/*
 * Decompiled with CFR 0.152.
 */
package org.basex.build.xml;

import java.lang.reflect.Constructor;
import javax.xml.transform.URIResolver;
import org.basex.util.Reflect;
import org.xml.sax.EntityResolver;

public final class CatalogWrapper {
    private static final Class<?> MANAGER;
    private static final Constructor<?> RESOLVER;
    private final Object cm = Reflect.get(MANAGER);

    private CatalogWrapper(String paths) {
        if (System.getProperty("xml.catalog.ignoreMissing") == null) {
            Reflect.invoke(Reflect.method(MANAGER, "setIgnoreMissingProperties", Boolean.TYPE), this.cm, true);
        }
        Reflect.invoke(Reflect.method(MANAGER, "setCatalogFiles", String.class), this.cm, paths);
    }

    public static CatalogWrapper get(String paths) {
        return CatalogWrapper.available() && !paths.isEmpty() ? new CatalogWrapper(paths) : null;
    }

    public static boolean available() {
        return MANAGER != null;
    }

    public URIResolver getURIResolver() {
        return (URIResolver)Reflect.get(RESOLVER, this.cm);
    }

    public EntityResolver getEntityResolver() {
        return (EntityResolver)Reflect.get(RESOLVER, this.cm);
    }

    static {
        Class<?> resolver;
        Class<?> manager = Reflect.find("org.apache.xml.resolver.CatalogManager");
        if (manager != null) {
            resolver = Reflect.find("org.apache.xml.resolver.tools.CatalogResolver");
        } else {
            manager = Reflect.find("com.sun.org.apache.xml.internal.resolver.CatalogManager");
            resolver = Reflect.find("com.sun.org.apache.xml.internal.resolver.tools.CatalogResolver");
        }
        MANAGER = manager;
        RESOLVER = Reflect.find(resolver, manager);
    }
}

