/*
 * Decompiled with CFR 0.152.
 */
package ModelInterface.ModelGUI2.tables;

import ModelInterface.InterfaceMain;
import ModelInterface.ModelGUI2.InputViewer;
import ModelInterface.ModelGUI2.tables.BaseTableModel;
import ModelInterface.ModelGUI2.tables.ComboTableModel;
import ModelInterface.ModelGUI2.tables.CopyPaste;
import ModelInterface.ModelGUI2.tables.MultiTableModel;
import ModelInterface.ModelGUI2.tables.NewDataTableModel;
import ModelInterface.ModelGUI2.tables.TableSorter;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.tree.TreePath;
import org.w3c.dom.Document;

public class TableSelector
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private String value;
    private JList list;
    private static String[] data = new String[]{"Single Table", "Multi Tables", "Combo Tables"};

    private void showDialog() {
        this.setVisible(true);
    }

    public TableSelector() {
        super(InterfaceMain.getInstance().getFrame(), "Table Types", true);
        JButton jButton = new JButton("Cancel");
        jButton.addActionListener(this);
        final JButton jButton2 = new JButton("Select");
        jButton2.setActionCommand("Select");
        jButton2.addActionListener(this);
        this.getRootPane().setDefaultButton(jButton2);
        this.list = new JList<String>(data);
        this.list.setSelectionMode(0);
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    jButton2.doClick();
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.list);
        jScrollPane.setPreferredSize(new Dimension(250, 80));
        jScrollPane.setMinimumSize(new Dimension(250, 80));
        jScrollPane.setAlignmentX(0.0f);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JLabel jLabel = new JLabel("Choose Table Viewing Type");
        jLabel.setLabelFor(this.list);
        jPanel.add(jLabel);
        jPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        jPanel.add(jScrollPane);
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        jPanel2.add(Box.createHorizontalGlue());
        jPanel2.add(jButton);
        jPanel2.add(Box.createRigidArea(new Dimension(10, 0)));
        jPanel2.add(jButton2);
        Container container = this.getContentPane();
        container.add((Component)jPanel, "Center");
        container.add((Component)jPanel2, "Last");
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.value = null;
        if ("Select".equals(actionEvent.getActionCommand())) {
            this.value = (String)this.list.getSelectedValue();
        }
        this.setVisible(false);
    }

    public JScrollPane createSelection(TreePath treePath, Document document, JFrame jFrame, InputViewer inputViewer) {
        this.showDialog();
        if (this.value == null) {
            return null;
        }
        if (this.value.equals("Single Table")) {
            NewDataTableModel newDataTableModel = new NewDataTableModel(treePath, document, "Single Table", inputViewer.getDocumentation());
            TableSorter tableSorter = new TableSorter(newDataTableModel);
            JTable jTable = new JTable(tableSorter);
            jTable.getModel().addTableModelListener(inputViewer);
            tableSorter.setTableHeader(jTable.getTableHeader());
            jTable.setAutoResizeMode(0);
            jTable.setCellSelectionEnabled(true);
            TableColumn tableColumn = jTable.getColumnModel().getColumn(0);
            tableColumn.setPreferredWidth(75);
            for (int i = 1; i < jTable.getColumnCount(); ++i) {
                tableColumn = jTable.getColumnModel().getColumn(i);
                tableColumn.setPreferredWidth(jTable.getColumnName(i).length() * 5 + 30);
                tableColumn.setCellRenderer(((BaseTableModel)newDataTableModel).getCellRenderer(0, i));
            }
            new CopyPaste(jTable);
            return new JScrollPane(jTable);
        }
        if (this.value.equals("Multi Tables")) {
            MultiTableModel multiTableModel = new MultiTableModel(treePath, document, "Multi Tables", inputViewer.getDocumentation());
            JTable jTable = new JTable(multiTableModel);
            jTable.getModel().addTableModelListener(inputViewer);
            jTable.getSelectionModel().setSelectionMode(0);
            jTable.setCellSelectionEnabled(true);
            jTable.getColumnModel().getColumn(0).setCellRenderer(((BaseTableModel)multiTableModel).getCellRenderer(0, 0));
            jTable.getColumnModel().getColumn(0).setCellEditor(multiTableModel.getCellEditor(0, 0));
            for (int i = 1; i < jTable.getRowCount(); i += 2) {
                jTable.setRowHeight(i, 200);
            }
            new CopyPaste(jTable);
            return new JScrollPane(jTable);
        }
        if (this.value.equals("Combo Tables")) {
            ComboTableModel comboTableModel = new ComboTableModel(treePath, document, "Combo Tables", inputViewer.getDocumentation());
            TableSorter tableSorter = new TableSorter(comboTableModel);
            JTable jTable = new JTable(tableSorter);
            jTable.getModel().addTableModelListener(inputViewer);
            tableSorter.setTableHeader(jTable.getTableHeader());
            jTable.setAutoResizeMode(0);
            jTable.setCellSelectionEnabled(true);
            for (int i = 0; i < jTable.getColumnCount(); ++i) {
                TableColumn tableColumn = jTable.getColumnModel().getColumn(i);
                if (jTable.getColumnName(i).equals("")) {
                    tableColumn.setPreferredWidth(75);
                } else {
                    tableColumn.setPreferredWidth(jTable.getColumnName(i).length() * 5 + 30);
                }
                tableColumn.setCellRenderer(((BaseTableModel)comboTableModel).getCellRenderer(0, i));
            }
            new CopyPaste(jTable);
            return new JScrollPane(jTable);
        }
        return null;
    }
}

