/*
 * Decompiled with CFR 0.152.
 */
package ModelInterface.ModelGUI2.tables;

import ModelInterface.InterfaceMain;
import ModelInterface.ModelGUI2.DOMmodel;
import ModelInterface.ModelGUI2.Documentation;
import ModelInterface.ModelGUI2.queries.QueryGenerator;
import ModelInterface.ModelGUI2.tables.BaseTableModel;
import ModelInterface.ModelGUI2.undo.FilterUndoableEdit;
import ModelInterface.ModelGUI2.undo.FlipUndoableEdit;
import ModelInterface.ModelGUI2.undo.TableUndoableEdit;
import ModelInterface.ModelGUI2.xmldb.DbProcInterrupt;
import ModelInterface.ModelGUI2.xmldb.QueryBinding;
import ModelInterface.ModelGUI2.xmldb.SingleQueryQueryBinding;
import ModelInterface.ModelGUI2.xmldb.XMLDB;
import ModelInterface.common.DataPair;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreePath;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.hssf.usermodel.HSSFPatriarch;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.basex.api.dom.BXNode;
import org.basex.query.QueryProcessor;
import org.basex.query.iter.Iter;
import org.basex.query.value.node.ANode;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.encoders.SunJPEGEncoderAdapter;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ComboTableModel
extends BaseTableModel {
    private static final long serialVersionUID = 1L;
    Vector TreeMapVector = new Vector();
    Vector leftSideVector = new Vector();
    Vector leftHeaderVector;
    Vector indCol;
    Vector indRow;
    String ind1Name;
    String ind2Name;
    boolean flipped;
    TableCellRenderer documentationRenderer;
    int chartLabelCol = -1;
    protected QueryGenerator qg;

    public ComboTableModel(TreePath treePath, Document document, String string, Documentation documentation) {
        super(treePath, document, string, documentation);
        this.leftHeaderVector = null;
        this.wild = this.chooseTableHeaders(treePath);
        this.wild.set(0, ((DOMmodel.DOMNodeAdapter)this.wild.get(0)).getNode().getNodeName());
        this.wild.set(1, ((DOMmodel.DOMNodeAdapter)this.wild.get(1)).getNode().getNodeName());
        this.buildTable(this.treePathtoXPath(treePath, document.getDocumentElement(), 0));
        this.activeRows = new Vector(this.leftSideVector.size() * this.indRow.size());
        for (int i = 0; i < this.leftSideVector.size() * this.indRow.size(); ++i) {
            this.activeRows.add(new Integer(i));
        }
        this.indCol.add(0, this.ind1Name);
        this.documentationRenderer = this.getDocumentationRenderer();
    }

    @Override
    public void flip(int n, int n2) {
        Vector vector = this.indCol;
        this.indCol = this.indRow;
        this.indRow = vector;
        this.indRow.remove(0);
        String string = this.ind1Name;
        this.ind1Name = this.ind2Name;
        this.ind2Name = string;
        this.indCol.add(0, this.ind1Name);
        this.flipped = !this.flipped;
        this.doFilter(new Vector(this.tableFilterMaps.keySet()));
        this.fireTableStructureChanged();
        InterfaceMain interfaceMain = InterfaceMain.getInstance();
        if (n >= 0 && n2 >= 0) {
            UndoManager undoManager = interfaceMain.getUndoManager();
            undoManager.addEdit(new FlipUndoableEdit(this));
        }
        interfaceMain.refreshUndoRedo();
    }

    @Override
    public TableCellRenderer getCellRenderer(int n, int n2) {
        if (n2 <= this.leftHeaderVector.size()) {
            return null;
        }
        return this.documentationRenderer;
    }

    @Override
    protected void buildTable(XPathExpression xPathExpression) {
        NodeList nodeList = null;
        try {
            nodeList = (NodeList)xPathExpression.evaluate(this.doc.getDocumentElement(), XPathConstants.NODESET);
        }
        catch (XPathExpressionException xPathExpressionException) {
            xPathExpressionException.printStackTrace();
        }
        xPathExpression = null;
        TreeSet<Object> treeSet = new TreeSet<Object>();
        TreeSet<Object> treeSet2 = new TreeSet<Object>();
        this.tableFilterMaps = new LinkedHashMap();
        TreeMap treeMap = new TreeMap();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            Object[] objectArray = this.getRegionAndYearFromNode(node.getParentNode(), this.tableFilterMaps);
            treeSet.add(objectArray[0]);
            treeSet2.add(objectArray[1]);
            this.addToDataTree(node, treeMap).put((String)objectArray[0] + ";" + (String)objectArray[1], node);
            if (this.units != null) continue;
            this.units = ((Element)node.getParentNode()).getAttribute("unit");
        }
        this.recAddTables(treeMap, null, treeSet, treeSet2, "");
        this.indCol = new Vector(treeSet);
        this.indRow = new Vector(treeSet2);
        this.ind1Name = (String)this.wild.get(0);
        this.ind2Name = (String)this.wild.get(1);
    }

    private Object[] getRegionAndYearFromNode(Node node, Map map) {
        Vector<String> vector = new Vector<String>(2, 0);
        do {
            String string;
            HashMap hashMap;
            if (node.getNodeName().equals((String)this.wild.get(0)) || node.getNodeName().equals((String)this.wild.get(1))) {
                if (!node.hasAttributes()) {
                    vector.add(node.getNodeName());
                    continue;
                }
                vector.add(this.getOneAttrVal(node));
                continue;
            }
            if (!node.hasAttributes() || (hashMap = map.containsKey(node.getNodeName()) ? (HashMap)map.get(node.getNodeName()) : new HashMap()).containsKey(string = this.getOneAttrVal(node))) continue;
            hashMap.put(string, new Boolean(true));
            map.put(node.getNodeName(), hashMap);
        } while ((node = node.getParentNode()).getNodeType() != 9);
        return vector.toArray();
    }

    private Map addToDataTree(Node node, Map map) {
        if (node.getNodeType() == 9) {
            return map;
        }
        Map map2 = this.addToDataTree(node.getParentNode(), map);
        if ((((String)this.wild.get(0)).matches(".*[Ss]ector") || ((String)this.wild.get(1)).matches(".*[Ss]ector")) && node.getNodeName().matches(".*[Ss]ector")) {
            return map2;
        }
        if (node.hasAttributes() && !node.getNodeName().equals((String)this.wild.get(0)) && !node.getNodeName().equals((String)this.wild.get(1))) {
            String string = this.getOneAttrVal(node);
            string = node.getNodeName() + "@" + string;
            if (!map2.containsKey(string)) {
                map2.put(string, new TreeMap());
            }
            return (Map)map2.get(string);
        }
        return map2;
    }

    private void recAddTables(Map map, Map.Entry entry, Set set, Set set2, String string) {
        for (Map.Entry entry2 : map.entrySet()) {
            if (entry2.getValue() instanceof Node || entry2.getValue() instanceof Double || entry2.getValue() instanceof String) {
                this.TreeMapVector.add((Map)entry.getValue());
                String string2 = string + '/';
                string2 = string2.substring(1, string2.length() - 1);
                StringTokenizer stringTokenizer = new StringTokenizer(string2, "~", false);
                int n = stringTokenizer.countTokens();
                Vector<String> vector = new Vector<String>(n);
                Vector<String> vector2 = new Vector<String>();
                while (stringTokenizer.hasMoreTokens()) {
                    String string3 = stringTokenizer.nextToken();
                    StringTokenizer stringTokenizer2 = new StringTokenizer(string3, "@", false);
                    if (stringTokenizer2.countTokens() != 2) {
                        System.out.println("BIG PROBLEM, COUNT TOKENS ISN'T 2!!!!!!!!!!: " + string3);
                        System.out.println("lineToParse: " + string2);
                        System.out.println("allNodeInfo: " + string3);
                        continue;
                    }
                    String string4 = stringTokenizer2.nextToken();
                    if (this.leftHeaderVector == null) {
                        vector2.add(string4);
                    }
                    String string5 = stringTokenizer2.nextToken();
                    vector.add(string5);
                }
                if (this.leftHeaderVector == null) {
                    this.leftHeaderVector = vector2;
                }
                if (!vector.isEmpty()) {
                    this.leftSideVector.add(vector);
                }
                return;
            }
            this.recAddTables((Map)entry2.getValue(), entry2, set, set2, string + "~" + (String)entry2.getKey());
        }
    }

    private String getKey(int n, int n2) {
        if (this.flipped) {
            return (String)this.indRow.get(n % this.indRow.size()) + ";" + (String)this.indCol.get(n2 - this.leftHeaderVector.size());
        }
        return (String)this.indCol.get(n2 - this.leftHeaderVector.size()) + ";" + (String)this.indRow.get(n % this.indRow.size());
    }

    @Override
    public int getColumnCount() {
        return this.leftHeaderVector.size() + this.indCol.size();
    }

    @Override
    public int getRowCount() {
        return this.activeRows.size();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        try {
            if (n2 < this.leftHeaderVector.size()) {
                return ((Vector)this.leftSideVector.get((Integer)this.activeRows.get(n) / this.indRow.size())).get(n2);
            }
            if (n2 == this.leftHeaderVector.size()) {
                return this.indRow.get((Integer)this.activeRows.get(n) % this.indRow.size());
            }
            Object v = ((Map)this.TreeMapVector.get((Integer)this.activeRows.get(n) / this.indRow.size())).get(this.getKey((Integer)this.activeRows.get(n), n2));
            if (v instanceof Node) {
                return new Double(((Node)v).getNodeValue());
            }
            if (v instanceof Double) {
                return (Double)v;
            }
            if (v == null && this.doc == null) {
                return new Double(0.0);
            }
            return v;
        }
        catch (NullPointerException nullPointerException) {
            return "";
        }
        catch (NumberFormatException numberFormatException) {
            Object v = ((Map)this.TreeMapVector.get((Integer)this.activeRows.get(n) / this.indRow.size())).get(this.getKey(n, n2));
            if (v instanceof Node) {
                return ((Node)v).getNodeValue();
            }
            numberFormatException.printStackTrace();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return "N/A";
        }
        return "";
    }

    protected boolean hasValueAt(int n, int n2) {
        return n2 > this.leftHeaderVector.size() && ((Map)this.TreeMapVector.get((Integer)this.activeRows.get(n) / this.indRow.size())).containsKey(this.getKey((Integer)this.activeRows.get(n), n2));
    }

    @Override
    protected Node getNodeAt(int n, int n2) {
        if (n2 <= this.leftHeaderVector.size()) {
            return null;
        }
        Object v = ((Map)this.TreeMapVector.get((Integer)this.activeRows.get(n) / this.indRow.size())).get(this.getKey(n, n2));
        if (v instanceof Node) {
            return (Node)v;
        }
        return null;
    }

    @Override
    public String getColumnName(int n) {
        if (n < this.leftHeaderVector.size()) {
            return (String)this.leftHeaderVector.get(n);
        }
        return (String)this.indCol.get(n - this.leftHeaderVector.size());
    }

    public Class getColumnClass(int n) {
        return n > this.leftHeaderVector.size() && n < this.getColumnCount() - 1 ? Double.class : String.class;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        if (this.doc == null) {
            return false;
        }
        return n2 > this.leftHeaderVector.size();
    }

    @Override
    protected void doFilter(Vector vector) {
        Object object;
        Vector vector2 = this.activeRows;
        this.activeRows = new Vector();
        for (int i = 0; i < this.leftSideVector.size() * this.indRow.size(); ++i) {
            this.activeRows.addElement(new Integer(i));
        }
        Integer n = new Integer(-1);
        for (int i = 0; i < vector.size(); ++i) {
            if (((String)vector.get(i)).equals("")) continue;
            this.currKeys = ((Map)this.tableFilterMaps.get((String)vector.get(i))).keySet().toArray(new String[0]);
            object = this.activeRows.iterator();
            block2: while (object.hasNext()) {
                n = (Integer)object.next();
                for (int j = 0; j < this.currKeys.length; ++j) {
                    if (((Boolean)((Map)this.tableFilterMaps.get((String)vector.get(i))).get(this.currKeys[j])).booleanValue() || !((String)((Vector)this.leftSideVector.get(n / this.indRow.size())).get(vector.size() - i - 1)).equals(this.currKeys[j])) continue;
                    object.remove();
                    continue block2;
                }
            }
        }
        InterfaceMain interfaceMain = InterfaceMain.getInstance();
        object = interfaceMain.getUndoManager();
        ((UndoManager)object).addEdit(new FilterUndoableEdit(this, vector2, this.activeRows));
        interfaceMain.refreshUndoRedo();
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        Serializable serializable;
        Object object2;
        Map map = (Map)this.TreeMapVector.get(n / this.indRow.size());
        CompoundEdit compoundEdit = new CompoundEdit();
        Object v = map.get(this.getKey(n, n2));
        Node node = null;
        if (v != null && v instanceof Double) {
            map.put(this.getKey(n, n2), object);
            return;
        }
        node = (Node)v;
        if (node != null) {
            object2 = node.getNodeValue();
            node.setNodeValue(object.toString());
            compoundEdit.addEdit(new TableUndoableEdit(this, n, n2, node, (String)object2, null, null));
        } else {
            Object object3;
            node = this.doc.createTextNode(object.toString());
            node.setUserData("isSetValue", compoundEdit, null);
            object2 = null;
            for (int i = this.leftHeaderVector.size() + 1; i < this.getColumnCount() && (object2 = (Node)map.get(this.getKey(n, i))) == null; ++i) {
            }
            if (object2 == null) {
                System.out.println("Couldn't gather enough info to create Node");
                InterfaceMain.getInstance().showMessageDialog("Couldn't gather enough information to \ncreate the data", "Set Value Error", 0);
                return;
            }
            serializable = new ArrayList();
            Node node2 = object2.getParentNode();
            String string = this.ind1Name;
            String string2 = this.ind2Name;
            String string3 = this.getKey(n, n2);
            String[] stringArray = string3.split(";", 2);
            if (this.flipped) {
                object3 = string;
                string = string2;
                string2 = object3;
            }
            object3 = new StringTokenizer(stringArray[1], "=", false);
            String string4 = ((StringTokenizer)object3).nextToken();
            String string5 = ((StringTokenizer)object3).nextToken();
            object3 = new StringTokenizer(stringArray[0], "=", false);
            String string6 = ((StringTokenizer)object3).nextToken();
            String string7 = ((StringTokenizer)object3).nextToken();
            while (!node2.getNodeName().equals(string)) {
                ((ArrayList)serializable).add(node2);
                node2 = node2.getParentNode();
            }
            node2 = node2.getParentNode();
            node2 = this.checkPath(node2, string, string4, string5, compoundEdit);
            for (int i = ((ArrayList)serializable).size() - 1; i >= 0; --i) {
                Node node3;
                Element element = (Element)((ArrayList)serializable).get(i);
                node2 = element.getNodeName().equals(string2) ? this.checkPath(node2, string2, string6, string7, compoundEdit) : ((node3 = element.getAttributes().item(0)) == null ? this.checkPath(node2, element.getNodeName(), null, null, compoundEdit) : this.checkPath(node2, element.getNodeName(), node3.getNodeName(), node3.getNodeValue(), compoundEdit));
            }
            node2.appendChild(node);
            map.put(this.getKey(n, n2), node);
            compoundEdit.addEdit(new TableUndoableEdit(this, n, n2, node, null, map, this.getKey(n, n2)));
        }
        compoundEdit.end();
        object2 = InterfaceMain.getInstance();
        serializable = ((InterfaceMain)object2).getUndoManager();
        ((UndoManager)serializable).addEdit(compoundEdit);
        ((InterfaceMain)object2).refreshUndoRedo();
        this.fireTableCellUpdated(n, n2);
    }

    private Node checkPath(Node node, String string, String string2, String string3, UndoableEdit undoableEdit) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element = (Element)nodeList.item(i);
            if (element.getNodeName().equals(string) && string2 == null) {
                return element;
            }
            if (!element.getNodeName().equals(string) || !element.getAttribute(string2).equals(string3)) continue;
            return element;
        }
        Element element = this.doc.createElement(string);
        element.setUserData("isSetValue", undoableEdit, null);
        if (string2 != null) {
            element.setAttribute(string2, string3);
        }
        node.appendChild(element);
        return element;
    }

    @Override
    public JFreeChart createChart(int n, int n2) {
        String string;
        XYSeries xYSeries;
        String string2;
        String string3;
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection();
        for (int i = 0; i < this.getRowCount(); ++i) {
            string3 = this.qg != null && this.qg.isGroup() ? (String)this.getValueAt(i, 0) + " " + (String)this.getValueAt(i, 1) : (this.chartLabelCol >= 0 ? (String)this.getValueAt(i, this.chartLabelCol) : (String)this.indRow.get((Integer)this.activeRows.get(i) % this.indRow.size()));
            string2 = string3;
            xYSeries = new XYSeries(string2);
            for (int j = this.leftHeaderVector.size() + 1; j < this.getColumnCount(); ++j) {
                string = this.getColumnName(j);
                if (string.equals("Units")) continue;
                double d = (Double)this.getValueAt(i, j);
                if (string.indexOf("=") != -1) {
                    string = string.split("=")[1];
                }
                double d2 = Double.parseDouble(string);
                if (d == 0.0 && !this.hasValueAt(i, j)) continue;
                xYSeries.add(d2, d);
            }
            xYSeriesCollection.addSeries(xYSeries);
        }
        NumberAxis numberAxis = this.qg != null ? new NumberAxis(this.qg.getAxis2Name()) : new NumberAxis("Year");
        string2 = this.units != null ? " (" + this.units + ")" : "";
        string3 = this.qg != null ? new NumberAxis(this.qg.getVariable() + string2) : new NumberAxis(this.ind1Name + string2);
        numberAxis.setAutoRangeIncludesZero(false);
        numberAxis.setAutoRange(true);
        string3.setAutoRange(true);
        xYSeries = new XYPlot((XYDataset)xYSeriesCollection, (ValueAxis)numberAxis, (ValueAxis)string3, (XYItemRenderer)new XYLineAndShapeRenderer());
        JFreeChart jFreeChart = new JFreeChart((Plot)xYSeries);
        string = new TextTitle(this.title);
        jFreeChart.setTitle((TextTitle)string);
        return jFreeChart;
    }

    public void setColNameIndex(String string) {
        if (string != null) {
            for (int i = 0; i < this.getColumnCount(); ++i) {
                if (!string.equals(this.getColumnName(i))) continue;
                this.chartLabelCol = i;
                return;
            }
        }
        this.chartLabelCol = -1;
    }

    public ComboTableModel(QueryGenerator queryGenerator, Object[] objectArray, Object[] objectArray2, QueryBinding queryBinding, DbProcInterrupt dbProcInterrupt) throws Exception {
        this.qg = queryGenerator;
        this.title = queryGenerator.toString();
        boolean bl = false;
        boolean bl2 = objectArray2.length == 1 && objectArray2[0].equals("Global");
        System.out.println("Before Function: " + System.currentTimeMillis());
        if (queryBinding == null) {
            this.buildTable(XMLDB.getInstance().createQuery(queryGenerator, objectArray, objectArray2, dbProcInterrupt), queryGenerator.isSumAll(), bl, bl2);
        } else {
            bl = !(queryBinding instanceof SingleQueryQueryBinding);
            this.buildTable(XMLDB.getInstance().createQuery(queryBinding, objectArray, objectArray2, dbProcInterrupt), queryGenerator.isSumAll(), bl, bl2);
        }
        this.ind2Name = queryGenerator.getVariable();
        this.indCol.add(0, this.ind1Name);
        this.activeRows = new Vector(this.leftSideVector.size() * this.indRow.size());
        Collection<String> collection = queryBinding == null && this.qg.shouldAppendRewriteValues() ? this.qg.getNodeLevelRewriteMap().values() : null;
        for (int i = 0; i < this.leftSideVector.size() * this.indRow.size(); ++i) {
            boolean bl3 = true;
            for (int j = this.leftHeaderVector.size() + 1; j < this.getColumnCount() && bl3; ++j) {
                if (((Map)this.TreeMapVector.get(i / this.indRow.size())).get(this.getKey(i, j)) == null) continue;
                bl3 = false;
            }
            if (bl3 && (collection == null || !collection.contains(this.indRow.get(i % this.indRow.size())))) continue;
            this.activeRows.add(new Integer(i));
        }
        this.setColNameIndex(this.qg.getChartLabelColumnName());
    }

    private void buildTable(QueryProcessor queryProcessor, boolean bl, boolean bl2, boolean bl3) throws Exception {
        System.out.println("In Function: " + System.currentTimeMillis());
        Iter iter = queryProcessor.iter();
        TreeSet<String> treeSet = new TreeSet<String>();
        TreeSet<String> treeSet2 = new TreeSet<String>();
        treeSet.addAll(this.getDefaultYearList());
        TreeMap treeMap = new TreeMap();
        Map<String, String> map = this.qg.getNodeLevelRewriteMap();
        DataPair<String, String> dataPair = new DataPair<String, String>();
        try {
            ANode aNode;
            while ((aNode = (ANode)iter.next()) != null) {
                BXNode bXNode = BXNode.get((ANode)aNode);
                dataPair.setKey(null);
                dataPair.setValue(null);
                Map object = this.qg.addToDataTree(aNode.parent(), treeMap, dataPair, bl3);
                if (dataPair.getKey() == null || dataPair.getValue() == null) {
                    System.out.println("Key: " + dataPair.getKey());
                    System.out.println("Value: " + dataPair.getValue());
                    throw new Exception("<html><body>Could not determine how to categorize the results.<br> Please check your axis node values.</body></html>");
                }
                if (bl2) {
                    dataPair.setValue("Total");
                }
                if (bl) {
                    dataPair.setValue("All " + this.qg.getNodeLevel());
                }
                if (map != null && map.containsKey(dataPair.getValue())) {
                    dataPair.setValue(map.get(dataPair.getValue()));
                    if (dataPair.getValue().equals("")) continue;
                }
                if ((this.units = (String)object.get("Units;" + dataPair.getValue())) == null) {
                    this.units = XMLDB.getAttrMap((Node)BXNode.get((ANode)aNode.parent())).get("unit");
                    if (this.units == null) {
                        this.units = "None Specified";
                    }
                }
                treeSet.add(dataPair.getKey());
                treeSet2.add(dataPair.getValue());
                double d = Double.parseDouble(bXNode.getNodeValue());
                String string = dataPair.getKey() + ";" + dataPair.getValue();
                Double d2 = (Double)object.get(string);
                object.put(string, d2 == null ? d : d2 + d);
                object.put("Units;" + dataPair.getValue(), this.units);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
        finally {
            queryProcessor.close();
        }
        if (treeMap.isEmpty()) {
            throw new Exception("The query returned no results.");
        }
        if (this.remove1975) {
            treeSet.remove("1975");
        }
        treeSet.add("Units");
        if (this.qg.shouldAppendRewriteValues()) {
            for (String string : map.values()) {
                if (string.equals("")) continue;
                treeSet2.add(string);
            }
        }
        System.out.println("After build Tree: " + System.currentTimeMillis());
        this.recAddTables(treeMap, null, treeSet, treeSet2, "");
        System.out.println("After Add table: " + System.currentTimeMillis());
        this.indRow = new Vector(treeSet2);
        this.indCol = new Vector(treeSet);
        this.ind1Name = this.qg.getAxis1Name();
    }

    @Override
    public void exportToExcel(HSSFSheet hSSFSheet, HSSFWorkbook hSSFWorkbook, HSSFPatriarch hSSFPatriarch) {
        int n;
        HSSFRow hSSFRow = hSSFSheet.createRow(hSSFSheet.getLastRowNum() + 1);
        hSSFRow.createCell((short)0).setCellValue("title");
        int n2 = 0;
        for (n = 0; n < this.getColumnCount(); ++n) {
            String string = this.getColumnName(n);
            if (n == 1 && !string.equals("region")) {
                n2 = 1;
                hSSFRow.createCell((short)(n + 1)).setCellValue("region");
            }
            hSSFRow.createCell((short)(n + 1 + n2)).setCellValue(string);
        }
        for (n = 0; n < this.getRowCount(); ++n) {
            hSSFRow = hSSFSheet.createRow(hSSFSheet.getLastRowNum() + 1);
            hSSFRow.createCell((short)0).setCellValue(this.title);
            if (n2 == 1) {
                hSSFRow.createCell((short)1).setCellValue(this.getValueAt(n, 0).toString());
                hSSFRow.createCell((short)2).setCellValue("Global");
            }
            for (int i = n2; i < this.getColumnCount(); ++i) {
                Object object = this.sortedTable.getValueAt(n, i);
                if (object instanceof Double) {
                    hSSFRow.createCell((short)(i + 1 + n2)).setCellValue(((Double)object).doubleValue());
                    continue;
                }
                hSSFRow.createCell((short)(i + 1 + n2)).setCellValue(this.getValueAt(n, i).toString());
            }
        }
        if (hSSFPatriarch == null) {
            return;
        }
        try {
            double d = this.getRowCount() / 6 * 10;
            double d2 = 1.4;
            int n3 = (int)(350.0 * d2);
            int n4 = (int)(d2 * (350.0 + d));
            BufferedImage bufferedImage = this.createChart(0, 0).createBufferedImage(n3, n4);
            int n5 = 8;
            short s = (short)(hSSFSheet.getLastRowNum() - this.getRowCount());
            short s2 = (short)(hSSFSheet.getRow((int)s).getLastCellNum() + 2);
            short s3 = (short)(n3 / (n5 * hSSFSheet.getColumnWidth((short)(this.getColumnCount() + 1))) + s2);
            short s4 = (short)((float)n4 / (hSSFSheet.getDefaultRowHeightInPoints() * 5.0f / 3.0f) + (float)s);
            int n6 = hSSFWorkbook.addPicture(new SunJPEGEncoderAdapter().encode(bufferedImage), 5);
            hSSFPatriarch.createPicture(new HSSFClientAnchor(0, 0, 255, 255, s2, (int)s, s3, (int)s4), n6);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    @Override
    public void annotate(int[] nArray, int[] nArray2, Documentation documentation) {
        Vector<Node> vector = new Vector<Node>(nArray.length * nArray2.length, 0);
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray2.length; ++j) {
                vector.add(this.getNodeAt(nArray[i], nArray2[j]));
            }
        }
        documentation.getDocumentation(vector, nArray, nArray2);
    }
}

