/*
 * Decompiled with CFR 0.152.
 */
package ModelInterface.ModelGUI2.tables;

import ModelInterface.InterfaceMain;
import ModelInterface.ModelGUI2.DOMmodel;
import ModelInterface.ModelGUI2.Documentation;
import ModelInterface.ModelGUI2.tables.NewDataTableModel;
import ModelInterface.ModelGUI2.tables.TableSorter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreePath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.poi.hssf.usermodel.HSSFPatriarch;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.LegendItem;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class BaseTableModel
extends AbstractTableModel {
    protected Vector activeRows;
    protected Document doc;
    protected ArrayList wild;
    protected Map tableFilterMaps;
    protected String title;
    protected Documentation documentation;
    protected String units;
    protected boolean remove1975;
    protected TableSorter sortedTable;
    private List<String> defaultYearList;
    protected int currFilter;
    protected String[] currKeys;
    protected String tableTypeString;

    public BaseTableModel() {
        if (InterfaceMain.getInstance() != null) {
            Properties properties = InterfaceMain.getInstance().getProperties();
            String string = properties.getProperty("remove1975", "true");
            properties.setProperty("remove1975", string);
            this.remove1975 = Boolean.parseBoolean(string);
        } else {
            this.remove1975 = false;
        }
        this.sortedTable = new TableSorter(this);
    }

    public BaseTableModel(TreePath treePath, Document document, String string, Documentation documentation) {
        this.doc = document;
        this.tableTypeString = string;
        this.documentation = documentation;
        this.title = ((DOMmodel.DOMNodeAdapter)treePath.getLastPathComponent()).getNode().getNodeName();
        final BaseTableModel baseTableModel = this;
        final JFrame jFrame = InterfaceMain.getInstance().getFrame();
        if (jFrame != null) {
            jFrame.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (propertyChangeEvent.getPropertyName().equals("Control") || propertyChangeEvent.getPropertyName().equals("Table") && !baseTableModel.equals(propertyChangeEvent.getNewValue())) {
                        System.out.println("New Table: " + propertyChangeEvent.getNewValue());
                        System.out.println("This Table: " + baseTableModel);
                        System.out.println("Stoped listening for filter");
                        jFrame.removePropertyChangeListener(this);
                    } else if (propertyChangeEvent.getPropertyName().equals("Filter")) {
                        try {
                            if (baseTableModel instanceof NewDataTableModel) {
                                InterfaceMain.getInstance().showMessageDialog("This table does not support filtering", "Table Filter Error", 0);
                            } else {
                                baseTableModel.filterData();
                            }
                        }
                        catch (UnsupportedOperationException unsupportedOperationException) {
                            InterfaceMain.getInstance().showMessageDialog("This table does not support filtering", "Table Filter Error", 0);
                        }
                    }
                }
            });
        }
    }

    public abstract TableCellRenderer getCellRenderer(int var1, int var2);

    public abstract JFreeChart createChart(int var1, int var2);

    public abstract void flip(int var1, int var2);

    public abstract void annotate(int[] var1, int[] var2, Documentation var3);

    protected abstract void buildTable(XPathExpression var1);

    protected XPathExpression treePathtoXPath(TreePath treePath, Node node, int n) {
        StringBuffer stringBuffer = new StringBuffer("/");
        Object[] objectArray = treePath.getPath();
        node = ((DOMmodel.DOMNodeAdapter)objectArray[objectArray.length - 1]).getNode();
        for (int i = 0; i < objectArray.length - 1; ++i) {
            Node node2 = ((DOMmodel.DOMNodeAdapter)objectArray[i]).getNode();
            if (n == 0) {
                stringBuffer.append(node2.getNodeName()).append("/");
                continue;
            }
            if (n != 1) continue;
            stringBuffer.append(node2.getNodeName());
            Vector vector = this.getAttrsNoWild(node2);
            if (vector.size() > 0) {
                stringBuffer.append("[");
            }
            for (int j = 0; j < vector.size(); ++j) {
                stringBuffer.append("(@").append(((Node)vector.get(j)).getNodeName()).append("='").append(((Node)vector.get(j)).getNodeValue()).append("')");
                if (j < vector.size() - 1) {
                    stringBuffer.append(" and ");
                    continue;
                }
                stringBuffer.append("]");
            }
            stringBuffer.append("/");
        }
        stringBuffer.append(node.getNodeName());
        if (n == 1 && node.hasAttributes() && !this.getTextData(node).equals("")) {
            if (n == 0) {
                stringBuffer.append("[@").append(this.getOneAttrVal(node)).append("]");
            } else if (n == 1) {
                Vector vector = this.getAttrsNoWild(node);
                for (int i = 0; i < vector.size(); ++i) {
                    stringBuffer.append("[@").append(((Node)vector.get(i)).getNodeName()).append("='").append(((Node)vector.get(i)).getNodeValue()).append("']");
                }
                stringBuffer.append("/text()");
            }
        } else if (n == 1 && node.hasAttributes()) {
            if (n == 0) {
                stringBuffer.append("[@").append(this.getOneAttrVal(node)).append("]/text()");
            } else if (n == 1) {
                Vector vector = this.getAttrsNoWild(node);
                for (int i = 0; i < vector.size(); ++i) {
                    stringBuffer.append("@").append(((Node)vector.get(i)).getNodeName()).append("='").append(((Node)vector.get(i)).getNodeValue()).append("'");
                }
                stringBuffer.append("/text()");
            }
        } else {
            stringBuffer.append("/text()");
        }
        System.out.println(stringBuffer.toString());
        try {
            return XPathFactory.newInstance().newXPath().compile(stringBuffer.toString());
        }
        catch (XPathExpressionException xPathExpressionException) {
            xPathExpressionException.printStackTrace();
            return null;
        }
    }

    public String getOneAttrVal(Node node) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap.item(0).getNodeName().equals("fillout")) {
            return this.getOneAttrVal(node, 1);
        }
        return namedNodeMap.item(0).getNodeName() + "=" + namedNodeMap.item(0).getNodeValue();
    }

    public String getOneAttrVal(Node node, int n) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        return namedNodeMap.item(n).getNodeValue();
    }

    public Vector getAttrsNoWild(Node node) {
        if ((((String)this.wild.get(0)).matches(".*[Ss]ector") || ((String)this.wild.get(1)).matches(".*[Ss]ector")) && node.getNodeName().equals("subsector")) {
            return new Vector();
        }
        if (node.getNodeName().equals((String)this.wild.get(0)) || node.getNodeName().equals((String)this.wild.get(1))) {
            return new Vector();
        }
        NamedNodeMap namedNodeMap = node.getAttributes();
        Vector<Node> vector = new Vector<Node>();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node node2 = namedNodeMap.item(i);
            if (node2.getNodeName().indexOf(58) != -1) continue;
            vector.add(node2);
        }
        return vector;
    }

    public String getTextData(Node node) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getNodeType() != 3) continue;
            return nodeList.item(i).getNodeValue();
        }
        return "";
    }

    protected ArrayList chooseTableHeaders(TreePath treePath) {
        Object object;
        Object object2;
        final ArrayList arrayList = new ArrayList(2);
        final Object[] objectArray = treePath.getPath();
        String[] stringArray = new String[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            object2 = ((DOMmodel.DOMNodeAdapter)objectArray[i]).getNode();
            if (object2.hasAttributes()) {
                object = object2.getAttributes();
                stringArray[i] = object2.getNodeName() + " (" + object.item(0).getNodeName() + " = " + object.item(0).getNodeValue() + ")";
                continue;
            }
            stringArray[i] = object2.getNodeName();
        }
        final JList<String> jList = new JList<String>(stringArray);
        jList.setSelectionMode(2);
        object2 = new JScrollPane(jList);
        object = InterfaceMain.getInstance().getFrame();
        final JDialog jDialog = new JDialog((Frame)object, this.tableTypeString + " for '" + ((DOMmodel.DOMNodeAdapter)objectArray[objectArray.length - 1]).getNode().getNodeName() + "'. Please choose two headers:", true);
        jDialog.setSize(500, 400);
        jDialog.setLocation(100, 100);
        jDialog.setResizable(false);
        JButton jButton = new JButton(" Finished With Selection ");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = jList.getSelectedIndices();
                if (nArray.length == 2) {
                    arrayList.add(objectArray[nArray[0]]);
                    arrayList.add(objectArray[nArray[1]]);
                    jDialog.dispose();
                } else {
                    InterfaceMain.getInstance().showMessageDialog("Error: You must choose exactly two (2)!", null, 0);
                }
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 2));
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(jButton);
        jPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        JLabel jLabel = new JLabel();
        jLabel.setHorizontalAlignment(2);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel2.add(Box.createVerticalGlue());
        jPanel2.add(jLabel);
        jPanel2.add(Box.createVerticalStrut(10));
        JScrollPane jScrollPane = new JScrollPane(jList);
        jScrollPane.setPreferredSize(new Dimension(150, 750));
        jPanel2.add(jScrollPane);
        jPanel2.add(Box.createVerticalStrut(10));
        jPanel2.add(new JSeparator(0));
        Container container = jDialog.getContentPane();
        container.add((Component)jPanel2, "Center");
        container.add((Component)jPanel, "Last");
        jDialog.setContentPane(container);
        jDialog.setVisible(true);
        return arrayList;
    }

    public void filterData() {
        if (this.activeRows == null) {
            this.activeRows = new Vector();
        }
        final int n = this.activeRows.size();
        this.currKeys = new String[0];
        final Map map = (Map)((LinkedHashMap)this.tableFilterMaps).clone();
        final Vector vector = new Vector(map.keySet());
        this.currFilter = vector.size() - 1;
        String string = "Filter Table";
        if (vector.isEmpty()) {
            return;
        }
        JFrame jFrame = InterfaceMain.getInstance().getFrame();
        final JDialog jDialog = new JDialog(jFrame, string, true);
        jDialog.setSize(500, 400);
        jDialog.setLocation(100, 100);
        jDialog.setResizable(false);
        final JList jList = new JList();
        final JLabel jLabel = new JLabel();
        jLabel.setHorizontalAlignment(2);
        this.updateList(jList, jLabel, (String)vector.get(this.currFilter), map);
        final JButton jButton = new JButton(" Cancel ");
        final JButton jButton2 = new JButton(" < Back ");
        final JButton jButton3 = new JButton(" Next > ");
        jButton2.setMnemonic(66);
        jButton3.setMnemonic(78);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!jButton.getText().equals(" Cancel ")) {
                    BaseTableModel.this.updateFilters(map, jList, (String)vector.get(BaseTableModel.this.currFilter));
                    BaseTableModel.this.tableFilterMaps = map;
                    BaseTableModel.this.doFilter(vector);
                    if (n < BaseTableModel.this.activeRows.size()) {
                        BaseTableModel.this.fireTableRowsInserted(n, BaseTableModel.this.activeRows.size());
                    } else if (n > BaseTableModel.this.activeRows.size()) {
                        BaseTableModel.this.fireTableRowsDeleted(0, BaseTableModel.this.activeRows.size());
                    } else {
                        BaseTableModel.this.fireTableRowsUpdated(0, BaseTableModel.this.activeRows.size());
                    }
                }
                jDialog.dispose();
            }
        });
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BaseTableModel.this.updateFilters(map, jList, (String)vector.get(BaseTableModel.this.currFilter));
                ++BaseTableModel.this.currFilter;
                BaseTableModel.this.updateList(jList, jLabel, (String)vector.get(BaseTableModel.this.currFilter), map);
                if (!jButton3.isEnabled()) {
                    jButton3.setEnabled(true);
                    jButton.setText(" Cancel ");
                }
                if (BaseTableModel.this.currFilter == vector.size() - 1) {
                    jButton2.setEnabled(false);
                }
            }
        });
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BaseTableModel.this.updateFilters(map, jList, (String)vector.get(BaseTableModel.this.currFilter));
                --BaseTableModel.this.currFilter;
                BaseTableModel.this.updateList(jList, jLabel, (String)vector.get(BaseTableModel.this.currFilter), map);
                if (!jButton2.isEnabled()) {
                    jButton2.setEnabled(true);
                }
                if (BaseTableModel.this.currFilter == 0) {
                    jButton3.setEnabled(false);
                    jButton.setText("Finished");
                }
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 2));
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(jButton2);
        jButton2.setEnabled(false);
        if (vector.size() == 1) {
            jButton3.setEnabled(false);
            jButton.setText("Finished");
        }
        jPanel.add(jButton3);
        jPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        jPanel.add(jButton);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel2.add(Box.createVerticalGlue());
        jPanel2.add(jLabel);
        jPanel2.add(Box.createVerticalStrut(10));
        JScrollPane jScrollPane = new JScrollPane(jList);
        jScrollPane.setPreferredSize(new Dimension(150, 750));
        jPanel2.add(jScrollPane);
        jPanel2.add(Box.createVerticalStrut(10));
        jPanel2.add(new JSeparator(0));
        Container container = jDialog.getContentPane();
        container.add((Component)jPanel2, "Center");
        container.add((Component)jPanel, "Last");
        jDialog.setContentPane(container);
        jDialog.setVisible(true);
    }

    protected void updateFilters(Map map, JList jList, String string) {
        int[] nArray = jList.getSelectedIndices();
        int n = 0;
        for (int i = 0; i < this.currKeys.length; ++i) {
            if (((Boolean)((Map)map.get(string)).get(this.currKeys[i])).booleanValue() && (n >= nArray.length || i != nArray[n])) {
                ((Map)map.get(string)).put(this.currKeys[i], new Boolean(false));
            } else if (!((Boolean)((Map)map.get(string)).get(this.currKeys[i])).booleanValue() && n < nArray.length && i == nArray[n]) {
                ((Map)map.get(string)).put(this.currKeys[i], new Boolean(true));
            }
            if (n >= nArray.length || i != nArray[n]) continue;
            ++n;
        }
    }

    protected void updateList(JList jList, JLabel jLabel, String string, Map map) {
        Map map2 = (Map)map.get(string);
        Vector<Integer> vector = new Vector<Integer>();
        jLabel.setText("Filter " + string);
        this.currKeys = map2.keySet().toArray(new String[0]);
        jList.setListData(this.currKeys);
        for (int i = 0; i < this.currKeys.length; ++i) {
            if (!((Boolean)map2.get(this.currKeys[i])).booleanValue()) continue;
            vector.addElement(new Integer(i));
        }
        int[] nArray = new int[vector.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = (Integer)vector.get(i);
        }
        map2 = null;
        vector = null;
        jList.setSelectedIndices(nArray);
    }

    protected abstract void doFilter(Vector var1);

    public abstract void exportToExcel(HSSFSheet var1, HSSFWorkbook var2, HSSFPatriarch var3);

    protected TableCellRenderer getDocumentationRenderer() {
        final DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer();
        return new TableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                Component component = defaultTableCellRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                if (BaseTableModel.this.documentation != null && BaseTableModel.this.documentation.hasDocumentation(BaseTableModel.this.getNodeAt(n, n2))) {
                    component.setBackground(bl ? Color.BLUE : Color.CYAN);
                } else {
                    component.setBackground(bl ? Color.BLUE : Color.WHITE);
                }
                return component;
            }
        };
    }

    protected abstract Node getNodeAt(int var1, int var2);

    public Dimension getChartDimensions(JFreeChart jFreeChart) {
        int n = 0;
        Iterator iterator = jFreeChart.getPlot().getLegendItems().iterator();
        while (iterator.hasNext()) {
            n += ((LegendItem)iterator.next()).getLabel().length();
        }
        if (n <= 500) {
            return new Dimension(350, 350);
        }
        return new Dimension(350, 350 + (n - 500) / 2);
    }

    public void setActiveRows(Vector vector) {
        this.activeRows = vector;
        this.fireTableStructureChanged();
    }

    public String exportToText(char c) {
        int n;
        String string = System.getProperty("line.separator");
        boolean bl = true;
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = this.title;
        if (string2.indexOf(c) != -1) {
            string2 = '\"' + string2 + '\"';
        }
        stringBuilder.append(string2).append(string);
        for (n = 0; n < this.getColumnCount() && bl; ++n) {
            string2 = this.getColumnName(n);
            if (!string2.equals("region")) continue;
            bl = false;
        }
        for (n = 0; n < this.getColumnCount(); ++n) {
            string2 = this.getColumnName(n);
            if (bl && n == 1) {
                stringBuilder.append("region").append(c);
            }
            if (string2.indexOf(c) != -1) {
                string2 = '\"' + string2 + '\"';
            }
            stringBuilder.append(string2).append(c);
        }
        stringBuilder.append(string);
        for (n = 0; n < this.getRowCount(); ++n) {
            for (int i = 0; i < this.getColumnCount(); ++i) {
                if (bl && i == 1) {
                    stringBuilder.append("Global").append(c);
                }
                if ((string2 = this.sortedTable.getValueAt(n, i).toString()).indexOf(c) != -1) {
                    string2 = '\"' + string2 + '\"';
                }
                stringBuilder.append(string2).append(c);
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public JTable getAsSortedTable() {
        JTable jTable = new JTable(this.sortedTable);
        this.sortedTable.setTableHeader(jTable.getTableHeader());
        return jTable;
    }

    public List<String> getDefaultYearList() {
        if (this.defaultYearList == null) {
            if (InterfaceMain.getInstance() != null) {
                Properties properties = InterfaceMain.getInstance().getProperties();
                String string = properties.getProperty("defaultYearList", "1990;2005;2020;2035;2050;2065;2080;2095");
                properties.setProperty("defaultYearList", string);
                String[] stringArray = string.split(";");
                this.defaultYearList = new ArrayList<String>(stringArray.length);
                if (stringArray.length != 1 || !stringArray[0].equals("")) {
                    for (String string2 : stringArray) {
                        this.defaultYearList.add(string2);
                    }
                }
            } else {
                this.defaultYearList = new ArrayList<String>();
                this.defaultYearList.add("1990");
                this.defaultYearList.add("2005");
                this.defaultYearList.add("2020");
                this.defaultYearList.add("2035");
                this.defaultYearList.add("2050");
                this.defaultYearList.add("2065");
                this.defaultYearList.add("2080");
                this.defaultYearList.add("2095");
            }
        }
        return this.defaultYearList;
    }
}

