/*
 * Decompiled with CFR 0.152.
 */
package ModelInterface.ModelGUI2;

import ModelInterface.InterfaceMain;
import ModelInterface.ModelGUI2.InputViewer;
import ModelInterface.ModelGUI2.XMLFilter;
import ModelInterface.common.FileChooser;
import ModelInterface.common.FileChooserFactory;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSParser;

public class Documentation {
    private Vector<DocumentationElement> documentations;
    private Document doc;
    private Comparator<Node> nodeComparator;
    private XPath xpathImpl;
    private URI documentationURI;
    private LSParser lsParser;
    private LSInput lsInput;

    private void init(LSParser lSParser, LSInput lSInput) {
        this.lsParser = lSParser;
        this.lsInput = lSInput;
        this.documentations = new Vector();
        this.xpathImpl = XPathFactory.newInstance().newXPath();
        this.nodeComparator = new Comparator<Node>(){

            @Override
            public int compare(Node node, Node node2) {
                String string;
                if (node.equals(node2)) {
                    return 0;
                }
                String string2 = node.getNodeValue();
                int n = String.CASE_INSENSITIVE_ORDER.compare(string2, string = node2.getNodeValue());
                if (n == 0) {
                    return 1;
                }
                return n;
            }
        };
        final JFrame jFrame = InterfaceMain.getInstance().getFrame();
        jFrame.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("Control") && (propertyChangeEvent.getOldValue().equals(InputViewer.controlStr) || propertyChangeEvent.getOldValue().equals(InputViewer.controlStr + "Same"))) {
                    System.out.println("The open xml file must be closing");
                    System.out.println("Going to write out documentation and stop listening");
                    if (Documentation.this.documentationURI == null) {
                        return;
                    }
                    try {
                        PrintStream printStream = new PrintStream(new File(Documentation.this.documentationURI));
                        Documentation.this.toXML(printStream);
                        printStream.close();
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        fileNotFoundException.printStackTrace();
                    }
                    jFrame.removePropertyChangeListener(this);
                }
            }
        });
    }

    private void openDocumentation() {
        if (this.documentationURI != null) {
            Document document = null;
            try {
                this.lsInput.setByteStream(new FileInputStream(new File(this.documentationURI)));
                document = this.lsParser.parse(this.lsInput);
            }
            catch (Exception exception) {
                System.out.println("Got Exception while creating XML document: " + exception);
                return;
            }
            NodeList nodeList = document.getDocumentElement().getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                this.documentations.add(new DocumentationElement(nodeList.item(i)));
            }
            this.lsParser = null;
            this.lsInput = null;
        }
    }

    public Documentation(Document document, LSParser lSParser, LSInput lSInput) {
        this.doc = document;
        this.documentationURI = null;
        this.init(lSParser, lSInput);
    }

    public Documentation(Document document, URI uRI, LSParser lSParser, LSInput lSInput) {
        this.documentationURI = uRI;
        this.doc = document;
        this.init(lSParser, lSInput);
        this.openDocumentation();
    }

    private void toXML(PrintStream printStream) {
        printStream.println("<documentation>");
        for (int i = 0; i < this.documentations.size(); ++i) {
            this.documentations.get(i).toXML(printStream);
        }
        printStream.println("</documentation>");
    }

    public boolean hasDocumentation(Node node) {
        int n;
        if (this.documentationURI == null) {
            return false;
        }
        if (node.getNextSibling() != null && node.getNextSibling().getNodeType() == 8) {
            n = Integer.parseInt(node.getNextSibling().getNodeValue());
        } else {
            n = this.contains(node);
            node.getParentNode().appendChild(this.doc.createComment(String.valueOf(n)));
        }
        return n != -1;
    }

    public void getDocumentation(Vector<Node> vector) {
        this.getDocumentation(vector, null, null);
    }

    public void getDocumentation(Vector<Node> vector, int[] nArray, int[] nArray2) {
        JPanel jPanel;
        Serializable serializable;
        Object object;
        Serializable serializable2;
        Object object2;
        InterfaceMain interfaceMain = InterfaceMain.getInstance();
        JFrame jFrame = interfaceMain.getFrame();
        if (this.documentationURI == null) {
            interfaceMain.showMessageDialog("Please select a documentation file, or type in the name of a\nnew documentation file to create a new one.\nYou must save the XML to save the link to the documentation file.", "Add new Documentation File", 1);
            FileChooser fileChooser = FileChooserFactory.getFileChooser();
            File[] fileArray = fileChooser.doFilePrompt(jFrame, "Select Documentation File", 1, new File(interfaceMain.getProperties().getProperty("lastDirectory", ".")), new XMLFilter());
            if (fileArray == null) {
                return;
            }
            URI uRI = this.documentationURI = fileArray[0].toURI();
            object2 = this.doc.getDocumentURI();
            if (object2 != null) {
                try {
                    object2 = ((String)object2).substring(0, ((String)object2).lastIndexOf("/"));
                    serializable2 = new URI((String)object2);
                    uRI = ((URI)serializable2).relativize(this.documentationURI);
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
            this.doc.getDocumentElement().setAttribute("documentation", uRI.toString());
            interfaceMain.fireProperty("Document-Modified", null, this.doc);
            if (fileArray[0].exists()) {
                System.out.println("Opening existing doc");
                this.openDocumentation();
            }
            fileChooser = null;
        }
        int n = 0;
        int n2 = 0;
        object2 = new HashMap<Integer, LinkedList<String>>();
        serializable2 = new Vector<String>();
        Object object3 = vector.iterator();
        while (object3.hasNext()) {
            int n3;
            if (nArray2 != null && n2 == nArray2.length) {
                n2 = 0;
                ++n;
            }
            if ((object = object3.next()).getNextSibling() != null && object.getNextSibling().getNodeType() == 8) {
                n3 = Integer.parseInt(object.getNextSibling().getNodeValue());
            } else {
                n3 = this.contains((Node)object);
                object.getParentNode().appendChild(this.doc.createComment(String.valueOf(n3)));
            }
            if (n3 != -1) {
                if (object2.containsKey(n3)) {
                    if (nArray == null || nArray2 == null) {
                        ((LinkedList)object2.get(n3)).addFirst(object.getNodeValue());
                    } else {
                        ((LinkedList)object2.get(n3)).addFirst("(" + nArray[n] + ", " + nArray2[n2] + ")");
                    }
                } else {
                    serializable = new LinkedList();
                    if (nArray == null || nArray2 == null) {
                        ((LinkedList)serializable).addFirst(object.getNodeValue());
                    } else {
                        ((LinkedList)serializable).addFirst("(" + nArray[n] + ", " + nArray2[n2] + ")");
                    }
                    object2.put(n3, serializable);
                }
                object3.remove();
            } else if (nArray == null || nArray2 == null) {
                ((Vector)serializable2).add((String)object.getNodeValue());
            } else {
                ((Vector)serializable2).add((String)("(" + nArray[n] + ", " + nArray2[n2] + ")"));
            }
            ++n2;
        }
        if (vector.size() != 0) {
            this.addToDocumentation(vector, (Vector<String>)serializable2, (Map<Integer, LinkedList<String>>)object2);
        }
        if (object2.size() == 0) {
            return;
        }
        object3 = new JDialog(jFrame, "Annotation", false);
        ((Window)object3).setLocation(100, 100);
        ((Dialog)object3).setResizable(false);
        object = new JButton("Cancel");
        serializable = new JButton("  OK  ");
        JPanel jPanel2 = new JPanel();
        Component component = Box.createRigidArea(new Dimension(20, 10));
        JTabbedPane jTabbedPane = new JTabbedPane();
        Set set = object2.keySet();
        Vector vector2 = new Vector(set.size(), 0);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            jPanel2 = new JPanel();
            jPanel2.setLayout(new BoxLayout(jPanel2, 1));
            jPanel2.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            int n4 = (Integer)iterator.next();
            Vector<JTextField> vector3 = new Vector<JTextField>(4, 0);
            JTextComponent jTextComponent = new JTextField(this.documentations.get((int)n4).source, 50);
            vector3.add((JTextField)jTextComponent);
            jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 0));
            jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            jPanel.add(new JLabel("Source: "));
            jPanel.add(component);
            jPanel.add(jTextComponent);
            jPanel.add(Box.createHorizontalGlue());
            jPanel2.add(jPanel);
            jTextComponent = new JTextField(this.documentations.get((int)n4).sourceDate, 50);
            vector3.add((JTextField)jTextComponent);
            jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 0));
            jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            jPanel.add(new JLabel("Source Date: "));
            jPanel.add(component);
            jPanel.add(jTextComponent);
            jPanel.add(Box.createHorizontalGlue());
            jPanel2.add(jPanel);
            jTextComponent = new JTextArea(this.documentations.get((int)n4).info, 5, 50);
            vector3.add((JTextField)jTextComponent);
            jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 0));
            jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            jPanel.add(new JLabel("Info: "));
            jPanel.add(component);
            jPanel.add(new JScrollPane(jTextComponent));
            jPanel.add(Box.createHorizontalGlue());
            jPanel2.add(jPanel);
            jTextComponent = new JTextField(this.documentations.get((int)n4).documentationAuthor, 50);
            vector3.add((JTextField)jTextComponent);
            jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 0));
            jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            jPanel.add(new JLabel("Documentation Author: "));
            jPanel.add(component);
            jPanel.add(jTextComponent);
            jPanel.add(Box.createHorizontalGlue());
            jPanel2.add(jPanel);
            LinkedList linkedList = (LinkedList)object2.get(n4);
            jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 0));
            jPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 5, 10));
            if (nArray == null || nArray2 == null) {
                jPanel.add(new JLabel("Applies to Selected Nodes with Values:"));
            } else {
                jPanel.add(new JLabel("Applies to Selected Nodes with Positions:"));
            }
            jPanel.add(Box.createHorizontalGlue());
            jPanel2.add(jPanel);
            int n5 = 0;
            while (n5 < linkedList.size()) {
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < 10 && n5 < linkedList.size(); ++n5, ++i) {
                    stringBuffer.append((String)linkedList.get(n5)).append(", ");
                }
                stringBuffer.delete(stringBuffer.length() - 2, stringBuffer.length() - 1);
                jPanel = new JPanel();
                jPanel.setLayout(new BoxLayout(jPanel, 0));
                jPanel.setBorder(BorderFactory.createEmptyBorder(0, 20, 10, 10));
                jPanel.add(new JLabel(stringBuffer.toString()));
                jPanel.add(Box.createHorizontalGlue());
                jPanel2.add(jPanel);
            }
            vector2.add(vector3);
            jTabbedPane.addTab(this.documentations.get((int)n4).source, jPanel2);
        }
        jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel2.add(jTabbedPane);
        jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add((Component)serializable);
        jPanel.add(component);
        jPanel.add((Component)object);
        jPanel2.add(jPanel);
        ((AbstractButton)serializable).addActionListener(new ActionListener((Map)object2, vector2, (JDialog)object3){
            final /* synthetic */ Map val$docMaps;
            final /* synthetic */ Vector val$textFields;
            final /* synthetic */ JDialog val$docDialog;
            {
                this.val$docMaps = map;
                this.val$textFields = vector;
                this.val$docDialog = jDialog;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Set set = this.val$docMaps.keySet();
                int n = 0;
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    int n2 = (Integer)iterator.next();
                    ((DocumentationElement)((Documentation)Documentation.this).documentations.get((int)n2)).source = ((JTextComponent)((Vector)this.val$textFields.get(n)).get(0)).getText();
                    ((DocumentationElement)((Documentation)Documentation.this).documentations.get((int)n2)).sourceDate = ((JTextComponent)((Vector)this.val$textFields.get(n)).get(1)).getText();
                    ((DocumentationElement)((Documentation)Documentation.this).documentations.get((int)n2)).info = ((JTextComponent)((Vector)this.val$textFields.get(n)).get(2)).getText();
                    ((DocumentationElement)((Documentation)Documentation.this).documentations.get((int)n2)).documentationAuthor = ((JTextComponent)((Vector)this.val$textFields.get(n)).get(3)).getText();
                    ++n;
                }
                this.val$docDialog.dispose();
            }
        });
        ((AbstractButton)object).addActionListener(new ActionListener((JDialog)object3){
            final /* synthetic */ JDialog val$docDialog;
            {
                this.val$docDialog = jDialog;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                this.val$docDialog.dispose();
            }
        });
        ((JDialog)object3).getContentPane().add(jPanel2);
        ((Window)object3).pack();
        ((Dialog)object3).setVisible(true);
    }

    private int contains(Node node) {
        for (int i = 0; i < this.documentations.size(); ++i) {
            if (!this.documentations.get(i).contains(node)) continue;
            return i;
        }
        return -1;
    }

    private void addToDocumentation(final Vector<Node> vector, final Vector<String> vector2, final Map<Integer, LinkedList<String>> map) {
        if (InterfaceMain.getInstance().showConfirmDialog("Warning Some of the nodes selected did not have documentation\n Would you like to add documentation now?", "Missing Documentation", 0, 2, 1) == 1) {
            return;
        }
        final Vector<String> vector3 = new Vector<String>(this.documentations.size());
        for (int i = 0; i < this.documentations.size(); ++i) {
            vector3.add(this.documentations.get((int)i).source + "  Date: " + this.documentations.get((int)i).sourceDate);
        }
        final JDialog jDialog = new JDialog(InterfaceMain.getInstance().getFrame(), "Add Documentation", true);
        jDialog.setLocation(100, 100);
        jDialog.setResizable(false);
        JButton jButton = new JButton("Done");
        JButton jButton2 = new JButton("Update");
        JButton jButton3 = new JButton("New Documentation");
        JPanel jPanel = new JPanel();
        final JList<String> jList = new JList<String>(vector2);
        jList.getSelectionModel().setSelectionMode(2);
        jList.setPreferredSize(new Dimension(100, 60));
        final JList jList2 = new JList(vector3);
        jList2.getSelectionModel().setSelectionMode(0);
        jList2.setPreferredSize(new Dimension(300, 60));
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                LinkedList linkedList;
                Object[] objectArray = jList.getSelectedValues();
                int[] nArray = jList.getSelectedIndices();
                Vector<Node> vector3 = new Vector<Node>(nArray.length, 0);
                if (nArray.length == 0) {
                    System.out.println("No nodes selected");
                    return;
                }
                int n2 = jList2.getSelectedIndex();
                if (n2 == -1) {
                    System.out.println("no doc selected");
                    return;
                }
                if (!map.containsKey(new Integer(n2))) {
                    linkedList = new LinkedList();
                    map.put(n2, linkedList);
                } else {
                    linkedList = (LinkedList)map.get(n2);
                }
                for (n = 0; n < nArray.length; ++n) {
                    ((DocumentationElement)Documentation.this.documentations.get(n2)).addXPathLinkForNode((Node)vector.get(n));
                    Node node = (Node)vector.get(n);
                    if (node.getNextSibling() != null && node.getNextSibling().getNodeType() == 8) {
                        node.getNextSibling().setNodeValue(String.valueOf(n2));
                    } else {
                        node.getParentNode().appendChild(Documentation.this.doc.createComment(String.valueOf(n2)));
                    }
                    vector3.add((Node)vector.get(n));
                    vector2.remove((String)objectArray[n]);
                    linkedList.addFirst((String)objectArray[n]);
                }
                for (n = 0; n < nArray.length; ++n) {
                    vector.remove(vector3.get(n));
                }
                jList.updateUI();
            }
        });
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (Documentation.this.newDocumentationDialog()) {
                    vector3.add(((DocumentationElement)((Documentation)Documentation.this).documentations.get((int)(((Documentation)Documentation.this).documentations.size() - 1))).source + "  Date: " + ((DocumentationElement)((Documentation)Documentation.this).documentations.get((int)(((Documentation)Documentation.this).documentations.size() - 1))).sourceDate);
                    jList2.updateUI();
                }
            }
        });
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.setVisible(false);
            }
        });
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(Box.createHorizontalStrut(10));
        jPanel2.add(new JLabel("Nodes:"));
        jPanel2.add(Box.createHorizontalStrut(95));
        jPanel2.add(new JLabel("Documentations:"));
        jPanel2.add(Box.createHorizontalGlue());
        jPanel.add(jPanel2);
        jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel2.add(new JScrollPane(jList));
        jPanel2.add(Box.createHorizontalStrut(10));
        jPanel2.add(new JSeparator(1));
        jPanel2.add(Box.createHorizontalStrut(10));
        jPanel2.add(new JScrollPane(jList2));
        jPanel.add(jPanel2);
        jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel2.add(Box.createHorizontalGlue());
        jPanel2.add(jButton2);
        jPanel2.add(Box.createHorizontalStrut(10));
        jPanel2.add(jButton3);
        jPanel2.add(Box.createHorizontalStrut(10));
        jPanel2.add(jButton);
        jPanel.add(jPanel2);
        jDialog.getContentPane().add(jPanel);
        jDialog.pack();
        jDialog.setVisible(true);
    }

    public boolean newDocumentationDialog() {
        final JDialog jDialog = new JDialog(InterfaceMain.getInstance().getFrame(), "Add Documentation", true);
        jDialog.setLocation(100, 100);
        jDialog.setResizable(false);
        int n = this.documentations.size();
        JButton jButton = new JButton("  OK  ");
        JButton jButton2 = new JButton("Cancel");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        final JTextField jTextField = new JTextField(50);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel2.add(new JLabel("Source: "));
        jPanel2.add(Box.createHorizontalStrut(10));
        jPanel2.add(jTextField);
        jPanel2.add(Box.createHorizontalGlue());
        jPanel.add(jPanel2);
        final JTextField jTextField2 = new JTextField(50);
        jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel2.add(new JLabel("Source Date: "));
        jPanel2.add(Box.createHorizontalStrut(10));
        jPanel2.add(jTextField2);
        jPanel2.add(Box.createHorizontalGlue());
        jPanel.add(jPanel2);
        final JTextArea jTextArea = new JTextArea(5, 50);
        jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel2.add(new JLabel("Info: "));
        jPanel2.add(Box.createHorizontalStrut(10));
        jPanel2.add(new JScrollPane(jTextArea));
        jPanel2.add(Box.createHorizontalGlue());
        jPanel.add(jPanel2);
        final JTextField jTextField3 = new JTextField(50);
        jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel2.add(new JLabel("Documentation Author: "));
        jPanel2.add(Box.createHorizontalGlue());
        jPanel2.add(jTextField3);
        jPanel2.add(Box.createHorizontalGlue());
        jPanel.add(jPanel2);
        jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel2.add(Box.createHorizontalGlue());
        jPanel2.add(jButton);
        jPanel2.add(Box.createHorizontalStrut(10));
        jPanel2.add(jButton2);
        jPanel.add(jPanel2);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Documentation.this.documentations.add(new DocumentationElement(jTextField.getText(), jTextField2.getText(), jTextArea.getText(), jTextField3.getText()));
                jDialog.setVisible(false);
            }
        });
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.setVisible(false);
            }
        });
        jDialog.getContentPane().add(jPanel);
        jDialog.pack();
        jDialog.setVisible(true);
        return n != this.documentations.size();
    }

    private class DocumentationElement {
        Vector<String> xpathLinks;
        Vector<TreeSet<Node>> nodeSets;
        String source;
        String sourceDate;
        String info;
        String documentationAuthor;

        public DocumentationElement(Node node) {
            NodeList nodeList = node.getChildNodes();
            this.nodeSets = new Vector();
            this.xpathLinks = new Vector();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                if (nodeList.item(i).getNodeName().equals("XPathLink")) {
                    this.xpathLinks.add(nodeList.item(i).getFirstChild().getNodeValue());
                    this.nodeSets.add(this.evaluateXPath(nodeList.item(i).getFirstChild().getNodeValue()));
                    continue;
                }
                if (nodeList.item(i).getNodeName().equals("source")) {
                    this.source = nodeList.item(i).getFirstChild().getNodeValue();
                    continue;
                }
                if (nodeList.item(i).getNodeName().equals("sourceDate")) {
                    this.sourceDate = nodeList.item(i).getFirstChild().getNodeValue();
                    continue;
                }
                if (nodeList.item(i).getNodeName().equals("info")) {
                    this.info = nodeList.item(i).getFirstChild().getNodeValue();
                    continue;
                }
                if (!nodeList.item(i).getNodeName().equals("documentationAuthor")) continue;
                this.documentationAuthor = nodeList.item(i).getFirstChild().getNodeValue();
            }
        }

        public DocumentationElement(String string, String string2, String string3, String string4) {
            this.nodeSets = new Vector();
            this.xpathLinks = new Vector();
            this.source = string;
            this.sourceDate = string2;
            this.info = string3;
            this.documentationAuthor = string4;
        }

        public boolean contains(Node node) {
            for (int i = 0; i < this.nodeSets.size(); ++i) {
                if (!this.nodeSets.get(i).contains(node)) continue;
                return true;
            }
            return false;
        }

        public void addXPathLinkForNode(Node node) {
            String string = this.nodeToXPath(node).toString();
            for (int i = 0; i < this.xpathLinks.size(); ++i) {
                System.out.println("Results of mergeing " + this.xpathLinks.get(i) + " with " + string + " is:");
                String string2 = this.meregeXPathLinks(this.xpathLinks.get(i), string);
                System.out.println(string2);
                if (string2 == null) continue;
                this.xpathLinks.set(i, string2);
                this.nodeSets.get(i).add(node);
                return;
            }
            this.xpathLinks.add(string);
            TreeSet<Node> treeSet = new TreeSet<Node>(Documentation.this.nodeComparator);
            treeSet.add(node);
            this.nodeSets.add(treeSet);
        }

        private String meregeXPathLinks(String string, String string2) {
            String[] stringArray = string.split("/");
            String[] stringArray2 = string2.split("/");
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            if (stringArray.length != stringArray2.length) {
                System.out.println("Can't merge " + string + " and " + string2);
                return null;
            }
            for (int i = 1; i < stringArray.length; ++i) {
                if (stringArray[i].equals(stringArray2[i])) {
                    stringBuffer.append("/").append(stringArray[i]);
                    continue;
                }
                if (bl) {
                    return null;
                }
                if (stringArray[i].indexOf(91) == -1 && stringArray2[i].indexOf(91) == -1) {
                    return null;
                }
                if (stringArray[i].indexOf(91) != -1 && stringArray2[i].indexOf(91) != -1 && !stringArray[i].substring(0, stringArray[i].indexOf(91)).equals(stringArray2[i].substring(0, stringArray2[i].indexOf(91)))) {
                    return null;
                }
                if (stringArray[i].indexOf(91) == -1 && stringArray2[i].indexOf(91) != -1) {
                    stringBuffer.append("/").append(stringArray2[i]);
                    continue;
                }
                String[] stringArray3 = stringArray[i].substring(stringArray[i].indexOf(91) + 1, stringArray[i].indexOf(93)).split(" or ");
                String string3 = stringArray2[i].substring(stringArray2[i].indexOf(91) + 1, stringArray2[i].indexOf(93));
                boolean bl2 = false;
                for (int j = 0; j < stringArray3.length && !bl2; ++j) {
                    if (!stringArray3[j].equals(string3)) continue;
                    stringBuffer.append("/").append(stringArray[i]);
                    bl2 = true;
                }
                if (!bl2) {
                    stringBuffer.append("/").append(stringArray[i].substring(0, stringArray[i].length() - 1)).append(" or ").append(string3).append("]");
                }
                bl = true;
            }
            return stringBuffer.toString();
        }

        private StringBuffer nodeToXPath(Node node) {
            if (node.getNodeType() != 9) {
                StringBuffer stringBuffer = this.nodeToXPath(node.getParentNode());
                if (node.getNodeType() == 3) {
                    return stringBuffer.append("node()");
                }
                stringBuffer.append(node.getNodeName());
                NamedNodeMap namedNodeMap = node.getAttributes();
                if (namedNodeMap.getLength() > 0) {
                    stringBuffer.append("[");
                }
                if (namedNodeMap.getLength() > 1) {
                    stringBuffer.append("(");
                }
                for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                    stringBuffer.append("(@").append(namedNodeMap.item(i).getNodeName()).append("='").append(namedNodeMap.item(i).getNodeValue()).append("')");
                    if (i + 1 == namedNodeMap.getLength()) continue;
                    stringBuffer.append(" and ");
                }
                if (namedNodeMap.getLength() > 1) {
                    stringBuffer.append(")");
                }
                if (namedNodeMap.getLength() > 0) {
                    stringBuffer.append("]");
                }
                return stringBuffer.append("/");
            }
            return new StringBuffer("/");
        }

        private TreeSet<Node> evaluateXPath(String string) {
            try {
                TreeSet<Node> treeSet = new TreeSet<Node>(Documentation.this.nodeComparator);
                XPathExpression xPathExpression = Documentation.this.xpathImpl.compile(string);
                NodeList nodeList = (NodeList)xPathExpression.evaluate(Documentation.this.doc.getDocumentElement(), XPathConstants.NODESET);
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    treeSet.add(nodeList.item(i));
                }
                return treeSet;
            }
            catch (XPathExpressionException xPathExpressionException) {
                xPathExpressionException.printStackTrace();
                return null;
            }
        }

        void toXML(PrintStream printStream) {
            printStream.println("\t<documentationElement>");
            for (int i = 0; i < this.xpathLinks.size(); ++i) {
                printStream.println("\t\t<XPathLink>" + this.xpathLinks.get(i) + "</XPathLink>");
            }
            printStream.println("\t\t<source>" + this.source + "</source>");
            printStream.println("\t\t<sourceDate>" + this.sourceDate + "</sourceDate>");
            printStream.println("\t\t<info>" + this.info + "</info>");
            printStream.println("\t\t<documentationAuthor>" + this.documentationAuthor + "</documentationAuthor>");
            printStream.println("\t</documentationElement>");
        }
    }
}

