/*
 * Decompiled with CFR 0.152.
 */
package ModelInterface.ModelGUI2;

import ModelInterface.InterfaceMain;
import ModelInterface.ModelGUI2.undo.NodeDeleteUndoableEdit;
import ModelInterface.ModelGUI2.undo.NodeEditUndoableEdit;
import ModelInterface.ModelGUI2.undo.NodeInsertUndoableEdit;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import javax.swing.undo.UndoableEdit;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.events.MutationEvent;

public class DOMmodel
implements TreeModel {
    private Vector treeModelListeners = new Vector();
    private Node rootNode;
    private Document doc;

    public DOMmodel(Document document) {
        this.doc = document;
        this.rootNode = document.getDocumentElement();
        final InterfaceMain interfaceMain = InterfaceMain.getInstance();
        this.treeModelListeners.clear();
        EventTarget eventTarget = (EventTarget)((Object)document);
        eventTarget.addEventListener("DOMNodeInserted", new org.w3c.dom.events.EventListener(){

            @Override
            public void handleEvent(Event event) {
                System.out.println("HANDLIN EVENT, type: " + event.getType());
                MutationEvent mutationEvent = (MutationEvent)event;
                DOMNodeAdapter dOMNodeAdapter = new DOMNodeAdapter((Node)((Object)mutationEvent.getTarget()));
                Node node = mutationEvent.getRelatedNode();
                int n = DOMmodel.this.getIndexOfChild(new DOMNodeAdapter(node), dOMNodeAdapter);
                int[] nArray = new int[]{n};
                Object[] objectArray = new Object[]{dOMNodeAdapter};
                TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, DOMmodel.this.getTreePathFromNode(node), nArray, objectArray);
                if (new Boolean(true).equals(dOMNodeAdapter.getNode().getUserData("isFromUndoable"))) {
                    System.out.println("Thinks this is from undo");
                    dOMNodeAdapter.getNode().setUserData("isFromUndoable", false, null);
                } else if (dOMNodeAdapter.getNode().getUserData("isSetValue") != null) {
                    System.out.println("Putting as compound edit");
                    System.out.println("Add to CompEdit returned: " + ((UndoableEdit)dOMNodeAdapter.getNode().getUserData("isSetValue")).addEdit(new NodeInsertUndoableEdit(node, dOMNodeAdapter.getNode())));
                    dOMNodeAdapter.getNode().setUserData("isSetValue", null, null);
                } else {
                    System.out.println("Thinks this is your regular or insert");
                    interfaceMain.getUndoManager().addEdit(new NodeInsertUndoableEdit(node, dOMNodeAdapter.getNode()));
                }
                interfaceMain.refreshUndoRedo();
                DOMmodel.this.fireTreeNodesInserted(treeModelEvent);
            }
        }, false);
        eventTarget.addEventListener("DOMNodeRemoved", new org.w3c.dom.events.EventListener(){

            @Override
            public void handleEvent(Event event) {
                System.out.println("HANDLIN EVENT, type: " + event.getType());
                MutationEvent mutationEvent = (MutationEvent)event;
                DOMNodeAdapter dOMNodeAdapter = new DOMNodeAdapter((Node)((Object)mutationEvent.getTarget()));
                Node node = mutationEvent.getRelatedNode();
                int n = DOMmodel.this.getIndexOfChild(new DOMNodeAdapter(node), dOMNodeAdapter);
                int[] nArray = new int[]{n};
                Object[] objectArray = new Object[]{dOMNodeAdapter};
                TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, DOMmodel.this.getTreePathFromNode(node), nArray, objectArray);
                if (!new Boolean(true).equals(dOMNodeAdapter.getNode().getUserData("isFromUndoable"))) {
                    interfaceMain.getUndoManager().addEdit(new NodeDeleteUndoableEdit(node, dOMNodeAdapter.getNode()));
                } else {
                    dOMNodeAdapter.getNode().setUserData("isFromUndoable", false, null);
                }
                interfaceMain.refreshUndoRedo();
                DOMmodel.this.fireTreeNodesRemoved(treeModelEvent);
            }
        }, false);
    }

    @Override
    public Object getRoot() {
        return new DOMNodeAdapter(this.rootNode);
    }

    @Override
    public int getChildCount(Object object) {
        NodeList nodeList = ((DOMNodeAdapter)object).getNode().getChildNodes();
        int n = 0;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getNodeType() == 8) continue;
            ++n;
        }
        return n;
    }

    @Override
    public Object getChild(Object object, int n) {
        Node node = ((DOMNodeAdapter)object).getNode().getChildNodes().item(n);
        int n2 = ((DOMNodeAdapter)object).getNode().getChildNodes().getLength();
        while (n < n2 && node.getNodeType() == 8) {
            node = ((DOMNodeAdapter)object).getNode().getChildNodes().item(++n);
        }
        return new DOMNodeAdapter(node);
    }

    @Override
    public boolean isLeaf(Object object) {
        return this.getChildCount(object) == 0;
    }

    @Override
    public int getIndexOfChild(Object object, Object object2) {
        if (object == null || object2 == null) {
            return -1;
        }
        try {
            NodeList nodeList = ((DOMNodeAdapter)object).getNode().getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                if (nodeList.item(i).getNodeType() == 8 || !(nodeList.item(i).getNodeType() == 3 && ((DOMNodeAdapter)object2).getNode().getNodeType() == 3 ? nodeList.item(i).getNodeValue().equals(((DOMNodeAdapter)object2).getNode().getNodeValue()) : ((DOMNodeAdapter)object2).getNode().getNodeType() != 3 && ((DOMNodeAdapter)object2).getNode().getNodeType() == 1 && this.compareHelper((Element)nodeList.item(i), (Element)((DOMNodeAdapter)object2).getNode()))) continue;
                return i;
            }
        }
        catch (ClassCastException classCastException) {
            System.out.println(classCastException);
            return -1;
        }
        return -1;
    }

    private boolean compareHelper(Element element, Element element2) {
        if (!element.getTagName().equals(element2.getTagName())) {
            return false;
        }
        NamedNodeMap namedNodeMap = element.getAttributes();
        NamedNodeMap namedNodeMap2 = element2.getAttributes();
        if (namedNodeMap.getLength() != namedNodeMap2.getLength()) {
            return false;
        }
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            String string = namedNodeMap.item(i).getNodeName();
            if (element.getAttribute(string).equals(element2.getAttribute(string))) continue;
            return false;
        }
        return true;
    }

    @Override
    public void addTreeModelListener(TreeModelListener treeModelListener) {
        if (treeModelListener != null && !this.treeModelListeners.contains(treeModelListener)) {
            this.treeModelListeners.addElement(treeModelListener);
        }
    }

    @Override
    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        if (treeModelListener != null) {
            this.treeModelListeners.removeElement(treeModelListener);
        }
    }

    @Override
    public void valueForPathChanged(TreePath treePath, Object object) {
        this.valueForPathChanged(treePath, object, true);
    }

    public void valueForPathChanged(TreePath treePath, Object object, boolean bl) {
        DOMNodeAdapter dOMNodeAdapter = (DOMNodeAdapter)treePath.getLastPathComponent();
        String string = dOMNodeAdapter.toEditString();
        if (dOMNodeAdapter.setFromEditString((String)object)) {
            EventListener eventListener;
            if (bl) {
                eventListener = InterfaceMain.getInstance();
                ((InterfaceMain)eventListener).getUndoManager().addEdit(new NodeEditUndoableEdit(this, treePath, string, (String)object));
                ((InterfaceMain)eventListener).refreshUndoRedo();
            }
            Iterator iterator = this.treeModelListeners.iterator();
            TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, treePath);
            while (iterator.hasNext()) {
                eventListener = (TreeModelListener)iterator.next();
                eventListener.treeNodesChanged(treeModelEvent);
            }
        }
    }

    public DOMNodeAdapter getAdapterNode(Node node) {
        return new DOMNodeAdapter(node);
    }

    public void insertNodeInto(Node node, TreePath treePath) {
        Node node2;
        int n;
        Node node3 = ((DOMNodeAdapter)treePath.getLastPathComponent()).getNode();
        if (node3 == null) {
            node3 = this.rootNode;
        }
        node3.appendChild(node);
        NodeList nodeList = node3.getChildNodes();
        for (n = 0; n < nodeList.getLength() && !(node2 = nodeList.item(n)).equals(node); ++n) {
        }
        int[] nArray = new int[]{n};
        Object[] objectArray = new Node[]{node};
        this.fireTreeNodesInserted(new TreeModelEvent((Object)this, treePath, nArray, objectArray));
    }

    public void removeNodeFrom(TreePath treePath) {
        Node node;
        Node node2 = ((DOMNodeAdapter)treePath.getLastPathComponent()).getNode();
        Node node3 = node2.getParentNode();
        if (node2 == this.rootNode) {
            this.rootNode = null;
            return;
        }
        NodeList nodeList = node3.getChildNodes();
        for (int i = 0; i < nodeList.getLength() && !(node = nodeList.item(i)).equals(node2); ++i) {
        }
        node3.removeChild(node2);
    }

    public void fireTreeNodesInserted(TreeModelEvent treeModelEvent) {
        for (TreeModelListener treeModelListener : this.treeModelListeners) {
            treeModelListener.treeNodesInserted(treeModelEvent);
        }
    }

    public void fireTreeNodesRemoved(TreeModelEvent treeModelEvent) {
        for (TreeModelListener treeModelListener : this.treeModelListeners) {
            treeModelListener.treeNodesRemoved(treeModelEvent);
        }
    }

    public void fireTreeNodesChanged(TreeModelEvent treeModelEvent) {
        for (TreeModelListener treeModelListener : this.treeModelListeners) {
            treeModelListener.treeNodesChanged(treeModelEvent);
        }
    }

    public TreePath getTreePathFromNode(Node node) {
        LinkedList<DOMNodeAdapter> linkedList = new LinkedList<DOMNodeAdapter>();
        linkedList.add(new DOMNodeAdapter(node));
        while ((node = node.getParentNode()) != null) {
            linkedList.add(0, new DOMNodeAdapter(node));
        }
        linkedList.remove(0);
        return new TreePath(linkedList.toArray());
    }

    public class DOMNodeAdapter {
        Node n;

        public DOMNodeAdapter(Node node) {
            this.n = node;
        }

        public String toString() {
            if (this.n.getNodeType() == 3) {
                return this.n.getNodeValue();
            }
            String string = this.n.getNodeName();
            NamedNodeMap namedNodeMap = this.n.getAttributes();
            if (namedNodeMap != null) {
                for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                    string = string + " " + namedNodeMap.item(i).getNodeName() + " = " + ((Element)this.n).getAttribute(namedNodeMap.item(i).getNodeName());
                }
            }
            return string;
        }

        public Node getNode() {
            return this.n;
        }

        public boolean equals(Object object) {
            if (!(object instanceof DOMNodeAdapter)) {
                return false;
            }
            return this.n.equals(((DOMNodeAdapter)object).getNode());
        }

        public int hashCode() {
            return this.n.hashCode();
        }

        public String toEditString() {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.n.getNodeType() == 3) {
                stringBuilder.append(this.n.getNodeValue());
            } else if (this.n.getNodeType() == 1) {
                stringBuilder.append(this.n.getNodeName());
                NamedNodeMap namedNodeMap = this.n.getAttributes();
                for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                    Node node = namedNodeMap.item(i);
                    stringBuilder.append(", ").append(node.getNodeName()).append(" = \"").append(node.getNodeValue()).append('\"');
                }
            }
            return stringBuilder.toString();
        }

        public boolean setFromEditString(String string) {
            boolean bl = false;
            if (this.n.getNodeType() == 3 && !this.n.getNodeValue().equals(string)) {
                this.n.setNodeValue(string);
                bl = true;
            } else if (this.n.getNodeType() == 1) {
                String string2;
                Pattern pattern = Pattern.compile("(?:\\s*([\\w\\-_]+)\\s*)?(?:,\\s*([\\w\\-_]+)\\s*=\\s*\"([^\"]+)\"\\s*)");
                Matcher matcher = pattern.matcher(string);
                HashMap<String, String> hashMap = new HashMap<String, String>();
                if (!matcher.find()) {
                    string2 = string;
                } else {
                    string2 = matcher.group(1);
                    do {
                        hashMap.put(matcher.group(2), matcher.group(3));
                    } while (matcher.find());
                }
                if (!this.n.getNodeName().equals(string2)) {
                    DOMmodel.this.doc.renameNode(this.n, "", string2);
                    bl = true;
                }
                NamedNodeMap namedNodeMap = this.n.getAttributes();
                for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                    Node object = namedNodeMap.item(i);
                    if (hashMap.containsKey(object.getNodeName())) {
                        if (!object.getNodeValue().equals(hashMap.get(object.getNodeName()))) {
                            object.setNodeValue((String)hashMap.get(object.getNodeName()));
                            bl = true;
                        }
                        hashMap.remove(object.getNodeName());
                        continue;
                    }
                    namedNodeMap.removeNamedItem(object.getNodeName());
                    --i;
                    bl = true;
                }
                for (Map.Entry entry : hashMap.entrySet()) {
                    ((Element)this.n).setAttribute((String)entry.getKey(), (String)entry.getValue());
                    bl = true;
                }
            }
            return bl;
        }
    }
}

