/*
 * Decompiled with CFR 0.152.
 */
package ModelInterface.ModelGUI2;

import ModelInterface.ModelGUI2.DOMmodel;
import ModelInterface.ModelGUI2.ParseFilter;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSException;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSParser;

public class DOMTransferHandler
extends TransferHandler {
    private Document doc;
    private DOMImplementationLS implls;
    private LSParser parser;
    public static DataFlavor DOM_NODE_DATAFLAVOR = new DataFlavor(Node.class, "Node");
    private int lastAction;

    public DOMTransferHandler(Document document, DOMImplementationLS dOMImplementationLS) {
        this.doc = document;
        this.implls = dOMImplementationLS;
        try {
            this.parser = this.implls.createLSParser((short)1, null);
            this.parser.setFilter(new ParseFilter());
        }
        catch (DOMException dOMException) {
            dOMException.printStackTrace();
        }
    }

    @Override
    public boolean importData(JComponent jComponent, Transferable transferable) {
        DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
        boolean bl = false;
        Node node = null;
        Node node2 = ((DOMmodel.DOMNodeAdapter)((JTree)jComponent).getSelectionPath().getLastPathComponent()).getNode();
        String string = null;
        for (DataFlavor dataFlavor : dataFlavorArray) {
            if (dataFlavor.equals(DOM_NODE_DATAFLAVOR)) {
                try {
                    node = (Node)transferable.getTransferData(DOM_NODE_DATAFLAVOR);
                    if (this.lastAction == 2) {
                        node2.appendChild(node);
                    } else {
                        node2.appendChild(node.cloneNode(true));
                    }
                    return true;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    continue;
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                    unsupportedFlavorException.printStackTrace();
                    continue;
                }
                catch (DOMException dOMException) {
                    dOMException.printStackTrace();
                    return false;
                }
            }
            if (!dataFlavor.equals(DataFlavor.stringFlavor)) continue;
            bl = true;
        }
        if (bl) {
            try {
                string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                LSInput lSInput = this.implls.createLSInput();
                lSInput.setStringData(string);
                node = this.doc.adoptNode(this.parser.parse(lSInput).getDocumentElement());
                node2.appendChild(node);
                return true;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                unsupportedFlavorException.printStackTrace();
            }
            catch (DOMException dOMException) {
                dOMException.printStackTrace();
                return this.attemptTextNodePaste(node2, string);
            }
            catch (LSException lSException) {
                lSException.printStackTrace();
                return this.attemptTextNodePaste(node2, string);
            }
        }
        return false;
    }

    @Override
    public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
        for (int i = 0; i < dataFlavorArray.length; ++i) {
            if (!DataFlavor.stringFlavor.equals(dataFlavorArray[i]) && !DOM_NODE_DATAFLAVOR.equals(dataFlavorArray[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    protected Transferable createTransferable(JComponent jComponent) {
        return new TransferableXML(((DOMmodel.DOMNodeAdapter)((JTree)jComponent).getSelectionPath().getLastPathComponent()).getNode());
    }

    @Override
    protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
        this.lastAction = n;
        if (n == 2) {
            ((JTree)jComponent).removeSelectionPaths(((JTree)jComponent).getSelectionPaths());
        }
    }

    @Override
    public int getSourceActions(JComponent jComponent) {
        return 3;
    }

    private boolean attemptTextNodePaste(Node node, String string) {
        try {
            Text text = this.doc.createTextNode(string);
            node.appendChild(text);
            return true;
        }
        catch (DOMException dOMException) {
            dOMException.printStackTrace();
            return false;
        }
    }

    private class TransferableXML
    implements Transferable {
        private Node curr;
        private DataFlavor[] transFlavors;

        public TransferableXML(Node node) {
            this.curr = node;
            this.transFlavors = new DataFlavor[2];
            this.transFlavors[0] = DOM_NODE_DATAFLAVOR;
            this.transFlavors[1] = DataFlavor.stringFlavor;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return this.transFlavors;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            return dataFlavor.isFlavorTextType() || DOM_NODE_DATAFLAVOR.equals(dataFlavor);
        }

        @Override
        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            if (DOM_NODE_DATAFLAVOR.equals(dataFlavor)) {
                return this.curr;
            }
            if (dataFlavor.isFlavorTextType()) {
                return DOMTransferHandler.this.implls.createLSSerializer().writeToString(this.curr);
            }
            throw new UnsupportedFlavorException(dataFlavor);
        }
    }
}

