/*
 * Decompiled with CFR 0.152.
 */
package ModelInterface.ConfigurationEditor.guihelpers;

import ModelInterface.ConfigurationEditor.guicomponents.DOMListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ButtonSetEnabler
implements ListSelectionListener,
ListDataListener {
    private static final int NUM_BUTTONS = 4;
    private final transient JButton[] mButtons = new JButton[4];

    public void addControlledButton(JButton jButton, ButtonType buttonType) {
        this.mButtons[buttonType.ordinal()] = jButton;
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        JList jList = (JList)listSelectionEvent.getSource();
        this.updateButtonStates(jList);
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        JList jList = ((DOMListModel)listDataEvent.getSource()).getParentList();
        this.updateButtonStates(jList);
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        JList jList = ((DOMListModel)listDataEvent.getSource()).getParentList();
        this.updateButtonStates(jList);
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        JList jList = ((DOMListModel)listDataEvent.getSource()).getParentList();
        this.updateButtonStates(jList);
    }

    private void updateButtonStates(final JList jList) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public synchronized void run() {
                ButtonSetEnabler.this.mButtons[ButtonType.ADD.ordinal()].setEnabled(((DOMListModel)jList.getModel()).canAddElements());
                int n = jList.getModel().getSize();
                int n2 = jList.getSelectedIndex();
                ButtonSetEnabler.this.mButtons[ButtonType.DELETE.ordinal()].setEnabled(n2 != -1 && n > 0);
                ButtonSetEnabler.this.mButtons[ButtonType.UP.ordinal()].setEnabled(n2 > 0);
                ButtonSetEnabler.this.mButtons[ButtonType.DOWN.ordinal()].setEnabled(n2 != -1 && n2 < n - 1);
            }
        });
    }

    public static enum ButtonType {
        ADD,
        DELETE,
        UP,
        DOWN;

    }
}

