/*
 * Decompiled with CFR 0.152.
 */
package ModelInterface.ConfigurationEditor.guicomponents;

import ModelInterface.ConfigurationEditor.guihelpers.NodeWrapper;
import ModelInterface.ConfigurationEditor.utils.DOMUtils;
import ModelInterface.ConfigurationEditor.utils.Messages;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractListModel;
import javax.swing.JList;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMListModel
extends AbstractListModel
implements ListSelectionListener,
ListDataListener {
    private static final long serialVersionUID = 5114598661300941143L;
    private transient Node mRoot = null;
    private transient Document mDocument = null;
    private final transient String mElementName;
    private transient String mParentXPath = null;
    private final transient boolean mLeafChildren;
    private transient JList mParentList = null;
    private final transient JList mContainerList;

    public DOMListModel(JList jList, String string, String string2, boolean bl) {
        this.mContainerList = jList;
        this.mParentXPath = string2;
        this.mElementName = string;
        this.mLeafChildren = bl;
    }

    public JList getParentList() {
        return this.mContainerList;
    }

    public void setParentList(JList jList) {
        this.mParentList = jList;
    }

    public void setDocument(Document document) {
        this.mDocument = document;
        this.mRoot = null;
        if (this.mParentXPath.charAt(0) == '/' && this.mDocument != null) {
            Node node = DOMUtils.getResultNodeFromQuery(this.mDocument, this.mParentXPath);
            if (node == null) {
                node = DOMUtils.addNodesForXPath(this.mDocument, this.mParentXPath);
            }
            this.mRoot = node;
        }
        this.fireContentsChanged(this, 0, this.getSize() - 1);
    }

    @Override
    public int getSize() {
        if (!this.canAccessDOM()) {
            return 0;
        }
        return DOMUtils.getNumberOfElementChildren(this.mRoot);
    }

    public boolean contains(Object object) {
        Element element = DOMUtils.createElement(this.mRoot, this.mElementName, object, this.mLeafChildren);
        return DOMUtils.getDOMIndexOfObject(this.mRoot, element) != -1;
    }

    @Override
    public Object getElementAt(int n) {
        int n2 = DOMUtils.getDOMIndexForListIndex(this.mRoot, n);
        if (n2 != -1) {
            return NodeWrapper.createProxy(this.mRoot.getChildNodes().item(n2));
        }
        Logger.global.log(Level.WARNING, Messages.getString("DOMListModel.5"));
        return null;
    }

    public void addElement(Object object) {
        Element element = DOMUtils.createElement(this.mRoot, this.mElementName, object, this.mLeafChildren);
        if (DOMUtils.getDOMIndexOfObject(this.mRoot, element) != -1) {
            Logger.global.log(Level.WARNING, Messages.getString("DOMListModel.9"));
            return;
        }
        this.mRoot.appendChild(element);
        int n = DOMUtils.getListIndexOfObject(this.mRoot, element);
        this.fireIntervalAdded(this, n, n);
    }

    public boolean canAddElements() {
        return this.canAccessDOM();
    }

    public boolean removeElement(Object object) {
        int n = DOMUtils.getDOMIndexOfObject(this.mRoot, object);
        if (n == -1) {
            Logger.global.log(Level.WARNING, Messages.getString("DOMListModel.11") + object.toString() + Messages.getString("DOMListModel.12"));
            return false;
        }
        int n2 = DOMUtils.getListIndexOfObject(this.mRoot, object);
        this.mRoot.removeChild(this.mRoot.getChildNodes().item(n));
        this.fireIntervalRemoved(this, n2, n2);
        return true;
    }

    public int moveElementBack(Object object) {
        int n = DOMUtils.getDOMIndexOfObject(this.mRoot, object);
        if (n == -1) {
            Logger.global.log(Level.WARNING, Messages.getString("DOMListModel.14") + object.toString() + Messages.getString("DOMListModel.15"));
            return 0;
        }
        if (n == 0) {
            Logger.global.log(Level.WARNING, Messages.getString("DOMListModel.16"));
            return 0;
        }
        NodeList nodeList = this.mRoot.getChildNodes();
        Node node = nodeList.item(n);
        Node node2 = DOMUtils.getItemBefore(this.mRoot, node);
        node = this.mRoot.removeChild(node);
        this.mRoot.insertBefore(node, node2);
        this.fireContentsChanged(this, DOMUtils.getListIndexOfObject(this.mRoot, node), DOMUtils.getListIndexOfObject(this.mRoot, node2));
        return DOMUtils.getListIndexOfObject(this.mRoot, node);
    }

    public int moveElementForward(Object object) {
        int n = DOMUtils.getDOMIndexOfObject(this.mRoot, object);
        if (n == -1) {
            Logger.global.log(Level.WARNING, Messages.getString("DOMListModel.18") + object.toString() + Messages.getString("DOMListModel.19"));
            return 0;
        }
        if (n == this.getSize() - 1) {
            Logger.global.log(Level.WARNING, Messages.getString("DOMListModel.0"));
            return 0;
        }
        NodeList nodeList = this.mRoot.getChildNodes();
        Node node = nodeList.item(n);
        Node node2 = DOMUtils.getItemAfter(this.mRoot, DOMUtils.getItemAfter(this.mRoot, node));
        node = this.mRoot.removeChild(node);
        this.mRoot.insertBefore(node, node2);
        this.fireContentsChanged(this, DOMUtils.getListIndexOfObject(this.mRoot, DOMUtils.getItemBefore(this.mRoot, node)), DOMUtils.getListIndexOfObject(this.mRoot, node2));
        return DOMUtils.getListIndexOfObject(this.mRoot, node);
    }

    private boolean canAccessDOM() {
        return this.mRoot != null;
    }

    public String getSelectedXPath(int n) {
        return this.mParentXPath + "/" + this.mElementName + "[@name='" + DOMUtils.getNameAttrValue((Node)this.getElementAt(n)) + "']";
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.mContainerList.setSelectedIndex(-1);
        this.update(((JList)listSelectionEvent.getSource()).getSelectedIndex());
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.mContainerList.setSelectedIndex(-1);
        this.update(((DOMListModel)listDataEvent.getSource()).mContainerList.getSelectedIndex());
    }

    private void update(int n) {
        this.mParentXPath = ((DOMListModel)this.mParentList.getModel()).getSelectedXPath(n);
        Node node = DOMUtils.getResultNodeFromQuery(this.mDocument, this.mParentXPath);
        if (node == null) {
            node = DOMUtils.addNodesForXPath(this.mDocument, this.mParentXPath);
        }
        this.mRoot = node;
        this.fireContentsChanged(this, 0, this.getSize() - 1);
    }
}

