/*
 * Decompiled with CFR 0.152.
 */
package ModelInterface.ConfigurationEditor.guicomponents;

import ModelInterface.ConfigurationEditor.guihelpers.NodeWrapper;
import ModelInterface.ConfigurationEditor.utils.DOMUtils;
import ModelInterface.ConfigurationEditor.utils.Messages;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractListModel;
import javax.swing.MutableComboBoxModel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DOMComboBoxModel
extends AbstractListModel
implements MutableComboBoxModel {
    private static final long serialVersionUID = 4829102744109149915L;
    private final transient Document mDocument;
    private final transient Node mRoot;
    private transient Object mSelectedItem = null;
    private final transient String mParentXPath;
    private final transient String mElementName;
    private final transient String mItemName;
    private final transient Map<Node, Object> mCachedWrappers;

    public DOMComboBoxModel(Document document, String string, String string2, String string3) {
        Logger.global.log(Level.INFO, "Creating DOM combo box model.");
        this.mDocument = document;
        this.mParentXPath = string;
        this.mElementName = string2;
        this.mItemName = string3;
        this.mCachedWrappers = new HashMap<Node, Object>();
        this.mRoot = this.getRootNode();
        this.mSelectedItem = this.getElementAt(0);
    }

    @Override
    public final Object getElementAt(int n) {
        int n2 = DOMUtils.getDOMIndexForListIndex(this.mRoot, n);
        if (n2 != -1) {
            Node node = this.mRoot.getChildNodes().item(n2);
            Object object = this.mCachedWrappers.get(node);
            if (object == null) {
                object = NodeWrapper.createProxy(node);
                this.mCachedWrappers.put(node, object);
            }
            return object;
        }
        Logger.global.log(Level.WARNING, "getElement failed because the requested position was greater than the number of elements.");
        return null;
    }

    @Override
    public int getSize() {
        if (!this.canAccessDOM()) {
            Logger.global.log(Level.INFO, "Returning size of zero because the DOM is inaccessable.");
            return 0;
        }
        return DOMUtils.getNumberOfElementChildren(this.mRoot);
    }

    @Override
    public void setSelectedItem(Object object) {
        if (object != null && DOMUtils.getDOMIndexOfObject(this.mRoot, object) == -1) {
            return;
        }
        if (object != null && object.equals(this.mSelectedItem)) {
            return;
        }
        this.mSelectedItem = object;
        this.fireContentsChanged(this, -1, -1);
    }

    @Override
    public Object getSelectedItem() {
        return this.mSelectedItem;
    }

    boolean canAccessDOM() {
        return this.mDocument != null && this.mRoot != null;
    }

    private final Node getRootNode() {
        Node node = DOMUtils.getResultNodeFromQuery(this.mDocument, this.getXPath());
        if (node == null) {
            Logger.global.log(Level.INFO, "Creating new root node for combo box model with XPath: " + this.getXPath());
            node = DOMUtils.addNodesForXPath(this.mDocument, this.getXPath());
            if (node == null) {
                Logger.global.log(Level.WARNING, "Failed to create a root node for combo box.");
            }
        }
        return node;
    }

    private String getXPath() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.mParentXPath != null) {
            stringBuilder.append(this.mParentXPath);
        }
        stringBuilder.append("/").append(this.mElementName);
        if (this.mItemName != null) {
            stringBuilder.append("[@name='").append(this.mItemName).append("']");
        }
        return stringBuilder.toString();
    }

    public void addElement(Object object) {
        this.insertElementAt(object, this.getSize());
    }

    @Override
    public void removeElement(Object object) {
        int n = DOMUtils.getListIndexOfObject(this.mRoot, object);
        if (n == -1) {
            Logger.global.log(Level.WARNING, "Could not find the object to remove from the combo box.");
            return;
        }
        this.removeElementAt(n);
    }

    public void insertElementAt(Object object, int n) {
        Element element = DOMUtils.createElement(this.mRoot, this.mElementName, object, false);
        if (DOMUtils.getDOMIndexOfObject(this.mRoot, element) != -1) {
            Logger.global.log(Level.WARNING, Messages.getString("DOMListModel.9"));
            return;
        }
        int n2 = DOMUtils.getDOMIndexForListIndex(this.mRoot, n);
        Node node = this.mRoot.getChildNodes().item(n2);
        this.mRoot.insertBefore(element, node);
        if (this.getSize() == 1) {
            this.setSelectedItem(this.getElementAt(0));
        }
        this.fireIntervalAdded(this, n, n);
    }

    @Override
    public void removeElementAt(int n) {
        int n2 = DOMUtils.getDOMIndexForListIndex(this.mRoot, n);
        if (n2 == -1) {
            Logger.global.log(Level.WARNING, "Could not remove element because position was invalid.");
            return;
        }
        if (this.getElementAt(n) == this.mSelectedItem) {
            this.mSelectedItem = this.getElementAt(n == 0 ? 1 : n - 1);
        }
        this.mRoot.removeChild(this.mRoot.getChildNodes().item(n2));
        this.fireIntervalRemoved(this, n, n);
    }
}

