/*
 * Decompiled with CFR 0.152.
 */
package ModelInterface.ConfigurationEditor.guicomponents;

import ModelInterface.ConfigurationEditor.utils.DOMUtils;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComboBox;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class DOMComboBoxController
implements ItemListener {
    private transient Document mDocument = null;
    private transient String mRootElementName = null;
    private transient String mParentNodeName = null;
    private transient String mCurrParentName = null;
    private transient Map<String, JComboBox> mComboBoxes = null;

    public DOMComboBoxController(Document document, String string, String string2) {
        this.mDocument = document;
        this.mRootElementName = string;
        this.mParentNodeName = string2;
        this.mComboBoxes = new HashMap<String, JComboBox>();
    }

    public JComboBox createComboBox(String[] stringArray, String string) {
        if (this.mComboBoxes.containsKey(string)) {
            Logger.global.log(Level.WARNING, "Cannot create duplicate combo box: " + string);
            return null;
        }
        JComboBox<String> jComboBox = new JComboBox<String>(stringArray);
        this.mComboBoxes.put(string, jComboBox);
        jComboBox.addItemListener(new ComboBoxItemListener(string));
        return jComboBox;
    }

    private String createXPath(String string) {
        return "/" + this.mRootElementName + "/" + this.mParentNodeName + "[@name='" + this.mCurrParentName + "']/" + string;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            this.mCurrParentName = itemEvent.getItem().toString();
            for (String string : this.mComboBoxes.keySet()) {
                JComboBox jComboBox = this.mComboBoxes.get(string);
                if (this.mCurrParentName == null) {
                    jComboBox.setSelectedIndex(-1);
                    jComboBox.setEnabled(false);
                    continue;
                }
                jComboBox.setEnabled(true);
                String string2 = this.createXPath(string);
                Node node = DOMUtils.getResultNodeFromQuery(this.mDocument, string2);
                int n = -1;
                if (node != null && node.getTextContent() != null) {
                    n = Integer.parseInt(node.getTextContent());
                }
                if (n >= jComboBox.getModel().getSize()) {
                    Logger.global.log(Level.WARNING, "Resetting invalid combo box value.");
                    n = jComboBox.getModel().getSize() - 1;
                }
                jComboBox.setSelectedIndex(n);
            }
        }
    }

    private final class ComboBoxItemListener
    implements ItemListener {
        private final transient String mItemName;

        public ComboBoxItemListener(String string) {
            this.mItemName = string;
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() != 1) {
                return;
            }
            if (DOMComboBoxController.this.mDocument == null) {
                Logger.global.log(Level.WARNING, "Item state changed without an underlying document.");
                return;
            }
            String string = DOMComboBoxController.this.createXPath(this.mItemName);
            Node node = DOMUtils.getResultNodeFromQuery(DOMComboBoxController.this.mDocument, string);
            int n = ((JComboBox)itemEvent.getSource()).getSelectedIndex();
            if (node == null && n != -1) {
                Logger.global.log(Level.INFO, string);
                node = DOMUtils.addNodesForXPath(DOMComboBoxController.this.mDocument, string);
            }
            if (node != null) {
                boolean bl = false;
                try {
                    bl = Integer.parseInt(node.getTextContent()) == n;
                }
                catch (NumberFormatException numberFormatException) {
                    Logger.global.log(Level.WARNING, "Number format caught while setting DOM value for combo box.");
                }
                if (!bl) {
                    node.setTextContent(Integer.toString(n));
                }
            }
        }
    }
}

