/*
 * Decompiled with CFR 0.152.
 */
package ModelInterface.ConfigurationEditor.configurationeditor;

import ModelInterface.ConfigurationEditor.configurationeditor.DOMDocumentEditor;
import ModelInterface.ConfigurationEditor.guicomponents.DOMButtonModel;
import ModelInterface.ConfigurationEditor.guicomponents.DOMComboBoxController;
import ModelInterface.ConfigurationEditor.guicomponents.DOMComboBoxModel;
import ModelInterface.ConfigurationEditor.guihelpers.DOMDocumentSaveSetter;
import ModelInterface.ConfigurationEditor.utils.DOMUtils;
import ModelInterface.ConfigurationEditor.utils.FileUtils;
import ModelInterface.ConfigurationEditor.utils.Messages;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.w3c.dom.Document;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;

public class LogEditor
extends JPanel
implements DOMDocumentEditor {
    private static final long serialVersionUID = -1626218404879455659L;
    private transient Document mDocument;
    static final String LOG_ROOT = "LoggerFactory";
    static final String SINGLE_LOGGER = "Logger";
    private static final String[] LEVEL_STRINGS = new String[]{"Debug", "Notice", "Warning", "Error", "Severe"};
    private static final String MIN_SCREEN_LEVEL = "minToScreenWarningLevel";
    private static final String MIN_LOG_LEVEL = "minLogWarningLevel";
    private static final String PRINT_LEVEL = "printLogWarningLevel";

    public final boolean initialize() {
        this.mDocument = this.loadDocument();
        if (this.mDocument == null) {
            return false;
        }
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createBevelBorder(0));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 0;
        JLabel jLabel = new JLabel(Messages.getString("ConfigurationEditor.89"));
        jLabel.setToolTipText(Messages.getString("ConfigurationEditor.90"));
        jLabel.setHorizontalAlignment(2);
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        JComboBox jComboBox = this.createLoggerSelecter();
        this.add((Component)jComboBox, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 10;
        JLabel jLabel2 = new JLabel("Settings for the selected log: ");
        this.add(jLabel2);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridy = 1;
        JLabel jLabel3 = new JLabel(Messages.getString("ConfigurationEditor.81"));
        jLabel3.setHorizontalAlignment(2);
        this.add((Component)jLabel3, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        JLabel jLabel4 = new JLabel(Messages.getString("ConfigurationEditor.84"));
        jLabel4.setHorizontalAlignment(2);
        this.add((Component)jLabel4, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        JLabel jLabel5 = new JLabel(Messages.getString("ConfigurationEditor.94"));
        this.add((Component)jLabel5, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        JCheckBox jCheckBox = this.createPrintLevelCheckBox();
        jComboBox.addItemListener((DOMButtonModel)jCheckBox.getModel());
        this.add((Component)jCheckBox, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        DOMComboBoxController dOMComboBoxController = new DOMComboBoxController(this.mDocument, LOG_ROOT, SINGLE_LOGGER);
        jComboBox.addItemListener(dOMComboBoxController);
        this.add((Component)this.createMinLogLevelCombo(dOMComboBoxController), gridBagConstraints);
        gridBagConstraints.gridy = 2;
        this.add((Component)this.createMinScreenLogLevelCombo(dOMComboBoxController), gridBagConstraints);
        jComboBox.setSelectedIndex(-1);
        if (jComboBox.getModel().getSize() > 0) {
            jComboBox.setSelectedIndex(0);
        }
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 13;
        JButton jButton = this.createOKButton();
        this.add((Component)jButton, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.anchor = 17;
        JButton jButton2 = this.createCancelButton();
        this.add((Component)jButton2, gridBagConstraints);
        return true;
    }

    private JButton createOKButton() {
        JButton jButton = new JButton();
        jButton.setToolTipText("Save the current changes.");
        jButton.setText("OK");
        final LogEditor logEditor = this;
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DOMUtils.serialize(LogEditor.this.mDocument, logEditor);
                logEditor.getTopLevelAncestor().setVisible(false);
            }
        });
        return jButton;
    }

    private JButton createCancelButton() {
        JButton jButton = new JButton();
        jButton.setToolTipText("Discard the current changes.");
        jButton.setText("Cancel");
        final LogEditor logEditor = this;
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                logEditor.getTopLevelAncestor().setVisible(false);
            }
        });
        return jButton;
    }

    private JComboBox createLoggerSelecter() {
        JComboBox jComboBox = new JComboBox(new DOMComboBoxModel(this.mDocument, null, LOG_ROOT, null));
        jComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                    Logger.global.log(Level.WARNING, "Item listener was interrupted, repainting UI.");
                }
                LogEditor.this.repaint();
            }
        });
        return jComboBox;
    }

    private JComboBox createMinLogLevelCombo(DOMComboBoxController dOMComboBoxController) {
        JComboBox jComboBox = dOMComboBoxController.createComboBox(LEVEL_STRINGS, MIN_LOG_LEVEL);
        jComboBox.setToolTipText(Messages.getString("ConfigurationEditor.87"));
        return jComboBox;
    }

    private JComboBox createMinScreenLogLevelCombo(DOMComboBoxController dOMComboBoxController) {
        JComboBox jComboBox = dOMComboBoxController.createComboBox(LEVEL_STRINGS, MIN_SCREEN_LEVEL);
        jComboBox.setToolTipText(Messages.getString("ConfigurationEditor.92"));
        return jComboBox;
    }

    private JCheckBox createPrintLevelCheckBox() {
        JCheckBox jCheckBox = new JCheckBox();
        DOMButtonModel dOMButtonModel = new DOMButtonModel(this.mDocument, "/LoggerFactory/Logger", PRINT_LEVEL, "", true);
        jCheckBox.setModel(dOMButtonModel);
        this.addPropertyChangeListener("document-replaced", dOMButtonModel);
        jCheckBox.setMnemonic(87);
        jCheckBox.setHorizontalTextPosition(2);
        jCheckBox.setToolTipText(Messages.getString("ConfigurationEditor.95"));
        return jCheckBox;
    }

    private Document loadDocument() {
        Logger.global.log(Level.INFO, "Loading log configuration document.");
        Properties properties = FileUtils.getInitializedProperties(this);
        String string = properties.getProperty("log-conf-path");
        if (string == null) {
            JOptionPane.showMessageDialog(this, "You must set the path to the log configuration file under Edit->Preferences before you can edit the file.", "Log configuration file path unset", 0);
            return null;
        }
        final Document document = FileUtils.loadDocument(new File(string), LOG_ROOT);
        if (document != null) {
            this.addPropertyChangeListener(new DOMDocumentSaveSetter(document));
            EventTarget eventTarget = (EventTarget)((Object)document.getDocumentElement());
            eventTarget.addEventListener("DOMSubtreeModified", new EventListener(){

                @Override
                public void handleEvent(Event event) {
                    LogEditor.this.firePropertyChange("document-modified", FileUtils.isDirty(document), true);
                }
            }, false);
        }
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Document getDocument() {
        LogEditor logEditor = this;
        synchronized (logEditor) {
            return this.mDocument;
        }
    }

    @Override
    public boolean askBeforeSaving() {
        return false;
    }
}

