/*
 * Decompiled with CFR 0.152.
 */
package ModelInterface.ConfigurationEditor.configurationeditor;

import ModelInterface.ConfigurationEditor.actions.EditLogSettingsAction;
import ModelInterface.ConfigurationEditor.actions.LoadAction;
import ModelInterface.ConfigurationEditor.actions.NewAction;
import ModelInterface.ConfigurationEditor.actions.QuitAction;
import ModelInterface.ConfigurationEditor.actions.RunAction;
import ModelInterface.ConfigurationEditor.actions.SaveAction;
import ModelInterface.ConfigurationEditor.actions.ShowPreferencesAction;
import ModelInterface.ConfigurationEditor.configurationeditor.AdvancedOptionsPanel;
import ModelInterface.ConfigurationEditor.configurationeditor.BatchOptionsPanel;
import ModelInterface.ConfigurationEditor.configurationeditor.DOMDocumentEditor;
import ModelInterface.ConfigurationEditor.configurationeditor.MainOptionsPanel;
import ModelInterface.ConfigurationEditor.guihelpers.ComponentEnabler;
import ModelInterface.ConfigurationEditor.guihelpers.DOMDocumentSaveSetter;
import ModelInterface.ConfigurationEditor.guihelpers.SaveEnabler;
import ModelInterface.ConfigurationEditor.utils.FileUtils;
import ModelInterface.ConfigurationEditor.utils.Messages;
import ModelInterface.InterfaceMain;
import ModelInterface.MenuAdder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.events.MutationEvent;

public class ConfigurationEditor
extends JFrame
implements DOMDocumentEditor,
MenuAdder {
    private static final long serialVersionUID = -4743689341303656460L;
    static final String ELEMENT_NAME = "Value";
    public static final String ROOT_ELEMENT_NAME = "Configuration";
    private static int EDIT_CONFIGURATION_MENUITEM_POS = 19;
    private transient Document mCurrentDocument = null;

    public ConfigurationEditor() {
        this.initialize();
    }

    private void initialize() {
        this.setJMenuBar(this.createMainMenuBar());
        this.setName(Messages.getString("ConfigurationEditor.0"));
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new QuitAction(this));
        this.setContentPane(this.createMainWindow());
        this.setTitle(Messages.getString("ConfigurationEditor.1"));
        this.firePropertyChange("document-replaced", "unknown", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDocument(Document document) {
        Document document2 = this.mCurrentDocument;
        Document document3 = document;
        synchronized (document3) {
            this.mCurrentDocument = document;
        }
        this.addDocumentListeners(this.mCurrentDocument);
        this.firePropertyChange("document-replaced", document2, this.mCurrentDocument);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public synchronized void run() {
                ConfigurationEditor.this.repaint();
            }
        });
    }

    private void addDocumentListeners(final Document document) {
        PropertyChangeListener[] propertyChangeListenerArray = this.getPropertyChangeListeners("document-modified");
        for (int i = 0; i < propertyChangeListenerArray.length; ++i) {
            this.removePropertyChangeListener("document-modified", propertyChangeListenerArray[i]);
        }
        if (document != null) {
            this.addPropertyChangeListener("document-modified", new DOMDocumentSaveSetter(document));
            EventTarget eventTarget = (EventTarget)((Object)document);
            eventTarget.addEventListener("DOMAttrModified", new EventListener(){

                @Override
                public void handleEvent(Event event) {
                    MutationEvent mutationEvent = (MutationEvent)event;
                    if (mutationEvent.getAttrName().equals("document-saved") && mutationEvent.getAttrChange() == 2) {
                        ConfigurationEditor.this.firePropertyChange("document-saved", false, true);
                        document.getDocumentElement().removeAttribute("document-saved");
                    }
                }
            }, false);
            eventTarget.addEventListener("DOMSubtreeModified", new EventListener(){

                @Override
                public void handleEvent(Event event) {
                    MutationEvent mutationEvent = (MutationEvent)event;
                    if (mutationEvent.getRelatedNode().equals(document.getDocumentElement())) {
                        System.out.println("Ignoring event on root.");
                    } else {
                        System.out.println("Firing document modified");
                        ConfigurationEditor.this.firePropertyChange("document-modified", FileUtils.isDirty(document), true);
                    }
                }
            }, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Document getDocument() {
        ConfigurationEditor configurationEditor = this;
        synchronized (configurationEditor) {
            return this.mCurrentDocument;
        }
    }

    @Override
    public boolean askBeforeSaving() {
        return true;
    }

    @Override
    public void addMenuItems(InterfaceMain.MenuManager menuManager) {
        JMenuItem jMenuItem = new JMenuItem("Configuration...");
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConfigurationEditor.this.pack();
                ConfigurationEditor.this.setVisible(true);
            }
        });
        menuManager.getSubMenuManager(1).addMenuItem(jMenuItem, EDIT_CONFIGURATION_MENUITEM_POS);
    }

    private JPanel createMainWindow() {
        JPanel jPanel = new JPanel();
        jPanel.setToolTipText(Messages.getString("ConfigurationEditor.3"));
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.createMainToolBar(), "North");
        jPanel.add((Component)this.createTabContainer(), "South");
        return jPanel;
    }

    private JTabbedPane createTabContainer() {
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.setToolTipText(Messages.getString("ConfigurationEditor.4"));
        MainOptionsPanel mainOptionsPanel = new MainOptionsPanel();
        this.addPropertyChangeListener(mainOptionsPanel);
        jTabbedPane.addTab(Messages.getString("ConfigurationEditor.5"), null, mainOptionsPanel, Messages.getString("ConfigurationEditor.6"));
        BatchOptionsPanel batchOptionsPanel = new BatchOptionsPanel();
        this.addPropertyChangeListener(batchOptionsPanel);
        jTabbedPane.addTab(Messages.getString("ConfigurationEditor.110"), null, batchOptionsPanel, Messages.getString("ConfigurationEditor.111"));
        AdvancedOptionsPanel advancedOptionsPanel = new AdvancedOptionsPanel();
        this.addPropertyChangeListener(advancedOptionsPanel);
        jTabbedPane.addTab(Messages.getString("ConfigurationEditor.7"), null, advancedOptionsPanel, Messages.getString("ConfigurationEditor.8"));
        return jTabbedPane;
    }

    private JToolBar createMainToolBar() {
        JToolBar jToolBar = new JToolBar();
        jToolBar.setToolTipText(Messages.getString("ConfigurationEditor.19"));
        jToolBar.add(this.createNewButton());
        jToolBar.add(this.createLoadButton());
        jToolBar.add(this.createSaveButton());
        jToolBar.add(this.createRunButton());
        return jToolBar;
    }

    private JMenuBar createMainMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.setToolTipText(Messages.getString("ConfigurationEditor.21"));
        jMenuBar.add(this.createFileMenu());
        jMenuBar.add(this.createEditMenu());
        jMenuBar.add(this.createHelpMenu());
        return jMenuBar;
    }

    private JMenu createFileMenu() {
        JMenu jMenu = new JMenu(Messages.getString("ConfigurationEditor.24"));
        jMenu.setName("FileMenu");
        jMenu.setToolTipText(Messages.getString("ConfigurationEditor.25"));
        jMenu.setMnemonic(70);
        jMenu.add(this.createNewMenuItem());
        jMenu.add(this.createLoadMenuItem());
        jMenu.add(this.createSaveMenuItem());
        jMenu.add(this.createSaveAsMenuItem());
        jMenu.add(this.createRunMenuItem());
        jMenu.add(this.createQuitMenuItem());
        return jMenu;
    }

    private JButton createSaveButton() {
        JButton jButton = new JButton();
        jButton.setActionCommand("Save");
        jButton.setAction(new SaveAction(this));
        jButton.setName("SaveDocumentButton");
        jButton.setToolTipText(Messages.getString("ConfigurationEditor.29"));
        jButton.setText(Messages.getString("ConfigurationEditor.30"));
        this.addPropertyChangeListener(new SaveEnabler(jButton));
        return jButton;
    }

    private JButton createNewButton() {
        JButton jButton = new JButton(Messages.getString("ConfigurationEditor.32"));
        jButton.setName("NewDocumentButton");
        jButton.setAction(new NewAction());
        jButton.setToolTipText(Messages.getString("ConfigurationEditor.33"));
        jButton.setMnemonic(78);
        return jButton;
    }

    private JButton createLoadButton() {
        JButton jButton = new JButton(Messages.getString("ConfigurationEditor.36"));
        jButton.setAction(new LoadAction());
        jButton.setName("LoadDocumentButton");
        jButton.setToolTipText(Messages.getString("ConfigurationEditor.37"));
        jButton.setMnemonic(79);
        return jButton;
    }

    private JButton createRunButton() {
        JButton jButton = new JButton(Messages.getString("ConfigurationEditor.38"));
        jButton.setName("RunModelButton");
        jButton.setAction(new RunAction(this));
        jButton.setMnemonic(82);
        jButton.setToolTipText(Messages.getString("ConfigurationEditor.39"));
        this.addPropertyChangeListener("document-replaced", new ComponentEnabler(jButton));
        return jButton;
    }

    private JMenuItem createQuitMenuItem() {
        JMenuItem jMenuItem = new JMenuItem(Messages.getString("ConfigurationEditor.41"));
        jMenuItem.setName("QuitMenuItem");
        jMenuItem.setAction(new QuitAction(this));
        jMenuItem.setMnemonic(81);
        jMenuItem.setToolTipText(Messages.getString("ConfigurationEditor.42"));
        return jMenuItem;
    }

    private JMenuItem createNewMenuItem() {
        JMenuItem jMenuItem = new JMenuItem(Messages.getString("ConfigurationEditor.44"));
        jMenuItem.setName("NewMenuItem");
        jMenuItem.setAction(new NewAction());
        jMenuItem.setMnemonic(78);
        jMenuItem.setToolTipText(Messages.getString("ConfigurationEditor.45"));
        return jMenuItem;
    }

    private JMenuItem createLoadMenuItem() {
        JMenuItem jMenuItem = new JMenuItem(Messages.getString("ConfigurationEditor.48"));
        jMenuItem.setName("LoadMenuItem");
        jMenuItem.setAction(new LoadAction());
        jMenuItem.setToolTipText(Messages.getString("ConfigurationEditor.49"));
        jMenuItem.setMnemonic(79);
        return jMenuItem;
    }

    private JMenuItem createSaveMenuItem() {
        JMenuItem jMenuItem = new JMenuItem();
        jMenuItem.setName("SaveMenuItem");
        jMenuItem.setActionCommand("Save");
        jMenuItem.setMnemonic(83);
        jMenuItem.setAction(new SaveAction(this));
        jMenuItem.setToolTipText(Messages.getString("ConfigurationEditor.50"));
        jMenuItem.setText(Messages.getString("ConfigurationEditor.51"));
        this.addPropertyChangeListener("document-replaced", new SaveEnabler(jMenuItem));
        return jMenuItem;
    }

    private JMenuItem createSaveAsMenuItem() {
        JMenuItem jMenuItem = new JMenuItem();
        jMenuItem.setName("SaveAsMenuItem");
        jMenuItem.setAction(new SaveAction(this));
        jMenuItem.setToolTipText(Messages.getString("ConfigurationEditor.54"));
        jMenuItem.setActionCommand("SaveAs");
        jMenuItem.setMnemonic(65);
        jMenuItem.setText(Messages.getString("ConfigurationEditor.53"));
        this.addPropertyChangeListener("document-replaced", new ComponentEnabler(jMenuItem));
        return jMenuItem;
    }

    private JMenuItem createRunMenuItem() {
        JMenuItem jMenuItem = new JMenuItem(Messages.getString("ConfigurationEditor.56"));
        jMenuItem.setName("RunMenuItem");
        jMenuItem.setAction(new RunAction(this));
        jMenuItem.setToolTipText(Messages.getString("ConfigurationEditor.57"));
        jMenuItem.setMnemonic(82);
        this.addPropertyChangeListener("document-replaced", new ComponentEnabler(jMenuItem));
        return jMenuItem;
    }

    private JMenu createEditMenu() {
        JMenu jMenu = new JMenu(Messages.getString("ConfigurationEditor.73"));
        jMenu.setMnemonic(69);
        jMenu.setToolTipText(Messages.getString("ConfigurationEditor.74"));
        jMenu.add(this.createPreferencesMenuItem());
        jMenu.add(this.createEditLogsMenuItem());
        return jMenu;
    }

    private JMenuItem createPreferencesMenuItem() {
        JMenuItem jMenuItem = new JMenuItem(Messages.getString("ConfigurationEditor.77"));
        jMenuItem.setActionCommand("ShowPreferences");
        jMenuItem.setAction(new ShowPreferencesAction(this));
        jMenuItem.setToolTipText(Messages.getString("ConfigurationEditor.78"));
        jMenuItem.setMnemonic(80);
        return jMenuItem;
    }

    private JMenuItem createEditLogsMenuItem() {
        JMenuItem jMenuItem = new JMenuItem(Messages.getString("ConfigurationEditor.136"));
        jMenuItem.setAction(new EditLogSettingsAction());
        jMenuItem.setToolTipText(Messages.getString("ConfigurationEditor.137"));
        jMenuItem.setMnemonic(76);
        return jMenuItem;
    }

    private JMenu createHelpMenu() {
        JMenu jMenu = new JMenu(Messages.getString("ConfigurationEditor.100"));
        jMenu.setMnemonic(72);
        jMenu.setToolTipText(Messages.getString("ConfigurationEditor.101"));
        return jMenu;
    }

    public void dispatchSave() {
        new SaveAction(this).actionPerformed(new ActionEvent(this, 1001, Messages.getString("ConfigurationEditor.103")));
    }
}

