/*
 * Decompiled with CFR 0.152.
 */
package ModelInterface.ConfigurationEditor.configurationeditor;

import ModelInterface.ConfigurationEditor.configurationeditor.AbstractEditorPanel;
import ModelInterface.ConfigurationEditor.configurationeditor.DOMDocumentEditor;
import ModelInterface.ConfigurationEditor.guicomponents.DOMListModel;
import ModelInterface.ConfigurationEditor.guicomponents.DOMListPanel;
import ModelInterface.ConfigurationEditor.guicomponents.DOMListPanelFactory;
import ModelInterface.ConfigurationEditor.utils.DOMUtils;
import ModelInterface.ConfigurationEditor.utils.FileUtils;
import ModelInterface.ConfigurationEditor.utils.Messages;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import org.w3c.dom.Document;

public class BatchFileEditor
extends AbstractEditorPanel
implements DOMDocumentEditor {
    private static final long serialVersionUID = 5932800223359767162L;
    private transient Document mDocument = null;
    private static final String ROOT_ELEMENT_NAME = "ComponentSets";

    public BatchFileEditor(String string, boolean bl) {
        this.initialize(string, bl);
    }

    public boolean isValidEditor() {
        return this.mDocument != null;
    }

    @Override
    public Document getDocument() {
        return this.mDocument;
    }

    @Override
    public boolean askBeforeSaving() {
        return false;
    }

    private void initializeUI() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = -1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 10;
        DOMListPanelFactory dOMListPanelFactory = new DOMListPanelFactory();
        this.addPropertyChangeListener("document-replaced", dOMListPanelFactory);
        JPanel jPanel = this.createRightPanel(dOMListPanelFactory);
        JPanel jPanel2 = this.createMiddlePanel(jPanel, dOMListPanelFactory);
        JPanel jPanel3 = this.createLeftPanel(jPanel2, dOMListPanelFactory);
        this.add((Component)jPanel3, gridBagConstraints);
        this.add((Component)jPanel2, gridBagConstraints);
        ((DOMListModel)((DOMListPanel)jPanel2).getList(null).getModel()).setParentList(((DOMListPanel)jPanel3).getList(null));
        ((DOMListModel)((DOMListPanel)jPanel).getList(null).getModel()).setParentList(((DOMListPanel)jPanel2).getList(null));
        gridBagConstraints.gridwidth = 2;
        this.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 13;
        JButton jButton = new JButton();
        jButton.setToolTipText(Messages.getString("BatchFileEditor.10"));
        jButton.setText(Messages.getString("BatchFileEditor.11"));
        final BatchFileEditor batchFileEditor = this;
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DOMUtils.serialize(BatchFileEditor.this.mDocument, batchFileEditor);
                ((JDialog)batchFileEditor.getTopLevelAncestor()).dispose();
            }
        });
        this.add((Component)jButton, gridBagConstraints);
        JButton jButton2 = new JButton();
        jButton2.setToolTipText(Messages.getString("BatchFileEditor.8"));
        jButton2.setText(Messages.getString("BatchFileEditor.9"));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ((JDialog)batchFileEditor.getTopLevelAncestor()).dispose();
            }
        });
        gridBagConstraints.gridx = 4;
        this.add((Component)jButton2, gridBagConstraints);
    }

    private JPanel createLeftPanel(JPanel jPanel, DOMListPanelFactory dOMListPanelFactory) {
        DOMListPanel dOMListPanel = dOMListPanelFactory.createDOMFileListPanel("/ComponentSets", "ComponentSet", "Component Sets", false);
        dOMListPanel.getList(null).addListSelectionListener((DOMListModel)((DOMListPanel)jPanel).getList(null).getModel());
        dOMListPanel.getList(null).getModel().addListDataListener((DOMListModel)((DOMListPanel)jPanel).getList(null).getModel());
        return dOMListPanel;
    }

    private JPanel createMiddlePanel(JPanel jPanel, DOMListPanelFactory dOMListPanelFactory) {
        DOMListPanel dOMListPanel = dOMListPanelFactory.createDOMFileListPanel("ComponentSet", "FileSet", "File Sets", false);
        dOMListPanel.getList(null).addListSelectionListener((DOMListModel)((DOMListPanel)jPanel).getList(null).getModel());
        dOMListPanel.getList(null).getModel().addListDataListener((DOMListModel)((DOMListPanel)jPanel).getList(null).getModel());
        return dOMListPanel;
    }

    private JPanel createRightPanel(DOMListPanelFactory dOMListPanelFactory) {
        DOMListPanel dOMListPanel = dOMListPanelFactory.createDOMFileListPanel("FileSet", Messages.getString("BatchFileEditor.19"), Messages.getString("BatchFileEditor.20"), true);
        return dOMListPanel;
    }

    private void initialize(String string, boolean bl) {
        this.initializeUI();
        File file = new File(string);
        this.mDocument = bl ? FileUtils.createDocument(this.getTopLevelAncestor(), file, ROOT_ELEMENT_NAME) : FileUtils.loadDocument(file, ROOT_ELEMENT_NAME);
        this.firePropertyChange("document-replaced", null, this.mDocument);
    }
}

