/*
 * Decompiled with CFR 0.152.
 */
package ModelInterface.ConfigurationEditor.actions;

import ModelInterface.ConfigurationEditor.configurationeditor.ConfigurationEditor;
import ModelInterface.ConfigurationEditor.guihelpers.XMLFileFilter;
import ModelInterface.ConfigurationEditor.utils.DOMUtils;
import ModelInterface.ConfigurationEditor.utils.FileUtils;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import org.w3c.dom.Document;

public class SaveAction
extends AbstractAction {
    private static final long serialVersionUID = 7682523793575123303L;
    private final transient ConfigurationEditor mParentEditor;

    public SaveAction(ConfigurationEditor configurationEditor) {
        super("Save");
        this.mParentEditor = configurationEditor;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("Save")) {
            File file = FileUtils.getDocumentFile(this.mParentEditor.getDocument());
            if (file == null) {
                this.doSaveAs();
            } else {
                this.doSave();
            }
        } else if (actionEvent.getActionCommand().equals("SaveAs")) {
            this.doSaveAs();
        } else assert (false);
    }

    private void doSave() {
        Document document = this.mParentEditor.getDocument();
        assert (document != null);
        DOMUtils.serialize(document, this.mParentEditor);
    }

    private void doSaveAs() {
        File file = FileUtils.selectFile(this.mParentEditor, new XMLFileFilter(), null, true);
        if (file != null) {
            FileUtils.setDocumentFile(this.mParentEditor.getDocument(), file);
            this.doSave();
        }
    }
}

