## 1.PCA

![img](https://img-blog.csdn.net/20180116192813738?watermark/2/text/aHR0cDovL2Jsb2cuY3Nkbi5uZXQvZHVndWRhaWJv/font/5a6L5L2T/fontsize/400/fill/I0JBQkFCMA==/dissolve/70/gravity/SouthEast)

将输入乘以一个权重矩阵W得到降维之后的结果。之后将降维之后的数据c乘以权重矩阵的转置，恢复得到近似原始图像。在这个过程中，我们希望输入层与输出层之间的图像越相似越好。

![img](https://img-blog.csdn.net/20180116193612608?watermark/2/text/aHR0cDovL2Jsb2cuY3Nkbi5uZXQvZHVndWRhaWJv/font/5a6L5L2T/fontsize/400/fill/I0JBQkFCMA==/dissolve/70/gravity/SouthEast)

这个过程也已通过NN的方式实现，其中 Input layer 到 hidden layer 的过程是编码（encode）过程，而从 hidden layer 到 Output layer 的过程是解码的过程（decode）。因为 hidden layer 得到的结果往往会比原始的维数小，就像一个瓶子的瓶颈一样狭窄，所以也将 hidden layer 称为 bottleneck layer 。


其中有两点需要注意，首先这里认为前后的权重矩阵是对称的，然而不是对称的也没过关系，因为用的是NN的方法而不是PCA的方法，不必满足前后的对称；其次这个模型原先需要采用RBM的方法逐层初始化，以现在训练NN的技术也可以不用了，所以上面的训练过程和一般的神经网络并没有什么区别。

![img](https://img-blog.csdn.net/20180116194847614?watermark/2/text/aHR0cDovL2Jsb2cuY3Nkbi5uZXQvZHVndWRhaWJv/font/5a6L5L2T/fontsize/400/fill/I0JBQkFCMA==/dissolve/70/gravity/SouthEast)

我们可以看到都是编码到30维之后再进行解码，深度自编码器的效果比PCA的效果要好很多。其中有一点需要注意，在使用神经网络的时候，第一个隐层的神经元的个数是多于输入层神经元的个数。

![img](https://img-blog.csdn.net/20180116195716025?watermark/2/text/aHR0cDovL2Jsb2cuY3Nkbi5uZXQvZHVndWRhaWJv/font/5a6L5L2T/fontsize/400/fill/I0JBQkFCMA==/dissolve/70/gravity/SouthEast)

可以看到PCA得到的结果将不同种类的数据区分的不是很开，而深度自编码器可以将数据区分的比较开。但是与之前的t-SNE相比还是有一定差距的。

## 2.文字检索或图片检索

将图片或者文字进行深度自编码之后，将它们编码的结果作为它们的特征，将输入的图像或者文字经过同样的编码，在编码后的空间比较相似性，完成文字搜索或者图片搜索。

## 3.预训练DNN

![img](https://img-blog.csdn.net/20180116200559377?watermark/2/text/aHR0cDovL2Jsb2cuY3Nkbi5uZXQvZHVndWRhaWJv/font/5a6L5L2T/fontsize/400/fill/I0JBQkFCMA==/dissolve/70/gravity/SouthEast)

左侧是我们最终希望得到的网络，右边是我进行与训练方法的第一步。我们将数据进行自编码，注意，这里的隐层的神经元的数量远远高于，所以要防止网络根本没有训练，直接将数据传到隐层再传到输出层的情况，所以在训练这一层的时候可以加入一项较大的 L1L1 惩罚项，使得权重只有部分有数值，强迫网络进行学习。这层收敛之后进入下一层的训练，方法如下


## 5. CNN自编码器

![img](https://img-blog.csdn.net/20180116203957978?watermark/2/text/aHR0cDovL2Jsb2cuY3Nkbi5uZXQvZHVndWRhaWJv/font/5a6L5L2T/fontsize/400/fill/I0JBQkFCMA==/dissolve/70/gravity/SouthEast)

在这里如果将右侧的部分认是编码的过程的话，在编码的过程中涉及到卷积和池化，所以再解码的过程中涉及到上采样和反卷积。上采样的一种方法如下图所示。

![img](https://img-blog.csdn.net/20180116204321725?watermark/2/text/aHR0cDovL2Jsb2cuY3Nkbi5uZXQvZHVndWRhaWJv/font/5a6L5L2T/fontsize/400/fill/I0JBQkFCMA==/dissolve/70/gravity/SouthEast)

它在每一次的下采样中都记住 maxpooling 所取的最大值的位置，然后在后恢复的过程中将最大值的那个位置仍取最大值，将剩下的位置置零；另一种方法是直接将最大值repeat到四个位置，不用记住位置。

而反卷积的过程实际上就是一个卷积的过程，我们以一维的卷积为例进行说明

![img](https://img-blog.csdn.net/20180116205342511?watermark/2/text/aHR0cDovL2Jsb2cuY3Nkbi5uZXQvZHVndWRhaWJv/font/5a6L5L2T/fontsize/400/fill/I0JBQkFCMA==/dissolve/70/gravity/SouthEast)

如左图所示是一个一维卷积的例子，我们可以看到经过三个卷积核之后，数据由5维降低至3维，所以如果想得到原来的效果就应该如中间图那样进行计算，每一个神经元伸出去三个权重，得到的位置重叠的结果进行相加，这个过程实际上等同与右侧的过程，但是需要进行补零，所以反卷积的过程实际上就是卷积。

## 7.小节

总体来讲深度自编码器的实现方式主要有两种，一种是通过NN实现，另一种是通过CNN实现。

  它的应用主要有一下几个方面：
  （１）最原始的功能：编码和解码
  （2）对数据进行降维，并将它们区分开来，效果虽然明显好于PCA的方法，但是也明显差于t-SNE的方法。
  （3）抽取图像的特征，这个是一种很通用的方法，不仅仅能抽取有label数据的特征，还可以抽取没有label数据的特征，得到特征之后可以计算之间的相似性（如进行图像，文本的检索），或者进行其他的下一步的操作
  （4）预训练网络。这一点现在不常用于预训练网络，而是首先通过无标签的数据进行预训练得到初始权重，再用有标签的数据进行finetune。
  （5）图像去噪或者增强模型的抗噪声鲁棒性
  （6）生成数据或者图像（但是不知道具体有什么用……）
————————————————
版权声明：本文为CSDN博主「独孤呆博」的原创文章，遵循CC 4.0 BY-SA版权协议，转载请附上原文出处链接及本声明。
原文链接：https://blog.csdn.net/dugudaibo/article/details/79078264