[TOC]



## Information from Wiki

信息论是对信息的量化，存储和交流的科学研究。 该领域是由1920年代的Harry Nyquist和Ralph Hartley以及1940年代的Claude Shannon的作品建立的。 该领域处于概率论，统计学，计算机科学，统计力学，信息工程和电气工程的交叉领域。

Information theory is the scientific study of the quantification, storage, and communication of information. The field was fundamentally established by the works of Harry Nyquist and Ralph Hartley, in the 1920s, and Claude Shannon in the 1940s. The field is at the intersection of probability theory, statistics, computer science, statistical mechanics, information engineering, and electrical engineering.

信息论中的关键指标是熵。 熵量化了随机变量的值或随机过程的结果中涉及的不确定性量。 例如，与通过掷骰子（具有六个同样可能的结果）指定结果相比，识别公平硬币翻转的结果（具有两个可能的结果）所提供的信息较少（熵较低）。 信息论中的其他重要指标是互信息，信道容量，错误指数和相对熵。 信息论的重要子领域包括源代码，算法复杂性理论，算法信息论和信息理论安全性。

A key measure in information theory is entropy. Entropy quantifies the amount of uncertainty involved in the value of a random variable or the outcome of a random process. For example, identifying the outcome of a fair coin flip (with two equally likely outcomes) provides less information (lower entropy) than specifying the outcome from a roll of a die (with six equally likely outcomes). Some other important measures in information theory are mutual information, channel capacity, error exponents, and relative entropy. Important sub-fields of information theory include source coding, algorithmic complexity theory, algorithmic information theory, and information-theoretic security.

信息论基本主题的应用包括无损数据压缩（例如ZIP文件），有损数据压缩（例如MP3和JPEG）和信道编码（例如DSL）。 它的影响对于旅行者号深空飞行任务的成功，光盘的发明，移动电话的可行性以及互联网的发展至关重要。 该理论还发现了其他领域的应用，包括统计推断，[1]密码学，神经生物学，[2]感知，[3]语言学，分子代码（生物信息学）的发展[4]和功能[5]，热物理学。 ，[6]量子计算，黑洞，信息检索，情报收集，窃检测，[7]模式识别，异常检测[8]甚至艺术创作。

Applications of fundamental topics of information theory include lossless data compression (e.g. ZIP files), lossy data compression (e.g. MP3s and JPEGs), and channel coding (e.g. for DSL). Its impact has been crucial to the success of the Voyager missions to deep space, the invention of the compact disc, the feasibility of mobile phones and the development of the Internet. The theory has also found applications in other areas, including statistical inference,[1] cryptography, neurobiology,[2] perception,[3] linguistics, the evolution[4] and function[5] of molecular codes (bioinformatics), thermal physics,[6] quantum computing, black holes, information retrieval, intelligence gathering, plagiarism detection,[7] pattern recognition, anomaly detection[8] and even art creation.

## Information Content自信息和信息熵

1. 一个概率为100%的事件不包含信息
2. 事件的概率越小，包含的信息越多
3. 若两个独立事件分别被测量，总共的信息是每个事件的自信息之和

仅有一个确定的概率函数满足以上三条定理，乘以一个scaling factor。x服从概率分布P，则Information Content定义为：
$$
I(x):=-lob_b|Pr(x)|=-log_b(P)
$$
log函数的底由上面的scaling factor决定不同的选择对应信息的不同单元，若2，单元定义为“位”或“香农”

通常一个信号源发出什么符号是不确定的，可以根据其出现的概率进行度量。概率大，出现的机会多，不确定小。在极限条件下，一个信号源仅发出一种符号，内容是确定的，即概率为100%，但接收方无法从接受信号中获取任何信息，信息量为0。

给定X服从P概率分布，X输出为x时的自信息定义为：
$$
I(x):=-log|P_X(x)|=log(\frac{1}{P_X(x)})
$$
仅有自信息只能衡量一个输出，信息熵可以定量描述信息的大小。X的信息熵定义为：
$$
H(X)=\sum_x-P_X(x)logP_X(x)=\sum_xP_X(x)I_X(x)
$$


## Conditional and joint entropy

### joint entropy

一族变量的不确定性度量。

#### 定义

$$
H(X,Y)=-\sum_x\sum_yP(x,y)log2|P(x,y)|\\
H(X_1,...,X_n)=\sum_{x_1}...\sum_{x_n}P(x_1,...,x_n)log_2[P(x_1,...,x_n)]
$$

#### 性质

$$
H(X,Y)>=max[H(X),H(Y)]
H(X,Y)<=H(X)+H(Y)
$$

#### 相关

$$
H(X|Y)=H(X,Y)-H(Y)\\
I(X;Y)=H(X)+H(Y)-H(X,Y)
$$

### Conditional entropy

$$
H(Y|X)=-\sum_{x\in X,y\in Y}P(x,y)log{\frac{P(x,y)}{P(x)}}
$$

#### Chain rule

$$
H(X|Y)=H(X,Y)-H(Y)\\
$$

#### Bayes rule

$$
H(Y|X)=H(X|Y)-H(X)+H(Y)
$$



## Mutual Information from wiki

在概率论和信息论中，两个随机变量的互信息（MI）是**两个变量之间相互依赖的度量**。 更具体地，它通过观察另一随机变量来量化关于一个随机变量获得的“信息量”（以诸如香农（Shannon），通常称为比特）为单位。 互信息的概念与随机变量的熵紧密相关，熵是信息理论中的基本概念，它量化了随机变量中预期的“信息量”。

In probability theory and information theory, the mutual information (MI) of two random variables is a measure of the mutual dependence between the two variables. More specifically, it quantifies the "amount of information" (in units such as shannons, commonly called bits) obtained about one random variable through observing the other random variable. The concept of mutual information is intimately linked to that of entropy of a random variable, a fundamental notion in information theory that quantifies the expected "amount of information" held in a random variable.

不同于相关系数囿于实值随机变量和线性相关性，MI更通用，**它决定了（X，Y）对的联合分布与的X和Y的边际分布的乘积有多大差异 。 MI是逐点共有信息（PMI）的期望值。** 

克劳德·香农（Claude Shannon）在他的里程碑式论文《A Mathematical Theory of Communication》中定义并分析了数量，尽管他没有将其称为“互信息”。 这个词后来由罗伯特·法诺（Robert Fano）创造。[1] MI也称为信息获取。

### 定义

$$
(X,Y)是一对随机变量，如果它们的联合概率分布为P_{(X,Y)}，边缘概率分布分别为P_X,P_Y。\\
它们之间的互信息定义为：\\
I(X;Y)=D_{KL}(P_{(X,Y)}||P_X\bullet P_Y)\\
其中D_{KL}是KL散度。注意KL散度中一个重要的性质，当X和Y相互独立的时候I(X;Y)\\等于0。一般情况下，I(X;Y)是非负的，它是将X和Y编码为一对独立随机变量的代价\\的度量。
$$

直观来讲，互信息度量了X和Y的共享信息，它度量了知道其中一个变量能减少多少关于另一个变量的不确定性。例如，若X和Y有确定的函数关系，则互信息等于X（或Y）中包含的不确定信息的量，称为X（或Y）的熵。

互信息是在独立假设下，相对于X和Y的边缘分布，以联合概率分布表示的内在依赖的度量。

#### 离散分布的互信息

$$
I(X;Y)=\sum_{y\in Y}\sum_{x\in X}P_{X,Y}(x,y)log(\frac{P_{X,Y}(x,y)}{P_X(x)P_Y(y)})
$$

### 和其他量的联系

#### 与条件和联合熵的联系

$$
I(X;Y)\equiv H(X)-H(X|Y)\equiv H(Y)-H(Y|X)\\

$$

#### 与KL散度的关系、

$$
I(X;Y)=D_{KL}(P_{X,Y}||P_XP_Y)\\
I(X;Y)=E_Y[D_{KL}(P_{X|Y}||P_X)]
$$



## Entropy and Mutual Information

### 1. Entropy

随机变量的熵是试图表征随机变量的“不可预测性”的函数。 考虑一个代表轮盘赌轮上出现的数字的随机变量X和代表一个公平的6面骰子出现的随机变量Y。 X的熵大于Y的熵。 除了数字1到6，轮盘上的值可以取值7到36。在某种意义上，它的可预测性较差。

The entropy of a random variable is a function which attempts to characterize  the “unpredictability” of a random variable. Consider a random variable X representing the number that comes up on a roulette wheel and a random variable  Y representing the number that comes up on a fair 6-sided die. The entropy of  X is greater than the entropy of Y . In addition to the numbers 1 through 6,  the values on the roulette wheel can take on the values 7 through 36. In some  sense, it is less predictable.

但是，熵不仅仅是关于可能结果的数量。 这也与他们的频率有关。 例如，让Z为加权的六面骰子的结果，该模具在90％的时间内出现“ 2”的情况。 Z的熵比Y的熵低。 从某种意义上说，加权后的骰子容易预测。

But entropy is not just about the number of possible outcomes. It is also about their frequency. For example, let Z be the outcome of a weighted six sided die that comes up 90% of the time as a “2”. Z has lower entropy than Y representing a fair 6-sided die. The weighted die is less unpredictable, in some sense.

但是熵并不是一个模糊的概念。 它具有精确的数学定义。 特别是，如果随机变量X取集合X = {x1，x2，...，xn}中的值，并由概率分布P（X）定义，则我们将写出随机变量的熵 作为

But entropy is not a vague concept. It has a precise mathematical definition. In particular, if a random variable X takes on values in a set X = {x1, x2, ..., xn}, and is defined by a probability distribution P(X), then we will write the entropy of the random variable as
$$
H(X)=-\sum_{x \in X}P(x)log(P(x))\\
或H(P(x))\equiv H(P)\equiv H(X)
$$
如果将上述等式中的对数取为以2为底，则熵以位表示。 如果将对数视为自然对数，则熵以nat表示。 更常见的是，熵以位表示，除非另有说明，否则我们将假设对数以2为底。

If the log in the above equation is taken to be to the base 2, then the entropy is expressed in bits. If the log is taken to be the natural log, then the entropy is expressed in nats. More commonly, entropy is expressed in bits, and unless otherwise noted, we will assume a logarithm with base 2.

### 2. Joint Entropy

联合熵是联合概率分布或多值随机变量的熵。 例如，可能希望知道由头发颜色C和眼睛颜色E定义的人的分布的联合熵，其中C可以从集合C中取4个不同的值，E可以从集合E中取3个值 如果P（E，C）定义了头发颜色和眼睛颜色的联合概率分布，那么我们可以写成它们的联合熵为：

Joint entropy is the entropy of a joint probability distribution, or a multi-valued random variable. For example, one might wish to the know the joint entropy of a distribution of people defined by hair color C and eye color E, where C can take on 4 different values from a set C and E can take on 3 values from a set E. If P(E, C) defines the joint probability distribution of hair color and eye color, then we write that their joint entropy is:
$$
H(E,C)\equiv H(P(E,C))=-\sum_{e\in E}\sum_{c\in C}P(e,c)logP(e,c)
$$

### 3. Mutual Information

互信息是度量同时采样的两个随机变量之间的关系的量。 特别是，它测量平均一个随机变量中有关另一变量的信息交换量。 直觉上，一个人可能会问，一个随机变量告诉我多少有关另一个变量？

Mutual information is a quantity that measures a relationship between two  random variables that are sampled simultaneously. In particular, it measures  how much information is communicated, on average, in one random variable  about another. Intuitively, one might ask, how much does one random variable  tell me about another?

例如，假设X代表6面公平的骰子的掷骰，而Y代表掷骰是否为偶数（偶数为0，奇数为1）。 显然，Y的值告诉我们有关X的值，反之亦然。 也就是说，这些变量共享共同的信息。

For example, suppose X represents the roll of a fair 6-sided die, and Y  represents whether the roll is even (0 if even, 1 if odd). Clearly, the value of Y  tells us something about the value of X and vice versa. That is, these variables  share mutual information.

另一方面，如果X代表一个公平的骰子的掷骰，Z代表另一个公平的骰子的掷骰，则X和Z不会共享任何信息。 一个骰子的掷骰不包含有关另一个骰子结果的任何信息。 信息论中的一个重要定理说，当且仅当两个变量在统计上独立时，两个变量之间的互信息为0

On the other hand, if X represents the roll of one fair die, and Z represents  the roll of another fair die, then X and Z share no mutual information. The roll  of one die does not contain any information about the outcome of the other die.  An important theorem from information theory says that the mutual information between two variables is 0 if and only if the two variables are statistically  independent
$$
I(X;Y)=\sum_{x\in X}\sum_{y\in Y}P(x,y)log{\frac{P(x,y)}{P(x)P(y)}}
$$


