# CNN

卷积神经网络与上一章中的普通神经网络非常相似：它们由具有可学习的权重和偏见的神经元组成。 每个神经元接收一些输入，执行点积，并可选地跟随其非线性。 整个网络仍然表示一个分类的分数函数：从一端的原始图像像素到另一端的类分数。 而且它们仍然具有损失功能（例如SVM

Convolutional Neural Networks are very similar to ordinary Neural Networks from the previous chapter: they are made up of neurons that have learnable weights and biases. Each neuron receives some inputs, performs a dot product and optionally follows it with a non-linearity. The whole network still expresses a single differentiable score function: from the raw image pixels on one end to class scores at the other. And they still have a loss function (e.g. SVM

那有什么变化呢？ ConvNet架构明确假设输入是图像，这使我们可以将某些属性编码到架构中。 这些使前向功能更有效地实现，并大大减少了网络中的参数数量。

So what changes? ConvNet architectures make the explicit assumption that the inputs are images, which allows us to encode certain properties into the architecture. These then make the forward function more efficient to implement and vastly reduce the amount of parameters in the network.

## Architecture Overview

回想一下：常规神经网络。 如上一章所述，神经网络接收输入（单个向量），并通过一系列隐藏层对其进行转换。 每个隐藏层都由一组神经元组成，其中每个神经元都完全连接到上一层中的所有神经元，并且其中单个层中的神经元完全独立地起作用，并且不共享任何连接。 最后一个完全连接的层称为“输出层”，在分类设置中，它表示类别分数。

Recall: Regular Neural Nets. As we saw in the previous chapter, Neural Networks receive an input (a single vector), and transform it through a series of hidden layers. 