# generated by datamodel-codegen:
#   filename:  tezos_storage.json

from __future__ import annotations

from typing import Any
from typing import Dict
from typing import List

from pydantic import BaseModel
from pydantic import Extra


class Key(BaseModel):
    class Config:
        extra = Extra.forbid

    owner: str
    delegate: str


class Delegate(BaseModel):
    class Config:
        extra = Extra.forbid

    key: Key
    value: Dict[str, Any]


class FreezeHistory(BaseModel):
    class Config:
        extra = Extra.forbid

    current_stage_num: str
    current_unstaked: str
    past_unstaked: str
    staked: str


class GovernanceToken(BaseModel):
    class Config:
        extra = Extra.forbid

    address: str
    token_id: str


class ProposalKeyListSortByLevelItem(BaseModel):
    class Config:
        extra = Extra.forbid

    nat: str
    bytes: str


class Key1(BaseModel):
    class Config:
        extra = Extra.forbid

    address: str
    bool: bool


class Voter(BaseModel):
    class Config:
        extra = Extra.forbid

    key: Key1
    value: str


class Proposals(BaseModel):
    class Config:
        extra = Extra.forbid

    downvotes: str
    metadata: str
    proposer: str
    proposer_frozen_token: str
    quorum_threshold: str
    start_level: str
    upvotes: str
    voters: List[Voter]
    voting_stage_num: str


class QuorumThresholdAtCycle(BaseModel):
    class Config:
        extra = Extra.forbid

    last_updated_cycle: str
    quorum_threshold: str
    staked: str


class RegistryStorage(BaseModel):
    class Config:
        extra = Extra.forbid

    admin: str
    delegates: List[Delegate]
    extra: Dict[str, str]
    freeze_history: Dict[str, FreezeHistory]
    frozen_token_id: str
    frozen_total_supply: str
    governance_token: GovernanceToken
    guardian: str
    metadata: Dict[str, str]
    pending_owner: str
    permits_counter: str
    proposal_key_list_sort_by_level: List[ProposalKeyListSortByLevelItem]
    proposals: Dict[str, Proposals]
    quorum_threshold_at_cycle: QuorumThresholdAtCycle
    start_level: str
    custom_entrypoints: Dict[str, str]
    decision_lambda: str
    fixed_proposal_fee_in_token: str
    governance_total_supply: str
    max_proposals: str
    max_quorum_change: str
    max_quorum_threshold: str
    max_voters: str
    min_quorum_threshold: str
    period: str
    proposal_check: str
    proposal_expired_level: str
    proposal_flush_level: str
    quorum_change: str
    rejected_proposal_slash_value: str
