drop table telemetry;

create table telemetry (
    ID int NOT NULL AUTO_INCREMENT,
    INPUT_DATE TIMESTAMP,
    MODEL_NAME varchar(30) NOT NULL,
    MODEL_ORDER int,
    C0 float,
    C1 float,
    C2 float,
    C3 float,
    C4 float,
    C5 float,
    C6 float,
    C7 float,
    C8 float,
    TELESCOPE VARCHAR(10),
    INSTRUMENT varchar(22),
    OBJECT varchar(20),
    INSTCONF varchar(5),
    RA varchar(13),
    DEC varchar(13),
    AIRMASS float,
    UT varchar(13),
    FOCUS float,
    MOUNT_AZ float,
    MOUNT_EL float,
    ROTATOR float,
    POSANGLE float,
    SEEING float,
    LST varchar(13),
    OBSRA varchar(13),
    OBSDEC varchar(13),
    DOME_AZ float,
    HA  varchar(13),
    ADCSTAT  varchar(8),
    ADCPOS  float,
    CAM_ANG float,
    GRT_ANG float,
    CAM_TARG float,
    GRT_TARG float,
    CAM_FOC  float,
    COLL_FOC float,
    FILTER varchar(18),
    FILTER2 varchar(18),
    GRATING varchar(18),
    SLIT varchar(18),
    COL_TEMP float,
    CAM_TEMP float,
    WAVMODE  varchar(12),
    EXPTIME  float,
    RDNOISE   float,
    GAIN    float,
    OBSTYPE varchar(10),
    OBSERVER varchar(20),
    PROPOSAL varchar(20),
    EQUINOX  float,
    ROI varchar(20),
    ENVWIN float,
    PRIMARY KEY (ID));


create table all_images (
    ID int NOT NULL AUTO_INCREMENT,
    INPUT_DATE TIMESTAMP,
    FULL_PATH varchar(100),
    PATH varchar(100),
    FILE_NAME varchar(50),
    HOSTNAME varchar(30),
    DATE_OBS datetime,
    TELESCOPE VARCHAR(10),
    INSTRUMENT varchar(22),
    OBJECT varchar(20),
    INSTCONF varchar(5),
    RA varchar(13),
    DECL varchar(13),
    AIRMASS float,
    UT varchar(13),
    FOCUS float,
    MOUNT_AZ float,
    MOUNT_EL float,
    ROTATOR float,
    POSANGLE float,
    SEEING float,
    LST varchar(13),
    OBSRA varchar(13),
    OBSDEC varchar(13),
    DOME_AZ float,
    HA  varchar(13),
    ADCSTAT  varchar(8),
    ADCPOS  float,
    CAM_ANG float,
    GRT_ANG float,
    CAM_TARG float,
    GRT_TARG float,
    CAM_FOC  float,
    COLL_FOC float,
    FILTER varchar(18),
    FILTER2 varchar(18),
    GRATING varchar(18),
    SLIT varchar(18),
    COL_TEMP float,
    CAM_TEMP float,
    WAVMODE  varchar(12),
    EXPTIME  float,
    RDNOISE   float,
    GAIN    float,
    OBSTYPE varchar(10),
    OBSERVER varchar(20),
    PROPOSAL varchar(20),
    EQUINOX  float,
    ROI varchar(20),
    ENVWIN float,
    PRIMARY KEY (ID));


select * from telemetry;

