#!/usr/bin/env python
# setup.py generated by flit for tools that don't yet use PEP 517

from distutils.core import setup

packages = \
['csr', 'csr.kernels', 'csr.kernels.mkl', 'csr.kernels.numba']

package_data = \
{'': ['*']}

install_requires = \
['numba >= 0.51', 'numpy >= 1.16', 'scipy', 'cffi >= 1.12.2']

extras_require = \
{'dev': ['flake8', 'rstcheck'],
 'doc': ['sphinx', 'sphinx_rtd_theme'],
 'profile': ['notebook', 'seaborn', 'pandas >=1.0'],
 'test': ['pytest >= 3.9',
          'pytest-doctestplus',
          'pytest-benchmark',
          'pytest-cov',
          'hypothesis']}

setup(name='csr',
      version='0.1.0',
      description='Compressed Sparse Row matrices for Python, with Numba API.',
      author='Michael Ekstrand <michaelekstrand@boisestate.edu>',
      author_email='michaelekstrand@boisestate.edu',
      url='https://csr.lenskit.org',
      packages=packages,
      package_data=package_data,
      install_requires=install_requires,
      extras_require=extras_require,
      python_requires='>= 3.6.1',
     )
