"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnService = exports.Type = exports.toJson_CfnServiceProps = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Generated by cdk-import
const cdk = require("aws-cdk-lib");
/**
 * Converts an object of type 'CfnServiceProps' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_CfnServiceProps(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Name': obj.name,
        'Comment': obj.comment,
        'Paused': obj.paused,
        'Id': obj.id,
        'Type': obj.type,
        'CustomerId': obj.customerId,
        'CreatedAt': obj.createdAt?.toISOString(),
        'UpdatedAt': obj.updatedAt?.toISOString(),
        'DeletedAt': obj.deletedAt?.toISOString(),
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_CfnServiceProps = toJson_CfnServiceProps;
/* eslint-enable max-len, quote-props */
/**
 * The type of this service.
 *
 * @schema Type
 */
var Type;
(function (Type) {
    /** vcl */
    Type["VCL"] = "vcl";
    /** wasm */
    Type["WASM"] = "wasm";
})(Type = exports.Type || (exports.Type = {}));
/**
 * A CloudFormation `Fastly::Services::Service`
 *
 * @cloudformationResource Fastly::Services::Service
 * @stability external
 * @link https://github.com/aws-ia/cloudformation-fastly-resource-providers.git
 */
class CfnService extends cdk.CfnResource {
    /**
     * Create a new `Fastly::Services::Service`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnService.CFN_RESOURCE_TYPE_NAME, properties: toJson_CfnServiceProps(props) });
        this.props = props;
        this.attrActiveVersionId = cdk.Token.asString(this.getAtt('ActiveVersionId'));
        this.attrLatestVersionId = cdk.Token.asString(this.getAtt('LatestVersionId'));
    }
}
exports.CfnService = CfnService;
_a = JSII_RTTI_SYMBOL_1;
CfnService[_a] = { fqn: "@cdk-cloudformation/fastly-services-service.CfnService", version: "1.0.0-alpha.7" };
/**
* The CloudFormation resource type name for this resource class.
*/
CfnService.CFN_RESOURCE_TYPE_NAME = "Fastly::Services::Service";
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5kZXguanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi9zcmMvaW5kZXgudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFBQSwwQkFBMEI7QUFDMUIsbUNBQW1DO0FBd0RuQzs7R0FFRztBQUNILHlDQUF5QztBQUN6QyxTQUFnQixzQkFBc0IsQ0FBQyxHQUFnQztJQUNyRSxJQUFJLEdBQUcsS0FBSyxTQUFTLEVBQUU7UUFBRSxPQUFPLFNBQVMsQ0FBQztLQUFFO0lBQzVDLE1BQU0sTUFBTSxHQUFHO1FBQ2IsTUFBTSxFQUFFLEdBQUcsQ0FBQyxJQUFJO1FBQ2hCLFNBQVMsRUFBRSxHQUFHLENBQUMsT0FBTztRQUN0QixRQUFRLEVBQUUsR0FBRyxDQUFDLE1BQU07UUFDcEIsSUFBSSxFQUFFLEdBQUcsQ0FBQyxFQUFFO1FBQ1osTUFBTSxFQUFFLEdBQUcsQ0FBQyxJQUFJO1FBQ2hCLFlBQVksRUFBRSxHQUFHLENBQUMsVUFBVTtRQUM1QixXQUFXLEVBQUUsR0FBRyxDQUFDLFNBQVMsRUFBRSxXQUFXLEVBQUU7UUFDekMsV0FBVyxFQUFFLEdBQUcsQ0FBQyxTQUFTLEVBQUUsV0FBVyxFQUFFO1FBQ3pDLFdBQVcsRUFBRSxHQUFHLENBQUMsU0FBUyxFQUFFLFdBQVcsRUFBRTtLQUMxQyxDQUFDO0lBQ0YsMEJBQTBCO0lBQzFCLE9BQU8sTUFBTSxDQUFDLE9BQU8sQ0FBQyxNQUFNLENBQUMsQ0FBQyxNQUFNLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxFQUFFLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsS0FBSyxTQUFTLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsR0FBRyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxFQUFFLEVBQUUsQ0FBQyxDQUFDO0FBQzFHLENBQUM7QUFmRCx3REFlQztBQUNELHdDQUF3QztBQUV4Qzs7OztHQUlHO0FBQ0gsSUFBWSxJQUtYO0FBTEQsV0FBWSxJQUFJO0lBQ2QsVUFBVTtJQUNWLG1CQUFXLENBQUE7SUFDWCxXQUFXO0lBQ1gscUJBQWEsQ0FBQTtBQUNmLENBQUMsRUFMVyxJQUFJLEdBQUosWUFBSSxLQUFKLFlBQUksUUFLZjtBQUdEOzs7Ozs7R0FNRztBQUNILE1BQWEsVUFBVyxTQUFRLEdBQUcsQ0FBQyxXQUFXO0lBc0I3Qzs7Ozs7O09BTUc7SUFDSCxZQUFZLEtBQTJCLEVBQUUsRUFBVSxFQUFFLEtBQXNCO1FBQ3pFLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFLEVBQUUsSUFBSSxFQUFFLFVBQVUsQ0FBQyxzQkFBc0IsRUFBRSxVQUFVLEVBQUUsc0JBQXNCLENBQUMsS0FBSyxDQUFFLEVBQUUsQ0FBQyxDQUFDO1FBRTFHLElBQUksQ0FBQyxLQUFLLEdBQUcsS0FBSyxDQUFDO1FBRW5CLElBQUksQ0FBQyxtQkFBbUIsR0FBRyxHQUFHLENBQUMsS0FBSyxDQUFDLFFBQVEsQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDLGlCQUFpQixDQUFDLENBQUMsQ0FBQztRQUM5RSxJQUFJLENBQUMsbUJBQW1CLEdBQUcsR0FBRyxDQUFDLEtBQUssQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLENBQUM7SUFDaEYsQ0FBQzs7QUFwQ0gsZ0NBcUNDOzs7QUFwQ0M7O0VBRUU7QUFDcUIsaUNBQXNCLEdBQUcsMkJBQTJCLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyIvLyBHZW5lcmF0ZWQgYnkgY2RrLWltcG9ydFxuaW1wb3J0ICogYXMgY2RrIGZyb20gJ2F3cy1jZGstbGliJztcbmltcG9ydCAqIGFzIGNvbnN0cnVjdHMgZnJvbSAnY29uc3RydWN0cyc7XG5cbi8qKlxuICogTWFuYWdlIGEgRmFzdGx5IHNlcnZpY2UuXG4gKlxuICogQHNjaGVtYSBDZm5TZXJ2aWNlUHJvcHNcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBDZm5TZXJ2aWNlUHJvcHMge1xuICAvKipcbiAgICogQHNjaGVtYSBDZm5TZXJ2aWNlUHJvcHMjTmFtZVxuICAgKi9cbiAgcmVhZG9ubHkgbmFtZTogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBAc2NoZW1hIENmblNlcnZpY2VQcm9wcyNDb21tZW50XG4gICAqL1xuICByZWFkb25seSBjb21tZW50Pzogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBAc2NoZW1hIENmblNlcnZpY2VQcm9wcyNQYXVzZWRcbiAgICovXG4gIHJlYWRvbmx5IHBhdXNlZD86IGJvb2xlYW47XG5cbiAgLyoqXG4gICAqIEBzY2hlbWEgQ2ZuU2VydmljZVByb3BzI0lkXG4gICAqL1xuICByZWFkb25seSBpZD86IHN0cmluZztcblxuICAvKipcbiAgICogQHNjaGVtYSBDZm5TZXJ2aWNlUHJvcHMjVHlwZVxuICAgKi9cbiAgcmVhZG9ubHkgdHlwZT86IFR5cGU7XG5cbiAgLyoqXG4gICAqIEBzY2hlbWEgQ2ZuU2VydmljZVByb3BzI0N1c3RvbWVySWRcbiAgICovXG4gIHJlYWRvbmx5IGN1c3RvbWVySWQ/OiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIEBzY2hlbWEgQ2ZuU2VydmljZVByb3BzI0NyZWF0ZWRBdFxuICAgKi9cbiAgcmVhZG9ubHkgY3JlYXRlZEF0PzogRGF0ZTtcblxuICAvKipcbiAgICogQHNjaGVtYSBDZm5TZXJ2aWNlUHJvcHMjVXBkYXRlZEF0XG4gICAqL1xuICByZWFkb25seSB1cGRhdGVkQXQ/OiBEYXRlO1xuXG4gIC8qKlxuICAgKiBAc2NoZW1hIENmblNlcnZpY2VQcm9wcyNEZWxldGVkQXRcbiAgICovXG4gIHJlYWRvbmx5IGRlbGV0ZWRBdD86IERhdGU7XG5cbn1cblxuLyoqXG4gKiBDb252ZXJ0cyBhbiBvYmplY3Qgb2YgdHlwZSAnQ2ZuU2VydmljZVByb3BzJyB0byBKU09OIHJlcHJlc2VudGF0aW9uLlxuICovXG4vKiBlc2xpbnQtZGlzYWJsZSBtYXgtbGVuLCBxdW90ZS1wcm9wcyAqL1xuZXhwb3J0IGZ1bmN0aW9uIHRvSnNvbl9DZm5TZXJ2aWNlUHJvcHMob2JqOiBDZm5TZXJ2aWNlUHJvcHMgfCB1bmRlZmluZWQpOiBSZWNvcmQ8c3RyaW5nLCBhbnk+IHwgdW5kZWZpbmVkIHtcbiAgaWYgKG9iaiA9PT0gdW5kZWZpbmVkKSB7IHJldHVybiB1bmRlZmluZWQ7IH1cbiAgY29uc3QgcmVzdWx0ID0ge1xuICAgICdOYW1lJzogb2JqLm5hbWUsXG4gICAgJ0NvbW1lbnQnOiBvYmouY29tbWVudCxcbiAgICAnUGF1c2VkJzogb2JqLnBhdXNlZCxcbiAgICAnSWQnOiBvYmouaWQsXG4gICAgJ1R5cGUnOiBvYmoudHlwZSxcbiAgICAnQ3VzdG9tZXJJZCc6IG9iai5jdXN0b21lcklkLFxuICAgICdDcmVhdGVkQXQnOiBvYmouY3JlYXRlZEF0Py50b0lTT1N0cmluZygpLFxuICAgICdVcGRhdGVkQXQnOiBvYmoudXBkYXRlZEF0Py50b0lTT1N0cmluZygpLFxuICAgICdEZWxldGVkQXQnOiBvYmouZGVsZXRlZEF0Py50b0lTT1N0cmluZygpLFxuICB9O1xuICAvLyBmaWx0ZXIgdW5kZWZpbmVkIHZhbHVlc1xuICByZXR1cm4gT2JqZWN0LmVudHJpZXMocmVzdWx0KS5yZWR1Y2UoKHIsIGkpID0+IChpWzFdID09PSB1bmRlZmluZWQpID8gciA6ICh7IC4uLnIsIFtpWzBdXTogaVsxXSB9KSwge30pO1xufVxuLyogZXNsaW50LWVuYWJsZSBtYXgtbGVuLCBxdW90ZS1wcm9wcyAqL1xuXG4vKipcbiAqIFRoZSB0eXBlIG9mIHRoaXMgc2VydmljZS5cbiAqXG4gKiBAc2NoZW1hIFR5cGVcbiAqL1xuZXhwb3J0IGVudW0gVHlwZSB7XG4gIC8qKiB2Y2wgKi9cbiAgVkNMID0gXCJ2Y2xcIixcbiAgLyoqIHdhc20gKi9cbiAgV0FTTSA9IFwid2FzbVwiLFxufVxuXG5cbi8qKlxuICogQSBDbG91ZEZvcm1hdGlvbiBgRmFzdGx5OjpTZXJ2aWNlczo6U2VydmljZWBcbiAqXG4gKiBAY2xvdWRmb3JtYXRpb25SZXNvdXJjZSBGYXN0bHk6OlNlcnZpY2VzOjpTZXJ2aWNlXG4gKiBAc3RhYmlsaXR5IGV4dGVybmFsXG4gKiBAbGluayBodHRwczovL2dpdGh1Yi5jb20vYXdzLWlhL2Nsb3VkZm9ybWF0aW9uLWZhc3RseS1yZXNvdXJjZS1wcm92aWRlcnMuZ2l0XG4gKi9cbmV4cG9ydCBjbGFzcyBDZm5TZXJ2aWNlIGV4dGVuZHMgY2RrLkNmblJlc291cmNlIHtcbiAgLyoqXG4gICogVGhlIENsb3VkRm9ybWF0aW9uIHJlc291cmNlIHR5cGUgbmFtZSBmb3IgdGhpcyByZXNvdXJjZSBjbGFzcy5cbiAgKi9cbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBDRk5fUkVTT1VSQ0VfVFlQRV9OQU1FID0gXCJGYXN0bHk6OlNlcnZpY2VzOjpTZXJ2aWNlXCI7XG5cbiAgLyoqXG4gICAqIFJlc291cmNlIHByb3BzLlxuICAgKi9cbiAgcHVibGljIHJlYWRvbmx5IHByb3BzOiBDZm5TZXJ2aWNlUHJvcHM7XG5cbiAgLyoqXG4gICAqIEF0dHJpYnV0ZSBgRmFzdGx5OjpTZXJ2aWNlczo6U2VydmljZS5BY3RpdmVWZXJzaW9uSWRgXG4gICAqIEBsaW5rIGh0dHBzOi8vZ2l0aHViLmNvbS9hd3MtaWEvY2xvdWRmb3JtYXRpb24tZmFzdGx5LXJlc291cmNlLXByb3ZpZGVycy5naXRcbiAgICovXG4gIHB1YmxpYyByZWFkb25seSBhdHRyQWN0aXZlVmVyc2lvbklkOiBzdHJpbmc7XG4gIC8qKlxuICAgKiBBdHRyaWJ1dGUgYEZhc3RseTo6U2VydmljZXM6OlNlcnZpY2UuTGF0ZXN0VmVyc2lvbklkYFxuICAgKiBAbGluayBodHRwczovL2dpdGh1Yi5jb20vYXdzLWlhL2Nsb3VkZm9ybWF0aW9uLWZhc3RseS1yZXNvdXJjZS1wcm92aWRlcnMuZ2l0XG4gICAqL1xuICBwdWJsaWMgcmVhZG9ubHkgYXR0ckxhdGVzdFZlcnNpb25JZDogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBDcmVhdGUgYSBuZXcgYEZhc3RseTo6U2VydmljZXM6OlNlcnZpY2VgLlxuICAgKlxuICAgKiBAcGFyYW0gc2NvcGUgLSBzY29wZSBpbiB3aGljaCB0aGlzIHJlc291cmNlIGlzIGRlZmluZWRcbiAgICogQHBhcmFtIGlkICAgIC0gc2NvcGVkIGlkIG9mIHRoZSByZXNvdXJjZVxuICAgKiBAcGFyYW0gcHJvcHMgLSByZXNvdXJjZSBwcm9wZXJ0aWVzXG4gICAqL1xuICBjb25zdHJ1Y3RvcihzY29wZTogY29uc3RydWN0cy5Db25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBDZm5TZXJ2aWNlUHJvcHMpIHtcbiAgICBzdXBlcihzY29wZSwgaWQsIHsgdHlwZTogQ2ZuU2VydmljZS5DRk5fUkVTT1VSQ0VfVFlQRV9OQU1FLCBwcm9wZXJ0aWVzOiB0b0pzb25fQ2ZuU2VydmljZVByb3BzKHByb3BzKSEgfSk7XG5cbiAgICB0aGlzLnByb3BzID0gcHJvcHM7XG5cbiAgICB0aGlzLmF0dHJBY3RpdmVWZXJzaW9uSWQgPSBjZGsuVG9rZW4uYXNTdHJpbmcodGhpcy5nZXRBdHQoJ0FjdGl2ZVZlcnNpb25JZCcpKTtcbiAgICB0aGlzLmF0dHJMYXRlc3RWZXJzaW9uSWQgPSBjZGsuVG9rZW4uYXNTdHJpbmcodGhpcy5nZXRBdHQoJ0xhdGVzdFZlcnNpb25JZCcpKTtcbiAgfVxufSJdfQ==