# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['pantable', 'pantable.cli']

package_data = \
{'': ['*']}

install_requires = \
['numpy>=1.16,<2.0', 'panflute>=2.1.3,<3.0.0', 'pyyaml>=5,<7']

extras_require = \
{':python_version < "3.8"': ['backports.cached-property>=1,<2'],
 'docs': ['sphinx>=3,<5', 'sphinx-bootstrap-theme', 'sphinxcontrib-apidoc'],
 'extras': ['coloredlogs>=14,<16', 'tabulate>=0.8,<0.9', 'yamlloader>=1,<2'],
 'tests': ['coverage',
           'coveralls',
           'flake8',
           'pytest',
           'pytest-cov',
           'pytest-parallel>=0.1.1,<0.2.0',
           'pytest-xdist']}

entry_points = \
{'console_scripts': ['pantable = pantable.cli.pantable:main',
                     'pantable2csv = pantable.cli.pantable2csv:main',
                     'pantable2csvx = pantable.cli.pantable2csvx:main']}

setup_kwargs = {
    'name': 'pantable',
    'version': '0.14.2',
    'description': 'A Python library for writing pandoc filters for tables with batteries included.',
    'long_description': '.. This is auto-generated from `docs/README.md`. Do not edit this file directly.\n\n========================================================================================\nPantable—A Python library for writing pandoc filters for tables with batteries included.\n========================================================================================\n\n:Date:   November 30, 2021\n\n.. contents::\n   :depth: 3\n..\n\n+-------------+----------------------------------------------------------------------------------+\n| docs        | |Documentation Status| |image2|                                                  |\n+=============+==================================================================================+\n| tests       | |GitHub Actions| |Coverage Status|                                               |\n|             |                                                                                  |\n|             | |Codacy Code Quality Status| |Scrutinizer Status| |CodeClimate Quality Status|   |\n+-------------+----------------------------------------------------------------------------------+\n| package     | |Supported versions| |Supported implementations| |PyPI Wheel|                    |\n|             |                                                                                  |\n|             | |PyPI Package latest release| |GitHub Releases| |Development Status| |Downloads| |\n|             |                                                                                  |\n|             | |Commits since latest release| |License|                                         |\n+-------------+----------------------------------------------------------------------------------+\n| conda-forge | |Conda Recipe| |Conda Downloads| |Conda Version| |Conda Platforms|               |\n+-------------+----------------------------------------------------------------------------------+\n| cite        | |DOI|                                                                            |\n+-------------+----------------------------------------------------------------------------------+\n\nIntroduction\n============\n\nPantable is a Python library that maps the pandoc Table AST to an internal structure losslessly. This enables writing pandoc filters specifically manipulating tables in pandoc.\n\nThis also comes with 3 pandoc filters, ``pantable``, ``pantable2csv``, ``pantable2csvx``.\n\n``pantable`` is the main filter, introducing a syntax to include CSV table in markdown source. It supports all table features supported by the pandoc Table AST.\n\n``pantable2csv`` complements ``pantable``, is the inverse of ``pantable``, which convert native pandoc tables into the CSV table format defined by ``pantable``. This is lossy as of pandoc 2.11+, which is supported since pantable 0.13.\n\n``pantable2csvx`` (experimental, may drop in the future) is similar to ``pantable2csv``, but introduces an extra column with the ``fancy-table`` syntax defined below such that any general pandoc Table AST can be losslessly encoded in CSV format.\n\nSome example uses are:\n\n1. You already have tables in CSV format.\n\n2. You feel that directly editing markdown table is troublesome. You want a spreadsheet interface to edit, but want to convert it to native pandoc table for higher readability. And this process might go back and forth.\n\n3. You want lower-level control on the table and column widths.\n\n4. You want to use all table features supported by the pandoc’s internal AST table format, which is not possible in markdown for pandoc (as of writing.)\n\nA word on support\n-----------------\n\nNote that the above is exactly how I use pantable personally. So you can count on the round-trip losslessness. ``pantable`` and ``pantable2csv`` should have robust support since it has been used for years. But since pandoc 2.11 the table AST has been majorly revised. Pantable 0.13 added support for this new AST by completely rewriting pantable, at the same time addresses some of the shortcoming of the original design. Part of the new design is to enable pantable as a library (see `Pantable as a library <#pantable-as-a-library>`__ below) so that its functionality can be extended, similar to how to write a pandoc filter to intercept the AST and modify it, you can intercept the internal structure of PanTable and modify it.\n\nHowever, since this library is completely rewritten as of v0.13,\n\n-  ``pantable`` and ``pantable2csv`` as pandoc filters should be stable\n\n   -  there may be regression, please open an issue to report this\n\n-  round-trip losslessness may break, please open an issue to report this\n-  ``pantable2csvx`` as pandoc filter is experimental. API here might change in the future or may be dropped completed (e.g.\xa0replaces by something even more general)\n-  Pantable as a library also is experimental, meaning that the API might be changed in the future.\n\nInstallation\n============\n\nPip\n---\n\nTo manage pantable using pip, open the command line and run\n\n-  ``pip install pantable`` to install\n\n   -  ``pip install https://github.com/ickc/pantable/archive/master.zip`` to install the in-development version\n\n-  ``pip install -U pantable`` to upgrade\n-  ``pip uninstall pantable`` to remove\n\nYou need a matching pandoc version for pantable to work flawlessly. See `Supported pandoc versions <#supported-pandoc-versions>`__ for details. Or, use the `Conda <#conda>`__ method to install below to have the pandoc version automatically managed for you.\n\nConda\n-----\n\nTo manage pantable **with a matching pandoc version**, open the command line and run\n\n-  ``conda install -c conda-forge pantable`` to install\n-  ``conda update pantable`` to upgrade\n-  ``conda remove pantable`` to remove\n\nYou may also replace ``conda`` by ``mamba``, which is basically a drop-in replacement of the conda package manager. See `mamba-org/mamba: The Fast Cross-Platform Package Manager <https://github.com/mamba-org/mamba>`__ for details.\n\nNote on versions\n----------------\n\nSupported Python versions\n~~~~~~~~~~~~~~~~~~~~~~~~~\n\npantable v0.12 drop Python 2 support. You need to ``pip install pantable<0.12`` if you need to run it on Python 2.\n\nTo enforce using Python 3, depending on your system, you may need to specify ``python3`` and ``pip3`` explicitly.\n\nCheck the badge above or ``setup.py`` for supported Python versions, ``setup.py`` further indicates support of pypy in additional of CPython.\n\nSupported pandoc versions\n^^^^^^^^^^^^^^^^^^^^^^^^^\n\npandoc versioning semantics is `MAJOR.MAJOR.MINOR.PATCH <https://pvp.haskell.org>`__ and panflute’s is MAJOR.MINOR.PATCH. Below we shows matching versions of pandoc that panflute supports, in descending order. Only major version is shown as long as the minor versions doesn’t matter.\n\n.. table:: Version Matching [1]_\n\n   +----------+------------------+---------------------------+-------------------------------+\n   | pantable | panflute version | supported pandoc versions | supported pandoc API versions |\n   +==========+==================+===========================+===============================+\n   | 0.14.1   | 2.1.3            | 2.11.0.4–2.16.x           | 1.22–1.22.1                   |\n   +----------+------------------+---------------------------+-------------------------------+\n   | 0.14     | 2.1              | 2.11.0.4—2.14.x           | 1.22                          |\n   +----------+------------------+---------------------------+-------------------------------+\n   | 0.13     | 2.0              | 2.11.0.4—2.11.x           | 1.22                          |\n   +----------+------------------+---------------------------+-------------------------------+\n   | -        | not supported    | 2.10                      | 1.21                          |\n   +----------+------------------+---------------------------+-------------------------------+\n   | 0.12     | 1.12             | 2.7-2.9                   | 1.17.5–1.20                   |\n   +----------+------------------+---------------------------+-------------------------------+\n\nNote: pandoc 2.10 is short lived and 2.11 has minor API changes comparing to that, mainly for fixing its shortcomings. Please avoid using pandoc 2.10.\n\nTo use pantable with pandoc < 2.10, install pantable 0.12 explicitly by ``pip install pantable~=0.12.4``.\n\nPantable as pandoc filters\n==========================\n\n``pantable``\n------------\n\nThis allows CSV tables, optionally containing markdown syntax (disabled by default), to be put in markdown as a fenced code blocks.\n\nExample\n-------\n\nAlso see the README in `GitHub Pages <https://ickc.github.io/pantable/>`__.\n\n::\n\n   ```table\n   ---\n   caption: \'*Awesome* **Markdown** Table\'\n   alignment: RC\n   table-width: 2/3\n   markdown: True\n   ---\n   First row,defaulted to be header row,can be disabled\n   1,cell can contain **markdown**,"It can be aribrary block element:\n\n   - following standard markdown syntax\n   - like this"\n   2,"Any markdown syntax, e.g.",E = mc^2^\n   ```\n\nbecomes\n\n.. table:: *Awesome* **Markdown** Table\n\n   +---------------+-------------------------------+---------------------------------------+\n   | First row     | defaulted to be header row    | can be disabled                       |\n   +===============+===============================+=======================================+\n   | 1             | cell can contain **markdown** | It can be aribrary block element:     |\n   |               |                               |                                       |\n   |               |                               | -  following standard markdown syntax |\n   |               |                               | -  like this                          |\n   +---------------+-------------------------------+---------------------------------------+\n   | 2             | Any markdown syntax, e.g.     | E = mc\\ :sup:`2`                      |\n   +---------------+-------------------------------+---------------------------------------+\n\n(The equation might not work if you view this on PyPI.)\n\nUsage\n-----\n\n.. code:: bash\n\n   pandoc -F pantable -o README.html README.md\n\nSyntax\n------\n\nFenced code blocks is used, with a class ``table``. See `Example <#example>`__.\n\nOptionally, YAML metadata block can be used within the fenced code block, following standard pandoc YAML metadata block syntax. 7 metadata keys are recognized:\n\n``caption``\n   the caption of the table. Can be block-like. If omitted, no caption will be inserted. Interpreted as markdown only if ``markdown: true`` below.\n\n   Default: disabled.\n\n``short-caption``\n   the short-caption of the table. Must be inline-like element. Interpreted as markdown only if ``markdown: true`` below.\n\n   Default: disabled.\n\n``alignment``\n   alignment for columns: a string of characters among ``L,R,C,D``, case-insensitive, corresponds to Left-aligned, Right-aligned, Center-aligned, Default-aligned respectively. e.g.\xa0``LCRD`` for a table with 4 columns.\n\n   You can specify only the beginning that’s non-default. e.g.\xa0``DLCR`` for a table with 8 columns is equivalent to ``DLCRDDDD``.\n\n   Default: ``DDD...``\n\n``alignment-cells``\n   alignment per cell. One row per line. A string of characters among ``L,R,C,D``, case-insensitive, corresponds to Left-aligned, Right-aligned, Center-aligned, Default-aligned respectively. e.g.\n\n   ::\n\n      LCRD\n      DRCL\n\n   for a table with 4 columns, 2 rows.\n\n   you can specify only the top left block that is not default, and the rest of the cells with be default to default automatically. e.g.\n\n   ::\n\n      DC\n      LR\n\n   for a table with 4 columns, 3 rows will be equivalent to\n\n   ::\n\n      DCDD\n      LRDD\n      DDDD\n\n   Default: ``DDD...\\n...``\n\n``width``\n   a list of relative width corresponding to the width of each columns. ``D`` means default width. e.g.\n\n   .. code:: yaml\n\n      - width\n          - 0.1\n          - 0.2\n          - 0.3\n          - 0.4\n          - D\n\n   Again, you can specify only the left ones that are non-default and it will be padded with defaults.\n\n   Default: ``[D, D, D, ...]``\n\n``table-width``\n   the relative width of the table (e.g.\xa0relative to ``\\linewidth``). If specified as a number, and if any of the column width in ``width`` is default, then auto-width will be performed such that the sum of ``width`` equals this number.\n\n   Default: None\n\n``header``\n   If it has a header row or not.\n\n   Default: True\n\n``markdown``\n   If CSV table cell contains markdown syntax or not.\n\n   Default: False\n\n``fancy_table``\n   if true, then the first column of the table will be interpreted as a special fancy-table syntax s.t. it encodes which rows are\n\n   -  table-header,\n   -  table-foot,\n   -  multiple table-bodies and\n   -  “body-head” within table-bodies.\n\n   see example below.\n\n``include``\n   the path to an CSV file, can be relative/absolute. If non-empty, override the CSV in the CodeBlock.\n\n   Default: None\n\n``include-encoding``\n   if specified, the file from ``include`` will be decoded according to this encoding, else assumed to be UTF-8. Hint: if you save the CSV file via Microsoft Excel, you may need to set this to ``utf-8-sig``.\n\n``csv-kwargs``\n   If specified, should be a dictionary passed to ``csv.reader`` as options. e.g.\n\n   .. code:: yaml\n\n      ---\n      csv-kwargs:\n        dialect: unix\n        key: value...\n      ...\n\n``format``\n   The file format from the data in code-block or include if specified.\n\n   Default: ``csv`` for data from code-block, and infer from extension in include.\n\n   Currently only ``csv`` is supported.\n\n``ms``\n   (experimental, may drop in the future): a list of int that specifies the number of rows per row-block. e.g.\xa0``[2, 6, 3, 4, 5, 1]`` means the table should have 21 rows, first 2 rows are table-head, last 1 row is table-foot, there are 2 table-bodies (indicated by ``6, 3, 4, 5`` in the middle) where the 1st body ``6, 3`` has 6 body-head and 3 “body-body”, and the 2nd body ``4, 5`` has 4 body-head and 5 “body-body”.\n\n   If this is specified, ``header`` will be ignored.\n\n   Default: None, which would be inferred from ``header``.\n\n``ns_head``\n   (experimental, may drop in the future): a list of int that specifies the number of head columns per table-body. e.g.\xa0``[1, 2]`` means the 1st table-body has 1 column of head, the 2nd table-body has 2 column of head\n\n   Default: None\n\n``pantable2csv``\n----------------\n\nThis one is the inverse of ``pantable``, a panflute filter to convert any native pandoc tables into the CSV table format used by pantable.\n\nEffectively, ``pantable`` forms a “CSV Reader”, and ``pantable2csv`` forms a “CSV Writer”. It allows you to convert back and forth between these 2 formats.\n\nFor example, in the markdown source:\n\n::\n\n   +--------+---------------------+--------------------------+\n   | First  | defaulted to be     | can be disabled          |\n   | row    | header row          |                          |\n   +========+=====================+==========================+\n   | 1      | cell can contain    | It can be aribrary block |\n   |        | **markdown**        | element:                 |\n   |        |                     |                          |\n   |        |                     | -   following standard   |\n   |        |                     |     markdown syntax      |\n   |        |                     | -   like this            |\n   +--------+---------------------+--------------------------+\n   | 2      | Any markdown        | $$E = mc^2$$             |\n   |        | syntax, e.g.        |                          |\n   +--------+---------------------+--------------------------+\n\n   : *Awesome* **Markdown** Table\n\nrunning ``pandoc -F pantable2csv -o output.md input.md``, it becomes\n\n::\n\n   ``` {.table}\n   ---\n   alignment: DDD\n   caption: \'*Awesome* **Markdown** Table\'\n   header: true\n   markdown: true\n   table-width: 0.8055555555555556\n   width: [0.125, 0.3055555555555556, 0.375]\n   ---\n   First row,defaulted to be header row,can be disabled\n   1,cell can contain **markdown**,"It can be aribrary block element:\n\n   -   following standard markdown syntax\n   -   like this\n   "\n   2,"Any markdown syntax, e.g.",$$E = mc^2$$\n   ```\n\n``pantable2csvx``\n-----------------\n\n(experimental, may drop in the future)\n\nSimilar to ``pantable2csv``, but convert with ``fancy_table`` syntax s.t. any general Table in pandoc AST is in principle losslessly converted to a markdown-ish syntax in a CSV representation.\n\ne.g.\n\n.. code:: sh\n\n   pandoc -F pantable2csvx -o tests/files/native_reference/planets.md tests/files/native/planets.native\n\nwould turn the native Table from ``platnets.native``\\  [2]_ to\n\n::\n\n   ``` {.table}\n   ---\n   caption: Data about the planets of our solar system.\n   alignment: CCDRRRRRRRR\n   ns-head:\n   - 3\n   markdown: true\n   fancy-table: true\n   ...\n   ===,"(1, 2)\n   ",,Name,Mass (10\\^24kg),Diameter (km),Density (kg/m\\^3),Gravity (m/s\\^2),Length of day (hours),Distance from Sun (10\\^6km),Mean temperature (C),Number of moons,Notes\n   ,"(4, 2)\n   Terrestrial planets",,Mercury,0.330,"4,879",5427,3.7,4222.6,57.9,167,0,Closest to the Sun\n   ,,,Venus,4.87,"12,104",5243,8.9,2802.0,108.2,464,0,\n   ,,,Earth,5.97,"12,756",5514,9.8,24.0,149.6,15,1,Our world\n   ,,,Mars,0.642,"6,792",3933,3.7,24.7,227.9,-65,2,The red planet\n   ,"(4, 1)\n   Jovian planets","(2, 1)\n   Gas giants",Jupiter,1898,"142,984",1326,23.1,9.9,778.6,-110,67,The largest planet\n   ,,,Saturn,568,"120,536",687,9.0,10.7,1433.5,-140,62,\n   ,,"(2, 1)\n   Ice giants",Uranus,86.8,"51,118",1271,8.7,17.2,2872.5,-195,27,\n   ,,,Neptune,102,"49,528",1638,11.0,16.1,4495.1,-200,14,\n   ___,"(1, 2)\n   Dwarf planets",,Pluto,0.0146,"2,370",2095,0.7,153.3,5906.4,-225,5,Declassified as a planet in 2006.\n   ```\n\nPantable as a library\n=====================\n\n(experimental, API may change in the future)\n\nDocumentation here is sparse, partly because the upstream (pandoc) may change the table AST again. See `Crazy ideas: table structure from upstream GitHub <https://github.com/jgm/pandoc-types/issues/86>`__.\n\nSee the API docs in https://ickc.github.io/pantable/.\n\nFor example, looking at the source of ``pantable`` as a pandoc filter, in ``codeblock_to_table.py``, you will see the main function doing the work is now\n\n.. code:: python\n\n   pan_table_str = (\n       PanCodeBlock\n       .from_yaml_filter(options=options, data=data, element=element, doc=doc)\n       .to_pantablestr()\n   )\n   if pan_table_str.table_width is not None:\n       pan_table_str.auto_width()\n   return (\n       pan_table_str\n       .to_pantable()\n       .to_panflute_ast()\n   )\n\nYou can see another example from ``table_to_codeblock.py`` which is what ``pantable2csv`` and ``pantable2csvx`` called.\n\nBelow is a diagram illustrating the API:\n\n.. figure:: docs/dot/pipeline-simple.svg\n   :alt: Overview\n\n   Overview\n\nSolid arrows are lossless conversions. Dashed arrows are lossy.\n\nYou can see the pantable internal structure, ``PanTable`` is one-one correspondence to the pandoc Table AST. Similarly for ``PanCodeBlock``.\n\nIt can then losslessly converts between PanTable and PanTableMarkdown, where everything in PanTableMarkdown is now markdown strings (whereas those in PanTable are panflute or panflute-like AST objects.)\n\nLastly, it defines a one-one correspondence to PanCodeBlock with ``fancy_table`` syntax mentioned earlier.\n\nBelow is the same diagram with the method names. You’d probably want to zoom into it to see it clearly.\n\n.. figure:: docs/dot/pipeline.svg\n   :alt: Detailed w/ methods\n\n   Detailed w/ methods\n\nDevelopment\n===========\n\nTo run all the tests run ``tox``. GitHub Actions is used for CI too so if you fork this you can check if your commits passes there.\n\nRelated Filters\n===============\n\n(The table here is created in the beginning of pantable, which has since added more features. This is left here for historical reason and also as a credit to those before this.)\n\nThe followings are pandoc filters written in Haskell that provide similar functionality. This filter is born after testing with theirs.\n\n-  `baig/pandoc-csv2table: A Pandoc filter that renders CSV as Pandoc Markdown Tables. <https://github.com/baig/pandoc-csv2table>`__\n-  `mb21/pandoc-placetable: Pandoc filter to include CSV data (from file or URL) <https://github.com/mb21/pandoc-placetable>`__\n-  `sergiocorreia/panflute/csv-tables.py <https://github.com/sergiocorreia/panflute/blob/1ddcaba019b26f41f8c4f6f66a8c6540a9c5f31a/docs/source/csv-tables.py>`__\n\n.. table:: \n\n   +-------------+-----------------------------------------+------------------------+--------------------------+-------------------------------------------------------+\n   |             | pandoc-csv2table                        | pandoc-placetable      | panflute example         | pantable                                              |\n   +=============+=========================================+========================+==========================+=======================================================+\n   | caption     | caption                                 | caption                | title                    | caption                                               |\n   +-------------+-----------------------------------------+------------------------+--------------------------+-------------------------------------------------------+\n   | aligns      | aligns = LRCD                           | aligns = LRCD          |                          | aligns = LRCD                                         |\n   +-------------+-----------------------------------------+------------------------+--------------------------+-------------------------------------------------------+\n   | width       |                                         | widths = "0.5 0.2 0.3" |                          | width: [0.5, 0.2, 0.3]                                |\n   +-------------+-----------------------------------------+------------------------+--------------------------+-------------------------------------------------------+\n   | table-width |                                         |                        |                          | table-width: 1.0                                      |\n   +-------------+-----------------------------------------+------------------------+--------------------------+-------------------------------------------------------+\n   | header      | header = yes | no                       | header = yes | no      | has_header: True | False | header: True | False | yes | NO                       |\n   +-------------+-----------------------------------------+------------------------+--------------------------+-------------------------------------------------------+\n   | markdown    |                                         | inlinemarkdown         |                          | markdown: True | False | yes | NO                     |\n   +-------------+-----------------------------------------+------------------------+--------------------------+-------------------------------------------------------+\n   | source      | source                                  | file                   | source                   | include                                               |\n   +-------------+-----------------------------------------+------------------------+--------------------------+-------------------------------------------------------+\n   | others      | type = simple | multiline | grid | pipe |                        |                          |                                                       |\n   +-------------+-----------------------------------------+------------------------+--------------------------+-------------------------------------------------------+\n   |             |                                         | delimiter              |                          |                                                       |\n   +-------------+-----------------------------------------+------------------------+--------------------------+-------------------------------------------------------+\n   |             |                                         | quotechar              |                          |                                                       |\n   +-------------+-----------------------------------------+------------------------+--------------------------+-------------------------------------------------------+\n   |             |                                         | id (wrapped by div)    |                          |                                                       |\n   +-------------+-----------------------------------------+------------------------+--------------------------+-------------------------------------------------------+\n   | Notes       |                                         |                        |                          | width are auto-calculated when width is not specified |\n   +-------------+-----------------------------------------+------------------------+--------------------------+-------------------------------------------------------+\n\n.. [1]\n   For pandoc API verion, check https://hackage.haskell.org/package/pandoc for pandoc-types, which is the same thing.\n\n.. [2]\n   copied from pandoc from `here <https://github.com/jgm/pandoc/blob/master/test/tables/planets.native>`__, which was dual licensed as CC0 `here <https://github.com/sergiocorreia/panflute/pull/172#issuecomment-736252008>`__\n\n.. |Documentation Status| image:: https://readthedocs.org/projects/pantable/badge/?version=latest\n   :target: https://pantable.readthedocs.io/en/latest/?badge=latest&style=plastic\n.. |image1| image:: https://github.com/ickc/pantable/workflows/GitHub%20Pages/badge.svg\n   :target: https://ickc.github.io/pantable\n.. |GitHub Actions| image:: https://github.com/ickc/pantable/workflows/Python%20package/badge.svg\n.. |Coverage Status| image:: https://codecov.io/gh/ickc/pantable/branch/master/graphs/badge.svg?branch=master\n   :target: https://codecov.io/github/ickc/pantable\n.. |Codacy Code Quality Status| image:: https://img.shields.io/codacy/grade/078ebc537c5747f68c1d4ad3d3594bbf.svg\n   :target: https://www.codacy.com/app/ickc/pantable\n.. |Scrutinizer Status| image:: https://img.shields.io/scrutinizer/quality/g/ickc/pantable/master.svg\n   :target: https://scrutinizer-ci.com/g/ickc/pantable/\n.. |CodeClimate Quality Status| image:: https://codeclimate.com/github/ickc/pantable/badges/gpa.svg\n   :target: https://codeclimate.com/github/ickc/pantable\n.. |Supported versions| image:: https://img.shields.io/pypi/pyversions/pantable.svg\n   :target: https://pypi.org/project/pantable\n.. |Supported implementations| image:: https://img.shields.io/pypi/implementation/pantable.svg\n   :target: https://pypi.org/project/pantable\n.. |PyPI Wheel| image:: https://img.shields.io/pypi/wheel/pantable.svg\n   :target: https://pypi.org/project/pantable\n.. |PyPI Package latest release| image:: https://img.shields.io/pypi/v/pantable.svg\n   :target: https://pypi.org/project/pantable\n.. |GitHub Releases| image:: https://img.shields.io/github/tag/ickc/pantable.svg?label=github+release\n   :target: https://github.com/ickc/pantable/releases\n.. |Development Status| image:: https://img.shields.io/pypi/status/pantable.svg\n   :target: https://pypi.python.org/pypi/pantable/\n.. |Downloads| image:: https://img.shields.io/pypi/dm/pantable.svg\n   :target: https://pypi.python.org/pypi/pantable/\n.. |Commits since latest release| image:: https://img.shields.io/github/commits-since/ickc/pantable/v0.14.2.svg\n   :target: https://github.com/ickc/pantable/compare/v0.14.2...master\n.. |License| image:: https://img.shields.io/pypi/l/pantable.svg\n.. |Conda Recipe| image:: https://img.shields.io/badge/recipe-pantable-green.svg\n   :target: https://anaconda.org/conda-forge/pantable\n.. |Conda Downloads| image:: https://img.shields.io/conda/dn/conda-forge/pantable.svg\n   :target: https://anaconda.org/conda-forge/pantable\n.. |Conda Version| image:: https://img.shields.io/conda/vn/conda-forge/pantable.svg\n   :target: https://anaconda.org/conda-forge/pantable\n.. |Conda Platforms| image:: https://img.shields.io/conda/pn/conda-forge/pantable.svg\n   :target: https://anaconda.org/conda-forge/pantable\n.. |DOI| image:: https://zenodo.org/badge/74008159.svg\n   :target: https://zenodo.org/badge/latestdoi/74008159\n.. |image2| image:: https://github.com/ickc/pantable/workflows/GitHub%20Pages/badge.svg\n   :target: https://ickc.github.io/pantable\n',
    'author': 'Kolen Cheung',
    'author_email': 'christian.kolen@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/ickc/pantable',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '>=3.7',
}


setup(**setup_kwargs)
