"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FilterStrategy = exports.FilterPreset = void 0;
/** Filter presets */
var FilterPreset;
(function (FilterPreset) {
    /**
     * Collapses extraneous nodes to parent and cdk created nodes on themselves,
     * and prunes extraneous edges.
     *
     * This most closely represents the developers code for the current application
     * and reduces the noise one expects.
     */
    FilterPreset["COMPACT"] = "compact";
    /**
     * Collapses extraneous nodes to parent and prunes extraneous edges.
     */
    FilterPreset["NON_EXTRANEOUS"] = "non-extraneous";
})(FilterPreset = exports.FilterPreset || (exports.FilterPreset = {}));
/**
 * Filter strategy to apply to filter matches.
 */
var FilterStrategy;
(function (FilterStrategy) {
    /** Remove filtered entity and all its edges */
    FilterStrategy["PRUNE"] = "prune";
    /** Collapse all child entities of filtered entity into filtered entity; and hoist all edges. */
    FilterStrategy["COLLAPSE"] = "collapse";
    /** Collapse all filtered entities into their parent entity; and hoist its edges to parent. */
    FilterStrategy["COLLAPSE_TO_PARENT"] = "collapse_to_parent";
})(FilterStrategy = exports.FilterStrategy || (exports.FilterStrategy = {}));
//# sourceMappingURL=data:application/json;base64,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