# AUTOGENERATED! DO NOT EDIT! File to edit: ../notebooks/video.ipynb.

# %% auto 0
__all__ = ['load_frames', 'process_video_frames', 'get_video_properties']

# %% ../notebooks/video.ipynb 2
import cv2
import matplotlib.pyplot as plt
import numpy as np
from PIL import Image
import json

# %% ../notebooks/video.ipynb 3
def load_frames(video_path, indexes=[], callback=None):
    video_path = str(video_path)
    cap = cv2.VideoCapture(video_path)
    frames = []
    frame_number = 0
    while cap.isOpened():
        frame_number += 1
        ret, frame = cap.read()
        if not ret:
            break
        if len(indexes) == 0 or frame_number in indexes:
            frames.append((frame_number, frame))
            if callback is not None:
                callback(frame_number, frame)

    cap.release()
    return frames


def process_video_frames(
    video_path, callback, call_every_n_frames: int = 1, up_to_frame: int = None
):
    cap = cv2.VideoCapture(str(video_path))
    frame_number = 0
    while cap.isOpened():
        frame_number += 1
        ret, frame = cap.read()
        stop_condition = (not ret) or (
            up_to_frame is not None and frame_number >= up_to_frame
        )
        if stop_condition:
            break
        if frame_number % call_every_n_frames == 0:
            frame = cv2.cvtColor(frame, cv2.COLOR_BGR2RGB)
            yield callback(frame_number, frame)

    cap.release()


def get_video_properties(video_path):
    cap = cv2.VideoCapture(str(video_path))
    out = {}
    frame_count = int(cap.get(cv2.CAP_PROP_FRAME_COUNT))
    fps = cap.get(cv2.CAP_PROP_FPS)
    duration = frame_count / fps
    return frame_count, fps, duration
