# AUTOGENERATED! DO NOT EDIT! File to edit: ../notebooks/plotting.ipynb.

# %% auto 0
__all__ = ['imshow', 'image_grid', 'draw_keypoints']

# %% ../notebooks/plotting.ipynb 2
import cv2
import matplotlib.pyplot as plt
import numpy as np
from PIL import Image
import json

# %% ../notebooks/plotting.ipynb 3
def imshow(im, figsize=(9, 9), ticks=False, **kwargs):
    plt.figure(figsize=figsize)
    if ticks is False:
        plt.xticks([])
        plt.yticks([])
    plt.imshow(im, **kwargs)


def image_grid(images, shape, figsize=(18, 9), **kwargs):
    assert len(images) == np.prod(shape)
    fig, axes = plt.subplots(*shape, figsize=figsize)
    fig.set_layout_engine(layout="compressed")
    axes = axes.reshape(shape)
    rows, columns = shape
    for x in range(rows):
        for y in range(columns):
            i = x * columns + y
            axes[x, y].imshow(images[i], **kwargs)
            axes[x, y].set_xticks([])
            axes[x, y].set_yticks([])

# %% ../notebooks/plotting.ipynb 4
def draw_keypoints(image, keypoints, size=3, color=(255, 0, 0)):
    image = image.copy()
    for x, y in keypoints:
        x = int(x)
        y = int(y)
        image[x - size : x + size, y - size : y + size] = color
    return image
