# AUTOGENERATED! DO NOT EDIT! File to edit: ../notebooks/io.ipynb.

# %% auto 0
__all__ = ["load_json", "save_json", "load_pickle", "save_pickle"]

# %% ../notebooks/io.ipynb 2
import json
import pickle
from pathlib import Path


# %% ../notebooks/io.ipynb 3
def load_txt(f):
    with open(f, encoding="utf-8") as f:
        return f.read()


def save_txt(s, f):
    with open(f, "w", encoding="utf-8") as f:
        f.write(s)


def load_json(f, **kwargs):
    with open(f, encoding="utf-8") as f:
        return json.load(f, **kwargs)


def save_json(obj, f, pretty: bool = False, append: bool = False, **kwargs):
    if append is True and Path(f).exists():
        data = load_json(f)
        if isinstance(data, list):
            data.append(obj)
            obj = data
        else:
            obj = [data, obj]
    with open(f, "w", encoding="utf-8") as f:
        json.dump(obj, f, indent=4 if pretty is True else None, **kwargs)


# %% ../notebooks/io.ipynb 4
def load_pickle(f):
    with open(f, "rb") as f:
        return pickle.load(f)


def save_pickle(obj, f):
    with open(f, "wb") as f:
        pickle.dump(obj, f)
