'use strict';

exports.__esModule = true;

var _ariaMenuitem = require('./aria-menuitem');

var _ariaMenuitem2 = _interopRequireDefault(_ariaMenuitem);

function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : {default: obj};
}

var Menu = function Menu(domNode) {
    this.domNode = domNode;
    this.init();
};

Menu.prototype.init = function () {
    var menuChildren = this.domNode.childNodes;
    [].filter.call(menuChildren, function (child) {
        return child.nodeType === 1;
    }).forEach(function (child) {
        new _ariaMenuitem2.default(child); // eslint-disable-line
    });
};
exports.default = Menu;