"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
The representation is generic to accommodate various source architectures.
In particular 32 and 64 bit versions of x86, ARM, PowerPC and MIPS have been
tested.

Multiple levels of deduping have been applied to make the format more compact
and avoid redundant data duplication. Some of this due to hard-earned
experience trying to cope with intentionally obfuscated malicious binaries.
Note in particular that the same instruction may occur in multiple basic
blocks and the same basic block in multiple functions (instruction and basic
block sharing). Implemented naively, malware can use this to cause
combinatorial explosion in memory usage, DOSing the analyst. This format
should store every unique expression, mnemonic, operand, instruction and
basic block only once instead of duplicating the information for every
instance of it.

This format does _not_ try to be 100% backwards compatible with the old
version. In particular, we do not store IDA's comment types, making lossless
porting of IDA comments impossible. We do however, store comments and
expression substitutions, so porting the actual data is possible, just not
the exact IDA type.

While it would be more natural to use addresses when defining call graph and
flow graph edges and other such references, it is more efficient to employ
one more level of indirection and use indices into the basic block or
function arrays instead. This is because addresses will usually use most of
the available 64 bit space while indices will be much smaller and compress
much better (less randomly distributed).

We omit all fields that are set to their default value anyways. Note that
this has two side effects:
  - changing the defaults in this proto file will, in effect, change what's
    read from disk
  - the generated code has_* methods are somewhat less useful
WARNING: We omit the defaults manually in the code writing the data. Do not
         change the defaults here without changing the code!

TODO(cblichmann): Link flow graphs to call graph nodes. The connection is
                  there via the address, but tricky to extract.
"""
import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing_extensions.final
class BinExport2(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class Meta(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        EXECUTABLE_NAME_FIELD_NUMBER: builtins.int
        EXECUTABLE_ID_FIELD_NUMBER: builtins.int
        ARCHITECTURE_NAME_FIELD_NUMBER: builtins.int
        TIMESTAMP_FIELD_NUMBER: builtins.int
        executable_name: builtins.str
        """Input binary filename including file extension but excluding file path.
        example: "insider_gcc.exe"
        """
        executable_id: builtins.str
        """Application defined executable id. Often the SHA256 hash of the input
        binary.
        """
        architecture_name: builtins.str
        """Input architecture name, e.g. x86-32."""
        timestamp: builtins.int
        """When did this file get created? Unix time. This may be used for some
        primitive versioning in case the file format ever changes.
        """
        def __init__(
            self,
            *,
            executable_name: builtins.str | None = ...,
            executable_id: builtins.str | None = ...,
            architecture_name: builtins.str | None = ...,
            timestamp: builtins.int | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["architecture_name", b"architecture_name", "executable_id", b"executable_id", "executable_name", b"executable_name", "timestamp", b"timestamp"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["architecture_name", b"architecture_name", "executable_id", b"executable_id", "executable_name", b"executable_name", "timestamp", b"timestamp"]) -> None: ...

    @typing_extensions.final
    class CallGraph(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        @typing_extensions.final
        class Vertex(google.protobuf.message.Message):
            DESCRIPTOR: google.protobuf.descriptor.Descriptor

            class _Type:
                ValueType = typing.NewType("ValueType", builtins.int)
                V: typing_extensions.TypeAlias = ValueType

            class _TypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[BinExport2.CallGraph.Vertex._Type.ValueType], builtins.type):
                DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
                NORMAL: BinExport2.CallGraph.Vertex._Type.ValueType  # 0
                """Regular function with full disassembly."""
                LIBRARY: BinExport2.CallGraph.Vertex._Type.ValueType  # 1
                """This function is a well known library function."""
                IMPORTED: BinExport2.CallGraph.Vertex._Type.ValueType  # 2
                """Imported from a dynamic link library (e.g. dll)."""
                THUNK: BinExport2.CallGraph.Vertex._Type.ValueType  # 3
                """A thunk function, forwarding its work via an unconditional jump."""
                INVALID: BinExport2.CallGraph.Vertex._Type.ValueType  # 4
                """An invalid function (a function that contained invalid code or was
                considered invalid by some heuristics).
                """

            class Type(_Type, metaclass=_TypeEnumTypeWrapper): ...
            NORMAL: BinExport2.CallGraph.Vertex.Type.ValueType  # 0
            """Regular function with full disassembly."""
            LIBRARY: BinExport2.CallGraph.Vertex.Type.ValueType  # 1
            """This function is a well known library function."""
            IMPORTED: BinExport2.CallGraph.Vertex.Type.ValueType  # 2
            """Imported from a dynamic link library (e.g. dll)."""
            THUNK: BinExport2.CallGraph.Vertex.Type.ValueType  # 3
            """A thunk function, forwarding its work via an unconditional jump."""
            INVALID: BinExport2.CallGraph.Vertex.Type.ValueType  # 4
            """An invalid function (a function that contained invalid code or was
            considered invalid by some heuristics).
            """

            ADDRESS_FIELD_NUMBER: builtins.int
            TYPE_FIELD_NUMBER: builtins.int
            MANGLED_NAME_FIELD_NUMBER: builtins.int
            DEMANGLED_NAME_FIELD_NUMBER: builtins.int
            LIBRARY_INDEX_FIELD_NUMBER: builtins.int
            MODULE_INDEX_FIELD_NUMBER: builtins.int
            address: builtins.int
            """The function's entry point address. Messages need to be sorted, see
            comment below on `vertex`.
            """
            type: global___BinExport2.CallGraph.Vertex.Type.ValueType
            mangled_name: builtins.str
            """If the function has a user defined, real name it will be given here.
            main() is a proper name, sub_BAADF00D is not (auto generated dummy
            name).
            """
            demangled_name: builtins.str
            """Demangled name if the function is a mangled C++ function and we could
            demangle it.
            """
            library_index: builtins.int
            """If this is a library function, what is its index in library arrays."""
            module_index: builtins.int
            """If module name, such as class name for DEX files, is present - index in
            module table.
            """
            def __init__(
                self,
                *,
                address: builtins.int | None = ...,
                type: global___BinExport2.CallGraph.Vertex.Type.ValueType | None = ...,
                mangled_name: builtins.str | None = ...,
                demangled_name: builtins.str | None = ...,
                library_index: builtins.int | None = ...,
                module_index: builtins.int | None = ...,
            ) -> None: ...
            def HasField(self, field_name: typing_extensions.Literal["address", b"address", "demangled_name", b"demangled_name", "library_index", b"library_index", "mangled_name", b"mangled_name", "module_index", b"module_index", "type", b"type"]) -> builtins.bool: ...
            def ClearField(self, field_name: typing_extensions.Literal["address", b"address", "demangled_name", b"demangled_name", "library_index", b"library_index", "mangled_name", b"mangled_name", "module_index", b"module_index", "type", b"type"]) -> None: ...

        @typing_extensions.final
        class Edge(google.protobuf.message.Message):
            DESCRIPTOR: google.protobuf.descriptor.Descriptor

            SOURCE_VERTEX_INDEX_FIELD_NUMBER: builtins.int
            TARGET_VERTEX_INDEX_FIELD_NUMBER: builtins.int
            source_vertex_index: builtins.int
            """source and target index into the vertex repeated field."""
            target_vertex_index: builtins.int
            def __init__(
                self,
                *,
                source_vertex_index: builtins.int | None = ...,
                target_vertex_index: builtins.int | None = ...,
            ) -> None: ...
            def HasField(self, field_name: typing_extensions.Literal["source_vertex_index", b"source_vertex_index", "target_vertex_index", b"target_vertex_index"]) -> builtins.bool: ...
            def ClearField(self, field_name: typing_extensions.Literal["source_vertex_index", b"source_vertex_index", "target_vertex_index", b"target_vertex_index"]) -> None: ...

        VERTEX_FIELD_NUMBER: builtins.int
        EDGE_FIELD_NUMBER: builtins.int
        @property
        def vertex(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___BinExport2.CallGraph.Vertex]:
            """vertices == functions in the call graph.
            Important: Most downstream tooling (notably BinDiff), need these to be
                       sorted by `Vertex::address` (ascending). For C++, the
                       `BinExport2Writer` class enforces this invariant.
            """
        @property
        def edge(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___BinExport2.CallGraph.Edge]:
            """edges == calls in the call graph."""
        def __init__(
            self,
            *,
            vertex: collections.abc.Iterable[global___BinExport2.CallGraph.Vertex] | None = ...,
            edge: collections.abc.Iterable[global___BinExport2.CallGraph.Edge] | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["edge", b"edge", "vertex", b"vertex"]) -> None: ...

    @typing_extensions.final
    class Expression(google.protobuf.message.Message):
        """An operand consists of 1 or more expressions, linked together as a tree."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        class _Type:
            ValueType = typing.NewType("ValueType", builtins.int)
            V: typing_extensions.TypeAlias = ValueType

        class _TypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[BinExport2.Expression._Type.ValueType], builtins.type):
            DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
            SYMBOL: BinExport2.Expression._Type.ValueType  # 1
            IMMEDIATE_INT: BinExport2.Expression._Type.ValueType  # 2
            IMMEDIATE_FLOAT: BinExport2.Expression._Type.ValueType  # 3
            OPERATOR: BinExport2.Expression._Type.ValueType  # 4
            REGISTER: BinExport2.Expression._Type.ValueType  # 5
            SIZE_PREFIX: BinExport2.Expression._Type.ValueType  # 6
            DEREFERENCE: BinExport2.Expression._Type.ValueType  # 7

        class Type(_Type, metaclass=_TypeEnumTypeWrapper): ...
        SYMBOL: BinExport2.Expression.Type.ValueType  # 1
        IMMEDIATE_INT: BinExport2.Expression.Type.ValueType  # 2
        IMMEDIATE_FLOAT: BinExport2.Expression.Type.ValueType  # 3
        OPERATOR: BinExport2.Expression.Type.ValueType  # 4
        REGISTER: BinExport2.Expression.Type.ValueType  # 5
        SIZE_PREFIX: BinExport2.Expression.Type.ValueType  # 6
        DEREFERENCE: BinExport2.Expression.Type.ValueType  # 7

        TYPE_FIELD_NUMBER: builtins.int
        SYMBOL_FIELD_NUMBER: builtins.int
        IMMEDIATE_FIELD_NUMBER: builtins.int
        PARENT_INDEX_FIELD_NUMBER: builtins.int
        IS_RELOCATION_FIELD_NUMBER: builtins.int
        type: global___BinExport2.Expression.Type.ValueType
        """IMMEDIATE_INT is by far the most common type and thus we can save some
        space by omitting it as the default.
        """
        symbol: builtins.str
        """Symbol for this expression. Interpretation depends on type. Examples
        include: "eax", "[", "+"
        """
        immediate: builtins.int
        """If the expression can be interpreted as an integer value (IMMEDIATE_INT)
        the value is given here.
        """
        parent_index: builtins.int
        """The parent expression. Example expression tree for the second operand of:
        mov eax, b4 [ebx + 12]
        "b4" --- "[" --- "+" --- "ebx"
                              \\  "12"
        """
        is_relocation: builtins.bool
        """true if the expression has entry in relocation table"""
        def __init__(
            self,
            *,
            type: global___BinExport2.Expression.Type.ValueType | None = ...,
            symbol: builtins.str | None = ...,
            immediate: builtins.int | None = ...,
            parent_index: builtins.int | None = ...,
            is_relocation: builtins.bool | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["immediate", b"immediate", "is_relocation", b"is_relocation", "parent_index", b"parent_index", "symbol", b"symbol", "type", b"type"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["immediate", b"immediate", "is_relocation", b"is_relocation", "parent_index", b"parent_index", "symbol", b"symbol", "type", b"type"]) -> None: ...

    @typing_extensions.final
    class Operand(google.protobuf.message.Message):
        """An instruction may have 0 or more operands."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        EXPRESSION_INDEX_FIELD_NUMBER: builtins.int
        @property
        def expression_index(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
            """Contains all expressions constituting this operand. All expressions
            should be linked into a single tree, i.e. there should only be one
            expression in this list with parent_index == NULL and all others should
            descend from that. Rendering order for expressions on the same tree level
            (siblings) is implicitly given by the order they are referenced in this
            repeated field.
            Implicit: expression sequence
            """
        def __init__(
            self,
            *,
            expression_index: collections.abc.Iterable[builtins.int] | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["expression_index", b"expression_index"]) -> None: ...

    @typing_extensions.final
    class Mnemonic(google.protobuf.message.Message):
        """An instruction has exactly 1 mnemonic."""

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        NAME_FIELD_NUMBER: builtins.int
        name: builtins.str
        """Literal representation of the mnemonic, e.g.: "mov"."""
        def __init__(
            self,
            *,
            name: builtins.str | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["name", b"name"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["name", b"name"]) -> None: ...

    @typing_extensions.final
    class Instruction(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        ADDRESS_FIELD_NUMBER: builtins.int
        CALL_TARGET_FIELD_NUMBER: builtins.int
        MNEMONIC_INDEX_FIELD_NUMBER: builtins.int
        OPERAND_INDEX_FIELD_NUMBER: builtins.int
        RAW_BYTES_FIELD_NUMBER: builtins.int
        COMMENT_INDEX_FIELD_NUMBER: builtins.int
        address: builtins.int
        """This will only be filled for instructions that do not just flow from the
        immediately preceding instruction. Regular instructions will have to
        calculate their own address by adding raw_bytes.size() to the previous
        instruction's address.
        """
        @property
        def call_target(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
            """If this is a call instruction and call targets could be determined
            they'll be given here. Note that we may or may not have a flow graph for
            the target and thus cannot use an index into the flow graph table here.
            We could potentially use call graph nodes, but linking instructions to
            the call graph directly does not seem a good choice.
            """
        mnemonic_index: builtins.int
        """Index into the mnemonic array of strings. Used for de-duping the data.
        The default value is used for the most common mnemonic in the executable.
        """
        @property
        def operand_index(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
            """Indices into the operand tree. On X86 this can be 0, 1 or 2 elements
            long, 3 elements with VEX/EVEX.
            Implicit: operand sequence
            """
        raw_bytes: builtins.bytes
        """The unmodified input bytes corresponding to this instruction."""
        @property
        def comment_index(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
            """Implicit: comment sequence"""
        def __init__(
            self,
            *,
            address: builtins.int | None = ...,
            call_target: collections.abc.Iterable[builtins.int] | None = ...,
            mnemonic_index: builtins.int | None = ...,
            operand_index: collections.abc.Iterable[builtins.int] | None = ...,
            raw_bytes: builtins.bytes | None = ...,
            comment_index: collections.abc.Iterable[builtins.int] | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["address", b"address", "mnemonic_index", b"mnemonic_index", "raw_bytes", b"raw_bytes"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["address", b"address", "call_target", b"call_target", "comment_index", b"comment_index", "mnemonic_index", b"mnemonic_index", "operand_index", b"operand_index", "raw_bytes", b"raw_bytes"]) -> None: ...

    @typing_extensions.final
    class BasicBlock(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        @typing_extensions.final
        class IndexRange(google.protobuf.message.Message):
            """This is a space optimization. The instructions for an individual basic
            block will usually be in a continuous index range. Thus it is more
            efficient to store the range instead of individual indices. However, this
            does not hold true for all basic blocks, so we need to be able to store
            multiple index ranges per block.
            """

            DESCRIPTOR: google.protobuf.descriptor.Descriptor

            BEGIN_INDEX_FIELD_NUMBER: builtins.int
            END_INDEX_FIELD_NUMBER: builtins.int
            begin_index: builtins.int
            """These work like begin and end iterators, i.e. the sequence is
            [begin_index, end_index). If the sequence only contains a single
            element end_index will be omitted.
            """
            end_index: builtins.int
            def __init__(
                self,
                *,
                begin_index: builtins.int | None = ...,
                end_index: builtins.int | None = ...,
            ) -> None: ...
            def HasField(self, field_name: typing_extensions.Literal["begin_index", b"begin_index", "end_index", b"end_index"]) -> builtins.bool: ...
            def ClearField(self, field_name: typing_extensions.Literal["begin_index", b"begin_index", "end_index", b"end_index"]) -> None: ...

        INSTRUCTION_INDEX_FIELD_NUMBER: builtins.int
        @property
        def instruction_index(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___BinExport2.BasicBlock.IndexRange]:
            """Implicit: instruction sequence"""
        def __init__(
            self,
            *,
            instruction_index: collections.abc.Iterable[global___BinExport2.BasicBlock.IndexRange] | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["instruction_index", b"instruction_index"]) -> None: ...

    @typing_extensions.final
    class FlowGraph(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        @typing_extensions.final
        class Edge(google.protobuf.message.Message):
            DESCRIPTOR: google.protobuf.descriptor.Descriptor

            class _Type:
                ValueType = typing.NewType("ValueType", builtins.int)
                V: typing_extensions.TypeAlias = ValueType

            class _TypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[BinExport2.FlowGraph.Edge._Type.ValueType], builtins.type):
                DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
                CONDITION_TRUE: BinExport2.FlowGraph.Edge._Type.ValueType  # 1
                CONDITION_FALSE: BinExport2.FlowGraph.Edge._Type.ValueType  # 2
                UNCONDITIONAL: BinExport2.FlowGraph.Edge._Type.ValueType  # 3
                SWITCH: BinExport2.FlowGraph.Edge._Type.ValueType  # 4

            class Type(_Type, metaclass=_TypeEnumTypeWrapper): ...
            CONDITION_TRUE: BinExport2.FlowGraph.Edge.Type.ValueType  # 1
            CONDITION_FALSE: BinExport2.FlowGraph.Edge.Type.ValueType  # 2
            UNCONDITIONAL: BinExport2.FlowGraph.Edge.Type.ValueType  # 3
            SWITCH: BinExport2.FlowGraph.Edge.Type.ValueType  # 4

            SOURCE_BASIC_BLOCK_INDEX_FIELD_NUMBER: builtins.int
            TARGET_BASIC_BLOCK_INDEX_FIELD_NUMBER: builtins.int
            TYPE_FIELD_NUMBER: builtins.int
            IS_BACK_EDGE_FIELD_NUMBER: builtins.int
            source_basic_block_index: builtins.int
            """Source instruction will always be the last instruction of the source
            basic block, target instruction the first instruction of the target
            basic block.
            """
            target_basic_block_index: builtins.int
            type: global___BinExport2.FlowGraph.Edge.Type.ValueType
            is_back_edge: builtins.bool
            """Indicates whether this is a loop edge as determined by Lengauer-Tarjan."""
            def __init__(
                self,
                *,
                source_basic_block_index: builtins.int | None = ...,
                target_basic_block_index: builtins.int | None = ...,
                type: global___BinExport2.FlowGraph.Edge.Type.ValueType | None = ...,
                is_back_edge: builtins.bool | None = ...,
            ) -> None: ...
            def HasField(self, field_name: typing_extensions.Literal["is_back_edge", b"is_back_edge", "source_basic_block_index", b"source_basic_block_index", "target_basic_block_index", b"target_basic_block_index", "type", b"type"]) -> builtins.bool: ...
            def ClearField(self, field_name: typing_extensions.Literal["is_back_edge", b"is_back_edge", "source_basic_block_index", b"source_basic_block_index", "target_basic_block_index", b"target_basic_block_index", "type", b"type"]) -> None: ...

        BASIC_BLOCK_INDEX_FIELD_NUMBER: builtins.int
        ENTRY_BASIC_BLOCK_INDEX_FIELD_NUMBER: builtins.int
        EDGE_FIELD_NUMBER: builtins.int
        @property
        def basic_block_index(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.int]:
            """Basic blocks are sorted by address."""
        entry_basic_block_index: builtins.int
        """The flow graph's entry point address is the first instruction of the
        entry_basic_block.
        """
        @property
        def edge(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___BinExport2.FlowGraph.Edge]: ...
        def __init__(
            self,
            *,
            basic_block_index: collections.abc.Iterable[builtins.int] | None = ...,
            entry_basic_block_index: builtins.int | None = ...,
            edge: collections.abc.Iterable[global___BinExport2.FlowGraph.Edge] | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["entry_basic_block_index", b"entry_basic_block_index"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["basic_block_index", b"basic_block_index", "edge", b"edge", "entry_basic_block_index", b"entry_basic_block_index"]) -> None: ...

    @typing_extensions.final
    class Reference(google.protobuf.message.Message):
        """Generic reference class used for address comments (deprecated), string
        references and expression substitutions. It allows referencing from an
        instruction, operand, expression subtree tuple to a de-duped string in the
        string table.
        """

        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        INSTRUCTION_INDEX_FIELD_NUMBER: builtins.int
        INSTRUCTION_OPERAND_INDEX_FIELD_NUMBER: builtins.int
        OPERAND_EXPRESSION_INDEX_FIELD_NUMBER: builtins.int
        STRING_TABLE_INDEX_FIELD_NUMBER: builtins.int
        instruction_index: builtins.int
        """Index into the global instruction table."""
        instruction_operand_index: builtins.int
        """Index into the operand array local to an instruction."""
        operand_expression_index: builtins.int
        """Index into the expression array local to an operand."""
        string_table_index: builtins.int
        """Index into the global string table."""
        def __init__(
            self,
            *,
            instruction_index: builtins.int | None = ...,
            instruction_operand_index: builtins.int | None = ...,
            operand_expression_index: builtins.int | None = ...,
            string_table_index: builtins.int | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["instruction_index", b"instruction_index", "instruction_operand_index", b"instruction_operand_index", "operand_expression_index", b"operand_expression_index", "string_table_index", b"string_table_index"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["instruction_index", b"instruction_index", "instruction_operand_index", b"instruction_operand_index", "operand_expression_index", b"operand_expression_index", "string_table_index", b"string_table_index"]) -> None: ...

    @typing_extensions.final
    class DataReference(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        INSTRUCTION_INDEX_FIELD_NUMBER: builtins.int
        ADDRESS_FIELD_NUMBER: builtins.int
        instruction_index: builtins.int
        """Index into the global instruction table."""
        address: builtins.int
        """Address being referred."""
        def __init__(
            self,
            *,
            instruction_index: builtins.int | None = ...,
            address: builtins.int | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["address", b"address", "instruction_index", b"instruction_index"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["address", b"address", "instruction_index", b"instruction_index"]) -> None: ...

    @typing_extensions.final
    class Comment(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        class _Type:
            ValueType = typing.NewType("ValueType", builtins.int)
            V: typing_extensions.TypeAlias = ValueType

        class _TypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[BinExport2.Comment._Type.ValueType], builtins.type):
            DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
            DEFAULT: BinExport2.Comment._Type.ValueType  # 0
            """A regular instruction comment. Typically displayed next to the
            instruction disassembly.
            """
            ANTERIOR: BinExport2.Comment._Type.ValueType  # 1
            """A comment line that is typically displayed before (above) the
            instruction it refers to.
            """
            POSTERIOR: BinExport2.Comment._Type.ValueType  # 2
            """Like ANTERIOR, but a typically displayed after (below)."""
            FUNCTION: BinExport2.Comment._Type.ValueType  # 3
            """Similar to an ANTERIOR comment, but applies to the beginning of an
            identified function. Programs displaying the proto may choose to render
            these differently (e.g. above an inferred function signature).
            """
            ENUM: BinExport2.Comment._Type.ValueType  # 4
            """Named constants, bitfields and similar."""
            LOCATION: BinExport2.Comment._Type.ValueType  # 5
            """Named locations, usually the target of a jump."""
            GLOBAL_REFERENCE: BinExport2.Comment._Type.ValueType  # 6
            """Data cross references."""
            LOCAL_REFERENCE: BinExport2.Comment._Type.ValueType  # 7
            """Local/stack variables."""

        class Type(_Type, metaclass=_TypeEnumTypeWrapper): ...
        DEFAULT: BinExport2.Comment.Type.ValueType  # 0
        """A regular instruction comment. Typically displayed next to the
        instruction disassembly.
        """
        ANTERIOR: BinExport2.Comment.Type.ValueType  # 1
        """A comment line that is typically displayed before (above) the
        instruction it refers to.
        """
        POSTERIOR: BinExport2.Comment.Type.ValueType  # 2
        """Like ANTERIOR, but a typically displayed after (below)."""
        FUNCTION: BinExport2.Comment.Type.ValueType  # 3
        """Similar to an ANTERIOR comment, but applies to the beginning of an
        identified function. Programs displaying the proto may choose to render
        these differently (e.g. above an inferred function signature).
        """
        ENUM: BinExport2.Comment.Type.ValueType  # 4
        """Named constants, bitfields and similar."""
        LOCATION: BinExport2.Comment.Type.ValueType  # 5
        """Named locations, usually the target of a jump."""
        GLOBAL_REFERENCE: BinExport2.Comment.Type.ValueType  # 6
        """Data cross references."""
        LOCAL_REFERENCE: BinExport2.Comment.Type.ValueType  # 7
        """Local/stack variables."""

        INSTRUCTION_INDEX_FIELD_NUMBER: builtins.int
        INSTRUCTION_OPERAND_INDEX_FIELD_NUMBER: builtins.int
        OPERAND_EXPRESSION_INDEX_FIELD_NUMBER: builtins.int
        STRING_TABLE_INDEX_FIELD_NUMBER: builtins.int
        REPEATABLE_FIELD_NUMBER: builtins.int
        TYPE_FIELD_NUMBER: builtins.int
        instruction_index: builtins.int
        """Index into the global instruction table. This is here to enable
        comment processing without having to iterate over all instructions.
        There is an N:M mapping of instructions to comments.
        """
        instruction_operand_index: builtins.int
        """Index into the operand array local to an instruction."""
        operand_expression_index: builtins.int
        """Index into the expression array local to an operand, like in Reference.
        This is not currently used, but allows to implement expression
        substitutions.
        """
        string_table_index: builtins.int
        """Index into the global string table."""
        repeatable: builtins.bool
        """Comment is propagated to all locations that reference the original
        location.
        """
        type: global___BinExport2.Comment.Type.ValueType
        def __init__(
            self,
            *,
            instruction_index: builtins.int | None = ...,
            instruction_operand_index: builtins.int | None = ...,
            operand_expression_index: builtins.int | None = ...,
            string_table_index: builtins.int | None = ...,
            repeatable: builtins.bool | None = ...,
            type: global___BinExport2.Comment.Type.ValueType | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["instruction_index", b"instruction_index", "instruction_operand_index", b"instruction_operand_index", "operand_expression_index", b"operand_expression_index", "repeatable", b"repeatable", "string_table_index", b"string_table_index", "type", b"type"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["instruction_index", b"instruction_index", "instruction_operand_index", b"instruction_operand_index", "operand_expression_index", b"operand_expression_index", "repeatable", b"repeatable", "string_table_index", b"string_table_index", "type", b"type"]) -> None: ...

    @typing_extensions.final
    class Section(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        ADDRESS_FIELD_NUMBER: builtins.int
        SIZE_FIELD_NUMBER: builtins.int
        FLAG_R_FIELD_NUMBER: builtins.int
        FLAG_W_FIELD_NUMBER: builtins.int
        FLAG_X_FIELD_NUMBER: builtins.int
        address: builtins.int
        """Section start address."""
        size: builtins.int
        """Section size."""
        flag_r: builtins.bool
        """Read flag of the section, True when section is readable."""
        flag_w: builtins.bool
        """Write flag of the section, True when section is writable."""
        flag_x: builtins.bool
        """Execute flag of the section, True when section is executable."""
        def __init__(
            self,
            *,
            address: builtins.int | None = ...,
            size: builtins.int | None = ...,
            flag_r: builtins.bool | None = ...,
            flag_w: builtins.bool | None = ...,
            flag_x: builtins.bool | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["address", b"address", "flag_r", b"flag_r", "flag_w", b"flag_w", "flag_x", b"flag_x", "size", b"size"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["address", b"address", "flag_r", b"flag_r", "flag_w", b"flag_w", "flag_x", b"flag_x", "size", b"size"]) -> None: ...

    @typing_extensions.final
    class Library(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        IS_STATIC_FIELD_NUMBER: builtins.int
        LOAD_ADDRESS_FIELD_NUMBER: builtins.int
        NAME_FIELD_NUMBER: builtins.int
        is_static: builtins.bool
        """If this library is statically linked."""
        load_address: builtins.int
        """Address where this library was loaded, 0 if unknown."""
        name: builtins.str
        """Name of the library (format is platform-dependent)."""
        def __init__(
            self,
            *,
            is_static: builtins.bool | None = ...,
            load_address: builtins.int | None = ...,
            name: builtins.str | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["is_static", b"is_static", "load_address", b"load_address", "name", b"name"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["is_static", b"is_static", "load_address", b"load_address", "name", b"name"]) -> None: ...

    @typing_extensions.final
    class Module(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        NAME_FIELD_NUMBER: builtins.int
        name: builtins.str
        """Name, such as Java class name. Platform-dependent."""
        def __init__(
            self,
            *,
            name: builtins.str | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["name", b"name"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["name", b"name"]) -> None: ...

    META_INFORMATION_FIELD_NUMBER: builtins.int
    EXPRESSION_FIELD_NUMBER: builtins.int
    OPERAND_FIELD_NUMBER: builtins.int
    MNEMONIC_FIELD_NUMBER: builtins.int
    INSTRUCTION_FIELD_NUMBER: builtins.int
    BASIC_BLOCK_FIELD_NUMBER: builtins.int
    FLOW_GRAPH_FIELD_NUMBER: builtins.int
    CALL_GRAPH_FIELD_NUMBER: builtins.int
    STRING_TABLE_FIELD_NUMBER: builtins.int
    ADDRESS_COMMENT_FIELD_NUMBER: builtins.int
    COMMENT_FIELD_NUMBER: builtins.int
    STRING_REFERENCE_FIELD_NUMBER: builtins.int
    EXPRESSION_SUBSTITUTION_FIELD_NUMBER: builtins.int
    SECTION_FIELD_NUMBER: builtins.int
    LIBRARY_FIELD_NUMBER: builtins.int
    DATA_REFERENCE_FIELD_NUMBER: builtins.int
    MODULE_FIELD_NUMBER: builtins.int
    @property
    def meta_information(self) -> global___BinExport2.Meta: ...
    @property
    def expression(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___BinExport2.Expression]: ...
    @property
    def operand(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___BinExport2.Operand]: ...
    @property
    def mnemonic(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___BinExport2.Mnemonic]: ...
    @property
    def instruction(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___BinExport2.Instruction]: ...
    @property
    def basic_block(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___BinExport2.BasicBlock]: ...
    @property
    def flow_graph(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___BinExport2.FlowGraph]: ...
    @property
    def call_graph(self) -> global___BinExport2.CallGraph: ...
    @property
    def string_table(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
    @property
    def address_comment(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___BinExport2.Reference]:
        """No longer written. This is here so that BinDiff can work with older
        BinExport files.
        """
    @property
    def comment(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___BinExport2.Comment]:
        """Rich comment index used for BinDiff's comment porting."""
    @property
    def string_reference(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___BinExport2.Reference]: ...
    @property
    def expression_substitution(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___BinExport2.Reference]: ...
    @property
    def section(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___BinExport2.Section]: ...
    @property
    def library(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___BinExport2.Library]: ...
    @property
    def data_reference(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___BinExport2.DataReference]: ...
    @property
    def module(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___BinExport2.Module]: ...
    def __init__(
        self,
        *,
        meta_information: global___BinExport2.Meta | None = ...,
        expression: collections.abc.Iterable[global___BinExport2.Expression] | None = ...,
        operand: collections.abc.Iterable[global___BinExport2.Operand] | None = ...,
        mnemonic: collections.abc.Iterable[global___BinExport2.Mnemonic] | None = ...,
        instruction: collections.abc.Iterable[global___BinExport2.Instruction] | None = ...,
        basic_block: collections.abc.Iterable[global___BinExport2.BasicBlock] | None = ...,
        flow_graph: collections.abc.Iterable[global___BinExport2.FlowGraph] | None = ...,
        call_graph: global___BinExport2.CallGraph | None = ...,
        string_table: collections.abc.Iterable[builtins.str] | None = ...,
        address_comment: collections.abc.Iterable[global___BinExport2.Reference] | None = ...,
        comment: collections.abc.Iterable[global___BinExport2.Comment] | None = ...,
        string_reference: collections.abc.Iterable[global___BinExport2.Reference] | None = ...,
        expression_substitution: collections.abc.Iterable[global___BinExport2.Reference] | None = ...,
        section: collections.abc.Iterable[global___BinExport2.Section] | None = ...,
        library: collections.abc.Iterable[global___BinExport2.Library] | None = ...,
        data_reference: collections.abc.Iterable[global___BinExport2.DataReference] | None = ...,
        module: collections.abc.Iterable[global___BinExport2.Module] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["call_graph", b"call_graph", "meta_information", b"meta_information"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["address_comment", b"address_comment", "basic_block", b"basic_block", "call_graph", b"call_graph", "comment", b"comment", "data_reference", b"data_reference", "expression", b"expression", "expression_substitution", b"expression_substitution", "flow_graph", b"flow_graph", "instruction", b"instruction", "library", b"library", "meta_information", b"meta_information", "mnemonic", b"mnemonic", "module", b"module", "operand", b"operand", "section", b"section", "string_reference", b"string_reference", "string_table", b"string_table"]) -> None: ...

global___BinExport2 = BinExport2
