# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.


COM_INTERFACES: dict[str, list[str]] = {
    "IClusterApplicationWizard": ["24F97151-6689-11D1-9AA7-00C04FB93A80"],
    "IWEExtendWizard97": ["97DEDE68-FC6B-11CF-B5F5-00A0C90AB505"],
    "IWCWizard97Callback": ["97DEDE67-FC6B-11CF-B5F5-00A0C90AB505"],
    "IWEInvokeCommand": ["97DEDE66-FC6B-11CF-B5F5-00A0C90AB505"],
    "IWEExtendContextMenu": ["97DEDE65-FC6B-11CF-B5F5-00A0C90AB505"],
    "IWCContextMenuCallback": ["97DEDE64-FC6B-11CF-B5F5-00A0C90AB505"],
    "IWEExtendWizard": ["97DEDE63-FC6B-11CF-B5F5-00A0C90AB505"],
    "IWCWizardCallback": ["97DEDE62-FC6B-11CF-B5F5-00A0C90AB505"],
    "IWEExtendPropertySheet": ["97DEDE61-FC6B-11CF-B5F5-00A0C90AB505"],
    "IWCPropertySheetCallback": ["97DEDE60-FC6B-11CF-B5F5-00A0C90AB505"],
    "IGetClusterNetInterfaceInfo": ["97DEDE57-FC6B-11CF-B5F5-00A0C90AB505"],
    "IGetClusterNetworkInfo": ["97DEDE56-FC6B-11CF-B5F5-00A0C90AB505"],
    "IGetClusterResourceInfo": ["97DEDE55-FC6B-11CF-B5F5-00A0C90AB505"],
    "IGetClusterGroupInfo": ["97DEDE54-FC6B-11CF-B5F5-00A0C90AB505"],
    "IGetClusterNodeInfo": ["97DEDE53-FC6B-11CF-B5F5-00A0C90AB505"],
    "IGetClusterObjectInfo": ["97DEDE52-FC6B-11CF-B5F5-00A0C90AB505"],
    "IGetClusterDataInfo": ["97DEDE51-FC6B-11CF-B5F5-00A0C90AB505"],
    "IGetClusterUIInfo": ["97DEDE50-FC6B-11CF-B5F5-00A0C90AB505"],
    "AsyncIClusCfgEvictNotify": ["AD2E83CC-1D14-4D20-928E-22D344847454"],
    "IClusCfgEvictNotify": ["090E7745-9E5B-4D76-936E-D760CF2FF3B9"],
    "AsyncIClusCfgEvictListener": ["08609AC3-D284-4009-805F-17D3CFE4160B"],
    "IClusCfgEvictListener": ["E20DDEE3-DEFC-4D54-B1F7-2AEB784C3847"],
    "IClusCfgVerifyQuorum": ["90A2EFAE-1B62-4ADA-BF1C-BECAB56F748D"],
    "IClusCfgManagedResourceData": ["8447ECB7-2171-4E21-A108-0EB5B0B516DA"],
    "AsyncIClusCfgStartupNotify": ["C2B0D06A-6353-4EE1-B253-6B0D75DB2CD3"],
    "IClusCfgStartupNotify": ["C2B0D069-6353-4EE1-B253-6B0D75DB2CD3"],
    "AsyncIClusCfgStartupListener": ["D282CAF0-2EDE-4AB9-A5D5-F7BDE3D23F10"],
    "IClusCfgStartupListener": ["D282CAEF-2EDE-4AB9-A5D5-F7BDE3D23F0F"],
    "AsyncIClusCfgEvictCleanup": ["6FE3E362-D373-4C5F-A0AF-1DFE8493C655"],
    "IClusCfgEvictCleanup": ["6FE3E361-D373-4C5F-A0AF-1DFE8493C655"],
    "AsyncIClusCfgResourceTypeCreate": ["3AFCE3B9-5F3E-4DDF-A8F4-4B4FCBF28F8F"],
    "IClusCfgResourceTypeCreate": ["3AFCE3B8-5F3E-4DDF-A8F4-4B4FCBF28F8F"],
    "AsyncIClusCfgResourceTypeInfo": ["C649A282-C847-4F5C-9841-D2F73B5AA71D"],
    "IClusCfgResourceTypeInfo": ["C649A281-C847-4F5C-9841-D2F73B5AA71D"],
    "AsyncIClusCfgMemberSetChangeListener": ["2B645350-2643-4ABC-A4E5-824D881B7582"],
    "IClusCfgMemberSetChangeListener": ["2B64534F-2643-4ABC-A4E5-824D881B7582"],
    "IClusCfgGroupCfg": ["DCB6D3D2-A55F-49E5-A64A-0CCFEB01ED3A"],
    "IClusCfgResourcePostCreate": ["72A9BF54-13B6-451F-910D-6913EBF025AB"],
    "IClusCfgResourceCreate": ["0647B41A-C777-443C-9432-02CCCF4FF443"],
    "IClusCfgResourcePreCreate": ["4240F6A1-9D49-427E-8F3D-09384E1F59E4"],
    "IClusCfgManagedResourceCfg": ["60300A0F-77E1-440C-BD94-6BFB0DBFDB3A"],
    "IClusCfgCapabilities": ["D94AB253-36C7-41C1-B52E-26B451975C8D"],
    "AsyncIClusCfgCredentials": ["54AA9406-A409-4B49-B314-5F0A0CE4C88F"],
    "IClusCfgCredentials": ["54AA9406-A409-4B49-B314-5F0A0CE4C88E"],
    "AsyncIClusCfgCallback": ["EBCE8945-AC69-4B3A-865D-E2D4EB33E41B"],
    "IClusCfgCallback": ["238DCA63-E2EF-4F32-A24D-ACBF975BE842"],
    "AsyncIClusCfgInitialize": ["2A0EB82E-F878-492A-951E-AE000918C4A6"],
    "IClusCfgInitialize": ["2A0EB82D-F878-492A-951E-AE000918C4A6"],
    "AsyncIClusCfgClusterInfo": ["8BDBA247-04F5-4114-837E-B263412A4B64"],
    "IClusCfgClusterInfo": ["85B4BBC0-DDC4-4AE7-8268-F4850BB2A6EE"],
    "AsyncIClusCfgNetworkInfo": ["ED71FD2D-AD02-4DFC-B376-5FFA5F5A7C2C"],
    "IClusCfgNetworkInfo": ["19FC7580-950A-44A6-966E-74B14B20918F"],
    "AsyncIClusCfgIPAddressInfo": ["AAEAF0A5-E310-4604-A55E-2F9DDC4157A9"],
    "IClusCfgIPAddressInfo": ["AAEAF0A5-E310-4604-A55E-2F9DDC4157A8"],
    "AsyncIEnumClusCfgIPAddresses": ["BD5F35BA-0BC0-455F-926D-C3D356419487"],
    "IEnumClusCfgIPAddresses": ["BD5F35BA-0BC0-455F-926D-C3D356419486"],
    "AsyncIClusCfgPartitionInfo": ["EC1EBD9F-5866-4846-8952-EC36C3961EEF"],
    "IClusCfgPartitionInfo": ["EC1EBD9F-5866-4846-8952-EC36C3961EEE"],
    "AsyncIEnumClusCfgPartitions": ["4440BB6A-B0AC-479D-B534-7265A31D6C56"],
    "IEnumClusCfgPartitions": ["4440BB6A-B0AC-479D-B534-7265A31D6C55"],
    "AsyncIClusCfgManagedResourceInfo": ["0560D153-892F-4BF5-87B0-06AF2803955C"],
    "IClusCfgManagedResourceInfo": ["8389D687-DF99-442B-81AB-58BA5B029688"],
    "AsyncIEnumClusCfgNetworks": ["F56B9B0D-E7B8-49EC-A843-5475076B947D"],
    "IEnumClusCfgNetworks": ["CF3FAED8-1322-4BCB-9923-B5B745A69E36"],
    "AsyncIEnumClusCfgManagedResources": ["B138483F-9695-4FA6-A98F-0DE2FB355449"],
    "IEnumClusCfgManagedResources": ["7DBE11EB-A5DF-4534-ABF6-8BAC7B53FC95"],
    "AsyncIClusCfgNodeInfo": ["4F3BB40B-DF27-40A0-B31A-BA18324CEB9D"],
    "IClusCfgNodeInfo": ["E4B5FA15-DD07-439E-A623-8823524E3D19"],
    "IClusCfgAddNodesWizard": ["9DA133CB-3B08-4C30-967E-56D96047F10C"],
    "IClusCfgCreateClusterWizard": ["F65C6990-A144-4127-AB6E-3712B75F1843"],
    "IInterfaceRelated": ["D1FB5A79-7706-11D1-ADBA-00C04FC2ADC0"],
    "ICallFrameWalker": ["08B23919-392D-11D2-B8A4-00C04FB9618A"],
    "ICallUnmarshal": ["5333B003-2E42-11D2-B89D-00C04FB9618A"],
    "ICallFrameEvents": ["FD5E0843-FC91-11D0-97D7-00C04FB9618A"],
    "ICallInterceptor": ["60C7CA75-896D-11D2-B8B6-00C04FB9618A"],
    "ICallIndirect": ["D573B4B1-894E-11D2-B8B6-00C04FB9618A"],
    "ICallFrame": ["D573B4B0-894E-11D2-B8B6-00C04FB9618A"],
    "IContextCallback": ["000001DA-0000-0000-C000-000000000046"],
    "IAuditControl": ["1DA6292F-BC66-11CE-AAE3-00AA004C2737"],
    "IAccessControl": ["EEDD23E0-8410-11CE-A1C3-08002B2B8D8F"],
    "ISpecialSystemProperties": ["000001B9-0000-0000-C000-000000000046"],
    "IOpaqueDataInfo": ["000001A9-0000-0000-C000-000000000046"],
    "IStandardActivator": ["000001B8-0000-0000-C000-000000000046"],
    "IPropertyBag": ["55272A00-42CB-11CE-8135-00AA004BB851"],
    "IErrorLog": ["3127CA40-446E-11CE-8135-00AA004BB851"],
    "IRecordInfo": ["0000002F-0000-0000-C000-000000000046"],
    "ITypeMarshal": ["0000002D-0000-0000-C000-000000000046"],
    "ITypeFactory": ["0000002E-0000-0000-C000-000000000046"],
    "ISupportErrorInfo": ["DF0B3D60-548F-101B-8E65-08002B2BD119"],
    "ICreateErrorInfo": ["22F03340-547D-101B-8E65-08002B2BD119"],
    "IErrorInfo": ["1CF2B120-547D-101B-8E65-08002B2BD119"],
    "ITypeChangeEvents": ["00020410-0000-0000-C000-000000000046"],
    "ITypeLib2": ["00020411-0000-0000-C000-000000000046"],
    "ITypeLib": ["00020402-0000-0000-C000-000000000046"],
    "ITypeInfo2": ["00020412-0000-0000-C000-000000000046"],
    "ITypeInfo": ["00020401-0000-0000-C000-000000000046"],
    "ITypeComp": ["00020403-0000-0000-C000-000000000046"],
    "IEnumVARIANT": ["00020404-0000-0000-C000-000000000046"],
    "IDispatch": ["00020400-0000-0000-C000-000000000046"],
    "ICreateTypeLib2": ["0002040F-0000-0000-C000-000000000046"],
    "ICreateTypeLib": ["00020406-0000-0000-C000-000000000046"],
    "ICreateTypeInfo2": ["0002040E-0000-0000-C000-000000000046"],
    "ICreateTypeInfo": ["00020405-0000-0000-C000-000000000046"],
    "IInitializeSpy": ["00000034-0000-0000-C000-000000000046"],
    "IProcessInitControl": ["72380D55-8D2B-43A3-8513-2B6EF31434E9"],
    "IComThreadingInfo": ["000001CE-0000-0000-C000-000000000046"],
    "ISurrogateService": ["000001D4-0000-0000-C000-000000000046"],
    "IProcessLock": ["000001D5-0000-0000-C000-000000000046"],
    "IObjContext": ["000001C6-0000-0000-C000-000000000046"],
    "IContext": ["000001C0-0000-0000-C000-000000000046"],
    "IEnumContextProps": ["000001C1-0000-0000-C000-000000000046"],
    "IDummyHICONIncluder": ["947990DE-CC28-11D2-A0F7-00805F858FB1"],
    "IThumbnailExtractor": ["969DC708-5C76-11D1-8D86-0000F804B057"],
    "AsyncIPipeDouble": ["DB2F3ACF-2F86-11D1-8E04-00C04FB9989A"],
    "IPipeDouble": ["DB2F3ACE-2F86-11D1-8E04-00C04FB9989A"],
    "AsyncIPipeLong": ["DB2F3ACD-2F86-11D1-8E04-00C04FB9989A"],
    "IPipeLong": ["DB2F3ACC-2F86-11D1-8E04-00C04FB9989A"],
    "AsyncIPipeByte": ["DB2F3ACB-2F86-11D1-8E04-00C04FB9989A"],
    "IPipeByte": ["DB2F3ACA-2F86-11D1-8E04-00C04FB9989A"],
    "IAddrExclusionControl": ["00000148-0000-0000-C000-000000000046"],
    "IAddrTrackingControl": ["00000147-0000-0000-C000-000000000046"],
    "IForegroundTransfer": ["00000145-0000-0000-C000-000000000046"],
    "IUrlMon": ["00000026-0000-0000-C000-000000000046"],
    "IWaitMultiple": ["0000002B-0000-0000-C000-000000000046"],
    "IReleaseMarshalBuffers": ["EB0CB9E8-7996-11D2-872E-0000F8080859"],
    "IRpcHelper": ["00000149-0000-0000-C000-000000000046"],
    "ICallFactory": ["1C733A30-2A1C-11CE-ADE5-00AA0044773D"],
    "IAsyncManager": ["0000002A-0000-0000-C000-000000000046"],
    "ICancelMethodCalls": ["00000029-0000-0000-C000-000000000046"],
    "ISynchronizeMutex": ["00000025-0000-0000-C000-000000000046"],
    "ISynchronizeContainer": ["00000033-0000-0000-C000-000000000046"],
    "ISynchronizeEvent": ["00000032-0000-0000-C000-000000000046"],
    "ISynchronizeHandle": ["00000031-0000-0000-C000-000000000046"],
    "ISynchronize": ["00000030-0000-0000-C000-000000000046"],
    "IDirectWriterLock": ["0E6D4D92-6738-11CF-9608-00AA00680DB4"],
    "IGlobalInterfaceTable": ["00000146-0000-0000-C000-000000000046"],
    "ISurrogate": ["00000022-0000-0000-C000-000000000046"],
    "IOplockStorage": ["8D19C834-8879-11D1-83E9-00C04FC2C6D4"],
    "ITimeAndNoticeControl": ["BC0BF6AE-8878-11D1-83E9-00C04FC2C6D4"],
    "IBlockingLock": ["30F3D47A-6447-11D1-8E3C-00C04FB9386D"],
    "ILayoutStorage": ["0E6D4D90-6738-11CF-9608-00AA00680DB4"],
    "IProgressNotify": ["A9D758A0-4617-11CF-95FC-00AA00680DB4"],
    "IFillLockBytes": ["99CAF010-415E-11CF-8814-00AA00B569F5"],
    "IRpcOptions": ["00000144-0000-0000-C000-000000000046"],
    "IClassActivator": ["00000140-0000-0000-C000-000000000046"],
    "IServerSecurity": ["0000013E-0000-0000-C000-000000000046"],
    "IClientSecurity": ["0000013D-0000-0000-C000-000000000046"],
    "IChannelHook": ["1008C4A0-7613-11CF-9AF1-0020AF6E72F4"],
    "IPSFactoryBuffer": ["D5F569D0-593B-101A-B569-08002B2DBF7A"],
    "IRpcStubBuffer": ["D5F56AFC-593B-101A-B569-08002B2DBF7A"],
    "IRpcProxyBuffer": ["D5F56A34-593B-101A-B569-08002B2DBF7A"],
    "IRpcSyntaxNegotiate": ["58A08519-24C8-4935-B482-3FD823333A4F"],
    "IRpcChannelBuffer3": ["25B15600-0115-11D0-BF0D-00AA00B8DFD2"],
    "IAsyncRpcChannelBuffer": ["A5029FB6-3C34-11D1-9C99-00C04FB998AA"],
    "IRpcChannelBuffer2": ["594F31D0-7F19-11D0-B194-00A0C90DC8BF"],
    "IRpcChannelBuffer": ["D5F56B60-593B-101A-B569-08002B2DBF7A"],
    "IMessageFilter": ["00000016-0000-0000-C000-000000000046"],
    "IDataAdviseHolder": ["00000110-0000-0000-C000-000000000046"],
    "IDataObject": ["0000010E-0000-0000-C000-000000000046"],
    "AsyncIAdviseSink2": ["00000151-0000-0000-C000-000000000046"],
    "IAdviseSink2": ["00000125-0000-0000-C000-000000000046"],
    "AsyncIAdviseSink": ["00000150-0000-0000-C000-000000000046"],
    "IAdviseSink": ["0000010F-0000-0000-C000-000000000046"],
    "IRootStorage": ["00000012-0000-0000-C000-000000000046"],
    "IEnumSTATDATA": ["00000105-0000-0000-C000-000000000046"],
    "IEnumFORMATETC": ["00000103-0000-0000-C000-000000000046"],
    "ILockBytes": ["0000000A-0000-0000-C000-000000000046"],
    "IPersistStorage": ["0000010A-0000-0000-C000-000000000046"],
    "IPersistFile": ["0000010B-0000-0000-C000-000000000046"],
    "IStorage": ["0000000B-0000-0000-C000-000000000046"],
    "IEnumSTATSTG": ["0000000D-0000-0000-C000-000000000046"],
    "IStream": ["0000000C-0000-0000-C000-000000000046"],
    "ISequentialStream": ["0C733A30-2A1C-11CE-ADE5-00AA0044773D"],
    "IEnumString": ["00000101-0000-0000-C000-000000000046"],
    "IROTData": ["F29F6BC0-5021-11CE-AA15-00006901293F"],
    "IMoniker": ["0000000F-0000-0000-C000-000000000046"],
    "IPersistStream": ["00000109-0000-0000-C000-000000000046"],
    "IPersist": ["0000010C-0000-0000-C000-000000000046"],
    "IRunningObjectTable": ["00000010-0000-0000-C000-000000000046"],
    "IRunnableObject": ["00000126-0000-0000-C000-000000000046"],
    "IEnumMoniker": ["00000102-0000-0000-C000-000000000046"],
    "IBindCtx": ["0000000E-0000-0000-C000-000000000046"],
    "IEnumUnknown": ["00000100-0000-0000-C000-000000000046"],
    "IInternalUnknown": ["00000021-0000-0000-C000-000000000046"],
    "AsyncIMultiQI": ["000E0020-0000-0000-C000-000000000046"],
    "IMultiQI": ["00000020-0000-0000-C000-000000000046"],
    "IExternalConnection": ["00000019-0000-0000-C000-000000000046"],
    "IStdMarshalInfo": ["00000018-0000-0000-C000-000000000046"],
    "IMallocSpy": ["0000001D-0000-0000-C000-000000000046"],
    "IMalloc": ["00000002-0000-0000-C000-000000000046"],
    "IMarshal2": ["000001CF-0000-0000-C000-000000000046"],
    "IMarshal": ["00000003-0000-0000-C000-000000000046"],
    "IQuickActivate": ["CF51ED10-62FE-11CF-BF86-00A0C9034836"],
    "IAdviseSinkEx": ["3AF24290-0C96-11CE-A0CF-00AA00600AB8"],
    "IPersistPropertyBag2": ["22F55881-280B-11D0-A8A9-00A0C90C2004"],
    "IPropertyBag2": ["22F55882-280B-11D0-A8A9-00A0C90C2004"],
    "IPerPropertyBrowsing": ["376BD3AA-3845-101B-84ED-08002B2EC713"],
    "IObjectWithSite": ["FC4801A3-2BA9-11CF-A229-00AA003D7352"],
    "IPointerInactive": ["55980BA0-35AA-11CF-B671-00AA004CD6D8"],
    "IOleUndoManager": ["D001F200-EF97-11CE-9BC9-00AA00608E01"],
    "IEnumOleUndoUnits": ["B3E7C340-EF97-11CE-9BC9-00AA00608E01"],
    "IOleParentUndoUnit": ["A1FAF330-EF97-11CE-9BC9-00AA00608E01"],
    "IOleUndoUnit": ["894AD3B0-EF97-11CE-9BC9-00AA00608E01"],
    "IViewObjectEx": ["3AF24292-0C96-11CE-A0CF-00AA00600AB8"],
    "IOleInPlaceSiteWindowless": ["922EADA0-3424-11CF-B670-00AA004CD6D8"],
    "IOleInPlaceSiteEx": ["9C2CAD80-3424-11CF-B670-00AA004CD6D8"],
    "IOleInPlaceObjectWindowless": ["1C2056CC-5EF4-101B-8BC8-00AA003E3B29"],
    "IPictureDisp": ["7BF80981-BF32-101A-8BBB-00AA00300CAB"],
    "IFontDisp": ["BEF6E003-A874-101A-8BBA-00AA00300CAB"],
    "IFontEventsDisp": ["4EF6100A-AF88-11D0-9846-00C04FC29993"],
    "IPicture": ["7BF80980-BF32-101A-8BBB-00AA00300CAB"],
    "IFont": ["BEF6E002-A874-101A-8BBA-00AA00300CAB"],
    "ISimpleFrameSite": ["742B0E01-14E6-101B-914E-00AA00300CAB"],
    "IPersistPropertyBag": ["37D84F60-42CB-11CE-8135-00AA004BB851"],
    "IPersistStreamInit": ["7FD52380-4E07-101B-AE2D-08002B2EC713"],
    "IPersistMemory": ["BD1AE5E0-A6AE-11CE-BD37-504200C10000"],
    "ISpecifyPropertyPages": ["B196B28B-BAB4-101A-B69C-00AA00341D07"],
    "IPropertyNotifySink": ["9BFBBC02-EFF1-101A-84ED-00AA00341D07"],
    "IPropertyPageSite": ["B196B28C-BAB4-101A-B69C-00AA00341D07"],
    "IPropertyPage2": ["01E44665-24AC-101B-84ED-08002B2EC713"],
    "IPropertyPage": ["B196B28D-BAB4-101A-B69C-00AA00341D07"],
    "IOleControlSite": ["B196B289-BAB4-101A-B69C-00AA00341D07"],
    "IOleControl": ["B196B288-BAB4-101A-B69C-00AA00341D07"],
    "IProvideMultipleClassInfo": ["A7ABA9C1-8983-11CF-8F20-00805F2CD064"],
    "IProvideClassInfo2": ["A6BC3AC0-DBAA-11CE-9DE3-00AA004BB851"],
    "IProvideClassInfo": ["B196B283-BAB4-101A-B69C-00AA00341D07"],
    "IClassFactory2": ["B196B28F-BAB4-101A-B69C-00AA00341D07"],
    "IConnectionPointContainer": ["B196B284-BAB4-101A-B69C-00AA00341D07"],
    "IEnumConnectionPoints": ["B196B285-BAB4-101A-B69C-00AA00341D07"],
    "IConnectionPoint": ["B196B286-BAB4-101A-B69C-00AA00341D07"],
    "IEnumConnections": ["B196B287-BAB4-101A-B69C-00AA00341D07"],
    "IMultiplePropertyAccess": ["EC81FEDE-D432-11CE-9244-0020AF6E72DB"],
    "IDifferencing": ["994F0AF0-2977-11CE-BB80-08002B36B2B0"],
    "IReconcileInitiator": ["99180161-DA16-101A-935C-444553540000"],
    "IReconcilableObject": ["99180162-DA16-101A-935C-444553540000"],
    "INotifyReplica": ["99180163-DA16-101A-935C-444553540000"],
    "IPropertySetContainer": ["B4FFAE60-A7CA-11CD-B58B-00006B829156"],
    "IEnumOLEVERB": ["00000104-0000-0000-C000-000000000046"],
    "IDropTarget": ["00000122-0000-0000-C000-000000000046"],
    "IDropSource": ["00000121-0000-0000-C000-000000000046"],
    "IViewObject2": ["00000127-0000-0000-C000-000000000046"],
    "IViewObject": ["0000010D-0000-0000-C000-000000000046"],
    "IContinue": ["0000012A-0000-0000-C000-000000000046"],
    "IOleInPlaceSite": ["00000119-0000-0000-C000-000000000046"],
    "IOleInPlaceObject": ["00000113-0000-0000-C000-000000000046"],
    "IOleInPlaceFrame": ["00000116-0000-0000-C000-000000000046"],
    "IOleInPlaceActiveObject": ["00000117-0000-0000-C000-000000000046"],
    "IOleInPlaceUIWindow": ["00000115-0000-0000-C000-000000000046"],
    "IOleItemContainer": ["0000011C-0000-0000-C000-000000000046"],
    "IOleLink": ["0000011D-0000-0000-C000-000000000046"],
    "IOleWindow": ["00000114-0000-0000-C000-000000000046"],
    "IOleObject": ["00000112-0000-0000-C000-000000000046"],
    "IOleClientSite": ["00000118-0000-0000-C000-000000000046"],
    "IOleContainer": ["0000011B-0000-0000-C000-000000000046"],
    "IParseDisplayName": ["0000011A-0000-0000-C000-000000000046"],
    "IOleCacheControl": ["00000129-0000-0000-C000-000000000046"],
    "IOleCache2": ["00000128-0000-0000-C000-000000000046"],
    "IOleCache": ["0000011E-0000-0000-C000-000000000046"],
    "IOleAdviseHolder": ["00000111-0000-0000-C000-000000000046"],
    "IEnumSTATPROPBAG": ["20021801-5DE6-11D1-8E38-00C04FB9386D"],
    "IPropertyBagEx": ["20011801-5DE6-11D1-8E38-00C04FB9386D"],
    "IEnumSTATPROPSETSTG": ["0000013B-0000-0000-C000-000000000046"],
    "IEnumSTATPROPSTG": ["00000139-0000-0000-C000-000000000046"],
    "IPropertySetStorage": ["0000013A-0000-0000-C000-000000000046"],
    "IPropertyStorage": ["00000138-0000-0000-C000-000000000046"],
    "IOverlappedStream": ["49384070-E40A-11CE-B2C9-00AA00680937"],
    "IOverlappedCompletion": ["521A28F0-E40B-11CE-B2C9-00AA00680937"],
    "IAlertTarget": ["589B61C0-54E6-11CE-94DD-00AA0051E40F"],
    "IAlertReport": ["4E81DFE8-4CA0-101A-8206-08002B2FC09B"],
    "IClassFactory": ["00000001-0000-0000-C000-000000000046"],
    "AsyncIUnknown": ["000E0000-0000-0000-C000-000000000046"],
    "IBoundObjectSite": ["9BFBBC01-EFF1-101A-84ED-00AA00341D07"],
    "IBoundObject": ["9BFBBC00-EFF1-101A-84ED-00AA00341D07"],
    "IEntryID": ["E4D19810-D188-11CD-AD48-00AA003C9CB6"],
    "ICursorFind": ["E01D7850-D188-11CD-AD48-00AA003C9CB6"],
    "INotifyDBEvents": ["DB526CC0-D188-11CD-AD48-00AA003C9CB6"],
    "ICursorUpdateARow": ["D14216A0-D188-11CD-AD48-00AA003C9CB6"],
    "ICursorScroll": ["BB87E420-D188-11CD-AD48-00AA003C9CB6"],
    "ICursorMove": ["ACFF0690-D188-11CD-AD48-00AA003C9CB6"],
    "ICursor": ["9F6AA700-D188-11CD-AD48-00AA003C9CB6"],
    "StdOle": ["00020430-0000-0000-C000-000000000046"],
    "IPropertyFrame": ["B196B28A-BAB4-101A-B69C-00AA00341D07"],
    "IRichEditOleCallback": ["00020D03-0000-0000-C000-000000000046"],
    "IRichEditOle": ["00020D00-0000-0000-C000-000000000046"],
    "IDebugStream": ["00000124-0000-0000-C000-000000000046"],
    "IDebug": ["00000123-0000-0000-C000-000000000046"],
    "IOlePresObj": ["00000120-0000-0000-C000-000000000046"],
    "IOleManager": ["0000011F-0000-0000-C000-000000000046"],
    "IEnumCallback": ["00000108-0000-0000-C000-000000000046"],
    "IEnumHolder": ["00000107-0000-0000-C000-000000000046"],
    "IEnumGeneric": ["00000106-0000-0000-C000-000000000046"],
    "IProxy": ["00000027-0000-0000-C000-000000000046"],
    "IDfReserved3": ["00000015-0000-0000-C000-000000000046"],
    "IDfReserved2": ["00000014-0000-0000-C000-000000000046"],
    "IDfReserved1": ["00000013-0000-0000-C000-000000000046"],
    "IInternalMoniker": ["00000011-0000-0000-C000-000000000046"],
    "IPSFactory": ["00000009-0000-0000-C000-000000000046"],
    "IProxyManager": ["00000008-0000-0000-C000-000000000046"],
    "IRpcProxy": ["00000007-0000-0000-C000-000000000046"],
    "IStubManager": ["00000006-0000-0000-C000-000000000046"],
    "IRpcStub": ["00000005-0000-0000-C000-000000000046"],
    "IRpcChannel": ["00000004-0000-0000-C000-000000000046"],
    "ITrkRestoreParser": ["755939E3-E381-11D0-B1C5-00C04FB9386D"],
    "ITrkRestoreNotify": ["D0056F6B-E2A0-11D0-B1C2-00C04FB9386D"],
    "ITrkForceOwnership": ["A2531F44-C67D-11D0-8CB1-00C04FD90F85"],
    "ITrackFile": ["8790C948-A30B-11D0-8CAB-00C04FD90F85"],
    "IEnroll4": ["F8053FE5-78F4-448F-A0DB-41D61B73446B"],
    "IEnroll2": ["C080E199-B7DF-11D2-A421-00C04F79FE8E"],
    "IEnroll": ["ACAA7838-4585-11D1-AB57-00C04FC295E1"],
    "ICEnroll4": ["C1F1188A-2EB5-4A80-841B-7E729A356D90"],
    "ICEnroll3": ["C28C2D95-B7DE-11D2-A421-00C04F79FE8E"],
    "ICEnroll2": ["704CA730-C90B-11D1-9BEC-00C04FC295E1"],
    "ICEnroll": ["43F8F288-7A20-11D0-8F06-00C04FC295E1"],
    "ICatInformation": ["0002E013-0000-0000-C000-000000000046"],
    "ICatRegister": ["0002E012-0000-0000-C000-000000000046"],
    "IEnumCATEGORYINFO": ["0002E011-0000-0000-C000-000000000046"],
    "IEnumGUID": ["0002E000-0000-0000-C000-000000000046"],
    "ISyncMgrRegister": ["6295DF42-35EE-11D1-8707-00C04FD93327"],
    "ISyncMgrSynchronizeInvoke": ["6295DF2C-35EE-11D1-8707-00C04FD93327"],
    "ISyncMgrEnumItems": ["6295DF2A-35EE-11D1-8707-00C04FD93327"],
    "ISyncMgrSynchronizeCallback": ["6295DF41-35EE-11D1-8707-00C04FD93327"],
    "ISyncMgrSynchronize": ["6295DF40-35EE-11D1-8707-00C04FD93327"],
    "ISyncMgrRegisterCSC": ["47681A61-BC74-11D2-B5C5-00C04FB93981"],
    "IOldSyncMgrRegister": ["894D8C55-BDDF-11D1-B85D-00C04FB93981"],
    "IOldSyncMgrSynchronizeCallback": ["6295DF29-35EE-11D1-8707-00C04FD93327"],
    "IOldSyncMgrSynchronize": ["6295DF28-35EE-11D1-8707-00C04FD93327"],
    "IEnumSyncItems": ["F0E1589A-A700-11D1-9831-00C04FD910DD"],
    "ISyncSchedulep": ["F0E1589B-A700-11D1-9831-00C04FD910DD"],
    "ISyncSchedule": ["F0E15899-A700-11D1-9831-00C04FD910DD"],
    "IEnumSyncSchedules": ["F0E15898-A700-11D1-9831-00C04FD910DD"],
    "ISyncScheduleMgr": ["F0E15897-A700-11D1-9831-00C04FD910DD"],
    "IPrivSyncMgrSynchronizeInvoke": ["6295DF2E-35EE-11D1-8707-00C04FD93327"],
    "ISensLogon2": ["D597BAB4-5B9F-11D1-8DD2-00AA004ABD5E"],
    "ISensLogon": ["D597BAB3-5B9F-11D1-8DD2-00AA004ABD5E"],
    "ISensOnNow": ["D597BAB2-5B9F-11D1-8DD2-00AA004ABD5E"],
    "ISensNetwork": ["D597BAB1-5B9F-11D1-8DD2-00AA004ABD5E"],
    "IXMLNodeFactory": ["D242361F-51A0-11D2-9CAF-0060B0EC3D39"],
    "IXMLParser3": ["C9407B83-04E7-496A-AF26-A5677AEFCC86"],
    "IXMLParser2": ["50FB5B1A-A75C-4FF4-86B2-14C62189E2CC"],
    "IXMLParser": ["D242361E-51A0-11D2-9CAF-0060B0EC3D39"],
    "IXMLNodeSource": ["D242361D-51A0-11D2-9CAF-0060B0EC3D39"],
    "IXMLError": ["948C5AD3-C58D-11D0-9C0B-00C04FC99C8E"],
    "IXMLAttribute": ["D4D4A0FC-3B73-11D1-B2B4-00C04FB92596"],
    "IXMLElement2": ["2B8DE2FF-8D2D-11D1-B2FC-00C04FD915A9"],
    "IXMLElement": ["3F7F31AC-E15F-11D0-9C25-00C04FC99C8E"],
    "IXMLDocument2": ["2B8DE2FE-8D2D-11D1-B2FC-00C04FD915A9"],
    "IXMLDocument": ["F52E2B61-18A1-11D1-B105-00805F49916B"],
    "IXMLElementCollection": ["65725580-9B5D-11D0-9BFE-00C04FC99C8E"],
    "IXMLDSOControl": ["310AFA62-0575-11D2-9CA9-0060B0EC3D39"],
    "IXMLHttpRequest": ["ED8C108D-4349-11D2-91A4-00C04F7969E8"],
    "IXTLRuntime": ["3EFAA425-272F-11D2-836F-0000F87A7782"],
    "IXMLDOMParseError": ["3EFAA426-272F-11D2-836F-0000F87A7782"],
    "IXMLDOMEntityReference": ["2933BF8E-7B36-11D2-B20E-00C04F983E60"],
    "IXMLDOMEntity": ["2933BF8D-7B36-11D2-B20E-00C04F983E60"],
    "IXMLDOMNotation": ["2933BF8C-7B36-11D2-B20E-00C04F983E60"],
    "IXMLDOMDocumentType": ["2933BF8B-7B36-11D2-B20E-00C04F983E60"],
    "IXMLDOMCDATASection": ["2933BF8A-7B36-11D2-B20E-00C04F983E60"],
    "IXMLDOMProcessingInstruction": ["2933BF89-7B36-11D2-B20E-00C04F983E60"],
    "IXMLDOMComment": ["2933BF88-7B36-11D2-B20E-00C04F983E60"],
    "IXMLDOMText": ["2933BF87-7B36-11D2-B20E-00C04F983E60"],
    "IXMLDOMElement": ["2933BF86-7B36-11D2-B20E-00C04F983E60"],
    "IXMLDOMAttribute": ["2933BF85-7B36-11D2-B20E-00C04F983E60"],
    "IXMLDOMCharacterData": ["2933BF84-7B36-11D2-B20E-00C04F983E60"],
    "IXMLDOMNamedNodeMap": ["2933BF83-7B36-11D2-B20E-00C04F983E60"],
    "IXMLDOMNodeList": ["2933BF82-7B36-11D2-B20E-00C04F983E60"],
    "IXMLDOMDocument": ["2933BF81-7B36-11D2-B20E-00C04F983E60"],
    "IXMLDOMDocumentFragment": ["3EFAA413-272F-11D2-836F-0000F87A7782"],
    "IXMLDOMNode": ["2933BF80-7B36-11D2-B20E-00C04F983E60"],
    "IXMLDOMImplementation": ["2933BF8F-7B36-11D2-B20E-00C04F983E60"],
    "IActiveScriptAuthorProcedure": ["7E2D4B70-BD9A-11D0-9336-00A0C90DCAA9"],
    "IActiveScriptAuthor": ["9C109DA0-7006-11D1-B36C-00A0C911E8B2"],
    "IScriptScriptlet": ["0AEE2A96-BCBB-11D0-8C72-00C04FC2B085"],
    "IScriptEntry": ["0AEE2A95-BCBB-11D0-8C72-00C04FC2B085"],
    "IScriptNode": ["0AEE2A94-BCBB-11D0-8C72-00C04FC2B085"],
    "IProvideExpressionContexts": ["51973C41-CB0C-11D0-B5C9-00A0244A0E7A"],
    "IEnumDebugExpressionContexts": ["51973C40-CB0C-11D0-B5C9-00A0244A0E7A"],
    "IDebugHelper": ["51973C3F-CB0C-11D0-B5C9-00A0244A0E7A"],
    "ISimpleConnectionPoint": ["51973C3E-CB0C-11D0-B5C9-00A0244A0E7A"],
    "IDebugFormatter": ["51973C05-CB0C-11D0-B5C9-00A0244A0E7A"],
    "IEnumRemoteDebugApplicationThreads": ["51973C3C-CB0C-11D0-B5C9-00A0244A0E7A"],
    "IEnumRemoteDebugApplications": ["51973C3B-CB0C-11D0-B5C9-00A0244A0E7A"],
    "IEnumDebugApplicationNodes": ["51973C3A-CB0C-11D0-B5C9-00A0244A0E7A"],
    "IDebugCookie": ["51973C39-CB0C-11D0-B5C9-00A0244A0E7A"],
    "IDebugApplicationThread64": ["9DAC5886-DBAD-456D-9DEE-5DEC39AB3DDA"],
    "IDebugApplicationThread": ["51973C38-CB0C-11D0-B5C9-00A0244A0E7A"],
    "IRemoteDebugApplicationThread": ["51973C37-CB0C-11D0-B5C9-00A0244A0E7A"],
    "IDebugThreadCall64": ["CB3FA335-E979-42FD-9FCF-A7546A0F3905"],
    "IDebugThreadCall32": ["51973C36-CB0C-11D0-B5C9-00A0244A0E7A"],
    "IDebugApplicationNodeEvents": ["51973C35-CB0C-11D0-B5C9-00A0244A0E7A"],
    "IDebugApplicationNode": ["51973C34-CB0C-11D0-B5C9-00A0244A0E7A"],
    "IRemoteDebugApplicationEvents": ["51973C33-CB0C-11D0-B5C9-00A0244A0E7A"],
    "IDebugApplication64": ["4DEDC754-04C7-4F10-9E60-16A390FE6E62"],
    "IDebugApplication32": ["51973C32-CB0C-11D0-B5C9-00A0244A0E7A"],
    "IRemoteDebugApplication": ["51973C30-CB0C-11D0-B5C9-00A0244A0E7A"],
    "IProcessDebugManager64": ["56B9FC1C-63A9-4CC1-AC21-087D69A17FAB"],
    "IProcessDebugManager32": ["51973C2F-CB0C-11D0-B5C9-00A0244A0E7A"],
    "IMachineDebugManagerEvents": ["51973C2E-CB0C-11D0-B5C9-00A0244A0E7A"],
    "IMachineDebugManagerCookie": ["51973C2D-CB0C-11D0-B5C9-00A0244A0E7A"],
    "IMachineDebugManager": ["51973C2C-CB0C-11D0-B5C9-00A0244A0E7A"],
    "IApplicationDebuggerUI": ["51973C2B-CB0C-11D0-B5C9-00A0244A0E7A"],
    "IApplicationDebugger": ["51973C2A-CB0C-11D0-B5C9-00A0244A0E7A"],
    "IDebugSessionProvider": ["51973C29-CB0C-11D0-B5C9-00A0244A0E7A"],
    "IDebugDocumentContext": ["51973C28-CB0C-11D0-B5C9-00A0244A0E7A"],
    "IDebugDocumentHost": ["51973C27-CB0C-11D0-B5C9-00A0244A0E7A"],
    "IDebugDocumentHelper64": ["C4C7363C-20FD-47F9-BD82-4855E0150871"],
    "IDebugDocumentHelper32": ["51973C26-CB0C-11D0-B5C9-00A0244A0E7A"],
    "IDebugDocumentTextExternalAuthor": ["51973C25-CB0C-11D0-B5C9-00A0244A0E7A"],
    "IDebugDocumentTextAuthor": ["51973C24-CB0C-11D0-B5C9-00A0244A0E7A"],
    "IDebugDocumentTextEvents": ["51973C23-CB0C-11D0-B5C9-00A0244A0E7A"],
    "IDebugDocumentText": ["51973C22-CB0C-11D0-B5C9-00A0244A0E7A"],
    "IDebugDocument": ["51973C21-CB0C-11D0-B5C9-00A0244A0E7A"],
    "IDebugDocumentProvider": ["51973C20-CB0C-11D0-B5C9-00A0244A0E7A"],
    "IDebugDocumentInfo": ["51973C1F-CB0C-11D0-B5C9-00A0244A0E7A"],
    "IEnumDebugStackFrames64": ["0DC38853-C1B0-4176-A984-B298361027AF"],
    "IEnumDebugStackFrames": ["51973C1E-CB0C-11D0-B5C9-00A0244A0E7A"],
    "IEnumDebugCodeContexts": ["51973C1D-CB0C-11D0-B5C9-00A0244A0E7A"],
    "IDebugAsyncOperationCallBack": ["51973C1C-CB0C-11D0-B5C9-00A0244A0E7A"],
    "IDebugAsyncOperation": ["51973C1B-CB0C-11D0-B5C9-00A0244A0E7A"],
    "IDebugSyncOperation": ["51973C1A-CB0C-11D0-B5C9-00A0244A0E7A"],
    "IDebugStackFrameSnifferEx64": ["8CD12AF4-49C1-4D52-8D8A-C146F47581AA"],
    "IDebugStackFrameSnifferEx32": ["51973C19-CB0C-11D0-B5C9-00A0244A0E7A"],
    "IDebugStackFrameSniffer": ["51973C18-CB0C-11D0-B5C9-00A0244A0E7A"],
    "IDebugStackFrame": ["51973C17-CB0C-11D0-B5C9-00A0244A0E7A"],
    "IDebugExpressionCallBack": ["51973C16-CB0C-11D0-B5C9-00A0244A0E7A"],
    "IDebugExpressionContext": ["51973C15-CB0C-11D0-B5C9-00A0244A0E7A"],
    "IDebugExpression": ["51973C14-CB0C-11D0-B5C9-00A0244A0E7A"],
    "IDebugCodeContext": ["51973C13-CB0C-11D0-B5C9-00A0244A0E7A"],
    "IActiveScriptErrorDebug": ["51973C12-CB0C-11D0-B5C9-00A0244A0E7A"],
    "IActiveScriptSiteDebug64": ["D6B96B0A-7463-402C-92AC-89984226942F"],
    "IActiveScriptSiteDebug32": ["51973C11-CB0C-11D0-B5C9-00A0244A0E7A"],
    "IActiveScriptDebug64": ["BC437E23-F5B8-47F4-BB79-7D1CE5483B86"],
    "IActiveScriptDebug32": ["51973C10-CB0C-11D0-B5C9-00A0244A0E7A"],
    "IActiveScriptTraceInfo": ["C35456E7-BEBF-4A1B-86A9-24D56BE8B369"],
    "IActiveScriptSiteTraceInfo": ["4B7272AE-1955-4BFE-98B0-780621888569"],
    "IActiveScriptSIPInfo": ["764651D0-38DE-11D4-A2A3-00104BD35090"],
    "IActiveScriptGarbageCollector": ["6AA2C4A0-2B53-11D4-A2A0-00104BD35090"],
    "ITridentEventSink": ["1DC9CA50-06EF-11D2-8415-006008C3FBFC"],
    "IActiveScriptProperty": ["4954E0D0-FBC7-11D1-8410-006008C3FBFC"],
    "IActiveScriptStats": ["B8DA6310-E19B-11D0-933C-00A0C90DCAA9"],
    "IBindEventHandler": ["63CDBCB0-C1B1-11D0-9336-00A0C90DCAA9"],
    "IActiveScriptHostEncode": ["BEE9B76E-CFE3-11D1-B747-00C04FC2B085"],
    "IActiveScriptEncode": ["BB1A2AE3-A4F9-11CF-8F20-00805F2CD064"],
    "IActiveScriptParseProcedure2_64": ["FE7C4271-210C-448D-9F54-76DAB7047B28"],
    "IActiveScriptParseProcedure2_32": ["71EE5B20-FB04-11D1-B3A8-00A0C911E8B2"],
    "IActiveScriptParseProcedure64": ["C64713B6-E029-4CC5-9200-438B72890B6A"],
    "IActiveScriptParseProcedure32": ["AA5B6A80-B834-11D0-932F-00A0C90DCAA9"],
    "IActiveScriptParseProcedureOld64": ["21F57128-08C9-4638-BA12-22D15D88DC5C"],
    "IActiveScriptParseProcedureOld32": ["1CFF0050-6FDD-11D0-9328-00A0C90DCAA9"],
    "IActiveScriptParse64": ["C7EF7658-E1EE-480E-97EA-D52CB4D76D17"],
    "IActiveScriptParse32": ["BB1A2AE2-A4F9-11CF-8F20-00805F2CD064"],
    "IActiveScript": ["BB1A2AE1-A4F9-11CF-8F20-00805F2CD064"],
    "IActiveScriptSiteInterruptPoll": ["539698A0-CDCA-11CF-A5EB-00AA0047A063"],
    "IActiveScriptSiteWindow": ["D10F6761-83E9-11CF-8F20-00805F2CD064"],
    "IActiveScriptError64": ["B21FB2A1-5B8F-4963-8C21-21450F84ED7F"],
    "IActiveScriptError": ["EAE1BA61-A4ED-11CF-8F20-00805F2CD064"],
    "IActiveScriptSite": ["DB01A1E3-A42B-11CF-8F20-00805F2CD064"],
    "IMailProtocolADEntry": ["40EF8C68-D554-47ED-AA37-E5FB6BC91075"],
    "IAccountDiscovery": ["FA202BBC-6ABE-4C17-B184-570B6CF256A6"],
    "IMailAutoDiscovery": ["80402DEE-B114-4D32-B44E-82FD8234C92A"],
    "IAutoDiscoveryProvider": ["9DCF4A37-01DE-4549-A9CB-3AC31EC23C4F"],
    "IDebugPropertyEnumType_Registers": ["51973C59-CB0C-11D0-B5C9-00A0244A0E7A"],
    "IDebugPropertyEnumType_LocalsPlusArgs": ["51973C58-CB0C-11D0-B5C9-00A0244A0E7A"],
    "IDebugPropertyEnumType_Arguments": ["51973C57-CB0C-11D0-B5C9-00A0244A0E7A"],
    "IDebugPropertyEnumType_Locals": ["51973C56-CB0C-11D0-B5C9-00A0244A0E7A"],
    "IDebugPropertyEnumType_All": ["51973C55-CB0C-11D0-B5C9-00A0244A0E7A"],
    "IPerPropertyBrowsing2": ["51973C54-CB0C-11D0-B5C9-00A0244A0E7A"],
    "IEnumDebugExtendedPropertyInfo": ["51973C53-CB0C-11D0-B5C9-00A0244A0E7A"],
    "IDebugExtendedProperty": ["51973C52-CB0C-11D0-B5C9-00A0244A0E7A"],
    "IEnumDebugPropertyInfo": ["51973C51-CB0C-11D0-B5C9-00A0244A0E7A"],
    "IDebugProperty": ["51973C50-CB0C-11D0-B5C9-00A0244A0E7A"],
    "IActiveIME2": ["E1C4BF0E-2D53-11D2-93E1-0060B067B86E"],
    "IActiveIME": ["6FE20962-D077-11D0-8FE7-00AA006BCC59"],
    "IActiveIMMIME": ["08C03411-F96B-11D0-A475-00AA006BCC59"],
    "IActiveIMMApp": ["08C0E040-62D1-11D1-9326-0060B067B86E"],
    "IActiveIMMMessagePumpOwner": ["B5CF2CFA-8AEB-11D1-9364-0060B067B86E"],
    "IActiveIMMRegistrar": ["B3458082-BD00-11D1-939B-0060B067B86E"],
    "IEnumInputContext": ["09B5EAB0-F997-11D1-93D4-0060B067B86E"],
    "IEnumRegisterWordW": ["4955DD31-B159-11D0-8FCF-00AA006BCC59"],
    "IEnumRegisterWordA": ["08C03412-F96B-11D0-A475-00AA006BCC59"],
    "IProvideRuntimeContext": ["10E2414A-EC59-49D2-BC51-5ADD2C36FEBC"],
    "IObjectIdentity": ["CA04B7E6-0D21-11D1-8CC5-00C04FC2B085"],
    "IVariantChangeType": ["A6EF9862-C720-11D0-9337-00A0C90DCAA9"],
    "IDispError": ["A6EF9861-C720-11D0-9337-00A0C90DCAA9"],
    "IDispatchEx": ["A6EF9860-C720-11D0-9337-00A0C90DCAA9"],
    "IDownloadManager": ["988934A4-064B-11D3-BB80-00104B35E7F9"],
    "IOleCommandTarget": ["B722BCCB-4E68-101B-A2BC-00AA00404770"],
    "IPrint": ["B722BCC9-4E68-101B-A2BC-00AA00404770"],
    "IContinueCallback": ["B722BCCA-4E68-101B-A2BC-00AA00404770"],
    "IEnumOleDocumentViews": ["B722BCC8-4E68-101B-A2BC-00AA00404770"],
    "IOleDocumentView": ["B722BCC6-4E68-101B-A2BC-00AA00404770"],
    "IOleDocumentSite": ["B722BCC7-4E68-101B-A2BC-00AA00404770"],
    "IOleDocument": ["B722BCC5-4E68-101B-A2BC-00AA00404770"],
    "IDownloadNotify": ["CAEB5D28-AE4C-11D1-BA40-00C04FB92D79"],
    "IDXTICMFilter": ["734321ED-1E7B-4E1C-BBFA-89C819800E2F"],
    "IDXTMatrix": ["AC66A493-0F0C-4C76-825C-9D68BEDE9188"],
    "IDXTMotionBlur": ["089057BE-D3F5-4A2C-B10A-A5130184A0F7"],
    "IDXTLight": ["F9EFBEC1-4302-11D2-952A-00C04FA34F05"],
    "IDXTWave": ["1D4637E7-383C-11D2-952A-00C04FA34F05"],
    "IDXTShadow": ["1D4637E6-383C-11D2-952A-00C04FA34F05"],
    "IDXTGlow": ["1D4637E4-383C-11D2-952A-00C04FA34F05"],
    "IDXTAlpha": ["1D4637E0-383C-11D2-952A-00C04FA34F05"],
    "IDXTMetaWormHole": ["0E6AE021-0C83-11D2-8CD4-00104BC75D9A"],
    "IDXTMetaThreshold": ["2A54C914-07AA-11D2-8D6D-00C04F8EF8E0"],
    "IDXTMetaGriddler2": ["2A54C912-07AA-11D2-8D6D-00C04F8EF8E0"],
    "IDXTMetaGriddler": ["2A54C910-07AA-11D2-8D6D-00C04F8EF8E0"],
    "IDXTMetaVacuum": ["2A54C90C-07AA-11D2-8D6D-00C04F8EF8E0"],
    "IDXTMetaFlowMotion": ["2A54C90A-07AA-11D2-8D6D-00C04F8EF8E0"],
    "IDXTMetaColorFade": ["2A54C907-07AA-11D2-8D6D-00C04F8EF8E0"],
    "IDXTMetaJaws": ["2A54C903-07AA-11D2-8D6D-00C04F8EF8E0"],
    "IDXTMetaBurnFilm": ["107045D0-06E0-11D2-8D6D-00C04F8EF8E0"],
    "IDXTMetaTwister": ["107045CE-06E0-11D2-8D6D-00C04F8EF8E0"],
    "IDXTMetaWhiteOut": ["107045CB-06E0-11D2-8D6D-00C04F8EF8E0"],
    "IDXTMetaRadialScaleWipe": ["107045C9-06E0-11D2-8D6D-00C04F8EF8E0"],
    "IDXTMetaLightWipe": ["107045C7-06E0-11D2-8D6D-00C04F8EF8E0"],
    "IDXTMetaWater": ["107045C4-06E0-11D2-8D6D-00C04F8EF8E0"],
    "IDXTMetaPeelSplit": ["AA0D4D11-06A3-11D2-8F98-00C04FB92EB7"],
    "IDXTMetaPeelPiece": ["AA0D4D0F-06A3-11D2-8F98-00C04FB92EB7"],
    "IDXTMetaPeelSmall": ["AA0D4D0D-06A3-11D2-8F98-00C04FB92EB7"],
    "IDXTMetaCenterPeel": ["AA0D4D0B-06A3-11D2-8F98-00C04FB92EB7"],
    "IDXTMetaLiquid": ["AA0D4D09-06A3-11D2-8F98-00C04FB92EB7"],
    "IDXTMetaPageTurn": ["AA0D4D07-06A3-11D2-8F98-00C04FB92EB7"],
    "IDXTMetaRipple": ["AA0D4D02-06A3-11D2-8F98-00C04FB92EB7"],
    "IDXTMetaRoll": ["9C61F46D-0530-11D2-8F98-00C04FB92EB7"],
    "IDXTStrips": ["A83C9B5C-FB11-4AF5-8F65-D03F151D3ED5"],
    "IDXTRandomBars": ["8A6D2022-4A8F-4EB9-BB25-AA05201F9C84"],
    "IDXTAlphaImageLoader": ["A5F2D3E8-7A7E-48E5-BC75-40790BE4A941"],
    "IDXTRedirect": ["02F5140B-626F-4019-9C9E-2DAA1E93E8FC"],
    "IDXTMask": ["A1067146-B063-47D7-A54A-2C2309E9889D"],
    "IDXTRevealTrans": ["B8095006-A128-464B-8B2D-90580AEE2B05"],
    "IDXTCheckerBoard": ["AD3C2576-117C-4510-84DD-B668971DCFD1"],
    "IDXTDropShadow": ["1D4637E3-383C-11D2-952A-00C04FA34F05"],
    "IDXTChroma": ["1D4637E2-383C-11D2-952A-00C04FA34F05"],
    "ICrWheel": ["3943DE80-1464-11D2-A484-00C04F8EFB69"],
    "ICrZigzag": ["4E5A64A0-0C8B-11D2-A484-00C04F8EFB69"],
    "ICrSpiral": ["0DE527A0-0C7E-11D2-A484-00C04F8EFB69"],
    "IDXTGridSize": ["D6BBE91E-FF60-11D2-8F6E-00A0C9697274"],
    "ICrStretch": ["6684AF00-0A87-11D2-A484-00C04F8EFB69"],
    "ICrInset": ["05C5EE20-0BA6-11D2-A484-00C04F8EFB69"],
    "ICrBlinds2": ["7059D403-599A-4264-8140-641EB8AE1F64"],
    "ICrBlinds": ["5AF5C340-0BA9-11D2-A484-00C04F8EFB69"],
    "ICrBarn2": ["B66A7A1B-8FC6-448C-A2EB-3C55957478A1"],
    "ICrBarn": ["276A2EE0-0B5D-11D2-A484-00C04F8EFB69"],
    "ICrRadialWipe": ["424B71AE-0695-11D2-A484-00C04F8EFB69"],
    "ICrSlide": ["810E402E-056B-11D2-A484-00C04F8EFB69"],
    "ICrIris2": ["F7B06961-BA8C-4970-918B-1C60CB9FF180"],
    "ICrIris": ["3F69F350-0379-11D2-A484-00C04F8EFB69"],
    "IDXPixelate": ["D33E180F-FBE9-11D1-906A-00C04FD9189D"],
    "IDXBasicImage": ["16B280C7-EE70-11D1-9066-00C04FD9189D"],
    "IDXTFade": ["16B280C4-EE70-11D1-9066-00C04FD9189D"],
    "ICrEmboss": ["E4ACFB80-053E-11D2-81EA-0000F87557DB"],
    "ICrEngrave": ["E4ACFB7F-053E-11D2-81EA-0000F87557DB"],
    "ICrBlur": ["9F7C7827-E87A-11D1-81E0-0000F87557DB"],
    "IDXTWipe2": ["E1FF8091-442B-4801-88B6-2B47B1611FD2"],
    "IDXTWipe": ["AF279B2F-86EB-11D1-81BF-0000F87557DB"],
    "IDXTComposite": ["9A43A843-0831-11D1-817F-0000F87557DB"],
    "IDXDMapper": ["7FD9088B-35ED-11D1-81A1-0000F87557DB"],
    "IDXMapper": ["555278E5-05DB-11D1-883A-3C8B00C10000"],
    "IDXTConvolution": ["7BA7F8AF-E5EA-11D1-81DD-0000F87557DB"],
    "IDXTGradientD": ["623E2881-FC0E-11D1-9A77-0000F8756A10"],
    "IDXDLUTBuilder": ["73068231-35EE-11D1-81A1-0000F87557DB"],
    "IDXLUTBuilder": ["F4370FC1-CADB-11D0-B52C-00A0C9054373"],
    "ICSSFilterDispatch": ["9519152B-9484-4A6C-B6A7-4F25E92D6C6B"],
    "IObjectWithBehaviorSite": ["B03DCBE3-DDDB-48CC-9961-74DCA693BFB2"],
    "IHTMLDXTransform": ["30E2AB7D-4FDD-4159-B7EA-DC722BF4ADE5"],
    "IDXRawSurface": ["09756C8A-D96A-11D1-9062-00C04FD9189D"],
    "IDXLookupTable": ["01BAFC7F-9E63-11D1-9053-00C04FD9189D"],
    "IDXEffect": ["E31FB81B-1335-11D1-8189-0000F87557DB"],
    "IDXTScale": ["B39FD742-E139-11D1-9065-00C04FD9189D"],
    "IDXGradient": ["B2024B51-EE77-11D1-9066-00C04FD9189D"],
    "IDXTScaleOutput": ["B2024B50-EE77-11D1-9066-00C04FD9189D"],
    "IDXDCLock": ["0F619456-CF39-11D1-905E-00C04FD9189D"],
    "IDXARGBReadWritePtr": ["EAAAC2D7-C290-11D1-905D-00C04FD9189D"],
    "IDXARGBReadPtr": ["EAAAC2D6-C290-11D1-905D-00C04FD9189D"],
    "IDXARGBSurfaceInit": ["9EA3B63A-C37D-11D1-905E-00C04FD9189D"],
    "IDXSurfaceInit": ["9EA3B639-C37D-11D1-905E-00C04FD9189D"],
    "IDXSurface": ["B39FD73F-E139-11D1-9065-00C04FD9189D"],
    "IDXSurfaceModifier": ["9EA3B637-C37D-11D1-905E-00C04FD9189D"],
    "IDXSurfaceFactory": ["144946F5-C4D4-11D1-81D1-0000F87557DB"],
    "IDXTaskManager": ["254DBBC1-F922-11D0-883A-3C8B00C10000"],
    "IDXTBindHost": ["D26BCE55-E9DC-11D1-9066-00C04FD9189D"],
    "IDXTransform": ["30A5FB78-E11F-11D1-9064-00C04FD9189D"],
    "IDXTransformFactory": ["6A950B2B-A971-11D1-81C8-0000F87557DB"],
    "IDXBaseObject": ["17B59B2B-9CC8-11D1-9053-00C04FD9189D"],
    "IDXTClipOrigin": ["EE1663D8-0988-4C48-9FD6-DB4450885668"],
    "IDXTRedirectFilterInit": ["D1A57094-21F7-4E6C-93E5-F5F77F748293"],
    "IDXTFilterController": ["5CF315F2-273D-47B6-B9ED-F75DC3B0150B"],
    "IDXTFilter": ["6187E5A2-A445-4608-8FC0-BE7A6C8DB386"],
    "IDXTFilterCollection": ["22B07B33-8BFB-49D4-9B90-0938370C9019"],
    "IDXTFilterBehaviorSite": ["909B23C2-9018-499F-A86D-4E7DA937E931"],
    "IDXTFilterBehavior": ["14D7DDDD-ACA2-4E45-9504-3808ABEB4F92"],
    "IDXGradient2": ["D0EF2A80-61DC-11D2-B2EB-00A0C936B212"],
    "IDX2D": ["9EFD02A9-A996-11D1-81C9-0000F87557DB"],
    "IDX2DDebug": ["03BB2457-A279-11D1-81C6-0000F87557DB"],
    "IDXTLabel": ["C0C17F0E-AE41-11D1-9A3B-0000F8756A10"],
    "IDXRasterizer": ["9EA3B635-C37D-11D1-905E-00C04FD9189D"],
    "ISearchAssistantOC3": ["72423E8F-8011-11D2-BE79-00A0C9A83DA3"],
    "ISearchAssistantOC2": ["72423E8F-8011-11D2-BE79-00A0C9A83DA2"],
    "ISearchAssistantOC": ["72423E8F-8011-11D2-BE79-00A0C9A83DA1"],
    "ISearches": ["47C922A2-3DD5-11D2-BF8B-00C04FB93661"],
    "ISearch": ["BA9239A4-3DD5-11D2-BF8B-00C04FB93661"],
    "IScriptErrorList": ["F3470F24-15FD-11D2-BB2E-00805FF7EFCA"],
    "IShellNameSpace": ["E572D3C9-37BE-4AE2-825D-D521763E3108"],
    "IShellFavoritesNameSpace": ["55136804-B2DE-11D1-B9F2-00A0C98BC547"],
    "IShellUIHelper": ["729FE2F8-1EA8-11D1-8F85-00C04FC2FBE1"],
    "IShellWindows": ["85CB6900-4D95-11CF-960C-0080C7F4EE85"],
    "IWebBrowser2": ["D30C1661-CDAF-11D0-8A3E-00C04FC9E26E"],
    "IWebBrowserApp": ["0002DF05-0000-0000-C000-000000000046"],
    "IWebBrowser": ["EAB22AC1-30C1-11CF-A7EB-0000C05BAE0B"],
    "ITargetFramePriv": ["9216E421-2BF5-11D0-82B4-00A0C90C29C5"],
    "ITargetEmbedding": ["548793C0-9E74-11CF-9655-00A0C9034923"],
    "ITargetFrame": ["D5F78C80-5252-11CF-90FA-00AA0042106E"],
    "ITargetContainer": ["7847EC01-2BEC-11D0-82B4-00A0C90C29C5"],
    "ITargetFrame2": ["86D52E11-94A8-11D0-82AF-00C04FD5AE38"],
    "ITargetNotify2": ["3050F6B1-98B5-11CF-BB82-00AA00BDCE0B"],
    "ITargetNotify": ["863A99A0-21BC-11D0-82B4-00A0C90C29C5"],
    "IHTMLViewFilterSite": ["3050F2F4-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLViewFilter": ["3050F2F1-98B5-11CF-BB82-00AA00BDCE0B"],
    "IWinHttpRequestEvents": ["F97F4E15-B787-4212-80D1-D380CBBF982E"],
    "IWinHttpRequest": ["016FE2EC-B2C8-45F8-B23B-39E53A75396B"],
    "IDialBranding": ["8AECAFA9-4306-43CC-8C5A-765F2979CC16"],
    "IDialEngine": ["39FD782B-7905-40D5-9148-3C9B190423D5"],
    "IDialEventSink": ["2D86F4FF-6E2D-4488-B2E9-6934AFD41BEA"],
    "IUtilityButton": ["3050F6AF-98B5-11CF-BB82-00AA00BDCE0B"],
    "ISliderBar": ["3050F68D-98B5-11CF-BB82-00AA00BDCE0B"],
    "ISpinButton": ["3050F68B-98B5-11CF-BB82-00AA00BDCE0B"],
    "IScrollBar": ["3050F689-98B5-11CF-BB82-00AA00BDCE0B"],
    "IRadioButton": ["3050F69B-98B5-11CF-BB82-00AA00BDCE0B"],
    "ICheckBox": ["3050F685-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLSelectElement3": ["3050F687-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLOptionElement2": ["3050F697-98B5-11CF-BB82-00AA00BDCE0B"],
    "ICombobox": ["3050F677-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHeaderFooter": ["3050F6CE-98B5-11CF-BB82-00AA00BDCE0B"],
    "ITemplatePrinter2": ["3050F83F-98B5-11CF-BB82-00AA00BDCE0B"],
    "ITemplatePrinter": ["3050F6B4-98B5-11CF-BB82-00AA00BDCE0B"],
    "IDeviceRect": ["3050F6D5-98B5-11CF-BB82-00AA00BDCE0B"],
    "ILayoutRect": ["3050F665-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHtmlArea": ["3050F64E-98B5-11CF-BB82-00AA00BDCE0B"],
    "IDownloadBehavior": ["3050F5BD-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLPersistData": ["3050F4C5-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLPersistDataOM": ["3050F4C0-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLUserDataOM": ["3050F48F-98B5-11CF-BB82-00AA00BDCE0B"],
    "IAnchorClick": ["13D5413B-33B9-11D2-95A7-00C04F8ECB02"],
    "Iwfolders": ["BAE31F98-1B81-11D2-A97A-00C04F8ECB02"],
    "IIntelliForms": ["9B9F68E6-1AAA-11D2-BCA5-00C04FD929DB"],
    "IClientCaps": ["7E8BC44D-AEFF-11D1-89C2-00C04FB6BFC4"],
    "IHomePage": ["766BF2AF-D650-11D1-9811-00C04FC31D2E"],
    "IPeerFactory": ["6663F9D3-B482-11D1-89C6-00C04FB6BFC4"],
    "IDithererImpl": ["7C48E840-3910-11D0-86FC-00A0C913F750"],
    "ISniffStream": ["4EF17940-30E0-11D0-B724-00AA006C1A01"],
    "IElementNamespacePrivate": ["3050F7FF-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLFilterPaintSite": ["3050F6D3-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLFilterPainter": ["3050F6DE-98B5-11CF-BB82-00AA00BDCE0B"],
    "IPrivacyServices": ["3050F84B-98B5-11CF-BB82-00AA00BDCE0B"],
    "IEditDebugServices": ["3050F60B-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLEditingServices": ["3050F7FB-98B5-11CF-BB82-00AA00BDCE0B"],
    "IElementAdorner": ["3050F607-98B5-11CF-BB82-00AA00BDCE0B"],
    "IElementBehaviorUI": ["3050F4BF-98B5-11CF-BB82-00AA00BDCE0B"],
    "ISubDivisionProvider": ["3050F4D2-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLPrivateWindow3": ["3050F840-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLPrivateWindow2": ["3050F7E5-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLPrivateWindow": ["3050F6DC-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLEditor": ["3050F7FA-98B5-11CF-BB82-00AA00BDCE0B"],
    "ISelectionObject2": ["3050F7FC-98B5-11CF-BB82-00AA00BDCE0B"],
    "IMimeInfo": ["F77459A0-BF9A-11CF-BA4E-00C04FD70816"],
    "IHTMLOMWindowServices": ["3050F5FC-98B5-11CF-BB82-00AA00BDCE0B"],
    "IClassFactoryEx": ["342D1EA0-AE25-11D1-89C5-006008C3FBFC"],
    "IDocHostShowUI": ["C4D244B0-D43E-11CF-893B-00AA00BDCE1A"],
    "ICustomDoc": ["3050F3F0-98B5-11CF-BB82-00AA00BDCE0B"],
    "IDocHostUIHandler2": ["3050F6D0-98B5-11CF-BB82-00AA00BDCE0B"],
    "IDocHostUIHandler": ["BD3F23C0-D43E-11CF-893B-00AA00BDCE1A"],
    "IHostDialogHelper": ["53DEC138-A51E-11D2-861E-00C04FA35C89"],
    "IHostBehaviorInit": ["3050F842-98B5-11CF-BB82-00AA00BDCE0B"],
    "IElementBehaviorSiteLayout2": ["3050F847-98B5-11CF-BB82-00AA00BDCE0B"],
    "IElementBehaviorSiteLayout": ["3050F6B7-98B5-11CF-BB82-00AA00BDCE0B"],
    "IElementBehaviorLayout2": ["3050F846-98B5-11CF-BB82-00AA00BDCE0B"],
    "IElementBehaviorLayout": ["3050F6BA-98B5-11CF-BB82-00AA00BDCE0B"],
    "IElementBehaviorFocus": ["3050F6B6-98B5-11CF-BB82-00AA00BDCE0B"],
    "IElementBehaviorSubmit": ["3050F646-98B5-11CF-BB82-00AA00BDCE0B"],
    "IElementBehaviorSiteCategory": ["3050F4EE-98B5-11CF-BB82-00AA00BDCE0B"],
    "IElementBehaviorCategory": ["3050F4ED-98B5-11CF-BB82-00AA00BDCE0B"],
    "IElementBehaviorSiteOM2": ["3050F659-98B5-11CF-BB82-00AA00BDCE0B"],
    "IElementNamespaceFactoryCallback": ["3050F7FD-98B5-11CF-BB82-00AA00BDCE0B"],
    "IElementNamespaceFactory2": ["3050F805-98B5-11CF-BB82-00AA00BDCE0B"],
    "IElementNamespaceFactory": ["3050F672-98B5-11CF-BB82-00AA00BDCE0B"],
    "IElementNamespaceTable": ["3050F670-98B5-11CF-BB82-00AA00BDCE0B"],
    "IElementNamespace": ["3050F671-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLAppBehavior3": ["3050F5CD-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLAppBehavior2": ["3050F5C9-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLAppBehavior": ["3050F5CA-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLPopup": ["3050F666-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLModelessInit": ["3050F5E4-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLDialog3": ["3050F388-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLDialog2": ["3050F5E0-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLDialog": ["3050F216-98B5-11CF-BB82-00AA00BDCE0B"],
    "IEnumPrivacyRecords": ["3050F844-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLIPrintCollection": ["3050F6B5-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLPainterOverlay": ["3050F7E3-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLPainterEventInfo": ["3050F6DF-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLPaintSite": ["3050F6A7-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLPainter": ["3050F6A6-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLNamespaceCollection": ["3050F6B8-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLNamespace": ["3050F6BB-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLComputedStyle": ["3050F6C3-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLEditServices2": ["3050F812-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLEditServices": ["3050F663-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLEditDesigner": ["3050F662-98B5-11CF-BB82-00AA00BDCE0B"],
    "ISelectionServices": ["3050F684-98B5-11CF-BB82-00AA00BDCE0B"],
    "ISelectionServicesListener": ["3050F699-98B5-11CF-BB82-00AA00BDCE0B"],
    "IIMEServices": ["3050F6CA-98B5-11CF-BB82-00AA00BDCE0B"],
    "ISequenceNumber": ["3050F6C1-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLEditHost2": ["3050F848-98B5-11CF-BB82-00AA00BDCE0D"],
    "IHTMLEditHost": ["3050F6A0-98B5-11CF-BB82-00AA00BDCE0B"],
    "IXMLGenericParse": ["E4E23071-4D07-11D2-AE76-0080C73BC199"],
    "IMarkupTextFrags": ["3050F5FA-98B5-11CF-BB82-00AA00BDCE0B"],
    "IMarkupPointer2": ["3050F675-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLChangePlayback": ["3050F6E0-98B5-11CF-BB82-00AA00BDCE0B"],
    "IMarkupServices2": ["3050F682-98B5-11CF-BB82-00AA00BDCE0B"],
    "IMarkupServices": ["3050F4A0-98B5-11CF-BB82-00AA00BDCE0B"],
    "ISecureUrlHost": ["C81984C4-74C8-11D2-BAA9-00C04FC2040E"],
    "ICSSFilter": ["3050F3EC-98B5-11CF-BB82-00AA00BDCE0B"],
    "IFontNames": ["3050F839-98B5-11CF-BB82-00AA00BDCE0B"],
    "IBlockFormats": ["3050F830-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHtmlDlgSafeHelper": ["3050F81A-98B5-11CF-BB82-00AA00BDCE0B"],
    "IDisplayServices": ["3050F69D-98B5-11CF-BB82-00AA00BDCE0B"],
    "IDisplayPointer": ["3050F69E-98B5-11CF-BB82-00AA00BDCE0B"],
    "ILineInfo": ["3050F7E2-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHighlightRenderingServices": ["3050F606-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHighlightSegment": ["3050F690-98B5-11CF-BB82-00AA00BDCE0B"],
    "IElementSegment": ["3050F68F-98B5-11CF-BB82-00AA00BDCE0B"],
    "ISegment": ["3050F683-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLCaret": ["3050F604-98B5-11CF-BB82-00AA00BDCE0B"],
    "ISegmentListIterator": ["3050F692-98B5-11CF-BB82-00AA00BDCE0B"],
    "ISegmentList": ["3050F605-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLChangeSink": ["3050F64A-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLChangeLog": ["3050F649-98B5-11CF-BB82-00AA00BDCE0B"],
    "IMarkupContainer2": ["3050F648-98B5-11CF-BB82-00AA00BDCE0B"],
    "IMarkupContainer": ["3050F5F9-98B5-11CF-BB82-00AA00BDCE0B"],
    "IMarkupPointer": ["3050F49F-98B5-11CF-BB82-00AA00BDCE0B"],
    "ICSSFilterSite": ["3050F3ED-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLStyleFontFace": ["3050F3D5-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLStyleElement": ["3050F375-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLOptionsHolder": ["3050F378-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLFontSizesCollection": ["3050F377-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLFontNamesCollection": ["3050F376-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLBGsound": ["3050F369-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLFrameSetElement2": ["3050F5C6-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLFrameSetElement": ["3050F319-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLSpanFlow": ["3050F3E5-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLLegendElement2": ["3050F834-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLLegendElement": ["3050F3EA-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLFieldSetElement2": ["3050F833-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLFieldSetElement": ["3050F3E7-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLDivPosition": ["3050F212-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLIFrameElement2": ["3050F4E6-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLIFrameElement": ["3050F315-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLFrameElement2": ["3050F7F5-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLFrameElement": ["3050F313-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLFrameBase3": ["3050F82E-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLFrameBase2": ["3050F6DB-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLParamElement": ["3050F83D-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLObjectElement3": ["3050F827-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLObjectElement2": ["3050F4CD-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLObjectElement": ["3050F24F-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLNoShowElement": ["3050F38A-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLScriptElement2": ["3050F828-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLScriptElement": ["3050F28B-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLTableCell2": ["3050F82D-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLTableCell": ["3050F23D-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLTableRowMetrics": ["3050F413-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLTableRow3": ["3050F82C-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLTableRow2": ["3050F4A1-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLTableRow": ["3050F23C-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLTableSection3": ["3050F82B-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLTableSection2": ["3050F5C7-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLTableCol2": ["3050F82A-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLTableCol": ["3050F23A-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLTable3": ["3050F829-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLTable2": ["3050F4AD-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLTable": ["3050F21E-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLTableSection": ["3050F23B-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLSpanElement": ["3050F3F3-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLPhraseElement2": ["3050F824-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLPhraseElement": ["3050F20A-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLCommentElement2": ["3050F813-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLCommentElement": ["3050F20C-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLTableCaption": ["3050F2EB-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLAreaElement": ["3050F265-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLMapElement": ["3050F266-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLAreasCollection3": ["3050F837-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLAreasCollection2": ["3050F5EC-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLAreasCollection": ["3050F383-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLEmbedElement": ["3050F25F-98B5-11CF-BB82-00AA00BDCE0B"],
    "IWBScriptControl": ["A5170870-0CF8-11D1-8B91-0080C744F389"],
    "IWebBridge": ["AE24FDAD-03C6-11D1-8B76-0080C744F389"],
    "IHTMLDocument5": ["3050F80C-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLDocument4": ["3050F69A-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLDocument3": ["3050F485-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLWindow4": ["3050F6CF-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLScreen2": ["3050F84A-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLScreen": ["3050F35C-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLFrameBase": ["3050F311-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLWindow3": ["3050F4AE-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLWindow2": ["332C4427-26CB-11D0-B483-00C04FD90119"],
    "IHTMLFramesCollection2": ["332C4426-26CB-11D0-B483-00C04FD90119"],
    "IHTMLDocument2": ["332C4425-26CB-11D0-B483-00C04FD90119"],
    "IHTMLEventObj4": ["3050F814-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLEventObj3": ["3050F680-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLEventObj2": ["3050F48B-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLDataTransfer": ["3050F4B3-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLBookmarkCollection": ["3050F4CE-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLLocation": ["163BB1E0-6E00-11CF-837A-48DC04C10000"],
    "IOmNavigator": ["FECEAAA5-8405-11CF-8BA1-00AA00476DA6"],
    "IHTMLOpsProfile": ["3050F401-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLPluginsCollection": ["3050F3FD-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLMimeTypesCollection": ["3050F3FC-98B5-11CF-BB82-00AA00BDCE0B"],
    "IOmHistory": ["FECEAAA2-8405-11CF-8BA1-00AA00476DA6"],
    "IHTMLUnknownElement": ["3050F209-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLBaseFontElement": ["3050F202-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLNextIdElement": ["3050F207-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLIsIndexElement2": ["3050F82F-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLIsIndexElement": ["3050F206-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLBaseElement": ["3050F204-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLMetaElement2": ["3050F81F-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLMetaElement": ["3050F203-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLTitleElement": ["3050F322-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLHeadElement": ["3050F81D-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLHtmlElement": ["3050F81C-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLMarqueeElement": ["3050F2B5-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLButtonElement": ["3050F2BB-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLTextAreaElement": ["3050F2AA-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLInputImage": ["3050F2C2-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLOptionButtonElement": ["3050F2BC-98B5-11CF-BB82-00AA00BDCE0B", "3050F509-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLInputFileElement": ["3050F2AD-98B5-11CF-BB82-00AA00BDCE0B", "3050F542-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLInputTextElement": ["3050F2A6-98B5-11CF-BB82-00AA00BDCE0B", "3050F520-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLInputHiddenElement": ["3050F2A4-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLInputButtonElement": ["3050F2B2-98B5-11CF-BB82-00AA00BDCE0B", "3050F51E-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLInputElement2": ["3050F821-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLInputElement": ["3050F5D2-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLOptionElementFactory": ["3050F38C-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLOptionElement3": ["3050F820-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLOptionElement": ["3050F211-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLSelectionObject2": ["3050F7EC-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLSelectionObject": ["3050F25A-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLSelectElement4": ["3050F838-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLSelectElement2": ["3050F5ED-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLSelectElement": ["3050F244-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLHeaderElement": ["3050F1F6-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLElementCollection3": ["3050F835-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLElementCollection2": ["3050F5EE-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLParaElement": ["3050F1F5-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLHRElement": ["3050F1F4-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLDListElement": ["3050F1F1-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLBRElement": ["3050F1F0-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLDTElement": ["3050F1F3-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLDDElement": ["3050F1F2-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLDivElement": ["3050F200-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLBlockElement2": ["3050F823-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLBlockElement": ["3050F208-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLLIElement": ["3050F1E0-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLOListElement": ["3050F1DE-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLUListElement": ["3050F1DD-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLListElement2": ["3050F822-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLListElement": ["3050F20E-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLLabelElement2": ["3050F832-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLLabelElement": ["3050F32A-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLAnchorElement2": ["3050F825-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLAnchorElement": ["3050F1DA-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLFontElement": ["3050F1D9-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLBodyElement2": ["3050F5C5-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLBodyElement": ["3050F1D8-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLImageElementFactory": ["3050F38E-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLImgElement2": ["3050F826-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLImgElement": ["3050F240-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLControlRange2": ["3050F65E-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLControlRange": ["3050F29C-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLTextContainer": ["3050F230-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLTextElement": ["3050F218-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLControlElement": ["3050F4E9-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLSubmitData": ["3050F645-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLFormElement3": ["3050F836-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLFormElement2": ["3050F4F6-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLFormElement": ["3050F1F7-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLTxtRangeCollection": ["3050F7ED-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLTextRangeMetrics2": ["3050F4A6-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLTextRangeMetrics": ["3050F40B-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLTxtRange": ["3050F220-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLLinkElement3": ["3050F81E-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLLinkElement2": ["3050F4E5-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLLinkElement": ["3050F205-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLStyleSheet2": ["3050F3D1-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLStyleSheet": ["3050F2E3-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLStyleSheetsCollection": ["3050F37E-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLStyleSheetPagesCollection": ["3050F7F0-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLStyleSheetPage": ["3050F7EE-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLStyleSheetRulesCollection": ["3050F2E5-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLStyleSheetRule": ["3050F357-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLGenericElement": ["3050F4B7-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLUrnCollection": ["3050F5E2-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTCDescBehavior": ["3050F5DC-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTCAttachBehavior2": ["3050F7EB-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTCAttachBehavior": ["3050F5F4-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTCEventBehavior": ["3050F4FF-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTCMethodBehavior": ["3050F631-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTCPropertyBehavior": ["3050F5DF-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTCDefaultDispatch": ["3050F4FD-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLElementDefaults": ["3050F6C9-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLDocument": ["626FC520-A41E-11CF-A731-00A0C9082637"],
    "IHTMLDatabinding": ["3050F3F2-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLUniqueName": ["3050F4D0-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLElementRender": ["3050F669-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLElement4": ["3050F80F-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLElement3": ["3050F673-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLElement2": ["3050F434-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLElementCollection": ["3050F21F-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLDOMChildrenCollection": ["3050F5AB-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLAttributeCollection2": ["3050F80A-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLAttributeCollection": ["3050F4C3-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLDOMImplementation": ["3050F80D-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLDOMTextNode2": ["3050F809-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLDOMTextNode": ["3050F4B1-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLDOMAttribute2": ["3050F810-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLDOMAttribute": ["3050F4B0-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLDOMNode2": ["3050F80B-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLDOMNode": ["3050F5DA-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLRectCollection": ["3050F4A4-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLRect": ["3050F4A3-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLElement": ["3050F1FF-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLCurrentStyle3": ["3050F818-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLCurrentStyle2": ["3050F658-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLCurrentStyle": ["3050F3DB-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLRenderStyle": ["3050F6AE-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLRuleStyle4": ["3050F817-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLRuleStyle3": ["3050F657-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLRuleStyle2": ["3050F4AC-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLRuleStyle": ["3050F3CF-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLStyle4": ["3050F816-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLStyle3": ["3050F656-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLStyle2": ["3050F4A2-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLStyle": ["3050F25E-98B5-11CF-BB82-00AA00BDCE0B"],
    "IElementBehaviorSiteRender": ["3050F4A7-98B5-11CF-BB82-00AA00BDCE0B"],
    "IElementBehaviorRender": ["3050F4AA-98B5-11CF-BB82-00AA00BDCE0B"],
    "IElementBehaviorSiteOM": ["3050F489-98B5-11CF-BB82-00AA00BDCE0B"],
    "IElementBehaviorFactory": ["3050F429-98B5-11CF-BB82-00AA00BDCE0B"],
    "IElementBehavior": ["3050F425-98B5-11CF-BB82-00AA00BDCE0B"],
    "IElementBehaviorSite": ["3050F427-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLEventObj": ["3050F32D-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHTMLFiltersCollection": ["3050F3EE-98B5-11CF-BB82-00AA00BDCE0B"],
    "ITIMEMediaPlayerControl": ["897A99E7-F386-45C8-B51B-3A25BBCBBA69"],
    "ITIMEMediaPlayerNetwork": ["B9987FCA-7FBB-4015-BD3D-7418605514DA"],
    "ITIMEMediaPlayerAudio": ["FFAACFDA-B374-4F22-AC9A-C5BB9437CB56"],
    "ITIMEMediaPlayer": ["EA4A95BE-ACC9-4BF0-85A4-1BF3C51E431C"],
    "ITIMEMediaPlayerSite": ["BF0571ED-344F-4F58-82C7-7431ED0FD834"],
    "IAnimationComposerSiteFactory": ["B4EA5681-ED72-4EFE-BBD7-7C47D1325696"],
    "IAnimationComposerFactory": ["BEEB3233-F71F-4683-8B05-9A5314C97DBC"],
    "ITIMEFactory": ["CD51E446-3006-434F-90E2-E37E8FB8CA8F"],
    "ITIMEDMusicPlayerObject": ["407954F5-2BAB-4CFA-954D-249F9FCE43A1"],
    "ITIMEDVDPlayerObject": ["3AF7AB68-4F29-462C-AA6E-5872448899E3"],
    "ITIMEPlayList": ["E9B75B62-DD97-4B19-8FD9-9646292952E0"],
    "ITIMEPlayItem2": ["4262CD38-6BDC-40A4-BC50-4CC50366E702"],
    "ITIMEPlayItem": ["2A6096D9-2CE0-47DC-A813-9099A2466309"],
    "ITIMEState": ["DD5EC62A-9D77-4573-80A8-758594E69CEA"],
    "ITIMEElementCollection": ["50ABC224-6D53-4F83-9135-2440A41B7BC8"],
    "IFilterAnimationInfo": ["02E29300-C758-49B4-9E11-C58BFE90558B"],
    "IAnimationFragment": ["319DFD88-0AC6-4AB1-A19F-90223BA2DA16"],
    "IAnimationRoot": ["29DF6387-30B4-4A62-891B-A9C5BE37BE88"],
    "IAnimationComposerSiteSink": ["8EF76C64-71CD-480F-96FC-BA2696E659BE"],
    "IAnimationComposerSite": ["488FCB56-8FD6-4CDA-A06A-5BB232930ECA"],
    "IAnimationComposer2": ["1A4F0E79-09CD-47F3-AFF1-483BF3A222DC"],
    "IAnimationComposer": ["5459C83D-322B-44B3-8DAA-24C947E7B275"],
    "ITIMEAnimationElement2": ["29CE8661-BD43-421A-B616-E9B31F33A572"],
    "ITIMEAnimationElement": ["A74F14B1-B6A2-430A-A5E8-1F4E53F710FE"],
    "ITIMETransitionElement": ["F383D66F-5E68-4FC2-B641-03672B543A49"],
    "ITIMEMediaElement2": ["9EE29400-7EE6-453A-85B3-4EC28E0305B4"],
    "ITIMEMediaElement": ["47A6972F-AE65-4A6B-AE63-D0C1D5307B58"],
    "ITIMEBodyElement": ["8C90E348-EC0A-4229-90B0-E57D2CA45CCB"],
    "ITIMEElement": ["1C2EF64E-F07D-4338-9771-9154491CD8B9"],
    "ITIMEActiveElementCollection": ["403E2540-4520-11D3-93AB-00A0C967A438"],
    "IObjectSafety": ["CB5BDC81-93C1-11CF-8F20-00805F2CD064"],
    "IImageDecodeEventSink": ["BAA342A0-2DED-11D0-86F4-00A0C913F750"],
    "IImageDecodeFilter": ["A3CCEDF3-2DE2-11D0-86F4-00A0C913F750"],
    "IMapMIMEToCLSID": ["D9E89500-30FA-11D0-B724-00AA006C1A01"],
    "ITimerSink": ["3050F361-98B5-11CF-BB82-00AA00BDCE0B"],
    "ITimer": ["3050F360-98B5-11CF-BB82-00AA00BDCE0B"],
    "ITimerService": ["3050F35F-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHtmlLoadOptions": ["A71A0808-0F88-11D1-BA19-00C04FD912D0"],
    "IOptionArray": ["22B6D492-0F88-11D1-BA19-00C04FD912D0"],
    "IPersistHistory": ["91A565C1-E38F-11D0-94BF-00A0C9055CBF"],
    "IProgSink": ["3050F371-98B5-11CF-BB82-00AA00BDCE0B"],
    "ICustomRatingHelper": ["D0D9842D-E211-4B2C-88DC-BC729342DFCB"],
    "IRatingNotification": ["639447BD-B2D3-44B9-9FB0-510F23CB45E4"],
    "IRecalcHostDebug": ["3050F5F7-98B5-11CF-BB82-00AA00BDCE0B"],
    "IRecalcProperty": ["3050F5D6-98B5-11CF-BB82-00AA00BDCE0B"],
    "IRecalcHost": ["3050F497-98B5-11CF-BB82-00AA00BDCE0B"],
    "IRecalcEngine": ["3050F496-98B5-11CF-BB82-00AA00BDCE0B"],
    "IActiveXSafetyProvider": ["69FF5101-FC63-11D0-97EB-00AA00615333"],
    "IServiceProvider": ["6D5140C1-7436-11CE-8034-00AA006009FA"],
    "ISubscriptionMgr2": ["614BC270-AEDF-11D1-A1F9-00C04FC2FBE1"],
    "ISubscriptionMgr": ["085FB2C0-0DF8-11D1-8F4B-00A0C905413F"],
    "IEnumSubscription": ["F72C8D97-6DBD-11D1-A1E8-00C04FC2FBE1"],
    "ISubscriptionItem": ["A97559F8-6C4A-11D1-A1E8-00C04FC2FBE1"],
    "IEnumItemProperties": ["F72C8D96-6DBD-11D1-A1E8-00C04FC2FBE1"],
    "IUrlHistoryNotify": ["BC40BEC1-C493-11D0-831B-00C04FD5AE38"],
    "IUrlHistoryStg2": ["AFA0DC11-C313-11D0-831A-00C04FD5AE38"],
    "IUrlHistoryStg": ["3C374A41-BAE4-11CF-BF7D-00AA006946EE"],
    "IEnumSTATURL": ["3C374A42-BAE4-11CF-BF7D-00AA006946EE"],
    "IWrappedProtocol": ["53C84785-8425-4DC5-971B-E58D9C19F9B6"],
    "IEncodingFilterFactory": ["70BDDE00-C18E-11D0-A9CE-006097942311"],
    "IDataFilter": ["69D14C80-C18E-11D0-A9CE-006097942311"],
    "ICatalogFileInfo": ["711C7600-6B48-11D1-B403-00AA00B92AF1"],
    "ISoftDistExt": ["B15B8DC1-C7E1-11D0-8680-00AA00BDCB71"],
    "IInternetZoneManagerEx": ["A4C23339-8E06-431E-9BF4-7E711C085648"],
    "IInternetZoneManager": ["79EAC9EF-BAF9-11CE-8C82-00AA004BA90B"],
    "IInternetHostSecurityManager": ["3AF280B6-CB3F-11D0-891E-00C04FB6BFC4"],
    "IZoneIdentifier": ["CD45F185-1B21-48E2-967B-EAD743A8914E"],
    "IInternetSecurityManagerEx": ["F164EDF1-CC7C-4F0D-9A94-34222625C393"],
    "IInternetSecurityManager": ["79EAC9EE-BAF9-11CE-8C82-00AA004BA90B"],
    "IInternetSecurityMgrSite": ["79EAC9ED-BAF9-11CE-8C82-00AA004BA90B"],
    "IInternetProtocolInfo": ["79EAC9EC-BAF9-11CE-8C82-00AA004BA90B"],
    "IInternetPriority": ["79EAC9EB-BAF9-11CE-8C82-00AA004BA90B"],
    "IInternetThreadSwitch": ["79EAC9E8-BAF9-11CE-8C82-00AA004BA90B"],
    "IInternetSession": ["79EAC9E7-BAF9-11CE-8C82-00AA004BA90B"],
    "IInternetProtocolSinkStackable": ["79EAC9F0-BAF9-11CE-8C82-00AA004BA90B"],
    "IInternetProtocolSink": ["79EAC9E5-BAF9-11CE-8C82-00AA004BA90B"],
    "IInternetProtocol": ["79EAC9E4-BAF9-11CE-8C82-00AA004BA90B"],
    "IInternetProtocolRoot": ["79EAC9E3-BAF9-11CE-8C82-00AA004BA90B"],
    "IInternetBindInfo": ["79EAC9E1-BAF9-11CE-8C82-00AA004BA90B"],
    "IInternet": ["79EAC9E0-BAF9-11CE-8C82-00AA004BA90B"],
    "IBindHost": ["FC4801A1-2BA9-11CF-A229-00AA003D7352"],
    "IWinInetCacheHints": ["DD1EC3B3-8391-4FDB-A9E6-347C3CAAA7DD"],
    "IWinInetHttpInfo": ["79EAC9D8-BAFA-11CE-8C82-00AA004BA90B"],
    "IHttpSecurity": ["79EAC9D7-BAFA-11CE-8C82-00AA004BA90B"],
    "IWinInetInfo": ["79EAC9D6-BAFA-11CE-8C82-00AA004BA90B"],
    "ICodeInstall": ["79EAC9D1-BAF9-11CE-8C82-00AA004BA90B"],
    "IWindowForBindingUI": ["79EAC9D5-BAFA-11CE-8C82-00AA004BA90B"],
    "IWinInetFileStream": ["F134C4B7-B1F8-4E75-B886-74B90943BECB"],
    "IHttpNegotiate2": ["4F9F9FCB-E0F4-48EB-B7AB-FA2EA9365CB4"],
    "IHttpNegotiate": ["79EAC9D2-BAF9-11CE-8C82-00AA004BA90B"],
    "IAuthenticate": ["79EAC9D0-BAF9-11CE-8C82-00AA004BA90B"],
    "IBindStatusCallback": ["79EAC9C1-BAF9-11CE-8C82-00AA004BA90B"],
    "IBinding": ["79EAC9C0-BAF9-11CE-8C82-00AA004BA90B"],
    "IBindProtocol": ["79EAC9CD-BAF9-11CE-8C82-00AA004BA90B"],
    "IMonikerProp": ["A5CA5F7F-1847-4D87-9C5B-918509F7511D"],
    "IPersistMoniker": ["79EAC9C9-BAF9-11CE-8C82-00AA004BA90B"],
    "IUrlTrackingStg": ["F2F8CBB3-B040-11D0-BB16-00C04FB66F63"],
    "IVersionHost": ["667115AC-DC02-11D1-BA57-00C04FC2040E"],
    "IVersionVector": ["4EB01410-DB1A-11D1-BA53-00C04FC2040E"],
    "ISubscriptionMgrPriv": ["D66B399E-AF1D-11D1-A1F9-00C04FC2FBE1"],
    "ISubscriptionAgentEvents": ["A89E8FF1-70F4-11D1-BC7F-00C04FD929DB"],
    "ISubscriptionAgentShellExt": ["81B184BA-B302-11D1-8552-00C04FA35C89"],
    "ISubscriptionAgentControl": ["A89E8FF0-70F4-11D1-BC7F-00C04FD929DB"],
    "ISubscriptionThrottler": ["1E9B00E4-9846-11D1-A1EE-00C04FC2FBE1"],
    "IIntDitherer": ["06670CA0-ECEF-11D0-AAE7-00C04FC9B304"],
    "IImgCtx": ["3050F3D7-98B5-11CF-BB82-00AA00BDCE0B"],
    "IAccessible": ["618736E0-3C3D-11CF-810C-00AA00389B71"],
    "IOInetCache": ["79EAC9EA-BAF9-11CE-8C82-00AA004BA90B"],
    "IOInetThreadSwitch": ["79EAC968-BAF9-11CE-8C82-00AA004BA90B"],
    "IOInetSession": ["79EAC967-BAF9-11CE-8C82-00AA004BA90B"],
    "IOInetBindClient": ["79EAC9E2-BAF9-11CE-8C82-00AA004BA90B"],
    "INotificationProcessMgr0": ["C733E4AE-576E-11D0-B28C-00C04FD7CD22"],
    "INotificationRunning": ["C733E4AD-576E-11D0-B28C-00C04FD7CD22"],
    "INotificationPing": ["C733E4AC-576E-11D0-B28C-00C04FD7CD22"],
    "INotificationHelper": ["C733E4AB-576E-11D0-B28C-00C04FD7CD22"],
    "IEnumNotificationSinkItem": ["C733E4AA-576E-11D0-B28C-00C04FD7CD22"],
    "IEnumScheduleGroup": ["C733E4A9-576E-11D0-B28C-00C04FD7CD22"],
    "IEnumNotification": ["C733E4A8-576E-11D0-B28C-00C04FD7CD22"],
    "INotificationReport": ["C733E4A7-576E-11D0-B28C-00C04FD7CD22"],
    "IScheduleGroup": ["C733E4A6-576E-11D0-B28C-00C04FD7CD22"],
    "INotificationSink": ["C733E4A5-576E-11D0-B28C-00C04FD7CD22"],
    "INotificationMgr": ["C733E4A4-576E-11D0-B28C-00C04FD7CD22"],
    "INotification": ["C733E4A3-576E-11D0-B28C-00C04FD7CD22"],
    "IPropertyMap": ["C733E4A2-576E-11D0-B28C-00C04FD7CD22"],
    "IEnumPropertyMap": ["C733E4A1-576E-11D0-B28C-00C04FD7CD22"],
    "IDebugOut": ["C733E4F1-576E-11D0-B28C-00C04FD7CD22"],
    "IDebugRegister": ["C733E4F0-576E-11D0-B28C-00C04FD7CD22"],
    "IBindStatusCallbackMsg": ["79EAC9D5-BAF9-11CE-8C82-00AA004BA90B"],
    "IAsyncBindCtx": ["79EAC9D4-BAF9-11CE-8C82-00AA004BA90B"],
    "IBindStatusCallbackHolder": ["79EAC9CC-BAF9-11CE-8C82-00AA004BA90B"],
    "IAsyncMoniker": ["79EAC9D3-BAF9-11CE-8C82-00AA004BA90B"],
    "ICiCResourceMonitor": ["F700FF8E-20EE-11D2-80F7-00C04FA354BA"],
    "ICiCFilterStatus": ["BC5F3D60-8BBC-11D1-8F73-00A0C91917F5"],
    "ICiCEventLogItem": ["44CC886A-4314-11D0-8C91-0020AF1D740E"],
    "ICiCQueryNotification": ["0A9E9F6C-3CE2-11D0-8C90-0020AF1D740E"],
    "ICiDocChangeNotifySink": ["8BFA1386-3CE5-11D0-8C90-0020AF1D740E"],
    "ICiCSecurityChecker": ["CA130CF4-3CC2-11D0-8C90-0020AF1D740E"],
    "ICiCUserSecurity": ["5D01D9CE-3CC2-11D0-8C90-0020AF1D740E"],
    "ICiCScopeChecker": ["7D820C9C-3CBC-11D0-8C90-0020AF1D740E"],
    "ICiCScope": ["1021C882-3CC0-11D0-8C90-0020AF1D740E"],
    "ICiCIndexNotificationStatus": ["5FFF3840-8E76-11D0-8D69-00A0C908DBF1"],
    "ICiIndexNotificationEntry": ["210769D0-8E75-11D0-8D69-00A0C908DBF1"],
    "ICiIndexNotification": ["4F2CD6E0-8E74-11D0-8D69-00A0C908DBF1"],
    "ICiISearchCreator": ["7DC07FA0-902E-11D0-A80C-00A0C906241A"],
    "ICiCDocStoreLocator": ["97EE7C06-5908-11D0-8C9B-0020AF1D740E"],
    "IPropertyMapper": ["B324B226-41A0-11D0-8C91-0020AF1D740E"],
    "ICiManager": ["CF0FCF56-3CCE-11D0-8C90-0020AF1D740E"],
    "ICiPersistIncrFile": ["31B311E2-4498-11D0-8C91-0020AF1D740E"],
    "ICiEnumWorkids": ["77900150-A09C-11D0-A80D-00A0C906241A"],
    "ICiStartup": ["68232CB8-3CCC-11D0-8C90-0020AF1D740E"],
    "ICiControl": ["63DEB7F4-3CCB-11D0-8C90-0020AF1D740E"],
    "ICiCQuerySession": ["AE461FD6-4E1D-11D0-8C94-0020AF1D740E"],
    "ICiQueryPropertyMapper": ["D2333EB0-756B-11D0-8D66-00A0C908DBF1"],
    "ICiCScopeEnumerator": ["CF8505EA-3CCA-11D0-8C90-0020AF1D740E"],
    "ICiCDeferredPropRetriever": ["C273AF70-6D72-11D0-8D64-00A0C908DBF1"],
    "ICiCPropRetriever": ["77D9B2DA-4401-11D0-8C91-0020AF1D740E"],
    "ICiCPropertyStorage": ["4C46225A-3CB5-11D0-8C90-0020AF1D740E"],
    "ICiCDocNameToWorkidTranslatorEx": ["7BBA76E6-A0E3-11D2-BC5D-00C04FA354BA"],
    "ICiCDocNameToWorkidTranslator": ["25FC3F54-3CB4-11D0-8C90-0020AF1D740E"],
    "ICiCDocStoreEx": ["F98282A7-FA72-11D1-9798-00C04FC2F410"],
    "ICiCDocStore": ["46625468-3C32-11D0-8C90-0020AF1D740E"],
    "ICiCFilterClient": ["A1E0BCB6-3C24-11D0-8C90-0020AF1D740E"],
    "ICiCAdviseStatus": ["CA05734A-1218-11D3-AE7A-00C04F72F831"],
    "ICiFrameworkQuery": ["AE67C7D9-85D3-11D0-8C45-00C04FC2DB8D"],
    "ICiAdmin": ["AE67C7D8-85D3-11D0-8C45-00C04FC2DB8D"],
    "ICiCLangRes": ["914C2E6C-43FE-11D0-8C91-0020AF1D740E"],
    "ICiAdminParams": ["A82D48C6-3F0F-11D0-8C91-0020AF1D740E"],
    "ICiCOpenedDoc": ["151EDFBE-3C2F-11D0-8C90-0020AF1D740E"],
    "ICiCDocName": ["76615076-3C2B-11D0-8C90-0020AF1D740E"],
    "IFilterStatus": ["F4EB8260-8DDA-11D1-B3AA-00A0C9063796"],
    "IFsCiAdmin": ["75398C30-7A26-11D0-A80A-00A0C906241A"],
    "IRowsetQueryStatus": ["A7AC77ED-F8D7-11CE-A798-0020F8008024"],
    "ISearchQueryHits": ["ED8CE7E0-106C-11CE-84E2-00AA004B9986"],
    "IColumnMapperCreator": ["0B63E37B-9CCC-11D0-BCDB-00805FCCCE04"],
    "IColumnMapper": ["0B63E37A-9CCC-11D0-BCDB-00805FCCCE04"],
    "ISimpleCommandCreator": ["5E341AB7-02D0-11D1-900C-00A0C9063796"],
    "IStemmer": ["EFBAF140-7F42-11CE-BE57-00AA0051FE20"],
    "IWordFormSink": ["FE77C330-7F42-11CE-BE57-00AA0051FE20"],
    "IWordBreaker": ["D53552C8-77E3-101A-B552-08002B33B0E6"],
    "IWordSink": ["CC907054-C058-101A-B554-08002B33B0E6"],
    "IPhraseSink": ["CC906FF0-C058-101A-B554-08002B33B0E6"],
    "IParser": ["186442B0-472E-11D1-8952-00C04FD611D7"],
    "IParserSession": ["186442B1-472E-11D1-8952-00C04FD611D7"],
    "IParserTreeProperties": ["186442B2-472E-11D1-8952-00C04FD611D7"],
    "IParserVerify": ["186442B3-472E-11D1-8952-00C04FD611D7"],
    "IFilter": ["89BCB740-6119-101A-BCB7-00DD010655AF"],
    "IApplicationGateway": ["5134842B-FDCE-485D-93CD-DE1640643BBE"],
    "IApplicationGatewayServices": ["5134842A-FDCE-485D-93CD-DE1640643BBE"],
    "IAdapterNotificationSink": ["44AB2DC3-23B2-47DE-8228-2E1CCEEB9911"],
    "IEnumAdapterInfo": ["A23F9D11-714C-41FE-8471-FFB19BC28454"],
    "ISecondaryControlChannel": ["A23F9D10-714C-41FE-8471-FFB19BC28454"],
    "IPrimaryControlChannel": ["1A2E8B62-9012-4BE6-84AE-32BD66BA657A"],
    "IPersistentDataChannel": ["A180E934-D92A-415D-9144-759F8054E8F6"],
    "IDataChannel": ["AD42D12A-4AD0-4856-919E-E854C91D1856"],
    "IPendingProxyConnection": ["B68E5043-3E3D-4CC2-B9C1-5F8F88FEE81C"],
    "IAdapterInfo": ["480BF94A-09FD-4F8A-A3E0-B0700282D84D"],
    "ITQOSApplicationID": ["E8C89D27-A3BD-47D5-A6FC-D2AE40CDBC6E"],
    "ITAudioSettings": ["6C0AB6C6-21E3-11D3-A577-00C04F8EF6E3"],
    "ITAudioDeviceControl": ["6C0AB6C5-21E3-11D3-A577-00C04F8EF6E3"],
    "ITCallQualityControl": ["FE1D8AE0-EDC4-49B5-8F8C-4DE40F9CDFAF"],
    "ITStreamQualityControl": ["6C0AB6C2-21E3-11D3-A577-00C04F8EF6E3"],
    "ITFormatControl": ["6C0AB6C1-21E3-11D3-A577-00C04F8EF6E3"],
    "ITParticipant": ["5899B820-5A34-11D2-95A0-00A0244D2298"],
    "IMulticastControl": ["410FA507-4DC6-415A-9014-633875D5406E"],
    "ITParticipantEvent": ["8BB35070-2DAD-11D3-A580-00C04F8EF6E3"],
    "ITParticipantSubStreamControl": ["2C679108-5A35-11D2-95A0-00A0244D2298"],
    "ITParticipantControl": ["D2EE6684-5A34-11D2-95A0-00A0244D2298"],
    "IEnumParticipant": ["0A91B56C-5A35-11D2-95A0-00A0244D2298"],
    "ITLocalParticipant": ["39CBF055-F77A-11D2-A824-00C04F8EF6E3"],
    "IDummy": ["0D7CA54A-D252-4FCB-9104-F6DDD310B3F9"],
    "IKeyFrameControl": ["C3341386-AF91-4EF9-83B6-BE3762E42ECB"],
    "IH323LineEx": ["44CF6A9D-CB40-4BBC-B2D3-B6AA93322C71"],
    "IInternetConnectionDeviceClient": ["04DF6139-5610-11D4-9EC8-00B0D022DD1F"],
    "IInternetConnectionDeviceSharedConnection": ["04DF6138-5610-11D4-9EC8-00B0D022DD1F"],
    "IInternetConnectionDevice": ["04DF6137-5610-11D4-9EC8-00B0D022DD1F"],
    "IEnumHNetBridgedConnections": ["85D18B7D-3032-11D4-9348-00C04F8EEB71"],
    "IEnumHNetPortMappingBindings": ["85D18B81-3032-11D4-9348-00C04F8EEB71"],
    "IEnumHNetPortMappingProtocols": ["85D18B7C-3032-11D4-9348-00C04F8EEB71"],
    "IEnumHNetApplicationProtocols": ["85D18B7B-3032-11D4-9348-00C04F8EEB71"],
    "IEnumHNetIcsPrivateConnections": ["85D18B7A-3032-11D4-9348-00C04F8EEB71"],
    "IEnumHNetIcsPublicConnections": ["85D18B79-3032-11D4-9348-00C04F8EEB71"],
    "IEnumHNetFirewalledConnections": ["85D18B78-3032-11D4-9348-00C04F8EEB71"],
    "IEnumHNetBridges": ["85D18B77-3032-11D4-9348-00C04F8EEB71"],
    "IEnumHNetConnections": ["E48CB68F-7CF0-496D-B8F7-D2EF8B639E1B"],
    "IHNetApplicationProtocol": ["85D18B7F-3032-11D4-9348-00C04F8EEB71"],
    "IHNetPortMappingBinding": ["85D18B80-3032-11D4-9348-00C04F8EEB71"],
    "IHNetPortMappingProtocol": ["85D18B7E-3032-11D4-9348-00C04F8EEB71"],
    "IHNetBridgedConnection": ["85D18B76-3032-11D4-9348-00C04F8EEB71"],
    "IHNetBridge": ["85D18B75-3032-11D4-9348-00C04F8EEB71"],
    "IHNetIcsPrivateConnection": ["85D18B74-3032-11D4-9348-00C04F8EEB71"],
    "IHNetIcsPublicConnection": ["85D18B73-3032-11D4-9348-00C04F8EEB71"],
    "IHNetFirewalledConnection": ["85D18B72-3032-11D4-9348-00C04F8EEB71"],
    "IHNetConnection": ["85D18B71-3032-11D4-9348-00C04F8EEB71"],
    "IHNetProtocolSettings": ["85D18B70-3032-11D4-9348-00C04F8EEB71"],
    "IHNetIcsSettings": ["85D18B6F-3032-11D4-9348-00C04F8EEB71"],
    "IHNetFirewallSettings": ["85D18B6E-3032-11D4-9348-00C04F8EEB71"],
    "IHNetBridgeSettings": ["85D18B6D-3032-11D4-9348-00C04F8EEB71"],
    "IHNetCfgMgr": ["85D18B6C-3032-11D4-9348-00C04F8EEB71"],
    "IStaticPortMapping": ["6F10711F-729B-41E5-93B8-F21D0F818DF1"],
    "IStaticPortMappingCollection": ["CD1F3E77-66D6-4664-82C7-36DBB641D0F1"],
    "IDynamicPortMapping": ["4FC80282-23B6-4378-9A27-CD8F17C9400C"],
    "IDynamicPortMappingCollection": ["B60DE00F-156E-4E8D-9EC1-3A2342C10899"],
    "INATNumberOfEntriesCallback": ["C83A0A74-91EE-41B6-B67A-67E0F00BBD78"],
    "INATExternalIPAddressCallback": ["9C416740-A34E-446F-BA06-ABD04C3149AE"],
    "INATEventManager": ["624BD588-9060-4109-B0B0-1ADBBCAC32DF"],
    "IUPnPNAT": ["B171C812-CC76-485A-94D8-B6B3A2794E99"],
    "IH26XRTPControl": ["1FC3F2C0-2BFD-11D0-8800-444553540000"],
    "IH26XEncoderControl": ["F9B78AA1-EA12-11CF-9FEC-00AA00A59F69"],
    "IH26XSnapshot": ["3CB194A0-10AA-11D0-8800-444553540000"],
    "IH26XEncodeOptions": ["65698D40-282D-11D0-8800-444553540000"],
    "IH26XVideoEffects": ["21555140-9C2B-11CF-90FA-00AA00A729EA"],
    "IQualityControl": ["6BC096AB-0CE6-11D1-BAAE-00C04FC2E20D", "56A868A5-0AD4-11CE-B03A-0020AF0BA770"],
    "IRequestSource": ["6BC096A9-0CE6-11D1-BAAE-00C04FC2E20D"],
    "IRequestHandler": ["6BC096AA-0CE6-11D1-BAAE-00C04FC2E20D"],
    "IRequestState": ["6BC096BA-0CE6-11D1-BAAE-00C04FC2E20D"],
    "IAttributesRaw": ["6BC096A8-0CE6-11D1-BAAE-00C04FC2E20D"],
    "IRequest": ["6BC096A7-0CE6-11D1-BAAE-00C04FC2E20D"],
    "IStats": ["944AD530-B09D-11CE-B59C-00AA006CB37D"],
    "IRTC": ["4811EA40-B582-11CE-B5AF-00AA006CB37D"],
    "IDelaydC": ["BFF9C030-B58F-11CE-B5B0-00AA006CB37D"],
    "IMcastAddressAllocation": ["DF0DAEF1-A289-11D1-8697-006008B0E5D2"],
    "IEnumMcastScope": ["DF0DAF09-A289-11D1-8697-006008B0E5D2"],
    "IMcastLeaseInfo": ["DF0DAEFD-A289-11D1-8697-006008B0E5D2"],
    "IMcastScope": ["DF0DAEF4-A289-11D1-8697-006008B0E5D2"],
    "ITMSPAddress": ["EE3BD600-3868-11D2-A045-00C04FB6809F"],
    "ITPluggableTerminalEventSinkRegistration": ["F7115709-A216-4957-A759-060AB32A90D1"],
    "ITPluggableTerminalEventSink": ["6E0887BE-BA1A-492E-BD10-4020EC5E33E0"],
    "INetCfgComponentSysPrep": ["C0E8AE9A-306E-11D1-AACF-00805FC1270E"],
    "INetLanConnectionUiInfo": ["C08956A6-1CD3-11D1-B1C5-00805FC1270E"],
    "INetCfgComponentUpperEdge": ["932238E4-BEA1-11D0-9298-00C04FC99DCF"],
    "INetCfgComponentNotifyGlobal": ["932238E2-BEA1-11D0-9298-00C04FC99DCF"],
    "INetCfgComponentNotifyBinding": ["932238E1-BEA1-11D0-9298-00C04FC99DCF"],
    "INetCfgComponentPropertyUi": ["932238E0-BEA1-11D0-9298-00C04FC99DCF"],
    "INetCfgComponentSetup": ["932238E3-BEA1-11D0-9298-00C04FC99DCF"],
    "INetCfgComponentControl": ["932238DF-BEA1-11D0-9298-00C04FC99DCF"],
    "INetCfgPnpReconfigCallback": ["8D84BD35-E227-11D2-B700-00A0C98A6A85"],
    "INetCfgSpecialCase": ["C0E8AE95-306E-11D1-AACF-00805FC1270E"],
    "INetInstallQueue": ["98133274-4B20-11D1-AB01-00805FC1270E"],
    "INetCfgComponentPrivate": ["98133273-4B20-11D1-AB01-00805FC1270E"],
    "INetCfgInternalSetup": ["98133276-4B20-11D1-AB01-00805FC1270E"],
    "ITcpipProperties": ["98133271-4B20-11D1-AB01-00805FC1270E"],
    "IIpxAdapterInfo": ["98133270-4B20-11D1-AB01-00805FC1270E"],
    "INetCfgSysPrep": ["C0E8AE98-306E-11D1-AACF-00805FC1270E"],
    "INetCfgComponentBindings": ["C0E8AE9E-306E-11D1-AACF-00805FC1270E"],
    "INetCfgComponent": ["C0E8AE99-306E-11D1-AACF-00805FC1270E"],
    "INetCfgClassSetup": ["C0E8AE9D-306E-11D1-AACF-00805FC1270E"],
    "INetCfgClass": ["C0E8AE97-306E-11D1-AACF-00805FC1270E"],
    "INetCfgBindingPath": ["C0E8AE96-306E-11D1-AACF-00805FC1270E"],
    "INetCfgBindingInterface": ["C0E8AE94-306E-11D1-AACF-00805FC1270E"],
    "INetCfgLock": ["C0E8AE9F-306E-11D1-AACF-00805FC1270E"],
    "INetCfg": ["C0E8AE93-306E-11D1-AACF-00805FC1270E"],
    "IEnumNetCfgComponent": ["C0E8AE92-306E-11D1-AACF-00805FC1270E"],
    "IEnumNetCfgBindingPath": ["C0E8AE91-306E-11D1-AACF-00805FC1270E"],
    "IEnumNetCfgBindingInterface": ["C0E8AE90-306E-11D1-AACF-00805FC1270E"],
    "INetSharingManager": ["C08956B7-1CD3-11D1-B1C5-00805FC1270E"],
    "INetSharingPrivateConnectionCollection": ["38AE69E0-4409-402A-A2CB-E965C727F840"],
    "INetSharingPublicConnectionCollection": ["7D7A6355-F372-4971-A149-BFC927BE762A"],
    "INetSharingEveryConnectionCollection": ["33C4643C-7811-46FA-A89A-768597BD7223"],
    "INetSharingConfiguration": ["C08956B6-1CD3-11D1-B1C5-00805FC1270E"],
    "INetConnectionProps": ["F4277C95-CE5B-463D-8167-5662D9BCAA72"],
    "INetSharingPortMappingCollection": ["02E4A2DE-DA20-4E34-89C8-AC22275A010B"],
    "IEnumNetSharingPrivateConnection": ["C08956B5-1CD3-11D1-B1C5-00805FC1270E"],
    "IEnumNetSharingPublicConnection": ["C08956B4-1CD3-11D1-B1C5-00805FC1270E"],
    "IEnumNetSharingEveryConnection": ["C08956B8-1CD3-11D1-B1C5-00805FC1270E"],
    "INetSharingPortMapping": ["C08956B1-1CD3-11D1-B1C5-00805FC1270E"],
    "INetSharingPortMappingProps": ["24B7E9B5-E38F-4685-851B-00892CF5F940"],
    "IEnumNetSharingPortMapping": ["C08956B0-1CD3-11D1-B1C5-00805FC1270E"],
    "INetConnectionCommonUi": ["C08956A5-1CD3-11D1-B1C5-00805FC1270E"],
    "INetConnectionPropertyUi2": ["C08956B9-1CD3-11D1-B1C5-00805FC1270E"],
    "INetConnectionPropertyUi": ["C08956A4-1CD3-11D1-B1C5-00805FC1270E"],
    "INetConnectionConnectUi": ["C08956A3-1CD3-11D1-B1C5-00805FC1270E"],
    "INetConnectionManagerEvents": ["C08956BA-1CD3-11D1-B1C5-00805FC1270E"],
    "INetConnectionManager": ["C08956A2-1CD3-11D1-B1C5-00805FC1270E"],
    "INetConnection": ["C08956A1-1CD3-11D1-B1C5-00805FC1270E"],
    "IEnumNetConnection": ["C08956A0-1CD3-11D1-B1C5-00805FC1270E"],
    "ISharedAccessBeaconFinder": ["FAEDCF67-31FE-11D1-AAD2-00805FC1270E"],
    "ISharedAccessBeacon": ["FAEDCF6B-31FE-11D1-AAD2-00805FC1270E"],
    "INetConnectionManagerDebug": ["FAEDCF5D-31FE-11D1-AAD2-00805FC1270E"],
    "INetMachinePolicies": ["FAEDCF68-31FE-11D1-AAD2-00805FC1270E"],
    "INetConnectionSysTray": ["FAEDCF65-31FE-11D1-AAD2-00805FC1270E"],
    "INetConnectionHNetUtil": ["FAEDCF64-31FE-11D1-AAD2-00805FC1270E"],
    "INetConnectionCMUtil": ["FAEDCF60-31FE-11D1-AAD2-00805FC1270E"],
    "INetConnectionRefresh": ["FAEDCF5F-31FE-11D1-AAD2-00805FC1270E"],
    "INetConnectionUiUtilities": ["FAEDCF5E-31FE-11D1-AAD2-00805FC1270E"],
    "INetConnectionNotifySink": ["FAEDCF5C-31FE-11D1-AAD2-00805FC1270E"],
    "INetConnection2": ["FAEDCF6A-31FE-11D1-AAD2-00805FC1270E"],
    "INetConnectionManager2": ["FAEDCF69-31FE-11D1-AAD2-00805FC1270E"],
    "INetConnectionBrandingInfo": ["FAEDCF5B-31FE-11D1-AAD2-00805FC1270E"],
    "IPersistNetConnection": ["FAEDCF59-31FE-11D1-AAD2-00805FC1270E"],
    "INetRasConnectionIpUiInfo": ["FAEDCF58-31FE-11D1-AAD2-00805FC1270E"],
    "INetDefaultConnection": ["FAEDCF66-31FE-11D1-AAD2-00805FC1270E"],
    "INetRasConnection": ["FAEDCF57-31FE-11D1-AAD2-00805FC1270E"],
    "INetLanConnectionWizardUi": ["FAEDCF56-31FE-11D1-AAD2-00805FC1270E"],
    "INetSharedAccessConnection": ["FAEDCF55-31FE-11D1-AAD2-00805FC1270E"],
    "INetLanConnection": ["FAEDCF54-31FE-11D1-AAD2-00805FC1270E"],
    "INetInboundConnection": ["FAEDCF53-31FE-11D1-AAD2-00805FC1270E"],
    "INetConnectionWizardUiContext": ["FAEDCF52-31FE-11D1-AAD2-00805FC1270E"],
    "INetConnectionWizardUi": ["FAEDCF51-31FE-11D1-AAD2-00805FC1270E"],
    "INetConnectionUiLock": ["FAEDCF50-31FE-11D1-AAD2-00805FC1270E"],
    "IEnumNetFwV6PortsAsVariants": ["C8A4F5EF-8DC9-4806-90AF-DB5AD4A5307C"],
    "INetFwV6PortsCollection": ["43287AC8-F5AB-498B-A455-74DC84750C49"],
    "IEnumNetFwV6ConnectionsAsVariants": ["D3CE39F1-3EA1-4AB2-AB29-D37E46A62315"],
    "INetFwV6ConnectionCollection": ["2A57D76E-94D7-484A-9D41-72CE289DED01"],
    "IEnumNetFwV6Ports": ["1901CCC7-A8CE-4207-BE51-E343419DEF19"],
    "IEnumNetFwV6Connections": ["05A800CA-317F-4608-9274-43D97D3924F5"],
    "INetFwV6Port": ["FD695182-B9FF-4224-B55F-6774CC4CDB38"],
    "INetFwV6Connection": ["1B664CB0-9403-4061-B356-B374C63B1241"],
    "INetFwV6Mgr": ["1C3FEDF7-1B2B-4550-A964-1511DF2163C8"],
    "IFlashConfig": ["8244DEDF-CF04-41FA-812F-E151F492C5AA"],
    "IProvisioningProfileWireless": ["C96FBD51-24DD-11D8-89FB-00904B2EA9C6"],
    "IProvisioningDomain": ["C96FBD50-24DD-11D8-89FB-00904B2EA9C6"],
    "ITRendezvous": ["34621D6B-6CFF-11D1-AFF7-00C04FC31FEE"],
    "IEnumDirectory": ["34621D6D-6CFF-11D1-AFF7-00C04FC31FEE"],
    "ITDirectory": ["34621D6C-6CFF-11D1-AFF7-00C04FC31FEE"],
    "ITILSConfig": ["34621D72-6CFF-11D1-AFF7-00C04FC31FEE"],
    "IEnumDirectoryObject": ["06C9B64A-306D-11D1-9774-00C04FD91AC0"],
    "ITDirectoryObject": ["34621D6E-6CFF-11D1-AFF7-00C04FC31FEE"],
    "IEnumDialableAddrs": ["34621D70-6CFF-11D1-AFF7-00C04FC31FEE"],
    "ITDirectoryObjectUser": ["34621D6F-6CFF-11D1-AFF7-00C04FC31FEE"],
    "ITDirectoryObjectConference": ["F1029E5D-CB5B-11D0-8D59-00C04FD91AC0"],
    "ISdoDictionaryOld": ["D432E5F4-53D8-11D2-9A3A-00C04FB998AC"],
    "ISdoCollection": ["56BC53E2-96DB-11D1-BF3F-000000000000"],
    "ISdo": ["56BC53DE-96DB-11D1-BF3F-000000000000"],
    "ISdoServiceControl": ["479F6E74-49A2-11D2-8ECA-00C04FC2F519"],
    "ISdoMachine": ["479F6E75-49A2-11D2-8ECA-00C04FC2F519"],
    "ITAttributeList": ["5037FB82-CAE9-11D0-8D58-00C04FD91AC0"],
    "ITConnection": ["8FA381D4-C8C2-11D0-8D58-00C04FD91AC0"],
    "ITSdp": ["9B2719D8-B696-11D0-A489-00C04FD91AC0"],
    "ITTimeCollection": ["0CC1F04F-CAEB-11D0-8D58-00C04FD91AC0"],
    "IEnumTime": ["9055322E-2FA8-11D1-9774-00C04FD91AC0"],
    "ITTime": ["2652BB78-1516-11D1-9771-00C04FD91AC0"],
    "ITMediaCollection": ["6A8E16A2-0ABC-11D1-976D-00C04FD91AC0"],
    "IEnumMedia": ["CA8397BE-2FA4-11D1-9774-00C04FD91AC0"],
    "ITMedia": ["0CC1F053-CAEB-11D0-8D58-00C04FD91AC0"],
    "ITConferenceBlob": ["C259D7AA-C8AB-11D0-8D58-00C04FD91AC0"],
    "ITAllocatorProperties": ["C1BC3C90-BCFE-11D1-9745-00C04FD91AC0"],
    "ITAMMediaFormat": ["0364EB00-4A77-11D1-A671-006097C9A2E8"],
    "IEnumAgentHandler": ["587E8C28-9802-11D1-A0A4-00805FC147D3"],
    "IEnumACDGroup": ["5AFC3157-4BCC-11D1-BF80-00805FC147D3"],
    "IEnumQueue": ["5AFC3158-4BCC-11D1-BF80-00805FC147D3"],
    "IEnumAgentSession": ["5AFC314E-4BCC-11D1-BF80-00805FC147D3"],
    "IEnumAgent": ["5AFC314D-4BCC-11D1-BF80-00805FC147D3"],
    "ITAgentHandler": ["587E8C22-9802-11D1-A0A4-00805FC147D3"],
    "ITTAPICallCenter": ["5AFC3154-4BCC-11D1-BF80-00805FC147D3"],
    "ITAgentHandlerEvent": ["297F3034-BD11-11D1-A0A7-00805FC147D3"],
    "ITQueueEvent": ["297F3033-BD11-11D1-A0A7-00805FC147D3"],
    "ITACDGroupEvent": ["297F3032-BD11-11D1-A0A7-00805FC147D3"],
    "ITAgentSessionEvent": ["5AFC314B-4BCC-11D1-BF80-00805FC147D3"],
    "ITAgentEvent": ["5AFC314A-4BCC-11D1-BF80-00805FC147D3"],
    "ITQueue": ["5AFC3149-4BCC-11D1-BF80-00805FC147D3"],
    "ITACDGroup": ["5AFC3148-4BCC-11D1-BF80-00805FC147D3"],
    "ITAgentSession": ["5AFC3147-4BCC-11D1-BF80-00805FC147D3"],
    "ITAgent": ["5770ECE5-4B27-11D1-BF80-00805FC147D3"],
    "ITScriptableAudioFormat": ["B87658BD-3C59-4F64-BE74-AEDE3E86A81E"],
    "ITBasicCallControl2": ["161A4A56-1E99-4B3F-A46A-168F38A5EE4C"],
    "ITLegacyWaveSupport": ["207823EA-E252-11D2-B77E-0080C7135381"],
    "IEnumSubStream": ["EE3BD609-3868-11D2-A045-00C04FB6809F"],
    "ITSubStream": ["EE3BD608-3868-11D2-A045-00C04FB6809F"],
    "ITSubStreamControl": ["EE3BD607-3868-11D2-A045-00C04FB6809F"],
    "IEnumStream": ["EE3BD606-3868-11D2-A045-00C04FB6809F"],
    "ITStream": ["EE3BD605-3868-11D2-A045-00C04FB6809F"],
    "ITStreamControl": ["EE3BD604-3868-11D2-A045-00C04FB6809F"],
    "ITDispatchMapper": ["E9225295-C759-11D1-A02B-00C04FB6809F"],
    "ITCallNotificationEvent": ["895801DF-3DD6-11D1-8F30-00C04FB6809F"],
    "IEnumCallingCard": ["0C4D8F02-8DDB-11D1-A09E-00805FC147D3"],
    "ITCallingCard": ["0C4D8F00-8DDB-11D1-A09E-00805FC147D3"],
    "IEnumLocation": ["0C4D8F01-8DDB-11D1-A09E-00805FC147D3"],
    "ITLocationInfo": ["0C4D8EFF-8DDB-11D1-A09E-00805FC147D3"],
    "ITAddressTranslationInfo": ["AFC15945-8D40-11D1-A09E-00805FC147D3"],
    "ITAddressTranslation": ["0C4D8F03-8DDB-11D1-A09E-00805FC147D3"],
    "ITForwardInformation2": ["5229B4ED-B260-4382-8E1A-5DF3A8A4CCC0"],
    "ITForwardInformation": ["449F659E-88A3-11D1-BB5D-00C04FB6809F"],
    "ITCollection2": ["E6DDDDA5-A6D3-48FF-8737-D32FC4D95477"],
    "ITCollection": ["5EC5ACF2-9C02-11D0-8362-00AA003CCABD"],
    "ITRequestEvent": ["AC48FFDE-F8C4-11D1-A030-00C04FB6809F"],
    "ITRequest": ["AC48FFDF-F8C4-11D1-A030-00C04FB6809F"],
    "ITCallInfoChangeEvent": ["5D4B65F9-E51C-11D1-A02F-00C04FB6809F"],
    "ITQOSEvent": ["CFA3357C-AD77-11D1-BB68-00C04FB6809F"],
    "ITToneTerminalEvent": ["E6F56009-611F-4945-BBD2-2D0CE5612056"],
    "ITASRTerminalEvent": ["EE016A02-4FA9-467C-933F-5A15B12377D7"],
    "ITTTSTerminalEvent": ["D964788F-95A5-461D-AB0C-B9900A6C2713"],
    "ITFileTerminalEvent": ["E4A7FBAC-8C17-4427-9F55-9F589AC8AF00"],
    "ITAddressDeviceSpecificEvent": ["3ACB216B-40BD-487A-8672-5CE77BD7E3A3"],
    "ITAddressEvent": ["831CE2D1-83B5-11D1-BB5C-00C04FB6809F"],
    "ITCallHubEvent": ["A3C15451-5B92-11D1-8F4E-00C04FB6809F"],
    "ITTAPIEventNotification": ["EDDB9426-3B91-11D1-8F30-00C04FB6809F"],
    "ITTAPIObjectEvent2": ["359DDA6E-68CE-4383-BF0B-169133C41B46"],
    "ITTAPIObjectEvent": ["F4854D48-937A-11D1-BB58-00C04FB6809F"],
    "ITToneDetectionEvent": ["407E0FAF-D047-4753-B0C6-8E060373FECD"],
    "ITDigitsGatheredEvent": ["E52EC4C1-CBA3-441A-9E6A-93CB909E9724"],
    "ITDigitGenerationEvent": ["80D3BFAD-57D9-11D2-A04A-00C04FB6809F"],
    "ITDigitDetectionEvent": ["80D3BFAC-57D9-11D2-A04A-00C04FB6809F"],
    "ITCallMediaEvent": ["FF36B87F-EC3A-11D0-8EE4-00C04FB6809F"],
    "ITPhoneDeviceSpecificEvent": ["63FFB2A6-872B-4CD3-A501-326E8FB40AF7"],
    "ITCallStateEvent": ["62F47097-95C9-11D0-835D-00AA003CCABD"],
    "ITPhoneEvent": ["8F942DD8-64ED-4AAF-A77D-B23DB0837EAD"],
    "IEnumPluggableSuperclassInfo": ["E9586A80-89E6-4CFF-931D-478D5751F4C0"],
    "IEnumPluggableTerminalClassInfo": ["4567450C-DBEE-4E3F-AAF5-37BF9EBF5E29"],
    "IEnumBstr": ["35372049-0BC6-11D2-A033-00C04FB6809F"],
    "IEnumCallHub": ["A3C15450-5B92-11D1-8F4E-00C04FB6809F"],
    "IEnumAddress": ["1666FCA1-9363-11D0-835C-00AA003CCABD"],
    "IEnumCall": ["AE269CF6-935E-11D0-835C-00AA003CCABD"],
    "IEnumTerminalClass": ["AE269CF5-935E-11D0-835C-00AA003CCABD"],
    "IEnumTerminal": ["AE269CF4-935E-11D0-835C-00AA003CCABD"],
    "IEnumPhone": ["F15B7669-4780-4595-8C89-FB369C8CF7AA"],
    "ITCustomTone": ["357AD764-B3C6-4B2A-8FA5-0722827A9254"],
    "ITDetectTone": ["961F79BD-3097-49DF-A1D6-909B77E89CA0"],
    "ITLegacyCallMediaControl2": ["57CA332D-7BC2-44F1-A60C-936FE8D7CE73"],
    "ITLegacyCallMediaControl": ["D624582F-CC23-4436-B8A5-47C625C8045D"],
    "ITLegacyAddressMediaControl2": ["B0EE512B-A531-409E-9DD9-4099FE86C738"],
    "ITPrivateEvent": ["0E269CD0-10D4-4121-9C22-9C85D625650D"],
    "ITLegacyAddressMediaControl": ["AB493640-4C0B-11D2-A046-00C04FB6809F"],
    "ITCallHub": ["A3C1544E-5B92-11D1-8F4E-00C04FB6809F"],
    "ITStaticAudioTerminal": ["A86B7871-D14C-48E6-922E-A8D15F984800"],
    "ITBasicAudioTerminal": ["B1EFC38D-9355-11D0-835C-00AA003CCABD"],
    "ITMediaControl": ["C445DDE8-5199-4BC7-9807-5FFB92E42E09"],
    "ITMediaRecord": ["F5DD4592-5476-4CC1-9D4D-FAD3EEFE7DB2"],
    "ITMediaPlayback": ["627E8AE6-AE4C-4A69-BB63-2AD625404B77"],
    "ITFileTrack": ["31CA6EA9-C08A-4BEA-8811-8E9C1BA3EA3A"],
    "ITMultiTrackTerminal": ["FE040091-ADE8-4072-95C9-BF7DE8C54B44"],
    "ITTerminal": ["B1EFC38A-9355-11D0-835C-00AA003CCABD"],
    "ITCallInfo2": ["94D70CA6-7AB0-4DAA-81CA-B8F8643FAEC1"],
    "ITCallInfo": ["350F85D1-1227-11D3-83D4-00C04FB6809F"],
    "ITBasicCallControl": ["B1EFC389-9355-11D0-835C-00AA003CCABD"],
    "ITAutomatedPhoneControl": ["1EE1AF0E-6159-4A61-B79B-6A4BA3FC9DFC"],
    "ITPhone": ["09D48DB4-10CC-4388-9DE7-A8465618975A"],
    "ITAddressCapabilities": ["8DF232F5-821B-11D1-BB5C-00C04FB6809F"],
    "ITAddress2": ["B0AE5D9B-BE51-46C9-B0F7-DFA8A22A8BC4"],
    "ITAddress": ["B1EFC386-9355-11D0-835C-00AA003CCABD"],
    "ITTerminalSupport2": ["F3EB39BC-1B1F-4E99-A0C0-56305C4DD591"],
    "ITTerminalSupport": ["B1EFC385-9355-11D0-835C-00AA003CCABD"],
    "ITPluggableTerminalSuperclassInfo": ["6D54E42C-4625-4359-A6F7-631999107E05"],
    "ITPluggableTerminalClassInfo": ["41757F4A-CF09-4B34-BC96-0A79D2390076"],
    "ITMediaSupport": ["B1EFC384-9355-11D0-835C-00AA003CCABD"],
    "ITTAPI2": ["54FBDC8C-D90F-4DAD-9695-B373097F094B"],
    "ITTAPI": ["B1EFC382-9355-11D0-835C-00AA003CCABD"],
    "ITPluggableTerminalSuperclassRegistration": ["60D3C08A-C13E-4195-9AB0-8DE768090F25"],
    "ITPluggableTerminalClassRegistration": ["924A3723-A00B-4F5F-9FEE-8E9AEB9E82AA"],
    "ITTerminalManager2": ["BB33DEC6-B2C7-46E6-9ED1-498B91FA85AC"],
    "ITTerminalManager": ["7170F2DE-9BE3-11D0-A009-00AA00B605A4"],
    "ITPluggableTerminalInitialization": ["AED6483C-3304-11D2-86F1-006008B0E5D2"],
    "ITTerminalControl": ["AED6483B-3304-11D2-86F1-006008B0E5D2"],
    "IRTCPresenceDevice": ["BC6A90DD-AD9A-48DA-9B0C-2515E38521AD"],
    "IRTCEnumPresenceDevices": ["708C2AB7-8BF8-42F8-8C7D-635197AD5539"],
    "IRTCSessionDescriptionManager": ["BA7F518E-D336-4070-93A6-865395C843F9"],
    "IRTCSessionReferredEvent": ["176A6828-4FCC-4F28-A862-04597A6CF1C4"],
    "IRTCSessionReferStatusEvent": ["3D8FC2CD-5D76-44AB-BB68-2A80353B34A2"],
    "IRTCUserSearchResultsEvent": ["D8C8C3CD-7FAC-4088-81C5-C24CBC0938E3"],
    "IRTCEnumUserSearchResults": ["83D4D877-AA5D-4A5B-8D0E-002A8067E0E8"],
    "IRTCUserSearchResult": ["851278B2-9592-480F-8DB5-2DE86B26B54D"],
    "IRTCUserSearchQuery": ["288300F5-D23A-4365-9A73-9985C98C2881"],
    "IRTCUserSearch": ["B619882B-860C-4DB4-BE1B-693B6505BBE5"],
    "IRTCClientPortManagement": ["D5DF3F03-4BDE-4417-AEFE-71177BDAEA66"],
    "IRTCSessionPortManagement": ["A072F1D6-0286-4E1F-85F2-17A2948456EC"],
    "IRTCPortManager": ["DA77C14B-6208-43CA-8DDF-5B60A0A69FAC"],
    "IRTCEventNotification": ["13FA24C7-5748-4B21-91F5-7397609CE747"],
    "IRTCBuddyGroup": ["60361E68-9164-4389-A4C6-D0B3925BDA5E"],
    "IRTCWatcher2": ["D4D9967F-D011-4B1D-91E3-ABA78F96393D"],
    "IRTCWatcher": ["C7CEDAD8-346B-4D1B-AC02-A2088DF9BE4F"],
    "IRTCBuddy2": ["102F9588-23E7-40E3-954D-CD7A1D5C0361"],
    "IRTCBuddy": ["FCB136C8-7B90-4E0C-BEFE-56EDF0BA6F1C"],
    "IRTCPresenceContact": ["8B22F92C-CD90-42DB-A733-212205C3E3DF"],
    "IRTCEnumGroups": ["742378D6-A141-4415-8F27-35D99076CF5D"],
    "IRTCEnumWatchers": ["A87D55D7-DB74-4ED1-9CA4-77A0E41B413E"],
    "IRTCEnumBuddies": ["F7296917-5569-4B3B-B3AF-98D1144B2B87"],
    "IRTCEnumProfiles": ["29B7C41C-ED82-4BCA-84AD-39D5101B58E3"],
    "IRTCEnumParticipants": ["FCD56F29-4A4F-41B2-BA5C-F5BCCC060BF6"],
    "IRTCCollection": ["EC7C8096-B918-4044-94F1-E4FBA0361D5C"],
    "IRTCPresenceStatusEvent": ["78673F32-4A0F-462C-89AA-EE7706707678"],
    "IRTCPresenceDataEvent": ["38F0E78C-8B87-4C04-A82D-AEDD83C909BB"],
    "IRTCPresencePropertyEvent": ["F777F570-A820-49D5-86BD-E099493F1518"],
    "IRTCReInviteEvent": ["11558D84-204C-43E7-99B0-2034E9417F7D"],
    "IRTCMediaRequestEvent": ["52572D15-148C-4D97-A36C-2DA55C289D63"],
    "IRTCInfoEvent": ["4E1D68AE-1912-4F49-B2C3-594FADFD425F"],
    "IRTCBuddyGroupEvent": ["3A79E1D1-B736-4414-96F8-BBC7F08863E4"],
    "IRTCWatcherEvent2": ["E52891E8-188C-49AF-B005-98ED13F83F9C"],
    "IRTCWatcherEvent": ["F30D7261-587A-424F-822C-312788F43548"],
    "IRTCBuddyEvent2": ["484A7F1E-73F0-4990-BFC2-60BC3978A720"],
    "IRTCBuddyEvent": ["F36D755D-17E6-404E-954F-0FC07574C78D"],
    "IRTCMessagingEvent": ["D3609541-1B29-4DE5-A4AD-5AEBAF319512"],
    "IRTCIntensityEvent": ["4C23BF51-390C-4992-A41D-41EEC05B2A4B"],
    "IRTCMediaEvent": ["099944FB-BCDA-453E-8C41-E13DA2ADF7F3"],
    "IRTCParticipantStateChangeEvent": ["09BCB597-F0FA-48F9-B420-468CEA7FDE04"],
    "IRTCSessionOperationCompleteEvent2": ["F6FC2A9B-D5BC-4241-B436-1B8460C13832"],
    "IRTCSessionOperationCompleteEvent": ["A6BFF4C0-F7C8-4D3C-9A41-3550F78A95B0"],
    "IRTCSessionStateChangeEvent2": ["4F933171-6F95-4880-80D9-2EC8D495D261"],
    "IRTCSessionStateChangeEvent": ["B5BAD703-5952-48B3-9321-7F4500521506"],
    "IRTCRegistrationStateChangeEvent": ["62D0991B-50AB-4F02-B948-CA94F26F8F95"],
    "IRTCClientEvent": ["2B493B7A-3CBA-4170-9C8B-76A9DACDD644"],
    "IRTCProfileEvent2": ["62E56EDC-03FA-4121-94FB-23493FD0AE64"],
    "IRTCProfileEvent": ["D6D5AB3B-770E-43E8-800A-79B062395FCA"],
    "IRTCRoamingEvent": ["79960A6B-0CB1-4DC8-A805-7318E99902E8"],
    "IRTCParticipant": ["AE86ADD5-26B1-4414-AF1D-B94CD938D739"],
    "IRTCSessionCallControl": ["E9A50D94-190B-4F82-9530-3B8EBF60758A"],
    "IRTCSession2": ["17D7CDFC-B007-484C-99D2-86A8A820991D"],
    "IRTCSession": ["387C8086-99BE-42FB-9973-7C0FC0CA9FA8"],
    "IRTCProfile2": ["4B81F84E-BDC7-4184-9154-3CB2DD7917FB"],
    "IRTCProfile": ["D07ECA9E-4062-4DD4-9E7D-722A49BA7303"],
    "IRTCClientProvisioning2": ["A70909B5-F40E-4587-BB75-E6BC0845023E"],
    "IRTCClientProvisioning": ["B9F5CF06-65B9-4A80-A0E6-73CAE3EF3822"],
    "IRTCClientPresence2": ["AD1809E8-62F7-4783-909A-29C9D2CB1D34"],
    "IRTCClientPresence": ["11C3CBCC-0744-42D1-968A-51AA1BB274C6"],
    "IRTCClient2": ["0C91D71D-1064-42DA-BFA5-572BEB8EEA84"],
    "IRTCClient": ["07829E45-9A34-408E-A011-BDDF13487CD1"],
    "IUPnPDeviceHostSetup": ["6BD34909-54E7-4FBF-8562-7B89709A589A"],
    "IUPnPDescriptionDocumentCallback": ["77394C69-5486-40D6-9BC3-4991983E02DA"],
    "IUPnPDescriptionDocument": ["11D1C1B2-7DAA-4C9E-9595-7F82ED206D1E"],
    "IUPnPDeviceDocumentAccess": ["E7772804-3287-418E-9072-CF2B47238981"],
    "IUPnPDevice": ["3D44D0D1-98C9-4889-ACD1-F9D674BF2221"],
    "IUPnPDevices": ["FDBC0C73-BDA3-4C66-AC4F-F2D96FDAD68C"],
    "IUPnPServiceCallback": ["31FADCA9-AB73-464B-B67D-5C1D0F83C8B8"],
    "IUPnPService": ["A295019C-DC65-47DD-90DC-7FE918A1AB44"],
    "IUPnPServices": ["3F8C8E9E-9A7A-4DC8-BC41-FF31FA374956"],
    "IUPnPDeviceFinderCallback": ["415A984A-88B3-49F3-92AF-0508BEDF0D6C"],
    "IUPnPDeviceFinder": ["ADDA3D55-6F72-4319-BFF9-18600A539B10"],
    "IUPnPPrivateDocumentCallbackHelper": ["19432A8E-4A32-4860-B8FB-95B1117CD4E5"],
    "IUPnPDeviceFinderAddCallbackWithInterface": ["983DFC0B-1796-44DF-8975-CA545B620EE5"],
    "IUPnPDeviceHostICSSupport": ["3FFC5AE5-A66B-499C-A180-C7393DB6BA8D"],
    "ISOAPRequest": ["AD194525-6E01-4BCA-929C-23C7383336AF"],
    "IUPnPServiceCallbackPrivate": ["24EA2515-F612-4528-BA82-7BD3DBBAD303"],
    "IUPnPPrivateServiceHelper2": ["340F4076-6856-48F9-B3C4-97B91B68D77E"],
    "IUPnPPrivateCallbackHelper": ["8DCC8327-DBE9-48E6-846C-33725865D50C"],
    "IUPnPRemoteEndpointInfo": ["C92EB863-0269-4AFF-9C72-75321BBA2952"],
    "IUPnPDeviceProvider": ["204810B8-73B2-11D4-BF42-00B0D0118B56"],
    "IUPnPDeviceControl": ["204810BA-73B2-11D4-BF42-00B0D0118B56"],
    "IUPnPReregistrar": ["204810B7-73B2-11D4-BF42-00B0D0118B56"],
    "IUPnPRegistrar": ["204810B6-73B2-11D4-BF42-00B0D0118B56"],
    "IUPnPEventSource": ["204810B5-73B2-11D4-BF42-00B0D0118B56"],
    "IUPnPEventSink": ["204810B4-73B2-11D4-BF42-00B0D0118B56"],
    "IXmlProviderEventNotification": ["A4886EFF-60B4-11D7-AE0A-00104BC54117"],
    "IXmlProviderNotification": ["A4886EFE-60B4-11D7-AE0A-00104BC54117"],
    "IXmlProviderDocuments": ["A4886EFD-60B4-11D7-AE0A-00104BC54117"],
    "IXmlProviderMaster": ["A4886EFC-60B4-11D7-AE0A-00104BC54117"],
    "IRowInfo": ["0C733AC1-2A1C-11CE-ADE5-00AA0044773D"],
    "ITmNodeName": ["30274F88-6EE4-474E-9B95-7807BC9EF8CF"],
    "ITransactionOutcomeEvents": ["3A6AD9E2-23B9-11CF-AD60-00AA00A74CCD"],
    "ITransactionOptions": ["3A6AD9E0-23B9-11CF-AD60-00AA00A74CCD"],
    "ITransactionDispenser": ["3A6AD9E1-23B9-11CF-AD60-00AA00A74CCD"],
    "ITransaction2": ["34021548-0065-11D3-BAC1-00C04F797BE2"],
    "ITransactionCloner": ["02656950-2152-11D0-944C-00A0C905416E"],
    "ITransaction": ["0FB15084-AF41-11CE-BD2B-204C4F4F5020"],
    "IEventServerTrace": ["9A9F12B8-80AF-47AB-A579-35EA57725370"],
    "IComLceEventDispatcher": ["6E35779B-305C-11D2-98A5-00C04F8EE1C4"],
    "INtaHelper": ["F5659960-0799-11D2-B720-00C04F8EE1C4"],
    "IProcessWatch": ["3194B4CE-EF32-11D1-93AE-00AA00BA3258"],
    "IProcessTerminateNotify": ["3194B4CF-EF32-11D1-93AE-00AA00BA3258"],
    "IEventServerInternal": ["2A5354DD-0634-4B0E-9D5A-FC5836CDCDF5"],
    "IEventServer2": ["378F3CA7-BD24-481C-8DC3-5E5ECE1BCAD7"],
    "IEventServer": ["F1CB0608-EC04-11D1-93AE-00AA00BA3258"],
    "IEventRegistrar": ["B4777622-6EB8-4655-AE1B-AF0A6E046CD0"],
    "IEventDispatcher": ["3194B4CD-EF32-11D1-93AE-00AA00BA3258"],
    "IEventCall": ["90D6AF83-0648-11D2-B719-00C04F8EE1C4"],
    "AsyncIEventSourceCallback2": ["C95BFC3D-76C5-4FDF-B0DE-A31F56785638"],
    "IEventSourceCallback2": ["F4C459A1-A13D-4BB8-B0F3-B76F860A07A0"],
    "AsyncIEventSourceCallback": ["90D6AF82-0648-11D2-B719-00C04F8EE1C4"],
    "IEventSourceCallback": ["3194B4CC-EF32-11D1-93AE-00AA00BA3258"],
    "IEnterActivityWithNoLock": ["D7174F82-36B8-4AA8-800A-E963AB2DFAB9"],
    "IQCPartitionInfo": ["59AA8AFC-F483-4862-A9A8-BEF669F6583D"],
    "IMarshalInterceptor": ["C99D1FC8-D0DC-11D2-9228-00C04F79D1EB"],
    "IQCMonikerInfo": ["83F3D27D-0646-11D2-9F6F-00C04FC340EE"],
    "IMkOption": ["E83BCB9F-5B12-11D2-9B88-00C04F7978E0"],
    "IQCQueueAdministration": ["1FA984EA-E213-11D2-9B41-00C04F7978E0"],
    "IMSMQQueueOptions": ["EF50B580-71BC-11D2-9BB9-00C04F7978E0"],
    "IQCPlayer": ["A3E69F2B-00AA-11D2-B58A-00E0290E6C31"],
    "IIntegrator": ["1F20BC5A-0549-11D2-8B2A-0000F8065031"],
    "ILQue": ["EC9E950E-AF2A-11D2-9A72-00C04F79B14C"],
    "ILMessage": ["CB34ADCA-9C0D-11D4-8373-00C04F605588"],
    "IQCListener": ["2A36CF7E-9B12-11D4-8373-00C04F605588"],
    "IQCInterfaceManager": ["7DAB9041-3180-42C6-A4D6-D895B512746B"],
    "IRpcChannelBufferInternal": ["6BC6DF07-620F-4219-BC54-B5C65BB71E9B"],
    "IChannelManager": ["99921E41-C341-11D0-8B1D-00A0C90365D6"],
    "IRecorderInternal": ["5D0B6204-35DE-4A66-AB26-1E5A7B332A4A"],
    "IMarshal3": ["7090ED49-E141-11D1-B586-00E0290E6C31"],
    "IMessageMover": ["588A085A-B795-11D1-8054-00C04FC340EE"],
    "IClassVbDebugInfo": ["2AAC1488-7809-11D2-9FEF-00C04F8EF934"],
    "IClassFactoryWithCoContext": ["0628A7E8-6918-11D2-9FED-00C04F8EF934"],
    "IMtsVbHelper": ["FC4886B2-A40F-11D1-AA88-00AA00BA3258"],
    "IEventSystem2": ["99CC098F-A48A-4E9C-8E58-965C0AFC19D5"],
    "IEventSubscription3": ["FBC1D17D-C498-43A0-81AF-423DDD530AF6"],
    "IEventSubscription2": ["4A6B0E16-2E38-11D1-9965-00C04FBBB345"],
    "IEventClassParallelFiringTimeout": ["A5657E5C-7BAE-4E81-9C17-284655918763"],
    "IEventClass3": ["7FB7EA43-2D76-4EA8-8CD9-3DECC270295E"],
    "IMultiInterfaceEventControl": ["0343E2F5-86F6-11D1-B760-00C04FB926AF"],
    "IEventControl": ["0343E2F4-86F6-11D1-B760-00C04FB926AF"],
    "IEventProperty": ["DA538EE2-F4DE-11D1-B6BB-00805FC79216"],
    "IEventObjectCollection": ["F89AC270-D4EB-11D1-B682-00805FC79216"],
    "IEnumEventObject": ["F4A07D63-2E25-11D1-9964-00C04FBBB345"],
    "IEventObjectChange2": ["7701A9C3-BD68-438F-83E0-67BF4F53A422"],
    "IEventObjectChange": ["F4A07D70-2E25-11D1-9964-00C04FBBB345"],
    "IMultiInterfacePublisherFilter": ["465E5CC1-7B26-11D1-88FB-0080C7D771BF"],
    "IPublisherFilter": ["465E5CC0-7B26-11D1-88FB-0080C7D771BF"],
    "IFiringControl": ["E0498C93-4EFE-11D1-9971-00C04FBBB345"],
    "IEventSubscription": ["4A6B0E15-2E38-11D1-9965-00C04FBBB345"],
    "IEventClass2": ["FB2B72A1-7A68-11D1-88F9-0080C7D771BF"],
    "IEventClass": ["FB2B72A0-7A68-11D1-88F9-0080C7D771BF"],
    "IEventPublisher": ["E341516B-2E32-11D1-9964-00C04FBBB345"],
    "IEventSystem": ["4E14FB9F-2E22-11D1-9964-00C04FBBB345"],
    "ISystemDebugEventFireAuto": ["6C736DEE-AB0E-11D0-A2AD-00A0C90F27E8"],
    "ISystemDebugEventFire": ["6C736DC1-AB0D-11D0-A2AD-00A0C90F27E8"],
    "ICatalogCollection": ["6EB22872-8A19-11D0-81B6-00A0C9231C29"],
    "ICatalogObject": ["6EB22871-8A19-11D0-81B6-00A0C9231C29"],
    "ICOMAdminCatalog2": ["790C6E0B-9194-4CC9-9426-A48A63185696"],
    "ICOMAdminCatalog": ["DD662187-DFC2-11D1-A2CF-00805FC79235"],
    "IMtsGrp": ["4B2E958C-0393-11D1-B1AB-00AA00BA3258"],
    "IMTSLocator": ["D19B8BFD-7F88-11D0-B16E-00AA00BA3258"],
    "IMtsEventInfo": ["D56C3DC1-8482-11D0-B170-00AA00BA3258"],
    "IMtsEvents": ["BACEDF4D-74AB-11D0-B162-00AA00BA3258"],
    "ISystemAppEventData": ["D6D48A3C-D5C5-49E7-8C74-99E4889ED52F"],
    "IComObjectConstruction2Events": ["4B5A7827-8DF2-45C0-8F6F-57EA1F856A9F"],
    "IComObjectPool2Events": ["65BF6534-85EA-4F64-8CF4-3D974B2AB1CF"],
    "IComInstance2Events": ["20E3BF07-B506-4AD5-A50C-D2CA5B9C158E"],
    "IComTransaction2Events": ["A136F62A-2F94-4288-86E0-D8A1FA4C0299"],
    "IComApp2Events": ["1290BC1A-B219-418D-B078-5934DED08242"],
    "IComTrackingInfoProperties": ["789B42BE-6F6B-443A-898E-67ABF390AA14"],
    "IComTrackingInfoObject": ["116E42C5-D8B1-47BF-AB1E-C895ED3E2372"],
    "IComTrackingInfoCollection": ["C266C677-C9AD-49AB-9FD9-D9661078588A"],
    "IComTrackingInfoEvents": ["4E6CDCC9-FB25-4FD5-9CC5-C9F4B6559CEC"],
    "IComMethod2Events": ["FB388AAA-567D-4024-AF8E-6E93EE748573"],
    "IComCRMEvents": ["683130B5-2E50-11D2-98A5-00C04F8EE1C4"],
    "ILBEvents": ["683130B4-2E50-11D2-98A5-00C04F8EE1C4"],
    "IComExceptionEvents": ["683130B3-2E50-11D2-98A5-00C04F8EE1C4"],
    "IComQCEvents": ["683130B2-2E50-11D2-98A5-00C04F8EE1C4"],
    "IComIdentityEvents": ["683130B1-2E50-11D2-98A5-00C04F8EE1C4"],
    "IComActivityEvents": ["683130B0-2E50-11D2-98A5-00C04F8EE1C4"],
    "IComObjectConstructionEvents": ["683130AF-2E50-11D2-98A5-00C04F8EE1C4"],
    "IComObjectPoolEvents2": ["683130AE-2E50-11D2-98A5-00C04F8EE1C4"],
    "IComObjectPoolEvents": ["683130AD-2E50-11D2-98A5-00C04F8EE1C4"],
    "IComSecurityEvents": ["683130AC-2E50-11D2-98A5-00C04F8EE1C4"],
    "IComResourceEvents": ["683130AB-2E50-11D2-98A5-00C04F8EE1C4"],
    "IComObjectEvents": ["683130AA-2E50-11D2-98A5-00C04F8EE1C4"],
    "IComMethodEvents": ["683130A9-2E50-11D2-98A5-00C04F8EE1C4"],
    "IComTransactionEvents": ["683130A8-2E50-11D2-98A5-00C04F8EE1C4"],
    "IComInstanceEvents": ["683130A7-2E50-11D2-98A5-00C04F8EE1C4"],
    "IComAppEvents": ["683130A6-2E50-11D2-98A5-00C04F8EE1C4"],
    "IComThreadEvents": ["683130A5-2E50-11D2-98A5-00C04F8EE1C4"],
    "IComUserEvent": ["683130A4-2E50-11D2-98A5-00C04F8EE1C4"],
    "IMtsEventsPriv2": ["59415D35-A530-4C14-AF2A-C71F8BFAE2EE"],
    "IMtsEventsPriv": ["44F876D8-8391-11D0-B16F-00AA00BA3258"],
    "IVolatilePolicyManager": ["9211A2CA-7B10-11D1-8633-0060089F6007"],
    "ICreateWithTipTransactionEx": ["455ACF59-5345-11D2-99CF-00C04F797BC9"],
    "ICreateWithTransactionEx": ["455ACF57-5345-11D2-99CF-00C04F797BC9"],
    "ITransactionContext": ["7999FC21-D3C6-11CF-ACAB-00A024A55AEF"],
    "ITransactionContextEx": ["7999FC22-D3C6-11CF-ACAB-00A024A55AEF"],
    "IEnumTRUSTPOLICYINFO": ["9211A291-7B10-11D1-8633-0060089F6007"],
    "IEnumTrustPolicy": ["9211A290-7B10-11D1-8633-0060089F6007"],
    "IScriptPolicyMaker": ["9211A27B-7B10-11D1-8633-0060089F6007"],
    "ITrustPolicyScript": ["9211A27A-7B10-11D1-8633-0060089F6007"],
    "ITrustPolicySetup": ["9211A279-7B10-11D1-8633-0060089F6007"],
    "ITrustPolicyVerbs": ["9211A278-7B10-11D1-8633-0060089F6007"],
    "ITrustPropertySet": ["9211A277-7B10-11D1-8633-0060089F6007"],
    "ITrustEvaluationContextProvider": ["9211A27C-7B10-11D1-8633-0060089F6007"],
    "ITrustEvaluationContext": ["9211A276-7B10-11D1-8633-0060089F6007"],
    "IInstancesCollection": ["9211A27E-7B10-11D1-8633-0060089F6007"],
    "ICategoriesCollection": ["9211A27D-7B10-11D1-8633-0060089F6007"],
    "IPolicyCategoryRegister": ["9211A275-7B10-11D1-8633-0060089F6007"],
    "IPolicyManager": ["9211A274-7B10-11D1-8633-0060089F6007"],
    "ITrustManager": ["9211A272-7B10-11D1-8633-0060089F6007"],
    "ITrustPolicy": ["9211A271-7B10-11D1-8633-0060089F6007"],
    "IProvideEvalContext": ["9211A297-7B10-11D1-8633-0060089F6007"],
    "ITrustable": ["9211A270-7B10-11D1-8633-0060089F6007"],
    "IClrObjectFactory": ["ECABAFD2-7F19-11D2-978E-0000F8757E2A"],
    "IClerksCollection": ["3ADEFFE3-C802-11D1-82FB-00A0C91EEDE9"],
    "ICRMRecoveryClerk": ["46E4FA02-8789-4AB9-8AD3-8CF46B8459C7"],
    "ICRMClerk": ["53610480-9695-11D1-82ED-00A0C91EEDE9"],
    "IPoolMgrPrivate": ["2BD0C880-D2E2-11D1-939A-00AA00BA3258"],
    "IPoolMgr": ["AA089089-3689-11D1-B1CF-00AA00BA3258"],
    "IServicePoolOptions": ["1D04CDF7-EAD5-41F0-AA0A-80218BD53B0D"],
    "ISvcPoolInit": ["68954CDF-5D4E-4EF2-B9B7-604A9B22FBF8"],
    "IObjPool": ["7D8805A0-2EA7-11D1-B1CC-00AA00BA3258"],
    "IPooledObj": ["7D8805A1-2EA7-11D1-B1CC-00AA00BA3258"],
    "ISTAPropStore": ["F4319F39-C523-11D1-A64E-0000F805B4B0"],
    "IUserPropsEnumInternal": ["FE00EDC3-6BE3-4792-AA01-E663F1B70B10"],
    "IUserPropsInternal": ["2599BAB0-C5FB-11D1-9396-00AA00BA3258"],
    "IAssociation": ["FE454FF4-C5CF-11D1-9396-00AA00BA3258"],
    "IImpersonationControl": ["51372AFF-CAE7-11CF-BE81-00AA00A2FA25"],
    "INonMTSActivation": ["51372AFB-CAE7-11CF-BE81-00AA00A2FA25"],
    "IThreadEventSource": ["51372AFA-CAE7-11CF-BE81-00AA00A2FA25"],
    "IThreadEvents": ["51372AF9-CAE7-11CF-BE81-00AA00A2FA25"],
    "IDumpControl": ["368F417F-280E-4639-B17A-6DDB0D9EE2BE"],
    "IFailfastControl": ["51372AF8-CAE7-11CF-BE81-00AA00A2FA25"],
    "IPauseResumeApp": ["E7228E0B-A708-4113-84E8-239DB12E0DB2"],
    "IMTSPackage": ["9A83A958-B859-11D1-AA90-00AA00BA3258"],
    "IMTSPackageControl": ["51372AF1-CAE7-11CF-BE81-00AA00A2FA25"],
    "IPackageControlInternal": ["B1B229B0-B77E-11D0-8079-00C04FC2F9C1"],
    "ISecurityInternal": ["A71D9C69-AE37-11D1-B82B-0000F8757E2A"],
    "IObjectContextTransaction": ["51372AEE-CAE7-11CF-BE81-00AA00A2FA25"],
    "IGetInternalTransaction": ["BF3108F3-D51C-47F2-9E58-E2C874F639A4"],
    "ITransactionProperty": ["788EA814-87B1-11D1-BBA6-00C04FC2FA5F"],
    "IRootTxStreamInternal": ["4E311080-8E81-11D1-9DCE-00C04FC2FBA2"],
    "ITxStreamInternal": ["4E31107F-8E81-11D1-9DCE-00C04FC2FBA2"],
    "ITransactionEvents": ["6287E875-9050-11D1-9DCE-00C04FC2FBA2"],
    "ITransactionStream": ["97199110-DB2E-11D1-A251-0000F805CA53"],
    "IActivity": ["C3813A4A-CE3A-11D1-939A-00AA00BA3258"],
    "IMTSActivity": ["51372AF0-CAE7-11CF-BE81-00AA00A2FA25"],
    "ICallContextNotify": ["51372AEB-CAE7-11CF-BE81-00AA00A2FA25"],
    "IBabyJITInterceptor": ["4BC31C23-C58D-4964-BD3F-01A302A96ED5"],
    "IBabyJITActivation": ["A7F3111A-56C6-47DE-A32D-0C4F5769BB14"],
    "IEnableDisableProperty": ["822646E6-D8B4-4B6F-A000-CFD379510CA9"],
    "ITrackerProperty": ["FBAC04F0-7D8C-45BF-B5B6-C6841D16FB61"],
    "IJITActivationProperty": ["788EA813-87B1-11D1-BBA6-00C04FC2FA5F"],
    "IActivationEvents": ["788EA812-87B1-11D1-BBA6-00C04FC2FA5F"],
    "IRegisterPhase0": ["0199706D-7B3E-11D2-99FB-00C04F797BC9"],
    "IPhase0Notify": ["0199706C-7B3E-11D2-99FB-00C04F797BC9"],
    "IServiceConfigInternal": ["374093DF-B5E7-4B91-8445-5102C062C2C9"],
    "IContextProperties": ["D396DA85-BF8F-11D1-BBAE-00C04FC2FA5F"],
    "IMTSCall": ["51372AEF-CAE7-11CF-BE81-00AA00A2FA25"],
    "ITransactionResourcePool": ["C5FEB7C1-346A-11D1-B1CC-00AA00BA3258"],
    "ISendMethodEvents": ["2732FD59-B2B4-4D44-878C-8B8F09626008"],
    "IManagedActivationEvents": ["A5F325AF-572F-46DA-B8AB-827C3D95D99E"],
    "IAssemblyLocator": ["391FFBB9-A8EE-432A-ABC8-BAA238DAB90F"],
    "IAppDomainHelper": ["C7B67079-8255-42C6-9EC0-6994A3548780"],
    "IManagedObjectInfo": ["1427C51A-4584-49D8-90A0-C50D8086CBE9"],
    "IManagedPoolAction": ["DA91B74E-5388-4783-949D-C1CD5FB00506"],
    "IManagedPooledObj": ["C5DA4BEA-1B42-4437-8926-B6A38860A770"],
    "IServicePool": ["B302DF81-EA45-451E-99A2-09F9FD1B1E13"],
    "IServicePoolConfig": ["A9690656-5BCA-470C-8451-250C1F43A33E"],
    "IProcessInitializer": ["1113F52D-DC7F-4943-AED6-88D04027E32A"],
    "IComStaThreadPoolKnobs2": ["73707523-FF9A-4974-BF84-2108DC213740"],
    "IComMtaThreadPoolKnobs": ["F9A76D2E-76A5-43EB-A0C4-49BEC8E48480"],
    "IComStaThreadPoolKnobs": ["324B64FA-33B6-11D2-98B7-00C04F8EE1C4"],
    "IThreadPoolKnobs": ["51372AF7-CAE7-11CF-BE81-00AA00A2FA25"],
    "IServiceActivity": ["67532E0C-9E2F-4450-A354-035633944E17"],
    "IAsyncErrorNotify": ["FE6777FB-A674-4177-8F32-6D707E113484"],
    "IServiceCall": ["BD3E2E12-42DD-40F4-A09A-95A50C58304B"],
    "IServicePartitionConfig": ["80182D03-5EA4-4831-AE97-55BEFFC2E590"],
    "IServiceTrackerConfig": ["6C3A3E1D-0BA6-4036-B76F-D0404DB816C9"],
    "IServiceSynchronizationConfig": ["FD880E81-6DCE-4C58-AF83-A208846C0030"],
    "IServiceTransactionConfig": ["59F4C2A3-D3D7-4A31-B6E4-6AB3177C50B9"],
    "IServiceTransactionConfigBase": ["772B3FBE-6FFD-42FB-B5F8-8F9B260F3810"],
    "IServiceThreadPoolConfig": ["186D89BC-F277-4BCC-80D5-4DF7B836EF4A"],
    "IServiceInheritanceConfig": ["92186771-D3B4-4D77-A8EA-EE842D586F35"],
    "ICheckSxsConfig": ["0FF5A96F-11FC-47D1-BAA6-25DD347E7242"],
    "IServiceSxsConfig": ["C7CD7379-F3F2-4634-811B-703281D73E08"],
    "IServiceComTIIntrinsicsConfig": ["09E6831E-04E1-4ED4-9D0F-E8B168BAFEAF"],
    "IServiceIISIntrinsicsConfig": ["1A0CF920-D452-46F4-BC36-48118D54EA52"],
    "ICrmFormatLogRecords": ["9C51D821-C98B-11D1-82FB-00A0C91EEDE9"],
    "ICrmMonitor": ["70C8E443-C7ED-11D1-82FB-00A0C91EEDE9"],
    "ICrmMonitorClerks": ["70C8E442-C7ED-11D1-82FB-00A0C91EEDE9"],
    "ICrmMonitorLogRecords": ["70C8E441-C7ED-11D1-82FB-00A0C91EEDE9"],
    "ICrmCompensator": ["BBC01830-8D3B-11D1-82EC-00A0C91EEDE9"],
    "ICrmCompensatorVariants": ["F0BAF8E4-7804-11D1-82E9-00A0C91EEDE9"],
    "ICrmLogControl": ["A0E174B3-D26E-11D2-8F84-00805FC7BCD9"],
    "ICOMLBArguments": ["3A0F150F-8EE5-4B94-B40E-AEF2F9E42ED2"],
    "ISelectCOMLBServer": ["DCF443F4-3F8A-4872-B9F0-369A796D12D6"],
    "IPoolManager": ["0A469861-5A91-43A0-99B6-D5E179BB0631"],
    "IContextState": ["3C05E54B-A42A-11D2-AFC4-00C04F8EE1C4"],
    "IGetContextProperties": ["51372AF4-CAE7-11CF-BE81-00AA00A2FA25"],
    "IPlaybackControl": ["51372AFD-CAE7-11CF-BE81-00AA00A2FA25"],
    "IObjectContextTip": ["92FD41CA-BAD9-11D2-9A2D-00C04F797BC9"],
    "ITransactionStatus": ["61F589E8-3724-4898-A0A4-664AE9E1D1B4"],
    "IObjectContextInfo2": ["594BE71A-4BC4-438B-9197-CFD176248B09"],
    "IObjectContextInfo": ["75B52DDB-E8ED-11D1-93AD-00AA00BA3258"],
    "IObjectContextActivity": ["51372AFC-CAE7-11CF-BE81-00AA00A2FA25"],
    "IObjectConstructString": ["41C4F8B2-7439-11D2-98CB-00C04F8EE1C4"],
    "IObjectConstruct": ["41C4F8B3-7439-11D2-98CB-00C04F8EE1C4"],
    "ISharedPropertyGroupManager": ["2A005C0D-A5DE-11CF-9E66-00AA00A3F464"],
    "ISharedPropertyGroup": ["2A005C07-A5DE-11CF-9E66-00AA00A3F464"],
    "ISharedProperty": ["2A005C01-A5DE-11CF-9E66-00AA00A3F464"],
    "ObjectControl": ["7DC41850-0C31-11D0-8B79-00AA00B8A790"],
    "ISecurityProperty": ["51372AEA-CAE7-11CF-BE81-00AA00A2FA25"],
    "IEnumNames": ["51372AF2-CAE7-11CF-BE81-00AA00A2FA25"],
    "IObjectControl": ["51372AEC-CAE7-11CF-BE81-00AA00A2FA25"],
    "IObjectContext": ["51372AE0-CAE7-11CF-BE81-00AA00A2FA25"],
    "IDispenserDriver": ["208B3651-2B48-11CF-BE10-00AA00A2FA25"],
    "IHolder": ["BF6A1850-2B45-11CF-BE10-00AA00A2FA25"],
    "IDispenserManagerShutdownGuarantee": ["5CB31E11-2B5F-11CF-BE10-00AA00A2FA25"],
    "IDispenserManager": ["5CB31E10-2B5F-11CF-BE10-00AA00A2FA25"],
    "IProcessDump": ["23C9DD26-2355-4FE2-84DE-F779A238ADBD"],
    "ITrkSvrAppControl": ["6EB6BA78-BE49-4044-9FE5-25B98380CA3F"],
    "IGetAppData": ["B60040E0-BCF3-11D1-861D-0080C729264D"],
    "IReceiveAppData": ["413DAFB0-BCF4-11D1-861D-0080C729264D"],
    "IClassTrackerUpdate": ["EA61E3C2-7C62-11CF-BE3F-00AA00A2FA25"],
    "IAppTracker": ["9096B831-7472-11CF-BE39-00AA00A2FA25"],
    "IGetSecurityCallContext": ["CAFC823F-B441-11D1-B82B-0000F8757E2A"],
    "ISecurityCallContext": ["CAFC823E-B441-11D1-B82B-0000F8757E2A"],
    "ISecurityCallersColl": ["CAFC823D-B441-11D1-B82B-0000F8757E2A"],
    "ISecurityIdentityColl": ["CAFC823C-B441-11D1-B82B-0000F8757E2A"],
    "ISecurityCertificateColl": ["CAFC823B-B441-11D1-B82B-0000F8757E2A"],
    "ISecurityCallCtxPrivate": ["29012F73-8C30-11D1-8E04-0080C7F8C2BF"],
    "IMTxAS": ["74C08641-CEDB-11CF-8B49-00AA00B8A790"],
    "ObjectContext": ["74C08646-CEDB-11CF-8B49-00AA00B8A790"],
    "ContextInfo2": ["C99D6E75-2375-11D4-8331-00C04F605588"],
    "ContextInfo": ["19A5A02C-0AC8-11D2-B286-00C04F8EF934"],
    "SecurityProperty": ["E74A7215-014D-11D1-A63C-00A0C911B4E0"],
    "IEnumChannels": ["A4C65425-0F82-11D1-90C3-00C04FC2F568"],
    "IChannelMgr": ["85BD8E82-0FBA-11D1-90C3-00C04FC2F568"],
    "IImageList": ["46EB5926-582E-4017-9FDF-E8998DAA0950", "43136EB8-D36C-11CF-ADBC-00AA00A80033"],
    "IEmptyVolumeCache2": ["02B7E3BA-4DB3-11D2-B2D9-00C04F8EEC8C"],
    "IEmptyVolumeCache": ["8FCE5227-04DA-11D1-A004-00805F8ABE06"],
    "IEmptyVolumeCacheCallBack": ["6E793361-73C6-11D0-8469-00AA00442901"],
    "IDiscMaster": ["520CCA62-51A5-11D3-9144-00104BA11C5E"],
    "IDiscMasterProgressEvents": ["EC9E51C1-4E5D-11D3-9144-00104BA11C5E"],
    "IJolietDiscMaster": ["E3BC42CE-4E5C-11D3-9144-00104BA11C5E"],
    "IRedbookDiscMaster": ["E3BC42CD-4E5C-11D3-9144-00104BA11C5E"],
    "IEnumDiscMasterFormats": ["DDF445E1-54BA-11D3-9144-00104BA11C5E"],
    "IEnumDiscRecorders": ["9B1921E1-54AC-11D3-9144-00104BA11C5E"],
    "IDiscRecorder": ["85AC9776-CA88-4CF2-894E-09598C078A41"],
    "IMultiLanguage3": ["4E5868AB-B157-4623-9ACC-6A1D9CAEBE04"],
    "IMLangFontLink2": ["DCCFC162-2B38-11D2-B7EC-00C04F8F5D9A"],
    "IMLangFontLink": ["359F3441-BD4A-11D0-B188-00AA0038C969"],
    "IMLangCodePages": ["359F3443-BD4A-11D0-B188-00AA0038C969"],
    "IMultiLanguage2": ["DCCFC164-2B38-11D2-B7EC-00C04F8F5D9A"],
    "IMultiLanguage": ["275C23E1-3747-11D0-9FEA-00AA003F8646"],
    "IMLangConvertCharset": ["D66D6F98-CDAA-11D0-B822-00C04FC9B31F"],
    "IEnumScript": ["AE5F1430-388B-11D2-8380-00C04F8F5DA1"],
    "IEnumRfc1766": ["3DC39D1D-C030-11D0-B81B-00C04FC9B31F"],
    "IEnumCodePage": ["275C23E3-3747-11D0-9FEA-00AA003F8646"],
    "IMLangLineBreakConsole": ["F5BE2EE1-BFD7-11D0-B188-00AA0038C969"],
    "IMLangStringAStr": ["C04D65D2-B70D-11D0-B188-00AA0038C969"],
    "IMLangStringWStr": ["C04D65D0-B70D-11D0-B188-00AA0038C969"],
    "IMLangString": ["C04D65CE-B70D-11D0-B188-00AA0038C969"],
    "IMLangStringBufA": ["D24ACD23-BA72-11D0-B188-00AA0038C969"],
    "IMLangStringBufW": ["D24ACD21-BA72-11D0-B188-00AA0038C969"],
    "IOpsProfileSimple": ["7DD1362C-28B6-11D2-BCA7-00C04FD929DB"],
    "IAppPublisher": ["07250A10-9CF9-11D1-9076-006008059382"],
    "IEnumPublishedApps": ["0B124F8C-91F0-11D1-B8B5-006008059382"],
    "IPublishedApp": ["1BC752E0-9046-11D1-B8B3-006008059382"],
    "IShellApp": ["A3E14960-935F-11D1-B8B8-006008059382"],
    "ILogonStatusHost": ["60664CAF-AF0D-1007-A300-5C7D25FF22A0"],
    "ILocalMachine": ["60664CAF-AF0D-1005-A300-5C7D25FF22A0"],
    "ILogonEnumUsers": ["60664CAF-AF0D-1004-A300-5C7D25FF22A0"],
    "ILogonUser": ["60664CAF-AF0D-1003-A300-5C7D25FF22A0"],
    "IShellImageDataAbort": ["53FB8E58-50C0-4003-B4AA-0C8DF28E7F3A"],
    "IShellImageData": ["BFDEEC12-8040-4403-A5EA-9E07DAFCF530"],
    "IShellImageDataFactory": ["9BE8ED5C-EDAB-4D75-90F3-BD5BDBB21C82"],
    "IAsyncOperation": ["3D8B0590-F691-11D2-8EA9-006097DF5BD4"],
    "IEnumACString": ["8E74C210-CF9D-4EAF-A403-7356428F0A5A"],
    "IAutoComplete2": ["EAC04BC0-3791-11D2-BB95-0060977B464C"],
    "IAutoComplete": ["00BB2762-6A77-11D0-A535-00C04FD7D062"],
    "IPassportClientServices": ["B30F7305-5967-45D1-B7BC-D6EB7163D770"],
    "INewWDEvents": ["0751C551-7568-41C9-8E5B-E22E38919236"],
    "IWebWizardHost": ["18BCC359-4990-4BFB-B951-3C83702BE5F9"],
    "IFileSearchBand": ["2D91EEA1-9932-11D2-BE86-00A0C9A83DA1"],
    "IShellDispatch4": ["EFD84B2D-4BCF-4298-BE25-EB542A59FBDA"],
    "IShellDispatch3": ["177160CA-BB5A-411C-841D-BD38FACDEAA0"],
    "IShellDispatch2": ["A4C6892C-3BA9-11D2-9DEA-00C04FB16162"],
    "IShellDispatch": ["D8F015C0-C278-11CE-A49E-444553540000"],
    "IShellFolderViewDual2": ["31C147B6-0ADE-4A3C-B514-DDF932EF6D17"],
    "IShellFolderViewDual": ["E7A1AF80-4D96-11CF-960C-0080C7F4EE85"],
    "IShellLinkDual2": ["317EE249-F12E-11D2-B1E4-00C04F8EEB3E"],
    "IShellLinkDual": ["88A05C00-F000-11CE-8350-444553540000"],
    "FolderItems3": ["EAA7C309-BBEC-49D5-821D-64D966CB667F"],
    "FolderItems2": ["C94F0AD0-F363-11D2-A327-00C04F8EEC7F"],
    "FolderItem2": ["EDC817AA-92B8-11D1-B075-00C04FC33AA5"],
    "Folder3": ["A7AE5F64-C4D7-4D7F-9307-4D24EE54B841"],
    "Folder2": ["F0D2D8EF-3890-11D2-BF8B-00C04FB93661"],
    "Folder": ["BBCBDE60-C3FF-11CE-8350-444553540000"],
    "FolderItemVerbs": ["1F8352C0-50B0-11CF-960C-0080C7F4EE85"],
    "FolderItemVerb": ["08EC3E00-50B0-11CF-960C-0080C7F4EE85"],
    "FolderItems": ["744129E0-CBE5-11CE-8350-444553540000"],
    "FolderItem": ["FAC32C80-CBE4-11CE-8350-444553540000"],
    "ISearchCommandExt": ["1D2EFD50-75CE-11D1-B75A-00A0C90564FE"],
    "DFConstraint": ["4A3DF050-23BD-11D2-939F-00A0C91EEDBA"],
    "IFolderViewOC": ["9BA05970-F6A8-11CF-A442-00A0C90A8F39"],
    "IShellMenu": ["EE1F7637-E138-11D1-8379-00C04FD918D0"],
    "IAttachmentExecute": ["73DB1241-1E85-4581-8E4F-A81E1D0F8C57"],
    "IShellMenuCallback": ["4CA300A1-9B8D-11D1-8B22-00C04FD918D0"],
    "INewWindowManager": ["D2BC4C84-3F72-4A52-A604-7BCBF3982CBB"],
    "IBrowserFrameOptions": ["10DF43C8-1DBE-11D3-8B34-006097DF5BD4"],
    "IDelegateFolder": ["ADD8BA80-002B-11D0-8F0F-00C04FD7D062"],
    "IContextMenuSite": ["0811AEBE-0B87-4C54-9E72-548CF649016B"],
    "IDefViewSafety": ["9A93B3FB-4E75-4C74-871A-2CDA667F39A5"],
    "IImageRecompress": ["505F1513-6B3E-4892-A272-59F8889A4D3E"],
    "IShellItem": ["43826D1E-E718-42EE-BC55-A1E261C37BFE"],
    "IMenuPopup": ["D1E7AFEB-6A2E-11D0-8C78-00C04FD918B4"],
    "IRegTreeItem": ["A9521922-0812-4D44-9EC3-7FD38C726F3D"],
    "INamespaceWalk": ["57CED8A7-3F4A-432C-9350-30F24483F74F"],
    "INamespaceWalkCB": ["D92995F8-CF5E-4A76-BF59-EAD39EA2B97E"],
    "IBandSite": ["4CF504B0-DE96-11D0-8B3F-00A0C911E8E5"],
    "IFolderBandPriv": ["47C01F95-E185-412C-B5C5-4F27DF965AEA"],
    "IMenuBand": ["568804CD-CBD7-11D0-9816-00C04FD91972"],
    "IDeskBar": ["EB0FE173-1A3A-11D0-89B3-00A0C90A90AC"],
    "IInsertItem": ["D2B57227-3D23-4B95-93C0-492BD454C356"],
    "IDVGetEnum": ["70F55181-5FEA-4900-B6B8-7343CB0A348C"],
    "ICDBurnExt": ["2271DCCA-74FC-4414-8FB7-C56B05ACE2D7"],
    "IPassportWizard": ["A09DB586-9180-41AC-9114-460A7F362B76"],
    "IModalWindow": ["B4DB1657-70D7-485E-8E3E-6FCB5A5C1802"],
    "IAutoCompleteDropDown": ["3CD141F4-3C6A-11D2-BCAA-00C04FD929DB"],
    "IFolderViewHost": ["1EA58F02-D55A-411D-B09E-9E65AC21605B"],
    "IPublishingWizard": ["AA9198BB-CCEC-472D-BEED-19A4F6733F7A"],
    "IWebWizardExtension": ["0E6B3F66-98D1-48C0-A222-FBDE74E2FBC5"],
    "IWizardExtension": ["C02EA696-86CC-491E-9B23-74394A0444A8"],
    "IWizardSite": ["88960F5B-422F-4E7B-8013-73415381C3C3"],
    "ICDBurn": ["3D73A659-E5D0-4D42-AFC0-5121BA425C8D"],
    "ITaskbarList2": ["602D4995-B13A-429B-A66E-1935E44F4317"],
    "ITaskbarList": ["56FDF342-FD6D-11D0-958A-006097C9A090"],
    "IDeskBand": ["EB0FE172-1A3A-11D0-89B3-00A0C90A90AC"],
    "IDockingWindow": ["012DD920-7B26-11D0-8CA9-00A0C92DBFE8"],
    "IUserEventTimer": ["0F504B94-6E42-42E6-99E0-E20FAFE52AB4"],
    "IUserEventTimerCallback": ["E9EAD8E6-2A25-410E-9B58-A9FBEF1DD1A2"],
    "IExtractImage2": ["953BB1EE-93B4-11D1-98A3-00C04FB687DA"],
    "IExtractImage": ["BB2E617C-0920-11D1-9A0B-00C04FC2D6C1"],
    "INetCrawler": ["49C929EE-A1B7-4C58-B539-E63BE392B6F3"],
    "IItemNameLimits": ["1DF0D7F1-B267-4D28-8B10-12E23202A5C4"],
    "IUserNotification": ["BA9711BA-5893-4787-A7E1-41277151550B"],
    "IQueryContinue": ["7307055C-B24A-486B-9F25-163E597A28A9"],
    "IRemoteComputer": ["000214FE-0000-0000-C000-000000000046"],
    "IShellPropSheetExt": ["000214E9-0000-0000-C000-000000000046"],
    "IShellExtInit": ["000214E8-0000-0000-C000-000000000046"],
    "IActionProgress": ["49FF1173-EADC-446D-9285-156453A6431C"],
    "IQueryCancelAutoPlay": ["DDEFE873-6997-4E68-BE26-39B633ADBE12"],
    "IHWEventHandler": ["C1FB73D0-EC3A-4BA2-B512-8CDB9187B6D1"],
    "IActionProgressDialog": ["49FF1172-EADC-446D-9285-156453A6431C"],
    "IShellLinkW": ["000214F9-0000-0000-C000-000000000046"],
    "IShellLinkA": ["000214EE-0000-0000-C000-000000000046"],
    "ICategorizer": ["A3B14589-9174-49A8-89A3-06A1AE2B9BA7"],
    "ICategoryProvider": ["9AF64809-5864-4C26-A720-C1F78C086EE3"],
    "IPropertyUI": ["757A7D9F-919A-4118-99D7-DBB208C8CC66"],
    "IProfferService": ["CB728B20-F786-11CE-92AD-00AA00A74CD0"],
    "IShellBrowser": ["000214E2-0000-0000-C000-000000000046"],
    "IFolderFilter": ["9CC22886-DC8E-11D2-B1D0-00C04F8EEB3E"],
    "IFolderFilterSite": ["C0A651F5-B48B-11D2-B5ED-006097C686F6"],
    "IFolderView": ["CDE725B0-CCC9-4519-917E-325D72FAB4CE"],
    "IShellView2": ["88E39E80-3578-11CF-AE69-08002B2E1262"],
    "IShellView": ["000214E3-0000-0000-C000-000000000046"],
    "IShellFolder2": ["93F2F68C-1D1B-11D3-A30E-00C04F79ABD1", "000214E7-0000-0000-C000-000000000046"],
    "IEnumExtraSearch": ["0E700BE1-9DB6-11D1-A1CE-00C04FD75D13"],
    "IShellFolder": ["000214E6-0000-0000-C000-000000000046"],
    "IEnumIDList": ["000214F2-0000-0000-C000-000000000046"],
    "IPersistIDList": ["1079ACFC-29BD-11D3-8E0D-00C04F6837D5"],
    "IPersistFolder2": ["1AC3D9F0-175C-11D1-95BE-00609797EA4F"],
    "IPersistFolder": ["000214EA-0000-0000-C000-000000000046"],
    "ITravelLogClient2": ["0AD364CE-ADCB-11D3-8269-00805FC732C0"],
    "ITravelLogClient": ["3050F67A-98B5-11CF-BB82-00AA00BDCE0B"],
    "ITravelLogEx": ["3050F679-98B5-11CF-BB82-00AA00BDCE0B"],
    "ITravelLog": ["66A9CB08-4802-11D2-A561-00A0C92DBFE8"],
    "ITravelEntry": ["F46EDB3B-BC2F-11D0-9412-00AA00A3EBD3"],
    "ITravelLogStg": ["7EBFDD80-AD18-11D3-A4C5-00C04F72D6B8"],
    "IEnumTravelLogEntry": ["7EBFDD85-AD18-11D3-A4C5-00C04F72D6B8"],
    "ITravelLogEntry": ["7EBFDD87-AD18-11D3-A4C5-00C04F72D6B8"],
    "IVirusScanEngine": ["083DB180-B4A8-11CF-AAFA-00AA00B6015C"],
    "IRegisterVirusScanEngine": ["0825E060-B961-11CF-AAFA-00AA00B6015C"],
    "IVirusScanner": ["4589BEE0-B4B1-11CF-AAFA-00AA00B6015C"],
    "IDsQueryColumnHandler": ["C072999E-FA49-11D1-A0AF-00C04FA31A86"],
    "IQueryHandler": ["A60CC73F-E0FC-11D0-9750-00A0C906AF45"],
    "IQueryFrame": ["7E8C7C20-7C9D-11D0-913F-00AA00C16E65"],
    "ICommonQuery": ["AB50DEC0-6F1D-11D0-A1C4-00AA00C16E65"],
    "IPersistQuery": ["1A3114B8-A62E-11D0-A6C5-00A0C906AF45"],
    "IQueryForm": ["8CFCEE30-39BD-11D0-B8D1-00A024AB2DBB"],
    "IDsBrowseDomainTree": ["7CABCF1E-78F5-11D2-960C-00C04FA31A86"],
    "IPrintDialogServices": ["509AAEDA-5639-11D1-B6A1-0000F8757BF9"],
    "IPrintDialogCallback": ["5852A2C3-6530-11D1-B6A3-0000F8757BF9"],
    "IBanneredBar": ["596A9A94-013E-11D1-8D34-00A0C90F2719"],
    "CDefView": ["4434FF80-EF4C-11CE-AE65-08002B2E1262"],
    "IDocViewSite": ["87D605E0-C511-11CF-89A9-00A0C9054129"],
    "IFileSystemBindData": ["01E18D10-4D8B-11D2-855D-006008059367"],
    "IDragSourceHelper": ["DE5BF786-477A-11D2-839D-00C04FD918D0"],
    "IDropTargetHelper": ["4657278B-411B-11D2-839A-00C04FD918D0"],
    "IMountedVolume": ["12518492-00B2-11D2-9FA5-9E3420524153"],
    "INamedPropertyBag": ["FB700430-952C-11D1-946F-000000000000"],
    "IColumnProvider": ["E8025004-1C42-11D2-BE2C-00A0C9A83DA1", "24F14F00-7B1C-11D1-838F-0000F80461CF"],
    "IQueryAssociations": ["C46CA590-3C3F-11D2-BEE6-0000F805CA57"],
    "IShellDetails3": ["D2A105C0-87D5-11D1-8391-0000F80461CF"],
    "ISynchronizedCallBack": ["74C26041-70D1-11D1-B75A-00A0C90564FE"],
    "IADesktopP2": ["B22754E2-4574-11D1-9888-006097DEACF9"],
    "IActiveDesktopP": ["52502EE0-EC80-11D0-89AB-00C04FC2972D"],
    "IActiveDesktop": ["F490EB00-1240-11D1-9888-006097DEACF9"],
    "IProgressDialog": ["EBBC7C04-315E-11D2-B62F-006097DF5BD4"],
    "ICurrentWorkingDirectory": ["91956D21-9276-11D1-921A-006097DF5BD4"],
    "IACList2": ["470141A0-5186-11D2-BBB6-0060977B464C"],
    "IACList": ["77A130B0-94FD-11D0-A544-00C04FD7D062"],
    "IObjMgr": ["00BB2761-6A77-11D0-A535-00C04FD7D062"],
    "IAutoCompList": ["00BB2760-6A77-11D0-A535-00C04FD7D062"],
    "IUniformResourceLocatorW": ["CABB0DA0-DA57-11CF-9974-0020AFD79762"],
    "IUniformResourceLocatorA": ["FBF23B80-E3F0-101B-8488-00AA003E56F8"],
    "IShellChangeNotify": ["D82BE2B1-5764-11D0-A96E-00C04FD705A2"],
    "IDiscardableBrowserProperty": ["49C3DE7C-D329-11D0-AB73-00C04FC33E80"],
    "IDefViewFrame": ["710EB7A0-45ED-11D0-924A-0020AFC7AC4D"],
    "IShellFolderBand": ["7FE80CC8-C247-11D0-B93A-00A0C90312E1"],
    "IContextMenu3": ["BCFCE0A0-EC17-11D0-8D10-00A0C90F2719"],
    "IEnumShellImageStore": ["6DFD582B-92E3-11D1-98A3-00C04FB687DA"],
    "IShellImageStore": ["48C8118C-B924-11D1-98D5-00C04FB687DA"],
    "IThumbnailCapture": ["4EA39266-7211-409F-B622-F63DBD16C533"],
    "IRunnableTask": ["85788D00-6807-11D0-B810-00C04FD706EC"],
    "IShellIconOverlayManager": ["F10B5E34-DD3B-42A7-AA7D-2F4EC54BB09B", "63B51F80-C868-11D0-999C-00C04FD655E1"],
    "IPersistFolder3": ["CEF04FDF-FE72-11D2-87A5-00C04F6837CF"],
    "IShellFolderViewCB": ["2047E320-F2A9-11CE-AE65-08002B2E1262"],
    "ICommDlgBrowser2": ["10339516-2894-11D2-9039-00C04F8EEB3E", "6D71532E-889E-11D1-997F-080036AF3F03"],
    "IShellIconOverlayIdentifier": ["0C6C4200-C589-11D0-999A-00C04FD655E1"],
    "IShellIconOverlay": ["7D688A70-C613-11D0-999B-00C04FD655E1"],
    "IDockingWindowFrame": ["47D2657A-7B27-11D0-8CA9-00A0C92DBFE8"],
    "IDockingWindowSite": ["2A342FC2-7B26-11D0-8CA9-00A0C92DBFE8"],
    "IInputObjectSite": ["F1DB8392-7331-11D0-8C99-00A0C92DBFE8"],
    "IInputObject": ["68284FAA-6A48-11D0-8C78-00C04FD918B4"],
    "IShellTaskScheduler": ["6CCB7BE0-6807-11D0-B810-00C04FD706EC"],
    "IDefViewID": ["985F64F0-D410-4E02-BE22-DA07F2B5C5E1"],
    "IURLSearchHook2": ["5EE44DA4-6D32-46E3-86BC-07540DEDD0E0"],
    "ISearchContext": ["09F656A2-41AF-480C-88F7-16CC0D164615"],
    "IURLSearchHook": ["AC60F6A0-0FD9-11D0-99CB-00C04FD64497"],
    "IResolveShellLink": ["5CD52983-9449-11D2-963A-00C04F79ADF0"],
    "IShellLinkDataList": ["45E2B4AE-B1C3-11D0-B92F-00A0C90312E1"],
    "IBriefcaseStg": ["8BCE1FA1-0921-101B-B1FF-00DD010CCC48"],
    "IQueryInfo": ["00021500-0000-0000-C000-000000000046"],
    "IShellCopyHookW": ["000214FC-0000-0000-C000-000000000046"],
    "IShellExecuteHookW": ["000214FB-0000-0000-C000-000000000046"],
    "IExtractIconW": ["000214FA-0000-0000-C000-000000000046"],
    "IFileViewerW": ["000214F8-0000-0000-C000-000000000046"],
    "INewShortcutHookW": ["000214F7-0000-0000-C000-000000000046"],
    "IPropSheetPage": ["000214F6-0000-0000-C000-000000000046"],
    "IShellExecuteHookA": ["000214F5-0000-0000-C000-000000000046"],
    "IContextMenu2": ["000214F4-0000-0000-C000-000000000046"],
    "IFileViewerSite": ["000214F3-0000-0000-C000-000000000046"],
    "ICommDlgBrowser": ["000214F1-0000-0000-C000-000000000046"],
    "IFileViewerA": ["000214F0-0000-0000-C000-000000000046"],
    "IShellCopyHookA": ["000214EF-0000-0000-C000-000000000046"],
    "IDelayedRelease": ["000214ED-0000-0000-C000-000000000046"],
    "IShellDetails": ["000214EC-0000-0000-C000-000000000046"],
    "IExtractIconA": ["000214EB-0000-0000-C000-000000000046"],
    "IShellIcon": ["000214E5-0000-0000-C000-000000000046"],
    "IContextMenu": ["000214E4-0000-0000-C000-000000000046"],
    "INewShortcutHookA": ["000214E1-0000-0000-C000-000000000046"],
    "IAccPropServices": ["6E26E776-04F0-495D-80E4-3330352E3169"],
    "IAccPropServer": ["76C0DBBB-15E0-4E7B-B61B-20EEEA2001E0"],
    "IAccIdentity": ["7852B78D-1CFD-41C1-A615-9C0C85960B5F"],
    "IAccessibleHandler": ["03022430-ABC4-11D0-BDE2-00AA001A1953"],
    "IBidiRequestSpl": ["9C007000-FFA8-44FF-B2B3-AE9102C74D4C"],
    "ITfSpeechUIServer": ["90E9A944-9244-489F-A78F-DE67AFC013A7"],
    "ITfLangBarAddIn": ["C9ADDAC3-15CB-4957-B93C-DB0873FF98BB"],
    "ITfInputScope": ["FDE1EAEE-6924-4CDF-91E7-DA38CFF5559D"],
    "ID3DXAnimationController": ["AC8948EC-F86D-43E2-96DE-31FC35F96D9E"],
    "ID3DXCompressedAnimationSet": ["6CC2480D-3808-4739-9F88-DE49FACD8D4C"],
    "ID3DXKeyframedAnimationSet": ["FA4E8E3A-9786-407D-8B4C-5995893764AF"],
    "ID3DXAnimationSet": ["698CFB3F-9289-4D95-9A57-33A94B5A65F9"],
    "ID3DXEffectCompiler": ["51B8A949-1A31-47E6-BEA0-4B30DB53F1E0"],
    "ID3DXEffect": ["F6CEB4B3-4E4C-40DD-B883-8D8DE5EA0CD5"],
    "ID3DXEffectStateManager": ["79AAB587-6DBC-4FA7-82DE-37FA1781C5CE"],
    "ID3DXBaseEffect": ["017C18AC-103F-4417-8C51-6BF6EF1E56BE"],
    "ID3DXEffectPool": ["9537AB04-3250-412E-8213-FCD2F8677933"],
    "ID3DXFragmentLinker": ["1A2C0CC2-E5B6-4EBC-9E8D-390E057811B6"],
    "ID3DXTextureShader": ["3E3D67F8-AA7A-405D-A857-BA01D4758426"],
    "ID3DXConstantTable": ["AB3C758F-093E-4356-B762-4DB18F1B3A01"],
    "ID3DXPRTEngine": ["683A4278-CD5F-4D24-90AD-C4E1B6855D53"],
    "ID3DXTextureGutterHelper": ["838F01EC-9729-4527-AADB-DF70ADE7FEA9"],
    "ID3DXPRTCompBuffer": ["A758D465-FE8D-45AD-9CF0-D01E56266A07"],
    "ID3DXPRTBuffer": ["F1827E47-00A8-49CD-908C-9D11955F8728"],
    "ID3DXPatchMesh": ["3CE6CC22-DBF2-44F4-894D-F9C34A337139"],
    "ID3DXSkinInfo": ["11EAA540-F9A6-4D49-AE6A-E19221F70CC4"],
    "ID3DXSPMesh": ["667EA4C7-F1CD-4386-B523-7C0290B83CC5"],
    "ID3DXPMesh": ["8875769A-D579-4088-AAEB-534D1AD84E96"],
    "ID3DXMesh": ["4020E5C2-1403-4929-883F-E2E849FAC195"],
    "ID3DXBaseMesh": ["7ED943DD-52E8-40B5-A8D8-76685C406330"],
    "ID3DXFileData": ["CEF08CFD-7B4F-4429-9624-2A690A933201"],
    "ID3DXFileEnumObject": ["CEF08CFC-7B4F-4429-9624-2A690A933201"],
    "ID3DXFileSaveData": ["CEF08CFB-7B4F-4429-9624-2A690A933201"],
    "ID3DXFileSaveObject": ["CEF08CFA-7B4F-4429-9624-2A690A933201"],
    "ID3DXFile": ["CEF08CF9-7B4F-4429-9624-2A690A933201"],
    "ID3DXLine": ["D379BA7F-9042-4AC4-9F5E-58192A4C6BD8"],
    "ID3DXRenderToEnvMap": ["313F1B4B-C7B0-4FA2-9D9D-8D380B64385E"],
    "ID3DXRenderToSurface": ["6985F346-2C3D-43B3-BE8B-DAAE8A03D894"],
    "ID3DXFont": ["D79DBB70-5F21-4D36-BBC2-FF525C213CDC"],
    "ID3DXSprite": ["BA0B762D-7D28-43EC-B9DC-2F84443B0614"],
    "ID3DXBuffer": ["8BA5FB08-5195-40E2-AC58-0D989C3A0102"],
    "ID3DXMatrixStack": ["C7885BA7-F990-4FE7-922D-8515E477DD85"],
    "IDirect3DSwapChain9Ex": ["91886CAF-1C3D-4D2E-A0AB-3E4C7D8D3303"],
    "IDirect3DDevice9Ex": ["B18B10CE-2649-405A-870F-95F777D4313A"],
    "IDirect3D9Ex": ["02177241-69FC-400C-8FF1-93A44DF6861D"],
    "HelperName": ["E4A36723-FDFE-4B22-B146-3C04C07F4CC8"],
    "IDirect3DQuery9": ["D9771460-A695-4F26-BBD3-27B840B541CC"],
    "IDirect3DStateBlock9": ["B07C4FE5-310D-4BA8-A23C-4F0F206F218B"],
    "IDirect3DPixelShader9": ["6D3BDBDC-5B02-4415-B852-CE5E8BCCB289"],
    "IDirect3DVertexShader9": ["EFC5557E-6265-4613-8A94-43857889EB36"],
    "IDirect3DVertexDeclaration9": ["DD13C59C-36FA-4098-A8FB-C7ED39DC8546"],
    "IDirect3DSwapChain9": ["794950F2-ADFC-458A-905E-10A10B0B503B"],
    "IDirect3DVolume9": ["24F416E6-1F67-4AA7-B88E-D33F6F3128A1"],
    "IDirect3DSurface9": ["0CFBAF3A-9FF6-429A-99B3-A2796AF8B89B"],
    "IDirect3DIndexBuffer9": ["7C9DD65E-D3F7-4529-ACEE-785830ACDE35"],
    "IDirect3DVertexBuffer9": ["B64BB1B5-FD70-4DF6-BF91-19D0A12455E3"],
    "IDirect3DVolumeTexture9": ["2518526C-E789-4111-A7B9-47EF328D13E6"],
    "IDirect3DCubeTexture9": ["FFF32F81-D953-473A-9223-93D652ABA93F"],
    "IDirect3DTexture9": ["85C31227-3DE5-4F00-9B3A-F11AC38C18B5"],
    "IDirect3DBaseTexture9": ["580CA87E-1D3C-4D54-991D-B7D3E3C298CE"],
    "IDirect3DResource9": ["05EEC05D-8F7D-4362-B999-D1BAF357C704"],
    "IDirect3DDevice9": ["D0223B96-BF7A-43FD-92BD-A43B0D82B9EB"],
    "IDirect3D9": ["81BDCBCA-64D4-426D-AE8D-AD0147F4275C"],
    "ID3DX10SkinInfo": ["420BD604-1C76-4A34-A466-E45D0658A32C"],
    "ID3DX10MeshBuffer": ["04B0D117-1041-46B1-AA8A-3952848BA22E"],
    "ID3DX10ThreadPump": ["C93FECFA-6967-478A-ABBC-402D90621FCB"],
    "ID3DX10Sprite": ["BA0B762D-8D28-43EC-B9DC-2F84443B0614"],
    "ID3D10Multithread": ["9B7E4E00-342C-4106-A19F-4F2704F689F0"],
    "ID3D10Device": ["9B7E4C0F-342C-4106-A19F-4F2704F689F0"],
    "ID3D10Counter": ["9B7E4C11-342C-4106-A19F-4F2704F689F0"],
    "ID3D10Predicate": ["9B7E4C10-342C-4106-A19F-4F2704F689F0"],
    "ID3D10Query": ["9B7E4C0E-342C-4106-A19F-4F2704F689F0"],
    "ID3D10Asynchronous": ["9B7E4C0D-342C-4106-A19F-4F2704F689F0"],
    "ID3D10SamplerState": ["9B7E4C0C-342C-4106-A19F-4F2704F689F0"],
    "ID3D10InputLayout": ["9B7E4C0B-342C-4106-A19F-4F2704F689F0"],
    "ID3D10PixelShader": ["4968B601-9D00-4CDE-8346-8E7F675819B6"],
    "ID3D10GeometryShader": ["6316BE88-54CD-4040-AB44-20461BC81F68"],
    "ID3D10VertexShader": ["9B7E4C0A-342C-4106-A19F-4F2704F689F0"],
    "ID3D10DepthStencilView": ["9B7E4C09-342C-4106-A19F-4F2704F689F0"],
    "ID3D10RenderTargetView": ["9B7E4C08-342C-4106-A19F-4F2704F689F0"],
    "ID3D10ShaderResourceView": ["9B7E4C07-342C-4106-A19F-4F2704F689F0"],
    "ID3D10View": ["C902B03F-60A7-49BA-9936-2A3AB37A7E33"],
    "ID3D10Texture3D": ["9B7E4C05-342C-4106-A19F-4F2704F689F0"],
    "ID3D10Texture2D": ["9B7E4C04-342C-4106-A19F-4F2704F689F0"],
    "ID3D10Texture1D": ["9B7E4C03-342C-4106-A19F-4F2704F689F0"],
    "ID3D10Buffer": ["9B7E4C02-342C-4106-A19F-4F2704F689F0"],
    "ID3D10Resource": ["9B7E4C01-342C-4106-A19F-4F2704F689F0"],
    "ID3D10RasterizerState": ["A2A07292-89AF-4345-BE2E-C53D9FBB6E9F"],
    "ID3D10BlendState": ["EDAD8D19-8A35-4D6D-8566-2EA276CDE161"],
    "ID3D10DepthStencilState": ["2B4B1CC8-A4AD-41F8-8322-CA86FC3EC675"],
    "ID3D10DeviceChild": ["9B7E4C00-342C-4106-A19F-4F2704F689F0"],
    "ID3D10Effect": ["51B0CA8B-EC0B-4519-870D-8EE1CB5017C7"],
    "ID3D10EffectTechnique": ["DB122CE8-D1C9-4292-B237-24ED3DE8B175"],
    "ID3D10EffectPass": ["5CFBEB89-1A06-46E0-B282-E3F9BFA36A54"],
    "ID3D10EffectSamplerVariable": ["6530D5C7-07E9-4271-A418-E7CE4BD1E480"],
    "ID3D10EffectRasterizerVariable": ["21AF9F0E-4D94-4EA9-9785-2CB76B8C0B34"],
    "ID3D10EffectDepthStencilVariable": ["AF482368-330A-46A5-9A5C-01C71AF24C8D"],
    "ID3D10EffectBlendVariable": ["1FCD2294-DF6D-4EAE-86B3-0E9160CFB07B"],
    "ID3D10EffectShaderVariable": ["80849279-C799-4797-8C33-0407A07D9E06"],
    "ID3D10EffectConstantBuffer": ["56648F4D-CC8B-4444-A5AD-B5A3D76E91B3"],
    "ID3D10EffectDepthStencilViewVariable": ["3E02C918-CC79-4985-B622-2D92AD701623"],
    "ID3D10EffectRenderTargetViewVariable": ["28CA0CC3-C2C9-40BB-B57F-67B737122B17"],
    "ID3D10EffectShaderResourceVariable": ["C0A7157B-D872-4B1D-8073-EFC2ACD4B1FC"],
    "ID3D10EffectStringVariable": ["71417501-8DF9-4E0A-A78A-255F9756BAFF"],
    "ID3D10EffectMatrixVariable": ["50666C24-B82F-4EED-A172-5B6E7E8522E0"],
    "ID3D10EffectVectorVariable": ["62B98C44-1F82-4C67-BCD0-72CF8F217E81"],
    "ID3D10EffectScalarVariable": ["00E48F7B-D2C8-49E8-A86C-022DEE53431F"],
    "ID3D10EffectVariable": ["AE897105-00E6-45BF-BB8E-281DD6DB8E1B"],
    "ID3D10EffectType": ["4E9E1DDC-CD9D-4772-A837-00180B9B88FD"],
    "ID3D10StateBlock": ["0803425A-57F5-4DD6-9465-A87570834A08"],
    "ID3D10ShaderReflection": ["D40E20B6-F8F7-42AD-AB20-4BAF8F15DFAA"],
    "ID3D10ShaderReflectionConstantBuffer": ["66C66A94-DDDD-4B62-A66A-F0DA33C2B4D0"],
    "ID3D10ShaderReflectionVariable": ["1BF63C95-2650-405D-99C1-3636BD1DA0A1"],
    "ID3D10ShaderReflectionType": ["C530AD7D-9B16-4395-A979-BA2ECFF83ADD"],
    "ID3D10InfoQueue": ["1B940B17-2642-4D1F-AB1F-B99BAD0C395F"],
    "ID3D10SwitchToRef": ["9B7E4E02-342C-4106-A19F-4F2704F689F0"],
    "ID3D10Debug": ["9B7E4E01-342C-4106-A19F-4F2704F689F0"],
    "IDXGIDevice": ["54EC77FA-1377-44E6-8C32-88FD5F44C84C"],
    "IDXGIFactory": ["7B7166EC-21C7-44AE-B21A-C9AE321AE369"],
    "IDXGISwapChain": ["310D36A0-D2E7-4C0A-AA04-6A9D23B8886A"],
    "IDXGIOutput": ["AE02EEDB-C735-4690-8D52-5A8DC20213AA"],
    "IDXGIAdapter": ["2411E7E1-12AC-4CCF-BD14-9798E8534DC0"],
    "IDXGISurface": ["CAFCB56C-6AC3-4889-BF47-9E23BBD260EC"],
    "IDXGIResource": ["035F3AB4-482E-4E50-B41F-8A7F8BD8960B"],
    "IDXGIDeviceSubObject": ["3D3E0379-F9DE-4D58-BB6C-18D62992F1A6"],
    "IDXGIObject": ["AEC22FB8-76F3-4639-9BE0-28EB43A67A2E"],
    "IDxDiagContainer": ["7D0F462F-4064-4862-BC7F-933E5058C10F"],
    "IDxDiagProvider": ["9C6B4CB0-23F8-49CC-A3ED-45A55000A6D2"],
    "IKsControl": ["28F54685-06FD-11D2-B27A-00A0C9223196"],
    "IDirectMusicAudioPath": ["C87631F5-23BE-4986-8836-05832FCC48F9"],
    "IDirectMusicContainer": ["9301E386-1F22-11D3-8226-D2FA76255D47"],
    "IDirectMusicScript": ["2252373A-5814-489B-8209-31FEDEBAF137"],
    "IDirectMusicPatternTrack": ["51C22E10-B49F-46FC-BEC2-E6288FB9EDE6"],
    "IDirectMusicStyle8": ["FD24AD8A-A260-453D-BF50-6F9384F70985"],
    "IDirectMusicSegmentState8": ["A50E4730-0AE4-48A7-9839-BC04BFE07772"],
    "IDirectMusicSegment8": ["C6784488-41A3-418F-AA15-B35093BA42D4"],
    "IDirectMusicPerformance8": ["679C4137-C62E-4147-B2B4-9D569ACB254C"],
    "IDirectMusicLoader8": ["19E7C08C-0A44-4E6A-A116-595A7CD5DE8C"],
    "IDirectMusicSegment2": ["D38894D1-C052-11D2-872F-00600893B1BD"],
    "IDirectMusicPerformance2": ["6FC2CAE0-BC78-11D2-AFA6-00AA0024D8B6"],
    "IDirectMusicBand": ["D2AC28C0-B39B-11D1-8704-00600893B1BD"],
    "IDirectMusicComposer": ["D2AC28BF-B39B-11D1-8704-00600893B1BD"],
    "IDirectMusicChordMap": ["D2AC28BE-B39B-11D1-8704-00600893B1BD"],
    "IDirectMusicStyle": ["D2AC28BD-B39B-11D1-8704-00600893B1BD"],
    "IDirectMusicGraph": ["2BEFC277-5497-11D2-BCCB-00A0C922E6EB"],
    "IDirectMusicPerformance": ["07D43D03-6523-11D2-871D-00600893B1BD"],
    "IDirectMusicSegmentState": ["A3AFDCC7-D3EE-11D1-BC8D-00A0C922E6EB"],
    "IDirectMusicSegment": ["F96029A2-4282-11D2-8717-00600893B1BD"],
    "IDirectMusicObject": ["D2AC28B5-B39B-11D1-8704-00600893B1BD"],
    "IDirectMusicGetLoader": ["68A04844-D13D-11D1-AFA6-00AA0024D8B6"],
    "IDirectMusicLoader": ["2FFAACA2-5DCA-11D2-AFA6-00AA0024D8B6"],
    "IDirectMusicTrack8": ["0E674304-3B05-11D3-9BD1-F9E7F0A01536"],
    "IDirectMusicTool8": ["0E674303-3B05-11D3-9BD1-F9E7F0A01536"],
    "IDirectMusicTool": ["D2AC28BA-B39B-11D1-8704-00600893B1BD"],
    "IDirectMusicTrack": ["F96029A1-4282-11D2-8717-00600893B1BD"],
    "IDirectMusic8": ["2D3629F7-813D-4939-8508-F05C6B75FD97"],
    "IDirectMusic2": ["6FC2CAE1-BC78-11D2-AFA6-00AA0024D8B6"],
    "IDirectMusicDownloadedInstrument": ["D2AC287E-B39B-11D1-8704-00600893B1BD"],
    "IDirectMusicInstrument": ["D2AC287D-B39B-11D1-8704-00600893B1BD"],
    "IDirectMusicCollection": ["D2AC287C-B39B-11D1-8704-00600893B1BD"],
    "IDirectMusicDownload": ["D2AC287B-B39B-11D1-8704-00600893B1BD"],
    "IDirectMusicPortDownload": ["D2AC287A-B39B-11D1-8704-00600893B1BD"],
    "IDirectMusicThru": ["CED153E7-3606-11D2-B9F9-0000F875AC12"],
    "IDirectMusicPort": ["08F2D8C9-37C2-11D2-B9F9-0000F875AC12"],
    "IDirectMusicBuffer": ["D2AC2878-B39B-11D1-8704-00600893B1BD"],
    "IDirectMusic": ["6536115A-7B2D-11D2-BA18-0000F875AC12"],
    "IDirectPlay8LobbyClient": ["819074A2-016C-11D3-AE14-006097B01411"],
    "IDirectPlay8LobbiedApplication": ["819074A3-016C-11D3-AE14-006097B01411"],
    "IDirectPlay8NATResolver": ["A9E213F2-9A60-486F-BF3B-53408B6D1CBB"],
    "IDirectPlay8ThreadPool": ["0D22EE73-4A46-4A0D-89B2-045B4D666425"],
    "IDirectPlay8Peer": ["5102DACF-241B-11D3-AEA7-006097B01411"],
    "IDirectPlay8Server": ["5102DACE-241B-11D3-AEA7-006097B01411"],
    "IDirectPlay8Client": ["5102DACD-241B-11D3-AEA7-006097B01411"],
    "IDirectPlay8AddressIP": ["E5A0E990-2BAD-430B-87DA-A142CF75DE58"],
    "IDirectPlay8Address": ["83783300-4063-4C8A-9DB3-82830A7FEB31"],
    "IDirectPlayVoiceTest": ["D26AF734-208B-41DA-8224-E0CE79810BE1"],
    "IDirectPlayVoiceServer": ["FAA1C173-0468-43B6-8A2A-EA8A4F2076C9"],
    "IDirectPlayVoiceClient": ["1DFDC8EA-BCF7-41D6-B295-AB64B3B23306"],
    "IDirectSoundFullDuplex": ["EDCB4C7A-DAAB-4216-A42E-6C50596DDC1D"],
    "IDirectSoundCaptureFXNoiseSuppress": ["ED311E41-FBAE-4175-9625-CD0854F693CA"],
    "IDirectSoundCaptureFXAec": ["AD74143D-903D-4AB7-8066-28D363036D65"],
    "IDirectSoundFXWavesReverb": ["46858C3A-0DC6-45E3-B760-D4EEF16CB325"],
    "IDirectSoundFXI3DL2Reverb": ["4B166A6A-0D66-43F3-80E3-EE6280DEE1A4"],
    "IDirectSoundFXParamEq": ["C03CA9FE-FE90-4204-8078-82334CD177DA"],
    "IDirectSoundFXCompressor": ["4BBD1154-62F6-4E2C-A15C-D3B6C417F7A0"],
    "IDirectSoundFXDistortion": ["8ECF4326-455F-4D8B-BDA9-8D5D3E9E3E0B"],
    "IDirectSoundFXEcho": ["8BD28EDF-50DB-4E92-A2BD-445488D1ED42"],
    "IDirectSoundFXFlanger": ["903E9878-2C92-4072-9B2C-EA68F5396783"],
    "IDirectSoundFXChorus": ["880842E3-145F-43E6-A934-A71806E50547"],
    "IDirectSoundFXGargle": ["D616F352-D622-11CE-AAC5-0020AF0B99A3"],
    "IKsPropertySet": ["31EFAC30-515C-11D0-A9AA-00AA0061BE93"],
    "IDirectSoundNotify": ["B0210783-89CD-11D0-AF08-00A0C925CD16"],
    "IDirectSoundCaptureBuffer8": ["00990DF4-0DBB-4872-833E-6D303E80AEB6"],
    "IDirectSoundCaptureBuffer": ["B0210782-89CD-11D0-AF08-00A0C925CD16"],
    "IDirectSoundCapture": ["B0210781-89CD-11D0-AF08-00A0C925CD16"],
    "IDirectSound3DBuffer": ["279AFA86-4981-11CE-A521-0020AF0BE560"],
    "IDirectSound3DListener": ["279AFA84-4981-11CE-A521-0020AF0BE560"],
    "IDirectSoundBuffer8": ["6825A449-7524-4D82-920F-50E36AB3AB1E"],
    "IDirectSoundBuffer": ["279AFA85-4981-11CE-A521-0020AF0BE560"],
    "IDirectSound8": ["C50A7E93-F395-4834-9EF6-7FA99DE50966"],
    "IDirectSound": ["279AFA83-4981-11CE-A521-0020AF0BE560"],
    "IReferenceClock": ["56A86897-0AD4-11CE-B03A-0020AF0BA770"],
    "IDirectPlayLobby3A": ["2DB72491-652C-11D1-A7A8-0000F803ABFC"],
    "IDirectPlayLobby3": ["2DB72490-652C-11D1-A7A8-0000F803ABFC"],
    "IDirectPlayLobby2A": ["1BB4AF80-A303-11D0-9C4F-00A0C905425E"],
    "IDirectPlayLobby2": ["0194C220-A303-11D0-9C4F-00A0C905425E"],
    "IDirectPlayLobbyA": ["26C66A70-B367-11CF-A024-00AA006157AC"],
    "IDirectPlayLobby": ["AF465C71-9588-11CF-A020-00AA006157AC"],
    "IDirectPlay": ["5454E9A0-DB65-11CE-921C-00AA006C4972"],
    "IDirectPlay4A": ["0AB1C531-4745-11D1-A7A1-0000F803ABFC"],
    "IDirectPlay4": ["0AB1C530-4745-11D1-A7A1-0000F803ABFC"],
    "IDirectPlay3A": ["133EFE41-32DC-11D0-9CFB-00A0C90A43CB"],
    "IDirectPlay3": ["133EFE40-32DC-11D0-9CFB-00A0C90A43CB"],
    "IDirectPlay2A": ["9D460580-A822-11CF-960C-0080C7534E82"],
    "IDirectPlay2": ["2B74F7C0-9154-11CF-A9CD-00AA006886E3"],
    "IDirectInputJoyConfig8": ["EB0D7DFA-1990-4F27-B4D6-EDF2EEC4A44C"],
    "IDirectInputPIDDriver": ["EEC6993A-B3FD-11D2-A916-00C04FB98638"],
    "IDirectInputJoyConfig": ["1DE12AB1-C9F5-11CF-BFC7-444553540000"],
    "IDirectInputEffectDriver": ["02538130-898F-11D0-9AD0-00A0C9A06E35"],
    "IDirectInputEffect": ["E7E1F7C0-88D2-11D0-9AD0-00A0C9A06E35"],
    "IDirectInputDevice8W": ["54D41081-DC15-4833-A41B-748F73A38179"],
    "IDirectInputDevice8A": ["54D41080-DC15-4833-A41B-748F73A38179"],
    "IDirectInputDevice7W": ["57D7C6BD-2356-11D3-8E9D-00C04F6844AE"],
    "IDirectInputDevice7A": ["57D7C6BC-2356-11D3-8E9D-00C04F6844AE"],
    "IDirectInputDevice2W": ["5944E683-C92E-11CF-BFC7-444553540000"],
    "IDirectInputDevice2A": ["5944E682-C92E-11CF-BFC7-444553540000"],
    "IDirectInputDeviceW": ["5944E681-C92E-11CF-BFC7-444553540000"],
    "IDirectInputDeviceA": ["5944E680-C92E-11CF-BFC7-444553540000"],
    "IDirectInput8W": ["BF798031-483A-4DA2-AA99-5D64ED369700"],
    "IDirectInput8A": ["BF798030-483A-4DA2-AA99-5D64ED369700"],
    "IDirectInput7W": ["9A4CB685-236D-11D3-8E9D-00C04F6844AE"],
    "IDirectInput7A": ["9A4CB684-236D-11D3-8E9D-00C04F6844AE"],
    "IDirectInput2W": ["5944E663-AA8A-11CF-BFC7-444553540000"],
    "IDirectInput2A": ["5944E662-AA8A-11CF-BFC7-444553540000"],
    "IDirectInputW": ["89521361-AA8A-11CF-BFC7-444553540000"],
    "IDirectInputA": ["89521360-AA8A-11CF-BFC7-444553540000"],
    "IDirectXFileBinary": ["3D82AB46-62DA-11CF-AB39-0020AF71E433"],
    "IDirectXFileDataReference": ["3D82AB45-62DA-11CF-AB39-0020AF71E433"],
    "IDirectXFileData": ["3D82AB44-62DA-11CF-AB39-0020AF71E433"],
    "IDirectXFileObject": ["3D82AB43-62DA-11CF-AB39-0020AF71E433"],
    "IDirectXFileSaveObject": ["3D82AB42-62DA-11CF-AB39-0020AF71E433"],
    "IDirectXFileEnumObject": ["3D82AB41-62DA-11CF-AB39-0020AF71E433"],
    "IDirectXFile": ["3D82AB40-62DA-11CF-AB39-0020AF71E433"],
    "IDirect3DRMWinDevice": ["C5016CC0-D273-11CE-AC48-0000C03825A1"],
    "IDirect3DRM3": ["4516EC83-8F20-11D0-9B6D-0000C0781BC3"],
    "IDirect3DRM2": ["4516ECC8-8F20-11D0-9B6D-0000C0781BC3"],
    "IDirect3DRM": ["2BC49361-8327-11CF-AC4A-0000C03825A1"],
    "IDirect3DRMClippedVisual": ["5434E733-6D66-11D1-BB0B-0000F875865A"],
    "IDirect3DRMPicked2Array": ["4516EC7B-8F20-11D0-9B6D-0000C0781BC3"],
    "IDirect3DRMProgressiveMesh": ["4516EC79-8F20-11D0-9B6D-0000C0781BC3"],
    "IDirect3DRMInterpolator": ["242F6BC1-3849-11D0-9B6D-0000C0781BC3"],
    "IDirect3DRMShadow2": ["86B44E25-9C82-11D1-BB0B-00A0C981A0A6"],
    "IDirect3DRMShadow": ["AF359780-6BA3-11CF-AC4A-0000C03825A1"],
    "IDirect3DRMUserVisual": ["59163DE0-6D43-11CF-AC4A-0000C03825A1"],
    "IDirect3DRMAnimationArray": ["D5F1CAE0-4BD7-11D1-B974-0060083E45F3"],
    "IDirect3DRMFaceArray": ["EB16CB17-D271-11CE-AC48-0000C03825A1"],
    "IDirect3DRMPickedArray": ["EB16CB16-D271-11CE-AC48-0000C03825A1"],
    "IDirect3DRMLightArray": ["EB16CB14-D271-11CE-AC48-0000C03825A1"],
    "IDirect3DRMVisualArray": ["EB16CB13-D271-11CE-AC48-0000C03825A1"],
    "IDirect3DRMFrameArray": ["EB16CB12-D271-11CE-AC48-0000C03825A1"],
    "IDirect3DRMViewportArray": ["EB16CB11-D271-11CE-AC48-0000C03825A1"],
    "IDirect3DRMDeviceArray": ["EB16CB10-D271-11CE-AC48-0000C03825A1"],
    "IDirect3DRMObjectArray": ["242F6BC2-3849-11D0-9B6D-0000C0781BC3"],
    "IDirect3DRMAnimationSet2": ["FF6B7F79-A40E-11D1-91F9-0000F8758E66"],
    "IDirect3DRMAnimationSet": ["EB16CB0E-D271-11CE-AC48-0000C03825A1"],
    "IDirect3DRMAnimation2": ["FF6B7F77-A40E-11D1-91F9-0000F8758E66"],
    "IDirect3DRMAnimation": ["EB16CB0D-D271-11CE-AC48-0000C03825A1"],
    "IDirect3DRMMaterial2": ["FF6B7F75-A40E-11D1-91F9-0000F8758E66"],
    "IDirect3DRMMaterial": ["EB16CB0B-D271-11CE-AC48-0000C03825A1"],
    "IDirect3DRMWrap": ["EB16CB0A-D271-11CE-AC48-0000C03825A1"],
    "IDirect3DRMTexture3": ["FF6B7F73-A40E-11D1-91F9-0000F8758E66"],
    "IDirect3DRMTexture2": ["120F30C0-1629-11D0-941C-0080C80CFA7B"],
    "IDirect3DRMTexture": ["EB16CB09-D271-11CE-AC48-0000C03825A1"],
    "IDirect3DRMLight": ["EB16CB08-D271-11CE-AC48-0000C03825A1"],
    "IDirect3DRMFace2": ["4516EC81-8F20-11D0-9B6D-0000C0781BC3"],
    "IDirect3DRMFace": ["EB16CB07-D271-11CE-AC48-0000C03825A1"],
    "IDirect3DRMMeshBuilder3": ["4516EC82-8F20-11D0-9B6D-0000C0781BC3"],
    "IDirect3DRMMeshBuilder2": ["4516EC77-8F20-11D0-9B6D-0000C0781BC3"],
    "IDirect3DRMMeshBuilder": ["A3A80D02-6E12-11CF-AC4A-0000C03825A1"],
    "IDirect3DRMMesh": ["A3A80D01-6E12-11CF-AC4A-0000C03825A1"],
    "IDirect3DRMVisual": ["EB16CB04-D271-11CE-AC48-0000C03825A1"],
    "IDirect3DRMFrame3": ["FF6B7F70-A40E-11D1-91F9-0000F8758E66"],
    "IDirect3DRMFrame2": ["C3DFBD60-3988-11D0-9EC2-0000C0291AC3"],
    "IDirect3DRMFrame": ["EB16CB03-D271-11CE-AC48-0000C03825A1"],
    "IDirect3DRMViewport2": ["4A1B1BE6-BFED-11D1-8ED8-00A0C967A482"],
    "IDirect3DRMViewport": ["EB16CB02-D271-11CE-AC48-0000C03825A1"],
    "IDirect3DRMDevice3": ["549F498B-BFEB-11D1-8ED8-00A0C967A482"],
    "IDirect3DRMDevice2": ["4516EC78-8F20-11D0-9B6D-0000C0781BC3"],
    "IDirect3DRMDevice": ["E9E19280-6E05-11CF-AC4A-0000C03825A1"],
    "IDirect3DRMObject2": ["4516EC7C-8F20-11D0-9B6D-0000C0781BC3"],
    "IDirect3DRMObject": ["EB16CB00-D271-11CE-AC48-0000C03825A1"],
    "IDirect3DSwapChain8": ["928C088B-76B9-4C6B-A536-A590853876CD"],
    "IDirect3DVolume8": ["BD7349F5-14F1-42E4-9C79-972380DB40C0"],
    "IDirect3DSurface8": ["B96EEBCA-B326-4EA5-882F-2FF5BAE021DD"],
    "IDirect3DIndexBuffer8": ["0E689C9A-053D-44A0-9D92-DB0E3D750F86"],
    "IDirect3DVertexBuffer8": ["8AEEEAC7-05F9-44D4-B591-000B0DF1CB95"],
    "IDirect3DVolumeTexture8": ["4B8AAAFA-140F-42BA-9131-597EAFAA2EAD"],
    "IDirect3DCubeTexture8": ["3EE5B968-2ACA-4C34-8BB5-7E0C3D19B750"],
    "IDirect3DTexture8": ["E4CDD575-2866-4F01-B12E-7EECE1EC9358"],
    "IDirect3DBaseTexture8": ["B4211CFA-51B9-4A9F-AB78-DB99B2BB678E"],
    "IDirect3DResource8": ["1B36BB7B-09B7-410A-B445-7D1430D7B33F"],
    "IDirect3DDevice8": ["7385E5DF-8FE8-41D5-86B6-D7B48547B6CF"],
    "IDirect3D8": ["1DD9E8DA-1C77-4D40-B0CF-98FEFDFF9512"],
    "IDirect3DVertexBuffer7": ["F5049E7D-4861-11D2-A407-00A0C90629A8"],
    "IDirect3DVertexBuffer": ["7A503555-4A83-11D1-A5DB-00A0C90367F8"],
    "IDirect3DViewport3": ["B0AB3B61-33D7-11D1-A981-00C04FD7B174"],
    "IDirect3DViewport2": ["93281500-8CF8-11D0-89AB-00A0C9054129"],
    "IDirect3DViewport": ["4417C146-33AD-11CF-816F-0000C020156E"],
    "IDirect3DExecuteBuffer": ["4417C145-33AD-11CF-816F-0000C020156E"],
    "IDirect3DMaterial3": ["CA9C46F4-D3C5-11D1-B75A-00600852B312"],
    "IDirect3DMaterial2": ["93281503-8CF8-11D0-89AB-00A0C9054129"],
    "IDirect3DMaterial": ["4417C144-33AD-11CF-816F-0000C020156E"],
    "IDirect3DLight": ["4417C142-33AD-11CF-816F-0000C020156E"],
    "IDirect3DTexture2": ["93281502-8CF8-11D0-89AB-00A0C9054129"],
    "IDirect3DTexture": ["2CDCD9E0-25A0-11CF-A31A-00AA00B93356"],
    "IDirect3DDevice7": ["F5049E79-4861-11D2-A407-00A0C90629A8"],
    "IDirect3DDevice3": ["B0AB3B60-33D7-11D1-A981-00C04FD7B174"],
    "IDirect3DDevice2": ["93281501-8CF8-11D0-89AB-00A0C9054129"],
    "IDirect3DDevice": ["64108800-957D-11D0-89AB-00A0C9054129"],
    "IDirect3DTnLHalDevice": ["F5049E78-4861-11D2-A407-00A0C90629A8"],
    "IDirect3DNullDevice": ["8767DF22-BACC-11D1-8969-00A0C90629A8"],
    "IDirect3DRefDevice": ["50936643-13E9-11D1-89AA-00A0C9054129"],
    "IDirect3DMMXDevice": ["881949A1-D6F3-11D0-89AB-00A0C9054129"],
    "IDirect3DHALDevice": ["84E63DE0-46AA-11CF-816F-0000C020156E"],
    "IDirect3DRGBDevice": ["A4665C60-2673-11CF-A31A-00AA00B93356"],
    "IDirect3DRampDevice": ["F2086B20-259F-11CF-A31A-00AA00B93356"],
    "IDirect3D7": ["F5049E77-4861-11D2-A407-00A0C90629A8"],
    "IDirect3D3": ["BB223240-E72B-11D0-A9B4-00AA00C0993E"],
    "IDirect3D2": ["6AAE1EC1-662A-11D0-889D-00AA00BBB76A"],
    "IDirect3D": ["3BBA0080-2421-11CF-A31A-00AA00B93356"],
    "IDirectDrawVideoPortNotify": ["A655FB94-0589-4E57-B333-567A89468C88"],
    "IDirectDrawVideoPort": ["B36D93E0-2B43-11CF-A2DE-00AA00B93356"],
    "IDDVideoPortContainer": ["6C142760-A733-11CE-A521-0020AF0BE560"],
    "IXACTEngine": ["0AA000A0-F404-11D9-BD7A-0010DC4F8F81"],
    "IDirectDrawGammaControl": ["69C11C3E-B46B-11D1-AD7A-00C04FC29B4E"],
    "IDirectDrawColorControl": ["4B9F0EE0-0D7E-11D0-9B06-00A0C903A3B8"],
    "IDirectDrawClipper": ["6C14DB85-A733-11CE-A521-0020AF0BE560"],
    "IDirectDrawPalette": ["6C14DB84-A733-11CE-A521-0020AF0BE560"],
    "IDirectDrawPalette2": ["C03C477E-6519-11D1-8C52-00C04FD930C5"],
    "IDirectDrawOptSurface": ["51191F1E-4F2B-11D1-8CC3-00A0C90629A8"],
    "IDirectDrawFactory2": ["89B2C488-4AF4-11D1-8C4C-00C04FD930C5"],
    "IDirectDrawSurfaceNew": ["1BAB8E96-9CFE-4CE3-BC72-D7E9E99A2175"],
    "IDirectDrawSurface7": ["06675A80-3B9B-11D2-B92F-00609797EA5B"],
    "IDirectDrawSurface4": ["0B2B8630-AD35-11D0-8EA6-00609797EA5B"],
    "IDirectDrawSurface3": ["DA044E00-69B2-11D0-A1D5-00AA00B8DFBB"],
    "IDirectDrawSurface2": ["57805885-6EEC-11CF-9441-A82303C10E27"],
    "IDirectDrawSurface": ["6C14DB81-A733-11CE-A521-0020AF0BE560"],
    "IDirectDraw7": ["15E65EC0-3B9C-11D2-B92F-00609797EA5B"],
    "IDirectDraw4": ["9C59509A-39BD-11D1-8C4A-00C04FD930C5"],
    "IDirectDraw2": ["B3A6F3E0-2B43-11CF-A2DE-00AA00B93356"],
    "IDirectDraw": ["6C14DB80-A733-11CE-A521-0020AF0BE560"],
    "IRTPSPHFilter": ["D5284681-B680-11D0-9643-00AA00A89C1D"],
    "ISilenceSuppressor": ["40C1D160-52F2-11D0-A874-00AA00B5CA1B"],
    "IMAPIAdviseSink": ["00020302-0000-0000-C000-000000000046"],
    "IMAPIProgress": ["0002031F-0000-0000-C000-000000000046"],
    "IMAPITableData": ["00020316-0000-0000-C000-000000000046"],
    "IKoInitializeParentDeviceObject": ["21B36996-8DE3-11D1-8AE0-00A0C9223196"],
    "IKsAllocator": ["8DA64899-C0D9-11D0-8413-0000F822FE8A"],
    "IKsClockPropertySet": ["5C5CBD84-E755-11D0-AC18-00A0C9223196"],
    "IKsInterfaceHandler": ["D3ABC7E0-9A61-11D0-A40D-00A0C9223196"],
    "IKsDataTypeHandler": ["5FFBAA02-49A3-11D0-9F36-00AA00A216A1"],
    "IKsPin": ["B61178D1-A2D9-11CF-9E53-00AA00A216A1"],
    "IKsObject": ["423C13A2-2070-11D0-9EF7-00AA00A216A1"],
    "IMediumValidation": ["40DC0EAE-5FAB-11D1-9AA6-00A0C9223196"],
    "IJavaComModuleManager": ["AC680B40-CDA0-11D1-A936-0080C7C575C0"],
    "IJavaExecute2": ["D7658820-01DD-11D0-9746-00AA00342BD8"],
    "IEnumJAVAPROPERTY": ["56E7DF80-F527-11CF-B728-FC8703C10000"],
    "ICodeStoreDBEntry": ["D2073C40-AB4F-11D0-A732-00A0C9082637"],
    "ICodeStoreDB": ["DF3D9C22-AB4E-11D0-A732-00A0C9082637"],
    "IEnumCodeStoreDBEntry": ["D2073C42-AB4F-11D0-A732-00A0C9082637"],
    "IJavaPackageManager": ["D2073C43-AB4F-11D0-A732-00A0C9082637"],
    "IJavaPackage": ["D2073C46-AB4F-11D0-A732-00A0C9082637"],
    "IJavaPackage2": ["F79E6FA1-86A0-11D1-811E-00C04FB92687"],
    "IJavaFile": ["D2073C48-AB4F-11D0-A732-00A0C9082637"],
    "IPersistJavaTypeLib": ["3A29ACD0-78D5-11D0-AF77-0080C71F7993"],
    "ICreateJavaPackageMgr": ["D2073C47-AB4F-11D0-A732-00A0C9082637"],
    "IEnumJavaPackage": ["D2073C45-AB4F-11D0-A732-00A0C9082637"],
    "IEnumJavaFile": ["D2073C49-AB4F-11D0-A732-00A0C9082637"],
    "IEnumBeanInfo": ["4D6007E2-0306-11D1-98C9-00C04FB609B9"],
    "IBeanInfo": ["4D6007E3-0306-11D1-98C9-00C04FB609B9"],
    "IJavaPackageManager2": ["3D1D4C60-3F32-11D1-A733-00C04FD79B94"],
    "IClassPathElement": ["3D1D4C61-3F32-11D1-A733-00C04FD79B94"],
    "IEnumClassPathElement": ["3D1D4C65-3F32-11D1-A733-00C04FD79B94"],
    "IJavaFileContainer": ["297982B3-39B8-11D1-A943-00A0C921A4D2"],
    "IEnumJavaFileContainer": ["297982B2-39B8-11D1-A943-00A0C921A4D2"],
    "IJavaZonePermissionEditor": ["85347F8A-C8B7-11D0-8823-00C04FB67C84"],
    "ICreatesJavaObjects": ["92F362C0-CF5A-11D1-A93C-0080C7C575C0"],
    "IJavaExecute": ["3EFB1803-C2A1-11CF-960C-0080C7C2BA87"],
    "ITNotification": ["DDA68522-B6A5-11D0-A489-00C04FD91AC0"],
    "IDocFindFolder": ["A5DF1EA0-5702-11D1-83FA-00A0C90DC849"],
    "IConnectionPointDefaultImpl": ["881DEEC0-6BA2-11D1-B758-00A0C90564FE"],
    "INotifyCallback": ["A5EA8D2E-253D-11D1-B3F1-00AA003761C5"],
    "IFilterSideInterface": ["A5EA8D2D-253D-11D1-B3F1-00AA003761C5"],
    "ICutListGraphBuilder": ["A5EA8D2C-253D-11D1-B3F1-00AA003761C5"],
    "IElementInfo": ["A5EA8D2B-253D-11D1-B3F1-00AA003761C5"],
    "IFileClip": ["A5EA8D2A-253D-11D1-B3F1-00AA003761C5"],
    "IStandardCutList": ["A5EA8D29-253D-11D1-B3F1-00AA003761C5"],
    "IElementDefinition": ["A5EA8D28-253D-11D1-B3F1-00AA003761C5"],
    "IAudioCutListElement": ["A5EA8D27-253D-11D1-B3F1-00AA003761C5"],
    "IVidFXCutListElement": ["A5EA8D26-253D-11D1-B3F1-00AA003761C5"],
    "IVideoCutListElement": ["A5EA8D25-253D-11D1-B3F1-00AA003761C5"],
    "IFileCutListElement": ["A5EA8D24-253D-11D1-B3F1-00AA003761C5"],
    "ICutListElement": ["A5EA8D23-253D-11D1-B3F1-00AA003761C5"],
    "ICutList": ["A5EA8D22-253D-11D1-B3F1-00AA003761C5"],
    "ICutListSourceFilter": ["A5EA8D21-253D-11D1-B3F1-00AA003761C5"],
    "IDvdGraphBuilder": ["FCC152B6-F372-11D0-8E00-00C04FD7C08B"],
    "IDvdInfo": ["A70EFE60-E2A3-11D0-A9BE-00AA0061BE93"],
    "IDvdControl": ["A70EFE61-E2A3-11D0-A9BE-00AA0061BE93"],
    "ICreateDevEnum": ["29840822-5B84-11D0-BD3B-00A0C911CE86"],
    "IAMovie": ["359ACE10-7688-11CF-8B23-00805F6CEF60"],
    "IAMStreamSelect": ["C1960960-17F5-11D1-ABE1-00A0C905F375"],
    "IAMDevMemoryControl": ["C6545BF1-E76B-11D0-BD52-00A0C911CE86"],
    "IAMDevMemoryAllocator": ["C6545BF0-E76B-11D0-BD52-00A0C911CE86"],
    "IAMTimecodeDisplay": ["9B496CE2-811B-11CF-8C77-00AA006B6814"],
    "IAMTimecodeGenerator": ["9B496CE0-811B-11CF-8C77-00AA006B6814"],
    "IAMTimecodeReader": ["9B496CE1-811B-11CF-8C77-00AA006B6814"],
    "IAMExtTransport": ["A03CD5F0-3045-11CF-8C44-00AA006B6814"],
    "IAMExtDevice": ["B5730A90-1A2C-11CF-8C23-00AA006B6814"],
    "IAMPhysicalPinInfo": ["F938C991-3029-11CF-8C44-00AA006B6814"],
    "IPersistMediaPropertyBag": ["5738E040-B67F-11D0-BD4D-00A0C911CE86"],
    "IMediaPropertyBag": ["6025A880-C0D5-11D0-BD4E-00A0C911CE86"],
    "IAMAnalogVideoEncoder": ["C6E133B0-30AC-11D0-A18C-00A0C9118956"],
    "IAMTVTuner": ["C6E133A0-30AC-11D0-A18C-00A0C9118956", "211A8766-03AC-11D1-8D13-00AA00BD8339"],
    "IAMCrossbar": ["C6E13380-30AC-11D0-A18C-00A0C9118956"],
    "IAMCameraControl": ["C6E13370-30AC-11D0-A18C-00A0C9118956"],
    "IAMVideoProcAmp": ["C6E13360-30AC-11D0-A18C-00A0C9118956"],
    "IAMAnalogVideoDecoder": ["C6E13350-30AC-11D0-A18C-00A0C9118956"],
    "IAMBufferNegotiation": ["56ED71A0-AF5F-11D0-B3F0-00AA003761C5"],
    "IAMAudioInputMixer": ["54C39221-8380-11D0-B3F0-00AA003761C5"],
    "IAMDroppedFrames": ["C6E13344-30AC-11D0-A18C-00A0C9118956"],
    "IAMVfwCompressDialogs": ["D8D715A3-6E5E-11D0-B3F0-00AA003761C5"],
    "IAMVfwCaptureDialogs": ["D8D715A0-6E5E-11D0-B3F0-00AA003761C5"],
    "IAMVideoCompression": ["C6E13343-30AC-11D0-A18C-00A0C9118956"],
    "IConfigAviMux": ["5ACD6AA0-F482-11CE-8B67-00AA00A3F1A6"],
    "IConfigInterleaving": ["BEE3D220-157B-11D0-BD23-00A0C911CE86"],
    "IAMStreamConfig": ["C6E13340-30AC-11D0-A18C-00A0C9118956"],
    "ISeekingPassThru": ["36B73883-C2C8-11CF-8B46-00805F6CEF60"],
    "IAMStreamControl": ["36B73881-C2C8-11CF-8B46-00805F6CEF60"],
    "IDistributorNotify": ["56A868AF-0AD4-11CE-B03A-0020AF0BA770"],
    "IResourceManager": ["56A868AC-0AD4-11CE-B03A-0020AF0BA770"],
    "IResourceConsumer": ["56A868AD-0AD4-11CE-B03A-0020AF0BA770"],
    "IGraphVersion": ["56A868AB-0AD4-11CE-B03A-0020AF0BA770"],
    "IAsyncReader": ["56A868AA-0AD4-11CE-B03A-0020AF0BA770"],
    "IStreamBuilder": ["56A868BF-0AD4-11CE-B03A-0020AF0BA770"],
    "IFilterGraph2": ["36B73882-C2C8-11CF-8B46-00805F6CEF60"],
    "IAMCopyCaptureFileProgress": ["670D1D20-A068-11D0-B3F0-00AA003761C5"],
    "ICaptureGraphBuilder": ["BF87B6E0-8C27-11D0-B3F0-00AA003761C5"],
    "IGraphBuilder": ["56A868A9-0AD4-11CE-B03A-0020AF0BA770"],
    "IFileAsyncIO": ["56A868A7-0AD4-11CE-B03A-0020AF0BA770"],
    "IFileSinkFilter2": ["00855B90-CE1B-11D0-BD4F-00A0C911CE86"],
    "IFileSinkFilter": ["A2104830-7C70-11CF-8BCE-00AA00A3F1A6"],
    "IFileSourceFilter": ["56A868A6-0AD4-11CE-B03A-0020AF0BA770"],
    "IMediaEventSink": ["56A868A2-0AD4-11CE-B03A-0020AF0BA770"],
    "IOverlay": ["56A868A1-0AD4-11CE-B03A-0020AF0BA770"],
    "IOverlayNotify": ["56A868A0-0AD4-11CE-B03A-0020AF0BA770"],
    "IFilterMapper2": ["B79BB0B0-33C1-11D1-ABE1-00A0C905F375"],
    "IFilterMapper": ["56A868A3-0AD4-11CE-B03A-0020AF0BA770"],
    "IEnumRegFilters": ["56A868A4-0AD4-11CE-B03A-0020AF0BA770"],
    "IMediaSeeking": ["36B73880-C2C8-11CF-8B46-00805F6CEF60"],
    "IAMovieSetup": ["A3D8CEC0-7E5A-11CF-BBC5-00805F6CEF20"],
    "IMemInputPin": ["56A8689D-0AD4-11CE-B03A-0020AF0BA770"],
    "IMemAllocator": ["56A8689C-0AD4-11CE-B03A-0020AF0BA770"],
    "IMediaSample2": ["36B73884-C2C8-11CF-8B46-00805F6CEF60"],
    "IMediaSample": ["56A8689A-0AD4-11CE-B03A-0020AF0BA770"],
    "IReferenceClock2": ["36B73885-C2C8-11CF-8B46-00805F6CEF60"],
    "IBaseFilter": ["56A86895-0AD4-11CE-B03A-0020AF0BA770"],
    "IMediaFilter": ["56A86899-0AD4-11CE-B03A-0020AF0BA770"],
    "IEnumFilters": ["56A86893-0AD4-11CE-B03A-0020AF0BA770"],
    "IFilterGraph": ["56A8689F-0AD4-11CE-B03A-0020AF0BA770"],
    "IEnumMediaTypes": ["89C31040-846B-11CE-97D3-00AA0055595A"],
    "IEnumPins": ["56A86892-0AD4-11CE-B03A-0020AF0BA770"],
    "IPin": ["56A86891-0AD4-11CE-B03A-0020AF0BA770"],
    "IPinInfo": ["56A868BD-0AD4-11CE-B03A-0020AF0BA770"],
    "IMediaTypeInfo": ["56A868BC-0AD4-11CE-B03A-0020AF0BA770"],
    "IRegFilterInfo": ["56A868BB-0AD4-11CE-B03A-0020AF0BA770"],
    "IFilterInfo": ["56A868BA-0AD4-11CE-B03A-0020AF0BA770"],
    "IQueueCommand": ["56A868B7-0AD4-11CE-B03A-0020AF0BA770"],
    "IDeferredCommand": ["56A868B8-0AD4-11CE-B03A-0020AF0BA770"],
    "IBasicVideo": ["56A868B5-0AD4-11CE-B03A-0020AF0BA770"],
    "IVideoWindow": ["56A868B4-0AD4-11CE-B03A-0020AF0BA770"],
    "IBasicAudio": ["56A868B3-0AD4-11CE-B03A-0020AF0BA770"],
    "IMediaPosition": ["56A868B2-0AD4-11CE-B03A-0020AF0BA770"],
    "IMediaEventEx": ["56A868C0-0AD4-11CE-B03A-0020AF0BA770"],
    "IMediaEvent": ["56A868B6-0AD4-11CE-B03A-0020AF0BA770"],
    "IMediaControl": ["56A868B1-0AD4-11CE-B03A-0020AF0BA770"],
    "IAMCollection": ["56A868B9-0AD4-11CE-B03A-0020AF0BA770"],
    "IAMLine21Decoder": ["6E8D4A21-310C-11D0-B79A-00AA003767A7"],
    "IMpegAudioDecoder": ["A8BB1580-B5EE-11CE-8D2B-0000E202599C", "B45DD570-3C77-11D1-ABE1-00A0C905F375"],
    "IAMDirectSound": ["546F4260-D53E-11CF-B3F0-00AA003761C5"],
    "IFullScreenVideoEx": ["53479470-F1DD-11CF-BC42-00AA00AC74F6"],
    "IFullScreenVideo": ["DD1D7110-7836-11CF-BF47-00AA0055595A"],
    "IDirectDrawSurfaceKernel": ["60755DA0-6A40-11D0-9B06-00A0C903A3B8"],
    "IDirectDrawKernel": ["8D56C120-6A08-11D0-9B06-00A0C903A3B8"],
    "IMixerPinConfig": ["593CDDE1-0759-11D1-9E69-00C04FD7C15B"],
    "IVPVBINotify": ["EC529B01-1A1F-11D1-BAD9-00609744111A"],
    "IVPVBIConfig": ["EC529B00-1A1F-11D1-BAD9-00609744111A"],
    "IVPNotify": ["C76794A1-D6C5-11D0-9E69-00C04FD7C15B"],
    "IVPConfig": ["BC29A660-30E3-11D0-9E69-00C04FD7C15B"],
    "IVPVBIObject": ["814B9802-1C88-11D1-BAD9-00609744111A"],
    "IVPObject": ["CE292862-FC88-11D0-9E69-00C04FD7C15B"],
    "IQualProp": ["1BD0ECB0-F8E2-11CE-AAC6-0020AF0B99A3"],
    "IDirectDrawVideo": ["36D39EB0-DD75-11CE-BF0E-00AA0055595A"],
    "IBaseVideoMixer": ["61DED640-E912-11CE-A099-00AA00479A58"],
    "IAMTuner": ["211A8761-03AC-11D1-8D13-00AA00BD8339"],
    "IAMTunerNotification": ["211A8760-03AC-11D1-8D13-00AA00BD8339"],
    "IBPCSatelliteTuner": ["211A8765-03AC-11D1-8D13-00AA00BD8339"],
    "IAMTVAudio": ["83EC1C30-23D1-11D1-99E6-00A0C9560266"],
    "IAMTVAudioNotification": ["83EC1C33-23D1-11D1-99E6-00A0C9560266"],
    "IAMCutListElement": ["CDE29520-3418-11CF-A5B0-0020AF053D8F"],
    "IAMFileCutListElement": ["F0947070-276C-11D0-8316-0020AF11C010"],
    "IAMVideoCutListElement": ["CDE29522-3418-11CF-A5B0-0020AF053D8F"],
    "IAMAudioCutListElement": ["CDE29524-3418-11CF-A5B0-0020AF053D8F"],
    "IVPControl": ["25DF12C1-3DE0-11D1-9E69-00C04FD7C15B"],
    "IDCInfo": ["0C733A9C-2A1C-11CE-ADE5-00AA0044773D"],
    "IDataConvert": ["0C733A8D-2A1C-11CE-ADE5-00AA0044773D"],
    "IADsSecurityUtility": ["A63251B2-5F21-474B-AB52-4A8EFAD10895"],
    "IADsAcePrivate": ["FD145DF2-FD96-4135-9B22-68FF0F6BF5BB"],
    "IUmiADSIPrivate": ["CFCECB01-3123-4926-B5E3-627808272643"],
    "IADsUmiHelperPrivate": ["4FE243F0-AD89-4CBC-9B14-486126446AE0"],
    "IADsExtension": ["3D35553C-D2B0-11D1-B17B-0000F87593A0"],
    "IADsObjOptPrivate": ["81CBB829-1867-11D2-9220-00C04FB6D0D1"],
    "IADsObjectOptions": ["46F14FDA-232B-11D1-A808-00C04FD8D5A8"],
    "IADsPropertyList": ["C6F602B6-8F69-11D0-8528-00C04FD8D503"],
    "IADsSearch": ["C69F7780-4008-11D0-B94C-00C04FD8D5A8"],
    "IDirectorySchemaMgmt": ["75DB3B9C-A4D8-11D0-A79C-00C04FD8D5A8"],
    "IDirectorySearch": ["109BA8EC-92F0-11D0-A790-00C04FD8D5A8"],
    "IDirectoryObject": ["E798DE2C-22E4-11D0-84FE-00C04FD8D503"],
    "IADsOpenDSObject": ["DDF2891E-0F9C-11D0-8AD4-00C04FD8D503"],
    "IADsOU": ["A2F733B8-EFFE-11CF-8ABC-00C04FD8D503"],
    "IADsO": ["A1CD2DC6-EFFE-11CF-8ABC-00C04FD8D503"],
    "IADsLocality": ["A05E03A2-EFFE-11CF-8ABC-00C04FD8D503"],
    "IADsProperty": ["C8F93DD3-4AE0-11CF-9E73-00AA004A5691"],
    "IADsSyntax": ["C8F93DD2-4AE0-11CF-9E73-00AA004A5691"],
    "IADsClass": ["C8F93DD0-4AE0-11CF-9E73-00AA004A5691"],
    "IADsFileShare": ["EB6DCAF0-4B83-11CF-A995-00AA006BC149"],
    "IADsSession": ["398B7DA0-4AAB-11CF-AE2C-00AA006EBFB9"],
    "IADsResource": ["34A05B20-4AAB-11CF-AE2C-00AA006EBFB9"],
    "IADsFileService": ["A89D1900-31CA-11CF-A98A-00AA006BC149"],
    "IADsFileServiceOperations": ["A02DED10-31CA-11CF-A98A-00AA006BC149"],
    "IADsService": ["68AF66E0-31CA-11CF-A98A-00AA006BC149"],
    "IADsServiceOperations": ["5D7B33F0-31CA-11CF-A98A-00AA006BC149"],
    "IADsCollection": ["72B945E0-253B-11CF-A988-00AA006BC149"],
    "IADsPrintJob": ["32FB6780-1ED0-11CF-A988-00AA006BC149"],
    "IADsPrintJobOperations": ["9A52DB30-1ECF-11CF-A988-00AA006BC149"],
    "IADsPrintQueueOperations": ["124BE5C0-156E-11CF-A986-00AA006BC149"],
    "IADsPrintQueue": ["B15160D0-1226-11CF-A985-00AA006BC149"],
    "IADsMembers": ["451A0030-72EC-11CF-B03B-00AA006E0975"],
    "IADsGroup": ["27636B00-410F-11CF-B1FF-02608C9E7553"],
    "IADsComputer": ["EFE3CC70-1D9F-11CF-B1F3-02608C9E7553"],
    "IADsComputerOperations": ["EF497680-1D9F-11CF-B1F3-02608C9E7553"],
    "IADsUser": ["3E37E320-17E2-11CF-ABC4-02608C9E7553"],
    "IADsDomain": ["00E4C220-FD16-11CE-ABC4-02608C9E7553"],
    "IADsNamespaces": ["28B96BA0-B330-11CF-A9AD-00AA006BC149"],
    "IADsContainer": ["001677D0-FD16-11CE-ABC4-02608C9E7553"],
    "IADs": ["FD8256D0-FD15-11CE-ABC4-02608C9E7553"],
    "IBitsTest1": ["51A183DB-67E0-4472-8602-3DBC730B7EF5"],
    "ICertManageModule": ["E7D7AD42-BD3D-11D1-9A4D-00C04FC297EB"],
    "IGCHost": ["FAC34F6E-0DCD-47B5-8021-531BC5ECCA63"],
    "IManagedInstanceWrapper": ["96E328FE-9A83-439F-A298-8F9CAA2995F0"],
    "IRegistrar": ["44EC053B-400F-11D0-9DCD-00A0C90391D3"],
    "IAxWinHostWindow": ["B6EA2050-048A-11D1-82B9-00C04FB9942E"],
    "IAxWinAmbientDispatch": ["B6EA2051-048A-11D1-82B9-00C04FB9942E"],
    "IInternalConnection": ["72AD0770-6A9F-11D1-BCEC-0060088F444E"],
    "IDocHostUIHandlerDispatch": ["425B5AF0-65F1-11D1-9611-0000F81E0D0D"],
    "IAxWinHostWindowLic": ["3935BDA8-4ED9-495C-8650-E01FC1E38A4B"],
    "IAxWinAmbientDispatchEx": ["B2D0778B-AC99-4C58-A5C8-E7724E5316B5"],
    "IMetaDataInternal": ["39EE28B3-0181-4D48-B53C-2FFAFFD5FEC1"],
    "IMetaDataError": ["B81FF171-20F3-11D2-8DCC-00A0C9B09C19"],
    "IMapToken": ["06A3EA8B-0225-11D1-BF72-00C04FC31E12"],
    "IMetaDataDispenser": ["809C652E-7396-11D2-9771-00A0C9B4D50C"],
    "IMetaDataEmit": ["BA3FEE4C-ECB9-4E41-83B7-183FA41CD859"],
    "IMetaDataEmit2": ["F5DD9950-F693-42E6-830E-7B833E8146A9"],
    "IMetaDataImport": ["7DAC8207-D3AE-4C75-9B67-92801A497D44"],
    "IMetaDataImport2": ["FCE5EFA0-8BBA-4F8E-A036-8F2022B08466"],
    "IMetaDataFilter": ["D0E80DD1-12D4-11D3-B39D-00C04FF81795"],
    "IHostFilter": ["D0E80DD3-12D4-11D3-B39D-00C04FF81795"],
    "IMetaDataConverter": ["D9DEBD79-2992-11D3-8BC1-0000F8083A57"],
    "IMetaDataAssemblyEmit": ["211EF15B-5317-4438-B196-DEC87B887693"],
    "IMetaDataAssemblyImport": ["EE62470B-E94B-424E-9B7C-2F00C9249F93"],
    "IMetaDataValidate": ["4709C9C6-81FF-11D3-9FC7-00C04F79A0A3"],
    "IMetaDataDispenserEx": ["31BCFCE2-DAFB-11D2-9F81-00C04F79A0A3"],
    "ICeeGen": ["7ED1BDFF-8E36-11D2-9C56-00A0C9B7CC45"],
    "ICorModule": ["2629F8E1-95E5-11D2-9C56-00A0C9B7CC45"],
    "IMetaDataTables": ["D8F579AB-402D-4B8E-82D9-5D63B1065C68"],
    "IMetaDataTables2": ["BADB5F70-58DA-43A9-A1C6-D74819F19B15"],
    "INativeImageDependency": ["814C9E35-3F3F-4975-977A-371F0A878AC7"],
    "INativeImageInstallInfo": ["0EA273D0-B4DA-4008-A60D-8D6EFFDD6E91"],
    "INativeImageEvaluate": ["065AA013-9BDC-447C-922F-FEE929908447"],
    "IGPMMigrationTable": ["48F823B1-EFAF-470B-B6ED-40D14EE1A4EC"],
    "IGPMMapEntry": ["8E79AD06-2381-4444-BE4C-FF693E6E6F2B"],
    "IGPMMapEntryCollection": ["BB0BF49B-E53F-443F-B807-8BE22BFB6D42"],
    "IGPMResult": ["86DFF7E9-F76F-42AB-9570-CEBC6BE8A52D"],
    "IGPMConstants": ["50EF73E6-D35C-4C8D-BE63-7EA5D2AAC5C4"],
    "IGPMStatusMessage": ["8496C22F-F3DE-4A1F-8F58-603CAAA93D7B"],
    "IGPMStatusMsgCollection": ["9B6E1AF0-1A92-40F3-A59D-F36AC1F728B7"],
    "IGPMAsyncProgress": ["6AAC29F8-5948-4324-BF70-423818942DBC"],
    "IGPMAsyncCancel": ["DDC67754-BE67-4541-8166-F48166868C9C"],
    "IGPMClientSideExtension": ["69DA7488-B8DB-415E-9266-901BE4D49928"],
    "IGPMCSECollection": ["2E52A97D-0A4A-4A6F-85DB-201622455DA0"],
    "IGPMGPOLinksCollection": ["189D7B68-16BD-4D0D-A2EC-2E6AA2288C7F"],
    "IGPMGPOLink": ["434B99BD-5DE7-478A-809C-C251721DF70C"],
    "IGPMGPOCollection": ["F0F0D5CF-70CA-4C39-9E29-B642F8726C01"],
    "IGPMGPO": ["58CC4352-1CA3-48E5-9864-1DA4D6E0D60F"],
    "IGPMRSOP": ["49ED785A-3237-4FF2-B1F0-FDF5A8D5A1EE"],
    "IGPMWMIFilterCollection": ["5782D582-1A36-4661-8A94-C3C32551945B"],
    "IGPMWMIFilter": ["EF2FF9B4-3C27-459A-B979-038305CEC75D"],
    "IGPMSOMCollection": ["ADC1688E-00E4-4495-ABBA-BED200DF0CAB"],
    "IGPMSOM": ["C0A7F09E-05A1-4F0C-8158-9E5C33684F6B"],
    "IGPMBackupCollection": ["C786FC0F-26D8-4BAB-A745-39CA7E800CAC"],
    "IGPMBackup": ["D8A16A35-3B0D-416B-8D02-4DF6F95A7119"],
    "IGPMSecurityInfo": ["B6C31ED4-1C93-4D3E-AE84-EB6D61161B60"],
    "IGPMPermission": ["35EBCA40-E1A1-4A02-8905-D79416FB464A"],
    "IGPMTrustee": ["3B466DA8-C1A4-4B2A-999A-BEFCDD56CEFB"],
    "IGPMSearchCriteria": ["D6F11C42-829B-48D4-83F5-3615B67DFC22"],
    "IGPMSitesContainer": ["4725A899-2782-4D27-A6BB-D499246FFD72"],
    "IGPMBackupDir": ["B1568BED-0A93-4ACC-810F-AFE7081019B9"],
    "IGPMDomain": ["6B21CC14-5A00-4F44-A738-FEEC8A94C7E3"],
    "IGPM": ["F5FAE809-3BD6-4DA9-A65E-17665B41D763"],
    "IKsTopology": ["28F54683-06FD-11D2-B27A-00A0C9223196"],
    "IKsAggregateControl": ["7F40EAC0-3947-11D2-874E-00A0C9223196"],
    "IKsAllocatorEx": ["091BB63A-603F-11D1-B067-00A0C9062802"],
    "IKsDataTypeCompletion": ["827D1A0E-0F73-11D2-B27A-00A0C9223196"],
    "IKsPinPipe": ["E539CD90-A8B4-11D1-8189-00A0C9062802"],
    "IKsPinEx": ["7BB38260-D19C-11D2-B38A-00A0C95EC22E"],
    "IFolderTabView": ["F4D3C5A8-0314-11D3-8859-00C04F72C717"],
    "ITitleView": ["DCA68D28-EEB3-11D2-883E-00C04F72C717"],
    "ITaskView": ["9FF7A05C-E7B9-11D2-883C-00C04F72C717"],
    "ITaskCallback": ["4B2293BA-E7BA-11D2-883C-00C04F72C717"],
    "IStringTablePrivate": ["461A6010-0F9E-11D2-A6A1-0000F875A9CE"],
    "ITaskPadHost": ["4F7606D0-5568-11D1-9FEA-00600832DB4A"],
    "IMMCListView": ["1B3C1392-D68B-11CF-8C2B-00AA003CA9F6"],
    "IPropertySheetProviderPrivate": ["FEF554F8-A55A-11D0-A7D7-00C04FD909DD"],
    "IDumpSnapins": ["A16496D0-1D2F-11D3-AEB8-00C04F8ECD78"],
    "IEnumNodeTypes": ["ABBD61E6-9686-11D0-A799-00C04FD8D565"],
    "INodeTypesCache": ["DE40436E-9671-11D0-A799-00C04FD8D565"],
    "INodeType": ["B08A8368-967F-11D0-A799-00C04FD8D565"],
    "IControlbarsCache": ["2E9FCD38-B9A0-11D0-A79D-00C04FD8D565"],
    "INodeCallback": ["B241FCED-5FB3-11D0-A986-00C04FD8D565"],
    "IScopeTreeIter": ["D779F8D1-6057-11D0-A986-00C04FD8D565"],
    "IScopeTree": ["D8DBF067-5FB2-11D0-A986-00C04FD8D565"],
    "IHeaderCtrlPrivate": ["0B384311-701B-4E8A-AEC2-DA6321E27AD2"],
    "IResultDataPrivate": ["1EBA2300-0854-11D0-8B03-00AA003CA9F6"],
    "IImageListPrivate": ["7538C620-0083-11D0-8B00-00AA003CA9F6"],
    "IScopeDataPrivate": ["60BD2FE0-F7C5-11CF-8AFD-00AA003CA9F6"],
    "IFramePrivate": ["D71D1F2A-1BA2-11D0-A29B-00C04FD909DD"],
    "IPropertySheetNotify": ["D700DD8E-2646-11D0-A2A7-00C04FD909DD"],
    "IHHCollectionWrapper": ["06A03424-C9EB-11D2-8CAA-0080C739E3E0"],
    "IMMCClipboardDataObject": ["5491AB67-AFEB-48B1-B8DF-B2D63810EF40"],
    "IDocConfig": ["F1E752C2-FD72-11D0-AEF6-00C04FB6DD2C"],
    "Property": ["4600C3A5-E301-41D8-B6D0-EF2E4212E0CA"],
    "Properties": ["2886ABC2-A425-42B2-91C6-E25C0E04581C"],
    "MenuItem": ["0178FAD1-B361-4B27-96AD-67C57EBF2E1D"],
    "ContextMenu": ["DAB39CE0-25E6-4E07-8362-BA9C95706545"],
    "Nodes": ["313B01DF-B22F-4D42-B1B8-483CDCF51D35"],
    "View": ["6EFC2DA2-B38C-457E-9ABB-ED2D189B8C38"],
    "Views": ["D6B8C29D-A1FF-4D72-AAB0-E381E9B9338D"],
    "Column": ["FD1C5F63-2B16-4D06-9AB3-F45350B940AB"],
    "Columns": ["383D4D97-FC44-478B-B139-6323DC48611C"],
    "Extensions": ["82DBEA43-8CA4-44BC-A2CA-D18741059EC8"],
    "Extension": ["AD4D6CA6-912F-409B-A26E-7FD234AEF542"],
    "SnapIns": ["2EF3DE1D-B12A-49D1-92C5-0B00798768F1"],
    "SnapIn": ["3BE910F6-3459-49C6-A1BB-41E6BE9DF3EA"],
    "Document": ["225120D6-1E0F-40A3-93FE-1079E6A8017B"],
    "ScopeNamespace": ["EBBB48DC-1A3B-4D86-B786-C21B28389012"],
    "Node": ["F81ED800-7839-4447-945D-8E15DA59CA55"],
    "Frame": ["E5E2D970-5BB3-4306-8804-B0968A31C8E6"],
    "_EventConnector": ["C0BCCD30-DE44-4528-8403-A05A6A1CC8EA"],
    "_AppEvents": ["DE46CBDD-53F5-4635-AF54-4FE71E923D3F"],
    "_Application": ["A3AFB9CC-B653-4741-86AB-F0470EC1384C"],
    "ISnapinPropertiesCallback": ["A50FA2E5-7E61-45EB-A8D4-9A07B3E851A8"],
    "ISnapinProperties": ["F7889DA9-4A02-4837-BF89-1A6F2A021010"],
    "IResultData2": ["0F36E0EB-A7F1-4A81-BE5A-9247F7DE4B1B"],
    "IConsole3": ["4F85EFDB-D0E1-498C-8D4A-D010DFDD404F"],
    "INodeProperties": ["15BC4D24-A522-4406-AA55-0749537A6865"],
    "IConsolePowerSink": ["3333759F-FE4F-4975-B143-FEC0A5DD6D65"],
    "IConsolePower": ["1CFBDD0E-62CA-49CE-A3AF-DBB2DE61B068"],
    "IViewExtensionCallback": ["34DD928A-7599-41E5-9F5E-D6BC3062C2DA"],
    "IExtendView": ["89995CEE-D2ED-4C0E-AE5E-DF7E76F3FA53"],
    "IMMCVersionInfo": ["A8D2C5FE-CDCB-4B9D-BDE5-A27343FF54BC"],
    "IContextMenuCallback2": ["E178BC0E-2ED0-4B5E-8097-42C9087E8B33"],
    "IComponent2": ["79A2D615-4A10-4ED4-8C65-8633F9335095"],
    "IComponentData2": ["CCA0F2D2-82DE-41B5-BF47-3B2076273D5C"],
    "IResultDataCompareEx": ["96933476-0251-11D3-AEB0-00C04F8ECD78"],
    "IMessageView": ["80F94174-FCCC-11D2-B991-00C04F8ECD78"],
    "IColumnData": ["547C1354-024D-11D3-A707-00C04F8EF4CB"],
    "IStringTable": ["DE40B7A4-0F65-11D2-8E25-00C04F8ECD78"],
    "IRequiredExtensions": ["72782D7A-A4A0-11D1-AF0F-00C04FB6DD2C"],
    "IDisplayHelp": ["CC593830-B926-11D1-8063-0000F875A9CE"],
    "IConsole2": ["103D842A-AA63-11D1-A7E1-00C04FD8D565"],
    "IExtendTaskPad": ["8DEE6511-554D-11D1-9FEA-00600832DB4A"],
    "IEnumTASK": ["338698B1-5A02-11D1-9FEC-00600832DB4A"],
    "ISnapinHelp2": ["4861A010-20F9-11D2-A510-00C04FB6DD2C"],
    "IHeaderCtrl2": ["9757ABB8-1B32-11D1-A7CE-00C04FD8D565"],
    "IExtendPropertySheet2": ["B7A87232-4A51-11D1-A7EA-00C04FD909DD"],
    "ISnapinHelp": ["A6B15ACE-DF59-11D0-A7DD-00C04FD909DD"],
    "IMenuButton": ["951ED750-D080-11D0-B197-000000000000"],
    "ISnapinAbout": ["1245208C-A151-11D0-A7D7-00C04FD909DD"],
    "IConsoleVerb": ["E49F7A60-74AF-11D0-A286-00C04FD8FE93"],
    "IToolbar": ["43136EB9-D36C-11CF-ADBC-00AA00A80033"],
    "IExtendControlbar": ["49506520-6F40-11D0-A98B-00C04FD8D565"],
    "IControlbar": ["69FB811E-6C1C-11D0-A2CB-00C04FD909DD"],
    "IExtendPropertySheet": ["85DE64DC-EF21-11CF-A285-00C04FD8DBE6"],
    "IPropertySheetProvider": ["85DE64DE-EF21-11CF-A285-00C04FD8DBE6"],
    "IPropertySheetCallback": ["85DE64DD-EF21-11CF-A285-00C04FD8DBE6"],
    "IConsoleNameSpace2": ["255F18CC-65DB-11D1-A7DC-00C04FD8D565"],
    "IConsoleNameSpace": ["BEDEB620-F24D-11CF-8AFC-00AA003CA9F6"],
    "IResultData": ["31DA5FA0-E0EB-11CF-9F21-00AA003CA9F6"],
    "IExtendContextMenu": ["4F3B7A4F-CFAC-11CF-B8E3-00C04FD8D5B0"],
    "IContextMenuProvider": ["43136EB6-D36C-11CF-ADBC-00AA00A80033"],
    "IContextMenuCallback": ["43136EB7-D36C-11CF-ADBC-00AA00A80033"],
    "IHeaderCtrl": ["43136EB3-D36C-11CF-ADBC-00AA00A80033"],
    "IConsole": ["43136EB1-D36C-11CF-ADBC-00AA00A80033"],
    "IResultOwnerData": ["9CB396D8-EA83-11D0-AEF1-00C04FB6DD2C"],
    "IResultDataCompare": ["E8315A52-7A1A-11D0-A2D2-00C04FD909DD"],
    "IComponent": ["43136EB2-D36C-11CF-ADBC-00AA00A80033"],
    "IComponentData": ["955AB28A-5218-11D0-A985-00C04FD8D565"],
    "IProvideTaskPage": ["4086658A-CBBB-11CF-B604-00C04FD8D565"],
    "ITaskScheduler": ["148BD527-A2AB-11CE-B11F-00AA00530503"],
    "IEnumWorkItems": ["148BD528-A2AB-11CE-B11F-00AA00530503"],
    "ITask": ["148BD524-A2AB-11CE-B11F-00AA00530503"],
    "IScheduledWorkItem": ["A6B952F0-A4B1-11D0-997D-00AA006887EC"],
    "ITaskTrigger": ["148BD52B-A2AB-11CE-B11F-00AA00530503"],
    "IXMLDocumentNotify": ["53BE4F42-3602-11D2-801B-0000F87A6CDF"],
    "IMXNamespaceManager": ["C90352F6-643C-4FBC-BB23-E996EB2D51FD"],
    "IVBMXNamespaceManager": ["C90352F5-643C-4FBC-BB23-E996EB2D51FD"],
    "IMXNamespacePrefixes": ["C90352F4-643C-4FBC-BB23-E996EB2D51FD"],
    "IServerXMLHTTPRequest2": ["2E01311B-C322-4B0A-BD77-B90CFDC8DCE7"],
    "IServerXMLHTTPRequest": ["2E9196BF-13BA-4DD4-91CA-6C571F281495"],
    "IXMLDOMSelection": ["AA634FC7-5888-44A7-A257-3A47150D3A0E"],
    "ISchemaNotation": ["50EA08BE-DD1B-4664-9A50-C2F40F4BD79A"],
    "ISchemaIdentityConstraint": ["50EA08BD-DD1B-4664-9A50-C2F40F4BD79A"],
    "ISchemaAny": ["50EA08BC-DD1B-4664-9A50-C2F40F4BD79A"],
    "ISchemaModelGroup": ["50EA08BB-DD1B-4664-9A50-C2F40F4BD79A"],
    "ISchemaAttributeGroup": ["50EA08BA-DD1B-4664-9A50-C2F40F4BD79A"],
    "ISchemaComplexType": ["50EA08B9-DD1B-4664-9A50-C2F40F4BD79A"],
    "ISchemaType": ["50EA08B8-DD1B-4664-9A50-C2F40F4BD79A"],
    "ISchemaElement": ["50EA08B7-DD1B-4664-9A50-C2F40F4BD79A"],
    "ISchemaAttribute": ["50EA08B6-DD1B-4664-9A50-C2F40F4BD79A"],
    "ISchemaParticle": ["50EA08B5-DD1B-4664-9A50-C2F40F4BD79A"],
    "ISchema": ["50EA08B4-DD1B-4664-9A50-C2F40F4BD79A"],
    "ISchemaItem": ["50EA08B3-DD1B-4664-9A50-C2F40F4BD79A"],
    "ISchemaItemCollection": ["50EA08B2-DD1B-4664-9A50-C2F40F4BD79A"],
    "ISchemaStringCollection": ["50EA08B1-DD1B-4664-9A50-C2F40F4BD79A"],
    "IXMLDOMSchemaCollection2": ["50EA08B0-DD1B-4664-9A50-C2F40F4BD79A"],
    "IMXSchemaDeclHandler": ["FA4BB38C-FAF9-4CCA-9302-D1DD0FE520DB"],
    "IMXReaderControl": ["808F4E35-8D5A-4FBE-8466-33A41279ED30"],
    "IMXAttributes": ["F10D27CC-3EC0-415C-8ED8-77AB1C5E7262"],
    "IMXWriter": ["4D7FF4BA-1565-4EA8-94E1-6E724A46F98D"],
    "IVBSAXAttributes": ["10DC0586-132B-4CAC-8BB3-DB00AC8B7EE0"],
    "IVBSAXDeclHandler": ["E8917260-7579-4BE1-B5DD-7AFBFA6F077B"],
    "IVBSAXLexicalHandler": ["032AAC35-8C0E-4D9D-979F-E3B702935576"],
    "IVBSAXErrorHandler": ["D963D3FE-173C-4862-9095-B92F66995F52"],
    "IVBSAXDTDHandler": ["24FB3297-302D-4620-BA39-3A732D850558"],
    "IVBSAXContentHandler": ["2ED7290A-4DD5-4B46-BB26-4E4155E77FAA"],
    "IVBSAXEntityResolver": ["0C05D096-F45B-4ACA-AD1A-AA0BC25518DC"],
    "IVBSAXLocator": ["796E7AC5-5AA2-4EFF-ACAD-3FAAF01A3288"],
    "IVBSAXXMLFilter": ["1299EB1B-5B88-433E-82DE-82CA75AD4E04"],
    "IVBSAXXMLReader": ["8C033CAA-6CD6-4F73-B728-4531AF74945F"],
    "ISAXAttributes": ["F078ABE1-45D2-4832-91EA-4466CE2F25C9"],
    "ISAXDeclHandler": ["862629AC-771A-47B2-8337-4E6843C1BE90"],
    "ISAXLexicalHandler": ["7F85D5F5-47A8-4497-BDA5-84BA04819EA6"],
    "ISAXErrorHandler": ["A60511C4-CCF5-479E-98A3-DC8DC545B7D0"],
    "ISAXDTDHandler": ["E15C1BAF-AFB3-4D60-8C36-19A8C45DEFED"],
    "ISAXContentHandler": ["1545CDFA-9E4E-4497-A8A4-2BF7D0112C44"],
    "ISAXEntityResolver": ["99BCA7BD-E8C4-4D5F-A0CF-6D907901FF07"],
    "ISAXLocator": ["9B7E472A-0DE4-4640-BFF3-84D38A051C31"],
    "ISAXXMLFilter": ["70409222-CA09-4475-ACB8-40312FE8D145"],
    "ISAXXMLReader": ["A4F96ED0-F829-476E-81C0-CDC7BD2A0802"],
    "IXSLProcessor": ["2933BF92-7B36-11D2-B20E-00C04F983E60"],
    "IXSLTemplate": ["2933BF93-7B36-11D2-B20E-00C04F983E60"],
    "IXMLDOMSchemaCollection": ["373984C8-B845-449B-91E7-45AC83036ADE"],
    "IXMLDOMDocument2": ["2933BF95-7B36-11D2-B20E-00C04F983E60"],
    "IDataSourceListener": ["7C0FFAB2-CD84-11D0-949A-00A0C91110ED"],
    "IDataSource": ["7C0FFAB3-CD84-11D0-949A-00A0C91110ED"],
    "IVBDSC": ["1AB42240-8C70-11CE-9421-00AA0062BE57"],
    "IWiaVideo": ["D52920AA-DB88-41F0-946C-E00DC0A19CFA"],
    "IStiWow64Device": ["E5332A98-80FD-463C-80E4-A8E370752906"],
    "IWiaWow64": ["7BB68E65-F426-4698-A0B7-D2AF28B1BA81"],
    "IWiaItemInternal": ["B884E681-66BA-4014-AFBF-DCB3BEE45FAA"],
    "IStiLockMgr": ["70681EA0-E7BF-4291-9FB1-FE550482AB88"],
    "IWia": ["B10BA1BC-3713-4EC0-8EEA-690EBD2CED8A"],
    "IWiaDeviceInfo": ["5267FF5E-7CAF-4769-865D-17A25968525E"],
    "IWiaDispatchItem": ["D06D503F-4B71-40F3-94A7-66478F732BC9"],
    "ICollection": ["C34C8CE7-B253-4F89-AA25-8A24AD71D0C0"],
    "IWiaDrvItem": ["1F02B5C5-B00C-11D2-A094-00C04F72DC3C"],
    "IWiaMiniDrvCallBack": ["33A57D5A-3DE8-11D2-9A36-00C04FA36145"],
    "IWiaMiniDrv": ["D8CDEE14-3C6C-11D2-9A35-00C04FA36145"],
    "IWiaItemExtras": ["6291EF2C-36EF-4532-876A-8E132593778D"],
    "IWiaNotifyDevMgr": ["70681EA0-E7BF-4291-9FB1-4E8813A3F78E"],
    "IWiaLogEx": ["AF1F22AC-7A40-4787-B421-AEB47A1FBD0B"],
    "IWiaLog": ["A00C10B6-82A1-452F-8B6C-86062AAD6890"],
    "IEnumWIA_FORMAT_INFO": ["81BEFC5B-656D-44F1-B24C-D41D51B4DC81"],
    "IEnumWIA_DEV_CAPS": ["1FCC4287-ACA6-11D2-A093-00C04F72DC3C"],
    "IEnumWiaItem": ["5E8383FC-3391-11D2-9A33-00C04FA36145"],
    "IWiaPropertyStorage": ["98B5E8A0-29CC-491A-AAC0-E6DB4FDCCEB6"],
    "IWiaItem": ["4DB1AD10-3391-11D2-9A33-00C04FA36145"],
    "IWiaDataTransfer": ["A6CEF998-A5B0-11D2-A08F-00C04F72DC3C"],
    "IWiaDataCallback": ["A558A866-A5B0-11D2-A08F-00C04F72DC3C"],
    "IWiaEventCallback": ["AE6287B0-0084-11D2-973B-00A0C9068F2E"],
    "IEnumWIA_DEV_INFO": ["5E38B83C-8CF1-11D1-BF92-0060081ED811"],
    "IWiaDevMgr": ["5EB2502A-8CF1-11D1-BF92-0060081ED811"],
    "IWiaProgressDialog": ["F740718A-E460-4B05-83E8-C5D221C772E5"],
    "IWiaGetImageDlg": ["4F67AD3C-19EA-4CE9-80E2-3ADE50D502A2"],
    "IWiaUIExtension": ["DA319113-50EE-4C80-B460-57D005D44A2C"],
    "IStiDevice": ["6CFA5A80-2DC8-11D0-90EA-00AA0060F86C"],
    "IStillImageA": ["A7B1F740-1D7F-11D1-ACA9-00A02438AD48"],
    "IStillImageW": ["641BD880-2DC8-11D0-90EA-00AA0060F86C"],
    "IViewTransition": ["3050F372-98B5-11CF-BB82-00AA00BDCE0B"],
    "IViewTransitionSite": ["3050F373-98B5-11CF-BB82-00AA00BDCE0B"],
    "IHlinkSite": ["79EAC9C2-BAF9-11CE-8C82-00AA004BA90B"],
    "IHlink": ["79EAC9C3-BAF9-11CE-8C82-00AA004BA90B"],
    "IHlinkTarget": ["79EAC9C4-BAF9-11CE-8C82-00AA004BA90B"],
    "IHlinkFrame": ["79EAC9C5-BAF9-11CE-8C82-00AA004BA90B"],
    "IEnumHLITEM": ["79EAC9C6-BAF9-11CE-8C82-00AA004BA90B"],
    "IHlinkBrowseContext": ["79EAC9C7-BAF9-11CE-8C82-00AA004BA90B"],
    "IExtensionServices": ["79EAC9CB-BAF9-11CE-8C82-00AA004BA90B"],
    "OLEDBSimpleProvider": ["E0E270C0-C0BE-11D0-8FE4-00A0C90A6341"],
    "OLEDBSimpleProviderListener": ["E0E270C1-C0BE-11D0-8FE4-00A0C90A6341"],
    "IPStore": ["5A6F1EC0-2DB1-11D0-8C39-00C04FD9126B"],
    "__PSTORECLib": ["5A6F1EBD-2DB1-11D0-8C39-00C04FD9126B"],
    "IUnknown": ["00000000-0000-0000-C000-000000000046"],
    "DWebBrowserEvents": ["EAB22AC2-30C1-11CF-A7EB-0000C05BAE0B"],
    "DWebBrowserEvents2": ["34A715A0-6587-11D0-924A-0020AFC7AC4D"],
    "DShellWindowsEvents": ["FE4106E0-399A-11D0-A48C-00A0C90A8F39"],
    "DShellFavoritesNameSpaceEvents": ["55136806-B2DE-11D1-B9F2-00A0C98BC547"],
    "DShellFolderViewEvents": ["62112AA2-EBE4-11CF-A5FB-0020AFE7292D"],
    "IBackgroundCopyFile": ["01B7BD23-FB88-4A77-8490-5891D3E4653A"],
    "IEnumBackgroundCopyFiles": ["CA51E165-C365-424C-8D41-24AAA4FF3C40"],
    "IBackgroundCopyError": ["19C613A0-FCB8-4F28-81AE-897C3D078F81"],
    "IBackgroundCopyJob": ["37668D37-507E-4160-9316-26306D150B12"],
    "IEnumBackgroundCopyJobs": ["1AF4F612-3B71-466F-8F58-7B6F73AC57AD"],
    "AsyncIBackgroundCopyCallback": ["CA29D251-B4BB-4679-A3D9-AE8006119D54"],
    "IBackgroundCopyManager": ["5CE34C0D-0DC9-4C1F-897C-DAA1B78CEE7C"],
    "MS_BackgroundCopyQueueManager1_0": ["1DEEB74F-7915-4560-B558-918C83F176A6"],
    "IBackgroundCopyCallback": ["97EA99C7-0186-4AD4-8DF9-C5B4E0ED6B22"],
    "IBackgroundCopyJob2": ["54B50739-686F-45EB-9DFF-D6A9A0FAA9AF"],
    "IBackgroundCopyJob3": ["443C8934-90FF-48ED-BCDE-26F5C7450042"],
    "IBackgroundCopyFile2": ["83E81B93-0873-474D-8A8C-F2018B1A939C"],
    "IOutlookExpress": ["3338DF6A-4660-11D1-8A8D-00C04FB951F3"],
    "IStoreNamespace": ["E70C92AA-4BFD-11D1-8A95-00C04FB951F3"],
    "IStoreFolder": ["E70C92AC-4BFD-11D1-8A95-00C04FB951F3"],
    "IUserIdentity": ["A9AE6C8E-1D1B-11D2-B21A-00C04FA357FA"],
    "IEnumUserIdentity": ["A9AE6C8F-1D1B-11D2-B21A-00C04FA357FA"],
    "IUserIdentityManager": ["A9AE6C90-1D1B-11D2-B21A-00C04FA357FA"],
    "IIdentityChangeNotify": ["A9AE6C92-1D1B-11D2-B21A-00C04FA357FA"],
    "IPrivateIdentityManager": ["A9AE6C93-1D1B-11D2-B21A-00C04FA357FA"],
    "IPrivateIdentityManager2": ["15E84C92-2E4D-11D3-9C92-00104B35E7F9"],
    "IUserIdentity2": ["A9AE6C94-1D1B-11D2-B21A-00C04FA357FA"],
    "IEnumPStoreProviders": ["5A6F1EBF-2DB1-11D0-8C39-00C04FD9126B"],
    "IEnumPStoreTypes": ["789C1CBF-31EE-11D0-8C39-00C04FD9126B"],
    "IEnumPStoreItems": ["5A6F1EC1-2DB1-11D0-8C39-00C04FD9126B"],
    "IEnumPStoreProviders_Default": ["5A6F1EC3-2DB1-11D0-8C39-00C04FD9126B"],
    "IEnumPStoreTypes_Default": ["09BB61E7-31EC-11D0-8C39-00C04FD9126B"],
    "IEnumPStoreItems_Default": ["09BB61E6-31EC-11D0-8C39-00C04FD9126B"],
    "HTMLStyle": ["3050F55A-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLRuleStyle": ["3050F55C-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLRenderStyle": ["3050F58B-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLCurrentStyle": ["3050F557-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLDOMAttribute": ["3050F564-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLDOMTextNode": ["3050F565-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLDOMImplementation": ["3050F58F-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLAttributeCollection": ["3050F56C-98B5-11CF-BB82-00AA00BDCE0B"],
    "DOMChildrenCollection": ["3050F577-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLElementEvents2": ["3050F60F-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLElementEvents": ["3050F33C-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLDefaults": ["3050F58C-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTCDefaultatch": ["3050F573-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTCPropertyBehavior": ["3050F57F-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTCMethodBehavior": ["3050F587-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTCEventBehavior": ["3050F574-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTCAttachBehavior": ["3050F583-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTCDescBehavior": ["3050F57E-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLGenericElement": ["3050F563-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLStyleSheet": ["3050F58D-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLLinkElementEvents2": ["3050F61D-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLLinkElementEvents": ["3050F3CC-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLLinkElement": ["3050F524-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLFormElementEvents2": ["3050F614-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLFormElementEvents": ["3050F364-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLFormElement": ["3050F510-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLControlElementEvents2": ["3050F612-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLControlElementEvents": ["3050F4EA-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLTextElement": ["3050F537-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLTextContainerEvents2": ["3050F624-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLTextContainerEvents": ["1FF6AA72-5842-11CF-A707-00AA00C0098D"],
    "HTMLImgEvents2": ["3050F616-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLImgEvents": ["3050F25B-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLImg": ["3050F51C-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLBody": ["3050F507-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLFontElement": ["3050F512-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLAnchorEvents2": ["3050F610-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLAnchorEvents": ["3050F29D-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLAnchorElement": ["3050F502-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLLabelEvents2": ["3050F61C-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLLabelEvents": ["3050F329-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLLabelElement": ["3050F522-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLListElement": ["3050F525-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLUListElement": ["3050F538-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLOListElement": ["3050F52A-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLLIElement": ["3050F523-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLBlockElement": ["3050F506-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLDivElement": ["3050F50C-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLDDElement": ["3050F50B-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLDTElement": ["3050F50D-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLBRElement": ["3050F53A-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLDListElement": ["3050F53B-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLHRElement": ["3050F53D-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLParaElement": ["3050F52C-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLElementCollection": ["3050F56B-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLHeaderElement": ["3050F515-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLSelectElementEvents2": ["3050F622-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLSelectElementEvents": ["3050F302-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLSelectElement": ["3050F531-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLOptionElement": ["3050F52B-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLButtonElementEvents2": ["3050F617-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLButtonElementEvents": ["3050F2B3-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLInputTextElementEvents2": ["3050F618-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLOptionButtonElementEvents2": ["3050F619-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLInputFileElementEvents2": ["3050F61A-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLInputImageEvents2": ["3050F61B-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLInputTextElementEvents": ["3050F2A7-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLOptionButtonElementEvents": ["3050F2BD-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLInputFileElementEvents": ["3050F2AF-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLInputImageEvents": ["3050F2C3-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLInputElement": ["3050F57D-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLTextAreaElement": ["3050F521-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLRichtextElement": ["3050F54D-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLButtonElement": ["3050F51F-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLMarqueeElementEvents2": ["3050F61F-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLMarqueeElementEvents": ["3050F2B8-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLMarqueeElement": ["3050F527-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLHtmlElement": ["3050F560-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLHeadElement": ["3050F561-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLTitleElement": ["3050F516-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLMetaElement": ["3050F517-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLBaseElement": ["3050F518-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLIsIndexElement": ["3050F519-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLNextIdElement": ["3050F51A-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLBaseFontElement": ["3050F504-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLUnknownElement": ["3050F539-98B5-11CF-BB82-00AA00BDCE0B"],
    "CEventObj": ["3050F558-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLWindowEvents2": ["3050F625-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLWindowEvents": ["96A0A4E0-D062-11CF-94B6-00AA0060275C"],
    "HTMLScreen": ["3050F591-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLWindow2": ["3050F55D-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLWindowProxy": ["3050F55E-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLDocumentEvents2": ["3050F613-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLDocumentEvents": ["3050F260-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLDocument": ["3050F55F-98B5-11CF-BB82-00AA00BDCE0B"],
    "DWebBridgeEvents": ["A6D897FF-0A95-11D1-B0BA-006008166E11"],
    "IWebBridge_Default": ["AE24FDAE-03C6-11D1-8B76-0080C744F389"],
    "HTMLEmbed": ["3050F52E-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLMapEvents2": ["3050F61E-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLMapEvents": ["3050F3BA-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLAreasCollection": ["3050F56A-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLMapElement": ["3050F526-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLAreaEvents2": ["3050F611-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLAreaEvents": ["3050F366-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLAreaElement": ["3050F503-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLTableCaption": ["3050F508-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLCommentElement": ["3050F50A-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLPhraseElement": ["3050F52D-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLSpanElement": ["3050F548-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLTableEvents2": ["3050F623-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLTableEvents": ["3050F407-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLTable": ["3050F532-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLTableCol": ["3050F533-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLTableSection": ["3050F534-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLTableRow": ["3050F535-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLTableCell": ["3050F536-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLScriptEvents2": ["3050F621-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLScriptEvents": ["3050F3E2-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLScriptElement": ["3050F530-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLNoShowElement": ["3050F528-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLObjectElementEvents2": ["3050F620-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLObjectElementEvents": ["3050F3C4-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLObjectElement": ["3050F529-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLParamElement": ["3050F590-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLFrameSiteEvents": ["3050F800-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLFrameBase": ["3050F541-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLFrameElement": ["3050F513-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLIFrame": ["3050F51B-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLDivPosition": ["3050F50F-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLFieldSetElement": ["3050F545-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLLegendElement": ["3050F546-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLSpanFlow": ["3050F544-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLFrameSetSite": ["3050F514-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLBGsound": ["3050F53C-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLStyleElementEvents2": ["3050F615-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLStyleElementEvents": ["3050F3CB-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLStyleElement": ["3050F511-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLNamespaceEvents": ["3050F6BD-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLPopup": ["3050F589-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLAppBehavior": ["3050F57C-98B5-11CF-BB82-00AA00BDCE0B"],
    "WinHttpRequest_component": ["2087C2F4-2CEF-4953-A8AB-66779B670495"],
    "IMailMsgNotify": ["0F7C3C30-A8AD-11D1-AA91-00AA006BC80B"],
    "IMailMsgPropertyStream": ["A44819C0-A7CF-11D1-AA91-00AA006BC80B"],
    "IMailMsgRecipientsBase": ["D1A97920-A891-11D1-AA91-00AA006BC80B"],
    "IMailMsgRecipientsAdd": ["4C28A700-A892-11D1-AA91-00AA006BC80B"],
    "IMailMsgRecipients": ["19507FE0-A892-11D1-AA91-00AA006BC80B"],
    "IMailMsgProperties": ["AB95FB40-A34F-11D1-AA8A-00AA006BC80B"],
    "IMailMsgCommit": ["02B80EDB-6D5A-4D05-950A-237811F8D412"],
    "IMailMsgValidate": ["6717B03C-072C-11D3-94FF-00C04FA379F1"],
    "IMailMsgValidateContext": ["60A482B1-B311-4ECA-A3A3-907F9DAFD16F"],
    "IMailMsgPropertyManagement": ["A2F196C0-A351-11D1-AA8A-00AA006BC80B"],
    "IMailMsgEnumMessages": ["E760A840-C8F1-11D1-9FF2-00C04FA37348"],
    "IMailMsgStoreDriver": ["246AAE60-ACC4-11D1-AA91-00AA006BC80B"],
    "IMailMsgQueueMgmt": ["B2564D0A-D5A1-11D1-9FF7-00C04FA37348"],
    "ISMTPStoreDriver": ["EE51588C-D64A-11D1-9FF7-00C04FA37348"],
    "IMailMsgStoreDriverValidateContext": ["C6742794-AD31-4711-BE73-9869142A8A23"],
    "IMailMsgBind": ["38CB448A-CA62-11D1-9FF3-00C04FA37348"],
    "IMailMsgPropertyBag": ["D6D0509C-EC51-11D1-AA65-00C04FA35B82"],
    "IMailMsgLoggingPropertyBag": ["4CB17416-EC53-11D1-AA65-00C04FA35B82"],
    "IMailMsgCleanupCallback": ["951C04A1-29F0-4B8E-9ED5-836C73766051"],
    "IMailMsgRegisterCleanupCallback": ["00561C2F-5E90-49E5-9E73-7BF9129298A0"],
    "ISMTPServer": ["22625594-D822-11D1-9FF7-00C04FA37348"],
    "ISMTPServerEx": ["52AE6373-90F6-470C-9D38-526E9060B07D"],
    "ISMTPServerAsync": ["08AF2A87-8C10-4196-9AE6-D517A86B9795"],
    "ISMTPServerGetAuxDomainInfoFlags": ["735E9929-1885-4736-8D07-492F962ECEB9"],
    "ISMTPServerInternal": ["57EE6C15-1870-11D2-A689-00C04FA3490A"],
    "IMimeInternational": ["C5588349-7F86-11D0-8252-00C04FD85AB4"],
    "IMimeSecurity": ["C5588353-7F86-11D0-8252-00C04FD85AB4"],
    "IMimeHeaderTable": ["FD853CD1-7F86-11D0-8252-00C04FD85AB4"],
    "IMimePropertySchema": ["FD853CEC-7F86-11D0-8252-00C04FD85AB4"],
    "IMimePropertySet": ["FD853CD3-7F86-11D0-8252-00C04FD85AB4"],
    "IMimeAddressTable": ["C558834A-7F86-11D0-8252-00C04FD85AB4"],
    "IMimeWebDocument": ["EE519F11-851A-11D0-825C-00C04FD85AB4"],
    "IMimeBody": ["C558834C-7F86-11D0-8252-00C04FD85AB4"],
    "IMimeMessageTree": ["FD853CD4-7F86-11D0-8252-00C04FD85AB4"],
    "IMimeMessage": ["FD853CD5-7F86-11D0-8252-00C04FD85AB4"],
    "IMimeMessageCallback": ["761AA641-7BDA-11D1-8AA9-00C04FB951F3"],
    "IPersistMime": ["DE4AD8DA-555F-11D1-8DD0-00C04FB951F9"],
    "IMimeMessageParts": ["C558834F-7F86-11D0-8252-00C04FD85AB4"],
    "IMimeEnumHeaderRows": ["C558834D-7F86-11D0-8252-00C04FD85AB4"],
    "IMimeEnumProperties": ["FD853CEE-7F86-11D0-8252-00C04FD85AB4"],
    "IMimeEnumAddressTypes": ["C5588354-7F86-11D0-8252-00C04FD85AB4"],
    "IMimeEnumMessageParts": ["C5588350-7F86-11D0-8252-00C04FD85AB4"],
    "IHashTable": ["64577981-86D7-11D1-BDFC-00C04FA31009"],
    "IMimeAllocator": ["C5588351-7F86-11D0-8252-00C04FD85AB4"],
    "IMimeObjResolver": ["FECEAFFD-C441-11D1-960E-00C04FBD7C09"],
    "IFontCache": ["B0D17FC2-7BC4-11D1-BDFA-00C04FA31009"],
    "IFontCacheNotify": ["B0D17FC5-7BC4-11D1-BDFA-00C04FA31009"],
    "IMimeEditTag": ["70183210-7B36-11D2-8C12-00C04FA31009"],
    "IMimeEditTagCollection": ["D09EE528-7B38-11D2-8C12-00C04FA31009"],
    "INetFwRemoteAdminSettings": ["D4BECDDF-6F73-4A83-B832-9C66874CD20E"],
    "INetFwIcmpSettings": ["A6207B2E-7CDD-426A-951E-5E1CBC5AFEAD"],
    "INetFwOpenPort": ["E0483BA0-47FF-4D9C-A6D6-7741D0B195F7"],
    "INetFwOpenPorts": ["C0E9D7FA-E07E-430A-B19A-090CE82D92E2"],
    "INetFwService": ["79FD57C8-908E-4A36-9888-D5B3F0A444CF"],
    "INetFwServices": ["79649BB4-903E-421B-94C9-79848E79F6EE"],
    "INetFwAuthorizedApplication": ["B5E64FFA-C2C5-444E-A301-FB5E00018050"],
    "INetFwAuthorizedApplications": ["644EFD52-CCF9-486C-97A2-39F352570B30"],
    "INetFwProfile": ["174A0DDA-E9F9-449D-993B-21AB667CA456"],
    "INetFwPolicy": ["D46D2478-9AC9-4008-9DC7-5563CE5536CC"],
    "INetFwMgr": ["F7898AF5-CAC4-4632-A2EC-DA06E5111AF2"],
    "INetFwOpenPort_Default": ["0CA545C6-37AD-4A6C-BF92-9F7610067EF5"],
    "INetFwAuthorizedApplication_Default": ["EC9846B3-2762-4A6B-A214-6ACB603462D2"],
    "INetFwMgr_Default": ["304CE942-6E39-40D8-943A-B913C40C9CD4"],
    "ISmtpInCommandContext": ["5F15C533-E90E-11D1-8852-00C04FA35B86"],
    "ISmtpInCallbackContext": ["5E4FC9DA-3E3B-11D3-88F1-00C04FA35B86"],
    "ISmtpOutCommandContext": ["C849B5F2-0A80-11D2-AA67-00C04FA35B82"],
    "ISmtpServerResponseContext": ["E38F9AD2-0A82-11D2-AA67-00C04FA35B82"],
    "ISmtpInCommandSink": ["B2D42A0E-0D5F-11D2-AA68-00C04FA35B82"],
    "ISmtpOutCommandSink": ["CFDBB9B0-0CA0-11D2-AA68-00C04FA35B82"],
    "ISmtpServerResponseSink": ["D7E10222-0CA1-11D2-AA68-00C04FA35B82"],
    "ISmtpInCallbackSink": ["0012B624-3E3C-11D3-88F1-00C04FA35B86"],
    "IMailTransportNotify": ["6E1CAA77-FCD4-11D1-9DF9-00C04FA322BA"],
    "IMailTransportSubmission": ["CE681916-FF14-11D1-9DFB-00C04FA322BA"],
    "IMailTransportOnPreCategorize": ["A3ACFB0E-83FF-11D2-9E14-00C04FA322BA"],
    "IMailTransportOnPostCategorize": ["76719653-05A6-11D2-9DFD-00C04FA322BA"],
    "IMailTransportRouterReset": ["A928AD12-1610-11D2-9E02-00C04FA322BA"],
    "IMailTransportSetRouterReset": ["A928AD11-1610-11D2-9E02-00C04FA322BA"],
    "IMessageRouter": ["A928AD14-1610-11D2-9E02-00C04FA322BA"],
    "IMailTransportRouterSetLinkState": ["B870CE28-A755-11D2-A6A9-00C04FA3490A"],
    "IMessageRouterLinkStateNotification": ["B870CE29-A755-11D2-A6A9-00C04FA3490A"],
    "IMailTransportRoutingEngine": ["A928AD13-1610-11D2-9E02-00C04FA322BA"],
    "IMsgTrackLog": ["1BC3580E-7E4F-11D2-94F4-00C04F79F1D6"],
    "IDnsResolverRecord": ["E5B89C52-8E0B-11D2-94F6-00C04F79F1D6"],
    "IDnsInfoSink": ["6A417A4C-27BA-4867-A286-83E332074558"],
    "IDnsStatus": ["4E60BFAD-A179-47AC-8961-C7C1F0785AC1"],
    "IDnsResolverRecordSink": ["D95A4D0C-8E06-11D2-94F6-00C04F79F1D6"],
    "ISmtpMaxMsgSize": ["B997F192-A67D-11D2-94F7-00C04F79F1D6"],
    "ISmtpLog": ["35BC9AD7-7AA5-43EE-A0AB-94E1D6BE99E5"],
    "ISmtpGetAuxDomainInfoFlags": ["D038C9DA-4977-491D-8B0E-97F2E546C35A"],
    "ICategorizerProperties": ["96BF3199-79D8-11D2-9E11-00C04FA322BA"],
    "ICategorizerParameters": ["86F9DA7B-EB6E-11D1-9DF3-00C04FA322BA"],
    "ICategorizerQueries": ["86F9DA7D-EB6E-11D1-9DF3-00C04FA322BA"],
    "ICategorizerMailMsgs": ["86F9DA80-EB6E-11D1-9DF3-00C04FA322BA"],
    "ICategorizerItemAttributes": ["86F9DA7F-EB6E-11D1-9DF3-00C04FA322BA"],
    "ICategorizerItemRawAttributes": ["34C3D389-8FA7-11D2-9E16-00C04FA322BA"],
    "ICategorizerItem": ["86F9DA7C-EB6E-11D1-9DF3-00C04FA322BA"],
    "ICategorizerAsyncCompletion": ["86F9DA7E-EB6E-11D1-9DF3-00C04FA322BA"],
    "ICategorizerListResolve": ["960252A4-0A3A-11D2-9E00-00C04FA322BA"],
    "IMailTransportCategorize": ["86F9DA7A-EB6E-11D1-9DF3-00C04FA322BA"],
    "ISMTPCategorizer": ["B23C35B8-9219-11D2-9E17-00C04FA322BA"],
    "ISMTPCategorizerCompletion": ["B23C35B9-9219-11D2-9E17-00C04FA322BA"],
    "ISMTPCategorizerDLCompletion": ["B23C35BA-9219-11D2-9E17-00C04FA322BA"],
    "ICategorizerDomainInfo": ["E210EDC6-F27D-481F-9DFC-1CA840905FD9"],
    "ICategorizerParametersEx": ["E962BA1F-3FB9-11D3-80D7-00C04FA322BA"],
    "ICategorizerRequestedAttributes": ["CB0924E0-357B-11D3-8328-00C04FA322BA"],
    "ICategorizerUTF8Attributes": ["BEBF931D-17E0-4EC8-BC1C-CC3286D72CB7"],
    "ICategorizerLdapConfig": ["27C1B2D3-1A28-4B90-BC0A-E52057D30712"],
    "IServersListInfo": ["C54CEA94-E501-4F34-8704-F5881EA5CBF4"],
    "IDSNGenerationSink": ["3A513AB9-339D-4589-A137-D54C5F520E6F"],
    "IDSNRecipientIterator": ["1D45C98A-56A0-4FE8-BF33-8986EEB85B63"],
    "IDSNSubmission": ["C016B75D-CE65-496F-A2C9-B487C83C0F6B"],
    "ATLVer30": ["B62F5910-6528-11D1-9611-0000F81E0D0D"],
    "ImageFormatBMP": ["B96B3CAB-0728-11D3-9D7B-0000F81EF32E"],
    "ImageFormatEMF": ["B96B3CAC-0728-11D3-9D7B-0000F81EF32E"],
    "ImageFormatEXIF": ["B96B3CB2-0728-11D3-9D7B-0000F81EF32E"],
    "ImageFormatGIF": ["B96B3CB0-0728-11D3-9D7B-0000F81EF32E"],
    "ImageFormatIcon": ["B96B3CB5-0728-11D3-9D7B-0000F81EF32E"],
    "ImageFormatJPEG": ["B96B3CAE-0728-11D3-9D7B-0000F81EF32E"],
    "ImageFormatPNG": ["B96B3CAF-0728-11D3-9D7B-0000F81EF32E"],
    "ImageFormatTIFF": ["B96B3CB1-0728-11D3-9D7B-0000F81EF32E"],
    "ImageFormatUndefined": ["B96B3CA9-0728-11D3-9D7B-0000F81EF32E"],
    "ImageFormatWMF": ["B96B3CAD-0728-11D3-9D7B-0000F81EF32E"],
    "FrameDimensionPage": ["7462DC86-6180-4C7E-8E3F-EE7333A7A483"],
    "FrameDimensionResolution": ["84236F7B-3BD3-428F-8DAB-4EA1439CA315"],
    "FrameDimensionTime": ["6AEDBD6D-3FB5-418A-83A6-7F45229DC872"],
    "EncoderChrominanceTable": ["F2E455DC-09B3-4316-8260-676ADA32481C"],
    "EncoderColorDepth": ["66087055-AD66-4C7C-9A18-38A2310B8337"],
    "EncoderCompression": ["E09D739D-CCD4-44EE-8EBA-3FBF8BE4FC58"],
    "EncoderLuminanceTable": ["EDB33BCE-0266-4A77-B904-27216099E717"],
    "EncoderQuality": ["1D5BE4B5-FA4A-452D-9CDD-5DB35105E7EB"],
    "EncoderRenderMethod": ["6D42C53A-229A-4825-8BB7-5C99E2B9A8B8"],
    "EncoderSaveFlag": ["292266FC-AC40-47BF-8CFC-A85B89A655DE"],
    "EncoderScanMethod": ["3A4E2661-3109-4E56-8536-42C156E7DCFA"],
    "EncoderTransformation": ["8D0EB2D1-A58E-4EA8-AA14-108074B7B6F9"],
    "EncoderVersion": ["24D18C76-814A-41A4-BF53-1C219CCCF797"],
    "Shell32": ["50A7E9B0-70EF-11D1-B75A-00A0C90564FE"],
    "SearchCommandExecuteErrors": ["418F4E6A-B903-11D1-B0A6-00C04FC33AA5"],
    "Folder2OfflineStatusConstants": ["35F1A0D0-3E9A-11D2-8499-005345000000"],
    "ViewOptionsConstants": ["742A99A0-C77E-11D0-A32C-00A0C91EEDBA"],
    "SpecialFoldersForOpenExploreConstants": ["CA31EA20-48D0-11CF-8350-444553540000"],
    "DSearchCommandEvents": ["60890160-69F0-11D1-B758-00A0C90564FE"],
    "StmOCX_Main_RE": ["7A0D1738-10EA-47FF-92BE-4E137B5BE1A4"],
    "StmOCX_TypeLib_RE": ["0AB6D809-3081-494F-BD93-D58F480BF0E3"],
    "StmOCX_Catagory1_RE": ["7DD95801-9882-11CF-9FA9-00AA006C42C4"],
    "StmOCX_Catagory2_RE": ["7DD95802-9882-11CF-9FA9-00AA006C42C4"],
    "StmOCX_3_Unknown_RE": ["4D418083-A65A-744B-93EB-855D7361E6B4"],
    "StmOCX_3_Crypted00_RE": ["EA4F5CEC-BC42-4B64-8B18-EFFC62ADDA31"],
    "ICaptureGraphBuilder2": ["93E5A4E0-2D50-11D2-ABFA-00A0C9C6E38D"],
    "FIAsyncOperationCompletedHandler_1_ContentManagement__CTargetedContent__CTargetedContentCollection": [
        "e1e99453-1a6e-58f5-8356-8e24ba4a0d4d",
        "e1e99453-1a6e-58f5-8356-8e24ba4a0d4d",
    ],
    "FIAsyncOperationCompletedHandler_1_ContentManagement__CTargetedContent__CTargetedContentSubscription": [
        "3bcc47af-6708-5acd-81af-fa7331aa2db1",
        "3bcc47af-6708-5acd-81af-fa7331aa2db1",
    ],
    "FIAsyncOperationCompletedHandler_1_DevicesFlowInteraction__CConnection__CIDeviceConnection": [
        "701ebb34-0bd0-5456-848e-5ed7cec441ef",
        "701ebb34-0bd0-5456-848e-5ed7cec441ef",
    ],
    "FIAsyncOperationCompletedHandler_1_PhoneInternal__CExperiences__CSync__CAccount": [
        "8142b78c-3c08-53fe-a74e-506063c49063",
        "8142b78c-3c08-53fe-a74e-506063c49063",
    ],
    "FIAsyncOperationCompletedHandler_1_PhoneInternal__CExperiences__CSync__CAccountErrorInformation": [
        "826bd12f-c1bb-5730-bf72-05db739871ae",
        "826bd12f-c1bb-5730-bf72-05db739871ae",
    ],
    "FIAsyncOperationCompletedHandler_1_PhoneInternal__CExperiences__CSync__CAccountStatus": [
        "62e9e23a-de30-5736-b0e5-9e9925442328",
        "62e9e23a-de30-5736-b0e5-9e9925442328",
    ],
    "FIAsyncOperationCompletedHandler_1_PhoneInternal__CExperiences__CSync__CAccountSyncScheduleInformation": [
        "c1f995d7-c911-57c7-99e0-38239f48cfe1",
        "c1f995d7-c911-57c7-99e0-38239f48cfe1",
    ],
    "FIAsyncOperationCompletedHandler_1_PhoneInternal__CExperiences__CSync__CExchangeServerAuthType": [
        "c9ac0b4c-9912-55ed-8f96-faad2f45e449",
        "c9ac0b4c-9912-55ed-8f96-faad2f45e449",
    ],
    "FIAsyncOperationCompletedHandler_1_PhoneInternal__CExperiences__CSync__CExchangeServerDiscoveryResult": [
        "e31b75bd-8a80-535d-a873-23586e84bdc5",
        "e31b75bd-8a80-535d-a873-23586e84bdc5",
    ],
    "FIAsyncOperationCompletedHandler_1_PhoneInternal__CExperiences__CSync__CInternetMailServerDiscoveryResult": [
        "cc8015c0-c914-55a3-add6-7b1982ced2dd",
        "cc8015c0-c914-55a3-add6-7b1982ced2dd",
    ],
    "FIAsyncOperationCompletedHandler_1_Windows__CApplicationModel__CCalls__CPhoneCallStore": [
        "27b63bb3-d008-58f5-854d-ddae65a020b9",
        "27b63bb3-d008-58f5-854d-ddae65a020b9",
    ],
    "FIAsyncOperationCompletedHandler_1_Windows__CApplicationModel__CCalls__CPhoneCallVideoCapabilities": [
        "e50fc826-3ef3-5669-aa14-eb95903793a5",
        "e50fc826-3ef3-5669-aa14-eb95903793a5",
    ],
    "FIAsyncOperationCompletedHandler_1_Windows__CApplicationModel__CCalls__CPhoneLine": [
        "92ce5bfd-1417-55ee-b0b6-298ae78cb179",
        "92ce5bfd-1417-55ee-b0b6-298ae78cb179",
    ],
    "FIAsyncOperationCompletedHandler_1_Windows__CApplicationModel__CContracts__CInternal__CBackgroundContractLaunchStatus": [
        "3d67f8bf-29cf-5d83-a70e-ef257bdcfdb6",
        "3d67f8bf-29cf-5d83-a70e-ef257bdcfdb6",
    ],
    "FIAsyncOperationCompletedHandler_1_Windows__CApplicationModel__CContracts__CInternal__CIBackgroundContractOperation": [
        "e21c6105-2667-5229-a682-83e4e8ea0c3a",
        "e21c6105-2667-5229-a682-83e4e8ea0c3a",
    ],
    "FIAsyncOperationCompletedHandler_1_Windows__CApplicationModel__CContracts__CInternal__CICdpLaunchResult": [
        "bbf0f7ce-56fb-521e-95ee-e5c557c1cbe4",
        "bbf0f7ce-56fb-521e-95ee-e5c557c1cbe4",
    ],
    "FIAsyncOperationCompletedHandler_1_Windows__CApplicationModel__CInternal__CDataTransfer__CDataRequestResult": [
        "62279b47-d495-5eff-983f-62c89c22ef4d",
        "62279b47-d495-5eff-983f-62c89c22ef4d",
    ],
    "FIAsyncOperationCompletedHandler_1_Windows__CApplicationModel__CInternal__CStartupTaskInternal": [
        "1b56d989-5d74-5b59-b109-9bdf26c38726",
        "1b56d989-5d74-5b59-b109-9bdf26c38726",
    ],
    "FIAsyncOperationCompletedHandler_1_Windows__CApplicationModel__CUserActivities__CUserActivity": [
        "a337dbef-620a-5bdc-843b-b50b38d3d00c",
        "a337dbef-620a-5bdc-843b-b50b38d3d00c",
    ],
    "FIAsyncOperationCompletedHandler_1_Windows__CInternal__CBackupRestore__CSettingsProviders__CBackupProviderStatus": [
        "296d91bc-848c-5b4d-97b0-6a97f24fe995",
        "296d91bc-848c-5b4d-97b0-6a97f24fe995",
    ],
    "FIAsyncOperationCompletedHandler_1_Windows__CInternal__CBackupRestore__CSettingsProviders__CBackupScopeStatus": [
        "49128036-7a26-55df-a220-ff97a1d1399a",
        "49128036-7a26-55df-a220-ff97a1d1399a",
    ],
    "FIAsyncOperationCompletedHandler_1_Windows__CInternal__CBackupRestore__CSettingsProviders__CBackupTargetStatus": [
        "062eec43-84ad-5290-af7a-3191dd58d52b",
        "062eec43-84ad-5290-af7a-3191dd58d52b",
    ],
    "FIAsyncOperationCompletedHandler_1_Windows__CInternal__CBackupRestore__CSettingsProviders__CBackupTargetValidationResult": [
        "c88957a0-4f7e-5152-b87e-322d7078aacd",
        "c88957a0-4f7e-5152-b87e-322d7078aacd",
    ],
    "FIAsyncOperationCompletedHandler_1_Windows__CInternal__CSecurity__CAuthentication__CWeb__CGetDefaultSignInAccountResult": [
        "51aa6c40-b054-5c68-801e-03b75f43e2a1",
        "51aa6c40-b054-5c68-801e-03b75f43e2a1",
    ],
    "FIAsyncOperationCompletedHandler_1_Windows__CInternal__CSecurity__CAuthentication__CWeb__CHttpCookieRequestResult": [
        "662e4720-ef23-589c-b21d-13e9e6fbab02",
        "662e4720-ef23-589c-b21d-13e9e6fbab02",
    ],
    "FIAsyncOperationCompletedHandler_1_Windows__CInternal__CSecurity__CSmartScreen__CAppReputationResult": [
        "1b988c32-1bc7-52fa-83ba-0b97e79c878b",
        "1b988c32-1bc7-52fa-83ba-0b97e79c878b",
    ],
    "FIAsyncOperationCompletedHandler_1_Windows__CInternal__CSecurity__CSmartScreen__CDownload__CDownloadReputationResult": [
        "4356f0fa-6153-5186-92ca-2e913fd15193",
        "4356f0fa-6153-5186-92ca-2e913fd15193",
    ],
    "FIAsyncOperationCompletedHandler_1_Windows__CInternal__CSecurity__CSmartScreen__CDownload__CFileReputationResult": [
        "e406ebb7-b140-562f-bcbc-40f0ef479d38",
        "e406ebb7-b140-562f-bcbc-40f0ef479d38",
    ],
    "FIAsyncOperationCompletedHandler_1_Windows__CInternal__CSecurity__CSmartScreen__CUriReputationResult": [
        "d164f201-3f19-588a-a21e-06c60651d335",
        "d164f201-3f19-588a-a21e-06c60651d335",
    ],
    "FIAsyncOperationCompletedHandler_1_Windows__CInternal__CSettingSync__CSettingSyncResult": [
        "d8cb7b5c-277a-5e63-894f-c03abbab9dad",
        "d8cb7b5c-277a-5e63-894f-c03abbab9dad",
    ],
    "FIAsyncOperationCompletedHandler_1_Windows__CInternal__CShell__CViewManagerInterop__CAppRequestHandledResult": [
        "10e84b15-acbe-5d0c-b7e4-204bf733bbe5",
        "10e84b15-acbe-5d0c-b7e4-204bf733bbe5",
    ],
    "FIAsyncOperationCompletedHandler_1_Windows__CSystem__CInternal__CSetUserAutologonResult": [
        "ecb07d05-745b-5c70-9417-78db4d11d050",
        "ecb07d05-745b-5c70-9417-78db4d11d050",
    ],
    "FIAsyncOperationCompletedHandler_1_Windows__CSystem__CInternal__CSignInResult": [
        "0b93f10e-773f-52b6-b46d-063534f2107b",
        "0b93f10e-773f-52b6-b46d-063534f2107b",
    ],
    "FIAsyncOperationCompletedHandler_1_Windows__CSystem__CInternal__CValidateCredentialsResult": [
        "880ebaee-3e15-5419-86de-e79f492f06ed",
        "880ebaee-3e15-5419-86de-e79f492f06ed",
    ],
    "FIAsyncOperationCompletedHandler_1___FIIterable_1_Windows__CInternal__CSettingSync__CICollectionBackup": [
        "8f668cb2-0e8c-56be-ab8c-3cc898aa4fea",
        "8f668cb2-0e8c-56be-ab8c-3cc898aa4fea",
    ],
    "FIAsyncOperationCompletedHandler_1___FIIterator_1_Windows__CInternal__CBackupRestore__CSettingsProviders__CIBackupTargetItem": [
        "b8d5af86-9a98-570f-a9c1-5c3ce0a62920",
        "b8d5af86-9a98-570f-a9c1-5c3ce0a62920",
    ],
    "FIAsyncOperationCompletedHandler_1___FIMapView_2_HSTRING_Windows__CMedia__CSpeechRecognition__CVoiceCommandSet": [
        "cab62352-dce4-5633-99ba-cc8a0d3ea9b8",
        "cab62352-dce4-5633-99ba-cc8a0d3ea9b8",
    ],
    "FIAsyncOperationCompletedHandler_1___FIVectorView_1_SharingPlatform__CISessionIdentifier": [
        "c37f57e5-31b8-5293-8a44-b7a17f544768",
        "c37f57e5-31b8-5293-8a44-b7a17f544768",
    ],
    "FIAsyncOperationCompletedHandler_1___FIVectorView_1_Windows__CApplicationModel__CDataTransfer__CShareProvider": [
        "4d98e785-8d94-5d86-a6cf-2cb56576c806",
        "4d98e785-8d94-5d86-a6cf-2cb56576c806",
    ],
    "FIAsyncOperationCompletedHandler_1___FIVectorView_1_Windows__CApplicationModel__CInternal__CDataTransfer__CShareAppExtension": [
        "f7f52561-574b-5514-96a1-024813e859a5",
        "f7f52561-574b-5514-96a1-024813e859a5",
    ],
    "FIAsyncOperationCompletedHandler_1___FIVectorView_1_Windows__CApplicationModel__CInternal__CStartupTaskInternal": [
        "f771cc67-0856-5efd-ac6f-37b6e05c63e2",
        "f771cc67-0856-5efd-ac6f-37b6e05c63e2",
    ],
    "FIAsyncOperationCompletedHandler_1___FIVectorView_1_Windows__CInternal__CApplicationModel__CWindowManagement__CAppView": [
        "98d53db6-a4c4-5a86-8c0c-3d2cd51c75a8",
        "98d53db6-a4c4-5a86-8c0c-3d2cd51c75a8",
    ],
    "FIAsyncOperationCompletedHandler_1___FIVectorView_1_Windows__CInternal__CApplicationModel__CWindowManagement__CWindow": [
        "54664ab2-7b9b-517c-afad-056cf02ee31d",
        "54664ab2-7b9b-517c-afad-056cf02ee31d",
    ],
    "FIAsyncOperationCompletedHandler_1___FIVectorView_1_Windows__CInternal__CBackupRestore__CSettingsProviders__CIBackupFrequency": [
        "3303a1d7-7c3e-54cb-94e6-e166913079e2",
        "3303a1d7-7c3e-54cb-94e6-e166913079e2",
    ],
    "FIAsyncOperationCompletedHandler_1___FIVectorView_1_Windows__CInternal__CBackupRestore__CSettingsProviders__CIBackupRelatedActionItem": [
        "d6173425-f2f5-50d9-bb05-9094742bdffb",
        "d6173425-f2f5-50d9-bb05-9094742bdffb",
    ],
    "FIAsyncOperationCompletedHandler_1___FIVectorView_1_Windows__CInternal__CBackupRestore__CSettingsProviders__CIFolderBackupScopeItem": [
        "b6f8985c-2720-5ad1-b841-b34a1bd0c2e3",
        "b6f8985c-2720-5ad1-b841-b34a1bd0c2e3",
    ],
    "FIAsyncOperationCompletedHandler_1___FIVectorView_1_Windows__CInternal__CBackupRestore__CSettingsProviders__CIRetentionListItem": [
        "6bfd0150-3ddb-50fa-9bf1-277f6b3752b4",
        "6bfd0150-3ddb-50fa-9bf1-277f6b3752b4",
    ],
    "FIAsyncOperationCompletedHandler_1___FIVectorView_1_Windows__CInternal__CStateRepository__CApplicationExtension": [
        "eea18408-5dcb-5bb1-b7ff-1b084d8bb951",
        "eea18408-5dcb-5bb1-b7ff-1b084d8bb951",
    ],
    "FIAsyncOperationCompletedHandler_1___FIVectorView_1_Windows__CMedia__CSpeech__CSpeechSupportedLanguage": [
        "79d2165b-36a4-5b3e-a726-a084d7b43207",
        "79d2165b-36a4-5b3e-a726-a084d7b43207",
    ],
    "FIAsyncOperationCompletedHandler_1___FIVectorView_1_Windows__CSecurity__CCredentials__CWebAccountProvider": [
        "44c86b7a-16ab-566d-8073-49be73ab6e52",
        "44c86b7a-16ab-566d-8073-49be73ab6e52",
    ],
    "FIAsyncOperationCompletedHandler_1___FIVectorView_1_Windows__CServices__CTargetedContent__CInternal__CTargetedContentTriggerInternal": [
        "ff35ba04-0b83-5f86-aa01-90b39bdb586f",
        "ff35ba04-0b83-5f86-aa01-90b39bdb586f",
    ],
    "FIAsyncOperationCompletedHandler_1___FIVectorView_1_Windows__CStorage__CPickers__CUpdateFilesResult": [
        "563f2dab-2814-583b-988f-f5cf942362ac",
        "563f2dab-2814-583b-988f-f5cf942362ac",
    ],
    "FIAsyncOperationCompletedHandler_1___FIVector_1_IInspectable": [
        "69f426f9-8d65-5235-8e1d-80f92f18416b",
        "69f426f9-8d65-5235-8e1d-80f92f18416b",
    ],
    "FIAsyncOperationCompletedHandler_1___FIVector_1_PhoneInternal__CExperiences__CSync__CAccount": [
        "b0cda29d-cd30-5375-a6b5-6c25158617e4",
        "b0cda29d-cd30-5375-a6b5-6c25158617e4",
    ],
    "FIAsyncOperationCompletedHandler_1___FIVector_1_Windows__CApplicationModel__CAppointments__CAppointment": [
        "d13815dc-ad88-5b2f-bf25-3c97b75262d5",
        "d13815dc-ad88-5b2f-bf25-3c97b75262d5",
    ],
    "FIAsyncOperationCompletedHandler_1___FIVector_1_Windows__CInternal__CBackupRestore__CSettingsProviders__CIBackupSettingsProvider": [
        "ff8b9b09-c556-57dc-9147-735ce5b60892",
        "ff8b9b09-c556-57dc-9147-735ce5b60892",
    ],
    "FIAsyncOperationCompletedHandler_1___FIVector_1_Windows__CInternal__CBackupRestore__CSettingsProviders__CIManualCleanupOption": [
        "794fa4e8-924d-5ec1-91c8-8b98ee00a3f8",
        "794fa4e8-924d-5ec1-91c8-8b98ee00a3f8",
    ],
    "FIAsyncOperationProgressHandler_2_Windows__CApplicationModel__CInternal__CDataTransfer__CNearShare__CNearShareStatus_Windows__CApplicationModel__CInternal__CDataTransfer__CNearShare__CReceiveDataProgress": [
        "edf45241-b54f-5055-9a13-bf2758225c40",
        "edf45241-b54f-5055-9a13-bf2758225c40",
    ],
    "FIAsyncOperationProgressHandler_2_Windows__CApplicationModel__CInternal__CDataTransfer__CNearShare__CNearShareStatus_Windows__CApplicationModel__CInternal__CDataTransfer__CNearShare__CSendDataProgress": [
        "f8720281-46dd-5a3d-a453-df834d8862b7",
        "f8720281-46dd-5a3d-a453-df834d8862b7",
    ],
    "FIAsyncOperationWithProgressCompletedHandler_2_Windows__CApplicationModel__CInternal__CDataTransfer__CNearShare__CNearShareStatus_Windows__CApplicationModel__CInternal__CDataTransfer__CNearShare__CReceiveDataProgress": [
        "40118fcb-91c5-57cb-8772-f0e515d67556",
        "40118fcb-91c5-57cb-8772-f0e515d67556",
    ],
    "FIAsyncOperationWithProgressCompletedHandler_2_Windows__CApplicationModel__CInternal__CDataTransfer__CNearShare__CNearShareStatus_Windows__CApplicationModel__CInternal__CDataTransfer__CNearShare__CSendDataProgress": [
        "dd97c40e-2d56-5a00-b678-c92d9ac62ffe",
        "dd97c40e-2d56-5a00-b678-c92d9ac62ffe",
    ],
    "FIAsyncOperationWithProgress_2_Windows__CApplicationModel__CInternal__CDataTransfer__CNearShare__CNearShareStatus_Windows__CApplicationModel__CInternal__CDataTransfer__CNearShare__CReceiveDataProgress": [
        "d73cba8a-f073-5e1c-94fd-05fdf2275f60",
        "d73cba8a-f073-5e1c-94fd-05fdf2275f60",
    ],
    "FIAsyncOperationWithProgress_2_Windows__CApplicationModel__CInternal__CDataTransfer__CNearShare__CNearShareStatus_Windows__CApplicationModel__CInternal__CDataTransfer__CNearShare__CSendDataProgress": [
        "40772286-cf1a-5cbd-9d74-4137587691d5",
        "40772286-cf1a-5cbd-9d74-4137587691d5",
    ],
    "FIAsyncOperation_1_ContentManagement__CTargetedContent__CTargetedContentCollection": [
        "c3b82949-7b48-533f-9a32-5db5bbd1d54d",
        "c3b82949-7b48-533f-9a32-5db5bbd1d54d",
    ],
    "FIAsyncOperation_1_ContentManagement__CTargetedContent__CTargetedContentSubscription": [
        "056677ef-7e5c-55dd-9949-94b09922f64f",
        "056677ef-7e5c-55dd-9949-94b09922f64f",
    ],
    "FIAsyncOperation_1_DevicesFlowInteraction__CConnection__CIDeviceConnection": [
        "0f3dd3e8-ed5b-547a-a9dc-6cfa2c27f1be",
        "0f3dd3e8-ed5b-547a-a9dc-6cfa2c27f1be",
    ],
    "FIAsyncOperation_1_PhoneInternal__CExperiences__CSync__CAccount": [
        "cc0c0864-c865-5cc9-a4a3-c2b57ff24745",
        "cc0c0864-c865-5cc9-a4a3-c2b57ff24745",
    ],
    "FIAsyncOperation_1_PhoneInternal__CExperiences__CSync__CAccountErrorInformation": [
        "24dc4a95-b674-5a8b-990c-5fd09d041411",
        "24dc4a95-b674-5a8b-990c-5fd09d041411",
    ],
    "FIAsyncOperation_1_PhoneInternal__CExperiences__CSync__CAccountStatus": [
        "5fff8dc7-b064-5238-8cc8-c1f27c54b09e",
        "5fff8dc7-b064-5238-8cc8-c1f27c54b09e",
    ],
    "FIAsyncOperation_1_PhoneInternal__CExperiences__CSync__CAccountSyncScheduleInformation": [
        "b31d28aa-a479-526b-94a6-7eade39fff7e",
        "b31d28aa-a479-526b-94a6-7eade39fff7e",
    ],
    "FIAsyncOperation_1_PhoneInternal__CExperiences__CSync__CExchangeServerAuthType": [
        "89652a86-a64d-5bd4-b9f1-a73b096efaba",
        "89652a86-a64d-5bd4-b9f1-a73b096efaba",
    ],
    "FIAsyncOperation_1_PhoneInternal__CExperiences__CSync__CExchangeServerDiscoveryResult": [
        "7be2c271-d134-5f81-97f5-fcb120dafd20",
        "7be2c271-d134-5f81-97f5-fcb120dafd20",
    ],
    "FIAsyncOperation_1_PhoneInternal__CExperiences__CSync__CInternetMailServerDiscoveryResult": [
        "6f3dc58a-ca84-53f3-8864-bf421ae7f31d",
        "6f3dc58a-ca84-53f3-8864-bf421ae7f31d",
    ],
    "FIAsyncOperation_1_Windows__CApplicationModel__CCalls__CPhoneCallStore": [
        "871cad28-01e8-53b5-a14b-30316df65907",
        "871cad28-01e8-53b5-a14b-30316df65907",
    ],
    "FIAsyncOperation_1_Windows__CApplicationModel__CCalls__CPhoneCallVideoCapabilities": [
        "7b4b280a-e312-5f06-b953-7e482b67cfcf",
        "7b4b280a-e312-5f06-b953-7e482b67cfcf",
    ],
    "FIAsyncOperation_1_Windows__CApplicationModel__CCalls__CPhoneLine": [
        "d8712730-aa68-5614-a408-b2012463120b",
        "d8712730-aa68-5614-a408-b2012463120b",
    ],
    "FIAsyncOperation_1_Windows__CApplicationModel__CContracts__CInternal__CBackgroundContractLaunchStatus": [
        "82f605af-d054-500e-b5cf-a522c8c27c75",
        "82f605af-d054-500e-b5cf-a522c8c27c75",
    ],
    "FIAsyncOperation_1_Windows__CApplicationModel__CContracts__CInternal__CIBackgroundContractOperation": [
        "02acc881-167e-5108-865f-3cfe714ae29d",
        "02acc881-167e-5108-865f-3cfe714ae29d",
    ],
    "FIAsyncOperation_1_Windows__CApplicationModel__CContracts__CInternal__CICdpLaunchResult": [
        "613d85d2-77ab-5588-9a10-16a3c4af5711",
        "613d85d2-77ab-5588-9a10-16a3c4af5711",
    ],
    "FIAsyncOperation_1_Windows__CApplicationModel__CInternal__CDataTransfer__CDataRequestResult": [
        "bda02fdc-81ee-52e1-adab-96ddbc948aa3",
        "bda02fdc-81ee-52e1-adab-96ddbc948aa3",
    ],
    "FIAsyncOperation_1_Windows__CApplicationModel__CInternal__CStartupTaskInternal": [
        "4bae8816-2e25-506c-a0ad-a94eeebd4c6d",
        "4bae8816-2e25-506c-a0ad-a94eeebd4c6d",
    ],
    "FIAsyncOperation_1_Windows__CApplicationModel__CUserActivities__CUserActivity": [
        "2b45acf6-4d52-582d-810b-42675866dbf9",
        "2b45acf6-4d52-582d-810b-42675866dbf9",
    ],
    "FIAsyncOperation_1_Windows__CInternal__CBackupRestore__CSettingsProviders__CBackupProviderStatus": [
        "b888c965-f590-592f-b489-052e0a52010a",
        "b888c965-f590-592f-b489-052e0a52010a",
    ],
    "FIAsyncOperation_1_Windows__CInternal__CBackupRestore__CSettingsProviders__CBackupScopeStatus": [
        "c708f8e0-c4bd-51eb-b8d2-39852012fd2f",
        "c708f8e0-c4bd-51eb-b8d2-39852012fd2f",
    ],
    "FIAsyncOperation_1_Windows__CInternal__CBackupRestore__CSettingsProviders__CBackupTargetStatus": [
        "c161b828-4f48-5917-91c6-4ac0739b5b35",
        "c161b828-4f48-5917-91c6-4ac0739b5b35",
    ],
    "FIAsyncOperation_1_Windows__CInternal__CBackupRestore__CSettingsProviders__CBackupTargetValidationResult": [
        "7cf7e020-bac5-58fb-b9b4-afb619e8de0d",
        "7cf7e020-bac5-58fb-b9b4-afb619e8de0d",
    ],
    "FIAsyncOperation_1_Windows__CInternal__CSecurity__CAuthentication__CWeb__CGetDefaultSignInAccountResult": [
        "b5a6f1bc-1641-5f4c-b946-79084e41ee35",
        "b5a6f1bc-1641-5f4c-b946-79084e41ee35",
    ],
    "FIAsyncOperation_1_Windows__CInternal__CSecurity__CAuthentication__CWeb__CHttpCookieRequestResult": [
        "4b4aca5d-6802-54ed-9f4a-f2774a1a6218",
        "4b4aca5d-6802-54ed-9f4a-f2774a1a6218",
    ],
    "FIAsyncOperation_1_Windows__CInternal__CSecurity__CSmartScreen__CAppReputationResult": [
        "377f919e-1b1a-5ca1-9ac0-70f57dcf5f61",
        "377f919e-1b1a-5ca1-9ac0-70f57dcf5f61",
    ],
    "FIAsyncOperation_1_Windows__CInternal__CSecurity__CSmartScreen__CDownload__CDownloadReputationResult": [
        "b20ac957-d4f8-5b39-887e-95c450ab5297",
        "b20ac957-d4f8-5b39-887e-95c450ab5297",
    ],
    "FIAsyncOperation_1_Windows__CInternal__CSecurity__CSmartScreen__CDownload__CFileReputationResult": [
        "0b3418c4-edbd-5275-a27d-c814665bd20b",
        "0b3418c4-edbd-5275-a27d-c814665bd20b",
    ],
    "FIAsyncOperation_1_Windows__CInternal__CSecurity__CSmartScreen__CUriReputationResult": [
        "f84b2c99-2f3d-5877-bf78-4f40f6bd25c0",
        "f84b2c99-2f3d-5877-bf78-4f40f6bd25c0",
    ],
    "FIAsyncOperation_1_Windows__CInternal__CSettingSync__CSettingSyncResult": [
        "803fa75a-585b-5a9c-9de7-d57d5c73a0a6",
        "803fa75a-585b-5a9c-9de7-d57d5c73a0a6",
    ],
    "FIAsyncOperation_1_Windows__CInternal__CShell__CViewManagerInterop__CAppRequestHandledResult": [
        "3843809c-1f21-5d40-a51f-f6963ca8d259",
        "3843809c-1f21-5d40-a51f-f6963ca8d259",
    ],
    "FIAsyncOperation_1_Windows__CSystem__CInternal__CSetUserAutologonResult": [
        "aea2997a-3b65-5d0e-a9c2-cb5af8de0470",
        "aea2997a-3b65-5d0e-a9c2-cb5af8de0470",
    ],
    "FIAsyncOperation_1_Windows__CSystem__CInternal__CSignInResult": [
        "1a5ce963-b036-5e43-90f0-b308bf841609",
        "1a5ce963-b036-5e43-90f0-b308bf841609",
    ],
    "FIAsyncOperation_1_Windows__CSystem__CInternal__CValidateCredentialsResult": [
        "c62f19f2-57ad-50bd-ae7e-2f0c53da0870",
        "c62f19f2-57ad-50bd-ae7e-2f0c53da0870",
    ],
    "FIAsyncOperation_1___FIIterable_1_Windows__CInternal__CSettingSync__CICollectionBackup": [
        "44d3441c-ad07-508a-99ca-960a8e24b99b",
        "44d3441c-ad07-508a-99ca-960a8e24b99b",
    ],
    "FIAsyncOperation_1___FIIterator_1_Windows__CInternal__CBackupRestore__CSettingsProviders__CIBackupTargetItem": [
        "5461d6c8-8df5-52bc-95fa-0281056a4a5a",
        "5461d6c8-8df5-52bc-95fa-0281056a4a5a",
    ],
    "FIAsyncOperation_1___FIMapView_2_HSTRING_Windows__CMedia__CSpeechRecognition__CVoiceCommandSet": [
        "b1e357b5-64fb-532b-803c-08799b03c4ba",
        "b1e357b5-64fb-532b-803c-08799b03c4ba",
    ],
    "FIAsyncOperation_1___FIVectorView_1_SharingPlatform__CISessionIdentifier": [
        "6292356a-5d97-5dff-825a-e0068f0b7307",
        "6292356a-5d97-5dff-825a-e0068f0b7307",
    ],
    "FIAsyncOperation_1___FIVectorView_1_Windows__CApplicationModel__CDataTransfer__CShareProvider": [
        "492446f5-66b3-58c5-964f-702135b49f62",
        "492446f5-66b3-58c5-964f-702135b49f62",
    ],
    "FIAsyncOperation_1___FIVectorView_1_Windows__CApplicationModel__CInternal__CDataTransfer__CShareAppExtension": [
        "623557a0-ae34-5139-9abf-8107438b034a",
        "623557a0-ae34-5139-9abf-8107438b034a",
    ],
    "FIAsyncOperation_1___FIVectorView_1_Windows__CApplicationModel__CInternal__CStartupTaskInternal": [
        "943a94cb-00d0-5bcd-83be-47502a6f2ccd",
        "943a94cb-00d0-5bcd-83be-47502a6f2ccd",
    ],
    "FIAsyncOperation_1___FIVectorView_1_Windows__CInternal__CApplicationModel__CWindowManagement__CAppView": [
        "c740bbb0-8003-54d9-8e09-4c66a8df3a11",
        "c740bbb0-8003-54d9-8e09-4c66a8df3a11",
    ],
    "FIAsyncOperation_1___FIVectorView_1_Windows__CInternal__CApplicationModel__CWindowManagement__CWindow": [
        "b0c625a5-c57d-564a-a4b7-e438c7fd7e15",
        "b0c625a5-c57d-564a-a4b7-e438c7fd7e15",
    ],
    "FIAsyncOperation_1___FIVectorView_1_Windows__CInternal__CBackupRestore__CSettingsProviders__CIBackupFrequency": [
        "34517b44-a23b-5580-83a7-0fc8c6d8f883",
        "34517b44-a23b-5580-83a7-0fc8c6d8f883",
    ],
    "FIAsyncOperation_1___FIVectorView_1_Windows__CInternal__CBackupRestore__CSettingsProviders__CIBackupRelatedActionItem": [
        "7a5de9a2-7141-5c56-b35b-bc15eb54c81b",
        "7a5de9a2-7141-5c56-b35b-bc15eb54c81b",
    ],
    "FIAsyncOperation_1___FIVectorView_1_Windows__CInternal__CBackupRestore__CSettingsProviders__CIFolderBackupScopeItem": [
        "924c82cf-3846-53a4-81c0-326114d00d87",
        "924c82cf-3846-53a4-81c0-326114d00d87",
    ],
    "FIAsyncOperation_1___FIVectorView_1_Windows__CInternal__CBackupRestore__CSettingsProviders__CIRetentionListItem": [
        "41a7ec32-0b42-584a-92a3-d12143e18aae",
        "41a7ec32-0b42-584a-92a3-d12143e18aae",
    ],
    "FIAsyncOperation_1___FIVectorView_1_Windows__CInternal__CStateRepository__CApplicationExtension": [
        "7a2914a8-2c2a-5531-a629-00d784d5e608",
        "7a2914a8-2c2a-5531-a629-00d784d5e608",
    ],
    "FIAsyncOperation_1___FIVectorView_1_Windows__CMedia__CSpeech__CSpeechSupportedLanguage": [
        "fca31d1e-ac32-5207-85c7-38edde1170fd",
        "fca31d1e-ac32-5207-85c7-38edde1170fd",
    ],
    "FIAsyncOperation_1___FIVectorView_1_Windows__CSecurity__CCredentials__CWebAccountProvider": [
        "3f9bd8a0-394b-54c1-baf8-5f36abe37a65",
        "3f9bd8a0-394b-54c1-baf8-5f36abe37a65",
    ],
    "FIAsyncOperation_1___FIVectorView_1_Windows__CServices__CTargetedContent__CInternal__CTargetedContentTriggerInternal": [
        "6c200718-e9a6-597e-84e2-fb5c63be8174",
        "6c200718-e9a6-597e-84e2-fb5c63be8174",
    ],
    "FIAsyncOperation_1___FIVectorView_1_Windows__CStorage__CPickers__CUpdateFilesResult": [
        "e1d250f2-a677-5437-a35d-3b3d910c29f8",
        "e1d250f2-a677-5437-a35d-3b3d910c29f8",
    ],
    "FIAsyncOperation_1___FIVector_1_IInspectable": [
        "9d1c89a9-c902-5e84-a499-fa5dffee6333",
        "9d1c89a9-c902-5e84-a499-fa5dffee6333",
    ],
    "FIAsyncOperation_1___FIVector_1_PhoneInternal__CExperiences__CSync__CAccount": [
        "9b8074aa-1ffa-5888-9d86-d57df5746904",
        "9b8074aa-1ffa-5888-9d86-d57df5746904",
    ],
    "FIAsyncOperation_1___FIVector_1_Windows__CApplicationModel__CAppointments__CAppointment": [
        "6d08b403-4fcf-5c76-82ab-5b79f0a6f5f2",
        "6d08b403-4fcf-5c76-82ab-5b79f0a6f5f2",
    ],
    "FIAsyncOperation_1___FIVector_1_Windows__CInternal__CBackupRestore__CSettingsProviders__CIBackupSettingsProvider": [
        "b4043f94-d18d-5ab6-9954-b4f172fbe7ff",
        "b4043f94-d18d-5ab6-9954-b4f172fbe7ff",
    ],
    "FIAsyncOperation_1___FIVector_1_Windows__CInternal__CBackupRestore__CSettingsProviders__CIManualCleanupOption": [
        "32f4aef0-896a-5312-8cea-2b90a4b79918",
        "32f4aef0-896a-5312-8cea-2b90a4b79918",
    ],
    "DICounterItem": ["c08c4ff2-0e2e-11cf-942c-008029004347", "c08c4ff2-0e2e-11cf-942c-008029004347"],
    "DIFsrmClassificationEvents": ["26942db0-dabf-41d8-bbdd-b129a9f70424", "26942db0-dabf-41d8-bbdd-b129a9f70424"],
    "DILogFileItem": ["8d093ffc-f777-4917-82d1-833fbc54c58f", "8d093ffc-f777-4917-82d1-833fbc54c58f"],
    "DISyncShareEvents": ["7272b32b-b31c-43c6-8e6d-dd62c94608c3"],
    "DISystemMonitor": ["13d73d81-c32e-11cf-9398-00aa00a3ddea", "13d73d81-c32e-11cf-9398-00aa00a3ddea"],
    "DISystemMonitorEvents": ["84979930-4ab3-11cf-943a-008029004347", "84979930-4ab3-11cf-943a-008029004347"],
    "DISystemMonitorInternal": ["194eb242-c32c-11cf-9398-00aa00a3ddea", "194eb242-c32c-11cf-9398-00aa00a3ddea"],
    "DShellNameSpaceEvents": ["55136806-b2de-11d1-b9f2-00a0c98bc547", "55136806-b2de-11d1-b9f2-00a0c98bc547"],
    "DataSourceObject": ["0ae9a4e4-18d4-11d1-b3b3-00aa00c1a924", "0ae9a4e4-18d4-11d1-b3b3-00aa00c1a924"],
    "DispApplicationCache": ["305900e4-98b5-11cf-bb82-00aa00bdce0b", "305900e4-98b5-11cf-bb82-00aa00bdce0b"],
    "DispCEventObj": ["3050f558-98b5-11cf-bb82-00aa00bdce0b", "3050f558-98b5-11cf-bb82-00aa00bdce0b"],
    "DispCPlugins": ["3050f54a-98b5-11cf-bb82-00aa00bdce0b", "3050f54a-98b5-11cf-bb82-00aa00bdce0b"],
    "DispCPrintManagerTemplatePrinter": [
        "305900e9-98b5-11cf-bb82-00aa00bdce0b",
        "305900e9-98b5-11cf-bb82-00aa00bdce0b",
    ],
    "DispCanvasGradient": ["3059008c-98b5-11cf-bb82-00aa00bdce0b", "3059008c-98b5-11cf-bb82-00aa00bdce0b"],
    "DispCanvasImageData": ["3059008f-98b5-11cf-bb82-00aa00bdce0b", "3059008f-98b5-11cf-bb82-00aa00bdce0b"],
    "DispCanvasPattern": ["3059008d-98b5-11cf-bb82-00aa00bdce0b", "3059008d-98b5-11cf-bb82-00aa00bdce0b"],
    "DispCanvasRenderingContext2D": ["30590082-98b5-11cf-bb82-00aa00bdce0b", "30590082-98b5-11cf-bb82-00aa00bdce0b"],
    "DispCanvasTextMetrics": ["3059008e-98b5-11cf-bb82-00aa00bdce0b", "3059008e-98b5-11cf-bb82-00aa00bdce0b"],
    "DispDOMBeforeUnloadEvent": ["305900a8-98b5-11cf-bb82-00aa00bdce0b", "305900a8-98b5-11cf-bb82-00aa00bdce0b"],
    "DispDOMChildrenCollection": ["3050f577-98b5-11cf-bb82-00aa00bdce0b", "3050f577-98b5-11cf-bb82-00aa00bdce0b"],
    "DispDOMCloseEvent": ["305900dc-98b5-11cf-bb82-00aa00bdce0b", "305900dc-98b5-11cf-bb82-00aa00bdce0b"],
    "DispDOMCompositionEvent": ["30590078-98b5-11cf-bb82-00aa00bdce0b", "30590078-98b5-11cf-bb82-00aa00bdce0b"],
    "DispDOMCustomEvent": ["3059007c-98b5-11cf-bb82-00aa00bdce0b", "3059007c-98b5-11cf-bb82-00aa00bdce0b"],
    "DispDOMDocumentType": ["30590098-98b5-11cf-bb82-00aa00bdce0b", "30590098-98b5-11cf-bb82-00aa00bdce0b"],
    "DispDOMDragEvent": ["305900a7-98b5-11cf-bb82-00aa00bdce0b", "305900a7-98b5-11cf-bb82-00aa00bdce0b"],
    "DispDOMEvent": ["3050f5a2-98b5-11cf-bb82-00aa00bdce0b", "3050f5a2-98b5-11cf-bb82-00aa00bdce0b"],
    "DispDOMException": ["30590094-98b5-11cf-bb82-00aa00bdce0b", "30590094-98b5-11cf-bb82-00aa00bdce0b"],
    "DispDOMFocusEvent": ["30590071-98b5-11cf-bb82-00aa00bdce0b", "30590071-98b5-11cf-bb82-00aa00bdce0b"],
    "DispDOMKeyboardEvent": ["30590077-98b5-11cf-bb82-00aa00bdce0b", "30590077-98b5-11cf-bb82-00aa00bdce0b"],
    "DispDOMMSAnimationEvent": ["305900bc-98b5-11cf-bb82-00aa00bdce0b", "305900bc-98b5-11cf-bb82-00aa00bdce0b"],
    "DispDOMMSManipulationEvent": ["305900e1-98b5-11cf-bb82-00aa00bdce0b", "305900e1-98b5-11cf-bb82-00aa00bdce0b"],
    "DispDOMMSTransitionEvent": ["305900bb-98b5-11cf-bb82-00aa00bdce0b", "305900bb-98b5-11cf-bb82-00aa00bdce0b"],
    "DispDOMMessageEvent": ["30590092-98b5-11cf-bb82-00aa00bdce0b", "30590092-98b5-11cf-bb82-00aa00bdce0b"],
    "DispDOMMouseEvent": ["30590073-98b5-11cf-bb82-00aa00bdce0b", "30590073-98b5-11cf-bb82-00aa00bdce0b"],
    "DispDOMMouseWheelEvent": ["30590074-98b5-11cf-bb82-00aa00bdce0b", "30590074-98b5-11cf-bb82-00aa00bdce0b"],
    "DispDOMMutationEvent": ["30590079-98b5-11cf-bb82-00aa00bdce0b", "30590079-98b5-11cf-bb82-00aa00bdce0b"],
    "DispDOMParser": ["305900ae-98b5-11cf-bb82-00aa00bdce0b", "305900ae-98b5-11cf-bb82-00aa00bdce0b"],
    "DispDOMProcessingInstruction": ["3059009b-98b5-11cf-bb82-00aa00bdce0b", "3059009b-98b5-11cf-bb82-00aa00bdce0b"],
    "DispDOMProgressEvent": ["30590091-98b5-11cf-bb82-00aa00bdce0b", "30590091-98b5-11cf-bb82-00aa00bdce0b"],
    "DispDOMSiteModeEvent": ["305900a9-98b5-11cf-bb82-00aa00bdce0b", "305900a9-98b5-11cf-bb82-00aa00bdce0b"],
    "DispDOMStorageEvent": ["30590093-98b5-11cf-bb82-00aa00bdce0b", "30590093-98b5-11cf-bb82-00aa00bdce0b"],
    "DispDOMTextEvent": ["30590076-98b5-11cf-bb82-00aa00bdce0b", "30590076-98b5-11cf-bb82-00aa00bdce0b"],
    "DispDOMUIEvent": ["30590072-98b5-11cf-bb82-00aa00bdce0b", "30590072-98b5-11cf-bb82-00aa00bdce0b"],
    "DispDOMWheelEvent": ["30590075-98b5-11cf-bb82-00aa00bdce0b", "30590075-98b5-11cf-bb82-00aa00bdce0b"],
    "DispEventException": ["30590099-98b5-11cf-bb82-00aa00bdce0b", "30590099-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTCAttachBehavior": ["3050f583-98b5-11cf-bb82-00aa00bdce0b", "3050f583-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTCDefaultDispatch": ["3050f573-98b5-11cf-bb82-00aa00bdce0b", "3050f573-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTCDescBehavior": ["3050f57e-98b5-11cf-bb82-00aa00bdce0b", "3050f57e-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTCEventBehavior": ["3050f574-98b5-11cf-bb82-00aa00bdce0b", "3050f574-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTCMethodBehavior": ["3050f587-98b5-11cf-bb82-00aa00bdce0b", "3050f587-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTCPropertyBehavior": ["3050f57f-98b5-11cf-bb82-00aa00bdce0b", "3050f57f-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLAnchorElement": ["3050f502-98b5-11cf-bb82-00aa00bdce0b", "3050f502-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLAppBehavior": ["3050f57c-98b5-11cf-bb82-00aa00bdce0b", "3050f57c-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLAreaElement": ["3050f503-98b5-11cf-bb82-00aa00bdce0b", "3050f503-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLAreasCollection": ["3050f56a-98b5-11cf-bb82-00aa00bdce0b", "3050f56a-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLAttributeCollection": ["3050f56c-98b5-11cf-bb82-00aa00bdce0b", "3050f56c-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLAudioElement": ["3059008a-98b5-11cf-bb82-00aa00bdce0b", "3059008a-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLBGsound": ["3050f53c-98b5-11cf-bb82-00aa00bdce0b", "3050f53c-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLBRElement": ["3050f53a-98b5-11cf-bb82-00aa00bdce0b", "3050f53a-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLBaseElement": ["3050f518-98b5-11cf-bb82-00aa00bdce0b", "3050f518-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLBaseFontElement": ["3050f504-98b5-11cf-bb82-00aa00bdce0b", "3050f504-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLBlockElement": ["3050f506-98b5-11cf-bb82-00aa00bdce0b", "3050f506-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLBody": ["3050f507-98b5-11cf-bb82-00aa00bdce0b", "3050f507-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLButtonElement": ["3050f51f-98b5-11cf-bb82-00aa00bdce0b", "3050f51f-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLCSSImportRule": ["3059007e-98b5-11cf-bb82-00aa00bdce0b", "3059007e-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLCSSMediaList": ["30590097-98b5-11cf-bb82-00aa00bdce0b", "30590097-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLCSSMediaRule": ["3059007f-98b5-11cf-bb82-00aa00bdce0b", "3059007f-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLCSSNamespaceRule": ["30590080-98b5-11cf-bb82-00aa00bdce0b", "30590080-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLCSSRule": ["3059007d-98b5-11cf-bb82-00aa00bdce0b", "3059007d-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLCSSStyleDeclaration": ["3059009a-98b5-11cf-bb82-00aa00bdce0b", "3059009a-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLCanvasElement": ["3059007b-98b5-11cf-bb82-00aa00bdce0b", "3059007b-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLCommentElement": ["3050f50a-98b5-11cf-bb82-00aa00bdce0b", "3050f50a-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLCurrentStyle": ["3050f557-98b5-11cf-bb82-00aa00bdce0b", "3050f557-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLDDElement": ["3050f50b-98b5-11cf-bb82-00aa00bdce0b", "3050f50b-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLDListElement": ["3050f53b-98b5-11cf-bb82-00aa00bdce0b", "3050f53b-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLDOMAttribute": ["3050f564-98b5-11cf-bb82-00aa00bdce0b", "3050f564-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLDOMImplementation": ["3050f58f-98b5-11cf-bb82-00aa00bdce0b", "3050f58f-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLDOMRange": ["3050f5a3-98b5-11cf-bb82-00aa00bdce0b", "3050f5a3-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLDOMTextNode": ["3050f565-98b5-11cf-bb82-00aa00bdce0b", "3050f565-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLDTElement": ["3050f50d-98b5-11cf-bb82-00aa00bdce0b", "3050f50d-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLDefaults": ["3050f58c-98b5-11cf-bb82-00aa00bdce0b", "3050f58c-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLDivElement": ["3050f50c-98b5-11cf-bb82-00aa00bdce0b", "3050f50c-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLDivPosition": ["3050f50f-98b5-11cf-bb82-00aa00bdce0b", "3050f50f-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLDocument": ["3050f55f-98b5-11cf-bb82-00aa00bdce0b", "3050f55f-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLDocumentCompatibleInfo": ["3050f53e-98b5-11cf-bb82-00aa00bdce0b", "3050f53e-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLDocumentCompatibleInfoCollection": [
        "3050f53f-98b5-11cf-bb82-00aa00bdce0b",
        "3050f53f-98b5-11cf-bb82-00aa00bdce0b",
    ],
    "DispHTMLElementCollection": ["3050f56b-98b5-11cf-bb82-00aa00bdce0b", "3050f56b-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLEmbed": ["3050f52e-98b5-11cf-bb82-00aa00bdce0b", "3050f52e-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLFieldSetElement": ["3050f545-98b5-11cf-bb82-00aa00bdce0b", "3050f545-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLFontElement": ["3050f512-98b5-11cf-bb82-00aa00bdce0b", "3050f512-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLFormElement": ["3050f510-98b5-11cf-bb82-00aa00bdce0b", "3050f510-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLFrameBase": ["3050f541-98b5-11cf-bb82-00aa00bdce0b", "3050f541-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLFrameElement": ["3050f513-98b5-11cf-bb82-00aa00bdce0b", "3050f513-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLFrameSetSite": ["3050f514-98b5-11cf-bb82-00aa00bdce0b", "3050f514-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLGenericElement": ["3050f563-98b5-11cf-bb82-00aa00bdce0b", "3050f563-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLHRElement": ["3050f53d-98b5-11cf-bb82-00aa00bdce0b", "3050f53d-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLHeadElement": ["3050f561-98b5-11cf-bb82-00aa00bdce0b", "3050f561-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLHeaderElement": ["3050f515-98b5-11cf-bb82-00aa00bdce0b", "3050f515-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLHistory": ["3050f549-98b5-11cf-bb82-00aa00bdce0b", "3050f549-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLHtmlElement": ["3050f560-98b5-11cf-bb82-00aa00bdce0b", "3050f560-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLIFrame": ["3050f51b-98b5-11cf-bb82-00aa00bdce0b", "3050f51b-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLImg": ["3050f51c-98b5-11cf-bb82-00aa00bdce0b", "3050f51c-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLInputElement": ["3050f57d-98b5-11cf-bb82-00aa00bdce0b", "3050f57d-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLIsIndexElement": ["3050f519-98b5-11cf-bb82-00aa00bdce0b", "3050f519-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLLIElement": ["3050f523-98b5-11cf-bb82-00aa00bdce0b", "3050f523-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLLabelElement": ["3050f522-98b5-11cf-bb82-00aa00bdce0b", "3050f522-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLLegendElement": ["3050f546-98b5-11cf-bb82-00aa00bdce0b", "3050f546-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLLinkElement": ["3050f524-98b5-11cf-bb82-00aa00bdce0b", "3050f524-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLListElement": ["3050f525-98b5-11cf-bb82-00aa00bdce0b", "3050f525-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLLocation": ["3050f54e-98b5-11cf-bb82-00aa00bdce0b", "3050f54e-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLMSCSSKeyframeRule": ["305900de-98b5-11cf-bb82-00aa00bdce0b", "305900de-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLMSCSSKeyframesRule": ["305900df-98b5-11cf-bb82-00aa00bdce0b", "305900df-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLMapElement": ["3050f526-98b5-11cf-bb82-00aa00bdce0b", "3050f526-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLMarqueeElement": ["3050f527-98b5-11cf-bb82-00aa00bdce0b", "3050f527-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLMediaElement": ["30590088-98b5-11cf-bb82-00aa00bdce0b", "30590088-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLMediaError": ["30590086-98b5-11cf-bb82-00aa00bdce0b", "30590086-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLMetaElement": ["3050f517-98b5-11cf-bb82-00aa00bdce0b", "3050f517-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLNamespace": ["3050f54f-98b5-11cf-bb82-00aa00bdce0b", "3050f54f-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLNamespaceCollection": ["3050f550-98b5-11cf-bb82-00aa00bdce0b", "3050f550-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLNavigator": ["3050f54c-98b5-11cf-bb82-00aa00bdce0b", "3050f54c-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLNextIdElement": ["3050f51a-98b5-11cf-bb82-00aa00bdce0b", "3050f51a-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLNoShowElement": ["3050f528-98b5-11cf-bb82-00aa00bdce0b", "3050f528-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLOListElement": ["3050f52a-98b5-11cf-bb82-00aa00bdce0b", "3050f52a-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLObjectElement": ["3050f529-98b5-11cf-bb82-00aa00bdce0b", "3050f529-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLOptionElement": ["3050f52b-98b5-11cf-bb82-00aa00bdce0b", "3050f52b-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLParaElement": ["3050f52c-98b5-11cf-bb82-00aa00bdce0b", "3050f52c-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLParamElement": ["3050f590-98b5-11cf-bb82-00aa00bdce0b", "3050f590-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLPerformance": ["3059009f-98b5-11cf-bb82-00aa00bdce0b", "3059009f-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLPerformanceNavigation": ["305900a0-98b5-11cf-bb82-00aa00bdce0b", "305900a0-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLPerformanceTiming": ["305900a1-98b5-11cf-bb82-00aa00bdce0b", "305900a1-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLPhraseElement": ["3050f52d-98b5-11cf-bb82-00aa00bdce0b", "3050f52d-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLPopup": ["3050f589-98b5-11cf-bb82-00aa00bdce0b", "3050f589-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLProgressElement": ["305900af-98b5-11cf-bb82-00aa00bdce0b", "305900af-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLRenderStyle": ["3050f58b-98b5-11cf-bb82-00aa00bdce0b", "3050f58b-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLRichtextElement": ["3050f54d-98b5-11cf-bb82-00aa00bdce0b", "3050f54d-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLRuleStyle": ["3050f55c-98b5-11cf-bb82-00aa00bdce0b", "3050f55c-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLScreen": ["3050f591-98b5-11cf-bb82-00aa00bdce0b", "3050f591-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLScriptElement": ["3050f530-98b5-11cf-bb82-00aa00bdce0b", "3050f530-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLSelectElement": ["3050f531-98b5-11cf-bb82-00aa00bdce0b", "3050f531-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLSemanticElement": ["305900ba-98b5-11cf-bb82-00aa00bdce0b", "305900ba-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLSourceElement": ["30590089-98b5-11cf-bb82-00aa00bdce0b", "30590089-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLSpanElement": ["3050f548-98b5-11cf-bb82-00aa00bdce0b", "3050f548-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLSpanFlow": ["3050f544-98b5-11cf-bb82-00aa00bdce0b", "3050f544-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLStorage": ["3050f59d-98b5-11cf-bb82-00aa00bdce0b", "3050f59d-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLStyle": ["3050f55a-98b5-11cf-bb82-00aa00bdce0b", "3050f55a-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLStyleElement": ["3050f511-98b5-11cf-bb82-00aa00bdce0b", "3050f511-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLStyleFontFace": ["30590081-98b5-11cf-bb82-00aa00bdce0b", "30590081-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLStyleMedia": ["3059009e-98b5-11cf-bb82-00aa00bdce0b", "3059009e-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLStyleSheet": ["3050f58d-98b5-11cf-bb82-00aa00bdce0b", "3050f58d-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLStyleSheetPage": ["3050f540-98b5-11cf-bb82-00aa00bdce0b", "3050f540-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLStyleSheetPagesCollection": [
        "3050f543-98b5-11cf-bb82-00aa00bdce0b",
        "3050f543-98b5-11cf-bb82-00aa00bdce0b",
    ],
    "DispHTMLStyleSheetRule": ["3050f50e-98b5-11cf-bb82-00aa00bdce0b", "3050f50e-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLStyleSheetRulesAppliedCollection": [
        "3050f5a6-98b5-11cf-bb82-00aa00bdce0b",
        "3050f5a6-98b5-11cf-bb82-00aa00bdce0b",
    ],
    "DispHTMLStyleSheetRulesCollection": [
        "3050f52f-98b5-11cf-bb82-00aa00bdce0b",
        "3050f52f-98b5-11cf-bb82-00aa00bdce0b",
    ],
    "DispHTMLStyleSheetsCollection": ["3050f547-98b5-11cf-bb82-00aa00bdce0b", "3050f547-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLTable": ["3050f532-98b5-11cf-bb82-00aa00bdce0b", "3050f532-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLTableCaption": ["3050f508-98b5-11cf-bb82-00aa00bdce0b", "3050f508-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLTableCell": ["3050f536-98b5-11cf-bb82-00aa00bdce0b", "3050f536-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLTableCol": ["3050f533-98b5-11cf-bb82-00aa00bdce0b", "3050f533-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLTableRow": ["3050f535-98b5-11cf-bb82-00aa00bdce0b", "3050f535-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLTableSection": ["3050f534-98b5-11cf-bb82-00aa00bdce0b", "3050f534-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLTextAreaElement": ["3050f521-98b5-11cf-bb82-00aa00bdce0b", "3050f521-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLTextElement": ["3050f537-98b5-11cf-bb82-00aa00bdce0b", "3050f537-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLTimeRanges": ["30590087-98b5-11cf-bb82-00aa00bdce0b", "30590087-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLTitleElement": ["3050f516-98b5-11cf-bb82-00aa00bdce0b", "3050f516-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLUListElement": ["3050f538-98b5-11cf-bb82-00aa00bdce0b", "3050f538-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLUnknownElement": ["3050f539-98b5-11cf-bb82-00aa00bdce0b", "3050f539-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLUrnCollection": ["3050f551-98b5-11cf-bb82-00aa00bdce0b", "3050f551-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLVideoElement": ["3059008b-98b5-11cf-bb82-00aa00bdce0b", "3059008b-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLW3CComputedStyle": ["30590070-98b5-11cf-bb82-00aa00bdce0b", "30590070-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLWindow2": ["3050f55d-98b5-11cf-bb82-00aa00bdce0b", "3050f55d-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLWindowProxy": ["3050f55e-98b5-11cf-bb82-00aa00bdce0b", "3050f55e-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLWndOptionElement": ["3050f598-98b5-11cf-bb82-00aa00bdce0b", "3050f598-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLWndSelectElement": ["3050f597-98b5-11cf-bb82-00aa00bdce0b", "3050f597-98b5-11cf-bb82-00aa00bdce0b"],
    "DispHTMLXMLHttpRequest": ["3050f596-98b5-11cf-bb82-00aa00bdce0b", "3050f596-98b5-11cf-bb82-00aa00bdce0b"],
    "DispIHTMLInputButtonElement": ["3050f51e-98b5-11cf-bb82-00aa00bdce0b", "3050f51e-98b5-11cf-bb82-00aa00bdce0b"],
    "DispIHTMLInputFileElement": ["3050f542-98b5-11cf-bb82-00aa00bdce0b", "3050f542-98b5-11cf-bb82-00aa00bdce0b"],
    "DispIHTMLInputImage": ["3050f51d-98b5-11cf-bb82-00aa00bdce0b", "3050f51d-98b5-11cf-bb82-00aa00bdce0b"],
    "DispIHTMLInputTextElement": ["3050f520-98b5-11cf-bb82-00aa00bdce0b", "3050f520-98b5-11cf-bb82-00aa00bdce0b"],
    "DispIHTMLOptionButtonElement": ["3050f509-98b5-11cf-bb82-00aa00bdce0b", "3050f509-98b5-11cf-bb82-00aa00bdce0b"],
    "DispNodeIterator": ["3059009c-98b5-11cf-bb82-00aa00bdce0b", "3059009c-98b5-11cf-bb82-00aa00bdce0b"],
    "DispRangeException": ["30590095-98b5-11cf-bb82-00aa00bdce0b", "30590095-98b5-11cf-bb82-00aa00bdce0b"],
    "DispRulesApplied": ["3050f5a5-98b5-11cf-bb82-00aa00bdce0b", "3050f5a5-98b5-11cf-bb82-00aa00bdce0b"],
    "DispRulesAppliedCollection": ["3050f5a4-98b5-11cf-bb82-00aa00bdce0b", "3050f5a4-98b5-11cf-bb82-00aa00bdce0b"],
    "DispSVGAElement": ["30590033-98b5-11cf-bb82-00aa00bdce0b", "30590033-98b5-11cf-bb82-00aa00bdce0b"],
    "DispSVGCircleElement": ["3059000a-98b5-11cf-bb82-00aa00bdce0b", "3059000a-98b5-11cf-bb82-00aa00bdce0b"],
    "DispSVGClipPathElement": ["3059003b-98b5-11cf-bb82-00aa00bdce0b", "3059003b-98b5-11cf-bb82-00aa00bdce0b"],
    "DispSVGDefsElement": ["30590003-98b5-11cf-bb82-00aa00bdce0b", "30590003-98b5-11cf-bb82-00aa00bdce0b"],
    "DispSVGDescElement": ["30590005-98b5-11cf-bb82-00aa00bdce0b", "30590005-98b5-11cf-bb82-00aa00bdce0b"],
    "DispSVGElement": ["30590000-98b5-11cf-bb82-00aa00bdce0b", "30590000-98b5-11cf-bb82-00aa00bdce0b"],
    "DispSVGElementInstance": ["30590007-98b5-11cf-bb82-00aa00bdce0b", "30590007-98b5-11cf-bb82-00aa00bdce0b"],
    "DispSVGElementInstanceList": ["30590008-98b5-11cf-bb82-00aa00bdce0b", "30590008-98b5-11cf-bb82-00aa00bdce0b"],
    "DispSVGEllipseElement": ["3059000b-98b5-11cf-bb82-00aa00bdce0b", "3059000b-98b5-11cf-bb82-00aa00bdce0b"],
    "DispSVGException": ["30590096-98b5-11cf-bb82-00aa00bdce0b", "30590096-98b5-11cf-bb82-00aa00bdce0b"],
    "DispSVGGElement": ["30590002-98b5-11cf-bb82-00aa00bdce0b", "30590002-98b5-11cf-bb82-00aa00bdce0b"],
    "DispSVGGradientElement": ["3059002e-98b5-11cf-bb82-00aa00bdce0b", "3059002e-98b5-11cf-bb82-00aa00bdce0b"],
    "DispSVGImageElement": ["30590027-98b5-11cf-bb82-00aa00bdce0b", "30590027-98b5-11cf-bb82-00aa00bdce0b"],
    "DispSVGLineElement": ["3059000c-98b5-11cf-bb82-00aa00bdce0b", "3059000c-98b5-11cf-bb82-00aa00bdce0b"],
    "DispSVGLinearGradientElement": ["3059002a-98b5-11cf-bb82-00aa00bdce0b", "3059002a-98b5-11cf-bb82-00aa00bdce0b"],
    "DispSVGMarkerElement": ["30590036-98b5-11cf-bb82-00aa00bdce0b", "30590036-98b5-11cf-bb82-00aa00bdce0b"],
    "DispSVGMaskElement": ["3059003c-98b5-11cf-bb82-00aa00bdce0b", "3059003c-98b5-11cf-bb82-00aa00bdce0b"],
    "DispSVGMetadataElement": ["3059002f-98b5-11cf-bb82-00aa00bdce0b", "3059002f-98b5-11cf-bb82-00aa00bdce0b"],
    "DispSVGPathElement": ["30590011-98b5-11cf-bb82-00aa00bdce0b", "30590011-98b5-11cf-bb82-00aa00bdce0b"],
    "DispSVGPathSegArcAbs": ["30590013-98b5-11cf-bb82-00aa00bdce0b", "30590013-98b5-11cf-bb82-00aa00bdce0b"],
    "DispSVGPathSegArcRel": ["30590014-98b5-11cf-bb82-00aa00bdce0b", "30590014-98b5-11cf-bb82-00aa00bdce0b"],
    "DispSVGPathSegClosePath": ["30590015-98b5-11cf-bb82-00aa00bdce0b", "30590015-98b5-11cf-bb82-00aa00bdce0b"],
    "DispSVGPathSegCurvetoCubicAbs": ["30590016-98b5-11cf-bb82-00aa00bdce0b", "30590016-98b5-11cf-bb82-00aa00bdce0b"],
    "DispSVGPathSegCurvetoCubicRel": ["30590017-98b5-11cf-bb82-00aa00bdce0b", "30590017-98b5-11cf-bb82-00aa00bdce0b"],
    "DispSVGPathSegCurvetoCubicSmoothAbs": [
        "30590018-98b5-11cf-bb82-00aa00bdce0b",
        "30590018-98b5-11cf-bb82-00aa00bdce0b",
    ],
    "DispSVGPathSegCurvetoCubicSmoothRel": [
        "30590019-98b5-11cf-bb82-00aa00bdce0b",
        "30590019-98b5-11cf-bb82-00aa00bdce0b",
    ],
    "DispSVGPathSegCurvetoQuadraticAbs": [
        "3059001a-98b5-11cf-bb82-00aa00bdce0b",
        "3059001a-98b5-11cf-bb82-00aa00bdce0b",
    ],
    "DispSVGPathSegCurvetoQuadraticRel": [
        "3059001b-98b5-11cf-bb82-00aa00bdce0b",
        "3059001b-98b5-11cf-bb82-00aa00bdce0b",
    ],
    "DispSVGPathSegCurvetoQuadraticSmoothAbs": [
        "3059001c-98b5-11cf-bb82-00aa00bdce0b",
        "3059001c-98b5-11cf-bb82-00aa00bdce0b",
    ],
    "DispSVGPathSegCurvetoQuadraticSmoothRel": [
        "3059001d-98b5-11cf-bb82-00aa00bdce0b",
        "3059001d-98b5-11cf-bb82-00aa00bdce0b",
    ],
    "DispSVGPathSegLinetoAbs": ["3059001e-98b5-11cf-bb82-00aa00bdce0b", "3059001e-98b5-11cf-bb82-00aa00bdce0b"],
    "DispSVGPathSegLinetoHorizontalAbs": [
        "3059001f-98b5-11cf-bb82-00aa00bdce0b",
        "3059001f-98b5-11cf-bb82-00aa00bdce0b",
    ],
    "DispSVGPathSegLinetoHorizontalRel": [
        "30590020-98b5-11cf-bb82-00aa00bdce0b",
        "30590020-98b5-11cf-bb82-00aa00bdce0b",
    ],
    "DispSVGPathSegLinetoRel": ["30590021-98b5-11cf-bb82-00aa00bdce0b", "30590021-98b5-11cf-bb82-00aa00bdce0b"],
    "DispSVGPathSegLinetoVerticalAbs": ["30590022-98b5-11cf-bb82-00aa00bdce0b", "30590022-98b5-11cf-bb82-00aa00bdce0b"],
    "DispSVGPathSegLinetoVerticalRel": ["30590023-98b5-11cf-bb82-00aa00bdce0b", "30590023-98b5-11cf-bb82-00aa00bdce0b"],
    "DispSVGPathSegMovetoAbs": ["30590024-98b5-11cf-bb82-00aa00bdce0b", "30590024-98b5-11cf-bb82-00aa00bdce0b"],
    "DispSVGPathSegMovetoRel": ["30590025-98b5-11cf-bb82-00aa00bdce0b", "30590025-98b5-11cf-bb82-00aa00bdce0b"],
    "DispSVGPatternElement": ["3059002c-98b5-11cf-bb82-00aa00bdce0b", "3059002c-98b5-11cf-bb82-00aa00bdce0b"],
    "DispSVGPolygonElement": ["3059000d-98b5-11cf-bb82-00aa00bdce0b", "3059000d-98b5-11cf-bb82-00aa00bdce0b"],
    "DispSVGPolylineElement": ["3059000e-98b5-11cf-bb82-00aa00bdce0b", "3059000e-98b5-11cf-bb82-00aa00bdce0b"],
    "DispSVGRadialGradientElement": ["3059002b-98b5-11cf-bb82-00aa00bdce0b", "3059002b-98b5-11cf-bb82-00aa00bdce0b"],
    "DispSVGRectElement": ["30590009-98b5-11cf-bb82-00aa00bdce0b", "30590009-98b5-11cf-bb82-00aa00bdce0b"],
    "DispSVGSVGElement": ["30590001-98b5-11cf-bb82-00aa00bdce0b", "30590001-98b5-11cf-bb82-00aa00bdce0b"],
    "DispSVGScriptElement": ["30590039-98b5-11cf-bb82-00aa00bdce0b", "30590039-98b5-11cf-bb82-00aa00bdce0b"],
    "DispSVGStopElement": ["3059002d-98b5-11cf-bb82-00aa00bdce0b", "3059002d-98b5-11cf-bb82-00aa00bdce0b"],
    "DispSVGStyleElement": ["30590029-98b5-11cf-bb82-00aa00bdce0b", "30590029-98b5-11cf-bb82-00aa00bdce0b"],
    "DispSVGSwitchElement": ["30590030-98b5-11cf-bb82-00aa00bdce0b", "30590030-98b5-11cf-bb82-00aa00bdce0b"],
    "DispSVGSymbolElement": ["30590004-98b5-11cf-bb82-00aa00bdce0b", "30590004-98b5-11cf-bb82-00aa00bdce0b"],
    "DispSVGTSpanElement": ["3059003a-98b5-11cf-bb82-00aa00bdce0b", "3059003a-98b5-11cf-bb82-00aa00bdce0b"],
    "DispSVGTextContentElement": ["30590035-98b5-11cf-bb82-00aa00bdce0b", "30590035-98b5-11cf-bb82-00aa00bdce0b"],
    "DispSVGTextElement": ["30590037-98b5-11cf-bb82-00aa00bdce0b", "30590037-98b5-11cf-bb82-00aa00bdce0b"],
    "DispSVGTextPathElement": ["3059003d-98b5-11cf-bb82-00aa00bdce0b", "3059003d-98b5-11cf-bb82-00aa00bdce0b"],
    "DispSVGTextPositioningElement": ["30590038-98b5-11cf-bb82-00aa00bdce0b", "30590038-98b5-11cf-bb82-00aa00bdce0b"],
    "DispSVGTitleElement": ["30590006-98b5-11cf-bb82-00aa00bdce0b", "30590006-98b5-11cf-bb82-00aa00bdce0b"],
    "DispSVGUseElement": ["30590010-98b5-11cf-bb82-00aa00bdce0b", "30590010-98b5-11cf-bb82-00aa00bdce0b"],
    "DispSVGViewElement": ["30590034-98b5-11cf-bb82-00aa00bdce0b", "30590034-98b5-11cf-bb82-00aa00bdce0b"],
    "DispSVGZoomEvent": ["30590031-98b5-11cf-bb82-00aa00bdce0b", "30590031-98b5-11cf-bb82-00aa00bdce0b"],
    "DispStaticNodeList": ["3050f59b-98b5-11cf-bb82-00aa00bdce0b", "3050f59b-98b5-11cf-bb82-00aa00bdce0b"],
    "DispTreeWalker": ["3059009d-98b5-11cf-bb82-00aa00bdce0b", "3059009d-98b5-11cf-bb82-00aa00bdce0b"],
    "DispWebGeocoordinates": ["305900be-98b5-11cf-bb82-00aa00bdce0b", "305900be-98b5-11cf-bb82-00aa00bdce0b"],
    "DispWebGeolocation": ["305900bd-98b5-11cf-bb82-00aa00bdce0b", "305900bd-98b5-11cf-bb82-00aa00bdce0b"],
    "DispWebGeoposition": ["305900c1-98b5-11cf-bb82-00aa00bdce0b", "305900c1-98b5-11cf-bb82-00aa00bdce0b"],
    "DispWebGeopositionError": ["305900bf-98b5-11cf-bb82-00aa00bdce0b", "305900bf-98b5-11cf-bb82-00aa00bdce0b"],
    "DispXDomainRequest": ["3050f599-98b5-11cf-bb82-00aa00bdce0b", "3050f599-98b5-11cf-bb82-00aa00bdce0b"],
    "DispXMLHttpRequestEventTarget": ["305900e7-98b5-11cf-bb82-00aa00bdce0b", "305900e7-98b5-11cf-bb82-00aa00bdce0b"],
    "DispXMLSerializer": ["305900ad-98b5-11cf-bb82-00aa00bdce0b", "305900ad-98b5-11cf-bb82-00aa00bdce0b"],
    "HTMLDocumentEvents3": ["3050f5a0-98b5-11cf-bb82-00aa00bdce0b", "3050f5a0-98b5-11cf-bb82-00aa00bdce0b"],
    "HTMLDocumentEvents4": ["30510737-98b5-11cf-bb82-00aa00bdce0b", "30510737-98b5-11cf-bb82-00aa00bdce0b"],
    "HTMLElementEvents3": ["3050f59f-98b5-11cf-bb82-00aa00bdce0b", "3050f59f-98b5-11cf-bb82-00aa00bdce0b"],
    "HTMLElementEvents4": ["3051075e-98b5-11cf-bb82-00aa00bdce0b", "3051075e-98b5-11cf-bb82-00aa00bdce0b"],
    "HTMLFrameSiteEvents2": ["3050f7ff-98b5-11cf-bb82-00aa00bdce0b", "3050f7ff-98b5-11cf-bb82-00aa00bdce0b"],
    "HTMLPersistEvents": ["3050f4c7-98b5-11cf-bb82-00aa00bdce0b"],
    "HTMLWindowEvents3": ["3050f5a1-98b5-11cf-bb82-00aa00bdce0b", "3050f5a1-98b5-11cf-bb82-00aa00bdce0b"],
    "HTMLXMLHttpRequestEvents": ["30510498-98b5-11cf-bb82-00aa00bdce0b", "30510498-98b5-11cf-bb82-00aa00bdce0b"],
    "IMsoEnvelopeVBEvents": ["000672ad-0000-0000-c000-000000000046", "000672ad-0000-0000-c000-000000000046"],
    "IRTCDispatchEventNotification": ["176ddfbe-fec0-4d55-bc87-84cff1ef7f91", "176ddfbe-fec0-4d55-bc87-84cff1ef7f91"],
    "ISWbemSinkEvents": ["75718ca0-f029-11d1-a1ac-00c04fb6c223", "75718ca0-f029-11d1-a1ac-00c04fb6c223"],
    "ITTAPIDispatchEventNotification": ["9f34325b-7e62-11d2-9457-00c04f8ec888", "9f34325b-7e62-11d2-9457-00c04f8ec888"],
    "LayoutRectEvents": ["3050f674-98b5-11cf-bb82-00aa00bdce0b"],
    "XMLDOMDocumentEvents": ["3efaa427-272f-11d2-836f-0000f87a7782", "3efaa427-272f-11d2-836f-0000f87a7782"],
    "CommandBarButtonEvents": ["000c0351-0000-0000-c000-000000000046"],
    "CommandBarComboBoxEvents": ["000c0354-0000-0000-c000-000000000046"],
    "CommandBarsEvents": ["000c0352-0000-0000-c000-000000000046"],
    "IAntiPhishingBrowserSolutionEvents": ["9153c3ba-d311-446c-bb01-bc45cb772c27"],
    "IAppRepEvents": ["5a031e69-96a8-4a9d-802f-a5115210f1bb"],
    "IFindSimilarResults": ["96236a81-9dbc-11da-9e3f-0011114ae311", "96236a81-9dbc-11da-9e3f-0011114ae311"],
    "IRdcComparator": ["96236a77-9dbc-11da-9e3f-0011114ae311", "96236a77-9dbc-11da-9e3f-0011114ae311"],
    "IRdcFileReader": ["96236a74-9dbc-11da-9e3f-0011114ae311", "96236a74-9dbc-11da-9e3f-0011114ae311"],
    "IRdcFileWriter": ["96236a75-9dbc-11da-9e3f-0011114ae311", "96236a75-9dbc-11da-9e3f-0011114ae311"],
    "IRdcGenerator": ["96236a73-9dbc-11da-9e3f-0011114ae311", "96236a73-9dbc-11da-9e3f-0011114ae311"],
    "IRdcGeneratorFilterMaxParameters": [
        "96236a72-9dbc-11da-9e3f-0011114ae311",
        "96236a72-9dbc-11da-9e3f-0011114ae311",
    ],
    "IRdcGeneratorParameters": ["96236a71-9dbc-11da-9e3f-0011114ae311", "96236a71-9dbc-11da-9e3f-0011114ae311"],
    "IRdcLibrary": ["96236a78-9dbc-11da-9e3f-0011114ae311", "96236a78-9dbc-11da-9e3f-0011114ae311"],
    "IRdcSignatureReader": ["96236a76-9dbc-11da-9e3f-0011114ae311", "96236a76-9dbc-11da-9e3f-0011114ae311"],
    "IRdcSimilarityGenerator": ["96236a80-9dbc-11da-9e3f-0011114ae311", "96236a80-9dbc-11da-9e3f-0011114ae311"],
    "ISimilarity": ["96236a83-9dbc-11da-9e3f-0011114ae311", "96236a83-9dbc-11da-9e3f-0011114ae311"],
    "ISimilarityFileIdTable": ["96236a7f-9dbc-11da-9e3f-0011114ae311", "96236a7f-9dbc-11da-9e3f-0011114ae311"],
    "ISimilarityReportProgress": ["96236a7a-9dbc-11da-9e3f-0011114ae311", "96236a7a-9dbc-11da-9e3f-0011114ae311"],
    "ISimilarityTableDumpState": ["96236a7b-9dbc-11da-9e3f-0011114ae311", "96236a7b-9dbc-11da-9e3f-0011114ae311"],
    "ISimilarityTraitsMappedView": ["96236a7c-9dbc-11da-9e3f-0011114ae311", "96236a7c-9dbc-11da-9e3f-0011114ae311"],
    "ISimilarityTraitsMapping": ["96236a7d-9dbc-11da-9e3f-0011114ae311", "96236a7d-9dbc-11da-9e3f-0011114ae311"],
    "ISimilarityTraitsTable": ["96236a7e-9dbc-11da-9e3f-0011114ae311", "96236a7e-9dbc-11da-9e3f-0011114ae311"],
    "ADOColumns": ["0000061d-0000-0010-8000-00aa006d2ea4"],
    "ADOCommandConstruction": ["00000517-0000-0010-8000-00aa006d2ea4"],
    "ADOConnectionConstruction": ["00000551-0000-0010-8000-00aa006d2ea4"],
    "ADOConnectionConstruction15": ["00000516-0000-0010-8000-00aa006d2ea4"],
    "ADOError": ["00000500-0000-0010-8000-00aa006d2ea4"],
    "ADOErrors": ["00000501-0000-0010-8000-00aa006d2ea4"],
    "ADOField": ["00000569-0000-0010-8000-00aa006d2ea4", "00001569-0000-0010-8000-00aa006d2ea4"],
    "ADOFields": ["00000564-0000-0010-8000-00aa006d2ea4", "00001564-0000-0010-8000-00aa006d2ea4"],
    "ADOGroups": ["00000617-0000-0010-8000-00aa006d2ea4"],
    "ADOIndexes": ["00000620-0000-0010-8000-00aa006d2ea4"],
    "ADOKeys": ["00000623-0000-0010-8000-00aa006d2ea4"],
    "ADOParameters": ["0000050d-0000-0010-8000-00aa006d2ea4", "0000150d-0000-0010-8000-00aa006d2ea4"],
    "ADOProcedure": ["00000625-0000-0010-8000-00aa006d2ea4"],
    "ADOProcedures": ["00000626-0000-0010-8000-00aa006d2ea4"],
    "ADOProperties": ["00000504-0000-0010-8000-00aa006d2ea4"],
    "ADOProperty": ["00000503-0000-0010-8000-00aa006d2ea4"],
    "ADORecordConstruction": ["00000567-0000-0010-8000-00aa006d2ea4"],
    "ADORecordsetConstruction": ["00000283-0000-0010-8000-00aa006d2ea4"],
    "ADOStreamConstruction": ["00000568-0000-0010-8000-00aa006d2ea4"],
    "ADOTables": ["00000611-0000-0010-8000-00aa006d2ea4"],
    "ADOUsers": ["0000061a-0000-0010-8000-00aa006d2ea4"],
    "ADOView": ["00000613-0000-0010-8000-00aa006d2ea4"],
    "ADOViews": ["00000614-0000-0010-8000-00aa006d2ea4"],
    "ActivationBrokerManager": ["c499dffc-8907-4d47-89f3-712716a789f2"],
    "AddIns": ["50590801-d13e-4404-80c2-5ca30a4d0ee8", "50590801-d13e-4404-80c2-5ca30a4d0ee8"],
    "Adjustments": ["000c0310-0000-0000-c000-000000000046"],
    "AnalogVideoStandard": ["266eee44-6c63-11cf-8a03-00aa006ecb65"],
    "AnalyzerReferences": ["1c0a9223-df8f-4d3d-a5fc-4d4b506706e7"],
    "AnswerWizard": ["000c0360-0000-0000-c000-000000000046"],
    "AnswerWizardFiles": ["000c0361-0000-0000-c000-000000000046"],
    "AssemblyReference": ["229f3491-6e60-4e50-90e5-7db14b0dc004"],
    "AssemblyReferences": ["2c264a1a-dbfb-43fe-9434-997b5be0fccc"],
    "AsyncIApplicationLicenseManager": ["847bd310-6cee-48a3-864c-414126b9d123"],
    "AsyncIApplicationLicenseManager2": ["22ced81a-4ff4-40b2-b095-fcc1a3c093a9"],
    "AsyncIApplicationLicenseManager3": ["d86e8705-fc92-43ff-a020-bb6e9c5894cf"],
    "AsyncIAssociatedIdentityProvider": ["2834d6ed-297e-4e72-8a51-961e86f05152"],
    "AsyncIChildInfo": ["e94f5961-1516-459f-9ce7-149b53264fe8"],
    "AsyncIConnectedIdentityProvider": ["9ce55141-bce9-4e15-824d-43d79f512f93"],
    "AsyncIConnectedUser": ["5cbbc77b-b292-4184-9dce-2f98ca53434e"],
    "AsyncIConnectedUserStore": ["96125fe4-250a-41e2-a473-a49a849703c8"],
    "AsyncIDebugApplicationNodeEvents": ["a2e3aa3b-aa8d-4ebf-84cd-648b737b8c13"],
    "AsyncIERegHelperBroker": ["bfd074f8-3a54-4fb3-8771-277d3e2031c5"],
    "AsyncIEdgeManagerBroker": ["869ee45b-fece-4670-9af9-49cbd9fb0cc9"],
    "AsyncIEdgeManagerBrowsingContextBroker": ["b4c6e777-a36c-4d74-b8b2-b0af9578792a"],
    "AsyncIFtpAuthenticationProvider": ["c24efb65-9f3e-4996-8fb1-ce166916bab5"],
    "AsyncIFtpAuthorizationProvider": ["860dc339-07e5-4a5c-9c61-8820cea012bc"],
    "AsyncIFtpHomeDirectoryProvider": ["73f81638-6295-42bd-a2be-4a657f7c479c"],
    "AsyncIFtpLogProvider": ["00a0ae46-2498-48b2-95e6-df678ed7d49f"],
    "AsyncIFtpPostprocessProvider": ["a16b2542-9694-4eb1-a564-6c2e91fdc133"],
    "AsyncIFtpPreprocessProvider": ["6ff5fd8f-fd8e-48b1-a3e0-bf7073db4db5"],
    "AsyncIFtpRoleProvider": ["3e83bf99-70ec-41ca-84b6-aca7c7a62caf"],
    "AsyncIGatherNotify2": ["818b6181-1b32-48b0-8fcd-ae2e431db061"],
    "AsyncIIdentityAdvise": ["3ab4c8da-d038-4830-8dd9-3253c55a127f"],
    "AsyncIIdentityAuthentication": ["f9a2f918-feca-4e9c-9633-61cbf13ed34d"],
    "AsyncIIdentityProvider": ["c6fc9901-c433-4646-8f48-4e4687aae2a0"],
    "AsyncIIdentityStore": ["eefa1616-48de-4872-aa64-6e6206535a51"],
    "AsyncIIdentityStore2": ["4b42e09e-288e-47a9-b700-ecd1bbb02528"],
    "AsyncIIdentityStoreEx": ["fca3af9a-8a07-4eae-8632-ec3de658a36a"],
    "AsyncILicenseManager": ["d9abb5bb-ce07-40fb-9153-d974c65a1b47"],
    "AsyncILicenseManager2": ["6c91e6bb-87e7-4694-aaea-a4d906ae6068"],
    "AsyncILicenseManagerSubscriptions": ["7bbe20ca-f217-4141-813a-8241537412cd"],
    "AsyncILicenseManagerUserContext": ["f7a799a8-5fa3-4bce-be7d-c93aca367b20"],
    "AsyncILicenseProxyService": ["2af479e5-dc08-48b1-89f0-5305d8e40190"],
    "AsyncILicenseStorageService": ["b357fdb9-d1e9-4410-8483-541f5766da55"],
    "AsyncILockScreenCallBroker": ["3208cfd6-81f6-4cd3-bcbe-3ae9e7296987"],
    "AsyncIMSAdminBaseSink": ["a9e69613-b80d-11d0-b9b9-00a0c922e750"],
    "AsyncIMSAdminBaseSinkW": ["a9e69613-b80d-11d0-b9b9-00a0c922e750"],
    "AsyncIMSAdminBaseSink_W": ["a9e69613-b80d-11d0-b9b9-00a0c922e750"],
    "AsyncIMigratedIdentityConnector": ["0e9140f2-3d70-4d34-835e-4c95a7bd9618"],
    "AsyncIModernMarketplaceApplicationLicenseManager": ["0cc509d6-3e9a-4538-b909-4ff310481baa"],
    "AsyncIOfflineFilesService": ["6c8f231d-bc94-474e-95da-656b8f877af4"],
    "AsyncIOperatingSystemLicenseManager": ["7270d1d5-679d-4f8c-a152-a0b2b46d6d5f"],
    "AsyncIRemUnknown": ["000e0131-0000-0000-c000-000000000046"],
    "AsyncIRemUnknown2": ["000e0143-0000-0000-c000-000000000046"],
    "AsyncIRemUnknownN": ["000b013c-0000-0000-c000-000000000046"],
    "AsyncIRemoveLicensesForReasons": ["88cfb7d0-d255-475a-ac5b-a2b89935dd45"],
    "AsyncIRundown": ["000e0134-0000-0000-c000-000000000046"],
    "AsyncISettingsProvider": ["f152e566-e744-4a37-8b0c-ebf0e680a896"],
    "AsyncIShdocvwBroker": ["089a3fe9-9d38-4a15-91f3-9953b3b726f4"],
    "AsyncIWpnPresentationTileSink": ["8d2877bb-8a20-41d1-9f0e-89ce2db84f6b"],
    "AsyncIeAxiAdminInstaller": ["146e5396-3b32-49ac-901e-4c4a82fee8c5"],
    "AsyncIeAxiInstaller": ["5c861803-b3f1-4956-9bc2-7737ba72c606"],
    "AsyncIeAxiInstaller2": ["e0fd8b8e-66ea-45d6-a10a-81e74453733a"],
    "AsyncIeAxiService": ["4c691564-057c-430a-bc66-2120bfb048f7"],
    "AsyncIeAxiService2": ["f7084e96-d20b-444c-9381-73a273c23976"],
    "Axes": ["22813759-8bd3-11d0-b4ef-00a0c9138ca4"],
    "Axis": ["22813732-8bd3-11d0-b4ef-00a0c9138ca4"],
    "Balloon": ["000c0324-0000-0000-c000-000000000046"],
    "BalloonCheckbox": ["000c0328-0000-0000-c000-000000000046"],
    "BalloonCheckboxes": ["000c0326-0000-0000-c000-000000000046"],
    "BalloonLabel": ["000c0330-0000-0000-c000-000000000046"],
    "BalloonLabels": ["000c032e-0000-0000-c000-000000000046"],
    "BlobPlaceHolder": ["8888b46a-db7e-4f7f-a468-af8eeac7a4b3"],
    "BooleanSymbolExpressionEvaluator": ["5dadf1ee-bcbe-46ce-badf-271992c112a3"],
    "Breakpoint": ["11c5114c-bb00-11d2-8ad1-00c04f79e479"],
    "Breakpoint2": ["fbc8d85a-e449-4cb3-b026-f7808deb7792"],
    "Breakpoint3": ["81c189c5-0ef0-459c-b907-a22f6b7b355c"],
    "Breakpoints": ["25968106-bafb-11d2-8ad1-00c04f79e479"],
    "BuildDependencies": ["ead260eb-1e5b-450a-b628-4cfada11b4a1"],
    "BuildDependency": ["9c5ceaac-062f-4434-a2ed-78ab4d6134fe"],
    "BuildManager": ["c711e2b7-3c58-4c37-9359-705208a890ae"],
    "CAnchorHelper": ["30510735-98b5-11cf-bb82-00aa00bdce0b"],
    "CDefnTypeComp": ["000204f5-0000-0000-c000-000000000046"],
    "COMAddIn": ["000c033a-0000-0000-c000-000000000046"],
    "COMAddIns": ["000c0339-0000-0000-c000-000000000046"],
    "CSharpProjectConfigurationProperties3": ["f25c9ad7-e371-414d-82a0-24e8bbc25c99"],
    "CSharpProjectConfigurationProperties4": ["dd47c0d5-5095-4a44-ac96-105b2f194f11"],
    "CSharpProjectConfigurationProperties5": ["c379af13-6c05-4a91-a3bf-4c61999174b4"],
    "CSharpProjectConfigurationProperties6": ["97c0fc65-e652-44e1-8367-907fdfcf84fd"],
    "CSharpProjectProperties3": ["7c9d1773-f1f3-447c-af1a-218e5e2c2f7f"],
    "CSharpProjectProperties4": ["9c52f596-60fb-4144-be49-adca8f044790"],
    "CSharpProjectProperties6": ["531d3661-c9ce-4618-bdb4-466a4e4072c9"],
    "CSharpProjectProperties7": ["ad327414-a8f4-4e96-9a2a-3008592fd6a9"],
    "CStyleElementHelper": ["30510713-98b5-11cf-bb82-00aa00bdce0b"],
    "CTypeInfo2": ["00020433-0000-0000-c000-000000000046"],
    "CTypeLib2": ["00020432-0000-0000-c000-000000000046"],
    "CUnmappedXmlStorage": ["8a0d0bda-c266-4a4c-b270-e5f09f6339b2"],
    "CalloutFormat": ["000c0311-0000-0000-c000-000000000046"],
    "CanvasShapes": ["000c0371-0000-0000-c000-000000000046"],
    "CodeAttribute": ["0cfbc2be-0d4e-11d3-8997-00c04f688dde"],
    "CodeAttribute2": ["35187e2a-e5f6-4f89-a4ce-da254640855b"],
    "CodeAttributeArgument": ["80f4779b-835d-4873-8356-2f34a759a514"],
    "CodeClass": ["b1f42514-91cd-4d3a-8b25-a317d8032b24"],
    "CodeClass2": ["295adcd4-b052-49ee-934e-c6b36862a7c6"],
    "CodeDelegate": ["b1f42513-91cd-4d3a-8b25-a317d8032b24"],
    "CodeDelegate2": ["3b1b24ef-dd8e-4c98-8799-4efac80080e9"],
    "CodeElement": ["0cfbc2b6-0d4e-11d3-8997-00c04f688dde"],
    "CodeElement2": ["f03dcce8-233b-43d7-a66b-a66efc1f85c3"],
    "CodeElements": ["0cfbc2b5-0d4e-11d3-8997-00c04f688dde"],
    "CodeEnum": ["b1f42512-91cd-4d3a-8b25-a317d8032b24"],
    "CodeEvent": ["ce615bd2-8ed5-4f0c-a7b6-4a299d8801fd"],
    "CodeFolder": ["58b5e6e3-c2d3-4d56-97eb-26dda09323f7"],
    "CodeFolders": ["fdcad245-e468-48f3-b603-2641e020d6d0"],
    "CodeFunction": ["0cfbc2b9-0d4e-11d3-8997-00c04f688dde"],
    "CodeFunction2": ["7e20cd35-8689-466d-8ea0-a863b7ea5db9"],
    "CodeImport": ["0c9a256e-0ff9-4d4a-88e6-304acf78225f"],
    "CodeInterface": ["b1f42510-91cd-4d3a-8b25-a317d8032b24"],
    "CodeInterface2": ["860ab609-8af2-4434-b4dd-a43dee31b017"],
    "CodeModel": ["0cfbc2b4-0d4e-11d3-8997-00c04f688dde"],
    "CodeModel2": ["99b9cd0e-6c89-4bc4-bba2-ffd3529d3acb"],
    "CodeNamespace": ["0cfbc2b8-0d4e-11d3-8997-00c04f688dde"],
    "CodeParameter": ["0cfbc2bd-0d4e-11d3-8997-00c04f688dde"],
    "CodeParameter2": ["35cd9e36-7c96-4429-968f-c0c350cb1a47"],
    "CodeProperty": ["0cfbc2bb-0d4e-11d3-8997-00c04f688dde"],
    "CodeProperty2": ["33770c02-21b7-4224-a577-6877bdba60ea"],
    "CodeStruct": ["b1f42511-91cd-4d3a-8b25-a317d8032b24"],
    "CodeStruct2": ["f6dc1a01-e65a-404b-8b6d-9cdd603db4ed"],
    "CodeType": ["0cfbc2b7-0d4e-11d3-8997-00c04f688dde"],
    "CodeTypeRef": ["0cfbc2bc-0d4e-11d3-8997-00c04f688dde"],
    "CodeTypeRef2": ["9883c07a-fa07-4ce7-bd8e-01e1a3f3a3f7"],
    "CodeVariable": ["0cfbc2ba-0d4e-11d3-8997-00c04f688dde"],
    "CodeVariable2": ["f747a8a0-01b1-4da2-9259-0d5a0cb4c049"],
    "ColorFormat": ["000c0312-0000-0000-c000-000000000046"],
    "ColorableItems": ["e5d17051-d6e5-4da7-8b3a-ca888617a5e7"],
    "Command15": ["00000508-0000-0010-8000-00aa006d2ea4", "00001508-0000-0010-8000-00aa006d2ea4"],
    "Command25": ["0000054e-0000-0010-8000-00aa006d2ea4", "0000154e-0000-0010-8000-00aa006d2ea4"],
    "CommandBar": ["000c0304-0000-0000-c000-000000000046"],
    "CommandBarButton": ["000c030e-0000-0000-c000-000000000046"],
    "CommandBarComboBox": ["000c030c-0000-0000-c000-000000000046"],
    "CommandBarControl": ["000c0308-0000-0000-c000-000000000046"],
    "CommandBarControls": ["000c0306-0000-0000-c000-000000000046"],
    "CommandBarPopup": ["000c030a-0000-0000-c000-000000000046"],
    "CommandBars": ["000c0302-0000-0000-c000-000000000046"],
    "CommandWindow": ["509b9955-7303-48c9-90d4-e165b974e6ba"],
    "Commands": ["e6b96cac-b8c7-40ae-b705-5c81878c4a9e", "e6b96cac-b8c7-40ae-b705-5c81878c4a9e"],
    "Commands2": ["7eaa857b-2356-494b-9e13-0f6eefa86e43"],
    "ConfigurationManager": ["9043fda1-345b-4364-900f-bc8598eb8e4f"],
    "Configurations": ["b6b4c8d6-4d27-43b9-b45c-52bd16b6ba38"],
    "Connection15": ["00000515-0000-0010-8000-00aa006d2ea4", "00001515-0000-0010-8000-00aa006d2ea4"],
    "ConnectionEvents": ["00000400-0000-0010-8000-00aa006d2ea4", "00001400-0000-0010-8000-00aa006d2ea4"],
    "ConnectionEventsVt": ["00000402-0000-0010-8000-00aa006d2ea4", "00001402-0000-0010-8000-00aa006d2ea4"],
    "ConnectorFormat": ["000c0313-0000-0000-c000-000000000046"],
    "ContextAttribute": ["1a6e2cb3-b897-42eb-96be-ff0fdb65db2f"],
    "ContextAttributes": ["33c5ebb8-244e-449d-9cee-fad70a774e59"],
    "CubeDef": ["da16a34a-7b7a-46fd-ad9d-66df1e699fa1"],
    "CubeDef25": ["2281373e-8bd3-11d0-b4ef-00a0c9138ca4"],
    "CubeDefs": ["2281375d-8bd3-11d0-b4ef-00a0c9138ca4"],
    "DDiscFormat2DataEvents": ["2735413c-7f64-5b0f-8f00-5d77afbe261e"],
    "DDiscFormat2EraseEvents": ["2735413a-7f64-5b0f-8f00-5d77afbe261e"],
    "DDiscFormat2RawCDEvents": ["27354142-7f64-5b0f-8f00-5d77afbe261e"],
    "DDiscFormat2TrackAtOnceEvents": ["2735413f-7f64-5b0f-8f00-5d77afbe261e"],
    "DDiscMaster2Events": ["27354131-7f64-5b0f-8f00-5d77afbe261e"],
    "DEPRECATED": [
        "00732830-50f1-4d03-99ac-c6644c8ed8b5",
        "010a6306-c433-44e5-a9f2-bd84d4030a95",
        "020a16e5-6a25-40a3-8c00-50a023f619d1",
        "03bbf9b9-12d8-4bce-8835-c5df3ac0adab",
        "049c266a-93b4-478c-aeb8-70157bf0ff94",
        "08c03978-437a-4d97-a663-fd3195600249",
        "08e80a98-b8e5-41c1-a3d8-d3abfae22675",
        "091791ed-872b-4eec-9c72-ab11627b34ec",
        "0b6a985a-d59d-40be-980c-488a2ab30a83",
        "0b7ad409-ec2d-47ce-a253-732beeebcacd",
        "0bedda75-46e6-4b11-a088-5c68632899b5",
        "0c4733d2-57e0-4180-bd5e-f31a2138423e",
        "0c9d8511-5202-4dcb-8c67-abda12bb3c12",
        "112fbfc8-f235-4fde-8d41-9bf27c9e9a40",
        "13043da7-7fca-4c2b-9eca-6890f9f00185",
        "143ba4fc-e9c5-4736-91b2-e8eb9cb88356",
        "14d981a3-fc26-4ff7-abc3-48e82a512a0a",
        "164bbb60-8465-4786-8b93-2c16a89289d7",
        "172c4882-2fd9-4c4e-ba34-fdf20a73dde5",
        "191330e0-8695-438a-9545-3da4e822ddb4",
        "1a58b0e1-e91a-481e-b876-a89e2bbc6b33",
        "1adf0f65-e3b7-4155-997f-b756ef65beba",
        "1b88e52b-7787-48d6-aa12-d8e8f47ab85a",
        "1c6a52c5-ff19-471b-ba6b-f8f35694ad9a",
        "1e2ba861-8533-4fce-839b-ecb72410ac14",
        "1e33390a-3c90-4d22-b898-f42bba6418ff",
        "1ee30a1a-11b2-4558-8865-e3a516922517",
        "205f5d24-1b48-4629-a6ca-2fdfedafb75d",
        "21d39698-aa62-45ff-a5ff-8037e5433825",
        "23ca0917-cd07-4609-be15-8fe894c5e41e",
        "256bbc3d-1c5d-4260-8c75-9144cfb78ba9",
        "2a706328-da25-4f8c-9eb7-5d0fc3658bca",
        "2c846fe1-3bad-4f33-8c8b-e46fae824b4b",
        "2ca11c87-0873-4caf-8a7d-bd471e8586d1",
        "2d223d65-c4b6-4438-8d46-b96e6d0fb21f",
        "2d2d1bc6-02ce-474a-a556-a75b1cf93a03",
        "2d4cf9a5-e32f-4ab2-8748-96350a016da3",
        "2e0e1b12-d627-4fca-bad4-1faf168c7d14",
        "2f1af2e0-baf1-453b-bed4-cd9d4619154c",
        "383cff99-d70c-444d-a8b0-720c2e66fe3b",
        "387ee6aa-89cd-481e-aade-dd92f70b2ad7",
        "3ae651d6-9669-4106-9fae-4835c1b96104",
        "3bb384cb-0760-461d-907f-5138f84d44c1",
        "3bd6781b-61b8-46e2-99a5-8abcb6b9f7d6",
        "3c064fe9-2351-4248-a529-7110f464a785",
        "3c4d3046-ac4b-49f2-97d6-020e6182cb9c",
        "3c5aeb51-350b-4df8-9414-59e09815510b",
        "3cb38370-c02b-4236-b3e8-6bdca49c3129",
        "3cde9dc9-4800-46cd-869b-1973ec685bde",
        "3e53dd62-fee8-451f-b0d4-f706cca3e037",
        "3f582656-28f8-4e0f-ae8c-5898b9ae2469",
        "40e05c86-a7b4-4771-9ae7-0b5ffb12c03a",
        "4100891d-278e-4f29-859b-a9e501053e7d",
        "443d25b2-b282-4637-9173-ac978435c985",
        "44df23ae-5d6e-4068-a168-f47643182114",
        "460c92e5-4c32-4538-a4d4-b6b4400d140f",
        "4738d29f-c345-4649-8468-b8c5fc357190",
        "47bc8205-4d36-47a9-8f68-ffcb339dd0fc",
        "48b8219f-1e51-4d77-ae50-3ec164ad3480",
        "4a992832-1984-4148-9f25-382b35db087f",
        "4c24b81f-d944-4112-a98e-6a69522b7ebb",
        "4c38a7da-fdd8-4ed4-a039-2a6f9b235038",
        "4f1392ab-1f72-4d33-b695-de3e1db60317",
        "51882366-9f4b-498f-beb0-42684f6e1c29",
        "5498d33a-e686-4935-a567-7ca77ad20fa4",
        "54d571a7-8062-40f4-abe7-dedfd697b019",
        "55b08742-1808-494e-9e30-9d2a7be8f700",
        "56fec28b-e8aa-4c0f-8e4c-a559e73add88",
        "5b4d9d1d-b5f6-469c-b8c2-b97a45e6863b",
        "5bb50f15-e46d-4c82-847d-5a0304c1d53d",
        "5bf4e813-3b53-4c6e-b61a-d86a63755650",
        "5c1d0ba7-3856-48b9-8dc6-244bf107bf8c",
        "5cbf831a-3f08-497f-917f-57e09d84b141",
        "5d14e906-9266-4808-bd71-5925f2a3130a",
        "5df1cca2-01f8-4a87-b859-d5e5b7e1de47",
        "5df1cca2-01f8-4a87-b859-d5e5b7e1de48",
        "5df1cca2-01f8-4a87-b859-d5e5b7e1de49",
        "5df1cca2-01f8-4a87-b859-d5e5b7e1de4a",
        "5df1cca2-01f8-4a87-b859-d5e5b7e1de4b",
        "5df3cca2-01f8-4a87-b859-d5e5b7e1de47",
        "5df3cca2-01f8-4a87-b859-d5e5b7e1de48",
        "5df3cca2-01f8-4a87-b859-d5e5b7e1de49",
        "6040f18d-d5e5-4b60-9201-cd279cbcfed9",
        "64e6a887-3982-4f3b-ba20-6155e435325b",
        "6548ca01-86de-5be1-6582-807fcf4c95cf",
        "68c4b50f-0c20-4980-8602-58c62238d423",
        "6937ed8d-30ea-4ded-8271-4553ff02f68a",
        "6c68e068-bcf1-4ecc-b891-7625d1244b6b",
        "6d334120-95ce-4660-907a-d98035aa2b7c",
        "72245c31-4b39-42a6-8e73-7235ade16853",
        "74816d2a-2090-4670-8c48-ef39e7ff7c26",
        "752a0906-36a7-47bb-9b79-56cc6b746770",
        "75763ea3-011a-470e-8225-6f05ade25648",
        "7650f56e-b9f5-461b-83ad-f222af2aaadc",
        "76b1e67a-b045-4414-9d6d-2ad3a5fe3a7e",
        "77f3a910-48fa-489c-934e-2ae85ba8f772",
        "780e96d1-8d02-4d2b-ada4-5ba624a0eb10",
        "794f7ab9-b37d-3b33-a10d-30626419ce65",
        "7955de75-25bb-4153-a1a2-3029fcabb652",
        "7960ce18-d39b-4fc8-a04a-929734c6756c",
        "79d433d6-47fb-4df1-bfc9-f01d40bd9942",
        "79f6e96e-f50f-4015-8ba4-c2bc344ebd4e",
        "7a0c0aa7-ed89-4bd5-a8d9-15f4d9861c10",
        "7ae1fa72-029e-4dc5-a2f8-5fb763154150",
        "7bfb9e40-a6aa-45a7-9ff6-54c42105dd1f",
        "7cfe7825-54bb-4d9d-bec5-8ef66151d2ac",
        "7dd85cfe-1b99-4f68-8f82-8177f7cedf2b",
        "7dfe2088-63df-48ed-83b1-4ab829132995",
        "7f138a08-fbb7-4b09-8356-aa5f4e335c31",
        "7f68c5ed-3ccc-47a3-8c55-380d3b010892",
        "80baf614-f2f4-4c8a-8de3-065c78f6d5de",
        "81278ab5-41ab-16da-86c2-7f7bf0912f5b",
        "81b10b1c-e561-4093-9b4d-2ad482794a53",
        "856ddbc1-55f7-471f-a0f2-68ac4c904592",
        "8b2ccd7e-2ec0-446d-9285-33f07ce8ac04",
        "8f08e2e7-5a76-43e3-a13a-da3d91a9ef98",
        "8fad02d5-86f7-4d8d-b966-5a3761ba9f59",
        "90499a19-7ef2-4523-951c-a417a24acf93",
        "93a48168-8bf8-45d2-a2f8-4ac0931cc7a6",
        "93c901e8-6c78-4b4f-aec1-a6bb9e691624",
        "951ec6b1-fc83-586d-8b84-2452c8981625",
        "9572adf1-8f1d-481f-a15b-c61655f16a0e",
        "96bd1392-e667-40c4-89f9-1462dea6a9cc",
        "982b1162-3dd7-4618-af89-0c272d5d06d8",
        "9889f253-f188-4427-8d54-ce0c2423c5c1",
        "98f1fbe1-7a8d-42cb-b6fe-8fe698264f13",
        "99998653-5a3d-417f-9239-f1889e548b48",
        "9cbb5987-ef6d-4bc2-bf49-4617515a0f9a",
        "9cd8f292-98b2-4530-a1b6-2ded5fecbc26",
        "9e39b64d-ab5b-4905-acdc-787a77c6374d",
        "9e5e1bd1-90d0-4e1d-9554-844d46607f61",
        "9f4cbbb4-8cba-48b0-840d-dbb22a54c678",
        "9f77fac7-b4bd-4857-9d50-be8ef075daef",
        "9ff86872-e677-4814-9a20-5337ca732b98",
        "a0251452-4ad6-4b38-8426-c59a15493a7d",
        "a0c0cc4d-e96c-4d81-86dd-38b95e49c6df",
        "a0d009f7-8748-4ee2-ad44-afa6be997c51",
        "a234e429-3e39-494d-a37c-f462a2494514",
        "a37b81fc-9906-4ffd-9161-0024b360b657",
        "a4fe35f0-ade3-4981-af6b-ec195921682a",
        "a80f501a-9aac-4233-9784-aceaf92510b5",
        "a844cd09-5ecc-44b3-bb4e-1db07287139c",
        "a959ce07-ead3-33df-8ec1-b924abe019c4",
        "a9c86871-05dc-4a4d-8a5c-a4ecf26bbc46",
        "aa3a8dd5-b6e7-4ee2-baa9-dd6baced0a2b",
        "aab253eb-3301-4dc4-afba-b2f2ed9635a0",
        "aac2bbcf-9782-5420-b81e-7ae56af31815",
        "ae8386e6-cad9-4359-8f96-8eae51810526",
        "b0886276-849e-4c7a-8ae6-b56064532153",
        "b13df682-fc30-492b-8ea0-ed1f53c0b038",
        "b1a3c09f-299b-4612-a4f7-270f25a096ec",
        "b1cd0932-4570-4c69-8d38-89446561ace0",
        "b3161d95-1180-4376-96e1-4095568147ce",
        "b4131a82-dff5-4047-8a19-3b4d805f7176",
        "b5ded412-9d2f-5cb5-9b05-356a0b836c10",
        "b8de3f09-31cd-4d97-bd30-8d39f742bc61",
        "bae75f65-be30-4bee-964b-ff9e498fee37",
        "bb26d85f-cfd6-495f-93ab-b8566af9f8af",
        "bc792ebd-64fe-4b65-a0c0-901ce2b68636",
        "bf5eada6-88e6-445f-9d40-d9b9f8939896",
        "c1431dd3-b146-4d39-b959-0c69b096c512",
        "c167acd0-2ce6-426c-ace5-5e9275fea715",
        "c5cdc330-29df-4ec6-9da9-9fbdfcfc1b3e",
        "c8316cc0-aed2-41e0-bce0-c26ca74f85ec",
        "c89b8a2f-ac56-4460-8d2f-80023bec4fc5",
        "ca87256c-6fae-428e-bb83-25dfee51136b",
        "cca959e8-797e-4e83-9b87-036a74142fc4",
        "d0031202-cfac-4f00-ae6a-97af80b848f2",
        "d16bf4e6-da24-442c-bbd5-55549b5b94f3",
        "d277fa69-eb4c-42ef-ba4f-288f615c93c1",
        "d42df95d-a75b-47bf-8249-bc83820da38a",
        "d4a5ee56-7291-4073-bc1f-ccb8f5afdf96",
        "d4a6c425-2884-4a8f-8134-2835d7286cbf",
        "d61c904c-a495-487f-9a6f-971548c5bc9f",
        "d65405ab-3424-4833-8c9a-af5fdeb22872",
        "d720b4d4-f4b8-4530-a809-9193a571e7fc",
        "d7663702-d3a6-46e0-8f9b-50b95bb4f9c5",
        "d8f0bef8-91d2-4d47-a3f9-eaff4edb729f",
        "dbdd8b01-f1a1-46d1-9ee3-543bcc995980",
        "dc6dba7c-0b58-468d-9ca1-6db04cc0477c",
        "dcd4d798-4b0b-4300-8d85-410817faa032",
        "df25ea9f-9863-4088-8498-87a1f4686f92",
        "e0baa198-9796-41c9-8695-59437e67e66a",
        "e3685517-a584-479d-90b7-d689c7bf7c80",
        "e3d23d2e-6e2c-4e6d-91d9-704cd8dff79d",
        "e536af23-ac4f-4adc-8c66-4ff7c2702dd6",
        "e68a05d4-b60c-40f4-bcb9-f24d46467320",
        "e8019814-4a91-41b0-83a6-881a1775353e",
        "ea1a8071-7a70-4a61-af94-07303853f695",
        "f0fa3f3a-d4e8-4ad3-9c34-2308f32fcec9",
        "f237f327-5181-4f24-96a7-700a4e5fac62",
        "f52c09c6-8611-40ad-8e59-de3fd7030a40",
        "f56a206e-1b77-42ef-8f0d-b949f8d9b260",
        "f5cb0fdc-2d09-4f19-b5e1-76a0b3ee9267",
        "f8584665-64f4-44a0-ac0d-468d2b8fda83",
        "f88008e5-5631-45ed-ad98-8c6aa04cfb91",
        "f88d07ea-d815-4dd1-a234-4520ce4604a4",
        "fae3193a-0683-47d9-8df0-18cbb48984d8",
        "fdacec38-3700-4d73-91a1-2f998674238a",
        "fe621549-2cbf-4f94-9861-f817ea317747",
    ],
    "DFileSystemImageEvents": ["2c941fdf-975b-59be-a960-9a2a262853a5"],
    "DFileSystemImageImportEvents": ["d25c30f9-4087-4366-9e24-e55be286424b"],
    "DImageComboEvents": ["dd9da665-8594-11d1-b16a-00c0f0283628"],
    "DRendezvousSessionEvents": ["3fa19cf8-64c4-4f53-ae60-635b3806eca6"],
    "DTE2": ["2ee1e9fa-0afe-4348-a89f-ed9cb45c99cf"],
    "DWriteEngine2Events": ["27354137-7f64-5b0f-8f00-5d77afbe261e"],
    "Debugger2": ["8b5e2bfd-4642-4efe-8af4-0b2da9aaa23c"],
    "Debugger3": ["87dfc8da-67b4-4954-bb89-6a277a50bafc"],
    "Debugger4": ["133bad54-8e8d-451b-9db0-af38ed9819cc"],
    "Debugger5": ["c8bbaa3a-7e99-4630-942c-570f085141eb"],
    "DiagramNode": ["000c0370-0000-0000-c000-000000000046"],
    "DiagramNodeChildren": ["000c036f-0000-0000-c000-000000000046"],
    "DiagramNodes": ["000c036e-0000-0000-c000-000000000046"],
    "Dimensions": ["2281375c-8bd3-11d0-b4ef-00a0c9138ca4"],
    "DocumentProperties": ["2df8d04d-5bfa-101b-bde5-00aa0044de52"],
    "DocumentProperty": ["2df8d04e-5bfa-101b-bde5-00aa0044de52"],
    "EditPoint": ["c1ffe800-028b-4475-a907-14f51f19bb7d"],
    "EditPoint2": ["136afa9f-f243-4abb-a8f8-4c2d26c47163"],
    "Engines": ["9f998c5e-549e-4c74-9fd8-b3a93d85a248"],
    "ErrorItem": ["f49a191f-7258-493b-9310-5f7771ddf3d7"],
    "ErrorItems": ["dcf93a30-d013-42f4-8aee-9f5ba215fb8b"],
    "ExceptionGroups": ["21bdc491-f828-4846-9fd8-75c9148aea24"],
    "ExceptionSetting": ["115998bf-a603-4848-b5de-3b250a13d109"],
    "ExceptionSettings": ["0e1ab53b-4065-4884-a39f-02e16eb57f7d"],
    "Expression2": ["f15a2dad-5c82-4802-bebc-5431b6ed5557"],
    "Expressions": ["2685337a-bb9e-11d2-8ad1-00c04f79e479"],
    "FSMsoControl": ["000c0147-0000-0000-c000-000000000046"],
    "Field15": ["00000505-0000-0010-8000-00aa006d2ea4", "00001505-0000-0010-8000-00aa006d2ea4"],
    "Field20": ["0000054c-0000-0010-8000-00aa006d2ea4", "0000154c-0000-0010-8000-00aa006d2ea4"],
    "Fields15": ["00000506-0000-0010-8000-00aa006d2ea4", "00001506-0000-0010-8000-00aa006d2ea4"],
    "Fields20": ["0000054d-0000-0010-8000-00aa006d2ea4", "0000154d-0000-0010-8000-00aa006d2ea4"],
    "FileCodeModel": ["ed1a3f99-4477-11d3-89bf-00c04f688dde"],
    "FileCodeModel2": ["a65964df-3a07-45eb-882a-dd04602016b9"],
    "FileDialog": ["000c0362-0000-0000-c000-000000000046"],
    "FileDialogFilter": ["000c0364-0000-0000-c000-000000000046"],
    "FileDialogFilters": ["000c0365-0000-0000-c000-000000000046"],
    "FileDialogSelectedItems": ["000c0363-0000-0000-c000-000000000046"],
    "FileProperties": ["516bd64e-51c0-11d3-85cf-00c04f6123b3"],
    "FileProperties2": ["41be8d4d-f235-46d4-b9f8-c6d6459d503c"],
    "FileTypes": ["000c036c-0000-0000-c000-000000000046"],
    "FillFormat": ["000c0314-0000-0000-c000-000000000046"],
    "Find2": ["01568308-5b2a-4f30-8d0a-e10ee0f28f4a"],
    "FolderProperties": ["8e4aa768-51e1-11d3-85cf-00c04f6123b3"],
    "FolderProperties2": ["2aca2576-0738-466f-845f-16062ed8d1bc"],
    "FontsAndColorsItems": ["f25ae7e6-1460-4ba4-8e5e-bbbe746de353"],
    "FoundFiles": ["000c0331-0000-0000-c000-000000000046"],
    "FreeformBuilder": ["000c0315-0000-0000-c000-000000000046"],
    "GENCONNECTIONPOINT": ["6657b990-7ab3-11ce-b4fd-00aa004b9c05"],
    "GENCPCONTAINER": ["313df590-7ab3-11ce-b4fd-00aa004b9c05"],
    "Globals": ["e68a3e0e-b435-4dde-86b7-f5adefc19df2"],
    "GroupShapes": ["000c0316-0000-0000-c000-000000000046"],
    "HTMLProject": ["000c0356-0000-0000-c000-000000000046"],
    "HTMLProjectItem": ["000c0358-0000-0000-c000-000000000046"],
    "HTMLProjectItems": ["000c0357-0000-0000-c000-000000000046"],
    "Hierarchies": ["2281375b-8bd3-11d0-b4ef-00a0c9138ca4"],
    "Hierarchy": ["22813746-8bd3-11d0-b4ef-00a0c9138ca4"],
    "IADMEXT": ["51dfe970-f6f2-11d0-b9bd-00a0c922e750"],
    "IADsADSystemInfo": ["5bb11929-afd1-11d2-9cb9-0000f87a369e"],
    "IADsAccessControlEntry": ["b4f3a14c-9bdd-11d0-852c-00c04fd8d503"],
    "IADsAccessControlList": ["b7ee91cc-9bdd-11d0-852c-00c04fd8d503"],
    "IADsAcl": ["8452d3ab-0869-11d1-a377-00c04fb950dc"],
    "IADsAggregatee": ["1346ce8c-9039-11d0-8528-00c04fd8d503"],
    "IADsAggregator": ["52db5fb0-941f-11d0-8529-00c04fd8d503"],
    "IADsBackLink": ["fd1302bd-4080-11d1-a3ac-00c04fb950dc"],
    "IADsCaseIgnoreList": ["7b66b533-4680-11d1-a3b4-00c04fb950dc"],
    "IADsDNWithBinary": ["7e99c0a2-f935-11d2-ba96-00c04fb6d0d1"],
    "IADsDNWithString": ["370df02e-f934-11d2-ba96-00c04fb6d0d1"],
    "IADsDeleteOps": ["b2bd0902-8878-11d1-8c21-00c04fd8d503"],
    "IADsEmail": ["97af011a-478e-11d1-a3b4-00c04fb950dc"],
    "IADsFaxNumber": ["a910dea9-4680-11d1-a3b4-00c04fb950dc"],
    "IADsHold": ["b3eb3b37-4080-11d1-a3ac-00c04fb950dc"],
    "IADsLargeInteger": ["9068270b-0939-11d1-8be1-00c04fd8d503"],
    "IADsNameTranslate": ["b1b272a3-3625-11d1-a3a4-00c04fb950dc"],
    "IADsNetAddress": ["b21a50a9-4080-11d1-a3ac-00c04fb950dc"],
    "IADsOctetList": ["7b28b80f-4680-11d1-a3b4-00c04fb950dc"],
    "IADsPath": ["b287fcd5-4080-11d1-a3ac-00c04fb950dc"],
    "IADsPathname": ["d592aed4-f420-11d0-a36e-00c04fb950dc"],
    "IADsPostalAddress": ["7adecf29-4680-11d1-a3b4-00c04fb950dc"],
    "IADsPropertyEntry": ["05792c8e-941f-11d0-8529-00c04fd8d503"],
    "IADsPropertyValue": ["79fa9ad0-a97c-11d0-8534-00c04fd8d503"],
    "IADsPropertyValue2": ["306e831c-5bc7-11d1-a3b8-00c04fb950dc"],
    "IADsReplicaPointer": ["f60fb803-4080-11d1-a3ac-00c04fb950dc"],
    "IADsSecurityDescriptor": ["b8c787ca-9bdd-11d0-852c-00c04fd8d503"],
    "IADsTSUserEx": ["c4930e79-2989-4462-8a60-2fcf2f2955ef"],
    "IADsTimestamp": ["b2f5a901-4080-11d1-a3ac-00c04fb950dc"],
    "IADsTypedName": ["b371a349-4080-11d1-a3ac-00c04fb950dc"],
    "IADsWinNTSystemInfo": ["6c6d65dc-afd1-11d2-9cb9-0000f87a369e"],
    "IAESCheck": ["8aca8016-b08c-4c5a-99ca-c24488385828"],
    "IAICEventSink": ["70f2f87b-1319-4156-8bfb-69a35c25ec31"],
    "IAICProxy": ["c1a97c88-de59-470f-adcb-a6c916fca6c2"],
    "IAImmFnDocFeed": ["6e098993-9577-499a-a830-52344f3e200d"],
    "IAImmThreadCompartment": ["d251a968-2b44-4da5-a549-c1249ef01711"],
    "IALEventSink": ["00ab4ba8-98ad-4bff-92d9-d22a7a42d36c"],
    "IALink": ["c8e77f39-3604-4fd4-85cf-38bdeb233ad4"],
    "IALink2": ["c8e77f39-3604-4fd4-85cf-38bdeb233ad5"],
    "IALink3": ["22d4f7a0-0065-43dd-8eaf-b9fb901d8223"],
    "IAMAsyncReaderTimestampScaling": ["cf7b26fc-9a00-485b-8147-3e789d5e8f67"],
    "IAMAudioRendererStats": ["22320cb2-d41a-11d2-bf7c-d7cb9df0bf93"],
    "IAMCertifiedOutputProtection": ["6feded3e-0ff1-4901-a2f1-43f7012c8515"],
    "IAMChannelInfo": ["fa2aa8f2-8b62-11d0-a520-000000000000"],
    "IAMClockAdjust": ["4d5466b0-a49c-11d1-abe8-00a0c905f375"],
    "IAMClockSlave": ["9fd52741-176d-4b36-8f51-ca8f933223be"],
    "IAMDecoderCaps": ["c0dff467-d499-4986-972b-e1d9090fa941"],
    "IAMDeviceRemoval": ["f90a6130-b658-11d2-ae49-0000f8754b99"],
    "IAMErrorLog": ["e43e73a2-0efa-11d3-9601-00a0c9441e20"],
    "IAMExtendedErrorInfo": ["fa2aa8f6-8b62-11d0-a520-000000000000"],
    "IAMExtendedSeeking": ["fa2aa8f9-8b62-11d0-a520-000000000000"],
    "IAMFilterGraphCallback": ["56a868fd-0ad4-11ce-b0a3-0020af0ba770"],
    "IAMFilterMiscFlags": ["2dd74950-a890-11d1-abe8-00a0c905f375"],
    "IAMGraphBuilderCallback": ["4995f511-9ddb-4f12-bd3b-f04611807b79"],
    "IAMGraphStreams": ["632105fa-072e-11d3-8af9-00c04fb6bd3d"],
    "IAMLatency": ["62ea93ba-ec62-11d2-b770-00c04fb6bd3d"],
    "IAMMediaContent": ["fa2aa8f4-8b62-11d0-a520-000000000000"],
    "IAMMediaContent2": ["ce8f78c1-74d9-11d2-b09d-00a0c9a81117"],
    "IAMMediaStream": ["bebe595d-9a6f-11d0-8fde-00c04fd9189d"],
    "IAMMediaTypeSample": ["ab6b4afb-f6e4-11d0-900d-00c04fd9189d"],
    "IAMMediaTypeStream": ["ab6b4afa-f6e4-11d0-900d-00c04fd9189d"],
    "IAMMultiMediaStream": ["bebe595c-9a6f-11d0-8fde-00c04fd9189d"],
    "IAMNetShowConfig": ["fa2aa8f1-8b62-11d0-a520-000000000000"],
    "IAMNetShowExProps": ["fa2aa8f5-8b62-11d0-a520-000000000000"],
    "IAMNetShowPreroll": ["aae7e4e2-6388-11d1-8d93-006097c9a2b2"],
    "IAMNetworkStatus": ["fa2aa8f3-8b62-11d0-a520-000000000000"],
    "IAMOpenProgress": ["8e1c39a1-de53-11cf-aa63-0080c744528d"],
    "IAMOverlayFX": ["62fae250-7e65-4460-bfc9-6398b322073c"],
    "IAMParse": ["c47a3420-005c-11d2-9038-00a0c9697298"],
    "IAMPlayList": ["56a868fe-0ad4-11ce-b03a-0020af0ba770", "56a868fe-0ad4-11ce-b0a3-0020af0ba770"],
    "IAMPlayListItem": ["56a868ff-0ad4-11ce-b03a-0020af0ba770", "56a868ff-0ad4-11ce-b0a3-0020af0ba770"],
    "IAMPluginControl": ["0e26a181-f40c-4635-8786-976284b52981"],
    "IAMPushSource": ["f185fe76-e64e-11d2-b76e-00c04fb6bd3d"],
    "IAMRebuild": ["02ef04dd-7580-11d1-bece-00c04fb6e937"],
    "IAMResourceControl": ["8389d2d0-77d7-11d1-abe6-00a0c905f375"],
    "IAMSetErrorLog": ["963566da-be21-4eaf-88e9-35704f8f52a1"],
    "IAMStats": ["bc9bcf80-dcd2-11d2-abf6-00a0c905f375"],
    "IAMTimeline": ["78530b74-61f9-11d2-8cad-00a024580902"],
    "IAMTimelineComp": ["eae58536-622e-11d2-8cad-00a024580902"],
    "IAMTimelineEffect": ["bce0c264-622d-11d2-8cad-00a024580902"],
    "IAMTimelineEffectable": ["eae58537-622e-11d2-8cad-00a024580902"],
    "IAMTimelineGroup": ["9eed4f00-b8a6-11d2-8023-00c0df10d434"],
    "IAMTimelineObj": ["78530b77-61f9-11d2-8cad-00a024580902"],
    "IAMTimelineSplittable": ["a0f840a0-d590-11d2-8d55-00a0c9441e20"],
    "IAMTimelineSrc": ["78530b79-61f9-11d2-8cad-00a024580902"],
    "IAMTimelineTrack": ["eae58538-622e-11d2-8cad-00a024580902"],
    "IAMTimelineTrans": ["bce0c265-622d-11d2-8cad-00a024580902"],
    "IAMTimelineTransable": ["378fa386-622e-11d2-8cad-00a024580902"],
    "IAMTimelineVirtualTrack": ["a8ed5f80-c2c7-11d2-8d39-00a0c9441e20"],
    "IAMVideoAccelerator": ["256a6a22-fbad-11d1-82bf-00a0c9696c8f"],
    "IAMVideoAcceleratorNotify": ["256a6a21-fbad-11d1-82bf-00a0c9696c8f"],
    "IAMVideoControl": ["6a2e0670-28e4-11d0-a18c-00a0c9118956"],
    "IAMVideoDecimationProperties": ["60d32930-13da-11d3-9ec6-c4fcaef5c7be"],
    "IAMWMBufferPass": ["6dd816d7-e740-4123-9e24-2444412644d8"],
    "IAMWMBufferPassCallback": ["b25b8372-d2d2-44b2-8653-1b8dae332489"],
    "IAMWstDecoder": ["c056de21-75c2-11d3-a184-00105aef9f33"],
    "IAPOControlInternal": ["0ef25615-b134-4fba-80e3-e3ea2f74206e"],
    "IAPOWrapperSrv": ["69fed9b6-5405-48b8-3db0-4ca492fc3677"],
    "IASPError": ["f5a6893e-a0f5-11d1-8c4b-00c04fc324a4"],
    "IASTAThreadHostService": ["ba9efe23-058f-4d2c-9b2e-a567a32be176"],
    "IATSCChannelTuneRequest": ["0369b4e1-45b6-11d3-b650-00c04f79498e"],
    "IATSCComponentType": ["fc189e4d-7bd4-4125-b3b3-3a76a332cc96"],
    "IATSCLocator": ["bf8d986f-8c2b-4131-94d7-4d3d9fcc21ef"],
    "IATSCLocator2": ["612aa885-66cf-4090-ba0a-566f5312e4ca"],
    "IATSCTuningSpace": ["0369b4e2-45b6-11d3-b650-00c04f79498e"],
    "IATSC_EIT": ["d7c212d7-76a2-4b4b-aa56-846879a80096"],
    "IATSC_ETT": ["5a142cc9-b8cf-4a86-a040-e9cadf3ef3e7"],
    "IATSC_MGT": ["8877dabd-c137-4073-97e3-779407a5d87a"],
    "IATSC_STT": ["6bf42423-217d-4d6f-81e1-3a7b360ec896"],
    "IATSC_VCT": ["26879a18-32f9-46c6-91f0-fb6479270e8c"],
    "IAbandonmentNotification": ["000001de-0000-0000-c000-000000000046"],
    "IAboveLockActivationListener": ["e47e960d-799e-4d57-85a7-1784c0e17538"],
    "IAboveLockActivationManager": ["3721d4ef-bca1-418a-98e2-ec3def272b2f"],
    "IAboveLockActivationManagerMobileInternal": ["818a0a6a-4370-4977-9755-48ae570039ae"],
    "IAboveLockActivationManagerPriv": ["0b8a7d52-5a75-42b4-8b20-2355e6ef22b4"],
    "IAboveLockActivationManagerSingleViewPriv": ["dea01884-59aa-44dd-a3aa-4051599e0f44"],
    "IAboveLockViewManager": ["e3538e54-26a6-4534-96cd-7f10c89d41e2"],
    "IAboveWelcomeScreenActivationManager": ["66c98467-d867-47a9-b86e-2de58a3bb410"],
    "IAccClientDocMgr": ["4c896039-7b6d-49e6-a8c1-45116a98292b"],
    "IAccDictionary": ["1dc4cb5f-d737-474d-ade9-5ccfc9bc1cc9"],
    "IAccPropMgrInternal": ["2bd370a9-3e7f-4edd-8a85-f8fed1f8e51f"],
    "IAccProxyVersion": ["55f9c234-79cd-4699-89e7-5518fd88bcde"],
    "IAccServerDocMgr": ["ad7c73cf-6dd5-4855-abc2-b04bad5b9153"],
    "IAccStore": ["e2cd4a63-2b72-4d48-b739-95e4765195ba"],
    "IAccTimeout": ["f660d979-a938-423f-b5b9-12e4028c50b0"],
    "IAccTimeout2": ["e210ec43-d7fb-41bf-9456-c0b9f6d034f3"],
    "IAcceleratorCallback": ["8f95583e-818f-4c3b-b03d-2e6c70265f34"],
    "IAcceleratorKeyEventArgs": ["ff1c4c4a-9287-470b-836e-9086e3126ade"],
    "IAcceleratorKeyEventArgs2": ["d300a9f6-2f7e-4873-a555-166e596ee1c5"],
    "IAccelerometer": ["df184548-2711-4da7-8098-4b82205d3c7d"],
    "IAccelerometer2": ["e8f092ee-4964-401a-b602-220d7153c60a"],
    "IAccelerometer3": ["87e0022a-ed80-49eb-bf8a-a4ea31e5cd84"],
    "IAccelerometer4": ["1d373c4f-42d3-45b2-8144-ab7fb665eb59"],
    "IAccelerometer5": ["7e7e7021-def4-53a6-af43-806fd538edf6"],
    "IAccelerometerDataThreshold": ["f92c1b68-6320-5577-879e-9942621c3dd9"],
    "IAccelerometerDeviceId": ["7eac64a9-97d5-446d-ab5a-917df9b96a2c"],
    "IAccelerometerReading": ["b9fe7acb-d351-40af-8bb6-7aa9ae641fb7"],
    "IAccelerometerReading2": ["0a864aa2-15ae-4a40-be55-db58d7de7389"],
    "IAccelerometerReadingChangedEventArgs": ["0095c65b-b6ac-475a-9f44-8b32d35a3f25"],
    "IAccelerometerShakenEventArgs": ["95ff01d1-4a28-4f35-98e8-8178aae4084a"],
    "IAccelerometerStatics": ["a5e28b74-5a87-4a2d-becc-0f906ea061dd"],
    "IAccelerometerStatics2": ["c4c4842f-d86b-4685-b2d7-3396f798d57b"],
    "IAccelerometerStatics3": ["9de218cf-455d-4cf3-8200-70e1410340f8"],
    "IAcceptHeaderOptions": ["ac5c47c4-9561-49a6-a737-c3bba1d82c6b"],
    "IAccessKeyDisplayDismissedEventArgs": ["8a610dc6-d72d-4ca8-9f66-556f35b513da"],
    "IAccessKeyDisplayRequestedEventArgs": ["0c079e55-13fe-4d03-a61d-e12f06567286"],
    "IAccessKeyInvokedEventArgs": ["cfe9cd97-c718-4091-b7dd-adf1c072b1e1"],
    "IAccessKeyManager": ["ecc973b0-2ee9-4b1c-98d7-6e0e816d334b"],
    "IAccessKeyManagerStatics": ["4ca0efe6-d9c8-4ebc-b4c7-30d1838a81f1"],
    "IAccessKeyManagerStatics2": ["962bb594-2ab3-47c5-954b-7092f355f797"],
    "IAccessibilityDockingService": ["8849dc22-cedf-4c95-998d-051419dd3f76"],
    "IAccessibilityDockingServiceCallback": ["157733fd-a592-42e5-b594-248468c5a81b"],
    "IAccessibilityDockingServiceInternal": ["6d2586fd-5559-4747-9a8f-28031d259eca"],
    "IAccessibilitySettings": ["fe0e8147-c4c0-4562-b962-1327b52ad5b9"],
    "IAccessibleEx": ["f8b80ada-2c44-48d0-89be-5ff23c9cd875"],
    "IAccessibleHostingElementProviders": ["33ac331b-943e-4020-b295-db37784974a3"],
    "IAccessibleObject": ["95a391c5-9ed4-4c28-8401-ab9e06719e11"],
    "IAccessibleProxy": ["7a7d9dcf-b7a1-4019-9031-258268846980"],
    "IAccessibleServer": ["52c8fb5e-d779-4e77-ae9f-f611fa7e9d7a"],
    "IAccessibleWinSAT": ["30e6018a-94a8-4ff8-a69a-71b67413f07b"],
    "IAccessibleWindowlessSite": ["bf3abd9c-76da-4389-9eb6-1427d25abab7"],
    "IAccessor": ["0c733a8c-2a1c-11ce-ade5-00aa0044773d"],
    "IAccountingProviderConfig": ["66a2db18-d706-11d0-a37b-00c04fc9da04"],
    "IAccountsSettingsPane": ["81ea942c-4f09-4406-a538-838d9b14b7e6"],
    "IAccountsSettingsPaneCommandsRequestedEventArgs": ["3b68c099-db19-45d0-9abf-95d3773c9330"],
    "IAccountsSettingsPaneCommandsRequestedEventArgs2": ["362f7bad-4e37-4967-8c40-e78ee7a1e5bb"],
    "IAccountsSettingsPaneEventDeferral": ["cbf25d3f-e5ba-40ef-93da-65e096e5fb04"],
    "IAccountsSettingsPaneInterop": ["d3ee12ad-3865-4362-9746-b75a682df0e6"],
    "IAccountsSettingsPaneStatics": ["561f8b60-b0ec-4150-a8dc-208ee44b068a"],
    "IAccountsSettingsPaneStatics2": ["d21df7c2-ce0d-484f-b8e8-e823c215765e"],
    "IAccountsSettingsPaneStatics3": ["08410458-a2ba-4c6f-b4ac-48f514331216"],
    "IAcmWrapperConfigure": ["62f510f6-5173-49d5-8f69-56fba0b20f8d"],
    "IAcrylicBrush": ["79bbcf4e-cd66-4f1b-a8b6-cd6d2977c18d"],
    "IAcrylicBrush2": ["c9645383-b19e-5ac0-86ff-3d90506dbcda"],
    "IAcrylicBrushFactory": ["81a32568-f6cc-4013-8363-928ae23b7a61"],
    "IAcrylicBrushStatics": ["2787fd79-a3da-423f-b81a-599147971523"],
    "IAcrylicBrushStatics2": ["129188a8-bf11-5bbc-8445-8c510e5926c0"],
    "IActionCollection": ["02820e19-7b98-4ed2-b2e8-fdccceff619b"],
    "IActionHistory": ["8d5de85b-7d42-11d0-a8aa-00a0c921a4d2"],
    "IActionOnCLREvent": ["607be24b-d91b-4e28-a242-61871ce56e35"],
    "IActionSpaceFlow": ["00d0f427-ebb3-4304-b6f8-ae4fa0fa7c20"],
    "IActivatableClassInformation": ["8d80c0b8-7c1d-4a31-9d67-9395e73b7cf6"],
    "IActivatableClassRegistration": ["9bbcae23-3dd6-49c3-b63c-1c587e7a6a67"],
    "IActivateAudioInterfaceAsyncOperation": ["72a22d78-cde4-431d-b8cc-843a71199b6d"],
    "IActivateAudioInterfaceCompletionHandler": ["41d949ab-9862-444a-80f6-c261334da5eb"],
    "IActivatedDeferral": ["c3bd1978-a431-49d8-a76a-395a4e03dcf3"],
    "IActivatedEventArgs": ["cf651713-cd08-4fd8-b697-a281b6544e2e"],
    "IActivatedEventArgsDeferral": ["ca6d5f74-63c2-44a6-b97b-d9a03c20bc9b"],
    "IActivatedEventArgsWithUser": ["1cf09b9e-9962-4936-80ff-afc8e8ae5c8c"],
    "IActivatedEventHandler": ["50f1e730-c5d1-4b6b-9adb-8a11756be29c"],
    "IActivatedOperation": ["b6a0b4bc-c6ca-42fd-9818-71904e45fed7"],
    "IActivationBrokerManager": ["c499dffc-8907-4d47-89f3-712716a789f2"],
    "IActivationBrokerPlugin": ["75f91a54-fa3d-431d-8ee7-6bf000847e77"],
    "IActivationBrokerPluginDesktopAppX": ["a040189f-c2a2-4ff8-b6e1-1e628e598d26"],
    "IActivationBrokerPluginWithResult": ["b98dd1e5-633a-4266-9610-0f82ef69856e"],
    "IActivationContextInfo": ["000001a5-0000-0000-c000-000000000046"],
    "IActivationErrorPopup": ["9333bee8-82cb-475a-8801-e43f12818290"],
    "IActivationErrorPopupFactory": ["848eaf0a-4435-4d6f-bcdf-8f42ffb38400"],
    "IActivationFactory": ["00000035-0000-0000-c000-000000000046"],
    "IActivationFilter": ["00000017-0000-0000-c000-000000000046"],
    "IActivationLayoutPreferences": ["657a8842-0b5e-40e1-b8cb-9aafacc33aab"],
    "IActivationPropOutClean": ["0b0d5310-d195-42df-b9a2-83cf63f043aa"],
    "IActivationProperties": ["000001af-0000-0000-c000-000000000046"],
    "IActivationPropertiesIn": ["000001a2-0000-0000-c000-000000000046"],
    "IActivationPropertiesOut": ["000001a3-0000-0000-c000-000000000046"],
    "IActivationSecurityInfo": ["000001a6-0000-0000-c000-000000000046"],
    "IActivationSignalDetectionConfiguration": ["40d8be16-5217-581c-9ab2-ce9b2f2e8e00"],
    "IActivationSignalDetector": ["b5bf345f-a4d0-5b2b-8e65-b3c55ee756ff"],
    "IActivationStageInfo": ["000001a8-0000-0000-c000-000000000046"],
    "IActivationStoreHelper": ["a1dffaf7-0f96-44c0-a97e-507291947d64"],
    "IActivationViewSwitcher": ["dca71bb6-7350-492b-aac7-c8a13d7224ad"],
    "IActivationViewSwitcherFactory": ["a6b0e1a3-3104-4034-9baa-52ab1f8963a5"],
    "IActiveBasicDevice": ["b64d6974-6e79-49af-9933-908b6e9a160c"],
    "IActiveBasicDeviceStatics": ["6d33255d-3642-4618-9db6-43524f4deadc"],
    "IActiveDesigner": ["51aae3e0-7486-11cf-a0c2-00aa0062be57"],
    "IActiveIMMAppEx": ["d7a6f58a-d478-44ab-86c9-591c23a26534"],
    "IActiveMonitorChangedEventArgs": ["20d7186f-5c33-48d6-bea2-d9e9e5af5a95"],
    "IActiveMonitorChangedHandler": ["264e19dc-8a37-4dda-b863-d2323c263026"],
    "IActiveMonitorNotifier": ["4cafecdd-c315-464f-ab85-7d6db67b61b8"],
    "IActiveScriptContext": ["47f6bca8-8623-4b1a-9efc-5c26ba993494"],
    "IActiveScriptDataCache": ["f8d6dbd7-18ad-438d-a154-b3b1b04864a3"],
    "IActiveScriptErrorDebug110": ["516e42b6-89a8-4530-937b-5f0708431442"],
    "IActiveScriptLifecycleEventSink": ["cc1a2bea-d5e9-4161-9da7-9042b37549a7"],
    "IActiveScriptParseUTF864": ["5901662f-7138-43af-a3d3-2a854c4b8253"],
    "IActiveScriptProfilerCallback": ["740eca23-7d9d-42e5-ba9d-f8b24b1c7a9b"],
    "IActiveScriptProfilerCallback2": ["31b7f8ad-a637-409c-b22f-040995b6103d"],
    "IActiveScriptProfilerCallback3": ["6ac5ad25-2037-4687-91df-b59979d93d73"],
    "IActiveScriptProfilerControl": ["784b5ff0-69b0-47d1-a7dc-2518f4230e90"],
    "IActiveScriptProfilerControl2": ["47810165-498f-40be-94f1-653557e9e7da"],
    "IActiveScriptProfilerControl3": ["0b403015-f381-4023-a5d0-6fed076de716"],
    "IActiveScriptProfilerControl4": ["160f94fd-9dbc-40d4-9eac-2b71db3132f4"],
    "IActiveScriptProfilerControl5": ["1c01a2d1-8f0f-46a5-9720-0d7ed2c62f0a"],
    "IActiveScriptProfilerHeapEnum": ["32e4694e-0d37-419b-b93d-fa20ded6e8ea"],
    "IActiveScriptSiteDebugEx": ["bb722ccb-6ad2-41c6-b780-af9c03ee69f5"],
    "IActiveScriptSiteDebugHelper": ["eddf3210-989c-452b-bb30-bfdc338f0f32"],
    "IActiveScriptSiteUIControl": ["aedae97e-d7ee-4796-b960-7f092ae844ab"],
    "IActiveScriptStringCompare": ["58562769-ed52-42f7-8403-4963514e1f11"],
    "IActiveScriptWinRTErrorDebug": ["73a3f82a-0fe9-4b33-ba3b-fe095f697e0a"],
    "IActiveXPlugin": ["06dd38d1-d187-11cf-a80d-00c04fd74ad8"],
    "IActiveXUIHandlerSite": ["30510853-98b5-11cf-bb82-00aa00bdce0b"],
    "IActiveXUIHandlerSite2": ["7e3707b2-d087-4542-ac1f-a0d2fcd080fd"],
    "IActiveXUIHandlerSite3": ["7904009a-1238-47f4-901c-871375c34608"],
    "IActiveZBand": ["d97a25b9-e3df-444c-afc6-2d12c0ffee84"],
    "IActiveZBandNotification": ["0c40987c-7026-499e-adad-c164c0ffee84"],
    "IActiveZBandNotificationForMonitor": ["78c8b458-dd5a-4f32-9d8b-d45a19ae9e1f"],
    "IActiveZBandNotificationForMonitorService": ["0f019ffe-0388-4dcf-a2e2-f059a60a5704"],
    "IActivitySensor": ["cd7a630c-fb5f-48eb-b09b-a2708d1c61ef"],
    "IActivitySensorReading": ["85125a96-1472-40a2-b2ae-e1ef29226c78"],
    "IActivitySensorReadingChangeReport": ["4f3c2915-d93b-47bd-960a-f20fb2f322b9"],
    "IActivitySensorReadingChangedEventArgs": ["de386717-aeb6-4ec7-946a-d9cc19b951ec"],
    "IActivitySensorStatics": ["a71e0e9d-ee8b-45d1-b25b-08cc0df92ab6"],
    "IActivitySensorTrigger": ["d0dd4342-e37b-4823-a5fe-6b31dfefdeb0"],
    "IActivitySensorTriggerDetails": ["2c9e6612-b9ca-4677-b263-243297f79d3a"],
    "IActivitySensorTriggerFactory": ["a72691c3-3837-44f7-831b-0132cc872bc3"],
    "IAdapterPnpManagement": ["706f2368-4086-47f5-b913-57b76eed1a32"],
    "IAdapterPowerManagement": ["793417d0-35fe-11d1-ad08-00a0c90ab1b0"],
    "IAdapterPowerManagement2": ["e0f92e5d-67f5-48ee-b57a-7d1e90c5f43d"],
    "IAdapterPowerManagement3": ["a8c7303e-f80c-4bc9-b2e3-fb2d08be920f"],
    "IAdaptiveCard": ["72d0568c-a274-41cd-82a8-989d40b9b05e"],
    "IAdaptiveCardBuilderStatics": ["766d8f08-d3fe-4347-a0bc-b9ea9a6dc28e"],
    "IAdaptiveMediaSource": ["4c7332ef-d39f-4396-b4d9-043957a7c964"],
    "IAdaptiveMediaSource2": ["17890342-6760-4bb9-a58a-f7aa98b08c0e"],
    "IAdaptiveMediaSource3": ["ba7023fd-c334-461b-a36e-c99f54f7174a"],
    "IAdaptiveMediaSourceAdvancedSettings": ["55db1680-1aeb-47dc-aa08-9a11610ba45a"],
    "IAdaptiveMediaSourceCorrelatedTimes": ["05108787-e032-48e1-ab8d-002b0b3051df"],
    "IAdaptiveMediaSourceCreationResult": ["4686b6b2-800f-4e31-9093-76d4782013e7"],
    "IAdaptiveMediaSourceCreationResult2": ["1c3243bf-1c44-404b-a201-df45ac7898e8"],
    "IAdaptiveMediaSourceDiagnosticAvailableEventArgs": ["3af64f06-6d9c-494a-b7a9-b3a5dee6ad68"],
    "IAdaptiveMediaSourceDiagnosticAvailableEventArgs2": ["8c6dd857-16a5-4d9f-810e-00bd901b3ef9"],
    "IAdaptiveMediaSourceDiagnosticAvailableEventArgs3": ["c3650cd5-daeb-4103-84da-68769ad513ff"],
    "IAdaptiveMediaSourceDiagnostics": ["9b24ee68-962e-448c-aebf-b29b56098e23"],
    "IAdaptiveMediaSourceDownloadBitrateChangedEventArgs": ["670c0a44-e04e-4eff-816a-17399f78f4ba"],
    "IAdaptiveMediaSourceDownloadBitrateChangedEventArgs2": ["f3f1f444-96ae-4de0-b540-2b3246e6968c"],
    "IAdaptiveMediaSourceDownloadCompletedEventArgs": ["19240dc3-5b37-4a1a-8970-d621cb6ca83b"],
    "IAdaptiveMediaSourceDownloadCompletedEventArgs2": ["704744c4-964a-40e4-af95-9177dd6dfa00"],
    "IAdaptiveMediaSourceDownloadCompletedEventArgs3": ["0f8a8bd1-93b2-47c6-badc-8be2c8f7f6e8"],
    "IAdaptiveMediaSourceDownloadFailedEventArgs": ["37739048-f4ab-40a4-b135-c6dfd8bd7ff1"],
    "IAdaptiveMediaSourceDownloadFailedEventArgs2": ["70919568-967c-4986-90c5-c6fc4b31e2d8"],
    "IAdaptiveMediaSourceDownloadFailedEventArgs3": ["d0354549-1132-4a10-915a-c2211b5b9409"],
    "IAdaptiveMediaSourceDownloadRequestedDeferral": ["05c68f64-fa20-4dbd-9821-4bf4c9bf77ab"],
    "IAdaptiveMediaSourceDownloadRequestedEventArgs": ["c83fdffd-44a9-47a2-bf96-03398b4bfaaf"],
    "IAdaptiveMediaSourceDownloadRequestedEventArgs2": ["b37d8bfe-aa44-4d82-825b-611de3bcfecb"],
    "IAdaptiveMediaSourceDownloadRequestedEventArgs3": ["333c50fd-4f62-4481-ab44-1e47b0574225"],
    "IAdaptiveMediaSourceDownloadResult": ["f4afdc73-bcee-4a6a-9f0a-fec41e2339b0"],
    "IAdaptiveMediaSourceDownloadResult2": ["15552cb7-7b80-4ac4-8660-a4b97f7c70f0"],
    "IAdaptiveMediaSourceDownloadStatistics": ["a306cefb-e96a-4dff-a9b8-1ae08c01ae98"],
    "IAdaptiveMediaSourcePlaybackBitrateChangedEventArgs": ["23a29f6d-7dda-4a51-87a9-6fa8c5b292be"],
    "IAdaptiveMediaSourceStatics": ["50a6bd5d-66ef-4cd3-9579-9e660507dc3f"],
    "IAdaptiveNotificationContent": ["eb0dbe66-7448-448d-9db8-d78acd2abba9"],
    "IAdaptiveNotificationText": ["46d4a3be-609a-4326-a40b-bfde872034a3"],
    "IAdaptiveSpatialAudioRenderer": ["24bdc606-d710-4d62-be35-be665fbc3e00"],
    "IAdaptiveTrigger": ["a5f04119-0cd9-49f1-a23f-44e547ab9f1a"],
    "IAdaptiveTriggerFactory": ["c966d482-5aeb-4841-9247-c1a0bdd6f59f"],
    "IAdaptiveTriggerStatics": ["b92e29ea-1615-4350-9c3b-92b2986bf444"],
    "IAdcChannel": ["040bf414-2588-4a56-abef-73a260acc60a"],
    "IAdcController": ["2a76e4b0-a896-4219-86b6-ea8cdce98f56"],
    "IAdcControllerProvider": ["be545828-816d-4de5-a048-aba06958aaa8"],
    "IAdcControllerStatics": ["cce98e0c-01f8-4891-bc3b-be53ef279ca4"],
    "IAdcControllerStatics2": ["a2b93b1d-977b-4f5a-a5fe-a6abaffe6484"],
    "IAdcProvider": ["28953668-9359-4c57-bc88-e275e81638c9"],
    "IAddAppointmentOperation": ["ec4a9af3-620d-4c69-add7-9794e918081f"],
    "IAddDeleteThemeTransition": ["adec852e-4424-4dab-99c1-3a04e36a3c48"],
    "IAddPackageOptions": ["05cee018-f68f-422b-95a4-66679ec77fc0"],
    "IAddPagesEventArgs": ["e2e52be5-056c-4420-9795-cb3526ce0c20"],
    "IAddPagesEventHandler": ["d4b57970-57a0-4209-847c-c093b54bc729"],
    "IAddinDesigner": ["ac0714f3-3d04-11d1-ae7d-00a0c90f26f4"],
    "IAddinInstance": ["ac0714f4-3d04-11d1-ae7d-00a0c90f26f4"],
    "IAddressBand": ["22c440df-4720-4b3a-a472-0ccb6e6cdd97"],
    "IAddressBandEx": ["a695888c-e3fe-47c2-82c0-ccd5890a243f"],
    "IAddressEditBox": ["4acda08f-21cf-45ae-a5d5-75cb63d3c4ee"],
    "IAdvancedCapturedPhoto": ["f072728b-b292-4491-9d41-99807a550bbf"],
    "IAdvancedCapturedPhoto2": ["18cf6cd8-cffe-42d8-8104-017bb318f4a1"],
    "IAdvancedColorInfo": ["8797dcfb-b229-4081-ae9a-2cc85e34ad6a"],
    "IAdvancedMediaCapture": ["d0751585-d216-4344-b5bf-463b68f977bb"],
    "IAdvancedMediaCaptureInitializationSettings": ["3de21209-8ba6-4f2a-a577-2819b56ff14d"],
    "IAdvancedMediaCaptureSettings": ["24e0485f-a33e-4aa1-b564-6019b1d14f65"],
    "IAdvancedPhotoCapture": ["83ffaafa-6667-44dc-973c-a6bce596aa0f"],
    "IAdvancedPhotoCaptureSettings": ["08f3863a-0018-445b-93d2-646d1c5ed05c"],
    "IAdvancedPhotoControl": ["c5b15486-9001-4682-9309-68eae0080eec"],
    "IAdvancedSettingsWriter": ["5d703587-da7e-43c0-982c-2ba8e7ed341b"],
    "IAdvancedVideoCaptureDeviceController": ["de6ff4d3-2b96-4583-80ab-b5b01dc6a8d7"],
    "IAdvancedVideoCaptureDeviceController2": ["8bb94f8f-f11a-43db-b402-11930b80ae56"],
    "IAdvancedVideoCaptureDeviceController3": ["a98b8f34-ee0d-470c-b9f0-4229c4bbd089"],
    "IAdvancedVideoCaptureDeviceController4": ["ea9fbfaf-d371-41c3-9a17-824a87ebdfd2"],
    "IAdvancedVideoCaptureDeviceController5": ["33512b17-b9cb-4a23-b875-f9eaab535492"],
    "IAdvancedVideoCaptureDeviceController6": ["b6563a53-68a1-44b7-9f89-b5fa97ac0cbe"],
    "IAdvancedVideoCaptureDeviceController7": ["8d2927f0-a054-50e7-b7df-7c04234d10f0"],
    "IAdvancedVideoCaptureDeviceController8": ["d843f010-e7fb-595b-9a78-0e54c4532b43"],
    "IAdvertisingManagerForUser": ["928bf3d0-cf7c-4ab0-a7dc-6dc5bcd44252"],
    "IAdvertisingManagerStatics": ["add3468c-a273-48cb-b346-3544522d5581"],
    "IAdvertisingManagerStatics2": ["dd0947af-1a6d-46b0-95bc-f3f9d6beb9fb"],
    "IAdviseOplockCallback": ["68766f36-3808-42f9-a18f-0abde6391172"],
    "IAgentTransportShutdownCallback": ["1eca6ebc-4b7a-4ba6-8516-db38df0045a5"],
    "IAggregateContactManager": ["0379d5dd-db5a-4fd3-b54e-4df17917a212"],
    "IAggregateContactManager2": ["5e8cc2d8-a9cd-4430-9c4b-01348db2ca50"],
    "IAggregateMultipleValues": ["24ebb68f-764b-484f-8e96-1be0c78a45e6"],
    "IAggregatePropertyStoreFactory": ["ab0a3f41-c316-458c-92e6-6d1495590def"],
    "IAggregatedIdentity": ["00000039-0000-0000-c000-000000000046"],
    "IAggregatedInterruptResponse": ["21b98aa2-dbd8-4e6b-821c-ac9c015a0609"],
    "IAggregator": ["000001d8-0000-0000-c000-000000000046"],
    "IAgileObject": ["94ea2b94-e9cc-49e0-c0ff-ee64ca8f5b90"],
    "IAgileReference": ["c03f6a43-65a4-9818-987e-e0b810d2a6f2"],
    "IAimInterop": ["7fc7255a-3a9d-4776-9bbb-a435510ef6ea"],
    "IAlarmApplicationManagerStatics": ["ca03fa3b-cce6-4de2-b09b-9628bd33bbbe"],
    "IAlertDataCollector": ["03837516-098b-11d8-9414-505054503030"],
    "IAliasedNamespace": ["fdbee76e-f12b-408e-93ab-9be8521000d9"],
    "IAllJoynAboutData": ["e5a9bf00-1fa2-4839-93ef-f9df404890f7"],
    "IAllJoynAboutDataView": ["6823111f-6212-4934-9c48-e19ca4984288"],
    "IAllJoynAboutDataViewStatics": ["57edb688-0c5e-416e-88b5-39b32d25c47d"],
    "IAllJoynAcceptSessionJoiner": ["4da817d2-cd1d-4023-a7c4-16def89c28df"],
    "IAllJoynAcceptSessionJoinerEventArgs": ["4efb5365-3e8a-4257-8f10-539ce0d56c0f"],
    "IAllJoynAcceptSessionJoinerEventArgsFactory": ["b4435bc0-6145-429e-84db-d5bfe772b14f"],
    "IAllJoynAuthenticationCompleteEventArgs": ["97b4701c-15dc-4b53-b6a4-7d134300d7bf"],
    "IAllJoynBusAttachment": ["f309f153-1eed-42c3-a20e-436d41fe62f6"],
    "IAllJoynBusAttachment2": ["3474cb1e-2368-43b2-b43e-6a3ac1278d98"],
    "IAllJoynBusAttachmentFactory": ["642ef1a4-ad85-4ddf-90ae-604452b22288"],
    "IAllJoynBusAttachmentStateChangedEventArgs": ["d82e75f4-c02a-41ec-a8d5-eab1558953aa"],
    "IAllJoynBusAttachmentStatics": ["839d4d3d-1051-40d7-872a-8d0141115b1f"],
    "IAllJoynBusObject": ["e8fd825e-f73a-490c-8804-04e026643047"],
    "IAllJoynBusObjectFactory": ["2c2f9f0b-8e02-4f9c-ac27-ea6dad5d3b50"],
    "IAllJoynBusObjectStoppedEventArgs": ["de102115-ef8e-4d42-b93b-a2ae74519766"],
    "IAllJoynBusObjectStoppedEventArgsFactory": ["6b22fd48-d0a3-4255-953a-4772b4028073"],
    "IAllJoynCredentials": ["824650f2-a190-40b1-abab-349ec244dfaa"],
    "IAllJoynCredentialsRequestedEventArgs": ["6a87e34e-b069-4b80-9e1a-41bc837c65d2"],
    "IAllJoynCredentialsVerificationRequestedEventArgs": ["800a7612-b805-44af-a2e1-792ab655a2d0"],
    "IAllJoynMessageInfo": ["ff2b0127-2c12-4859-aa3a-c74461ee814c"],
    "IAllJoynMessageInfoFactory": ["34664c2a-8289-43d4-b4a8-3f4de359f043"],
    "IAllJoynProducer": ["9d084679-469b-495a-a710-ac50f123069f"],
    "IAllJoynProducerStoppedEventArgs": ["51309770-4937-492d-8080-236439987ceb"],
    "IAllJoynProducerStoppedEventArgsFactory": ["56529961-b219-4d6e-9f78-fa3f99fa8fe5"],
    "IAllJoynServiceInfo": ["4cbe8209-b93e-4182-999b-ddd000f9c575"],
    "IAllJoynServiceInfoFactory": ["7581dabd-fe03-4f4b-94a4-f02fdcbd11b8"],
    "IAllJoynServiceInfoRemovedEventArgs": ["3057a95f-1d3f-41f3-8969-e32792627396"],
    "IAllJoynServiceInfoRemovedEventArgsFactory": ["0dbf8627-9aff-4955-9227-6953baf41569"],
    "IAllJoynServiceInfoStatics": ["5678570a-603a-49fc-b750-0ef13609213c"],
    "IAllJoynSession": ["e8d11b0c-c0d4-406c-88a9-a93efa85d4b1"],
    "IAllJoynSessionJoinedEventArgs": ["9e9f5bd0-b5d7-47c5-8dab-b040cc192871"],
    "IAllJoynSessionJoinedEventArgsFactory": ["6824d689-d6cb-4d9e-a09e-35806870b17f"],
    "IAllJoynSessionLostEventArgs": ["e766a48a-8bb8-4954-ae67-d2fa43d1f96b"],
    "IAllJoynSessionLostEventArgsFactory": ["13bbfd32-d2f4-49c9-980e-2805e13586b1"],
    "IAllJoynSessionMemberAddedEventArgs": ["49a2798a-0dd1-46c1-9cd6-27190e503a5e"],
    "IAllJoynSessionMemberAddedEventArgsFactory": ["341de352-1d33-40a1-a1d3-e5777020e1f1"],
    "IAllJoynSessionMemberRemovedEventArgs": ["409a219f-aa4a-4893-b430-baa1b63c6219"],
    "IAllJoynSessionMemberRemovedEventArgsFactory": ["c4d355e8-42b8-4b67-b757-d0cfcad59280"],
    "IAllJoynSessionStatics": ["9e05d604-a06c-46d4-b46c-0b0b54105b44"],
    "IAllJoynStatusStatics": ["d0b7a17e-0d29-4da9-8ac6-54c554bedbc5"],
    "IAllJoynWatcherStoppedEventArgs": ["c9fca03b-701d-4aa8-97dd-a2bb0a8f5fa3"],
    "IAllJoynWatcherStoppedEventArgsFactory": ["878fa5a8-2d50-47e1-904a-20bf0d48c782"],
    "IAllUpViewHost": ["389221b7-bf28-4d25-9501-b4491d822be1"],
    "IAllUpViewInvoker": ["e053969d-e07d-482d-ae3b-17d1f01bf1ad"],
    "IAllocatorMXF": ["a5f0d62c-b30f-11d2-b7a3-0060083316c1", "a5f0d62c-b30f-11d2-b7a3-0060083316c1"],
    "IAltTabLoadSink": ["528ffb4c-0620-4c0f-ab7c-f85596896e09"],
    "IAltTabViewHost": ["405444d2-baa5-48ed-abfe-a673f70be863"],
    "IAlterIndex": ["0c733aa6-2a1c-11ce-ade5-00aa0044773d"],
    "IAlterTable": ["0c733aa5-2a1c-11ce-ade5-00aa0044773d"],
    "IAlternateWordForm": ["47396c1e-51b9-4207-9146-248e636a1d1d"],
    "IAlternativeName": ["728ab313-217d-11da-b2a4-000e7bbb2b09"],
    "IAlternativeNames": ["728ab314-217d-11da-b2a4-000e7bbb2b09"],
    "IAltimeter": ["72f057fd-8f04-49f1-b4a7-f4e363b701a2"],
    "IAltimeter2": ["c9471bf9-2add-48f5-9f08-3d0c7660d938"],
    "IAltimeterReading": ["fbe8ef73-7f5e-48c8-aa1a-f1f3befc1144"],
    "IAltimeterReading2": ["543a1bd9-6d0b-42b2-bd69-bc8fae0f782c"],
    "IAltimeterReadingChangedEventArgs": ["7069d077-446d-47f7-998c-ebc23b45e4a2"],
    "IAltimeterStatics": ["9eb4d7c3-e5ac-47ce-8eef-d3718168c01f"],
    "IAmAFiringAgent": ["0771cb93-da7c-44b5-8196-422e6a2fbc40"],
    "IAmbientLight": ["a48130a1-b7c4-46f7-b9bf-daf43a44e6ee"],
    "IAmbientLight2": ["3b64a6bf-5f97-4c94-86e5-042dd386b27d"],
    "IAmsiStream": ["3e47f2e5-81d4-4d3b-897f-545096770373"],
    "IAnalogAudioComponentType": ["2cfeb2a8-1787-4a24-a941-c6eaec39c842"],
    "IAnalogLocator": ["34d1f26b-e339-430d-abce-738cb48984dc"],
    "IAnalogRadioTuningSpace": ["2a6e293b-2595-11d3-b64c-00c04f79498e"],
    "IAnalogRadioTuningSpace2": ["39dd45da-2da8-46ba-8a8a-87e2b73d983a"],
    "IAnalogTVTuningSpace": ["2a6e293c-2595-11d3-b64c-00c04f79498e"],
    "IAnalyticsInfoStatics": ["1d5ee066-188d-5ba9-4387-acaeb0e7e305"],
    "IAnalyticsInfoStatics2": ["101704ea-a7f9-46d2-ab94-016865afdb25"],
    "IAnalyticsVersionInfo": ["926130b8-9955-4c74-bdc1-7cd0decf9b03"],
    "IAnchorRequestedEventArgs": ["5175f55d-4785-5a72-b462-eb11e9bdf897"],
    "IAnimateWindowSize": ["22e4c895-8ab9-40bb-b81a-001dd9b1f449"],
    "IAnimationController": ["c934efd2-0722-4f5f-a4e2-9510f3d43bf7"],
    "IAnimationControllerStatics": ["e71164df-651b-4800-b9e5-6a3bcfed3365"],
    "IAnimationDescription": ["7d11a549-be3d-41de-b081-05c149962f9b"],
    "IAnimationDescriptionFactory": ["c6e27abe-c1fb-48b5-9271-ecc70ac86ef0"],
    "IAnimationObject": ["e7141e0a-04b8-4fc5-a4dc-195392e57807"],
    "IAnimationPropertyInfo": ["f4716f05-ed77-4e3c-b328-5c3985b3738f"],
    "IAnnotationPatternIdentifiers": ["d475a0c1-48b2-4e40-a6cf-3dc4b638c0de"],
    "IAnnotationPatternIdentifiersStatics": ["e0e3a35d-d167-46dc-95ab-330af61aebb5"],
    "IAnnotationProvider": ["95ba1417-4437-451b-9461-050a49b59d06", "f95c7e80-bd63-4601-9782-445ebff011fc"],
    "IAntimalware": ["82d29c2e-f062-44e6-b5c9-3d9a2f24a2df"],
    "IAntimalwareProvider": ["b2cabfe3-fe04-42b1-a5df-08d483d4d125"],
    "IAntimalwareUacProvider": ["b2cabfe4-fe04-42b1-a5df-08d483d4d125"],
    "IApartmentCallback": ["178e5337-1528-4591-b1c9-1c6e484686d8"],
    "IApartmentShutdown": ["a2f05a09-27a2-42b5-bc0e-ac163ef49d9b"],
    "IApiInformationStatics": ["997439fe-f681-4a11-b416-c13a47e8ba36"],
    "IApiTracingDataCollector": ["0383751a-098b-11d8-9414-505054503030"],
    "IAppActivationFailedHandler": ["ba8e2d49-2e77-4442-bf1c-34c22bedf42e"],
    "IAppActivationRemediationInfo": ["23655ae6-d92b-416f-b4d6-7c8218038718"],
    "IAppActivationResult": ["6b528900-f46e-4eb0-aa6c-38af557cf9ed"],
    "IAppActivationUIInfo": ["abad189d-9fa3-4278-b3ca-8ca448a88dcb"],
    "IAppApplicabilityStatics": ["1664a082-0f38-5c99-83e4-48995970861c"],
    "IAppBar": ["7b0fc253-86a5-4b43-9872-0b8a6234b74b"],
    "IAppBar2": ["c3ab17b3-7ad7-4676-9910-7fe3f0e8e993"],
    "IAppBar3": ["982b001f-752e-4e7a-b055-54802c9ea749"],
    "IAppBar4": ["94ebc8cd-0a64-4da3-bf43-f13100a46605"],
    "IAppBarAutomationPeer": ["8b4acfeb-89fa-4f13-84be-35ca5b7c9590"],
    "IAppBarAutomationPeerFactory": ["8360f4e2-e396-4517-af5d-f4cf34c54edf"],
    "IAppBarButton": ["4459a451-69e8-440c-9896-4bb4f5f642d1"],
    "IAppBarButton3": ["0b282150-198b-4e84-8f1c-9f6a8ba267a7"],
    "IAppBarButton4": ["958fce6b-fd08-4414-8458-9d40866dc84e"],
    "IAppBarButton5": ["4096fc7f-1aec-4b0f-a031-ca8c4e06d2ed"],
    "IAppBarButtonAutomationPeer": ["443262b2-4f6d-4b76-9d2e-3eff777e8864"],
    "IAppBarButtonAutomationPeerFactory": ["aef0342a-acb7-42dc-97e3-847071865fd6"],
    "IAppBarButtonFactory": ["bdbb1bb6-cb2e-4276-abd6-7935130510e0"],
    "IAppBarButtonStatics": ["7ccd13e6-5301-407f-874e-dc9160aa07af"],
    "IAppBarButtonStatics3": ["4d7bf314-2ede-4328-8906-752a1f27cdfa"],
    "IAppBarButtonStatics4": ["1c0ae26a-c755-4fe6-a3b6-0e3394e952c0"],
    "IAppBarButtonTemplateSettings": ["cbc9b39d-0c95-4951-bff2-13963691c366"],
    "IAppBarElementContainer": ["1d5ba067-a990-5dab-a9c3-e6be56642a1a"],
    "IAppBarElementContainerFactory": ["b506530e-8897-5d6f-a43e-f0586338d282"],
    "IAppBarElementContainerStatics": ["ebbef840-c745-5a6f-8671-9a41eb2196e7"],
    "IAppBarFactory": ["614708d1-8e65-43cb-92d7-8eee17515f8d"],
    "IAppBarOverrides": ["f003e4e2-7b0f-4f4a-970d-ae8a0eaa9b70"],
    "IAppBarOverrides3": ["412bbbc8-51d0-4b49-ab62-a3dd6bdcb298"],
    "IAppBarSeparator": ["1b0795a1-1bc1-4d53-95ea-fb0a2cccc905"],
    "IAppBarSeparatorFactory": ["05da25cd-f407-48de-8b50-ff87d1e2818f"],
    "IAppBarSeparatorStatics": ["37f23484-5b35-4663-a75d-f2d50cb9c619"],
    "IAppBarSeparatorStatics3": ["36c753f9-7373-4e5e-9ba4-c3622a003c4e"],
    "IAppBarStatics": ["79bb7e8d-dca9-4b5f-a448-37b13238ed76"],
    "IAppBarStatics2": ["222355e9-0384-49de-8738-dfc9d409ac5d"],
    "IAppBarStatics4": ["ba02082e-1165-4451-94b3-eb3ac73e4196"],
    "IAppBarTemplateSettings": ["bcc2a863-eb35-423c-8389-d7827be3bf67"],
    "IAppBarTemplateSettings2": ["cbe66259-0399-5bcc-b925-4d5f5c9a4568"],
    "IAppBarToggleButton": ["2e914438-fd53-4b8d-858b-3644269f8e4d"],
    "IAppBarToggleButton3": ["ef9a85e5-16ff-4d72-b9e8-9b861eaf84a8"],
    "IAppBarToggleButton4": ["b86b736e-3eaf-4751-a897-00029f1f6aca"],
    "IAppBarToggleButton5": ["9dca3357-c130-4fb6-a1e2-d2b348fe43be"],
    "IAppBarToggleButtonAutomationPeer": ["8464efad-9655-4aff-9550-63ae9ec8fe9c"],
    "IAppBarToggleButtonAutomationPeerFactory": ["d6f9139d-02c1-4221-9591-7d4efeb74701"],
    "IAppBarToggleButtonFactory": ["028aa7d4-8f54-45a6-9f90-13605656d793"],
    "IAppBarToggleButtonStatics": ["fe5aaf96-7929-4da1-aa67-cddf73a3e4b5"],
    "IAppBarToggleButtonStatics3": ["bd4c65bf-2edd-44d1-acd5-35c00e2f21bc"],
    "IAppBarToggleButtonStatics4": ["a478b984-e916-4137-bdbd-95bd46ff3ce6"],
    "IAppBarToggleButtonTemplateSettings": ["aaf99c48-d8f4-40d9-9fa3-3a64f0fec5d8"],
    "IAppBridgeData": ["d7bcecce-d68c-405d-b48f-fd7e70ad1e05"],
    "IAppBroadcastBackgroundService": ["bad1e72a-fa94-46f9-95fc-d71511cda70b"],
    "IAppBroadcastBackgroundService2": ["fc8ccbbf-5549-4b87-959f-23ca401fd473"],
    "IAppBroadcastBackgroundServiceSignInInfo": ["5e735275-88c8-4eca-89ba-4825985db880"],
    "IAppBroadcastBackgroundServiceSignInInfo2": ["9104285c-62cf-4a3c-a7ee-aeb507404645"],
    "IAppBroadcastBackgroundServiceStreamInfo": ["31dc02bc-990a-4904-aa96-fe364381f136"],
    "IAppBroadcastBackgroundServiceStreamInfo2": ["bd1e9f6d-94dc-4fce-9541-a9f129596334"],
    "IAppBroadcastCameraCaptureStateChangedEventArgs": ["1e334cd0-b882-4b88-8692-05999aceb70f"],
    "IAppBroadcastGlobalSettings": ["b2cb27a5-70fc-4e17-80bd-6ba0fd3ff3a0"],
    "IAppBroadcastHeartbeatRequestedEventArgs": ["cea54283-ee51-4dbf-9472-79a9ed4e2165"],
    "IAppBroadcastManagerStatics": ["364e018b-1e4e-411f-ab3e-92959844c156"],
    "IAppBroadcastMicrophoneCaptureStateChangedEventArgs": ["a86ad5e9-9440-4908-9d09-65b7e315d795"],
    "IAppBroadcastPlugIn": ["520c1e66-6513-4574-ac54-23b79729615b"],
    "IAppBroadcastPlugInManager": ["e550d979-27a1-49a7-bbf4-d7a9e9d07668"],
    "IAppBroadcastPlugInManagerStatics": ["f2645c20-5c76-4cdc-9364-82fe9eb6534d"],
    "IAppBroadcastPlugInStateChangedEventArgs": ["4881d0f2-abc5-4fc6-84b0-89370bb47212"],
    "IAppBroadcastPreview": ["14b60f5a-6e4a-4b80-a14f-67ee77d153e7"],
    "IAppBroadcastPreviewStateChangedEventArgs": ["5a57f2de-8dea-4e86-90ad-03fc26b9653c"],
    "IAppBroadcastPreviewStreamReader": ["92228d50-db3f-40a8-8cd4-f4e371ddab37"],
    "IAppBroadcastPreviewStreamVideoFrame": ["010fbea1-94fe-4499-b8c0-8d244279fb12"],
    "IAppBroadcastPreviewStreamVideoHeader": ["8bef6113-da84-4499-a7ab-87118cb4a157"],
    "IAppBroadcastProviderSettings": ["c30bdf62-9948-458f-ad50-aa06ec03da08"],
    "IAppBroadcastServices": ["8660b4d6-969b-4e3c-ac3a-8b042ee4ee63"],
    "IAppBroadcastSignInStateChangedEventArgs": ["02b692a4-5919-4a9e-8d5e-c9bb0dd3377a"],
    "IAppBroadcastState": ["ee08056d-8099-4ddd-922e-c56dac58abfb"],
    "IAppBroadcastStreamAudioFrame": ["efab4ac8-21ba-453f-8bb7-5e938a2e9a74"],
    "IAppBroadcastStreamAudioHeader": ["bf21a570-6b78-4216-9f07-5aff5256f1b7"],
    "IAppBroadcastStreamReader": ["b338bcf9-3364-4460-b5f1-3cc2796a8aa2"],
    "IAppBroadcastStreamStateChangedEventArgs": ["5108a733-d008-4a89-93be-58aed961374e"],
    "IAppBroadcastStreamVideoFrame": ["0f97cf2b-c9e4-4e88-8194-d814cbd585d8"],
    "IAppBroadcastStreamVideoHeader": ["0b9ebece-7e32-432d-8ca2-36bf10b9f462"],
    "IAppBroadcastTrigger": ["74d4f496-8d37-44ec-9481-2a0b9854eb48"],
    "IAppBroadcastTriggerDetails": ["deebab35-ec5e-4d8f-b1c0-5da6e8c75638"],
    "IAppBroadcastTriggerFactory": ["280b9f44-22f4-4618-a02e-e7e411eb7238"],
    "IAppBroadcastTriggerProviderInfo": ["f219352d-9de8-4420-9ce2-5eff8f17376b"],
    "IAppBroadcastViewerCountChangedEventArgs": ["e6e11825-5401-4ade-8bd2-c14ecee6807d"],
    "IAppBroadcastingMonitor": ["00f95a68-8907-48a0-b8ef-24d208137542"],
    "IAppBroadcastingStatus": ["1225e4df-03a1-42f8-8b80-c9228cd9cf2e"],
    "IAppBroadcastingStatusDetails": ["069dada4-b573-4e3c-8e19-1bafacd09713"],
    "IAppBroadcastingUI": ["e56f9f8f-ee99-4dca-a3c3-70af3db44f5f"],
    "IAppBroadcastingUIStatics": ["55a8a79d-23cb-4579-9c34-886fe02c045a"],
    "IAppCapability": ["4c49d915-8a2a-4295-9437-2df7c396aff4"],
    "IAppCapabilityAccessChangedEventArgs": ["0a578d15-bdd7-457e-8cca-6f53bd2e5944"],
    "IAppCapabilityStatics": ["7c353e2a-46ee-44e5-af3d-6ad3fc49bd22"],
    "IAppCapture": ["9749d453-a29a-45ed-8f29-22d09942cff7"],
    "IAppCaptureAlternateShortcutKeys": ["19e8e0ef-236c-40f9-b38f-9b7dd65d1ccc"],
    "IAppCaptureAlternateShortcutKeys2": ["c3669090-dd17-47f0-95e5-ce42286cf338"],
    "IAppCaptureAlternateShortcutKeys3": ["7b81448c-418e-469c-a49a-45b597c826b6"],
    "IAppCaptureDurationGeneratedEventArgs": ["c1f5563b-ffa1-44c9-975f-27fbeb553b35"],
    "IAppCaptureFileGeneratedEventArgs": ["4189fbf4-465e-45bf-907f-165b3fb23758"],
    "IAppCaptureManagerStatics": ["7d9e3ea7-6282-4735-8d4e-aa45f90f6723"],
    "IAppCaptureMetadataWriter": ["e0ce4877-9aaf-46b4-ad31-6a60b441c780"],
    "IAppCaptureMicrophoneCaptureStateChangedEventArgs": ["324d249e-45bc-4c35-bc35-e469fc7a69e0"],
    "IAppCaptureRecordOperation": ["c66020a9-1538-495c-9bbb-2ba870ec5861"],
    "IAppCaptureRecordingStateChangedEventArgs": ["24fc8712-e305-490d-b415-6b1c9049736b"],
    "IAppCaptureServices": ["44fec0b5-34f5-4f18-ae8c-b9123abbfc0d"],
    "IAppCaptureSettings": ["14683a86-8807-48d3-883a-970ee4532a39"],
    "IAppCaptureSettings2": ["fcb8cee7-e26b-476f-9b1a-ec342d2a8fde"],
    "IAppCaptureSettings3": ["a93502fe-88c2-42d6-aaaa-40feffd75aec"],
    "IAppCaptureSettings4": ["07c2774c-1a81-482f-a244-049d95f25b0b"],
    "IAppCaptureSettings5": ["18894522-b0e8-4ba0-8f13-3eaa5fa4013b"],
    "IAppCaptureState": ["73134372-d4eb-44ce-9538-465f506ac4ea"],
    "IAppCaptureStatics": ["f922dd6c-0a7e-4e74-8b20-9c1f902d08a1"],
    "IAppCaptureStatics2": ["b2d881d4-836c-4da4-afd7-facc041e1cf3"],
    "IAppDataPaths": ["7301d60a-79a2-48c9-9ec0-3fda092f79e1"],
    "IAppDataPathsStatics": ["d8eb2afe-a9d9-4b14-b999-e3921379d903"],
    "IAppDiagnosticInfo": ["e348a69a-8889-4ca3-be07-d5ffff5f0804"],
    "IAppDiagnosticInfo2": ["df46fbd7-191a-446c-9473-8fbc2374a354"],
    "IAppDiagnosticInfo3": ["c895c63d-dd61-4c65-babd-81a10b4f9815"],
    "IAppDiagnosticInfoStatics": ["ce6925bf-10ca-40c8-a9ca-c5c96501866e"],
    "IAppDiagnosticInfoStatics2": ["05b24b86-1000-4c90-bb9f-7235071c50fe"],
    "IAppDiagnosticInfoWatcher": ["75575070-01d3-489a-9325-52f9cc6ede0a"],
    "IAppDiagnosticInfoWatcherEventArgs": ["7017c716-e1da-4c65-99df-046dff5be71a"],
    "IAppDisplayInfo": ["1aeb1103-e4d4-41aa-a4f6-c4a276e79eac"],
    "IAppDomainBinding": ["5c2b07a7-1e98-11d3-872f-00c04f79ed0d"],
    "IAppDomainInfo110": ["585dbb5b-a542-4296-bec6-29d12a7b016c"],
    "IAppExecutionStateChangeResult": ["6f039bf0-f91b-4df8-ae77-3033ccb69114"],
    "IAppExtension": ["8450902c-15ed-4faf-93ea-2237bbf8cbd6"],
    "IAppExtensionCatalog": ["97872032-8426-4ad1-9084-92e88c2da200"],
    "IAppExtensionCatalogStatics": ["3c36668a-5f18-4f0b-9ce5-cab61d196f11"],
    "IAppExtensionPackageInstalledEventArgs": ["39e59234-3351-4a8d-9745-e7d3dd45bc48"],
    "IAppExtensionPackageStatusChangedEventArgs": ["1ce17433-1153-44fd-87b1-8ae1050303df"],
    "IAppExtensionPackageUninstallingEventArgs": ["60f160c5-171e-40ff-ae98-ab2c20dd4d75"],
    "IAppExtensionPackageUpdatedEventArgs": ["3a83c43f-797e-44b5-ba24-a4c8b5a543d7"],
    "IAppExtensionPackageUpdatingEventArgs": ["7ed59329-1a65-4800-a700-b321009e306a"],
    "IAppHostAdminManager": ["9be77978-73ed-4a9a-87fd-13f09fec1b13"],
    "IAppHostChangeHandler": ["09829352-87c2-418d-8d79-4133969a489d"],
    "IAppHostChildElementCollection": ["08a90f5f-0702-48d6-b45f-02a9885a9768"],
    "IAppHostCollectionSchema": ["de095db1-5368-4d11-81f6-efef619b7bcf"],
    "IAppHostConfigException": ["4dfa1df3-8900-4bc7-bbb5-d1a458c52410"],
    "IAppHostConfigFile": ["ada4e6fb-e025-401e-a5d0-c3134a281f07"],
    "IAppHostConfigLocation": ["370af178-7758-4dad-8146-7391f6e18585"],
    "IAppHostConfigLocationCollection": ["832a32f7-b3ea-4b8c-b260-9a2923001184"],
    "IAppHostConfigManager": ["8f6d760f-f0cb-4d69-b5f6-848b33e9bdc6"],
    "IAppHostConstantValue": ["0716caf8-7d05-4a46-8099-77594be91394"],
    "IAppHostConstantValueCollection": ["5b5a68e6-8b9f-45e1-8199-a95ffccdffff"],
    "IAppHostElement": ["64ff8ccc-b287-4dae-b08a-a72cbf45f453"],
    "IAppHostElementCollection": ["c8550bff-5281-4b1e-ac34-99b6fa38464d"],
    "IAppHostElementExtension": ["518eb37d-1ff4-42dd-86c3-3140bc35b823"],
    "IAppHostElementSchema": ["ef13d885-642c-4709-99ec-b89561c6bc69"],
    "IAppHostElementSchemaCollection": ["0344cdda-151e-4cbf-82da-66ae61e97754"],
    "IAppHostMappingExtension": ["31a83ea0-c0e4-4a2c-8a01-353cc2a4c60a"],
    "IAppHostMethod": ["7883ca1c-1112-4447-84c3-52fbeb38069d"],
    "IAppHostMethodCollection": ["d6c7cd8f-bb8d-4f96-b591-d3a5f1320269"],
    "IAppHostMethodExtension": ["70184ac9-7673-4770-96b1-445ce035cf70"],
    "IAppHostMethodInstance": ["b80f3c42-60e0-4ae0-9007-f52852d3dbed"],
    "IAppHostMethodSchema": ["2d9915fb-9d42-4328-b782-1b46819fab9e"],
    "IAppHostPathMapper": ["e7927575-5cc3-403b-822e-328a6b904bee"],
    "IAppHostPathMapper2": ["0f80e901-8f4c-449a-bf90-13d5d082f187"],
    "IAppHostProperty": ["ed35f7a1-5024-4e7b-a44d-07ddaf4b524d"],
    "IAppHostPropertyCollection": ["0191775e-bcff-445a-b4f4-3bdda54e2816"],
    "IAppHostPropertyException": ["eafe4895-a929-41ea-b14d-613e23f62b71"],
    "IAppHostPropertyExtension": ["88e220f3-33e8-4534-afac-b4a98eccf9ae"],
    "IAppHostPropertySchema": ["450386db-7409-4667-935e-384dbbee2a9e"],
    "IAppHostPropertySchemaCollection": ["8bed2c68-a5fb-4b28-8581-a0dc5267419f"],
    "IAppHostSectionDefinition": ["c5c04795-321c-4014-8fd6-d44658799393"],
    "IAppHostSectionDefinitionCollection": ["b7d381ee-8860-47a1-8af4-1f33b2b1f325"],
    "IAppHostSectionGroup": ["0dd8a158-ebe6-4008-a1d9-b7ecc8f1104b"],
    "IAppHostWritableAdminManager": ["fa7660f6-7b3f-4237-a8bf-ed0ad0dcbbd9"],
    "IAppIdAuthority": ["8c87810c-2541-4f75-b2d0-9af515488e23"],
    "IAppInfo": ["cf7f59b3-6a09-4de8-a6c0-5792d56880d1"],
    "IAppInfo2": ["be4b1f5a-2098-431b-bd25-b30878748d47"],
    "IAppInfoStatics": ["cf1f782a-e48b-4f0c-9b0b-79c3f8957dd7"],
    "IAppInstallItem": ["49d3dfab-168a-4cbf-a93a-9e448c82737d"],
    "IAppInstallItem2": ["d3972af8-40c0-4fd7-aa6c-0aa13ca6188c"],
    "IAppInstallItem3": ["6f3dc998-dd47-433c-9234-560172d67a45"],
    "IAppInstallItem4": ["c2d1ce12-71ff-4fc8-b540-453d4b37e1d1"],
    "IAppInstallItem5": ["5510e7cc-4076-4a0b-9472-c21d9d380e55"],
    "IAppInstallManager": ["9353e170-8441-4b45-bd72-7c2fa925beee"],
    "IAppInstallManager2": ["16937851-ed37-480d-8314-52e27c03f04a"],
    "IAppInstallManager3": ["95b24b17-e96a-4d0e-84e1-c8cb417a0178"],
    "IAppInstallManager4": ["260a2a16-5a9e-4ebd-b944-f2ba75c31159"],
    "IAppInstallManager5": ["3cd7be4c-1be9-4f7f-b675-aa1d64a529b2"],
    "IAppInstallManager6": ["c9e7d408-f27a-4471-b2f4-e76efcbebcca"],
    "IAppInstallManager7": ["a5ee7b30-d5e4-49a3-9853-3db03203321d"],
    "IAppInstallManagerItemEventArgs": ["bc505743-4674-4dd1-957e-c25682086a14"],
    "IAppInstallOptions": ["c9808300-1cb8-4eb6-8c9f-6a30c64a5b51"],
    "IAppInstallOptions2": ["8a04c0d7-c94b-425e-95b4-bf27faeaee89"],
    "IAppInstallStatus": ["936dccfa-2450-4126-88b1-6127a644dd5c"],
    "IAppInstallStatus2": ["96e7818a-5e92-4aa9-8edc-58fed4b87e00"],
    "IAppInstallStatus3": ["cb880c56-837b-4b4c-9ebb-6d44a0a96307"],
    "IAppInstallerInfo": ["29ab2ac0-d4f6-42a3-adcd-d6583c659508"],
    "IAppInstance": ["675f2b47-f25f-4532-9fd6-3633e0634d01"],
    "IAppInstanceStatics": ["9d11e77f-9ea6-47af-a6ec-46784c5ba254"],
    "IAppLayoutCache": ["e511e73c-cad4-40aa-bf1a-b9938ac75ff0"],
    "IAppLicenseManagerInternal": ["5f909710-d28c-4a6c-9a2e-bcf284836e80"],
    "IAppListEntry": ["ef00f07f-2108-490a-877a-8a9f17c25fad"],
    "IAppListEntry2": ["d0a618ad-bf35-42ac-ac06-86eeeb41d04b"],
    "IAppListEntry3": ["6099f28d-fc32-470a-bc69-4b061a76ef2e"],
    "IAppMemoryReport": ["6d65339b-4d6f-45bc-9c5e-e49b3ff2758d"],
    "IAppMemoryReport2": ["5f7f3738-51b7-42dc-b7ed-79ba46d28857"],
    "IAppMemoryUsageLimitChangingEventArgs": ["79f86664-feca-4da5-9e40-2bc63efdc979"],
    "IAppReadinessFirstLogonApps": ["71810574-b03b-49ca-a1d6-9ca263536563"],
    "IAppReadinessService": ["29b6a139-cf48-4840-8d2f-e08c7c949b44"],
    "IAppReadinessServiceForUser": ["300fdaa3-4ddf-4bf3-9122-2bb0c7f71d7a"],
    "IAppReadinessTask": ["96080be3-6332-4825-92ef-ba6c9ac6d91d"],
    "IAppReadinessTaskCallback": ["de8ed432-fd92-47a6-9c73-738c7b466c69"],
    "IAppRecordingManager": ["e7e26076-a044-48e2-a512-3094d574c7cc"],
    "IAppRecordingManagerStatics": ["50e709f7-38ce-4bd3-9db2-e72bbe9de11d"],
    "IAppRecordingResult": ["3a900864-c66d-46f9-b2d9-5bc2dad070d7"],
    "IAppRecordingSaveScreenshotResult": ["9c5b8d0a-0abb-4457-aaee-24f9c12ec778"],
    "IAppRecordingSavedScreenshotInfo": ["9b642d0a-189a-4d00-bf25-e1bb1249d594"],
    "IAppRecordingStatus": ["1d0cc82c-bc18-4b8a-a6ef-127efab3b5d9"],
    "IAppRecordingStatusDetails": ["b538a9b0-14ed-4412-ac45-6d672c9c9949"],
    "IAppRep2": ["11a95ac9-bd61-4e16-8c56-c654268488bf"],
    "IAppRepParm2": ["8ca16e67-129f-489f-84cf-a8e317a2263b"],
    "IAppResolverPinToStart": ["6b1d7151-7a17-4c66-abc4-c9b1bc6c0e8d"],
    "IAppResourceGroupBackgroundTaskReport": ["2566e74e-b05d-40c2-9dc1-1a4f039ea120"],
    "IAppResourceGroupInfo": ["b913f77a-e807-49f4-845e-7b8bdcfe8ee7"],
    "IAppResourceGroupInfo2": ["ee9b236d-d305-4d6b-92f7-6afdad72dedc"],
    "IAppResourceGroupInfoWatcher": ["d9b0a0fd-6e5a-4c72-8b17-09fec4a212bd"],
    "IAppResourceGroupInfoWatcherEventArgs": ["7a787637-6302-4d2f-bf89-1c12d0b2a6b9"],
    "IAppResourceGroupInfoWatcherExecutionStateChangedEventArgs": ["1bdbedd7-fee6-4fd4-98dd-e92a2cc299f3"],
    "IAppResourceGroupMemoryReport": ["2c8c06b1-7db1-4c51-a225-7fae2d49e431"],
    "IAppResourceGroupStateReport": ["52849f18-2f70-4236-ab40-d04db0c7b931"],
    "IAppServiceCatalogStatics": ["ef0d2507-d132-4c85-8395-3c31d5a1e941"],
    "IAppServiceClosedEventArgs": ["de6016f6-cb03-4d35-ac8d-cc6303239731"],
    "IAppServiceConnection": ["9dd474a2-871f-4d52-89a9-9e090531bd27"],
    "IAppServiceConnection2": ["8bdfcd5f-2302-4fbd-8061-52511c2f8bf9"],
    "IAppServiceConnectionExtendedExecution": ["65219584-f9cb-4ae3-81f9-a28a6ca450d9"],
    "IAppServiceConnectionStatics": ["adc56ce9-d408-5673-8637-827a4b274168"],
    "IAppServiceDeferral": ["7e1b5322-eab0-4248-ae04-fdf93838e472"],
    "IAppServiceRequest": ["20e58d9d-18de-4b01-80ba-90a76204e3c8"],
    "IAppServiceRequestReceivedEventArgs": ["6e122360-ff65-44ae-9e45-857fe4180681"],
    "IAppServiceResponse": ["8d503cec-9aa3-4e68-9559-9de63e372ce4"],
    "IAppServiceTriggerDetails": ["88a2dcac-ad28-41b8-80bb-bdf1b2169e19"],
    "IAppServiceTriggerDetails2": ["e83d54b2-28cc-43f2-b465-c0482e59e2dc"],
    "IAppServiceTriggerDetails3": ["fbd71e21-7939-4e68-9e3c-7780147aabb6"],
    "IAppServiceTriggerDetails4": ["1185b180-8861-5e30-ab55-1cf4d08bbf6d"],
    "IAppSwitcherNotificationService": ["24677459-c19e-43f9-8ea8-984d017abafa"],
    "IAppSwitchingTestability": ["8332fbec-5803-4461-be72-91b106e7af8a"],
    "IAppSyncChangeHandler": ["8fdd23b4-904d-4070-b59f-976f3caf4ed9"],
    "IAppSyncDEHOperation": ["fb2c85f8-002f-48fb-8eae-be8254f790df"],
    "IAppSyncFilter": ["e84d2995-21f2-42cc-b2ba-07a6115ea592"],
    "IAppSyncHandler": ["ca316713-a41f-4b7e-831c-6c5f6b5cbfb5"],
    "IAppSyncRepository": ["c9483bce-7350-4b0d-a2d5-5aedd637af1b"],
    "IAppSyncSetting": ["4bc233cb-d491-4822-87dc-e9921088cbab"],
    "IAppUpdateOptions": ["26f0b02f-c2f3-4aea-af8c-6308dd9db85f"],
    "IAppUpdateOptions2": ["f4646e08-ed26-4bf9-9679-48f628e53df8"],
    "IAppUriHandlerHost": ["5d50cac5-92d2-5409-b56f-7f73e10ea4c3"],
    "IAppUriHandlerHostFactory": ["257c3c96-ce04-5f98-96bb-3ebd3e9275bb"],
    "IAppUriHandlerRegistration": ["6f73aeb1-4569-5c3f-9ba0-99123eea32c3"],
    "IAppUriHandlerRegistrationManager": ["e62c9a52-ac94-5750-ac1b-6cfb6f250263"],
    "IAppUriHandlerRegistrationManagerStatics": ["d5cedd9f-5729-5b76-a1d4-0285f295c124"],
    "IAppViewManager": ["24fdf66c-aad4-4512-b94b-3480c0ffee84"],
    "IAppVisibility": ["2246ea2d-caea-4444-a3c4-6de827e44313"],
    "IAppVisibilityEvents": ["6584ce6b-7d82-49c2-89c9-c6bc02ba8c38"],
    "IAppWindow": ["663014a6-b75e-5dbd-995c-f0117fa3fb61"],
    "IAppWindowChangedEventArgs": ["1de1f3be-a655-55ad-b2b6-eb240f880356"],
    "IAppWindowCloseRequestedEventArgs": ["e9ff01da-e7a2-57a8-8b5e-39c4003afdbb"],
    "IAppWindowClosedEventArgs": ["cc7df816-9520-5a06-821e-456ad8b358aa"],
    "IAppWindowFrame": ["9ee22601-7e5d-52af-846b-01dc6c296567"],
    "IAppWindowFrameStyle": ["ac412946-e1ac-5230-944a-c60873dcf4a9"],
    "IAppWindowPlacement": ["03dc815e-e7a9-5857-9c03-7d670594410e"],
    "IAppWindowPresentationConfiguration": ["b5a43ee3-df33-5e67-bd31-1072457300df"],
    "IAppWindowPresentationConfigurationFactory": ["fd3606a6-7875-5de8-84ff-6351ee13dd0d"],
    "IAppWindowPresenter": ["5ae9ed73-e1fd-5317-ad78-5a3ed271bbde"],
    "IAppWindowStatics": ["ff1f3ea3-b769-50ef-9873-108cd0e89746"],
    "IAppWindowTitleBar": ["6e932c84-f644-541d-a2d7-0c262437842d"],
    "IAppWindowTitleBarOcclusion": ["fea3cffd-2ccf-5fc3-aeae-f843876bf37e"],
    "IAppWindowTitleBarVisibility": ["a215a4e3-6e7e-5651-8c3b-624819528154"],
    "IApplication2": ["019104be-522a-5904-f52f-de72010429e0"],
    "IApplication3": ["b775ad7c-18b8-45ca-a1b0-dc483e4b1028"],
    "IApplicationActivationBroker": ["d98fd14a-522a-4d59-b875-811e83919a9e"],
    "IApplicationActivationClient": ["f7dd9e5a-4aaa-4898-abb4-27e4047d61b6"],
    "IApplicationActivationClient2": ["9f8ecbb6-9790-493b-ac99-8c80fbe51d5e"],
    "IApplicationActivationHistory": ["268b7798-2d57-434c-b84f-eabec0ffee84"],
    "IApplicationActivationImpl": ["e52e6467-ad3b-4df0-8267-b09f7cf57da5"],
    "IApplicationActivationManager": ["2e941141-7f97-4756-ba1d-9decde894a3d"],
    "IApplicationActivationManagerPriv": ["54e4c428-d1d4-47d4-ade6-46c829114a7d"],
    "IApplicationActivationManagerPriv2": ["88022cb7-9496-4d1d-9425-6231cc1842ba"],
    "IApplicationActivationPhone": ["dfcaacc1-90d6-4b33-b437-e29d4cfad8a6"],
    "IApplicationActivationPhonePriv": ["e7a5f14e-0650-44f2-9168-35cd1d04fe20"],
    "IApplicationActivationTypeProvider": ["601b41d9-ad89-4414-a63b-479a512021eb"],
    "IApplicationActivator": ["68e58421-f1ee-4c21-9612-c643798734ae"],
    "IApplicationAddOn": ["738d940f-b2c9-4dff-9b1c-6e06720f921a"],
    "IApplicationAssociationRegistration": ["4e530b0a-e611-4c77-a3ac-9031d022281b"],
    "IApplicationAssociationRegistrationInternal": ["14ebcc88-2831-4fc8-a5df-9f36a81db12c"],
    "IApplicationAssociationRegistrationUI": ["1f76a169-f994-40ac-8fc8-0959e8874710"],
    "IApplicationContentInfo": ["19a543ba-bad2-4739-83c8-177b3beac2ef"],
    "IApplicationContentInfo2": ["cb5b47a9-6537-451f-8dd7-d305ae3dea57"],
    "IApplicationData": ["c3da6fb7-b744-4b45-b0b8-223a0938d0dc"],
    "IApplicationData2": ["9e65cd69-0ba3-4e32-be29-b02de6607638"],
    "IApplicationData3": ["dc222cf4-2772-4c1d-aa2c-c9f743ade8d1"],
    "IApplicationDataContainer": ["c5aefd1e-f467-40ba-8566-ab640a441e1d"],
    "IApplicationDataManager": ["74d10432-2e99-4000-9a3a-64307e858129"],
    "IApplicationDataManagerStatics": ["1e1862e3-698e-49a1-9752-dee94925b9b3"],
    "IApplicationDataSetVersionHandler": ["a05791e6-cc9f-4687-acab-a364fd785463"],
    "IApplicationDataStatics": ["5612147b-e843-45e3-94d8-06169e3c8e17"],
    "IApplicationDataStatics2": ["cd606211-cf49-40a4-a47c-c7f0dbba8107"],
    "IApplicationDesignModeSettings": ["2a3dee9a-e31d-46d6-8508-bcc597db3557"],
    "IApplicationDesignModeSettings2": ["490514e1-675a-4d6e-a58d-e54901b4ca2f"],
    "IApplicationDestinations": ["12337d35-94c6-48a0-bce7-6a9c69d4d600"],
    "IApplicationDocumentLists": ["3c594f9f-9f30-47a1-979a-c9e83d3d0a06"],
    "IApplicationEvictionBroker": ["5bde7cd0-c973-4c6e-894f-290cf8307148"],
    "IApplicationExtension": ["7aecc259-7014-4482-8f56-bb3cd72b8250"],
    "IApplicationFactory": ["93bbe361-be5a-4ee3-b4a3-95118dc97a89"],
    "IApplicationFrame": ["143715d9-a015-40ea-b695-d5cc267e36ee"],
    "IApplicationFrameEventHandler": ["ea5d0de4-770d-4da0-a9f8-d7f9a140ff79"],
    "IApplicationFrameInputPaneEventHandler": ["fb45dabf-22c2-43b2-b887-af34b3a857f1"],
    "IApplicationFrameManager": ["d6defab3-dbb9-4413-8af9-554586fdff94"],
    "IApplicationFrameTitleBar": ["3ec723e8-3a72-4627-b3fb-aafbcc8837b8"],
    "IApplicationGlomBroker": ["63d0af21-aec2-40fd-8550-0f4c75f35b0f"],
    "IApplicationHost": ["c34c8544-811b-440d-b273-263c5d1cb130"],
    "IApplicationIdentifier": ["d934aab5-496b-4b08-ada0-a00931bc1315"],
    "IApplicationInitializationCallback": ["b6351c55-c284-46e4-8310-fb0967fab76f"],
    "IApplicationInitializationCallbackParams": ["751b792e-5772-4488-8b87-f547faa64474"],
    "IApplicationInstanceViewTest": ["e2ad0e73-3233-4421-b69c-df1bd1f9efc4"],
    "IApplicationInvocableFlow": ["f230b678-5fc3-49f4-94b4-afdc0ef9fa13"],
    "IApplicationLanguagesStatics": ["75b40847-0a4c-4a92-9565-fd63c95f7aed"],
    "IApplicationLanguagesStatics2": ["1df0de4f-072b-4d7b-8f06-cb2db40f2bb5"],
    "IApplicationLicenseManager": ["90e2000c-b946-42fa-892f-94506f30ca4f"],
    "IApplicationLicenseManager2": ["0375a9ac-cd24-49c0-9ac7-4f6337576180"],
    "IApplicationLicenseManager3": ["2f6b16bf-23b2-4e78-988f-7bdd0c3358b0"],
    "IApplicationLifecycleEvent": ["72d5424d-6eb2-4735-b36d-c9c3c6f038ce"],
    "IApplicationObject": ["d97a6da0-a866-11cf-83ae-10a0c90c2bd8"],
    "IApplicationOverrides": ["25f99ff7-9347-459a-9fac-b2d0e11c1a0f"],
    "IApplicationOverrides2": ["db5cd2b9-d3b4-558c-c64e-0434fd1bd889"],
    "IApplicationPlugin": ["b05651c2-9b10-425e-b616-1fcd828db3b1"],
    "IApplicationPlugins": ["b05651c1-9b10-425e-b616-1fcd828db3b1"],
    "IApplicationPositionPersistence": ["f876b69a-7b8e-4f46-864c-a0b0ea3e49c2"],
    "IApplicationPreLaunch": ["e87e2bc9-ec45-4ddb-95e1-b275d66cbeaa"],
    "IApplicationStateChangeHandler": ["b755e6e0-b048-49cc-8911-11a041216f5f"],
    "IApplicationStateChangeOutOfProcNotificationService": ["48f4e2d1-eeba-461e-8f8f-6353da1a3aca"],
    "IApplicationStatics": ["06499997-f7b4-45fe-b763-7577d1d3cb4a"],
    "IApplicationStreamDownload": ["4afdbf7a-60f4-4ca2-966c-c1b1086ac2e8"],
    "IApplicationTargetingChanges": ["45f9fb05-8122-433d-a807-b7cfbb411af5"],
    "IApplicationTileActivationBroker": ["c735d7d4-b88a-41f2-b35d-da0141e7348a"],
    "IApplicationTileActivationBroker2": ["1a91faba-b93c-456b-a10d-0036d2a68be6"],
    "IApplicationTrigger": ["0b468630-9574-492c-9e93-1a3ae6335fe9"],
    "IApplicationTriggerDetails": ["97dc6ab2-2219-4a9e-9c5e-41d047f76e82"],
    "IApplicationView": ["9ac0b5c8-1484-4c5b-9533-4134a0f97cea", "d222d519-4361-451e-96c4-60f4f9742db0"],
    "IApplicationView2": ["e876b196-a545-40dc-b594-450cba68cc00"],
    "IApplicationView3": ["903c9ce5-793a-4fdf-a2b2-af1ac21e3108"],
    "IApplicationView4": ["15e5cbec-9e0f-46b5-bc3f-9bf653e74b5e"],
    "IApplicationView7": ["a0369647-5faf-5aa6-9c38-befbb12a071e"],
    "IApplicationView9": ["9c6516f9-021a-5f01-93e5-9bdad2647574"],
    "IApplicationViewActivatedEventArgs": ["930cef4b-b829-40fc-88f4-8513e8a64738"],
    "IApplicationViewArrangePosition": ["3fc0257d-21c2-4ad3-8fb0-fd481cd204e2"],
    "IApplicationViewBroker": ["d4351e8c-208e-4c24-88ac-6e2add5f4bb1"],
    "IApplicationViewChangeListener": ["727f9e97-76ee-497b-a942-b6371328485c"],
    "IApplicationViewCollection": ["2c08adf0-a386-4b35-9250-0fe183476fcc"],
    "IApplicationViewCollectionManagement": ["b644fe9d-3090-4a41-9f18-465a5f445272"],
    "IApplicationViewCollectionTestHook": ["0afd5bce-d688-4973-ad54-ad0ce775f26b"],
    "IApplicationViewCompatibilityManager": ["203e0af6-3e82-4224-9e81-1cd9a6fe638b"],
    "IApplicationViewCompatiblityNotification": ["91d1aa6a-3b5d-42d1-a056-683271cbd488"],
    "IApplicationViewConsolidatedEventArgs": ["514449ec-7ea2-4de7-a6a6-7dfbaaebb6fb"],
    "IApplicationViewConsolidatedEventArgs2": ["1c199ecc-6dc1-40f4-afee-07d9ea296430"],
    "IApplicationViewDataProvider": ["3c0475b6-e2a8-44aa-be98-1b0d31f44d6f"],
    "IApplicationViewInteropStatics": ["c446fb5d-4793-4896-a8e2-be57a8bb0f50"],
    "IApplicationViewPosition": ["f9b8d4b3-64da-447c-b1ba-68861510eed6"],
    "IApplicationViewScaling": ["1d0ddc23-23f3-4b2d-84fe-74bf37b48b66"],
    "IApplicationViewScalingStatics": ["b08fecf0-b946-45c8-a5e3-71f5aa78f861"],
    "IApplicationViewStatics2": ["af338ae5-cf64-423c-85e5-f3e72448fb23"],
    "IApplicationViewStatics3": ["a28d7594-8c41-4e13-9719-5164796fe4c7"],
    "IApplicationViewStatics4": ["08fd8d33-2611-5336-a315-d98e6366c9db"],
    "IApplicationViewSwitcher": ["e0fe7384-5482-4659-ab2c-4ff038948779"],
    "IApplicationViewSwitcherStatics": ["975f2f1e-e656-4c5e-a0a1-717c6ffa7d64"],
    "IApplicationViewSwitcherStatics2": ["60e995cd-4fc2-48c4-b8e3-395f2b9f0fc1"],
    "IApplicationViewSwitcherStatics3": ["92059420-80a7-486d-b21f-c7a4a242a383"],
    "IApplicationViewTitleBar": ["00924ac0-932b-4a6b-9c4b-dc38c82478ce"],
    "IApplicationViewTransferContext": ["8574bc63-3c17-408e-9408-8a1a9ea81bfa"],
    "IApplicationViewTransferContextStatics": ["15a89d92-dd79-4b0b-bc47-d5f195f14661"],
    "IApplicationViewVisibilityDebouncedNotificationService": ["af6eec2f-c097-4f4a-b536-3cb918550cb3"],
    "IApplicationViewWithContext": ["bd55d512-9dc1-44fc-8501-666625df60dc"],
    "IAppointment": ["dd002f2f-2bdd-4076-90a3-22c275312965"],
    "IAppointment2": ["5e85983c-540f-3452-9b5c-0dd7ad4c65a2"],
    "IAppointment3": ["bfcc45a9-8961-4991-934b-c48768e5a96c"],
    "IAppointmentCalendar": ["5273819d-8339-3d4f-a02f-64084452bb5d"],
    "IAppointmentCalendar2": ["18e7e422-2467-4e1c-a459-d8a29303d092"],
    "IAppointmentCalendar3": ["eb23d22b-a685-42ae-8495-b3119adb4167"],
    "IAppointmentCalendarCancelMeetingRequest": ["49460f8d-6434-40d7-ad46-6297419314d1"],
    "IAppointmentCalendarCancelMeetingRequestEventArgs": ["1a79be16-7f30-4e35-beef-9d2c7b6dcae1"],
    "IAppointmentCalendarCreateOrUpdateAppointmentRequest": ["2e62f2b2-ca96-48ac-9124-406b19fefa70"],
    "IAppointmentCalendarCreateOrUpdateAppointmentRequestEventArgs": ["cf8ded28-002e-4bf7-8e9d-5e20d49aa3ba"],
    "IAppointmentCalendarForwardMeetingRequest": ["82e5ee56-26b6-4253-8a8f-6cf5f2ff7884"],
    "IAppointmentCalendarForwardMeetingRequestEventArgs": ["3109151a-23a2-42fd-9c82-c9a60d59f8a8"],
    "IAppointmentCalendarProposeNewTimeForMeetingRequest": ["ce1c63f5-edf6-43c3-82b7-be6b368c6900"],
    "IAppointmentCalendarProposeNewTimeForMeetingRequestEventArgs": ["d2d777d8-fed1-4280-a3ba-2e1f47609aa2"],
    "IAppointmentCalendarSyncManager": ["2b21b3a0-4aff-4392-bc5f-5645ffcffb17"],
    "IAppointmentCalendarSyncManager2": ["647528ad-0d29-4c7c-aaa7-bf996805537c"],
    "IAppointmentCalendarSyncManagerSyncRequest": ["12ab382b-7163-4a56-9a4e-7223a84adf46"],
    "IAppointmentCalendarSyncManagerSyncRequestEventArgs": ["ca17c6f7-0284-4edd-87ba-4d8f69dcf5c0"],
    "IAppointmentCalendarUpdateMeetingResponseRequest": ["a36d608c-c29d-4b94-b086-7e9ff7bd84a0"],
    "IAppointmentCalendarUpdateMeetingResponseRequestEventArgs": ["88759883-97bf-479d-aed5-0be8ce567d1e"],
    "IAppointmentConflictResult": ["d5cdf0be-2f2f-3b7d-af0a-a7e20f3a46e3"],
    "IAppointmentDataProviderConnection": ["f3dd9d83-3254-465f-abdb-928046552cf4"],
    "IAppointmentDataProviderTriggerDetails": ["b3283c01-7e12-4e5e-b1ef-74fb68ac6f2a"],
    "IAppointmentException": ["a2076767-16f6-4bce-9f5a-8600b8019fcb"],
    "IAppointmentInvitee": ["13bf0796-9842-495b-b0e7-ef8f79c0701d"],
    "IAppointmentManagerForUser": ["70261423-73cc-4660-b318-b01365302a03"],
    "IAppointmentManagerStatics": ["3a30fa01-5c40-499d-b33f-a43050f74fc4"],
    "IAppointmentManagerStatics2": ["0a81f60d-d04f-4034-af72-a36573b45ff0"],
    "IAppointmentManagerStatics3": ["2f9ae09c-b34c-4dc7-a35d-cafd88ae3ec6"],
    "IAppointmentParticipant": ["615e2902-9718-467b-83fb-b293a19121de"],
    "IAppointmentPropertiesStatics": ["25141fe9-68ae-3aae-855f-bc4441caa234"],
    "IAppointmentPropertiesStatics2": ["dffc434b-b017-45dd-8af5-d163d10801bb"],
    "IAppointmentRecurrence": ["d87b3e83-15a6-487b-b959-0c361e60e954"],
    "IAppointmentRecurrence2": ["3df3a2e0-05a7-4f50-9f86-b03f9436254d"],
    "IAppointmentRecurrence3": ["89ff96d9-da4d-4a17-8dd2-1cebc2b5ff9d"],
    "IAppointmentStore": ["a461918c-7a47-4d96-96c9-15cd8a05a735"],
    "IAppointmentStore2": ["25c48c20-1c41-424f-8084-67c1cfe0a854"],
    "IAppointmentStore3": ["4251940b-b078-470a-9a40-c2e01761f72f"],
    "IAppointmentStoreChange": ["a5a6e035-0a33-3654-8463-b543e90c3b79"],
    "IAppointmentStoreChange2": ["b37d0dce-5211-4402-a608-a96fe70b8ee2"],
    "IAppointmentStoreChangeReader": ["8b2409f1-65f3-42a0-961d-4c209bf30370"],
    "IAppointmentStoreChangeTracker": ["1b25f4b1-8ece-4f17-93c8-e6412458fd5c"],
    "IAppointmentStoreChangeTracker2": ["b66aaf45-9542-4cf7-8550-eb370e0c08d3"],
    "IAppointmentStoreChangedDeferral": ["4cb82026-fedb-4bc3-9662-95a9befdf4df"],
    "IAppointmentStoreChangedEventArgs": ["2285f8b9-0791-417e-bfea-cc6d41636c8c"],
    "IAppointmentStoreNotificationTrigger": ["64d4040c-c201-42ad-aa2a-e21ba3425b6d"],
    "IAppointmentStoreNotificationTriggerDetails": ["9b33cb11-c301-421e-afef-047ecfa76adb"],
    "IAppointmentsProviderActivatedEventArgs": ["3364c405-933c-4e7d-a034-500fb8dcd9f3"],
    "IAppointmentsProviderAddAppointmentActivatedEventArgs": ["a2861367-cee5-4e4d-9ed7-41c34ec18b02"],
    "IAppointmentsProviderInternalActivatedEventArgs": ["7d590f6f-94e7-4178-a253-24493fcade4f"],
    "IAppointmentsProviderLaunchActionVerbsStatics": ["36dbba28-9e2e-49c6-8ef7-3ab7a5dcc8b8"],
    "IAppointmentsProviderLaunchActionVerbsStatics2": ["ef9049a4-af21-473c-88dc-76cd89f60ca5"],
    "IAppointmentsProviderRemoveAppointmentActivatedEventArgs": ["751f3ab8-0b8e-451c-9f15-966e699bac25"],
    "IAppointmentsProviderReplaceAppointmentActivatedEventArgs": ["1551b7d4-a981-4067-8a62-0524e4ade121"],
    "IAppointmentsProviderShowAppointmentDetailsActivatedEventArgs": ["3958f065-9841-4ca5-999b-885198b9ef2a"],
    "IAppointmentsProviderShowTimeFrameActivatedEventArgs": ["9baeaba6-0e0b-49aa-babc-12b1dc774986"],
    "IAppxBaseExtension": ["893ac9e5-23a5-4561-9500-c27ef5a058ac"],
    "IAppxBlockMapBlock": ["75cf3930-3244-4fe0-a8c8-e0bcb270b889"],
    "IAppxBlockMapBlocksEnumerator": ["6b429b5b-36ef-479e-b9eb-0c1482b49e16"],
    "IAppxBlockMapFile": ["277672ac-4f63-42c1-8abc-beae3600eb59"],
    "IAppxBlockMapFilesEnumerator": ["02b856a2-4262-4070-bacb-1a8cbbc42305"],
    "IAppxBlockMapReader": ["5efec991-bca3-42d1-9ec2-e92d609ec22a"],
    "IAppxBundleFactory": ["bba65864-965f-4a5f-855f-f074bdbf3a7b"],
    "IAppxBundleManifestOptionalBundleInfo": ["515bf2e8-bcb0-4d69-8c48-e383147b6e12"],
    "IAppxBundleManifestOptionalBundleInfoEnumerator": ["9a178793-f97e-46ac-aaca-dd5ba4c177c8"],
    "IAppxBundleManifestPackageInfo": ["54cd06c1-268f-40bb-8ed2-757a9ebaec8d"],
    "IAppxBundleManifestPackageInfo2": ["44c2acbc-b2cf-4ccb-bbdb-9c6da8c3bc9e"],
    "IAppxBundleManifestPackageInfo3": ["6ba74b98-bb74-4296-80d0-5f4256a99675"],
    "IAppxBundleManifestPackageInfo4": ["5da6f13d-a8a7-4532-857c-1393d659371d"],
    "IAppxBundleManifestPackageInfoEnumerator": ["f9b856ee-49a6-4e19-b2b0-6a2406d63a32"],
    "IAppxBundleManifestReader": ["cf0ebbc1-cc99-4106-91eb-e67462e04fb0"],
    "IAppxBundleManifestReader2": ["5517df70-033f-4af2-8213-87d766805c02"],
    "IAppxBundleReader": ["dd75b8c0-ba76-43b0-ae0f-68656a1dc5c8"],
    "IAppxBundleWriter": ["ec446fe8-bfec-4c64-ab4f-49f038f0c6d2"],
    "IAppxBundleWriter2": ["6d8fe971-01cc-49a0-b685-233851279962"],
    "IAppxBundleWriter3": ["ad711152-f969-4193-82d5-9ddf2786d21a"],
    "IAppxBundleWriter4": ["9cd9d523-5009-4c01-9882-dc029fbd47a3"],
    "IAppxContentGroup": ["328f6468-c04f-4e3c-b6fa-6b8d27f3003a"],
    "IAppxContentGroupFilesEnumerator": ["1a09a2fd-7440-44eb-8c84-848205a6a1cc"],
    "IAppxContentGroupMapReader": ["418726d8-dd99-4f5d-9886-157add20de01"],
    "IAppxContentGroupMapWriter": ["d07ab776-a9de-4798-8c14-3db31e687c78"],
    "IAppxContentGroupsEnumerator": ["3264e477-16d1-4d63-823e-7d2984696634"],
    "IAppxEncryptedBundleWriter": ["80b0902f-7bf0-4117-b8c6-4279ef81ee77"],
    "IAppxEncryptedBundleWriter2": ["e644be82-f0fa-42b8-a956-8d1cb48ee379"],
    "IAppxEncryptedBundleWriter3": ["0d34deb3-5cae-4dd3-977c-504932a51d31"],
    "IAppxEncryptedPackageWriter": ["f43d0b0b-1379-40e2-9b29-682ea2bf42af"],
    "IAppxEncryptedPackageWriter2": ["3e475447-3a25-40b5-8ad2-f953ae50c92d"],
    "IAppxEncryptionFactory": ["80e8e04d-8c88-44ae-a011-7cadf6fb2e72"],
    "IAppxEncryptionFactory2": ["c1b11eee-c4ba-4ab2-a55d-d015fe8ff64f"],
    "IAppxEncryptionFactory3": ["09edca37-cd64-47d6-b7e8-1cb11d4f7e05"],
    "IAppxEncryptionFactory4": ["a879611f-12fd-41fe-85d5-06ae779bbaf5"],
    "IAppxFactory": ["beb94909-e451-438b-b5a7-d79e767b75d8"],
    "IAppxFactory2": ["f1346df2-c282-4e22-b918-743a929a8d55"],
    "IAppxFile": ["91df827b-94fd-468f-827b-57f41b2f6f2e"],
    "IAppxFileOpenPickerExtension": ["01b7617f-b00a-4290-870e-d329b5a43033"],
    "IAppxFilesEnumerator": ["f007eeaf-9831-411c-9847-917cdc62d1fe"],
    "IAppxManifestApplication": ["5da89bf4-3773-46be-b650-7e744863b7e8"],
    "IAppxManifestApplicationsEnumerator": ["9eb8a55a-f04b-4d0d-808d-686185d4847a"],
    "IAppxManifestCapabilitiesEnumerator": ["11d22258-f470-42c1-b291-8361c5437e41"],
    "IAppxManifestDesignerService": ["11d31ba1-480f-435f-b711-8f192a1c226e"],
    "IAppxManifestDeviceCapabilitiesEnumerator": ["30204541-427b-4a1c-bacf-655bf463a540"],
    "IAppxManifestDocument": ["80cad0de-8ecc-48fc-b81e-d11b13ab9e8a"],
    "IAppxManifestDriverConstraint": ["c031bee4-bbcc-48ea-a237-c34045c80a07"],
    "IAppxManifestDriverConstraintsEnumerator": ["d402b2d1-f600-49e0-95e6-975d8da13d89"],
    "IAppxManifestDriverDependenciesEnumerator": ["fe039db2-467f-4755-8404-8f5eb6865b33"],
    "IAppxManifestDriverDependency": ["1210cb94-5a92-4602-be24-79f318af4af9"],
    "IAppxManifestHostRuntimeDependenciesEnumerator": ["6427a646-7f49-433e-b1a6-0da309f6885a"],
    "IAppxManifestHostRuntimeDependency": ["3455d234-8414-410d-95c7-7b35255b8391"],
    "IAppxManifestMainPackageDependenciesEnumerator": ["a99c4f00-51d2-4f0f-ba46-7ed5255ebdff"],
    "IAppxManifestMainPackageDependency": ["05d0611c-bc29-46d5-97e2-84b9c79bd8ae"],
    "IAppxManifestOSPackageDependenciesEnumerator": ["b84e2fc3-f8ec-4bc1-8ae2-156346f5ffea"],
    "IAppxManifestOSPackageDependency": ["154995ee-54a6-4f14-ac97-d8cf0519644b"],
    "IAppxManifestOptionalPackageInfo": ["2634847d-5b5d-4fe5-a243-002ff95edc7e"],
    "IAppxManifestPackageDependenciesEnumerator": ["b43bbcf9-65a6-42dd-bac0-8c6741e7f5a4"],
    "IAppxManifestPackageDependency": ["e4946b59-733e-43f0-a724-3bde4c1285a0"],
    "IAppxManifestPackageDependency2": ["dda0b713-f3ff-49d3-898a-2786780c5d98"],
    "IAppxManifestPackageDependency3": ["1ac56374-6198-4d6b-92e4-749d5ab8a895"],
    "IAppxManifestPackageId": ["283ce2d7-7153-4a91-9649-7a0f7240945f"],
    "IAppxManifestPackageId2": ["2256999d-d617-42f1-880e-0ba4542319d5"],
    "IAppxManifestProperties": ["03faf64d-f26f-4b2c-aaf7-8fe7789b8bca"],
    "IAppxManifestQualifiedResource": ["3b53a497-3c5c-48d1-9ea3-bb7eac8cd7d4"],
    "IAppxManifestQualifiedResourcesEnumerator": ["8ef6adfe-3762-4a8f-9373-2fc5d444c8d2"],
    "IAppxManifestReader": ["4e1bd148-55a0-4480-a3d1-15544710637c"],
    "IAppxManifestReader2": ["d06f67bc-b31d-4eba-a8af-638e73e77b4d"],
    "IAppxManifestReader3": ["c43825ab-69b7-400a-9709-cc37f5a72d24"],
    "IAppxManifestReader4": ["4579bb7c-741d-4161-b5a1-47bd3b78ad9b"],
    "IAppxManifestReader5": ["8d7ae132-a690-4c00-b75a-6aae1feaac80"],
    "IAppxManifestReader6": ["34deaca4-d3c0-4e3e-b312-e42625e3807e"],
    "IAppxManifestReader7": ["8efe6f27-0ce0-4988-b32d-738eb63db3b7"],
    "IAppxManifestResourcesEnumerator": ["de4dfbbd-881a-48bb-858c-d6f2baeae6ed"],
    "IAppxManifestTargetDeviceFamiliesEnumerator": ["36537f36-27a4-4788-88c0-733819575017"],
    "IAppxManifestTargetDeviceFamily": ["9091b09b-c8d5-4f31-8687-a338259faefb"],
    "IAppxPackageEditor": ["e2adb6dc-5e71-4416-86b6-86e5f5291a6b"],
    "IAppxPackageReader": ["b5c49650-99bc-481c-9a34-3d53a4106708"],
    "IAppxPackageReader2": ["37e8d3d5-1aea-4204-9c50-ff715932c249"],
    "IAppxPackageWriter": ["9099e33b-246f-41e4-881a-008eb613f858"],
    "IAppxPackageWriter2": ["2cf5c4fd-e54c-4ea5-ba4e-f8c4b105a8c8"],
    "IAppxPackageWriter3": ["a83aacd3-41c0-4501-b8a3-74164f50b2fd"],
    "IAppxPackagingDiagnosticEventSink": ["17239d47-6adb-45d2-80f6-f9cbc3bf059d"],
    "IAppxPackagingDiagnosticEventSinkManager": ["369648fa-a7eb-4909-a15d-6954a078f18a"],
    "IAppxShareExtension": ["1323d2e8-a6e1-498d-93b9-16ca249c9306"],
    "IAppxSourceContentGroupMapReader": ["f329791d-540b-4a9f-bc75-3282b7d73193"],
    "IArbiterBroker": ["edb9ef13-045c-4c0a-808e-3294c59703b4"],
    "IArcSegment": ["07940c5f-63fb-4469-91be-f1097c168052"],
    "IArcSegmentStatics": ["82348f6e-8a69-4204-9c12-7207df317643"],
    "IArcadeStick": ["b14a539d-befb-4c81-8051-15ecf3b13036"],
    "IArcadeStickStatics": ["5c37b8c8-37b1-4ad8-9458-200f1a30018e"],
    "IArcadeStickStatics2": ["52b5d744-bb86-445a-b59c-596f0e2a49df"],
    "IAssemblyCache": ["e707dcde-d1cd-11d2-bab9-00c04f8eceae"],
    "IAssemblyCacheItem": ["9e3aaeb4-d1cd-11d2-bab9-00c04f8eceae"],
    "IAssemblyEnum": ["21b8916c-f28e-11d2-a473-00c04f8ef448"],
    "IAssemblyName": ["cd193bc0-b4bc-11d2-9833-00c04fc31d2e"],
    "IAssignedAccessSettings": ["1bc57f1c-e971-5757-b8e0-512f8b8c46d2"],
    "IAssignedAccessSettingsStatics": ["34a81d0d-8a29-5ef3-a7be-618e6ac3bd01"],
    "IAssocHandler": ["f04061ac-1659-4a3f-a954-775aa57fc083"],
    "IAssocHandlerInvoker": ["92218cab-ecaa-4335-8133-807fd234c2ee"],
    "IAssociatedIdentityProvider": ["2af066b3-4cbb-4cba-a798-204b6af68cc0"],
    "IAssociationArray": ["c35f777c-5fa8-4293-bd69-4636ff366f22"],
    "IAssociationElement": ["d8f6ad5b-b44f-4bcc-88fd-eb3473db7502"],
    "IAsymmetricAlgorithmNamesStatics": ["caf6fce4-67c0-46aa-84f9-752e77449f9b"],
    "IAsymmetricAlgorithmNamesStatics2": ["f141c0d6-4bff-4f23-ba66-6045b137d5df"],
    "IAsymmetricKeyAlgorithmProvider": ["e8d2ff37-6259-4e88-b7e0-94191fde699e"],
    "IAsymmetricKeyAlgorithmProvider2": ["4e322a7e-7c4d-4997-ac4f-1b848b36306e"],
    "IAsymmetricKeyAlgorithmProviderStatics": ["425bde18-a7f3-47a6-a8d2-c48d6033a65c"],
    "IAsyncAction": ["5a648006-843a-4da9-865b-9d26e5dfad7b"],
    "IAsyncActionCompletedHandler": ["a4ed5c81-76c9-40bd-8be6-b1d90fb20ae7"],
    "IAsyncAllowed": ["f5f2893a-ba9e-11d0-abb9-00c04fc29f8f"],
    "IAsyncCallback": ["ea8a389b-437d-4791-aa14-5dca004bc92a"],
    "IAsyncCallbackDispatcher": ["7702e77c-66f6-479b-af2b-e316cff5f814"],
    "IAsyncCausalityTracerStatics": ["50850b26-267e-451b-a890-ab6a370245ee"],
    "IAsyncDebugEngineOperation": ["08c85523-1f56-4ccd-8315-df2c657a245f"],
    "IAsyncDebugEngineOperation158": ["0fddd94e-01da-4409-844c-36c63aad3fc9"],
    "IAsyncDebugEngineOperationWorkList": ["4401b380-016e-4b61-8532-b3b0f41a3b47"],
    "IAsyncDebugEngineOperationWorkList158": ["44dff079-4364-4d72-9997-cd3fe128ce39"],
    "IAsyncDebugEvaluateCompletionHandler": ["df75ac59-e3cf-456b-a5a2-b8b8fbdfb7a7"],
    "IAsyncDebugGetFramesCompletionHandler": ["15c89f68-17d2-4c34-9714-e5a1e0824904"],
    "IAsyncDebugGetPropertiesCompletionHandler": ["5c9afc5d-fd11-43f9-a6aa-345625dea2a3"],
    "IAsyncDebugGetThreadPropertiesCompletionHandler": ["00eb372d-8dc7-404a-af65-17262fd3b330"],
    "IAsyncDebugPropertyInfoProvider": ["bb7e4dec-d761-41e6-8281-8976641efe90"],
    "IAsyncDebugWorkListFactory": ["119cd2bc-74ec-4510-a0cd-6276a8a87737"],
    "IAsyncDragUIContentCompletionCallbackPriv": ["9c19e0bc-7d95-426d-a994-5aec39d45a90"],
    "IAsyncDragUIContentPriv": ["a8996fdb-5dd0-4cdc-bc77-9da61d2174df"],
    "IAsyncInfo": ["00000036-0000-0000-c000-000000000046"],
    "IAsyncLoadablePackageInitialize": ["3ec4d7f6-4036-4406-a393-2fff7b2e78a1"],
    "IAsyncNotifyServerReferral": ["87be5d60-2ab8-4340-a475-8ce1541d63f9"],
    "IAsyncOperationCompletion": ["4c378512-fa50-4242-b162-d08222cbc405"],
    "IAsyncProgressCallback": ["c3a2d62e-64be-4008-924f-7e303e2b0001"],
    "IAsyncSecurityStatus": ["e31af1ec-96b2-4635-b0ba-f1431e82ba92"],
    "IAsyncServiceProvider": ["257b63fa-8388-4feb-9db8-3db22f4405de"],
    "IAsyncServiceProvider2": ["4edcc64c-4f4e-47bb-9364-cf04348aec1e"],
    "IAsyncWPNInit": ["f84eb939-b961-ba76-565f-857c29a88131"],
    "IAsynchronousDataRetriever": ["9fc7e470-61ea-4a88-9be4-df56a27cfef2"],
    "IAtomPubClient": ["35392c38-cded-4d4c-9637-05f15c1c9406"],
    "IAtomPubClientFactory": ["49d55012-57cb-4bde-ab9f-2610b172777b"],
    "IAtscContentAdvisoryDescriptor": ["ff76e60c-0283-43ea-ba32-b422238547ee"],
    "IAtscPsipParser": ["b2c98995-5eb2-4fb1-b406-f3e8e2026a9a"],
    "IAttachableInputObject": ["9b822734-a3c1-542a-b2f4-0e32b773fb07"],
    "IAttachableInputObjectFactory": ["a4c54c4e-42bc-58fa-a640-ea1516f4c06b"],
    "IAttributeGet": ["52dbd1ec-e48f-4528-9232-f442a68f0ae1"],
    "IAttributeSet": ["583ec3cc-4960-4857-982b-41a33ea0a006"],
    "IAttributedNetworkUsage": ["f769b039-eca2-45eb-ade1-b0368b756c49"],
    "IAudioAccessibility": ["a99be094-a808-4cfb-a658-29d5a3858300"],
    "IAudioAmbisonicsControl": ["28724c91-df35-4856-9f76-d6a26413f3df"],
    "IAudioAutoGainControl": ["85401fd4-6de4-4b9d-9869-2d6753a82f3c"],
    "IAudioBass": ["a2b1a1d9-4db3-425d-a2b2-bd335cb3e2e5"],
    "IAudioBuffer": ["35175827-724b-4c6a-b130-f6537f9ae0d0"],
    "IAudioCaptureClient": ["c8adbd64-e71e-48a0-a4de-185c395cd317"],
    "IAudioCaptureEffectsManager": ["8f85c271-038d-4393-8298-540110608eef"],
    "IAudioChannelConfig": ["bb11c46f-ec28-493c-b88a-5db88062ce98"],
    "IAudioCleanup": ["2bee5823-6cbb-4b32-9861-be5c604c4f87"],
    "IAudioClient": ["1cb9ad4c-dbfa-4c32-b178-c2f568a703b2"],
    "IAudioClient2": ["726778cd-f60a-4eda-82de-e47610cd78aa"],
    "IAudioClient3": ["7ed4ee07-8e67-4cd4-8c1a-2b7a5987ad42"],
    "IAudioClock": ["cd63314f-3fba-4a1b-812c-ef96358728e7"],
    "IAudioClock2": ["6f49ff73-6727-49ac-a008-d98cf5e70048"],
    "IAudioClockAdjustment": ["f6e4c0a0-46d9-4fb8-be21-57a3ef2b626c"],
    "IAudioConstrictor": ["6b54b2b5-45ee-4f11-9935-9ec3183ad534"],
    "IAudioCopy": ["adf7583d-f947-4311-83fb-066ad4e5e7c2"],
    "IAudioData": ["54c719c0-af60-11d0-8212-00c04fc32c45"],
    "IAudioDeviceController": ["edd4a388-79c7-4f7c-90e8-ef934b21580a"],
    "IAudioDeviceEndpoint": ["d4952f5a-a0b2-4cc4-8b82-9358488dd8ac"],
    "IAudioDeviceGraph": ["3c169ff7-37b2-484c-b199-c3155590f316"],
    "IAudioDeviceInputNode": ["b01b6be1-6f4e-49e2-ac01-559d62beb3a9"],
    "IAudioDeviceModule": ["86cfac36-47c1-4b33-9852-8773ec4be123"],
    "IAudioDeviceModuleNotificationEventArgs": ["e3e3ccaf-224c-48be-956b-9a13134e96e8"],
    "IAudioDeviceModulesClient": ["98f37dac-d0b6-49f5-896a-aa4d169a4c48"],
    "IAudioDeviceModulesManager": ["6aa40c4d-960a-4d1c-b318-0022604547ed"],
    "IAudioDeviceModulesManagerFactory": ["8db03670-e64d-4773-96c0-bc7ebf0e063f"],
    "IAudioDeviceOutputNode": ["362edbff-ff1c-4434-9e0f-bd2ef522ac82"],
    "IAudioDither": ["6bb6a944-7352-4327-ab91-d92607b25656"],
    "IAudioEffect": ["34aafa51-9207-4055-be93-6e5734a86ae4"],
    "IAudioEffectDefinition": ["e4d7f974-7d80-4f73-9089-e31c9db9c294"],
    "IAudioEffectDefinitionFactory": ["8e1da646-e705-45ed-8a2b-fc4e4f405a97"],
    "IAudioEffectsManagerStatics": ["66406c04-86fa-47cc-a315-f489d8c3fe10"],
    "IAudioEncodingProperties": ["62bc7a16-005c-4b3b-8a0b-0a090e9687f3"],
    "IAudioEncodingProperties2": ["c45d54da-80bd-4c23-80d5-72d4a181e894"],
    "IAudioEncodingProperties3": ["87600341-748c-4f8d-b0fd-10caf08ff087"],
    "IAudioEncodingPropertiesStatics": ["0cad332c-ebe9-4527-b36d-e42a13cf38db"],
    "IAudioEncodingPropertiesStatics2": ["7489316f-77a0-433d-8ed5-4040280e8665"],
    "IAudioEncodingPropertiesWithFormatUserData": ["98f10d79-13ea-49ff-be70-2673db69702c"],
    "IAudioEndpoint": ["30a99515-1527-4451-af9f-00c5f0234daf"],
    "IAudioEndpointControl": ["c684b72a-6df4-4774-bdf9-76b77509b653"],
    "IAudioEndpointFormatControl": ["784cfd40-9f89-456e-a1a6-873b006a664e"],
    "IAudioEndpointLastBufferControl": ["f8520dd3-8f9d-4437-9861-62f584c33dd6"],
    "IAudioEndpointOffloadStreamMeter": ["e1546dce-9dd1-418b-9ab2-348ced161c86"],
    "IAudioEndpointOffloadStreamMute": ["dfe21355-5ec2-40e0-8d6b-710ac3c00249"],
    "IAudioEndpointOffloadStreamVolume": ["64f1dd49-71ca-4281-8672-3a9eddd1d0b6"],
    "IAudioEndpointRT": ["dfd2005f-a6e5-4d39-a265-939ada9fbb4d"],
    "IAudioEndpointVolume": ["5cdf2c82-841e-4546-9722-0cf74078229a"],
    "IAudioEndpointVolumeCallback": ["657804fa-d6ad-4496-8a60-352752af4f89"],
    "IAudioEndpointVolumeEx": ["66e11784-f695-4f28-a505-a7080081a78f"],
    "IAudioFileInputNode": ["905b67c8-6f65-4cd4-8890-4694843c276d"],
    "IAudioFileOutputNode": ["50e01980-5166-4093-80f8-ada00089e9cf"],
    "IAudioFlyoutController": ["41f9d2fb-7834-4ab6-8b1b-73e74064b465"],
    "IAudioFormatConverter": ["fc7dff56-6b8d-45a9-b4ca-266f9ac21693"],
    "IAudioFormatEnumerator": ["dcdaa858-895a-4a22-a5eb-67bda506096d"],
    "IAudioFrame": ["e36ac304-aab2-4277-9ed0-43cedf8e29c6"],
    "IAudioFrameCompletedEventArgs": ["dc7c829e-0208-4504-a5a8-f0f268920a65"],
    "IAudioFrameFactory": ["91a90ade-2422-40a6-b9ad-30d02404317d"],
    "IAudioFrameInputNode": ["01b266c7-fd96-4ff5-a3c5-d27a9bf44237"],
    "IAudioFrameNative": ["20be1e2e-930f-4746-9335-3c332f255093"],
    "IAudioFrameNativeFactory": ["7bd67cf8-bf7d-43e6-af8d-b170ee0c0110"],
    "IAudioFrameOutputNode": ["b847371b-3299-45f5-88b3-c9d12a3f1cc8"],
    "IAudioGraph": ["1ad46eed-e48c-4e14-9660-2c4f83e9cdd8"],
    "IAudioGraph2": ["4e4c3bd5-4fc1-45f6-a947-3cd38f4fd839"],
    "IAudioGraph3": ["ddcd25ae-1185-42a7-831d-6a9b0fc86820"],
    "IAudioGraphCallback": ["2f732065-eff0-4c7c-8fc1-363851b1f1d7"],
    "IAudioGraphConnection": ["763070ed-d04e-4fac-b233-600b42edd469"],
    "IAudioGraphSettings": ["1d59647f-e6fe-4628-84f8-9d8bdba25785"],
    "IAudioGraphSettings2": ["72919787-4dab-46e3-b4c9-d8e1a2636062"],
    "IAudioGraphSettingsFactory": ["a5d91cc6-c2eb-4a61-a214-1d66d75f83da"],
    "IAudioGraphStatics": ["76ec3132-e159-4ab7-a82a-17beb4b31e94"],
    "IAudioGraphUnrecoverableErrorOccurredEventArgs": ["c3d9cbe0-3ff6-4fb3-b262-50d435c55423"],
    "IAudioInputEndpointRT": ["8026ab61-92b2-43c1-a1df-5c37ebd08d82"],
    "IAudioInputNode": ["d148005c-8428-4784-b7fd-a99d468c5d20"],
    "IAudioInputNode2": ["905156b7-ca68-4c6d-a8bc-e3ee17fe3fd2"],
    "IAudioInputSelector": ["4f03dc02-5e6e-4653-8f72-a030c123d598"],
    "IAudioLfxControl": ["076a6922-d802-4f83-baf6-409d9ca11bfe"],
    "IAudioLimiter": ["7df8824c-aec7-4119-9425-e6979172a8ae"],
    "IAudioLoudness": ["7d8b1437-dd53-4350-9c1b-1ee2890bd938"],
    "IAudioMatrix": ["bb8b2f5d-2af0-473f-bd94-f55a77587d3f"],
    "IAudioMediaFrame": ["a3a9feff-8021-441b-9a46-e7f0137b7981"],
    "IAudioMediaStream": ["f7537560-a3be-11d0-8212-00c04fc32c45"],
    "IAudioMediaType": ["4e997f73-b71f-4798-873b-ed7dfcf15b4d"],
    "IAudioMeter": ["419b26e3-fa99-4408-83de-cc1276efa489"],
    "IAudioMeterInformation": ["c02216f6-8c67-4b5b-9d00-d008e73e0064"],
    "IAudioMidrange": ["5e54b6d7-b44b-40d9-9a9e-e691d9ce6edf"],
    "IAudioMixer": ["c23bdc7a-47f8-49a1-b750-692c35b532c3"],
    "IAudioMute": ["df45aeea-b74a-4b6b-afad-2366b6aa012e"],
    "IAudioMuteAPO": ["885c7b80-3fa2-4e5a-be07-cf01e1d6e2cd"],
    "IAudioNode": ["15389d7f-dbd8-4819-bf03-668e9357cd6d"],
    "IAudioNodeEmitter": ["3676971d-880a-47b8-adf7-1323a9d965be"],
    "IAudioNodeEmitter2": ["4ab6eecb-ec29-47f8-818c-b6b660a5aeb1"],
    "IAudioNodeEmitterConeProperties": ["e99b2cee-02ca-4375-9326-0c6ae4bcdfb5"],
    "IAudioNodeEmitterDecayModel": ["1d1d5af7-0d53-4fa9-bd84-d5816a86f3ff"],
    "IAudioNodeEmitterDecayModelStatics": ["c7787ca8-f178-462f-bc81-8dd5cbe5dae8"],
    "IAudioNodeEmitterFactory": ["fdc8489a-6ad6-4ce4-b7f7-a99370df7ee9"],
    "IAudioNodeEmitterNaturalDecayModelProperties": ["48934bcf-cf2c-4efc-9331-75bd22df1f0c"],
    "IAudioNodeEmitterShape": ["ea0311c5-e73d-44bc-859c-45553bbc4828"],
    "IAudioNodeEmitterShapeStatics": ["57bb2771-ffa5-4b86-a779-e264aeb9145f"],
    "IAudioNodeListener": ["d9722e16-0c0a-41da-b755-6c77835fb1eb"],
    "IAudioNodeWithListener": ["0e0f907c-79ff-4544-9eeb-01257b15105a"],
    "IAudioOutputEndpointRT": ["8fa906e4-c31c-4e31-932e-19a66385e9aa"],
    "IAudioOutputSelector": ["bb515f69-94a7-429e-8b9c-271b3f11a3ab"],
    "IAudioPeakMeter": ["dd79923c-0599-45e0-b8b6-c8df7db6e796"],
    "IAudioPlaybackConnection": ["1a4c1dea-cafc-50e7-8718-ea3f81cbfa51"],
    "IAudioPlaybackConnectionOpenResult": ["4e656aef-39f9-5fc9-a519-a5bbfd9fe921"],
    "IAudioPlaybackConnectionStatics": ["e60963a2-69e6-5ffc-9e13-824a85213daf"],
    "IAudioProcessingObject": ["fd7f2b29-24d0-4b5c-b177-592c39f9ca10"],
    "IAudioProcessingObjectConfiguration": ["0e5ed805-aba6-49c3-8f9a-2b8c889c4fa8"],
    "IAudioProcessingObjectInternal": ["69e1f79f-6eae-4517-be9f-13aa90e30014"],
    "IAudioProcessingObjectRT": ["9e1d6a6d-ddbc-4e95-a4c7-ad64ba37846c"],
    "IAudioProcessingObjectVBR": ["7ba1db8f-78ad-49cd-9591-f79d80a17c81"],
    "IAudioProcessor": ["6683b02d-3931-487c-ac86-a0f42493c3c3"],
    "IAudioProtectedOutput": ["69a95a38-c637-46a0-9fb2-1c939aebf2e8"],
    "IAudioProtectedOutputController": ["6ec153c1-371e-47e1-a896-2f7f80eb7842"],
    "IAudioPump": ["5945c28d-52af-41ae-abf3-5776f2ea9fc8"],
    "IAudioRateConvert": ["788f7be2-9c40-41c0-af05-4393fbf409f9"],
    "IAudioRenderClient": ["f294acfc-3146-4483-a7bf-addca7c260e2"],
    "IAudioRenderEffectsManager": ["4dc98966-8751-42b2-bfcb-39ca7864bd47"],
    "IAudioSessionControl": ["f4b1a599-7266-4319-a8ca-e70acb11e8cd"],
    "IAudioSessionControl2": ["bfb7ff88-7239-4fc9-8fa2-07c950be9c6d"],
    "IAudioSessionEnumerator": ["e2f5bb11-0570-40ca-acdd-3aa01277dee8"],
    "IAudioSessionEvents": ["24918acc-64b3-37c1-8ca9-74a66e9957a8"],
    "IAudioSessionManager": ["bfa971f1-4d5e-40bb-935e-967039bfbee4"],
    "IAudioSessionManager2": ["77aa99a0-1bd6-484f-8bc7-2c654c9a9b6f"],
    "IAudioSessionNotification": ["641dd20b-4d41-49cc-aba3-174b9477bb08"],
    "IAudioSessionSite": ["d7d8b684-d02d-4517-b6b7-19e3dfe29c45"],
    "IAudioSilenceMonitor": ["22150b0d-ab8e-4f85-bd9a-8580e3b290f1"],
    "IAudioSourceProvider": ["ebbaf249-afc2-4582-91c6-b60df2e84954"],
    "IAudioStateMonitor": ["1d13d136-0199-4cdc-b84e-e72c2b581ece"],
    "IAudioStateMonitorStatics": ["6374ea4c-1b3b-4001-94d9-dd225330fa40"],
    "IAudioStreamDescriptor": ["1e3692e4-4027-4847-a70b-df1d9a2a7b04"],
    "IAudioStreamDescriptor2": ["2e68f1f6-a448-497b-8840-85082665acf9"],
    "IAudioStreamDescriptor3": ["4d220da1-8e83-44ef-8973-2f63e993f36b"],
    "IAudioStreamDescriptorFactory": ["4a86ce9e-4cb1-4380-8e0c-83504b7f5bf3"],
    "IAudioStreamSample": ["345fee00-aba5-11d0-8212-00c04fc32c45"],
    "IAudioStreamVolume": ["93014887-242d-4068-8a15-cf5e93b90fe3"],
    "IAudioSystemEffects": ["5fa00f27-add6-499a-8a9d-6b98521fa75b"],
    "IAudioSystemEffects2": ["bafe99d2-7436-44ce-9e0e-4d89afbfff56"],
    "IAudioSystemEffectsCustomFormats": ["b1176e34-bb7f-4f05-bebd-1b18a534e097"],
    "IAudioTrack": ["f23b6e77-3ef7-40de-b943-068b1321701d"],
    "IAudioTrackOpenFailedEventArgs": ["eeddb9b9-bb7c-4112-bf76-9384676f824b"],
    "IAudioTrackSupportInfo": ["178beff7-cc39-44a6-b951-4a5653f073fa"],
    "IAudioTreble": ["0a717812-694e-4907-b74b-bafa5cfdca7b"],
    "IAudioVirtualProtectedOutput": ["562462dd-4f9a-4110-9d6a-c3ca0407ff76"],
    "IAudioVolume": ["d81229b1-5a43-480c-92f7-be0f7f4eab60"],
    "IAudioVolumeDuckNotification": ["c3b284d4-6d39-4359-b3cf-b56ddb3bb39c"],
    "IAudioVolumeLevel": ["7fb7b48f-531d-44a2-bcb3-5ad5a134b3dc"],
    "IAumidNotificationSettings": ["71d10a03-f4b1-4603-b214-e79834d10082"],
    "IAuthLockScreenImageEx": ["7093134e-768e-47b0-ace0-b2ccd7124ec6"],
    "IAuthUIBumpDialog": ["eeee1dfc-8e6f-4e81-b03e-2873867beb11"],
    "IAuthenticateEx": ["2ad1edaf-d83d-48b5-9adf-03dbe19f53bd"],
    "IAuthenticateHostUI": ["ac78490a-ea21-4757-87d2-12bf26030d30"],
    "IAuthenticateHostUISite": ["aeb7815f-926e-485f-8ea1-43047a9b7984"],
    "IAuthenticationProviderConfig": ["66a2db17-d706-11d0-a37b-00c04fc9da04"],
    "IAutoCompleteHost": ["a85871f1-3167-491f-9642-a11c3f5ce52a"],
    "IAutoExpandInNSC": ["498175a5-67a8-4e7d-b666-b0fb9d029b6b"],
    "IAutoListDescription": ["607c87f7-0696-4558-a368-de5e59cfe456"],
    "IAutoPlayDirect": ["b7d1e57c-4276-4c21-9bfe-6f02fbfd67d3"],
    "IAutoRepeatModeChangeRequestedEventArgs": ["ea137efa-d852-438e-882b-c990109a78f4"],
    "IAutoRetry": ["56887418-c996-4ee6-95e2-fa03776e10b3"],
    "IAutoSuggestBox": ["103e9b13-3400-4a16-90b9-6912bf06974f"],
    "IAutoSuggestBox2": ["aa87ddde-e679-45b2-a7c9-9aedc39db886"],
    "IAutoSuggestBox3": ["9bbbfcef-f32d-402e-9009-05bdbaf6336e"],
    "IAutoSuggestBox4": ["c22df897-a3e8-5051-b3cc-b5f0f5262950"],
    "IAutoSuggestBoxAutomationPeer": ["2f32c302-f99b-491d-9726-a5e181643efa"],
    "IAutoSuggestBoxAutomationPeerFactory": ["80046849-18e7-4475-b362-4bbd53d24562"],
    "IAutoSuggestBoxQuerySubmittedEventArgs": ["78dcb116-818a-4cb5-bca7-382ce6ddc90d"],
    "IAutoSuggestBoxStatics": ["ee22c7f4-c15d-4ff3-8a94-f50dfdfbe89a"],
    "IAutoSuggestBoxStatics2": ["1cd297a8-8e6a-41ef-a95d-7157dc0c7106"],
    "IAutoSuggestBoxStatics3": ["2cead2dd-c4d5-4ab2-8a13-afddcf067c86"],
    "IAutoSuggestBoxStatics4": ["d63efaae-b9df-58d8-a00a-dbfe9ffdedd0"],
    "IAutoSuggestBoxSuggestionChosenEventArgs": ["396f7254-1ed5-4bc5-a060-655530bca6ba"],
    "IAutoSuggestBoxTextChangedEventArgs": ["3a6f7254-1ed5-4bc5-a060-655530bca6ba"],
    "IAutoSuggestBoxTextChangedEventArgsStatics": ["fef7772b-9f45-44db-8c27-bda3f933e7b5"],
    "IAutomaticDestinationList": ["e9c5ef8d-fd41-4f72-ba87-eb03bad5817c"],
    "IAutomaticDestinationList2": ["e014d578-d95e-4757-bffb-3bda010fe68a"],
    "IAutomaticUpdates": ["673425bf-c082-4c7c-bdfd-569464b8e0ce"],
    "IAutomaticUpdates2": ["4a2f5c31-cfd9-410e-b7fb-29a653973a0f"],
    "IAutomaticUpdatesResults": ["e7a4d634-7942-4dd9-a111-82228ba33901"],
    "IAutomaticUpdatesSettings": ["2ee48f22-af3c-405f-8970-f71be12ee9a2"],
    "IAutomaticUpdatesSettings2": ["6abc136a-c3ca-4384-8171-cb2b1e59b8dc"],
    "IAutomaticUpdatesSettings3": ["b587f5c3-f57e-485f-bbf5-0d181c5cd0dc"],
    "IAutomationAnnotation": ["fb3c30ca-03d8-4618-91bf-e4d84f4af318"],
    "IAutomationAnnotationFactory": ["4906fa52-ddc0-4e69-b76b-019d928d822f"],
    "IAutomationAnnotationStatics": ["e503eab7-4ee5-48cb-b5b8-bbcd46c9d1da"],
    "IAutomationElementIdentifiers": ["e68a63cf-4345-4e2d-8a6a-49cce1fa2dcc"],
    "IAutomationElementIdentifiersStatics": ["4549399f-8340-4d67-b9bf-8c2ac6a0773a"],
    "IAutomationElementIdentifiersStatics2": ["b5cbb1e2-d55f-46a9-9eda-1a4742515dc3"],
    "IAutomationElementIdentifiersStatics3": ["0f5cbebd-b3eb-4083-adc7-0c2f39bb3543"],
    "IAutomationElementIdentifiersStatics4": ["5af51f75-5913-4d78-b330-a6f50b73ed9b"],
    "IAutomationElementIdentifiersStatics5": ["986a8206-de59-42f9-a1e7-62b8af9e756d"],
    "IAutomationElementIdentifiersStatics6": ["de52b00d-8328-4eae-8035-f8db99c8bac4"],
    "IAutomationElementIdentifiersStatics7": ["00f1abb2-742c-446a-a8f6-1672b10d2874"],
    "IAutomationElementIdentifiersStatics8": ["8517b060-806c-5dc5-bc41-891bb5a47adf"],
    "IAutomationPeer": ["35aac87a-62ee-4d3e-a24c-2bc8432d68b7"],
    "IAutomationPeer2": ["ea1f89c7-ebf5-4ab8-88f7-680d821dac61"],
    "IAutomationPeer3": ["d3cfb977-0084-41d7-a221-28158d3bc32c"],
    "IAutomationPeer4": ["761ce752-73c1-4f44-be75-43c49ec0d4d5"],
    "IAutomationPeer5": ["f632e1c6-0a3f-4574-9fef-cdc151765674"],
    "IAutomationPeer6": ["caf8608f-13ff-42fb-866d-22206434cc6b"],
    "IAutomationPeer7": ["796b3287-e642-48ab-b223-5208b41da9d6"],
    "IAutomationPeer8": ["5c6a1fe6-9a55-4d7f-9498-cfe429e92da8"],
    "IAutomationPeer9": ["df2e0265-1d74-57fa-8094-f81c2f626b8c"],
    "IAutomationPeerAnnotation": ["0c456061-52cf-43fa-82f8-07f137351e5a"],
    "IAutomationPeerAnnotationFactory": ["f59c439e-c65b-43cd-9009-03fc023363a7"],
    "IAutomationPeerAnnotationStatics": ["8809a87d-09b2-4d45-b78b-1d3b3b09f661"],
    "IAutomationPeerFactory": ["20c27545-a88b-43c8-bc24-cea9dafd04a3"],
    "IAutomationPeerOverrides": ["bea93e67-dbee-4f7b-af0d-a79aae5333bf"],
    "IAutomationPeerOverrides2": ["2603682a-9da6-4023-b496-496e5ef228d2"],
    "IAutomationPeerOverrides3": ["b6f0c4ad-4d39-49e6-bb91-d924eefd8538"],
    "IAutomationPeerOverrides4": ["b186cda2-5d46-4bcd-a811-269ad15b3aee"],
    "IAutomationPeerOverrides5": ["2c847c85-781e-49f7-9fef-b9e14d014707"],
    "IAutomationPeerOverrides6": ["e98babe7-f6ff-444c-9c0d-277eaf0ad9c0"],
    "IAutomationPeerOverrides8": ["0e1ebbd4-a003-4936-8175-f5457c07f0c6"],
    "IAutomationPeerOverrides9": ["f3709e8b-091a-5db5-b896-ff78f01990c9"],
    "IAutomationPeerProtected": ["f4b40e52-642f-4629-a54a-ea5d2349c448"],
    "IAutomationPeerStatics": ["562f7fb0-a331-4a9c-9dec-bfb7586fffff"],
    "IAutomationPeerStatics3": ["572c5714-7f87-4271-819f-6cf4c4d022d0"],
    "IAutomationProperties": ["68d7232c-e622-48e9-af0b-1ffa33cc5cba"],
    "IAutomationPropertiesStatics": ["b618fd7b-32d0-4970-9c42-7c039ac7be78"],
    "IAutomationPropertiesStatics2": ["3976547f-7089-4801-8f1d-aab78090d1a0"],
    "IAutomationPropertiesStatics3": ["7b75d735-5cb1-42ad-9b57-5faba8c1867f"],
    "IAutomationPropertiesStatics4": ["f7d62655-311a-4b7c-a131-524e89cd3cf9"],
    "IAutomationPropertiesStatics5": ["0be35b26-c8f9-41a2-b4db-e6a7a32b0c34"],
    "IAutomationPropertiesStatics6": ["c61e030f-eb49-4e5d-b012-4c1c96c3901b"],
    "IAutomationPropertiesStatics7": ["f7e98bf3-8f91-4068-a4ad-b7b402d10a2c"],
    "IAutomationPropertiesStatics8": ["432eca20-171a-560d-8524-3e651d3ad6ca"],
    "IAutomationProperty": ["b627195b-3227-4e16-9534-ddece30ddb46"],
    "IAutomationProviderRequestedEventArgs": ["961ff258-21bf-4b42-a298-fa479d4c52e2"],
    "IAutoplayHandlerList": ["f68dde6d-ae8c-4047-bfae-65bb5173d4d9"],
    "IAuxInTuningSpace": ["e48244b8-7e17-4f76-a763-5090ff1e2f30"],
    "IAuxInTuningSpace2": ["b10931ed-8bfe-4ab0-9dce-e469c29a9729"],
    "IAvailableCategory": ["87f5fad1-d143-44d3-a835-834473cbc292"],
    "IAvailableCategoryNotifySink": ["14a821a3-97e8-11d9-8309-000d9dff97d3"],
    "IAvailableNetwork": ["14a82193-97e8-11d9-8309-000d9dff97d3"],
    "IAvailableNetworkCustomUI": ["14a82196-97e8-11d9-8309-000d9dff97d3"],
    "IAvailableNetworkDataUsage": ["54fda6e7-864f-4a59-bdea-42f77cba1952"],
    "IAvailableNetworkDiagnostic": ["14a821a1-97e8-11d9-8309-000d9dff97d3"],
    "IAvailableNetworkMediaManager": ["cbe511f1-0829-4db1-adee-2e681476c896"],
    "IAvailableNetworkMediaManagerDiagnostic": ["14a821a0-97e8-11d9-8309-000d9dff97d3"],
    "IAvailableNetworkMediaManagerNotifySink": ["14a82195-97e8-11d9-8309-000d9dff97d3"],
    "IAvailableNetworkNotifySink": ["14a82199-97e8-11d9-8309-000d9dff97d3"],
    "IAvailableNetworkSettings": ["14a821a4-97e8-11d9-8309-000d9dff97d3"],
    "IAvailableNetworkUiDUIElements": ["260677a6-dfe4-4834-a932-bc4ebefc7975"],
    "IAvailableNetworkUiDUIElementsNotifySink": ["7c86dfa9-1407-4c9d-beb4-9d85a9764fd3"],
    "IAvailableNetworkUiElements": ["3807204c-c211-49a4-8db1-711ff2c732b4"],
    "IAvailableNetworkUiElementsContextMenu": ["7c8b80c6-1e4a-4a6b-9e5e-87a44151f233"],
    "IAzApplication": ["987bc7c7-b813-4d27-bede-6ba5ae867e95"],
    "IAzApplication2": ["086a68af-a249-437c-b18d-d4d86d6a9660"],
    "IAzApplication3": ["181c845e-7196-4a7d-ac2e-020c0bb7a303"],
    "IAzApplicationGroup": ["f1b744cd-58a6-4e06-9fbf-36f6d779e21e"],
    "IAzApplicationGroup2": ["3f0613fc-b71a-464e-a11d-5b881a56cefa"],
    "IAzApplicationGroups": ["4ce66ad5-9f3c-469d-a911-b99887a7e685"],
    "IAzApplications": ["929b11a9-95c5-4a84-a29a-20ad42c2f16c"],
    "IAzAuthorizationStore": ["edbd9ca9-9b82-4f6a-9e8b-98301e450f14"],
    "IAzAuthorizationStore2": ["b11e5584-d577-4273-b6c5-0973e0f8e80d"],
    "IAzAuthorizationStore3": ["abc08425-0c86-4fa0-9be3-7189956c926e"],
    "IAzBizRuleContext": ["e192f17d-d59f-455e-a152-940316cd77b2"],
    "IAzBizRuleInterfaces": ["e94128c7-e9da-44cc-b0bd-53036f3aab3d"],
    "IAzBizRuleParameters": ["fc17685f-e25d-4dcd-bae1-276ec9533cb5"],
    "IAzClientContext": ["eff1f00b-488a-466d-afd9-a401c5f9eef5"],
    "IAzClientContext2": ["2b0c92b8-208a-488a-8f81-e4edb22111cd"],
    "IAzClientContext3": ["11894fde-1deb-4b4b-8907-6d1cda1f5d4f"],
    "IAzNameResolver": ["504d0f15-73e2-43df-a870-a64f40714f53"],
    "IAzObjectPicker": ["63130a48-699a-42d8-bf01-c62ac3fb79f9"],
    "IAzOperation": ["5e56b24f-ea01-4d61-be44-c49b5e4eaf74"],
    "IAzOperation2": ["1f5ea01f-44a2-4184-9c48-a75b4dcc8ccc"],
    "IAzOperations": ["90ef9c07-9706-49d9-af80-0438a5f3ec35"],
    "IAzPrincipalLocator": ["e5c3507d-ad6a-4992-9c7f-74ab480b44cc"],
    "IAzRole": ["859e0d8d-62d7-41d8-a034-c0cd5d43fdfa"],
    "IAzRoleAssignment": ["55647d31-0d5a-4fa3-b4ac-2b5f9ad5ab76"],
    "IAzRoleAssignments": ["9c80b900-fceb-4d73-a0f4-c83b0bbf2481"],
    "IAzRoleDefinition": ["d97fcea1-2599-44f1-9fc3-58e9fbe09466"],
    "IAzRoleDefinitions": ["881f25a5-d755-4550-957a-d503a3b34001"],
    "IAzRoles": ["95e0f119-13b4-4dae-b65f-2f7d60d822e4"],
    "IAzScope": ["00e52487-e08d-4514-b62e-877d5645f5ab"],
    "IAzScope2": ["ee9fe8c9-c9f3-40e2-aa12-d1d8599727fd"],
    "IAzScopes": ["78e14853-9f5e-406d-9b91-6bdba6973510"],
    "IAzTask": ["cb94e592-2e0e-4a6c-a336-b89a6dc1e388"],
    "IAzTask2": ["03a9a5ee-48c8-4832-9025-aad503c46526"],
    "IAzTasks": ["b338ccab-4c85-4388-8c0a-c58592bad398"],
    "IBDAComparable": ["b34505e0-2f0e-497b-80bc-d43f3b24ed7f"],
    "IBDACreateTuneRequestEx": ["c0a4a1d4-2b3c-491a-ba22-499fbadd4d12"],
    "IBDA_AUX": ["7def4c09-6e66-4567-a819-f0e17f4a81ab"],
    "IBDA_AutoDemodulate": ["ddf15b12-bd25-11d2-9ca0-00c04f7971e0"],
    "IBDA_AutoDemodulateEx": ["34518d13-1182-48e6-b28f-b24987787326"],
    "IBDA_ConditionalAccess": ["cd51f1e0-7be9-4123-8482-a2a796c0a6b0"],
    "IBDA_ConditionalAccessEx": ["497c3418-23cb-44ba-bb62-769f506fcea7"],
    "IBDA_DRIDRMService": ["1f9bc2a5-44a3-4c52-aab1-0bbce5a1381d"],
    "IBDA_DRIWMDRMSession": ["05c690f8-56db-4bb2-b053-79c12098bb26"],
    "IBDA_DRM": ["f98d88b0-1992-4cd6-a6d9-b9afab99330d"],
    "IBDA_DRMService": ["bff6b5bb-b0ae-484c-9dca-73528fb0b46e"],
    "IBDA_DeviceControl": ["fd0a5af3-b41d-11d2-9c95-00c04f7971e0"],
    "IBDA_DiagnosticProperties": ["20e80cb5-c543-4c1b-8eb3-49e719eee7d4"],
    "IBDA_DigitalDemodulator": ["ef30f379-985b-4d10-b640-a79d5e04e1e0"],
    "IBDA_DigitalDemodulator2": ["525ed3ee-5cf3-4e1e-9a06-5368a84f9a6e"],
    "IBDA_DigitalDemodulator3": ["13f19604-7d32-4359-93a2-a05205d90ac9"],
    "IBDA_DiseqCommand": ["f84e2ab0-3c6b-45e3-a0fc-8669d4b81f11"],
    "IBDA_EasMessage": ["d806973d-3ebe-46de-8fbb-6358fe784208"],
    "IBDA_Encoder": ["3a8bad59-59fe-4559-a0ba-396cfaa98ae3"],
    "IBDA_EthernetFilter": ["71985f43-1ca1-11d3-9cc8-00c04f7971e0"],
    "IBDA_EventingService": ["207c413f-00dc-4c61-bad6-6fee1ff07064"],
    "IBDA_FDC": ["138adc7e-58ae-437f-b0b4-c9fe19d5b4ac"],
    "IBDA_FrequencyFilter": ["71985f47-1ca1-11d3-9cc8-00c04f7971e0"],
    "IBDA_GuideDataDeliveryService": ["c0afcb73-23e7-4bc6-bafa-fdc167b4719f"],
    "IBDA_IPSinkControl": ["3f4dc8e2-4050-11d3-8f4b-00c04f7971e2"],
    "IBDA_IPSinkInfo": ["a750108f-492e-4d51-95f7-649b23ff7ad7"],
    "IBDA_IPV4Filter": ["71985f44-1ca1-11d3-9cc8-00c04f7971e0"],
    "IBDA_IPV6Filter": ["e1785a74-2a23-4fb3-9245-a8f88017ef33"],
    "IBDA_ISDBConditionalAccess": ["5e68c627-16c2-4e6c-b1e2-d00170cdaa0f"],
    "IBDA_LNBInfo": ["992cf102-49f9-4719-a664-c4f23e2408f4"],
    "IBDA_MUX": ["942aafec-4c05-4c74-b8eb-8706c2a4943f"],
    "IBDA_NameValueService": ["7f0b3150-7b81-4ad4-98e3-7e9097094301"],
    "IBDA_NetworkProvider": ["fd501041-8ebe-11ce-8183-00aa00577da2"],
    "IBDA_NullTransform": ["ddf15b0d-bd25-11d2-9ca0-00c04f7971e0"],
    "IBDA_PinControl": ["0ded49d5-a8b7-4d5d-97a1-12b0c195874d"],
    "IBDA_SignalProperties": ["d2f1644b-b409-11d2-bc69-00a0c9ee9e16"],
    "IBDA_SignalStatistics": ["1347d106-cf3a-428a-a5cb-ac0d9a2a4338"],
    "IBDA_TIF_REGISTRATION": ["dfef4a68-ee61-415f-9ccb-cd95f2f98a3a"],
    "IBDA_Topology": ["79b56888-7fea-4690-b45d-38fd3c7849be"],
    "IBDA_TransportStreamInfo": ["8e882535-5f86-47ab-86cf-c281a72a0549"],
    "IBDA_TransportStreamSelector": ["1dcfafe9-b45e-41b3-bb2a-561eb129ae98"],
    "IBDA_UserActivityService": ["53b14189-e478-4b7a-a1ff-506db4b99dfe"],
    "IBDA_VoidTransform": ["71985f46-1ca1-11d3-9cc8-00c04f7971e0"],
    "IBDA_WMDRMSession": ["4be6fa3d-07cd-4139-8b80-8c18ba3aec88"],
    "IBDA_WMDRMTuner": ["86d979cf-a8a7-4f94-b5fb-14c0aca68fe6"],
    "IBFCacheable": ["30510861-98b5-11cf-bb82-00aa00bdce0b"],
    "IBITSExtensionSetup": ["29cfbbf7-09e4-4b97-b0bc-f2287e3d8eb3"],
    "IBITSExtensionSetupFactory": ["d5d2d542-5503-4e64-8b48-72ef91a32ee1"],
    "IBackClickEventArgs": ["2ae6146c-477e-48c9-8830-2c464b7c7104"],
    "IBackClickEventHandler": ["fa9bc21f-9892-482e-abf6-eb2d607d32de"],
    "IBackComponentService": ["d00fe662-58ee-4068-9eb9-f5bc39972ef4"],
    "IBackEase": ["e47796e7-f805-4a8f-81c9-38e6472caa94"],
    "IBackEaseStatics": ["3c70a2ff-a0a0-4786-926c-22321f8f25b7"],
    "IBackReferencedObject": ["c938b119-d3ad-4d02-b5ee-164c2ec8160e"],
    "IBackRequestedEventArgs": ["d603d28a-e411-4a4e-ba41-6a327a8675bc"],
    "IBackStackApplicationNotification": ["a64a6c35-3367-439e-a713-93f78e365b7b"],
    "IBackgroundAccessManagerBroker": ["934aa191-7986-46f0-ae1e-bbe6e4c7aa90"],
    "IBackgroundAccessManagerService": ["428d4ddd-3462-43df-9395-1eff13ae7a4b"],
    "IBackgroundAccessStateChangeHandler": ["43c6b434-c1be-4ad2-af03-c0deaccebd1f"],
    "IBackgroundAccessStateChangeHandler2": ["a15f35d4-56f1-482a-a9c5-5f77d1abe30a"],
    "IBackgroundActivatedEventArgs": ["ab14bee0-e760-440e-a91c-44796de3a92d"],
    "IBackgroundActivatedEventHandler": ["edb19fbb-0761-47cc-9a77-24d7072965ca"],
    "IBackgroundActivationContext": ["a2add09a-fb9b-4e6e-bc69-0b810eeb0ab4"],
    "IBackgroundActivationSessionManagerEvents": ["e7fb793d-3581-4b54-a798-ab8e9d69c963"],
    "IBackgroundAudioTrack": ["4b91b3bd-9e21-4266-a9c2-67dd011a2357"],
    "IBackgroundAudioTrackStatics": ["d9b1c0d7-d018-42a8-a559-cb4d9e97e664"],
    "IBackgroundCondition": ["ae48a1ee-8951-400a-8302-9c9c9a2a3a3b"],
    "IBackgroundContextMenuInvoked": ["2c68bdea-fe5e-4c78-9008-44c026994ca6"],
    "IBackgroundCopyCallback1": ["084f6593-3800-4e08-9b59-99fa59addf82"],
    "IBackgroundCopyCallback2": ["659cdeac-489e-11d9-a9cd-000d56965251"],
    "IBackgroundCopyCallback3": ["98c97bd2-e32b-4ad8-a528-95fd8b16bd42"],
    "IBackgroundCopyFile3": ["659cdeaa-489e-11d9-a9cd-000d56965251"],
    "IBackgroundCopyFile4": ["ef7e0655-7888-4960-b0e5-730846e03492"],
    "IBackgroundCopyFile5": ["85c1657f-dafc-40e8-8834-df18ea25717e"],
    "IBackgroundCopyFile6": ["cf6784f7-d677-49fd-9368-cb47aee9d1ad"],
    "IBackgroundCopyGroup": ["1ded80a7-53ea-424f-8a04-17fea9adc4f5"],
    "IBackgroundCopyJob1": ["59f5553c-2031-4629-bb18-2645a6970947"],
    "IBackgroundCopyJob4": ["659cdeae-489e-11d9-a9cd-000d56965251"],
    "IBackgroundCopyJob5": ["e847030c-bbba-4657-af6d-484aa42bf1fe"],
    "IBackgroundCopyJobHttpOptions": ["f1bd1079-9f01-4bdc-8036-f09b70095066"],
    "IBackgroundCopyJobHttpOptions2": ["b591a192-a405-4fc3-8323-4c5c542578fc"],
    "IBackgroundCopyJobHttpOptions3": ["8a9263d3-fd4c-4eda-9b28-30132a4d4e3c"],
    "IBackgroundCopyQMgr": ["16f41c69-09f5-41d2-8cd8-3c08c47bc8a8"],
    "IBackgroundCopyServerCertificateValidationCallback": ["4cec0d02-def7-4158-813a-c32a46945ff7"],
    "IBackgroundDownloader": ["c1c79333-6649-4b1d-a826-a4b3dd234d0b"],
    "IBackgroundDownloader2": ["a94a5847-348d-4a35-890e-8a1ef3798479"],
    "IBackgroundDownloader3": ["d11a8c48-86e8-48e2-b615-6976aabf861d"],
    "IBackgroundDownloaderFactory": ["26836c24-d89e-46f4-a29a-4f4d4f144155"],
    "IBackgroundDownloaderStaticMethods": ["52a65a35-c64e-426c-9919-540d0d21a650"],
    "IBackgroundDownloaderStaticMethods2": ["2faa1327-1ad4-4ca5-b2cd-08dbf0746afe"],
    "IBackgroundEventDetailsFactory": ["853d138c-29ca-42d1-8287-1b797d86f21a"],
    "IBackgroundExecutionManagerStatics": ["e826ea58-66a9-4d41-83d4-b4c18c87b846"],
    "IBackgroundExecutionManagerStatics2": ["469b24ef-9bbb-4e18-999a-fd6512931be9"],
    "IBackgroundTask": ["6a14295b-4900-49c8-8269-2c5686cecd16", "7d13d534-fd12-43ce-8c22-ea1ff13c06df"],
    "IBackgroundTaskBuilder": ["0351550e-3e64-4572-a93a-84075a37c917"],
    "IBackgroundTaskBuilder2": ["6ae7cfb1-104f-406d-8db6-844a570f42bb"],
    "IBackgroundTaskBuilder3": ["28c74f4a-8ba9-4c09-a24f-19683e2c924c"],
    "IBackgroundTaskBuilder4": ["4755e522-cba2-4e35-bd16-a6da7f1c19aa"],
    "IBackgroundTaskBuilder5": ["077103f6-99f5-4af4-bcad-4731d0330d43"],
    "IBackgroundTaskCanceledEventHandler": ["a6c4bac0-51f8-4c57-ac3f-156dd1680c4f"],
    "IBackgroundTaskCapabilityInternal": ["445289d9-2bba-4b3d-9f41-09683cc27200"],
    "IBackgroundTaskCompletedEventArgs": ["565d25cf-f209-48f4-9967-2b184f7bfbf0"],
    "IBackgroundTaskCompletedEventHandler": ["5b38e929-a086-46a7-a678-439135822bcf"],
    "IBackgroundTaskDeferral": ["93cc156d-af27-4dd3-846e-24ee40cadd25"],
    "IBackgroundTaskInstance": ["865bda7a-21d8-4573-8f32-928a1b0641f6"],
    "IBackgroundTaskInstance2": ["4f7d0176-0c76-4fb4-896d-5de1864122f6"],
    "IBackgroundTaskInstance4": ["7f29f23c-aa04-4b08-97b0-06d874cdabf5"],
    "IBackgroundTaskProgressEventArgs": ["fb1468ac-8332-4d0a-9532-03eae684da31"],
    "IBackgroundTaskProgressEventHandler": ["46e0683c-8a88-4c99-804c-76897f6277a6"],
    "IBackgroundTaskRegistration": ["10654cc2-a26e-43bf-8c12-1fb40dbfbfa0"],
    "IBackgroundTaskRegistration2": ["6138c703-bb86-4112-afc3-7f939b166e3b"],
    "IBackgroundTaskRegistration3": ["fe338195-9423-4d8b-830d-b1dd2c7badd5"],
    "IBackgroundTaskRegistrationGroup": ["2ab1919a-871b-4167-8a76-055cd67b5b23"],
    "IBackgroundTaskRegistrationGroupFactory": ["83d92b69-44cf-4631-9740-03c7d8741bc5"],
    "IBackgroundTaskRegistrationStatics": ["4c542f69-b000-42ba-a093-6a563c65e3f8"],
    "IBackgroundTaskRegistrationStatics2": ["174b671e-b20d-4fa9-ad9a-e93ad6c71e01"],
    "IBackgroundTransferBase": ["2a9da250-c769-458c-afe8-feb8d4d3b2ef"],
    "IBackgroundTransferCompletionGroup": ["2d930225-986b-574d-7950-0add47f5d706"],
    "IBackgroundTransferCompletionGroupTriggerDetails": ["7b6be286-6e47-5136-7fcb-fa4389f46f5b"],
    "IBackgroundTransferContentPart": ["e8e15657-d7d1-4ed8-838e-674ac217ace6"],
    "IBackgroundTransferContentPartFactory": ["90ef98a9-7a01-4a0b-9f80-a0b0bb370f8d"],
    "IBackgroundTransferErrorStaticMethods": ["aad33b04-1192-4bf4-8b68-39c5add244e2"],
    "IBackgroundTransferGroup": ["d8c3e3e4-6459-4540-85eb-aaa1c8903677"],
    "IBackgroundTransferGroupStatics": ["02ec50b2-7d18-495b-aa22-32a97d45d3e2"],
    "IBackgroundTransferOperation": ["ded06846-90ca-44fb-8fb1-124154c0d539"],
    "IBackgroundTransferOperationPriority": ["04854327-5254-4b3a-915e-0aa49275c0f9"],
    "IBackgroundTransferRangesDownloadedEventArgs": ["3ebc7453-bf48-4a88-9248-b0c165184f5c"],
    "IBackgroundTrigger": ["84b3a058-6027-4b87-9790-bdf3f757dbd7"],
    "IBackgroundUploader": ["c595c9ae-cead-465b-8801-c55ac90a01ce"],
    "IBackgroundUploader2": ["8e0612ce-0c34-4463-807f-198a1b8bd4ad"],
    "IBackgroundUploader3": ["b95e9439-5bf0-4b3a-8c47-2c6199a854b9"],
    "IBackgroundUploaderFactory": ["736203c7-10e7-48a0-ac3c-1ac71095ec57"],
    "IBackgroundUploaderStaticMethods": ["f2875cfb-9b05-4741-9121-740a83e247df"],
    "IBackgroundUploaderStaticMethods2": ["e919ac62-ea08-42f0-a2ac-07e467549080"],
    "IBackgroundWorkCostStatics": ["c740a662-c310-4b82-b3e3-3bcfb9e4c77d"],
    "IBackgroundWorkItemInstanceEvents": ["c21a025f-497a-47ce-abb5-dd7cf34d04cb"],
    "IBackgroundWorkItemInstanceRemote": ["0166231b-fd21-4e33-a713-75eb3207a138"],
    "IBackupDataLossDetector": ["3e2d05ac-3aa5-46fc-b7a4-8b14b9b1b59b"],
    "IBackupDataLossInfo": ["a7e443ae-8414-4853-bd79-dc8d6dfa063c"],
    "IBackupRestoreServices": ["f5f7bf38-0c0f-4b31-9dc0-fd925995cb68"],
    "IBackupSettings": ["cdfe1d93-f8c7-4236-b52c-b3eeec640576"],
    "IBadgeNotification": ["075cb4ca-d08a-4e2f-9233-7e289c1f7722"],
    "IBadgeNotificationFactory": ["edf255ce-0618-4d59-948a-5a61040c52f9"],
    "IBadgeUpdateManagerForUser": ["996b21bc-0386-44e5-ba8d-0c1077a62e92"],
    "IBadgeUpdateManagerStatics": ["33400faa-6dd5-4105-aebc-9b50fca492da"],
    "IBadgeUpdateManagerStatics2": ["979a35ce-f940-48bf-94e8-ca244d400b41"],
    "IBadgeUpdater": ["b5fa1fd4-7562-4f6c-bfa3-1b6ed2e57f2f"],
    "IBandHost": ["b9075c7c-d48e-403f-ab99-d6c77a1084ac"],
    "IBandwidthEstimation": ["6aebc7c5-323b-485e-8e25-fa49e68b72df"],
    "IBannerNotificationHandler": ["8d7b2ba7-db05-46a8-823c-d2b6de08ee91"],
    "IBannerUI": ["355ac7b4-0db5-460c-9a7e-263cf9cb801a"],
    "IBarcodeScanner": ["bea33e06-b264-4f03-a9c1-45b20f01134f"],
    "IBarcodeScanner2": ["89215167-8cee-436d-89ab-8dfb43bb4286"],
    "IBarcodeScannerCapabilities": ["c60691e4-f2c8-4420-a307-b12ef6622857"],
    "IBarcodeScannerCapabilities1": ["8e5ab3e9-0e2c-472f-a1cc-ee8054b6a684"],
    "IBarcodeScannerCapabilities2": ["f211cfec-e1a1-4ea8-9abc-92b1596270ab"],
    "IBarcodeScannerDataReceivedEventArgs": ["4234a7e2-ed97-467d-ad2b-01e44313a929"],
    "IBarcodeScannerDisableScannerRequest": ["88ecf7c0-37b9-4275-8e77-c8e52ae5a9c8"],
    "IBarcodeScannerDisableScannerRequest2": ["ccdfe625-65c3-4ccc-b457-f39c7a9ea60d"],
    "IBarcodeScannerDisableScannerRequestEventArgs": ["7006e142-e802-46f5-b604-352a15ce9232"],
    "IBarcodeScannerEnableScannerRequest": ["c0b3e9ba-816a-452b-bd77-b7e453ec446d"],
    "IBarcodeScannerEnableScannerRequest2": ["71a4f2a8-9905-41ac-9121-b645916a84a1"],
    "IBarcodeScannerEnableScannerRequestEventArgs": ["956c9419-7b4e-4451-8c41-8e10cfbc5b41"],
    "IBarcodeScannerErrorOccurredEventArgs": ["2cd2602f-cf3a-4002-a75a-c5ec468f0a20"],
    "IBarcodeScannerFrameReader": ["dbc72b07-64c3-482b-93c8-65fb33c22208"],
    "IBarcodeScannerFrameReaderFrameArrivedEventArgs": ["b0bbd604-54fd-436d-8629-712e787223dd"],
    "IBarcodeScannerGetSymbologyAttributesRequest": ["9774c46a-58e4-4c5f-b8e9-e41467632700"],
    "IBarcodeScannerGetSymbologyAttributesRequest2": ["6a6a2b13-75a8-49fb-b852-bfb93d760af7"],
    "IBarcodeScannerGetSymbologyAttributesRequestEventArgs": ["7f89de3e-fb5d-493c-b402-356b24d574a6"],
    "IBarcodeScannerHideVideoPreviewRequest": ["fa4ebe7f-6670-40e1-b90b-bb10d8d425fa"],
    "IBarcodeScannerHideVideoPreviewRequest2": ["7e28435d-9814-431d-a2f2-d6248c5ad4b5"],
    "IBarcodeScannerHideVideoPreviewRequestEventArgs": ["16a281fc-d6be-4bc7-9df1-33741f3eadea"],
    "IBarcodeScannerImagePreviewReceivedEventArgs": ["f3b7de85-6e8b-434e-9f58-06ef26bc4baf"],
    "IBarcodeScannerPreviewActivatedEventArgs": ["6772797c-99bf-4349-af22-e4123560371c"],
    "IBarcodeScannerProviderConnection": ["b44acbed-0b3a-4fa3-86c5-491ea30780eb"],
    "IBarcodeScannerProviderConnection2": ["be9b53cd-1134-418c-a06b-04423a73f3d7"],
    "IBarcodeScannerProviderTriggerDetails": ["50856d82-24e3-48ce-99c7-70aac1cbc9f7"],
    "IBarcodeScannerReport": ["5ce4d8b0-a489-4b96-86c4-f0bf8a37753d"],
    "IBarcodeScannerReportFactory": ["a2547326-2013-457c-8963-49c15dca78ce"],
    "IBarcodeScannerSetActiveSymbologiesRequest": ["db3f32b9-f7da-41a1-9f79-07bcd95f0bdf"],
    "IBarcodeScannerSetActiveSymbologiesRequest2": ["f5ff6edf-fa9a-4749-b11b-e8fccb75bc6b"],
    "IBarcodeScannerSetActiveSymbologiesRequestEventArgs": ["06305afa-7bf6-4d52-801a-330272f60ae1"],
    "IBarcodeScannerSetSymbologyAttributesRequest": ["32fb814f-a37f-48b0-acea-dce1480f12ae"],
    "IBarcodeScannerSetSymbologyAttributesRequest2": ["dffbbfc1-dba8-4b77-be1e-b56cd72f65b3"],
    "IBarcodeScannerSetSymbologyAttributesRequestEventArgs": ["b2b89809-9824-47d4-85bd-d0077baa7bd2"],
    "IBarcodeScannerStartSoftwareTriggerRequest": ["e3fa7b27-ff62-4454-af4a-cb6144a3e3f7"],
    "IBarcodeScannerStartSoftwareTriggerRequest2": ["eb72a25c-6658-4765-a68e-327482653deb"],
    "IBarcodeScannerStartSoftwareTriggerRequestEventArgs": ["2305d843-c88f-4f3b-8c3b-d3df071051ec"],
    "IBarcodeScannerStatics": ["5d115f6f-da49-41e8-8c8c-f0cb62a9c4fc"],
    "IBarcodeScannerStatics2": ["b8652473-a36f-4007-b1d0-279ebe92a656"],
    "IBarcodeScannerStatusUpdatedEventArgs": ["355d8586-9c43-462b-a91a-816dc97f452c"],
    "IBarcodeScannerStopSoftwareTriggerRequest": ["6f9faf35-e287-4ca8-b70d-5a91d694f668"],
    "IBarcodeScannerStopSoftwareTriggerRequest2": ["cb57c5dd-fe50-49f8-a0b4-bdc230814da2"],
    "IBarcodeScannerStopSoftwareTriggerRequestEventArgs": ["eac34450-4eb7-481a-9273-147a273b99b8"],
    "IBarcodeScannerVideoFrame": ["7e585248-9df7-4121-a175-801d8000112e"],
    "IBarcodeSymbologiesStatics": ["ca8549bb-06d2-43f4-a44b-c620679fd8d0"],
    "IBarcodeSymbologiesStatics2": ["8b7518f4-99d0-40bf-9424-b91d6dd4c6e0"],
    "IBarcodeSymbologyAttributes": ["66413a78-ab7a-4ada-8ece-936014b2ead7"],
    "IBarcodeSymbologyAttributesBuilder": ["c57b0cbf-e4f5-40b9-84cf-e63fbaea42b4"],
    "IBarometer": ["934475a8-78bf-452f-b017-f0209ce6dab4"],
    "IBarometer2": ["32bcc418-3eeb-4d04-9574-7633a8781f9f"],
    "IBarometer3": ["0e35f0ea-02b5-5a04-b03d-822084863a54"],
    "IBarometerDataThreshold": ["076b952c-cb62-5a90-a0d1-f85e4a936394"],
    "IBarometerReading": ["f5b9d2e6-1df6-4a1a-a7ad-321d4f5db247"],
    "IBarometerReading2": ["85a244eb-90c5-4875-891c-3865b4c357e7"],
    "IBarometerReadingChangedEventArgs": ["3d84945f-037b-404f-9bbb-6232d69543c3"],
    "IBarometerStatics": ["286b270a-02e3-4f86-84fc-fdd892b5940f"],
    "IBarometerStatics2": ["8fc6b1e7-95ff-44ac-878e-d65c8308c34c"],
    "IBasicAudioEffect": ["8c062c53-6bc0-48b8-a99a-4b41550f1359"],
    "IBasicBitmapOps": ["327abdaf-072b-11d3-9d7b-0000f81ef32e"],
    "IBasicConnectedAnimationConfiguration": ["e675f9b5-a4d6-5353-83e6-c89e7cf8d456"],
    "IBasicConnectedAnimationConfigurationFactory": ["95e6844a-4377-503c-bee2-11dfcd5570e6"],
    "IBasicDevice": ["f4f26cbb-7962-48b7-80f7-c3a5d753bcb0"],
    "IBasicPositioner": ["474124e2-17d8-4eaa-b9b7-08baf8878ae7"],
    "IBasicProperties": ["d05d55db-785e-4a66-be02-9beec58aea81"],
    "IBasicVideo2": ["329bb360-f6ea-11d1-9038-00a0c9697298"],
    "IBasicVideoEffect": ["8262c7ef-b360-40be-949b-2ff42ff35693"],
    "IBattery": ["bc894fc6-0072-47c8-8b5d-614aaa7a437e"],
    "IBatteryNotificationManager": ["529e1404-8b51-11e6-ae22-56b6b6499611"],
    "IBatteryReport": ["c9858c3a-4e13-420a-a8d0-24f18f395401"],
    "IBatteryStatics": ["79cd72b6-9e5e-4452-bea6-dfcd541e597f"],
    "IBeginStoryboard": ["64189fcd-49ec-4e52-a6f6-55324c921053"],
    "IBeginStoryboardStatics": ["12cff18c-aa91-4c4a-b82f-df34fc57f94b"],
    "IBezierSegment": ["af4bb9ee-8984-49b7-81df-3f35994b95eb"],
    "IBezierSegmentStatics": ["c0287bac-1410-4530-8452-1c9d0ad1f341"],
    "IBidiAsyncNotifyChannel": ["532818f7-921b-4fb2-bff8-2f4fd52ebebf"],
    "IBidiAsyncNotifyRegistration": ["a8fe383c-c22f-4790-88cd-d9fe0f0addf9"],
    "IBidiRequestContainer": ["d752f6c0-94a8-4275-a77d-8f1d1a1121ae"],
    "IBidiSpl": ["d580dc0e-de39-4649-baa8-bf0b85a03a97"],
    "IBidiSpl2": ["0e8f51b8-8273-4906-8e7b-be453ffd2e2b"],
    "IBinaryConverter": ["728ab302-217d-11da-b2a4-000e7bbb2b09"],
    "IBinaryConverter2": ["8d7928b4-4e17-428d-9a17-728df00d1b2b"],
    "IBindCallbackRedirect": ["11c81bc2-121e-4ed5-b9c4-b430bd54f2c0"],
    "IBindHttpSecurity": ["a9eda967-f50e-4a33-b358-206f6ef3086d"],
    "IBindResource": ["0c733ab1-2a1c-11ce-ade5-00aa0044773d"],
    "IBindStatusCallbackEx": ["aaa74ef9-8ee7-4659-88d9-f8c504da73cc"],
    "IBindStatusCallbackEx2": ["32445657-606b-11e0-9ebd-18a905c16311"],
    "IBindStatusCallbackHolderSink": ["bb81f1d9-5fa7-4941-a57c-1f5c24eff5ad"],
    "IBindableIterable": ["036d2c08-df29-41af-8aa2-d774be62ba6f"],
    "IBindableIterator": ["6a1d6c07-076d-49f2-8314-f52c9c9a8331"],
    "IBindableObservableVector": ["fe1eb536-7e7f-4f90-ac9a-474984aae512"],
    "IBindableVector": ["393de7de-6fd0-4c0d-bb71-47244a113e93"],
    "IBindableVectorChangedEventHandler": ["624cd4e1-d007-43b1-9c03-af4d3e6258c4"],
    "IBindableVectorView": ["346dd6e7-976e-4bc3-815d-ece243bc0f33"],
    "IBinding2": ["34f96fcb-0406-48b3-9e82-f333ec4c6910"],
    "IBindingBase": ["1589a2ab-3d15-49bc-a447-8a5448e58870"],
    "IBindingBaseFactory": ["22dafc3a-7701-4666-a1ba-9859bdcfec34"],
    "IBindingExInternal": ["f3d8f080-a5eb-476f-9d19-a5ef24e5c2e6"],
    "IBindingExpression": ["516a19a5-c2fd-4a9e-9fd3-9aa42f995a3c"],
    "IBindingExpressionBase": ["fded3154-e954-4f67-8fb6-6ed79b3a1cb3"],
    "IBindingExpressionBaseFactory": ["ea7116a7-c2d9-4375-b471-66b9c48c7930"],
    "IBindingExpressionFactory": ["1cb55cd9-db72-40b3-a2b5-24ee6ea5c328"],
    "IBindingFactory": ["ff42bb08-c39e-4f7e-8434-a1569083883c"],
    "IBindingFailedEventArgs": ["32c1d013-4dbd-446d-bbb8-0de35048a449"],
    "IBindingFailedEventHandler": ["136b1782-54ba-420d-a1aa-82828721cde6"],
    "IBindingOperations": ["6fffd738-9839-419c-a17a-4b3604e1524e"],
    "IBindingOperationsStatics": ["e155ef73-95a0-4aab-8c7d-2a47da073c79"],
    "IBitBltVideoDevice": ["2891e8a0-6058-4b93-9923-f7d8d03ea472"],
    "IBitmapBuffer": ["a53e04c4-399c-438c-b28f-a63a6b83d1a1"],
    "IBitmapCache": ["79c2219e-44d2-4610-9735-9bec83809ecf"],
    "IBitmapCodecInformation": ["400caaf2-c4b0-4392-a3b0-6f6f9ba95cb4"],
    "IBitmapData": ["d1a34ef2-cad8-4635-a3d2-fcda8d3f3caf"],
    "IBitmapDecoder": ["acef22ba-1d74-4c91-9dfc-9620745233e6"],
    "IBitmapDecoderStatics": ["438ccb26-bcef-4e95-bad6-23a822e58d01"],
    "IBitmapDecoderStatics2": ["50ba68ea-99a1-40c4-80d9-aef0dafa6c3f"],
    "IBitmapEncoder": ["2bc468e3-e1f8-4b54-95e8-32919551ce62"],
    "IBitmapEncoderStatics": ["a74356a7-a4e4-4eb9-8e40-564de7e1ccb2"],
    "IBitmapEncoderStatics2": ["33cbc259-fe31-41b1-b812-086d21e87e16"],
    "IBitmapEncoderWithSoftwareBitmap": ["686cd241-4330-4c77-ace4-0334968b1768"],
    "IBitmapFrame": ["72a49a1c-8081-438d-91bc-94ecfc8185c6"],
    "IBitmapFrameWithSoftwareBitmap": ["fe287c9a-420c-4963-87ad-691436e08383"],
    "IBitmapIcon": ["e8fe17cb-35f7-40f3-a185-48b397b73e68"],
    "IBitmapIcon2": ["0624a20a-9dd1-4201-bb20-42863da15658"],
    "IBitmapIconFactory": ["46d64b1d-7a49-4f66-9729-2848c788e402"],
    "IBitmapIconSource": ["c8e33dc7-d4ae-4a87-947f-ac4d0bcf5af4"],
    "IBitmapIconSourceFactory": ["6509e5c6-44b6-4cd1-86cd-c3189b12c43c"],
    "IBitmapIconSourceStatics": ["5a105887-e494-4d2b-8528-39472296133f"],
    "IBitmapIconStatics": ["e072d117-e4e7-4e0c-9470-53ff1ce84f67"],
    "IBitmapIconStatics2": ["9745026b-b742-4a89-a5d7-a0e5fb809af1"],
    "IBitmapImage": ["31af3271-e3b4-442d-a341-4c0226b2725b", "327abdaa-072b-11d3-9d7b-0000f81ef32e"],
    "IBitmapImage2": ["1069c1b6-8c9b-4762-be3d-759f5698f2b3"],
    "IBitmapImage3": ["f1de6f26-3c73-453f-a7ba-9b85c18b3733"],
    "IBitmapImageFactory": ["c9132978-4810-4e5e-8087-03671ee60d85"],
    "IBitmapImageStatics": ["9e282143-70e8-437c-9fa4-2cbf295cff84"],
    "IBitmapImageStatics2": ["c5f5576a-75af-41a4-b893-8fe91fee2882"],
    "IBitmapImageStatics3": ["2b44e30d-f6d5-4411-a8cd-bf7603c4faa0"],
    "IBitmapProperties": ["ea9f4f1b-b505-4450-a4d1-e8ca94529d8d"],
    "IBitmapPropertiesView": ["7e0fe87a-3a70-48f8-9c55-196cf5a545f5"],
    "IBitmapSource": ["23d86411-202f-41b2-8c5b-a8a3b333800b"],
    "IBitmapSourceFactory": ["e240420e-d4a7-49a4-a0b4-a59fdd77e508"],
    "IBitmapSourceStatics": ["9a9c9981-827b-4e51-891b-8a15b511842d"],
    "IBitmapTransform": ["ae755344-e268-4d35-adcf-e995d31a8d34"],
    "IBitmapTypedValue": ["cd8044a9-2443-4000-b0cd-79316c56f589"],
    "IBitmapTypedValueFactory": ["92dbb599-ce13-46bb-9545-cb3a3f63eb8b"],
    "IBitsPeer": ["659cdea2-489e-11d9-a9cd-000d56965251"],
    "IBitsPeerCacheAdministration": ["659cdead-489e-11d9-a9cd-000d56965251"],
    "IBitsPeerCacheRecord": ["659cdeaf-489e-11d9-a9cd-000d56965251"],
    "IBitsTokenOptions": ["9a2584c3-f7d2-457a-9a5e-22b67bffc7d2"],
    "IBln": ["e0b1c713-e991-11d0-9ea7-00c04fd7081f"],
    "IBlock2": ["5ec7bdf3-1333-4a92-8318-6caedc12ef89"],
    "IBlockFactory": ["07110532-4f59-4f3b-9ce5-25784c430507"],
    "IBlockNotificationChannelsCallback": ["aae55411-1b10-4d55-a5dc-88f6d03a72f8"],
    "IBlockRange": ["b507ca25-2204-11dd-966a-001aa01bbc58"],
    "IBlockRangeList": ["b507ca26-2204-11dd-966a-001aa01bbc58"],
    "IBlockStatics": ["f86a8c34-8d18-4c53-aebd-91e610a5e010"],
    "IBlockStatics2": ["af01a4d6-03e3-4cee-9b02-2bfc308b27a9"],
    "IBluetoothAdapter": ["7974f04c-5f7a-4a34-9225-a855f84b1a8b"],
    "IBluetoothAdapter2": ["ac94cecc-24d5-41b3-916d-1097c50b102b"],
    "IBluetoothAdapter3": ["8f8624e0-cba9-5211-9f89-3aac62b4c6b8"],
    "IBluetoothAdapterStatics": ["8b02fb6a-ac4c-4741-8661-8eab7d17ea9f"],
    "IBluetoothClassOfDevice": ["d640227e-d7d7-4661-9454-65039ca17a2b"],
    "IBluetoothClassOfDeviceStatics": ["e46135bd-0fa2-416c-91b4-c1e48ca061c1"],
    "IBluetoothDevice": ["2335b156-90d2-4a04-aef5-0e20b9e6b707"],
    "IBluetoothDevice2": ["0133f954-b156-4dd0-b1f5-c11bc31a5163"],
    "IBluetoothDevice3": ["57fff78b-651a-4454-b90f-eb21ef0b0d71"],
    "IBluetoothDevice4": ["817c34ad-0e9c-42b2-a8dc-3e8094940d12"],
    "IBluetoothDevice5": ["b5e0b385-5e85-4559-a10d-1c7281379f96"],
    "IBluetoothDeviceId": ["c17949af-57c1-4642-bcce-e6c06b20ae76"],
    "IBluetoothDeviceIdStatics": ["a7884e67-3efb-4f31-bbc2-810e09977404"],
    "IBluetoothDeviceStatics": ["0991df51-57db-4725-bbd7-84f64327ec2c"],
    "IBluetoothDeviceStatics2": ["c29e8e2f-4e14-4477-aa1b-b8b47e5b7ece"],
    "IBluetoothLEAdvertisement": ["066fb2b7-33d1-4e7d-8367-cf81d0f79653"],
    "IBluetoothLEAdvertisementBytePattern": ["fbfad7f2-b9c5-4a08-bc51-502f8ef68a79"],
    "IBluetoothLEAdvertisementBytePatternFactory": ["c2e24d73-fd5c-4ec3-be2a-9ca6fa11b7bd"],
    "IBluetoothLEAdvertisementDataSection": ["d7213314-3a43-40f9-b6f0-92bfefc34ae3"],
    "IBluetoothLEAdvertisementDataSectionFactory": ["e7a40942-a845-4045-bf7e-3e9971db8a6b"],
    "IBluetoothLEAdvertisementDataTypesStatics": ["3bb6472f-0606-434b-a76e-74159f0684d3"],
    "IBluetoothLEAdvertisementFilter": ["131eb0d3-d04e-47b1-837e-49405bf6f80f"],
    "IBluetoothLEAdvertisementPublisher": ["cde820f9-d9fa-43d6-a264-ddd8b7da8b78"],
    "IBluetoothLEAdvertisementPublisher2": ["fbdb545e-56f1-510f-a434-217fbd9e7bd2"],
    "IBluetoothLEAdvertisementPublisherFactory": ["5c5f065e-b863-4981-a1af-1c544d8b0c0d"],
    "IBluetoothLEAdvertisementPublisherStatusChangedEventArgs": ["09c2bd9f-2dff-4b23-86ee-0d14fb94aeae"],
    "IBluetoothLEAdvertisementPublisherStatusChangedEventArgs2": ["8f62790e-dc88-5c8b-b34e-10b321850f88"],
    "IBluetoothLEAdvertisementPublisherTrigger": ["ab3e2612-25d3-48ae-8724-d81877ae6129"],
    "IBluetoothLEAdvertisementPublisherTrigger2": ["aa28d064-38f4-597d-b597-4e55588c6503"],
    "IBluetoothLEAdvertisementPublisherTriggerDetails": ["610eca86-3480-41c9-a918-7ddadf207e00"],
    "IBluetoothLEAdvertisementPublisherTriggerDetails2": ["d4a3d025-c601-42d6-9829-4ccb3f5cd77f"],
    "IBluetoothLEAdvertisementReceivedEventArgs": ["27987ddf-e596-41be-8d43-9e6731d4a913"],
    "IBluetoothLEAdvertisementReceivedEventArgs2": ["12d9c87b-0399-5f0e-a348-53b02b6b162e"],
    "IBluetoothLEAdvertisementWatcher": ["a6ac336f-f3d3-4297-8d6c-c81ea6623f40"],
    "IBluetoothLEAdvertisementWatcher2": ["01bf26bc-b164-5805-90a3-e8a7997ff225"],
    "IBluetoothLEAdvertisementWatcherFactory": ["9aaf2d56-39ac-453e-b32a-85c657e017f1"],
    "IBluetoothLEAdvertisementWatcherStoppedEventArgs": ["dd40f84d-e7b9-43e3-9c04-0685d085fd8c"],
    "IBluetoothLEAdvertisementWatcherTrigger": ["1aab1819-bce1-48eb-a827-59fb7cee52a6"],
    "IBluetoothLEAdvertisementWatcherTrigger2": ["39b56799-eb39-5ab6-9932-aa9e4549604d"],
    "IBluetoothLEAdvertisementWatcherTriggerDetails": ["a7db5ad7-2257-4e69-9784-fee645c1dce0"],
    "IBluetoothLEAppearance": ["5d2079f2-66a8-4258-985e-02b4d9509f18"],
    "IBluetoothLEAppearanceCategoriesStatics": ["6d4d54fe-046a-4185-aab6-824cf0610861"],
    "IBluetoothLEAppearanceStatics": ["a193c0c7-4504-4f4a-9ba5-cd1054e5e065"],
    "IBluetoothLEAppearanceSubcategoriesStatics": ["e57ba606-2144-415a-8312-71ccf291f8d1"],
    "IBluetoothLEDevice": ["b5ee2f7b-4ad8-4642-ac48-80a0b500e887"],
    "IBluetoothLEDevice2": ["26f062b3-7aee-4d31-baba-b1b9775f5916"],
    "IBluetoothLEDevice3": ["aee9e493-44ac-40dc-af33-b2c13c01ca46"],
    "IBluetoothLEDevice4": ["2b605031-2248-4b2f-acf0-7cee36fc5870"],
    "IBluetoothLEDevice5": ["9d6a1260-5287-458e-95ba-17c8b7bb326e"],
    "IBluetoothLEDeviceStatics": ["c8cf1a19-f0b6-4bf0-8689-41303de2d9f4"],
    "IBluetoothLEDeviceStatics2": ["5f12c06b-3bac-43e8-ad16-563271bd41c2"],
    "IBluetoothLEManufacturerData": ["912dba18-6963-4533-b061-4694dafb34e5"],
    "IBluetoothLEManufacturerDataFactory": ["c09b39f8-319a-441e-8de5-66a81e877a6c"],
    "IBluetoothSignalStrengthFilter": ["df7b7391-6bb5-4cfe-90b1-5d7324edcf7f"],
    "IBluetoothUuidHelperStatics": ["17df0cd8-cf74-4b21-afe6-f57a11bcdea0"],
    "IBodyPart": ["cd000021-8b95-11d1-82db-00c04fb1625d"],
    "IBodyParts": ["cd000023-8b95-11d1-82db-00c04fb1625d"],
    "IBold": ["ade73784-1b59-4da4-bb23-0f20e885b4bf"],
    "IBooleanExpression": ["0519dace-f446-4ecb-bc0c-bbcdff6bb952"],
    "IBooleanKeyFrameAnimation": ["95e23a08-d1f4-4972-9770-3efe68d82e14"],
    "IBooleanSetting": ["18d72473-cd4a-411d-a73e-6b212cec6ca8"],
    "IBootOptions": ["2c941fd4-975b-59be-a960-9a2a262853a5"],
    "IBootTrigger": ["2a9c35da-d357-41f4-bbc1-207ac1b1f3cb"],
    "IBorder": ["797c4539-45bd-4633-a044-bfb02ef5170f"],
    "IBorder2": ["a1efbd9d-cb8b-56b5-878d-3a7f43bc9730"],
    "IBorderStatics": ["b81d1639-e911-4fd7-a4c4-b9c7f008b7fc"],
    "IBorderStatics2": ["a26d4476-803f-5040-a0f3-e66db3733166"],
    "IBounceEase": ["2bf1464e-fc71-47ed-85a1-3ba9577718b4"],
    "IBounceEaseStatics": ["c0701da2-4f73-41c9-b2cb-2ea3105107ff"],
    "IBounceScalarNaturalMotionAnimation": ["baa30dcc-a633-4618-9b06-7f7c72c87cff"],
    "IBounceVector2NaturalMotionAnimation": ["da344196-2154-4b3c-88aa-47361204eccd"],
    "IBounceVector3NaturalMotionAnimation": ["47dabc31-10d3-4518-86f1-09caf742d113"],
    "IBreadcrumbBar": ["02305531-f76f-4a4d-a760-b1192e72c6d5"],
    "IBrightnessOverride": ["96c9621a-c143-4392-bedd-4a7e9574c8fd"],
    "IBrightnessOverrideSettings": ["d112ab2a-7604-4dba-bcf8-4b6f49502cb0"],
    "IBrightnessOverrideSettingsStatics": ["d487dc90-6f74-440b-b383-5fe96cf00b0f"],
    "IBrightnessOverrideStatics": ["03a7b9ed-e1f1-4a68-a11f-946ad8ce5393"],
    "IBringIntoViewOptions": ["19bdd1b5-c7cb-46d9-a4dd-a1bbe83ef2fb"],
    "IBringIntoViewOptions2": ["e855e08e-64b6-1211-bddb-1fddbb6e8231"],
    "IBringIntoViewRequestedEventArgs": ["0e629ec4-2206-4c8b-94ae-bdb66a4ebfd1"],
    "IBroadcastDVRCommand": ["5a4c52f1-92a1-4f7d-9010-60dc2a06d6af"],
    "IBroadcastDVRComponent": ["82467e7f-e743-4e2f-bf0b-20adcadf3217"],
    "IBroadcastEvent": ["3b21263f-26e8-489d-aac4-924f7efd9511"],
    "IBroadcastEventEx": ["3d9e3887-1929-423f-8021-43682de95448"],
    "IBrokeredTask": ["3a22e38b-9e68-4cdf-ade9-a25bc040c520"],
    "IBrokeredTaskNotify": ["56cfe922-3560-40a7-a40c-d6d40f1f1b34"],
    "IBrowserActivationEvent": ["7bc9fc77-d85a-4220-b7dd-7b22cf22d0ed"],
    "IBrowserApplicationState": ["e66a412d-14b3-425c-82ac-5b7716cca5a7"],
    "IBrowserBandProxy": ["cbd8776e-43df-43b1-b533-948983fd037b"],
    "IBrowserBrokerFactory": ["7179e7f6-4fe0-48b3-8b6a-bb413bf6ea0d"],
    "IBrowserConnectionPointCB": ["c14c0111-c86c-4b2f-af17-5a62731dd48e"],
    "IBrowserEmulationControl": ["254e52a5-428f-4170-bf66-8b9d42536f20"],
    "IBrowserEvents": ["33614250-dfea-46cc-8347-9a655bcf1a08"],
    "IBrowserExtension": ["32bb8320-b41b-11cf-a6bb-0080c7b2d682"],
    "IBrowserFrameHostServices": ["75f5a2c0-b905-4f5e-aa34-b68b335c5e09"],
    "IBrowserFrameTestHelper": ["cb8e9baf-8f6a-4931-85c0-bb6db9b9c4d1"],
    "IBrowserHTMLWindowSupport": ["6379d68c-df01-4b71-9f38-effb828557fc"],
    "IBrowserHost": ["b965e203-2a6a-4e2e-a15d-cecd736f12b2"],
    "IBrowserHostEvents": ["7d722cee-1797-44e0-a992-1a3c7fd9ddd1"],
    "IBrowserImageStore": ["e62a8160-909d-49fd-b771-2766c574af93"],
    "IBrowserImageStoreEvents": ["615e31b1-2b6e-4222-aa41-170150c516ec"],
    "IBrowserProgressAggregator": ["5ea8eec4-c34b-4de0-9b56-0e15fd8c8f80"],
    "IBrowserProgressConnection": ["20174539-b2c7-4ec7-970b-04201f9cdbad"],
    "IBrowserProgressSessionProvider": ["18140cbd-aa23-4384-a38d-6a8d3e2be505"],
    "IBrowserService": ["02ba3b52-0547-11d1-b833-00c04fc9b31f"],
    "IBrowserService2": ["68bd21cc-438b-11d2-a560-00a0c92dbfe8"],
    "IBrowserService3": ["27d7ce21-762d-48f3-86f3-40e2fd3749c4"],
    "IBrowserService4": ["639f1bff-e135-4096-abd8-e0f504d649a4"],
    "IBrowserSettings": ["dd1e21cc-e2c7-402c-bf05-10328d3f6bad"],
    "IBrowserStreamImageStore": ["e97b1e92-e9fd-419d-b08f-c64466a0784c"],
    "IBrowserTabComponentRemotable": ["ebfc36ec-6683-460c-81f6-0384894a32ed"],
    "IBrowserThreadState": ["ccd6f2eb-d12a-40c7-8683-509f1c818eae"],
    "IBrowserTrackEventsCallback": ["3934e4c2-8143-4e4c-a1dc-718f8563f337"],
    "IBrowserWindows": ["6312f983-7c1b-4080-98b1-98e463b5ec74"],
    "IBrowserWithActivationNotification": ["05a89298-6246-4c63-bb0d-9bdaf140bf3b"],
    "IBrowsingContextCOMReceptor": ["561ae8b0-f775-497b-b441-100120851784"],
    "IBrush": ["8806a321-1e06-422c-a1cc-01696559e021"],
    "IBrushFactory": ["399658a2-14fb-4b8f-83e6-6e3dab12069b"],
    "IBrushOverrides2": ["d092b151-d83b-5a81-a71e-a1c7f8ad6963"],
    "IBrushStatics": ["e70c3102-0225-47f5-b22e-0467619f6a22"],
    "IBrushTransition": ["1116972c-9dad-5429-a7dd-b2b7d061ab8e"],
    "IBrushTransitionFactory": ["3dbe7368-13d4-510c-a215-7539f4787b52"],
    "IBuffer": ["000001b4-0000-0000-c000-000000000046", "905a0fe0-bc53-11df-8c49-001e4fc686da"],
    "IBufferFactory": ["71af914d-c10f-484b-bc50-14bc623b3a27"],
    "IBufferMediaFrame": ["b5b153c7-9b84-4062-b79c-a365b2596854"],
    "IBufferProtectUnprotectResult": ["47995edc-6cec-4e3a-b251-9e7485d79e7a"],
    "IBufferStatics": ["e901e65b-d716-475a-a90a-af7229b1e741"],
    "IBufferedTimedTextDataSourceFactory": ["0bd09785-1035-426b-b34d-3111ee270f7c"],
    "IBufferingTime": ["1e00486a-78dd-11d2-8dd3-006097c9a2b2"],
    "IBuilderWizardManager": ["95fc88c3-9fcb-11cf-a405-00aa00c00940"],
    "IBuiltMenu": ["3a57684a-3480-4d0b-920a-c21912455d94"],
    "IBulkParser": ["193215bf-3815-441a-98bc-589db62452a6"],
    "IBurnVerification": ["d2ffd834-958b-426d-8470-2a13879c6a91"],
    "IButton": ["280335ae-5570-46c7-8e0b-602be71229a2", "66833fe9-8583-11d1-b16a-00c0f0283628"],
    "IButtonAutomationPeer": ["fb77efbe-39ec-4508-8ac3-51a1424027d7"],
    "IButtonAutomationPeerFactory": ["3fdb9f49-f4ab-4780-8644-03376299a175"],
    "IButtonBase": ["fa002c1a-494e-46cf-91d4-e14a8d798674"],
    "IButtonBaseAutomationPeer": ["a4f3b5b6-7585-4e0b-96d2-08cf6f28befa"],
    "IButtonBaseAutomationPeerFactory": ["8a04091e-e6b2-4c60-a759-c13ca45165ed"],
    "IButtonBaseFactory": ["389b7c71-5220-42b2-9992-2690c1a6702f"],
    "IButtonBaseStatics": ["67ef17e1-fe37-474f-9e97-3b5e0b30f2df"],
    "IButtonFactory": ["80a13c19-843a-451c-8cf5-44c701b0e216"],
    "IButtonMenu": ["66833fed-8583-11d1-b16a-00c0f0283628"],
    "IButtonMenus": ["66833feb-8583-11d1-b16a-00c0f0283628"],
    "IButtonStaticsWithFlyout": ["90143898-a16c-4759-b2f0-a5f7e625169e"],
    "IButtonWithFlyout": ["09108f87-df6c-4180-9b3a-e60845825811"],
    "IButtons": ["66833fe7-8583-11d1-b16a-00c0f0283628"],
    "ICAT": ["7c6995fb-2a31-4bd7-953e-b1ad7fb7d31c"],
    "ICCSubStreamFiltering": ["4b2bd7ea-8347-467b-8dbf-62f784929cc3"],
    "ICDBurnGlobalSettingsDialog": ["1deecab6-1cff-4923-9a53-bc2c5d199544"],
    "ICDBurnPriv": ["9cfd6c07-1992-47bd-9b83-830b358b2df4"],
    "ICDPAFSUserSettings": ["df33603d-5e58-4a7e-986a-cd6ea2125a7c"],
    "ICDPAccount": ["290ee677-8899-4721-add0-56df4fee0bdd"],
    "ICDPAccountProvider": ["4b22fba5-d1ea-4e3c-86ff-df3ed0e81d90"],
    "ICDPAccountProviderCallback": ["0e9c4de9-954d-4444-8521-508484e0c649"],
    "ICDPActivity": ["a6437fc1-d521-4b4c-b986-add26ee93986"],
    "ICDPActivityAsset": ["147cbf37-7b07-4981-87ca-fcc4b45ca8eb"],
    "ICDPActivityStore": ["c96b69cd-c73b-4ce4-a85b-26defafc1916"],
    "ICDPActivityStoreManagement": ["9f0c9868-f343-4b67-b5b0-d59464ff3abc"],
    "ICDPAppControlClient": ["7427f25f-dd26-474d-b5f2-9372a028da32"],
    "ICDPAppId": ["7eb7f6de-2c88-4249-93c7-e9d31f4dc273"],
    "ICDPAuthInfo": ["e071e9a9-5a5e-4753-9995-37f362e398a0"],
    "ICDPAuxiliaryStreamClient": ["b80758b4-e519-4920-b2a6-067cd7654ffd"],
    "ICDPAuxiliaryStreamHost": ["41ad4428-d8e3-4ab0-b880-06b0c421fcc8"],
    "ICDPBinaryClient": ["dc1cf076-da95-472e-81a2-ef55fc2865e5"],
    "ICDPBinaryHost": ["834497dc-f3ca-4f30-a30e-e91bd7f515ad"],
    "ICDPCallbackNotifier": ["75bc530f-ff1e-45d5-9482-a2b907ff3b51"],
    "ICDPClientAuthorizationProvider": ["4d578e0a-ae33-403f-bd68-97a4b2eaf886"],
    "ICDPClientAuthorizationProviderCallback": ["f0e42f8a-6b3a-447e-b358-f861b5260dfd"],
    "ICDPComAFSUserSettings": ["683d7fc9-8697-4309-994e-e8a2c5628884"],
    "ICDPComAccountProvider": ["ed642470-bbf6-4d03-ad85-5dddb2889113"],
    "ICDPComAccountProviderCallback": ["b6fa2e6a-4552-43a6-9569-1d7b83406c06"],
    "ICDPComActivityStore": ["611b5064-4ea8-4edf-8734-64da92fc8e44"],
    "ICDPComActivityStoreManagementControl": ["8dd85454-2ca5-4099-9412-f471edac4253"],
    "ICDPComAppControlClient": ["8b2e9458-f2b6-4c79-bfd3-4ec9434d8b02"],
    "ICDPComAppControlSystemHandler": ["e40333dd-4915-43ad-b02c-5a0a9dbf9b14"],
    "ICDPComAppControlSystemHandlerCallback": ["952c7c44-3704-48a5-952d-fd3cdb111811"],
    "ICDPComAuthenticationHandler": ["427ee032-ef0b-4fc5-a247-52a625121243"],
    "ICDPComAuthenticationHandlerCallback": ["31eb73d2-3bc4-435d-b733-b30bdf09dee9"],
    "ICDPComAuxiliaryStreamClient": ["6d51013b-d4ec-4f37-a339-f71656e0b43e"],
    "ICDPComAuxiliaryStreamClientHandler": ["debf86c3-e72b-463e-af42-1921156482eb"],
    "ICDPComAuxiliaryStreamHost": ["373eb506-7ff2-4322-a6cd-5248189b85f4"],
    "ICDPComAuxiliaryStreamHostHandler": ["6cf26be1-51c8-41e3-aba6-22b7a479ca69"],
    "ICDPComBinaryClient": ["3ee35a36-2887-474e-9b0e-d615dacf2d1b"],
    "ICDPComBinaryHost": ["0dbd6b2a-fefc-4554-ac3e-9930474f7c6f"],
    "ICDPComClientAuthorizationProviderCallback": ["e9a8e362-9e3d-4278-858f-695972deba49"],
    "ICDPComDevice": ["cab19a95-482b-4720-99a5-a9232995b595"],
    "ICDPComDeviceCache": ["343b9da0-7a25-4bf2-9542-1178bff18518"],
    "ICDPComDeviceQuery": ["f6dead79-25e8-43ea-8016-04929d87602d"],
    "ICDPComDirectNotificationHost": ["75165041-c9ce-4302-a9b2-873dded43b7f"],
    "ICDPComEnumDevice": ["1ca240ac-72a6-470d-8b1a-1d97087d0f05"],
    "ICDPComGameDvrSystemHandler": ["c7f208a4-c8cd-4689-983b-a2babae6a460"],
    "ICDPComGamepadSystemHandler": ["e95754ca-b1d4-4a0b-afe2-0c051752d9fb"],
    "ICDPComHostAuthorizationProviderCallback": ["05f48c01-49d5-4ead-9248-04553bcbdda8"],
    "ICDPComLegacyHost": ["014e0fcf-0f61-4507-b3c0-8a9834be5fee"],
    "ICDPComLegacyHostHandler": ["70ca8280-3125-47c5-9480-c8cc17559e7e"],
    "ICDPComMediaClient": ["d11e298a-2917-4d15-95fd-daf81c3311ac"],
    "ICDPComMediaClientHandler": ["424c73cb-0665-4a1a-b92a-c186fa8e45ff"],
    "ICDPComMediaHost": ["39c3c91e-bb09-4cd6-8e5f-60bae8a1df2a"],
    "ICDPComMediaHostHandler": ["5fee7e2b-f82e-4f2d-bd08-e9bebc5de158"],
    "ICDPComMediaSystemHandler": ["e51a7c0a-3ef2-4f08-a23a-621ccb11aa28"],
    "ICDPComMediaSystemHandlerCallback": ["4ca8a94f-6526-4b64-923e-89244ad356ba"],
    "ICDPComMessagingClient": ["7a8ac8c3-adb0-4612-b94b-923e8714b2fc"],
    "ICDPComMessagingClientHandler": ["3f21a112-53f6-437e-ba5b-2ff3e1e02887"],
    "ICDPComMessagingHost": ["e2f79687-9075-4b3b-b6c1-7234a4079e35"],
    "ICDPComMessagingHostHandler": ["070996bf-13e3-4008-86a9-dfa7af5d5a27"],
    "ICDPComMessagingSystemHandler": ["a24213ae-acf9-4c9d-8156-c4777ddaf7b1"],
    "ICDPComMessagingSystemHandlerCallback": ["e4466e0f-c942-4c9c-98ef-b31a17aeaf1e"],
    "ICDPComNearShareBroker": ["6b8007ae-4dd7-46f3-9bec-06f777d78864"],
    "ICDPComNearShareHandler": ["a7224b82-30f6-497a-be79-58e991488b67"],
    "ICDPComParticipantHandler": ["db94c387-16e8-43dd-a3e3-e4af33b14d3c"],
    "ICDPComRemoteTextSystemHandler": ["0324a68b-60f3-4f90-a69d-d21936cc8234"],
    "ICDPComRemoteTextSystemHandlerCallback": ["942e69c7-b708-4388-8343-240ef11ca4ea"],
    "ICDPComResourceHandler": ["50d91478-da2d-496b-be08-6447349f1fb4"],
    "ICDPComResourceHandlerCallback": ["43e8615a-47ef-49db-a79f-d7cd208b3039"],
    "ICDPComResourceManager": ["0de562ea-dd2c-4786-b32e-2600d09399e5"],
    "ICDPComResourcePolicyBroker": ["aa5555f2-8825-4d5d-a35e-df73844c0806"],
    "ICDPComResourcePolicyCallback": ["b2b38398-bc32-437b-81c3-a2f6d8697568"],
    "ICDPComResourcePolicyHandler": ["5a2703ae-70a3-4757-a2ae-d141f9248a3d"],
    "ICDPComSensorClient": ["ea0fcfe7-f386-4ba5-83df-8e8747948398"],
    "ICDPComSensorHost": ["bdb44ba0-22e1-4822-9944-a0e81de3d1a0"],
    "ICDPComSensorHostHandler": ["ba9f4490-70a6-4655-b3e0-742a5af33e44"],
    "ICDPComSensorSystemHandler": ["0eb5a8ad-7da9-4830-bcdb-21eadfc638fa"],
    "ICDPComTouchClient": ["bf7c0b76-dae0-4637-a5c2-c218033983e6"],
    "ICDPComTouchHost": ["728ae251-e94f-4306-a7bb-e9b3287efbcd"],
    "ICDPComTouchHostHandler": ["5f502cc5-e475-46dc-a455-a84278f4c577"],
    "ICDPComTouchSystemHandler": ["f73605e1-e491-4012-90be-f8aaf1a8d179"],
    "ICDPComUserActivitySettings": ["7f66e6eb-4f9d-4780-adb0-2dcdf798415a"],
    "ICDPComUserServiceNotificationHost": ["50c3f242-5793-4bf5-bb83-e662f04b9e63"],
    "ICDPComUserSettingsProvider": ["8cb134c6-72c3-4c94-859f-c1f2d40ddd13"],
    "ICDPComWebAccountProviderCallback": ["e43e21e4-34c1-4769-9ce8-93aebb6da4f9"],
    "ICDPCrossPlatformAppId": ["bbee2a22-80df-4fe0-a652-e3e2329aeb91"],
    "ICDPCrossPlatformAppIdEnumerator": ["8eb672e9-6d0f-44c0-87ca-e00ff32acb3b"],
    "ICDPDevice": ["77064fe7-6a61-42da-beb5-e2ad8ddb609b"],
    "ICDPDeviceCache": ["4d4636f1-62f8-4bda-95ea-a4ef18278c8a"],
    "ICDPDeviceInfo": ["b61b414b-0342-4770-b528-fb317e440f4d"],
    "ICDPDeviceQuery": ["b18f823d-c907-4211-9068-62d284d0afd8"],
    "ICDPDirectNotificationHost": ["3d0ed931-c089-4a3b-802b-0861cad8099f"],
    "ICDPEndpoint": ["a2114e07-d8d3-4b28-8fb5-68467f02b005"],
    "ICDPEndpointAccount": ["8a5d3949-11e9-42e3-9ed9-e54a086a632b"],
    "ICDPEnumDevice": ["f9a6294f-7353-4416-bf9d-82dfbaedba48"],
    "ICDPHost": ["033feb2f-5f4a-4152-a0af-00d5ad2a7649"],
    "ICDPHostAuthorizationProvider": ["c22976d1-7d42-4d70-b97a-625cd5d52589"],
    "ICDPHostAuthorizationProviderCallback": ["9af0344f-71c8-4be3-84d7-febdc4b9e2af"],
    "ICDPLegacyHost": ["27ae0d19-90e2-466e-a4bc-956647b512ef"],
    "ICDPLogger": ["fddcc7fb-0be6-4927-9c29-a878b8b28309"],
    "ICDPMediaClient": ["cb7dfb0b-985f-4963-b1c0-42ba417b746e"],
    "ICDPMediaHost": ["3bf1eb2f-d95d-4075-a6a1-3739160e9349"],
    "ICDPMessagingClient": ["2b68b9d5-ca21-44aa-8b94-b58253a6ee04"],
    "ICDPMessagingHost": ["b39f7bb0-9984-4012-8511-b2f0a8d80e24"],
    "ICDPParticipant": ["75543a6b-8bde-43e6-88b1-dcbb09c2d54d"],
    "ICDPParticipantDeviceInfo": ["88a8e526-0c23-401a-9cfe-9e92e21ac218"],
    "ICDPParticipantHandler": ["c8bb91c8-7571-473b-a2b2-22d5819cd0c2"],
    "ICDPResourceHandler": ["b972db8e-ca3d-4e6e-aa00-2cd72f9b10ed"],
    "ICDPResourceManager": ["bb74860e-7746-436f-889e-5e8186af346c"],
    "ICDPResourcePolicyHandler": ["9764b4ed-9b49-4a68-9ab0-3862d3f7c22b"],
    "ICDPSensorClient": ["f84714eb-f838-49d6-b7a9-dbaf3c63264a"],
    "ICDPSensorHost": ["5f606a0f-863c-4c35-b822-28b3e2fc7237"],
    "ICDPTask": ["14258db5-14cc-48f8-8641-15e951b3a60f"],
    "ICDPTouchClient": ["452f8c7a-077f-4b43-9b80-e6144fa7b89c"],
    "ICDPTouchHost": ["3a20c162-2f00-4795-b672-8b8e85513fc6"],
    "ICDPUserActivitySettings": ["a53bd71d-a5d9-4d71-b4dc-49be8bcb1a52"],
    "ICDPUserNotificationClient": ["92f1c068-4b1d-4c95-b302-2c29f10bba16"],
    "ICDPUserServiceNotificationClient": ["3d4fe8cf-04b4-422a-8345-1d611dbfc82f"],
    "ICDPWebAccountProviderCallback": ["c1cf6049-f869-4bc0-8ac9-2c9fdee17023"],
    "ICLAPI_CLIENT": ["08fd99d1-cfb6-11cf-bc03-00aa006111e0"],
    "ICLRAppDomainResourceMonitor": ["c62de18c-2e23-4aea-8423-b40c1fc59eae"],
    "ICLRAssemblyIdentityManager": ["15f0a9da-3ff6-4393-9da9-fdfd284e6972"],
    "ICLRAssemblyReferenceList": ["1b2c9750-2e66-4bda-8b44-0a642c5cd733"],
    "ICLRControl": ["9065597e-d1a1-4fb2-b6ba-7e1fce230f61"],
    "ICLRDataEnumMemoryRegions": ["471c35b4-7c2f-4ef0-a945-00f8c38056f1"],
    "ICLRDataEnumMemoryRegionsCallback": ["bcdd6908-ba2d-4ec5-96cf-df4d5cdcb4a4"],
    "ICLRDataEnumMemoryRegionsCallback2": ["3721a26f-8b91-4d98-a388-db17b356fadb"],
    "ICLRDataTarget": ["3e11ccee-d08b-43e5-af01-32717a64da03"],
    "ICLRDataTarget2": ["6d05fae3-189c-4630-a6dc-1c251e1c01ab"],
    "ICLRDataTarget3": ["a5664f95-0af4-4a1b-960e-2f3346b4214c"],
    "ICLRDebugManager": ["00dcaec6-2ac0-43a9-acf9-1e36c139b10d"],
    "ICLRDebugging": ["d28f3c5a-9634-4206-a509-477552eefb10"],
    "ICLRDebuggingLibraryProvider": ["3151c08d-4d09-4f9b-8838-2880bf18fe51"],
    "ICLRDomainManager": ["270d00a2-8e15-4d0b-adeb-37bc3e47df77"],
    "ICLRErrorReportingManager": ["980d2f1a-bf79-4c08-812a-bb9778928f78"],
    "ICLRGCManager": ["54d9007e-a8e2-4885-b7bf-f998deee4f2a"],
    "ICLRGCManager2": ["0603b793-a97a-4712-9cb4-0cd1c74c0f7c"],
    "ICLRHostBindingPolicyManager": ["4b3545e7-1856-48c9-a8ba-24b21a753c09"],
    "ICLRHostProtectionManager": ["89f25f5c-ceef-43e1-9cfa-a68ce863aaac"],
    "ICLRIoCompletionManager": ["2d74ce86-b8d6-4c84-b3a7-9768933b3c12"],
    "ICLRMemoryNotificationCallback": ["47eb8e57-0846-4546-af76-6f42fcfc2649"],
    "ICLRMetaHost": ["d332db9e-b9b3-4125-8207-a14884f53216"],
    "ICLRMetaHostPolicy": ["e2190695-77b2-492e-8e14-c4b3a7fdd593"],
    "ICLRMetadataLocator": ["aa8fa804-bc05-4642-b2c5-c353ed22fc63"],
    "ICLROnEventManager": ["1d0e0132-e64f-493d-9260-025c0e32c175"],
    "ICLRPolicyManager": ["7d290010-d781-45da-a6f8-aa5d711a730e"],
    "ICLRProbingAssemblyEnum": ["d0c5fb1f-416b-4f97-81f4-7ac7dc24dd5d"],
    "ICLRProfiling": ["b349abe3-b56f-4689-bfcd-76bf39d888ea"],
    "ICLRReferenceAssemblyEnum": ["d509cb5d-cf32-4876-ae61-67770cf91973"],
    "ICLRRuntimeHost": ["90f1a06c-7712-4762-86b5-7a5eba6bdb02"],
    "ICLRRuntimeInfo": ["bd39d1d2-ba2f-486a-89b0-b4b0cb466891"],
    "ICLRStrongName": ["9fd93ccf-3280-4391-b3a9-96e1cde77c8d"],
    "ICLRStrongName2": ["c22ed5c5-4b59-4975-90eb-85ea55c0069b"],
    "ICLRStrongName3": ["22c7089b-bbd3-414a-b698-210f263f1fed"],
    "ICLRSyncManager": ["55ff199d-ad21-48f9-a16c-f24ebbb8727d"],
    "ICLRTask": ["28e66a4a-9906-4225-b231-9187c3eb8611"],
    "ICLRTask2": ["28e66a4a-9906-4225-b231-9187c3eb8612"],
    "ICLRTaskManager": ["4862efbe-3ae5-44f8-8feb-346190ee8a34"],
    "ICLRValidator": ["63df8730-dc81-4062-84a2-1ff943f59fdd"],
    "ICache": ["06faeb05-191c-11d3-9573-00c04fa31a86"],
    "ICacheContext": ["3004ead6-8fe4-44b1-a732-af9b71c97938"],
    "ICacheManager": ["9b9027a3-4350-484e-b96e-ed4e5a5c9069"],
    "ICacheMode": ["98dc8b11-c6f9-4dab-b838-5fd5ec8c7350"],
    "ICacheModeFactory": ["eb1f8c5b-0abb-4e70-b8a8-620d0d953ab2"],
    "ICacheObjectCleanup": ["c96a8701-dee2-4682-bda3-e36f6540ab05"],
    "ICacheProperty": ["57eb5a03-0dc8-4959-87d5-83826cdfb724"],
    "ICacheRefresh": ["000002ff-0000-0000-c000-000000000046"],
    "ICacheableObject": ["771e5917-5788-4a36-a276-b0ddbf8e4abf"],
    "ICachedFileManagerStatics": ["8ffc224a-e782-495d-b614-654c4f0b2370"],
    "ICachedFileUpdaterActivatedEventArgs": ["d06eb1c7-3805-4ecb-b757-6cf15e26fef3"],
    "ICachedFileUpdaterHost": ["6be3cdf4-613c-4eb4-b5d5-03abc11b34b4"],
    "ICachedFileUpdaterStatics": ["9fc90920-7bcf-4888-a81e-102d7034d7ce"],
    "ICachedFileUpdaterTrigger": ["e21caeeb-32f2-4d31-b553-b9e01bde37e0"],
    "ICachedFileUpdaterTriggerDetails": ["71838c13-1314-47b4-9597-dc7e248c17cc"],
    "ICachedFileUpdaterUI": ["9e6f41e6-baf2-4a97-b600-9333f5df80fd"],
    "ICachedFileUpdaterUI2": ["8856a21c-8699-4340-9f49-f7cad7fe8991"],
    "ICachedPrivateProfile": ["b57046bc-32e5-428a-9887-19f712b907bf"],
    "ICalendar": ["ca30221d-86d9-40fb-a26b-d44eb7cf08ea"],
    "ICalendarDatePicker": ["63c9c16f-668c-4491-9444-d45d8bf4fa29"],
    "ICalendarDatePicker2": ["b216c159-2411-4a60-a7aa-27416b49481e"],
    "ICalendarDatePicker3": ["645856c0-db7b-5e75-85e9-f623e3457ea6"],
    "ICalendarDatePickerAutomationPeer": ["40d8938e-db5e-4b03-beba-d10f62419787"],
    "ICalendarDatePickerAutomationPeerFactory": ["ab705dd2-d293-45bf-9f19-26f7603a5e9b"],
    "ICalendarDatePickerDateChangedEventArgs": ["60d90db2-5010-46ba-842d-a4152c6504e7"],
    "ICalendarDatePickerFactory": ["107aad5d-38be-42af-a957-fc86a5cf1e9a"],
    "ICalendarDatePickerStatics": ["39a3d291-afab-4b94-8395-ba7b874e3c8c"],
    "ICalendarDatePickerStatics2": ["30206b58-a2f6-4a00-8d13-33c46b6b8e0d"],
    "ICalendarDatePickerStatics3": ["b188741d-cf69-568c-9707-baaaec2b64db"],
    "ICalendarFactory": ["83f58412-e56b-4c75-a66e-0f63d57758a6"],
    "ICalendarFactory2": ["b44b378c-ca7e-4590-9e72-ea2bec1a5115"],
    "ICalendarIdentifiersStatics": ["80653f68-2cb2-4c1f-b590-f0f52bf4fd1a"],
    "ICalendarIdentifiersStatics2": ["7df4d488-5fd0-42a7-95b5-7d98d823075f"],
    "ICalendarIdentifiersStatics3": ["2c225423-1fad-40c0-9334-a8eb90db04f5"],
    "ICalendarPanel": ["fcd55a2d-02d3-4ee6-9a90-9df3ead00994"],
    "ICalendarView": ["cd639203-dfb5-4312-ac07-c0391824607b"],
    "ICalendarViewDayItem": ["0fdb2dc5-32c1-4b8f-befc-017b555b32d2"],
    "ICalendarViewDayItemChangingEventArgs": ["73146666-1fb1-44f9-b7ad-4de859ecc565"],
    "ICalendarViewDayItemChangingEventHandler": ["8d745891-4de3-49cb-974b-083871a3afe6"],
    "ICalendarViewDayItemFactory": ["62112bdc-1d2f-4e44-9baf-1665749521f2"],
    "ICalendarViewDayItemStatics": ["c3a1dbbf-bd88-488b-b916-d00d69b1735a"],
    "ICalendarViewFactory": ["3d8f82e3-6cc6-423e-8d7c-7014d954ddef"],
    "ICalendarViewSelectedDatesChangedEventArgs": ["ee6069f6-13ef-4896-8ffc-5302b1b17539"],
    "ICalendarViewStatics": ["7260f1c4-2f5d-41bd-99bb-4571b20b79a8"],
    "ICalendarViewTemplateSettings": ["56c71483-64e1-477c-8a0b-cb2f3334b9b0"],
    "ICallAnswerEventArgs": ["61f132aa-f92a-48fa-aa8f-4f3a17662980", "fd789617-2dd7-4c8c-b2bd-95d17a5bb733"],
    "ICallControl": ["a520d0d6-ae8d-45db-8011-ca49d3b3e578"],
    "ICallControlEventHandler": ["596f759f-50df-4454-bc63-4d3d01b61958"],
    "ICallControlStatics": ["03945ad5-85ab-40e1-af19-56c94303b019"],
    "ICallInfo": ["000001dc-0000-0000-c000-000000000046"],
    "ICallRejectEventArgs": ["3e04061a-ce7d-49c2-a2b8-7f49b6eaebc5", "da47fad7-13d4-4d92-a1c2-b77811ee37ec"],
    "ICallStateChangeEventArgs": ["1f3e87b0-d371-4395-8b6c-1786a42e2f18", "eab2349e-66f5-47f9-9fb5-459c5198c720"],
    "ICallWaitingSettingsCompletion": ["f9581718-2283-4336-9397-1c6c067299d2"],
    "ICallbackWithNoReentrancyToApplicationSTA": ["0a299774-3e4e-fc42-1d9d-72cee105ca57"],
    "ICallingProcessInfo": ["68c6a1b9-de39-42c3-8d28-bf40a5126541"],
    "ICameraCaptureUI": ["48587540-6f93-4bb4-b8f3-e89e48948c91"],
    "ICameraCaptureUIPhotoCaptureSettings": ["b9f5be97-3472-46a8-8a9e-04ce42ccc97d"],
    "ICameraCaptureUIVideoCaptureSettings": ["64e92d1f-a28d-425a-b84f-e568335ff24e"],
    "ICameraControl": ["2ba1785d-4d1b-44ef-85e8-c7f1d3f20184"],
    "ICameraIntrinsics": ["0aa6ed32-6589-49da-afde-594270ca0aac"],
    "ICameraIntrinsics2": ["0cdaa447-0798-4b4d-839f-c5ec414db27a"],
    "ICameraIntrinsicsFactory": ["c0ddc486-2132-4a34-a659-9bfe2a055712"],
    "ICameraOptionsUIStatics": ["3b0d5e34-3906-4b7d-946c-7bde844499ae"],
    "ICameraSettingsActivatedEventArgs": ["fb67a508-2dad-490a-9170-dca036eb114b"],
    "ICameraSoundPlayback": ["6ae0038b-c4d8-4fbf-9931-b0ec2db17423"],
    "ICameraUIControl": ["b8733adf-3d68-4b8f-bb08-e28a0bed0376"],
    "ICameraUIControlEventCallback": ["1bfa0c2c-fbcd-4776-bda4-88bf974e74f4"],
    "ICanExecuteRequestedEventArgs": ["c8e75256-1950-505d-993b-75907ef96830"],
    "ICanHandleException": ["c5598e60-b307-11d1-b27d-006008c3fbfb"],
    "ICanInfoCompletion": ["b5bb6a5e-8d3f-4203-b58b-26c3d4e8eedc"],
    "ICandidateWindowBoundsChangedEventArgs": ["8a946458-83b0-4c32-9450-5169a5838b55"],
    "ICanvas": ["79190e19-cd38-4823-aeae-64a77132f519"],
    "ICanvasFactory": ["1b328bd1-b400-4a8e-943b-5ad2c45be0df"],
    "ICanvasGradient": ["30510714-98b5-11cf-bb82-00aa00bdce0b"],
    "ICanvasImageData": ["3051071a-98b5-11cf-bb82-00aa00bdce0b"],
    "ICanvasPattern": ["30510716-98b5-11cf-bb82-00aa00bdce0b"],
    "ICanvasPixelArray": ["3051071c-98b5-11cf-bb82-00aa00bdce0b"],
    "ICanvasPixelArrayData": ["305107f9-98b5-11cf-bb82-00aa00bdce0b"],
    "ICanvasRenderingContext2D": ["305106ff-98b5-11cf-bb82-00aa00bdce0b"],
    "ICanvasStatics": ["40ce5c46-2962-446f-aafb-4cdc486939c9"],
    "ICanvasTextMetrics": ["30510718-98b5-11cf-bb82-00aa00bdce0b"],
    "ICapabilities": ["5f6942bb-61c5-4fe5-9956-f7c99812f95c"],
    "ICaptionServiceDescriptor": ["40834007-6834-46f0-bd45-d5f6a6be258c"],
    "ICaptureElement": ["31a5c0e7-f307-4d4a-b626-e978863f5b74"],
    "ICaptureElementAutomationPeer": ["dcc44ee0-fa45-45c6-8bb7-320d808f5958"],
    "ICaptureElementAutomationPeerFactory": ["9b92ef48-85e9-4869-b175-8f7cf45a6d9f"],
    "ICaptureElementStatics": ["1e438ded-7da6-409e-806e-305ae4ad9b3f"],
    "ICapturedFrame": ["1dd2de1f-571b-44d8-8e80-a08a1578766e"],
    "ICapturedFrame2": ["543fa6d1-bd78-4866-adda-24314bc65dea"],
    "ICapturedFrameControlValues": ["90c65b7f-4e0d-4ca4-882d-7a144fed0a90"],
    "ICapturedFrameControlValues2": ["500b2b88-06d2-4aa7-a7db-d37af73321d8"],
    "ICapturedFrameWithSoftwareBitmap": ["b58e8b6e-8503-49b5-9e86-897d26a3ff3d"],
    "ICapturedPhoto": ["b0ce7e5a-cfcc-4d6c-8ad1-0869208aca16"],
    "ICardAddedEventArgs": ["18bbef98-f18b-4dd3-b118-dfb2c8e23cc6"],
    "ICardRemovedEventArgs": ["15331aaf-22d7-4945-afc9-03b46f42a6cd"],
    "ICaretPositionProvider": ["58da43a2-108e-4d5b-9f75-e5f74f93fff5"],
    "ICarouselPanel": ["deab78b2-373b-4151-8785-e544d0d9362b"],
    "ICarouselPanelFactory": ["c1109404-9ae1-440e-a0dd-bbb6e2293cbe"],
    "ICashDrawer": ["9f88f5c8-de54-4aee-a890-920bcbfe30fc"],
    "ICashDrawerCapabilities": ["0bc6de0b-e8e7-4b1f-b1d1-3e501ad08247"],
    "ICashDrawerCloseAlarm": ["6bf88cc7-6f63-430e-ab3b-95d75ffbe87f"],
    "ICashDrawerEventSource": ["e006e46c-f2f9-442f-8dd6-06c10a4227ba"],
    "ICashDrawerEventSourceEventArgs": ["69cb3bc1-147f-421c-9c23-090123bb786c"],
    "ICashDrawerStatics": ["dfa0955a-d437-4fff-b547-dda969a4f883"],
    "ICashDrawerStatics2": ["3e818121-8c42-40e8-9c0e-40297048104c"],
    "ICashDrawerStatus": ["6bbd78bf-dca1-4e06-99eb-5af6a5aec108"],
    "ICashDrawerStatusUpdatedEventArgs": ["30aae98a-0d70-459c-9553-87e124c52488"],
    "ICastingConnection": ["cd951653-c2f1-4498-8b78-5fb4cd3640dd"],
    "ICastingConnectionErrorOccurredEventArgs": ["a7fb3c69-8719-4f00-81fb-961863c79a32"],
    "ICastingController": ["f0a56423-a664-4fbd-8b43-409a45e8d9a1"],
    "ICastingDevice": ["de721c83-4a43-4ad1-a6d2-2492a796c3f2"],
    "ICastingDevicePicker": ["dcd39924-0591-49be-aacb-4b82ee756a95"],
    "ICastingDevicePickerFilter": ["be8c619c-b563-4354-ae33-9fdaad8c6291"],
    "ICastingDeviceSelectedEventArgs": ["dc439e86-dd57-4d0d-9400-af45e4fb3663"],
    "ICastingDeviceStatics": ["e7d958d7-4d13-4237-a365-4c4f6a4cfd2f"],
    "ICastingEventHandler": ["c79a6cb7-bebd-47a6-a2ad-4d45ad79c7bc"],
    "ICastingSource": ["f429ea72-3467-47e6-a027-522923e9d727"],
    "ICastingSourceInfo": ["45101ab7-7c3a-4bce-9500-12c09024b298"],
    "ICatBandManager": ["8d79a7d3-6397-48ee-bc1f-1f021f8fff1c"],
    "ICatalog64BitSupport": ["1d118904-94b3-4a64-9fa6-ed432666a7b9"],
    "ICatalogFileInfo2Priv": ["ec7985d9-5d5f-45cb-9e91-3d7d6406fb1d"],
    "ICatalogServices": ["04c6be1e-1db1-4058-ab7a-700cccfbf254"],
    "ICatalogSession": ["182c40fa-32e4-11d0-818b-00a0c9231c29"],
    "ICatalogSetup2": ["d66375aa-132d-43fa-881c-3ebff2ca8e24"],
    "ICatalogTableInfo": ["a8927a41-d3ce-11d1-8472-006008b0e5ca"],
    "ICategorizableItem": ["d607ad44-e038-4501-861d-d9a6d52a2105"],
    "ICategorizeProperties": ["4d07fc10-f931-11ce-b001-00aa006884e5"],
    "ICategorizerFactory": ["7b9cee5b-bc27-4480-92f8-65222afd2bf9"],
    "ICategoryCollection": ["3a56bfb8-576c-43f7-9335-fe4838fd7e37"],
    "ICategoryDescription": ["d8074769-99fe-4b5e-8ca1-afc6bcd17d44"],
    "ICategoryDescriptionArray": ["406a66e8-0dc2-49e4-81e2-1f7a7da666db"],
    "ICategoryInfo": ["f8c3e22d-db97-4090-9729-76d84e10f7e8"],
    "ICategoryInfoArray": ["a6564d5e-75b8-40ac-a23c-ab9ba01b9cdd"],
    "ICbeTaskCompletionBroker": ["0e84b395-a286-455b-8202-a069be0b2571"],
    "ICellset": ["2281372a-8bd3-11d0-b4ef-00a0c9138ca4"],
    "ICellularApnContext": ["6fa529f4-effd-4542-9ab2-705bbf94943a"],
    "ICellularApnContext2": ["76b0eb1a-ac49-4350-b1e5-dc4763bc69c7"],
    "ICentennialLifetimeManagerConsoleOperator": ["749413f7-bd96-4017-88d7-e22797a95c62"],
    "ICertAdmin": ["34df6950-7fb6-11d0-8817-00a0c903b83c"],
    "ICertAdmin2": ["f7c3ac41-b8ce-4fb4-aa58-3d1dc0e36b39"],
    "ICertConfig": ["372fce34-4324-11d0-8810-00a0c903b83c"],
    "ICertConfig2": ["7a18edde-7e78-4163-8ded-78e2c9cee924"],
    "ICertEncodeAltName": ["1c9a8c70-1271-11d1-9bd4-00c04fb683fa"],
    "ICertEncodeAltName2": ["f67fe177-5ef1-4535-b4ce-29df15e2e0c3"],
    "ICertEncodeBitString": ["6db525be-1278-11d1-9bd4-00c04fb683fa"],
    "ICertEncodeBitString2": ["e070d6e7-23ef-4dd2-8242-ebd9c928cb30"],
    "ICertEncodeCRLDistInfo": ["01958640-bbff-11d0-8825-00a0c903b83c"],
    "ICertEncodeCRLDistInfo2": ["b4275d4b-3e30-446f-ad36-09d03120b078"],
    "ICertEncodeDateArray": ["2f9469a0-a470-11d0-8821-00a0c903b83c"],
    "ICertEncodeDateArray2": ["99a4edb5-2b8e-448d-bf95-bba8d7789dc8"],
    "ICertEncodeLongArray": ["15e2f230-a0a2-11d0-8821-00a0c903b83c"],
    "ICertEncodeLongArray2": ["4efde84a-bd9b-4fc2-a108-c347d478840f"],
    "ICertEncodeStringArray": ["12a88820-7494-11d0-8816-00a0c903b83c"],
    "ICertEncodeStringArray2": ["9c680d93-9b7d-4e95-9018-4ffe10ba5ada"],
    "ICertExit": ["e19ae1a0-7364-11d0-8816-00a0c903b83c"],
    "ICertExit2": ["0abf484b-d049-464d-a7ed-552e7529b0ff"],
    "ICertGetConfig": ["c7ea09c0-ce17-11d0-8833-00a0c903b83c"],
    "ICertPolicy": ["38bb5a00-7636-11d0-b413-00a0c91bbf8c"],
    "ICertPolicy2": ["3db4910e-8001-4bf1-aa1b-f43a808317a0"],
    "ICertProperties": ["728ab32f-217d-11da-b2a4-000e7bbb2b09"],
    "ICertProperty": ["728ab32e-217d-11da-b2a4-000e7bbb2b09"],
    "ICertPropertyArchived": ["728ab337-217d-11da-b2a4-000e7bbb2b09"],
    "ICertPropertyArchivedKeyHash": ["728ab33b-217d-11da-b2a4-000e7bbb2b09"],
    "ICertPropertyAutoEnroll": ["728ab332-217d-11da-b2a4-000e7bbb2b09"],
    "ICertPropertyBackedUp": ["728ab338-217d-11da-b2a4-000e7bbb2b09"],
    "ICertPropertyDescription": ["728ab331-217d-11da-b2a4-000e7bbb2b09"],
    "ICertPropertyEnrollment": ["728ab339-217d-11da-b2a4-000e7bbb2b09"],
    "ICertPropertyEnrollmentPolicyServer": ["728ab34a-217d-11da-b2a4-000e7bbb2b09"],
    "ICertPropertyFriendlyName": ["728ab330-217d-11da-b2a4-000e7bbb2b09"],
    "ICertPropertyKeyProvInfo": ["728ab336-217d-11da-b2a4-000e7bbb2b09"],
    "ICertPropertyRenewal": ["728ab33a-217d-11da-b2a4-000e7bbb2b09"],
    "ICertPropertyRequestOriginator": ["728ab333-217d-11da-b2a4-000e7bbb2b09"],
    "ICertPropertySHA1Hash": ["728ab334-217d-11da-b2a4-000e7bbb2b09"],
    "ICertRequest": ["014e4840-5523-11d0-8812-00a0c903b83c"],
    "ICertRequest2": ["a4772988-4a85-4fa9-824e-b5cf5c16405a"],
    "ICertRequest3": ["afc8f92b-33a2-4861-bf36-2933b7cd67b3"],
    "ICertRequestD": ["d99e6e70-fc88-11d0-b498-00a0c90312f3"],
    "ICertRequestD2": ["5422fd3a-d4b8-4cef-a12e-e87d4ca22e90"],
    "ICertServerExit": ["4ba9eb90-732c-11d0-8816-00a0c903b83c"],
    "ICertServerPolicy": ["aa000922-ffbe-11cf-8800-00a0c903b83c"],
    "ICertSrvSetup": ["b760a1bb-4784-44c0-8f12-555f0780ff25"],
    "ICertSrvSetupKeyInformation": ["6ba73778-36da-4c39-8a85-bcfa7d000793"],
    "ICertSrvSetupKeyInformationCollection": ["e65c8b00-e58f-41f9-a9ec-a28d7427c844"],
    "ICertView": ["c3fac344-1e84-11d1-9bd6-00c04fb683fa"],
    "ICertView2": ["d594b282-8851-4b61-9c66-3edadf848863"],
    "ICertificate": ["333f740c-04d8-43b3-b278-8c5fcc9be5a0"],
    "ICertificate2": ["17b8374c-8a25-4d96-a492-8fc29ac4fda6"],
    "ICertificate3": ["be51a966-ae5f-4652-ace7-c6d7e7724cf3"],
    "ICertificateAttestationChallenge": ["6f175a7c-4a3a-40ae-9dba-592fd6bbf9b8"],
    "ICertificateAttestationChallenge2": ["4631334d-e266-47d6-bd79-be53cb2e2753"],
    "ICertificateChain": ["20bf5385-3691-4501-a62c-fd97278b31ee"],
    "ICertificateEnrollmentManagerStatics": ["8846ef3f-a986-48fb-9fd7-9aec06935bf1"],
    "ICertificateEnrollmentManagerStatics2": ["dc5b1c33-6429-4014-999c-5d9735802d1d"],
    "ICertificateEnrollmentManagerStatics3": ["fdec82be-617c-425a-b72d-398b26ac7264"],
    "ICertificateEnrollmentPolicyServerSetup": ["859252cc-238c-4a88-b8fd-a37e7d04e68b"],
    "ICertificateEnrollmentServerSetup": ["70027fdb-9dd9-4921-8944-b35cb31bd2ec"],
    "ICertificateExtension": ["84cf0656-a9e6-454d-8e45-2ea7c4bcd53b"],
    "ICertificateFactory": ["17b4221c-4baf-44a2-9608-04fb62b16942"],
    "ICertificateKeyUsages": ["6ac6206f-e1cf-486a-b485-a69c83e46fd1"],
    "ICertificatePolicies": ["728ab31f-217d-11da-b2a4-000e7bbb2b09"],
    "ICertificatePolicy": ["728ab31e-217d-11da-b2a4-000e7bbb2b09"],
    "ICertificateQuery": ["5b082a31-a728-4916-b5ee-ffcb8acf2417"],
    "ICertificateQuery2": ["935a0af7-0bd9-4f75-b8c2-e27a7f74eecd"],
    "ICertificateRequestProperties": ["487e84f6-94e2-4dce-8833-1a700a37a29a"],
    "ICertificateRequestProperties2": ["3da0c954-d73f-4ff3-a0a6-0677c0ada05b"],
    "ICertificateRequestProperties3": ["e687f616-734d-46b1-9d4c-6edfdbfc845b"],
    "ICertificateRequestProperties4": ["4e429ad2-1c61-4fea-b8fe-135fb19cdce4"],
    "ICertificateStore": ["b0bff720-344e-4331-af14-a7f7a7ebc93a"],
    "ICertificateStore2": ["c7e68e4a-417d-4d1a-babd-15687e549974"],
    "ICertificateStoresStatics": ["fbecc739-c6fe-4de7-99cf-74c3e596e032"],
    "ICertificateStoresStatics2": ["fa900b79-a0d4-4b8c-bc55-c0a37eb141ed"],
    "ICertificationAuthorities": ["13b79005-2181-11da-b2a4-000e7bbb2b09"],
    "ICertificationAuthority": ["835d1f61-1e95-4bc8-b4d3-976c42b968f7"],
    "IChainBuildingParameters": ["422ba922-7c8d-47b7-b59b-b12703733ac3"],
    "IChainValidationParameters": ["c4743b4a-7eb0-4b56-a040-b9c8e655ddf3"],
    "IChangeConflict": ["014ebf97-9f20-4f7a-bdd4-25979c77c002"],
    "IChangeNotifySink": ["320cf551-8e59-49bb-93d5-cf5ad5c29299"],
    "IChangeUnitException": ["0cd7ee7c-fec0-4021-99ee-f0e5348f2a5f"],
    "IChangeUnitListFilterInfo": ["f2837671-0bdf-43fa-b502-232375fb50c2"],
    "IChannelAudioVolume": ["1c158861-b533-4b30-b1cf-e853e51c59b8"],
    "IChannelCredentials": ["181b448c-c17c-4b17-ac6d-06699b93198f"],
    "IChannelHandleMarshal": ["f17737fe-2a97-4514-8507-f21abf6ffb16"],
    "IChannelIDTuneRequest": ["156eff60-86f4-4e28-89fc-109799fd57ee"],
    "IChannelTuneRequest": ["0369b4e0-45b6-11d3-b650-00c04f79498e"],
    "IChapterCue": ["72a98001-d38a-4c0a-8fa6-75cddaf4664c"],
    "IChapteredRowset": ["0c733a93-2a1c-11ce-ade5-00aa0044773d"],
    "ICharacterGrouping": ["fae761bb-805d-4bb0-95bb-c1f7c3e8eb8e"],
    "ICharacterGroupings": ["b8d20a75-d4cf-4055-80e5-ce169c226496"],
    "ICharacterGroupingsFactory": ["99ea9fd9-886d-4401-9f98-69c82d4c2f78"],
    "ICharacterReceivedEventArgs": ["c584659f-99b2-4bcc-bd33-04e63f42902e"],
    "ICharacterReceivedRoutedEventArgs": ["7849fd82-48e4-444d-9419-93ab8892c107"],
    "ICharmBarAction": ["b2ec85ee-0d21-4b56-a460-e4aa92ee2283"],
    "IChatCapabilities": ["3aff77bc-39c9-4dd1-ad2d-3964dd9d403f"],
    "IChatCapabilitiesManagerStatics": ["b57a2f30-7041-458e-b0cf-7c0d9fea333a"],
    "IChatCapabilitiesManagerStatics2": ["e30d4274-d5c1-4ac9-9ffc-40e69184fec8"],
    "IChatConversation": ["a58c080d-1a6f-46dc-8f3d-f5028660b6ee"],
    "IChatConversation2": ["0a030cd1-983a-47aa-9a90-ee48ee997b59"],
    "IChatConversationReader": ["055136d2-de32-4a47-a93a-b3dc0833852b"],
    "IChatConversationThreadingInfo": ["331c21dc-7a07-4422-a32c-24be7c6dab24"],
    "IChatItem": ["8751d000-ceb1-4243-b803-15d45a1dd428"],
    "IChatMessage": ["4b39052a-1142-5089-76da-f2db3d17cd05"],
    "IChatMessage2": ["86668332-543f-49f5-ac71-6c2afc6565fd"],
    "IChatMessage3": ["74eb2fb0-3ba7-459f-8e0b-e8af0febd9ad"],
    "IChatMessage4": ["2d144b0f-d2bf-460c-aa68-6d3f8483c9bf"],
    "IChatMessageAttachment": ["c7c4fd74-bf63-58eb-508c-8b863ff16b67"],
    "IChatMessageAttachment2": ["5ed99270-7dd1-4a87-a8ce-acdd87d80dc8"],
    "IChatMessageAttachmentFactory": ["205852a2-a356-5b71-6ca9-66c985b7d0d5"],
    "IChatMessageBlockingStatic": ["f6b9a380-cdea-11e4-8830-0800200c9a66"],
    "IChatMessageChange": ["1c18c355-421e-54b8-6d38-6b3a6c82fccc"],
    "IChatMessageChangeReader": ["14267020-28ce-5f26-7b05-9a5c7cce87ca"],
    "IChatMessageChangeTracker": ["60b7f066-70a0-5224-508c-242ef7c1d06f"],
    "IChatMessageChangedDeferral": ["fbc6b30c-788c-4dcc-ace7-6282382968cf"],
    "IChatMessageChangedEventArgs": ["b6b73e2d-691c-4edf-8660-6eb9896892e3"],
    "IChatMessageManager2Statics": ["1d45390f-9f4f-4e35-964e-1b9ca61ac044"],
    "IChatMessageManagerStatic": ["f15c60f7-d5e8-5e92-556d-e03b60253104"],
    "IChatMessageManagerStatics3": ["208b830d-6755-48cc-9ab3-fd03c463fc92"],
    "IChatMessageNotificationTrigger": ["513b43bf-1d40-5c5d-78f5-c923fee3739e"],
    "IChatMessageNotificationTriggerDetails": ["fd344dfb-3063-4e17-8586-c6c08262e6c0"],
    "IChatMessageNotificationTriggerDetails2": ["6bb522e0-aa07-4fd1-9471-77934fb75ee6"],
    "IChatMessageReader": ["b6ea78ce-4489-56f9-76aa-e204682514cf"],
    "IChatMessageReader2": ["89643683-64bb-470d-9df4-0de8be1a05bf"],
    "IChatMessageReceivedNotificationTrigger": ["3ea3760e-baf5-4077-88e9-060cf6f0c6d5"],
    "IChatMessageStore": ["31f2fd01-ccf6-580b-4976-0a07dd5d3b47"],
    "IChatMessageStore2": ["ad4dc4ee-3ad4-491b-b311-abdf9bb22768"],
    "IChatMessageStore3": ["9adbbb09-4345-4ec1-8b74-b7338243719c"],
    "IChatMessageStoreChangedEventArgs": ["65c66fac-fe8c-46d4-9119-57b8410311d5"],
    "IChatMessageTransport": ["63a9dbf8-e6b3-5c9a-5f85-d47925b9bd18"],
    "IChatMessageTransport2": ["90a75622-d84a-4c22-a94d-544444edc8a1"],
    "IChatMessageTransportConfiguration": ["879ff725-1a08-4aca-a075-3355126312e6"],
    "IChatMessageValidationResult": ["25e93a03-28ec-5889-569b-7e486b126f18"],
    "IChatQueryOptions": ["2fd364a6-bf36-42f7-b7e7-923c0aabfe16"],
    "IChatRecipientDeliveryInfo": ["ffc7b2a2-283c-4c0a-8a0e-8c33bdbf0545"],
    "IChatSearchReader": ["4665fe49-9020-4752-980d-39612325f589"],
    "IChatSyncConfiguration": ["09f869b2-69f4-4aff-82b6-06992ff402d2"],
    "IChatSyncManager": ["7ba52c63-2650-486f-b4b4-6bd9d3d63c84"],
    "ICheckBoxAutomationPeer": ["eb15bc42-c0a9-46c6-ac24-b83de429c733"],
    "ICheckBoxAutomationPeerFactory": ["b75c775d-eb8f-44ef-a27c-e26ac7de8333"],
    "ICheckBoxFactory": ["4fa6aabb-3f4b-4301-be07-1172ea61eefb"],
    "ICheckDiskDialog": ["504b27aa-001f-4179-9ad0-663a37c317a9"],
    "IChildId": ["c412bf5b-91ea-4904-b34a-855504fbbf0b"],
    "IChildInfo": ["31140cb5-6b64-48ff-b872-660441ce9e51"],
    "IChoosingGroupHeaderContainerEventArgs": ["67db44d6-d201-4d72-beac-5e8e58afd8c7"],
    "IChoosingItemContainerEventArgs": ["9bb43bce-ae67-4a80-8363-e3fe1b244f2c"],
    "ICiQueryServer": ["2cf34970-2fe7-11d3-b880-00805f85d78c"],
    "ICiSecurityStore": ["a28e816a-dbc1-11d2-9a8c-00c04f6888ed"],
    "ICiSecurityStore2": ["77881d91-be5d-4b91-94b2-5c7b474d00ef"],
    "ICircleEase": ["53a3bdb2-9177-4e6e-a043-5082d889ab1f"],
    "ICivicAddress": ["a8567a1a-64f4-4d48-bcea-f6b008eca34c"],
    "ICivicAddressReport": ["c0b19f70-4adf-445d-87f2-cad8fd711792"],
    "ICivicAddressReportFactory": ["bf773b93-c64f-4bee-beb2-67c0b8df66e0"],
    "IClaimedBarcodeScanner": ["4a63b49c-8fa4-4332-bb26-945d11d81e0f"],
    "IClaimedBarcodeScanner1": ["f61aad0c-8551-42b4-998c-970c20210a22"],
    "IClaimedBarcodeScanner2": ["e3b59e8c-2d8b-4f70-8af3-3448bedd5fe2"],
    "IClaimedBarcodeScanner3": ["e6ceb430-712e-45fc-8b86-cd55f5aef79d"],
    "IClaimedBarcodeScanner4": ["5d501f97-376a-41a8-a230-2f37c1949dde"],
    "IClaimedBarcodeScannerClosedEventArgs": ["cf7d5489-a22c-4c65-a901-88d77d833954"],
    "IClaimedCashDrawer": ["ca3f99af-abb8-42c1-8a84-5c66512f5a75"],
    "IClaimedCashDrawer2": ["9cbab5a2-de42-4d5b-b0c1-9b57a2ba89c3"],
    "IClaimedCashDrawerClosedEventArgs": ["cc573f33-3f34-4c5c-baae-deadf16cd7fa"],
    "IClaimedJournalPrinter": ["67ea0630-517d-487f-9fdf-d2e0a0a264a5"],
    "IClaimedLineDisplay": ["120ac970-9a75-4acf-aae7-09972bcf8794"],
    "IClaimedLineDisplay2": ["a31c75ed-41f5-4e76-a074-795e47a46e97"],
    "IClaimedLineDisplay3": ["642ecd92-e9d4-4ecc-af75-329c274cd18f"],
    "IClaimedLineDisplayClosedEventArgs": ["f915f364-d3d5-4f10-b511-90939edfacd8"],
    "IClaimedLineDisplayStatics": ["78ca98fb-8b6b-4973-86f0-3e570c351825"],
    "IClaimedMagneticStripeReader": ["475ca8f3-9417-48bc-b9d7-4163a7844c02"],
    "IClaimedMagneticStripeReader2": ["236fafdf-e2dc-4d7d-9c78-060df2bf2928"],
    "IClaimedMagneticStripeReaderClosedEventArgs": ["14ada93a-adcd-4c80-acda-c3eaed2647e1"],
    "IClaimedPosPrinter": ["6d64ce0c-e03e-4b14-a38e-c28c34b86353"],
    "IClaimedPosPrinter2": ["5bf7a3d5-5198-437a-82df-589993fa77e1"],
    "IClaimedPosPrinterClosedEventArgs": ["e2b7a27b-4d40-471d-92ed-63375b18c788"],
    "IClaimedReceiptPrinter": ["9ad27a74-dd61-4ee2-9837-5b5d72d538b9"],
    "IClaimedSlipPrinter": ["bd5deff2-af90-4e8a-b77b-e3ae9ca63a7f"],
    "IClassActivityInfo": ["000001e5-0000-0000-c000-000000000046"],
    "IClassBabyJitActivationInfo": ["a2d9cfd2-2bc9-4f56-88f2-c515a6d31d8d"],
    "IClassClassicInfo": ["000001e2-0000-0000-c000-000000000046"],
    "IClassClassicInfo2": ["000001df-0000-0000-c000-000000000046"],
    "IClassClassicInfo3": ["0318b242-d086-4de9-b10c-2824a6ca1019"],
    "IClassComTIIntrinsics": ["000001f4-0000-0000-c000-000000000046"],
    "IClassDesigner": ["94a0f6f1-10bc-11d0-8d09-00a0c90f2732"],
    "IClassFactory3": ["342d1ea0-ae25-11d1-89c5-006008c3fbfc"],
    "IClassIISIntrinsics": ["000001f3-0000-0000-c000-000000000046"],
    "IClassJitActivationInfo": ["000001e7-0000-0000-c000-000000000046"],
    "IClassLoadBalancingInfo": ["000001ea-0000-0000-c000-000000000046"],
    "IClassObjectPoolingInfo": ["000001eb-0000-0000-c000-000000000046"],
    "IClassRetInfo": ["000001e9-0000-0000-c000-000000000046"],
    "IClassSecurityInfo": ["000001e8-0000-0000-c000-000000000046"],
    "IClassTrackingInfo": ["000001f6-0000-0000-c000-000000000046"],
    "IClassTransactionInfo": ["000001e6-0000-0000-c000-000000000046"],
    "IClassTransactionInfo2": ["bda21d55-c681-44bc-998b-35731155ca82"],
    "IClassicAppManagerStatics": ["e2fad668-882c-4f33-b035-0df7b90d67e6"],
    "IClassicApplicationView": ["7a05f995-6242-440e-a64e-34b7ed3413d3"],
    "IClassicApplicationViewFactory": ["ecc62f5d-14aa-4971-9f06-b2159b1ffd40"],
    "IClassicWindowManager": ["6c6cbabd-6e36-4f9d-a349-c8852d0e7ee5"],
    "ICleanUpVirtualizedItemEventArgs": ["ea05cce9-937c-4120-8406-792185784338"],
    "ICleanUpVirtualizedItemEventHandler": ["cacad0d6-0f0d-4870-884d-f2dedf674288"],
    "IClearCancel": ["4a235d38-01a3-44fe-87ce-2a3afb4b5ee0"],
    "IClickNote": ["f9fe368b-8033-43a5-9e71-17f6f5385832"],
    "IClipServiceNotificationHelper": ["c39948f0-6142-44fd-98ca-e1681a8d68b5"],
    "IClipboardBroker": ["ac57caff-e1cb-4325-8d0a-0da256c83284"],
    "IClipboardBrokerInternal": ["51c971b4-0504-4933-af4e-64e3ee0a7be5"],
    "IClipboardContentChangedCallback": ["2f55d587-f8cb-427d-968a-5412ed551f7e"],
    "IClipboardContentOptions": ["e888a98c-ad4b-5447-a056-ab3556276d2b"],
    "IClipboardHistoryChangedEventArgs": ["c0be453f-8ea2-53ce-9aba-8d2212573452"],
    "IClipboardHistoryItem": ["0173bd8a-afff-5c50-ab92-3d19f481ec58"],
    "IClipboardHistoryItemsResult": ["e6dfdee6-0ee2-52e3-852b-f295db65939a"],
    "IClipboardNotificationClient": ["69f490d3-555d-4c08-8f93-b3b39246a3e1"],
    "IClipboardProtectionServices": ["fed95700-f716-4950-bcac-8e2e1ca1b307"],
    "IClipboardServer": ["b3d86f99-514b-4fb3-bc0b-e77a1a717abc"],
    "IClipboardStatics": ["c627e291-34e2-4963-8eed-93cbb0ea3d70"],
    "IClipboardStatics2": ["d2ac1b6a-d29f-554b-b303-f0452345fe02"],
    "IClipboardTaskCompletion": ["c58bdf0c-86c7-4fbc-90ae-94c73629ce74"],
    "IClockIdentifiersStatics": ["523805bb-12ec-4f83-bc31-b1b4376b0808"],
    "IClockVector": ["14b2274a-8698-4cc6-9333-f89bd1d47bc4"],
    "IClockVectorElement": ["e71c4250-adf8-4a07-8fae-5669596909c1"],
    "IClonableWrapper": ["b33e75ff-e84c-4dca-a25c-33b8dc003374"],
    "ICloneViewHelper": ["f6a3d4c4-5632-4d83-b0a1-fb88712b1eb7"],
    "IClosable": ["30d5a829-7fa4-4026-83bb-d75bae4ea99e"],
    "ICloseRequestBroker": ["128badf9-175b-44f1-86ec-7dd47c93dac4"],
    "ICloseRequestedArgsPrivate": ["682ac0ef-3263-4190-ba9e-2526278dcd04"],
    "ICloseRequestedService": ["cd2d3dc4-03e6-49c5-9acf-ad01ab648e99"],
    "IClosedCaptionPropertiesStatics": ["10aa1f84-cc30-4141-b503-5272289e0c20"],
    "IClosedTabManager": ["c10dbf75-c96b-4a7d-af1a-ba4c6d9e80fc"],
    "IClosestInteractiveBoundsRequestedEventArgs": ["347c11d7-f6f8-40e3-b29f-ae50d3e86486"],
    "ICloudChangeWnfMonitor": ["8fe8483d-8533-4ec9-8572-7453008d57b0"],
    "ICloudManageAppBackups": ["ed0bf9c6-539f-11e3-9262-ba9b6188709b"],
    "ICloudManageDeviceBackups": ["5ed6404c-ca2b-4994-9fcd-3a271b5af8d2"],
    "ICloudManageSystemSettingBackups": ["45171f48-f800-4bf4-994a-736678325610"],
    "ICloudStorageInfo": ["07c996ae-9cc3-11e2-9f8f-d7f06188709b"],
    "ICloudStorageUsage": ["323fdf42-6140-11e2-8178-c6316188709b"],
    "ICloudStorageWizard": ["38ff3dc2-9d96-415d-bce7-92162743fee4"],
    "ICloudSyncEngine": ["66b600ce-def5-4d28-a6fc-58dce1cd68cb"],
    "ICloudSyncEngineCallback": ["ad9fb40a-82a8-4c15-bd8d-5944200c2c03"],
    "ICloudSyncPolicyManager": ["05b48acc-9426-11e2-96f0-797e6188709b"],
    "IClrTrksBroker": ["2ac06f23-3274-4224-ae7e-f897edf15fe9"],
    "IClusterDetector": ["3f07f7b7-c680-41d9-9423-915107ec9ff9"],
    "ICmProxyResolver": ["542efef0-28e9-4b84-9adf-a908d2be0abc"],
    "ICmProxyResult": ["d8109ad1-31a0-4dda-831d-b3106a659646"],
    "ICmsAttachedSignature": ["61899d9d-3757-4ecb-bddc-0ca357d7a936"],
    "ICmsAttachedSignatureFactory": ["d0c8fc15-f757-4c64-a362-52cc1c77cffb"],
    "ICmsAttachedSignatureStatics": ["87989c8e-b0ad-498d-a7f5-78b59bce4b36"],
    "ICmsDetachedSignature": ["0f1ef154-f65e-4536-8339-5944081db2ca"],
    "ICmsDetachedSignatureFactory": ["c4ab3503-ae7f-4387-ad19-00f150e48ebb"],
    "ICmsDetachedSignatureStatics": ["3d114cfd-bf9b-4682-9be6-91f57c053808"],
    "ICmsSignerInfo": ["50d020db-1d2f-4c1a-b5c5-d0188ff91f47"],
    "ICmsTimestampInfo": ["2f5f00f2-2c18-4f88-8435-c534086076f5"],
    "ICoCreateLocally": ["03de00aa-f272-41e3-99cb-03c5e8114ea0"],
    "ICoCreatedLocally": ["0a53eb6c-1908-4742-8cff-2cee2e93f94c"],
    "ICodeNavigate": ["6d5140c4-7436-11ce-8034-00aa006009fa"],
    "ICodeNavigate2": ["2702ad60-3459-11d1-88fd-00a0c9110049"],
    "ICodecAPI": ["901db4c7-31ce-41a2-85dc-8fa0bf41b8da"],
    "ICodecInfo": ["51e89f85-ea97-499c-86ac-4ce5e73f3a42"],
    "ICodecQuery": ["222a953a-af61-4e04-808a-a4634e2f3ac4"],
    "ICodecSubtypesStatics": ["a66ac4f2-888b-4224-8cf6-2a8d4eb02382"],
    "ICollectionAnchor": ["84ba9c75-6c22-4590-9bdc-5584eade039e"],
    "ICollectionEventSink": ["ab481469-2d98-42d2-9ddf-9161e8bd44b1"],
    "ICollectionNotify": ["97312c82-d4c2-11d1-b682-00805fc79216"],
    "ICollectionProvider": ["2d2bfaee-31a8-4613-8bc2-bb7c3020f788"],
    "ICollectionStagingManager": ["95a1f9ea-4032-11e3-95fe-65f56188709b"],
    "ICollectionStagingProgressSink": ["ff56a010-ffb0-491e-bdb1-b387cccab33d"],
    "ICollectionStagingState": ["88a9d820-1c0b-4148-89d9-6b1b4784233a"],
    "ICollectionSyncState": ["beb5d41e-0e4f-4915-ba6d-362d052c96fa"],
    "ICollectionSyncStateStore": ["f549f78a-c20d-456a-8c42-a457d5435de6"],
    "ICollectionSyncStateStoreProvider": ["51f07ca4-2bde-42c3-a0a2-379a1b718332"],
    "ICollectionUniqueCount": ["932cb17b-02b9-4adc-964f-54e5eae22582"],
    "ICollectionView": ["8be8bfe4-dbef-44df-8126-a31a89121ddc"],
    "ICollectionViewFactory": ["34d4aaf4-8e72-4950-9192-ecd07d399d0a"],
    "ICollectionViewGroup": ["7e01b9d8-d7b5-48b6-b31c-5bb5bdf5f09b"],
    "ICollectionViewSource": ["a66a1146-d2fb-4ead-be9f-3578a466dcfe"],
    "ICollectionViewSourceStatics": ["173a0710-46af-4c0c-818b-21b6ef81bf65"],
    "IColorAnimation": ["b8ae8a15-0f63-4694-9467-bdafac1253ea"],
    "IColorAnimationStatics": ["55eaf6e2-87e3-4f48-958f-855b2f9ea9ec"],
    "IColorAnimationUsingKeyFrames": ["f5c82640-13c3-42aa-9ae2-7e6b51c92f95"],
    "IColorAnimationUsingKeyFramesStatics": ["b4723cdc-96e9-48f9-8d92-9b648b2f1cc6"],
    "IColorChangedEventArgs": ["34f7201f-aad0-4c3a-b97b-2abf36455539"],
    "IColorDirectory": ["00000303-a8f2-4877-ba0a-fd2b6645fb94"],
    "IColorHelper": ["193cfbe7-65c7-4540-ad08-6283ba76879a"],
    "IColorHelperStatics": ["8504dbea-fb6a-4144-a6c2-33499c9284f5"],
    "IColorHelperStatics2": ["24d9af02-6eb0-4b94-855c-fcf0818d9a16"],
    "IColorKeyFrame": ["b51d82d9-0910-4589-a284-b0c9205858e9"],
    "IColorKeyFrameAnimation": ["93adb5e9-8e05-4593-84a3-dca152781e56"],
    "IColorKeyFrameFactory": ["769bd88a-9cfb-4a7d-96c4-a1e7de6fdb4b"],
    "IColorKeyFrameStatics": ["c043ae99-210c-430f-9da5-df1082692055"],
    "IColorOverrideSettings": ["fbefa134-4a81-4c4d-a5b6-7d1b5c4bd00b"],
    "IColorOverrideSettingsStatics": ["b068e05f-c41f-4ac9-afab-827ab6248f9a"],
    "IColorPaletteResources": ["258088c4-aef2-5d3f-833b-c36db6278ed9"],
    "IColorPaletteResourcesFactory": ["a57f0783-1876-5cc0-8ea5-bc77b17e0f7e"],
    "IColorPicker": ["6232e371-5c64-43cb-8b35-7f82dde36740"],
    "IColorPickerFactory": ["abae07ff-aecf-481d-9204-201c3894cd1b"],
    "IColorPickerSlider": ["94394d83-e0df-4c5f-bbcd-8155f4020440"],
    "IColorPickerSliderAutomationPeer": ["a514215a-7293-4577-924c-47d4e0bf9b90"],
    "IColorPickerSliderAutomationPeerFactory": ["1a55c77e-9dd6-45a3-9042-b40200fea1a9"],
    "IColorPickerSliderFactory": ["06d879a2-8c07-4b1e-a940-9fbce8f49639"],
    "IColorPickerSliderStatics": ["22eafc6a-9fe3-4eee-8734-a1398ec4413a"],
    "IColorPickerStatics": ["67ca9be7-1574-451a-b6df-fe57d9d07b46"],
    "IColorSpectrum": ["ce46f271-f509-4f98-8288-e4942fb385df"],
    "IColorSpectrumAutomationPeer": ["15d5ba03-010d-4ff7-9087-f4dd09f831b7"],
    "IColorSpectrumAutomationPeerFactory": ["0ac400e1-b743-4496-837a-8889e6ac6497"],
    "IColorSpectrumFactory": ["90c7e61e-904d-42ab-b44f-e68dbf0cdee9"],
    "IColorSpectrumStatics": ["906bee7c-2cee-4e90-968b-f0a5bd691b4a"],
    "IColors": ["9b8c9326-4ca6-4ce5-8994-9eff65cabdcc"],
    "IColorsStatics": ["cff52e04-cca6-4614-a17e-754910c84a99"],
    "IColumnDefinition": ["f7f1b229-f024-467f-970a-7e705615db7b"],
    "IColumnDefinitionStatics": ["06b0d728-d044-40c6-942e-ae60eac74851"],
    "IColumnHeader": ["bdd1f051-858b-11d1-b16a-00c0f0283628"],
    "IColumnHeaders": ["bdd1f050-858b-11d1-b16a-00c0f0283628"],
    "IColumnList": ["c92f9791-754f-4205-9d3d-3ec1e04b03f9"],
    "IColumnManager": ["d8ec27bb-3f3b-4042-b10a-4acfd924d453"],
    "IColumnPreference": ["08727c66-4a04-456d-8c9a-cc1f65490753"],
    "IColumnsInfo": ["0c733a11-2a1c-11ce-ade5-00aa0044773d"],
    "IColumnsInfo2": ["0c733ab8-2a1c-11ce-ade5-00aa0044773d"],
    "IColumnsRowset": ["0c733a10-2a1c-11ce-ade5-00aa0044773d"],
    "IComApplInfo": ["000001ec-0000-0000-c000-000000000046"],
    "IComApplInfo2": ["000001e3-0000-0000-c000-000000000046"],
    "IComCatalog": ["000001e0-0000-0000-c000-000000000046"],
    "IComCatalog2": ["000001fa-0000-0000-c000-000000000046"],
    "IComCatalog2Internal": ["3310dab4-edc0-4ce9-8a9c-8fea2980fd89"],
    "IComCatalogInternal": ["a6304910-4115-11d2-8133-0060089f5fed"],
    "IComCatalogLocation": ["fae51051-9887-47f2-af44-7392bf90039b"],
    "IComCatalogSCM": ["000001fd-0000-0000-c000-000000000046"],
    "IComCatalogSettings": ["000001ff-0000-0000-c000-000000000046"],
    "IComClassInfo": ["000001e1-0000-0000-c000-000000000046"],
    "IComClassInfo2": ["000001e4-0000-0000-c000-000000000046"],
    "IComComputerInfo": ["1684441e-e922-4882-863f-4c87138e6423"],
    "IComDispatchInfo": ["000001d9-0000-0000-c000-000000000046"],
    "IComHandlerAction": ["6d2fd252-75c5-4f66-90ba-2a7d8cc3039f"],
    "IComLTxEvents": ["605cf82c-578e-4298-975d-82babcd9e053"],
    "IComObjIdentity": ["000001d7-0000-0000-c000-000000000046"],
    "IComProcessInfo": ["000001ed-0000-0000-c000-000000000046"],
    "IComProcessInfo2": ["6acfc1bf-3882-45b1-96a3-ab948a267d38"],
    "IComProcessInfo3": ["5b0300bc-3a64-4bfe-9a06-ee2bcce72680"],
    "IComServices": ["000001f5-0000-0000-c000-000000000046"],
    "IComServices2": ["61a7d610-42eb-43d2-a55f-1904d3294daa"],
    "IComSoapPublisher": ["d8013eee-730b-45e2-ba24-874b7242c425"],
    "IComWrapper": ["cbd71f2c-6bc5-4932-b851-b93eb3151386"],
    "IComWrapperFactory": ["436b402a-a479-41a8-a093-9713ce3ad111"],
    "IComWrapperFactory2": ["cb4bb619-abd5-459c-ac9f-88844c610bc9"],
    "ICombinedFilterInfo": ["11f9de71-2818-4779-b2ac-42d450565f45"],
    "IComboBox": ["b9a8d05c-ac97-47f1-a5f4-3f9f4d4b116c"],
    "IComboBox2": ["ea0cbf91-ca36-4fad-972a-2e53a6718b9f"],
    "IComboBox3": ["52400a63-476c-4bb6-b781-019324d3fed9"],
    "IComboBox4": ["b7974f49-b05c-47f9-9aaf-d6f9187be5fd"],
    "IComboBox5": ["ab79d646-800a-4a28-969b-34bb8fb458cf"],
    "IComboBox6": ["61aad6a5-81fb-5f87-bae3-369fbe2ea1f3"],
    "IComboBoxAutomationPeer": ["7eb40d0b-75c5-4263-ba6a-d4a54fb0f239"],
    "IComboBoxAutomationPeerFactory": ["098e5b0d-1b90-40b9-9be3-b23267eb13cf"],
    "IComboBoxFactory": ["ac0d0444-a65b-4abd-86df-3016049efedc"],
    "IComboBoxItem": ["993fd6d2-2aae-4f3b-b44d-5648f4d06114"],
    "IComboBoxItemAutomationPeer": ["12ddc76e-9552-446a-82ee-938cc371800f"],
    "IComboBoxItemAutomationPeerFactory": ["134ac7fc-397a-403f-a6ec-1ce8beda15e5"],
    "IComboBoxItemDataAutomationPeer": ["4fef6df2-289c-4c04-831b-5a668c6d7104"],
    "IComboBoxItemDataAutomationPeerFactory": ["14a8d4f6-469a-41ba-9d93-44a1a55da872"],
    "IComboBoxItemFactory": ["8fffe867-d94c-4e87-8fc4-6ebcd63c5ac2"],
    "IComboBoxOverrides": ["4f016541-bcfe-4a22-8932-c914981c2240"],
    "IComboBoxStatics": ["3e14c9b1-d15b-4dc9-8110-cf3a117b96e7"],
    "IComboBoxStatics2": ["93988a11-402c-4b13-96d1-7220266b9220"],
    "IComboBoxStatics3": ["949e140f-ce7f-4e41-bdc5-d1d3388ad0a6"],
    "IComboBoxStatics4": ["d9f58358-f7b0-46ce-8061-ad83ec2f2dd4"],
    "IComboBoxStatics5": ["b802cef1-a264-444a-9a61-aa8867b7a63c"],
    "IComboBoxStatics6": ["516c88e0-ec6b-54ac-8c57-5ec080ee05c8"],
    "IComboBoxTemplateSettings": ["83285c4e-17f6-4aa3-b61b-e87c718604ea"],
    "IComboBoxTemplateSettings2": ["00e90cd7-68be-449d-b5a7-76e26f703e9b"],
    "IComboBoxTextSubmittedEventArgs": ["cb698cbb-6879-558e-af82-df1d08f62afa"],
    "IComboItem": ["dd9da660-8594-11d1-b16a-00c0f0283628"],
    "IComboItems": ["dd9da662-8594-11d1-b16a-00c0f0283628"],
    "ICommDlgBrowser3": ["c8ad25a1-3294-41ee-8165-71174bd01c57"],
    "ICommand": ["0c733a63-2a1c-11ce-ade5-00aa0044773d", "e5af3542-ca67-4081-995b-709dd13792df"],
    "ICommandBar": ["98bc4280-4a3d-4cee-bd07-22ce94c5af76"],
    "ICommandBar2": ["57662f58-5b32-475d-be64-4ca36e7b97d4"],
    "ICommandBar3": ["40ebbc23-2a79-48b3-9a67-649b852d8589"],
    "ICommandBarButtonEvents": ["55f88890-7708-11d1-aceb-006008961da5"],
    "ICommandBarComboBoxEvents": ["55f88896-7708-11d1-aceb-006008961da5"],
    "ICommandBarElement": ["67918e1b-f2d5-44d1-8b84-92b87f80a350"],
    "ICommandBarElement2": ["a9bf1236-4402-4688-b987-9d2b9b7bf2bd"],
    "ICommandBarFactory": ["67bdeb44-20e1-4177-ad44-f617b374e8e8"],
    "ICommandBarFlyout": ["fecd2c4d-f16a-58cd-8aca-db0f046f25c3"],
    "ICommandBarFlyoutCommandBar": ["14146e7c-38c4-55c4-b706-ce18f6061e7e"],
    "ICommandBarFlyoutCommandBarFactory": ["f8236f9f-5559-5697-8e6f-20d70ca17dd0"],
    "ICommandBarFlyoutCommandBarTemplateSettings": ["47642c44-26ff-5d14-9cfc-77dc64f3a447"],
    "ICommandBarFlyoutFactory": ["dd6441b3-6df1-593d-b80c-daf5c1daee41"],
    "ICommandBarOverflowPresenter": ["6e7a9427-58ef-4366-a017-18c193d56b14"],
    "ICommandBarOverflowPresenterFactory": ["8323f774-5aaa-4049-b78f-218c6a19c37e"],
    "ICommandBarStatics": ["5bd981ea-e278-409c-b522-f946ca253b44"],
    "ICommandBarStatics2": ["3d9ec8e3-51a9-4e34-956c-7081d06f26f8"],
    "ICommandBarStatics3": ["b45a24a4-8af1-4843-b319-e03fc45ab726"],
    "ICommandBarTemplateSettings": ["61c8f92c-05aa-414a-a2ae-482c5a46c08e"],
    "ICommandBarTemplateSettings2": ["fbb24f93-c2e2-4177-a2b6-3cd705073cf6"],
    "ICommandBarTemplateSettings3": ["3bd71eba-3403-4bfe-842d-2ce8c511d245"],
    "ICommandBarTemplateSettings4": ["f2562dd3-aa58-59c5-853b-828a19d1214e"],
    "ICommandBarsEvents": ["55f88892-7708-11d1-aceb-006008961da5"],
    "ICommandButtonInfo": ["8a49a5ea-5e80-46d0-8506-285496e4592e"],
    "ICommandCollection": ["156a0971-f6e2-4767-b7ce-d33e2798037e"],
    "ICommandCost": ["0c733a4e-2a1c-11ce-ade5-00aa0044773d"],
    "ICommandDescriptor": ["0323648f-ff62-48cc-a9de-abbda1550caa"],
    "ICommandDescriptorEx": ["768b08be-40a0-44be-a52c-65211d3f93a8"],
    "ICommandExtManager": ["25a161e8-96fb-49f5-af56-93b4bae5a01b"],
    "ICommandLineActivatedEventArgs": ["4506472c-006a-48eb-8afb-d07ab25e3366"],
    "ICommandLineActivationOperation": ["994b2841-c59e-4f69-bcfd-b61ed4e622eb"],
    "ICommandPersist": ["0c733aa7-2a1c-11ce-ade5-00aa0044773d"],
    "ICommandPrepare": ["0c733a26-2a1c-11ce-ade5-00aa0044773d"],
    "ICommandProperties": ["0c733a79-2a1c-11ce-ade5-00aa0044773d"],
    "ICommandSearch": ["48b37235-b7e4-4617-a3f1-d5bb6ad5d78f"],
    "ICommandStream": ["0c733abf-2a1c-11ce-ade5-00aa0044773d"],
    "ICommandText": ["0c733a27-2a1c-11ce-ade5-00aa0044773d"],
    "ICommandTree": ["0c733a87-2a1c-11ce-ade5-00aa0044773d"],
    "ICommandValidate": ["0c733a18-2a1c-11ce-ade5-00aa0044773d"],
    "ICommandWithParameters": ["0c733a64-2a1c-11ce-ade5-00aa0044773d"],
    "ICommonClaimedPosPrinterStation": ["b7eb66a8-fe8a-4cfb-8b42-e35b280cb27c"],
    "ICommonLayoutDefinition": ["d72ff553-ae8f-4dae-9ee8-833a9e025cb0"],
    "ICommonLayoutModifier": ["d783f427-3c66-4cff-87b6-b0db2305736c"],
    "ICommonNavigationTransitionInfo": ["50345692-a555-4624-a361-0a91c1706473"],
    "ICommonNavigationTransitionInfoStatics": ["1e3efe33-50be-4443-883c-e5627201c2e5"],
    "ICommonPosPrintStationCapabilities": ["de5b52ca-e02e-40e9-9e5e-1b488e6aacfc"],
    "ICommonReceiptSlipCapabilities": ["09286b8b-9873-4d05-bfbe-4727a6038f69"],
    "ICommunicationBlockingAccessManagerStatics": ["1c969998-9d2a-5db7-edd5-0ce407fc2595"],
    "ICommunicationBlockingAppManagerStatics": ["77db58ec-14a6-4baa-942a-6a673d999bf2"],
    "ICommunicationBlockingAppSetAsActiveTrigger": ["fb91f28a-16a5-486d-974c-7835a8477be2"],
    "ICompactOverlayBroker": ["173c883a-9329-4c9e-a204-94c620ee69a3"],
    "ICompactOverlayPresentationConfiguration": ["a7e5750f-5730-56c6-8e1f-d63ff4d7980d"],
    "IComparableConcept": ["a7830646-9f0c-4a31-ba19-503f33e6c8a3"],
    "ICompass": ["292ffa94-1b45-403c-ba06-b106dba69a64"],
    "ICompass2": ["36f26d09-c7d7-434f-b461-979ddfc2322f"],
    "ICompass3": ["a424801b-c5ea-4d45-a0ec-4b791f041a89"],
    "ICompass4": ["291e7f11-ec32-5dcc-bfcb-0bb39eba5774"],
    "ICompassDataThreshold": ["d15b52b3-d39d-5ec8-b2e4-f193e6ab34ed"],
    "ICompassDeviceId": ["d181ca29-b085-4b1d-870a-4ff57ba74fd4"],
    "ICompassReading": ["82911128-513d-4dc9-b781-5eedfbf02d0c"],
    "ICompassReading2": ["b13a661e-51bb-4a12-bedd-ad47ff87d2e8"],
    "ICompassReadingChangedEventArgs": ["8f1549b0-e8bc-4c7e-b009-4e41df137072"],
    "ICompassReadingHeadingAccuracy": ["e761354e-8911-40f7-9e16-6ecc7daec5de"],
    "ICompassStatics": ["9abc97df-56ec-4c25-b54d-40a68bb5b269"],
    "ICompassStatics2": ["0ace0ead-3baa-4990-9ce4-be0913754ed2"],
    "ICompatContextMenu": ["4b11d5ae-62f5-4ce2-9767-c54aa2eba7b3"],
    "IComponentActivation": ["70df5e3a-726c-4b53-818d-fa24a8292132"],
    "IComponentAuthenticate": ["a9889c00-6d2b-11d3-8496-00c04f79dbc0"],
    "IComponentConnector": ["f6790987-e6e5-47f2-92c6-eccce4ba159a"],
    "IComponentConnector2": ["dc8f368b-eccc-498e-b139-91142254d7ae"],
    "IComponentHandles": ["d4ca8951-1981-4813-b663-4df5afd111fd"],
    "IComponentLoadFailedEventArgs": ["95972e93-7746-417e-8495-f031bbc5862c"],
    "IComponentLoadFailedEventHandler": ["95da643c-6db9-424b-86ca-091af432081c"],
    "IComponentReceiveHandle": ["c697bd11-01e0-4fc0-b6ff-1934243a02ee"],
    "IComponentRegistrarControl": ["6e803fc2-a423-11d2-b943-00c04f79d22f"],
    "IComponentRenewalStatics": ["6ffbcd67-b795-48c5-8b7b-a7c4efe202e3"],
    "IComponentSitePrivate": ["4f43b367-57d8-4e5b-94e2-805fee4e1faa"],
    "IComponentType": ["6a340dc0-0311-11d3-9d8e-00c04f72d980"],
    "IComponentTypes": ["0dc13d4a-0313-11d3-9d8e-00c04f72d980"],
    "IComponentUIExperienceBroker": ["7d0a51a2-edd8-43ac-88e0-8c37279db21a"],
    "IComponentUIPlugin": ["9f0f63f2-6657-4dfd-92ae-ef7abc80fddd"],
    "IComponentUtil": ["6eb22873-8a19-11d0-81b6-00a0c9231c29"],
    "IComponents": ["39a48091-fffe-4182-a161-3ff802640e26"],
    "IComponentsOld": ["fcd01846-0e19-11d3-9d8e-00c04f72d980"],
    "ICompositeTransform": ["c8a4385b-f24a-4701-a265-a78846f142b9"],
    "ICompositeTransform3D": ["8977cb01-af8d-4af5-b084-c08eb9704abe"],
    "ICompositeTransform3DStatics": ["ddbf4d67-2a25-48f3-9808-c51ec3d55bec"],
    "ICompositeTransformStatics": ["2f190c08-8266-496f-9653-a18bd4f836aa"],
    "ICompositeVideoFrameContext": ["6c30024b-f514-4278-a5f7-b9188049d110"],
    "ICompositionAnimation": ["464c4c2c-1caa-4061-9b40-e13fde1503ca"],
    "ICompositionAnimation2": ["369b603e-a80f-4948-93e3-ed23fb38c6cb"],
    "ICompositionAnimation3": ["d51e030d-7da4-4bd7-bc2d-f4517529f43a"],
    "ICompositionAnimation4": ["770137be-76bc-4e23-bfed-fe9cc20f6ec9"],
    "ICompositionAnimationBase": ["1c2c2999-e818-48d3-a6dd-d78c82f8ace9"],
    "ICompositionAnimationFactory": ["10f6c4fb-6e51-4c25-bbd3-586a9bec3ef4"],
    "ICompositionAnimationGroup": ["5e7cc90c-cd14-4e07-8a55-c72527aabdac"],
    "ICompositionBackdropBrush": ["c5acae58-3898-499e-8d7f-224e91286a5d"],
    "ICompositionBatchCompletedEventArgs": ["0d00dad0-9464-450a-a562-2e2698b0a812"],
    "ICompositionBrush": ["ab0d7608-30c0-40e9-b568-b60a6bd1fb46"],
    "ICompositionBrushFactory": ["da53fb4c-4650-47c4-ad76-765379607ed6"],
    "ICompositionCapabilities": ["8253353e-b517-48bc-b1e8-4b3561a2e181"],
    "ICompositionCapabilitiesStatics": ["f7b7a86e-6416-49e5-8ddf-afe949e20562"],
    "ICompositionClip": ["1ccd2a52-cfc7-4ace-9983-146bb8eb6a3c"],
    "ICompositionClip2": ["5893e069-3516-40e1-89e0-5ba924927235"],
    "ICompositionClipFactory": ["b9484caf-20c7-4aed-ac4a-9c78ba1302cf"],
    "ICompositionColorBrush": ["2b264c5e-bf35-4831-8642-cf70c20fff2f"],
    "ICompositionColorGradientStop": ["6f00ca92-c801-4e41-9a8f-a53e20f57778"],
    "ICompositionColorGradientStopCollection": ["9f1d20ec-7b04-4b1d-90bc-9fa32c0cfd26"],
    "ICompositionCommitBatch": ["0d00dad0-ca07-4400-8c8e-cb5db08559cc"],
    "ICompositionConditionalValue": ["43250538-eb73-4561-a71d-1a43eaeb7a9b"],
    "ICompositionConditionalValueStatics": ["090c4b72-8467-4d0a-9065-ac46b80a5522"],
    "ICompositionContainerShape": ["4f5e859b-2e5b-44a8-982c-aa0f69c16059"],
    "ICompositionDebugHeatMaps": ["e49c90ac-2ff3-5805-718c-b725ee07650f"],
    "ICompositionDebugSettings": ["2831987e-1d82-4d38-b7b7-efd11c7bc3d1"],
    "ICompositionDebugSettingsStatics": ["64ec1f1e-6af8-4af8-b814-c870fd5a9505"],
    "ICompositionDrawingSurface": ["a166c300-fad0-4d11-9e67-e433162ff49e"],
    "ICompositionDrawingSurface2": ["fad0e88b-e354-44e8-8e3d-c4880d5a213f"],
    "ICompositionDrawingSurfaceFactory": ["9497b00a-312d-46b9-9db3-412fd79464c8"],
    "ICompositionEasingFunction": ["5145e356-bf79-4ea8-8cc2-6b5b472e6c9a"],
    "ICompositionEasingFunctionFactory": ["60840774-3da0-4949-8200-7206c00190a0"],
    "ICompositionEffectBrush": ["bf7f795e-83cc-44bf-a447-3e3c071789ec"],
    "ICompositionEffectFactory": ["be5624af-ba7e-4510-9850-41c0b4ff74df"],
    "ICompositionEffectSourceParameter": ["858ab13a-3292-4e4e-b3bb-2b6c6544a6ee"],
    "ICompositionEffectSourceParameterFactory": ["b3d9f276-aba3-4724-acf3-d0397464db1c"],
    "ICompositionEllipseGeometry": ["4801f884-f6ad-4b93-afa9-897b64e57b1f"],
    "ICompositionGeometricClip": ["c840b581-81c9-4444-a2c1-ccaece3a50e5"],
    "ICompositionGeometry": ["e985217c-6a17-4207-abd8-5fd3dd612a9d"],
    "ICompositionGeometryFactory": ["bffebfe1-8c25-480b-9f56-fed6b288055d"],
    "ICompositionGradientBrush": ["1d9709e0-ffc6-4c0e-a9ab-34144d4c9098"],
    "ICompositionGradientBrush2": ["899dd5a1-b4c7-4b33-a1b6-264addc26d10"],
    "ICompositionGradientBrushFactory": ["56d765d7-f189-48c9-9c8d-94daf1bec010"],
    "ICompositionGraphicsDevice": ["fb22c6e1-80a2-4667-9936-dbeaf6eefe95"],
    "ICompositionGraphicsDevice2": ["0fb8bdf6-c0f0-4bcc-9fb8-084982490d7d"],
    "ICompositionGraphicsDevice3": ["37f67514-d3ef-49d1-b69d-0d8eabeb3626"],
    "ICompositionInteractionSource": ["043b2431-06e3-495a-ba54-409f0017fac0"],
    "ICompositionInteractionSourceCollection": ["1b468e4b-a5bf-47d8-a547-3894155a158c"],
    "ICompositionLight": ["41a6d7c2-2e5d-4bc1-b09e-8f0a03e3d8d3"],
    "ICompositionLight2": ["a7bcda72-f35d-425d-9b98-23f4205f6669"],
    "ICompositionLight3": ["4b0b00e4-df07-4959-b7a4-4f7e4233f838"],
    "ICompositionLightFactory": ["069cf306-da3c-4b44-838a-5e03d51ace55"],
    "ICompositionLineGeometry": ["dd7615a4-0c9a-4b67-8dce-440a5bf9cdec"],
    "ICompositionLinearGradientBrush": ["983bc519-a9db-413c-a2d8-2a9056fc525e"],
    "ICompositionMaskBrush": ["522cf09e-be6b-4f41-be49-f9226d471b4a"],
    "ICompositionMipmapSurface": ["4863675c-cf4a-4b1c-9ece-c5ec0c2b2fe6"],
    "ICompositionNineGridBrush": ["f25154e4-bc8c-4be7-b80f-8685b83c0186"],
    "ICompositionObject": ["bcb4ad45-7609-4550-934f-16002a68fded"],
    "ICompositionObject2": ["ef874ea1-5cff-4b68-9e30-a1519d08ba03"],
    "ICompositionObject3": ["4bc27925-dacd-4cf2-98b1-986b76e7ebe6"],
    "ICompositionObject4": ["0bb3784c-346b-4a7c-966b-7310966553d5"],
    "ICompositionObjectFactory": ["51205c5e-558a-4f2a-8d39-37bfe1e20ddd"],
    "ICompositionObjectStatics": ["c1ed052f-1ba2-44ba-a904-6a882a0a5adb"],
    "ICompositionPath": ["66da1d5f-2e10-4f22-8a06-0a8151919e60"],
    "ICompositionPathFactory": ["9c1e8c6a-0f33-4751-9437-eb3fb9d3ab07"],
    "ICompositionPathGeometry": ["0b6a417e-2c77-4c23-af5e-6304c147bb61"],
    "ICompositionProcessor": ["ea69859a-db5b-4c4a-8a8f-ae9759027534"],
    "ICompositionProjectedShadow": ["285b8e72-4328-523f-bcf2-5557c52c3b25"],
    "ICompositionProjectedShadowCaster": ["b1d7d426-1e36-5a62-be56-a16112fdd148"],
    "ICompositionProjectedShadowCasterCollection": ["d2525c0c-e07f-58a3-ac91-37f73ee91740"],
    "ICompositionProjectedShadowCasterCollectionStatics": ["56fbb136-e94f-5299-ab5b-6e15e38bd899"],
    "ICompositionProjectedShadowReceiver": ["1377985a-6a49-536a-9be4-a96a8e5298a9"],
    "ICompositionProjectedShadowReceiverUnorderedCollection": ["02b3e3b7-27d2-599f-ac4b-ab787cdde6fd"],
    "ICompositionPropertySet": ["c9d6d202-5f67-4453-9117-9eadd430d3c2"],
    "ICompositionPropertySet2": ["de80731e-a211-4455-8880-7d0f3f6a44fd"],
    "ICompositionRadialGradientBrush": ["3d3b50c5-e3fa-4ce2-b9fc-3ee12561788f"],
    "ICompositionRectangleGeometry": ["0cd51428-5356-4246-aecf-7a0b76975400"],
    "ICompositionRoundedRectangleGeometry": ["8770c822-1d50-4b8b-b013-7c9a0e46935f"],
    "ICompositionScopedBatch": ["0d00dad0-fb07-46fd-8c72-6280d1a3d1dd"],
    "ICompositionShadow": ["329e52e2-4335-49cc-b14a-37782d10f0c4"],
    "ICompositionShadowFactory": ["221f492f-dcba-4b91-999e-1dc217a01530"],
    "ICompositionShape": ["b47ce2f7-9a88-42c4-9e87-2e500ca8688c"],
    "ICompositionShapeFactory": ["1dfc36d0-b05a-44ef-82b0-12118bcd4cd0"],
    "ICompositionSpriteShape": ["401b61bb-0007-4363-b1f3-6bcc003fb83e"],
    "ICompositionSurface": ["1527540d-42c7-47a6-a408-668f79a90dfb"],
    "ICompositionSurfaceBrush": ["ad016d79-1e4c-4c0d-9c29-83338c87c162"],
    "ICompositionSurfaceBrush2": ["d27174d5-64f5-4692-9dc7-71b61d7e5880"],
    "ICompositionSurfaceBrush3": ["550bb289-1fe0-42e5-8195-1eefa87ff08e"],
    "ICompositionTarget": ["26cfbff0-713c-4bec-8803-e101f7b14ed3", "a1bea8ba-d726-4663-8129-6b5e7927ffa6"],
    "ICompositionTargetFactory": ["93cd9d2b-8516-4b14-a8ce-f49e2119ec42"],
    "ICompositionTargetStatics": ["2b1af03d-1ed2-4b59-bd00-7594ee92832b"],
    "ICompositionTargetStatics3": ["bc0a7cd9-6750-4708-994c-2028e0312ac8"],
    "ICompositionTransform": ["7cd54529-fbed-4112-abc5-185906dd927c"],
    "ICompositionTransformFactory": ["aaaeca26-c149-517a-8f72-6bff7a65ce08"],
    "ICompositionViewBox": ["b440bf07-068f-4537-84c6-4ecbe019e1f4"],
    "ICompositionVirtualDrawingSurface": ["a9c384db-8740-4f94-8b9d-b68521e7863d"],
    "ICompositionVirtualDrawingSurfaceFactory": ["6766106c-d56b-4a49-b1df-5076a0620768"],
    "ICompositionVisualSurface": ["b224d803-4f6e-4a3f-8cae-3dc1cda74fc6"],
    "ICompositor": ["b403ca50-7f8c-4e83-985f-cc45060036d8"],
    "ICompositor2": ["735081dc-5e24-45da-a38f-e32cc349a9a0"],
    "ICompositor3": ["c9dd8ef0-6eb1-4e3c-a658-675d9c64d4ab"],
    "ICompositor4": ["ae47e78a-7910-4425-a482-a05b758adce9"],
    "ICompositor5": ["48ea31ad-7fcd-4076-a79c-90cc4b852c9b"],
    "ICompositor6": ["7a38b2bd-cec8-4eeb-830f-d8d07aedebc3"],
    "ICompositorController": ["2d75f35a-70a7-4395-ba2d-cef0b18399f9"],
    "ICompositorStatics": ["080db93e-121e-4d97-8b74-1dfcf91987ea"],
    "ICompositorWithProjectedShadow": ["a2e6330e-8a60-5a38-bb85-b44ea901677c"],
    "ICompositorWithRadialGradient": ["98b9c1a7-8e71-4b53-b4a8-69ba5d19dc5b"],
    "ICompositorWithVisualSurface": ["cfa1658b-0123-4551-8891-89bdcc40322b"],
    "IComprehensiveSpellCheckProvider": ["0c58f8de-8e94-479e-9717-70c42c4ad2c3"],
    "ICompressor": ["0ac3645a-57ac-4ee1-b702-84d39d5424e0"],
    "ICompressorFactory": ["5f3d96a4-2cfb-442c-a8ba-d7d11b039da0"],
    "IComputerAccountNotify": ["f0009734-e8de-48e5-b603-bfa5966a8f7c"],
    "IComputerAccounts": ["3c708557-c99d-4fa3-9231-56518418b4e4"],
    "IComputerAccounts2": ["fde873d4-e2de-427c-89bd-c234b5f2dc43"],
    "IComputerAccountsEnumerationOption": ["6584ab60-75df-46ce-a8ca-fe0ea7882370"],
    "IComputerInfoAdvise": ["4623bd61-5603-444f-824a-aaebceed93fa"],
    "IComputerInfoChangeNotify": ["0df60d92-6818-46d6-b358-d66170dde466"],
    "ICondition": ["0fc988d4-c935-4b97-a973-46282ea175c8"],
    "ICondition2": ["0db8851d-2e5b-47eb-9208-d28c325a01d7"],
    "IConditionFactory": ["a5efe073-b16f-474f-9f3e-9f8b497a3e08"],
    "IConditionFactory2": ["71d222e1-432f-429e-8c13-b6dafde5077a"],
    "IConditionForceEffect": ["32d1ea68-3695-4e69-85c0-cd1944189140"],
    "IConditionForceEffectFactory": ["91a99264-1810-4eb6-a773-bfd3b8cddbab"],
    "IConditionGenerator": ["92d2cc58-4386-45a3-b98c-7e0ce64a4117"],
    "IConfigAsfWriter": ["45086030-f7e4-486a-b504-826bb5792a3b"],
    "IConfigAsfWriter2": ["7989ccaa-53f0-44f0-884a-f3b03f6ae066"],
    "IConfiguration": ["cd000022-8b95-11d1-82db-00c04fb1625d"],
    "IConfigurationDataCollector": ["03837514-098b-11d8-9414-505054503030"],
    "IConfigureHostedCoreWindow": ["34e7b726-59fc-4ace-a7cd-d4ad43a0751f"],
    "IConfigureRetailDemoInternal": ["0e64bb19-ed60-458d-a97f-e65843ad2bc2"],
    "IConfigureWindowFactory": ["601d51e3-801e-49c9-bbfa-fe29a662aead"],
    "IConfigureWindowFactory2": ["dbcc81cc-d31a-4e70-9632-fc3fdd4325c0"],
    "IConfirmOnlyAssociationResponse": ["6bbc32a7-290f-4bce-888a-4b1b42b59952"],
    "IConfirmPinMatchAssociationResponse": ["f869dea6-824d-4f26-b594-deccb2a44ecd"],
    "IConfirmationInterrupt": ["47e7bb4d-2d83-4604-905c-0ee8eab077a4"],
    "IConflictDialogData": ["106fe53d-7a09-42d0-862a-cc5b126e979a"],
    "IConflictDialogDataResponse": ["caaaca0f-9b02-4565-b3c5-9b20fc4da566"],
    "IConflictInterrupt": ["6faf1156-8855-47b5-bdc8-4555d13c095f"],
    "IConflictInterruptFilter": ["cd904a72-e610-47b1-af43-2e47adb17c70"],
    "IConflictItemDataCallback": ["c7c67cb1-44ae-4e71-9e69-2c92f8d732fc"],
    "IConflictOperationScheduler": ["6b1aa9d9-a942-432d-904d-f215fd09f1c6"],
    "IConnectableCredentialProviderCredential": ["9387928b-ac75-4bf9-8ab2-2b93c4a55290"],
    "IConnectedAccountServices": ["ec242d06-492e-4a29-9757-0e84dd7852c0"],
    "IConnectedAccountServicesFactory": ["e07a4796-33a3-4b2c-9584-c5411f166a2a"],
    "IConnectedAccountStateChange": ["b5b0b6cf-ea52-4922-9376-695634758329"],
    "IConnectedAccountStatus": ["b09911a6-44de-42db-81fb-70411c593cd9"],
    "IConnectedAccountStatusEvents": ["939e6c49-eef5-4fd5-ab5e-ea1f13e424f9"],
    "IConnectedAnimation": ["3518628c-f387-4c25-ac98-44e86c3cadf0"],
    "IConnectedAnimation2": ["5d2f8e5c-584b-4ddd-b668-973891431459"],
    "IConnectedAnimation3": ["6e3040c6-0430-59c0-a80c-cceed2e778dd"],
    "IConnectedAnimationConfiguration": ["00218aae-cd8c-5651-92a0-c1db95c03998"],
    "IConnectedAnimationConfigurationFactory": ["30f9b84b-dd7e-593e-bf75-e959dc0ec52a"],
    "IConnectedAnimationService": ["1c6875c9-19bb-4d47-b9aa-66c802dcb9ff"],
    "IConnectedAnimationServiceStatics": ["c7078ea5-d688-40e8-8f90-96a6279273d2"],
    "IConnectedIdentityProvider": ["b7417b54-e08c-429b-96c8-678d1369ecb1"],
    "IConnectedSearchRegionInfo": ["ce41758b-10c6-4880-8275-3ed1bd9d4cfb"],
    "IConnectedSearchSettingsManager": ["20cde598-4740-410c-a167-98b764ffcb19"],
    "IConnectedSharePlatform": ["a8a81ca8-3d93-416f-b1f9-08113f0b873e"],
    "IConnectedUser": ["9d5f2149-de8c-45f2-b313-6587a04f771d"],
    "IConnectedUserStore": ["9ec044bc-b01d-4c18-8634-59bd3ff5dcc1"],
    "IConnectionCost": ["bad7d829-3416-4b10-a202-bac0b075bdae"],
    "IConnectionCost2": ["8e113a05-e209-4549-bb25-5e0db691cb05"],
    "IConnectionCreatedCallback": ["4bfddeb8-130e-41d1-8e6e-670e469dc9cd"],
    "IConnectionFactory": ["6fe2b64c-5012-4b88-bb9d-7ce4f45e3751"],
    "IConnectionManagerCallbacks2": ["5911f583-53a1-4c74-8592-6312178c3a14"],
    "IConnectionManagerFactory": ["a6311d38-813c-46c8-9929-89d3b6e14515"],
    "IConnectionManagerUI": ["007c9001-33be-46b7-b86c-eff659c26d4b"],
    "IConnectionManagerUICategory": ["007c9002-33be-46b7-b86c-eff659c26d4b"],
    "IConnectionManagerUIItem": ["66e03284-572f-4834-bb1a-1e5423de2b3c"],
    "IConnectionManagerUIItemContextMenu": ["d3a80e73-0ebd-40bd-859a-1429e0c3204e"],
    "IConnectionManagerUIQueue": ["007c9053-33be-46b7-b86c-eff659c26d4b"],
    "IConnectionProfile": ["71ba143c-598e-49d0-84eb-8febaedcc195"],
    "IConnectionProfile2": ["e2045145-4c9f-400c-9150-7ec7d6e2888a"],
    "IConnectionProfile3": ["578c2528-4cd9-4161-8045-201cfd5b115c"],
    "IConnectionProfile4": ["7a2d42cd-81e0-4ae6-abed-ab9ca13eb714"],
    "IConnectionProfile5": ["85361ec7-9c73-4be0-8f14-578eec71ee0e"],
    "IConnectionProfileFilter": ["204c7cc8-bd2d-4e8d-a4b3-455ec337388a"],
    "IConnectionProfileFilter2": ["cd068ee1-c3fc-4fad-9ddc-593faa4b7885"],
    "IConnectionProfileFilter3": ["0aaa09c0-5014-447c-8809-aee4cb0af94a"],
    "IConnectionProvider": ["9a7ddec7-6e6d-11df-86f8-18a905160fe0"],
    "IConnectionProvider2": ["bb130446-f2cc-4e8f-a303-71093415e323"],
    "IConnectionProviderEvents": ["46938fd0-251f-4231-ae8f-a16d80b934d5"],
    "IConnectionRequestCallback": ["272c9ae0-7161-4ae0-91bd-9f448ee9c427"],
    "IConnectionRequestedEventArgs": ["eb6891ae-4f1e-4c66-bd0d-46924a942e08"],
    "IConnectionSession": ["ff905d4c-f83b-41b0-8a0c-1462d9c56b73"],
    "IConnectionStatusHandler": ["b571c28c-a472-48d5-88d2-8adcaf1b8813"],
    "IConnectivityInterval": ["4faa3fff-6746-4824-a964-eed8e87f8709"],
    "IConnectivityManagerStatics": ["5120d4b1-4fb1-48b0-afc9-42e0092a8164"],
    "IConnector": ["9c2c4058-23f5-41de-877a-df3af236a09e"],
    "IConstantForceEffect": ["9bfa0140-f3c7-415c-b068-0f068734bce0"],
    "IConstraintConflict": ["00d2302e-1cf8-4835-b85f-b7ca4f799e0a"],
    "IConstructReplicaKeyMap": ["ded10970-ec85-4115-b52c-4405845642a5"],
    "IConstructString": ["000001f9-0000-0000-c000-000000000046"],
    "IContact": ["ec0072f3-2118-4049-9ebc-17f0ab692b64", "f941b671-bda7-4f77-884a-f46462f226a7"],
    "IContact2": ["f312f365-bb77-4c94-802d-8328cee40c08"],
    "IContact3": ["48201e67-e08e-42a4-b561-41d08ca9575d"],
    "IContactActivatedEventArgs": ["d627a1c4-c025-4c41-9def-f1eafad075e7"],
    "IContactAddress": ["9739d39a-42ce-4872-8d70-3063aa584b70"],
    "IContactAddressMarshal": ["cc3088b9-45e7-462f-8bea-6a3ffd87db74"],
    "IContactAggregationAggregate": ["7ed1c814-cd30-43c8-9b8d-2e489e53d54b"],
    "IContactAggregationAggregateCollection": ["2359f3a6-3a68-40af-98db-0f9eb143c3bb"],
    "IContactAggregationContact": ["1eb22e86-4c86-41f0-9f9f-c251e9fda6c3"],
    "IContactAggregationContactCollection": ["826e66fa-81de-43ca-a6fb-8c785cd996c6"],
    "IContactAggregationGroup": ["c93c545f-1284-499b-96af-07372af473e0"],
    "IContactAggregationGroupCollection": ["20a19a9c-d2f3-4b83-9143-beffd2cc226d"],
    "IContactAggregationLink": ["b6813323-a183-4654-8627-79b30de3a0ec"],
    "IContactAggregationLinkCollection": ["f8bc0e93-fb55-4f28-b9fa-b1c274153292"],
    "IContactAggregationManager": ["1d865989-4b1f-4b60-8f34-c2ad468b2b50"],
    "IContactAggregationServerPerson": ["7fdc3d4b-1b82-4334-85c5-25184ee5a5f2"],
    "IContactAggregationServerPersonCollection": ["4f730a4a-6604-47b6-a987-669ecf1e5751"],
    "IContactAnnotation2": ["b691ecf3-4ab7-4a1f-9941-0c9cf3171b75"],
    "IContactAnnotationList": ["92a486aa-5c88-45b9-aad0-461888e68d8a"],
    "IContactAnnotationStore": ["23acf4aa-7a77-457d-8203-987f4b31af09"],
    "IContactAnnotationStore2": ["7ede23fd-61e7-4967-8ec5-bdf280a24063"],
    "IContactBatch": ["35d1972d-bfce-46bb-93f8-a5b06ec5e201"],
    "IContactCallActivatedEventArgs": ["c2df14c7-30eb-41c6-b3bc-5b1694f9dab3"],
    "IContactCardDelayedDataLoader": ["b60af902-1546-434d-869c-6e3520760ef3"],
    "IContactCardOptions": ["8c0a4f7e-6ab6-4f3f-be72-817236eeea5b"],
    "IContactCardOptions2": ["8f271ba0-d74b-4cc6-9f53-1b0eb5d1273c"],
    "IContactChange": ["951d4b10-6a59-4720-a4e1-363d98c135d5"],
    "IContactChangeReader": ["217319fa-2d0c-42e0-a9da-3ecd56a78a47"],
    "IContactChangeTracker": ["6e992952-309b-404d-9712-b37bd30278aa"],
    "IContactChangeTracker2": ["7f8ad0fc-9321-4d18-9c09-d708c63fcd31"],
    "IContactChangedDeferral": ["c5143ae8-1b03-46f8-b694-a523e83cfcb6"],
    "IContactChangedEventArgs": ["525e7fd1-73f3-4b7d-a918-580be4366121"],
    "IContactCollection": ["b6afa338-d779-11d9-8bde-f66bad1e3f3a"],
    "IContactConnectedServiceAccount": ["f6f83553-aa27-4731-8e4a-3dec5ce9eec9"],
    "IContactConnectedServiceAccountMarshal": ["28072957-925d-11e2-9952-b4b52fe06527"],
    "IContactContentLinkProvider": ["f92fd29b-589b-4abd-9d37-35a1468f021e"],
    "IContactDataProviderConnection": ["1a398a52-8c9d-4d6f-a4e0-111e9a125a30"],
    "IContactDataProviderConnection2": ["a1d327b0-196c-4bfd-8f0f-c68d67f249d3"],
    "IContactDataProviderTriggerDetails": ["527104be-3c62-43c8-9ae7-db531685cd99"],
    "IContactDate": ["fe98ae66-b205-4934-9174-0ff2b0565707"],
    "IContactDateMarshal": ["28072955-925d-11e2-9952-b4b52fe06527"],
    "IContactEmail": ["90a219a9-e3d3-4d63-993b-05b9a5393abf"],
    "IContactEmailMarshal": ["28072954-925d-11e2-9952-b4b52fe06527"],
    "IContactField": ["b176486a-d293-492c-a058-db575b3e3c0f"],
    "IContactFieldFactory": ["85e2913f-0e4a-4a3e-8994-406ae7ed646e"],
    "IContactGroup": ["59bdeb01-9e9a-475d-bfe5-a37b806d852c"],
    "IContactInformation": ["275eb6d4-6a2e-4278-a914-e460d5f088f6"],
    "IContactInstantMessageField": ["cce33b37-0d85-41fa-b43d-da599c3eb009"],
    "IContactInstantMessageFieldFactory": ["ba0b6794-91a3-4bb2-b1b9-69a5dff0ba09"],
    "IContactInternal": ["896ab8bf-b6c5-444a-a5f3-ffd4f71f69ba"],
    "IContactJobInfo": ["6d117b4c-ce50-4b43-9e69-b18258ea5315"],
    "IContactJobInfoMarshal": ["28072956-925d-11e2-9952-b4b52fe06527"],
    "IContactLaunchActionVerbsStatics": ["fb1232d6-ee73-46e7-8761-11cd0157728f"],
    "IContactList": ["16ddec75-392c-4845-9dfb-51a3e7ef3e42"],
    "IContactList2": ["cb3943b4-4550-4dcb-9229-40ff91fb0203"],
    "IContactList3": ["1578ee57-26fc-41e8-a850-5aa32514aca9"],
    "IContactListCreateOrUpdateContactRequest": ["b4af411f-c849-47d0-b119-91cf605b2f2a"],
    "IContactListCreateOrUpdateContactRequestEventArgs": ["851c1690-1a51-4b0c-aeef-1240ac5bed75"],
    "IContactListDeleteContactRequest": ["5e114687-ce03-4de5-8557-9ccf552d472a"],
    "IContactListDeleteContactRequestEventArgs": ["b22054a1-e8fa-4db5-9389-2d12ee7d15ee"],
    "IContactListLimitedWriteOperations": ["e19813da-4a0b-44b8-9a1f-a0f3d218175f"],
    "IContactListServerSearchReadBatchRequest": ["ba776a97-4030-4925-9fb4-143b295e653b"],
    "IContactListServerSearchReadBatchRequestEventArgs": ["1a27e87b-69d7-4e4e-8042-861cba61471e"],
    "IContactListSyncConstraints": ["b2b0bf01-3062-4e2e-969d-018d1987f314"],
    "IContactListSyncManager": ["146e83be-7925-4acc-9de5-21ddd06f8674"],
    "IContactListSyncManager2": ["a9591247-bb55-4e23-8128-370134a85d0d"],
    "IContactListSyncManagerSyncRequest": ["3c0e57a4-c4e7-4970-9a8f-9a66a2bb6c1a"],
    "IContactListSyncManagerSyncRequestEventArgs": ["158e4dac-446d-4f10-afc2-02683ec533a6"],
    "IContactLocationField": ["9ec00f82-ab6e-4b36-89e3-b23bc0a1dacc"],
    "IContactLocationFieldFactory": ["f79932d7-2fdf-43fe-8f18-41897390bcfe"],
    "IContactManager": ["ad553d98-deb1-474a-8e17-fc0c2075b738"],
    "IContactManagerForUser": ["b74bba57-1076-4bef-aef3-54686d18387d"],
    "IContactManagerForUser2": ["4d469c2e-3b75-4a73-bb30-736645472256"],
    "IContactManagerInterop": ["99eacba7-e073-43b6-a896-55afe48a0833"],
    "IContactManagerStatics": ["81f21ac0-f661-4708-ba4f-d386bd0d622e"],
    "IContactManagerStatics2": ["a178e620-47d8-48cc-963c-9592b6e510c6"],
    "IContactManagerStatics3": ["c4cc3d42-7586-492a-930b-7bc138fc2139"],
    "IContactManagerStatics4": ["24982272-347b-46dc-8d95-51bd41e15aaf"],
    "IContactManagerStatics5": ["f7591a87-acb7-4fad-90f2-a8ab64cdbba4"],
    "IContactMapActivatedEventArgs": ["b32bf870-eee7-4ad2-aaf1-a87effcf00a4"],
    "IContactMarshal": ["28072958-925d-11e2-9952-b4b52fe06527"],
    "IContactMatchReason": ["bc922504-e7d8-413e-95f4-b75c54c74077"],
    "IContactMessageActivatedEventArgs": ["de598db2-0e03-43b0-bf56-bcc40b3162df"],
    "IContactName": ["f404e97b-9034-453c-8ebf-140a38c86f1d"],
    "IContactPanel": ["41bf1265-d2ee-4b97-a80a-7d8d64cca6f5"],
    "IContactPanelActivatedEventArgs": ["52bb63e4-d3d4-4b63-8051-4af2082cab80"],
    "IContactPanelClosingEventArgs": ["222174d3-cf4b-46d7-b739-6edc16110bfb"],
    "IContactPanelLaunchFullAppRequestedEventArgs": ["88d61c0e-23b4-4be8-8afc-072c25a4190d"],
    "IContactPhone": ["467dab65-2712-4f52-b783-9ea8111c63cd"],
    "IContactPhoneMarshal": ["28072952-925d-11e2-9952-b4b52fe06527"],
    "IContactPicker": ["0e09fd91-42f8-4055-90a0-896f96738936"],
    "IContactPicker2": ["b35011cf-5cef-4d24-aa0c-340c5208725d"],
    "IContactPicker3": ["0e723315-b243-4bed-8516-22b1a7ac0ace"],
    "IContactPickerActivatedEventArgs": ["ce57aae7-6449-45a7-971f-d113be7a8936"],
    "IContactPickerStatics": ["7488c029-6a53-4258-a3e9-62dff6784b6c"],
    "IContactPickerUI": ["e2cc1366-cf66-43c4-a96a-a5a112db4746"],
    "IContactPickerUI2": ["6e449e28-7b25-4999-9b0b-875400a1e8c8"],
    "IContactPostActivatedEventArgs": ["b35a3c67-f1e7-4655-ad6e-4857588f552f"],
    "IContactProperties": ["70dd27dd-5cbd-46e8-bef0-23b6b346288f"],
    "IContactPropertyCollection": ["ffd3adf8-fa64-4328-b1b6-2e0db509cb3c"],
    "IContactQueryOptions": ["4408cc9e-7d7c-42f0-8ac7-f50733ecdbc1"],
    "IContactQueryOptionsFactory": ["543fba47-8ce7-46cb-9dac-9aa42a1bc8e2"],
    "IContactQueryTextSearch": ["f7e3f9cb-a957-439b-a0b7-1c02a1963ff0"],
    "IContactReader": ["d397e42e-1488-42f2-bf64-253f4884bfed"],
    "IContactRemovedEventArgs": ["6f354338-3302-4d13-ad8d-adcc0ff9e47c"],
    "IContactSignificantOther": ["8873b5ab-c5fb-46d8-93fe-da3ff1934054"],
    "IContactSignificantOther2": ["8d7bd474-3f03-45f8-ba0f-c4ed37d64219"],
    "IContactSignificantOtherMarshal": ["28072951-925d-11e2-9952-b4b52fe06527"],
    "IContactStore": ["2c220b10-3a6c-4293-b9bc-fe987f6e0d52"],
    "IContactStore2": ["18ce1c22-ebd5-4bfb-b690-5f4f27c4f0e8"],
    "IContactStore3": ["cb882c6c-004e-4050-87f0-840407ee6818"],
    "IContactStoreNotificationTrigger": ["c833419b-4705-4571-9a16-06b997bf9c96"],
    "IContactStoreNotificationTriggerDetails": ["abb298d6-878a-4f8b-a9ce-46bb7d1c84ce"],
    "IContactVideoCallActivatedEventArgs": ["61079db8-e3e7-4b4f-858d-5c63a96ef684"],
    "IContactWebsite": ["9f130176-dc1b-4055-ad66-652f39d990e8"],
    "IContactWebsite2": ["f87ee91e-5647-4068-bb5e-4b6f437ce308"],
    "IContactWebsiteMarshal": ["28072950-925d-11e2-9952-b4b52fe06527"],
    "IContactsHelper": ["289e924c-9fa1-4b1f-b8ae-a8b7ad9d74a7"],
    "IContactsProviderActivatedEventArgs": ["4580dca8-5750-4916-aa52-c0829521eb94"],
    "IContainerActivationHelper": ["b524f93f-80d5-4ec7-ae9e-d66e93ade1fa"],
    "IContainerContentChangingEventArgs": ["07deeaa7-018f-4dda-b399-fd4e13a31bea"],
    "IContainerEncodingProperties": ["59ac2a57-b32a-479e-8a61-4b7f2e9e7ea0"],
    "IContainerEncodingProperties2": ["b272c029-ae26-4819-baad-ad7a49b0a876"],
    "IContainerVisual": ["02f6bc74-ed20-4773-afe6-d49b4a93db32"],
    "IContainerVisualFactory": ["0363a65b-c7da-4d9a-95f4-69b5c8df670b"],
    "IContainsDeletedItems": ["7ffb5080-d7ea-42d9-8ee4-a5dd03fe0ec6"],
    "IContentBlock": ["d8619504-d70e-4717-9bfb-4e62ee02eb5d"],
    "IContentControl": ["a26dd1dc-cd44-435c-be94-01d6241c231c"],
    "IContentControl2": ["652c208c-8ccf-4399-bd3e-5a015aa1bc03"],
    "IContentControlFactory": ["ab017b19-196e-4ed5-a27f-55c58fb1673f"],
    "IContentControlOverrides": ["5f4c0b10-e38e-4b5d-be1a-5ed04246a635"],
    "IContentControlStatics": ["116982a4-5cf5-4c05-a53f-15e4876c85ec"],
    "IContentDialog": ["38dc4404-d24e-40d8-9415-349464c1afdc"],
    "IContentDialog2": ["2f93eb45-ee43-4303-9b38-3fe1a111ecbf"],
    "IContentDialog3": ["9d9a089e-f954-4ede-b07f-6b069a9c0180"],
    "IContentDialogButtonClickDeferral": ["bd0d3637-19ce-4946-8e77-bd03fe8ebe03"],
    "IContentDialogButtonClickEventArgs": ["5f34c205-8afa-4cf2-8ca0-264d73bed63d"],
    "IContentDialogClosedEventArgs": ["905522ef-2cba-4af8-b666-cc36c22732fb"],
    "IContentDialogClosingDeferral": ["215d4d11-7e30-4cb9-a710-5a4f9cca8b42"],
    "IContentDialogClosingEventArgs": ["db3c1c34-3bbf-47d4-be4f-c9ec115918b9"],
    "IContentDialogFactory": ["05557178-9d8e-4315-b37d-680c14012c35"],
    "IContentDialogOpenedEventArgs": ["0966b315-5f59-4999-9e3e-374c0f174b04"],
    "IContentDialogStatics": ["23ab47a6-508a-4f33-b786-f2fa96d869af"],
    "IContentDialogStatics2": ["329825b2-8fb0-4125-bb07-e79a5a03819f"],
    "IContentIndexer": ["b1767f8d-f698-4982-b05f-3a6e8cab01a2"],
    "IContentIndexerQuery": ["70e3b0f8-4bfc-428a-8889-cc51da9a7b9d"],
    "IContentIndexerQueryOperations": ["28823e10-4786-42f1-9730-792b3566b150"],
    "IContentIndexerStatics": ["8c488375-b37e-4c60-9ba8-b760fda3e59d"],
    "IContentLink": ["6c60c3e1-528c-42f8-92be-34b8c68be304"],
    "IContentLinkChangedEventArgs": ["64f3f1de-89fb-4b77-8b9b-191b6d19290a"],
    "IContentLinkInfo": ["1ed52525-1c5f-48cb-b335-78b50a2ee642"],
    "IContentLinkInvokedEventArgs": ["546717c1-e8df-4593-9639-97595fdf8310"],
    "IContentLinkProvider": ["730587fd-bfdc-4cb3-904d-b65ab339bbf5"],
    "IContentLinkProviderCollection": ["f5b84d0c-a9f4-4d1a-a13c-10def1843734"],
    "IContentLinkProviderFactory": ["57d60d3b-ef1a-4e8e-839b-d36ef3a503e0"],
    "IContentLinkStatics": ["a34e3063-eb16-484e-a3df-522b9a832e6e"],
    "IContentPrefetchTrigger": ["710627ee-04fa-440b-80c0-173202199e5d"],
    "IContentPrefetchTriggerFactory": ["c2643eda-8a03-409e-b8c4-88814c28ccb6"],
    "IContentPrefetcher": ["a8d6f754-7dc1-4cd9-8810-2a6aa9417e11"],
    "IContentPrefetcherTaskTrigger": ["1b35a14a-6094-4799-a60e-e474e15d4dc9"],
    "IContentPrefetcherTime": ["e361fd08-132a-4fde-a7cc-fcb0e66523af"],
    "IContentPresenter": ["79fde5b4-cd37-491c-8845-daf472defff6"],
    "IContentPresenter2": ["5138e958-335d-4210-8bbb-0aa2b4b5c29e"],
    "IContentPresenter3": ["b038876a-9c4d-4402-ac56-a223487dc6c8"],
    "IContentPresenter4": ["997b1b17-3bf8-432b-8fd9-68c7bab21f9d"],
    "IContentPresenter5": ["d248970c-b785-5e7f-9c11-8a6cd3d5929b"],
    "IContentPresenterFactory": ["3339d4f7-4815-44c4-9f76-68c83880ef10"],
    "IContentPresenterOverrides": ["a76339ed-32ff-438b-aad5-1d68fae93426"],
    "IContentPresenterStatics": ["18c2893b-da2e-4426-b85a-2c7e2171bedf"],
    "IContentPresenterStatics2": ["c7d89dd9-06e6-46be-a8a0-9c117d3024a3"],
    "IContentPresenterStatics3": ["cbe6cf5b-38b1-4d5d-b098-bc94b35c8ddf"],
    "IContentPresenterStatics4": ["ff8be292-af28-47eb-a5c3-dc44ced40fd2"],
    "IContentPresenterStatics5": ["169e700f-e8e6-5f6a-b97e-7ef8f7006f49"],
    "IContentRestrictionsBrowsePolicy": ["8c0133a4-442e-461a-8757-fad2f5bd37e4"],
    "IContentThemeTransition": ["f66fc5c3-5915-437d-8e3b-adf8e7f0ab57"],
    "IContentThemeTransitionStatics": ["0e8ee385-9a42-4459-afa9-337dc41e1587"],
    "IContentTypeProvider": ["97d098a5-3b99-4de9-88a5-e11d2f50c795"],
    "IContextMarshaler": ["000001d8-0000-0000-c000-000000000046"],
    "IContextMenuCB": ["3409e930-5a39-11d1-83fa-00a0c90dc849"],
    "IContextMenuEventArgs": ["1f7df263-c14b-4528-b6f0-637999d83cc6"],
    "IContextMenuFactory": ["47d9e2b2-cbb3-4fe3-a925-f49978685982"],
    "IContextMenuForProgInvoke": ["649e2263-dc09-466f-9d66-3eb133ee8f81"],
    "IContextMenuOpeningEventHandler": ["df945151-745c-4446-b2fc-216d765847a0"],
    "IContextNotify": ["15f936f5-a3fa-11d2-aec3-00c04f79d1eb"],
    "IContextRegisterNotify": ["15f936f6-a3fa-11d2-aec3-00c04f79d1eb"],
    "IContextRequestedEventArgs": ["42618e0a-1cb6-46fb-8374-0aec68aa5e51"],
    "IContextSecurityPerimeter": ["a7549a29-a7c4-42e1-8dc1-7e3d748dc24a"],
    "IContextTransactionInfo": ["7d40fcc8-f81e-462e-bba1-8a99ebdc826c"],
    "IContinuationActivatedEventArgs": ["e58106b5-155f-4a94-a742-c7e08f4e188c"],
    "IContinuumNavigationTransitionInfo": ["4be1dbad-8ba6-4004-8438-8a9017978543"],
    "IContinuumNavigationTransitionInfoStatics": ["3e25dd53-b18f-4bf1-b3bc-92f516f29903"],
    "IContractActivation": ["85a098aa-ef5a-451b-b332-c1b795431bc3"],
    "IContractBrokerGetStream": ["4bb67095-515f-4e53-b6bb-ddeb70df3cc4"],
    "IContractBrokerGetStreamReadyEvent": ["c218afae-7884-4151-873f-631e82388d0d"],
    "IContractBrokerHandleMarshal": ["ca20a226-daaa-4093-813a-f639ee1eaf18"],
    "IControl2": ["43e0fe10-14ec-427e-8c57-dee60df60aa8"],
    "IControl3": ["077b29e4-dade-4f55-9b96-09e21b28eb1c"],
    "IControl4": ["0e18aeee-5f2e-44ea-8513-d3875c0a7513"],
    "IControl5": ["5ebb51d5-9e58-49b7-bc2d-0155ff118664"],
    "IControl7": ["3550dbe1-e561-5934-a3ef-7db8bf6e3b45"],
    "IControlChangeDelegate": ["dc73b98f-ac0d-4e1e-b9fe-13f6378b1219"],
    "IControlChangeNotify": ["a09513ed-c709-4d21-bd7b-5f34c47f3947"],
    "IControlChannelTrigger": ["7d1431a7-ee96-40e8-a199-8703cd969ec3"],
    "IControlChannelTrigger2": ["af00d237-51be-4514-9725-3556e1879580"],
    "IControlChannelTriggerEventDetails": ["1b36e047-89bb-4236-96ac-71d012bb4869"],
    "IControlChannelTriggerFactory": ["da4b7cf0-8d71-446f-88c3-b95184a2d6cd"],
    "IControlChannelTriggerResetEventDetails": ["6851038e-8ec4-42fe-9bb2-21e91b7bfcb1"],
    "IControlEvents": ["9a4bbf53-4e46-101b-8bbd-00aa003e3b29"],
    "IControlFactory": ["b12b1d5a-6419-4e16-b212-a45336b75778"],
    "IControlInterface": ["45d37c3f-5140-444a-ae24-400789f3cbf3"],
    "IControlMarkup": ["d6d2fbae-f116-458c-8c34-03569877a2d2"],
    "IControlOverrides": ["a09691df-9824-41fe-b530-b0d8990e64c1"],
    "IControlOverrides6": ["e194c96a-d8cc-4339-a0e1-2e9c420879ec"],
    "IControlPanelGrepEnumerator": ["f93f9470-36a7-4a92-afdb-aed751464f32"],
    "IControlPanelNavPaneProvider": ["9c708890-41f3-43f2-98d7-b610256ed61c"],
    "IControlPanelPrivate": ["f11cbea6-468c-4247-9726-6c75dcd1604c"],
    "IControlProtected": ["1791587a-2a7c-4981-a2d8-ab99fffc65b9"],
    "IControlStatics": ["473b305b-877d-4c35-8fca-46a05f96607a"],
    "IControlStatics2": ["32233e36-ab74-4a25-a556-45293135b2c5"],
    "IControlStatics3": ["aad15e61-e4b9-4d72-b653-934149aa5003"],
    "IControlStatics4": ["59fda728-c05a-4ec2-8a4b-06ad69b66e15"],
    "IControlStatics5": ["f635b5a3-ef8e-404f-877b-5580473710a6"],
    "IControlStatics7": ["aee1ca45-c910-5dab-a266-fdf50c0bedd2"],
    "IControlTemplate": ["efd2418e-41e0-48bb-8b82-91eda1ba3fe2"],
    "IControls": ["c8a3dc00-8593-11d1-b16a-00c0f0283628"],
    "IConversationalAgentDetectorManager": ["de94fbb0-597a-5df8-8cfb-9dbb583ba3ff"],
    "IConversationalAgentDetectorManagerStatics": ["36a8d283-fa0e-5693-8489-0fb2f0ab40d3"],
    "IConversationalAgentSession": ["daaae09a-b7ba-57e5-ad13-df520f9b6fa7"],
    "IConversationalAgentSessionInterruptedEventArgs": ["9766591f-f63d-5d3e-9bf2-bd0760552686"],
    "IConversationalAgentSessionStatics": ["a005166e-e954-576e-be04-11b8ed10f37b"],
    "IConversationalAgentSignal": ["20ed25f7-b120-51f2-8603-265d6a47f232"],
    "IConversationalAgentSignalDetectedEventArgs": ["4d57eb8f-f88a-599b-91d3-d604876708bc"],
    "IConversationalAgentSystemStateChangedEventArgs": ["1c2c6e3e-2785-59a7-8e71-38adeef79928"],
    "IConvertToSidString": ["6dac21b6-e2ce-45b1-aeb7-afea6ada2977"],
    "IConvertType": ["0c733a88-2a1c-11ce-ade5-00aa0044773d"],
    "ICookieJarRecoveryData": ["8fd276bb-5a9d-4fc0-b0bd-90fa7cf1283d"],
    "ICookieJarSessionData": ["4dd0da1f-9587-448c-b960-5148806cc7a0"],
    "ICopyHookA": ["000214ef-0000-0000-c000-000000000046"],
    "ICopyHookW": ["000214fc-0000-0000-c000-000000000046"],
    "ICorConfiguration": ["5c2b07a5-1e98-11d3-872f-00c04f79ed0d"],
    "ICorDebug": ["3d6f5f61-7538-11d3-8d5b-00104b35e7ef"],
    "ICorDebug2": ["eccccf2e-b286-4b3e-a983-860a8793d105"],
    "ICorDebugAppDomain": ["3d6f5f63-7538-11d3-8d5b-00104b35e7ef"],
    "ICorDebugAppDomain2": ["096e81d5-ecda-4202-83f5-c65980a9ef75"],
    "ICorDebugAppDomain3": ["8cb96a16-b588-42e2-b71c-dd849fc2eccc"],
    "ICorDebugAppDomain4": ["fb99cc40-83be-4724-ab3b-768e796ebac2"],
    "ICorDebugAppDomainEnum": ["63ca1b24-4359-4883-bd57-13f815f58744"],
    "ICorDebugArrayValue": ["0405b0df-a660-11d2-bd02-0000f80849bd"],
    "ICorDebugAssembly": ["df59507c-d47a-459e-bce2-6427eac8fd06"],
    "ICorDebugAssembly2": ["426d1f9e-6dd4-44c8-aec7-26cdbaf4e398"],
    "ICorDebugAssembly3": ["76361ab2-8c86-4fe9-96f2-f73d8843570a"],
    "ICorDebugAssemblyEnum": ["4a2a1ec9-85ec-4bfb-9f15-a89fdfe0fe83"],
    "ICorDebugBlockingObjectEnum": ["976a6278-134a-4a81-81a3-8f277943f4c3"],
    "ICorDebugBoxValue": ["cc7bcafc-8a68-11d2-983c-0000f808342d"],
    "ICorDebugBreakpoint": ["cc7bcae8-8a68-11d2-983c-0000f808342d"],
    "ICorDebugBreakpointEnum": ["cc7bcb03-8a68-11d2-983c-0000f808342d"],
    "ICorDebugChain": ["cc7bcaee-8a68-11d2-983c-0000f808342d"],
    "ICorDebugChainEnum": ["cc7bcb08-8a68-11d2-983c-0000f808342d"],
    "ICorDebugClass": ["cc7bcaf5-8a68-11d2-983c-0000f808342d"],
    "ICorDebugClass2": ["b008ea8d-7ab1-43f7-bb20-fbb5a04038ae"],
    "ICorDebugCode": ["cc7bcaf4-8a68-11d2-983c-0000f808342d"],
    "ICorDebugCode2": ["5f696509-452f-4436-a3fe-4d11fe7e2347"],
    "ICorDebugCode3": ["d13d3e88-e1f2-4020-aa1d-3d162dcbe966"],
    "ICorDebugCode4": ["18221fa4-20cb-40fa-b19d-9f91c4fa8c14"],
    "ICorDebugCodeEnum": ["55e96461-9645-45e4-a2ff-0367877abcde"],
    "ICorDebugComObjectValue": ["5f69c5e5-3e12-42df-b371-f9d761d6ee24"],
    "ICorDebugContext": ["cc7bcb00-8a68-11d2-983c-0000f808342d"],
    "ICorDebugController": ["3d6f5f62-7538-11d3-8d5b-00104b35e7ef"],
    "ICorDebugDataTarget": ["fe06dc28-49fb-4636-a4a3-e80db4ae116c"],
    "ICorDebugDataTarget2": ["2eb364da-605b-4e8d-b333-3394c4828d41"],
    "ICorDebugDataTarget3": ["d05e60c3-848c-4e7d-894e-623320ff6afa"],
    "ICorDebugDebugEvent": ["41bd395d-de99-48f1-bf7a-cc0f44a6d281"],
    "ICorDebugEditAndContinueErrorInfo": ["8d600d41-f4f6-4cb3-b7ec-7bd164944036"],
    "ICorDebugEditAndContinueSnapshot": ["6dc3fa01-d7cb-11d2-8a95-0080c792e5d8"],
    "ICorDebugEnum": ["cc7bcb01-8a68-11d2-983c-0000f808342d"],
    "ICorDebugErrorInfoEnum": ["f0e18809-72b5-11d2-976f-00a0c9b4d50c"],
    "ICorDebugEval": ["cc7bcaf6-8a68-11d2-983c-0000f808342d"],
    "ICorDebugEval2": ["fb0d9ce7-be66-4683-9d32-a42a04e2fd91"],
    "ICorDebugExceptionDebugEvent": ["af79ec94-4752-419c-a626-5fb1cc1a5ab7"],
    "ICorDebugExceptionObjectCallStackEnum": ["ed775530-4dc4-41f7-86d0-9e2def7dfc66"],
    "ICorDebugExceptionObjectValue": ["ae4ca65d-59dd-42a2-83a5-57e8a08d8719"],
    "ICorDebugFrame": ["cc7bcaef-8a68-11d2-983c-0000f808342d"],
    "ICorDebugFrameEnum": ["cc7bcb07-8a68-11d2-983c-0000f808342d"],
    "ICorDebugFunction": ["cc7bcaf3-8a68-11d2-983c-0000f808342d"],
    "ICorDebugFunction2": ["ef0c490b-94c3-4e4d-b629-ddc134c532d8"],
    "ICorDebugFunction3": ["09b70f28-e465-482d-99e0-81a165eb0532"],
    "ICorDebugFunctionBreakpoint": ["cc7bcae9-8a68-11d2-983c-0000f808342d"],
    "ICorDebugGCReferenceEnum": ["7f3c24d3-7e1d-4245-ac3a-f72f8859c80c"],
    "ICorDebugGenericValue": ["cc7bcaf8-8a68-11d2-983c-0000f808342d"],
    "ICorDebugGuidToTypeEnum": ["6164d242-1015-4bd6-8cbe-d0dbd4b8275a"],
    "ICorDebugHandleValue": ["029596e8-276b-46a1-9821-732e96bbb00b"],
    "ICorDebugHeapEnum": ["76d7dab8-d044-11df-9a15-7e29dfd72085"],
    "ICorDebugHeapSegmentEnum": ["a2fa0f8e-d045-11df-ac8e-ce2adfd72085"],
    "ICorDebugHeapValue": ["cc7bcafa-8a68-11d2-983c-0000f808342d"],
    "ICorDebugHeapValue2": ["e3ac4d6c-9cb7-43e6-96cc-b21540e5083c"],
    "ICorDebugHeapValue3": ["a69acad8-2374-46e9-9ff8-b1f14120d296"],
    "ICorDebugILCode": ["598d46c2-c877-42a7-89d2-3d0c7f1c1264"],
    "ICorDebugILCode2": ["46586093-d3f5-4db6-acdb-955bce228c15"],
    "ICorDebugILFrame": ["03e26311-4f76-11d3-88c6-006097945418"],
    "ICorDebugILFrame2": ["5d88a994-6c30-479b-890f-bcef88b129a5"],
    "ICorDebugILFrame3": ["9a9e2ed6-04df-4fe0-bb50-cab64126ad24"],
    "ICorDebugILFrame4": ["ad914a30-c6d1-4ac5-9c5e-577f3baa8a45"],
    "ICorDebugInstanceFieldSymbol": ["a074096b-3adc-4485-81da-68c7a4ea52db"],
    "ICorDebugInternalFrame": ["b92cc7f7-9d2d-45c4-bc2b-621fcc9dfbf4"],
    "ICorDebugInternalFrame2": ["c0815bdc-cfab-447e-a779-c116b454eb5b"],
    "ICorDebugLoadedModule": ["817f343a-6630-4578-96c5-d11bc0ec5ee2"],
    "ICorDebugMDA": ["cc726f2f-1db7-459b-b0ec-05f01d841b42"],
    "ICorDebugManagedCallback": ["3d6f5f60-7538-11d3-8d5b-00104b35e7ef"],
    "ICorDebugManagedCallback2": ["250e5eea-db5c-4c76-b6f3-8c46f12e3203"],
    "ICorDebugManagedCallback3": ["264ea0fc-2591-49aa-868e-835e6515323f"],
    "ICorDebugMemoryBuffer": ["677888b3-d160-4b8c-a73b-d79e6aaa1d13"],
    "ICorDebugMergedAssemblyRecord": ["faa8637b-3bbe-4671-8e26-3b59875b922a"],
    "ICorDebugMetaDataLocator": ["7cef8ba9-2ef7-42bf-973f-4171474f87d9"],
    "ICorDebugModule": ["dba2d8c1-e5c5-4069-8c13-10a7c6abf43d"],
    "ICorDebugModule2": ["7fcc5fb5-49c0-41de-9938-3b88b5b9add7"],
    "ICorDebugModule3": ["86f012bf-ff15-4372-bd30-b6f11caae1dd"],
    "ICorDebugModuleBreakpoint": ["cc7bcaea-8a68-11d2-983c-0000f808342d"],
    "ICorDebugModuleDebugEvent": ["51a15e8d-9fff-4864-9b87-f4fbdea747a2"],
    "ICorDebugModuleEnum": ["cc7bcb09-8a68-11d2-983c-0000f808342d"],
    "ICorDebugMutableDataTarget": ["a1b8a756-3cb6-4ccb-979f-3df999673a59"],
    "ICorDebugNativeFrame": ["03e26314-4f76-11d3-88c6-006097945418"],
    "ICorDebugNativeFrame2": ["35389ff1-3684-4c55-a2ee-210f26c60e5e"],
    "ICorDebugObjectEnum": ["cc7bcb02-8a68-11d2-983c-0000f808342d"],
    "ICorDebugObjectValue": ["18ad3d6e-b7d2-11d2-bd04-0000f80849bd"],
    "ICorDebugObjectValue2": ["49e4a320-4a9b-4eca-b105-229fb7d5009f"],
    "ICorDebugProcess": ["3d6f5f64-7538-11d3-8d5b-00104b35e7ef"],
    "ICorDebugProcess2": ["ad1b3588-0ef0-4744-a496-aa09a9f80371"],
    "ICorDebugProcess3": ["2ee06488-c0d4-42b1-b26d-f3795ef606fb"],
    "ICorDebugProcess5": ["21e9d9c0-fcb8-11df-8cff-0800200c9a66"],
    "ICorDebugProcess6": ["11588775-7205-4ceb-a41a-93753c3153e9"],
    "ICorDebugProcess7": ["9b2c54e4-119f-4d6f-b402-527603266d69"],
    "ICorDebugProcess8": ["2e6f28c1-85eb-4141-80ad-0a90944b9639"],
    "ICorDebugProcessEnum": ["cc7bcb05-8a68-11d2-983c-0000f808342d"],
    "ICorDebugReferenceValue": ["cc7bcaf9-8a68-11d2-983c-0000f808342d"],
    "ICorDebugRegisterSet": ["cc7bcb0b-8a68-11d2-983c-0000f808342d"],
    "ICorDebugRegisterSet2": ["6dc7ba3f-89ba-4459-9ec1-9d60937b468d"],
    "ICorDebugRemote": ["d5ebb8e2-7bbe-4c1d-98a6-a3c04cbdef64"],
    "ICorDebugRemoteTarget": ["c3ed8383-5a49-4cf5-b4b7-01864d9e582d"],
    "ICorDebugRuntimeUnwindableFrame": ["879cac0a-4a53-4668-b8e3-cb8473cb187f"],
    "ICorDebugStackWalk": ["a0647de9-55de-4816-929c-385271c64cf7"],
    "ICorDebugStaticFieldSymbol": ["cbf9da63-f68d-4bbb-a21c-15a45eaadf5b"],
    "ICorDebugStepper": ["cc7bcaec-8a68-11d2-983c-0000f808342d"],
    "ICorDebugStepper2": ["c5b6e9c3-e7d1-4a8e-873b-7f047f0706f7"],
    "ICorDebugStepperEnum": ["cc7bcb04-8a68-11d2-983c-0000f808342d"],
    "ICorDebugStringValue": ["cc7bcafd-8a68-11d2-983c-0000f808342d"],
    "ICorDebugSymbolProvider": ["3948a999-fd8a-4c38-a708-8a71e9b04dbb"],
    "ICorDebugSymbolProvider2": ["f9801807-4764-4330-9e67-4f685094165e"],
    "ICorDebugThread": ["938c6d66-7fb6-4f69-b389-425b8987329b"],
    "ICorDebugThread2": ["2bd956d9-7b07-4bef-8a98-12aa862417c5"],
    "ICorDebugThread3": ["f8544ec3-5e4e-46c7-8d3e-a52b8405b1f5"],
    "ICorDebugThread4": ["1a1f204b-1c66-4637-823f-3ee6c744a69c"],
    "ICorDebugThreadEnum": ["cc7bcb06-8a68-11d2-983c-0000f808342d"],
    "ICorDebugType": ["d613f0bb-ace1-4c19-bd72-e4c08d5da7f5"],
    "ICorDebugType2": ["e6e91d79-693d-48bc-b417-8284b4f10fb5"],
    "ICorDebugTypeEnum": ["10f27499-9df2-43ce-8333-a321d7c99cb4"],
    "ICorDebugUnmanagedCallback": ["5263e909-8cb5-11d3-bd2f-0000f80849bd"],
    "ICorDebugValue": ["cc7bcaf7-8a68-11d2-983c-0000f808342d"],
    "ICorDebugValue2": ["5e0b54e7-d88a-4626-9420-a691e0a78b49"],
    "ICorDebugValue3": ["565005fc-0f8a-4f3e-9edb-83102b156595"],
    "ICorDebugValueBreakpoint": ["cc7bcaeb-8a68-11d2-983c-0000f808342d"],
    "ICorDebugValueEnum": ["cc7bcb0a-8a68-11d2-983c-0000f808342d"],
    "ICorDebugVariableHome": ["50847b8d-f43f-41b0-924c-6383a5f2278b"],
    "ICorDebugVariableHomeEnum": ["e76b7a57-4f7a-4309-85a7-5d918c3deaf7"],
    "ICorDebugVariableSymbol": ["707e8932-1163-48d9-8a93-f5b1f480fbb7"],
    "ICorDebugVirtualUnwinder": ["f69126b7-c787-4f6b-ae96-a569786fc670"],
    "ICorProfilerAssemblyReferenceProvider": ["66a78c24-2eef-4f65-b45f-dd1d8038bf3c"],
    "ICorProfilerCallback": ["176fbed1-a55c-4796-98ca-a9da0ef883e7"],
    "ICorProfilerCallback2": ["8a8cc829-ccf2-49fe-bbae-0f022228071a"],
    "ICorProfilerCallback3": ["4fd2ed52-7731-4b8d-9469-03d2cc3086c5"],
    "ICorProfilerCallback4": ["7b63b2e3-107d-4d48-b2f6-f61e229470d2"],
    "ICorProfilerCallback5": ["8dfba405-8c9f-45f8-bffa-83b14cef78b5"],
    "ICorProfilerCallback6": ["fc13df4b-4448-4f4f-950c-ba8d19d00c36"],
    "ICorProfilerCallback7": ["f76a2dba-1d52-4539-866c-2aa518f9efc3"],
    "ICorProfilerCallback8": ["5bed9b15-c079-4d47-bfe2-215a140c07e0"],
    "ICorProfilerCallback9": ["27583ec3-c8f5-482f-8052-194b8ce4705a"],
    "ICorProfilerFunctionControl": ["f0963021-e1ea-4732-8581-e01b0bd3c0c6"],
    "ICorProfilerFunctionEnum": ["ff71301a-b994-429d-a10b-b345a65280ef"],
    "ICorProfilerInfo": ["28b5557d-3f3f-48b4-90b2-5f9eea2f6c48"],
    "ICorProfilerInfo2": ["cc0935cd-a518-487d-b0bb-a93214e65478"],
    "ICorProfilerInfo3": ["b555ed4f-452a-4e54-8b39-b5360bad32a0"],
    "ICorProfilerInfo4": ["0d8fdcaa-6257-47bf-b1bf-94dac88466ee"],
    "ICorProfilerInfo5": ["07602928-ce38-4b83-81e7-74adaf781214"],
    "ICorProfilerInfo6": ["f30a070d-bffb-46a7-b1d8-8781ef7b698a"],
    "ICorProfilerInfo7": ["9aeecc0d-63e0-4187-8c00-e312f503f663"],
    "ICorProfilerInfo8": ["c5ac80a6-782e-4716-8044-39598c60cfbf"],
    "ICorProfilerMethodEnum": ["fccee788-0088-454b-a811-c99f298d1942"],
    "ICorProfilerModuleEnum": ["b0266d75-2081-4493-af7f-028ba34db891"],
    "ICorProfilerObjectEnum": ["2c6269bd-2d13-4321-ae12-6686365fd6af"],
    "ICorProfilerThreadEnum": ["571194f7-25ed-419f-aa8b-7016b3159701"],
    "ICorPublish": ["9613a0e7-5a68-11d3-8f84-00a0c9b4d50c"],
    "ICorPublishAppDomain": ["d6315c8f-5a6a-11d3-8f84-00a0c9b4d50c"],
    "ICorPublishAppDomainEnum": ["9f0c98f5-5a6a-11d3-8f84-00a0c9b4d50c"],
    "ICorPublishEnum": ["c0b22967-5a69-11d3-8f84-00a0c9b4d50c"],
    "ICorPublishProcess": ["18d87af1-5a6a-11d3-8f84-00a0c9b4d50c"],
    "ICorPublishProcessEnum": ["a37fbd41-5a69-11d3-8f84-00a0c9b4d50c"],
    "ICorRuntimeHost": ["cb2f6722-ab3a-11d2-9c40-00c04fa30a3e"],
    "ICorSvc": ["3eef5ff0-3680-4f20-8a8f-9051aca66b22"],
    "ICorSvcManager": ["8f416a48-d663-4a7e-9732-fbca3fc46ea8"],
    "ICorThreadpool": ["84680d3a-b2c1-46e8-acc2-dbc0a359159a"],
    "ICoreAcceleratorKeys": ["9ffdf7f5-b8c9-4ef0-b7d2-1de626561fc8"],
    "ICoreAppWindowPreview": ["a4f6e665-365e-5fde-87a5-9543c3a15aa8"],
    "ICoreAppWindowPreviewStatics": ["33ac21be-423b-5db6-8a8e-4dc87353b75b"],
    "ICoreApplication": ["0aacf7a4-5e1d-49df-8034-fb6a68bc5ed1"],
    "ICoreApplication2": ["998681fb-1ab6-4b7f-be4a-9a0645224c04"],
    "ICoreApplication3": ["feec0d39-598b-4507-8a67-772632580a57"],
    "ICoreApplicationExit": ["cf86461d-261e-4b72-9acd-44ed2ace6a29"],
    "ICoreApplicationUnhandledError": ["f0e24ab0-dd09-42e1-b0bc-e0e131f78d7e"],
    "ICoreApplicationUseCount": ["518dc408-c077-475b-809e-0bc0c57e4b74"],
    "ICoreApplicationView": ["638bb2db-451d-4661-b099-414f34ffb9f1"],
    "ICoreApplicationView2": ["68eb7adf-917f-48eb-9aeb-7de53e086ab1"],
    "ICoreApplicationView3": ["07ebe1b3-a4cf-4550-ab70-b07e85330bc8"],
    "ICoreApplicationView5": ["2bc095a8-8ef0-446d-9e60-3a3e0428c671"],
    "ICoreApplicationView6": ["c119d49a-0679-49ba-803f-b79c5cf34cca"],
    "ICoreApplicationViewPrivate": ["42b83e6e-076b-4742-828c-173c723b1a81"],
    "ICoreApplicationViewTitleBar": ["006d35e3-e1f1-431b-9508-29b96926ac53"],
    "ICoreApplicationViewTitleBarInternal": ["72558910-08e1-49c4-90bd-d2c149d1c169"],
    "ICoreClosestInteractiveBoundsRequested": ["f303043a-e8bf-4e8e-ae69-c9dadd57a114"],
    "ICoreComponentFocusable": ["52f96fa3-8742-4411-ae69-79a85f29ac8b"],
    "ICoreCursor": ["96893acf-111d-442c-8a77-b87992f8e2d6"],
    "ICoreCursorFactory": ["f6359621-a79d-4ed3-8c32-a9ef9d6b76a4"],
    "ICoreDispatcher": ["60db2fa8-b705-4fde-a7d6-ebbb1891d39e"],
    "ICoreDispatcher2": ["6f5e63c7-e3aa-4eae-b0e0-dcf321ca4b2f"],
    "ICoreDispatcherWithTaskPriority": ["bafaecad-484d-41be-ba80-1d58c65263ea"],
    "ICoreDragDropManager": ["7d56d344-8464-4faf-aa49-37ea6e2d7bd1"],
    "ICoreDragDropManagerStatics": ["9542fdca-da12-4c1c-8d06-041db29733c3"],
    "ICoreDragInfo": ["48353a8b-cb50-464e-9575-cd4e3a7ab028"],
    "ICoreDragInfo2": ["c54691e5-e6fb-4d74-b4b1-8a3c17f25e9e"],
    "ICoreDragOperation": ["cc06de4f-6db0-4e62-ab1b-a74a02dc6d85"],
    "ICoreDragOperation2": ["824b1e2c-d99a-4fc3-8507-6c182f33b46a"],
    "ICoreDragUIOverride": ["89a85064-3389-4f4f-8897-7e8a3ffb3c93"],
    "ICoreDropOperationTarget": ["d9126196-4c5b-417d-bb37-76381def8db4"],
    "ICoreDropOperationTargetRequestedEventArgs": ["2aca929a-5e28-4ea6-829e-29134e665d6d"],
    "ICoreFragment": ["613b2ab5-b304-47d9-9c31-ce6c54401a15"],
    "ICoreFragmentInspector": ["f7fcc5fd-ae26-4679-ba16-96aac583c134"],
    "ICoreImmersiveApplication": ["1ada0e3e-e4a2-4123-b451-dc96bf800419"],
    "ICoreImmersiveApplication2": ["828e1e36-e9e3-4cfc-9b66-48b78ea9bb2c"],
    "ICoreImmersiveApplication3": ["34a05b2f-ee0d-41e5-8314-cf10c91bf0af"],
    "ICoreIncrementalInkStroke": ["fda015d3-9d66-4f7d-a57f-cc70b9cfaa76"],
    "ICoreIncrementalInkStrokeFactory": ["d7c59f46-8da8-4f70-9751-e53bb6df4596"],
    "ICoreInkIndependentInputSource": ["39b38da9-7639-4499-a5b5-191d00e35b16"],
    "ICoreInkIndependentInputSourceStatics": ["73e6011b-80c0-4dfb-9b66-10ba7f3f9c84"],
    "ICoreInkPresenterHost": ["396e89e6-7d55-4617-9e58-68c70c9169b9"],
    "ICoreInputInterop": ["40bfe3e3-b75a-4479-ac96-475365749bb8"],
    "ICoreInputSourceBase": ["9f488807-4580-4be8-be68-92a9311713bb"],
    "ICoreInputView": ["c770cd7a-7001-4c32-bf94-25c1f554cbf1"],
    "ICoreInputView2": ["0ed726c1-e09a-4ae8-aedf-dfa4857d1a01"],
    "ICoreInputView3": ["bc941653-3ab9-4849-8f58-46e7f0353cfc"],
    "ICoreInputView4": ["002863d6-d9ef-57eb-8cef-77f6ce1b7ee7"],
    "ICoreInputViewHidingEventArgs": ["eada47bd-bac5-5336-848d-41083584daad"],
    "ICoreInputViewOcclusion": ["cc36ce06-3865-4177-b5f5-8b65e0b9ce84"],
    "ICoreInputViewOcclusionsChangedEventArgs": ["be1027e8-b3ee-4df7-9554-89cdc66082c2"],
    "ICoreInputViewShowingEventArgs": ["ca52261b-fb9e-5daf-a98c-262b8b76af50"],
    "ICoreInputViewStatics": ["7d9b97cd-edbe-49cf-a54f-337de052907f"],
    "ICoreInputViewStatics2": ["7ebc0862-d049-4e52-87b0-1e90e98c49ed"],
    "ICoreInputViewTransferringXYFocusEventArgs": ["04de169f-ba02-4850-8b55-d82d03ba6d7f"],
    "ICoreKeyboardInputSource": ["231c9088-e469-4df1-b208-6e490d71cb90"],
    "ICoreKeyboardInputSource2": ["fa24cb94-f963-47a5-8778-207c482b0afd"],
    "ICorePerceptionAutomationStatics": ["0bb04541-4ce2-4923-9a76-8187ecc59112"],
    "ICorePointerInputSource": ["bbf1bb18-e47a-48eb-8807-f8f8d3ea4551"],
    "ICorePointerInputSource2": ["d703708a-4516-4786-b1e5-2751d563f997"],
    "ICorePointerRedirector": ["8f9d0c94-5688-4b0c-a9f1-f931f7fa3dc3"],
    "ICoreSelectionChangedEventArgs": ["c2941949-3955-4ec2-8f88-3f2bfc04d0f1"],
    "ICoreTextChangedEventArgs": ["7e3c9572-60e4-4feb-8683-4cf0e0fa7659"],
    "ICoreTextCompositionCompletedEventArgs": ["1f34ebb6-b79f-4121-a5e7-fda9b8616e30"],
    "ICoreTextCompositionSegment": ["776c6bd9-4ead-4da7-8f47-3a88b523cc34"],
    "ICoreTextCompositionStartedEventArgs": ["276b16a9-64e7-4ab0-bc4b-a02d73835bfb"],
    "ICoreTextEditContext": ["bf6608af-4041-47c3-b263-a918eb5eaef2"],
    "ICoreTextEditContext2": ["b1867dbb-083b-49e1-b281-2b35d62bf466"],
    "ICoreTextFormatUpdatingEventArgs": ["7310bd33-b4a8-43b1-b37b-0724d4aca7ab"],
    "ICoreTextLayoutBounds": ["e972c974-4436-4917-80d0-a525e4ca6780"],
    "ICoreTextLayoutRequest": ["2555a8cc-51fd-4f03-98bf-ac78174d68e0"],
    "ICoreTextLayoutRequest2": ["676de624-cd3d-4bcd-bf01-7f7110954511"],
    "ICoreTextLayoutRequestedEventArgs": ["b1dc6ae0-9a7b-4e9e-a566-4a6b5f8ad676"],
    "ICoreTextSelectionRequest": ["f0a70403-208b-4301-883c-74ca7485fd8d"],
    "ICoreTextSelectionRequestedEventArgs": ["13c6682b-f614-421a-8f4b-9ec8a5a37fcd"],
    "ICoreTextSelectionUpdatingEventArgs": ["d445839f-fe7f-4bd5-8a26-0922c1b3e639"],
    "ICoreTextServicesManager": ["c2507d83-6e0a-4a8a-bdf8-1948874854ba"],
    "ICoreTextServicesManagerStatics": ["1520a388-e2cf-4d65-aeb9-b32d86fe39b9"],
    "ICoreTextServicesStatics": ["91859a46-eccf-47a4-8ae7-098a9c6fbb15"],
    "ICoreTextTextRequest": ["50d950a9-f51e-4cc1-8ca1-e6346d1a61be"],
    "ICoreTextTextRequestedEventArgs": ["f096a2d0-41c6-4c02-8b1a-d953b00cabb3"],
    "ICoreTextTextUpdatingEventArgs": ["eea7918d-cc2b-4f03-8ff6-02fd217db450"],
    "ICoreTouchHitTesting": ["b1d8a289-3acf-4124-9fa3-ea8aba353c21"],
    "ICoreUserActivityManagerStatics": ["ca3adb02-a4be-4d4d-bfa8-6795f4264efb"],
    "ICoreWebViewPrivate": ["f26091c4-5805-4cc0-bcc9-0f078b86949d"],
    "ICoreWetStrokeUpdateEventArgs": ["fb07d14c-3380-457a-a987-991357896c1b"],
    "ICoreWetStrokeUpdateSource": ["1f718e22-ee52-4e00-8209-4c3e5b21a3cc"],
    "ICoreWetStrokeUpdateSourceStatics": ["3dad9cba-1d3d-46ae-ab9d-8647486c6f90"],
    "ICoreWindow": ["79b9d5f2-879e-4b89-b798-79e47598030c"],
    "ICoreWindow2": ["7c2b1b85-6917-4361-9c02-0d9e3a420b95"],
    "ICoreWindow3": ["32c20dd8-faef-4375-a2ab-32640e4815c7"],
    "ICoreWindow4": ["35caf0d0-47f0-436c-af97-0dd88f6f5f02"],
    "ICoreWindow5": ["4b4ae1e1-2e6d-4eaa-bda1-1c5cc1bee141"],
    "ICoreWindowAdapterInterop": ["7a5b6fd1-cd73-4b6c-9cf4-2e869eaf470a"],
    "ICoreWindowComponentInterop": ["0576ab31-a310-4c40-ba31-fd37e0298dfa"],
    "ICoreWindowComponentUIBridge": ["49a4b96a-169e-4d7f-8070-91ac8360ff5e"],
    "ICoreWindowDialog": ["e7392ce0-c78d-427e-8b2c-01ff420c69d5"],
    "ICoreWindowDialogFactory": ["cfb2a855-1c59-4b13-b1e5-16e29805f7c4"],
    "ICoreWindowEventArgs": ["272b1ef3-c633-4da5-a26c-c6d0f56b29da"],
    "ICoreWindowFactory": ["cd292360-2763-4085-8a9f-74b224a29175"],
    "ICoreWindowFactoryPriv": ["087ca5a4-8cfc-4264-b39d-da2bb2583a11"],
    "ICoreWindowFactoryPrivCallbackProvider": ["4208d435-b020-4346-ae40-2a4796084296"],
    "ICoreWindowFactoryPrivCallbackSink": ["91f0a4af-1ba8-461d-b57d-6d24d7c96a42"],
    "ICoreWindowFlyout": ["e89d854d-2050-40bb-b344-f6f355eeb314"],
    "ICoreWindowFlyoutFactory": ["dec4c6c4-93e8-4f7c-be27-cefaa1af68a7"],
    "ICoreWindowInterop": ["45d64a29-a63e-4cb6-b498-5781d298cb4f"],
    "ICoreWindowKeyboardInput": ["196b175e-1a33-4b17-9935-338ef6443477"],
    "ICoreWindowPopupShowingEventArgs": ["26155fa2-5ba5-4ea4-a3b4-2dc7d63c8e26"],
    "ICoreWindowResizeManager": ["b8f0b925-b350-48b3-a198-5c1a84700243"],
    "ICoreWindowResizeManagerLayoutCapability": ["bb74f27b-a544-4301-80e6-0ae033ef4536"],
    "ICoreWindowResizeManagerStatics": ["ae4a9045-6d70-49db-8e68-46ffbd17d38d"],
    "ICoreWindowStatic": ["4d239005-3c2a-41b1-9022-536bb9cf93b1"],
    "ICoreWindowWithContext": ["9ac40241-3575-4c3b-af66-e8c529d4d06c"],
    "ICornerRadiusHelper": ["fd7be182-1cdb-4288-b8c8-85ee79297bfc"],
    "ICornerRadiusHelperStatics": ["f4a1f659-d4d4-451f-a387-d6bf4b2451d4"],
    "ICorrelationEngine": ["a188440e-db11-45b8-b42c-b2149fa71453"],
    "ICorrelationVectorInformation": ["83c78b3c-d88b-4950-aa6e-22b8d22aabd3"],
    "ICorrelationVectorSource": ["152b8a3b-b9b9-4685-b56e-974847bc7545"],
    "ICortanaActionableInsights": ["951ec6b1-fc83-586d-8b84-2452c8981625"],
    "ICortanaActionableInsightsOptions": ["aac2bbcf-9782-5420-b81e-7ae56af31815"],
    "ICortanaActionableInsightsStatics": ["b5ded412-9d2f-5cb5-9b05-356a0b836c10"],
    "ICortanaExperienceFlow": ["37c30b2c-2c34-45bc-bb87-62126979a511"],
    "ICortanaPermissionsManager": ["191330e0-8695-438a-9545-3da4e822ddb4"],
    "ICortanaPermissionsManagerStatics": ["76b1e67a-b045-4414-9d6d-2ad3a5fe3a7e"],
    "ICortanaSettings": ["54d571a7-8062-40f4-abe7-dedfd697b019"],
    "ICortanaSettingsStatics": ["8b2ccd7e-2ec0-446d-9285-33f07ce8ac04"],
    "ICounterItem": ["771a9520-ee28-11ce-941e-008029004347"],
    "ICounterItem2": ["eefcd4e1-ea1c-4435-b7f4-e341ba03b4f9"],
    "ICounters": ["79167962-28fc-11cf-942f-008029004347"],
    "ICplSpellCheckerFactory": ["91f68443-3842-4df6-baee-f505c923360f"],
    "ICreateAudioDeviceInputNodeResult": ["16eec7a8-1ca7-40ef-91a4-d346e0aa1bba"],
    "ICreateAudioDeviceInputNodeResult2": ["921c69ce-3f35-41c7-9622-79f608baedc2"],
    "ICreateAudioDeviceOutputNodeResult": ["f7776d27-1d9a-47f7-9cd4-2859cc1b7bff"],
    "ICreateAudioDeviceOutputNodeResult2": ["4864269f-bdce-4ab1-bd38-fbae93aedaca"],
    "ICreateAudioFileInputNodeResult": ["ce83d61c-e297-4c50-9ce7-1c7a69d6bd09"],
    "ICreateAudioFileInputNodeResult2": ["f9082020-3d80-4fe0-81c1-768fea7ca7e0"],
    "ICreateAudioFileOutputNodeResult": ["47d6ba7b-e909-453f-866e-5540cda734ff"],
    "ICreateAudioFileOutputNodeResult2": ["9f01b50d-3318-47b3-a60a-1b492be7fc0d"],
    "ICreateAudioGraphResult": ["5453ef7e-7bde-4b76-bb5d-48f79cfc8c0b"],
    "ICreateAudioGraphResult2": ["6d738dfc-88c6-4fcb-a534-85cedd4050a1"],
    "ICreateDefaultValueCallback": ["d6ecb12c-15b5-4ec8-b95c-cdd208f08153"],
    "ICreateDeviceAccessAsync": ["3474628f-683d-42d2-abcb-db018c6503bc"],
    "ICreateLibraryCallback": ["10c0729b-efd1-49b9-aa7a-db81386a8cf7"],
    "ICreateMediaSourceAudioInputNodeResult": ["46a658a3-53c0-4d59-9e51-cc1d1044a4c4"],
    "ICreateMediaSourceAudioInputNodeResult2": ["63514ce8-6a1a-49e3-97ec-28fd5be114e5"],
    "ICreateNewLink": ["b5ab9c96-c11d-43e7-b44c-79b13ee7ac6f"],
    "ICreateObject": ["75121952-e0d0-43e5-9380-1d80483acf72"],
    "ICreateObjectEx": ["b13b9a9e-0e4d-4669-9f10-4889129a5d41"],
    "ICreatePerInterfacePSFactory": ["0d3acec7-6972-1380-e40a-77e59ab56400"],
    "ICreateProcessInputs": ["f6ef6140-e26f-4d82-bac4-e9ba5fd239a8"],
    "ICreatePropBagOnRegKey": ["8a674b48-1f63-11d3-b64c-00c04f79498e"],
    "ICreateRestrictedErrorInfo": ["66818b96-dc17-4c12-8ca1-8e1fbaa5bf80"],
    "ICreateResultSetsCallback": ["2e9d9dca-dd6e-4fee-b704-ff1e06001f6e"],
    "ICreateRow": ["0c733ab2-2a1c-11ce-ade5-00aa0044773d"],
    "ICreateStorageFile": ["4dac8671-4d47-42df-a831-54e268dd0da1"],
    "ICreateStreamedFileFromUriDelegate": ["4fddeaf4-d857-4b54-9f71-36b1ce2b5c7c"],
    "ICreateWithLocalTransaction": ["227ac7a8-8423-42ce-b7cf-03061ec9aaa3"],
    "ICreatedProcess": ["c2b937aa-3110-4398-8a56-f34c6342d244"],
    "ICreatingProcess": ["c2b937a9-3110-4398-8a56-f34c6342d244"],
    "ICreatingProcessError": ["515e6577-fe07-457b-bae3-6bd0fa8e3c84"],
    "ICredProviderCredentialSerialization": ["b1534289-3c01-41d3-bb58-ff279bf807a3"],
    "ICredUIBroker": ["0129ca94-3d53-4386-bcef-f773d0e46cc1"],
    "ICredUILocalServiceBroker": ["c76cd2e4-1e90-440a-8e08-1cd1812d9bed"],
    "ICredentialBroker": ["2e3bd64b-6a82-4da0-b49e-92a8b4bd59f4"],
    "ICredentialCacheSessionData": ["7096c91c-c33e-427a-b7cc-de5dc12b298b"],
    "ICredentialCommand": ["a5f665e6-6143-4a7a-a971-b017ba978ce2"],
    "ICredentialCommandCredentialDeletedHandler": ["61c0e185-0977-4678-b4e2-98727afbeed9"],
    "ICredentialCommandFactory": ["27e88c17-bc3e-4b80-9495-4ed720e48a91"],
    "ICredentialFactory": ["54ef13a1-bf26-47b5-97dd-de779b7cad58"],
    "ICredentialPickerOptions": ["965a0b4c-95fa-467f-992b-0b22e5859bf6"],
    "ICredentialPickerResults": ["1948f99a-cc30-410c-9c38-cc0884c5b3d7"],
    "ICredentialPickerStatics": ["aa3a5c73-c9ea-4782-99fb-e6d7e938e12d"],
    "ICredentialPromptOption": ["6f2e6c03-6d22-44b4-b08a-0b9c49e023c1"],
    "ICredentialProvider": ["d27c3481-5a1c-45b2-8aaa-c20ebbe8229e"],
    "ICredentialProviderCredential": ["63913a93-40c1-481a-818d-4072ff8c70cc"],
    "ICredentialProviderCredential2": ["fd672c54-40ea-4d6e-9b49-cfb1a7507bd7"],
    "ICredentialProviderCredentialEvents": ["fa6fa76b-66b7-4b11-95f1-86171118e816"],
    "ICredentialProviderCredentialEvents2": ["b53c00b6-9922-4b78-b1f4-ddfe774dc39b"],
    "ICredentialProviderCredentialWithFieldOptions": ["dbc6fb30-c843-49e3-a645-573e6f39446a"],
    "ICredentialProviderEvents": ["34201e5a-a787-41a3-a5a4-bd6dcf2a854e"],
    "ICredentialProviderFilter": ["a5da53f9-d475-4080-a120-910c4a739880"],
    "ICredentialProviderSetUserArray": ["095c1484-1c0c-4388-9c6d-500e61bf84bd"],
    "ICredentialProviderUser": ["13793285-3ea6-40fd-b420-15f47da41fbb"],
    "ICredentialProviderUserArray": ["90c119ae-0f18-4520-a1f1-114366a40fe8"],
    "ICredentialRecoveryData": ["239d58cc-793c-4b64-8320-b51380087c0b"],
    "ICrossApartmentProtocolHandler": ["7daf9908-8415-4005-95ae-bd27f6e3dc00"],
    "ICrossSlidingEventArgs": ["e9374738-6f88-41d9-8720-78e08e398349"],
    "ICrossSlidingEventArgs2": ["eefb7d48-c070-59f3-8dab-bcaf621d8687"],
    "ICryptAttribute": ["728ab32c-217d-11da-b2a4-000e7bbb2b09"],
    "ICryptAttributes": ["728ab32d-217d-11da-b2a4-000e7bbb2b09"],
    "ICryptographicBufferStatics": ["320b7e22-3cb0-4cdf-8663-1d28910065eb"],
    "ICryptographicEngineStatics": ["9fea0639-6ff7-4c85-a095-95eb31715eb9"],
    "ICryptographicEngineStatics2": ["675948fe-df9f-4191-92c7-6ce6f58420e0"],
    "ICryptographicKey": ["ed2a3b70-8e7b-4009-8401-ffd1a62eeb27"],
    "ICspAlgorithm": ["728ab305-217d-11da-b2a4-000e7bbb2b09"],
    "ICspAlgorithms": ["728ab306-217d-11da-b2a4-000e7bbb2b09"],
    "ICspInformation": ["728ab307-217d-11da-b2a4-000e7bbb2b09"],
    "ICspInformations": ["728ab308-217d-11da-b2a4-000e7bbb2b09"],
    "ICspStatus": ["728ab309-217d-11da-b2a4-000e7bbb2b09"],
    "ICspStatuses": ["728ab30a-217d-11da-b2a4-000e7bbb2b09"],
    "ICubicBezierEasingFunction": ["32350666-c1e8-44f9-96b8-c98acf0ae698"],
    "ICubicEase": ["1b94fc76-dad7-4354-b1a2-7969fbf6a70d"],
    "ICurrencyAmount": ["74b49942-eb75-443a-95b3-7d723f56f93c"],
    "ICurrencyAmountFactory": ["48d7168f-ef3b-4aee-a6a1-4b036fe03ff0"],
    "ICurrencyFormatter": ["11730ca5-4b00-41b2-b332-73b12a497d54"],
    "ICurrencyFormatter2": ["072c2f1d-e7ba-4197-920e-247c92f7dea6"],
    "ICurrencyFormatterFactory": ["86c7537e-b938-4aa2-84b0-2c33dc5b1450"],
    "ICurrencyIdentifiersStatics": ["9f1d091b-d586-4913-9b6a-a9bd2dc12874"],
    "ICurrencyIdentifiersStatics2": ["1814797f-c3b2-4c33-9591-980011950d37"],
    "ICurrencyIdentifiersStatics3": ["4fb23bfa-ed25-4f4d-857f-237f1748c21c"],
    "ICurrentApp": ["d52dc065-da3f-4685-995e-9b482eb5e603"],
    "ICurrentApp2Statics": ["df4e6e2d-3171-4ad3-8614-2c61244373cb"],
    "ICurrentAppSimulator": ["f17f9db1-74cd-4787-9787-19866e9a5559"],
    "ICurrentAppSimulatorStaticsWithFiltering": ["617e70e2-f86f-4b54-9666-dde285092c68"],
    "ICurrentAppSimulatorWithCampaignId": ["84678a43-df00-4672-a43f-b25b1441cfcf"],
    "ICurrentAppSimulatorWithConsumables": ["4e51f0ab-20e7-4412-9b85-59bb78388667"],
    "ICurrentAppStaticsWithFiltering": ["d36d6542-9085-438e-97ba-a25c976be2fd"],
    "ICurrentAppWithCampaignId": ["312f4cd0-36c1-44a6-b32b-432d608e4dd6"],
    "ICurrentAppWithConsumables": ["844e0071-9e4f-4f79-995a-5f91172e6cef"],
    "ICurrentChangingEventArgs": ["f9891e29-51cc-47dd-a5b9-35dc4914af69"],
    "ICurrentChangingEventArgsFactory": ["153bbeee-62f3-48cf-8183-8be26de3a66e"],
    "ICurrentChangingEventHandler": ["f3888db8-139f-4dce-8dc9-f7f1444d1185"],
    "ICurrentItem": ["240a7174-d653-4a1d-a6d3-d4943cfbfe3d"],
    "ICurrentMediaPlaybackItemChangedEventArgs": ["1743a892-5c43-4a15-967a-572d2d0f26c6"],
    "ICurrentMediaPlaybackItemChangedEventArgs2": ["1d80a51e-996e-40a9-be48-e66ec90b2b7d"],
    "ICurrentRecordInstance": ["3050f328-98b5-11cf-bb82-00aa00bdce0b"],
    "ICurrentSessionChangedEventArgs": ["6969cb39-0bfa-5fe0-8d73-09cc5e5408e1"],
    "ICurrentTimeChangeRequestedEventArgs": ["99711324-edc7-4bf5-91f6-3c8627db59e5"],
    "ICustomDelegateCallback": ["07d7b3d2-6f11-48d3-9fda-abfc644fd9bf"],
    "ICustomDestinationList": ["6332debf-87b5-4670-90c0-5e57b408a49e"],
    "ICustomDevice": ["dd30251f-c48b-43bd-bcb1-dec88f15143e"],
    "ICustomDeviceStatics": ["c8220312-ef4c-46b1-a58e-eeb308dc8917"],
    "ICustomDialog": ["e000160d-dd29-4f11-b56f-4f2fdf75bc8b"],
    "ICustomFilterInfo": ["1d335dff-6f88-4e4d-91a8-a3f351cfd473"],
    "ICustomGameControllerFactory": ["69a0ae5e-758e-4cbe-ace6-62155fe9126f"],
    "ICustomIconManager": ["7e23d323-36d6-4eb2-a654-387832868ea3"],
    "ICustomMapTileDataSource": ["65da384a-2db1-4be1-b155-3d0c9ecf4799"],
    "ICustomMapTileDataSourceFactory": ["c8477947-c955-4f22-9444-a1d8d744af11"],
    "ICustomNavigationProvider": ["2062a28a-8c07-4b94-8e12-7037c622aeb8", "2bd8a6d0-2fa3-4717-b28c-4917ce54928d"],
    "ICustomProperty": ["30da92c0-23e8-42a0-ae7c-734a0e5d2782"],
    "ICustomPropertyProvider": ["7c925755-3e48-42b4-8677-76372267033f"],
    "ICustomSensor": ["a136f9ad-4034-4b4d-99dd-531aac649c09"],
    "ICustomSensor2": ["20db3111-ec58-4d9f-bfbd-e77825088510"],
    "ICustomSensorReading": ["64004f4d-446a-4366-a87a-5f963268ec53"],
    "ICustomSensorReading2": ["223c98ea-bf73-4992-9a48-d3c897594ccb"],
    "ICustomSensorReadingChangedEventArgs": ["6b202023-cffd-4cc1-8ff0-e21823d76fcc"],
    "ICustomSensorStatics": ["992052cf-f422-4c7d-836b-e7dc74a7124b"],
    "ICustomShellManager": ["0b86d836-f65d-4516-a7e9-5ba7c2681877"],
    "ICustomSystemEventTrigger": ["f3596798-cf6b-4ef4-a0ca-29cf4a278c87"],
    "ICustomSystemEventTriggerFactory": ["6bcb16c5-f2dc-41b2-9efd-b96bdcd13ced"],
    "ICustomXamlResourceLoader": ["511a84ab-4a88-419f-852e-54083b90b078"],
    "ICustomXamlResourceLoaderFactory": ["5bfd7e49-7886-44f3-8ed3-6fec0463ed69"],
    "ICustomXamlResourceLoaderOverrides": ["f851e991-af02-46e8-9af8-427b7ebfe9f8"],
    "ICustomXamlResourceLoaderStatics": ["224ff617-e4dc-4c27-ad32-db93d5d0e5da"],
    "ICustomizeInfoTip": ["da22171f-70b4-43db-b38f-296741d1494c"],
    "ID2D1AnalysisTransform": ["0359dc30-95e6-4568-9055-27720d130e93"],
    "ID2D1Bitmap": ["a2296057-ea42-4099-983b-539fb6505426"],
    "ID2D1Bitmap1": ["a898a84c-3873-4588-b08b-ebbf978df041"],
    "ID2D1BitmapBrush": ["2cd906aa-12e2-11dc-9fed-001143a055f9"],
    "ID2D1BitmapBrush1": ["41343a53-e41a-49a2-91cd-21793bbb62e5"],
    "ID2D1BitmapRenderTarget": ["2cd90695-12e2-11dc-9fed-001143a055f9"],
    "ID2D1BlendTransform": ["63ac0b32-ba44-450f-8806-7f4ca1ff2f1b"],
    "ID2D1BorderTransform": ["4998735c-3a19-473c-9781-656847e3a347"],
    "ID2D1BoundsAdjustmentTransform": ["90f732e2-5092-4606-a819-8651970baccd"],
    "ID2D1Brush": ["2cd906a8-12e2-11dc-9fed-001143a055f9"],
    "ID2D1ColorContext": ["1c4820bb-5771-4518-a581-2fe4dd0ec657"],
    "ID2D1ColorContext1": ["1ab42875-c57f-4be9-bd85-9cd78d6f55ee"],
    "ID2D1CommandList": ["b4f34a19-2383-4d76-94f6-ec343657c3dc"],
    "ID2D1CommandSink": ["54d7898a-a061-40a7-bec7-e465bcba2c4f"],
    "ID2D1CommandSink1": ["9eb767fd-4269-4467-b8c2-eb30cb305743"],
    "ID2D1CommandSink2": ["3bab440e-417e-47df-a2e2-bc0be6a00916"],
    "ID2D1CommandSink3": ["18079135-4cf3-4868-bc8e-06067e6d242d"],
    "ID2D1CommandSink4": ["c78a6519-40d6-4218-b2de-beeeb744bb3e"],
    "ID2D1CommandSink5": ["7047dd26-b1e7-44a7-959a-8349e2144fa8"],
    "ID2D1ComputeInfo": ["5598b14b-9fd7-48b7-9bdb-8f0964eb38bc"],
    "ID2D1ComputeTransform": ["0d85573c-01e3-4f7d-bfd9-0d60608bf3c3"],
    "ID2D1ConcreteTransform": ["1a799d8a-69f7-4e4c-9fed-437ccc6684cc"],
    "ID2D1DCRenderTarget": ["1c51bc64-de61-46fd-9899-63a5d8f03950"],
    "ID2D1Device": ["47dd575d-ac05-4cdd-8049-9b02cd16f44c"],
    "ID2D1Device1": ["d21768e1-23a4-4823-a14b-7c3eba85d658"],
    "ID2D1Device2": ["a44472e1-8dfb-4e60-8492-6e2861c9ca8b"],
    "ID2D1Device3": ["852f2087-802c-4037-ab60-ff2e7ee6fc01"],
    "ID2D1Device4": ["d7bdb159-5683-4a46-bc9c-72dc720b858b"],
    "ID2D1Device5": ["d55ba0a4-6405-4694-aef5-08ee1a4358b4"],
    "ID2D1Device6": ["7bfef914-2d75-4bad-be87-e18ddb077b6d"],
    "ID2D1DeviceContext": ["e8f7fe7a-191c-466d-ad95-975678bda998"],
    "ID2D1DeviceContext1": ["d37f57e4-6908-459f-a199-e72f24f79987"],
    "ID2D1DeviceContext2": ["394ea6a3-0c34-4321-950b-6ca20f0be6c7"],
    "ID2D1DeviceContext3": ["235a7496-8351-414c-bcd4-6672ab2d8e00"],
    "ID2D1DeviceContext4": ["8c427831-3d90-4476-b647-c4fae349e4db"],
    "ID2D1DeviceContext5": ["7836d248-68cc-4df6-b9e8-de991bf62eb7"],
    "ID2D1DeviceContext6": ["985f7e37-4ed0-4a19-98a3-15b0edfde306"],
    "ID2D1DrawInfo": ["693ce632-7f2f-45de-93fe-18d88b37aa21"],
    "ID2D1DrawTransform": ["36bfdcb6-9739-435d-a30d-a653beff6a6f"],
    "ID2D1DrawingStateBlock": ["28506e39-ebf6-46a1-bb47-fd85565ab957"],
    "ID2D1DrawingStateBlock1": ["689f1f85-c72e-4e33-8f19-85754efd5ace"],
    "ID2D1Effect": ["28211a43-7d89-476f-8181-2d6159b220ad"],
    "ID2D1EffectContext": ["3d9f916b-27dc-4ad7-b4f1-64945340f563"],
    "ID2D1EffectContext1": ["84ab595a-fc81-4546-bacd-e8ef4d8abe7a"],
    "ID2D1EffectContext2": ["577ad2a0-9fc7-4dda-8b18-dab810140052"],
    "ID2D1EffectImpl": ["a248fd3f-3e6c-4e63-9f03-7f68ecc91db9"],
    "ID2D1EllipseGeometry": ["2cd906a4-12e2-11dc-9fed-001143a055f9"],
    "ID2D1Factory": ["06152247-6f50-465a-9245-118bfd3b6007"],
    "ID2D1Factory1": ["bb12d362-daee-4b9a-aa1d-14ba401cfa1f"],
    "ID2D1Factory2": ["94f81a73-9212-4376-9c58-b16a3a0d3992"],
    "ID2D1Factory3": ["0869759f-4f00-413f-b03e-2bda45404d0f"],
    "ID2D1Factory4": ["bd4ec2d2-0662-4bee-ba8e-6f29f032e096"],
    "ID2D1Factory5": ["c4349994-838e-4b0f-8cab-44997d9eeacc"],
    "ID2D1Factory6": ["f9976f46-f642-44c1-97ca-da32ea2a2635"],
    "ID2D1Factory7": ["bdc2bdd3-b96c-4de6-bdf7-99d4745454de"],
    "ID2D1GdiInteropRenderTarget": ["e0db51c3-6f77-4bae-b3d5-e47509b35838"],
    "ID2D1GdiMetafile": ["2f543dc3-cfc1-4211-864f-cfd91c6f3395"],
    "ID2D1GdiMetafile1": ["2e69f9e8-dd3f-4bf9-95ba-c04f49d788df"],
    "ID2D1GdiMetafileSink": ["82237326-8111-4f7c-bcf4-b5c1175564fe"],
    "ID2D1GdiMetafileSink1": ["fd0ecb6b-91e6-411e-8655-395e760f91b4"],
    "ID2D1Geometry": ["2cd906a1-12e2-11dc-9fed-001143a055f9"],
    "ID2D1GeometryGroup": ["2cd906a6-12e2-11dc-9fed-001143a055f9"],
    "ID2D1GeometryRealization": ["a16907d7-bc02-4801-99e8-8cf7f485f774"],
    "ID2D1GeometrySink": ["2cd9069f-12e2-11dc-9fed-001143a055f9"],
    "ID2D1GradientMesh": ["f292e401-c050-4cde-83d7-04962d3b23c2"],
    "ID2D1GradientStopCollection": ["2cd906a7-12e2-11dc-9fed-001143a055f9"],
    "ID2D1GradientStopCollection1": ["ae1572f4-5dd0-4777-998b-9279472ae63b"],
    "ID2D1HwndRenderTarget": ["2cd90698-12e2-11dc-9fed-001143a055f9"],
    "ID2D1Image": ["65019f75-8da2-497c-b32c-dfa34e48ede6"],
    "ID2D1ImageBrush": ["fe9e984d-3f95-407c-b5db-cb94d4e8f87c"],
    "ID2D1ImageSource": ["c9b664e5-74a1-4378-9ac2-eefc37a3f4d8"],
    "ID2D1ImageSourceFromWic": ["77395441-1c8f-4555-8683-f50dab0fe792"],
    "ID2D1ImageSourceFromWicHardware": ["9c1c9525-dd79-432a-b941-5456bf07284d"],
    "ID2D1Ink": ["b499923b-7029-478f-a8b3-432c7c5f5312"],
    "ID2D1InkStyle": ["bae8b344-23fc-4071-8cb5-d05d6f073848"],
    "ID2D1Layer": ["2cd9069b-12e2-11dc-9fed-001143a055f9"],
    "ID2D1LinearGradientBrush": ["2cd906ab-12e2-11dc-9fed-001143a055f9"],
    "ID2D1LookupTable3D": ["53dd9855-a3b0-4d5b-82e1-26e25c5e5797"],
    "ID2D1Mesh": ["2cd906c2-12e2-11dc-9fed-001143a055f9"],
    "ID2D1Multithread": ["31e6e7bc-e0ff-4d46-8c64-a0a8c41c15d3"],
    "ID2D1OffsetTransform": ["3fe6adea-7643-4f53-bd14-a0ce63f24042"],
    "ID2D1PathGeometry": ["2cd906a5-12e2-11dc-9fed-001143a055f9"],
    "ID2D1PathGeometry1": ["62baa2d2-ab54-41b7-b872-787e0106a421"],
    "ID2D1PrintControl": ["2c1d867d-c290-41c8-ae7e-34a98702e9a5"],
    "ID2D1PrivateTestDevice": ["5f1729fe-8904-42b2-bca3-d96a703cb445"],
    "ID2D1Properties": ["483473d7-cd46-4f9d-9d3a-3112aa80159d"],
    "ID2D1RadialGradientBrush": ["2cd906ac-12e2-11dc-9fed-001143a055f9"],
    "ID2D1RectangleGeometry": ["2cd906a2-12e2-11dc-9fed-001143a055f9"],
    "ID2D1RenderInfo": ["519ae1bd-d19a-420d-b849-364f594776b7"],
    "ID2D1RenderTarget": ["2cd90694-12e2-11dc-9fed-001143a055f9"],
    "ID2D1Resource": ["2cd90691-12e2-11dc-9fed-001143a055f9"],
    "ID2D1ResourceTexture": ["688d15c3-02b0-438d-b13a-d1b44c32c39a"],
    "ID2D1ResourceWeakReference": ["e2379834-a3b5-46e0-871b-e74a145c8f45"],
    "ID2D1RoundedRectangleGeometry": ["2cd906a3-12e2-11dc-9fed-001143a055f9"],
    "ID2D1SimplifiedGeometrySink": ["2cd9069e-12e2-11dc-9fed-001143a055f9"],
    "ID2D1SolidColorBrush": ["2cd906a9-12e2-11dc-9fed-001143a055f9"],
    "ID2D1SourceTransform": ["db1800dd-0c34-4cf9-be90-31cc0a5653e1"],
    "ID2D1SpriteBatch": ["4dc583bf-3a10-438a-8722-e9765224f1f1"],
    "ID2D1StrokeStyle": ["2cd9069d-12e2-11dc-9fed-001143a055f9"],
    "ID2D1StrokeStyle1": ["10a72a66-e91c-43f4-993f-ddf4b82b0b4a"],
    "ID2D1SvgAttribute": ["c9cdb0dd-f8c9-4e70-b7c2-301c80292c5e"],
    "ID2D1SvgDocument": ["86b88e4d-afa4-4d7b-88e4-68a51c4a0aec"],
    "ID2D1SvgElement": ["ac7b67a6-183e-49c1-a823-0ebe40b0db29"],
    "ID2D1SvgGlyphStyle": ["af671749-d241-4db8-8e41-dcc2e5c1a438"],
    "ID2D1SvgPaint": ["d59bab0a-68a2-455b-a5dc-9eb2854e2490"],
    "ID2D1SvgPathData": ["c095e4f4-bb98-43d6-9745-4d1b84ec9888"],
    "ID2D1SvgPointCollection": ["9dbe4c0d-3572-4dd9-9825-5530813bb712"],
    "ID2D1SvgStrokeDashArray": ["f1c0ca52-92a3-4f00-b4ce-f35691efd9d9"],
    "ID2D1TessellationSink": ["2cd906c1-12e2-11dc-9fed-001143a055f9"],
    "ID2D1Transform": ["ef1a287d-342a-4f76-8fdb-da0d6ea9f92b"],
    "ID2D1TransformGraph": ["13d29038-c3e6-4034-9081-13b53a417992"],
    "ID2D1TransformNode": ["b2efe1e7-729f-4102-949f-505fa21bf666"],
    "ID2D1TransformedGeometry": ["2cd906bb-12e2-11dc-9fed-001143a055f9"],
    "ID2D1TransformedImageSource": ["7f1f79e5-2796-416c-8f55-700f911445e5"],
    "ID2D1VertexBuffer": ["9b8b1336-00a5-4668-92b7-ced5d8bf9b7b"],
    "ID3D10BlendState1": ["edad8d99-8a35-4d6d-8566-2ea276cde161"],
    "ID3D10Blob": ["8ba5fb08-5195-40e2-ac58-0d989c3a0102"],
    "ID3D10Device1": ["9b7e4c8f-342c-4106-a19f-4f2704f689f0"],
    "ID3D10EffectPool": ["9537ab04-3250-412e-8213-fcd2f8677933"],
    "ID3D10ShaderReflection1": ["c3457783-a846-47ce-9520-cea6f66e7447"],
    "ID3D10ShaderResourceView1": ["9b7e4c87-342c-4106-a19f-4f2704f689f0"],
    "ID3D11Asynchronous": ["4b35d0cd-1e15-4258-9c98-1b1333f6dd3b"],
    "ID3D11AuthenticatedChannel": ["3015a308-dcbd-47aa-a747-192486d14d4a"],
    "ID3D11BlendState": ["75b68faa-347d-4159-8f45-a0640f01cd9a"],
    "ID3D11BlendState1": ["cc86fabe-da55-401d-85e7-e3c9de2877e9"],
    "ID3D11Buffer": ["48570b85-d1ee-4fcd-a250-eb350722b037"],
    "ID3D11ClassInstance": ["a6cd7faa-b0b7-4a2f-9436-8662a65797cb"],
    "ID3D11ClassLinkage": ["ddf57cba-9543-46e4-a12b-f207a0fe7fed"],
    "ID3D11CommandList": ["a24bc4d1-769e-43f7-8013-98ff566c18e2"],
    "ID3D11ComputeShader": ["4f5b196e-c2bd-495e-bd01-1fded38e4969"],
    "ID3D11Counter": ["6e8c49fb-a371-4770-b440-29086022b741"],
    "ID3D11CryptoSession": ["9b32f9ad-bdcc-40a6-a39d-d5c865845720"],
    "ID3D11Debug": ["79cf2233-7536-4948-9d36-1e4692dc5760"],
    "ID3D11DepthStencilState": ["03823efb-8d8f-4e1c-9aa2-f64bb2cbfdf1"],
    "ID3D11DepthStencilView": ["9fdac92a-1876-48c3-afad-25b94f84a9b6"],
    "ID3D11Device": ["db6f6ddb-ac77-4e88-8253-819df9bbf140"],
    "ID3D11Device1": ["a04bfb29-08ef-43d6-a49c-a9bdbdcbe686"],
    "ID3D11Device2": ["9d06dffa-d1e5-4d07-83a8-1bb123f2f841"],
    "ID3D11Device3": ["a05c8c37-d2c6-4732-b3a0-9ce0b0dc9ae6"],
    "ID3D11Device4": ["8992ab71-02e6-4b8d-ba48-b056dcda42c4"],
    "ID3D11Device5": ["8ffde202-a0e7-45df-9e01-e837801b5ea0"],
    "ID3D11DeviceChild": ["1841e5c8-16b0-489b-bcc8-44cfb0d5deae"],
    "ID3D11DeviceContext": ["c0bfa96c-e089-44fb-8eaf-26f8796190da"],
    "ID3D11DeviceContext1": ["bb2c6faa-b5fb-4082-8e6b-388b8cfa90e1"],
    "ID3D11DeviceContext2": ["420d5b32-b90c-4da4-bef0-359f6a24a83a"],
    "ID3D11DeviceContext3": ["b4e3c01d-e79e-4637-91b2-510e9f4c9b8f"],
    "ID3D11DeviceContext4": ["917600da-f58c-4c33-98d8-3e15b390fa24"],
    "ID3D11DomainShader": ["f582c508-0f36-490c-9977-31eece268cfa"],
    "ID3D11Fence": ["affde9d1-1df7-4bb7-8a34-0f46251dab80"],
    "ID3D11FunctionLinkingGraph": ["54133220-1ce8-43d3-8236-9855c5ceecff"],
    "ID3D11FunctionParameterReflection": ["42757488-334f-47fe-982e-1a65d08cc462"],
    "ID3D11FunctionReflection": ["207bcecb-d683-4a06-a8a3-9b149b9f73a4"],
    "ID3D11GeometryShader": ["38325b96-effb-4022-ba02-2e795b70275c"],
    "ID3D11HullShader": ["8e5c6061-628a-4c8e-8264-bbe45cb3d5dd"],
    "ID3D11InfoQueue": ["6543dbb6-1b48-42f5-ab82-e97ec74326f6"],
    "ID3D11InputLayout": ["e4819ddc-4cf0-4025-bd26-5de82a3e07b7"],
    "ID3D11LibraryReflection": ["54384f1b-5b3e-4bb7-ae01-60ba3097cbb6"],
    "ID3D11Linker": ["59a6cd0e-e10d-4c1f-88c0-63aba1daf30e"],
    "ID3D11LinkingNode": ["d80dd70c-8d2f-4751-94a1-03c79b3556db"],
    "ID3D11Module": ["cac701ee-80fc-4122-8242-10b39c8cec34"],
    "ID3D11ModuleInstance": ["469e07f7-045a-48d5-aa12-68a478cdf75d"],
    "ID3D11Multithread": ["9b7e4e00-342c-4106-a19f-4f2704f689f0"],
    "ID3D11On12Device": ["85611e73-70a9-490e-9614-a9e302777904"],
    "ID3D11On12Device1": ["bdb64df4-ea2f-4c70-b861-aaab1258bb5d"],
    "ID3D11On12Device2": ["dc90f331-4740-43fa-866e-67f12cb58223"],
    "ID3D11PixelShader": ["ea82e40d-51dc-4f33-93d4-db7c9125ae8c"],
    "ID3D11Predicate": ["9eb576dd-9f77-4d86-81aa-8bab5fe490e2"],
    "ID3D11Query": ["d6c00747-87b7-425e-b84d-44d108560afd"],
    "ID3D11Query1": ["631b4766-36dc-461d-8db6-c47e13e60916"],
    "ID3D11RasterizerState": ["9bb4ab81-ab1a-4d8f-b506-fc04200b6ee7"],
    "ID3D11RasterizerState1": ["1217d7a6-5039-418c-b042-9cbe256afd6e"],
    "ID3D11RasterizerState2": ["6fbd02fb-209f-46c4-b059-2ed15586a6ac"],
    "ID3D11RefDefaultTrackingOptions": ["03916615-c644-418c-9bf4-75db5be63ca0"],
    "ID3D11RefTrackingOptions": ["193dacdf-0db2-4c05-a55c-ef06cac56fd9"],
    "ID3D11RenderTargetView": ["dfdba067-0b8d-4865-875b-d7b4516cc164"],
    "ID3D11RenderTargetView1": ["ffbe2e23-f011-418a-ac56-5ceed7c5b94b"],
    "ID3D11Resource": ["dc8e63f3-d12b-4952-b47b-5e45026a862d"],
    "ID3D11SamplerState": ["da6fea51-564c-4487-9810-f0d0f9b4e3a5"],
    "ID3D11ShaderReflection": ["8d536ca1-0cca-4956-a837-786963755584"],
    "ID3D11ShaderReflectionConstantBuffer": ["eb62d63d-93dd-4318-8ae8-c6f83ad371b8"],
    "ID3D11ShaderReflectionType": ["6e6ffa6a-9bae-4613-a51e-91652d508c21"],
    "ID3D11ShaderReflectionVariable": ["51f23923-f3e5-4bd1-91cb-606177d8db4c"],
    "ID3D11ShaderResourceView": ["b0e06fe0-8192-4e1a-b1ca-36d7414710b2"],
    "ID3D11ShaderResourceView1": ["91308b87-9040-411d-8c67-c39253ce3802"],
    "ID3D11ShaderTrace": ["36b013e6-2811-4845-baa7-d623fe0df104"],
    "ID3D11ShaderTraceFactory": ["1fbad429-66ab-41cc-9617-667ac10e4459"],
    "ID3D11SwitchToRef": ["1ef337e3-58e7-4f83-a692-db221f5ed47e"],
    "ID3D11Texture1D": ["f8fb5c27-c6b3-4f75-a4c8-439af2ef564c"],
    "ID3D11Texture2D": ["6f15aaf2-d208-4e89-9ab4-489535d34f9c"],
    "ID3D11Texture2D1": ["51218251-1e33-4617-9ccb-4d3a4367e7bb"],
    "ID3D11Texture3D": ["037e866e-f56d-4357-a8af-9dabbe6e250e"],
    "ID3D11Texture3D1": ["0c711683-2853-4846-9bb0-f3e60639e46a"],
    "ID3D11TracingDevice": ["1911c771-1587-413e-a7e0-fb26c3de0268"],
    "ID3D11UnorderedAccessView": ["28acf509-7f5c-48f6-8611-f316010a6380"],
    "ID3D11UnorderedAccessView1": ["7b3b6153-a886-4544-ab37-6537c8500403"],
    "ID3D11VertexShader": ["3b301d64-d678-4289-8897-22f8928b72f3"],
    "ID3D11VideoContext": ["61f21c45-3c0e-4a74-9cea-67100d9ad5e4"],
    "ID3D11VideoContext1": ["a7f026da-a5f8-4487-a564-15e34357651e"],
    "ID3D11VideoContext2": ["c4e7374c-6243-4d1b-ae87-52b4f740e261"],
    "ID3D11VideoContext3": ["a9e2faa0-cb39-418f-a0b7-d8aad4de672e"],
    "ID3D11VideoDecoder": ["3c9c5b51-995d-48d1-9b8d-fa5caeded65c"],
    "ID3D11VideoDecoderOutputView": ["c2931aea-2a85-4f20-860f-fba1fd256e18"],
    "ID3D11VideoDevice": ["10ec4d5b-975a-4689-b9e4-d0aac30fe333"],
    "ID3D11VideoDevice1": ["29da1d51-1321-4454-804b-f5fc9f861f0f"],
    "ID3D11VideoDevice2": ["59c0cb01-35f0-4a70-8f67-87905c906a53"],
    "ID3D11VideoProcessor": ["1d7b0652-185f-41c6-85ce-0c5be3d4ae6c"],
    "ID3D11VideoProcessorEnumerator": ["31627037-53ab-4200-9061-05faa9ab45f9"],
    "ID3D11VideoProcessorEnumerator1": ["465217f2-5568-43cf-b5b9-f61d54531ca1"],
    "ID3D11VideoProcessorInputView": ["11ec5a5f-51dc-4945-ab34-6e8c21300ea5"],
    "ID3D11VideoProcessorOutputView": ["a048285e-25a9-4527-bd93-d68b68c44254"],
    "ID3D11View": ["839d1216-bb2e-412b-b7f4-a9dbebe08ed1"],
    "ID3D12CommandAllocator": ["6102dee4-af59-4b09-b999-b44d73f09b24"],
    "ID3D12CommandList": ["7116d91c-e7e4-47ce-b8c6-ec8168f437e5"],
    "ID3D12CommandQueue": ["0ec870a6-5d7e-4c22-8cfc-5baae07616ed"],
    "ID3D12CommandSignature": ["c36a797c-ec80-4f0a-8985-a7b2475082d1"],
    "ID3D12Debug": ["344488b7-6846-474b-b989-f027448245e0"],
    "ID3D12Debug1": ["affaa4ca-63fe-4d8e-b8ad-159000af4304"],
    "ID3D12Debug2": ["93a665c4-a3b2-4e5d-b692-a26ae14e3374"],
    "ID3D12Debug3": ["5cf4e58f-f671-4ff1-a542-3686e3d153d1"],
    "ID3D12DebugCommandList": ["09e0bf36-54ac-484f-8847-4baeeab6053f"],
    "ID3D12DebugCommandList1": ["102ca951-311b-4b01-b11f-ecb83e061b37"],
    "ID3D12DebugCommandList2": ["aeb575cf-4e06-48be-ba3b-c450fc96652e"],
    "ID3D12DebugCommandQueue": ["09e0bf36-54ac-484f-8847-4baeeab6053a"],
    "ID3D12DebugDevice": ["3febd6dd-4973-4787-8194-e45f9e28923e"],
    "ID3D12DebugDevice1": ["a9b71770-d099-4a65-a698-3dee10020f88"],
    "ID3D12DebugDevice2": ["60eccbc1-378d-4df1-894c-f8ac5ce4d7dd"],
    "ID3D12DescriptorHeap": ["8efb471d-616c-4f49-90f7-127bb763fa51"],
    "ID3D12Device": ["189819f1-1db6-4b57-be54-1821339b85f7"],
    "ID3D12Device1": ["77acce80-638e-4e65-8895-c1f23386863e"],
    "ID3D12Device2": ["30baa41e-b15b-475c-a0bb-1af5c5b64328"],
    "ID3D12Device3": ["81dadc15-2bad-4392-93c5-101345c4aa98"],
    "ID3D12Device4": ["e865df17-a9ee-46f9-a463-3098315aa2e5"],
    "ID3D12Device5": ["8b4f173b-2fea-4b80-8f58-4307191ab95d"],
    "ID3D12Device6": ["c70b221b-40e4-4a17-89af-025a0727a6dc"],
    "ID3D12Device7": ["5c014b53-68a1-4b9b-8bd1-dd6046b9358b"],
    "ID3D12Device8": ["9218e6bb-f944-4f7e-a75c-b1b2c7b701f3"],
    "ID3D12DeviceChild": ["905db94b-a00c-4140-9df5-2b64ca9ea357"],
    "ID3D12DeviceRemovedExtendedData": ["98931d33-5ae8-4791-aa3c-1a73a2934e71"],
    "ID3D12DeviceRemovedExtendedData1": ["9727a022-cf1d-4dda-9eba-effa653fc506"],
    "ID3D12DeviceRemovedExtendedDataSettings": ["82bc481c-6b9b-4030-aedb-7ee3d1df1e63"],
    "ID3D12DeviceRemovedExtendedDataSettings1": ["dbd5ae51-3317-4f0a-adf9-1d7cedcaae0b"],
    "ID3D12Fence": ["0a753dcf-c4d8-4b91-adf6-be5a60d95a76"],
    "ID3D12Fence1": ["433685fe-e22b-4ca0-a8db-b5b4f4dd0e4a"],
    "ID3D12FunctionParameterReflection": ["ec25f42d-7006-4f2b-b33e-02cc3375733f"],
    "ID3D12FunctionReflection": ["1108795c-2772-4ba9-b2a8-d464dc7e2799"],
    "ID3D12GraphicsCommandList": ["5b160d0f-ac1b-4185-8ba8-b3ae42a5a455"],
    "ID3D12GraphicsCommandList1": ["553103fb-1fe7-4557-bb38-946d7d0e7ca7"],
    "ID3D12GraphicsCommandList2": ["38c3e585-ff17-412c-9150-4fc6f9d72a28"],
    "ID3D12GraphicsCommandList3": ["6fda83a7-b84c-4e38-9ac8-c7bd22016b3d"],
    "ID3D12GraphicsCommandList4": ["8754318e-d3a9-4541-98cf-645b50dc4874"],
    "ID3D12GraphicsCommandList5": ["55050859-4024-474c-87f5-6472eaee44ea"],
    "ID3D12GraphicsCommandList6": ["c3827890-e548-4cfa-96cf-5689a9370f80"],
    "ID3D12Heap": ["6b3b2502-6e51-45b3-90ee-9884265e8df3"],
    "ID3D12Heap1": ["572f7389-2168-49e3-9693-d6df5871bf6d"],
    "ID3D12InfoQueue": ["0742a90b-c387-483f-b946-30a7e4e61458"],
    "ID3D12LibraryReflection": ["8e349d19-54db-4a56-9dc9-119d87bdb804"],
    "ID3D12LifetimeOwner": ["e667af9f-cd56-4f46-83ce-032e595d70a8"],
    "ID3D12LifetimeTracker": ["3fd03d36-4eb1-424a-a582-494ecb8ba813"],
    "ID3D12MetaCommand": ["dbb84c27-36ce-4fc9-b801-f048c46ac570"],
    "ID3D12Object": ["c4fec28f-7966-4e95-9f94-f431cb56c3b8"],
    "ID3D12Pageable": ["63ee58fb-1268-4835-86da-f008ce62f0d6"],
    "ID3D12PipelineLibrary": ["c64226a8-9201-46af-b4cc-53fb9ff7414f"],
    "ID3D12PipelineLibrary1": ["80eabf42-2568-4e5e-bd82-c37f86961dc3"],
    "ID3D12PipelineState": ["765a30f3-f624-4c6f-a828-ace948622445"],
    "ID3D12ProtectedResourceSession": ["6cd696f4-f289-40cc-8091-5a6c0a099c3d"],
    "ID3D12ProtectedResourceSession1": ["d6f12dd6-76fb-406e-8961-4296eefc0409"],
    "ID3D12ProtectedSession": ["a1533d18-0ac1-4084-85b9-89a96116806b"],
    "ID3D12QueryHeap": ["0d9658ae-ed45-469e-a61d-970ec583cab4"],
    "ID3D12Resource": ["696442be-a72e-4059-bc79-5b5c98040fad"],
    "ID3D12Resource1": ["9d5e227a-4430-4161-88b3-3eca6bb16e19"],
    "ID3D12Resource2": ["be36ec3b-ea85-4aeb-a45a-e9d76404a495"],
    "ID3D12RootSignature": ["c54a6b66-72df-4ee8-8be5-a946a1429214"],
    "ID3D12RootSignatureDeserializer": ["34ab647b-3cc8-46ac-841b-c0965645c046"],
    "ID3D12ShaderReflection": ["5a58797d-a72c-478d-8ba2-efc6b0efe88e"],
    "ID3D12ShaderReflectionConstantBuffer": ["c59598b4-48b3-4869-b9b1-b1618b14a8b7"],
    "ID3D12ShaderReflectionType": ["e913c351-783d-48ca-a1d1-4f306284ad56"],
    "ID3D12ShaderReflectionVariable": ["8337a8a6-a216-444a-b2f4-314733a73aea"],
    "ID3D12SharingContract": ["0adf7d52-929c-4e61-addb-ffed30de66ef"],
    "ID3D12StateObject": ["47016943-fca8-4594-93ea-af258b55346d"],
    "ID3D12StateObjectProperties": ["de5fa827-9bf9-4f26-89ff-d7f56fde3860"],
    "ID3D12SwapChainAssistant": ["f1df64b6-57fd-49cd-8807-c0eb88b45c8f"],
    "ID3D12Tools": ["7071e1f0-e84b-4b33-974f-12fa49de65c5"],
    "ID3D12VersionedRootSignatureDeserializer": ["7f91ce67-090c-4bb7-b78e-ed8ff2e31da0"],
    "ID3D12VideoDecodeCommandList": ["3b60536e-ad29-4e64-a269-f853837e5e53"],
    "ID3D12VideoDecodeCommandList1": ["d52f011b-b56e-453c-a05a-a7f311c8f472"],
    "ID3D12VideoDecodeCommandList2": ["6e120880-c114-4153-8036-d247051e1729"],
    "ID3D12VideoDecoder": ["c59b6bdc-7720-4074-a136-17a156037470"],
    "ID3D12VideoDecoder1": ["79a2e5fb-ccd2-469a-9fde-195d10951f7e"],
    "ID3D12VideoDecoderHeap": ["0946b7c9-ebf6-4047-bb73-8683e27dbb1f"],
    "ID3D12VideoDecoderHeap1": ["da1d98c5-539f-41b2-bf6b-1198a03b6d26"],
    "ID3D12VideoDevice": ["1f052807-0b46-4acc-8a89-364f793718a4"],
    "ID3D12VideoDevice1": ["981611ad-a144-4c83-9890-f30e26d658ab"],
    "ID3D12VideoDevice2": ["f019ac49-f838-4a95-9b17-579437c8f513"],
    "ID3D12VideoEncodeCommandList": ["8455293a-0cbd-4831-9b39-fbdbab724723"],
    "ID3D12VideoEncodeCommandList1": ["94971eca-2bdb-4769-88cf-3675ea757ebc"],
    "ID3D12VideoExtensionCommand": ["554e41e8-ae8e-4a8c-b7d2-5b4f274a30e4"],
    "ID3D12VideoMotionEstimator": ["33fdae0e-098b-428f-87bb-34b695de08f8"],
    "ID3D12VideoMotionVectorHeap": ["5be17987-743a-4061-834b-23d22daea505"],
    "ID3D12VideoProcessCommandList": ["aeb2543a-167f-4682-acc8-d159ed4a6209"],
    "ID3D12VideoProcessCommandList1": ["542c5c4d-7596-434f-8c93-4efa6766f267"],
    "ID3D12VideoProcessCommandList2": ["db525ae4-6ad6-473c-baa7-59b2e37082e4"],
    "ID3D12VideoProcessor": ["304fdb32-bede-410a-8545-943ac6a46138"],
    "ID3D12VideoProcessor1": ["f3cfe615-553f-425c-86d8-ee8c1b1fb01c"],
    "ID3DBlob": ["8ba5fb08-5195-40e2-ac58-0d989c3a0102"],
    "ID3DDestructionNotifier": ["a06eb39a-50da-425b-8c31-4eecd6c270f3"],
    "ID3DDeviceContextState": ["5c1e0d8a-7c23-48f9-8c59-a92958ceff11"],
    "ID3DUserDefinedAnnotation": ["b2daad8b-03d4-4dbf-95eb-32ab4b63d0ab"],
    "ID3DX11FFT": ["b3f7a938-4c93-4310-a675-b30d6de50553"],
    "ID3DX11Scan": ["5089b68f-e71d-4d38-be8e-f363b95a9405"],
    "ID3DX11SegmentedScan": ["a915128c-d954-4c79-bfe1-64db923194d6"],
    "IDATASRCListener": ["3050f380-98b5-11cf-bb82-00aa00bdce0b"],
    "IDBAsynchNotify": ["0c733a96-2a1c-11ce-ade5-00aa0044773d"],
    "IDBAsynchStatus": ["0c733a95-2a1c-11ce-ade5-00aa0044773d"],
    "IDBBinderProperties": ["0c733ab3-2a1c-11ce-ade5-00aa0044773d"],
    "IDBCreateCommand": ["0c733a1d-2a1c-11ce-ade5-00aa0044773d"],
    "IDBCreateSession": ["0c733a5d-2a1c-11ce-ade5-00aa0044773d"],
    "IDBDataSourceAdmin": ["0c733a7a-2a1c-11ce-ade5-00aa0044773d"],
    "IDBFolderPriv": ["1af4b01d-4a4a-489c-8f9f-243612300d24"],
    "IDBInfo": ["0c733a89-2a1c-11ce-ade5-00aa0044773d"],
    "IDBInitialize": ["0c733a8b-2a1c-11ce-ade5-00aa0044773d"],
    "IDBPromptInitialize": ["2206ccb0-19c1-11d1-89e0-00c04fd7a829"],
    "IDBProperties": ["0c733a8a-2a1c-11ce-ade5-00aa0044773d"],
    "IDBSchemaCommand": ["0c733a50-2a1c-11ce-ade5-00aa0044773d"],
    "IDBSchemaRowset": ["0c733a7b-2a1c-11ce-ade5-00aa0044773d"],
    "IDBSecurityInfo": ["0c733a62-2a1c-11ce-ade5-00aa0044773d"],
    "IDCompositionAnimation": ["cbfd91d9-51b2-45e4-b3de-d19ccfb863c5"],
    "IDCompositionDeviceInterop": ["2f4688bd-7f61-4b95-adcf-248d89e971bc"],
    "IDCompositionVisualInterop": ["33f8a013-5341-40c9-86ca-273ac031c7f6"],
    "IDDEConnected": ["5815aebe-69a9-4352-a91d-d805b44879da"],
    "IDDEInitializer": ["30dc931f-33fc-4ffd-a168-942258cf3ca4"],
    "IDDOResourceInfo": ["03e05342-07f2-4dee-98f7-c4ec68370cf4"],
    "IDDrawExclModeVideo": ["153acc21-d83b-11d1-82bf-00a0c9696c8f"],
    "IDDrawExclModeVideoCallback": ["913c24a0-20ab-11d2-9038-00a0c9697298"],
    "IDLLHost": ["00000141-0000-0000-c000-000000000046"],
    "IDMOQualityControl": ["65abea96-cf36-453f-af8a-705e98f16260"],
    "IDMOVideoOutputOptimizations": ["be8f4f4e-5b16-4d29-b350-7f6b5d9298ac"],
    "IDMOWrapperFilter": ["52d6f586-9f0f-4824-8fc8-e32ca04930c2"],
    "IDOMBeforeUnloadEvent": ["30510763-98b5-11cf-bb82-00aa00bdce0b"],
    "IDOMCloseEvent": ["305107ff-98b5-11cf-bb82-00aa00bdce0b"],
    "IDOMCompositionEvent": ["305106d8-98b5-11cf-bb82-00aa00bdce0b"],
    "IDOMCustomEvent": ["305106de-98b5-11cf-bb82-00aa00bdce0b"],
    "IDOMDocumentType": ["30510738-98b5-11cf-bb82-00aa00bdce0b"],
    "IDOMDragEvent": ["30510761-98b5-11cf-bb82-00aa00bdce0b"],
    "IDOMEvent": ["305104ba-98b5-11cf-bb82-00aa00bdce0b"],
    "IDOMEventRegistrationCallback": ["3051083b-98b5-11cf-bb82-00aa00bdce0b"],
    "IDOMException": ["3051072b-98b5-11cf-bb82-00aa00bdce0b"],
    "IDOMFocusEvent": ["305106cc-98b5-11cf-bb82-00aa00bdce0b"],
    "IDOMKeyboardEvent": ["305106d6-98b5-11cf-bb82-00aa00bdce0b"],
    "IDOMMSAnimationEvent": ["305107b7-98b5-11cf-bb82-00aa00bdce0b"],
    "IDOMMSManipulationEvent": ["30510816-98b5-11cf-bb82-00aa00bdce0b"],
    "IDOMMSTransitionEvent": ["305107b5-98b5-11cf-bb82-00aa00bdce0b"],
    "IDOMMessageEvent": ["30510720-98b5-11cf-bb82-00aa00bdce0b"],
    "IDOMMouseEvent": ["305106ce-98b5-11cf-bb82-00aa00bdce0b"],
    "IDOMMouseWheelEvent": ["305106d0-98b5-11cf-bb82-00aa00bdce0b"],
    "IDOMMutationEvent": ["305106da-98b5-11cf-bb82-00aa00bdce0b"],
    "IDOMNodeIterator": ["30510746-98b5-11cf-bb82-00aa00bdce0b"],
    "IDOMParser": ["30510781-98b5-11cf-bb82-00aa00bdce0b"],
    "IDOMParserFactory": ["30510783-98b5-11cf-bb82-00aa00bdce0b"],
    "IDOMProcessingInstruction": ["30510742-98b5-11cf-bb82-00aa00bdce0b"],
    "IDOMProgressEvent": ["3051071e-98b5-11cf-bb82-00aa00bdce0b"],
    "IDOMSiteModeEvent": ["30510765-98b6-11cf-bb82-00aa00bdce0b"],
    "IDOMStorageEvent": ["30510722-98b5-11cf-bb82-00aa00bdce0b"],
    "IDOMTextEvent": ["305106d4-98b5-11cf-bb82-00aa00bdce0b"],
    "IDOMTreeWalker": ["30510748-98b5-11cf-bb82-00aa00bdce0b"],
    "IDOMUIEvent": ["305106ca-98b5-11cf-bb82-00aa00bdce0b"],
    "IDOMWheelEvent": ["305106d2-98b5-11cf-bb82-00aa00bdce0b"],
    "IDOMXmlSerializer": ["3051077d-98b5-11cf-bb82-00aa00bdce0b"],
    "IDOMXmlSerializerFactory": ["3051077f-98b5-11cf-bb82-00aa00bdce0b"],
    "IDSOControl": ["310afa62-0575-11d2-9ca9-0060b0ec3d39"],
    "IDSRefConsumer": ["ab36de42-2bf4-11ce-ab3c-00aa004404fb"],
    "IDSRefProvider": ["ab36de41-2bf4-11ce-ab3c-00aa004404fb"],
    "IDShowPlugin": ["4746b7c8-700e-11d1-becc-00c04fb6e937"],
    "IDTCommandTarget": ["7ef39a3e-590d-4879-88d4-c9be5bcfd92e"],
    "IDTFilter": ["c4c4c4b2-0049-4e2b-98fb-9537f6ce516d"],
    "IDTFilter2": ["c4c4c4b4-0049-4e2b-98fb-9537f6ce516d"],
    "IDTFilter3": ["513998cc-e929-4cdf-9fbd-bad1e0314866"],
    "IDTFilterConfig": ["c4c4c4d2-0049-4e2b-98fb-9537f6ce516d"],
    "IDTFilterEvents": ["c4c4c4c2-0049-4e2b-98fb-9537f6ce516d"],
    "IDTFilterLicenseRenewal": ["8a78b317-e405-4a43-994a-620d8f5ce25e"],
    "IDTToolsOptionsPage": ["bdcaf240-2692-4713-902a-b110b1d0f100"],
    "IDTWizard": ["e914bbe1-03a4-11d1-bbcd-00a0c90f2744"],
    "IDUIElementProviderInit": ["e1f5ec9f-f933-492b-a242-c3cdac6ecfbd"],
    "IDUIFrameworkClientInitializer": ["05b2f74e-2712-46ba-bca3-f65a46bf0e00"],
    "IDVBCLocator": ["6e42f36e-1dd2-43c4-9f78-69d25ae39034"],
    "IDVBSLocator": ["3d7c353c-0d04-45f1-a742-f97cc1188dc8"],
    "IDVBSLocator2": ["6044634a-1733-4f99-b982-5fb12afce4f0"],
    "IDVBSTuningSpace": ["cdf7be60-d954-42fd-a972-78971958e470"],
    "IDVBTLocator": ["8664da16-dda2-42ac-926a-c18f9127c302"],
    "IDVBTLocator2": ["448a2edf-ae95-4b43-a3cc-747843c453d4"],
    "IDVBTuneRequest": ["0d6f567e-a636-42bb-83ba-ce4c1704afa2"],
    "IDVBTuningSpace": ["ada0b268-3b19-4e5b-acc4-49f852be13ba"],
    "IDVBTuningSpace2": ["843188b4-ce62-43db-966b-8145a094e040"],
    "IDVB_BAT": ["ece9bb0c-43b6-4558-a0ec-1812c34cd6ca"],
    "IDVB_DIT": ["91bffdf9-9432-410f-86ef-1c228ed0ad70"],
    "IDVB_EIT": ["442db029-02cb-4495-8b92-1c13375bce99"],
    "IDVB_EIT2": ["61a389e0-9b9e-4ba0-aeea-5ddd159820ea"],
    "IDVB_NIT": ["c64935f4-29e4-4e22-911a-63f7f55cb097"],
    "IDVB_RST": ["f47dcd04-1e23-4fb7-9f96-b40eead10b2b"],
    "IDVB_SDT": ["02cad8d3-fe43-48e2-90bd-450ed9a8a5fd"],
    "IDVB_SIT": ["68cdce53-8bea-45c2-9d9d-acf575a089b5"],
    "IDVB_ST": ["4d5b9f23-2a02-45de-bcda-5d5dbfbfbe62"],
    "IDVB_TDT": ["0780dc7d-d55c-4aef-97e6-6b75906e2796"],
    "IDVB_TOT": ["83295d6a-faba-4ee1-9b15-8067696910ae"],
    "IDVEnc": ["d18e17a0-aacb-11d0-afb0-00aa00b67a42"],
    "IDVRGB219": ["58473a19-2bc8-4663-8012-25f81babddd1"],
    "IDVSplitter": ["92a3a302-da7c-4a1f-ba7e-1802bb5d2d02"],
    "IDXCoreAdapter": ["f0db4c7f-fe5a-42a2-bd62-f2a6cf6fc83e"],
    "IDXCoreAdapterFactory": ["78ee5945-c36e-4b13-a669-005dd11c0f06"],
    "IDXCoreAdapterList": ["526c7776-40e9-459b-b711-f32ad76dfc28"],
    "IDXGIAdapter1": ["29038f61-3839-4626-91fd-086879011a05"],
    "IDXGIAdapter2": ["0aa1ae0a-fa0e-4b84-8644-e05ff8e5acb5"],
    "IDXGIAdapter3": ["645967a4-1392-4310-a798-8053ce3e93fd"],
    "IDXGIAdapter4": ["3c8d99d1-4fbf-4181-a82c-af66bf7bd24e"],
    "IDXGIDebug": ["119e7452-de9e-40fe-8806-88f90c12b441"],
    "IDXGIDebug1": ["c5a05f0c-16f2-4adf-9f4d-a8c4d58ac550"],
    "IDXGIDecodeSwapChain": ["2633066b-4514-4c7a-8fd8-12ea98059d18"],
    "IDXGIDevice1": ["77db970f-6276-48ba-ba28-070143b4392c"],
    "IDXGIDevice2": ["05008617-fbfd-4051-a790-144884b4f6a9"],
    "IDXGIDevice3": ["6007896c-3244-4afd-bf18-a6d3beda5023"],
    "IDXGIDevice4": ["95b4f95f-d8da-4ca4-9ee6-3b76d5968a10"],
    "IDXGIDisplayControl": ["ea9dbf1a-c88e-4486-854a-98aa0138f30c"],
    "IDXGIFactory1": ["770aae78-f26f-4dba-a829-253c83d1b387"],
    "IDXGIFactory2": ["50c83a1c-e072-4c48-87b0-3630fa36a6d0"],
    "IDXGIFactory3": ["25483823-cd46-4c7d-86ca-47aa95b837bd"],
    "IDXGIFactory4": ["1bc6ea02-ef36-464f-bf0c-21ca39e5168a"],
    "IDXGIFactory5": ["7632e1f5-ee65-4dca-87fd-84cd75f8838d"],
    "IDXGIFactory6": ["c1b6694f-ff09-44a9-b03c-77900a0a1d17"],
    "IDXGIFactory7": ["a4966eed-76db-44da-84c1-ee9a7afb20a8"],
    "IDXGIFactoryMedia": ["41e7d1f2-a591-4f7b-a2e5-fa9c843e1c12"],
    "IDXGIInfoQueue": ["d67441c7-672a-476f-9e82-cd55b44949ce"],
    "IDXGIKeyedMutex": ["9d8e1289-d7b3-465f-8126-250e349af85d"],
    "IDXGIOutput1": ["00cddea8-939b-4b83-a340-a685226666cc"],
    "IDXGIOutput2": ["595e39d1-2724-4663-99b1-da969de28364"],
    "IDXGIOutput3": ["8a6bb301-7e7e-41f4-a8e0-5b32f7f99b18"],
    "IDXGIOutput4": ["dc7dca35-2196-414d-9f53-617884032a60"],
    "IDXGIOutput5": ["80a07424-ab52-42eb-833c-0c42fd282d98"],
    "IDXGIOutput6": ["068346e8-aaec-4b84-add7-137f513f77a1"],
    "IDXGIOutputDuplication": ["191cfac3-a341-470d-b26e-a864f428319c"],
    "IDXGIResource1": ["30961379-4609-4a41-998e-54fe567ee0c1"],
    "IDXGISurface1": ["4ae63092-6327-4c1b-80ae-bfe12ea32b86"],
    "IDXGISurface2": ["aba496dd-b617-4cb8-a866-bc44d7eb1fa2"],
    "IDXGISwapChain1": ["790a45f7-0d42-4876-983a-0a55cfe6f4aa"],
    "IDXGISwapChain2": ["a8be2ac4-199f-4946-b331-79599fb98de7"],
    "IDXGISwapChain3": ["94d99bdb-f1f8-4ab0-b236-7da0170edab1"],
    "IDXGISwapChain4": ["3d585d5a-bd4a-489e-b1f4-3dbcb6452ffb"],
    "IDXGISwapChainMedia": ["dd95b90b-f05f-4f6a-bd65-25bfb264bd84"],
    "IDXSurfacePick": ["30a5fb79-e11f-11d1-9064-00c04fd9189d"],
    "IDXVAHD_Device": ["95f12dfd-d77e-49be-815f-57d579634d6d"],
    "IDXVAHD_VideoProcessor": ["95f4edf4-6e03-4cd7-be1b-3075d665aa52"],
    "IDailyTrigger": ["126c5cd8-b288-41d5-8dbf-e491446adc5c"],
    "IDataChanged": ["fd216d21-456e-4621-bbde-68cc15bb0654"],
    "IDataCollector": ["038374ff-098b-11d8-9414-505054503030"],
    "IDataCollectorCollection": ["03837502-098b-11d8-9414-505054503030"],
    "IDataCollectorSet": ["03837520-098b-11d8-9414-505054503030"],
    "IDataCollectorSetCollection": ["03837524-098b-11d8-9414-505054503030"],
    "IDataContextChangedEventArgs": ["7da68e21-0b8f-4f9f-a143-f8e7780136a2"],
    "IDataCue": ["7c7f676d-1fbc-4e2d-9a87-ee38bd1dc637"],
    "IDataCue2": ["bc561b15-95f2-49e8-96f1-8dd5dac68d93"],
    "IDataInitialize": ["2206ccb1-19c1-11d1-89e0-00c04fd7a829"],
    "IDataItemCommandHandler": ["b451532e-89ac-4fc0-a057-c61e79b1fb40"],
    "IDataItemEventHandler": ["836e0f2d-d28b-4bae-9fcc-ef5b46c65d89"],
    "IDataManager": ["03837541-098b-11d8-9414-505054503030"],
    "IDataModelCB": ["43efc137-1403-4e73-89fc-a49fdbfc09ec"],
    "IDataModelConcept": ["fcb98d1d-1114-4fbf-b24c-effcb5def0d3"],
    "IDataModelManager": ["73fe19f4-a110-4500-8ed9-3c28896f508c"],
    "IDataModelManager2": ["f412c5ea-2284-4622-a660-a697160d3312"],
    "IDataModelNameBinder": ["af352b7b-8292-4c01-b360-2dc3696c65e7"],
    "IDataModelScript": ["7b4d30fc-b14a-49f8-8d87-d9a1480c97f7"],
    "IDataModelScriptClient": ["3b362b0e-89f0-46c6-a663-dfdc95194aef"],
    "IDataModelScriptDebug": ["de8e0945-9750-4471-ab76-a8f79d6ec350"],
    "IDataModelScriptDebug2": ["cbb10ed3-839e-426c-9243-e23535c1ae1a"],
    "IDataModelScriptDebugBreakpoint": ["6bb27b35-02e6-47cb-90a0-5371244032de"],
    "IDataModelScriptDebugBreakpointEnumerator": ["39484a75-b4f3-4799-86da-691afa57b299"],
    "IDataModelScriptDebugClient": ["53159b6d-d4c4-471b-a863-5b110ca800ca"],
    "IDataModelScriptDebugStack": ["051364dd-e449-443e-9762-fe578f4a5473"],
    "IDataModelScriptDebugStackFrame": ["dec6ed5e-6360-4941-ab4c-a26409de4f82"],
    "IDataModelScriptDebugVariableSetEnumerator": ["0f9feed7-d045-4ac3-98a8-a98942cf6a35"],
    "IDataModelScriptHostContext": ["014d366a-1f23-4981-9219-b2db8b402054"],
    "IDataModelScriptManager": ["6fd11e33-e5ad-410b-8011-68c6bc4bf80d"],
    "IDataModelScriptProvider": ["513461e0-4fca-48ce-8658-32f3e2056f3b"],
    "IDataModelScriptProviderEnumerator": ["95ba00e2-704a-4fe2-a8f1-a7e7d8fb0941"],
    "IDataModelScriptTemplate": ["1303dec4-fa3b-4f1b-9224-b953d16babb5"],
    "IDataModelScriptTemplateEnumerator": ["69ce6ae2-2268-4e6f-b062-20ce62bfe677"],
    "IDataObjectAsyncCapability": ["3d8b0590-f691-11d2-8ea9-006097df5bd4"],
    "IDataObjectProvider": ["3d25f6d6-4b2a-433c-9184-7c33ad35d001"],
    "IDataPackage": ["61ebf5c7-efea-4346-9554-981d7e198ffe"],
    "IDataPackage2": ["041c1fe9-2409-45e1-a538-4c53eeee04a7"],
    "IDataPackage3": ["88f31f5d-787b-4d32-965a-a9838105a056"],
    "IDataPackage4": ["13a24ec8-9382-536f-852a-3045e1b29a3b"],
    "IDataPackageHostEventDetails": ["03a8e14f-039b-4ebb-aa77-5c2a992a9000"],
    "IDataPackagePostProcessor": ["3557af0e-d460-4113-ba67-6cf66d5595f1"],
    "IDataPackagePriv": ["cd1c0ba1-0ccb-4a33-9652-fe27a738c219"],
    "IDataPackagePropertySet": ["cd1c93eb-4c4c-443a-a8d3-f5c241e91689"],
    "IDataPackagePropertySet2": ["eb505d4a-9800-46aa-b181-7b6f0f2b919a"],
    "IDataPackagePropertySet3": ["9e87fd9b-5205-401b-874a-455653bd39e8"],
    "IDataPackagePropertySet4": ["6390ebf5-1739-4c74-b22f-865fab5e8545"],
    "IDataPackagePropertySetView": ["b94cec01-0c1a-4c57-be55-75d01289735d"],
    "IDataPackagePropertySetView2": ["6054509b-8ebe-4feb-9c1e-75e69de54b84"],
    "IDataPackagePropertySetView3": ["db764ce5-d174-495c-84fc-1a51f6ab45d7"],
    "IDataPackagePropertySetView4": ["4474c80d-d16f-40ae-9580-6f8562b94235"],
    "IDataPackagePropertySetView5": ["6f0a9445-3760-50bb-8523-c4202ded7d78"],
    "IDataPackageView": ["7b840471-5900-4d85-a90b-10cb85fe3552"],
    "IDataPackageView2": ["40ecba95-2450-4c1d-b6b4-ed45463dee9c"],
    "IDataPackageView3": ["d37771a8-ddad-4288-8428-d1cae394128b"],
    "IDataPackageView4": ["dfe96f1f-e042-4433-a09f-26d6ffda8b85"],
    "IDataPackageViewPriv": ["6f9bf6c5-569e-4980-b12a-596a08bef5a8"],
    "IDataPlanStatus": ["977a8b8c-3885-40f3-8851-42cd2bd568bb"],
    "IDataPlanUsage": ["b921492d-3b44-47ff-b361-be59e69ed1b0"],
    "IDataProtectionInfo": ["8420b0c1-5e31-4405-9540-3f943af0cb26"],
    "IDataProtectionManagerStatics": ["b6149b74-9144-4ee4-8a8a-30b5f361430e"],
    "IDataProtectionProvider": ["09639948-ed22-4270-bd1c-6d72c00f8787"],
    "IDataProtectionProviderFactory": ["adf33dac-4932-4cdf-ac41-7214333514ca"],
    "IDataProvider": ["5ebc8d33-d04e-4576-ae40-0a8631f319e6"],
    "IDataProviderDeferral": ["c2cf2373-2d26-43d9-b69d-dcb86d03f6da"],
    "IDataProviderHandler": ["e7ecd720-f2f4-4a2d-920e-170a2f482a27"],
    "IDataProviderRequest": ["ebbc7157-d3c8-47da-acde-f82388d5f716"],
    "IDataReader": ["e2b50029-b4c1-4314-a4b8-fb813a2f275e"],
    "IDataReaderFactory": ["d7527847-57da-4e15-914c-06806699a098"],
    "IDataReaderStatics": ["11fcbfc8-f93a-471b-b121-f379e349313c"],
    "IDataRequest": ["4341ae3b-fc12-4e53-8c02-ac714c415a27"],
    "IDataRequestDeferral": ["6dc4b89f-0386-4263-87c1-ed7dce30890e"],
    "IDataRequestedEventArgs": ["cb8ba807-6ac5-43c9-8ac5-9ba232163182"],
    "IDataRetrieverCallback": ["71b4863b-f969-4676-bbc3-3d9fdc3fb2c7"],
    "IDataSourceLocator": ["2206ccb2-19c1-11d1-89e0-00c04fd7a829"],
    "IDataTemplate": ["9910aec7-8ab5-4118-9bc6-09f45a35073d"],
    "IDataTemplateComponent": ["08429dc8-8ab0-4747-aa9a-feadfc8da8e1"],
    "IDataTemplateExtension": ["595e9547-cdff-4b92-b773-ab396878f353"],
    "IDataTemplateFactory": ["51ed9d7e-2b53-475b-9c88-0c1832c8351a"],
    "IDataTemplateKey": ["873b6c28-cceb-4b61-86fa-b2cec39cc2fa"],
    "IDataTemplateKeyFactory": ["e96b2959-d982-4152-91cb-de0e4dfd7693"],
    "IDataTemplateSelector": ["a907d496-46a0-4cd7-8dbe-f9a581df60b1"],
    "IDataTemplateSelector2": ["3792bc47-8c4b-4257-a5ae-cc3f8ed786eb"],
    "IDataTemplateSelectorFactory": ["511baad0-210a-457d-9521-433d2b11b7d2"],
    "IDataTemplateSelectorOverrides": ["2d162925-5966-4bfa-8638-4d345689f6cf"],
    "IDataTemplateSelectorOverrides2": ["6c3fb5fc-8e84-4c91-ac15-04a1d885500f"],
    "IDataTemplateStatics2": ["8af77d73-aa01-471e-bedd-8bad86219b77"],
    "IDataTransfer": ["86fa2fd1-a5ed-11cf-b57d-00aa00a71d1a"],
    "IDataTransferManager": ["a5caee9b-8708-49d1-8d36-67d25a8da00c"],
    "IDataTransferManager2": ["30ae7d71-8ba8-4c02-8e3f-ddb23b388715"],
    "IDataTransferManagerInterop": ["3a3dcd6c-3eab-43dc-bcde-45671ce800c8"],
    "IDataTransferManagerStatics": ["a9da01aa-e00e-4cfe-aa44-2dd932dca3d8"],
    "IDataTransferManagerStatics2": ["c54ec2ec-9f97-4d63-9868-395e271ad8f5"],
    "IDataTransferManagerStatics3": ["05845473-6c82-4f5c-ac23-62e458361fac"],
    "IDataWriter": ["64b89265-d341-4922-b38a-dd4af8808c4e"],
    "IDataWriterFactory": ["338c67c2-8b84-4c2b-9c50-7b8767847a1f"],
    "IDatagramSocket": ["7fe25bbb-c3bc-4677-8446-ca28a465a3af"],
    "IDatagramSocket2": ["d83ba354-9a9d-4185-a20a-1424c9c2a7cd"],
    "IDatagramSocket3": ["37544f09-ab92-4306-9ac1-0c381283d9c6"],
    "IDatagramSocketControl": ["52ac3f2e-349a-4135-bb58-b79b2647d390"],
    "IDatagramSocketControl2": ["33ead5c2-979c-4415-82a1-3cfaf646c192"],
    "IDatagramSocketControl3": ["d4eb8256-1f6d-4598-9b57-d42a001df349"],
    "IDatagramSocketInformation": ["5f1a569a-55fb-48cd-9706-7a974f7b1585"],
    "IDatagramSocketMessageReceivedEventArgs": ["9e2ddca2-1712-4ce4-b179-8c652c6d107e"],
    "IDatagramSocketStatics": ["e9c62aee-1494-4a21-bb7e-8589fc751d9d"],
    "IDatePickedEventArgs": ["a1527b12-59c1-4521-b28c-b176675e7c5a"],
    "IDatePicker": ["06da3946-08b8-4103-8b8a-093efd6a7657"],
    "IDatePicker2": ["bb28b475-2c1f-4340-9e30-948f99c9e57a"],
    "IDatePicker3": ["7da12a3b-a764-5ae1-abae-6affc1428e1e"],
    "IDatePickerAutomationPeer": ["d07d357f-a0b9-45dc-991a-76c505e7d0f5"],
    "IDatePickerAutomationPeerFactory": ["e5667d19-9157-4436-9f4d-7fb99174b48e"],
    "IDatePickerFactory": ["eec3ca84-9896-4a7d-bb35-6fb21eaeca11"],
    "IDatePickerFlyout": ["fbf33b1a-a3a4-4df8-9228-23a5ac27df4e"],
    "IDatePickerFlyout2": ["cfb18dbb-9931-4119-8bda-54a86fdfac84"],
    "IDatePickerFlyoutItem": ["9d9bc289-00d2-4aac-9c85-d74f06367887"],
    "IDatePickerFlyoutItemStatics": ["aa9c91da-07f6-4cdf-89b4-dda3bdb0ea6b"],
    "IDatePickerFlyoutPresenter": ["7c62f70e-2ddc-4381-832f-54cbdfaa849a"],
    "IDatePickerFlyoutPresenter2": ["c5b2578f-96d8-55cc-97ee-3f88fc85e479"],
    "IDatePickerFlyoutPresenterAutomationPeer": ["752aed38-c2bf-4880-82b2-a6c05e90c135"],
    "IDatePickerFlyoutPresenterStatics2": ["4dc0c49e-1f8e-5966-bbdb-215750c73aba"],
    "IDatePickerFlyoutStatics": ["cd570377-5845-4c12-8c10-592d9fcc7cd9"],
    "IDatePickerFlyoutStatics2": ["afd3e569-81e6-4b54-84a9-68079b73e34e"],
    "IDatePickerSelectedValueChangedEventArgs": ["564dceed-744a-5c3a-9bd2-4dcd9919a7b7"],
    "IDatePickerStatics": ["182e7c69-2116-4c67-b513-713364831d79"],
    "IDatePickerStatics2": ["f1076df6-fba6-4550-8b88-a6420847f60d"],
    "IDatePickerStatics3": ["a9f80afe-a30a-5f26-a446-fec2075d4a0e"],
    "IDatePickerValueChangedEventArgs": ["1ae661b2-b1b4-4273-96e0-19daff187446"],
    "IDateTimeFormatter": ["95eeca10-73e0-4e4b-a183-3d6ad0ba35ec"],
    "IDateTimeFormatter2": ["27c91a86-bdaa-4fd0-9e36-671d5aa5ee03"],
    "IDateTimeFormatterFactory": ["ec8d8a53-1a2e-412d-8815-3b745fb1a2a0"],
    "IDateTimeFormatterStatics": ["bfcde7c0-df4c-4a2e-9012-f47daf3f1212"],
    "IDateTimeSettingsStatics": ["5d2150d1-47ee-48ab-a52b-9f1954278d82"],
    "IDebugAD1Program2_V7": ["b7bdab6c-9077-43d0-87c4-96d1fd851446"],
    "IDebugActivateDocumentEvent2": ["58f36c3d-7d07-4eba-a041-62f63e188037"],
    "IDebugAddress": ["c2e34ebb-8b9d-11d2-9014-00c04fa38338"],
    "IDebugAddress2": ["877a0da6-a43e-4046-9be3-f916aff4fa7b"],
    "IDebugAdvanced": ["f2df5f53-071f-47bd-9de6-5734c3fed689"],
    "IDebugAdvanced2": ["716d14c9-119b-4ba5-af1f-0890e672416a"],
    "IDebugAdvanced3": ["cba4abb4-84c4-444d-87ca-a04e13286739"],
    "IDebugAdvanced4": ["d1069067-2a65-4bf0-ae97-76184b67856b"],
    "IDebugAlias": ["de7ccb92-94ac-4841-b354-5827b68217e7"],
    "IDebugApplication110": ["2039d958-4eeb-496a-87bb-2e5201eadeef", "bdb3b5de-89f2-4e11-84a5-97445f941c7d"],
    "IDebugApplication11032": ["bdb3b5de-89f2-4e11-84a5-97445f941c7d"],
    "IDebugApplication11064": ["2039d958-4eeb-496a-87bb-2e5201eadeef"],
    "IDebugApplicationNode100": ["90a7734e-841b-4f77-9384-a2891e76e7e2"],
    "IDebugApplicationThread110": ["2194ac5c-6561-404a-a2e9-f57d72de3702", "420aa4cc-efd8-4dac-983b-47127826917d"],
    "IDebugApplicationThread11032": ["2194ac5c-6561-404a-a2e9-f57d72de3702"],
    "IDebugApplicationThread11064": ["420aa4cc-efd8-4dac-983b-47127826917d"],
    "IDebugApplicationThreadEvents110": ["84e5e468-d5da-48a8-83f4-40366429007b"],
    "IDebugArrayField": ["c2e34eb7-8b9d-11d2-9014-00c04fa38338"],
    "IDebugArrayObject": ["29ecd774-75ae-11d2-b74e-0000f87572ef"],
    "IDebugArrayObject2": ["41487e33-9a10-42fe-ba3b-15fde59d09d5"],
    "IDebugAsyncTask120": ["7eab8ebe-0f51-4cc1-b69c-a379a31c6847"],
    "IDebugAttachCompleteEvent2": ["fe1fd9ea-6413-4183-a67d-588870014e97"],
    "IDebugAttachSecurityCallback2": ["a19e7faf-cb6f-43ba-ac16-bde9823d6dd1"],
    "IDebugBeforeSymbolSearchEvent2": ["b15c8149-2b81-40ae-9388-62fa276ae14c"],
    "IDebugBinder": ["c077c833-476c-11d2-b73c-0000f87572ef"],
    "IDebugBinder2": ["dcf3c6ee-7c7d-4e1f-aeeb-646902af0723"],
    "IDebugBinder3": ["bbcd7263-b415-40f6-942a-4a9a8599b708"],
    "IDebugBinderDirect": ["9db3e3b8-84f5-488e-93eb-b3ce3e33edab"],
    "IDebugBinderDirect100": ["00ca5803-6adc-49b3-adcb-a2b538b5665e"],
    "IDebugBitField": ["c2e34eba-8b9d-11d2-9014-00c04fa38338"],
    "IDebugBoundBreakpoint110": ["f7d19258-7aed-45c5-bb5a-1657b035360d"],
    "IDebugBoundBreakpoint2": ["d533d975-3f32-4876-abd0-6d37fda563e7"],
    "IDebugBoundBreakpoint3": ["60f49115-ce92-4f96-8d0a-81cccae4ab77"],
    "IDebugBreakEvent2": ["c7405d1d-e24b-44e0-b707-d8a5a4e1641b"],
    "IDebugBreakpoint": ["5bd9d474-5975-423a-b88b-65a8e7110e65"],
    "IDebugBreakpoint2": ["1b278d20-79f2-426e-a3f9-c1ddf375d48e"],
    "IDebugBreakpoint3": ["38f5c249-b448-43bb-9835-579d4ec02249"],
    "IDebugBreakpointBoundEvent2": ["1dddb704-cf99-4b8a-b746-dabb01dd13a0"],
    "IDebugBreakpointChecksumRequest2": ["0ea91cf7-8542-4780-8d6b-7bd686cd2471"],
    "IDebugBreakpointErrorEvent2": ["abb0ca42-f82b-4622-84e4-6903ae90f210"],
    "IDebugBreakpointEvent2": ["501c1e21-c557-48b8-ba30-a1eab0bc4a74"],
    "IDebugBreakpointFileUpdateNotification110": ["a87ab572-49c1-4bf5-9f1b-e0a3f94ca27b"],
    "IDebugBreakpointRequest110": ["8ab88b04-2586-47ce-8a23-e3130f86296f"],
    "IDebugBreakpointRequest2": ["6015fd18-8257-4df3-ac42-f074dedd4cbd"],
    "IDebugBreakpointRequest3": ["5c18a5fe-7150-4e66-8246-27bfb0e7bfd9"],
    "IDebugBreakpointResolution2": ["b7e66f28-035a-401a-afc7-2e300bd29711"],
    "IDebugBreakpointUnboundEvent2": ["78d1db4f-c557-4dc5-a2dd-5369d21b1c8c"],
    "IDebugCOMPlusProgramNode2": ["d6f7d3d0-506a-448f-8702-46eb2745e4fc"],
    "IDebugCallbackNotificationHandler": ["30510842-98b5-11cf-bb82-00aa00bdce0b"],
    "IDebugCanStopEvent2": ["b5b0d747-d4d2-4e2d-872d-74da22037826"],
    "IDebugClassField": ["c2e34eb5-8b9d-11d2-9014-00c04fa38338"],
    "IDebugClient": ["27fe5639-8407-4f47-8364-ee118fb08ac8"],
    "IDebugClient2": ["edbed635-372e-4dab-bbfe-ed0d2f63be81"],
    "IDebugClient3": ["dd492d7f-71b8-4ad6-a8dc-1c887479ff91"],
    "IDebugClient4": ["ca83c3de-5089-4cf8-93c8-d892387f2a5e"],
    "IDebugClient5": ["e3acb9d7-7ec2-4f0c-a0da-e81e0cbbe628"],
    "IDebugClient6": ["fd28b4c5-c498-4686-a28e-62cad2154eb3"],
    "IDebugClient7": ["13586be3-542e-481e-b1f2-8497ba74f9a9"],
    "IDebugCodeContext100": ["653f13a7-7e53-4f48-bde8-8ef8d3bc3c57"],
    "IDebugCodeContext120A": ["98a98e96-a59a-4580-925f-4e7ff5a49cfe"],
    "IDebugCodeContext150": ["0eb39b6b-8eff-4b9d-8cbd-eda45d5c588f"],
    "IDebugCodeContext2": ["ac17b76b-2b09-419a-ad5f-7d7402da8875"],
    "IDebugCodeContext3": ["17c106b9-0925-42f5-ae32-1fc019649c10"],
    "IDebugCodeContextInfoCompletionRoutine150": ["bf4cd6e7-7ad0-45a4-b1bf-d94bbbf0b0e5"],
    "IDebugCodePath90": ["7372dce0-f816-4e35-8b42-64b7f50e6395"],
    "IDebugComPlusSnapshot2": ["f6f94d20-78c2-11d2-8ffe-00c04fa38314"],
    "IDebugComPlusSymbolProvider": ["c2e34eaf-8b9d-11d2-9014-00c04fa38338"],
    "IDebugComPlusSymbolProvider2": ["29d97d99-2c50-4855-bc74-b3e372ddd602"],
    "IDebugComPlusSymbolSearchInfo": ["f96f4d16-e799-492d-b33d-2325e63d4135"],
    "IDebugCompiledExpression110": ["a528d84a-06d7-48b0-8825-614f4c5c1f68"],
    "IDebugComputeKernel110": ["ed1847bc-ef75-459f-a1da-5042cf83f229"],
    "IDebugComputeKernelDispatchEvent110": ["e157b5e4-7380-4516-9624-c5ba188d8431"],
    "IDebugComputeThread110": ["e50a6e8d-74ba-4f69-956d-9c27d86f5922"],
    "IDebugComputeThreadPropertyChangedEvent110": ["9daaccd8-4368-4391-b8d5-3e4a6b794a20"],
    "IDebugContainerField": ["c2e34eb2-8b9d-11d2-9014-00c04fa38338"],
    "IDebugControl": ["5182e668-105e-416e-ad92-24ef800424ba"],
    "IDebugControl2": ["d4366723-44df-4bed-8c7e-4c05424f4588"],
    "IDebugControl3": ["7df74a86-b03f-407f-90ab-a20dadcead08"],
    "IDebugControl4": ["94e60ce9-9b41-4b19-9fc0-6d9eb35272b3"],
    "IDebugControl5": ["b2ffe162-2412-429f-8d1d-5bf6dd824696"],
    "IDebugControl6": ["bc0d583f-126d-43a1-9cc4-a860ab1d537b"],
    "IDebugControl7": ["b86fb3b1-80d4-475b-aea3-cf06539cf63a"],
    "IDebugCoreServer2": ["17bf8fa3-4c5a-49a3-b2f8-5942e1ea287e"],
    "IDebugCoreServer3": ["12c1180e-c257-4485-9800-af484b699713"],
    "IDebugCoreServer90": ["1a1b5760-fe45-4958-aa3f-819060b16de9"],
    "IDebugCurrentThreadChangedEvent100": ["8764364b-0c52-4c7c-af6a-8b19a8c98226"],
    "IDebugCustomAttribute": ["a3a37c5e-8d71-487d-a9e1-b9a1b3ba9cbb"],
    "IDebugCustomAttributeQuery": ["dfd37b5a-1e3a-4f15-8098-220abadc620b"],
    "IDebugCustomAttributeQuery2": ["7d257f89-ef56-43c4-80ff-c89b064e4680"],
    "IDebugCustomENCModule100": ["a39a3ddd-af4d-48fa-bc0d-7afd3fcdee9b"],
    "IDebugCustomEvent110": ["2615d9bc-1948-4d21-81ee-7a963f20cf59"],
    "IDebugCustomViewer": ["6306e526-9e02-4696-bff9-48338a27f8af"],
    "IDebugDataGrid": ["411f3e08-e6b1-4789-ab29-755c52e52ac4"],
    "IDebugDataSpaces": ["88f7dfab-3ea7-4c3a-aefb-c4e8106173aa"],
    "IDebugDataSpaces2": ["7a5e852f-96e9-468f-ac1b-0b3addc4a049"],
    "IDebugDataSpaces3": ["23f79d6c-8aaf-4f7c-a607-9995f5407e63"],
    "IDebugDataSpaces4": ["d98ada1f-29e9-4ef5-a6c0-e53349883212"],
    "IDebugDefaultPort110": ["690ffd4f-6336-4689-9bc6-c8f87c1d333c"],
    "IDebugDefaultPort2": ["302f0f55-1ede-4777-9b38-115e1f229d56"],
    "IDebugDisassemblyStream2": ["e5b017fe-dfb0-411c-8266-7c64d6f519f8"],
    "IDebugDoNotUseThisInterface165": ["d2d94ae8-5ee6-4ed2-bcea-eae8cbf261fb"],
    "IDebugDocument120": ["54271ecb-d88e-42c5-b8af-137f851e57e2"],
    "IDebugDocument2": ["1606dd73-5d5f-405c-b4f4-ce32baba2501"],
    "IDebugDocumentChecksum2": ["c1c74db7-a3a7-40a2-a279-a63ba756b8b0"],
    "IDebugDocumentContext150": ["3cfd5762-425b-4a0b-a962-3a6cacbcaef5"],
    "IDebugDocumentContext155": ["e8111c77-5764-498d-9e48-5f1d37c5b538"],
    "IDebugDocumentContext2": ["931516ad-b600-419c-88fc-dcf5183b5fa9"],
    "IDebugDocumentPosition110": ["d3376546-5c4b-46f4-9e38-2cc7c0c2eb41"],
    "IDebugDocumentPosition2": ["bdde0eee-3b8d-4c82-b529-33f16b42832e"],
    "IDebugDocumentPositionOffset2": ["037edd0f-8551-4f7f-8ca0-04d9e29f532d"],
    "IDebugDocumentText2": ["4b0645aa-08ef-4cb9-adb9-0395d6edad35"],
    "IDebugDocumentTextEvents2": ["33ec72e3-002f-4966-b91c-5ce2f7ba5124"],
    "IDebugDumpModule100": ["12e0c541-6479-4c3c-a48d-8ffa223208c2"],
    "IDebugDynamicField": ["b5a2a5ea-d5ab-11d2-9033-00c04fa302a1"],
    "IDebugDynamicFieldCOMPlus": ["b5b20820-e233-11d2-9037-00c04fa302a1"],
    "IDebugENC": ["b104d8b7-af19-11d2-922c-00a02448799a"],
    "IDebugENC110": ["fcca721f-237b-4f21-9b63-976babab3aae"],
    "IDebugENC2": ["54b61a02-4823-42ec-9648-a9ae80cda270"],
    "IDebugENCBuildInfo2": ["ea70281b-bd58-11d2-9238-00a02448799a"],
    "IDebugENCDocumentContextUpdate": ["f5637291-d779-4580-a82c-0d523e7fdcf0"],
    "IDebugENCInfo2": ["6b56106f-bd51-11d2-9238-00a02448799a"],
    "IDebugENCLineMap": ["8706233b-bd4c-11d2-9238-00a02448799a"],
    "IDebugENCModule": ["95b8097d-3201-4b21-887c-239ee0a0d589"],
    "IDebugENCModule2": ["a58ff1f1-1fff-44b4-a311-55d6675f4a0f"],
    "IDebugENCRelinkInfo2": ["cbb63a8d-bd57-11d2-9238-00a02448799a"],
    "IDebugENCSnapshot2": ["f6f94d0e-78c2-11d2-8ffe-00c04fa38314"],
    "IDebugENCSnapshot3": ["3f50c7d0-d1af-4a97-ad81-7fdd5934ad32"],
    "IDebugENCStackFrame2": ["b3c64d7f-db9d-47c7-b479-c579c7f07103"],
    "IDebugENCStateEvents": ["ec80d064-102e-435f-aafb-d37e2a4ef654"],
    "IDebugENCSymbolProvider2": ["ff6d3520-e8d9-4e8c-bb75-cffa7b03c633"],
    "IDebugENCUpdate": ["978baee7-bd4c-11d2-9238-00a02448799a"],
    "IDebugENCUpdateOnRelinkEvent2": ["0ebf1959-bd57-11d2-9238-00a02448799a"],
    "IDebugENCUpdateOnStaleCodeEvent2": ["2f01eb29-bd57-11d2-9238-00a02448799a"],
    "IDebugEncNotify": ["347c45e1-5c42-4e0e-9e15-deff9cfc7841"],
    "IDebugEngine110": ["6f274ec0-3772-415c-969f-58bac0e2c5a9"],
    "IDebugEngine150": ["0c6c8422-1241-4fb1-8106-5762c7e27e59"],
    "IDebugEngine2": ["ba105b52-12f1-4038-ae64-d95785874c47"],
    "IDebugEngine3": ["a60384f6-3712-4cb3-bc46-81e6402fee99"],
    "IDebugEngineCreateEvent2": ["fe5b734c-759d-4e59-ab04-f103343bdd06"],
    "IDebugEngineJITSettings2": ["b9f3fdf1-7b6d-4899-bd94-72e4d4acd2e1"],
    "IDebugEngineLaunch100": ["1ac3d265-c50c-4c12-9b1a-c93f7291fc12"],
    "IDebugEngineLaunch2": ["c7c1462f-9736-466c-b2c1-b6b2dedbf4a7"],
    "IDebugEngineProgram140": ["e74b9a86-4fdd-4ad6-995e-38977ff3ad15"],
    "IDebugEngineProgram2": ["7ce3e768-654d-4ba7-8d95-cdaac642b141"],
    "IDebugEngineStepFilterManager90": ["de74abe1-c625-4768-81b3-8eddab72ca20"],
    "IDebugEngineSymbolProviderServices": ["83919262-acd6-11d2-9028-00c04fa302a1"],
    "IDebugEngineSymbolProviderServices2": ["d318e959-22ab-4eea-9a06-962b11afdc29"],
    "IDebugEntryPointEvent2": ["e8414a3e-1642-48ec-829e-5f4040e16da9"],
    "IDebugEnumField": ["c2e34eb9-8b9d-11d2-9014-00c04fa38338"],
    "IDebugErrorBreakpoint2": ["74570ef7-2486-4089-800c-56e3829b5ca4"],
    "IDebugErrorBreakpointResolution2": ["603aedf8-9575-4d30-b8ca-124d1c98ebd8"],
    "IDebugErrorEvent2": ["fdb7a36c-8c53-41da-a337-8bd86b14d5cb"],
    "IDebugEvent2": ["423238d6-da42-4989-96fb-6bba26e72e09"],
    "IDebugEventCallback2": ["ade2eeb9-fc85-4f5b-b5d9-d431b4aac31a"],
    "IDebugEventCallbacks": ["337be28b-5036-4d72-b6bf-c45fbb9f2eaa"],
    "IDebugEventCallbacksT": ["0690e046-9c23-45ac-a04f-987ac29ad0d3", "337be28b-5036-4d72-b6bf-c45fbb9f2eaa"],
    "IDebugEventCallbacksWide": ["0690e046-9c23-45ac-a04f-987ac29ad0d3"],
    "IDebugEventContextCallbacks": ["61a4905b-23f9-4247-b3c5-53d087529ab7"],
    "IDebugExceptionCallback2": ["6f5cfda4-47d3-4a90-a882-14427237bcee"],
    "IDebugExceptionCondition": ["fbfd0196-b9a4-48fc-ab5e-77e4a2efd887"],
    "IDebugExceptionConditionList": ["14fb02ff-2d1b-496a-96c7-2f565bbfcea4"],
    "IDebugExceptionDetails": ["15030210-d2c0-410d-9044-9f8091b992d8"],
    "IDebugExceptionDetails164": ["766a0544-ae86-4c9a-8dfb-bd0d71f30d9a"],
    "IDebugExceptionEvent120": ["9c954ace-8041-4c57-ad2a-d9e2cf2e565e"],
    "IDebugExceptionEvent150": ["a91ad17c-1174-4563-9c1e-56c837c2adee"],
    "IDebugExceptionEvent2": ["51a94113-8788-4a54-ae15-08b74ff922d0"],
    "IDebugExceptionSettingsChangeNotification140": ["95a6c633-4a5f-46a0-b1a9-85145b163955"],
    "IDebugExceptionSettingsChangeNotification150": ["acc93823-3cb2-421e-af29-272777ae8180"],
    "IDebugExceptionSettingsManager140": ["73ea578a-d148-4b71-b894-58fc82451450"],
    "IDebugExceptionSettingsManager150": ["791019de-09c3-4438-9a74-078511727a09"],
    "IDebugExpression157": ["15fa3968-a6eb-481d-a55d-eb6927dac066"],
    "IDebugExpression2": ["f7473fd0-7f75-478d-8d85-a485204e7a2d"],
    "IDebugExpressionCompilationContext110": ["3de09ace-d2b6-4054-b17b-1120b0160283"],
    "IDebugExpressionContext2": ["37a44580-d5fc-473e-a048-21702ebfc466"],
    "IDebugExpressionEvaluationCompleteEvent2": ["c0e13a85-238a-4800-8315-d947c960a843"],
    "IDebugExpressionEvaluator": ["c077c822-476c-11d2-b73c-0000f87572ef"],
    "IDebugExpressionEvaluator100": ["643cd3d4-043d-410c-8201-7e83c8918a91"],
    "IDebugExpressionEvaluator2": ["2de1d5e0-ca57-456f-815c-5902825a2795"],
    "IDebugExpressionEvaluator3": ["4c7ec6f5-bb6c-43a2-853c-80ff48b7a8a6"],
    "IDebugExtendedField": ["20f22571-aa1c-4724-ad0a-bde2d19d6163"],
    "IDebugField": ["c2e34eb1-8b9d-11d2-9014-00c04fa38338"],
    "IDebugFirewallConfigurationCallback2": ["ba3288db-224a-4fd6-a37e-64e7abe9c4a1"],
    "IDebugFuncEvalAbortedEvent2": ["3f3be369-0b78-4511-91e5-08f9fc5cae0d"],
    "IDebugFunctionObject": ["f71d9ea0-4269-48dc-9e8d-f86defa042b3"],
    "IDebugFunctionObject2": ["8e861cc7-d21c-43e7-ab7b-947921689b88"],
    "IDebugFunctionPosition2": ["1ede3b4b-35e7-4b97-8133-02845d600174"],
    "IDebugGenericFieldDefinition": ["c5717d6c-8dbf-4852-b7d8-c003ee09541f"],
    "IDebugGenericFieldInstance": ["c93c9dd0-0a65-4966-bceb-633eeee2e096"],
    "IDebugGenericParamField": ["941105e9-760a-49ec-995f-7668cb60216c"],
    "IDebugGroupEvaluationCompleteEvent110": ["ba675acf-e798-4b06-a843-c0ed2631e015"],
    "IDebugHost": ["b8c74943-6b2c-4eeb-b5c5-35d378a6d99d"],
    "IDebugHostBaseClass": ["b94d57d2-390b-40f7-b5b4-b6db897d974b"],
    "IDebugHostConstant": ["62787edc-fa76-4690-bd71-5e8c3e2937ec"],
    "IDebugHostContext": ["a68c70d8-5ec0-46e5-b775-3134a48ea2e3"],
    "IDebugHostData": ["a3d64993-826c-44fa-897d-926f2fe7ad0b"],
    "IDebugHostErrorSink": ["c8ff0f0b-fce9-467e-8bb3-5d69ef109c00"],
    "IDebugHostEvaluator": ["0fef9a21-577e-4997-ac7b-1c4883241d99"],
    "IDebugHostEvaluator2": ["a117a435-1fb4-4092-a2ab-a929576c1e87"],
    "IDebugHostExtensibility": ["3c2b24e1-11d0-4f86-8ae5-4df166f73253"],
    "IDebugHostField": ["e06f6495-16bc-4cc9-b11d-2a6b23fa72f3"],
    "IDebugHostMemory": ["212149c9-9183-4a3e-b00e-4fd1dc95339b"],
    "IDebugHostMemory2": ["eea033de-38f6-416b-a251-1d3771001270"],
    "IDebugHostModule": ["c9ba3e18-d070-4378-bbd0-34613b346e1e"],
    "IDebugHostModule2": ["b51887e8-bcd0-4e8f-a8c7-434398b78c37"],
    "IDebugHostModuleSignature": ["31e53a5a-01ee-4bbb-b899-4b46ae7d595c"],
    "IDebugHostPublic": ["6c597ac9-fb4d-4f6d-9f39-22488539f8f4"],
    "IDebugHostScriptHost": ["b70334a4-b92c-4570-93a1-d3eb686649a0"],
    "IDebugHostStatus": ["4f3e1ce2-86b2-4c7a-9c65-d0a9d0eecf44"],
    "IDebugHostSymbol": ["0f819103-87de-4e96-8277-e05cd441fb22"],
    "IDebugHostSymbol2": ["21515b67-6720-4257-8a68-077dc944471c"],
    "IDebugHostSymbolEnumerator": ["28d96c86-10a3-4976-b14e-eaef4790aa1f"],
    "IDebugHostSymbols": ["854fd751-c2e1-4eb2-b525-6619cb97a588"],
    "IDebugHostType": ["f219b848-63b2-4a43-a6c9-72abf25a9711"],
    "IDebugHostType2": ["b28632b9-8506-4676-87ce-8f7e05e59876"],
    "IDebugHostTypeSignature": ["3aadc353-2b14-4abb-9893-5e03458e07ee"],
    "IDebugIDBInfo2": ["9b7de9a9-bd59-11d2-9238-00a02448799a"],
    "IDebugIDECallback": ["b78c9e91-dd39-4e5b-bb7b-30b88149b2fe"],
    "IDebugIDEJIT2": ["b2f73449-98ea-4866-90a0-425837fc5e23"],
    "IDebugInputCallbacks": ["9f50e42c-f136-499e-9a97-73036c94ed2d"],
    "IDebugInterceptExceptionCompleteEvent2": ["44fceaca-7f56-4d2c-a637-60052b1b9cbe"],
    "IDebugIteratorFrameProvider": ["a38ef241-af3e-49a9-8533-0e35b6794d40"],
    "IDebugJIT2": ["2ea4c00d-7156-4f8e-b990-fb4271147617"],
    "IDebugJMCWarningEvent140": ["bc87fb3f-20a5-432c-88e3-de67d0ed86b1"],
    "IDebugLaunchCustomTelemetryProvider": ["f63a5f5c-de4e-4361-8361-3178dbc0e675"],
    "IDebugLaunchedProcessAttachRequestEvent110": ["7a529a0a-d8ed-4abd-8218-f216b081ef3e"],
    "IDebugLoadCompleteEvent2": ["b1844850-1349-45d4-9f12-495212f5eb0b"],
    "IDebugLogicalThread120": ["fca685e7-45f2-4c36-beb8-be982087479f"],
    "IDebugLogicalThread2": ["88d2f75b-d329-4e03-9b75-201f7782d8bd"],
    "IDebugLostBreakStateEvent150": ["33b3c3d1-9a81-4d9a-ad69-14d66148d818"],
    "IDebugMDMUtil2_V7": ["f3062547-43d8-4dc2-b18e-e1460ff2c422"],
    "IDebugMDMUtil3_V7": ["af598dea-ce92-443b-a0b5-9992ff660bc4"],
    "IDebugMachine2_V7": ["17bf8fa3-4c5a-49a3-b2f8-5942e1ea287e"],
    "IDebugMachineEx2_V7": ["ae27b230-a0bf-47ff-a2d1-22c29a178eac"],
    "IDebugManagedENC": ["12dcd8b7-ebfc-4dbe-a72c-3e44cdd3cbaf"],
    "IDebugManagedExceptionInfo2": ["d288564a-edb2-4214-8690-ff9a82870379"],
    "IDebugManagedObject": ["71af87c9-66c5-49e4-a602-b9012115afd5"],
    "IDebugMemoryBytes2": ["925837d1-3aa1-451a-b7fe-cc04bb42cfb8"],
    "IDebugMemoryContext2": ["1ab276dd-f27b-4445-825d-5df0b4a04a3a"],
    "IDebugMessageEvent2": ["3bdb28cf-dbd2-4d24-af03-01072b67eb9e"],
    "IDebugMetaDataDebugEmit2": ["f6f94d22-78c2-11d2-8ffe-00c04fa38314"],
    "IDebugMetaDataEmit2": ["f6f94d21-78c2-11d2-8ffe-00c04fa38314"],
    "IDebugMethodField": ["c2e34eb4-8b9d-11d2-9014-00c04fa38338"],
    "IDebugModOpt": ["b90282fc-2d44-4050-a7b2-bf3bcff8baf1"],
    "IDebugModule2": ["0fc1cd9a-b912-405c-a04c-43ce02cd7df2"],
    "IDebugModule3": ["245f9d6a-e550-404d-82f1-fdb68281607a"],
    "IDebugModuleLoadEvent2": ["989db083-0d7c-40d1-a9d9-921bf611a4b2"],
    "IDebugModuleManaged": ["232397f8-b232-479d-b1bb-2f044c70a0f9"],
    "IDebugModuleReloadOperationCompleteEvent100": ["e72b36e9-8ec2-4dee-b96b-c18b752c98c8"],
    "IDebugNativeExceptionInfo": ["3d320710-06c0-437b-a55f-826f48cc7ee7"],
    "IDebugNativePort2": ["521b4726-04e9-47e7-b3a5-cd93a7f74f5b"],
    "IDebugNativeSnapshot2": ["461fda3e-bba5-11d2-b10f-00c04f72dc32"],
    "IDebugNativeSymbolProvider": ["c2e34eb0-8b9d-11d2-9014-00c04fa38338"],
    "IDebugNoSymbolsEvent2": ["3ad4fb48-647e-4b03-9c1e-52754e80c880"],
    "IDebugObject": ["c077c823-476c-11d2-b73c-0000f87572ef"],
    "IDebugObject2": ["3ff130fc-b14f-4bae-ae44-46b1cd3928cc"],
    "IDebugObject90": ["2b8f1709-ec30-48ac-9baa-23867a5076dc"],
    "IDebugOptionList120A": ["bd0e4180-eeb9-45cf-9341-1cb4ca98ce07"],
    "IDebugOutputCallbacks": ["4bf58045-d654-4c40-b0af-683090f356dc"],
    "IDebugOutputCallbacks2": ["67721fe9-56d2-4a44-a325-2b65513ce6eb"],
    "IDebugOutputCallbacksT": ["4bf58045-d654-4c40-b0af-683090f356dc", "4c7fd663-c394-4e26-8ef1-34ad5ed3764c"],
    "IDebugOutputCallbacksWide": ["4c7fd663-c394-4e26-8ef1-34ad5ed3764c"],
    "IDebugOutputStream": ["7782d8f2-2b85-4059-ab88-28ceddca1c80"],
    "IDebugOutputStringEvent2": ["569c4bb1-7b82-46fc-ae28-4536ddad753e"],
    "IDebugParsedExpression": ["7895c94c-5a3f-11d2-b742-0000f87572ef"],
    "IDebugPendingBreakpoint2": ["6e215ef3-e44c-44d1-b7ba-b2401f7dc23d"],
    "IDebugPendingBreakpoint3": ["96643d32-2624-479a-9f1a-25d02030dd3b"],
    "IDebugPlmClient": ["a02b66c4-aea3-4234-a9f7-fe4c383d4e29"],
    "IDebugPlmClient2": ["597c980d-e7bd-4309-962c-9d9b69a7372c"],
    "IDebugPlmClient3": ["cdf48669-901f-4791-b868-7d2cb3a2d7fc"],
    "IDebugPointerField": ["c2e34eb8-8b9d-11d2-9014-00c04fa38338"],
    "IDebugPointerObject": ["112756a1-3f04-4ccd-bfd6-acb4bca614c9"],
    "IDebugPointerObject2": ["bf032216-2c7f-4682-84c1-76ef432d840b"],
    "IDebugPointerObject3": ["b69d88f9-bc5a-4eb3-a43c-9af3155f0632"],
    "IDebugPort2": ["79293cc8-d9d9-43f5-97ad-0bcc5a688776"],
    "IDebugPortEvents2": ["564fa275-12e1-4b5f-8316-4d79bcef7246"],
    "IDebugPortEventsEx2": ["608a5912-e66b-4278-b6ed-847ac9318405"],
    "IDebugPortEx2": ["e2314ee1-5c8c-4a9d-ad32-0c9a3574f685"],
    "IDebugPortNotify2": ["fb8d2032-2858-414c-83d9-f732664e0c7a"],
    "IDebugPortPicker": ["8d6eed60-2737-4425-b38a-490ef273acbb"],
    "IDebugPortRequest2": ["8d36beb8-9bfe-47dd-a11b-7ba1de18e449"],
    "IDebugPortSupplier2": ["53f68191-7b2f-4f14-8e55-40b1b6e5df66"],
    "IDebugPortSupplier3": ["5b5eec44-51aa-4210-b84f-1938b8576d8d"],
    "IDebugPortSupplierDescription2": ["d0785faa-91d7-4ca2-a302-6555487719f7"],
    "IDebugPortSupplierEx2": ["c1f9ba1d-f70f-49f8-839e-5e0caa230306"],
    "IDebugPortSupplierLocale2": ["1bbab55e-6d13-4a5e-8c81-34ab2a3a6269"],
    "IDebugPrimitiveTypeField": ["7a739554-3fc6-43ee-981d-f49171151393"],
    "IDebugProcess2": ["43286fea-6997-4543-803e-60a20c473de5"],
    "IDebugProcess3": ["83ab1712-18a6-47a1-8da6-8c7b0f96092e"],
    "IDebugProcessContinueEvent100": ["c703ebea-42e7-4768-85a9-692eecba567b"],
    "IDebugProcessCreateEvent2": ["bac3780f-04da-4726-901c-ba6a4633e1ca"],
    "IDebugProcessDestroyEvent2": ["3e2a0832-17e1-4886-8c0e-204da242995f"],
    "IDebugProcessEnhancedStep90": ["c446ca51-979a-4096-b996-5934b7ab0455"],
    "IDebugProcessEx2": ["82d71df5-6597-48c4-b5d5-b8b697fa36b5"],
    "IDebugProcessInfoUpdatedEvent158": ["96c242fc-f584-4c3e-8fed-384d3d13ef36"],
    "IDebugProcessQueryProperties": ["230a0071-62ef-4cae-aac0-8988c37024bf"],
    "IDebugProcessSecurity2": ["fca0c35c-4c02-432b-88f7-eb277be2ba55"],
    "IDebugProcessStartTime140": ["a385590e-f94c-47a5-bc29-84bd01526171"],
    "IDebugProgram110": ["007d8d53-acbe-4fc6-99be-6bbf13d9f8d3"],
    "IDebugProgram150": ["6ec6f085-ffbe-41b8-979f-f885a86ea181"],
    "IDebugProgram2": ["69d172ef-f2c4-44e1-89f7-c86231e706e9"],
    "IDebugProgram3": ["7cf3ec7f-ac62-4cd6-bb30-39a464cb52cb"],
    "IDebugProgramCreateEvent2": ["96cd11ee-ecd4-4e89-957e-b5d496fc4139"],
    "IDebugProgramDestroyEvent2": ["e147e9e3-6440-4073-a7b7-a65592c714b5"],
    "IDebugProgramDestroyEventFlags2": ["7e072bee-24e7-43eb-9bce-06402c70e018"],
    "IDebugProgramEngines2": ["fda24a6b-b142-447d-bbbc-8654a3d84f80"],
    "IDebugProgramEnhancedStep90": ["6d07112f-b30d-47b4-b5ce-45b26c29205a"],
    "IDebugProgramEx2": ["2959618a-a692-48ff-8cef-7a28a4f50954"],
    "IDebugProgramHost2": ["c99d588f-778c-44fe-8b2e-40124a738891"],
    "IDebugProgramJIT2": ["87379803-2fad-4801-abdf-218b5d2f076f"],
    "IDebugProgramNameChangedEvent2": ["e05c2dfd-59d5-46d3-a71c-5d07665d85af"],
    "IDebugProgramNode2": ["426e255c-f1ce-4d02-a931-f9a254bf7f0f"],
    "IDebugProgramNodeAttach2": ["73faa608-5f87-4d2b-9551-8440b1cbf54c"],
    "IDebugProgramProvider2": ["1959530a-8e53-4e09-ad11-1b7334811cad"],
    "IDebugProgramPublisher2": ["a3dddf26-7792-4544-a9a4-d4dfb11cd8f3"],
    "IDebugProperty110": ["9119092a-be6b-44f0-914a-c9e83b9223cf"],
    "IDebugProperty150": ["6f4e34da-6b2b-4624-93c5-93a058cd95de"],
    "IDebugProperty157": ["790d60a3-2f26-426f-8a3c-53db57d4cd29"],
    "IDebugProperty158": ["e02453b1-f68a-47c1-b243-25760004a4b9"],
    "IDebugProperty160": ["c6c64271-4fde-485a-899b-d00e628f6a82"],
    "IDebugProperty164": ["b66d2821-1aed-489d-b376-42270d737c78"],
    "IDebugProperty2": ["a7ee3e7e-2dd2-4ad7-9697-f4aae3427762"],
    "IDebugProperty3": ["94e1e004-0672-423d-ad62-78783def1e76"],
    "IDebugPropertyBag110": ["574f2363-bd5b-43d4-a30f-3a0c562d5bef"],
    "IDebugPropertyClose2": ["852c7d42-794f-43cd-a18f-cd40e83e67cd"],
    "IDebugPropertyCreateEvent2": ["ded6d613-a3db-4e35-bb5b-a92391133f03"],
    "IDebugPropertyDestroyEvent2": ["f3765f18-f395-4b8c-8e95-dcb3fe8e7ec8"],
    "IDebugPropertyField": ["c2e34eb6-8b9d-11d2-9014-00c04fa38338"],
    "IDebugPropertySafetyWrapper": ["7031886b-61d2-4cb5-b909-00386090733b"],
    "IDebugProviderProgramNode2": ["afdba726-047a-4b83-b8c7-d812fe9caa5c"],
    "IDebugQueryEngine2": ["c989adc9-f305-4ef5-8ca2-20898e8d0e28"],
    "IDebugQueryPerformanceCountersCompletionRoutine150": ["442fbf28-fa75-4697-aa4f-41dc1e9b7777"],
    "IDebugReference2": ["10b793ac-0c47-4679-8454-adb36f29f802"],
    "IDebugRefreshBreakStateEvent162": ["4966ee8b-ef5c-4aa4-b4ba-7217ff345cbe"],
    "IDebugRefreshNotification140": ["23d9a2f7-d25a-4963-a59e-4828cb4fecab"],
    "IDebugRegisters": ["ce289126-9e84-45a7-937e-67bb18691493"],
    "IDebugRegisters2": ["1656afa9-19c6-4e3a-97e7-5dc9160cf9c4"],
    "IDebugRemoteServer2": ["3d3ce5c4-1508-4711-a5eb-f848f6e10072"],
    "IDebugRemoteServerFactory2": ["4a5af829-ca32-4b01-aae4-4c53d260e75c"],
    "IDebugRestrictedExceptionInfo110": ["24ef7776-1eb8-42f6-8146-ec673fbce5b4"],
    "IDebugReturnValueEvent2": ["0da4d4cc-2d0b-410f-8d5d-b6b73a5d35d8"],
    "IDebugReversibleEngineProgram160": ["7f7a3651-e3d2-4137-8367-56fcccaab4dc"],
    "IDebugReversibleSessionProcess160": ["a9bf4fb5-c25e-4fad-bdc4-ab9d9c72dce9"],
    "IDebugRuntimeJITServerProvider2": ["e7f35f78-362c-4d8a-8f76-3a7dbae0a237"],
    "IDebugSQLCLRProgramNode2": ["f617dfcb-0045-4024-837b-7acad8f4d67b"],
    "IDebugSession150": ["6b762667-eb09-4b7e-ac1a-5baabccc412a"],
    "IDebugSession2": ["8948300f-8bd5-4728-a1d8-83d172295a9d"],
    "IDebugSession3": ["bbf74db9-39d5-406e-8bc3-3ba9dd34c02e"],
    "IDebugSessionCreateEvent2": ["2c2b15b7-fc6d-45b3-9622-29665d964a76"],
    "IDebugSessionDestroyEvent2": ["f199b2c2-88fe-4c5d-a0fd-aa046b0dc0dc"],
    "IDebugSessionEvent2": ["fd1a378c-f117-4f43-917c-dadca1308606"],
    "IDebugSessionProcess110": ["e0b1eeac-4cb1-4421-a46b-c7a42f89ab67"],
    "IDebugSessionProcess120": ["c80129aa-876a-4f3b-81bb-8497ade9d47a"],
    "IDebugSessionProperty2": ["72ff2712-0bc3-4308-a99d-26ac7ec68c5f"],
    "IDebugSetJITEventCallback2": ["92dca9c3-37a3-4498-8466-4c57ea885e49"],
    "IDebugSetValueCallback": ["e0284f01-eda1-11d0-b452-00a0244a1dd2"],
    "IDebugSettings": ["3d451f98-c6a7-4d17-8398-d83a067183d8"],
    "IDebugSettings2": ["48d37585-e1a6-469b-83c8-30825037119e"],
    "IDebugSettings3": ["e6bb5022-0625-479f-8e32-4b583d73b7ac"],
    "IDebugSettings4": ["c9001e45-e824-5a5f-866c-e20cec88a8fc"],
    "IDebugSettingsCallback110": ["712b9487-3492-42a4-87f4-a676ed3707ce"],
    "IDebugSettingsCallback2": ["050b1813-91db-47a0-8987-fc55bdd6362b"],
    "IDebugSourceLinkDocumentContext150": ["667f17de-b438-4ada-a1e5-5517db9f6533"],
    "IDebugSourceLinkInfo150": ["6a31f3f2-bf97-452d-888b-cd526d1e9d80"],
    "IDebugSourceServerModule": ["492e5541-215b-4f67-ad73-20f48614912e"],
    "IDebugStackFrame110": ["4b509611-b6ea-4b24-adcb-d0ccfd1a7e33", "5cfcaf33-9b58-49b3-9be3-e47bec9fa20c"],
    "IDebugStackFrame120": ["94967a8a-5c7b-42df-9415-d6896a51de6a"],
    "IDebugStackFrame157": ["3c0fe564-2dfa-40d4-842e-1b7747c4c3ea"],
    "IDebugStackFrame2": ["1412926f-5dd6-4e58-b648-e1c63e013d51"],
    "IDebugStackFrame3": ["60de844b-38b1-4d87-afe1-8cf49677d3b0"],
    "IDebugStepCompleteEvent2": ["0f7f24c1-74d9-4ea6-a3ea-7edb2d81441d"],
    "IDebugStepCompleteEvent90": ["82d3f946-c2f8-495b-8b5f-9c30acdc6c81"],
    "IDebugStepper90": ["c0aa96a2-ae7c-4d80-8831-c7c720f14cca"],
    "IDebugStopCompleteEvent2": ["3dca9dcd-fb09-4af1-a926-45f293d48b2d"],
    "IDebugSymbolGroup": ["f2528316-0f1a-4431-aeed-11d096e1e2ab"],
    "IDebugSymbolGroup2": ["6a7ccc5f-fb5e-4dcc-b41c-6c20307bccc7"],
    "IDebugSymbolProvider": ["c2e34eae-8b9d-11d2-9014-00c04fa38338"],
    "IDebugSymbolProviderDirect": ["533a62e9-fddd-4fef-b7c3-be4117773087"],
    "IDebugSymbolProviderGroup": ["2b226a06-ff61-44f3-9add-b34bd9f72fcb"],
    "IDebugSymbolSearchEvent2": ["638f7c54-c160-4c7b-b2d0-e0337bc61f8c"],
    "IDebugSymbolSettings100": ["142a0821-8b28-49af-bd41-eabd00a88f57"],
    "IDebugSymbols": ["8c31e98c-983a-48a5-9016-6fe5d667a950"],
    "IDebugSymbols2": ["3a707211-afdd-4495-ad4f-56fecdf8163f"],
    "IDebugSymbols3": ["f02fbecc-50ac-4f36-9ad9-c975e8f32ff8"],
    "IDebugSymbols4": ["e391bbd8-9d8c-4418-840b-c006592a1752"],
    "IDebugSymbols5": ["c65fa83e-1e69-475e-8e0e-b5d79e9cc17e"],
    "IDebugSystemObjects": ["6b86fe2c-2c4f-4f0c-9da2-174311acc327"],
    "IDebugSystemObjects2": ["0ae9f5ff-1852-4679-b055-494bee6407ee"],
    "IDebugSystemObjects3": ["e9676e2f-e286-4ea3-b0f9-dfe5d9fc330e"],
    "IDebugSystemObjects4": ["489468e6-7d0f-4af5-87ab-25207454d553"],
    "IDebugTelemetryDetailsEvent150": ["8f2652b2-cd3c-4aed-a946-a3db6f379412"],
    "IDebugThisAdjust": ["49473e34-d4cc-49c8-bf62-79a08d2134a5"],
    "IDebugThread100": ["8590dd4c-bf52-4aef-8348-e0dac9c65268"],
    "IDebugThread120": ["daabf75d-aed6-4857-83c9-aaf589057c3d"],
    "IDebugThread156": ["f6cd61c6-b706-488a-96c0-1fc3f10ae514"],
    "IDebugThread157": ["43c7542b-f624-4e1f-9761-bb5a9396caff"],
    "IDebugThread2": ["d5168050-a57a-465c-bea9-974f405eba13"],
    "IDebugThread3": ["43d24196-0000-467f-8c6b-9c006922d02f"],
    "IDebugThread90": ["8fd7f3bb-c09e-4c0c-830f-114ffa8bf4f8"],
    "IDebugThreadCreateEvent2": ["2090ccfc-70c5-491d-a5e8-bad2dd9ee3ea"],
    "IDebugThreadDestroyEvent2": ["2c3b7532-a36f-4a6e-9072-49be649b8541"],
    "IDebugThreadDisplayNameChangeEvent100": ["39cbd675-bdf9-423a-884f-7ab36bf51af9"],
    "IDebugThreadFlagChangeEvent100": ["a4f87f48-d3c4-4694-a1a3-1969e3639ee7"],
    "IDebugThreadNameChangedEvent2": ["1ef4ef78-2c44-4b7a-8473-8f4357611729"],
    "IDebugThreadProperties": ["30ffaec1-c24c-440a-a9c5-1cc1cfd99dc8"],
    "IDebugThreadSuspendChangeEvent100": ["bd20393d-6d0c-44fb-a5e3-7bd5d1b640d1"],
    "IDebugTimedEvent140": ["5e1c7abd-5ebf-462c-866a-8fdcd3678250"],
    "IDebugTracepoint162": ["4be935f2-82c9-460c-8221-846e5147685e"],
    "IDebugTypeFieldBuilder": ["796ae40b-6cda-4f05-a663-d282a93ac7d4"],
    "IDebugTypeFieldBuilder2": ["eed3392e-c13a-42a9-932f-145c12b4fb5c"],
    "IDebugUpdateInMemoryPE": ["9e2bd568-7cee-4166-abc9-495ba8d3054a"],
    "IDebugUpdateInMemoryPE2": ["8a9e5aae-bef6-47a8-879b-690463516d73"],
    "IDebugUpdateInMemoryPE3": ["ae2ff3a4-2fa6-487c-ae74-9fb3d9276742"],
    "IDebugUserNotificationUI110": ["43fee995-53cd-41aa-9ec9-ca1281378788"],
    "IDebugUserNotificationUI120": ["e2e3aee2-9e39-40e5-8609-d43260630766"],
    "IDebugWindowsComputerPort2": ["5fbb8ed3-ecdb-412a-bfa3-3a54beb5b2d1"],
    "IDebugWrappedJITDebugger2": ["4dfa78ac-43c1-4de5-8179-3c3ec9010a31"],
    "IDebugWrappedMessageEvent140": ["d4a891bb-3f73-4964-a599-8b1210bcbc95"],
    "IDebuggerInfo": ["bf24142d-a47d-4d24-a66d-8c2141944e44"],
    "IDebuggerThreadControl": ["23d86786-0bb5-4774-8fb5-e3522add6246"],
    "IDecimalFormatterFactory": ["0d018c9a-e393-46b8-b830-7a69c8f89fbb"],
    "IDecimateVideoImage": ["2e5ea3e0-e924-11d2-b6da-00a0c995e8df"],
    "IDecompressor": ["b883fe46-d68a-4c8b-ada0-4ee813fc5283"],
    "IDecompressorFactory": ["5337e252-1da2-42e1-8834-0379d28d742f"],
    "IDedupBackupSupport": ["c719d963-2b2d-415e-acf7-7eb7ca596ff4"],
    "IDedupChunkLibrary": ["bb5144d7-2720-4dcc-8777-78597416ec23"],
    "IDedupDataPort": ["7963d734-40a9-4ea3-bbf6-5a89d26f7ae8"],
    "IDedupDataPortManager": ["44677452-b90a-445e-8192-cdcfe81511fb"],
    "IDedupIterateChunksHash32": ["90b584d3-72aa-400f-9767-cad866a5a2d8"],
    "IDedupReadFileCallback": ["7bacc67a-2f1d-42d0-897e-6ff62dd533bb"],
    "IDefaultAudioDeviceChangedEventArgs": ["110f882f-1c05-4657-a18e-47c9b69f07ab"],
    "IDefaultBrowserSyncSettings": ["7a27faad-5ae6-4255-9030-c530936292e3"],
    "IDefaultDeviceChangeNotification": ["af089eb5-4c6f-463b-bc06-dd5bf098b39d"],
    "IDefaultDeviceFactory": ["2972cef7-7f0f-41db-926f-d2ee5fca715b"],
    "IDefaultDeviceProvider": ["aaad6f87-9f5e-4a20-9cd7-8e2682315fb4"],
    "IDefaultExtractIconInit": ["41ded17d-d6b3-4261-997d-88c60e4b1d58"],
    "IDefaultFolderMenuInitialize": ["7690aa79-f8fc-4615-a327-36f7d18f5d91"],
    "IDefaultLocation": ["a65af77e-969a-4a2e-8aca-33bb7cbb1235"],
    "IDefaultPresentationConfiguration": ["d8c2b53b-2168-5703-a853-d525589fe2b9"],
    "IDeferral": ["d6269732-3b7f-46a7-b40b-4fdca2a2c693"],
    "IDeferralCompletedHandler": ["ed32a372-f3c8-4faa-9cfb-470148da3888"],
    "IDeferralFactory": ["65a1ecc5-3fb5-4832-8ca9-f061b281d13a"],
    "IDeferredInvoke": ["5edd2d9b-be4e-40b1-b783-b6e30a18c70b"],
    "IDefinitionAppId": ["d91e12d8-98ed-47fa-9936-39421283d59b"],
    "IDefinitionIdentity": ["587bf538-4d90-4a3c-9ef1-58a200a8a9e7"],
    "IDelayedPropertyStoreFactory": ["40d4577f-e237-4bdb-bd69-58f089431b6a"],
    "IDelayedVisibility": ["68a4fdba-a48a-4a86-a329-1b69b9b19e89"],
    "IDelegateHostItemContainer": ["02468693-e7e5-4c6b-9995-64ce5f51cec4"],
    "IDelegateItem": ["3c5a1c94-c951-4cb7-bb6d-3b93f30cce93"],
    "IDeleteBrowsingHistory": ["cf38ed4b-2be7-4461-8b5e-9a466dc82ae3"],
    "IDeleteLibraryCallback": ["234c2b44-4ea4-4114-ae7d-0f2e65622544"],
    "IDeliveryOptimizationCleanup": ["6692fd56-3b9b-433a-ac04-3ffb442556dd"],
    "IDeliveryOptimizationJob": ["ee2584cf-a69c-4848-b633-2649962b3ef7"],
    "IDeliveryOptimizationJobNotify": ["9787568a-71ff-42c8-8717-c40ec82f9185"],
    "IDeliveryOptimizationMgmt": ["baab12a9-fc1a-43e4-a915-ad826aeec8d8"],
    "IDeliveryOptimizationMgmtAdmin": ["eef3a6ae-ff2a-4a62-825b-060202082f12"],
    "IDeliveryOptimizationMgr": ["00aa9211-f3d0-4f46-9080-78bebff98836"],
    "IDeliveryOptimizationNotify": ["4ee9204b-6b39-4651-8529-98e848e45667"],
    "IDeliveryOptimizationOptions": ["90970731-fd64-4e53-9960-fe11b8fb8a2f"],
    "IDeliveryOptimizationPolicy": ["6a1c005c-ec79-4bbb-88b5-188bc45611ca"],
    "IDeliveryOptimizationSettings": ["1810fda0-e853-565e-b874-7a8a7b9a0e0f"],
    "IDeliveryOptimizationSettingsStatics": ["5c817caf-aed5-5999-b4c9-8c60898bc4f3"],
    "IDemuxRender": ["8f7c48e9-e418-456f-9265-a922135b0d49"],
    "IDependencyObject": ["5c526665-f60e-4912-af59-5fe0680f089d"],
    "IDependencyObject2": ["29fed85d-3d22-43a1-add0-17027c08b212"],
    "IDependencyObjectCollectionFactory": ["051e79ff-b3a8-49ee-b5af-ac8f68b649e4"],
    "IDependencyObjectFactory": ["9a03af92-7d8a-4937-884f-ecf34fe02acb"],
    "IDependencyProperty": ["85b13970-9bc4-4e96-acf1-30c8fd3d55c8"],
    "IDependencyPropertyChangedCallback": ["45883d16-27bf-4bc1-ac26-94c1601f3a49"],
    "IDependencyPropertyChangedEventArgs": ["81212c2b-24d0-4957-abc3-224470a93a4e"],
    "IDependencyPropertyChangedEventHandler": ["09223e5a-75be-4499-8180-1ddc005421c0"],
    "IDependencyPropertyStatics": ["49e5f28f-8259-4d5c-aae0-83d56dbb68d9"],
    "IDeploymentResult": ["2563b9ae-b77d-4c1f-8a7b-20e6ad515ef3"],
    "IDeploymentResult2": ["fc0e715c-5a01-4bd7-bcf1-381c8c82e04a"],
    "IDepthCorrelatedCoordinateMapper": ["f95d89fb-8af0-4cb0-926d-696866e5046a"],
    "IDepthMediaFrame": ["47135e4f-8549-45c0-925b-80d35efdb10a"],
    "IDepthMediaFrame2": ["6cca473d-c4a4-4176-b0cd-33eae3b35aa3"],
    "IDepthMediaFrameFormat": ["c312cf40-d729-453e-8780-2e04f140d28e"],
    "IDesignModeStatics": ["2c3893cc-f81a-4e7a-b857-76a80887e185"],
    "IDesignModeStatics2": ["80cf8137-b064-4858-bec8-3eba22357535"],
    "IDesignerAppExitedEventArgs": ["f6aac86a-0cad-410c-8f62-dc2936151c74"],
    "IDesignerAppManager": ["a6272caa-d5c6-40cb-abd9-27ba43831bb7"],
    "IDesignerAppManagerFactory": ["8f9d633b-1266-4c0e-8499-0db85bbd4c43"],
    "IDesignerAppView": ["5c777cea-dd71-4a84-a56f-dacb4b14706f"],
    "IDeskBand2": ["79d16de4-abee-4021-8d9d-9169b261d657"],
    "IDeskBandEx": ["5dd6b79a-3ab7-49c0-ab82-6b2da7d78d75"],
    "IDeskBandInfo": ["77e425fc-cbf9-4307-ba6a-bb5727745661"],
    "IDeskBarClient": ["eb0fe175-1a3a-11d0-89b3-00a0c90a90ac"],
    "IDesktopGadget": ["c1646bc4-f298-4f91-a204-eb2dd1709d1a"],
    "IDesktopNotificationActivator": ["1a7e31ea-c744-4ac4-a0f6-d274c9314863"],
    "IDesktopTileActivator": ["17541a17-f509-4cb6-8d08-651dc68d8227"],
    "IDesktopVisibilityChangesNotification": ["fc413902-2a24-4522-ad1f-2d27c0ffee84"],
    "IDesktopVisibilityService": ["2af0421a-a7bc-4b7e-be85-7e17c0ffee84"],
    "IDesktopWallpaper": ["b92b56a9-8b55-4e14-9a89-0199bbb6f93b"],
    "IDesktopWallpaperPrivate": ["c182461f-dfac-4375-ab6e-4cc45aa7f9cc"],
    "IDesktopWindowTarget": ["6329d6ca-3366-490e-9db3-25312929ac51"],
    "IDesktopWindowXamlSource": ["d585bfe1-00ff-51be-ba1d-a1329956ea0a"],
    "IDesktopWindowXamlSourceFactory": ["5cd61dc0-2561-56e1-8e75-6e44173805e3"],
    "IDesktopWindowXamlSourceGotFocusEventArgs": ["39be4849-d9cc-5b70-8f05-1ad9a4aaa342"],
    "IDesktopWindowXamlSourceNative": ["3cbcf1bf-2f76-4e9c-96ab-e84b37972554"],
    "IDesktopWindowXamlSourceNative2": ["e3dcd8c7-3057-4692-99c3-7b7720afda31"],
    "IDesktopWindowXamlSourceTakeFocusRequestedEventArgs": ["fe61e4b9-a7af-52b3-bdb9-c3305c0b8df2"],
    "IDestInfo": ["000001cd-0000-0000-c000-000000000046"],
    "IDestinationStreamFactory": ["8a87781b-39a7-4a1f-aab3-a39b9c34a7d9"],
    "IDetectedFace": ["8200d454-66bc-34df-9410-e89400195414"],
    "IDetectionConfigurationAvailabilityChangedEventArgs": ["5129c9fb-4be8-5f14-af2b-88d62b1b4462"],
    "IDetectionConfigurationAvailabilityInfo": ["b5affeb0-40f0-5398-b838-91979c2c6208"],
    "IDevToolbarDownloadInitiatorInfo": ["6a29b837-5c21-4665-8df2-ee993760e2e1"],
    "IDeveloperConsoleMessageReceiver": ["30510808-98b5-11cf-bb82-00aa00bdce0b"],
    "IDeviceAccessChangedEventArgs": ["deda0bcc-4f9d-4f58-9dba-a9bc800408d5"],
    "IDeviceAccessChangedEventArgs2": ["82523262-934b-4b30-a178-adc39f2f2be3"],
    "IDeviceAccessInformation": ["0baa9a73-6de5-4915-8ddd-9a0554a6f545"],
    "IDeviceAccessInformationStatics": ["574bd3d3-5f30-45cd-8a94-724fe5973084"],
    "IDeviceAccessPolicyManager": ["02a175a2-f59b-4490-8008-da0592239633"],
    "IDeviceAccountConfiguration": ["ad0123a3-fbdc-4d1b-be43-5a27ea4a1b63"],
    "IDeviceAccountConfiguration2": ["f2b2e5a6-728d-4a4a-8945-2bf8580136de"],
    "IDeviceActivatedEventArgs": ["cd50b9a9-ce10-44d2-8234-c355a073ef33"],
    "IDeviceAgentTransport": ["a28f4830-7032-44fe-9038-c215ac298c22"],
    "IDeviceArrivedEventHandler": ["efa9da69-f6e1-49c9-a49e-8e0fc58fb911"],
    "IDeviceAssociationBroker": ["2b0796b2-0d8b-4022-a6b7-7ca7d79364d4"],
    "IDeviceAssociationBrokerCallback": ["49891994-b7ba-4a1f-b979-6bd1a43e6c5f"],
    "IDeviceAssociationBrokerCustomHandler": ["527c7d30-422d-4b52-a22c-832314bcf459"],
    "IDeviceAssociationCallback": ["aa035573-c122-420a-a2b5-557ebb4bdeb9"],
    "IDeviceAssociationSettings": ["036eb567-8c67-4ade-9555-3bd7ab6d69a2"],
    "IDeviceBroker": ["8604b268-34a6-4b1a-a59f-cdbd8379fd98"],
    "IDeviceConnectionChangeTrigger": ["90875e64-3cdd-4efb-ab1c-5b3b6a60ce34"],
    "IDeviceConnectionChangeTriggerDetails": ["b8578c0c-bbc1-484b-bffa-7b31dcc200b2"],
    "IDeviceConnectionChangeTriggerStatics": ["c3ea246a-4efd-4498-aa60-a4e4e3b17ab9"],
    "IDeviceController": ["4feeb26d-50a7-402b-896a-be95064d6bff"],
    "IDeviceControllerFinderHandler": ["a88a7d06-988c-4403-9d8a-015bed140b34"],
    "IDeviceDepartedEventHandler": ["efa9da69-f6e2-49c9-a49e-8e0fc58fb911"],
    "IDeviceDisconnectButtonClickedEventArgs": ["8e44b56d-f902-4a00-b536-f37992e6a2a7"],
    "IDeviceDiscoveryAndPairingBroker": ["c01664c1-4973-43b5-98eb-1b4af20bcb3a"],
    "IDeviceDiscoveryContext": ["999aa7de-6880-4676-bb24-8788a8f3badb"],
    "IDeviceDisplayPropertiesCallback": ["91867751-3d57-4614-b938-7065b758a035"],
    "IDeviceDisplayPropertiesProvider": ["ef05e46f-6730-40c6-bab1-96f2a8076226"],
    "IDeviceDisplayStatusFactory": ["db4b2731-7a52-4923-a603-908f7fa1eedc"],
    "IDeviceDisplayStatusFactory2": ["f167b5a5-cb97-48d7-a0ff-4e736240df46"],
    "IDeviceEnumerationHelper": ["6cf5b075-a9ca-44b3-999b-994304844d46"],
    "IDeviceGraphObjectCache": ["ce70eb76-c767-4c4a-bf83-322a29cec581"],
    "IDeviceGraphObjectCacheManager": ["97ecdc10-b3b5-4dff-8dcc-abd71ac23c33"],
    "IDeviceIcon": ["8ffb1a1e-023d-4de1-b556-ab5abf01929c"],
    "IDeviceIdentity": ["f2dc8b0c-0447-4e0c-909f-2a6d94390f6a"],
    "IDeviceInformation": ["aba0fb95-4398-489d-8e44-e6130927011f"],
    "IDeviceInformation2": ["f156a638-7997-48d9-a10c-269d46533f48"],
    "IDeviceInformationCustomPairing": ["85138c02-4ee6-4914-8370-107a39144c0e"],
    "IDeviceInformationPairing": ["2c4769f5-f684-40d5-8469-e8dbaab70485"],
    "IDeviceInformationPairing2": ["f68612fd-0aee-4328-85cc-1c742bb1790d"],
    "IDeviceInformationPairingStatics": ["e915c408-36d4-49a1-bf13-514173799b6b"],
    "IDeviceInformationPairingStatics2": ["04de5372-b7b7-476b-a74f-c5836a704d98"],
    "IDeviceInformationStatics": ["c17f100e-3a46-4a78-8013-769dc9b97390"],
    "IDeviceInformationStatics2": ["493b4f34-a84f-45fd-9167-15d1cb1bd1f9"],
    "IDeviceInformationUpdate": ["8f315305-d972-44b7-a37e-9e822c78213b"],
    "IDeviceInformationUpdate2": ["5d9d148c-a873-485e-baa6-aa620788e3cc"],
    "IDeviceIoControl": ["9eefe161-23ab-4f18-9b49-991b586ae970"],
    "IDeviceMetadataHelper": ["2c6d8250-3e48-4218-935a-e7a094879d96"],
    "IDeviceMetadataParser": ["6a8e8546-71d2-4c33-8cc8-62882f541d54"],
    "IDeviceModelPlugIn": ["1cd63475-07c4-46fe-a903-d655316d11fd"],
    "IDeviceNotificationCallback": ["a7eb8f00-ae98-4be6-b50f-49b933c7455d"],
    "IDevicePacketStream": ["bd6a1f9f-086e-41df-bad2-6c7b24825dcf"],
    "IDevicePair": ["f1a423f1-b7b4-449c-a90d-aea8e17c5e5f"],
    "IDevicePairingActivatedEventArgs": ["eba0d1e4-ecc6-4148-94ed-f4b37ec05b3e"],
    "IDevicePairingContext": ["16bd01cf-9e2c-4a71-a4b0-f720703231e0"],
    "IDevicePairingManager": ["81053590-ce20-472a-88d9-653eb4ea6473"],
    "IDevicePairingManagerCallback": ["948e7465-38f6-4d1d-8b6e-8d194fcb0cbd"],
    "IDevicePairingRequestedEventArgs": ["f717fc56-de6b-487f-8376-0180aca69963"],
    "IDevicePairingRequestedEventArgs2": ["c83752d9-e4d3-4db0-a360-a105e437dbdc"],
    "IDevicePairingResult": ["072b02bf-dd95-4025-9b37-de51adba37b7"],
    "IDevicePairingSettings": ["482cb27c-83bb-420e-be51-6602b222de54"],
    "IDevicePicker": ["84997aa2-034a-4440-8813-7d0bd479bf5a"],
    "IDevicePickerAppearance": ["e69a12c6-e627-4ed8-9b6c-460af445e56d"],
    "IDevicePickerFilter": ["91db92a2-57cb-48f1-9b59-a59b7a1f02a2"],
    "IDevicePortalConnection": ["0f447f51-1198-4da1-8d54-bdef393e09b6"],
    "IDevicePortalConnectionClosedEventArgs": ["fcf70e38-7032-428c-9f50-945c15a9f0cb"],
    "IDevicePortalConnectionRequestReceivedEventArgs": ["64dae045-6fda-4459-9ebd-ecce22e38559"],
    "IDevicePortalConnectionStatics": ["4bbe31e7-e9b9-4645-8fed-a53eea0edbd6"],
    "IDevicePortalWebSocketConnection": ["67657920-d65a-42f0-aef4-787808098b7b"],
    "IDevicePortalWebSocketConnectionRequestReceivedEventArgs": ["79fdcaba-175c-4739-9f74-dda797c35b3f"],
    "IDeviceRequestCompletionCallback": ["999bad24-9acd-45bb-8669-2a2fc0288b04"],
    "IDeviceSelectedEventArgs": ["269edade-1d2f-4940-8402-4156b81d3c77"],
    "IDeviceServicingDetails": ["4aabee29-2344-4ac4-8527-4a8ef6905645"],
    "IDeviceServicingTrigger": ["1ab217ad-6e34-49d3-9e6f-17f1b6dfa881"],
    "IDeviceSpecificProperty": ["3b22bcbf-2586-4af0-8583-205d391b807c"],
    "IDeviceStream": ["48956b2c-47f3-45ee-8ab3-b7b09220f8ac"],
    "IDeviceTicketManager": ["efce55bb-e93a-4478-ad33-edb7a0782dbe"],
    "IDeviceTopology": ["2a07407e-6497-4a18-9787-32f79bd0d98f"],
    "IDeviceTopologyTest": ["b9cacc9c-6879-4988-a3ce-ffd38e08ab93"],
    "IDeviceUnpairingResult": ["66f44ad3-79d9-444b-92cf-a92ef72571c7"],
    "IDeviceUseDetails": ["7d565141-557e-4154-b994-e4f7a11fb323"],
    "IDeviceUseTrigger": ["0da68011-334f-4d57-b6ec-6dca64b412e4"],
    "IDeviceWatcher": ["c9eab97d-8f6b-4f96-a9f4-abc814e22271"],
    "IDeviceWatcher2": ["ff08456e-ed14-49e9-9a69-8117c54ae971"],
    "IDeviceWatcherEvent": ["74aa9c0b-1dbd-47fd-b635-3cc556d0ff8b"],
    "IDeviceWatcherTrigger": ["a4617fdd-8573-4260-befc-5bec89cb693d"],
    "IDeviceWatcherTriggerDetails": ["38808119-4cb7-4e57-a56d-776d07cbfef9"],
    "IDevicesFlow": ["5b0d0ad4-9dcd-48c0-bfa0-7a407d50664d"],
    "IDevicesFlowController": ["1a94ebd6-6e02-4715-a74b-de718a1bc1b2"],
    "IDevicesFlowNotification": ["0f0a074d-1c9c-4668-b20f-c90f8818672f"],
    "IDiaAddressMap": ["b62a2e7a-067a-4ea3-b598-04c09717502c"],
    "IDiaDataSource": ["79f1bb5f-b66e-48e5-b6a9-1545c323ca3d"],
    "IDiaDataSource2": ["6d31cb3b-edd4-4c3e-ab44-12b9f7a3828e"],
    "IDiaDataSource3": ["65a23c15-bab3-45da-8639-f06de86b9ea8"],
    "IDiaDataSource4": ["27b468a6-229c-4248-8f5e-f326e7c62ba4"],
    "IDiaEnumDebugStreamData": ["486943e8-d187-4a6b-a3c4-291259fff60d"],
    "IDiaEnumDebugStreams": ["08cbb41e-47a6-4f87-92f1-1c9c87ced044"],
    "IDiaEnumFrameData": ["9fc77a4b-3c1c-44ed-a798-6c1deea53e1f"],
    "IDiaEnumInjectedSources": ["d5612573-6925-4468-8883-98cdec8c384a"],
    "IDiaEnumInputAssemblyFiles": ["1c7ff653-51f7-457e-8419-b20f57ef7e4d"],
    "IDiaEnumLineNumbers": ["fe30e878-54ac-44f1-81ba-39de940f6052"],
    "IDiaEnumSectionContribs": ["1994deb2-2c82-4b1d-a57f-aff424d54a68"],
    "IDiaEnumSegments": ["e8368ca9-01d1-419d-ac0c-e31235dbda9f"],
    "IDiaEnumSourceFiles": ["10f3dbd9-664f-4469-b808-9471c7a50538"],
    "IDiaEnumStackFrames": ["ec9d461d-ce74-4711-a020-7d8f9a1dd255"],
    "IDiaEnumSymbols": ["cab72c48-443b-48f5-9b0b-42f0820ab29a"],
    "IDiaEnumSymbolsByAddr": ["624b7d9c-24ea-4421-9d06-3b577471c1fa"],
    "IDiaEnumTables": ["c65c2b0a-1150-4d7a-afcc-e05bf3dee81e"],
    "IDiaFrameData": ["a39184b7-6a36-42de-8eec-7df9f3f59f33"],
    "IDiaImageData": ["c8e40ed2-a1d9-4221-8692-3ce661184b44"],
    "IDiaInjectedSource": ["ae605cdc-8105-4a23-b710-3259f1e26112"],
    "IDiaInputAssemblyFile": ["3bfe56b0-390c-4863-9430-1f3d083b7684"],
    "IDiaLineNumber": ["b388eb14-be4d-421d-a8a1-6cf7ab057086"],
    "IDiaLoadCallback": ["c32adb82-73f4-421b-95d5-a4706edf5dbe"],
    "IDiaLoadCallback2": ["4688a074-5a4d-4486-aea8-7b90711d9f7c"],
    "IDiaPropertyStorage": ["9d416f9c-e184-45b2-a4f0-ce517f719e9b"],
    "IDiaReadExeAtOffsetCallback": ["587a461c-b80b-4f54-9194-5032589a6319"],
    "IDiaReadExeAtRVACallback": ["8e3f80ca-7517-432a-ba07-285134aaea8e"],
    "IDiaSectionContrib": ["0cf4b60e-35b1-4c6c-bdd8-854b9c8e3857"],
    "IDiaSegment": ["0775b784-c75b-4449-848b-b7bd3159545b"],
    "IDiaSession": ["2f609ee1-d1c8-4e24-8288-3326badcd211", "6fc5d63f-011e-40c2-8dd2-e6486e9d6b68"],
    "IDiaSourceFile": ["a2ef5353-f5a8-4eb3-90d2-cb526acb3cdd"],
    "IDiaStackFrame": ["5edbc96d-cdd6-4792-afbe-cc89007d9610"],
    "IDiaStackWalkFrame": ["07c590c1-438d-4f47-bdcd-4397bc81ad75"],
    "IDiaStackWalkHelper": ["21f81b1b-c5bb-42a3-bc4f-ccbaa75b9f19"],
    "IDiaStackWalkHelper2": ["8222c490-507b-4bef-b3bd-41dca7b5934c"],
    "IDiaStackWalker": ["5485216b-a54c-469f-9670-52b24d5229bb"],
    "IDiaStackWalker2": ["7c185885-a015-4cac-9411-0f4fb39b1f3a"],
    "IDiaSymbol": ["cb787b2f-bd6c-4635-ba52-933126bd2dcd"],
    "IDiaTable": ["4a59fb77-abac-469b-a30b-9ecc85bfef14"],
    "IDiagnosticActionResult": ["c265a296-e73b-4097-b28f-3442f03dd831"],
    "IDiagnosticInvoker": ["187b270a-02e3-4f86-84fc-fdd892b5940f"],
    "IDiagnosticInvoker2": ["e3bf945c-155a-4b52-a8ec-070c44f95000"],
    "IDiagnosticInvokerStatics": ["5cfad8de-f15c-4554-a813-c113c3881b09"],
    "IDiagnosticsScriptEngine": ["30510859-98b5-11cf-bb82-00aa00bdce0b"],
    "IDiagnosticsScriptEngineProvider": ["3051085a-98b5-11cf-bb82-00aa00bdce0b"],
    "IDiagnosticsScriptEngineSite": ["30510858-98b5-11cf-bb82-00aa00bdce0b"],
    "IDiagnosticsSettings": ["e5e9eccd-2711-44e0-973c-491d78048d24"],
    "IDiagnosticsSettingsStatics": ["72d2e80f-5390-4793-990b-3ccc7d6ac9c8"],
    "IDialApp": ["555ffbd3-45b7-49f3-bbd7-302db6084646"],
    "IDialAppStateDetails": ["ddc4a4a1-f5de-400d-bea4-8c8466bb2961"],
    "IDialDevice": ["fff0edaf-759f-41d2-a20a-7f29ce0b3784"],
    "IDialDevice2": ["bab7f3d5-5bfb-4eba-8b32-b57c5c5ee5c9"],
    "IDialDevicePicker": ["ba7e520a-ff59-4f4b-bdac-d89f495ad6e1"],
    "IDialDevicePickerFilter": ["c17c93ba-86c0-485d-b8d6-0f9a8f641590"],
    "IDialDeviceSelectedEventArgs": ["480b92ad-ac76-47eb-9c06-a19304da0247"],
    "IDialDeviceStatics": ["aa69cc95-01f8-4758-8461-2bbd1cdc3cf3"],
    "IDialDisconnectButtonClickedEventArgs": ["52765152-9c81-4e55-adc2-0ebe99cde3b6"],
    "IDialReceiverActivatedEventArgs": ["fb777ed7-85ee-456e-a44d-85d730e70aed"],
    "IDialReceiverApp": ["fd3e7c57-5045-470e-b304-4dd9b13e7d11"],
    "IDialReceiverApp2": ["530c5805-9130-42ac-a504-1977dcb2ea8a"],
    "IDialReceiverAppStatics": ["53183a3c-4c36-4d02-b28a-f2a9da38ec52"],
    "IDialRequestedEventArgs": ["037b929e-953c-4286-8866-4f0f376c855a"],
    "IDialRequestedEventHandler": ["5abbffdb-c21f-4bc4-891b-257e28c1b1a4"],
    "IDialogWindowBroker": ["163e219f-16d9-4706-8b04-9f2852e153a6"],
    "IDigitalCableLocator": ["48f66a11-171a-419a-9525-beeecd51584c"],
    "IDigitalCableTuneRequest": ["bad7753b-6b37-4810-ae57-3ce0c4a9e6cb"],
    "IDigitalCableTuningSpace": ["013f9f9c-b449-4ec7-a6d2-9d4f2fc70ae5"],
    "IDigitalLocator": ["19b595d8-839a-47f0-96df-4f194f3c768c"],
    "IDirect3D11CaptureFrame": ["fa50c623-38da-4b32-acf3-fa9734ad800e"],
    "IDirect3D11CaptureFramePool": ["24eb6d22-1975-422e-82e7-780dbd8ddf24"],
    "IDirect3D11CaptureFramePoolStatics": ["7784056a-67aa-4d53-ae54-1088d5a8ca21"],
    "IDirect3D11CaptureFramePoolStatics2": ["589b103f-6bbc-5df5-a991-02e28b3b66d5"],
    "IDirect3D9ExEnumerationSettings": ["9dce9370-e1b7-43ed-9b77-908e62396cde"],
    "IDirect3D9ExOverlayExtension": ["187aeb13-aaf5-4c59-876d-e059088c0df8"],
    "IDirect3DAuthenticatedChannel9": ["ff24beee-da21-4beb-98b5-d2f899f98af9"],
    "IDirect3DCaptureContainer9": ["ab04a269-1f6b-422c-940f-d1a1d94f7d06"],
    "IDirect3DCryptoSession9": ["fa0ab799-7a9c-48ca-8c5b-237e71a54434"],
    "IDirect3DDXVA2Container9": ["126d0349-4787-4aa6-8e1b-40c177c60a01"],
    "IDirect3DDXVADevice9": ["9f00c3d3-5ab6-465f-b955-9f0ebb2c5606"],
    "IDirect3DDXVAExtensionDevice9": ["d54b57b4-4cdb-4ad6-97df-eab7aed7d3b7"],
    "IDirect3DDXVAHDDevice9": ["babba640-5592-48d9-8a84-07671b5534e4"],
    "IDirect3DDXVAHDVideoProcessor9": ["cb129961-b008-47d2-817b-5d2ff10e1ec1"],
    "IDirect3DDecodeDevice9": ["41f9cb11-d633-40bb-abf1-229262d7c3af"],
    "IDirect3DDevice9On12": ["e7fda234-b589-4049-940d-8878977531c8"],
    "IDirect3DDevice9Video": ["26dc4561-a1ee-4ae7-96da-118a36c0ec95"],
    "IDirect3DDeviceManager9": ["a0cade0f-06d5-4cf4-a1c7-f3cdd725aa75"],
    "IDirect3DShaderValidator9": ["814d5a8f-5a68-47f4-bcc6-d4d910b2a9e5"],
    "IDirect3DVideoDevice9": ["694036ac-542a-4a3a-9a32-53bc20002c1b"],
    "IDirect3DVideoProcessDevice9": ["74c5b367-a31f-4669-bcdd-e9547717dcbe"],
    "IDirectConnectedAnimationConfiguration": ["ee5d736f-5738-5d86-b770-151948cf365e"],
    "IDirectConnectedAnimationConfigurationFactory": ["059263e9-d2b3-5a77-9cf4-e26d8b542608"],
    "IDirectDraw3": ["618f8ad4-8b7a-11d0-8fcc-00c04fd9189d"],
    "IDirectDrawMediaSample": ["ab6b4afe-f6e4-11d0-900d-00c04fd9189d"],
    "IDirectDrawMediaSampleAllocator": ["ab6b4afc-f6e4-11d0-900d-00c04fd9189d"],
    "IDirectDrawMediaStream": ["f4104fce-9a70-11d0-8fde-00c04fd9189d"],
    "IDirectDrawStreamSample": ["f4104fcf-9a70-11d0-8fde-00c04fd9189d"],
    "IDirectManipulationAutoScrollBehavior": ["6d5954d4-2003-4356-9b31-d051c9ff0af7"],
    "IDirectManipulationCompositor": ["537a0825-0387-4efa-b62f-71eb1f085a7e"],
    "IDirectManipulationCompositor2": ["d38c7822-f1cb-43cb-b4b9-ac0c767a412e"],
    "IDirectManipulationCompositorPartner": ["59f4c99d-084e-46b9-ad3b-c9776f453163"],
    "IDirectManipulationContent": ["b89962cb-3d89-442b-bb58-5098fa0f9f16"],
    "IDirectManipulationContent2": ["2386312c-0b34-4383-a23d-24d45c125a9d"],
    "IDirectManipulationCrossProcessEventHandler": ["51484e62-a674-11e4-89d3-123b93f75cba"],
    "IDirectManipulationDeferContactService": ["652d5c71-fe60-4a98-be70-e5f21291e7f1"],
    "IDirectManipulationDelegatedViewportEventHandler": ["8779d548-148d-4cb0-abe0-5c084d0d1ae8"],
    "IDirectManipulationDragDropBehavior": ["814b5af5-c2c8-4270-a9b7-a198ce8d02fa"],
    "IDirectManipulationDragDropEventHandler": ["1fa11b10-701b-41ae-b5f2-49e36bd595aa"],
    "IDirectManipulationFrameInfoProvider": ["fb759dba-6f4c-4c01-874e-19c8a05907f9"],
    "IDirectManipulationInteractionEventHandler": ["e43f45b8-42b4-403e-b1f2-273b8f510830"],
    "IDirectManipulationManager": ["fbf5d3b4-70c7-4163-9322-5a6f660d6fbc"],
    "IDirectManipulationManager2": ["fa1005e9-3d16-484c-bfc9-62b61e56ec4e"],
    "IDirectManipulationManager3": ["2cb6b33d-ffe8-488c-b750-fbdfe88dca8c"],
    "IDirectManipulationManagerPartner": ["0a467fda-2a21-4b04-bb41-b3482d087b23"],
    "IDirectManipulationParametricMotionBehavior": ["820c0b62-45be-41dd-a2dc-6ccaf6ae0f04"],
    "IDirectManipulationParametricMotionCurve": ["cca6498e-f33f-4bf5-a344-c08067a863e4"],
    "IDirectManipulationParametricRestPointBehavior": ["b9a34d22-6f1f-4f81-92e6-02612316aea1"],
    "IDirectManipulationParametricRestPointList": ["ada8a4c4-1694-4f03-854e-0d118c451dd6"],
    "IDirectManipulationPrimaryContent": ["c12851e4-1698-4625-b9b1-7ca3ec18630b"],
    "IDirectManipulationPrimaryContent2": ["d8042f40-a051-4fee-875e-243b7b38d66e"],
    "IDirectManipulationSnapPointsBehavior": ["f170ddfd-6190-4dfa-a44e-e2c7235f06df"],
    "IDirectManipulationSnapPointsInertiaBehavior": ["5a775dd9-9ab2-4ba4-bdcb-1fcc46c1766b"],
    "IDirectManipulationUpdateHandler": ["790b6337-64f8-4ff5-a269-b32bc2af27a7"],
    "IDirectManipulationUpdateManager": ["b0ae62fd-be34-46e7-9caa-d361facbb9cc"],
    "IDirectManipulationViewport": ["28b85a3d-60a0-48bd-9ba1-5ce8d9ea3a6d"],
    "IDirectManipulationViewport2": ["923ccaac-61e1-4385-b726-017af189882a"],
    "IDirectManipulationViewport3": ["b3b92295-a421-41e3-a6b2-07922a217cad"],
    "IDirectManipulationViewportEventHandler": ["952121da-d69f-45f9-b0f9-f23944321a6d"],
    "IDirectManipulationViewportPartner": ["b0908968-2c5d-4d78-9607-c3c006df6f19"],
    "IDirectMusicCollection8": ["d2ac287c-b39b-11d1-8704-00600893b1bd"],
    "IDirectMusicDownload8": ["d2ac287b-b39b-11d1-8704-00600893b1bd"],
    "IDirectMusicDownloadedInstrument8": ["d2ac287e-b39b-11d1-8704-00600893b1bd"],
    "IDirectMusicInstrument8": ["d2ac287d-b39b-11d1-8704-00600893b1bd"],
    "IDirectMusicPort8": ["08f2d8c9-37c2-11d2-b9f9-0000f875ac12"],
    "IDirectMusicPortDownload8": ["d2ac287a-b39b-11d1-8704-00600893b1bd"],
    "IDirectMusicSynth": ["09823661-5c85-11d2-afa6-00aa0024d8b6"],
    "IDirectMusicSynth8": ["53cab625-2711-4c9f-9de7-1b7f925f6fc8"],
    "IDirectMusicSynthSink": ["09823663-5c85-11d2-afa6-00aa0024d8b6"],
    "IDirectMusicThru8": ["ced153e7-3606-11d2-b9f9-0000f875ac12"],
    "IDirectSound3DBuffer8": ["279afa86-4981-11ce-a521-0020af0be560"],
    "IDirectSound3DListener8": ["279afa84-4981-11ce-a521-0020af0be560"],
    "IDirectSoundCapture8": ["b0210781-89cd-11d0-af08-00a0c925cd16"],
    "IDirectSoundCaptureFXAec8": ["ad74143d-903d-4ab7-8066-28d363036d65"],
    "IDirectSoundCaptureFXNoiseSuppress8": ["ed311e41-fbae-4175-9625-cd0854f693ca"],
    "IDirectSoundFXChorus8": ["880842e3-145f-43e6-a934-a71806e50547"],
    "IDirectSoundFXCompressor8": ["4bbd1154-62f6-4e2c-a15c-d3b6c417f7a0"],
    "IDirectSoundFXDistortion8": ["8ecf4326-455f-4d8b-bda9-8d5d3e9e3e0b"],
    "IDirectSoundFXEcho8": ["8bd28edf-50db-4e92-a2bd-445488d1ed42"],
    "IDirectSoundFXFlanger8": ["903e9878-2c92-4072-9b2c-ea68f5396783"],
    "IDirectSoundFXGargle8": ["d616f352-d622-11ce-aac5-0020af0b99a3"],
    "IDirectSoundFXI3DL2Reverb8": ["4b166a6a-0d66-43f3-80e3-ee6280dee1a4"],
    "IDirectSoundFXParamEq8": ["c03ca9fe-fe90-4204-8078-82334cd177da"],
    "IDirectSoundFXWavesReverb8": ["46858c3a-0dc6-45e3-b760-d4eef16cb325"],
    "IDirectSoundFullDuplex8": ["edcb4c7a-daab-4216-a42e-6c50596ddc1d"],
    "IDirectSoundNotify8": ["b0210783-89cd-11d0-af08-00a0c925cd16"],
    "IDirectXVideoAccelerationService": ["fc51a550-d5e7-11d9-af55-00054e43ff02"],
    "IDirectXVideoDecoder": ["f2b0810a-fd00-43c9-918c-df94e2d8ef7d"],
    "IDirectXVideoDecoderService": ["fc51a551-d5e7-11d9-af55-00054e43ff02"],
    "IDirectXVideoMemoryConfiguration": ["b7f916dd-db3b-49c1-84d7-e45ef99ec726"],
    "IDirectXVideoProcessor": ["8c3a39f0-916e-4690-804f-4c8001355d25"],
    "IDirectXVideoProcessorService": ["fc51a552-d5e7-11d9-af55-00054e43ff02"],
    "IDiscFormat2": ["27354152-8f64-5b0f-8f00-5d77afbe261e"],
    "IDiscFormat2Data": ["27354153-9f64-5b0f-8f00-5d77afbe261e"],
    "IDiscFormat2DataEventArgs": ["2735413d-7f64-5b0f-8f00-5d77afbe261e"],
    "IDiscFormat2Erase": ["27354156-8f64-5b0f-8f00-5d77afbe261e"],
    "IDiscFormat2RawCD": ["27354155-8f64-5b0f-8f00-5d77afbe261e"],
    "IDiscFormat2RawCDEventArgs": ["27354143-7f64-5b0f-8f00-5d77afbe261e"],
    "IDiscFormat2TrackAtOnce": ["27354154-8f64-5b0f-8f00-5d77afbe261e"],
    "IDiscFormat2TrackAtOnceEventArgs": ["27354140-7f64-5b0f-8f00-5d77afbe261e"],
    "IDiscMaster2": ["27354130-7f64-5b0f-8f00-5d77afbe261e"],
    "IDiscRecorder2": ["27354133-7f64-5b0f-8f00-5d77afbe261e"],
    "IDiscRecorder2Ex": ["27354132-7f64-5b0f-8f00-5d77afbe261e"],
    "IDisconnectSink": ["0000014a-0000-0000-c000-000000000046"],
    "IDiscoverRecentItem": ["dd910131-9c55-48a4-8fa7-f00d062b10f2"],
    "IDiscoverUrlCallBack": ["0eea651c-b208-4ede-96ce-5194f4dc4e4a"],
    "IDiscoveryClientResult": ["fc5e8b09-ff17-4da6-ba39-eb8dfc314bc1"],
    "IDiscoveryClientResultCollection": ["bceb2c6c-e0d1-4fa5-8ddc-977d68e8d50b"],
    "IDiscoveryResult": ["b9a32c91-b14d-4ae3-a955-5cbc3e75fca5"],
    "IDiscoveryResult2": ["9947783d-b173-4fd9-8e6e-91482cf9e239"],
    "IDiscoveryResult3": ["6e1073e5-a112-441a-8386-232cecc0c29b"],
    "IDiscoverySession": ["d622fe99-2087-4d78-8b49-7b46460475fd"],
    "IDiscoverySession2": ["182b5eb4-9a58-47b7-a3fe-ac7ed8b891ff"],
    "IDiscreteColorKeyFrame": ["230c08f4-e062-4cb1-8e2a-14093d73ed8c"],
    "IDiscreteDoubleKeyFrame": ["f5f51f3a-ad11-49ce-8e1c-08fdf1447446"],
    "IDiscreteObjectKeyFrame": ["c7dcde89-f12d-4a9c-8199-e7a9ece3a473"],
    "IDiscretePointKeyFrame": ["e0a9070d-4c42-4a90-983a-75f5a83a2fbe"],
    "IDiskCleanupMgr": ["eb025082-257d-4a9e-a402-1468bc2868ec"],
    "IDiskQuotaControl": ["7988b572-ec89-11cf-9c00-00aa00a14f56"],
    "IDiskQuotaEvents": ["7988b579-ec89-11cf-9c00-00aa00a14f56"],
    "IDiskQuotaUser": ["7988b574-ec89-11cf-9c00-00aa00a14f56"],
    "IDiskQuotaUserBatch": ["7988b576-ec89-11cf-9c00-00aa00a14f56"],
    "IDispCivicAddressReport": ["16ff1a34-9e30-42c3-b44d-e22513b5767a"],
    "IDispLatLongReport": ["8ae32723-389b-4a11-9957-5bdd48fc9617"],
    "IDispatchExInternal": ["db113cdd-aba5-4ae7-ac40-b9a10d341fa9"],
    "IDispatchVerifyUntrusted": ["c78d010b-c706-4a74-9e8e-4a634be760fc"],
    "IDispatch_In_Memory": ["83fb5d85-2339-11d2-b89d-00c04fb9618a"],
    "IDispatchedHandler": ["d1f276c4-98d8-4636-bf49-eb79507548e9"],
    "IDispatcherQueue": ["603e88e4-a338-4ffe-a457-a5cfb9ceb899"],
    "IDispatcherQueue2": ["c822c647-30ef-506e-bd1e-a647ae6675ff"],
    "IDispatcherQueueController": ["22f34e66-50db-4e36-a98d-61c01b384d20"],
    "IDispatcherQueueControllerStatics": ["0a6c98e0-5198-49a2-a313-3f70d1f13c27"],
    "IDispatcherQueueHandler": ["dfa2dc9c-1a2d-4917-98f2-939af1d6e0c8"],
    "IDispatcherQueueShutdownStartingEventArgs": ["c4724c4c-ff97-40c0-a226-cc0aaa545e89"],
    "IDispatcherQueueStatics": ["a96d83d7-9371-4517-9245-d0824ac12c74"],
    "IDispatcherQueueTimer": ["5feabb1d-a31c-4727-b1ac-37454649d56a"],
    "IDispatcherTimer": ["d160ce46-cd22-4f5f-8c97-40e61da3e2dc"],
    "IDispatcherTimerFactory": ["e9961e6e-3626-403a-afe0-040d58165632"],
    "IDispenserManagerDriver": ["aa5839c0-7c77-11cf-9489-00aa00bf9397"],
    "IDispenserManagerDriver2": ["b7ed6e1a-d984-11d1-939b-00aa00ba3258"],
    "IDisplayDeviceInterop": ["64338358-366a-471b-bd56-dd8ef48e439b"],
    "IDisplayEnhancementOverride": ["429594cf-d97a-4b02-a428-5c4292f7f522"],
    "IDisplayEnhancementOverrideCapabilities": ["457060de-ee5a-47b7-9918-1e51e812ccc8"],
    "IDisplayEnhancementOverrideCapabilitiesChangedEventArgs": ["db61e664-15fa-49da-8b77-07dbd2af585d"],
    "IDisplayEnhancementOverrideStatics": ["cf5b7ec1-9791-4453-b013-29b6f778e519"],
    "IDisplayInformation": ["bed112ae-adc3-4dc9-ae65-851f4d7d4799"],
    "IDisplayInformation2": ["4dcd0021-fad1-4b8e-8edf-775887b8bf19"],
    "IDisplayInformation3": ["db15011d-0f09-4466-8ff3-11de9a3c929a"],
    "IDisplayInformation4": ["c972ce2f-1242-46be-b536-e1aafe9e7acf"],
    "IDisplayInformation5": ["3a5442dc-2cde-4a8d-80d1-21dc5adcc1aa"],
    "IDisplayInformationStatics": ["c6a02a6c-d452-44dc-ba07-96f3c6adf9d1"],
    "IDisplayItem": ["c6fd5997-9f6b-4888-8703-94e80e8cde3f"],
    "IDisplayMonitor": ["1f6b15d4-1d01-4c51-87e2-6f954a772b59"],
    "IDisplayMonitor2": ["023018e6-cb23-5830-96df-a7bf6e602577"],
    "IDisplayMonitorStatics": ["6eae698f-a228-4c05-821d-b695d667de8e"],
    "IDisplayPathInterop": ["a6ba4205-e59e-4e71-b25b-4e436d21ee3d"],
    "IDisplayPinAssociationResponse": ["25e8275b-fa36-4097-b189-cb7228d80b4d"],
    "IDisplayRegion": ["db50c3a2-4094-5f47-8cb1-ea01ddafaa94"],
    "IDisplayRequest": ["e5732044-f49f-4b60-8dd4-5e7e3a632ac0"],
    "IDisplayServices2": ["a39531fe-a534-4a08-8b9f-a356097beedd"],
    "IDisplayTreeDumper": ["30510415-98b5-11cf-bb82-00aa00bdce0b"],
    "IDistantLight": ["318cfafc-5ce3-4b55-ab5d-07a00353ac99"],
    "IDistantLight2": ["dbcdaa1c-294b-48d7-b60e-76df64aa392b"],
    "IDllServerActivatableClassRegistration": ["c8aa04f6-66c6-46a3-8fe6-f56be7ddc091"],
    "IDmaChannel": ["22c6ac61-851b-11d0-9a7f-00aa0038acfe"],
    "IDmaChannelSlave": ["22c6ac62-851b-11d0-9a7f-00aa0038acfe"],
    "IDnssdRegistrationResult": ["3d786ad2-e606-5350-73ea-7e97f066162f"],
    "IDnssdServiceInstance": ["e246db7e-98a5-4ca1-b9e4-c253d33c35ff"],
    "IDnssdServiceInstanceFactory": ["6cb061a1-c478-4331-9684-4af2186c0a2b"],
    "IDnssdServiceWatcher": ["cc34d9c1-db7d-4b69-983d-c6f83f205682"],
    "IDoNothingUsefulAtAll": ["c55bc3fd-a465-cbe4-5d7a-5199030da400"],
    "IDocHostObject": ["67431840-c511-11cf-89a9-00a0c9054129"],
    "IDocHostUIAppProtocol": ["f0895e2e-8929-43d0-b2cb-386aeb0c5dbe"],
    "IDocHostUIControlPriv": ["bf9d04bf-dbad-40ef-b1a1-e4cc38fa8995"],
    "IDocHostUIHandlerPriv": ["f0d241d1-5d0e-4e85-bcb4-fad7f7c5528c"],
    "IDocNavigate": ["131a6950-7f78-11d0-a979-00c04fd705a2"],
    "IDocObjectService": ["3050f801-98b5-11cf-bb82-00aa00bdce0b"],
    "IDocObjectStatus": ["fbece6c9-48d7-4a37-8fe3-6ad4272fddac"],
    "IDocWrap": ["dcd285fe-0be0-43bd-99c9-aaaec513c555"],
    "IDocfileAsyncConnectionPoint": ["4a8df970-8d9a-11cf-8827-00aa00b569f5"],
    "IDockPatternIdentifiers": ["ccd7f4e6-e4f9-47ff-bde7-378b11f78e09"],
    "IDockPatternIdentifiersStatics": ["2b87245c-ed80-4fe5-8eb4-708a39c841e5"],
    "IDockProvider": ["159bc72c-4ad3-485e-9637-d7052edf0146", "48c243f8-78b1-44a0-ac5f-750757bcde3c"],
    "IDocumentEvent": ["305104bc-98b5-11cf-bb82-00aa00bdce0b"],
    "IDocumentProperties": ["482d7eaf-45f5-4ccd-b707-7bea5967d1d5", "7eab19bc-1821-4923-b4a9-0aea404d0070"],
    "IDocumentRange": ["305104af-98b5-11cf-bb82-00aa00bdce0b"],
    "IDocumentSelector": ["30510462-98b5-11cf-bb82-00aa00bdce0b"],
    "IDocumentSite": ["94a0f6f1-10bc-11d0-8d09-00a0c90f2732"],
    "IDocumentSite2": ["61d4a8a1-2c90-11d2-ade4-00c04f98f417"],
    "IDocumentSuggestedSitesPriv": ["df464bcd-318b-46eb-9162-adde9c786f32"],
    "IDocumentTraversal": ["30510744-98b5-11cf-bb82-00aa00bdce0b"],
    "IDontSupportEventSubscription": ["784121f1-62a6-4b89-855f-d65f296de83a"],
    "IDot11AdHocInterface": ["8f10cc2b-cf0d-42a0-acbe-e2de7007384d"],
    "IDot11AdHocInterfaceNotificationSink": ["8f10cc2f-cf0d-42a0-acbe-e2de7007384d"],
    "IDot11AdHocManager": ["8f10cc26-cf0d-42a0-acbe-e2de7007384d"],
    "IDot11AdHocManagerNotificationSink": ["8f10cc27-cf0d-42a0-acbe-e2de7007384d"],
    "IDot11AdHocNetwork": ["8f10cc29-cf0d-42a0-acbe-e2de7007384d"],
    "IDot11AdHocNetworkNotificationSink": ["8f10cc2a-cf0d-42a0-acbe-e2de7007384d"],
    "IDot11AdHocSecuritySettings": ["8f10cc2e-cf0d-42a0-acbe-e2de7007384d"],
    "IDoubleAnimation": ["7e9f3d59-0f07-4bc9-977d-03763ff8154f"],
    "IDoubleAnimationStatics": ["e27a935d-f111-43b7-b824-832b58d7786b"],
    "IDoubleAnimationUsingKeyFrames": ["4fee628f-bfee-4f75-83c2-a93b39488473"],
    "IDoubleAnimationUsingKeyFramesStatics": ["109bf2f6-c60f-49aa-abf6-f696d492116b"],
    "IDoubleKeyFrame": ["674456fd-e81e-4f4e-b4ad-0acfed9ecd68"],
    "IDoubleKeyFrameFactory": ["ac97dec3-7538-40b9-b152-696f7fbf4722"],
    "IDoubleKeyFrameStatics": ["324641b0-7d37-427a-adeb-43f38bb61a4d"],
    "IDoubleTappedEventHandler": ["3124d025-04a7-4d45-825e-8204a624dbf4"],
    "IDoubleTappedRoutedEventArgs": ["af404424-26df-44f4-8714-9359249b62d3"],
    "IDownloadBar": ["3edcb28e-e026-4d7b-bf1b-4c200268fd3b"],
    "IDownloadBroadcaster": ["e0a3dcc6-bb71-4a76-bd8e-f24b9d9a48c0"],
    "IDownloadCallback": ["9329e39d-0445-4cbf-a14f-f1df49a57e76"],
    "IDownloadCompletedCallback": ["77254866-9f5b-4c8e-b9e2-c77a8530d64b"],
    "IDownloadCompletedCallbackArgs": ["fa565b23-498c-47a0-979d-e7d5b1813360"],
    "IDownloadCounterProvider": ["33973ac4-dbf2-4d1c-9468-a282a9146c0b"],
    "IDownloadExecutionBroker": ["58062ea0-b932-4785-8239-84eea4914482"],
    "IDownloadExecutionOptions": ["0d574e62-2784-49d0-804d-361f804caa1d"],
    "IDownloadHistoryDatabase": ["8a445657-f50d-11e0-9240-18a905c16311"],
    "IDownloadHistoryEnum": ["86445657-f50d-11e0-9240-18a905c16311"],
    "IDownloadInitiatorProvider": ["7c733a3d-f21f-41fc-8a61-032659d720d1"],
    "IDownloadJob": ["c574de85-7358-43f6-aae8-8697e62d8ba7"],
    "IDownloadLaunch": ["a11e36f5-d54c-4cad-bef1-c2ddae7be6a3"],
    "IDownloadListener": ["5b2ae522-f16f-40ce-a7ca-ff6d78aea699"],
    "IDownloadModeHandleCallback": ["8f0f47d6-abbe-4489-b124-ca0cee8ec202"],
    "IDownloadNotificationStack": ["48b8014a-9bf5-42ad-9bed-eeeee9514d21"],
    "IDownloadOperation": ["bd87ebb0-5714-4e09-ba68-bef73903b0d7"],
    "IDownloadOperation2": ["a3cced40-8f9c-4353-9cd4-290dee387c38"],
    "IDownloadOperation3": ["5027351c-7d5e-4adc-b8d3-df5c6031b9cc"],
    "IDownloadOperation4": ["0cdaaef4-8cef-404a-966d-f058400bed80"],
    "IDownloadOperation5": ["a699a86f-5590-463a-b8d6-1e491a2760a5"],
    "IDownloadPrivacy": ["04b0d606-b925-44f8-8a6c-fe2a4b0f32b9"],
    "IDownloadProgress": ["d31a5bac-f719-4178-9dbb-5e2cb47fd18a"],
    "IDownloadProgressChangedCallback": ["8c3f1cdd-6173-4591-aebd-a56a53ca77c1"],
    "IDownloadProgressChangedCallbackArgs": ["324ff2c6-4981-4b04-9412-57481745ab24"],
    "IDownloadProgressEventArgs": ["7311e0d4-fe94-4e70-9b90-cdd47ac23afb"],
    "IDownloadProgressEventHandler": ["1abaee23-74ee-4cc7-99ba-b171e3cda61e"],
    "IDownloadRateCalculator": ["fd6237bf-0c1e-4a4f-9963-30409b3bad80"],
    "IDownloadResult": ["daa4fdd0-4727-4dbe-a1e7-745dca317144"],
    "IDownloadSecurity": ["b5d1318c-89ba-4166-af8b-76b0df8e7d46"],
    "IDownloadUIManager": ["ccfb755f-13b4-4d15-84c7-92d241425a5c"],
    "IDownloadWindow": ["84650f00-1345-4045-9aa4-44df59f5eba9"],
    "IDownloadWindowContainer": ["e6129efb-a4e2-4504-a5a0-865d751ab37a"],
    "IDownloadsFolderStatics": ["27862ed0-404e-47df-a1e2-e37308be7b37"],
    "IDownloadsFolderStatics2": ["e93045bd-8ef8-4f8e-8d15-ac0e265f390d"],
    "IDpxContainer": ["ddc1b712-0e55-452f-838e-d1505b866e2b"],
    "IDpxContainer2": ["c8e1e004-3a8d-45c7-a6aa-8c8f2f2ed1e1"],
    "IDpxContainer3": ["582f768c-fe7d-4bf5-b0b8-3ab01d53b0d0"],
    "IDpxContainerDirectoryEntry": ["ddc1b715-0e55-452f-838e-d1505b866e2b"],
    "IDpxDownloadCallback": ["ddc1b717-0e55-452f-838e-d1505b866e2b"],
    "IDpxDownloadProvider": ["ddc1b716-0e55-452f-838e-d1505b866e2b"],
    "IDpxEncryptedContainer": ["ddc1b726-0e55-452f-838e-d1505b866e2b"],
    "IDpxFile": ["ddc1b713-0e55-452f-838e-d1505b866e2b"],
    "IDpxFile2": ["c249cc11-c1f5-428e-acbf-e1b78b30b971"],
    "IDpxJob": ["ddc1b711-0e55-452f-838e-d1505b866e2b"],
    "IDpxJob2": ["e1c292c8-919a-4f1b-b85a-9c542932fc8d"],
    "IDragCompletedEventArgs": ["b04f29a1-bd16-48f6-a511-9c2763641331"],
    "IDragCompletedEventArgsFactory": ["36a7d99d-148c-495f-a0fc-afc871d62f33"],
    "IDragCompletedEventHandler": ["36b28888-19ac-4b4e-9137-a6cf2b023883"],
    "IDragDeltaEventArgs": ["2c2dd73c-2806-49fc-aae9-6d792b572b6a"],
    "IDragDeltaEventArgsFactory": ["46e7a1ef-ae15-44a6-8a04-95b0bf9ab876"],
    "IDragDeltaEventHandler": ["4ac24f9f-ac28-49e9-9189-dccffeb66472"],
    "IDragDropArgsPriv": ["079f88f0-6801-479c-9129-40d02c7b1d42"],
    "IDragDropBroker": ["ff87c9a7-7870-4152-8bb6-743a05cede09"],
    "IDragDropHelper": ["0000012d-0000-0000-c000-000000000046"],
    "IDragDropManagerInterop": ["5ad8cba7-4c01-4dac-9074-827894292d63"],
    "IDragDropViewCreationHandler": ["800d4c3a-a217-4177-b228-04cfef8c1dc3"],
    "IDragEventArgs": ["b440c7c3-02b4-4980-9342-25dae1c0f188"],
    "IDragEventArgs2": ["26336658-2917-411d-bfc3-2f22471cbbe7"],
    "IDragEventArgs3": ["d04fc3c6-8119-427a-8152-5f9550cc0416"],
    "IDragEventHandler": ["2ab1a205-1e73-4bcf-aabc-57b97e21961d"],
    "IDragItemThemeAnimation": ["0c7d5db5-7ed6-4949-b4e6-a78c9f4f978d"],
    "IDragItemThemeAnimationStatics": ["6218b9f5-013a-4fb1-86fc-92bc4e8d0241"],
    "IDragItemsCompletedEventArgs": ["af05f22f-9e78-4b21-9a8e-41c2d1367a2a"],
    "IDragItemsStartingEventArgs": ["71cf215c-daed-4783-aa11-dc574d2713e9"],
    "IDragItemsStartingEventHandler": ["3aaeab4c-14cb-4434-becc-88a8585c2f89"],
    "IDragOperationDeferral": ["ba73ecba-1b73-4086-b3d3-c223beea1633"],
    "IDragOperationPriv": ["3d678ff8-6adf-4aad-ba71-117cf9baa0ae"],
    "IDragOverThemeAnimation": ["72f762f7-7e51-4a6b-b937-dc4b4c1c5458"],
    "IDragOverThemeAnimationStatics": ["146ffe57-3c9d-41d9-a5ff-8d7239516810"],
    "IDragPatternIdentifiers": ["6266e985-4d07-4e80-82eb-8f96690a1a0c"],
    "IDragPatternIdentifiersStatics": ["2a05379d-1755-4082-9d90-46f1411d7986"],
    "IDragProvider": ["2e7786a9-7ffc-4f57-b965-1ef1f373f546", "6aa7bbbb-7ff9-497d-904f-d20b897929d8"],
    "IDragSourceHelper2": ["83e07d0d-0c5f-4163-bf1a-60b274051e40"],
    "IDragStartedEventArgs": ["9f915dd0-a124-4366-bd85-2408214aeed4"],
    "IDragStartedEventArgsFactory": ["5eefe579-c706-4781-a308-c9e7f4c6a1d7"],
    "IDragStartedEventHandler": ["d2eea48a-c65a-495d-a2f1-72c66989142d"],
    "IDragStartingEventArgs": ["6800d3fa-90b8-46f9-8e30-5ac25f73f0f9"],
    "IDragStartingEventArgs2": ["d855e08e-44b6-4211-bd0b-7fddbb6e8231"],
    "IDragUI": ["2d9bd838-7c60-4842-9170-346fe10a226a"],
    "IDragUIContentProviderPriv": ["3d7e959f-4290-45be-905e-b452996dc701"],
    "IDragUIOverride": ["bd6c9dfa-c961-4861-b7a5-bf4fe4a8a6ef"],
    "IDragUIOverridePriv": ["3058ba43-74d3-4f1d-b251-5dea99b75f57"],
    "IDragViewEventHandler": ["cdc15432-c344-4d81-a416-b5fdeec8cb04"],
    "IDragViewTracker": ["d14b56bb-6137-487c-9b58-2ca634c0a99a"],
    "IDraggingEventArgs": ["1c905384-083c-4bd3-b559-179cddeb33ec"],
    "IDraggingEventArgs2": ["71efdbf9-382a-55ca-b4b9-008123c1bf1a"],
    "IDrawVideoImage": ["48efb120-ab49-11d2-aed2-00a0c995e8d5"],
    "IDrillInNavigationTransitionInfo": ["3b86201a-45d3-463b-939e-c8595f439bcc"],
    "IDrillInThemeAnimation": ["b090b824-f1d2-41b8-87ba-78034126594c"],
    "IDrillInThemeAnimationStatics": ["c61fe488-a17a-4b11-b53b-a4f1a07d4ba9"],
    "IDrillOutThemeAnimation": ["d890ccdf-06d3-4f7e-8e4a-4fb76e256139"],
    "IDrillOutThemeAnimationStatics": ["beb5db9b-2617-4888-80dd-72fa7bb6fac3"],
    "IDriveFolderExt": ["3ec36f3e-5ba3-4c3d-bf39-10f76c3f7cc6"],
    "IDriverConfigModule": ["61487bd7-94b5-4e4b-8dda-a555a2b77bc1"],
    "IDriverEntry": ["1bec7499-8881-4f2b-b01c-a1a907304afc"],
    "IDrmAudioStream": ["1915c967-3299-48cb-a3e4-69fd1d1b306e"],
    "IDrmPort": ["286d3df8-ca22-4e2e-b9bc-20b4f0e201ce"],
    "IDrmPort2": ["1acce59c-7311-4b6b-9fba-cc3ba59acdce"],
    "IDropCompletedEventArgs": ["6c4fc188-95bc-4261-9ec5-21cab677b734"],
    "IDropController": ["b55e4d76-2743-4b4e-af8d-18817545de74"],
    "IDropDirectory": ["cd000024-8b95-11d1-82db-00c04fb1625d"],
    "IDropDownButton": ["671f74e6-2a27-5fa8-b0a2-79b2e71ebd87"],
    "IDropDownButtonAutomationPeer": ["72f294f1-bff6-5d07-9db4-54134506bc80"],
    "IDropDownButtonAutomationPeerFactory": ["b8c449b2-6354-5c0c-9e95-e0c99a293a44"],
    "IDropDownButtonFactory": ["0d9f8ab5-e70d-52bd-9ca0-36ceecaa642a"],
    "IDropOperationTargetPriv": ["e86f28a0-42a8-43c7-af4a-ba1d3cc77cc4"],
    "IDropShadow": ["cb977c07-a154-4851-85e7-a8924c84fad8"],
    "IDropShadow2": ["6c4218bc-15b9-4c2d-8d4a-0767df11977a"],
    "IDropSourceMarshallable": ["e8e8d427-ef1b-4491-8e0d-3bae38974c3e"],
    "IDropSourceNotify": ["0000012b-0000-0000-c000-000000000046"],
    "IDropTargetFactory": ["504c9f82-0f68-47f4-8f63-083e58c88412"],
    "IDropTargetHwnd": ["0f8ebe91-5169-4306-b495-09f55d460333"],
    "IDropTargetItemThemeAnimation": ["1881c968-1824-462b-87e8-c357212b977b"],
    "IDropTargetItemThemeAnimationStatics": ["ae80f486-2e56-4513-bf18-d77470164ae5"],
    "IDropTargetPatternIdentifiers": ["11865133-a6fe-4634-bd18-0ef612b7b208"],
    "IDropTargetPatternIdentifiersStatics": ["1b693304-89fb-4b0a-9452-ca2c66aaf9f3"],
    "IDropTargetProvider": ["7a245bdd-b458-4fe0-98c8-aac89df56d61", "bae82bfd-358a-481c-85a0-d8b4d90a5d61"],
    "IDropTargetProviderPriv": ["dadef92c-227e-46c0-93c0-9fffa4dc07d9"],
    "IDropTargetWithDADSupport": ["b0061660-b231-11d2-963e-00c04f79adf0"],
    "IDsAdminCreateObj": ["53554a38-f902-11d2-82b9-00c04f68928b"],
    "IDsAdminNewObj": ["f2573587-e6fc-11d2-82af-00c04f68928b"],
    "IDsAdminNewObjExt": ["6088eae2-e7bf-11d2-82af-00c04f68928b"],
    "IDsAdminNewObjPrimarySite": ["be2b487e-f904-11d2-82b9-00c04f68928b"],
    "IDsAdminNotifyHandler": ["e4a2b8b3-5a18-11d2-97c1-00a0c9a06d2d"],
    "IDsDisplaySpecifier": ["1ab4a8c0-6a0b-11d2-ad49-00c04fa31a86"],
    "IDsObjectPicker": ["0c87e64e-3b7a-11d2-b9e0-00c04fd8dbf7"],
    "IDsPrinterProperties": ["8a58bc16-410e-11d1-a9c2-080036af3f03"],
    "IDtcLuConfigure": ["4131e760-1aea-11d0-944b-00a0c905416e"],
    "IDtcLuRecovery": ["ac2b8ad2-d6f0-11d0-b386-00a0c9083365"],
    "IDtcLuRecoveryFactory": ["4131e762-1aea-11d0-944b-00a0c905416e"],
    "IDtcLuRecoveryInitiatedByDtc": ["4131e764-1aea-11d0-944b-00a0c905416e"],
    "IDtcLuRecoveryInitiatedByDtcStatusWork": ["4131e766-1aea-11d0-944b-00a0c905416e"],
    "IDtcLuRecoveryInitiatedByDtcTransWork": ["4131e765-1aea-11d0-944b-00a0c905416e"],
    "IDtcLuRecoveryInitiatedByLu": ["4131e768-1aea-11d0-944b-00a0c905416e"],
    "IDtcLuRecoveryInitiatedByLuWork": ["ac2b8ad1-d6f0-11d0-b386-00a0c9083365"],
    "IDtcLuRmEnlistment": ["4131e769-1aea-11d0-944b-00a0c905416e"],
    "IDtcLuRmEnlistmentFactory": ["4131e771-1aea-11d0-944b-00a0c905416e"],
    "IDtcLuRmEnlistmentSink": ["4131e770-1aea-11d0-944b-00a0c905416e"],
    "IDtcLuSubordinateDtc": ["4131e773-1aea-11d0-944b-00a0c905416e"],
    "IDtcLuSubordinateDtcFactory": ["4131e775-1aea-11d0-944b-00a0c905416e"],
    "IDtcLuSubordinateDtcSink": ["4131e774-1aea-11d0-944b-00a0c905416e"],
    "IDtcNetworkAccessConfig": ["9797c15d-a428-4291-87b6-0995031a678d"],
    "IDtcNetworkAccessConfig2": ["a7aa013b-eb7d-4f42-b41c-b2dec09ae034"],
    "IDtcNetworkAccessConfig3": ["76e4b4f3-2ca5-466b-89d5-fd218ee75b49"],
    "IDtcToXaHelper": ["a9861611-304a-11d1-9813-00a0c905416e", "adefc46b-cb1d-11d0-b135-00c04fc2f3ef"],
    "IDtcToXaHelperFactory": ["a9861610-304a-11d1-9813-00a0c905416e", "adefc46a-cb1d-11d0-b135-00c04fc2f3ef"],
    "IDtcToXaHelperSinglePipe": ["47ed4971-53b3-11d1-bbb9-00c04fd658f6"],
    "IDtcToXaMapper": ["64ffabe0-7ce9-11d0-8ce6-00c04fdc877e"],
    "IDtdEntity": ["6a0b5ffc-63b4-480f-9e6a-8a92816aade4"],
    "IDtdNotation": ["8cb4e04d-6d46-4edb-ab73-df83c51ad397"],
    "IDualSimTile": ["143ab213-d05f-4041-a18c-3e3fcb75b41e"],
    "IDualSimTileStatics": ["50567c9e-c58f-4dc9-b6e8-fa6777eeeb37"],
    "IDummyMBNUCMExt": ["dcbbbab6-ffff-4bbb-aaee-338e368af6fa"],
    "IDuplicateHandleProvider": ["fa9812c4-0b34-47d0-9b0b-157fb5b5fdf2"],
    "IDurationHelper": ["25c1659f-4497-4135-940f-ee96f4d6e934"],
    "IDurationHelperStatics": ["bc88093e-3547-4ec0-b519-ffa8f9c4838c"],
    "IDvbCableDeliverySystemDescriptor": ["dfb98e36-9e1a-4862-9946-993a4e59017b"],
    "IDvbComponentDescriptor": ["91e405cf-80e7-457f-9096-1b9d1ce32141"],
    "IDvbContentDescriptor": ["2e883881-a467-412a-9d63-6f2b6da05bf0"],
    "IDvbContentIdentifierDescriptor": ["05e0c1ea-f661-4053-9fbf-d93b28359838"],
    "IDvbDataBroadcastDescriptor": ["d1ebc1d6-8b60-4c20-9caf-e59382e7c400"],
    "IDvbDataBroadcastIDDescriptor": ["5f26f518-65c8-4048-91f2-9290f59f7b90"],
    "IDvbDefaultAuthorityDescriptor": ["05ec24d1-3a31-44e7-b408-67c60a352276"],
    "IDvbExtendedEventDescriptor": ["c9b22eca-85f4-499f-b1db-efa93a91ee57"],
    "IDvbFrequencyListDescriptor": ["1cadb613-e1dd-4512-afa8-bb7a007ef8b1"],
    "IDvbHDSimulcastLogicalChannelDescriptor": ["1ea8b738-a307-4680-9e26-d0a908c824f4"],
    "IDvbLinkageDescriptor": ["1cdf8b31-994a-46fc-acfd-6a6be8934dd5"],
    "IDvbLogicalChannel2Descriptor": ["f69c3747-8a30-4980-998c-01fe7f0ba35a"],
    "IDvbLogicalChannelDescriptor": ["cf1edaff-3ffd-4cf7-8201-35756acbf85f"],
    "IDvbLogicalChannelDescriptor2": ["43aca974-4be8-4b98-bc17-9eafd788b1d7"],
    "IDvbMultilingualServiceNameDescriptor": ["2d80433b-b32c-47ef-987f-e78ebb773e34"],
    "IDvbNetworkNameDescriptor": ["5b2a80cf-35b9-446c-b3e4-048b761dbc51"],
    "IDvbParentalRatingDescriptor": ["3ad9dde1-fb1b-4186-937f-22e6b5a72a10"],
    "IDvbPrivateDataSpecifierDescriptor": ["5660a019-e75a-4b82-9b4c-ed2256d165a2"],
    "IDvbSatelliteDeliverySystemDescriptor": ["02f2225a-805b-4ec5-a9a6-f9b5913cd470"],
    "IDvbServiceAttributeDescriptor": ["0f37bd92-d6a1-4854-b950-3a969d27f30e"],
    "IDvbServiceDescriptor": ["f9c7fbcf-e2d6-464d-b32d-2ef526e49290"],
    "IDvbServiceDescriptor2": ["d6c76506-85ab-487c-9b2b-36416511e4a2"],
    "IDvbServiceListDescriptor": ["05db0d8f-6008-491a-acd3-7090952707d0"],
    "IDvbShortEventDescriptor": ["b170be92-5b75-458e-9c6e-b0008231491a"],
    "IDvbSiParser": ["b758a7bd-14dc-449d-b828-35909acb3b1e"],
    "IDvbSiParser2": ["0ac5525f-f816-42f4-93ba-4c0f32f46e54"],
    "IDvbSubtitlingDescriptor": ["9b25fe1d-fa23-4e50-9784-6df8b26f8a49"],
    "IDvbTeletextDescriptor": ["9cd29d47-69c6-4f92-98a9-210af1b7303a"],
    "IDvbTerrestrial2DeliverySystemDescriptor": ["20ee9be9-cd57-49ab-8f6e-1d07aeb8e482"],
    "IDvbTerrestrialDeliverySystemDescriptor": ["ed7e1b91-d12e-420c-b41d-a49d84fe1823"],
    "IDvdCmd": ["5a4a97e4-94ee-4a55-9751-74b5643aa27d"],
    "IDvdControl2": ["33bc7430-eec0-11d2-8201-00a0c9d74842"],
    "IDvdInfo2": ["34151510-eec0-11d2-8201-00a0c9d74842"],
    "IDvdState": ["86303d6d-1c4a-4087-ab42-f711167048ef"],
    "IDwnBindInfo": ["3050f3c3-98b5-11cf-bb82-00aa00bdce0b"],
    "IDxtAlphaSetter": ["4ee9ead9-da4d-43d0-9383-06b90c08b12b"],
    "IDxtCompositor": ["bb44391e-6abd-422f-9e2e-385c9dff51fc"],
    "IDxtJpeg": ["de75d011-7a65-11d2-8cea-00a0c9441e20"],
    "IDxtKey": ["3255de56-38fb-4901-b980-94b438010d7b"],
    "IDynamicConceptProviderConcept": ["95a7f7dd-602e-483f-9d06-a15c0ee13174"],
    "IDynamicHWHandler": ["dc2601d7-059e-42fc-a09d-2afd21b6d5f7"],
    "IDynamicKeyProviderConcept": ["e7983fa1-80a7-498c-988f-518ddc5d4025"],
    "IDynamicOverflowItemsChangingEventArgs": ["c93c736f-6f6e-4e43-90d9-9b46a0d88b9f"],
    "IDynamicRenderer": ["a079468e-7165-46f9-b7af-98ad01a93009"],
    "IDynamicStorage": ["52bbc746-9f9c-44b4-8d7c-0aaab79bc7dc"],
    "IEAPProviderConfig": ["66a2db19-d706-11d0-a37b-00c04fc9da04"],
    "IEAPProviderConfig2": ["d565917a-85c4-4466-856e-671c3742ea9a"],
    "IEAPProviderConfig3": ["b78ecd12-68bb-4f86-9bf0-8438dd3be982"],
    "IEAxInstallBrokerBroker": ["b2103bdb-b79e-4474-8424-4363161118d5"],
    "IEBrokerAttach": ["7673b35e-907a-449d-a49f-e5ce47f0b0b2"],
    "IEBrokerObjectCleanup": ["2e564fef-5bb0-4d9e-b169-b40a5117715a"],
    "IEBrokerRegisterObjectCleanup": ["c40b45c3-1518-46fb-a0f0-0c056174d555"],
    "IEContentAdvisorBroker": ["c456f893-35ed-0eb4-56f9-3e139ebe5f47"],
    "IEDPNotificationHost": ["d46fa868-2e4e-4a72-a424-ffa395eadf33"],
    "IEDPNotificationHostBroker": ["079ca8fc-5ac1-4418-b72e-eedac3978341"],
    "IEDataObjectInternal": ["196bab51-2c67-485a-a74f-557182263013"],
    "IEDataObjectWrapper": ["64eeb363-190e-428f-a801-f63615e988b1"],
    "IEDropSourceWrapper": ["c74aff92-5b45-477b-8630-61d5cbed416a"],
    "IEDropSourceWrapperInternal": ["9c627e44-7a53-4938-91c6-f60f3ecbea94"],
    "IEEAssemblyRef": ["aad20a0e-9cd9-40ab-91b9-3c1943562c84"],
    "IEEAssemblyRefResolveComparer": ["6f1a544c-e69e-4a52-9ea1-25c897b05bef"],
    "IEEDataStorage": ["dcf1f227-ec51-4680-8722-c8796a5f3483"],
    "IEEHelperObject": ["4a3bcde5-5f66-4cc8-9fa0-14275ccee688"],
    "IEEHostServices": ["bb7be481-da8f-4b9e-89cb-0a8dde6bc5d7"],
    "IEELocalObject": ["44f8f85f-5514-49a3-8173-6f9c9f1c4832"],
    "IEEMemoryManager": ["17713b61-b59f-4e13-baaf-91623dc8adc0"],
    "IEEVisualizerDataProvider": ["27ed701a-fa26-406e-ae71-00011b5ae396"],
    "IEEVisualizerService": ["82545b58-f203-4835-acd6-6d0997aa6f25"],
    "IEEVisualizerServiceProvider": ["a2f2c782-f929-4ffa-8699-88d4c4c07b17"],
    "IEFrameAuto": ["401062ac-2f9c-426e-91a2-4af5bead509f"],
    "IEInetcplRasBroker": ["7819a000-56f5-432f-bf43-662a11261696"],
    "IENCDebugInfo": ["1da15c39-7e02-4ee8-8f60-fff81275ee14"],
    "IENCSymbolReaderProvider": ["b69910a9-4ad6-475f-859a-5dc0b1072a5d"],
    "IERegHelperBroker": ["41dc24d8-6b81-41c4-832c-fe172cb3a582"],
    "IERegistryHKLMBroker": ["6cbef08d-65a6-446e-b291-255624568192"],
    "IESCloseMmiEvent": ["6b80e96f-55e2-45aa-b754-0c23c8e7d5c1"],
    "IESEvent": ["1f0e5357-af43-44e6-8547-654c645145d2"],
    "IESEventFactory": ["506a09b8-7f86-4e04-ac05-3303bfe8fc49"],
    "IESEventService": ["ed89a619-4c06-4b2f-99eb-c7669b13047c"],
    "IESEventServiceConfiguration": ["33b9daae-9309-491d-a051-bcad2a70cd66"],
    "IESEvents": ["abd414bf-cfe5-4e5e-af5b-4b4e49c5bfeb"],
    "IESFileExpiryDateEvent": ["ba9edcb6-4d36-4cfe-8c56-87a6b0ca48e1"],
    "IESIsdbCasResponseEvent": ["2017cb03-dc0f-4c24-83ca-36307b2cd19f"],
    "IESLicenseRenewalResultEvent": ["d5a48ef5-a81b-4df0-acaa-5e35e7ea45d4"],
    "IESOpenMmiEvent": ["ba4b6526-1a35-4635-8b56-3ec612746a8c"],
    "IESRequestTunerEvent": ["54c7a5e8-c3bb-4f51-af14-e0e2c0e34c6d"],
    "IESValueUpdatedEvent": ["8a24c46e-bb63-4664-8602-5d9c718c146d"],
    "IESim": ["6f6e6e26-f123-437d-8ced-dc1d2bc0c3a9"],
    "IESim2": ["bd4fd0a0-c68f-56eb-b99b-8f34b8100299"],
    "IESimAddedEventArgs": ["38bd0a58-4d5a-4d08-8da7-e73eff369ddd"],
    "IESimDiscoverEvent": ["e59ac3e3-39bc-5f6f-9321-0d4a182d261b"],
    "IESimDiscoverResult": ["56b4bb5e-ab2f-5ac6-b359-dd5a8e237926"],
    "IESimDownloadProfileMetadataResult": ["c4234d9e-5ad6-426d-8d00-4434f449afec"],
    "IESimManagerStatics": ["0bfa2c0c-df88-4631-bf04-c12e281b3962"],
    "IESimOperationResult": ["a67b63b1-309b-4e77-9e7e-cd93f1ddc7b9"],
    "IESimPolicy": ["41e1b99d-cf7e-4315-882b-6f1e74b0d38f"],
    "IESimProfile": ["ee1e7880-06a9-4027-b4f8-ddb23d7810e0"],
    "IESimProfileMetadata": ["ed25831f-90db-498d-a7b4-ebce807d3c23"],
    "IESimProfilePolicy": ["e6dd0f1d-9c5c-46c5-a289-a948999bf062"],
    "IESimRemovedEventArgs": ["dec5277b-2fd9-4ed9-8376-d9b5e41278a3"],
    "IESimServiceInfo": ["f16aabcf-7f59-4a51-8494-bd89d5ff50ee"],
    "IESimUpdatedEventArgs": ["4c125cec-508d-4b88-83cb-68bef8168d12"],
    "IESimWatcher": ["c1f84ceb-a28d-4fbf-9771-6e31b81ccf22"],
    "IETFilter": ["c4c4c4b1-0049-4e2b-98fb-9537f6ce516d"],
    "IETFilterConfig": ["c4c4c4d1-0049-4e2b-98fb-9537f6ce516d"],
    "IETFilterEvents": ["c4c4c4c1-0049-4e2b-98fb-9537f6ce516d"],
    "IEUserBroker": ["1ac7516e-e6bb-4a69-b63f-e841904dc5a6"],
    "IEVRFilterConfig": ["83e91e85-82c1-4ea7-801d-85dc50b75086"],
    "IEVRFilterConfigEx": ["aea36028-796d-454f-beee-b48071e24304"],
    "IEVRTrustedVideoPlugin": ["83a4ce40-7710-494b-a893-a472049af630"],
    "IEVRVideoStreamControl": ["d0cfe38b-93e7-4772-8957-0400c49a4485"],
    "IEasClientDeviceInformation": ["54dfd981-1968-4ca3-b958-e595d16505eb"],
    "IEasClientDeviceInformation2": ["ffb35923-bb26-4d6a-81bc-165aee0ad754"],
    "IEasClientSecurityPolicy": ["45b72362-dfba-4a9b-aced-6fe2adcb6420"],
    "IEasComplianceResults": ["463c299c-7f19-4c66-b403-cb45dd57a2b3"],
    "IEasComplianceResults2": ["2fbe60c9-1aa8-47f5-88bb-cb3ef0bffb15"],
    "IEasingColorKeyFrame": ["c733d630-f4b9-4934-9bdd-27ac5ed1cfd8"],
    "IEasingColorKeyFrameStatics": ["6f3837fc-8e3d-4522-9b0f-003db8609851"],
    "IEasingDoubleKeyFrame": ["965adb8d-9a54-4108-b4ff-b5a5212cb338"],
    "IEasingDoubleKeyFrameStatics": ["c8d3d845-dbae-4e5b-8b84-d9537398e5b1"],
    "IEasingFunctionBase": ["c108383f-2c02-4151-8ecd-68ddaa3f0d9b"],
    "IEasingFunctionBaseFactory": ["1830fe6a-f01b-43e0-b61f-b452a1c66fd2"],
    "IEasingFunctionBaseStatics": ["2a5031aa-2c50-4a1d-bb04-d75e07b71548"],
    "IEasingPointKeyFrame": ["b3c91380-6868-4225-a70b-3981cc0b2947"],
    "IEasingPointKeyFrameStatics": ["e22dbfc4-080c-402c-a6b5-f48d0a98116b"],
    "IEccCurveNamesStatics": ["b3ff930c-aeeb-409e-b7d4-9b95295aaecf"],
    "IEchoEffectDefinition": ["0e4d3faa-36b8-4c91-b9da-11f44a8a6610"],
    "IEchoEffectDefinitionFactory": ["0d4e2257-aaf2-4e86-a54c-fb79db8f6c12"],
    "IEdgeBrowserFrame": ["2689f454-ff74-47da-bdf5-397a257dddd9"],
    "IEdgeBrowserImageStoreEvents": ["cab0c4c4-5b58-4605-a101-69ba1fa96ae9"],
    "IEdgeBrowserStreamImageStore": ["d3440f35-9ed5-4103-8a34-d3ba5fdce92d"],
    "IEdgeBrowserTabComponentRemotable": ["d63f088e-bf2f-4b6c-9247-145d2cafdfad"],
    "IEdgeDataModelCB": ["32966928-6fc2-45ec-a8ac-1bc6fd428c83"],
    "IEdgeDispatchVerifyUntrusted": ["d1203147-ac90-44b4-ad8e-b0d91a4f494f"],
    "IEdgeDocNavigate": ["4cdf168a-6e3c-4004-93af-a3d5e3c8dcf9"],
    "IEdgeDownloadManager": ["846c235d-9f6d-4836-9fd0-cf5e167bcda5"],
    "IEdgeDownloadRateCalculator": ["687a3c9e-950a-490f-b706-872b5a95d701"],
    "IEdgeF12HostManagerProcessProvider": ["99961ad8-91b7-4dda-890e-69c92d68daac"],
    "IEdgeFrameHTMLWindowServices": ["0316ed71-3287-4e5b-99db-e6c9a5b8ade4"],
    "IEdgeGesture": ["580d5292-2ab1-49aa-a7f0-33bd3f8df9f1"],
    "IEdgeGestureEventArgs": ["44fa4a24-2d09-42e1-8b5e-368208796a4c"],
    "IEdgeGestureSource": ["faac0612-d697-44ca-a78e-2704f0ce6e9d"],
    "IEdgeGestureStatics": ["bc6a8519-18ee-4043-9839-4fc584d60a14"],
    "IEdgeImmersiveFrameworkInputPaneForwarder": ["5730e20b-3ed2-43e8-ae42-0e444f80b115"],
    "IEdgeLayer": ["70214387-f6ee-4258-85ce-058f03973386"],
    "IEdgeLayerCommandHandler": ["5083f441-f28c-41b2-8d92-d5a979a64ca9"],
    "IEdgeLayerDynamicStateEvents": ["5a39fa2c-96aa-4d11-860c-b354cd6fcff7"],
    "IEdgeLayerState": ["6dea5f64-a1b9-4a55-b795-16b81071924c"],
    "IEdgeLayerStateEvents": ["e2b00d43-51bf-4dd3-88c9-0f287f7b6140"],
    "IEdgeLayerStateProvider": ["24815532-89b7-4b2b-8fde-c11360a3cd94"],
    "IEdgeManagerBroker": ["26ea2529-1012-4dd2-8a8b-3d2de75d3529"],
    "IEdgeManagerBrowsingContextBroker": ["27deaf48-1129-4119-a9fe-737043d09835"],
    "IEdgeModalDialogService": ["36f19ccb-9f8d-453d-9763-4096452f431d"],
    "IEdgeNavigationTarget": ["3f3cc2bd-f4a4-4885-873b-fc0b3c85fbc9"],
    "IEdgeNewTabPageData": ["26971f15-02b9-4dae-a557-8b76afa58d03"],
    "IEdgeReadingModeExtractedContent": ["a2b687e3-e544-4588-8c14-074a7e269eef"],
    "IEdgeRecoveryDataClient": ["dbbf7661-2dda-4ba5-94cf-b67c6c691dc5"],
    "IEdgeRecoveryStore": ["e37a6272-136a-4e62-ac1c-b0817fa90512"],
    "IEdgeSecMgrCacheSeedTarget": ["cebc3bc2-7399-4c7b-a36b-279ff36e0d15"],
    "IEdgeTabBrowserService": ["42d770b2-a093-4bc5-b67f-a1faf560f8f1"],
    "IEdgeTabProtocolLaunch": ["8110d918-82d3-4106-a563-aa29a082bf42"],
    "IEdgeTabRecoveryData": ["069102a8-2d71-43ed-b16c-a19f62a174ba"],
    "IEdgeTabWindow": ["b7c1bea6-2ee2-4d40-ba95-e0cab6405008"],
    "IEdgeTabWindowEvents": ["664ca29d-42e1-4ffa-8edc-af2e8ff59551"],
    "IEdgeTabWindowManager": ["bc47c6e9-7dd7-4c49-aca6-daca4710e807"],
    "IEdgeTabWindowModalManager": ["ac6f1cd9-6942-4000-ae2a-1312ab283167"],
    "IEdgeThreadNeutralCallback": ["e5c2eefc-c0fd-44a0-9b79-dc8756cc87e0"],
    "IEdgeTravelEntry2": ["efff019e-0e50-4d66-ab2b-de5eee43d9f1"],
    "IEdgeTravelLogClientPriv": ["cade2f20-ba76-4e3d-9813-4cc286b9d303"],
    "IEdgeTravelLogClientWrapper": ["a2d6065a-23cd-45d9-8a32-39fd7ec931d5"],
    "IEdgeTravelLogRecoveryData": ["9c504ab5-86fb-4110-8a2b-3e1126b109a0"],
    "IEdgeTravelLogUI": ["3c14419c-5978-4037-9cfe-2c6c396417d0"],
    "IEdgeUIThemeTransition": ["5c86c19b-49d7-19ec-cf19-83a73c6de75e"],
    "IEdgeUIThemeTransitionStatics": ["16a2b13b-4705-302b-27c6-2aac92f645ac"],
    "IEdgeUiDeviceManager": ["b2d4644a-a026-4dde-81be-fb471fc419e8"],
    "IEdgeUiInvocationProvider": ["e42c54ae-af19-4a12-ad01-922a8663e61f"],
    "IEdgeUiManager": ["6e6c3c52-5a5e-4b4b-a0f8-7fe12621a93e"],
    "IEdgeWPCDownloadContext": ["2b45394f-79b0-44e0-93c4-82b06ad9d4c1"],
    "IEdgeWaitOnThreadsBeforeExit": ["903a9856-3dfa-4ae0-91ca-a12d85f10698"],
    "IEdgeWebBrowserPriv": ["c5f926b7-9eaa-41bd-be4a-a163d87c6e59"],
    "IEdgeWebBrowserPriv2": ["4f6ffd9c-9931-4b77-8e9f-98435d2ff223"],
    "IEdgeWebBrowserPriv3": ["8537ef7d-e7d5-4f92-b3a1-8e0f8f1baff9"],
    "IEdgeWebPageMetaInfo": ["15b0d6be-e159-4bf4-bd45-43daa8eedc96"],
    "IEditionUpgradeBroker": ["ff19cbcf-9455-4937-b872-6b7929a460af"],
    "IEditionUpgradeHelper": ["d3e9e342-5deb-43b6-849e-6913b85d503a"],
    "IEducationSettingsStatics": ["fc53f0ef-4d3e-4e13-9b23-505f4d091e92"],
    "IEffectivePermission": ["3853dc76-9f35-407c-88a1-d19344365fbc"],
    "IEffectivePermission2": ["941fabca-dd47-4fca-90bb-b0e10255f20d"],
    "IEffectiveViewportChangedEventArgs": ["55ee2e81-1c18-59ed-bd3d-c4ca8fa7d190"],
    "IElasticEase": ["ef5ba58c-b0b6-4a6c-9ca8-fb4233f12459"],
    "IElasticEaseStatics": ["a9f566ec-fe9c-4b2b-8e52-bb785d562185"],
    "IElementCompositionPreview": ["b6f1a676-cfe6-46ac-acf6-c4687bb65e60"],
    "IElementCompositionPreviewStatics": ["08c92b38-ec99-4c55-bc85-a1c180b27646"],
    "IElementCompositionPreviewStatics2": ["24148fbb-23d6-4f37-ba0c-0733e799722d"],
    "IElementCompositionPreviewStatics3": ["843bc4c3-c105-59fe-a3d1-373c1d3e6fbc"],
    "IElementFactory": ["17d2ad90-1370-55c8-80e1-78b49004a9e1"],
    "IElementFactoryGetArgs": ["fb508774-41a3-5829-9255-cf452d041df4"],
    "IElementFactoryGetArgsFactory": ["c3b6dae7-883b-5fd7-be80-2059d877e783"],
    "IElementFactoryRecycleArgs": ["86f16b14-37e8-5dd8-a90c-25d3710318b0"],
    "IElementFactoryRecycleArgsFactory": ["8d926509-ea0d-541b-8271-f9e9118f5e7c"],
    "IElementSelector": ["30510463-98b5-11cf-bb82-00aa00bdce0b"],
    "IElementSoundPlayer": ["387773a5-f036-460c-9b81-f3d6ea43f6f2"],
    "IElementSoundPlayerStatics": ["217a9004-981d-41c9-b152-ada911a4b13a"],
    "IElementSoundPlayerStatics2": ["f2505956-ed41-48d7-aae8-f2abcb444929"],
    "IElementSpy": ["318995d3-e706-4216-a6eb-560ff9e96a82"],
    "IElementTraversal": ["30510736-98b5-11cf-bb82-00aa00bdce0b"],
    "IElevatableDiscImageMount": ["3dca391f-7a6c-4240-af1c-fd209d7ec6e5"],
    "IElevatedCopyEngineCache": ["c57cc5a4-49a0-4c2c-9ce1-30e2cc589e52"],
    "IElevatedFactoryServer": ["804bd226-af47-4d71-b492-443a57610b08"],
    "IElevatedFactoryServerManager": ["36df1a3d-973d-4956-b55a-47de453e8103"],
    "IElevatedOperationEngineInfo": ["ae108cc3-7fb6-4b79-b46c-0bd2b9d4d10d"],
    "IEllipse": ["70e05ac4-d38d-4bab-831f-4a22ef52ac86"],
    "IEllipseGeometry": ["d4f61bba-4ea2-40d6-aa6c-8d38aa87651f"],
    "IEllipseGeometryStatics": ["1744db47-f635-4b16-aee6-e052a65defb2"],
    "IEmailAction": ["10f62c64-7e16-4314-a0c2-0c3683f99d40"],
    "IEmailAttachment": ["f353caf9-57c8-4adb-b992-60fceb584f54"],
    "IEmailAttachment2": ["225f1070-b0ff-4571-9d54-a706c48d55c6"],
    "IEmailAttachmentFactory": ["796eac46-ed56-4979-8708-abb8bc854b7d"],
    "IEmailAttachmentFactory2": ["23259435-51f9-427d-adcd-241023c8cfb7"],
    "IEmailConversation": ["da18c248-a0bc-4349-902d-90f66389f51b"],
    "IEmailConversationBatch": ["b8c1ab81-01c5-432a-9df1-fe85d98a279a"],
    "IEmailConversationReader": ["b4630f82-2875-44c8-9b8c-85beb3a3c653"],
    "IEmailDataProviderConnection": ["3b9c9dc7-37b2-4bf0-ae30-7b644a1c96e1"],
    "IEmailDataProviderTriggerDetails": ["8f3e4e50-341e-45f3-bba0-84a005e1319a"],
    "IEmailFolder": ["a24f7771-996c-4864-b1ba-ed1240e57d11"],
    "IEmailIrmInfo": ["90f52193-b1a0-4ebd-a6b6-ddca55606e0e"],
    "IEmailIrmInfoFactory": ["314bb18c-e3e6-4d7b-be8d-91a96311b01b"],
    "IEmailIrmTemplate": ["f327758d-546d-4bea-a963-54a38b2cc016"],
    "IEmailIrmTemplateFactory": ["3da31876-8738-4418-b9cb-471b936fe71e"],
    "IEmailItemCounts": ["5bd13321-fec8-4bab-83ba-0baf3c1f6cbd"],
    "IEmailMailbox": ["a8790649-cf5b-411b-80b1-4a6a1484ce25"],
    "IEmailMailbox2": ["14f8e404-6ca2-4ab2-9241-79cd7bf46346"],
    "IEmailMailbox3": ["3da5897b-458b-408a-8e37-ac8b05d8af56"],
    "IEmailMailbox4": ["5d1f301b-f222-48a7-b7b6-716356cd26a1"],
    "IEmailMailbox5": ["39967087-0092-49be-bd0e-5d4dc9d96d90"],
    "IEmailMailboxAction": ["ac9889fa-21fa-4927-9210-d410582fdf3e"],
    "IEmailMailboxAutoReply": ["e223254c-8ab4-485b-b31f-04d15476bd59"],
    "IEmailMailboxAutoReplySettings": ["a87a9fa8-0ac6-4b77-ba77-a6b99e9a27b8"],
    "IEmailMailboxCapabilities": ["eedec3a6-89db-4305-82c4-439e0a33da11"],
    "IEmailMailboxCapabilities2": ["69723ee4-2f21-4cbc-88ab-2e7602a4806b"],
    "IEmailMailboxCapabilities3": ["f690e944-56f2-45aa-872c-0ce9f3db0b5c"],
    "IEmailMailboxChange": ["61edf54b-11ef-400c-adde-8cde65c85e66"],
    "IEmailMailboxChangeReader": ["bdbd0ebb-c53d-4331-97be-be75a2146a75"],
    "IEmailMailboxChangeTracker": ["7ae48638-5166-42b7-8882-fd21c92bdd4b"],
    "IEmailMailboxChangedDeferral": ["779a74c1-97c5-4b54-b30d-306232623e6d"],
    "IEmailMailboxChangedEventArgs": ["3cfd5f6e-01d4-4e4a-a44c-b22dd42ec207"],
    "IEmailMailboxCreateFolderRequest": ["184d3775-c921-4c39-a309-e16c9f22b04b"],
    "IEmailMailboxCreateFolderRequestEventArgs": ["03e4c02c-241c-4ea9-a68f-ff20bc5afc85"],
    "IEmailMailboxCreateFolderResult": ["b228557f-2885-4998-b595-8a2d374ce950"],
    "IEmailMailboxDeleteFolderRequest": ["9469e88a-a931-4779-923d-09a3ea292e29"],
    "IEmailMailboxDeleteFolderRequestEventArgs": ["b4d32d06-2332-4678-8378-28b579336846"],
    "IEmailMailboxDownloadAttachmentRequest": ["0b1dbbb4-750c-48e1-bce4-8d589684ffbc"],
    "IEmailMailboxDownloadAttachmentRequestEventArgs": ["ccddc46d-ffa8-4877-9f9d-fed7bcaf4104"],
    "IEmailMailboxDownloadMessageRequest": ["497b4187-5b4d-4b23-816c-f3842beb753e"],
    "IEmailMailboxDownloadMessageRequestEventArgs": ["470409ad-d0a0-4a5b-bb2a-37621039c53e"],
    "IEmailMailboxEmptyFolderRequest": ["fe4b03ab-f86d-46d9-b4ce-bc8a6d9e9268"],
    "IEmailMailboxEmptyFolderRequestEventArgs": ["7183f484-985a-4ac0-b33f-ee0e2627a3c0"],
    "IEmailMailboxForwardMeetingRequest": ["616d6af1-70d4-4832-b869-b80542ae9be8"],
    "IEmailMailboxForwardMeetingRequestEventArgs": ["2bd8f33a-2974-4759-a5a5-58f44d3c0275"],
    "IEmailMailboxGetAutoReplySettingsRequest": ["9b380789-1e88-4e01-84cc-1386ad9a2c2f"],
    "IEmailMailboxGetAutoReplySettingsRequestEventArgs": ["d79f55c2-fd45-4004-8a91-9bacf38b7022"],
    "IEmailMailboxMoveFolderRequest": ["10ba2856-4a95-4068-91cc-67cc7acf454f"],
    "IEmailMailboxMoveFolderRequestEventArgs": ["38623020-14ba-4c88-8698-7239e3c8aaa7"],
    "IEmailMailboxPolicies": ["1f3345c5-1c3b-4dc7-b410-6373783e545d"],
    "IEmailMailboxPolicies2": ["bab58afb-a14b-497c-a8e2-55eac29cc4b5"],
    "IEmailMailboxPolicies3": ["bdd4a01f-4867-414a-81a2-803919c44191"],
    "IEmailMailboxProposeNewTimeForMeetingRequest": ["5aeff152-9799-4f9f-a399-ff07f3eef04e"],
    "IEmailMailboxProposeNewTimeForMeetingRequestEventArgs": ["fb480b98-33ad-4a67-8251-0f9c249b6a20"],
    "IEmailMailboxResolveRecipientsRequest": ["efa4cf70-7b39-4c9b-811e-41eaf43a332d"],
    "IEmailMailboxResolveRecipientsRequestEventArgs": ["260f9e02-b2cf-40f8-8c28-e3ed43b1e89a"],
    "IEmailMailboxServerSearchReadBatchRequest": ["090eebdf-5a96-41d3-8ad8-34912f9aa60e"],
    "IEmailMailboxServerSearchReadBatchRequestEventArgs": ["14101b4e-ed9e-45d1-ad7a-cc9b7f643ae2"],
    "IEmailMailboxSetAutoReplySettingsRequest": ["75a422d0-a88e-4e54-8dc7-c243186b774e"],
    "IEmailMailboxSetAutoReplySettingsRequestEventArgs": ["09da11ad-d7ca-4087-ac86-53fa67f76246"],
    "IEmailMailboxSyncManager": ["517ac55a-3591-4b5d-85bc-c71dde862263"],
    "IEmailMailboxSyncManager2": ["cd8dc97e-95c1-4f89-81b7-e6aecb6695fc"],
    "IEmailMailboxSyncManagerSyncRequest": ["4e10e8e4-7e67-405a-b673-dc60c91090fc"],
    "IEmailMailboxSyncManagerSyncRequestEventArgs": ["439a031a-8fcc-4ae5-b9b5-d434e0a65aa8"],
    "IEmailMailboxUpdateMeetingResponseRequest": ["5b99ac93-b2cf-4888-ba4f-306b6b66df30"],
    "IEmailMailboxUpdateMeetingResponseRequestEventArgs": ["6898d761-56c9-4f17-be31-66fda94ba159"],
    "IEmailMailboxValidateCertificatesRequest": ["a94d3931-e11a-4f97-b81a-187a70a8f41a"],
    "IEmailMailboxValidateCertificatesRequestEventArgs": ["2583bf17-02ff-49fe-a73c-03f37566c691"],
    "IEmailManagerForUser": ["f773de9f-3ca5-4b0f-90c1-156e40174ce5"],
    "IEmailManagerStatics": ["f5128654-55c5-4890-a824-216c2618ce7f"],
    "IEmailManagerStatics2": ["ac052da3-b194-425d-b6d9-d0f04135eda2"],
    "IEmailManagerStatics3": ["4a722395-843e-4945-b3aa-349e07a362c5"],
    "IEmailMeetingInfo": ["31c03fa9-7933-415f-a275-d165ba07026b"],
    "IEmailMeetingInfo2": ["7e59386d-b0d9-4fe5-867c-e31ed2b588b8"],
    "IEmailMessage": ["6c6d948d-80b5-48f8-b0b1-e04e430f44e5"],
    "IEmailMessage2": ["fdc8248b-9f1a-44db-bd3c-65c384770f86"],
    "IEmailMessage3": ["a1ea675c-e598-4d29-a018-fc7b7eece0a1"],
    "IEmailMessage4": ["317cf181-3e7f-4a05-8394-3e10336dd435"],
    "IEmailMessageBatch": ["605cd08f-25d9-4f1b-9e51-0514c0149653"],
    "IEmailMessageReader": ["2f4abe9f-6213-4a85-a3b0-f92d1a839d19"],
    "IEmailQueryOptions": ["45504b9b-3e7f-4d52-b6dd-d6fd4e1fbd9a"],
    "IEmailQueryOptionsFactory": ["88f1a1b8-78ab-4ee8-b4e3-046d6e2fe5e2"],
    "IEmailQueryTextSearch": ["9fa0a288-3c5d-46a5-a6e2-31d6fd17e540"],
    "IEmailRecipient": ["cae825b3-4478-4814-b900-c902b5e19b53"],
    "IEmailRecipientFactory": ["5500b84d-c79a-4ef8-b909-722e18e3935d"],
    "IEmailRecipientResolutionResult": ["918338fa-8d8d-4573-80d1-07172a34b98d"],
    "IEmailRecipientResolutionResult2": ["5e420bb6-ce5b-4bde-b9d4-e16da0b09fca"],
    "IEmailStore": ["f803226e-9137-4f8b-a470-279ac3058eb6"],
    "IEmailStoreNotificationTrigger": ["986d06da-47eb-4268-a4f2-f3f77188388a"],
    "IEmailStoreNotificationTriggerDetails": ["ce17563c-46e6-43c9-96f7-facf7dd710cb"],
    "IEmbeddedAudioTrack": ["55ee5a7a-2d30-3fba-a190-4f1a6454f88f"],
    "IEmbeddedD2DObject": ["caa99e5c-dc58-429d-bc18-390ec433000f"],
    "IEnableOpenFromScc": ["795635a1-4522-11d1-8dce-00aa00a3f593"],
    "IEnclosureLocation": ["42340a27-5810-459c-aabb-c65e1f813ecf"],
    "IEnclosureLocation2": ["2885995b-e07d-485d-8a9e-bdf29aef4f66"],
    "IEncoderAPI": ["70423839-6acc-4b23-b079-21dbf08156a5"],
    "IEncryptedAndAuthenticatedData": ["6fa42fe7-1ecb-4b00-bea5-60b83f862f17"],
    "IEndpointPair": ["33a0aa36-f8fa-4b30-b856-76517c3bd06d"],
    "IEndpointPairFactory": ["b609d971-64e0-442b-aa6f-cc8c8f181f78"],
    "IEnforceGrfMode": ["8c9ee71b-4660-49a0-926e-e97a3379cdd7"],
    "IEnhancedStorageACT": ["6e7781f4-e0f2-4239-b976-a01abab52930"],
    "IEnhancedStorageACT2": ["4da57d2e-8eb3-41f6-a07e-98b52b88242b"],
    "IEnhancedStorageACT3": ["022150a1-113d-11df-bb61-001aa01bbc58"],
    "IEnhancedStorageSilo": ["5aef78c6-2242-4703-bf49-44b29357a359"],
    "IEnhancedStorageSiloAction": ["b6f7f311-206f-4ff8-9c4b-27efee77a86f"],
    "IEnhancedWaypoint": ["ed268c74-5913-11e6-8b77-86f30ca893d3"],
    "IEnhancedWaypointFactory": ["af868477-a2aa-46dd-b645-23b31b8aa6c7"],
    "IEnhancement": ["f4e26c7b-0d88-4f41-87e2-b01bd0aa96d6"],
    "IEnlistingInProject": ["f59fd070-0063-4256-8212-e5db6fc22253"],
    "IEnteredBackgroundEventArgs": ["f722dcc2-9827-403d-aaed-ecca9ac17398"],
    "IEnteredBackgroundEventHandler": ["2b09a173-b68e-4def-88c1-8de84e5aab2f", "93a956ae-1d7f-438b-b7b8-227d96b609c0"],
    "IEnterpriseChromeManager": ["4ea5c164-584a-4ba9-b420-86aa52d1c92f"],
    "IEnterpriseChromeServiceProvider": ["b41c09aa-0e12-4da0-829e-0ba17fca01ba"],
    "IEnterpriseDropTarget": ["390e3878-fd55-4e18-819d-4682081c0cfd"],
    "IEnterpriseIdChangeNotification": ["374fdd79-cca2-4be4-a49d-0508c29743bc"],
    "IEnterpriseKeyCredentialRegistrationInfo": ["38321acc-672b-4823-b603-6b3c753daf97"],
    "IEnterpriseKeyCredentialRegistrationManager": ["83f3be3f-a25f-4cba-bb8e-bdc32d03c297"],
    "IEnterpriseKeyCredentialRegistrationManagerStatics": ["77b85e9e-acf4-4bc0-bac2-40bb46efbb3f"],
    "IEntity": ["24264891-e80b-4fd3-b7ce-4ff2fae8931f"],
    "IEntranceNavigationTransitionInfo": ["720a256b-1c8a-41ee-82ec-8a87c0cf47da"],
    "IEntranceNavigationTransitionInfoStatics": ["f948c27a-40c9-469f-8f33-bf45c8811f21"],
    "IEntranceThemeTransition": ["07698c09-a8e3-419a-a01d-7410a0ae8ec8"],
    "IEntranceThemeTransitionStatics": ["37cc0577-ff98-4aed-b86e-5ec23702f877"],
    "IEnumAccounts": ["50c852b0-c95f-4fee-be00-87dc18b2661b"],
    "IEnumActions": ["7a6335c8-7884-11d0-a8a9-00a0c921a4d2"],
    "IEnumAssocHandlers": ["973810ae-9599-4b88-9e4d-6ee98c9552da"],
    "IEnumAutoplayHandler": ["fff994dd-e785-11d6-8f9f-00065bbd32bd"],
    "IEnumAvailableCategories": ["14a821a6-97e8-11d9-8309-000d9dff97d3"],
    "IEnumAvailableNetworks": ["14a82191-97e8-11d9-8309-000d9dff97d3"],
    "IEnumBSTR": ["3d8bed7a-4fde-4149-9ffa-46e6bb9adf21"],
    "IEnumBackgroundCopyGroups": ["d993e603-4aa4-47c5-8665-c20d39c2ba4f"],
    "IEnumBackgroundCopyJobs1": ["8baeba9d-8f1c-42c4-b82c-09ae79980d25"],
    "IEnumBitsPeerCacheRecords": ["659cdea4-489e-11d9-a9cd-000d56965251"],
    "IEnumBitsPeers": ["659cdea5-489e-11d9-a9cd-000d56965251"],
    "IEnumBooleanExpression": ["8ab14053-a4a3-45d0-ae7e-1b56a81bb2f7"],
    "IEnumCATID": ["0002e000-0000-0000-c000-000000000046"],
    "IEnumCERTVIEWATTRIBUTE": ["e77db656-7653-11d1-9bde-00c04fb683fa"],
    "IEnumCERTVIEWCOLUMN": ["9c735be2-57a5-11d1-9bdb-00c04fb683fa"],
    "IEnumCERTVIEWEXTENSION": ["e7dd1466-7653-11d1-9bde-00c04fb683fa"],
    "IEnumCERTVIEWROW": ["d1157f4c-5af2-11d1-9bdc-00c04fb683fa"],
    "IEnumCLSID": ["0002e000-0000-0000-c000-000000000046"],
    "IEnumChangeUnitExceptions": ["3074e802-9319-4420-be21-1022e2e21da8"],
    "IEnumChunkEdgeTravelLogRecoveryData": ["fc8c5a10-5612-445e-a07f-8632799add20"],
    "IEnumChunkTravelLogRecoveryData": ["26115904-fdf5-4204-a8b1-800a15af91e0"],
    "IEnumClientSyncHandlers": ["30da6b29-4bb0-41d7-91c6-b88d695f4cfc"],
    "IEnumClockVector": ["525844db-2837-4799-9e80-81a66e02220c"],
    "IEnumCodePaths2": ["9b13f80d-cfc6-4b78-81ef-1f7cc33f7639"],
    "IEnumComReferences": ["46b4b7c2-11eb-4753-be4b-0e0a16e9ce53"],
    "IEnumComponentTypes": ["8a674b4a-1f63-11d3-b64c-00c04f79498e"],
    "IEnumComponents": ["2a6e2939-2595-11d3-b64c-00c04f79498e", "9a04b730-656c-11d3-85fc-00c04f6123b3"],
    "IEnumComputeThreadInfo110": ["983c0ef8-f4f3-432c-8d4a-0866c55d4b79"],
    "IEnumConnectionManagerUICategory": ["007c90e2-33be-46b7-b86c-eff659c26d4b"],
    "IEnumConnectionManagerUIItem": ["007c90e3-33be-46b7-b86c-eff659c26d4b"],
    "IEnumCookieSessionData": ["1a054188-308f-4142-8657-e8f573d904bd"],
    "IEnumCredentialSessionData": ["6c9e6e89-fb93-4148-a48a-453686cc2943"],
    "IEnumDMO": ["2c3cd98a-2bfa-4a53-9c27-5249ba64ba0f"],
    "IEnumDebugAddresses": ["c2e34ebd-8b9d-11d2-9014-00c04fa38338"],
    "IEnumDebugBoundBreakpoints2": ["0f6b37e0-fcfe-44d9-9112-394ca9b92114"],
    "IEnumDebugCodeContexts2": ["ad47a80b-eda7-459e-af82-647cc9fbaa50"],
    "IEnumDebugCodePaths90": ["0b6520fb-1417-4599-9806-0d254f3c1869"],
    "IEnumDebugComputeKernel110": ["9a663b05-dc59-41d4-bebf-a6a574d1d3ec"],
    "IEnumDebugCustomAttributes": ["d9089ef0-22d1-40b9-81d6-47cbda9dc32c"],
    "IEnumDebugENCInfo2": ["7b076ad1-bd51-11d2-9238-00a02448799a"],
    "IEnumDebugENCRelinkInfo2": ["e51be743-bd57-11d2-9238-00a02448799a"],
    "IEnumDebugENCSnapshots2": ["f6f94d1a-78c2-11d2-8ffe-00c04fa38314"],
    "IEnumDebugErrorBreakpoints2": ["e158f5aa-31fe-491b-a9f6-cff934b03a01"],
    "IEnumDebugErrorInfos2": ["f6f94d23-78c2-11d2-8ffe-00c04fa38314"],
    "IEnumDebugExceptionInfo150": ["418c94a5-23b8-461e-a117-69543ce0db36"],
    "IEnumDebugExceptionInfo2": ["8e4bbd34-a2f4-41ef-87b5-c563b4ad6ee7"],
    "IEnumDebugFields": ["c2e34ebc-8b9d-11d2-9014-00c04fa38338"],
    "IEnumDebugFrameInfo2": ["98bbba48-4c4d-4fff-8340-6097bec9c894"],
    "IEnumDebugFrameInfoFilter2": ["6cd4fb40-f954-44e0-b8a5-a614481e0831"],
    "IEnumDebugIDBInfo2": ["b34e469b-bd59-11d2-9238-00a02448799a"],
    "IEnumDebugMachines2_V7": ["61d986ec-1eac-46b6-90ff-402a008f15d1"],
    "IEnumDebugMachines2__deprecated": ["61d986ec-1eac-46b6-90ff-402a008f15d1"],
    "IEnumDebugModules2": ["4c4a2835-682e-4ce1-aebc-1e6b3a165b44"],
    "IEnumDebugObjects": ["0881751c-99f4-11d2-b767-0000f87572ef"],
    "IEnumDebugPendingBreakpoints2": ["70d2dc1e-4dcc-4786-a072-9a3b600c216b"],
    "IEnumDebugPortSuppliers2": ["59c9dc99-3eff-4ff3-b201-98acd01b0d87"],
    "IEnumDebugPorts2": ["bc827c5e-99ae-4ac8-83ad-2ea5c2034333"],
    "IEnumDebugProcesses2": ["96c74ef4-185d-4f9a-8a43-4d2723758e0a"],
    "IEnumDebugPrograms2": ["8d14bca6-34ce-4efe-ac7e-0abc61dadb20"],
    "IEnumDebugPropertyInfo2": ["6c7072c3-3ac4-408f-a680-fc5a2f96903e"],
    "IEnumDebugReferenceInfo2": ["e459dd12-864f-4aaa-abc1-dcecbc267f04"],
    "IEnumDebugSessionFrameInfo2": ["ef7262c4-4a01-42a0-8658-932667b27555"],
    "IEnumDebugStackFrames2": ["cd39102b-4b69-4495-8f29-e0b25c4a8855"],
    "IEnumDebugTelemetryProperty150": ["161ea122-d0a3-47a8-9063-f6878e0f5f9b"],
    "IEnumDebugThreads2": ["0d30dc12-c4f8-433d-9fcc-9ff117e5e5f4"],
    "IEnumDefinitionIdentity": ["f3549d9c-fc73-4793-9c00-1cd204254c0c"],
    "IEnumDiskQuotaUsers": ["7988b577-ec89-11cf-9c00-00aa00a14f56"],
    "IEnumDot11AdHocInterfaces": ["8f10cc2c-cf0d-42a0-acbe-e2de7007384d"],
    "IEnumDot11AdHocNetworks": ["8f10cc28-cf0d-42a0-acbe-e2de7007384d"],
    "IEnumDot11AdHocSecuritySettings": ["8f10cc2d-cf0d-42a0-acbe-e2de7007384d"],
    "IEnumDpxContainerDirectoryEntries": ["ddc1b725-0e55-452f-838e-d1505b866e2b"],
    "IEnumDpxContainers": ["ddc1b722-0e55-452f-838e-d1505b866e2b"],
    "IEnumDpxFiles": ["ddc1b723-0e55-452f-838e-d1505b866e2b"],
    "IEnumEnhancedStorageACT": ["09b224bd-1335-4631-a7ff-cfd3a92646d7"],
    "IEnumEnhancements": ["ecf43b3a-724a-46bb-bad3-6afe0bef0728"],
    "IEnumExplorerCommand": ["a88826f8-186f-4987-aade-ea0cef8fbfe8"],
    "IEnumFeedClockVector": ["550f763d-146a-48f6-abeb-6c88c7f70514"],
    "IEnumFontNames": ["35d81c54-6448-459c-86b4-a48d1f7746ff"],
    "IEnumFsiItems": ["2c941fda-975b-59be-a960-9a2a262853a5"],
    "IEnumFullIDList": ["d0191542-7954-4908-bc06-b2360bbe45ba"],
    "IEnumGroupEvaluationResultContext110": ["cb9d13f7-b6ec-4971-8075-7a21554d0f4b"],
    "IEnumGroupEvaluationResults110": ["b9ab98d4-0454-4093-8793-2eba79e8c66e"],
    "IEnumGuideDataProperties": ["ae44423b-4571-475c-ad2c-f40a771d80ef"],
    "IEnumHierarchies": ["bec77711-2df9-44d7-b478-a453c2e8a134"],
    "IEnumHierarchyItems": ["687396ae-252e-460f-8f54-ef2c521bb6d8"],
    "IEnumHomegroupRecords": ["2d046f31-f907-4c9e-8f8d-838f617e2975"],
    "IEnumIDENTITY_ATTRIBUTE": ["9cdaae75-246e-4b00-a26d-b9aec137a3eb"],
    "IEnumITfCompositionView": ["5efd22ba-7838-46cb-88e2-cadb14124f8f"],
    "IEnumItemIds": ["43aa3f61-4b2e-4b60-83df-b110d3e148f1"],
    "IEnumJsStackFrames": ["5e7da34b-fb51-4791-abe7-cb5bdf419755"],
    "IEnumLocalClouds": ["34f25baa-6769-485a-88c9-39fcecb9522c"],
    "IEnumMCString": ["32a3094f-0063-4370-9f1c-ca8cf131d631"],
    "IEnumMSVidGraphSegment": ["3dd2903e-e0aa-11d2-b63a-00c04f79498e"],
    "IEnumManagerFrames": ["3caa826a-9b1f-4a79-bc81-f0430ded1648"],
    "IEnumMatchedStackFrameInfo110": ["7007bef7-8a7d-4539-bd92-9b177b75aec9"],
    "IEnumMsiRecord": ["000c1023-0000-0000-c000-000000000046"],
    "IEnumMsiString": ["000c1022-0000-0000-c000-000000000046"],
    "IEnumMsiVolume": ["000c1024-0000-0000-c000-000000000046"],
    "IEnumMsmConfigurableItem": ["832c6969-4826-4c24-a397-b7002d8196e6"],
    "IEnumMsmDependency": ["0adda82c-2c26-11d2-ad65-00a0c9af11a6"],
    "IEnumMsmError": ["0adda829-2c26-11d2-ad65-00a0c9af11a6"],
    "IEnumMsmString": ["0adda826-2c26-11d2-ad65-00a0c9af11a6"],
    "IEnumMsoView": ["b722bcc8-4e68-101b-a2bc-00aa00404770"],
    "IEnumNamedWindows": ["e6b08c04-e901-43d9-ba29-05617e373bda"],
    "IEnumNetwork": ["26656eaa-54eb-4e6f-8f85-4f0ef901a406"],
    "IEnumNetworkConnections": ["dcb00006-570f-4a9b-8d69-199fdba5723b"],
    "IEnumNetworkInterface": ["bcd1de7e-2db1-418b-b047-4a74e101f8c1"],
    "IEnumNetworkSignature": ["de9a958a-a1a5-4812-bdf7-18518ffa6c86"],
    "IEnumNetworks": ["dcb00003-570f-4a9b-8d69-199fdba5723b"],
    "IEnumObjects": ["2c1c7e2e-2d0e-4059-831e-1e6f82335c2e"],
    "IEnumOfflineFilesData": ["3327e7aa-f023-4a21-b83d-c0fee2725fc7"],
    "IEnumOfflineFilesItems": ["da70e815-c361-4407-bc0b-0d7046e5f2cd"],
    "IEnumOfflineFilesSettingNames": ["8cdf4b81-ad17-43e9-ab3e-12e5c10934ad"],
    "IEnumOfflineFilesSettings": ["729680c4-1a38-47bc-9e5c-02c51562ac30"],
    "IEnumOfflineFilesSyncConflicts": ["08ccde75-0b6c-41e6-b75c-575401c7b1aa"],
    "IEnumOfflineFilesSyncContextItems": ["d35e46dc-7ac5-41b8-91aa-7660cd315eea"],
    "IEnumOpenServiceActivity": ["a436d7d2-17c3-4ef4-a1e8-5c86faff26c0"],
    "IEnumOpenServiceActivityCategory": ["33627a56-8c9a-4430-8fd1-b5f5c771afb6"],
    "IEnumPIDMap": ["afb6c2a2-2c41-11d3-8a60-0000f81e0e4a"],
    "IEnumPackages": ["9673a35f-c03a-438d-bd7e-27d9e28ac184"],
    "IEnumPortableDeviceConnectors": ["bfdef549-9247-454f-bd82-06fe80853faa"],
    "IEnumPortableDeviceObjectIDs": ["10ece955-cf41-4728-bfa0-41eedf1bbf19"],
    "IEnumPreviousVersionsCallback": ["c8f026da-8f7d-40aa-a780-41525ebdcc1f"],
    "IEnumProgressItems": ["2c941fd6-975b-59be-a960-9a2a262853a5"],
    "IEnumProgressUpdates": ["2c06eab7-1814-4def-9625-0f3ec1ef0bc7"],
    "IEnumProjectStartupServices": ["9e6f916a-3e8b-4741-8afb-5187f82b699b"],
    "IEnumPropertyUpdates": ["8c85b440-d8f7-48c3-98e0-a91513f7d829"],
    "IEnumPushedPrinterConnections": ["87f825d5-4e6c-4df2-b6b6-240745c98ff4"],
    "IEnumRangeExceptions": ["0944439f-ddb1-4176-b703-046ff22a2386"],
    "IEnumReadyCallback": ["61e00d45-8fff-4e60-924e-6537b61612dd"],
    "IEnumRecoveryCookieJar": ["036438a5-d9ac-4353-a567-69298fdaa990"],
    "IEnumRecoveryCredential": ["d358f4e1-0465-4965-9dd5-cae303d2c345"],
    "IEnumReferenceIdentity": ["b30352cf-23da-4577-9b3f-b4e6573be53b"],
    "IEnumResources": ["2dd81fe3-a83c-4da9-a330-47249d345ba1"],
    "IEnumRunningDocuments": ["d5c658c5-59a1-414f-af5e-e72e83377eae"],
    "IEnumSaDevices": ["55c82f5b-97c8-49a6-8624-8417fe7339d2"],
    "IEnumSearchFolderOutOfProc": ["d6f8ec75-a388-47de-ba3a-903b12a38e86"],
    "IEnumSearchRoots": ["ab310581-ac80-11d1-8df3-00c04fb6ef52"],
    "IEnumSearchScopeRules": ["ab310581-ac80-11d1-8df3-00c04fb6ef54"],
    "IEnumShareInfo": ["65afe70b-8d5b-4c25-9eec-7438e208e07b"],
    "IEnumShellItems": ["70629033-e363-4a28-a567-0db78006e6d7"],
    "IEnumSingleItemExceptions": ["e563381c-1b4d-4c66-9796-c86faccdcd40"],
    "IEnumSnapinNode": ["950d574d-7f36-4f37-a750-07cd3659d6bc"],
    "IEnumSpObjectTokens": ["06b64f9e-7fda-11d2-b4f2-00c04f797396"],
    "IEnumSpeechCommands": ["8c5dac4f-083c-4b85-a4c9-71746048adca"],
    "IEnumSpellingError": ["803e3bd4-2828-4410-8290-418d1d73c762"],
    "IEnumStreamBufferRecordingAttrib": ["c18a9162-1e82-4142-8c73-5690fa62fe33"],
    "IEnumStreamIdMap": ["945c1566-6202-46fc-96c7-d87f289c6534"],
    "IEnumSyncChangeUnits": ["346b35f1-8703-4c6d-ab1a-4dbca2cff97f"],
    "IEnumSyncChanges": ["5f86be4a-5e78-4e32-ac1c-c24fd223ef85"],
    "IEnumSyncMgrConflict": ["82705914-dda3-4893-ba99-49de6c8c8036"],
    "IEnumSyncMgrEventInfo": ["b979fe94-9f8b-4734-a509-7a33f75d6737"],
    "IEnumSyncMgrEvents": ["c81a1d4e-8cf7-4683-80e0-bcae88d677b6"],
    "IEnumSyncMgrFolderItemInfo": ["06091ffe-0b9b-4b2a-b933-0ab0fea8b26d"],
    "IEnumSyncMgrSyncItems": ["54b3abf3-f085-4181-b546-e29c403c726b"],
    "IEnumSyncProviderConfigUIInfos": ["f6be2602-17c6-4658-a2d7-68ed3330f641"],
    "IEnumSyncProviderInfos": ["a04ba850-5eb1-460d-a973-393fcb608a11"],
    "IEnumSystemAssemblies": ["7431fce8-8e4f-49b6-bb50-e295636cba6b"],
    "IEnumTargetFrameworks": ["d92c0b96-e08d-4268-a941-6d7d670f1820"],
    "IEnumTextBlobIds": ["5fed305e-baaf-42c6-9ed9-f25f5f53a6ec"],
    "IEnumTextTrackers": ["c78232b3-a5b8-4613-b6c3-685e5ce2d259"],
    "IEnumTfCandidates": ["defb1926-6c80-4ce8-87d4-d6b72b812bde"],
    "IEnumTfContextViews": ["f0c0f8dd-cf38-44e1-bb0f-68cf0d551c78"],
    "IEnumTfContexts": ["8f1a7ea6-1654-4502-a86e-b2902344d507"],
    "IEnumTfConversionCandidate": ["1a9fb7b5-efaf-4c0b-b59e-7b1ad1cb9f60"],
    "IEnumTfDisplayAttributeInfo": ["7cef04d7-cb75-4e80-a7ab-5f5bc7d332de"],
    "IEnumTfDocumentMgrs": ["aa80e808-2021-11d2-93e0-0060b067b86e"],
    "IEnumTfFunctionProviders": ["e4b24db0-0990-11d3-8df0-00105a2799b5"],
    "IEnumTfInputProcessorProfiles": ["71c6e74d-0f28-11d8-a82a-00065b84435c"],
    "IEnumTfLangBarItems": ["583f34d0-de25-11d2-afdd-00105a2799b5"],
    "IEnumTfLanguageProfiles": ["3d61bf11-ac5f-42c8-a4cb-931bcc28c744"],
    "IEnumTfLatticeElements": ["56988052-47da-4a05-911a-e3d941f17145"],
    "IEnumTfProperties": ["19188cb0-aca9-11d2-afc5-00105a2799b5"],
    "IEnumTfPropertyValue": ["8ed8981b-7c10-4d7d-9fb3-ab72e9c75f72"],
    "IEnumTfRanges": ["f99d3f40-8e32-11d2-bf46-00105a2799b5"],
    "IEnumTfRenderingMarkup": ["8c03d21b-95a7-4ba0-ae1b-7fce12a72930"],
    "IEnumTfUIElements": ["887aa91e-acba-4931-84da-3c5208cf543f"],
    "IEnumToolboxItems": ["5303ccde-d37a-445b-88a1-a71742f66345"],
    "IEnumToolboxTabs": ["cc81495d-3c2b-4b1e-82ce-965ea5fca2a0"],
    "IEnumTuneRequests": ["1993299c-ced6-4788-87a3-420067dce0c7"],
    "IEnumTuningSpaces": ["8b8eb248-fc2b-11d2-9d8c-00c04f72d980"],
    "IEnumUICommand": ["869447da-9f84-4e2a-b92d-00642dc8a911"],
    "IEnumVdsObject": ["118610b7-8d94-4030-b5b8-500889788e4e"],
    "IEnumVsENCRebuildableProjectCfgs": ["3909921b-bacd-11d2-bd66-00c04fa302e2"],
    "IEnumVsEmpWebResource": ["2aba4461-0c9f-11d3-85c9-00a0c9cfcc16"],
    "IEnumVsEmpWebResourceCheckouts": ["2aba4462-0c9f-11d3-85c9-00a0c9cfcc16"],
    "IEnumVsProfilerTargetInfos": ["cf9f5ea4-ce28-4dc6-b058-ee910b9171ae"],
    "IEnumWCFReferenceContracts": ["a8f120c5-e7df-465a-a7fb-711805281a3b"],
    "IEnumWCFReferenceEndpoints": ["0d66f264-c498-44c6-b08a-1a9ef57ddd63"],
    "IEnumWCFReferenceGroupMetadataItems": ["603a2aea-c925-4a8c-a273-65b3b81cd43a"],
    "IEnumWbemClassObject": ["027947e1-d731-11ce-a357-000000000001"],
    "IEnumWebServices": ["4db4e7d3-5550-41ae-a612-3d28cd0c52a8"],
    "IEnumWiaItem2": ["59970af4-cd0d-44d9-ab24-52295630e582"],
    "IEnumWindowFrames": ["8c453b03-8907-435b-96d7-573c40948f5c"],
    "IEnumXWizardHost": ["777ba8ae-2498-4875-933a-3067de883070"],
    "IEnumXWizardPage": ["777ba8ce-2498-4875-933a-3067de883070"],
    "IEnumXWizardPropertyBag": ["777ba8de-2498-4875-933a-3067de883070"],
    "IEnumXWizardTask": ["777ba8be-2498-4875-933a-3067de883070"],
    "IEnumerableBSTR": ["b887db4f-490c-415e-9ff4-f4657b757772"],
    "IEnumerableIVxContentType": ["acc50312-81c5-4da1-92b0-3f37acfa1106"],
    "IEnumerableIVxTextSnapshotLine": ["021b71e1-59bb-481a-9ac6-c9b4ad7b7446"],
    "IEnumerableView": ["8c8bf236-1aec-495f-9894-91d57c3c686f"],
    "IEnumerationBlockOptions": ["e9faf793-31c2-406a-8096-da07bf7de0a4"],
    "IEnumeratorBSTR": ["18a2071c-67fb-4543-bd62-d11e68a6785b"],
    "IEnumeratorIUnknown": ["379d6c69-25b8-413d-b58c-015f2c7a942d"],
    "IEnumeratorIVxContentType": ["d92cce42-6e23-4ce3-a633-8b76ac0826f2"],
    "IEnumeratorIVxTextBuffer": ["7a1e5f7c-6f1d-4e1e-b13d-8656b71f2f97"],
    "IEnumeratorIVxTextChange": ["a4728f3b-90ee-4783-a6af-0caeeea73147"],
    "IEnumeratorIVxTextSnapshot": ["13dc5d4f-7e53-4180-8779-1364b6ae8322"],
    "IEnumeratorIVxTextSnapshotLine": ["5ba4ea24-9310-4284-9e86-6ebec3e1818e"],
    "IEnumeratorIVxTrackingSpan": ["496727c4-5622-4889-94ae-ddd857bacea7"],
    "IEnumeratorVxSnapshotPoint": ["30ddec83-f0b5-4bd7-a4d3-2d82d51d6d70"],
    "IEnumeratorVxSnapshotSpan": ["fd6cb9a7-f2c2-450d-b14e-756b5a013591"],
    "IEnumeratorVxSpan": ["f5c3a3cb-442d-4abc-84b7-687611079c21"],
    "IEqualizerBand": ["c00a5a6a-262d-4b85-9bb7-43280b62ed0c"],
    "IEqualizerEffectDefinition": ["023f6f1f-83fe-449a-a822-c696442d16b0"],
    "IEqualizerEffectDefinitionFactory": ["d2876fc4-d410-4eb5-9e69-c9aa1277eaf0"],
    "IEquatableConcept": ["c52d5d3d-609d-4d5d-8a82-46b0acdec4f4"],
    "IErrorDetails": ["378cbb01-2cc9-428f-8c55-2c990d463e8f"],
    "IErrorDetailsStatics": ["b7703750-0b1d-46c8-aa0e-4b8178e4fce9"],
    "IErrorLookup": ["0c733a66-2a1c-11ce-ade5-00aa0044773d"],
    "IErrorMessage": ["a17b9e86-a16b-4a47-9b64-135777b44e64"],
    "IErrorReceivedEventArgs": ["fcc6bf59-1283-4d8a-bfdf-566b33ddb28f"],
    "IErrorRecords": ["0c733a67-2a1c-11ce-ade5-00aa0044773d"],
    "IErrorReportingSettings": ["16369792-b03e-4ba1-8bb8-d28f4ab4d2c0"],
    "IEtwEvent": ["07a0c227-bbeb-43fa-af86-108114187cdc"],
    "IEtwEventFactory": ["80fdee60-5888-47db-92d3-e5bc3c9f57cf"],
    "IEtwEventRecord": ["79380594-6095-49c8-82e6-65ddc099dc59"],
    "IEtwEventRecordCallback": ["8929948f-2a94-4ed4-abb6-92ef45e61b21"],
    "IEtwEventWatcher": ["012a38e6-6b29-473e-a219-caae719e9996"],
    "IEtwProvider": ["11624719-7c26-4bde-a80f-441df7670bb8"],
    "IEtwProviderStatics": ["598024f7-a743-4555-a1fd-5eb465308194"],
    "IEtwRule": ["c2205647-2fd8-43e0-92cb-0ed1a0db9e55"],
    "IEtwRuleFactory": ["363fa5d1-2e25-4cc0-8bcf-62ecd32abf9a"],
    "IEvalRat": ["c5c5c5b1-3abc-11d6-b25b-00c04fa0c026"],
    "IEventBinding": ["8e398ce0-a64e-11d0-a9ea-00aa00685c74"],
    "IEventBindingManager": ["0b4cdbc0-a64f-11d0-a9ea-00aa00685c74"],
    "IEventBindingManagerCopier": ["64bad540-f88d-11d0-aa14-00aa006bc80b"],
    "IEventBindings": ["1080b910-a636-11d0-a9ea-00aa00685c74"],
    "IEventClassInternal": ["9f83871a-195f-44b5-a46f-18fffe152f7c"],
    "IEventClassTier2": ["609b9555-4fb6-11d1-9971-00c04fbbb345"],
    "IEventComCat": ["65a70ec0-cd87-11d0-a9f8-00aa00685c74"],
    "IEventCreateOptions": ["c0287bfe-ef7f-11d1-9fff-00c04fa37348"],
    "IEventDatabase": ["bc5a3ec8-9f24-11d1-b7a3-00c04fb926af"],
    "IEventDatabaseManager": ["adc25b30-cbd8-11d0-a9f8-00aa00685c74"],
    "IEventDatabasePlugin": ["4915fb10-af97-11d0-a9eb-00aa00685c74"],
    "IEventDeliveryOptions": ["0688a660-a3ff-11d0-a9e9-00aa00685c74"],
    "IEventDispatcherChain": ["58a90754-fb15-11d1-a00c-00c04fa37348"],
    "IEventException": ["3051073a-98b5-11cf-bb82-00aa00bdce0b"],
    "IEventIsCacheable": ["22e0f830-1e81-11d1-aa29-00aa006bc80b"],
    "IEventLock": ["1b7058f0-af88-11d0-a9eb-00aa00685c74"],
    "IEventManager": ["5f6012b0-a651-11d0-a9ea-00aa00685c74"],
    "IEventNotificationCallback": ["021e0321-e397-41a1-a6f1-18600895f4b0"],
    "IEventNotifyBindingChange": ["08f4f2a0-dc5b-11d0-aa0f-00aa006bc80b"],
    "IEventNotifyBindingChangeDisp": ["dc3d83b0-e99f-11d0-aa10-00aa006bc80b"],
    "IEventObjectRow": ["ffcaa232-9f25-11d1-b7a3-00c04fb926af"],
    "IEventObjectRowCursor": ["ffcaa233-9f25-11d1-b7a3-00c04fb926af"],
    "IEventObjectTable": ["bc5a3ec9-9f24-11d1-b7a3-00c04fb926af"],
    "IEventPersistBinding": ["e9311660-1a98-11d1-aa26-00aa006bc80b"],
    "IEventPropertyBag": ["aabb23e0-a705-11d0-a9ea-00aa00685c74"],
    "IEventRouter": ["1a00b970-eda0-11d0-aa10-00aa006bc80b"],
    "IEventRuleEngine": ["da816090-f343-11d0-aa14-00aa006bc80b"],
    "IEventSinkNotify": ["bdf065b0-f346-11d0-aa14-00aa006bc80b"],
    "IEventSinkNotifyDisp": ["33a79660-f347-11d0-aa14-00aa006bc80b"],
    "IEventSourceType": ["063a62e0-a652-11d0-a9ea-00aa00685c74"],
    "IEventSourceTypes": ["caf30fd0-a651-11d0-a9ea-00aa00685c74"],
    "IEventSources": ["73e8c930-a652-11d0-a9ea-00aa00685c74"],
    "IEventSubscriptionInternal": ["9b724996-d383-4c5f-b0f6-2814708c7633"],
    "IEventSubscriptionTier2": ["609b9557-4fb6-11d1-9971-00c04fbbb345"],
    "IEventSystemInitialize": ["a0e8f27a-888c-11d1-b763-00c04fb926af"],
    "IEventSystemPersistable": ["a0e8f279-888c-11d1-b763-00c04fb926af"],
    "IEventSystemTier2": ["609b954b-4fb6-11d1-9971-00c04fbbb345"],
    "IEventSystemTier2Factory": ["64b8f404-a4ae-11d1-b7b6-00c04fb926af"],
    "IEventSystemTier2Inproc": ["dc7c5ccc-34e1-4531-941d-035e29ff8257"],
    "IEventTarget": ["305104b9-98b5-11cf-bb82-00aa00bdce0b"],
    "IEventTarget2": ["30510839-98b5-11cf-bb82-00aa00bdce0b"],
    "IEventTrigger": ["d45b0167-9653-4eef-b94f-0732ca7af251", "def8f855-0b49-4087-b1a9-b8b38488f786"],
    "IEventType": ["4a993b80-a654-11d0-a9ea-00aa00685c74"],
    "IEventTypeSinks": ["a1063f50-a654-11d0-a9ea-00aa00685c74"],
    "IEventTypes": ["cab29ef0-a64f-11d0-a9ea-00aa00685c74"],
    "IEventUtil": ["c61670e0-cd6e-11d0-a9f8-00aa00685c74"],
    "IEvtlogger": ["c1ce93d8-b59a-4037-b4b4-a5bb59e58e4f"],
    "IExceptionNotification": ["000001db-0000-0000-c000-000000000046"],
    "IExceptionRoutedEventArgs": ["dd9ff16a-4b62-4a6c-a49d-0671ef6136be"],
    "IExceptionRoutedEventArgsFactory": ["bba9826d-5d7a-44e7-b893-b2ae0dd24273"],
    "IExceptionRoutedEventHandler": ["68e0e810-f6ea-42bc-855b-5d9b67e6a262"],
    "IExchangeExportChanges": ["a3ea9cc0-d1b2-11cd-80fc-00aa004bba0b"],
    "IExeServerActivatableClassRegistration": ["9308c3c5-c2ac-49d1-a024-660a2bb5d5ac"],
    "IExeServerRegistration": ["ec734a06-0401-4317-bac1-3b7e207242e3"],
    "IExecAction": ["4c3d624d-fd6b-49a3-b9b7-09cb3cd3f047"],
    "IExecAction2": ["f2a82542-bda5-4e6b-9143-e2bf4f8987b6"],
    "IExecuteCommand": ["7f9185b0-cb92-43c5-80a9-92277a4f7b54"],
    "IExecuteCommandApplicationHostEnvironment": ["18b21aa9-e184-4ff0-9f5e-f882d03771b3"],
    "IExecuteCommandHost": ["4b6832a2-5f04-4c9d-b89d-727a15d103e7"],
    "IExecuteCommandNotify": ["cdb65641-7618-4871-a1fb-151a88db3f94"],
    "IExecuteRequestedEventArgs": ["e07fa734-a0b6-5755-9e87-24f54cca9372"],
    "IExecutionEngine": ["7af02dac-2a33-494b-a09f-25e00a93c6f8"],
    "IExpDispSupport": ["0d7d1d00-6fc0-11d0-a974-00c04fd705a2"],
    "IExpDispSupportXP": ["2f0dd58c-f789-4f14-99fb-9293b3c9c212"],
    "IExpandCollapsePatternIdentifiers": ["b006bac0-751b-4d55-92cb-613ec1bdf5d0"],
    "IExpandCollapsePatternIdentifiersStatics": ["d7816fd4-6ee0-4f38-8e14-56ef21adacfd"],
    "IExpandCollapseProvider": ["49ac8399-d626-4543-94b9-a6d9a9593af6", "d847d3a5-cab0-4a98-8c32-ecb45c59ad24"],
    "IExperimentationBroker": ["15c6aa22-55af-49de-bc43-0ac340f3a8ae"],
    "IExplorerBrowser": ["dfd3b6b5-c10c-4be9-85f6-a66969f402f6"],
    "IExplorerBrowserEvents": ["361bbdc7-e6ee-4e13-be58-58e2240c810f"],
    "IExplorerCommand": ["a08ce4d0-fa25-44ab-b57c-c7b1c323e0b9"],
    "IExplorerCommand2": ["d51836b4-8b5a-4e11-8f97-d489bd4b28c0"],
    "IExplorerCommandProvider": ["64961751-0835-43c0-8ffe-d57686530e64"],
    "IExplorerCommandState": ["bddacb60-7657-47ae-8445-d23e1acf82ae"],
    "IExplorerFrame": ["76542021-fff8-43f3-acbd-bb46a60a94ca"],
    "IExplorerFrameCallback": ["86d6986d-b7e8-4246-b823-14bee2c4232a"],
    "IExplorerFrameCallbackManager": ["e2d2f506-0441-46af-83f9-c51458e3a19e"],
    "IExplorerHost": ["50a87baa-5f79-4c31-b6b3-28f6f2d097e6"],
    "IExplorerHostCreator": ["c4de032a-d902-450a-bc43-d9df6d0fd48c"],
    "IExplorerLauncher": ["5ac8c8f7-1cc7-46cb-8d7d-3cf14b64868c"],
    "IExplorerPaneVisibility": ["e07010ec-bc17-44c0-97b0-46c7c95b9edc"],
    "IExplorerRibbonTestHook": ["9a395adf-3dc9-413e-a2d9-ddf867105efd"],
    "IExplorerToolbar": ["f80c2137-5829-4ce9-9f81-a95e159dd8d5"],
    "IExplorerWindowManager": ["f7041e23-1a6c-41bb-89b2-b3425c51ccd5"],
    "IExponentialEase": ["7cb9e41d-f0bb-4bca-9da5-9ba3a11734c4"],
    "IExponentialEaseStatics": ["f37ee7e3-a761-4352-9ad6-70794567581a"],
    "IExposureCompensationControl": ["81c8e834-dcec-4011-a610-1f3847e64aca"],
    "IExposureControl": ["09e8cbe2-ad96-4f28-a0e0-96ed7e1b5fd2"],
    "IExposurePriorityVideoControl": ["2cb240a3-5168-4271-9ea5-47621a98a352"],
    "IExpressionAnimation": ["6acc5431-7d3d-4bf3-abb6-f44bdc4888c1"],
    "IExtendedExecutionBroker": ["ba62a0e9-1bca-4e20-9da8-d748dc56a27c"],
    "IExtendedExecutionForegroundRevokedEventArgs": ["b07cd940-9557-aea4-2c99-bdd56d9be461"],
    "IExtendedExecutionForegroundSession": ["fbf440e1-9d10-4201-b01e-c83275296f2e"],
    "IExtendedExecutionRevokedEventArgs": ["bfbc9f16-63b5-4c0b-aad6-828af5373ec3"],
    "IExtendedExecutionSession": ["af908a2d-118b-48f1-9308-0c4fc41e200f"],
    "IExtendedObject": ["a575c060-5b17-11d1-ab3e-00a0c9055a90"],
    "IExtendedTypeLib": ["6d5140d6-7436-11ce-8034-00aa006009fa"],
    "IExtenderProvider": ["4db06329-23f4-443b-9abd-9cf611e8ae07"],
    "IExtenderProviderUnk": ["f69b64a3-9017-4e48-9784-e152b51aa722"],
    "IExtenderSite": ["e57c510b-968b-4a3c-a467-ee4013157dc9"],
    "IExtensibleObject": ["86c31347-5b52-4715-b454-a6e5fcab975d"],
    "IExtensibleObjectSite": ["eb5be8a7-e593-4de6-a923-c2afecb96336"],
    "IExtensionActivationContextProperties": ["071742dc-587e-4930-81d5-8a7de8547529"],
    "IExtensionValidation": ["7d33f73d-8525-4e0f-87db-830288baff44"],
    "IExtensions": ["9d0876ca-02dc-453a-95d9-f2194a656442"],
    "IExtractIconWithElevationCache": ["cb304ee1-ab41-4341-93e8-f94c0010425e"],
    "IEyesPose": ["682a9b23-8a1e-5b86-a060-906ffacb62a4"],
    "IEyesPoseStatics": ["1cff7413-b21f-54c0-80c1-e60d994ca58c"],
    "IF12HostManagerProcessProvider": ["5eb747cd-1780-4cd1-a625-9d806bd6eaf8"],
    "IFECommon": ["019f7151-e6db-11d0-83c3-00c04fddb82e"],
    "IFEDictionary": ["019f7153-e6db-11d0-83c3-00c04fddb82e"],
    "IFELanguage": ["019f7152-e6db-11d0-83c3-00c04fddb82e"],
    "IFELanguage2": ["21164102-c24a-11d1-851a-00c04fcc6b14"],
    "IFRSReplicaSet": ["c5c48050-0141-4805-b365-9ad2b06f475e"],
    "IFSClientProxy": ["7b23bf1b-785c-4170-ae58-923fd320f094"],
    "IFSPipelineMediaType": ["5f3ee6ff-f69d-409c-8e41-d51107e9bb78"],
    "IFSTraceString": ["3858aded-fdea-4e35-bd7a-f90c8e8727bf"],
    "IFSTraceStringArray": ["ae1f0687-3668-448b-9790-768b6499d509"],
    "IFTEPluginEventLogger": ["a373e885-7a87-11d3-b1c1-00c04f68155c"],
    "IFTEPluginLocator": ["e2092465-544c-4e2f-8447-adc89d122ffc"],
    "IFTEPluginLocatorClient": ["85ffaef0-8208-4c44-8072-48b1a7852ebe"],
    "IFTEStringNormalizer": ["68c6d225-77e0-11d5-8528-00c04f68155c"],
    "IFTSQLParserSessionEx": ["794f8323-0976-42ed-8999-e1e1602ac7ec"],
    "IFaceDetectedEventArgs": ["19918426-c65b-46ba-85f8-13880576c90a"],
    "IFaceDetectionEffect": ["ae15ebd2-0542-42a9-bc90-f283a29f46c1"],
    "IFaceDetectionEffectDefinition": ["43dca081-b848-4f33-b702-1fd2624fb016"],
    "IFaceDetectionEffectFrame": ["8ab08993-5dc8-447b-a247-5270bd802ece"],
    "IFaceDetector": ["16b672dc-fe6f-3117-8d95-c3f04d51630c"],
    "IFaceDetectorStatics": ["bc042d67-9047-33f6-881b-6746c1b218b8"],
    "IFaceTracker": ["6ba67d8c-a841-4420-93e6-2420a1884fcf"],
    "IFaceTrackerStatics": ["e9629198-1801-3fa5-932e-31d767af6c4d"],
    "IFadeInThemeAnimation": ["6d4bc8f5-a918-4477-8078-554c68812ab8"],
    "IFadeInThemeAnimationStatics": ["7f0117e1-bea9-4923-b23a-0ddf4d7b8737"],
    "IFadeOutThemeAnimation": ["89276ba9-ffd4-45b6-9b9a-ced48951e712"],
    "IFadeOutThemeAnimationStatics": ["fe17a81a-4168-4f68-a28c-e5dd98cf680f"],
    "IFastRundown": ["00000040-0000-0000-c000-000000000046"],
    "IFaxAccount": ["68535b33-5dc4-4086-be26-b76f9b711006"],
    "IFaxAccountFolders": ["6463f89d-23d8-46a9-8f86-c47b77ca7926"],
    "IFaxAccountIncomingArchive": ["a8a5b6ef-e0d6-4aee-955c-91625bec9db4"],
    "IFaxAccountIncomingQueue": ["dd142d92-0186-4a95-a090-cbc3eadba6b4"],
    "IFaxAccountNotify": ["0b5e5bd1-b8a9-47a0-a323-ef4a293ba06a", "b9b3bc81-ac1b-46f3-b39d-0adc30e1b788"],
    "IFaxAccountOutgoingArchive": ["5463076d-ec14-491f-926e-b3ceda5e5662"],
    "IFaxAccountOutgoingQueue": ["0f1424e9-f22d-4553-b7a5-0d24bd0d7e46"],
    "IFaxAccountSet": ["7428fbae-841e-47b8-86f4-2288946dca1b"],
    "IFaxAccounts": ["93ea8162-8be7-42d1-ae7b-ec74e2d989da"],
    "IFaxActivity": ["4b106f97-3df5-40f2-bc3c-44cb8115ebdf"],
    "IFaxActivityLogging": ["1e29078b-5a69-497b-9592-49b7e7faddb5"],
    "IFaxConfiguration": ["10f4d0f7-0994-4543-ab6e-506949128c40"],
    "IFaxDevice": ["49306c59-b52e-4867-9df4-ca5841c956d0"],
    "IFaxDeviceIds": ["2f0f813f-4ce9-443e-8ca1-738cfaeee149"],
    "IFaxDeviceProvider": ["290eac63-83ec-449c-8417-f148df8c682a"],
    "IFaxDeviceProviders": ["9fb76f62-4c7e-43a5-b6fd-502893f7e13e"],
    "IFaxDevices": ["9e46783e-f34f-482e-a360-0416becbbd96"],
    "IFaxDoc": ["fa21f4c5-5c4c-11d1-83cf-00c04fb6e984"],
    "IFaxDocument": ["b207a246-09e3-4a4e-a7dc-fea31d29458f"],
    "IFaxDocument2": ["e1347661-f9ef-4d6d-b4a5-c0a068b65cff"],
    "IFaxEventLogging": ["0880d965-20e8-42e4-8e17-944f192caad4"],
    "IFaxFolders": ["dce3b2a8-a7ab-42bc-9d0a-3149457261a0"],
    "IFaxInboundRouting": ["8148c20f-9d52-45b1-bf96-38fc12713527"],
    "IFaxInboundRoutingExtension": ["885b5e08-c26c-4ef9-af83-51580a750be1"],
    "IFaxInboundRoutingExtensions": ["2f6c9673-7b26-42de-8eb0-915dcd2a4f4c"],
    "IFaxInboundRoutingMethod": ["45700061-ad9d-4776-a8c4-64065492cf4b"],
    "IFaxInboundRoutingMethods": ["783fca10-8908-4473-9d69-f67fbea0c6b9"],
    "IFaxIncomingArchive": ["76062cc7-f714-4fbd-aa06-ed6e4a4b70f3"],
    "IFaxIncomingJob": ["207529e6-654a-4916-9f88-4d232ee8a107"],
    "IFaxIncomingJobs": ["011f04e9-4fd6-4c23-9513-b6b66bb26be9"],
    "IFaxIncomingMessage": ["7cab88fa-2ef9-4851-b2f3-1d148fed8447"],
    "IFaxIncomingMessage2": ["f9208503-e2bc-48f3-9ec0-e6236f9b509a"],
    "IFaxIncomingMessageIterator": ["fd73ecc4-6f06-4f52-82a8-f7ba06ae3108"],
    "IFaxIncomingQueue": ["902e64ef-8fd8-4b75-9725-6014df161545"],
    "IFaxJob": ["55dabfd5-5c9e-11d1-b791-000000000000"],
    "IFaxJobStatus": ["8b86f485-fd7f-4824-886b-40c5caa617cc"],
    "IFaxJobs": ["55dabfd3-5c9e-11d1-b791-000000000000"],
    "IFaxLoggingOptions": ["34e64fb9-6b31-4d32-8b27-d286c0c33606"],
    "IFaxOutboundRouting": ["25dc05a4-9909-41bd-a95b-7e5d1dec1d43"],
    "IFaxOutboundRoutingGroup": ["ca6289a1-7e25-4f87-9a0b-93365734962c"],
    "IFaxOutboundRoutingGroups": ["235cbef7-c2de-4bfd-b8da-75097c82c87f"],
    "IFaxOutboundRoutingRule": ["e1f795d5-07c2-469f-b027-acacc23219da"],
    "IFaxOutboundRoutingRules": ["dcefa1e7-ae7d-4ed6-8521-369edcca5120"],
    "IFaxOutgoingArchive": ["c9c28f40-8d80-4e53-810f-9a79919b49fd"],
    "IFaxOutgoingJob": ["6356daad-6614-4583-bf7a-3ad67bbfc71c"],
    "IFaxOutgoingJob2": ["418a8d96-59a0-4789-b176-edf3dc8fa8f7"],
    "IFaxOutgoingJobs": ["2c56d8e6-8c2f-4573-944c-e505f8f5aeed"],
    "IFaxOutgoingMessage": ["f0ea35de-caa5-4a7c-82c7-2b60ba5f2be2"],
    "IFaxOutgoingMessage2": ["b37df687-bc88-4b46-b3be-b458b3ea9e7f"],
    "IFaxOutgoingMessageIterator": ["f5ec5d4f-b840-432f-9980-112fe42a9b7a"],
    "IFaxOutgoingQueue": ["80b1df24-d9ac-4333-b373-487cedc80ce5"],
    "IFaxPort": ["d73733cc-cc80-11d0-b225-00c04fb6c2f5"],
    "IFaxPorts": ["d73733d5-cc80-11d0-b225-00c04fb6c2f5"],
    "IFaxReceiptOptions": ["378efaeb-5fcb-4afb-b2ee-e16e80614487"],
    "IFaxRecipient": ["9a3da3a0-538d-42b6-9444-aaa57d0ce2bc"],
    "IFaxRecipients": ["b9c9de5a-894e-4492-9fa3-08c627c11d5d"],
    "IFaxRoutingMethod": ["2199f5f3-cefc-11d0-a341-0000f800e68d"],
    "IFaxRoutingMethods": ["2199f5f5-cefc-11d0-a341-0000f800e68d"],
    "IFaxSecurity": ["77b508c1-09c0-47a2-91eb-fce7fdf2690e"],
    "IFaxSecurity2": ["17d851f4-d09b-48fc-99c9-8f24c4db9ab1"],
    "IFaxSender": ["0d879d7d-f57a-4cc6-a6f9-3ee5d527b46a"],
    "IFaxServer": ["475b6469-90a5-4878-a577-17a86e8e3462", "d73733c7-cc80-11d0-b225-00c04fb6c2f5"],
    "IFaxServer2": ["571ced0f-5609-4f40-9176-547e3a72ca7c"],
    "IFaxServerNotify": ["2e037b27-cf8a-4abd-b1e0-5704943bea6f"],
    "IFaxServerNotify2": ["616ca8d6-a77a-4062-abfd-0e471241c7aa", "ec9c69b9-5fe7-4805-9467-82fcd96af903"],
    "IFaxStatus": ["8b97e605-d054-11d0-b226-00c04fb6c2f5"],
    "IFaxTiff": ["b19bb45f-b91c-11d1-83e1-00c04fb6e984"],
    "IFdnAccessManagerStatics": ["f2aa4395-f1e6-4319-aa3e-477ca64b2bdf"],
    "IFeed": ["f7f915d8-2ede-42bc-98e7-a5d05063a757"],
    "IFeed2": ["33f2ea09-1398-4ab9-b6a4-f94b49d0a42e"],
    "IFeedClockVector": ["8d1d98d1-9fb8-4ec9-a553-54dd924e0f67"],
    "IFeedClockVectorElement": ["a40b46d2-e97b-4156-b6da-991f501b0f05"],
    "IFeedEnclosure": ["361c26f7-90a4-4e67-ae09-3a36a546436a"],
    "IFeedEvents": ["abf35c99-0681-47ea-9a8c-1436a375a99e"],
    "IFeedFolder": ["81f04ad1-4194-4d7d-86d6-11813cec163c"],
    "IFeedFolderEvents": ["20a59fa6-a844-4630-9e98-175f70b4d55b"],
    "IFeedItem": ["0a1e6cad-0a47-4da2-a13d-5baaa5c8bd4f"],
    "IFeedItem2": ["79ac9ef4-f9c1-4d2b-a50b-a7ffba4dcf37"],
    "IFeedRequest": ["cccf3654-f2c1-405b-b167-682e0a3e9a20"],
    "IFeedRequestCallback": ["f847e090-32df-464a-8c03-decba6ad67af"],
    "IFeedTasks": ["9df68e2d-7484-4851-9b87-f6dda1b8b446"],
    "IFeedbackHubApp": ["abb07809-a867-4c65-9598-8b8f9d5e88d6"],
    "IFeedbackHubAppInfo": ["06c1d185-6035-4728-81d9-ee4bd2bea71a"],
    "IFeedsEnum": ["e3cd0028-2eed-4c60-8fae-a3225309a836"],
    "IFeedsManager": ["a74029cc-1f1a-4906-88f0-810638d86591"],
    "IFhConfigMgr": ["6a5fea5b-bf8f-4ee5-b8c3-44d8a0d7331c"],
    "IFhReassociation": ["6544a28a-f68d-47ac-91ef-16b2b36aa3ee"],
    "IFhScopeIterator": ["3197abce-532a-44c6-8615-f3666566a720"],
    "IFhTarget": ["d87965fd-2bad-4657-bd3b-9567eb300ced"],
    "IFileActivatedEventArgs": ["bb2afc33-93b1-42ed-8b26-236dd9c78496"],
    "IFileActivatedEventArgsWithCallerPackageFamilyName": ["2d60f06b-d25f-4d25-8653-e1c5e1108309"],
    "IFileActivatedEventArgsWithNeighboringFiles": ["433ba1a4-e1e2-48fd-b7fc-b5d6eee65033"],
    "IFileBasedLogInit": ["00951e8c-1294-11d1-97e4-00c04fb9618a"],
    "IFileCallbackCleanup": ["35c5f79c-6d81-4819-aa64-d6a8939d94d6"],
    "IFileCallbackClose": ["c28fd731-f3f1-4573-97dc-620f72d013a6"],
    "IFileChangeEntry": ["d34e1a5f-5063-4dee-b9e3-2316b0a6ced3"],
    "IFileChangeEntryVector": ["d840e2e9-c794-4183-9be9-38cb358348a2"],
    "IFileChangeTracker": ["0875169b-1407-44ea-9298-20a337646785"],
    "IFileChangeTrackerForStoreApp": ["7f2be360-2a95-4574-a16e-b8ec025083ce"],
    "IFileChangeTrackerInternal": ["b77d0bb4-256d-4218-8a17-52bc66b19f4b"],
    "IFileChangeTrackerRegistrar": ["63f55b21-b33e-4d42-b614-733a96a618c0"],
    "IFileChangeTrackerState": ["e09841dd-8048-40d0-a7cf-54d78b0a9c2b"],
    "IFileChunkMap": ["0095a475-f357-475c-a5b7-cb183e48a1be"],
    "IFileClient": ["bfccd196-1244-4840-ab44-480975c4ffe4"],
    "IFileDialog": ["42f85136-db7e-439c-85f1-e4075d135fc8"],
    "IFileDialog2": ["61744fc7-85b5-4791-a9b0-272276309b13"],
    "IFileDialogControlEvents": ["36116642-d713-4b97-9b83-7484a9d00433"],
    "IFileDialogCustomize": ["e6fdd21a-163f-4975-9c8c-a69f1ba37034"],
    "IFileDialogCustomizeOld": ["8016b7b3-3d49-4504-a0aa-2a37494e606f"],
    "IFileDialogEvents": ["973510db-7d7f-452b-8975-74a85828d354"],
    "IFileDialogEventsPrivate": ["050e9e69-baea-4c08-ad6a-61666dd32e96"],
    "IFileDialogPrivate": ["18cfdf39-aa66-42c6-906b-7e4aaf8d3dfe"],
    "IFileDialogResultHandler": ["42841501-194f-478f-9b4c-78985419da53"],
    "IFileDownloadBroker": ["8b103b7a-d39e-4c3d-b1f6-913b6cae5009"],
    "IFileHandle": ["5e0ebc87-bece-4f2a-8d36-3673758f6c55"],
    "IFileHashProviderCallback": ["e9a288f7-bcfb-4466-95c6-5a388263d8fb"],
    "IFileIOStatics": ["887411eb-7f54-4732-a5f0-5e43e3b8c2f5"],
    "IFileInformationFactory": ["401d88be-960f-4d6d-a7d0-1a3861e76c83"],
    "IFileInformationFactoryFactory": ["84ea0e7d-e4a2-4f00-8afa-af5e0f826bd5"],
    "IFileIo": ["11993196-1244-4840-ab44-480975c4ffe4"],
    "IFileIsInUse": ["64a1cbf0-3a1a-4461-9158-376969693950"],
    "IFileJunctionOptions": ["72dbece7-d912-4a8f-841c-a521b7447463"],
    "IFileLoggingSession": ["24c74216-fed2-404c-895f-1f9699cb02f7"],
    "IFileLoggingSessionFactory": ["eea08dce-8447-4daa-9133-12eb46f697d4"],
    "IFileOpenDialog": ["d57c7288-d4ad-4768-be02-9d969532d960"],
    "IFileOpenDialogPrivate": ["3e481212-dfe0-4756-a033-0928214904bc"],
    "IFileOpenPicker": ["2ca8278a-12c5-4c5f-8977-94547793c241"],
    "IFileOpenPicker2": ["8ceb6cd2-b446-46f7-b265-90f8e55ad650"],
    "IFileOpenPicker3": ["d9a5c5b3-c5dc-5b98-bd80-a8d0ca0584d8"],
    "IFileOpenPickerActivatedEventArgs": ["72827082-5525-4bf2-bc09-1f5095d4964d"],
    "IFileOpenPickerActivatedEventArgs2": ["5e731f66-8d1f-45fb-af1d-73205c8fc7a1"],
    "IFileOpenPickerContinuationEventArgs": ["f0fa3f3a-d4e8-4ad3-9c34-2308f32fcec9"],
    "IFileOpenPickerStatics": ["6821573b-2f02-4833-96d4-abbfad72b67b"],
    "IFileOpenPickerStatics2": ["e8917415-eddd-5c98-b6f3-366fdfcad392"],
    "IFileOpenPickerUI": ["dda45a10-f9d4-40c4-8af5-c5b6b5a61d1d"],
    "IFileOpenPickerWithOperationId": ["3f57b569-2522-4ca5-aa73-a15509f1fcbf"],
    "IFileOperation": ["947aab5f-0a5c-4c13-b4d6-4bf7836fc9f8"],
    "IFileOperation2": ["cd8f23c1-8f61-4916-909d-55bdd0918753"],
    "IFileOperationBroker": ["d2da1efd-1dfa-43e1-911f-e18288e361b0"],
    "IFileOperationConflictItemsMetadata": ["b3cd19c7-42fc-417d-a831-9394e78705b4"],
    "IFileOperationProgressSink": ["04b0f1a7-9490-44bc-96e1-4296a31252e2"],
    "IFilePickerInternal": ["2bd6990f-2d1a-4b5a-9d61-ab6229a36caa"],
    "IFilePlaceholder": ["e6240d00-fecd-40b1-a7e4-8ed12ca335fd"],
    "IFilePlaceholderCallback": ["3bbe1335-5937-4ba2-b42e-93fc3d6227d9"],
    "IFilePlaceholderStateInternal": ["c8b34e60-6ee3-4881-9138-6b4fb6bfb461"],
    "IFilePlaceholderStreamResolver": ["cedcbd91-e5ac-4a58-8bec-f6049ef73c41"],
    "IFilePropSheetPageHelper": ["4169a239-f6cb-4924-99a4-cfada3608308"],
    "IFileProtectionInfo": ["4ee96486-147e-4dd0-8faf-5253ed91ad0c"],
    "IFileProtectionInfo2": ["82123a4c-557a-498d-8e94-944cd5836432"],
    "IFileProtectionManagerStatics": ["5846fc9b-e613-426b-bb38-88cba1dc9adb"],
    "IFileProtectionManagerStatics2": ["83d2a745-0483-41ab-b2d5-bc7f23d74ebb"],
    "IFileProtectionManagerStatics3": ["6918849a-624f-46d6-b241-e9cd5fdf3e3f"],
    "IFileRandomAccessStreamStatics": ["73550107-3b57-4b5d-8345-554d2fc621f0"],
    "IFileSaveDialog": ["84bccd23-5fde-4cdb-aea4-af64b83d78ab"],
    "IFileSaveDialogOld": ["2804b74c-ac16-4398-9dc0-db83f5b7ed14"],
    "IFileSaveDialogPrivate": ["6cb95a6a-88b6-4dc4-b3ea-3a776d1e8eff"],
    "IFileSavePicker": ["3286ffcb-617f-4cc5-af6a-b3fdf29ad145"],
    "IFileSavePicker2": ["0ec313a2-d24b-449a-8197-e89104fd42cc"],
    "IFileSavePicker3": ["698aec69-ba3c-4e51-bd90-4abcbbf4cfaf"],
    "IFileSavePicker4": ["e7d83a5a-ddfa-5de0-8b70-c842c21988ec"],
    "IFileSavePickerActivatedEventArgs": ["81c19cf1-74e6-4387-82eb-bb8fd64b4346"],
    "IFileSavePickerActivatedEventArgs2": ["6b73fe13-2cf2-4d48-8cbc-af67d23f1ce7"],
    "IFileSavePickerContinuationEventArgs": ["2c846fe1-3bad-4f33-8c8b-e46fae824b4b"],
    "IFileSavePickerStatics": ["28e3cf9e-961c-5e2c-aed7-e64737f4ce37"],
    "IFileSavePickerUI": ["9656c1e7-3e56-43cc-8a39-33c73d9d542b"],
    "IFileSettingUnit": ["40de6c67-5063-4ae0-b98e-ce4ab728512b"],
    "IFileSyncMergeHandler": ["d97b5aac-c792-433c-975d-35c4eadc7a9d"],
    "IFileSysFolderMonitor": ["edeefb76-cd88-4f17-acec-5025e85ff066"],
    "IFileSystemBindData2": ["3acf075f-71db-4afa-81f0-3fc4fdf2a5b8"],
    "IFileSystemHandlerCallback": ["e70a2df4-c48b-11e5-adac-0313bb8e7f8b"],
    "IFileSystemHandlerCallback2": ["871cd30c-6e23-4a4f-84af-e7e0446eaed6"],
    "IFileSystemHandlerState": ["8dbf0464-9922-442c-b9ee-d98258142a31"],
    "IFileSystemImage": ["2c941fe1-975b-59be-a960-9a2a262853a5"],
    "IFileSystemImage2": ["d7644b2c-1537-4767-b62f-f1387b02ddfd"],
    "IFileSystemImage3": ["7cff842c-7e97-4807-8304-910dd8f7c051"],
    "IFileSystemImageResult": ["2c941fd8-975b-59be-a960-9a2a262853a5"],
    "IFileSystemImageResult2": ["b507ca29-2204-11dd-966a-001aa01bbc58"],
    "IFileSystemStorage": ["e820910b-1910-404d-afaf-5d7298b9b28d"],
    "IFileUnprotectOptions": ["7d1312f1-3b0d-4dd8-a1f8-1ec53822e2f3"],
    "IFileUnprotectOptionsFactory": ["51aeb39c-da8c-4c3f-9bfb-cb73a7cce0dd"],
    "IFileUpdateRequest": ["40c82536-c1fe-4d93-a792-1e736bc70837"],
    "IFileUpdateRequest2": ["82484648-bdbe-447b-a2ee-7afe6a032a94"],
    "IFileUpdateRequestDeferral": ["ffcedb2b-8ade-44a5-bb00-164c4e72f13a"],
    "IFileUpdateRequestedEventArgs": ["7b0a9342-3905-438d-aaef-78ae265f8dd2"],
    "IFileUpdateResult": ["908075ae-1b69-4112-8126-42aa8074cddc"],
    "IFileUploadCallback": ["d4e43af1-5046-48d3-bde2-0f26b1d20164"],
    "IFileUploader": ["fb73269f-fd3c-4016-8366-ad855ce316d9"],
    "IFileWordlistInitializer": ["8f31dd65-05e8-4851-860e-755aff566516"],
    "IFillInfo": ["de2eacd0-9c9d-11cf-882a-00aa00b569f5"],
    "IFillPropertiesCallback": ["c9d22189-49c4-4ae5-b107-b0ce8312cdd3"],
    "IFilterChain": ["dcfbdcf6-0dc2-45f5-9ab2-7c330ea09c29"],
    "IFilterCondition": ["fca2857d-1760-4ad3-8c63-c9b602fcbaea"],
    "IFilterGraph3": ["aaf38154-b80b-422f-91e6-b66467509a07"],
    "IFilterHost": ["4f5385f1-f9a8-4536-9920-93e8d144dbd0"],
    "IFilterKeyMap": ["ca169652-07c6-4708-a3da-6e4eba8d2297"],
    "IFilterMapper3": ["b79bb0b1-33c1-11d1-abe1-00a0c905f375"],
    "IFilterProperties": ["aade1f59-6ace-43d1-8fca-42af3a5c4f3c"],
    "IFilterRequestCallback": ["82df8873-6360-463a-a8a1-ede5e1a1594d"],
    "IFilterSupport": ["0ae9278d-bae7-41d1-b555-60e8d4196bee"],
    "IFilterTrackingProvider": ["743383c0-fc4e-45ba-ad81-d9d84c7a24f8"],
    "IFilterTrackingRequestCallback": ["713ca7bb-c858-4674-b4b6-1122436587a9"],
    "IFilterTrackingSyncChangeBuilder": ["295024a0-70da-4c58-883c-ce2afb308d0b"],
    "IFilterView": ["a5da0c32-4f6c-4aaa-a6bc-a7c1fe27a059"],
    "IFilteredItemFactory": ["a4cbb5d1-b912-4bf6-a96b-b02855169492"],
    "IFind": ["000c0337-0000-0000-c000-000000000046"],
    "IFindAllAccountsResult": ["a5812b5d-b72e-420c-86ab-aac0d7b7261f"],
    "IFindAppointmentsOptions": ["55f7dc55-9942-3086-82b5-2cb29f64d5f5"],
    "IFindCompressorCB": ["f03fa8de-879a-4d59-9b2c-26bb1cf83461"],
    "IFindEngine": ["ba8f5842-e7e9-4563-86e2-bc3c43f8631f"],
    "IFindEngineCallback": ["90c7af4d-953e-438c-9af4-8977780187ec"],
    "IFindInDocument": ["4fd0599e-fcc0-4fb1-aced-6b6773199268"],
    "IFindInDocumentEvents": ["30217f3c-e8fa-416b-aba6-bf0bd3b79321"],
    "IFindNetPrinters": ["3741a885-71b8-49b4-8303-3eab8628ff8a"],
    "IFindNetPrintersCallback": ["0075f3ea-ad58-4860-ac5b-302d9334a294"],
    "IFindNextElementOptions": ["d88ae22b-46c2-41fc-897e-b5961977b89d"],
    "IFindPrinter": ["b4cd8efc-d70b-11d1-99b1-080036af3f03"],
    "IFindReferenceTargetsCallback": ["04b3486c-4687-4229-8d14-505ab584dd88"],
    "IFingerprintSettingsHandler": ["349939ac-c9dd-4d96-a299-c019379de564"],
    "IFirstLogonSync": ["775bb368-c3bb-457d-9d85-6f458f6733f8"],
    "IFirstSignInSettings": ["3e945153-3a5e-452e-a601-f5baad2a4870"],
    "IFirstSignInSettingsStatics": ["1ce18f0f-1c41-4ea0-b7a2-6f0c1c7e8438"],
    "IFixedDocument": ["f222ca9f-9968-4db9-81bd-abaebf15f93f"],
    "IFixedDocumentSequence": ["8028d181-2c32-4249-8493-1bfb22045574"],
    "IFixedPage": ["3d9f6448-7e95-4cb5-94fb-0180c2883a57"],
    "IFlashControl": ["def41dbe-7d68-45e3-8c0f-be7bb32837d0"],
    "IFlashControl2": ["7d29cc9e-75e1-4af7-bd7d-4e38e1c06cd6"],
    "IFlexibleTaskbarPinnedList": ["60274fa2-611f-4b8a-a293-f27bf103d148"],
    "IFlightSettingsAPIBroker": ["e833feb2-c58a-45e4-8d93-08874744febb"],
    "IFlightSettingsActionManager": ["1f8c32cf-794f-4c50-ad67-0009b4f999d4"],
    "IFlightSettingsValidator": ["4d7498f1-5096-45e6-9b1c-56037baf6f1e"],
    "IFlightSettingsWriter": ["4ab30937-1c1f-4ffd-b66f-b3cf3d092bd6"],
    "IFlightStick": ["b4a2c01c-b83b-4459-a1a9-97b03c33da7c"],
    "IFlightStickStatics": ["5514924a-fecc-435e-83dc-5cec8a18a520"],
    "IFlightingRing": ["960da761-e98a-4e7a-8497-52d03466318b"],
    "IFlipView": ["a1582f68-3d7d-4d3b-b71d-488eed1e3493"],
    "IFlipView2": ["c4fea4fd-7af3-4952-9fd9-9e0987fc4f29"],
    "IFlipViewAutomationPeer": ["8ec0353a-4284-4b00-aef8-a2688ea5e3c4"],
    "IFlipViewAutomationPeerFactory": ["4395ab0d-8d83-483c-88eb-e2617b0d293f"],
    "IFlipViewFactory": ["f1dea9be-9ae8-4d4b-ab43-16d31e05f4f3"],
    "IFlipViewItem": ["56196565-ce2b-4bda-a36b-82a2b8b0d4c0"],
    "IFlipViewItemAutomationPeer": ["c83034de-fa08-4bd3-aeb2-d2e5bfa04df9"],
    "IFlipViewItemAutomationPeerFactory": ["69109356-d0e5-4c10-a09c-ad0bf1b0cb01"],
    "IFlipViewItemDataAutomationPeer": ["b0986175-00bc-4118-8a6f-16ee9c15d968"],
    "IFlipViewItemDataAutomationPeerFactory": ["3c864393-0aea-4e78-bc11-b775cac4114c"],
    "IFlipViewItemFactory": ["f21d91fe-22a0-4412-a853-9d6a6e8f2aaf"],
    "IFlipViewStatics2": ["70e3d93f-4308-4ba2-bbce-e2cb0ed34476"],
    "IFlyout": ["6584ebdf-cbc7-4e19-843a-a14f24a793ea"],
    "IFlyoutBase": ["723eea0b-d12e-430d-a9f0-9bb32bbf9913"],
    "IFlyoutBase2": ["f82b435e-65b3-41c6-a9e2-77b67bc4c00c"],
    "IFlyoutBase3": ["a89c9712-48e0-4240-95b9-0dfd0826a8d3"],
    "IFlyoutBase4": ["e3897d69-a37f-4828-9b70-0ef67c03b5f8"],
    "IFlyoutBase5": ["ad3ec0c7-12bb-5a73-b78e-105192ca73d6"],
    "IFlyoutBase6": ["5399de8c-06cc-5b52-b65a-ff9322d1c940"],
    "IFlyoutBaseClosingEventArgs": ["d075852d-b09a-4fd1-b005-db2ba01206fb"],
    "IFlyoutBaseFactory": ["1c3363d7-fca7-407e-920e-70e15e9f0bf1"],
    "IFlyoutBaseOverrides": ["101dec86-6f4d-45a4-9d0e-3ece6f16977e"],
    "IFlyoutBaseOverrides4": ["a6bfd04d-5ff3-4418-add8-4042a88d2da5"],
    "IFlyoutBaseStatics": ["e2d795e3-85c0-4de2-bac1-5294ca011a78"],
    "IFlyoutBaseStatics2": ["a8e913fe-2d60-4307-aad9-56b450121b58"],
    "IFlyoutBaseStatics3": ["7ba92e4f-dd16-4be4-99db-bd9d4406c0f8"],
    "IFlyoutBaseStatics5": ["69edb25c-992a-542b-bcff-2f7f855523bd"],
    "IFlyoutBaseStatics6": ["96d49254-c91b-5246-8b39-afc2a2c50cf8"],
    "IFlyoutFactory": ["4bed4933-008e-4b03-a385-79fe5266ddba"],
    "IFlyoutPresenter": ["827d5b79-e37b-46a5-8d44-63a11a580e83"],
    "IFlyoutPresenter2": ["4f857e92-36b4-5048-9051-a992b43e8a1d"],
    "IFlyoutPresenterAutomationPeer": ["a01840b4-5fca-456f-98ea-300eb40b585e"],
    "IFlyoutPresenterAutomationPeerFactory": ["f350155f-8924-44c0-ba44-653fe79f1efb"],
    "IFlyoutPresenterFactory": ["ee4d668f-da76-469a-acd7-3060e613ade7"],
    "IFlyoutPresenterStatics2": ["1492ae4b-2727-5e8e-9105-6d7a2b1185b2"],
    "IFlyoutShowOptions": ["57d693ad-0c74-54dd-b110-1ee43fabadd9"],
    "IFlyoutShowOptionsFactory": ["ce596f61-2eb4-5b4e-af69-f9af42320eee"],
    "IFlyoutStatics": ["61364e0b-db75-47e1-b2c3-5b901c3d74b6"],
    "IFocusContainer": ["76b463ec-dde4-48ea-b9dd-1b2b13487928"],
    "IFocusControl": ["c0d889f6-5228-4453-b153-85606592b238"],
    "IFocusControl2": ["3f7cff48-c534-4e9e-94c3-52ef2afd5d07"],
    "IFocusDisengagedEventArgs": ["5e14280f-953e-4cf8-b9ea-c530a1ce02ad"],
    "IFocusEngagedEventArgs": ["a69fc352-da66-404c-823f-5358594e70bb"],
    "IFocusEngagedEventArgs2": ["4a59e0f4-87c0-4ccd-93c4-a3a01ce39265"],
    "IFocusManager": ["c843f50b-3b83-4da1-9d6f-557c1169f341"],
    "IFocusManagerGotFocusEventArgs": ["97aa5d83-535b-507a-868e-62b706f06b61"],
    "IFocusManagerLostFocusEventArgs": ["3e157e7a-9578-5cd3-aaa8-051b3d391978"],
    "IFocusManagerStatics": ["1eccd326-8182-4482-826a-0918e9ed9af7"],
    "IFocusManagerStatics2": ["a920d761-dd87-4f31-beda-ef417fe7c04a"],
    "IFocusManagerStatics3": ["60805ebf-b149-417d-83f1-baeb560e2a47"],
    "IFocusManagerStatics4": ["29276e9c-1c6c-414a-ba1c-96efd5962bcd"],
    "IFocusManagerStatics5": ["280edc61-207a-4d7b-b98f-ce165e1b2015"],
    "IFocusManagerStatics6": ["3546a1b6-20bf-5007-929d-e6d32e16afe4"],
    "IFocusManagerStatics7": ["95d6fa97-f0fc-5c32-b29d-07c04ec966b0"],
    "IFocusMovementResult": ["06dfead3-c2ae-44bb-bfab-9c73de8407a4"],
    "IFocusSettings": ["79958f6b-3263-4275-85d6-aeae891c96ee"],
    "IFolderAction": ["03837543-098b-11d8-9414-505054503030"],
    "IFolderActionCollection": ["03837544-098b-11d8-9414-505054503030"],
    "IFolderLauncherOptions": ["bb91c27d-6b87-432a-bd04-776c6f5fb2ab"],
    "IFolderPicker": ["084f7799-f3fb-400a-99b1-7b4a772fd60d"],
    "IFolderPicker2": ["8eb3ba97-dc85-4616-be94-9660881f2f5d"],
    "IFolderPicker3": ["673b1e29-d326-53c0-bd24-a25c714cee36"],
    "IFolderPickerContinuationEventArgs": ["51882366-9f4b-498f-beb0-42684f6e1c29"],
    "IFolderPickerStatics": ["9be34740-7ca1-5942-a3c8-46f2551ecff3"],
    "IFolderType": ["053b4a86-0dc9-40a3-b7ed-bc6a2e951f48"],
    "IFolderTypeDescription": ["e2ba9629-b18f-4e3a-aba5-42d879e79c80"],
    "IFolderTypeModifier": ["04ba120e-ad52-4a2d-9807-2da178d0c3e1"],
    "IFolderView2": ["1af3a467-214f-4298-908e-06b03e0b39f9"],
    "IFolderViewOptions": ["3cc974d2-b302-4d36-ad3e-06d93f695d3f"],
    "IFolderViewSettings": ["ae8c987d-8797-4ed3-be72-2a47dd938db0"],
    "IFolderWithGrepConfiguration": ["2a2407e5-1c5a-4836-a9fe-717590eb940d"],
    "IFolderWithNavigationOptions": ["d95a2970-4f52-4ee2-a438-4f1ad881f19f"],
    "IFolderWithSearchRoot": ["dc0ac42a-141e-4876-9c43-824829440de0"],
    "IFontFamily": ["92467e64-d66a-4cf4-9322-3d23b3c0c361"],
    "IFontFamilyFactory": ["d5603377-3dae-4dcd-af09-f9498e9ec659"],
    "IFontFamilyStatics2": ["52ad7af9-37e6-4297-a238-97fb6a408d9e"],
    "IFontIcon": ["d4d61391-39ac-4950-9166-3606c264418b"],
    "IFontIcon2": ["f6ebd84d-37e8-46ee-a574-41ad550482e0"],
    "IFontIcon3": ["6155d919-1c6c-4950-8794-231ef0914d94"],
    "IFontIconFactory": ["1c781b6b-37bf-4ddc-a1a8-1b77db3cf0ea"],
    "IFontIconSource": ["2211ac9a-74e3-43ed-b61c-21afc7df4d10"],
    "IFontIconSourceFactory": ["8bdcf6bd-fc06-42b8-b30b-7505082ac38f"],
    "IFontIconSourceStatics": ["8c0e422f-8269-43b1-b95a-ef070e86770d"],
    "IFontIconStatics": ["b3be7bf6-1467-4086-bbcb-4e21d97a7b4d"],
    "IFontIconStatics2": ["e6080672-08f8-43d3-8790-4604290cbebd"],
    "IFontIconStatics3": ["a4528b17-b084-4bd5-aab4-feae9d3b5d26"],
    "IFontManager": ["935ad8eb-cbf8-4fd3-8f4f-385f55258f2e"],
    "IFontManagerEvents": ["5cea2cc7-c557-480c-b44d-04172e801c7f"],
    "IFontWeights": ["7880a444-01ab-4997-8517-df822a0c45f1"],
    "IFontWeightsStatics": ["b3b579d5-1ba9-48eb-9dad-c095e8c23ba3"],
    "IForceFeedbackEffect": ["a17fba0c-2ae4-48c2-8063-eabd0777cb89"],
    "IForceFeedbackMotor": ["8d3d417c-a5ea-4516-8026-2b00f74ef6e5"],
    "IForegroundAppChangeHandler": ["21ecba5d-00f0-4ac3-974e-c0de9d935707"],
    "IForegroundAppChangeNotification": ["9c892ffb-ae7e-4e5e-af1c-9c9b74749af7"],
    "IForegroundManagerBackgroundPolicy": ["402d0f67-cd0a-4a7a-849b-068515b93866"],
    "IForegroundManagerCustomResourcePolicy": ["40a605fd-e2e5-4519-9858-c712826167b6"],
    "IForegroundManagerInternal": ["5c4e89bf-7ddc-414a-8f9a-48bd131be991"],
    "IForgottenKnowledge": ["456e0f96-6036-452b-9f9d-bcc4b4a85db2"],
    "IFormatDetectionDumper": ["3051085d-98b5-11cf-bb82-00aa00bdce0b"],
    "IFormatEngine": ["fe70304f-2b7e-4ee7-bd89-1ca62e049282"],
    "IFormatForDisplayHelper": ["679ca263-b06d-40ee-bc2f-0dd3aacecc52"],
    "IFoundFiles": ["000c0338-0000-0000-c000-000000000046"],
    "IFrame2": ["3f367f87-9f5a-4b04-b818-b554c069597a"],
    "IFrame3": ["648a2b4d-53ca-4b5a-aa8e-3cc7440f4a67"],
    "IFrame4": ["9b17c21a-bd2b-4a00-99eb-946be9618084"],
    "IFrame5": ["453fb92e-82b5-5f93-92ab-15341806c9da"],
    "IFrameControlCapabilities": ["a8ffae60-4e9e-4377-a789-e24c4ae7e544"],
    "IFrameControlCapabilities2": ["ce9b0464-4730-440f-bd3e-efe8a8f230a8"],
    "IFrameController": ["c16459d9-baef-4052-9177-48aff2af7522"],
    "IFrameController2": ["00d3bc75-d87c-485b-8a09-5c358568b427"],
    "IFrameExposureCapabilities": ["bdbe9ce3-3985-4e72-97c2-0590d61307a1"],
    "IFrameExposureCompensationCapabilities": ["b988a823-8065-41ee-b04f-722265954500"],
    "IFrameExposureCompensationControl": ["e95896c9-f7f9-48ca-8591-a26531cb1578"],
    "IFrameExposureControl": ["b1605a61-ffaf-4752-b621-f5b6f117f432"],
    "IFrameFactory": ["02ee93d4-448e-469e-9799-0a8a1f70f171"],
    "IFrameFlashCapabilities": ["bb9341a2-5ebe-4f62-8223-0e2b05bfbbd0"],
    "IFrameFlashControl": ["75d5f6c7-bd45-4fab-9375-45ac04b332c2"],
    "IFrameFocusCapabilities": ["7b25cd58-01c0-4065-9c40-c1a721425c1a"],
    "IFrameFocusControl": ["272df1d0-d912-4214-a67b-e38a8d48d8c6"],
    "IFrameFocusHost": ["e571e20c-0490-4284-a6f9-64db48921ff5"],
    "IFrameHTMLWindowServices": ["01fe3c16-443d-45e6-b793-d61f1a032065"],
    "IFrameInputNodeQuantumStartedEventArgs": ["3d9bd498-a306-4f06-bd9f-e9efc8226304"],
    "IFrameIsoSpeedCapabilities": ["16bdff61-6df6-4ac9-b92a-9f6ecd1ad2fa"],
    "IFrameIsoSpeedControl": ["1a03efed-786a-4c75-a557-7ab9a85f588c"],
    "IFrameLayoutDefinition": ["176c11b1-4302-4164-8430-d5a9f0eeacdb"],
    "IFrameLayoutDefinitionFactory": ["7e734121-f3b4-45f9-ad43-2fbe39e533e2"],
    "IFrameManager": ["31e4fa78-02b4-419f-9430-7b7585237c77"],
    "IFrameModule": ["60ce96bb-b6f9-42dc-b84e-5e5d9c370a6f"],
    "IFrameNavigationOptions": ["b539ad2a-9fb7-520a-8f41-57a50c59cf92"],
    "IFrameNavigationOptionsFactory": ["d4681e41-7e6d-5c7c-aca0-478681cc6fce"],
    "IFrameNotificationClient": ["1d3293bc-ec01-400f-8179-8de5d53abeb7"],
    "IFrameShellViewClient": ["6b353825-c58b-4f03-aec4-8de179122661"],
    "IFrameStatics": ["d5acf0e9-d967-471b-8459-c8af4341511b"],
    "IFrameStatics2": ["e4b5cdfe-42f0-4462-a1c1-5d259dd82a03"],
    "IFrameStatics5": ["53c89b25-f0e0-58f1-a06d-441075914ff8"],
    "IFrameTaskManager": ["35bd3360-1b35-4927-bae4-b10e70d99eff"],
    "IFrameWorkItem": ["7c32fa17-30a4-42d5-b7da-ffe8fcfcce45"],
    "IFrameworkElement": ["a391d09b-4a99-4b7c-9d8d-6fa5d01f6fbf"],
    "IFrameworkElement2": ["f19104be-422a-4904-a52f-ee72010429e5"],
    "IFrameworkElement3": ["c81c2720-5c52-4bbe-a199-2b1e34f00f70"],
    "IFrameworkElement4": ["6b765bb3-fba3-4404-bdee-1a45d1ca5f21"],
    "IFrameworkElement6": ["792a5d91-62a1-40bf-a0ce-f9c131fcb7a7"],
    "IFrameworkElement7": ["2263886c-c069-570f-b9cc-9e21dd028d8e"],
    "IFrameworkElementAutomationPeer": ["b90ad781-bfeb-4451-bd47-9f3a63ebd24a"],
    "IFrameworkElementAutomationPeerFactory": ["0db9b8bc-b812-48e3-af1f-dbc57600c325"],
    "IFrameworkElementAutomationPeerStatics": ["b9c0b997-2820-44a1-a5a8-9b801edc269e"],
    "IFrameworkElementFactory": ["deaee126-03ca-4966-b576-604cce93b5e8"],
    "IFrameworkElementOverrides": ["da007e54-b3c2-4b9a-aa8e-d3f071262b97"],
    "IFrameworkElementOverrides2": ["cb5cd2b9-e3b4-458c-b64e-1434fd1bd88a"],
    "IFrameworkElementProtected7": ["65aa0480-22e3-5103-ad2a-b626f88ca5ae"],
    "IFrameworkElementStatics": ["48383032-fbeb-4f8a-aed2-ee21fb27a57b"],
    "IFrameworkElementStatics2": ["9695db02-c0d8-4fa2-b100-3fa2df8b9538"],
    "IFrameworkElementStatics4": ["9c41b155-c5d8-4663-bff2-d8d54fb5dbb3"],
    "IFrameworkElementStatics5": ["525d3941-0b3c-4be6-9978-19a8025c09d8"],
    "IFrameworkElementStatics6": ["fcc1529a-69db-4582-a7be-cf6a1cfdacd0"],
    "IFrameworkInputPane": ["5752238b-24f0-495a-82f1-2fd593056796"],
    "IFrameworkInputPaneHandler": ["226c537b-1e76-4d9e-a760-33db29922f18"],
    "IFrameworkInputPanePriv": ["8d358a3b-c719-4c70-ad58-6efe8c58bd9d"],
    "IFrameworkTemplate": ["a1e254d8-a446-4a27-9a9d-a0f59e1258a5"],
    "IFrameworkTemplateFactory": ["1a78a0a5-937d-46d4-832b-94ff14dab061"],
    "IFrameworkView": ["ddba664b-b603-47aa-942d-3833174f0d80", "faab5cd0-8924-45ac-ad0f-a08fae5d0324"],
    "IFrameworkViewSource": ["cd770614-65c4-426c-9494-34fc43554862", "e3b077da-35ad-4b09-b5b2-27420041ba9f"],
    "IFreeThreadedComWrapper": ["394ab223-9fc6-4893-8943-9f6c70d51891"],
    "IFreeThreadedItemContainer": ["0c904b4a-164a-4d81-92d9-a5fc866f7fb8"],
    "IFrequencyMap": ["06fb45c1-693c-4ea7-b79f-7a6a54d8def2"],
    "IFsiDirectoryItem": ["2c941fdc-975b-59be-a960-9a2a262853a5"],
    "IFsiDirectoryItem2": ["f7fb4b9b-6d96-4d7b-9115-201b144811ef"],
    "IFsiFileItem": ["2c941fdb-975b-59be-a960-9a2a262853a5"],
    "IFsiFileItem2": ["199d0c19-11e1-40eb-8ec2-c8c822a07792"],
    "IFsiItem": ["2c941fd9-975b-59be-a960-9a2a262853a5"],
    "IFsiNamedStreams": ["ed79ba56-5294-4250-8d46-f9aecee23459"],
    "IFsrmAccessDeniedRemediationClient": ["40002314-590b-45a5-8e1b-8c05da527e52"],
    "IFsrmAction": ["6cd6408a-ae60-463b-9ef1-e117534d69dc"],
    "IFsrmActionCommand": ["12937789-e247-4917-9c20-f3ee9c7ee783"],
    "IFsrmActionEmail": ["d646567d-26ae-4caa-9f84-4e0aad207fca"],
    "IFsrmActionEmail2": ["8276702f-2532-4839-89bf-4872609a2ea4"],
    "IFsrmActionEventLog": ["4c8f96c3-5d94-4f37-a4f4-f56ab463546f"],
    "IFsrmActionReport": ["2dbe63c4-b340-48a0-a5b0-158e07fc567e"],
    "IFsrmAutoApplyQuota": ["f82e5729-6aba-4740-bfc7-c7f58f75fb7b"],
    "IFsrmClassificationManager": ["d2dc89da-ee91-48a0-85d8-cc72a56f7d04"],
    "IFsrmClassificationManager2": ["0004c1c9-127e-4765-ba07-6a3147bca112"],
    "IFsrmClassificationRule": ["afc052c2-5315-45ab-841b-c6db0e120148"],
    "IFsrmClassifierModuleDefinition": ["bb36ea26-6318-4b8c-8592-f72dd602e7a5"],
    "IFsrmClassifierModuleImplementation": ["4c968fc6-6edb-4051-9c18-73b7291ae106"],
    "IFsrmCollection": ["f76fbf3b-8ddd-4b42-b05a-cb1c3ff1fee8"],
    "IFsrmCommittableCollection": ["96deb3b5-8b91-4a2a-9d93-80a35d8aa847"],
    "IFsrmDerivedObjectsResult": ["39322a2d-38ee-4d0d-8095-421a80849a82"],
    "IFsrmExportImport": ["efcb0ab1-16c4-4a79-812c-725614c3306b"],
    "IFsrmFileCondition": ["70684ffc-691a-4a1a-b922-97752e138cc1"],
    "IFsrmFileConditionProperty": ["81926775-b981-4479-988f-da171d627360"],
    "IFsrmFileGroup": ["8dd04909-0e34-4d55-afaa-89e1f1a1bbb9"],
    "IFsrmFileGroupImported": ["ad55f10b-5f11-4be7-94ef-d9ee2e470ded"],
    "IFsrmFileGroupManager": ["426677d5-018c-485c-8a51-20b86d00bdc4"],
    "IFsrmFileManagementJob": ["0770687e-9f36-4d6f-8778-599d188461c9"],
    "IFsrmFileManagementJobManager": ["ee321ecb-d95e-48e9-907c-c7685a013235"],
    "IFsrmFileScreen": ["5f6325d3-ce88-4733-84c1-2d6aefc5ea07"],
    "IFsrmFileScreenBase": ["f3637e80-5b22-4a2b-a637-bbb642b41cfc"],
    "IFsrmFileScreenException": ["bee7ce02-df77-4515-9389-78f01c5afc1a"],
    "IFsrmFileScreenManager": ["ff4fa04e-5a94-4bda-a3a0-d5b4d3c52eba"],
    "IFsrmFileScreenTemplate": ["205bebf8-dd93-452a-95a6-32b566b35828"],
    "IFsrmFileScreenTemplateImported": ["e1010359-3e5d-4ecd-9fe4-ef48622fdf30"],
    "IFsrmFileScreenTemplateManager": ["cfe36cba-1949-4e74-a14f-f1d580ceaf13"],
    "IFsrmMutableCollection": ["1bb617b8-3886-49dc-af82-a6c90fa35dda"],
    "IFsrmObject": ["22bcef93-4a3f-4183-89f9-2f8b8a628aee"],
    "IFsrmPathMapper": ["6f4dbfff-6920-4821-a6c3-b7e94c1fd60c"],
    "IFsrmPipelineModuleConnector": ["c16014f3-9aa1-46b3-b0a7-ab146eb205f2"],
    "IFsrmPipelineModuleDefinition": ["515c1277-2c81-440e-8fcf-367921ed4f59"],
    "IFsrmPipelineModuleImplementation": ["b7907906-2b02-4cb5-84a9-fdf54613d6cd"],
    "IFsrmProperty": ["4a73fee4-4102-4fcc-9ffb-38614f9ee768"],
    "IFsrmPropertyBag": ["774589d1-d300-4f7a-9a24-f7b766800250"],
    "IFsrmPropertyBag2": ["0e46bdbd-2402-4fed-9c30-9266e6eb2cc9"],
    "IFsrmPropertyCondition": ["326af66f-2ac0-4f68-bf8c-4759f054fa29"],
    "IFsrmPropertyDefinition": ["ede0150f-e9a3-419c-877c-01fe5d24c5d3"],
    "IFsrmPropertyDefinition2": ["47782152-d16c-4229-b4e1-0ddfe308b9f6"],
    "IFsrmPropertyDefinitionValue": ["e946d148-bd67-4178-8e22-1c44925ed710"],
    "IFsrmQuota": ["377f739d-9647-4b8e-97d2-5ffce6d759cd"],
    "IFsrmQuotaBase": ["1568a795-3924-4118-b74b-68d8f0fa5daf"],
    "IFsrmQuotaManager": ["8bb68c7d-19d8-4ffb-809e-be4fc1734014"],
    "IFsrmQuotaManagerEx": ["4846cb01-d430-494f-abb4-b1054999fb09"],
    "IFsrmQuotaObject": ["42dc3511-61d5-48ae-b6dc-59fc00c0a8d6"],
    "IFsrmQuotaTemplate": ["a2efab31-295e-46bb-b976-e86d58b52e8b"],
    "IFsrmQuotaTemplateImported": ["9a2bf113-a329-44cc-809a-5c00fce8da40"],
    "IFsrmQuotaTemplateManager": ["4173ac41-172d-4d52-963c-fdc7e415f717"],
    "IFsrmReport": ["d8cc81d9-46b8-4fa4-bfa5-4aa9dec9b638"],
    "IFsrmReportJob": ["38e87280-715c-4c7d-a280-ea1651a19fef"],
    "IFsrmReportManager": ["27b899fe-6ffa-4481-a184-d3daade8a02b"],
    "IFsrmReportScheduler": ["6879caf9-6617-4484-8719-71c3d8645f94"],
    "IFsrmRule": ["cb0df960-16f5-4495-9079-3f9360d831df"],
    "IFsrmSetting": ["f411d4fd-14be-4260-8c40-03b7c95e608a"],
    "IFsrmStorageModuleDefinition": ["15a81350-497d-4aba-80e9-d4dbcc5521fe"],
    "IFsrmStorageModuleImplementation": ["0af4a0da-895a-4e50-8712-a96724bcec64"],
    "IFtpAuthenticationProvider": ["4659f95c-d5a8-4707-b2fc-6fd5794246cf"],
    "IFtpAuthorizationProvider": ["a50ae7a1-a35a-42b4-a4f3-f4f7057a05d1"],
    "IFtpHomeDirectoryProvider": ["0933b392-18dd-4097-8b9c-83325c35d9a6"],
    "IFtpLogProvider": ["a18a94cc-8299-4408-816c-7c3baca1a40e"],
    "IFtpPostprocessProvider": ["4522cbc6-16cd-49ad-8653-9a2c579e4280"],
    "IFtpPreprocessProvider": ["a3c19b60-5a28-471a-8f93-ab30411cee82"],
    "IFtpProviderConstruct": ["4d1a3f7b-412d-447c-b199-64f967e9a2da"],
    "IFtpRoleProvider": ["909c850d-8ca0-4674-96b8-cc2941535725"],
    "IFullContactCardOptions": ["8744436c-5cf9-4683-bdca-a1fdebf8dbce"],
    "IFullScreenBroker": ["796be4b3-0fb1-415d-9984-0bc8b72e5fa2"],
    "IFullScreenManager": ["f0093591-bfa3-471f-b9f0-f17f8a979c6d"],
    "IFullScreenNotification": ["7adc3cb7-307a-4f32-b2c6-c007ee409fd0"],
    "IFullScreenPositioner": ["88ed940d-d632-4b84-9529-a3110b5af527"],
    "IFullScreenPositionerNotification": ["fe917f8f-4e14-41a5-83ba-a9f9de203a07"],
    "IFullScreenPositionerPrivateNotification": ["c0d2dfdf-8b97-41f6-9f0c-13247f43abb8"],
    "IFullScreenPresentationConfiguration": ["43d3dcd8-d2a8-503d-a626-15533d6d5f62"],
    "IFullTrustProcessLauncherStatics": ["d784837f-1100-3c6b-a455-f6262cc331b6"],
    "IFunctionDiscovery": ["4df99b70-e148-4432-b004-4c9eeb535a5e"],
    "IFunctionDiscoveryNotification": ["5f6c1ba8-5330-422e-a368-572b244d3f87"],
    "IFunctionDiscoveryProvider": ["dcde394f-1478-4813-a402-f6fb10657222"],
    "IFunctionDiscoveryProviderFactory": ["86443ff0-1ad5-4e68-a45a-40c2c329de3b"],
    "IFunctionDiscoveryProviderQuery": ["6876ea98-baec-46db-bc20-75a76e267a3a"],
    "IFunctionDiscoveryProviderRefresh": ["fab03726-1da1-4ba5-aff1-d26e20e7f2f8"],
    "IFunctionDiscoveryServiceProvider": ["4c81ed02-1b04-43f2-a451-69966cbcd1c2"],
    "IFunctionInstance": ["33591c10-0bed-4f02-b0ab-1530d5533ee9"],
    "IFunctionInstanceCollection": ["f0a3d895-855c-42a2-948d-2f97d450ecb1"],
    "IFunctionInstanceCollectionQuery": ["57cc6fd2-c09a-4289-bb72-25f04142058e"],
    "IFunctionInstanceCollectionQuery2": ["24de490a-2fec-4ed0-8aa2-2cfe8c71643b"],
    "IFunctionInstanceCollectionQueryCollection": ["b3330569-bb2a-4766-8972-bbfb4f9db684"],
    "IFunctionInstanceQuery": ["6242bc6b-90ec-4b37-bb46-e229fd84ed95"],
    "IFunctionInstanceQuery2": ["766ed696-6f98-419b-8624-281f686e1d05"],
    "IGCHost2": ["a1d70cec-2dbe-4e2f-9291-fdf81438a1df"],
    "IGCHostControl": ["5513d564-8374-4cb9-aed9-0083f4160a1d"],
    "IGCThreadControl": ["f31d1788-c397-4725-87a5-6af3472c2791"],
    "IGITCookieProvider": ["61543de8-8d55-421e-8bed-99751e938bcc"],
    "IGPEInformation": ["8fc0b735-a0e1-11d1-a7d3-0000f87571e3"],
    "IGPM2": ["00238f8a-3d86-41ac-8f5e-06a6638a634a"],
    "IGPMBackupDirEx": ["f8dc55ed-3ba0-4864-aad4-d365189ee1d5"],
    "IGPMConstants2": ["05ae21b0-ac09-4032-a26f-9e7da786dc19"],
    "IGPMDomain2": ["7ca6bb8b-f1eb-490a-938d-3c4e51c768e6"],
    "IGPMDomain3": ["0077fdfe-88c7-4acf-a11d-d10a7c310a03"],
    "IGPMGPO2": ["8a66a210-b78b-4d99-88e2-c306a817c925"],
    "IGPMGPO3": ["7cf123a1-f94a-4112-bfae-6aa1db9cb248"],
    "IGPMStarterGPO": ["dfc3f61b-8880-4490-9337-d29c7ba8c2f0"],
    "IGPMStarterGPOBackup": ["51d98eda-a87e-43dd-b80a-0b66ef1938d6"],
    "IGPMStarterGPOBackupCollection": ["c998031d-add0-4bb5-8dea-298505d8423b"],
    "IGPMStarterGPOCollection": ["2e522729-2219-44ad-933a-64dfd650c423"],
    "IGPUPMitigationDevice": ["d6f70a58-e039-42b3-96db-efe033bc2eac"],
    "IGPUPVDev": ["0f4ddc9b-d683-46fb-a7e9-935dfe0b617f"],
    "IGameBarServices": ["2dbead57-50a6-499e-8c6c-d330a7311796"],
    "IGameBarServicesCommandEventArgs": ["a74226b2-f176-4fcf-8fbb-cf698b2eb8e0"],
    "IGameBarServicesManager": ["3a4b9cfa-7f8b-4c60-9dbb-0bcd262dffc6"],
    "IGameBarServicesManagerGameBarServicesCreatedEventArgs": ["ededbd9c-143e-49a3-a5ea-0b1995c8d46e"],
    "IGameBarServicesManagerStatics": ["34c1b616-ff25-4792-98f2-d3753f15ac13"],
    "IGameBarServicesTargetInfo": ["b4202f92-1611-4e05-b6ef-dfd737ae33b0"],
    "IGameBarStatics": ["1db9a292-cc78-4173-be45-b61e67283ea7"],
    "IGameChatMessageReceivedEventArgs": ["a28201f1-3fb9-4e42-a403-7afce2023b1e"],
    "IGameChatOverlay": ["fbc64865-f6fc-4a48-ae07-03ac6ed43704"],
    "IGameChatOverlayMessageSource": ["1e177397-59fb-4f4f-8e9a-80acf817743c"],
    "IGameChatOverlayStatics": ["89acf614-7867-49f7-9687-25d9dbf444d1"],
    "IGameCollection": ["620978e0-1288-48e8-94af-9ee9afe81512"],
    "IGameCompanyInfo": ["f6eae7d9-4e28-440b-8f53-f45e91578069"],
    "IGameCompanyInfoCollection": ["8b434050-b341-4a0c-a7b3-57175d2393a3"],
    "IGameController": ["1baf6522-5f64-42c5-8267-b9fe2215bfbd"],
    "IGameControllerBatteryInfo": ["dcecc681-3963-4da6-955d-553f3b6f6161"],
    "IGameControllerFactoryManagerStatics": ["36cb66e3-d0a1-4986-a24c-40b137deba9e"],
    "IGameControllerFactoryManagerStatics2": ["eace5644-19df-4115-b32a-2793e2aea3bb"],
    "IGameControllerInputSink": ["1ff6f922-c640-4c78-a820-9a715c558bcb"],
    "IGameControllerProvider": ["e6d73982-2996-4559-b16c-3e57d46e58d6"],
    "IGameControllerProviderInfoStatics": ["0be1e6c5-d9bd-44ee-8362-488b2e464bfb"],
    "IGameDescription": ["3814a6d4-60ac-4dba-9159-9bfc2ba18ca4"],
    "IGameDescriptionRating": ["4edae929-1ed1-471e-8731-20bd177dcc2b"],
    "IGameExplorer": ["e7b2fb72-d728-49b3-a5f2-18ebf5f1349e"],
    "IGameExplorer2": ["86874aa7-a1ed-450d-a7eb-b89e20b2fff3"],
    "IGameExplorerPrivate": ["e0a5897f-2381-4b2f-a38c-1ea964d1a58b"],
    "IGameListChangedEventHandler": ["25f6a421-d8f5-4d91-b40e-53d5e86fde64"],
    "IGameListEntry": ["735924d3-811f-4494-b69c-c641a0c61543"],
    "IGameListEntry2": ["d84a8f8b-8749-4a25-90d3-f6c5a427886d"],
    "IGameListRemovedEventHandler": ["10c5648f-6c8f-4712-9b38-474bc22e76d8"],
    "IGameListStatics": ["2ddd0f6f-9c66-4b05-945c-d6ed78491b8c"],
    "IGameListStatics2": ["395f2098-ea1a-45aa-9268-a83905686f27"],
    "IGameModeConfiguration": ["78e591af-b142-4ef0-8830-55bc2be4f5ea"],
    "IGameModeUserConfiguration": ["72d34af4-756b-470f-a0c2-ba62a90795db"],
    "IGameModeUserConfigurationStatics": ["6e50d97c-66ea-478e-a4a1-f57c0e8d00e7"],
    "IGameRSS": ["7c36a277-4b51-4208-8a7a-4cad5ea9a7b9"],
    "IGameRSSManager": ["e7ea03ce-d9de-441c-bbf9-d2c6c6970ee4"],
    "IGameSaveBlobGetResult": ["917281e0-7201-4953-aa2c-4008f03aef45"],
    "IGameSaveBlobInfo": ["add38034-baf0-4645-b6d0-46edaffb3c2b"],
    "IGameSaveBlobInfoGetResult": ["c7578582-3697-42bf-989c-665d923b5231"],
    "IGameSaveBlobInfoQuery": ["9fdd74b2-eeee-447b-a9d2-7f96c0f83208"],
    "IGameSaveContainer": ["c3c08f89-563f-4ecd-9c6f-33fd0e323d10"],
    "IGameSaveContainerInfo": ["b7e27300-155d-4bb4-b2ba-930306f391b5"],
    "IGameSaveContainerInfoGetResult": ["ffc50d74-c581-4f9d-9e39-30a10c1e4c50"],
    "IGameSaveContainerInfoQuery": ["3c94e863-6f80-4327-9327-ffc11afd42b3"],
    "IGameSaveOperationResult": ["cf0f1a05-24a0-4582-9a55-b1bbbb9388d8"],
    "IGameSaveProvider": ["90a60394-80fe-4211-97f8-a5de14dd95d2"],
    "IGameSaveProviderGetResult": ["3ab90816-d393-4d65-ac16-41c3e67ab945"],
    "IGameSaveProviderStatics": ["d01d3ed0-7b03-449d-8cbd-3402842a1048"],
    "IGameStatistics": ["3887c9ca-04a0-42ae-bc4c-5fa6c7721145"],
    "IGameStatisticsMgr": ["aff3ea11-e70e-407d-95dd-35e612c41ce2"],
    "IGameTask": ["b7c9034c-6ab1-415c-8a31-8374d5fb9fbb"],
    "IGameTaskCollection": ["f4902fb8-4a1f-46dc-9be6-ca69c72a168a"],
    "IGameUIProviderActivatedEventArgs": ["a7b3203e-caf7-4ded-bbd2-47de43bb6dd5"],
    "IGameVersionData": ["0d4794cb-76e2-48aa-a7b5-4923d27f58c2"],
    "IGamepad": ["bc7bb43c-0a69-3903-9e9d-a50f86a45de5"],
    "IGamepad2": ["3c1689bd-5915-4245-b0c0-c89fae0308ff"],
    "IGamepadStatics": ["8bbce529-d49c-39e9-9560-e47dde96b7c8"],
    "IGamepadStatics2": ["42676dc5-0856-47c4-9213-b395504c3a3c"],
    "IGamutMapModelPlugIn": ["2dd80115-ad1e-41f6-a219-a4f4b583d1f9"],
    "IGather": ["c206493f-3c3b-4845-ac46-9e9f5d539a34"],
    "IGatherAdmin": ["b05651f6-9b10-425e-b616-1fcd828db3b1"],
    "IGatherAdmin2": ["ba3c6251-c679-42ed-b75e-4fb81cf2ce93"],
    "IGatherAdmin3": ["fce7ec00-38e9-4837-9f8c-a0313215b86f"],
    "IGatherAdmin4": ["1953486c-8ffa-453f-a489-9f691a007f5e"],
    "IGatherAdmin5": ["2115c3b0-578b-4d31-9001-1a185200ddd1"],
    "IGatherApplication": ["b05651e2-9b10-425e-b616-1fcd828db3b1"],
    "IGatherApplication2": ["c886b1d4-dc18-48d6-8a8f-e66046fcd0cd"],
    "IGatherApplications": ["b05651e4-9b10-425e-b616-1fcd828db3b1"],
    "IGatherApplications2": ["b05651e5-9b10-425e-b616-1fcd828db3b1"],
    "IGatherDataResource": ["0b63e314-9ccc-11d0-bcdb-00805fccce04"],
    "IGatherDataSink": ["c7310559-ac80-11d1-8df3-00c04fb6ef4f"],
    "IGatherDataSite": ["c731057d-ac80-11d1-8df3-00c04fb6ef4f"],
    "IGatherLanguageResourcePool": ["c7310685-ac80-11d1-8df3-00c04fb6ef4f"],
    "IGatherLog": ["b05651d9-9b10-425e-b616-1fcd828db3b1"],
    "IGatherLogProvider": ["a373e680-7a87-11d3-b1c1-00c04f68155c"],
    "IGatherLogs": ["b05651d8-9b10-425e-b616-1fcd828db3b1"],
    "IGatherManagerAdmin": ["b05651e6-9b10-425e-b616-1fcd828db3b1"],
    "IGatherManagerAdmin2": ["b05651e7-9b10-425e-b616-1fcd828db3b1"],
    "IGatherManagerAdmin4": ["7e5e602d-98c3-4dc3-a624-610e430b3c5f"],
    "IGatherNotify": ["b05651f9-9b10-425e-b616-1fcd828db3b1"],
    "IGatherNotify2": ["a5eba07a-dae8-4d15-b12f-728efd8a9866"],
    "IGatherNotifyInline": ["9ea01e09-b0ac-4fb0-ae44-5caa8cb1502f"],
    "IGatherNotifyInline2": ["5fa6726b-3ba9-4223-810b-29a160321172"],
    "IGatherNotifyInlineInternal": ["519d6ff5-aa00-4e4f-914f-be3e10ad78ad"],
    "IGatherNotifySink": ["b056523e-9b10-425e-b616-1fcd828db3b1"],
    "IGatherPluginContext": ["c731059e-ac80-11d1-8df3-00c04fb6ef4f"],
    "IGatherProjectAdmin": ["b05651df-9b10-425e-b616-1fcd828db3b1"],
    "IGatherProjectAdmin2": ["b05651e0-9b10-425e-b616-1fcd828db3b1"],
    "IGatherProjectAdmin3": ["b05651e1-9b10-425e-b616-1fcd828db3b1"],
    "IGatherPropertyBagEnum": ["c731057f-ac80-11d1-8df3-00c04fb6ef4f"],
    "IGatherStoreAppCleanup": ["2bab5a77-7751-4955-ad37-4a27a3c3046d"],
    "IGatherStoreAppSize": ["9fd4bf75-68d1-4791-8ac3-6c757a0c7b9f"],
    "IGatherStoreAppSupport": ["e65bd7f9-275b-4aff-b384-c66ad8046d96"],
    "IGatherStoreScopeNotification": ["a20bfc65-eed8-4814-9be5-d1327a823de4"],
    "IGatherTransactionStatus": ["2c6d493f-bea1-47a6-8b3f-f6f4f0b86eda"],
    "IGatherUsn": ["2bbf221a-023a-49a8-8f67-b7d8f080815b"],
    "IGattCharacteristic": ["59cb50c1-5934-4f68-a198-eb864fa44e6b"],
    "IGattCharacteristic2": ["ae1ab578-ec06-4764-b780-9835a1d35d6e"],
    "IGattCharacteristic3": ["3f3c663e-93d4-406b-b817-db81f8ed53b3"],
    "IGattCharacteristicNotificationTrigger": ["e25f8fc8-0696-474f-a732-f292b0cebc5d"],
    "IGattCharacteristicNotificationTrigger2": ["9322a2c4-ae0e-42f2-b28c-f51372e69245"],
    "IGattCharacteristicNotificationTriggerDetails": ["9ba03b18-0fec-436a-93b1-f46c697532a2"],
    "IGattCharacteristicNotificationTriggerDetails2": ["727a50dc-949d-454a-b192-983467e3d50f"],
    "IGattCharacteristicNotificationTriggerFactory": ["57ba1995-b143-4575-9f6b-fd59d93ace1a"],
    "IGattCharacteristicNotificationTriggerFactory2": ["5998e91f-8a53-4e9f-a32c-23cd33664cee"],
    "IGattCharacteristicStatics": ["59cb50c3-5934-4f68-a198-eb864fa44e6b"],
    "IGattCharacteristicUuidsStatics": ["58fa4586-b1de-470c-b7de-0d11ff44f4b7"],
    "IGattCharacteristicUuidsStatics2": ["1855b425-d46e-4a2c-9c3f-ed6dea29e7be"],
    "IGattCharacteristicsResult": ["1194945c-b257-4f3e-9db7-f68bc9a9aef2"],
    "IGattClientNotificationResult": ["506d5599-0112-419a-8e3b-ae21afabd2c2"],
    "IGattClientNotificationResult2": ["8faec497-45e0-497e-9582-29a1fe281ad5"],
    "IGattDescriptor": ["92055f2b-8084-4344-b4c2-284de19a8506"],
    "IGattDescriptor2": ["8f563d39-d630-406c-ba11-10cdd16b0e5e"],
    "IGattDescriptorStatics": ["92055f2d-8084-4344-b4c2-284de19a8506"],
    "IGattDescriptorUuidsStatics": ["a6f862ce-9cfc-42f1-9185-ff37b75181d3"],
    "IGattDescriptorsResult": ["9bc091f3-95e7-4489-8d25-ff81955a57b9"],
    "IGattDeviceService": ["ac7b7c05-b33c-47cf-990f-6b8f5577df71"],
    "IGattDeviceService2": ["fc54520b-0b0d-4708-bae0-9ffd9489bc59"],
    "IGattDeviceService3": ["b293a950-0c53-437c-a9b3-5c3210c6e569"],
    "IGattDeviceServiceStatics": ["196d0022-faad-45dc-ae5b-2ac3184e84db"],
    "IGattDeviceServiceStatics2": ["0604186e-24a6-4b0d-a2f2-30cc01545d25"],
    "IGattDeviceServicesResult": ["171dd3ee-016d-419d-838a-576cf475a3d8"],
    "IGattLocalCharacteristic": ["aede376d-5412-4d74-92a8-8deb8526829c"],
    "IGattLocalCharacteristicParameters": ["faf73db4-4cff-44c7-8445-040e6ead0063"],
    "IGattLocalCharacteristicResult": ["7975de9b-0170-4397-9666-92f863f12ee6"],
    "IGattLocalDescriptor": ["f48ebe06-789d-4a4b-8652-bd017b5d2fc6"],
    "IGattLocalDescriptorParameters": ["5fdede6a-f3c1-4b66-8c4b-e3d2293b40e9"],
    "IGattLocalDescriptorResult": ["375791be-321f-4366-bfc1-3bc6b82c79f8"],
    "IGattLocalService": ["f513e258-f7f7-4902-b803-57fcc7d6fe83"],
    "IGattPresentationFormat": ["196d0021-faad-45dc-ae5b-2ac3184e84db"],
    "IGattPresentationFormatStatics": ["196d0020-faad-45dc-ae5b-2ac3184e84db"],
    "IGattPresentationFormatStatics2": ["a9c21713-b82f-435e-b634-21fd85a43c07"],
    "IGattPresentationFormatTypesStatics": ["faf1ba0a-30ba-409c-bef7-cffb6d03b8fb"],
    "IGattProtocolErrorStatics": ["ca46c5c5-0ecc-4809-bea3-cf79bc991e37"],
    "IGattReadClientCharacteristicConfigurationDescriptorResult": ["63a66f09-1aea-4c4c-a50f-97bae474b348"],
    "IGattReadClientCharacteristicConfigurationDescriptorResult2": ["1bf1a59d-ba4d-4622-8651-f4ee150d0a5d"],
    "IGattReadRequest": ["f1dd6535-6acd-42a6-a4bb-d789dae0043e"],
    "IGattReadRequestedEventArgs": ["93497243-f39c-484b-8ab6-996ba486cfa3"],
    "IGattReadResult": ["63a66f08-1aea-4c4c-a50f-97bae474b348"],
    "IGattReadResult2": ["a10f50a0-fb43-48af-baaa-638a5c6329fe"],
    "IGattReliableWriteTransaction": ["63a66f07-1aea-4c4c-a50f-97bae474b348"],
    "IGattReliableWriteTransaction2": ["51113987-ef12-462f-9fb2-a1a43a679416"],
    "IGattRequestStateChangedEventArgs": ["e834d92c-27be-44b3-9d0d-4fc6e808dd3f"],
    "IGattServiceProvider": ["7822b3cd-2889-4f86-a051-3f0aed1c2760"],
    "IGattServiceProviderAdvertisementStatusChangedEventArgs": ["59a5aa65-fa21-4ffc-b155-04d928012686"],
    "IGattServiceProviderAdvertisingParameters": ["e2ce31ab-6315-4c22-9bd7-781dbc3d8d82"],
    "IGattServiceProviderAdvertisingParameters2": ["ff68468d-ca92-4434-9743-0e90988ad879"],
    "IGattServiceProviderConnection": ["7fa1b9b9-2f13-40b5-9582-8eb78e98ef13"],
    "IGattServiceProviderConnectionStatics": ["3d509f4b-0b0e-4466-b8cd-6ebdda1fa17d"],
    "IGattServiceProviderResult": ["764696d8-c53e-428c-8a48-67afe02c3ae6"],
    "IGattServiceProviderStatics": ["31794063-5256-4054-a4f4-7bbe7755a57e"],
    "IGattServiceProviderTrigger": ["ddc6a3e9-1557-4bd8-8542-468aa0c696f6"],
    "IGattServiceProviderTriggerDetails": ["ae8c0625-05ff-4afb-b16a-de95f3cf0158"],
    "IGattServiceProviderTriggerResult": ["3c4691b1-b198-4e84-bad4-cf4ad299ed3a"],
    "IGattServiceProviderTriggerStatics": ["b413a36a-e294-4591-a5a6-64891a828153"],
    "IGattServiceUuidsStatics": ["6dc57058-9aba-4417-b8f2-dce016d34ee2"],
    "IGattServiceUuidsStatics2": ["d2ae94f5-3d15-4f79-9c0c-eaafa675155c"],
    "IGattSession": ["d23b5143-e04e-4c24-999c-9c256f9856b1"],
    "IGattSessionStatics": ["2e65b95c-539f-4db7-82a8-73bdbbf73ebf"],
    "IGattSessionStatusChangedEventArgs": ["7605b72e-837f-404c-ab34-3163f39ddf32"],
    "IGattSubscribedClient": ["736e9001-15a4-4ec2-9248-e3f20d463be9"],
    "IGattValueChangedEventArgs": ["d21bdb54-06e3-4ed8-a263-acfac8ba7313"],
    "IGattWriteRequest": ["aeb6a9ed-de2f-4fc2-a9a8-94ea7844f13d"],
    "IGattWriteRequestedEventArgs": ["2dec8bbe-a73a-471a-94d5-037deadd0806"],
    "IGattWriteResult": ["4991ddb1-cb2b-44f7-99fc-d29a2871dc9b"],
    "IGazeDevicePreview": ["e79e7ee9-b389-11e7-b201-c8d3ffb75721"],
    "IGazeDeviceWatcherAddedPreviewEventArgs": ["e79e7eed-b389-11e7-b201-c8d3ffb75721"],
    "IGazeDeviceWatcherPreview": ["e79e7ee7-b389-11e7-b201-c8d3ffb75721"],
    "IGazeDeviceWatcherRemovedPreviewEventArgs": ["f2631f08-0e3f-431f-a606-50b35af94a1c"],
    "IGazeDeviceWatcherUpdatedPreviewEventArgs": ["7fe830ef-7f08-4737-88e1-4a83ae4e4885"],
    "IGazeEnteredPreviewEventArgs": ["2567bf43-1225-489f-9dd1-daa7c50fbf4b"],
    "IGazeExitedPreviewEventArgs": ["5d0af07e-7d83-40ef-9f0a-fbc1bbdcc5ac"],
    "IGazeInputSourcePreview": ["e79e7ee8-b389-11e7-b201-c8d3ffb75721"],
    "IGazeInputSourcePreviewStatics": ["e79e7ee6-b389-11e7-b201-c8d3ffb75721"],
    "IGazeMovedPreviewEventArgs": ["e79e7eeb-b389-11e7-b201-c8d3ffb75721"],
    "IGazePointPreview": ["e79e7eea-b389-11e7-b201-c8d3ffb75721"],
    "IGeneralTransform": ["a06798b7-a2ec-415f-ade2-eade9333f2c7"],
    "IGeneralTransformFactory": ["7a25c930-29c4-4e31-b6f9-dedd52e4df1b"],
    "IGeneralTransformOverrides": ["4f121083-24cf-4524-90ad-8a42b1c12783"],
    "IGeneratorPositionHelper": ["cd40318d-7745-40d9-ab9d-abbda4a7ffea"],
    "IGeneratorPositionHelperStatics": ["ad4095cd-60ec-4588-8d60-39d29097a4df"],
    "IGenericDescriptor": ["6a5918f8-a77a-4f61-aed0-5702bdcda3e6"],
    "IGenericDescriptor2": ["bf02fb7e-9792-4e10-a68d-033a2cc246a5"],
    "IGenericTypeLibOLE": ["f5aa2660-ba14-1069-8aee-00dd010f7d13"],
    "IGeoboundingBox": ["0896c80b-274f-43da-9a06-cbfcdaeb4ec2"],
    "IGeoboundingBoxFactory": ["4dfba589-0411-4abc-b3b5-5bbccb57d98c"],
    "IGeoboundingBoxStatics": ["67b80708-e61a-4cd0-841b-93233792b5ca"],
    "IGeocircle": ["39e45843-a7f9-4e63-92a7-ba0c28d124b1"],
    "IGeocircleFactory": ["afd6531f-72b1-4f7d-87cc-4ed4c9849c05"],
    "IGeocoordinate": ["ee21a3aa-976a-4c70-803d-083ea55bcbc4"],
    "IGeocoordinateSatelliteData": ["c32a74d9-2608-474c-912c-06dd490f4af7"],
    "IGeocoordinateWithPoint": ["feea0525-d22c-4d46-b527-0b96066fc7db"],
    "IGeocoordinateWithPositionData": ["95e634be-dbd6-40ac-b8f2-a65c0340d9a6"],
    "IGeocoordinateWithPositionSourceTimestamp": ["8543fc02-c9f1-4610-afe0-8bc3a6a87036"],
    "IGeofence": ["9c090823-edb8-47e0-8245-5bf61d321f2d"],
    "IGeofenceFactory": ["841f624b-325f-4b90-bca7-2b8022a93796"],
    "IGeofenceMonitor": ["4c0f5f78-1c1f-4621-bbbd-833b92247226"],
    "IGeofenceMonitorStatics": ["2dd32fcf-7e75-4899-ace3-2bd0a65cce06"],
    "IGeofenceStateChangeReport": ["9a243c18-2464-4c89-be05-b3ffff5babc5"],
    "IGeographicRegion": ["01e9a621-4a64-4ed9-954f-9edeb07bd903"],
    "IGeographicRegionFactory": ["53425270-77b4-426b-859f-81e19d512546"],
    "IGeographicRegionStatics": ["29e28974-7ad9-4ef4-8799-b3b44fadec08"],
    "IGeolocator": ["a9c3bf62-4524-4989-8aa9-de019d2e551f"],
    "IGeolocator2": ["d1b42e6d-8891-43b4-ad36-27c6fe9a97b1"],
    "IGeolocatorStatics": ["9a8e7571-2df5-4591-9f87-eb5fd894e9b7"],
    "IGeolocatorStatics2": ["993011a2-fa1c-4631-a71d-0dbeb1250d9c"],
    "IGeolocatorWithScalarAccuracy": ["96f5d3c1-b80f-460a-994d-a96c47a51aa4"],
    "IGeometry": ["fa123889-0acd-417b-b62d-5ca1bf4dfc0e"],
    "IGeometryFactory": ["f65daf23-d5fd-42f9-b32a-929c5a4b54e1"],
    "IGeometryGroup": ["55225a61-8677-4c8c-8e46-ee3dc355114b"],
    "IGeometryGroupStatics": ["56c955f4-8496-4bb6-abf0-617b1fe78b45"],
    "IGeometrySource2D": ["caff7902-670c-4181-a624-da977203b845"],
    "IGeometryStatics": ["7a70aa8c-0b06-465f-b637-9a47e5a70111"],
    "IGeopath": ["e53fd7b9-2da4-4714-a652-de8593289898"],
    "IGeopathFactory": ["27bea9c8-c7e7-4359-9b9b-fca3e05ef593"],
    "IGeopoint": ["6bfa00eb-e56e-49bb-9caf-cbaa78a8bcef"],
    "IGeopointFactory": ["db6b8d33-76bd-4e30-8af7-a844dc37b7a0"],
    "IGeoposition": ["c18d0454-7d41-4ff7-a957-9dffb4ef7f5b"],
    "IGeoposition2": ["7f62f697-8671-4b0d-86f8-474a8496187c"],
    "IGeoshape": ["c99ca2af-c729-43c1-8fab-d6dec914df7e"],
    "IGeotagHelperStatics": ["41493244-2524-4655-86a6-ed16f5fc716b"],
    "IGeovisit": ["b1877a76-9ef6-41ab-a0dd-793ece76e2de"],
    "IGeovisitMonitor": ["80118aaf-5944-4591-83c1-396647f54f2c"],
    "IGeovisitMonitorStatics": ["bcf976a7-bbf2-4cdd-95cf-554c82edfb87"],
    "IGeovisitStateChangedEventArgs": ["ceb4d1ff-8b53-4968-beed-4cecd029ce15"],
    "IGeovisitTrigger": ["4818edaa-04e1-4127-9a4c-19351b8a80a4"],
    "IGeovisitTriggerDetails": ["ea770d9e-d1c9-454b-99b7-b2f8cdd2482f"],
    "IGestureRecognizer": ["ae9ef86b-7054-45e3-ae22-3174dc8811b7", "b47a37bf-3d6b-4f88-83e8-6dcb4012ffb0"],
    "IGestureRecognizer2": ["d646097f-6ef7-5746-8ba8-8ff2206e6f3b"],
    "IGetActivationFactory": ["4edb8ee2-96dd-49a7-94f7-4607ddab8e3c"],
    "IGetAppTrackerData": ["507c3ac8-3e12-4cb0-9366-653d3e050638"],
    "IGetBindHandle": ["af0ff408-129d-4b20-91f0-02bd23d88352"],
    "IGetCachedIndexAndVersion": ["4e506848-39a0-4f04-8b96-428fb9d1b523"],
    "IGetCallForwardingCompletion": ["c329148f-3374-438b-8ed4-e1b9ab28eee3"],
    "IGetCapabilitiesKey": ["a8809222-07bb-48ea-951c-33158100625b"],
    "IGetCatalogObject": ["000001fe-0000-0000-c000-000000000046"],
    "IGetContextId": ["000001dd-0000-0000-c000-000000000046"],
    "IGetCountCallback": ["e379fdde-70ae-406a-b761-06d0e508eb20"],
    "IGetDataSource": ["0c733a75-2a1c-11ce-ade5-00aa0044773d"],
    "IGetDispenser": ["c23cc370-87ef-11ce-8081-0080c758527e"],
    "IGetEntitlementResult": ["74fc843f-1a9e-4609-8e4d-819086d08a3d"],
    "IGetInterface": ["cd0ff000-8b95-11d1-82db-00c04fb1625d"],
    "IGetLibrariesCallback": ["2c9eef62-b4cb-43cc-961f-5322aae59241"],
    "IGetNAICompletion": ["4afe7f70-7d1f-45d1-bc93-908161febc58"],
    "IGetOleObject": ["8a701da0-4feb-101b-a82e-08002b2b2337"],
    "IGetPLMNwAcT": ["e9beb716-6add-492b-bbea-b2fe1068a86e"],
    "IGetPauseStateCallback": ["32674bd8-5f56-40b8-8ffc-22b3212ff021"],
    "IGetPiboStreamX": ["69f429ed-36b1-4c5c-af3e-38c128b58caf"],
    "IGetPreviewPageEventArgs": ["a43d703d-dea9-4df6-a7ed-35049cd485c7"],
    "IGetPreviewPageEventHandler": ["ccb3e9ed-9c11-4e50-ab49-e98086bbfdef"],
    "IGetProcessInfoInternal": ["eb3cae6b-6670-4b52-a0a9-d96c3b30180f"],
    "IGetProxyForUrlCompletion": ["eaf85b1b-d1a3-48b7-9d96-52f9f09c9bab"],
    "IGetProxyForUrlParameters": ["2145c3b3-ce6d-4f97-83e4-c25da5b85bf0"],
    "IGetRFStateCompletion": ["4255dd18-d829-4c04-849a-624727b990a2"],
    "IGetRFStateExCompletion": ["74e511fd-f17b-48fc-bd56-93af42e71031"],
    "IGetRecordStatusCompletion": ["2d033fa3-ae5c-495c-bcf5-459ffa07036a"],
    "IGetResultCallback": ["0e90fdd8-8f71-407c-8a44-9ce79b40b99e"],
    "IGetRow": ["0c733aaf-2a1c-11ce-ade5-00aa0044773d"],
    "IGetSIDNIDCompletion": ["e7d5d35e-a770-4adc-8bb1-a677ea6e89ac"],
    "IGetSVGDocument": ["305105ab-98b5-11cf-bb82-00aa00bdce0b"],
    "IGetSearchLaunchModeForWindow": ["f88ddd9c-e19f-4ffb-9bf7-6199f8e45940"],
    "IGetSearchPaneBroker": ["d86cf271-2d45-4831-a2fd-5b61601a1a82"],
    "IGetSelectiveSyncInformationCallback": ["889180d2-f7b3-45b4-ae53-6dc6ed89e613"],
    "IGetSession": ["0c733aba-2a1c-11ce-ade5-00aa0044773d"],
    "IGetSettingUnitPersistentID": ["e6e81559-9f2a-4842-abeb-e7641318b5db"],
    "IGetSourceRow": ["0c733abb-2a1c-11ce-ade5-00aa0044773d"],
    "IGetSyncStatusCallback": ["7b9016c4-d591-402b-bb4d-e125867a8047"],
    "IGetUniqueCountCallback": ["c034a4a8-5e06-4bfe-94c6-93899017fd8f"],
    "IGetVBAObject": ["91733a60-3f4c-101b-a3f6-00aa0034e4e9"],
    "IGettingFocusEventArgs": ["fa05b9ce-c67c-4be8-8fd4-c44d67877e0d"],
    "IGettingFocusEventArgs2": ["88754d7b-b4b9-4959-8bce-89bf212ed4eb"],
    "IGettingFocusEventArgs3": ["4e024891-db3f-5e78-b75a-62bfc3510735"],
    "IGipFirmwareUpdateResult": ["6b794d32-8553-4292-8e03-e16651a2f8bc"],
    "IGipGameControllerInputSink": ["a2108abf-09f1-43bc-a140-80f899ec36fb"],
    "IGipGameControllerProvider": ["dbcf1e19-1af5-45a8-bf02-a0ee50c823fc"],
    "IGlobalOptions": ["0000015b-0000-0000-c000-000000000046"],
    "IGlobalRudeWindowManager": ["cd7a55eb-4c97-4cdc-9163-fc1b0219e13a"],
    "IGlobalRudeWindowNotificationService": ["a240bbbd-d294-480c-8d38-3786056363f1"],
    "IGlobalRudeWindowNotifications": ["22ba7cc0-8e75-484f-844e-0b6d74105413"],
    "IGlobalServiceDS": ["217ebb8e-bc0f-413c-a4c4-87eda3e952d6"],
    "IGlobalSystemMediaTransportControlsSession": ["7148c835-9b14-5ae2-ab85-dc9b1c14e1a8"],
    "IGlobalSystemMediaTransportControlsSessionManager": ["cace8eac-e86e-504a-ab31-5ff8ff1bce49"],
    "IGlobalSystemMediaTransportControlsSessionManagerStatics": ["2050c4ee-11a0-57de-aed7-c97c70338245"],
    "IGlobalSystemMediaTransportControlsSessionMediaProperties": ["68856cf6-adb4-54b2-ac16-05837907acb6"],
    "IGlobalSystemMediaTransportControlsSessionPlaybackControls": ["6501a3e6-bc7a-503a-bb1b-68f158f3fb03"],
    "IGlobalSystemMediaTransportControlsSessionPlaybackInfo": ["94b4b6cf-e8ba-51ad-87a7-c10ade106127"],
    "IGlobalSystemMediaTransportControlsSessionTimelineProperties": ["ede34136-6f25-588d-8ecf-ea5b6735aaa5"],
    "IGlobalizationPreferencesForUser": ["150f0795-4f6e-40ba-a010-e27d81bda7f5"],
    "IGlobalizationPreferencesStatics": ["01bf4326-ed37-4e96-b0e9-c1340d1ea158"],
    "IGlobalizationPreferencesStatics2": ["fcce85f1-4300-4cd0-9cac-1a8e7b7e18f4"],
    "IGlobalizationPreferencesStatics3": ["1e059733-35f5-40d8-b9e8-aef3ef856fce"],
    "IGlyphs": ["d079498b-f2b1-4281-99a2-e4d05932b2b5"],
    "IGlyphs2": ["aa8bfe5c-3754-4bee-bbe1-4403ee9b86f0"],
    "IGlyphsStatics": ["225cf4c5-fdf1-43ed-958f-414e86f103f2"],
    "IGlyphsStatics2": ["10489aa7-1615-4a33-aa02-d7ef2aefc739"],
    "IGpioChangeCounter": ["cb5ec0de-6801-43ff-803d-4576628a8b26"],
    "IGpioChangeCounterFactory": ["147d94b6-0a9e-410c-b4fa-f89f4052084d"],
    "IGpioChangeReader": ["0abc885f-e031-48e8-8590-70de78363c6d"],
    "IGpioChangeReaderFactory": ["a9598ef3-390e-441a-9d1c-e8de0b2df0df"],
    "IGpioController": ["284012e3-7461-469c-a8bc-61d69d08a53c"],
    "IGpioControllerProvider": ["ad11cec7-19ea-4b21-874f-b91aed4a25db"],
    "IGpioControllerStatics": ["2ed6f42e-7af7-4116-9533-c43d99a1fb64"],
    "IGpioControllerStatics2": ["912b7d20-6ca4-4106-a373-fffd346b0e5b"],
    "IGpioPin": ["11d9b087-afae-4790-9ee9-e0eac942d201"],
    "IGpioPinProvider": ["42344cb7-6abc-40ff-9ce7-73b85301b900"],
    "IGpioPinProviderValueChangedEventArgs": ["32a6d6f2-3d5b-44cd-8fbe-13a69f2edb24"],
    "IGpioPinProviderValueChangedEventArgsFactory": ["3ecb0b59-568c-4392-b24a-8a59a902b1f1"],
    "IGpioPinValueChangedEventArgs": ["3137aae1-703d-4059-bd24-b5b25dffb84e"],
    "IGpioProvider": ["44e82707-08ca-434a-afe0-d61580446f7e"],
    "IGpnvsCommonBase": ["907e0b5c-e42d-4f04-91f0-26f401f36907"],
    "IGradientBrush": ["2166e69f-935a-4191-8e3c-1c8dfdfcdc78"],
    "IGradientBrushFactory": ["ed4779ca-45bd-4131-b625-be86e07c6112"],
    "IGradientBrushStatics": ["961661f9-8bb4-4e6c-b923-b5d787e0f1a9"],
    "IGradientStop": ["665f44fe-2e59-4c4a-ab53-076a100ccd81"],
    "IGradientStopStatics": ["602a6d75-6193-4fe5-8e82-c7c6f6febafd"],
    "IGraphConfig": ["03a1eb8e-32bf-4245-8502-114d08a9cb88"],
    "IGraphConfigCallback": ["ade0fd60-d19d-11d2-abf6-00a0c905f375"],
    "IGraphicsCaptureItem": ["79c3f95b-31f7-4ec2-a464-632ef5d30760"],
    "IGraphicsCaptureItemStatics": ["a87ebea5-457c-5788-ab47-0cf1d3637e74"],
    "IGraphicsCapturePicker": ["5a1711b3-ad79-4b4a-9336-1318fdde3539"],
    "IGraphicsCaptureSession": ["814e42a9-f70f-4ad7-939b-fddcc6eb880d"],
    "IGraphicsCaptureSession2": ["2c39ae40-7d2e-5044-804e-8b6799d4cf9e"],
    "IGraphicsCaptureSessionStatics": ["2224a540-5974-49aa-b232-0882536f4cb5"],
    "IGraphicsEffect": ["cb51c0ce-8fe6-4636-b202-861faa07d8f3"],
    "IGraphicsEffectSource": ["2d8f9ddc-4339-4eb9-9216-f9deb75658a2"],
    "IGravityConnectedAnimationConfiguration": ["c751a4b7-0459-5142-b891-aeaac1d41822"],
    "IGravityConnectedAnimationConfiguration2": ["62333add-aed4-5fed-95ff-d128acce8be4"],
    "IGravityConnectedAnimationConfigurationFactory": ["e822c41f-3656-5090-92f5-c217eaacb682"],
    "IGrfCache": ["ae9472be-b0c3-11d2-8d24-00a0c9441e20"],
    "IGrid": ["fd104460-2e15-4ba3-8b8f-fa693a4161e9"],
    "IGrid2": ["f76efa41-380e-45db-be87-9e1326ba4b57"],
    "IGrid3": ["12dfc5fc-2342-4dd2-9e7d-2090a171d1ef"],
    "IGrid4": ["ed02d274-81f1-5ac2-a0c3-bbdaf5a3ffee"],
    "IGridFactory": ["ae814041-c531-43b4-bf99-12f506f7b01c"],
    "IGridItemPatternIdentifiers": ["757744f1-3285-4fb1-803b-2545bd431599"],
    "IGridItemPatternIdentifiersStatics": ["217d2402-5e46-4d61-8794-b8ee8e774714"],
    "IGridItemProvider": ["d02541f1-fb81-4d64-ae32-f520f8a6dbd1", "fff3683c-7407-45bb-a936-df3ed6d3837d"],
    "IGridLengthHelper": ["7a826ce1-07a0-4083-b6d1-b1d917b976ac"],
    "IGridLengthHelperStatics": ["9d457b9b-019f-4266-8872-215f198f6a9d"],
    "IGridPatternIdentifiers": ["c902980f-96c5-450c-9044-7e52c24f9e94"],
    "IGridPatternIdentifiersStatics": ["7bc452f3-a181-4137-8de9-1f9b1a8320ed"],
    "IGridProvider": ["8b62b7a0-932c-4490-9a13-02fdb39a8f5b", "b17d6187-0907-464b-a168-0ef17a1572b1"],
    "IGridStatics": ["64fe2e9f-f951-42b6-a9ce-bb179af11595"],
    "IGridStatics2": ["2d666658-58b6-4a1b-841b-875ba93b5d6a"],
    "IGridStatics3": ["c3fba437-5a0c-407a-9621-79545386d811"],
    "IGridStatics4": ["691af349-1f63-57aa-8726-9cdcc1b14c02"],
    "IGridView": ["026ae934-b67e-4d80-8f72-8aa64b4d827b"],
    "IGridViewAutomationPeer": ["1c4401a4-d951-49ca-8f82-c7f3c60681b0"],
    "IGridViewAutomationPeerFactory": ["8aca59dd-22a7-4800-894b-c1f485f38953"],
    "IGridViewFactory": ["d9bcca89-09f9-4c6e-a83e-f199146f0e7d"],
    "IGridViewHeaderItem": ["72d75d7e-5dc3-4ffc-9b1c-939b5c37161c"],
    "IGridViewHeaderItemAutomationPeer": ["e3dcef3a-e08a-48e7-b23a-2be5b66e474e"],
    "IGridViewHeaderItemAutomationPeerFactory": ["2c80b4d2-ffc2-4157-88dd-59cd92e39715"],
    "IGridViewHeaderItemFactory": ["36e0c96e-b56a-4b3b-8bac-7aef5e6f9945"],
    "IGridViewItem": ["7d9901f1-e7c1-4e83-b470-c9d6d7bda9f5"],
    "IGridViewItemAutomationPeer": ["93ef2d07-346c-4166-a4ba-bc6a181e7f33"],
    "IGridViewItemAutomationPeerFactory": ["fafec376-f22e-466d-913c-ae24ccdb160f"],
    "IGridViewItemDataAutomationPeer": ["f3f4868f-29d4-4094-8c54-ea61a88294a4"],
    "IGridViewItemDataAutomationPeerFactory": ["a65e7a88-770d-402c-996f-67506af2a4af"],
    "IGridViewItemFactory": ["229b00af-3fa6-43e9-979d-07ea0d6280dc"],
    "IGridViewItemPresenter": ["214f9010-56e2-4821-8a1c-2305709af94b"],
    "IGridViewItemPresenterFactory": ["53c12178-63bb-4a65-a3f1-ab114cfc6ffe"],
    "IGridViewItemPresenterStatics": ["e958f8c4-277e-4a72-a01e-9e1688980178"],
    "IGridViewItemTemplateSettings": ["9e30baaf-165d-4267-a45e-1a43a75706ac"],
    "IGripperHost": ["7b684b1a-3563-4ebe-b541-f2a1d4e85a9f"],
    "IGripperHost2": ["9afb662d-c536-42d5-9a82-638d5f4c23ec"],
    "IGroupItem": ["4ae8d5d1-7228-4a16-a61f-88c0e8f45c76"],
    "IGroupItemAutomationPeer": ["1914fe6d-0740-4236-9ee1-38cf19c1c388"],
    "IGroupItemAutomationPeerFactory": ["56a64567-f21c-4c90-b379-15a27c7f8409"],
    "IGroupItemFactory": ["d9a1d53e-b1e0-4319-9808-7a9e887e13b0"],
    "IGroupPolicyObject": ["ea502723-a23d-11d1-a7d3-0000f87571e3"],
    "IGroupStyle": ["71ca300b-b89e-4184-b0df-a9e95447de8d"],
    "IGroupStyle2": ["69f90679-3a11-4fe7-b4df-2a0139d4018b"],
    "IGroupStyleFactory": ["56ff664f-e2d7-4f49-803d-c727cdf9372d"],
    "IGroupStyleSelector": ["6dda119e-9a74-478f-a339-5bb52de6c51e"],
    "IGroupStyleSelectorFactory": ["bf570d33-b2f6-481f-a450-c80c291fb22d"],
    "IGroupStyleSelectorOverrides": ["f691cab2-77ad-4d3d-a51c-8ef9c3836456"],
    "IGuardableStream": ["dd62ff99-d359-4b64-9ba1-b8d01dc351d2"],
    "IGuidCollection": ["a22f4113-46d1-478f-ab7e-e66f319ad46f"],
    "IGuidHelperStatics": ["59c7966b-ae52-5283-ad7f-a1b9e9678add"],
    "IGuidanceAudioNotificationRequestedEventArgs": ["ca2aa24a-c7c2-4d4c-9d7c-499576bceddb"],
    "IGuidanceLaneInfo": ["8404d114-6581-43b7-ac15-c9079bf90df1"],
    "IGuidanceManeuver": ["fc09326c-ecc9-4928-a2a1-7232b99b94a1"],
    "IGuidanceMapMatchedCoordinate": ["b7acb168-2912-4a99-aff1-798609b981fe"],
    "IGuidanceNavigator": ["08f17ef7-8e3f-4d9a-be8a-108f9a012c67"],
    "IGuidanceNavigator2": ["6cdc50d1-041c-4bf3-b633-a101fc2f6b57"],
    "IGuidanceNavigatorStatics": ["00fd9513-4456-4e66-a143-3add6be08426"],
    "IGuidanceNavigatorStatics2": ["54c5c3e2-7784-4c85-8c95-d0c6efb43965"],
    "IGuidanceReroutedEventArgs": ["115d4008-d528-454e-bb94-a50341d2c9f1"],
    "IGuidanceRoadSegment": ["b32758a6-be78-4c63-afe7-6c2957479b3e"],
    "IGuidanceRoadSegment2": ["2474a61d-1723-49f1-895b-47a2c4aa9c55"],
    "IGuidanceRoadSignpost": ["f1a728b6-f77a-4742-8312-53300f9845f0"],
    "IGuidanceRoute": ["3a14545d-801a-40bd-a286-afb2010cce6c"],
    "IGuidanceRouteStatics": ["f56d926a-55ed-49c1-b09c-4b8223b50db3"],
    "IGuidanceTelemetryCollector": ["db1f8da5-b878-4d92-98dd-347d23d38262"],
    "IGuidanceTelemetryCollectorStatics": ["36532047-f160-44fb-b578-94577ca05990"],
    "IGuidanceUpdatedEventArgs": ["fdac160b-9e8d-4de3-a9fa-b06321d18db9"],
    "IGuideData": ["61571138-5b01-43cd-aeaf-60b784a0bf93"],
    "IGuideDataEvent": ["efda0c80-f395-42c3-9b3c-56b37dec7bb7"],
    "IGuideDataLoader": ["4764ff7c-fa95-4525-af4d-d32236db9e38"],
    "IGuideDataProperty": ["88ec5e58-bb73-41d6-99ce-66c524b8b591"],
    "IGyrometer": ["fdb9a9c4-84b1-4ca2-9763-9b589506c70c"],
    "IGyrometer2": ["63df2443-8ce8-41c3-ac44-8698810b557f"],
    "IGyrometer3": ["5d6f88d5-8fbc-4484-914b-528adfd947b1"],
    "IGyrometer4": ["0628a60c-4c4b-5096-94e6-c356df68bef7"],
    "IGyrometerDataThreshold": ["8648b31e-6e52-5259-bbad-242a69dc38c8"],
    "IGyrometerDeviceId": ["1ee5e978-89a2-4275-9e95-7126f4708760"],
    "IGyrometerReading": ["b3d6de5c-1ee4-456f-9de7-e2493b5c8e03"],
    "IGyrometerReading2": ["16afe13c-2b89-44bb-822b-d1e1556ff09b"],
    "IGyrometerReadingChangedEventArgs": ["0fdf1895-6f9e-42ce-8d58-388c0ab8356d"],
    "IGyrometerStatics": ["83b6e7c9-e49d-4b39-86e6-cd554be4c5c1"],
    "IGyrometerStatics2": ["ef83f7a1-d700-4204-9613-79c6b161df4e"],
    "IH264ProfileIdsStatics": ["38654ca7-846a-4f97-a2e5-c3a15bbf70fd"],
    "IHCAction": ["e90aad8b-7f0c-480d-b33e-16779c4cf59d"],
    "IHCCheck": ["fae9ce59-7621-4208-8bc3-2acecd58fed2"],
    "IHCCheckCollection": ["db62c52c-dbae-476c-aeac-fa9966e85326"],
    "IHCCheckInternalP": ["0cc6fe25-a88b-480d-956a-a9a20bd2c65a"],
    "IHCCheckProvider": ["418ee892-56f0-4c3b-9238-696ba0cef799"],
    "IHCCommand": ["3d2eafc0-96d0-4925-9f7d-ff80b168f243"],
    "IHCCommandCollection": ["58d879fe-5b40-46aa-ab68-d146ff6a68a0"],
    "IHCDescriptionAndIcon": ["7cbc33db-7a53-45c3-a0cc-610292bd7b9e"],
    "IHCIconP": ["014a1425-828b-482a-a386-5763b23531c3"],
    "IHCNotification": ["8025d477-47d3-449c-9350-c676140ee829"],
    "IHCNotificationCollection": ["1cf5e433-3cf8-498e-8b5a-f47e23200e07"],
    "IHCNotificationInternalP": ["8db6ae56-7ea1-421c-9c22-d3247c12c6c4"],
    "IHCNotificationManager": ["01afc156-f2eb-4c1c-a722-8550417d396f"],
    "IHCNotificationManagerEventsP": ["0acabbb8-8f37-4605-9d41-eec1c33eeb95"],
    "IHCNotificationManagerP": ["b066dde3-445d-45dc-bf2a-bc7baa74c5c5"],
    "IHCObjectWithCanonicalName": ["824f0d64-069c-4383-9107-f18fc40c3ca6"],
    "IHCStatus": ["b387c51b-7fe4-4252-8cd4-585592b4dc7e"],
    "IHTML5AttributeSelectorCI": ["30510767-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLAnchorElement3": ["3051041d-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLApplicationCache": ["30510828-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLAreaElement2": ["3051041f-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLAreasCollection4": ["30510492-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLAttributeCollection3": ["30510469-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLAttributeCollection4": ["305106fa-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLAudioElement": ["30510708-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLAudioElementFactory": ["305107eb-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLBaseElement2": ["30510420-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLBlockElement3": ["30510494-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLBodyElement3": ["30510422-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLBodyElement4": ["30510795-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLBodyElement5": ["30510822-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLButtonElement2": ["305106f3-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLCSSImportRule": ["305106ea-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLCSSMediaList": ["30510731-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLCSSMediaRule": ["305106eb-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLCSSNamespaceRule": ["305106ee-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLCSSRule": ["305106e9-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLCSSStyleDeclaration": ["30510740-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLCSSStyleDeclaration2": ["305107d1-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLCSSStyleDeclaration3": ["3051085c-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLCSSStyleDeclaration4": ["d6100f3b-27c8-4132-afea-f0e4b1e00060"],
    "IHTMLCanvasElement": ["305106e4-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLCommentElement3": ["3051073f-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLCurrentStyle4": ["3050f33b-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLCurrentStyle5": ["30510481-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLDOMAttribute3": ["30510468-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLDOMAttribute4": ["305106f9-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLDOMChildrenCollection2": ["30510791-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLDOMConstructor": ["3051049b-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLDOMConstructorCollection": ["3051049c-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLDOMImplementation2": ["3051073c-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLDOMNode3": ["305106e0-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLDOMRange": ["305104ae-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLDOMTextNode3": ["3051073e-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLDocument6": ["30510417-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLDocument7": ["305104b8-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLDocument8": ["305107d0-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLDocumentCompatibleInfo": ["3051041a-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLDocumentCompatibleInfoCollection": ["30510418-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLEditorPrivate": ["e9ee444d-1d03-41be-ba81-3a9a3539835f"],
    "IHTMLEditorViewManager": ["53a2d5b0-d2fc-11d0-84e0-006097c9987d"],
    "IHTMLElemCtxStream": ["85da4432-40ba-4221-8ca0-730b85e615ae"],
    "IHTMLElement5": ["3051045d-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLElement6": ["305106f8-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLElement7": ["305107aa-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLElementAppliedStyles": ["305104bd-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLElementCollection4": ["30510425-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLElementDynamicCrawlerExt": ["f39d947b-30a0-4974-90e0-a6f10c3318b5"],
    "IHTMLEmbedElement2": ["30510493-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLEventObj5": ["30510478-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLEventObj6": ["30510734-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLFormElement4": ["3051042c-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLFrameElement3": ["3051042d-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLFrameSetElement3": ["30510796-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLHeadElement2": ["3051042f-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLIFrameElement3": ["30510433-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLImgElement3": ["30510434-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLImgElement4": ["305107f6-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLInputElement3": ["30510435-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLInputRangeElement": ["3050f2d4-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLInputTextElement2": ["3050f2d2-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLLinkElement4": ["3051043a-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLLinkElement5": ["30510726-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLMSCSSKeyframeRule": ["3051080c-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLMSCSSKeyframesRule": ["3051080d-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLMSImgElement": ["30510793-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLMSMediaElement": ["30510792-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLMediaElement": ["30510706-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLMediaElement2": ["30510809-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLMediaElementPrivate": ["44dc7214-50f9-485d-8187-0480a06aab66"],
    "IHTMLMediaError": ["30510704-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLMetaElement3": ["30510495-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLObjectElement4": ["3051043e-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLObjectElement5": ["305104b5-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLOptionElement4": ["305107b4-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLPaintSitePriv": ["372978fb-b349-4d03-a4ff-85b83de3ce06"],
    "IHTMLPainterDispSurface": ["667a4437-dfdc-45ea-b713-d22667f9ab63"],
    "IHTMLParamElement2": ["30510444-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLPerformance": ["3051074e-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLPerformanceNavigation": ["30510750-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLPerformanceTiming": ["30510752-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLPhraseElement3": ["3051043d-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLPlayToPrivate": ["56f69a1a-5a67-4590-9bdf-ed1a4c4ed651"],
    "IHTMLPlayToPrivate2": ["0b06c8ca-867a-4c1a-adf4-bfb3c192b501"],
    "IHTMLPrivateCanvasElement": ["3051085b-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLPrivateDocument": ["305106f5-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLPrivateDocument2": ["30510733-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLPrivateDocument3": ["30510862-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLPrivateDocument4": ["30510835-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLPrivateInputElement": ["6a8ea653-6278-47be-82f6-20d4823f3449"],
    "IHTMLPrivateWindow4": ["30510836-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLPrivateWindow5": ["3051083d-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLPrivateWindow6": ["c1c89ad8-11a3-45a1-a26e-689f3f5add5a"],
    "IHTMLPrivateWindowAccessible": ["3051085e-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLPrivateXMLHttpRequest": ["f7283e06-d006-4376-81d9-88cd3457c774"],
    "IHTMLProgressElement": ["3050f2d6-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLRect2": ["3051076c-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLRuleStyle5": ["3050f335-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLRuleStyle6": ["30510471-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLScreen3": ["305104a1-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLScreen4": ["3051076b-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLScriptElement3": ["30510447-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLScriptElement4": ["30510801-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLSelectElement5": ["3051049d-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLSelectElement6": ["30510760-98b6-11cf-bb82-00aa00bdce0b"],
    "IHTMLSelectElementEx": ["3050f2d1-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLSourceElement": ["30510707-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLStorage": ["30510474-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLStorage2": ["30510799-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLStyle5": ["3050f33a-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLStyle6": ["30510480-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLStyleElement2": ["3051072a-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLStyleEnabled": ["305104c2-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLStyleFontFace2": ["305106ec-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLStyleMedia": ["3051074b-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLStyleSheet3": ["30510496-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLStyleSheet4": ["305106f4-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLStyleSheetPage2": ["305106ed-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLStyleSheetPagePrivate": ["305104a7-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLStyleSheetRule2": ["305106fd-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLStyleSheetRuleApplied": ["305104c1-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLStyleSheetRulePriv": ["3051049f-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLStyleSheetRulesAppliedCollection": ["305104c0-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLStyleSheetRulesCollection2": ["305106e8-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLStyleSheetsCollection2": ["305106e7-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLTable4": ["305106c2-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLTableCell3": ["305106c7-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLTableCol3": ["305106c4-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLTableRow4": ["305106c6-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLTableSection4": ["305106c5-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLTextAreaElement2": ["3050f2d3-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLTimeRanges": ["30510705-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLTimeRanges2": ["3051080b-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLTxtRangeInternal": ["305107c4-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLVideoElement": ["30510709-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLWindow5": ["3051040e-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLWindow6": ["30510453-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLWindow7": ["305104b7-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLWindow8": ["305107ab-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLWindowServicesBroker": ["806d58df-ee78-4630-9475-f9b337a2dfcb"],
    "IHTMLXDomainRequest": ["30510454-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLXDomainRequestFactory": ["30510456-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLXMLHttpRequest": ["3051040a-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLXMLHttpRequest2": ["30510482-98b5-11cf-bb82-00aa00bdce0b"],
    "IHTMLXMLHttpRequestFactory": ["3051040c-98b5-11cf-bb82-00aa00bdce0b"],
    "IHWContainerEventHandler": ["ed7cc9ee-2c17-4912-8fa0-e3ce911e225d"],
    "IHWDeviceCustomProperties": ["77d5d69c-d6ce-4026-b625-26964eec733f"],
    "IHWEventHandler2": ["cfcc809f-295d-42e8-9ffc-424b33c487e6"],
    "IHandMeshObserver": ["85ae30cb-6fc3-55c4-a7b4-29e33896ca69"],
    "IHandMeshVertexState": ["046c5fef-1d8b-55de-ab2c-1cd424886d8f"],
    "IHandPose": ["4d98e79a-bb08-5d09-91de-df0dd3fae46c"],
    "IHandleCloudChangeNotification": ["f3965cb9-a6da-45aa-845b-0b1cb0121820"],
    "IHandleDuplicator": ["24a0bf18-6849-4d99-9fc8-48bcabace467"],
    "IHandlerActivationHost": ["35094a87-8bb1-4237-96c6-c417eebdb078"],
    "IHandlerAsset": ["7629162a-c94d-4f88-8ad4-537c65756c16"],
    "IHandlerAssetCollection": ["7d9c497e-4b9d-444d-85c6-1f1190ade7c3"],
    "IHandlerInfo": ["997706ef-f880-453b-8118-39e1a2d2655a"],
    "IHandlerInfo2": ["31cca04c-04d3-4ea9-90de-97b15e87a532"],
    "IHandwritingPanelClosedEventArgs": ["4fb91c73-192d-4dd2-a1a2-80ed01125876"],
    "IHandwritingPanelOpenedEventArgs": ["fc15b16d-9f15-47b0-b97a-94a68cc61345"],
    "IHandwritingView": ["c44204a7-31e0-44bc-a38b-4bee64ecd99f"],
    "IHandwritingViewFactory": ["e00c873f-0012-475c-890c-97ae308642de"],
    "IHandwritingViewStatics": ["bb7ceed0-cc5f-4004-b8c8-142e195f0618"],
    "IHandwrittenTextInsertion": ["56fdea97-ecd6-43e7-aa3a-816be7785860"],
    "IHardwareAudioEngineBase": ["eddce3e4-f3c1-453a-b461-223563cbd886"],
    "IHardwareDevices": ["3b0f86b5-8113-439d-b2a3-2766c839d073"],
    "IHardwareDevicesEnum": ["553a4a55-681c-440e-b109-597b9219cfb2"],
    "IHardwareDevicesMountPointsEnum": ["ee93d145-9b4e-480c-8385-1e8119a6f7b2"],
    "IHardwareDevicesVolumesEnum": ["1c0eb79b-2cde-44ec-bb35-fc471024c13c"],
    "IHardwareIdentificationStatics": ["971260e0-f170-4a42-bd55-a900b212dae2"],
    "IHardwareToken": ["28f6d4c0-fb12-40a4-8167-7f4e03d2724c"],
    "IHashAlgorithmNamesStatics": ["6b5e0516-de96-4f0a-8d57-dcc9dae36c76"],
    "IHashAlgorithmProvider": ["be9b3080-b2c3-422b-bce1-ec90efb5d7b5"],
    "IHashAlgorithmProviderStatics": ["9fac9741-5cc4-4336-ae38-6212b75a915a"],
    "IHashComputation": ["5904d1b6-ad31-4603-a3a4-b1bda98e2562"],
    "IHdcpSession": ["718845e9-64d7-426d-809b-1be461941a2a"],
    "IHdmiDisplayInformation": ["130b3c0a-f565-476e-abd5-ea05aee74c69"],
    "IHdmiDisplayInformationStatics": ["6ce6b260-f42a-4a15-914c-7b8e2a5a65df"],
    "IHdmiDisplayMode": ["0c06d5ad-1b90-4f51-9981-ef5a1c0ddf66"],
    "IHdmiDisplayMode2": ["07cd4e9f-4b3c-42b8-84e7-895368718af2"],
    "IHdrVideoControl": ["55d8e2d0-30c0-43bf-9b9a-9799d70ced94"],
    "IHeadPose": ["7f5ac5a5-49db-379f-9429-32a2faf34fa6"],
    "IHeaderFooter2": ["305104a5-98b5-11cf-bb82-00aa00bdce0b"],
    "IHeadset": ["3fd156ef-6925-3fa8-9181-029c5223ae3b"],
    "IHidBooleanControl": ["524df48a-3695-408c-bba2-e2eb5abfbc20"],
    "IHidBooleanControlDescription": ["6196e543-29d8-4a2a-8683-849e207bbe31"],
    "IHidBooleanControlDescription2": ["c8eed2ea-8a77-4c36-aa00-5ff0449d3e73"],
    "IHidCollection": ["7189f5a3-32f1-46e3-befd-44d2663b7e6a"],
    "IHidDevice": ["5f8a14e7-2200-432e-95da-d09b87d574a8"],
    "IHidDeviceStatics": ["9e5981e4-9856-418c-9f73-77de0cd85754"],
    "IHidFeatureReport": ["841d9b79-5ae5-46e3-82ef-1fec5c8942f4"],
    "IHidGameControllerInputSink": ["f754c322-182d-40e4-a126-fcee4ffa1e31"],
    "IHidGameControllerProvider": ["95ce3af4-abf0-4b68-a081-3b7de73ff0e7"],
    "IHidInputReport": ["c35d0e50-f7e7-4e8d-b23e-cabbe56b90e9"],
    "IHidInputReportReceivedEventArgs": ["7059c5cb-59b2-4dc2-985c-0adc6136fa2d"],
    "IHidNumericControl": ["e38a12a5-35a7-4b75-89c8-fb1f28b10823"],
    "IHidNumericControlDescription": ["638d5e86-1d97-4c75-927f-5ff58ba05e32"],
    "IHidOutputReport": ["62cb2544-c896-4463-93c1-df9db053c450"],
    "IHighDynamicRangeControl": ["55f1a7ae-d957-4dc9-9d1c-8553a82a7d99"],
    "IHighDynamicRangeOutput": ["0f57806b-253b-4119-bb40-3a90e51384f7"],
    "IHighlightRenderingServicesPriv": ["3051049e-98b5-11cf-bb82-00aa00bdce0b"],
    "IHingeAngleReading": ["a3cd45b9-1bf1-4f65-a704-e2da04f182c0"],
    "IHingeAngleSensor": ["e9d3be02-bfdf-437f-8c29-88c77393d309"],
    "IHingeAngleSensorReadingChangedEventArgs": ["24d9558b-fad0-42b8-a854-78923049a1ba"],
    "IHingeAngleSensorStatics": ["b7b63910-fbb1-4123-89ce-4ea34eb0dfca"],
    "IHist": ["06faeb04-191c-11d3-9573-00c04fa31a86"],
    "IHlinkSource": ["79eac9c4-baf9-11ce-8c82-00aa004ba90b"],
    "IHolderDriver": ["bf6a1851-2b45-11cf-be10-00aa00a2fa25"],
    "IHoldingEventArgs": ["2bf755c5-e799-41b4-bb40-242f40959b71"],
    "IHoldingEventArgs2": ["141da9ea-4c79-5674-afea-493fdeb91f19"],
    "IHoldingEventHandler": ["ecae8ccd-8e5e-4fbe-9846-30a6370afcdf"],
    "IHoldingRoutedEventArgs": ["c246ff23-d80d-44de-8db9-0d815e269ac0"],
    "IHolographicApplicationPreviewStatics": ["fe038691-2a3a-45a9-a208-7bed691919f3"],
    "IHolographicCamera": ["e4e98445-9bed-4980-9ba0-e87680d1cb74"],
    "IHolographicCamera2": ["b55b9f1a-ba8c-4f84-ad79-2e7e1e2450f3"],
    "IHolographicCamera3": ["45aa4fb3-7b59-524e-4a3f-4a6ad6650477"],
    "IHolographicCamera4": ["9a2531d6-4723-4f39-a9a5-9d05181d9b44"],
    "IHolographicCamera5": ["229706f2-628d-4ef5-9c08-a63fdd7787c6"],
    "IHolographicCamera6": ["0209194f-632d-5154-ab52-0b5d15b12505"],
    "IHolographicCameraInterop": ["7cc1f9c5-6d02-41fa-9500-e1809eb48eec"],
    "IHolographicCameraPose": ["0d7d7e30-12de-45bd-912b-c7f6561599d1"],
    "IHolographicCameraPose2": ["232be073-5d2d-4560-814e-2697c4fce16b"],
    "IHolographicCameraRenderingParameters": ["8eac2ed1-5bf4-4e16-8236-ae0800c11d0d"],
    "IHolographicCameraRenderingParameters2": ["261270e3-b696-4634-94d6-be0681643599"],
    "IHolographicCameraRenderingParameters3": ["b1aa513f-136d-4b06-b9d4-e4b914cd0683"],
    "IHolographicCameraRenderingParametersInterop": ["f75b68d6-d1fd-4707-aafd-fa6f4c0e3bf4"],
    "IHolographicCameraViewportParameters": ["80cdf3f7-842a-41e1-93ed-5692ab1fbb10"],
    "IHolographicDesktopViewBroker": ["63713e6e-7503-4369-bfc4-1d1cd78e4931"],
    "IHolographicDisplay": ["9acea414-1d9f-4090-a388-90c06f6eae9c"],
    "IHolographicDisplay2": ["75ac3f82-e755-436c-8d96-4d32d131473e"],
    "IHolographicDisplay3": ["fc4c6ac6-6480-5008-b29e-157d77c843f7"],
    "IHolographicDisplayStatics": ["cb374983-e7b0-4841-8355-3ae5b536e9a4"],
    "IHolographicFrame": ["c6988eb6-a8b9-3054-a6eb-d624b6536375"],
    "IHolographicFrame2": ["283f37bf-3bf2-5e91-6633-870574e6f217"],
    "IHolographicFrame3": ["e5e964c9-8a27-55d3-9f98-94530d369052"],
    "IHolographicFramePrediction": ["520f4de1-5c0a-4e79-a81e-6abe02bb2739"],
    "IHolographicFramePresentationMonitor": ["ca87256c-6fae-428e-bb83-25dfee51136b"],
    "IHolographicFramePresentationReport": ["80baf614-f2f4-4c8a-8de3-065c78f6d5de"],
    "IHolographicFrameRenderingReport": ["05f32de4-e384-51b3-b934-f0d3a0f78606"],
    "IHolographicFrameScanoutMonitor": ["7e83efa9-843c-5401-8095-9bc1b8b08638"],
    "IHolographicFrameScanoutReport": ["0ebbe606-03a0-5ca0-b46e-bba068d7233f"],
    "IHolographicKeyboardPlacementOverridePreview": ["c8a8ce3a-dfde-5a14-8d5f-182c526dd9c4"],
    "IHolographicKeyboardPlacementOverridePreviewStatics": ["202e6039-1ff6-5a06-aac4-a5e24fa3ec4b"],
    "IHolographicQuadLayer": ["903460c9-c9d9-5d5c-41ac-a2d5ab0fd331"],
    "IHolographicQuadLayerFactory": ["a67538f3-5a14-5a10-489a-455065b37b76"],
    "IHolographicQuadLayerInterop": ["cfa688f0-639e-4a47-83d7-6b7f5ebf7fed"],
    "IHolographicQuadLayerUpdateParameters": ["2b0ea3b0-798d-5bca-55c2-2c0c762ebb08"],
    "IHolographicQuadLayerUpdateParameters2": ["4f33d32d-82c1-46c1-8980-3cb70d98182b"],
    "IHolographicQuadLayerUpdateParametersInterop": ["e5f549cd-c909-444f-8809-7cc18a9c8920"],
    "IHolographicSpace": ["4380dba6-5e78-434f-807c-3433d1efe8b7"],
    "IHolographicSpace2": ["4f81a9a8-b7ff-4883-9827-7d677287ea70"],
    "IHolographicSpace3": ["df1733d1-f224-587e-8d71-1e8fc8f07b1f"],
    "IHolographicSpaceCameraAddedEventArgs": ["58f1da35-bbb3-3c8f-993d-6c80e7feb99f"],
    "IHolographicSpaceCameraRemovedEventArgs": ["805444a8-f2ae-322e-8da9-836a0a95a4c1"],
    "IHolographicSpaceInterop": ["5c4ee536-6a98-4b86-a170-587013d6fd4b"],
    "IHolographicSpaceStatics": ["364e6064-c8f2-3ba1-8391-66b8489e67fd"],
    "IHolographicSpaceStatics2": ["0e777088-75fc-48af-8758-0652f6f07c59"],
    "IHolographicSpaceStatics3": ["3b00de3d-b1a3-4dfe-8e79-fec5909e6df8"],
    "IHolographicViewConfiguration": ["5c1de6e6-67e9-5004-b02c-67a3a122b576"],
    "IHolographicViewManager": ["538317c5-5bad-4847-962d-42da294f5e0a"],
    "IHolographicViewTransitionNotification": ["76bb2cfb-c246-41ec-b9c3-671e5347cf51"],
    "IHolographicViewTransitionNotificationService": ["5090de35-ed23-43be-9714-586c5041026a"],
    "IHomeGroup": ["7a3bd1d9-35a9-4fb3-a467-f48cac35e2d0"],
    "IHomeGroupAdvise": ["3d169692-8af5-489f-bb02-faa22d08d824"],
    "IHomeGroupAutoCreateJoin": ["31abd3e1-5ec3-4056-9e80-ec591dc302af"],
    "IHomeGroupCollection": ["c042fb2f-bc74-4636-95b1-2bbe308f7391"],
    "IHomeGroupComponentList": ["3a6dd474-de86-4b4a-b44f-ae9aa8ff432c"],
    "IHomeGroupCplUpdate": ["2edfba4a-2ec9-4b2e-b133-40624a784bec"],
    "IHomeGroupCtrl": ["9642ab2b-2198-4234-8f68-c3f55e5e9247"],
    "IHomeGroupDesktopNotify": ["2fadc3ab-778a-4fce-a62a-05249965e62d"],
    "IHomeGroupDevice": ["2be10a43-bf34-4cc0-b172-3c16761c4384"],
    "IHomeGroupEncryption": ["b852dd46-c3e4-493b-8cd2-a9b3a9f0ff08"],
    "IHomeGroupFunctionDiscoveryQuery": ["e64ffd21-0b4e-4883-a13a-0e23d67549dd"],
    "IHomeGroupInitialize": ["d75646d9-47c4-4b4f-99b8-dacac8401713"],
    "IHomeGroupListener": ["010d0200-d513-4a39-adc7-db57f22b7490"],
    "IHomeGroupListenerManager": ["127592fb-9caf-4411-bd99-a62b924a5d39"],
    "IHomeGroupListenerNotify": ["44bcca94-fd00-4782-8068-847e18ed552d"],
    "IHomeGroupListenerNotifyPriv": ["98ed7fd0-a34a-4d79-a226-e442e7d1d452"],
    "IHomeGroupListenerSCMStatus": ["a84ce57c-1543-478e-b08b-b9c5d31c7240"],
    "IHomeGroupNetwork": ["c8b8b7c0-d585-43e4-a665-fe817bfdf561"],
    "IHomeGroupNetworkCallback": ["ff321dfb-7148-440d-bec4-bcd1f9773ca8"],
    "IHomeGroupPassword": ["06f5ad81-ac49-4557-b4a5-d7e9013329fc"],
    "IHomeGroupPeerManager": ["1991896f-9051-4be3-ba23-137d546edb46"],
    "IHomeGroupPrinterMonitor": ["389153ab-ea42-457f-9704-7ab979c9ef93"],
    "IHomeGroupPrinting": ["e4a31a22-8ad1-419e-ad99-8fabc096dd8a"],
    "IHomeGroupProvider": ["3c61788c-049e-4d13-b510-3acf82f039ee"],
    "IHomeGroupProviderInternal": ["d70b1f16-f0a1-485c-8233-f22ea411667d"],
    "IHomeGroupProviderPriv": ["1ee6d6ce-eb8b-4798-a744-89b724cef2a9"],
    "IHomeGroupProviderServiceDiagnostics": ["e04ed95d-11f8-48d6-973d-f88520dbcbb0"],
    "IHomeGroupRoamedPassword": ["58ebeb65-1e40-40d1-8f59-5130dabc8078"],
    "IHomeGroupSharing": ["30f1c3e8-3f53-47f0-a3f9-26f29a7e3be7"],
    "IHomeGroupState": ["844a53b1-a097-4d62-b58d-d3bb3b4a5dba"],
    "IHomeGroupStateInternal": ["242bf39b-b552-4e1a-be75-7c6a45dccdb6"],
    "IHomeGroupStatus": ["b0a10e19-e52b-4038-bbf7-867e5e6a51fb"],
    "IHomeGroupUIStatus": ["4977ae38-6fa8-44cd-9773-6d5e2be74121"],
    "IHomeGroupUIStatusAdvise": ["4f286628-467d-42be-a332-d7e76cf6e990"],
    "IHomeGroupWizardUpdate": ["400dc7c6-0eb0-44c7-9764-7a1262caf66f"],
    "IHomePageProtector": ["96ab1e90-828c-4b09-9b4c-8ba0b0d9bc66"],
    "IHomePageSetting": ["fdfc244f-18fa-4ff2-b08e-1d618f3ffbe4"],
    "IHostAssemblyManager": ["613dabd7-62b2-493e-9e65-c1e32a1e0c5e"],
    "IHostAssemblyStore": ["7b102a88-3f7f-496d-8fa2-c35374e01af3"],
    "IHostAutoEvent": ["50b0cfce-4063-4278-9673-e5cb4ed0bdb8"],
    "IHostControl": ["02ca073c-7079-4860-880a-c2f7a449c991"],
    "IHostCrst": ["6df710a6-26a4-4a65-8cd5-7237b8bda8dc"],
    "IHostDataModelAccess": ["f2bce54e-4835-4f8a-836e-7981e29904d1"],
    "IHostGCManager": ["5d4ec34e-f248-457b-b603-255faaba0d21"],
    "IHostIdStore": ["d7a5d1cc-fcbc-4e54-9deb-45ef67293cf8"],
    "IHostIoCompletionManager": ["8bde9d80-ec06-41d6-83e6-22580effcc20"],
    "IHostMalloc": ["1831991c-cc53-4a31-b218-04e910446479"],
    "IHostManualEvent": ["1bf4ec38-affe-4fb9-85a6-525268f15b54"],
    "IHostMemoryManager": ["7bc698d1-f9e3-4460-9cde-d04248e9fa25"],
    "IHostMemoryNeededCallback": ["47eb8e57-0846-4546-af76-6f42fcfc2649"],
    "IHostName": ["bf8ecaad-ed96-49a7-9084-d416cae88dcb"],
    "IHostNameFactory": ["458c23ed-712f-4576-adf1-c20b2c643558"],
    "IHostNameStatics": ["f68cd4bf-a388-4e8b-91ea-54dd6dd901c0"],
    "IHostPolicyManager": ["7ae49844-b1e3-4683-ba7c-1e8212ea3b79"],
    "IHostSecurityContext": ["7e573ce4-0343-4423-98d7-6318348a1d3c"],
    "IHostSecurityManager": ["75ad2468-a349-4d02-a764-76a68aee0c4f"],
    "IHostSemaphore": ["855efd47-cc09-463a-a97d-16acab882661"],
    "IHostSyncManager": ["234330c7-5f10-4f20-9615-5122dab7a0ac"],
    "IHostTask": ["c2275828-c4b1-4b55-82c9-92135f74df1a"],
    "IHostTaskManager": ["997ff24c-43b7-4352-8667-0dc04fafd354"],
    "IHostThreadpoolManager": ["983d50e2-cb15-466b-80fc-845dc6e8c5fd"],
    "IHostedApplication": ["942d3eb0-58dc-4807-bee8-c49dfa7d1452"],
    "IHostedApplicationActivationManagerPrivateCallbacks": ["171fea36-96b5-4075-a9b5-b6ede42761bc"],
    "IHostedApplicationExperienceManager": ["cc33932d-0085-4311-8c4d-281aa6501442"],
    "IHostedApplicationNotification": ["1fc98738-e0bf-4cb2-9de2-20ab31b23ce4"],
    "IHostedApplicationTaskCompletion": ["e0664d9b-649c-4b08-91f1-f2d006cd668a"],
    "IHostedApplicationView": ["7b0b9bca-d006-4c7e-8d75-9fcd1c4a7644"],
    "IHostedViewClosingEventArgs": ["d238943c-b24e-4790-acb5-3e4243c4ff87"],
    "IHostedViewDeferClose": ["f9eb9c6d-5a6a-43c7-b0d1-82d3c81e33fc"],
    "IHotPlug": ["4d16bc13-22e4-4126-8cae-705a7a9dd787"],
    "IHotspotAuthEngine": ["fc5eeaf6-1001-11df-adb9-f4ce462d9137"],
    "IHotspotAuthEvents": ["fc5eeaf6-1002-11df-adb9-f4ce462d9137"],
    "IHotspotAuthExtension": ["fc5eeaf6-1005-11df-adb9-f4ce462d9137"],
    "IHotspotAuthLaunchHandler": ["fc5eeaf6-1003-11df-adb9-f4ce462d9137"],
    "IHotspotAuthLaunchStatus": ["fc5eeaf6-1004-11df-adb9-f4ce462d9137"],
    "IHotspotAuthenticationContext": ["e756c791-1003-4de5-83c7-de61d88831d0"],
    "IHotspotAuthenticationContext2": ["e756c791-1004-4de5-83c7-de61d88831d0"],
    "IHotspotAuthenticationContextStatics": ["e756c791-1002-4de5-83c7-de61d88831d0"],
    "IHotspotAuthenticationEventDetails": ["e756c791-1001-4de5-83c7-de61d88831d0"],
    "IHotspotCredentialsAuthenticationResult": ["e756c791-1005-4de5-83c7-de61d88831d0"],
    "IHtmlFormatHelperStatics": ["e22e7749-dd70-446f-aefc-61cee59f655e"],
    "IHtmlLocalFileResolver": ["882381c6-21f5-4299-ae9e-7f1bb75ed7d3"],
    "IHtmlPrintDocumentSource": ["cea6469a-0e05-467a-abc9-36ec1d4cdcb6"],
    "IHtmlUtilities": ["fec00add-2399-4fac-b5a7-05e9acd7181d"],
    "IHttpBaseProtocolFilter": ["71c89b09-e131-4b54-a53c-eb43ff37e9bb"],
    "IHttpBaseProtocolFilter2": ["2ec30013-9427-4900-a017-fa7da3b5c9ae"],
    "IHttpBaseProtocolFilter3": ["d43f4d4c-bd42-43ae-8717-ad2c8f4b2937"],
    "IHttpBaseProtocolFilter4": ["9fe36ccf-2983-4893-941f-eb518ca8cef9"],
    "IHttpBaseProtocolFilter5": ["416e4993-31e3-4816-bf09-e018ee8dc1f5"],
    "IHttpBaseProtocolFilterStatics": ["6d4dee0c-e908-494e-b5a3-1263c9b8242a"],
    "IHttpBufferContentFactory": ["bc20c193-c41f-4ff7-9123-6435736eadc2"],
    "IHttpCacheControl": ["c77e1cb4-3cea-4eb5-ac85-04e186e63ab7"],
    "IHttpCacheDirectiveHeaderValueCollection": ["9a586b89-d5d0-4fbe-bd9d-b5b3636811b4"],
    "IHttpChallengeHeaderValue": ["393361af-0f7d-4820-9fdd-a2b956eeaeab"],
    "IHttpChallengeHeaderValueCollection": ["ca9e5f81-aee0-4353-a10b-e625babd64c2"],
    "IHttpChallengeHeaderValueFactory": ["c452c451-d99c-40aa-9399-90eeb98fc613"],
    "IHttpChallengeHeaderValueStatics": ["f3d38a72-fc01-4d01-a008-fcb7c459d635"],
    "IHttpClient": ["7fda1151-3574-4880-a8ba-e6b1e0061f3d"],
    "IHttpClient2": ["cdd83348-e8b7-4cec-b1b0-dc455fe72c92"],
    "IHttpClientFactory": ["c30c4eca-e3fa-4f99-afb4-63cc65009462"],
    "IHttpConnectionOptionHeaderValue": ["cb4af27a-4e90-45eb-8dcd-fd1408f4c44f"],
    "IHttpConnectionOptionHeaderValueCollection": ["e4f56c1d-5142-4e00-8e0f-019509337629"],
    "IHttpConnectionOptionHeaderValueFactory": ["d93ccc1e-0b7d-4c3f-a58d-a2a1bdeabc0a"],
    "IHttpConnectionOptionHeaderValueStatics": ["aaa75d37-a946-4b1f-85af-48b68b3c50bd"],
    "IHttpContent": ["6b14a441-fba7-4bd2-af0a-839de7c295da"],
    "IHttpContentCodingHeaderValue": ["bcf7f92a-9376-4d85-bccc-9f4f9acab434"],
    "IHttpContentCodingHeaderValueCollection": ["7d221721-a6db-436e-8e83-91596192819c"],
    "IHttpContentCodingHeaderValueFactory": ["c53d2bd7-332b-4350-8510-2e67a2289a5a"],
    "IHttpContentCodingHeaderValueStatics": ["94d8602e-f9bf-42f7-aa46-ed272a41e212"],
    "IHttpContentCodingWithQualityHeaderValue": ["94531cd5-8b13-4d73-8651-f76b38f88495"],
    "IHttpContentCodingWithQualityHeaderValueCollection": ["7c0d753e-e899-4378-b5c8-412d820711cc"],
    "IHttpContentCodingWithQualityHeaderValueFactory": ["c45eee1a-c553-46fc-ade2-d75c1d53df7b"],
    "IHttpContentCodingWithQualityHeaderValueStatics": ["e8c9357c-8f89-4801-8e75-4c9abfc3de71"],
    "IHttpContentDispositionHeaderValue": ["f2a2eedc-2629-4b49-9908-96a168e9365e"],
    "IHttpContentDispositionHeaderValueFactory": ["9915bbc4-456c-4e81-8295-b2ab3cbcf545"],
    "IHttpContentDispositionHeaderValueStatics": ["29c56067-5a37-46e4-b074-c5177d69ca66"],
    "IHttpContentHeaderCollection": ["40612a44-47ae-4b7e-9124-69628b64aa18"],
    "IHttpContentRangeHeaderValue": ["04d967d3-a4f6-495c-9530-8579fcba8aa9"],
    "IHttpContentRangeHeaderValueFactory": ["3f5bd691-a03c-4456-9a6f-ef27ecd03cae"],
    "IHttpContentRangeHeaderValueStatics": ["80a346ca-174c-4fae-821c-134cd294aa38"],
    "IHttpCookie": ["1f5488e2-cc2d-4779-86a7-88f10687d249"],
    "IHttpCookieFactory": ["6a0585a9-931c-4cd1-a96d-c21701785c5f"],
    "IHttpCookieManager": ["7a431780-cd4f-4e57-a84a-5b0a53d6bb96"],
    "IHttpCookiePairHeaderValue": ["cbd46217-4b29-412b-bd90-b3d814ab8e1b"],
    "IHttpCookiePairHeaderValueCollection": ["f3f44350-581e-4ecc-9f59-e507d04f06e6"],
    "IHttpCookiePairHeaderValueFactory": ["635e326f-146f-4f56-aa21-2cb7d6d58b1e"],
    "IHttpCookiePairHeaderValueStatics": ["6e866d48-06af-4462-8158-99388d5dca81"],
    "IHttpCredentialsHeaderValue": ["c34cc3cb-542e-4177-a6c7-b674ce193fbf"],
    "IHttpCredentialsHeaderValueFactory": ["f21d9e91-4d1c-4182-bfd1-34470a62f950"],
    "IHttpCredentialsHeaderValueStatics": ["a69b2be6-ce8c-4443-a35a-1b727b131036"],
    "IHttpDateOrDeltaHeaderValue": ["eafcaa6a-c4dc-49e2-a27d-043adf5867a3"],
    "IHttpDateOrDeltaHeaderValueStatics": ["7c2659a8-6672-4e90-9a9a-f39766f7f576"],
    "IHttpDiagnosticProvider": ["bd811501-a056-4d39-b174-833b7b03b02c"],
    "IHttpDiagnosticProviderRequestResponseCompletedEventArgs": ["735f98ee-94f6-4532-b26e-61e1b1e4efd4"],
    "IHttpDiagnosticProviderRequestResponseTimestamps": ["e0afde10-55cf-4c01-91d4-a20557d849f0"],
    "IHttpDiagnosticProviderRequestSentEventArgs": ["3f5196d0-4c1f-4ebe-a57a-06930771c50d"],
    "IHttpDiagnosticProviderResponseReceivedEventArgs": ["a0a2566c-ab5f-4d66-bb2d-084cf41635d0"],
    "IHttpDiagnosticProviderStatics": ["5b824ec1-6a6c-47cc-afec-1e86bc26053b"],
    "IHttpDiagnosticSourceLocation": ["54a9d260-8860-423f-b6fa-d77716f647a7"],
    "IHttpExpectationHeaderValue": ["4ce585cd-3a99-43af-a2e6-ec232fea9658"],
    "IHttpExpectationHeaderValueCollection": ["e78521b3-a0e2-4ac4-9e66-79706cb9fd58"],
    "IHttpExpectationHeaderValueFactory": ["4ea275cb-d53e-4868-8856-1e21a5030dc0"],
    "IHttpExpectationHeaderValueStatics": ["3019abe2-cfe5-473b-a57f-fba5b14eb257"],
    "IHttpFilter": ["a4cb6dd5-0902-439e-bfd7-e12552b165ce"],
    "IHttpFormUrlEncodedContentFactory": ["43f0138c-2f73-4302-b5f3-eae9238a5e01"],
    "IHttpGetBufferResult": ["53d08e7c-e209-404e-9a49-742d8236fd3a"],
    "IHttpGetInputStreamResult": ["d5d63463-13aa-4ee0-be95-a0c39fe91203"],
    "IHttpGetStringResult": ["9bac466d-8509-4775-b16d-8953f47a7f5f"],
    "IHttpLanguageHeaderValueCollection": ["9ebd7ca3-8219-44f6-9902-8c56dfd3340c"],
    "IHttpLanguageRangeWithQualityHeaderValue": ["7256e102-0080-4db4-a083-7de7b2e5ba4c"],
    "IHttpLanguageRangeWithQualityHeaderValueCollection": ["885d5abd-4b4f-480a-89ce-8aedcee6e3a0"],
    "IHttpLanguageRangeWithQualityHeaderValueFactory": ["7bb83970-780f-4c83-9fe4-dc3087f6bd55"],
    "IHttpLanguageRangeWithQualityHeaderValueStatics": ["2541e146-f308-46f5-b695-42f54024ec68"],
    "IHttpMapTileDataSource": ["9d03cb5c-fd79-4795-87be-7e54ca0b37d0"],
    "IHttpMapTileDataSourceFactory": ["53b4b107-84dc-4291-89f8-6d0bb612a055"],
    "IHttpMediaTypeHeaderValue": ["16b28533-e728-4fcb-bdb0-08a431a14844"],
    "IHttpMediaTypeHeaderValueFactory": ["bed747a8-cd17-42dd-9367-ab9c5b56dd7d"],
    "IHttpMediaTypeHeaderValueStatics": ["e04d83df-1d41-4d8c-a2de-6fd2ed87399b"],
    "IHttpMediaTypeWithQualityHeaderValue": ["188d5e32-76be-44a0-b1cd-2074bded2dde"],
    "IHttpMediaTypeWithQualityHeaderValueCollection": ["3c0c6b73-1342-4587-a056-18d02ff67165"],
    "IHttpMediaTypeWithQualityHeaderValueFactory": ["4c6d20f4-9457-44e6-a323-d122b958780b"],
    "IHttpMediaTypeWithQualityHeaderValueStatics": ["5b070cd9-b560-4fc8-9835-7e6c0a657b24"],
    "IHttpMethod": ["728d4022-700d-4fe0-afa5-40299c58dbfd"],
    "IHttpMethodFactory": ["3c51d10d-36d7-40f8-a86d-e759caf2f83f"],
    "IHttpMethodHeaderValueCollection": ["43bc3ff4-6119-4adf-938c-34bfffcf92ed"],
    "IHttpMethodStatics": ["64d171f0-d99a-4153-8dc6-d68cc4cce317"],
    "IHttpMultipartContent": ["df916aff-9926-4ac9-aaf1-e0d04ef09bb9"],
    "IHttpMultipartContentFactory": ["7eb42e62-0222-4f20-b372-47d5db5d33b4"],
    "IHttpMultipartFormDataContent": ["64d337e2-e967-4624-b6d1-cf74604a4a42"],
    "IHttpMultipartFormDataContentFactory": ["a04d7311-5017-4622-93a8-49b24a4fcbfc"],
    "IHttpNameValueHeaderValue": ["d8ba7463-5b9a-4d1b-93f9-aa5b44ecfddf"],
    "IHttpNameValueHeaderValueFactory": ["770e2267-cbf8-4736-a925-93fbe10c7ca8"],
    "IHttpNameValueHeaderValueStatics": ["ffd4030f-1130-4152-8659-256909a9d115"],
    "IHttpNegotiate3": ["57b6c80a-34c2-4602-bc26-66a02fc57153"],
    "IHttpProductHeaderValue": ["f4feee03-ebd4-4160-b9ff-807c5183b6e6"],
    "IHttpProductHeaderValueFactory": ["611aa4f5-82bc-42fb-977b-dc00536e5e86"],
    "IHttpProductHeaderValueStatics": ["90c33e29-befc-4337-be62-49f097975f53"],
    "IHttpProductInfoHeaderValue": ["1b1a8732-4c35-486a-966f-646489198e4d"],
    "IHttpProductInfoHeaderValueCollection": ["877df74a-d69b-44f8-ad4f-453af9c42ed0"],
    "IHttpProductInfoHeaderValueFactory": ["24220fbe-eabe-4464-b460-ec010b7c41e2"],
    "IHttpProductInfoHeaderValueStatics": ["db7fd857-327a-4e73-81e5-7059a302b042"],
    "IHttpRequestHeaderCollection": ["af40329b-b544-469b-86b9-ac3d466fea36"],
    "IHttpRequestMessage": ["f5762b3c-74d4-4811-b5dc-9f8b4e2f9abf"],
    "IHttpRequestMessageFactory": ["5bac994e-3886-412e-aec3-52ec7f25616f"],
    "IHttpRequestResult": ["6acf4da8-b5eb-4a35-a902-4217fbe820c5"],
    "IHttpResponseHeaderCollection": ["7a990969-fa3f-41ed-aac6-bf957975c16b"],
    "IHttpResponseMessage": ["fee200fb-8664-44e0-95d9-42696199bffc"],
    "IHttpResponseMessageFactory": ["52a8af99-f095-43da-b60f-7cfc2bc7ea2f"],
    "IHttpServerCustomValidationRequestedEventArgs": ["3165fe32-e7dd-48b7-a361-939c750e63cc"],
    "IHttpStreamContentFactory": ["f3e64d9d-f725-407e-942f-0eda189809f4"],
    "IHttpStringContentFactory": ["46649d5b-2e93-48eb-8e61-19677878e57f"],
    "IHttpTransferCodingHeaderValue": ["436f32f9-3ded-42bd-b38a-5496a2511ce6"],
    "IHttpTransferCodingHeaderValueCollection": ["202c8c34-2c03-49b8-9665-73e27cb2fc79"],
    "IHttpTransferCodingHeaderValueFactory": ["bb62dffc-e361-4f08-8e4f-c9e723de703b"],
    "IHttpTransferCodingHeaderValueStatics": ["6ab8892a-1a98-4d32-a906-7470a9875ce5"],
    "IHttpTransportInformation": ["70127198-c6a7-4ed0-833a-83fd8b8f178d"],
    "IHub": ["ae692e82-7314-4f51-ab11-2af1ed4a19f8"],
    "IHubAutomationPeer": ["4ddee056-4ebc-4620-a05d-903e3c9a4ead"],
    "IHubAutomationPeerFactory": ["c762d43f-79dd-43ee-8777-8d08b39aa065"],
    "IHubFactory": ["dca6b2ba-c6f5-4961-9953-c51873db5424"],
    "IHubSection": ["a4e66cb7-7fdd-4fe0-ab49-c246639dccf9"],
    "IHubSectionAutomationPeer": ["16d91ff7-7431-4d82-83ce-cfa3192b0f18"],
    "IHubSectionAutomationPeerFactory": ["c68e27e8-17ec-4329-91ae-2d0b2339d498"],
    "IHubSectionFactory": ["fff55fa2-ece4-4bba-aa3b-9804aef47883"],
    "IHubSectionHeaderClickEventArgs": ["e1c5ef04-1edd-4112-aeeb-996c96400698"],
    "IHubSectionHeaderClickEventHandler": ["afe17b9b-9c63-4583-88e4-c59019b7f49d"],
    "IHubSectionStatics": ["12d2d85a-ea27-42d1-998b-61e52aed842b"],
    "IHubStatics": ["0e6fa034-ad3c-4f32-b701-e24fab562028"],
    "IHxHelpPane": ["8cec5884-07a1-11d9-b15e-000d56bfe6ee"],
    "IHxInteractiveUser": ["8cec595b-07a1-11d9-b15e-000d56bfe6ee"],
    "IHyperlink": ["0fe2363b-14e9-4152-9e58-5aea5b21f08d"],
    "IHyperlink2": ["4ce9da5f-7cff-4291-b78f-dfec72490576"],
    "IHyperlink3": ["c3f157d9-e5d3-4fb7-8702-4f6d85dd9e0a"],
    "IHyperlink4": ["f7d02959-82fb-400a-a407-5a4ee677988a"],
    "IHyperlink5": ["607dd7d2-0945-4328-91ee-94ccec2ea6c3"],
    "IHyperlinkButton": ["ccebaca3-3b5c-4f4c-9bfd-86887bc79772"],
    "IHyperlinkButtonAutomationPeer": ["aa7afcb1-0edf-46d9-aa9e-0eb21d140097"],
    "IHyperlinkButtonAutomationPeerFactory": ["59bc1661-c182-49af-9526-44b88e628455"],
    "IHyperlinkButtonFactory": ["43521bad-4e97-4da9-a64d-935dfd8cedf2"],
    "IHyperlinkButtonStatics": ["fbaeb5c7-cdb7-4263-b7d6-3c0d2904ed98"],
    "IHyperlinkClickEventArgs": ["c755916b-7bdc-4be7-b373-9240a503d870"],
    "IHyperlinkStatics": ["3a44d3d4-fd41-41db-8c72-3b790acd9fd3"],
    "IHyperlinkStatics2": ["5028d8b7-7adf-43ee-a4ae-9c925f755716"],
    "IHyperlinkStatics3": ["3e15dea0-205e-4947-99a5-74e757e8e1b4"],
    "IHyperlinkStatics4": ["0476b378-8faa-4e24-b3b6-e9de4d3c708c"],
    "IHyperlinkStatics5": ["59308cea-1e49-4921-bd88-a2878d07e30e"],
    "II2cConnectionSettings": ["f2db1307-ab6f-4639-a767-54536dc3460f"],
    "II2cConnectionSettingsFactory": ["81b586b3-9693-41b1-a243-ded4f6e66926"],
    "II2cController": ["c48ab1b2-87a0-4166-8e3e-b4b8f97cd729"],
    "II2cControllerProvider": ["61c2bb82-4510-4163-a87c-4e15a9558980"],
    "II2cControllerStatics": ["40fc0365-5f05-4e7e-84bd-100db8e0aec5"],
    "II2cDevice": ["8636c136-b9c5-4f70-9449-cc46dc6f57eb"],
    "II2cDeviceProvider": ["ad342654-57e8-453e-8329-d1e447d103a9"],
    "II2cDeviceStatics": ["91a33be3-7334-4512-96bc-fbae9459f5f6"],
    "II2cProvider": ["6f13083e-bf62-4fe2-a95a-f08999669818"],
    "IICCSVGColor": ["305104d6-98b5-11cf-bb82-00aa00bdce0b"],
    "IIE70DispatchEx": ["3051046b-98b5-11cf-bb82-00aa00bdce0b"],
    "IIE80DispatchEx": ["3051046c-98b5-11cf-bb82-00aa00bdce0b"],
    "IIEDownloadManager": ["15f6b27f-70f6-46d9-bc53-8d274c2d74d6"],
    "IIEEventHandler": ["01985350-df2a-473f-9bc9-ceb4d0ca10ef"],
    "IIEObjectWithProgID": ["f6a76981-4245-4415-8a38-d2790017ad73"],
    "IIETravelEntry2": ["21e1115f-0dde-45b5-8eb5-773054644299"],
    "IIETravelEntry3": ["b3e0e6ed-dc8c-4161-9f13-d8be42f4cba9"],
    "IIETravelEntry4": ["5464942c-6a4b-4a4b-81ba-cc0d17c3c090"],
    "IIETravelEntryEvents": ["39b21fe4-d4d3-47d1-98ba-262c28bf3e2c"],
    "IIETravelLog2": ["19bb515b-da44-4bcc-8625-6ad1be065692"],
    "IIETravelLogClientWrapper": ["671ecd53-3291-4eab-9fb4-079e11e4e894"],
    "IIETravelLogEx": ["dd9e2b32-4d78-44f1-b59b-8ca4c9392140"],
    "IIEWebDriverManager": ["bd1dc630-6590-4ca2-a293-6bc72b2438d8"],
    "IIEWebDriverSite": ["ffb84444-453d-4fbc-9f9d-8db5c471ec75"],
    "IIISApplicationAdmin": ["7c4e1804-e342-483d-a43e-a850cfcc8d18"],
    "IIISApplicationAdmin2": ["d643717a-fc87-4260-88ac-6ce35f0ec14e"],
    "IIMContactHandler": ["eb17d9f5-2eee-4d4a-9cfe-c954689ea7e8"],
    "IIMSICompletion": ["a9342324-da50-46b2-ba1c-2b1cb60c3817"],
    "IINETLOG_INFORMATION": ["cc557a71-f61a-11cf-bc0f-00aa006111e0"],
    "IIOCancelInformation": ["f5b0bf81-8cb5-4b1b-9449-1a159e0c733c"],
    "IIOControlCode": ["0e9559e7-60c8-4375-a761-7f8808066c60"],
    "IIOControlCodeFactory": ["856a7cf0-4c11-44ae-afc6-b8d4a212788f"],
    "IIPDVDec": ["b8e8bd60-0bfe-11d0-af91-00aa00b67a42"],
    "IIPInformation": ["d85145e0-138f-47d7-9b3a-36bb488cef33"],
    "IIRawElementProviderSimple": ["ec752224-9b77-4720-bb21-4ac89fdb1afd"],
    "IISApp": ["46fbbb80-0192-11d1-9c39-00a0c922e703"],
    "IISApp2": ["603dcbea-7350-11d2-a7be-0000f8085b95"],
    "IISApp3": ["2812b639-8fac-4510-96c5-71ddbd1f54fc"],
    "IISApplicationPool": ["0b3cb1e1-829a-4c06-8b09-f56da1894c88"],
    "IISApplicationPools": ["587f123f-49b4-49dd-939e-f4547aa3fa75"],
    "IISComputer": ["cf87a2e0-078b-11d1-9c3d-00a0c922e703"],
    "IISComputer2": ["63d89839-5762-4a68-b1b9-3507ea76cbbf"],
    "IISDBSLocator": ["c9897087-e29c-473f-9e4b-7072123dea14"],
    "IISDB_BIT": ["537cd71e-0e46-4173-9001-ba043f3e49e2"],
    "IISDB_CDT": ["25fa92c2-8b80-4787-a841-3a0e8f17984b"],
    "IISDB_EMM": ["0edb556d-43ad-4938-9668-321b2ffecfd3"],
    "IISDB_LDT": ["141a546b-02ff-4fb9-a3a3-2f074b74a9a9"],
    "IISDB_NBIT": ["1b1863ef-08f1-40b7-a559-3b1eff8cafa6"],
    "IISDB_SDT": ["3f3dc9a2-bb32-4fb9-ae9e-d856848927a3"],
    "IISDB_SDTT": ["ee60ef2d-813a-4dc7-bf92-ea13dac85313"],
    "IISDsCrMap": ["edcd6a60-b053-11d0-a62f-00a0c922e752"],
    "IISWebService": ["ee46d40c-1b38-4a02-898d-358e74dfc9d2"],
    "IITBuildCollect": ["8fa0d5a5-dedf-11d0-9a61-00c04fb68bf7"],
    "IITCmdInt": ["4cf34c30-9bf9-11d0-8764-00a0c913f764"],
    "IITDatabase": ["8fa0d5a2-dedf-11d0-9a61-00c04fb68bf7"],
    "IITPropList": ["1f403bb1-9997-11d0-a850-00aa006c7d01"],
    "IITResultSet": ["3bb91d41-998b-11d0-a850-00aa006c7d01"],
    "IITStopWordList": ["8fa0d5ad-dedf-11d0-9a61-00c04fb68bf7"],
    "IITSvMgr": ["4e7da031-9c11-11d0-8764-00a0c913f764"],
    "IITWordWheel": ["8fa0d5a4-dedf-11d0-9a61-00c04fb68bf7"],
    "IIconElement": ["9af0803b-d04c-467a-bbd5-9b81f02d9a56"],
    "IIconElementFactory": ["cf37a562-0424-43c7-8bea-720fba973ef1"],
    "IIconElementStatics": ["be19a623-77cf-472f-82ea-047801d12012"],
    "IIconSource": ["92ec8d55-45eb-47a4-863c-91b224044f9b"],
    "IIconSourceElement": ["d7a64502-ddda-55cd-b4c9-e79abc8b0ea4"],
    "IIconSourceElementFactory": ["26b59fab-2092-5b95-b59e-f27f210689e7"],
    "IIconSourceElementStatics": ["f37cfd45-f3d8-50ff-a1b8-0fba4ae61d79"],
    "IIconSourceFactory": ["4d117cf1-1fd6-49d7-b483-02ec3de997d6"],
    "IIconSourceStatics": ["1d389dbe-1cd3-4f4f-83b0-55dc6387685b"],
    "IIdentifyHive": ["f75ceccd-5a36-474b-a324-07f57a1ed9d2"],
    "IIdentityAdvise": ["4e982fed-d14b-440c-b8d6-bb386453d386"],
    "IIdentityAuthentication": ["5e7ef254-979f-43b5-b74e-06e4eb7df0f9"],
    "IIdentityAuthority": ["261a6983-c35d-4d0d-aa5b-7867259e77bc"],
    "IIdentityName": ["7d903fca-d6f9-4810-8332-946c0177e247"],
    "IIdentityPath": ["52958b02-bcca-41cf-a447-d24f460b24e9"],
    "IIdentityProvider": ["0d1b9e0c-e8ba-4f55-a81b-bce934b948f5"],
    "IIdentityStore": ["df586fa5-6f35-44f1-b209-b38e169772eb"],
    "IIdentityStore2": ["7c0c01e3-b1d3-4823-8441-c39e08bf02fa"],
    "IIdentityStoreEx": ["f9f9eb98-8f7f-4e38-9577-6980114ce32b"],
    "IIdleDispatchedHandler": ["a42b0c24-7f21-4abc-99c1-8f01007f0880"],
    "IIdleDispatchedHandlerArgs": ["98bb6a24-dc1c-43cb-b4ed-d1c0eb2391f3"],
    "IIdleSettings": ["84594461-0053-4342-a8fd-088fabf11f32"],
    "IIdleTask": ["f08ce0d0-c2d0-4d54-a6ad-d32646f54aa0"],
    "IIdleTaskHost": ["d9befc84-f21e-4166-874b-a8d3010dc764"],
    "IIdleTrigger": ["d537d2b0-9fb3-4d34-9739-1ff5ce7b1ef3"],
    "IIisServiceControl": ["e8fb8620-588f-11d2-9d61-00c04f79c5fe"],
    "IImage2": ["f445119e-881f-48bb-873a-64417ca4f002"],
    "IImage3": ["06ebe792-47c2-4d92-a488-8cd685d06aca"],
    "IImageAutomationPeer": ["9b0bbf8c-60a2-48bf-ab2c-1a52a451d2d4"],
    "IImageAutomationPeerFactory": ["90304003-687d-47bf-b3a2-4babcad8ef50"],
    "IImageBrush": ["9fd11377-c12a-4493-bf7d-f3a8ad74b554"],
    "IImageBrushStatics": ["1255b1b2-dd18-42e5-892c-eae30c305b8c"],
    "IImageBytes": ["025d1823-6c7d-447b-bbdb-a3cbc3dfa2fc"],
    "IImageCombo": ["dd9da664-8594-11d1-b16a-00c0f0283628"],
    "IImageCue": ["52828282-367b-440b-9116-3c84570dd270"],
    "IImageDecodeEventSink2": ["8ebd8a57-8a96-48c9-84a6-962e2db9c931"],
    "IImageDecoder": ["327abdab-072b-11d3-9d7b-0000f81ef32e"],
    "IImageDisplayProperties": ["cd0bc7ef-54e7-411f-9933-f0e98b0a96d2"],
    "IImageDownload": ["6266a09e-5af8-4024-aa55-429eeab0e85c"],
    "IImageDownloadSink": ["96c5be7f-88d5-40df-a8bc-e9e39e006eae"],
    "IImageEncoder": ["327abdac-072b-11d3-9d7b-0000f81ef32e"],
    "IImageEncodingProperties": ["78625635-f331-4189-b1c3-b48d5ae034f1"],
    "IImageEncodingProperties2": ["c854a2df-c923-469b-ac8e-6a9f3c1cd9e3"],
    "IImageEncodingPropertiesStatics": ["257c68dc-8b99-439e-aa59-913a36161297"],
    "IImageEncodingPropertiesStatics2": ["f6c25b29-3824-46b0-956e-501329e1be3c"],
    "IImageEncodingPropertiesStatics3": ["48f4814d-a2ff-48dc-8ea0-e90680663656"],
    "IImageFeatureDescriptor": ["365585a5-171a-4a2a-985f-265159d3895a"],
    "IImageFeatureValue": ["f0414fd9-c9aa-4405-b7fb-94f87c8a3037"],
    "IImageFeatureValueStatics": ["1bc317fd-23cb-4610-b085-c8e1c87ebaa0"],
    "IImageFilter": ["cdbf2040-c624-11cf-b584-00aa00a71d1a"],
    "IImageHandle": ["b4d44e85-fcf6-481e-bfbf-cdf3a573e298"],
    "IImageInformation": ["7c907864-346c-4aeb-8f3f-57da289f969f"],
    "IImageList2": ["192b9d83-50fc-457b-90a0-2b82a8b5dae1"],
    "IImageProcessorForRoaming": ["d14e769b-4502-48a7-99af-0fc558ef35c7"],
    "IImageProperties": ["523c9424-fcff-4275-afee-ecdb9ab47973"],
    "IImageQueueManager": ["f9e87849-b323-eefa-3204-8a2d2d2b4432"],
    "IImageSanitizationBroker": ["06765610-54ea-4db8-a9c6-0d0f8d1e73d4"],
    "IImageSanitizationValidator": ["3a05b5ea-527e-4c9b-ba53-58aca78d0b56"],
    "IImageScanner": ["53a88f78-5298-48a0-8da3-8087519665e0"],
    "IImageScannerFeederConfiguration": ["74bdacee-fa97-4c17-8280-40e39c6dcc67"],
    "IImageScannerFormatConfiguration": ["ae275d11-dadf-4010-bf10-cca5c83dcbb0"],
    "IImageScannerPreviewResult": ["08b7fe8e-8891-441d-be9c-176fa109c8bb"],
    "IImageScannerScanResult": ["c91624cd-9037-4e48-84c1-ac0975076bc5"],
    "IImageScannerSourceConfiguration": ["bfb50055-0b44-4c82-9e89-205f9c234e59"],
    "IImageScannerStatics": ["bc57e70e-d804-4477-9fb5-b911b5473897"],
    "IImageSink": ["327abdae-072b-11d3-9d7b-0000f81ef32e"],
    "IImageSource": ["737ef309-ea41-4d96-a71c-98e98efcab07"],
    "IImageSourceFactory": ["297ec001-2540-4e5a-ab66-88035dd3ddb5"],
    "IImageStatics": ["89903772-c336-43d1-9d51-c3bbd5d5d691"],
    "IImageTransform": ["732b4749-8d28-4cc2-8b9e-b4a7583d488b"],
    "IImageTransformParameters": ["cd589afd-9a50-4594-8b52-797029577be5"],
    "IImages": ["2c247f24-8591-11d1-b16a-00c0f0283628"],
    "IImePad": ["5d8e643a-c3a9-11d1-afef-00805f0c8b6d"],
    "IImePadApplet": ["5d8e643b-c3a9-11d1-afef-00805f0c8b6d"],
    "IImePlugInDictDictionaryList": ["98752974-b0a6-489b-8f6f-bff3769c8eeb"],
    "IImeSpecifyApplets": ["5d8e643c-c3a9-11d1-afef-00805f0c8b6d"],
    "IImgCreateErrorInfo": ["1c55a64c-07cd-4fb5-90f7-b753d91f0c9e"],
    "IImgErrorInfo": ["2bce4ece-d30e-445a-9423-6829be945ad8"],
    "IImgFileItem": ["bf29a939-56cf-44e3-bf31-8007dd67a517"],
    "IImgFilePool": ["2947feb1-c585-4d69-bd63-5ff0effec831"],
    "IImgFilePoolX": ["90d1bbb2-2421-4034-b30d-d774e2d3fb3b"],
    "IImgWriterFileItem": ["c01f00b2-147a-4027-9fa6-b5430da48d77"],
    "IImgWriterFileItemX": ["2d9a89a9-0449-4dab-8300-842860d60aa7"],
    "IImmersiveAccountsSettings": ["82cfe484-6292-4c11-8260-b36817031c9b"],
    "IImmersiveAppCrusher": ["55c8429b-3f9e-4736-96a2-1c56e2dfc883"],
    "IImmersiveAppCrusherNotification": ["1bf3dc4c-07a0-4f3f-87f8-5a625cd2e7ad"],
    "IImmersiveAppCrusherNotificationService": ["0c0f0f3c-7bab-426c-84fc-c682fc0375d0"],
    "IImmersiveAppPositioner": ["8faec766-bd4b-4c16-9dce-a7d4226c66b6"],
    "IImmersiveApplication": ["8b14e88b-5663-4caf-b196-c31479262831"],
    "IImmersiveApplicationArray": ["c6ed6dac-8fac-4598-a74c-69020137149c"],
    "IImmersiveApplicationArrayService": ["a3c23ab7-6be2-4778-8eb0-1adb7977f76a"],
    "IImmersiveApplicationDebugControlInternal": ["683906e1-1771-40a1-bbd6-409cc4c8e268"],
    "IImmersiveApplicationDebugControlInternal2": ["f63c57d3-03a2-40a9-ab07-7fc0d51184b2"],
    "IImmersiveApplicationHolographic": ["f4921d4f-67d4-4ca9-9ec4-0bc577bb904e"],
    "IImmersiveApplicationManager": ["bf63999f-7411-40da-861c-df72c0ffee84"],
    "IImmersiveApplicationNotification": ["e23730be-13f1-4f0b-88ab-76d5e3beb5b7"],
    "IImmersiveApplicationNotificationService": ["7860c098-fb29-49aa-a512-adacc0ffee84"],
    "IImmersiveApplicationTitleBarManager": ["ef50bc9f-87d2-4ec5-a007-d94d7ff66f24"],
    "IImmersiveApplicationVisibilityOverride": ["53f83578-492b-4e8f-8096-3d3dd1260aa6"],
    "IImmersiveApplicationWindow": ["c6636ec2-eba1-4e6d-a995-8fa14b8b2891"],
    "IImmersiveBackstackManager": ["dbea162d-04e8-460f-8a0b-4a431715d9a3"],
    "IImmersiveBackstackManagerPriv": ["c68619de-d7bf-4586-aa6c-02f2177708e9"],
    "IImmersiveBackstackSettings": ["8d294980-9ce1-42ac-8f77-11fa93d47324"],
    "IImmersiveCharmsWindowManager": ["351c9530-3568-4ec4-bb33-9e2dc0ffee84"],
    "IImmersiveExpressionSanitizationBroker": ["dd864693-2f00-4cf9-a4c7-2f7c386a8a1d"],
    "IImmersiveFrameworkInputPaneForwarder": ["87da1e67-cafa-4fab-99f5-9427b2d5b2de"],
    "IImmersiveHomeGroupCPLCallback": ["c16411cb-4c7c-4384-9776-1ebb10d50c6d"],
    "IImmersiveLauncher": ["d8d60399-a0f1-f987-5551-321fd1b49864"],
    "IImmersiveLauncherCortana": ["5ef7890f-319b-4259-8d0f-36e5ff0916ce"],
    "IImmersiveLauncherSearchTaskEvent": ["7f9bad1e-c1c4-46b4-a9ea-c8ec56d20357"],
    "IImmersiveLauncherTrayNotify": ["bcf1f74f-2413-46b3-8707-ec2fca11965d"],
    "IImmersiveLayout": ["d770b2ad-8f5e-4b8e-b3df-f05a2ab5287c"],
    "IImmersiveLayoutChanges": ["6a5e657d-223a-4875-838b-c311ed73523b"],
    "IImmersiveLayoutClient": ["05088755-ef51-4684-8f7c-b07c8d5d5f39"],
    "IImmersiveMonitor": ["880b26f8-9197-43d0-8045-8702d0d72000"],
    "IImmersiveMonitorManager": ["4d4c1e64-e410-4faa-bafa-59ca069bfec2"],
    "IImmersiveMonitorNotification": ["940c223d-5bdc-49db-968c-e4f3ef9b9270"],
    "IImmersiveMonitorNotificationService": ["7c7a3e75-4362-4d12-860d-68ee72909f83"],
    "IImmersiveSessionIdleDetector": ["a340ae45-86bf-4c9c-b6c8-6109ca1e2f29"],
    "IImmersiveSessionIdleNotification": ["985c98a3-21f6-4585-9e13-f708cb0de4f2"],
    "IImmersiveSettings": ["7665c60a-c9a7-4306-ae31-bf520214fa71"],
    "IImmersiveSettingsCache": ["4214f6fa-eb36-4e2f-9ca2-23fdc1832df7"],
    "IImmersiveSettingsCacheNotification": ["0b40e4e6-2749-461f-9a84-29491c297f86"],
    "IImmersiveShellBroker": ["9767060c-9476-42e2-8f7b-2f10fd13765c"],
    "IImmersiveShellComponent": ["e67ad469-a445-4371-82a5-7a5cefa85fc4"],
    "IImmersiveShellCreationBehavior": ["5d6c0d20-18bb-403c-becf-46e01ee3bfe4"],
    "IImmersiveShellHookNotification": ["4b25b8ee-6129-45e4-b527-f376f89c9c8c"],
    "IImmersiveShellHookService": ["914d9b3a-5e53-4e14-bbba-46062acb35a4"],
    "IImmersiveShellTracingHandler": ["dded82e1-c4f9-43f0-93f0-76dd2375caea"],
    "IImmersiveShellTracingService": ["6c36f018-4d3d-427c-8136-ea21290abd5c"],
    "IImmersiveSystemMode": ["ea9aac7d-0cac-4ceb-981c-4545a28bada2"],
    "IImmersiveSystemModeNotification": ["8ec4fc3a-ddb1-4e84-a7fc-210ec0ffee84"],
    "IImmersiveSystemModeNotificationService": ["ac2af908-82b1-40b3-a94d-18c2c0ffee84"],
    "IImmersiveWindowManager": ["611aa8fe-b694-4129-86af-2c2553fff785"],
    "IImmersiveWindowMessageService": ["bf8b6ede-2069-4010-a9e7-4480e24c01ca"],
    "IImpersonateCallback": ["99b01d17-9fbd-4aa6-b16d-82dab6a4107f"],
    "IImpersonateClipboardOwner": ["b6fb7c7c-0bb2-4c59-b866-d6b153521af6"],
    "IImplicitAnimationCollection": ["0598a3ff-0a92-4c9d-a427-b25519250dbf"],
    "IImportBroker": ["01463365-9a8d-4602-9aac-40754a8c0750"],
    "IInclinometer": ["2648ca6f-2286-406f-9161-f0c4bd806ebf"],
    "IInclinometer2": ["029f3393-28b2-45f8-bb16-61e86a7fae6e"],
    "IInclinometer3": ["3a095004-d765-4384-a3d7-0283f3abe6ae"],
    "IInclinometer4": ["43852618-8fca-548e-bbf5-5c50412b6aa4"],
    "IInclinometerDataThreshold": ["f80a4783-7bfe-545e-bb60-a0ebc47bd2fb"],
    "IInclinometerDeviceId": ["01e91982-41ff-4406-ae83-62210ff16fe3"],
    "IInclinometerReading": ["9f44f055-b6f6-497f-b127-1a775e501458"],
    "IInclinometerReading2": ["4f164781-e90b-4658-8915-0103e08a805a"],
    "IInclinometerReadingChangedEventArgs": ["4ae91dc1-e7eb-4938-8511-ae0d6b440438"],
    "IInclinometerReadingYawAccuracy": ["b453e880-1fe3-4986-a257-e6ece2723949"],
    "IInclinometerStatics": ["f22ec551-9c30-453a-8b49-3c3eeb33cb61"],
    "IInclinometerStatics2": ["043f9775-6a1e-499c-86e0-638c1a864b00"],
    "IInclinometerStatics3": ["bd9a4280-b91a-4829-9392-abc0b6bdf2b4"],
    "IInclinometerStatics4": ["e8ba96f9-6e85-4a83-aed0-d7cdcc9856c8"],
    "IIncrementNumberRounder": ["70a64ff8-66ab-4155-9da1-739e46764543"],
    "IIncrementalFillCallback": ["72eb0e17-af29-425e-a698-613587058a9a"],
    "IIndexDefinition": ["0c733a68-2a1c-11ce-ade5-00aa0044773d"],
    "IIndexPerfCounters": ["8e4225c5-886c-4a40-914f-01765e175def"],
    "IIndexableConcept": ["d1fad99f-3f53-4457-850c-8051df2d3fb5"],
    "IIndexableContent": ["ccf1a05f-d4b5-483a-b06e-e0db1ec420e4"],
    "IIndexedResourceCandidate": ["0e619ef3-faec-4414-a9d7-54acd5953f29"],
    "IIndexedResourceQualifier": ["dae3bb9b-d304-497f-a168-a340042c8adb"],
    "IIndexerPlugIn": ["b0565244-9b10-425e-b616-1fcd828db3b1"],
    "IIndexerTasks": ["817b682b-5d96-4c97-9d71-1cb8d5478201"],
    "IInertiaExpansionBehavior": ["751d87e5-8d42-44c5-965e-3cd30cc9d6f7"],
    "IInertiaProcessor": ["18b00c6d-c5ee-41b1-90a9-9d4a929095ad"],
    "IInertiaRotationBehavior": ["424cfb2e-bbfd-4625-ae78-20c65bf1efaf"],
    "IInertiaTranslationBehavior": ["45d3a512-3b32-4882-a4c2-ecfa2d4b6df0"],
    "IInfoBarHost": ["e38fe0f3-3db0-47ee-a314-25cf7f4bf521"],
    "IInfoBarManager": ["9040e4e1-1ef9-4949-a379-36bc095d1ce4"],
    "IInfoPaneProvider": ["38698b65-1ca7-458c-b4d6-e0a51379c1d2"],
    "IInfraredMediaFrame": ["3fd13503-004b-4f0e-91ac-465299b41658"],
    "IInfraredTorchControl": ["1cba2c83-6cb6-5a04-a6fc-3be7b33ff056"],
    "IInitActivationPropertiesIn": ["000001a1-0000-0000-c000-000000000046"],
    "IInitCategoryEnum": ["46187751-37c4-4bd0-be08-7f954c2fd0d0"],
    "IInitCollection": ["1f074b83-6468-453b-82ab-1f4889934437"],
    "IInitEnumExplorerCommandOnMenu": ["974fc285-a627-490d-a293-0f5e8ab987fe"],
    "IInitViewLinkedWebOC": ["e787f2c0-3d21-4d98-85c8-a038195ba649"],
    "IInitializeCommand": ["85075acf-231f-40ea-9610-d26b7b58f638"],
    "IInitializeFolderInfoTip": ["cafec873-94b2-47a4-aa4a-6a54f2df865d"],
    "IInitializeIdentity": ["68d92253-f390-4036-bb23-05a5b4d90737"],
    "IInitializeMediaStreamSourceRequestedEventArgs": ["25bc45e1-9b08-4c2e-a855-4542f1a75deb"],
    "IInitializeNetworkFolder": ["6e0f9881-42a8-4f2a-97f8-8af4e026d92d"],
    "IInitializePropertyStore": ["de9c1991-1891-491c-b3a2-ee89c467c584"],
    "IInitializeProviderConfig": ["628880f3-0dc6-4359-a29b-15ef9aecbd23"],
    "IInitializeQueryResult": ["4eea50c7-78d0-47c2-b585-3b7c026ccc15"],
    "IInitializeResultSetFactory": ["c7858b50-f6b7-4bd4-a645-8a86c3fb9f52"],
    "IInitializeResultSetManager": ["d6effa92-c1ad-4416-b077-84d5e448bdb8"],
    "IInitializeResultShape": ["42c9f529-ac7b-45d3-a320-c2f23f250b94"],
    "IInitializeSettingHandler": ["6dbbd4c5-2cbb-4875-b22a-0ad7458894d9"],
    "IInitializeSettingHandlerFactory": ["c3f22887-8214-43bd-b660-ca604ac1264d"],
    "IInitializeSettingSyncProvider": ["908270d5-5fbe-4170-9504-fb7554d2e589"],
    "IInitializeSortColumnArray": ["e70c4a71-a5a1-40f2-84eb-9a9081e246a9"],
    "IInitializeWindowsPackageSettingHandler": ["6ffb50eb-65dc-4a8e-b417-4572ec1729a9"],
    "IInitializeWithBindCtx": ["71c0d2bc-726d-45cc-a6c0-2e31c1db2159"],
    "IInitializeWithCoreWindow": ["188f20d6-9873-464a-ace5-57e010f465e6"],
    "IInitializeWithDelegate": ["465a756d-45ad-4305-85fd-d3321650f3b7"],
    "IInitializeWithFile": ["b7d14566-0509-4cce-a71f-0a554233bd9b"],
    "IInitializeWithItem": ["7f73be3f-fb79-493c-a6c7-7ee14e245841"],
    "IInitializeWithItemArrayAndGPSFlags": ["8c59322f-f915-4757-9925-4fb4df1dd7d7"],
    "IInitializeWithPopupPersonality": ["6a193f22-6d3e-4803-b595-a581906c929b"],
    "IInitializeWithPropertyFactory": ["cb6d939d-7dfe-4e1e-aa08-d3bec4a0f1c6"],
    "IInitializeWithPropertyKeys": ["3bd82d8d-fb97-462a-b942-4bdfe8811a0c"],
    "IInitializeWithPropertyStore": ["c3e12eb5-7d8d-44f8-b6dd-0e77b34d6de4"],
    "IInitializeWithPropertyStores": ["b8158717-9161-46fd-b8d2-26d42185bc69"],
    "IInitializeWithQueryCancel": ["3f1cc7a7-1457-4810-adbd-33fb78a36bf8"],
    "IInitializeWithStream": ["b824b49d-22ac-4161-ac8a-9916e8fa3f7f"],
    "IInitializeWithWindow": ["3e68d4bd-7135-4d10-8018-9fb6d9f33fa1"],
    "IInitiateWinSATAssessment": ["d983fc50-f5bf-49d5-b5ed-cccb18aa7fc1"],
    "IInjectedInputGamepadInfo": ["20ae9a3f-df11-4572-a9ab-d75b8a5e48ad"],
    "IInjectedInputGamepadInfoFactory": ["59596876-6c39-4ec4-8b2a-29ef7de18aca"],
    "IInjectedInputKeyboardInfo": ["4b46d140-2b6a-5ffa-7eae-bd077b052acd"],
    "IInjectedInputMouseInfo": ["96f56e6b-e47a-5cf4-418d-8a5fb9670c7d"],
    "IInjectedInputPenInfo": ["6b40ad03-ca1e-5527-7e02-2828540bb1d4"],
    "IInjectedInputTouchInfo": ["224fd1df-43e8-5ef5-510a-69ca8c9b4c28"],
    "IInk": ["03f8e511-43a1-11d3-8bb6-0080c7d6bad5"],
    "IInkAnalysisInkBullet": ["ee049368-6110-4136-95f9-ee809fc20030"],
    "IInkAnalysisInkDrawing": ["6a85ed1f-1fe4-4e15-898c-8e112377e021"],
    "IInkAnalysisInkWord": ["4bd228ad-83af-4034-8f3b-f8687dfff436"],
    "IInkAnalysisLine": ["a06d048d-2b8d-4754-ad5a-d0871193a956"],
    "IInkAnalysisListItem": ["b4e3c23f-c4c3-4c3a-a1a6-9d85547ee586"],
    "IInkAnalysisNode": ["30831f05-5f64-4a2c-ba37-4f4887879574"],
    "IInkAnalysisParagraph": ["d9ad045c-0cd1-4dd4-a68b-eb1f12b3d727"],
    "IInkAnalysisResult": ["8948ba79-a243-4aa3-a294-1f98bd0ff580"],
    "IInkAnalysisRoot": ["3fb6a3c4-2fde-4061-8502-a90f32545b84"],
    "IInkAnalysisWritingRegion": ["dd6d6231-bd16-4663-b5ae-941d3043ef5b"],
    "IInkAnalyzer": ["f12b8f95-0866-4dc5-8c77-f88614dfe38c"],
    "IInkAnalyzerFactory": ["29138686-1963-49d8-9589-e14384c769e3"],
    "IInkCanvas": ["29443c28-8e48-4fc8-a473-35b0ba12acea"],
    "IInkCanvasFactory": ["924ac2de-ab04-48f0-9653-e0f2da4dbf1a"],
    "IInkCollector": ["f0f060b5-8b1f-4a7c-89ec-880692588a4f"],
    "IInkCommitRequestHandler": ["fabea3fc-b108-45b6-a9fc-8d08fa9f85cf"],
    "IInkCursor": ["ad30c630-40c5-4350-8405-9c71012fc558"],
    "IInkCursorButton": ["85ef9417-1d59-49b2-a13c-702c85430894"],
    "IInkCursorButtons": ["3671cc40-b624-4671-9fa0-db119d952d54"],
    "IInkCursors": ["a248c1ac-c698-4e06-9e5c-d57f77c7e647"],
    "IInkCustomStrokes": ["7e23a88f-c30e-420f-9bdb-28902543f0c1"],
    "IInkD2DRenderer": ["407fb1de-f85a-4150-97cf-b7fb274fb4f8"],
    "IInkD2DRenderer2": ["0a95dcd9-4578-4b71-b20b-bf664d4bfeee"],
    "IInkDesktopHost": ["4ce7d875-a981-4140-a1ff-ad93258e8d59"],
    "IInkDisp": ["9d398fa0-c4e2-4fcd-9973-975caaf47ea6"],
    "IInkDivider": ["5de00405-f9a4-4651-b0c5-c317defd58b9"],
    "IInkDivisionResult": ["2dbec0a7-74c7-4b38-81eb-aa8ef0c24900"],
    "IInkDivisionUnit": ["85aee342-48b0-4244-9dd5-1ed435410fab"],
    "IInkDivisionUnits": ["1bb5ddc2-31cc-4135-ab82-2c66c9f00c41"],
    "IInkDrawingAttributes": ["97a2176c-6774-48ad-84f0-48f5a9be74f9", "bf519b75-0a15-4623-adc9-c00d436a8092"],
    "IInkDrawingAttributes2": ["7cab6508-8ec4-42fd-a5a5-e4b7d1d5316d"],
    "IInkDrawingAttributes3": ["72020002-7d5b-4690-8af4-e664cbe2b74f"],
    "IInkDrawingAttributes4": ["ef65dc25-9f19-456d-91a3-bc3a3d91c5fb"],
    "IInkDrawingAttributes5": ["d11aa0bb-0775-4852-ae64-41143a7ae6c9"],
    "IInkDrawingAttributesPencilProperties": ["4f2534cb-2d86-41bb-b0e8-e4c2a0253c52"],
    "IInkDrawingAttributesStatics": ["f731e03f-1a65-4862-96cb-6e1665e17f6d"],
    "IInkEdit": ["f2127a19-fbfb-4aed-8464-3f36d78cfefb"],
    "IInkExtendedProperties": ["89f2a8be-95a9-4530-8b8f-88e971e3e25f"],
    "IInkExtendedProperty": ["db489209-b7c3-411d-90f6-1548cfff271e"],
    "IInkGesture": ["3bdc0a97-04e5-4e26-b813-18f052d41def"],
    "IInkHostWorkItem": ["ccda0a9a-1b78-4632-bb96-97800662e26c"],
    "IInkInputConfiguration": ["93a68dc4-0b7b-49d7-b34f-9901e524dcf2"],
    "IInkInputProcessingConfiguration": ["2778d85e-33ca-4b06-a6d3-ac3945116d37"],
    "IInkLineInfo": ["9c1c5ad6-f22f-4de4-b453-a2cc482e7c33"],
    "IInkManager": ["4744737d-671b-4163-9c95-4e8d7a035fe1"],
    "IInkModelerAttributes": ["bad31f27-0cd9-4bfd-b6f3-9e03ba8d7454"],
    "IInkModelerAttributes2": ["86d1d09a-4ef8-5e25-b7bc-b65424f16bb3"],
    "IInkOverlay": ["b82a463b-c1c5-45a3-997c-deab5651b67a"],
    "IInkPicture": ["e85662e0-379a-40d7-9b5c-757d233f9923"],
    "IInkPoint": ["9f87272b-858c-46a5-9b41-d195970459fd"],
    "IInkPoint2": ["fba9c3f7-ae56-4d5c-bd2f-0ac45f5e4af9"],
    "IInkPointFactory": ["29e5d51c-c98f-405d-9f3b-e53e31068d4d"],
    "IInkPointFactory2": ["e0145e85-daff-45f2-ad69-050d8256a209"],
    "IInkPresenter": ["a69b70e2-887b-458f-b173-4fe4438930a3"],
    "IInkPresenter2": ["cf53e612-9a34-11e6-9f33-a24fc0d9649c"],
    "IInkPresenter3": ["51e1ce89-d37d-4a90-83fc-7f5e9dfbf217"],
    "IInkPresenterDesktop": ["73f3c0d9-2e8b-48f3-895e-20cbd27b723b"],
    "IInkPresenterProtractor": ["7de3f2aa-ef6c-4e91-a73b-5b70d56fbd17"],
    "IInkPresenterProtractorFactory": ["320103c9-68fa-47e9-8127-8370711fc46c"],
    "IInkPresenterRuler": ["6cda7d5a-dec7-4dd7-877a-2133f183d48a"],
    "IInkPresenterRuler2": ["45130dc1-bc61-44d4-a423-54712ae671c4"],
    "IInkPresenterRulerFactory": ["34361beb-9001-4a4b-a690-69dbaf63e501"],
    "IInkPresenterStencil": ["30d12d6d-3e06-4d02-b116-277fb5d8addc"],
    "IInkRecognitionAlternate": ["b7e660ad-77e4-429b-adda-873780d1fc4a"],
    "IInkRecognitionAlternates": ["286a167f-9f19-4c61-9d53-4f07be622b84"],
    "IInkRecognitionResult": ["36461a94-5068-40ef-8a05-2c2fb60908a2", "3bc129a8-86cd-45ad-bde8-e0d32d61c16d"],
    "IInkRecognizer": ["077ccea3-904d-442a-b151-aaca3631c43b", "782bf7cf-034b-4396-8a32-3a1833cf6b56"],
    "IInkRecognizer2": ["6110118a-3a75-4ad6-b2aa-04b2b72bbe65"],
    "IInkRecognizerContainer": ["a74d9a31-8047-4698-a912-f82a5085012f"],
    "IInkRecognizerContext": ["c68f52f9-32a3-4625-906c-44fc23b40958"],
    "IInkRecognizerContext2": ["d6f0e32f-73d8-408e-8e9f-5fea592c363f"],
    "IInkRecognizerGuide": ["d934be07-7b84-4208-9136-83c20994e905"],
    "IInkRecognizers": ["9ccc4f12-b0b7-4a8b-bf58-4aeca4e8cefd"],
    "IInkRectangle": ["9794ff82-6071-4717-8a8b-6ac7c64a686e"],
    "IInkRenderer": ["e6257a9c-b511-4f4c-a8b0-a7dbc9506b83"],
    "IInkStroke": ["15144d60-cce3-4fcf-9d52-11518ab6afd4"],
    "IInkStroke2": ["5db9e4f4-bafa-4de1-89d3-201b1ed7d89b"],
    "IInkStroke3": ["4a807374-9499-411d-a1c4-68855d03d65f"],
    "IInkStrokeBuilder": ["82bbd1dc-1c63-41dc-9e07-4b4a70ced801"],
    "IInkStrokeBuilder2": ["bd82bc27-731f-4cbc-bbbf-6d468044f1e5"],
    "IInkStrokeBuilder3": ["b2c71fcd-5472-46b1-a81d-c37a3d169441"],
    "IInkStrokeContainer": ["22accbc6-faa9-4f14-b68c-f6cee670ae16"],
    "IInkStrokeContainer2": ["8901d364-da36-4bcf-9e5c-d195825995b4"],
    "IInkStrokeContainer3": ["3d07bea5-baea-4c82-a719-7b83da1067d2"],
    "IInkStrokeDisp": ["43242fea-91d1-4a72-963e-fbb91829cfa2"],
    "IInkStrokeInput": ["cf2ffe7b-5e10-43c6-a080-88f26e1dc67d"],
    "IInkStrokeRenderingSegment": ["68510f1f-88e3-477a-a2fa-569f5f1f9bd5"],
    "IInkStrokes": ["f1f4c9d8-590a-4963-b3ae-1935671bb6f3"],
    "IInkStrokesCollectedEventArgs": ["c4f3f229-1938-495c-b4d9-6de4b08d4811"],
    "IInkStrokesErasedEventArgs": ["a4216a22-1503-4ebf-8ff5-2de84584a8aa"],
    "IInkSynchronizer": ["9b9ea160-ae9b-45f9-8407-4b493b163661"],
    "IInkTablet": ["2de25eaa-6ef8-42d5-aee9-185bc81b912d"],
    "IInkTablet2": ["90c91ad2-fa36-49d6-9516-ce8d570f6f85"],
    "IInkTablet3": ["7e313997-1327-41dd-8ca9-79f24be17250"],
    "IInkTablets": ["112086d9-7779-4535-a699-862b43ac1863"],
    "IInkToolbar": ["3ddd0cca-51f0-486f-a03e-4ee13dc12bcb"],
    "IInkToolbar2": ["86f0c111-b484-454a-ae78-1d25a33d1c67"],
    "IInkToolbar3": ["a8a6def0-7aa8-5326-b7c4-88ae25013362"],
    "IInkToolbarAutomationPeer": ["123baaa4-f2e8-4bcb-9382-5dfdd11fe45f"],
    "IInkToolbarBallpointPenButton": ["158329f8-1e99-3acc-910f-9da2d872ae12"],
    "IInkToolbarBallpointPenButtonFactory": ["2f0bd3e4-d754-4255-8ec4-00cd101296ab"],
    "IInkToolbarCustomPen": ["4082207b-2f3d-4e6a-8c27-fe61ef7e70eb"],
    "IInkToolbarCustomPenButton": ["46024401-2b2a-4f3c-a53c-1a045a408efa"],
    "IInkToolbarCustomPenButtonFactory": ["0f2ef0ba-c8b9-4c36-8987-94d3dafede18"],
    "IInkToolbarCustomPenButtonStatics": ["373c25f4-e555-4e85-a80d-da6b8433dbde"],
    "IInkToolbarCustomPenFactory": ["d214d636-f1aa-4f48-bf2c-a926caae4c60"],
    "IInkToolbarCustomPenOverrides": ["9d22eb6c-1255-4256-b6bd-82c2fd273488"],
    "IInkToolbarCustomToggleButton": ["550c4d84-4f54-4fbe-b12b-e0a50aab0d05"],
    "IInkToolbarCustomToggleButtonFactory": ["4a00374d-4cd2-4ed9-863e-83b8cf3fd2af"],
    "IInkToolbarCustomToolButton": ["9f98acd7-c605-4105-be10-3943a7c0da3c"],
    "IInkToolbarCustomToolButtonFactory": ["c295fe4e-30eb-4130-a6b6-8c85d8e26e89"],
    "IInkToolbarCustomToolButtonStatics": ["11fe4cb9-bbac-4314-9344-92c6693ddeaf"],
    "IInkToolbarEraserButton": ["4cbdb92e-5f5e-4b35-a41c-16ffb0283bc0"],
    "IInkToolbarEraserButton2": ["e7a59257-5ae8-436d-b2e2-93c200900ca0"],
    "IInkToolbarEraserButtonFactory": ["fd40611d-d1ba-4d67-af00-148036ad492c"],
    "IInkToolbarEraserButtonStatics2": ["038a1736-c5cd-4311-83f4-38cbf07c2066"],
    "IInkToolbarFactory": ["3947aa99-36b1-4374-ab5c-98bf07a4320b"],
    "IInkToolbarFlyoutItem": ["92b68786-37ee-4915-9e89-e187564a889a"],
    "IInkToolbarFlyoutItemFactory": ["352e7b93-803b-4f0e-8c72-9dfc0329329f"],
    "IInkToolbarFlyoutItemStatics": ["1fe54b64-4063-4a5f-b89c-9f58935ee379"],
    "IInkToolbarHighlighterButton": ["0b3cc15b-7abf-487e-acc1-5b5048fee6d2"],
    "IInkToolbarHighlighterButtonFactory": ["7c334add-42ca-4943-94a4-23b5a6e55cf1"],
    "IInkToolbarIsStencilButtonCheckedChangedEventArgs": ["026edd26-d32b-4e28-a033-d5097662b292"],
    "IInkToolbarMenuButton": ["860ecae5-7633-4ea1-a209-50392d1aebd1"],
    "IInkToolbarMenuButtonFactory": ["7a463a9d-5dc7-44a7-afd0-2b685cb9a96c"],
    "IInkToolbarMenuButtonStatics": ["f03b17a6-b8b0-4a87-a961-37cd05d83137"],
    "IInkToolbarPenButton": ["e0b80c21-b032-40ee-a2b9-507f6ccb827b"],
    "IInkToolbarPenButtonFactory": ["b1463d21-59cb-4a83-92e1-692842797b2e"],
    "IInkToolbarPenButtonStatics": ["b922ce42-09f0-453d-8026-44daf2753f65"],
    "IInkToolbarPenConfigurationControl": ["601ae5f6-28a5-44cc-89a6-380e91a572dd"],
    "IInkToolbarPenConfigurationControlFactory": ["67f065ee-f5e7-46eb-9187-8d3ca3af891b"],
    "IInkToolbarPenConfigurationControlStatics": ["48a61bef-19ce-41bb-abe0-7c8726fae75e"],
    "IInkToolbarPencilButton": ["5b112832-1984-4148-9f25-382b35db087f"],
    "IInkToolbarPencilButtonFactory": ["db66d85f-cfd6-495f-93ab-b8566af9f8af"],
    "IInkToolbarStatics": ["a3b493bb-cb4f-4e6b-a33d-f11e7a295efa"],
    "IInkToolbarStatics2": ["aac1f8f2-2c1f-4e9c-b3f3-31ff22b51c7a"],
    "IInkToolbarStatics3": ["a0ee663d-b63f-516e-a0a4-0704c4544d62"],
    "IInkToolbarStencilButton": ["306a2616-5b40-4bf3-92b7-f1df936aeff5"],
    "IInkToolbarStencilButtonFactory": ["a20701d1-8a70-4d77-89d4-1730a3a58edf"],
    "IInkToolbarStencilButtonStatics": ["4748c07f-63e4-420d-939a-6b7243e9d124"],
    "IInkToolbarToggleButton": ["b4a278fa-f5f0-4b1f-beb0-0b8a29905a4a"],
    "IInkToolbarToggleButtonFactory": ["b2f90710-e5a1-4365-9d1a-e5b7ad8b9668"],
    "IInkToolbarToolButton": ["5c5af41e-ccb7-4458-8064-a9849d31561b"],
    "IInkToolbarToolButtonFactory": ["6293bf4b-89fe-4ed0-a1a6-88d3eba917b2"],
    "IInkToolbarToolButtonStatics": ["9e097d18-d136-4ef6-b0fd-1a78c2884a01"],
    "IInkTransform": ["615f1d43-8703-4565-88e2-8201d2ecd7b7"],
    "IInkUnprocessedInput": ["db4445e0-8398-4921-ac3b-ab978c5ba256"],
    "IInkWordList": ["76ba3491-cb2f-406b-9961-0e0c4cdaaef2"],
    "IInkWordList2": ["14542586-11bf-4f5f-b6e7-49d0744aab6e"],
    "IInkWorkspaceHostedAppBroker": ["3e75d5ee-bd10-4119-84b9-959626f49ab0"],
    "IInkWorkspaceHostedAppManager": ["fe0a7990-5e59-4bb7-8a63-7d218cd96300"],
    "IInkWorkspaceHostedAppManagerStatics": ["cbfd8cc5-a162-4bc4-84ee-e8716d5233c5"],
    "IInline": ["0c92712d-1bc9-4931-8cb1-1aeadf1cc685"],
    "IInlineFactory": ["4058acd1-2f90-4b8f-99dd-4218ef5f03de"],
    "IInlineUIContainer": ["1416ce81-28ee-452e-b121-5fc4f60b86a6"],
    "IInplaceShareEngine": ["cdf7745a-45b2-456e-8646-ab0c204404f9"],
    "IInputActivationListener": ["5d6d4ed2-28c7-5ae3-aa74-c918a9f243ca"],
    "IInputActivationListenerActivationChangedEventArgs": ["7699b465-1dcf-5791-b4b9-6cafbeed2056"],
    "IInputActivationListenerPreviewStatics": ["f0551ce5-0de6-5be0-a589-f737201a4582"],
    "IInputEnabledEventArgs": ["80371d4f-2fd8-4c24-aa86-3163a87b4e5a"],
    "IInputHostLayout": ["3a67c20b-df2d-4437-a761-0c41b441ac25"],
    "IInputHostLayoutCallback": ["624eeb56-662c-4406-a5a2-124f9ee9ee39"],
    "IInputHostLayoutChanges": ["4fb9f2b9-bdd6-47b9-9ebe-703eacdc1c8e"],
    "IInputHostManager": ["260b6f30-f9bc-452d-be7e-d8bdc0ea3a0a"],
    "IInputHostManagerBroker": ["2166ee67-71df-4476-8394-0ced2ed05274"],
    "IInputInjector": ["8ec26f84-0b02-4bd2-ad7a-3d4658be3e18"],
    "IInputInjector2": ["8e7a905d-1453-43a7-9bcb-06d6d7b305f7"],
    "IInputInjectorStatics": ["deae6943-7402-4141-a5c6-0c01aa57b16a"],
    "IInputInjectorStatics2": ["a4db38fb-dd8c-414f-95ea-f87ef4c0ae6c"],
    "IInputModeChangeNotifier": ["60aaa1e2-9cf9-4fdd-b24f-1b8988ab3603"],
    "IInputModeChangedEventArgs": ["15c6e4ab-dc40-400b-8ab3-3ce61f67df93"],
    "IInputModeChangedHandler": ["6ba4b426-dd10-47c8-a023-c22f13a5f596"],
    "IInputObject2": ["6915c085-510b-44cd-94af-28dfa56cf92b"],
    "IInputPane": ["640ada70-06f3-4c87-a678-9829c9127c28"],
    "IInputPane2": ["8a6b3f26-7090-4793-944c-c3f2cde26276"],
    "IInputPaneAnimationCoordinator": ["2af16ba9-2de5-4b75-82d9-01372afbffb4"],
    "IInputPaneControl": ["088bb24f-962f-489d-aa6e-c6be1a0a6e52"],
    "IInputPaneEventHandler": ["87482e5d-0157-459a-bd7c-cb18085be80f"],
    "IInputPaneInterop": ["75cf2c57-9195-4931-8332-f0b409e916af"],
    "IInputPaneStatics": ["95f4af3a-ef47-424a-9741-fd2815eba2bd"],
    "IInputPaneStatics2": ["1b63529b-d9ec-4531-8445-71bab9fb828e"],
    "IInputPaneVisibilityEventArgs": ["d243e016-d907-4fcc-bb8d-f77baa5028f1"],
    "IInputPanelConfiguration": ["41c81592-514c-48bd-a22e-e6af638521a6"],
    "IInputPanelInvocationConfiguration": ["a213f136-3b45-4362-a332-efb6547cd432"],
    "IInputPanelWindowHandle": ["4af81847-fdc4-4fc3-ad0b-422479c1b935"],
    "IInputScope": ["5c0f85f3-f9d8-4220-b666-045d074d9bfa"],
    "IInputScopeName": ["fd3e6997-08fb-4cba-a021-792d7589fd5a"],
    "IInputScopeNameFactory": ["4a40bb52-4bd7-4e54-8617-1cda8a1eda7f"],
    "IInputSequenceCheckerContainer": ["02d887fa-4358-11d2-be22-080009dc0a8d"],
    "IInputStream": ["905a0fe2-bc53-11df-8c49-001e4fc686da"],
    "IInputStreamReference": ["43929d18-5ec9-4b5a-919c-4205b0c804b6"],
    "IInputSwitchCallback": ["b9bc2a50-43c3-41aa-a083-5db14e184bae"],
    "IInputSwitchControl": ["b9bc2a50-43c3-41aa-a082-5db14e184bae"],
    "IInsertionPanel": ["6b8de08f-6527-4d39-bcbf-58b01da923d7"],
    "IInsetClip": ["1e73e647-84c7-477a-b474-5880e0442e15"],
    "IInspectable": ["af86e2e0-b12d-4c6a-9c5a-d7aa65101e90"],
    "IInstallReferenceEnum": ["56b1a988-7c0c-4aa2-8639-c3eb5a90226f"],
    "IInstallReferenceItem": ["582dac66-e678-449f-aba6-6faaec8a9394"],
    "IInstallationAgent": ["925cbc18-a2ea-4648-bf1c-ec8badcfe20a"],
    "IInstallationBehavior": ["d9a59339-e245-4dbd-9686-4d5763e39624"],
    "IInstallationCompletedCallback": ["45f4f6f3-d602-4f98-9a8a-3efa152ad2d3"],
    "IInstallationCompletedCallbackArgs": ["250e2106-8efb-4705-9653-ef13c581b6a1"],
    "IInstallationJob": ["5c209f0b-bad5-432a-9556-4699bed2638a"],
    "IInstallationProgress": ["345c8244-43a3-4e32-a368-65f073b76f36"],
    "IInstallationProgressChangedCallback": ["e01402d5-f8da-43ba-a012-38894bd048f1"],
    "IInstallationProgressChangedCallbackArgs": ["e4f14e1e-689d-4218-a0b9-bc189c484a01"],
    "IInstallationResult": ["a43c56d6-7451-48d4-af96-b6cd2d0d9b7a"],
    "IInstalledClassicAppInfo": ["0a7d3da3-65d0-4086-80d6-0610d760207d"],
    "IInstalledDesktopApp": ["75eab8ed-c0bc-5364-4c28-166e0545167a"],
    "IInstalledDesktopAppStatics": ["264cf74e-21cd-5f9b-6056-7866ad72489a"],
    "IInstalledVoicesStatic": ["7d526ecc-7533-4c3f-85be-888c2baeebdc"],
    "IInstalledVoicesStatic2": ["64255f2e-358d-4058-be9a-fd3fcb423530"],
    "IInstanceInfo": ["000001ad-0000-0000-c000-000000000046"],
    "IInstantiationInfo": ["000001ab-0000-0000-c000-000000000046"],
    "IInterFilterCommunicator": ["4daf1e69-81fd-462d-940f-8cd3ddf56fca"],
    "IInteractionSourceConfiguration": ["a78347e5-a9d1-4d02-985e-b930cd0b9da4"],
    "IInteractionTracker": ["2a8e8cb1-1000-4416-8363-cc27fb877308"],
    "IInteractionTracker2": ["25769a3e-ce6d-448c-8386-92620d240756"],
    "IInteractionTracker3": ["e6c5d7a2-5c4b-42c6-84b7-f69441b18091"],
    "IInteractionTracker4": ["ebd222bc-04af-4ac7-847d-06ea36e80a16"],
    "IInteractionTracker5": ["d3ef5da2-a254-40e4-88d5-44e4e16b5809"],
    "IInteractionTrackerCustomAnimationStateEnteredArgs": ["8d1c8cf1-d7b0-434c-a5d2-2d7611864834"],
    "IInteractionTrackerCustomAnimationStateEnteredArgs2": ["47d579b7-0985-5e99-b024-2f32c380c1a4"],
    "IInteractionTrackerIdleStateEnteredArgs": ["50012faa-1510-4142-a1a5-019b09f8857b"],
    "IInteractionTrackerIdleStateEnteredArgs2": ["f2e771ed-b803-5137-9435-1c96e48721e9"],
    "IInteractionTrackerInertiaModifier": ["a0e2c920-26b4-4da2-8b61-5e683979bbe2"],
    "IInteractionTrackerInertiaModifierFactory": ["993818fe-c94e-4b86-87f3-922665ba46b9"],
    "IInteractionTrackerInertiaMotion": ["04922fdc-f154-4cb8-bf33-cc1ba611e6db"],
    "IInteractionTrackerInertiaMotionStatics": ["8cc83dd6-ba7b-431a-844b-6eac9130f99a"],
    "IInteractionTrackerInertiaNaturalMotion": ["70acdaae-27dc-48ed-a3c3-6d61c9a029d2"],
    "IInteractionTrackerInertiaNaturalMotionStatics": ["cfda55b0-5e3e-4289-932d-ee5f50e74283"],
    "IInteractionTrackerInertiaRestingValue": ["86f7ec09-5096-4170-9cc8-df2fe101bb93"],
    "IInteractionTrackerInertiaRestingValueStatics": ["18ed4699-0745-4096-bcab-3a4e99569bcf"],
    "IInteractionTrackerInertiaStateEnteredArgs": ["87108cf2-e7ff-4f7d-9ffd-d72f1e409b63"],
    "IInteractionTrackerInertiaStateEnteredArgs2": ["b1eb32f6-c26c-41f6-a189-fabc22b323cc"],
    "IInteractionTrackerInertiaStateEnteredArgs3": ["48ac1c2f-47bd-59af-a58c-79bd2eb9ef71"],
    "IInteractionTrackerInteractingStateEnteredArgs": ["a7263939-a17b-4011-99fd-b5c24f143748"],
    "IInteractionTrackerInteractingStateEnteredArgs2": ["509652d6-d488-59cd-819f-f52310295b11"],
    "IInteractionTrackerOwner": ["db2e8af3-4deb-4e53-b29c-b06c9f96d651"],
    "IInteractionTrackerRequestIgnoredArgs": ["80dd82f1-ce25-488f-91dd-cb6455ccff2e"],
    "IInteractionTrackerStatics": ["bba5d7b7-6590-4498-8d6c-eb62b514c92a"],
    "IInteractionTrackerStatics2": ["35e53720-46b7-5cb0-b505-f3d6884a6163"],
    "IInteractionTrackerValuesChangedArgs": ["cf1578ef-d3df-4501-b9e6-f02fb22f73d0"],
    "IInteractionTrackerVector2InertiaModifier": ["87e08ab0-3086-4853-a4b7-77882ad5d7e3"],
    "IInteractionTrackerVector2InertiaModifierFactory": ["7401d6c4-6c6d-48df-bc3e-171e227e7d7f"],
    "IInteractionTrackerVector2InertiaNaturalMotion": ["5f17695c-162d-4c07-9400-c282b28276ca"],
    "IInteractionTrackerVector2InertiaNaturalMotionStatics": ["82001a48-09c0-434f-8189-141c66df362f"],
    "IInteractiveSessionStatics": ["60884631-dd3a-4576-9c8d-e8027618bdce"],
    "IInterfaceFromWindowProp": ["00000135-0000-0000-c000-000000000046"],
    "IInterfaceInfo": ["000001f7-0000-0000-c000-000000000046"],
    "IInterleavedSerializeCallback": ["e0a98c5b-4965-4f4b-87f9-33efba6e85fc"],
    "IInternalApplicationPermissions": ["c0d179ae-689b-4eb5-8008-6ec45eed03b0"],
    "IInternalBrowserService": ["6bd38a1c-7310-4e76-8567-927d8f72ef27"],
    "IInternalCustomDestinationList": ["507101cd-f6ad-46c8-8e20-eeb9e6bac47f"],
    "IInternalDocWrap": ["e1aa6466-9db4-40ba-be03-77c38e8e60b2"],
    "IInternalExtenderProvider": ["b85f43c4-c765-4984-ae3d-695e8cd8e992"],
    "IInternetBindInfoEx": ["a3e015b7-a82c-4dcd-a150-569aeeed36ab"],
    "IInternetBindInfoInternal": ["8fd4c3a8-e3e8-4b62-9f2f-483e5c09661d"],
    "IInternetExplorerManager": ["acc84351-04ff-44f9-b23f-655ed168c6d5"],
    "IInternetExplorerManager2": ["dfbb5136-9259-4895-b4a7-c1934429919a"],
    "IInternetPriorityInfoInternal": ["d5ae15f6-2032-488e-8f96-f92406d8d8b4"],
    "IInternetPriorityInternal": ["eb5cda44-5086-44fe-a9b1-c6421353a546"],
    "IInternetProtocolEx": ["c7a98e66-1010-492c-a1c8-c809e1f75905"],
    "IInternetSecurityManagerEx2": ["f1e50292-a795-4117-8e09-2b560a72ac60"],
    "IInternetZoneManagerEx2": ["edc17559-dd5d-4846-8eef-8becba5a4abf"],
    "IInterruptCommand": ["51525841-daae-4204-bef4-e7628582450f"],
    "IInterruptItem": ["388eed6a-df36-4009-b5ea-609d3309cc5d"],
    "IInterruptSync": ["22c6ac63-851b-11d0-9a7f-00aa0038acfe"],
    "IInterruptedOperationHandler": ["036b4fc7-6a11-4c07-8046-22d268c37721"],
    "IInterval": ["6bf0a714-3c18-430b-8b5d-83b1c234d3db"],
    "IInvalidProductLicenseException": ["a37d00f5-7bb0-4953-b414-f9e98326f2e8"],
    "IInvocationLocation": ["831d1dff-7f57-4720-87e4-cb57d6214428"],
    "IInvokeProvider": ["54fcb24b-e18e-47a2-b4d3-eccbe77599a2", "f7d1a187-b13c-4540-b09e-6778e2dc9ba5"],
    "IInvokeSettingSyncSSO": ["36ec7e1f-64ae-4220-8526-f95769ab6388"],
    "IIsMappingValidCallback": ["0f2ad8fa-bab1-4ad8-a41f-952db538a247"],
    "IIsTextTrimmedChangedEventArgs": ["16f597cd-ebff-4fb4-8714-26147418b945"],
    "IIsWebBrowserSB": ["b8a9c381-19df-11d1-9193-006097df5bd4"],
    "IIsdbAudioComponentDescriptor": ["679d2002-2425-4be4-a4c7-d6632a574f4d"],
    "IIsdbCAContractInformationDescriptor": ["08e18b25-a28f-4e92-821e-4fced5cc2291"],
    "IIsdbCADescriptor": ["0570aa47-52bc-42ae-8ca5-969f41e81aea"],
    "IIsdbCAServiceDescriptor": ["39cbeb97-ff0b-42a7-9ab9-7b9cfe70a77a"],
    "IIsdbComponentGroupDescriptor": ["a494f17f-c592-47d8-8943-64c9a34be7b9"],
    "IIsdbDataContentDescriptor": ["a428100a-e646-4bd6-aa14-6087bdc08cd5"],
    "IIsdbDigitalCopyControlDescriptor": ["1a28417e-266a-4bb8-a4bd-d782bcfb8161"],
    "IIsdbDownloadContentDescriptor": ["5298661e-cb88-4f5f-a1de-5f440c185b92"],
    "IIsdbEmergencyInformationDescriptor": ["ba6fa681-b973-4da1-9207-ac3e7f0341eb"],
    "IIsdbEventGroupDescriptor": ["94b06780-2e2a-44dc-a966-cc56fdabc6c2"],
    "IIsdbHierarchicalTransmissionDescriptor": ["b7b3ae90-ee0b-446d-8769-f7e2aa266aa6"],
    "IIsdbLogoTransmissionDescriptor": ["e0103f49-4ae1-4f07-9098-756db1fa88cd"],
    "IIsdbSIParameterDescriptor": ["f837dc36-867c-426a-9111-f62093951a45"],
    "IIsdbSeriesDescriptor": ["07ef6370-1660-4f26-87fc-614adab24b11"],
    "IIsdbSiParser2": ["900e4bb7-18cd-453f-98be-3be6aa211772"],
    "IIsdbTSInformationDescriptor": ["d7ad183e-38f5-4210-b55f-ec8d601bbd47"],
    "IIsdbTerrestrialDeliverySystemDescriptor": ["39fae0a6-d151-44dd-a28a-765de5991670"],
    "IIsoImageManager": ["6ca38be5-fbbb-4800-95a1-a438865eb0d4"],
    "IIsoSpeedControl": ["27b6c322-25ad-4f1b-aaab-524ab376ca33"],
    "IIsoSpeedControl2": ["6f1578f2-6d77-4f8a-8c2f-6130b6395053"],
    "IIsolatedAppLauncher": ["f686878f-7b42-4cc4-96fb-f4f3b6e3d24d"],
    "IIsolatedWindowsEnvironment": ["41d24597-c328-4467-b37f-4dfc6f60b6bc"],
    "IIsolatedWindowsEnvironmentCreateResult": ["ef9a5e58-dcd7-45c2-9c85-ab642a715e8e"],
    "IIsolatedWindowsEnvironmentFactory": ["1aca93e7-e804-454d-8466-f9897c20b0f6"],
    "IIsolatedWindowsEnvironmentFile": ["4d5ae1ef-029f-4101-8c35-fe91bf9cd5f0"],
    "IIsolatedWindowsEnvironmentHostStatics": ["2c0e22c7-05a0-517a-b81c-6ee8790c381f"],
    "IIsolatedWindowsEnvironmentLaunchFileResult": ["685d4176-f6e0-4569-b1aa-215c0ff5b257"],
    "IIsolatedWindowsEnvironmentOptions": ["b71d98f7-61f0-4008-b207-0bf9eb2d76f2"],
    "IIsolatedWindowsEnvironmentOwnerRegistrationData": ["f888ec22-e8cf-56c0-b1df-90af4ad80e84"],
    "IIsolatedWindowsEnvironmentOwnerRegistrationResult": ["6dab9451-6169-55df-8f51-790e99d7277d"],
    "IIsolatedWindowsEnvironmentOwnerRegistrationStatics": ["10951754-204b-5ec9-9de3-df792d074a61"],
    "IIsolatedWindowsEnvironmentProcess": ["a858c3ef-8172-4f10-af93-cbe60af88d09"],
    "IIsolatedWindowsEnvironmentShareFolderRequestOptions": ["c405eb7d-7053-4f6a-9b87-746846ed19b2"],
    "IIsolatedWindowsEnvironmentShareFolderResult": ["556ba72e-ca9d-4211-b143-1cedc86eb2fe"],
    "IIsolatedWindowsEnvironmentStartProcessResult": ["8fa1dc2f-57da-4bb5-9c06-fa072d2032e2"],
    "IIsolatedWindowsEnvironmentTelemetryParameters": ["ebdb3cab-7a3a-4524-a0f4-f96e284d33cd"],
    "IIsolatedWindowsHostMessengerStatics": ["06e444bb-53c0-4889-8fa3-53592e37cf21"],
    "IItalic": ["91f4619c-fcbb-4157-802c-76f63b5fb657"],
    "IItemAutomationPeer": ["953c34f6-3b31-47a7-b3bf-25d3ae99c317"],
    "IItemAutomationPeerFactory": ["29065073-de3d-4d3f-97b4-4d6f9d53444d"],
    "IItemCategorizer": ["b669937f-94c3-45d8-a950-38c43c9be7a8"],
    "IItemChangeArray": ["8550419b-ac9d-4dc8-8019-534fdc3e86ce"],
    "IItemClickEventArgs": ["9c314242-f29a-494d-a3a5-d4c7b2a46852"],
    "IItemClickEventHandler": ["3df6d14e-e18a-4a75-9395-627c5f3cd489"],
    "IItemCollection": ["39651294-8f5c-452a-9dcb-75ea630399e4"],
    "IItemCollectionFactory": ["56028b02-396d-4bf4-ad8d-03494890aee0"],
    "IItemContainerGenerator": ["40765f00-83f0-4d7f-b1b8-f19de4f1d5da"],
    "IItemContainerMapping": ["53c9f23a-f25d-446a-99b8-c7aeb839050f"],
    "IItemContainerProvider": ["e747770b-39ce-4382-ab30-d8fb3f336f24", "ef5cd845-e1d4-40f4-bad5-c7fad44a703e"],
    "IItemDevirtualizerSpy": ["6f2d1a66-13f0-40c9-ac0b-5d2e8f6376a8"],
    "IItemEnumerator": ["9f7d7bb7-20b3-11da-81a5-0030f1642e3c"],
    "IItemEventSink": ["9d6dcf9e-4068-46ea-9ac3-ef709bb2fe1c"],
    "IItemFilter": ["7fcbeb25-ed60-45c9-9f5e-57b48493c4dd"],
    "IItemFilterOwner": ["7e1af054-83a6-47fc-ab27-a58ae8d9c705"],
    "IItemHandlerCache": ["ddb6beda-0406-404d-8a91-177e92f5c6d0"],
    "IItemIndexRange": ["83b834be-0583-4a26-9b64-8bf4a2f65704"],
    "IItemIndexRangeFactory": ["86e2c440-2e7a-4c7d-a664-e8abf07bfc7e"],
    "IItemKeyArray": ["7e56debf-4e4a-4ce3-9d33-d62909685063"],
    "IItemPropertyCache": ["2ad6c81c-42dc-46b8-931b-ee0db2a20d1b"],
    "IItemRemovedEventArgs": ["59677e5c-55be-4c66-ba66-5eaea79d2631"],
    "IItemSetOperationCallback": ["30176cfe-6f36-4ea4-be65-a4b728fece39"],
    "IItemSetOperations": ["32ae3a1f-d90e-4417-9dd9-23b0dfa4621d"],
    "IItemStore": ["df44cd5d-9ae9-4935-980a-e8add2246d41"],
    "IItemStoreOwner": ["35c22fea-79f6-4d3d-ae15-1699cbf54721"],
    "IItemTaskScheduler": ["c1884f8b-2db6-40b6-9e90-b9876b75ffe0"],
    "IItemThumbnailCallback": ["099ab00e-1fe6-4460-9e1b-4b2567da41ca"],
    "IItemTranslation": ["59d6f31b-fa6b-4fba-8af3-197ff140c714"],
    "IItemsChangedEventArgs": ["e8b45568-7d10-421e-be29-81839a91de20"],
    "IItemsChangedEventHandler": ["178257be-a304-482f-8bf0-b9d2e39612a3"],
    "IItemsControl": ["f4a91dd8-d979-4381-8652-bda0342a765e"],
    "IItemsControl2": ["754c3266-0529-45e3-8748-bf747d158357"],
    "IItemsControl3": ["502b7489-aee4-4de3-a2ab-195ac20c4212"],
    "IItemsControlAutomationPeer": ["96e76bf1-37f7-4088-925d-65268e83e34d"],
    "IItemsControlAutomationPeer2": ["c48d8917-95a8-47b8-a517-bf891a6c039b"],
    "IItemsControlAutomationPeerFactory": ["4038a259-2e1a-49ca-a533-c64f181577e6"],
    "IItemsControlAutomationPeerOverrides2": ["361dc0e8-b56f-45e9-80fe-10a0fb0fe177"],
    "IItemsControlFactory": ["f7bbc359-f8fd-471c-bcb2-2c74be8ebf8c"],
    "IItemsControlOverrides": ["c79bb41b-a084-4301-a496-72971f364ed1"],
    "IItemsControlStatics": ["37dabd89-dcfb-45b8-9afe-874df097905e"],
    "IItemsPanelTemplate": ["14ead768-34b2-4b97-bf3c-e8d73230a2aa"],
    "IItemsPickedEventArgs": ["f95b9aac-a621-488e-9156-8ee31165be04"],
    "IItemsPresenter": ["c271569b-6dca-4e2b-8e14-c55136b02a71"],
    "IItemsPresenter2": ["5c04aa33-1df3-4731-a4c9-da818378d63d"],
    "IItemsPresenterStatics": ["18de66cd-4a6c-4b2e-aa86-cb126c9a2920"],
    "IItemsPresenterStatics2": ["8971632e-7867-4d66-9630-29f1c5f7403f"],
    "IItemsRangeInfo": ["f05f5665-71fd-45a2-be13-a081d294a68d"],
    "IItemsStackPanel": ["df7ab79d-7ad5-4b58-9363-919af90226e6"],
    "IItemsStackPanel2": ["eeeecdb0-00b4-4534-937b-56318b293e92"],
    "IItemsStackPanelStatics": ["ca25d63f-044f-4b6b-b315-0b60e0b4f87d"],
    "IItemsStackPanelStatics2": ["3972eb2c-384a-48bf-adfd-772e2572c504"],
    "IItemsViewSpy": ["2691d091-02c2-4096-b45d-a29fef234940"],
    "IItemsViewSpyClient": ["def89b4a-5804-456b-af09-a8e4c80de58d"],
    "IItemsWrapGrid": ["ddfe6b5f-ba88-4a7d-8a5b-e58caf0f4e2d"],
    "IItemsWrapGrid2": ["80c21c0f-63ec-4258-bd61-d4a6956c864a"],
    "IItemsWrapGridStatics": ["4ec5427d-24a0-449a-b763-3077ba0f2dd5"],
    "IItemsWrapGridStatics2": ["2e27d3f7-feaa-478d-bfd1-29338adc5a03"],
    "IIterableConcept": ["f5d49d0c-0b02-4301-9c9b-b3a6037628f3"],
    "IJITDebuggingHost2": ["42ef9f29-7777-42ed-ba74-944aefd663da"],
    "IJapanesePhoneme": ["2f6a9300-e85b-43e6-897d-5d82f862df21"],
    "IJapanesePhoneticAnalyzerStatics": ["88ab9e90-93de-41b2-b4d5-8edb227fd1c2"],
    "IJavascriptDispatchRemoteProxy": ["c20ed5c4-0a2e-4f66-9be2-86a1c823dd68"],
    "IJavascriptLocalProxy": ["ebade2e2-a8cc-4797-a430-2e863867efd0"],
    "IJetEngine": ["9f63d980-ff25-11d1-bb6f-00c04fae22da"],
    "IJournalPrintJob": ["9f4f2864-f3f0-55d0-8c39-74cc91783eed"],
    "IJournalPrinterCapabilities": ["3b5ccc43-e047-4463-bb58-17b5ba1d8056"],
    "IJournalPrinterCapabilities2": ["03b0b645-33b8-533b-baaa-a4389283ab0a"],
    "IJsArguments": ["09eef2f5-bc32-4a88-8d18-225edc4dc04f"],
    "IJsArray": ["e34507b0-f19a-11d0-9349-00a0c90dcaa9"],
    "IJsDebug": ["be0e89da-2ac5-4c04-ac5e-59956aae3613"],
    "IJsDebugBreakPoint": ["df6773e3-ed8d-488b-8a3e-5812577d1542"],
    "IJsDebugDataTarget": ["53b28977-53a1-48e5-9000-5d0dfa893931"],
    "IJsDebugFrame": ["c9196637-ab9d-44b2-bad2-13b95b3f390e"],
    "IJsDebugProcess": ["3d587168-6a2d-4041-bd3b-0de674502862"],
    "IJsDebugProperty": ["f8ffcf2b-3aa4-4320-85c3-52a312ba9633"],
    "IJsDebugStackWalker": ["db24b094-73c4-456c-a4ec-e90ea00bdfe3"],
    "IJsEnumDebugProperty": ["4092432f-2f0f-4fe1-b638-5b74a52cdcbe"],
    "IJsonArray": ["08c1ddb6-0cbd-4a9a-b5d3-2f852dc37e81"],
    "IJsonArrayStatics": ["db1434a9-e164-499f-93e2-8a8f49bb90ba"],
    "IJsonErrorStatics2": ["404030da-87d0-436c-83ab-fc7b12c0cc26"],
    "IJsonObject": ["064e24dd-29c2-4f83-9ac1-9ee11578beb3"],
    "IJsonObjectStatics": ["2289f159-54de-45d8-abcc-22603fa066a0"],
    "IJsonObjectWithDefaultValues": ["d960d2a2-b7f0-4f00-8e44-d82cf415ea13"],
    "IJsonValue": ["a3219ecb-f0b3-4dcd-beee-19d48cd3ed1e"],
    "IJsonValueStatics": ["5f6b544a-2f53-48e1-91a3-f78b50a6345c"],
    "IJsonValueStatics2": ["1d9ecbe4-3fe8-4335-8392-93d8e36865f0"],
    "IJumpList": ["b0234c3e-cd6f-4cb6-a611-61fd505f3ed1"],
    "IJumpListItem": ["7adb6717-8b5d-4820-995b-9b418dbe48b0"],
    "IJumpListItemBackgroundConverter": ["81177858-d224-410c-b16c-c5b6bb6188b2"],
    "IJumpListItemBackgroundConverterStatics": ["20e7c3dd-6f27-4808-b0be-83e0e9b5cc45"],
    "IJumpListItemForegroundConverter": ["1590ed38-c504-4796-a63a-5bfc9eefaae8"],
    "IJumpListItemForegroundConverterStatics": ["474e7352-210c-4673-ac6a-413f0e2c7750"],
    "IJumpListItemStatics": ["f1bfc4e8-c7aa-49cb-8dde-ecfccd7ad7e4"],
    "IJumpListStatics": ["a7e0c681-e67e-4b74-8250-3f322c4d92c3"],
    "IJumpViewContextMenuWrapper": ["dcf1427b-9f2f-4bb5-8aa2-ec625e2b2082"],
    "IJumpViewExecuteHelper": ["8a4427de-b11b-4a61-8977-844a3a7bc63b"],
    "IJumpViewItemInfoInternal": ["b1e3d1df-81ce-4b9f-ac99-048a4f42a73c"],
    "IKernelTransaction": ["79427a2b-f895-40e0-be79-b57dc82ed231"],
    "IKeyAdviseSink": ["8ebd3263-d48c-4093-91b2-45ba9368e6f2"],
    "IKeyAlgorithmNamesStatics": ["479065d7-7ac7-4581-8c3b-d07027140448"],
    "IKeyAlgorithmNamesStatics2": ["c99b5686-e1fd-4a4a-893d-a26f33dd8bb4"],
    "IKeyAttestationHelperStatics": ["1648e246-f644-4326-88be-3af102d30e0c"],
    "IKeyAttestationHelperStatics2": ["9c590b2c-a6c6-4a5e-9e64-e85d5279df97"],
    "IKeyChangeProvider": ["28d0f38c-2f49-4683-b4bf-002cdaffc682"],
    "IKeyCredential": ["9585ef8d-457b-4847-b11a-fa960bbdb138"],
    "IKeyCredentialAttestationResult": ["78aab3a1-a3c1-4103-b6cc-472c44171cbb"],
    "IKeyCredentialManagerStatics": ["6aac468b-0ef1-4ce0-8290-4106da6a63b5"],
    "IKeyCredentialOperationResult": ["f53786c1-5261-4cdd-976d-cc909ac71620"],
    "IKeyCredentialRetrievalResult": ["58cd7703-8d87-4249-9b58-f6598cc9644e"],
    "IKeyDerivationAlgorithmNamesStatics": ["7b6e363e-94d2-4739-a57b-022e0c3a402a"],
    "IKeyDerivationAlgorithmNamesStatics2": ["57953fab-6044-466f-97f4-337b7808384d"],
    "IKeyDerivationAlgorithmProvider": ["e1fba83b-4671-43b7-9158-763aaa98b6bf"],
    "IKeyDerivationAlgorithmProviderStatics": ["0a22097a-0a1c-443b-9418-b9498aeb1603"],
    "IKeyDerivationParameters": ["7bf05967-047b-4a8c-964a-469ffd5522e2"],
    "IKeyDerivationParameters2": ["cd4166d1-417e-4f4c-b666-c0d879f3f8e0"],
    "IKeyDerivationParametersStatics": ["ea961fbe-f37f-4146-9dfe-a456f1735f4b"],
    "IKeyDerivationParametersStatics2": ["a5783dd5-58e3-4efb-b283-a1653126e1be"],
    "IKeyEnumerator": ["345fa92e-5e00-4319-9cae-971f7601cdcf"],
    "IKeyEventArgs": ["5ff5e930-2544-4a17-bd78-1f2fdebb106b"],
    "IKeyEventArgs2": ["583add98-0790-4571-9b12-645ef9d79e42"],
    "IKeyEventHandler": ["7c63d2e5-7a0e-4e12-b96a-7715aa6ff1c8"],
    "IKeyFrameAnimation": ["126e7f22-3ae9-4540-9a8a-deae8a4a4a84"],
    "IKeyFrameAnimation2": ["f4b488bb-2940-4ec0-a41a-eb6d801a2f18"],
    "IKeyFrameAnimation3": ["845bf0b4-d8de-462f-8753-c80d43c6ff5a"],
    "IKeyFrameAnimationFactory": ["bf0803f8-712a-4fc1-8c87-970859ed8d2e"],
    "IKeyRoutedEventArgs": ["d4cd3dfe-4079-42e9-a39a-3095d3f049c6"],
    "IKeyRoutedEventArgs2": ["1b02d57a-9634-4f14-91b2-133e42fdb3cd"],
    "IKeyRoutedEventArgs3": ["2779f5b4-ca41-411b-a8ef-f4fc78e78057"],
    "IKeySpline": ["77a163bb-d5ca-4a32-ba0b-7dff988e58a0"],
    "IKeyStorageProviderNamesStatics": ["af186ae0-5529-4602-bd94-0aab91957b5c"],
    "IKeyStorageProviderNamesStatics2": ["262d743d-9c2e-41cc-8812-c4d971dd7c60"],
    "IKeyStore": ["0fc7557d-401d-4fca-9365-da1e9850697c"],
    "IKeyTimeHelper": ["3643e480-4823-466a-abe5-5e79c8ed77ed"],
    "IKeyTimeHelperStatics": ["7fa2612c-22a9-45e9-9af7-c7416efff7a5"],
    "IKeyboardAccelerator": ["92e6181e-19ae-465a-9b3c-a71ee9ea7420"],
    "IKeyboardAcceleratorFactory": ["44d88a99-4bfd-4a47-a893-515f388623f6"],
    "IKeyboardAcceleratorInvokedEventArgs": ["c00b03f2-04e7-4415-b17d-d76b9490de2b"],
    "IKeyboardAcceleratorInvokedEventArgs2": ["befca4b8-5907-48ee-8e21-9c969078fa11"],
    "IKeyboardAcceleratorStatics": ["3bd43d51-9bb3-456d-bf15-804adfb86261"],
    "IKeyboardCapabilities": ["3a3f9b56-6798-4bbc-833e-0f34b17c65ff"],
    "IKeyboardDeliveryInterceptor": ["b4baf068-8f49-446c-8db5-8c0ffe85cc9e"],
    "IKeyboardDeliveryInterceptorStatics": ["f9f63ba2-ceba-4755-8a7e-14c0ffecd239"],
    "IKeyboardInputBuffer": ["3776ee93-8079-40cc-8c2f-a7a997cf9d6e"],
    "IKeypadPressedEventArgs": ["d3a43900-b4fa-49cd-9442-89af6568f601"],
    "IKeypadPressedEventHandler": ["e637a454-c527-422c-8926-c9af83b559a0"],
    "IKeywordDetectorOemAdapter": ["a13f4e6a-3bc5-46b4-88fb-f39014b51ac9"],
    "IKindDescriptionFactory": ["fdada2fa-894d-47d8-ae78-adf1fd7f28df"],
    "IKnowledgeSyncProvider": ["43434a49-8da4-47f2-8172-ad7b8b024978"],
    "IKnownAdaptiveNotificationHintsStatics": ["06206598-d496-497d-8692-4f7d7c2770df"],
    "IKnownAdaptiveNotificationTextStylesStatics": ["202192d7-8996-45aa-8ba1-d461d72c2a1b"],
    "IKnownAutoListManager": ["a768a74d-ae70-45d6-9997-ea0c0bd5513e"],
    "IKnownCSimFilePathsStatics": ["b458aeed-49f1-4c22-b073-96d511bf9c35"],
    "IKnownDeviceTypesStatics": ["ee5479c2-5448-45da-ad1b-24948c239094"],
    "IKnownFolder": ["3aa7af7e-9b36-420c-a8e3-f77d4674a488"],
    "IKnownFolderAllowPrivateFlags": ["700ea002-ec3d-4976-9a08-964b8bba3927"],
    "IKnownFolderManager": ["8be2d872-86aa-4d47-b776-32cca40c7018"],
    "IKnownFolderManagerPriv": ["2fc35761-0f20-4ab5-80c7-856e9679f228"],
    "IKnownFolderProperties": ["0e207e42-dc38-440d-9b00-2e8cf0e23c8d"],
    "IKnownFoldersCameraRollStatics": ["5d115e66-27e8-492f-b8e5-2f90896cd4cd"],
    "IKnownFoldersPlaylistsStatics": ["dad5ecd6-306f-4d6a-b496-46ba8eb106ce"],
    "IKnownFoldersSavedPicturesStatics": ["055c93ea-253d-467c-b6ca-a97da1e9a18d"],
    "IKnownFoldersStatics": ["5a2a7520-4802-452d-9ad9-4351ada7ec35"],
    "IKnownFoldersStatics2": ["194bd0cd-cf6e-4d07-9d53-e9163a2536e9"],
    "IKnownFoldersStatics3": ["c5194341-9742-4ed5-823d-fc1401148764"],
    "IKnownFoldersStatics4": ["1722e6bf-9ff9-4b21-bed5-90ecb13a192e"],
    "IKnownNotificationBindingsStatics": ["79427bae-a8b7-4d58-89ea-76a7b7bccded"],
    "IKnownRemoteSystemCapabilitiesStatics": ["8108e380-7f8a-44e4-92cd-03b6469b94a3"],
    "IKnownRetailInfoPropertiesStatics": ["99571178-500f-487e-8e75-29e551728712"],
    "IKnownRuimFilePathsStatics": ["3883c8b9-ff24-4571-a867-09f960426e14"],
    "IKnownScopeFiller": ["295c3011-e9b9-43de-a04c-4800da69f4d3"],
    "IKnownSimFilePathsStatics": ["80cd1a63-37a5-43d3-80a3-ccd23e8fecee"],
    "IKnownSimpleHapticsControllerWaveformsStatics": ["3d577ef7-4cee-11e6-b535-001bdc06ab3b"],
    "IKnownSmartCardAppletIds": ["7b04d8d8-95b4-4c88-8cea-411e55511efc"],
    "IKnownUSimFilePathsStatics": ["7c34e581-1f1b-43f4-9530-8b092d32d71f"],
    "IKnownUserPropertiesStatics": ["7755911a-70c5-48e5-b637-5ba3441e4ee4"],
    "IKsComponentId": ["1136a91a-2bef-45b3-91d9-0a58472ee8a7"],
    "IKsDeviceFunctions": ["e234f2e2-bd69-4f8c-b3f2-7cd79ed466bd", "e234f2e2-bd69-4f8c-b3f2-7cd79ed466bd"],
    "IKsFastClock": ["c9902485-c180-11d2-8473-d42394459e5e", "c9902485-c180-11d2-8473-d42394459e5e"],
    "IKsFormatSupport": ["3cb4a69d-bb6f-4d2b-95b7-452d2c155db5"],
    "IKsJackContainerId": ["c99af463-d629-4ec4-8c00-e54d68154248"],
    "IKsJackDescription": ["4509f757-2d46-4637-8e62-ce7db944f57b"],
    "IKsJackDescription2": ["478f3a9b-e0c9-4827-9228-6f5505ffe76a"],
    "IKsJackSinkInformation": ["d9bd72ed-290f-4581-9ff3-61027a8fe532"],
    "IKsNodeControl": ["11737c14-24a7-4bb5-81a0-0d003813b0c4"],
    "IKsPinFactory": ["cd5ebe6b-8b6e-11d1-8ae0-00a0c9223196"],
    "IKsTopologyInfo": ["720d4ac0-7533-11d0-a5d6-28db04c10000"],
    "IL2CacheEntry": ["5769d5a6-d3fd-49a8-8a34-ffe4f8a26ea2"],
    "ILCIEComponent": ["d2649e5e-e1a3-4255-b764-d7531a794042"],
    "ILCIEParentComponent": ["c00fc1fe-fa95-4d94-b79c-0c13f0a03c78"],
    "ILCIEProxyControl": ["5df06db2-c1c2-48b6-8bb6-9cd88eac5015"],
    "ILCIESerializable": ["0acb838f-a152-4108-ab65-06e73c92ee5f"],
    "ILCIESerializableContainer": ["5a3dd708-20d3-4c5c-a470-44ffbb24a72d"],
    "ILCIESharedMemoryObject": ["29c3390d-b55c-482e-9e92-1e0064b5ca54"],
    "ILCIEShowInternetSecurity": ["4db066e1-93a3-496f-9ad8-d86b4aaecd68"],
    "ILCIEThreadRef": ["3e322340-e4a8-4292-9d52-24e5b7b08253"],
    "ILLTDEnumerationEvents": ["480611c4-18d1-4be9-92bd-0918605ec39f"],
    "ILLTDEnumerator": ["b9d905d7-aa24-4208-ba33-010c8c1bd200"],
    "ILLTDEventProperties": ["47bde00f-00c7-4b5b-b6fe-ff276d0cfbe3"],
    "ILLTDGlobalEvents": ["e485b5dd-ca2d-45de-a300-215c7a1dee54"],
    "ILLTDMap": ["bc190dff-8708-4488-bf62-b94bef994f44"],
    "ILLTDMapper": ["2fa7433a-62e8-4a41-921b-3dccc6a763a6"],
    "ILLTDMappingEvents": ["efa8a829-0b92-44ea-a882-eac405cf768b"],
    "ILLTDNode": ["ce6aeb1f-fcbb-4a7f-a384-73d1656bae70"],
    "ILSCSlideshowCallback": ["ba07f11c-ca4d-4c42-8646-7fa9e260b31d"],
    "ILSCSlideshowDCompDirectHost": ["00d33981-e83f-4e0c-b7d6-f7c0ee32d2fe"],
    "ILSCSlideshowFeedManager": ["cc74a6af-371a-4fef-ba16-ee26f317db03"],
    "ILSCSlideshowHandleExchange": ["36913c75-97ec-4583-b266-c5be3033c4cb"],
    "ILSCSlideshowManager": ["94190d6c-fa27-4714-b422-02ee93b8025e"],
    "ILSCSlideshowServer": ["805760ce-ce47-4c6f-abac-9c932730d0d6"],
    "ILVRange": ["96a23e16-a1bc-11d1-b084-00c04fc33aa5"],
    "ILamp": ["047d5b9a-ea45-4b2b-b1a2-14dff00bde7b"],
    "ILampArray": ["7ace9787-c8a0-4e95-a1e0-d58676538649"],
    "ILampArrayBitmapEffect": ["3238e065-d877-4627-89e5-2a88f7052fa6"],
    "ILampArrayBitmapEffectFactory": ["13608090-e336-4c8f-9053-a92407ca7b1d"],
    "ILampArrayBitmapRequestedEventArgs": ["c8b4af9e-fe63-4d51-babd-619defb454ba"],
    "ILampArrayBlinkEffect": ["ebbf35f6-2fc5-4bb3-b3c3-6221a7680d13"],
    "ILampArrayBlinkEffectFactory": ["879f1d97-9f50-49b2-a56f-013aa08d55e0"],
    "ILampArrayColorRampEffect": ["2b004437-40a7-432e-a0b9-0d570c2153ff"],
    "ILampArrayColorRampEffectFactory": ["520bd133-0c74-4df5-bea7-4899e0266b0f"],
    "ILampArrayCustomEffect": ["ec579170-3c34-4876-818b-5765f78b0ee4"],
    "ILampArrayCustomEffectFactory": ["68b4774d-63e5-4af0-a58b-3e535b94e8c9"],
    "ILampArrayEffect": ["11d45590-57fb-4546-b1ce-863107f740df"],
    "ILampArrayEffectPlaylist": ["7de58bfe-6f61-4103-98c7-d6632f7b9169"],
    "ILampArrayEffectPlaylistStatics": ["fb15235c-ea35-4c7f-a016-f3bfc6a6c47d"],
    "ILampArraySolidEffect": ["441f8213-43cc-4b33-80eb-c6ddde7dc8ed"],
    "ILampArraySolidEffectFactory": ["f862a32c-5576-4341-961b-aee1f13cf9dd"],
    "ILampArrayStatics": ["7bb8c98d-5fc1-452d-bb1f-4ad410d398ff"],
    "ILampArrayUpdateRequestedEventArgs": ["73560d6a-576a-48af-8539-67ffa0ab3516"],
    "ILampAvailabilityChangedEventArgs": ["4f6e3ded-07a2-499d-9260-67e304532ba4"],
    "ILampInfo": ["30bb521c-0acf-49da-8c10-150b9cf62713"],
    "ILampStatics": ["a822416c-8885-401e-b821-8e8b38a8e8ec"],
    "ILanIdentifier": ["48aa53aa-1108-4546-a6cb-9a74da4b7ba0"],
    "ILanIdentifierData": ["a74e83c3-d639-45be-a36a-c4e4aeaf6d9b"],
    "ILangToolsBroker": ["b39f0f46-e68f-42aa-8646-19145c75e708"],
    "ILanguage": ["ea79a752-f7c2-4265-b1bd-c4dec4e4f080"],
    "ILanguage2": ["6a47e5b5-d94d-4886-a404-a5a5b9d5b494"],
    "ILanguage3": ["c6af3d10-641a-5ba4-bb43-5e12aed75954"],
    "ILanguageComponentType": ["b874c8ba-0fa2-11d3-9d8e-00c04f72d980"],
    "ILanguageExceptionErrorInfo": ["04a2dbf3-df83-116c-0946-0812abf6e07d"],
    "ILanguageExceptionErrorInfo2": ["5746e5c4-5b97-424c-b620-2822915734dd"],
    "ILanguageExceptionStackBackTrace": ["cbe53fb5-f967-4258-8d34-42f5e25833de"],
    "ILanguageExceptionTransform": ["feb5a271-a6cd-45ce-880a-696706badc65"],
    "ILanguageExtensionSubtags": ["7d7daf45-368d-4364-852b-dec927037b85"],
    "ILanguageFactory": ["9b0252ac-0c27-44f8-b792-9793fb66c63e"],
    "ILanguageFont": ["b12e5c3a-b76d-459b-beeb-901151cd77d1"],
    "ILanguageFontGroup": ["f33a7fc3-3a5c-4aea-b9ff-b39fb242f7f6"],
    "ILanguageFontGroupFactory": ["fcaeac67-4e77-49c7-b856-dde934fc735b"],
    "ILanguageResources": ["fb8026e2-3572-11d3-b282-00c04fa3027b"],
    "ILanguageStatics": ["b23cd557-0865-46d4-89b8-d59be8990f0d"],
    "ILanguageStatics2": ["30199f6e-914b-4b2a-9d6e-e3b0e27dbe4f"],
    "ILanguageStatics3": ["d15ecb5a-71de-5752-9542-fac5b4f27261"],
    "ILastResourceManager": ["4d964ad4-5b33-11d3-8a91-00c04f79eb6d"],
    "ILatLongReport": ["7fed806d-0ef8-4f07-80ac-36a0beae3134"],
    "ILatLongReportFactory": ["3f0804cb-b114-447d-83dd-390174ebb082"],
    "ILateRestoreHelper": ["de897046-8eb9-4f78-bb3c-c1cb10b1a8e7"],
    "ILaunchActivatedEventArgs": ["fbc93e26-a14a-4b4f-82b0-33bed920af52"],
    "ILaunchActivatedEventArgs2": ["0fd37ebc-9dc9-46b5-9ace-bd95d4565345"],
    "ILaunchOperationWorker": ["28317368-4896-454b-aa95-032914fc45b5"],
    "ILaunchSourceAppUserModelId": ["989191ac-28ff-4cf0-9584-e0d078bc2396"],
    "ILaunchSourceViewSizePreference": ["e5aa01f7-1fb8-4830-8720-4e6734cbd5f3"],
    "ILaunchTargetMonitor": ["266fbc7e-490d-46ed-a96b-2274db252003"],
    "ILaunchTargetViewSizePreference": ["2f0666c6-12f7-4360-b511-a394a0553725"],
    "ILaunchUIContext": ["1791e8f6-21c7-4340-882a-a6a93e3fd73b"],
    "ILaunchUIContextProvider": ["0d12c4c8-a3d9-4e24-94c1-0e20c5a956c4"],
    "ILaunchUriResult": ["ec27a8df-f6d5-45ca-913a-70a40c5c8221"],
    "ILaunchableShellExperience": ["471241bb-09e6-4418-a245-867813d3771c"],
    "ILauncherOptions": ["bafa21d8-b071-4cd8-853e-341203e557d3"],
    "ILauncherOptions2": ["3ba08eb4-6e40-4dce-a1a3-2f53950afb49"],
    "ILauncherOptions3": ["f0770655-4b63-4e3a-9107-4e687841923a"],
    "ILauncherOptions4": ["ef6fd10e-e6fb-4814-a44e-57e8b9d9a01b"],
    "ILauncherOutsideHolographic": ["d10ec26d-1c68-45e9-a5a7-a5b314fdb672"],
    "ILauncherStatics": ["277151c3-9e3e-42f6-91a4-5dfdeb232451"],
    "ILauncherStatics2": ["59ba2fbb-24cb-4c02-a4c4-8294569d54f1"],
    "ILauncherStatics3": ["234261a8-9db3-4683-aa42-dc6f51d33847"],
    "ILauncherStatics4": ["b9ec819f-b5a5-41c6-b3b3-dd1b3178bcf2"],
    "ILauncherStatics5": ["5b24ef84-d895-5fea-9153-1ac49aed9ba9"],
    "ILauncherTipContextMenu": ["b8c1db5f-cbb3-48bc-afd9-ce6b880c79ed"],
    "ILauncherTipContextMenuSettingChangeListener": ["5c616abc-7341-4100-950b-69f3b00f548c"],
    "ILauncherUIOptions": ["1b25da6e-8aa6-41e9-8251-4165f5985f49"],
    "ILauncherViewOptions": ["8a9b29f1-7ca7-49de-9bd3-3c5b7184f616"],
    "ILayer": ["b32fbf42-effb-4862-b164-6565c2ef32f4"],
    "ILayerCommandHandler": ["0f2d35b3-db34-4966-bea6-59c7cd203862"],
    "ILayerDynamicStateEvents": ["72c94cf1-f24c-4c2e-9a4f-b23439babd5e"],
    "ILayerState": ["a4fc45c4-abdd-47cb-af94-8697249a8558"],
    "ILayerStateEvents": ["55cf8fa7-7035-4b80-80ce-51aeb5de7cfc"],
    "ILayerStateProvider": ["739cbf5d-5aed-49f8-ad1c-540094411664"],
    "ILayerUIPropPage": ["d3075f87-a7bd-4231-9f6a-60c5e07374a7"],
    "ILayerVisual": ["af843985-0444-4887-8e83-b40b253f822c"],
    "ILayerVisual2": ["98f9aeeb-6f23-49f1-90b1-1f59a14fbce3"],
    "ILayoutDumper": ["30510464-98b5-11cf-bb82-00aa00bdce0b"],
    "ILayoutInformation": ["b5384c9b-c8cf-41b3-bf16-18c8420e72c9"],
    "ILayoutInformationStatics": ["cf06cf99-58e9-4682-8326-50caab65ed7c"],
    "ILayoutInformationStatics2": ["760315b5-6d4e-4939-ac61-639863cea36b"],
    "ILayoutModifier": ["90b4135a-95ba-46ea-8caa-e05b45cd801e"],
    "ILayoutPreferencesOnAppLaunch": ["a2b8c352-914a-45ae-9f86-46236719c5c8"],
    "ILayoutProperties": ["ba1439cb-6514-4152-8a5a-9b9b5000e591"],
    "ILayoutType": ["50f4aa22-3684-4837-ab29-9485f697a0d1"],
    "ILearningModel": ["5b8e4920-489f-4e86-9128-265a327b78fa"],
    "ILearningModelBinding": ["ea312f20-168f-4f8c-94fe-2e7ac31b4aa8"],
    "ILearningModelBindingFactory": ["c95f7a7a-e788-475e-8917-23aa381faf0b"],
    "ILearningModelDevice": ["f5c2c8fe-3f56-4a8c-ac5f-fdb92d8b8252"],
    "ILearningModelDeviceFactory": ["9cffd74d-b1e5-4f20-80ad-0a56690db06b"],
    "ILearningModelDeviceFactoryNative": ["1e9b31a1-662e-4ae0-af67-f63bb337e634"],
    "ILearningModelDeviceStatics": ["49f32107-a8bf-42bb-92c7-10b12dc5d21f"],
    "ILearningModelEvaluationResult": ["b2f9bfcd-960e-49c0-8593-eb190ae3eee2"],
    "ILearningModelFeatureDescriptor": ["bc08cf7c-6ed0-4004-97ba-b9a2eecd2b4f"],
    "ILearningModelFeatureValue": ["f51005db-4085-4dfe-9fed-95eb0c0cf75c"],
    "ILearningModelOperatorProvider": ["2a222e5d-afb1-47ed-bfad-b5b3a459ec04"],
    "ILearningModelSession": ["8e58f8f6-b787-4c11-90f0-7129aeca74a9"],
    "ILearningModelSessionFactory": ["0f6b881d-1c9b-47b6-bfe0-f1cf62a67579"],
    "ILearningModelSessionFactory2": ["4e5c88bf-0a1f-5fec-ade0-2fd91e4ef29b"],
    "ILearningModelSessionOptions": ["b8f63fa1-134d-5133-8cff-3a5c3c263beb"],
    "ILearningModelSessionOptions2": ["6fcd1dc4-175f-5bd2-8de5-2f2006a25adf"],
    "ILearningModelStatics": ["e3b977e8-6952-4e47-8ef4-1f7f07897c6d"],
    "ILeavingBackgroundEventArgs": ["39c6ec9a-ae6e-46f9-a07a-cfc23f88733e"],
    "ILeavingBackgroundEventHandler": ["00b4ccd9-7a9c-4b6b-9ac4-13474f268bc4", "aaad5dad-4fc6-4aa4-b7cf-877e36ada4f6"],
    "ILegacyFindFiles": ["2946cccb-31c6-4323-92d4-b418f3e40b77"],
    "ILegacyIAccessibleProvider": ["e44c3566-915d-4070-99c6-047bff5a08f5"],
    "ILegacyInfo": ["000001ac-0000-0000-c000-000000000046"],
    "ILegacyPrintUI": ["81966513-2d8a-4056-99c4-b59ff186f2d2"],
    "ILegacyViewWrapper": ["2dd4e662-f456-4daf-aeff-84a1c012e15f"],
    "ILibraryDescription": ["86187c37-e662-4d1e-a122-7478676d7e6e"],
    "ILibraryFactory": ["12929ca2-37e4-440a-815a-759d7df24ec6"],
    "ILibraryFolderInit": ["09bec583-5e66-4457-a5f3-98302db60e12"],
    "ILibraryFolderValidationCallback": ["a7810c5d-2077-49c8-a08f-a23b17893e43"],
    "ILibraryShareEngine": ["659ad78f-1608-4a89-97d3-c8d741fdd0bc"],
    "ILicAgent": ["00194002-d9c3-11d3-8d59-0050048384e3"],
    "ILicValidator": ["919aa22c-b9ad-11d3-8d59-0050048384e3"],
    "ILicWizExternal": ["4cac6328-b9b0-11d3-8d59-0050048384e3"],
    "ILicenseChangedCallback": ["14985706-bc03-4a60-974e-1a7512567c5b"],
    "ILicenseChangedEventHandler": ["d4a50255-1369-4c36-832f-6f2d88e3659b"],
    "ILicenseIdentityContext": ["da85c393-2379-496d-a405-4def5e31f0aa"],
    "ILicenseIdentityContextSnapshot": ["0bd7b327-541e-4069-9e90-a1f2f9dd1ae5"],
    "ILicenseIdentityContextSnapshotRemediation": ["7f3fa025-e5e7-4d1d-82bc-3226aace4a1d"],
    "ILicenseInformation": ["8eb7dc30-f170-4ed5-8e21-1516da3fd367"],
    "ILicenseInstance": ["54d34ad6-0013-417b-9bb9-1dca63cab256"],
    "ILicenseInstanceInternal": ["03f4bb06-6c67-473a-8971-74761b3acf09"],
    "ILicenseManager": ["0c8de26f-bc3e-473a-ba3d-68cad2bf533f"],
    "ILicenseManager2": ["72ce0451-d460-4e78-b0ab-21890caf047c"],
    "ILicenseManagerFactory": ["8b79d867-8c47-4277-bc08-a51f22d951f1"],
    "ILicenseManagerStatics": ["b5ac3ae0-da47-4f20-9a23-09182c9476ff"],
    "ILicenseManagerStatics2": ["ab2ec47b-1f79-4480-b87e-2c499e601ba3"],
    "ILicenseManagerSubscriptions": ["d2a977cd-dfda-4162-ac48-e69d2820e81b"],
    "ILicenseManagerUserContext": ["ec241ad6-34c1-43cd-a349-d375905fc1e3"],
    "ILicenseProxyService": ["835af12e-4e5d-4ef6-bea7-09cb00dc8075"],
    "ILicenseProxyServiceTest": ["0362300c-886c-4a51-bfe0-63e0a7a8181a"],
    "ILicenseProxyServiceWithUserTicket": ["2f955a33-0cb0-4688-b365-d1a312aaaef3"],
    "ILicenseRemediationInfo": ["2082cf4e-067d-42a8-a528-43cfc302c067"],
    "ILicenseRequestData": ["1d9d0f8b-da81-424c-8f7e-92f3862ad1ad"],
    "ILicenseResponseData": ["9ed52611-9781-48a7-9bbf-61231feab825"],
    "ILicenseRootRequestData": ["bc38866e-eb56-4778-9757-a7e2cd8f4b7f"],
    "ILicenseRootResponseData": ["19bc68d4-8e48-41d6-966e-c4fd915f8143"],
    "ILicenseSatisfactionInfo": ["3ccbb08f-db31-48d5-8384-fa17c81474e2"],
    "ILicenseSatisfactionResult": ["3c674f73-3c87-4ee1-8201-f428359bd3af"],
    "ILicenseStorageService": ["6378598d-0ce5-4c84-8e31-ec14ede3b998"],
    "ILicenseStorageServiceTest": ["d5a7212c-a3e2-473f-a0ca-4a4e76a5601c"],
    "ILicenseTimerService": ["29c14b44-390b-40cb-9ccd-05a4cea88526"],
    "ILicenseTimerServiceCallback": ["5cdd240a-d2ab-4ef2-acf5-1ff2d460d0d9"],
    "ILicensedClassManager": ["6d5140d4-7436-11ce-8034-00aa006009fa"],
    "ILifetimeManagerRemote": ["fc99c60d-d59b-4b2b-b73d-3a1cc9f2aafa"],
    "ILightDismissNotification": ["8d4d1ec2-4740-4fc5-b4b1-6dc3722a2eeb"],
    "ILightDismissProvider": ["b849acb5-8ac5-4fb8-88b6-55c749d25a44"],
    "ILightDismissProviderTest": ["aadfb5d0-90e7-488d-a04c-271e59b564fd"],
    "ILightSensor": ["f84c0718-0c54-47ae-922e-789f57fb03a0"],
    "ILightSensor2": ["486b24e8-a94c-4090-8f48-09f782a9f7d5"],
    "ILightSensor3": ["4876d0ff-9f4c-5f72-adbd-a3471b063c00"],
    "ILightSensorDataThreshold": ["b160afd1-878f-5492-9f2c-33dc3ae584a3"],
    "ILightSensorDeviceId": ["7fee49f8-0afb-4f51-87f0-6c26375ce94f"],
    "ILightSensorReading": ["ffdf6300-227c-4d2b-b302-fc0142485c68"],
    "ILightSensorReading2": ["b7512185-44a3-44c9-8190-9ef6de0a8a74"],
    "ILightSensorReadingChangedEventArgs": ["a3a2f4cf-258b-420c-b8ab-8edd601ecf50"],
    "ILightSensorStatics": ["45db8c84-c3a8-471e-9a53-6457fad87c0e"],
    "ILightSensorStatics2": ["0ec0a650-ddc6-40ab-ace3-ec3359d42c51"],
    "ILimitedAccessFeatureRequestResult": ["d45156a6-1e24-5ddd-abb4-6188aba4d5bf"],
    "ILimitedAccessFeaturesStatics": ["8be612d4-302b-5fbf-a632-1a99e43e8925"],
    "ILimitedItemsView": ["d92e45a1-c7c0-4380-bea1-10beb57d9610"],
    "ILimiterEffectDefinition": ["6b755d19-2603-47ba-bdeb-39055e3486dc"],
    "ILimiterEffectDefinitionFactory": ["ecbae6f1-61ff-45ef-b8f5-48659a57c72d"],
    "ILineBreak": ["645589c4-f769-41ed-895b-8a1b2fb31562"],
    "ILineDisplay": ["24f5df4e-3c99-44e2-b73f-e51be3637a8c"],
    "ILineDisplay2": ["c296a628-ef44-40f3-bd1c-b04c6a5cdc7d"],
    "ILineDisplayAttributes": ["c17de99c-229a-4c14-a6f1-b4e4b1fead92"],
    "ILineDisplayCapabilities": ["5a15b5d1-8dc5-4b9c-9172-303e47b70c55"],
    "ILineDisplayCursor": ["ecdffc45-754a-4e3b-ab2b-151181085605"],
    "ILineDisplayCursorAttributes": ["4e2d54fe-4ffd-4190-aae1-ce285f20c896"],
    "ILineDisplayCustomGlyphs": ["2257f63c-f263-44f1-a1a0-e750a6a0ec54"],
    "ILineDisplayMarquee": ["a3d33e3e-f46a-4b7a-bc21-53eb3b57f8b4"],
    "ILineDisplayStatics": ["022dc0b6-11b0-4690-9547-0b39c5af2114"],
    "ILineDisplayStatics2": ["600c3f1c-77ab-4968-a7de-c02ff169f2cc"],
    "ILineDisplayStatisticsCategorySelector": ["b521c46b-9274-4d24-94f3-b6017b832444"],
    "ILineDisplayStatusUpdatedEventArgs": ["ddd57c1a-86fb-4eba-93d1-6f5eda52b752"],
    "ILineDisplayStoredBitmap": ["f621515b-d81e-43ba-bf1b-bcfa3c785ba0"],
    "ILineDisplayWindow": ["d21feef4-2364-4be5-bee1-851680af4964"],
    "ILineDisplayWindow2": ["a95ce2e6-bdd8-4365-8e11-de94de8dff02"],
    "ILineGeometry": ["30edd4a2-8fc5-40af-a7a2-c27fe7aa1363"],
    "ILineGeometryStatics": ["578ae763-5562-4ee4-8703-ea4036d891e3"],
    "ILineScrollerSpy": ["d294970d-48f2-48e7-9487-ab7a05a0bcfe"],
    "ILineSegment": ["ef6a2e25-3ff0-4420-a411-7182a4cecb15"],
    "ILineSegmentStatics": ["9fcab141-04c0-4afb-87b3-e800b969b894"],
    "ILineStatics": ["267c123d-6ea4-4c50-8b1d-50207aff1e8a"],
    "ILinearColorKeyFrame": ["66fdb6ef-ac81-4611-b1d2-61f545983f03"],
    "ILinearDoubleKeyFrame": ["8efdf265-9a7b-431d-8f0c-14c56b5ea4d9"],
    "ILinearEasingFunction": ["9400975a-c7a6-46b3-acf7-1a268a0a117d"],
    "ILinearGradientBrush": ["8e96d16b-bb84-4c6f-9dbf-9d6c5c6d9c39"],
    "ILinearGradientBrushFactory": ["0ae0861c-1e7a-4fed-9857-ea8caa798490"],
    "ILinearGradientBrushStatics": ["7af6e504-2dc3-40e3-be0b-b314c13cb991"],
    "ILinearPointKeyFrame": ["e7c9b8ef-af24-49ee-84f1-a86600a4e319"],
    "ILinguisticService": ["9d36af1e-bb5a-4d46-a8c3-a5eff90c28d0"],
    "ILink": ["22827db0-8266-4e0f-8172-9c169b813d28"],
    "ILinkItem": ["6e576dc2-4ba0-4351-95c0-8836295dcea6"],
    "ILinkItemHandler": ["dcfab355-c289-4b38-8f72-a360f4f2bf54"],
    "ILinkTarget": ["95e2a960-a4e4-4a71-bb4b-b07775b69cdd"],
    "ILinkTrackingInfo": ["f80759f1-8fcf-4244-8324-cf29513cec29"],
    "ILinksBand": ["d91b8947-f8ca-4508-a58a-2d8a49bf6111"],
    "ILinksMonitor": ["8b63fee2-ae22-40cc-85bc-45ccb7578289"],
    "ILinksMonitorEvents": ["765eb303-124e-4e48-a6bd-601eb5bc5950"],
    "ILinksToolbar": ["9f8f5a55-2564-4e24-902d-83c7d096d3d7"],
    "IListBox": ["e9f3b9ff-8e91-4ecf-a707-c927f694f881"],
    "IListBox2": ["70572aba-8ad1-4085-9350-deee359294e3"],
    "IListBoxAutomationPeer": ["8cd0d608-b402-4a6e-bd9a-343f8845eb32"],
    "IListBoxAutomationPeerFactory": ["e2362185-7df6-49f7-8abc-4c33f1a3d46e"],
    "IListBoxFactory": ["60cdfda2-2f44-444b-9c94-b8c9fda46f59"],
    "IListBoxItem": ["43c13323-6edf-4e4b-b6b2-3a93eec41d95"],
    "IListBoxItemAutomationPeer": ["1bc6e1c6-2997-42df-99eb-92bc1dd149fb"],
    "IListBoxItemAutomationPeerFactory": ["509f9dd8-b0aa-443f-a110-41209af44f1c"],
    "IListBoxItemDataAutomationPeer": ["fd7d5fee-fde0-482a-8084-dcebba5b9806"],
    "IListBoxItemDataAutomationPeerFactory": ["d7924e16-bd8d-4662-a995-20ff9a056093"],
    "IListBoxItemFactory": ["4398b8d4-a3de-402c-b23d-190384b27ca8"],
    "IListBoxStatics": ["6d3f7f73-706a-4e53-a9aa-c9a53c9cdd70"],
    "IListBoxStatics2": ["0089adeb-b709-4c8d-b1ed-4a7d97ee7716"],
    "IListControlProvider": ["16770868-239c-445b-a01d-f26c7fbbf26c"],
    "IListDebugFrameInfo": ["11d2710f-2e6f-4931-8fc8-936bfb5938a3"],
    "IListDebugPropertyInfo": ["2a9ddad2-bf0f-4406-b57d-be93ad78ee05"],
    "IListDescription": ["077386d3-344c-4e33-aa67-31408b2ee7a8"],
    "IListIUnknown": ["fdc0603f-f733-49c9-aad2-ac3e0ae513bb"],
    "IListIVxTextBuffer": ["121811be-de48-4320-b7c6-1237c0d2ff3b"],
    "IListIVxTextChange": ["7627a97f-187f-428e-bba9-07183f73a088"],
    "IListIVxTextSnapshot": ["b886572e-8f74-43c8-b8c1-f8bc0bdb5d1c"],
    "IListIVxTrackingSpan": ["fb17674f-3e6c-4ad2-9d17-e605c3f45262"],
    "IListItem": ["bdd1f04e-858b-11d1-b16a-00c0f0283628"],
    "IListItems": ["bdd1f04c-858b-11d1-b16a-00c0f0283628"],
    "IListPickerFlyout": ["0f0cb9d7-e5f3-45e6-9063-ff7bbb193c47"],
    "IListPickerFlyoutPresenter": ["68155fb3-883e-417a-80d0-e2fd88410084"],
    "IListPickerFlyoutPresenterAutomationPeer": ["56dfdc58-2395-4060-8047-8ea463698a24"],
    "IListPickerFlyoutStatics": ["fee25b97-8b96-4602-81d2-82fd8e0f7ea8"],
    "IListSubItem": ["bdd1f055-858b-11d1-b16a-00c0f0283628"],
    "IListSubItems": ["bdd1f053-858b-11d1-b16a-00c0f0283628"],
    "IListView": [
        "bdd1f049-858b-11d1-b16a-00c0f0283628",
        "e5b16af2-3990-4681-a609-1f060cd14269",
        "f6ce8c6d-fe96-41ad-a64a-c2b81c4af7f8",
    ],
    "IListViewAutomationPeer": ["73cecc87-c0dc-4260-9148-75e9864a7230"],
    "IListViewAutomationPeerFactory": ["65f39174-eaa2-4e44-8be6-4cca28cd0288"],
    "IListViewBase": ["3d0813ba-6890-4537-bfe5-796d9458edd6"],
    "IListViewBase2": ["d1c2a4f7-78a3-4491-86e0-2ddebc007ac5"],
    "IListViewBase3": ["b364c035-0a13-406f-a3fb-f30e7ddca94c"],
    "IListViewBase4": ["18b7792b-11dc-4eb6-a7bc-741adb3eeb79"],
    "IListViewBase5": ["1a9c6e99-1719-4b80-b335-628331a07019"],
    "IListViewBase6": ["f8a42637-965b-483b-94e5-e5c9fef0e352"],
    "IListViewBaseAutomationPeer": ["87ec7649-b83d-4e55-9afd-bd835e748f5c"],
    "IListViewBaseAutomationPeerFactory": ["70d3c2be-8950-4647-9362-fd002f8ff82e"],
    "IListViewBaseFactory": ["e67e6c7f-150f-46d0-a6ac-c5002bd9ca53"],
    "IListViewBaseHeaderItem": ["6d0ded27-0d19-4091-8917-ce7c85c1e630"],
    "IListViewBaseHeaderItemAutomationPeer": ["7cb8b732-c1f0-4a3c-bc14-85dd48dedb85"],
    "IListViewBaseHeaderItemAutomationPeerFactory": ["40ec995f-d631-4004-832e-6d8643e51561"],
    "IListViewBaseHeaderItemFactory": ["3872a6a1-ea19-455f-9df7-147cc41d329c"],
    "IListViewBaseStatics": ["8532b8f7-3e16-455b-89a8-c1346223f6d3"],
    "IListViewBaseStatics2": ["821c00c8-78cc-411f-9f2e-a55758227f3e"],
    "IListViewBaseStatics3": ["3b539091-31c6-4d0c-90af-5dc1d6ae9c05"],
    "IListViewBaseStatics4": ["ad13258b-fbd0-4f18-8bf8-9b8613951c22"],
    "IListViewBaseStatics5": ["40346fcf-0476-4259-895f-a6569738620f"],
    "IListViewFactory": ["bdff696d-3f22-41f9-97a6-883134a76113"],
    "IListViewFooter": ["f0034da8-8a22-4151-8f16-2eba76565bcc"],
    "IListViewFooterCallback": ["88eb9442-913b-4ab4-a741-dd99dcb7558b"],
    "IListViewHeaderItem": ["1b61baeb-e196-4b3b-a5f9-1ed636f3f79b"],
    "IListViewHeaderItemAutomationPeer": ["67ab1e4b-ad61-4c88-ba45-0f3a8d061f8f"],
    "IListViewHeaderItemAutomationPeerFactory": ["07668694-2ca5-4be4-a8b9-592d48f76087"],
    "IListViewHeaderItemFactory": ["68d2c96a-96b0-4f08-a7a5-f1086720a0fa"],
    "IListViewItem": ["b7bb4305-3dd9-43de-a8c0-c472f085bc11"],
    "IListViewItemAutomationPeer": ["ca114e70-a16d-4d09-a1cf-1856ef98a9ec"],
    "IListViewItemAutomationPeerFactory": ["c47dfbc0-facc-4024-a73b-17ec4e662654"],
    "IListViewItemDataAutomationPeer": ["15a8d7fd-d7a5-4a6c-963c-6f7ce464671a"],
    "IListViewItemDataAutomationPeerFactory": ["d0db12bb-d715-4523-acc0-1e1072d8e32b"],
    "IListViewItemFactory": ["f431073d-9cac-42a2-82df-0f4490bc4e2e"],
    "IListViewItemPresenter": ["fc8946bd-a3a2-4969-8174-25b5d3c28033"],
    "IListViewItemPresenter2": ["f5dc5496-e122-4c57-a625-ac4b08fb2d4c"],
    "IListViewItemPresenter3": ["36620013-0390-4e30-ad97-8744404f7010"],
    "IListViewItemPresenterFactory": ["e0777cfd-f7e4-4a67-9ac0-a994fcacd020"],
    "IListViewItemPresenterStatics": ["6504a55a-15dd-42fb-aa5d-2d8ce2e9c294"],
    "IListViewItemPresenterStatics2": ["4cb3b945-d24d-42a3-9e83-a86d0618bf1b"],
    "IListViewItemPresenterStatics3": ["c3d3d11e-fa26-4ce7-a4ed-ff948f01b7c0"],
    "IListViewItemTemplateSettings": ["67af84bf-8279-4686-9326-cd189f27575d"],
    "IListViewItemToKeyHandler": ["6af5da76-7e8b-4a91-9a56-460cb47d523f"],
    "IListViewKeyToItemHandler": ["26fd5855-b530-4688-b9f0-428249178ef8"],
    "IListViewPersistenceHelper": ["05bde8a6-2191-4b4b-8c22-9b25676e806e"],
    "IListViewPersistenceHelperStatics": ["6d0c2b08-bb9b-44f9-8063-5c3f9c21884b"],
    "IListVxSnapshotPoint": ["587a5a1a-4b4e-43f8-896f-7d61716a33cb"],
    "IListVxSnapshotSpan": ["75970b1d-36b9-419b-bf43-ec2a66776955"],
    "IListVxSpan": ["f265752d-e60c-4c02-a3d4-9200a936b1b4"],
    "IListingInformation": ["588b4abf-bc74-4383-b78c-99606323dece"],
    "IListingInformation2": ["c0fd2c1d-b30e-4384-84ea-72fefa82223e"],
    "ILoadChangeContext": ["44a4aaca-ec39-46d5-b5c9-d633c0ee67e2"],
    "ILoadCompletedEventHandler": ["aebaf785-43fc-4e2c-95c3-97ae84eabc8e"],
    "ILoadFilter": ["c7310722-ac80-11d1-8df3-00c04fb6ef4f"],
    "ILoadFilterWithPrivateComActivation": ["40bdbd34-780b-48d3-9bb6-12ebd4ad2e75"],
    "ILoadedImageSourceLoadCompletedEventArgs": ["1ac60b1e-7837-4489-b3e5-d0d5ad0a56c4"],
    "ILoadedImageSurface": ["050c8313-6737-45ba-8531-33094febef55"],
    "ILoadedImageSurfaceStatics": ["22b8edf6-84ad-40ab-937d-4871613e765d"],
    "ILoadedStorageViewInternal": ["f3f052bf-4de6-46aa-995b-69f14322b099"],
    "ILocalAccountManager": ["ce6af879-5386-4daf-83fd-850b56486428"],
    "ILocalAccountManagerAuthBufferHelpers": ["4c939908-0198-4da2-bd62-ed4938edb44f"],
    "ILocalAccountManagerNgcHelpers": ["c42d0c9d-19d2-4480-995c-976ccd8de49d"],
    "ILocalAccountTaskPrivate": ["7006713f-0333-463d-889e-2314bcd790ec"],
    "ILocalCategoriesStatics": ["f49399f5-8261-4321-9974-ef92d49a8dca"],
    "ILocalConnectionListener": ["b8482f5b-c1cb-4cfb-a1e3-86618cc8067e"],
    "ILocalContentSuggestionSettings": ["eeaeb062-743d-456e-84a3-23f06f2d15d7"],
    "ILocalCopy": ["d5ab5937-4a2a-4c16-85b3-56bbed37487b"],
    "ILocalCopyDownloadSettings": ["667708d1-a931-4a85-9999-609eaa7dd85a"],
    "ILocalFileBroker": ["0fbfe6c9-3b4c-4d47-a5b7-159b55534d66"],
    "ILocalLocation": ["bb0fe9ab-4502-4f2c-94a9-0d60de0e2163"],
    "ILocalLocation2": ["6e9e307c-ecb5-4ffc-bb8c-ba50ba8c2dc6"],
    "ILocalLocationFinderResult": ["d09b6cc6-f338-4191-9fd8-5440b9a68f52"],
    "ILocalLocationFinderStatics": ["d2ef7344-a0de-48ca-81a8-07c7dcfd37ab"],
    "ILocalLocationHoursOfOperationItem": ["23548c72-a1c7-43f1-a4f0-1091c39ec640"],
    "ILocalLocationRatingInfo": ["cb1dab56-3354-4311-8bc0-a2d4d5eb806e"],
    "ILocalMachineNames": ["0000015a-0000-0000-c000-000000000046"],
    "ILocalMapTileDataSource": ["616257b5-9108-4f12-8bf4-bb3c8f6274e5"],
    "ILocalMapTileDataSourceFactory": ["c5cfe9fc-72ac-4839-8a0d-011f24693c79"],
    "ILocalProvider": ["b2e4eb94-e61f-478b-9fa4-d415cae5a5fd"],
    "ILocalRankerGroup": ["d7861d14-42f7-41f5-8068-bc5d23fc6415"],
    "ILocalRegistry": ["6d5140d3-7436-11ce-8034-00aa006009fa"],
    "ILocalRegistry2": ["77bb19b0-0462-11d1-aaf6-00a0c9055a90"],
    "ILocalRegistry3": ["1b01f13f-abee-4761-91af-76ce6b4c9e7a"],
    "ILocalRegistry4": ["5c45b909-e820-4acc-b894-0a013c6da212"],
    "ILocalRegistry5": ["d5f528b9-e492-43a7-afc0-f98a8fb0516d"],
    "ILocalRoamedMachine": ["9834fd4a-c5e2-4efa-b7d4-5a7af4859feb"],
    "ILocalRoamedTabs": ["efe15d70-16fc-41c9-8d9d-e32714dab88f"],
    "ILocalServerInfo": ["c835ea86-8854-4ab8-9e2b-77e29dab4c75"],
    "ILocalSettingSyncProvider": ["4d2e63e3-ec0b-4227-93ba-8ed2d9525512"],
    "ILocalSystemActivator": ["00000132-0000-0000-c000-000000000046"],
    "ILocalVideoStream": ["54024241-6c0b-49bb-b200-e4a6ec2bdeed"],
    "ILocalWeightGroup": ["bfd28008-b2a5-48bb-b0dc-a54de4d003e0"],
    "ILocalizedPropertyStore": ["cb072faa-cf74-45ab-afb0-fe3d89ffdd94"],
    "ILocallyCachedItem": ["f8bc0f33-bd7c-4872-a6fe-8dab9ed2cf44"],
    "ILocation": ["ab2ece69-56d9-4f28-b525-de1b0ee44237"],
    "ILocationCreator": ["08687bd9-c16d-4592-ae76-56c852cab45c"],
    "ILocationDescription": ["51016709-f127-43d9-a644-6d60bbd83cb6"],
    "ILocationDescription2": ["f8e6532b-c735-4517-bf1d-cbe30df8fe1c"],
    "ILocationEvents": ["cae02bbf-798b-4508-a207-35a7906dc73d"],
    "ILocationPermissions": ["d5fb0a7f-e74e-44f5-8e02-4806863a274f"],
    "ILocationPower": ["193e7729-ab6b-4b12-8617-7596e1bb191c"],
    "ILocationReport": ["c8b7f7ee-75d0-4db9-b62d-7a0f369ca456"],
    "ILocationReportFactory": ["2daec322-90b2-47e4-bb08-0da841935a6b"],
    "ILocationTrigger": ["47666a1c-6877-481e-8026-ff7e14a811a0"],
    "ILocationTriggerFactory": ["1106bb07-ff69-4e09-aa8b-1384ea475e98"],
    "ILocator": ["286d7f89-760c-4f89-80c4-66841d2507aa"],
    "ILockAppHostShellInterop": ["72163aa1-8a18-436a-9067-3a86aa7460dc"],
    "ILockApplicationHost": ["38ee31ad-d94f-4e7c-81fa-4f4436506281"],
    "ILockApplicationHostStatics": ["f48fab8e-23d7-4e63-96a1-666ff52d3b2c"],
    "ILockScreenActivatedEventArgs": ["3ca77966-6108-4a41-8220-ee7d133c8532"],
    "ILockScreenAppPositioner": ["7437db22-fcaa-4d0b-ad90-2f4cd133f967"],
    "ILockScreenBadge": ["e95105d9-2bff-4db0-9b4f-3824778b9c9a"],
    "ILockScreenCallActivatedEventArgs": ["06f37fbe-b5f2-448b-b13e-e328ac1c516a"],
    "ILockScreenCallBroker": ["bef9ea75-773f-4f44-81c1-6ef017b52802"],
    "ILockScreenCallBrokerPriv": ["a7c2344c-80d3-46af-9538-aa7b5aad574d"],
    "ILockScreenCallEndCallDeferral": ["2dd7ed0d-98ed-4041-9632-50ff812b773f"],
    "ILockScreenCallEndRequestedEventArgs": ["8190a363-6f27-46e9-aeb6-c0ae83e47dc7"],
    "ILockScreenCallUI": ["c596fd8d-73c9-4a14-b021-ec1c50a3b727"],
    "ILockScreenContentionFlyout": ["991cc8d2-5bdb-4ad5-bbb8-5eecb53a9c49"],
    "ILockScreenCreativeConfig": ["fb37854f-513a-4ca8-9a06-4adab5968a23"],
    "ILockScreenImageFeedStatics": ["2c0d73f6-03a9-41a6-9b01-495251ff51d5"],
    "ILockScreenInfo": ["f59aa65c-9711-4dc9-a630-95b6cb8cdad0"],
    "ILockScreenStatics": ["3ee9d3ad-b607-40ae-b426-7631d9821269"],
    "ILockScreenToastEndpoint": ["dbbf74d0-f031-47af-bb04-91ec3bad0adc"],
    "ILockScreenToastSink": ["856859e3-ce2b-4a92-a45b-5c5d66950baa"],
    "ILockScreenUnlockingDeferral": ["7e7d1ad6-5203-43e7-9bd6-7c3947d1e3fe"],
    "ILockScreenUnlockingEventArgs": ["44e6c007-75fb-4abb-9f8b-824748900c71"],
    "ILockScreenViewManager": ["8bb5da34-1b62-4c69-b17e-da7c688aa451"],
    "ILockScreenViewManagerNotificationCallback": ["989e63bd-43c5-4815-b192-2251e9a6e452"],
    "ILogFileGeneratedEventArgs": ["269e976f-0d38-4c1a-b53f-b395d881df84"],
    "ILogFileItem": ["d6b518dd-05c7-418a-89e6-4f9ce8c6841e"],
    "ILogFiles": ["6a2a97e6-6851-41ea-87ad-2a8225335865"],
    "ILogPlugin": ["08fd99d1-cfb6-11cf-bc03-00aa006111e0"],
    "ILogPluginEx": ["3710e192-9c25-11d1-8b9a-080009dcc2fa"],
    "ILogRecover": ["b992fa57-128c-11d1-97e4-00c04fb9618a"],
    "ILoggingActivity": ["bc032941-b766-4cb5-9848-97ac6ba6d60c"],
    "ILoggingActivity2": ["26c29808-6322-456a-af82-80c8642f178b"],
    "ILoggingActivityFactory": ["6b33b483-e10a-4c58-97d5-10fb451074fb"],
    "ILoggingChannel": ["e9a50343-11d7-4f01-b5ca-cf495278c0a8"],
    "ILoggingChannel2": ["9f4c3cf3-0bac-45a5-9e33-baf3f3a246a5"],
    "ILoggingChannelFactory": ["4edc5b9c-af80-4a9b-b0dc-398f9ae5207b"],
    "ILoggingChannelFactory2": ["4c6ef5dd-3b27-4dc9-99f0-299c6e4603a1"],
    "ILoggingChannelOptions": ["c3e847ff-0ebb-4a53-8c54-dec24926cb2c"],
    "ILoggingChannelOptionsFactory": ["a93151da-7faf-4191-8755-5e86dc65d896"],
    "ILoggingFields": ["d7f6b7af-762d-4579-83bd-52c23bc333bc"],
    "ILoggingOptions": ["90bc7850-0192-4f5d-ac26-006adaca12d8"],
    "ILoggingOptionsFactory": ["d713c6cb-98ab-464b-9f22-a3268478368a"],
    "ILoggingSession": ["6221f306-9380-4ad7-baf5-41ea9310d768"],
    "ILoggingSessionFactory": ["4e937ee5-58fd-45e0-8c2f-a132eff95c1e"],
    "ILoggingTarget": ["65f16c35-e388-4e26-b17a-f51cd3a83916"],
    "ILoginCallback": ["711db9ba-3317-4234-afa9-6bdd67047626"],
    "ILogonErrorRedirector": ["2344718b-40d0-4cb0-9a92-78c3c3ae7fb0"],
    "ILogonTrigger": ["72dade38-fae4-4b3e-baf4-5d009af02b1c"],
    "ILoopingSelector": ["4c9a3e04-4827-49d9-8806-093957b0fd21"],
    "ILoopingSelectorAutomationPeer": ["50b406ca-bae9-4816-8a3a-0cb4f96478a2"],
    "ILoopingSelectorItem": ["c69714b9-27c6-4433-9d7c-0dbfb2f4344f"],
    "ILoopingSelectorItemAutomationPeer": ["d3fa68bf-04cf-4f4c-8d3e-4780a19d4788"],
    "ILoopingSelectorItemDataAutomationPeer": ["ef567e32-7cd2-4d32-9590-1f588d5ef38d"],
    "ILoopingSelectorPanel": ["40a9ba70-1011-4778-87f7-6bfd20d6377d"],
    "ILoopingSelectorStatics": ["03e8bafa-8c7d-4fc5-b92a-f049fb933cc5"],
    "ILoriEvents": ["07ab1e58-91a0-450f-b4a5-a4c775e67359"],
    "ILosingFocusEventArgs": ["f9f683c7-d789-472b-aa93-6d4105e6dabe"],
    "ILosingFocusEventArgs2": ["0493fad9-c27f-469f-8e62-52b3a4f7cd54"],
    "ILosingFocusEventArgs3": ["c98900bd-0b79-566e-ad1f-436fa513ae22"],
    "ILowLagMediaRecording": ["41c8baf7-ff3f-49f0-a477-f195e3ce5108"],
    "ILowLagMediaRecording2": ["6369c758-5644-41e2-97af-8ef56a25e225"],
    "ILowLagMediaRecording3": ["5c33ab12-48f7-47da-b41e-90880a5fe0ec"],
    "ILowLagPhotoCapture": ["a37251b7-6b44-473d-8f24-f703d6c0ec44"],
    "ILowLagPhotoControl": ["6d5c4dd0-fadf-415d-aee6-3baa529300c9"],
    "ILowLagPhotoSequenceCapture": ["7cc346bb-b9a9-4c91-8ffa-287e9c668669"],
    "ILowLagPhotoSequenceControl": ["3dcf909d-6d16-409c-bafe-b9a594c6fde6"],
    "ILowLevelDevicesAggregateProvider": ["a73e561c-aac1-4ec7-a852-479f7060d01f"],
    "ILowLevelDevicesAggregateProviderFactory": ["9ac4aaf6-3473-465e-96d5-36281a2c57af"],
    "ILowLevelDevicesController": ["2ec23dd4-179b-45de-9b39-3ae02527de52"],
    "ILowLevelDevicesControllerStatics": ["093e926a-fccb-4394-a697-19de637c2db3"],
    "ILowLightFusionResult": ["78edbe35-27a0-42e0-9cd3-738d2089de9c"],
    "ILowLightFusionStatics": ["5305016d-c29e-40e2-87a9-9e1fd2f192f5"],
    "ILowMicHelper": ["3ed4ec4c-9931-432b-bffd-b8e13c2e6dad"],
    "IMAOAdminBroker": ["dd3d809a-0d91-4c71-856d-096877d72b7a"],
    "IMCISMessageFilter": ["f174e5b0-9046-11d0-a9e8-00aa00685c74"],
    "IMDDataset": ["a07cccd1-8148-11d0-87bb-00c04fc33942"],
    "IMDEConnectionManager": ["120c85a1-1764-437e-93bf-40d5cdac64cb"],
    "IMDEDatapath": ["479af05b-ffb9-4227-bc12-cb5d601ba5f2"],
    "IMDEExternalSessionState": ["57bed9a8-e93e-4c2c-84e7-cbfb57d61958"],
    "IMDEMiracastConnection": ["bd35fc34-a301-4a54-bfc9-679b2c5bdb8b"],
    "IMDEMiracastEventHandler": ["e1f07147-64b7-43dc-9605-91b0e6e9300a"],
    "IMDEOpCenter": ["b08701d0-0568-4010-83cd-52215d6238e1"],
    "IMDEOpCenter2": ["9adf3b82-5d26-4061-8ac3-3605be2c3e52"],
    "IMDEOpCenterWithSessionFactory": ["d4418574-611a-47f9-8681-405034dd4c94"],
    "IMDEOutputProfileManager": ["da03f4a9-d4d8-4769-a0e3-3591ba6adfb9"],
    "IMDEOutputProfileManager2": ["d73e04b3-3408-42d8-9bb1-f988ac79c57e"],
    "IMDEOutputProfileManager3": ["d9247f7b-1aa7-407f-8952-62709b79b66f"],
    "IMDETranscodeManager": ["3d5cd812-9a2f-4bc0-9ff1-5a2bbf3766c0"],
    "IMDFind": ["a07cccd2-8148-11d0-87bb-00c04fc33942"],
    "IMDRangeRowset": ["0c733aa0-2a1c-11ce-ade5-00aa0044773d"],
    "IMDSPDevice": ["1dcb3a12-33ed-11d3-8470-00c04f79dbc0"],
    "IMDSPDevice2": ["420d16ad-c97d-4e00-82aa-00e9f4335ddd"],
    "IMDSPDevice3": ["1a839845-fc55-487c-976f-ee38ac0e8c4e"],
    "IMDSPDeviceControl": ["1dcb3a14-33ed-11d3-8470-00c04f79dbc0"],
    "IMDSPDirectTransfer": ["c2fe57a8-9304-478c-9ee4-47e397b912d7"],
    "IMDSPEnumDevice": ["1dcb3a11-33ed-11d3-8470-00c04f79dbc0"],
    "IMDSPEnumStorage": ["1dcb3a15-33ed-11d3-8470-00c04f79dbc0"],
    "IMDSPObject": ["1dcb3a18-33ed-11d3-8470-00c04f79dbc0"],
    "IMDSPObject2": ["3f34cd3e-5907-4341-9af9-97f4187c3aa5"],
    "IMDSPObjectInfo": ["1dcb3a19-33ed-11d3-8470-00c04f79dbc0"],
    "IMDSPRevoked": ["a4e8f2d4-3f31-464d-b53d-4fc335998184"],
    "IMDSPStorage": ["1dcb3a16-33ed-11d3-8470-00c04f79dbc0"],
    "IMDSPStorage2": ["0a5e07a5-6454-4451-9c36-1c6ae7e2b1d6"],
    "IMDSPStorage3": ["6c669867-97ed-4a67-9706-1c5529d2a414"],
    "IMDSPStorage4": ["3133b2c4-515c-481b-b1ce-39327ecb4f74"],
    "IMDSPStorageGlobals": ["1dcb3a17-33ed-11d3-8470-00c04f79dbc0"],
    "IMDServiceProvider": ["1dcb3a10-33ed-11d3-8470-00c04f79dbc0"],
    "IMDServiceProvider2": ["b2fa24b7-cda3-4694-9862-413ae1a34819"],
    "IMDServiceProvider3": ["4ed13ef3-a971-4d19-9f51-0e1826b2da57"],
    "IMF2DBuffer": ["7dc9d5f9-9ed9-44ec-9bbf-0600bb589fbb"],
    "IMF2DBuffer2": ["33ae5ea6-4316-436f-8ddd-d73d22f829ec"],
    "IMF2DBuffer2Internal": ["1482b536-399f-4472-90a3-c7384d77558d"],
    "IMF2DBuffer3Internal": ["c106c57d-d856-4fc1-88ac-26c43da36c4b"],
    "IMFASFContentInfo": ["b1dca5cd-d5da-4451-8e9e-db5c59914ead"],
    "IMFASFIndexer": ["53590f48-dc3b-4297-813f-787761ad7b3e"],
    "IMFASFMultiplexer": ["57bdd80a-9b38-4838-b737-c58f670d7d4f"],
    "IMFASFMutualExclusion": ["12558291-e399-11d5-bc2a-00b0d0f3f4ab"],
    "IMFASFProfile": ["d267bf6a-028b-4e0d-903d-43f0ef82d0d4"],
    "IMFASFSplitter": ["12558295-e399-11d5-bc2a-00b0d0f3f4ab"],
    "IMFASFStreamConfig": ["9e8ae8d2-dbbd-4200-9aca-06e6df484913"],
    "IMFASFStreamPrioritization": ["699bdc27-bbaf-49ff-8e38-9c39c9b5e088"],
    "IMFASFStreamSelector": ["d01bad4a-4fa0-4a60-9349-c27e62da9d41"],
    "IMFActivate": ["7fee9e9a-4a89-47a6-899c-b6a53a70fb67"],
    "IMFAppStateChangeNotify": ["4461eda8-0cb4-4fce-88b9-a5e62a74fdaa"],
    "IMFAsyncCallback": ["a27003cf-2354-4f2a-8d6a-ab7cff15437e"],
    "IMFAsyncCallbackLogging": ["c7a4dca1-f5f0-47b6-b92b-bf0106d25791"],
    "IMFAsyncResult": ["ac6b7889-0740-4d51-8619-905994a55cc6"],
    "IMFAttributes": ["2cd2d921-c447-44a7-a13c-4adabfc247e3"],
    "IMFAudioMediaType": ["26a0adc3-ce26-4672-9304-69552edd3faf"],
    "IMFAudioPolicy": ["a0638c2b-6465-4395-9ae7-a321a9fd2856"],
    "IMFAudioRenderPrivate": ["413ed6d4-9acd-4118-9cca-f2a39675e4d8"],
    "IMFAudioStatistics": ["b0f2fc5d-a724-4709-b629-2fa6912683f2"],
    "IMFAudioStreamVolume": ["76b1bbdb-4ec8-4f36-b106-70a9316df593"],
    "IMFAuthenticationContext": ["0feb8e8f-aa79-4de8-a928-d1b4de0552d5"],
    "IMFBfrHandler": ["672b333c-077b-4f68-b4b6-c116bb1f947b"],
    "IMFBufferListNotify": ["24cd47f7-81d8-4785-adb2-af697a963cd2"],
    "IMFBufferReleaseCallback": ["e0e43df5-dd2f-4241-8a9f-9bc6e9619ebe"],
    "IMFByteStream": ["ad4c1b00-4bf7-422f-9175-756693d9130d"],
    "IMFByteStreamBuffering": ["6d66d782-1d4f-4db7-8c63-cb8c77f1ef5e"],
    "IMFByteStreamCacheControl": ["f5042ea4-7a96-4a75-aa7b-2be1ef7f88d5"],
    "IMFByteStreamCacheControl2": ["71ce469c-f34b-49ea-a56b-2d2a10e51149"],
    "IMFByteStreamDownloadRateControl": ["82dd62b7-bfe3-44cb-a195-9d8e3ea3e161"],
    "IMFByteStreamHandler": ["bb420aa4-765b-4a1f-91fe-d6a8a143924c"],
    "IMFByteStreamProgressiveDownload": ["ef92650a-d0e5-40a4-8ea2-1fe69e8ad6ac"],
    "IMFByteStreamProxyClassFactory": ["a6b43f84-5c0a-42e8-a44d-b1857a76992f"],
    "IMFByteStreamReplace": ["adf0be72-70e2-4bab-8028-8aa842fa28ba"],
    "IMFByteStreamReservation": ["1a37165b-2079-402c-9e2c-ebcdede8c12f"],
    "IMFByteStreamReuse": ["8484e72a-cd3d-40b6-a4d2-0c8a262a18cc"],
    "IMFByteStreamTimeSeek": ["64976bfa-fb61-4041-9069-8c9a5f659beb"],
    "IMFCDM": ["fc9460f5-d471-429f-a8f8-fdf0fe9b45f5"],
    "IMFCDM2": ["b614e03a-cdab-4ed4-b10d-c65657d20cbf"],
    "IMFCDM3": ["83489f3d-d123-4f3e-883c-69430789c228"],
    "IMFCDMAccess": ["c2e03abd-858a-4458-9633-c76b6134118f"],
    "IMFCDMFactory": ["51731d73-7e90-4546-bc0c-d7ea67a61896"],
    "IMFCDMFactory2": ["1a5d4d24-14f3-4fea-b3a5-c62bf6fdaa9d"],
    "IMFCDMFactory3": ["3c023cf8-4a3b-455c-8e97-3e40ecfd6f88"],
    "IMFCDMSession": ["5fae84c7-5d75-4a07-b7b2-197435509e54"],
    "IMFCDMSession2": ["14475fce-a45b-45ba-87a0-d10ead6765f8"],
    "IMFCDMSessionCallbacks": ["9a956fcd-3e32-407f-a896-86922d354ed0"],
    "IMFCDMSessionCallbacks2": ["ef28f579-1abb-4ca7-85f1-565c91154a01"],
    "IMFCameraProfile": ["6764318a-8018-41b6-b65a-ab48f8aed212"],
    "IMFCameraProfileCollection": ["1a59dd98-e38b-491a-972b-e3f6de172a20"],
    "IMFCameraProfileConcurrency": ["40473867-e26d-4e58-b32c-7694cf359197"],
    "IMFCameraProfilePin": ["f0c55e3a-c722-4e72-be3c-7a7a590fe799"],
    "IMFCameraProfilePinMedia": ["1cd040e7-21de-4a74-947d-064266d65e4f"],
    "IMFCameraProfilePinMedia2": ["41571254-67a7-464b-84f8-2cd7f8556281"],
    "IMFCameraProfileValidation": ["1f7b8766-18f9-41bf-b03a-d2a8cdba0c06"],
    "IMFCameraStreamStateShutdown": ["a7c2f0d6-86e8-469b-b22e-be9caba350b5"],
    "IMFCaptureEngine": ["a6bba433-176b-48b2-b375-53aa03473207"],
    "IMFCaptureEngine2": ["dbc97bd4-eeb1-48b4-859b-9db001a05e26"],
    "IMFCaptureEngineClassFactory": ["8f02d140-56fc-4302-a705-3a97c78be779"],
    "IMFCaptureEngineNotify": ["74890190-092f-4db7-b255-a21f3b2b6e36"],
    "IMFCaptureEngineOnEventCallback": ["aeda51c0-9025-4983-9012-de597b88b089"],
    "IMFCaptureEngineOnPeekingSampleCallback": ["fdea8535-707a-4022-9983-428f669e0896"],
    "IMFCaptureEngineOnSampleCallback": ["52150b82-ab39-4467-980f-e48bf0822ecd"],
    "IMFCaptureEngineOnSampleCallback2": ["e37ceed7-340f-4514-9f4d-9c2ae026100b"],
    "IMFCaptureFrameReaderSink": ["d309a0a1-5b67-44ba-93e0-66f8222614d6"],
    "IMFCapturePhotoConfirmation": ["19f68549-ca8a-4706-a4ef-481dbc95e12c"],
    "IMFCapturePhotoSink": ["d2d43cc8-48bb-4aa7-95db-10c06977e777"],
    "IMFCapturePreviewSink": ["77346cfd-5b49-4d73-ace0-5b52a859f2e0"],
    "IMFCapturePreviewSinkInternal": ["2a3995fa-f92c-4ac7-b969-4c5cb8b67af7"],
    "IMFCapturePreviewSinkInternal2": ["8d503bbc-a19d-4dda-9028-d0738695cdf6"],
    "IMFCaptureRecordSink": ["3323b55a-f92a-4fe2-8edc-e9bfc0634d77"],
    "IMFCaptureRecordSinkInternal": ["11ae1897-f7f8-4334-b8a9-3a190fa8dcea"],
    "IMFCaptureSink": ["72d6135b-35e9-412c-b926-fd5265f2a885"],
    "IMFCaptureSink2": ["f9e4219e-6197-4b5e-b888-bee310ab2c59"],
    "IMFCaptureSource": ["439a42a8-0d2c-4505-be83-f79b2a05d5c4"],
    "IMFCaptureSourceAsyncDeviceControl": ["dc0861ea-3d09-4d42-ac77-22e9202a4298"],
    "IMFCaptureSourceBasicDeviceControl": ["00029279-2dd8-4e97-ac7d-b3da0d129a48"],
    "IMFCaptureSourceDeviceControl": ["6bb90109-1928-4855-b37f-cf8af0d07de6"],
    "IMFCaptureSourceDeviceControl2": ["b8ab84fa-2e3e-4353-b792-a3d15872a340"],
    "IMFCaptureSourceDeviceController": ["d3989299-5ea3-40f3-9c87-7f83d68990a1"],
    "IMFCaptureSourceInternal": ["44ac72a8-9183-4214-b128-044ff537f0cf"],
    "IMFCaptureSourceInternal2": ["2ad90d27-1361-4271-91d2-1e47c365c9d9"],
    "IMFCdmSuspendNotify": ["7a5645d2-43bd-47fd-87b7-dcd24cc7d692"],
    "IMFChannelAccelerator": ["2d188d37-0418-44d2-b8d1-e06f0a9db3dc"],
    "IMFClock": ["2eb1e945-18b8-4139-9b1a-d5d584818530"],
    "IMFClockConsumer": ["6ef2a662-47c0-4666-b13d-cbb717f2fa2c"],
    "IMFClockRateMatch": ["828e7c7e-84f2-4b45-8cee-5bb3d827fcf5"],
    "IMFClockStateSink": ["f6696e82-74f7-4f3d-a178-8a5e09c3659f"],
    "IMFCodecAPIRemoting": ["12c96fba-0004-45d8-8674-52a37917699c"],
    "IMFCollection": ["5bc8a76b-869a-46a3-9b03-fa218a66aebe"],
    "IMFComponentCreator": ["97ec2ea2-0e42-4937-97ac-9d6d328824e1"],
    "IMFCongestionHandler": ["051268b6-eba3-4123-973d-6cb63fb4cc75"],
    "IMFContentDecryptionModule": ["87be986c-10be-4943-bf48-4b54ce1983a2"],
    "IMFContentDecryptionModuleAccess": ["a853d1f4-e2a0-4303-9edc-f1a68ee43136"],
    "IMFContentDecryptionModuleFactory": ["7d5abf16-4cbb-4e08-b977-9ba59049943e"],
    "IMFContentDecryptionModuleSession": ["4e233efd-1dd2-49e8-b577-d63eee4c0d33"],
    "IMFContentDecryptionModuleSessionCallbacks": ["3f96ee40-ad81-4096-8470-59a4b770f89a"],
    "IMFContentDecryptorContext": ["7ec4b1bd-43fb-4763-85d2-64fcb5c5f4cb"],
    "IMFContentEnabler": ["d3c4ef59-49ce-4381-9071-d5bcd044c770"],
    "IMFContentProtectionDevice": ["e6257174-a060-4c9a-a088-3b1b471cad28"],
    "IMFContentProtectionManager": ["acf92459-6a61-42bd-b57c-b43e51203cb0"],
    "IMFD3D12SynchronizationObject": ["802302b0-82de-45e1-b421-f19ee5bdaf23"],
    "IMFD3D12SynchronizationObjectCommands": ["09d0f835-92ff-4e53-8efa-40faa551f233"],
    "IMFDLNAProfileInfo": ["62e536d0-e618-4735-ae4c-14ed5d74ba50"],
    "IMFDLNASinkInit": ["0c012799-1b61-4c10-bda9-04445be5f561"],
    "IMFDRMNetHelper": ["3d1ff0ea-679a-4190-8d46-7fa69e8c7e15"],
    "IMFDShowTransformWrapperConfig": ["334dad59-5bc3-4506-8f0b-e5f314295036"],
    "IMFDXGIBuffer": ["e7174cfa-1c9e-48b1-8866-626226bfc258"],
    "IMFDXGIBufferInternal": ["9405913d-ba9b-49b6-a644-e36fb231a3e5"],
    "IMFDXGIDeviceManager": ["eb533d5d-2db6-40f8-97a9-494692014f07"],
    "IMFDXGIDeviceManager2": ["63f95bf0-737a-444b-a1a6-333ba0d56bc2"],
    "IMFDXGIDeviceManager3": ["44e8e468-8c57-4126-a886-49c000a90b6f"],
    "IMFDXGIDeviceManagerSource": ["20bc074b-7a8d-4609-8c3b-64a0a3b5d7ce"],
    "IMFDXGIScheduledObjectIterator": ["07f5b7d3-b315-4fc2-a5f3-74d65250bc5e"],
    "IMFDXGIScheduler": ["df681668-70ec-457b-9aa3-caa60910a710"],
    "IMFDebugNetSource": ["e9cd0380-a268-4bb4-82de-658d53574d41"],
    "IMFDebugPMPSession": ["ed597033-a68b-4522-999f-44d4f9dea2f5"],
    "IMFDescriptorInterpreter": ["e6d7cd50-2a95-4698-89e4-0d6420704440"],
    "IMFDesiredSample": ["56c294d0-753e-4260-8d61-a3d8820b1d54"],
    "IMFDeviceControl": ["c2574938-0314-4ef5-81de-da3503afb832"],
    "IMFDeviceController": ["a1f58958-a5aa-412f-af20-1b7f1242dba0"],
    "IMFDeviceController2": ["2032c7ef-76f6-492a-94f3-4a81f69380cc"],
    "IMFDeviceController3": ["37ab888c-9d3e-46eb-9d5c-ac1ec00e2729"],
    "IMFDeviceMFTInternal": ["0c3502fb-f1b2-4155-b990-dd8a5fc34f93"],
    "IMFDeviceMFTInternal2": ["59cd78a0-0dbf-4815-9a9e-3430dce51feb"],
    "IMFDeviceMFTInternal3": ["76fcc99a-7a67-4192-9168-0022cfe4c7e1"],
    "IMFDeviceMFTInternal4": ["4022ffa6-aff9-4d42-84b5-a939f431d4f9"],
    "IMFDeviceMFTInternal5": ["b77cd8e4-43d2-4dea-acba-b76878aa41ef"],
    "IMFDeviceMFTInternal6": ["39d78038-24e3-412d-bd5a-58515412ee0f"],
    "IMFDevicePhotoStreamInternal": ["d9b9a781-6c81-4f40-aa29-fae2bdcc4615"],
    "IMFDevicePhotoStreamInternal2": ["92f6ec9b-c1db-4c01-b6f6-4984ee848f05"],
    "IMFDeviceSourceInternal": ["7f02a37e-4e81-11e0-8f3e-d057dfd72085"],
    "IMFDeviceSourceInternal2": ["c47d95d5-9685-4bf6-b6fb-772dc58d8e3b"],
    "IMFDeviceSourceStatus": ["43937dc1-0be6-4add-8a14-9ea68ff31252"],
    "IMFDeviceSourceStatus2": ["862be468-b94b-42a0-b2b0-2cf1d36969b3"],
    "IMFDeviceSourceStreamState": ["fbc717dc-3589-4cd7-af7d-23361e2e0fce"],
    "IMFDeviceStreamInternal": ["d4587da3-2380-4947-ac63-7ad5968a3953"],
    "IMFDeviceTransform": ["d818fbd8-fc46-42f2-87ac-1ea2d1f9bf32"],
    "IMFDeviceTransformCallback": ["6d5cb646-29ec-41fb-8179-8c4c6d750811"],
    "IMFDeviceTransformManager": ["70212999-c449-4b9d-b1a4-b358e1490121"],
    "IMFEMEMediaSource": ["a67cc551-6d6d-4351-9b57-ace41114d2c4"],
    "IMFExtendedCameraControl": ["38e33520-fca1-4845-a27a-68b7c6ab3789"],
    "IMFExtendedCameraController": ["b91ebfee-ca03-4af4-8a82-a31752f4a0fc"],
    "IMFExtendedCameraIntrinsicModel": ["5c595e64-4630-4231-855a-12842f733245"],
    "IMFExtendedCameraIntrinsics": ["687f6dac-6987-4750-a16a-734d1e7a10fe"],
    "IMFExtendedCameraIntrinsicsDistortionModel6KT": ["74c2653b-5f55-4eb1-9f0f-18b8f68b7d3d"],
    "IMFExtendedCameraIntrinsicsDistortionModelArcTan": ["812d5f95-b572-45dc-bafc-ae24199ddda8"],
    "IMFExtendedDRMTypeSupport": ["332ec562-3758-468d-a784-e38f23552128"],
    "IMFFieldOfUseMFTUnlock": ["508e71d3-ec66-4fc3-8775-b4b9ed6ba847"],
    "IMFFinalizableMediaSink": ["eaecb74a-9a50-42ce-9541-6a7f57aa4ad7"],
    "IMFFrameReader": ["b9f9f8c2-4f3a-4524-8c54-809e616cabd4"],
    "IMFFrameReader2": ["e07ab612-625d-4aef-8d7d-6ffdcd473603"],
    "IMFGetCaptureEngine": ["08a11708-b216-4b2a-9253-acf3c90c155d"],
    "IMFGetMultipleServiceProviders": ["6ca60d7e-e98d-4c2d-b25e-d4b7cf394185"],
    "IMFGetProtectionSystemIds": ["97e60041-b4d1-452e-9af3-88964bd0c15d"],
    "IMFGetService": ["fa993888-4383-415a-a930-dd472a8cf6f7"],
    "IMFHDCPManager": ["3ab81598-962b-4834-bfe5-4426ac1294c1"],
    "IMFHDCPSender": ["659c02d6-03fe-4f39-96ca-ef19ff7ae599"],
    "IMFHDCPStatus": ["de400f54-5bf1-40cf-8964-0bea136b1e3d"],
    "IMFHdcpDecrypt": ["2f389830-1f76-42e3-b0ae-eff133e7097b"],
    "IMFHdcpReceiverControl": ["62abe66a-48fb-4073-967f-3a73d1236d82"],
    "IMFHttpDownloadRequest": ["f779fddf-26e7-4270-8a8b-b983d1859de0"],
    "IMFHttpDownloadRequestOptions": ["397e26e9-6122-48a7-a73e-d6bb0a82666f"],
    "IMFHttpDownloadResponseOptions": ["a6fa17b4-be6c-4371-a451-d354bce14a57"],
    "IMFHttpDownloadSession": ["71fa9a2c-53ce-4662-a132-1a7e8cbf62db"],
    "IMFHttpDownloadSessionProvider": ["1b4cf4b9-3a16-4115-839d-03cc5c99df01"],
    "IMFImageFactory": ["d9daae21-f3cb-4ffa-aab5-a6c1015fec80"],
    "IMFImageFactoryInternal": ["b70259f1-7868-40ea-8002-57f0e09ec33d"],
    "IMFImageSharingEngine": ["cfa0ae8e-7e1c-44d2-ae68-fc4c148a6354"],
    "IMFImageSharingEngineClassFactory": ["1fc55727-a7fb-4fc8-83ae-8af024990af1"],
    "IMFInputTrustAuthority": ["d19f8e98-b126-4446-890c-5dcb7ad71453"],
    "IMFLPCMSinkActivate": ["9781e33c-d4af-4092-887c-34d58ba530f1"],
    "IMFLicenseManager": ["6e0bb04d-2f34-4004-857c-855c1f586934"],
    "IMFLicenseValidator": ["c68f77cc-c5c0-43d1-9eec-fab78b822a84"],
    "IMFLocalMFTRegistration": ["149c4d73-b4be-4f8d-8b87-079e926b6add"],
    "IMFLocalMFTRegistrationInternal": ["38b47b3a-d1dd-4f74-b61b-892398042a7b"],
    "IMFLock": ["97ec2ea3-0e42-4937-97ac-9d6d328824e1"],
    "IMFMP3ContentInfo": ["cc6c6949-c8ec-4def-911c-67098f786aa2"],
    "IMFMP4FragmentInfo": ["c394a8d6-454a-4b9c-8d8a-a5d3dbcfba38"],
    "IMFMP4InitSegmentGenerator": ["192837ee-294f-480a-97e0-6f6328ee8f7b"],
    "IMFMP4MediaSourcePluginFactory": ["17d8d95c-d765-4597-9372-9607dd8fcb7b"],
    "IMFMP4SegmentGeneratorFactory": ["cc88e5ee-92d3-4759-8af8-0e64a023a259"],
    "IMFMPEG2SinkActivate": ["30982126-392d-44a0-b426-cc250f4beda4"],
    "IMFMediaBuffer": ["045fa593-8799-42b8-bc8d-8968c6453507"],
    "IMFMediaBufferInternal": ["17648318-a670-4651-8129-768ac1f99041"],
    "IMFMediaBufferMultiSample": ["045fa594-8799-42b8-bc8d-8968c6453507"],
    "IMFMediaBufferWrapper": ["a0c691f0-6d1d-4138-887f-b2d3ecaf0a3d"],
    "IMFMediaEngine": ["98a1b0bb-03eb-4935-ae7c-93c1fa0e1c93"],
    "IMFMediaEngineAudioEndpointId": ["7a3bac98-0e76-49fb-8c20-8a86fd98eaf2"],
    "IMFMediaEngineClassFactory": ["4d645ace-26aa-4688-9be1-df3516990b93"],
    "IMFMediaEngineClassFactory2": ["09083cef-867f-4bf6-8776-dee3a7b42fca"],
    "IMFMediaEngineClassFactory3": ["3787614f-65f7-4003-b673-ead8293a0e60"],
    "IMFMediaEngineClassFactory4": ["fbe256c1-43cf-4a9b-8cb8-ce8632a34186"],
    "IMFMediaEngineClassFactoryEx": ["c56156c6-ea5b-48a5-9df8-fbe035d0929e"],
    "IMFMediaEngineClassFactoryInternal": ["d21b5617-2e6f-4987-baef-b5576626c970"],
    "IMFMediaEngineEME": ["50dc93e4-ba4f-4275-ae66-83e836e57469"],
    "IMFMediaEngineEMENotify": ["9e184d15-cdb7-4f86-b49e-566689f4a601"],
    "IMFMediaEngineEx": ["83015ead-b1e6-40d0-a98a-37145ffe1ad1"],
    "IMFMediaEngineExtension": ["2f69d622-20b5-41e9-afdf-89ced1dda04e"],
    "IMFMediaEngineInternal": ["703dc3bf-e96d-4881-8ef3-aed201c8898b"],
    "IMFMediaEngineMediaBreakCallback": ["d7126fef-79d7-4394-90c1-baf8b90626ea"],
    "IMFMediaEngineMediaBreakSupport": ["22407c47-3820-44dc-87c7-59a1b26d5293"],
    "IMFMediaEngineNeedKeyNotify": ["46a30204-a696-4b18-8804-246b8f031bb1"],
    "IMFMediaEngineNotify": ["fee7c112-e776-42b5-9bbf-0048524e2bd5"],
    "IMFMediaEngineNotifyArgs": ["1ade2303-ff47-481c-9916-410ead13e427"],
    "IMFMediaEngineOPMInfo": ["765763e6-6c01-4b01-bb0f-b829f60ed28c"],
    "IMFMediaEnginePlaylistSupport": ["3423a1a9-47db-4a61-91ea-d7b88d56cb92"],
    "IMFMediaEngineProtectedContent": ["9f8021e8-9c8c-487e-bb5c-79aa4779938c"],
    "IMFMediaEngineSourceResolver": ["695323e8-cf7c-4a81-8c51-9ce818d90518"],
    "IMFMediaEngineSphericalVideoSupport": ["e50f5c6b-29aa-4794-b4af-f779a86900f5"],
    "IMFMediaEngineSrcElements": ["7a5e5354-b114-4c72-b991-3131d75032ea"],
    "IMFMediaEngineSrcElementsEx": ["654a6bb3-e1a3-424a-9908-53a43a0dfda0"],
    "IMFMediaEngineSupportsSourceTransfer": ["a724b056-1b2e-4642-a6f3-db9420c52908"],
    "IMFMediaEngineTest": ["1f985a61-bc76-488c-87ba-e9b54b67b2dd"],
    "IMFMediaEngineTimelineControllerSupport": ["d36d82ca-5183-49e7-87b5-e20d6ed4ab62"],
    "IMFMediaEngineTransferSource": ["24230452-fe54-40cc-94f3-fcc394c340d6"],
    "IMFMediaEngineWebSupport": ["ba2743a1-07e0-48ef-84b6-9a2ed023ca6c"],
    "IMFMediaError": ["fc0e10d2-ab2a-4501-a951-06bb1075184c"],
    "IMFMediaEvent": ["df598932-f10c-4e39-bba2-c308f101daa3"],
    "IMFMediaEventGenerator": ["2cd0bd52-bcd5-4b89-b62c-eadc0c031e7d"],
    "IMFMediaEventQueue": ["36f846fc-2256-48b6-b58e-e2b638316581"],
    "IMFMediaKeySession": ["24fa67d5-d1d0-4dc5-995c-c0efdc191fb5"],
    "IMFMediaKeySession2": ["e9707e05-6d55-4636-b185-3de21210bd75"],
    "IMFMediaKeySessionNotify": ["6a0083f9-8947-4c1d-9ce0-cdee22b23135"],
    "IMFMediaKeySessionNotify2": ["c3a9e92a-da88-46b0-a110-6cf953026cb9"],
    "IMFMediaKeySystemAccess": ["aec63fda-7a97-4944-b35c-6c6df8085cc3"],
    "IMFMediaKeys": ["5cb31c05-61ff-418f-afda-caaf41421a38"],
    "IMFMediaKeys2": ["45892507-ad66-4de2-83a2-acbb13cd8d43"],
    "IMFMediaKeysPrivate": ["25991c64-f64e-4be8-93b7-1f13fbbceb3f"],
    "IMFMediaPlaylistInternal": ["b194e5a3-eac1-4caf-b33f-f4e9fd8d3c54"],
    "IMFMediaProcessor": ["7bc6644e-2146-4122-833c-27d74d37121f"],
    "IMFMediaProcessorEx": ["fe3de6ec-1e5d-4741-9c4d-2a348a43f9fc"],
    "IMFMediaProcessorStream": ["7bc6644f-2146-4122-833c-27d74d37121f"],
    "IMFMediaSegmentIndex": ["6b2370bb-72df-41c7-b680-6fd4ebd9e5eb"],
    "IMFMediaSegmentIndexParser": ["f1d4744a-bf9d-4e1d-8731-9c0d5a040363"],
    "IMFMediaSession": ["90377834-21d0-4dee-8214-ba2e3e6c1127"],
    "IMFMediaSessionFactory": ["09c6d01f-94bd-4551-83cb-1002d012c139"],
    "IMFMediaSharingEngine": ["8d3ce1bf-2367-40e0-9eee-40d377cc1b46"],
    "IMFMediaSharingEngineClassFactory": ["524d2bc4-b2b1-4fe5-8fac-fa4e4512b4e0"],
    "IMFMediaSharingEngineInternal": ["7efe543f-150a-4ffc-9d7e-e4c9549d82df"],
    "IMFMediaSink": ["6ef2a660-47c0-4666-b13d-cbb717f2fa2c"],
    "IMFMediaSinkPreroll": ["5dfd4b2a-7674-4110-a4e6-8a68fd5f3688"],
    "IMFMediaSource": ["279a808d-aec7-40c8-9c6b-a6b492c78a66"],
    "IMFMediaSource2": ["fbb03414-d13b-4786-8319-5ac51fc0a136"],
    "IMFMediaSourceActivate": ["f00374d1-c2f9-4a3f-913e-13c0984deec5"],
    "IMFMediaSourceEx": ["3c9b2eb9-86d5-4514-a394-f56664f9f0d8"],
    "IMFMediaSourceExtension": ["e467b94e-a713-4562-a802-816a42e9008a"],
    "IMFMediaSourceExtensionLiveSeekableRange": ["5d1abfd6-450a-4d92-9efc-d6b6cbc1f4da"],
    "IMFMediaSourceExtensionNotify": ["a7901327-05dd-4469-a7b7-0e01979e361d"],
    "IMFMediaSourcePresentationProvider": ["0e1d600a-c9f3-442d-8c51-a42d2d49452f"],
    "IMFMediaSourceTopologyProvider": ["0e1d6009-c9f3-442d-8c51-a42d2d49452f"],
    "IMFMediaStream": ["d182108f-4ec6-443f-aa42-a71106ec825f"],
    "IMFMediaStream2": ["c5bc37d6-75c7-46a1-a132-81b5f723c20f"],
    "IMFMediaStreamSourceSampleRequest": ["380b9af9-a85b-4e78-a2af-ea5ce645c6b4"],
    "IMFMediaTimeRange": ["db71a2fc-078a-414e-9df9-8c2531b0aa6c"],
    "IMFMediaTimelineControllerInternal": ["d5481ef2-b4b9-47b3-bf5d-8dc1d0740a3d"],
    "IMFMediaType": ["44ae0fa8-ea31-4109-8d2e-4cae4997c555"],
    "IMFMediaTypeChangeRemoting": ["e68b7f1b-751a-45a9-b767-c664c65f2a21"],
    "IMFMediaTypeHandler": ["e93dcf6c-4b07-4e1e-8123-aa16ed6eadf5"],
    "IMFMetadata": ["f88cfb8c-ef16-4991-b450-cb8c69e51704"],
    "IMFMetadataProvider": ["56181d2d-e221-4adb-b1c8-3cee6a53f76f"],
    "IMFMiracastConnectionCallback": ["891616ab-29d9-4475-8699-995c640d1454"],
    "IMFMiracastConnectionRegistrar": ["d91061d2-ee59-43f7-b44e-c6d15a04b794"],
    "IMFMiracastControlCallback": ["e54fb38b-37c7-4a63-a6ac-c12a154e5dd9"],
    "IMFMiracastStatsCallback": ["aa878e6c-46a2-4ae2-9282-f24ad9d7e1fc"],
    "IMFMultiReaderWriterLock": ["c413c0b4-2b66-4a47-b6cb-ad49b0c1e4a9"],
    "IMFMuxActivate": ["cf118367-09ae-45fb-af4d-be4a2b2e0e77"],
    "IMFMuxStreamAttributesManager": ["ce8bd576-e440-43b3-be34-1e53f565f7e8"],
    "IMFMuxStreamMediaTypeManager": ["505a2c72-42f7-4690-aeab-8f513d0ffdb8"],
    "IMFMuxStreamSampleManager": ["74abbc19-b1cc-4e41-bb8b-9d9b86a8f6ca"],
    "IMFNackHandler": ["e7f6a364-168c-4965-862c-b190a1c7c5f0"],
    "IMFNetBufferControl": ["d99849fc-41d3-4bbf-aacd-ffb94ec48c2b"],
    "IMFNetCardeaLicenseRequestEvent": ["674eff6a-5144-487a-a01d-013fc23d0353"],
    "IMFNetChangeProfileEvent": ["f181ed81-0b84-413c-8daf-290142d1a168"],
    "IMFNetChannel": ["a990f0fa-60bb-454b-a3bc-b4fb11054697"],
    "IMFNetChannelActivate": ["8780ed4c-a3d9-4ada-9489-023ddb3bd1d6"],
    "IMFNetChannelBandwidthEstimation": ["9cc607ab-64fc-44ed-bec7-cee7eb700cab"],
    "IMFNetChannelRIO": ["91b7b3e3-6286-4871-9a29-47d122cb5cbf"],
    "IMFNetCloseEvent": ["19006102-92b7-4263-953c-b84c24bedcce"],
    "IMFNetCredential": ["5b87ef6a-7ed8-434f-ba0e-184fac1628d1"],
    "IMFNetCredentialCache": ["5b87ef6c-7ed8-434f-ba0e-184fac1628d1"],
    "IMFNetCredentialManager": ["5b87ef6b-7ed8-434f-ba0e-184fac1628d1"],
    "IMFNetCrossOriginSupport": ["bc2b7d44-a72d-49d5-8376-1480dee58b22"],
    "IMFNetDescribeEvent": ["8e2f2316-0036-4f47-b6fd-b86c67ec1ab3"],
    "IMFNetDownloadEvent": ["f983790b-e48d-4eda-ab16-9df3681ce27e"],
    "IMFNetEosEvent": ["7c1411a3-4133-4d4e-bf38-276dbf9bb48a"],
    "IMFNetEvent": ["8e2f2315-0036-4f47-b6fd-b86c67ec1ab3"],
    "IMFNetEventHandler": ["6e2b250a-f1a7-46be-b2d1-38a762a2bff7"],
    "IMFNetHeaderCollection": ["8e2f2314-0036-4f47-b6fd-b86c67ec1ab3"],
    "IMFNetListener": ["1752bc20-967f-443a-8731-981b923e2bfd"],
    "IMFNetLogEvent": ["0d5ebc6b-6a6c-4f5c-8507-22c5eb1aead7"],
    "IMFNetPlayEvent": ["bbc20c5b-c228-4ab3-b188-e5d00d31475b"],
    "IMFNetPresentationTarget": ["c0b35174-11ff-43c9-9360-6dcf46db4404"],
    "IMFNetProfilesEvent": ["8420d5e8-eb2a-4323-afd7-f8ae2a62ead0"],
    "IMFNetProxyLocator": ["e9cd0383-a268-4bb4-82de-658d53574d41"],
    "IMFNetProxyLocatorFactory": ["e9cd0384-a268-4bb4-82de-658d53574d41"],
    "IMFNetRawEvent": ["efda1ed6-dc24-48c1-b7c5-f1e45ca5a14b"],
    "IMFNetResourceFilter": ["091878a3-bf11-4a5c-bc9f-33995b06ef2d"],
    "IMFNetSchemeHandlerConfig": ["7be19e73-c9bf-468a-ac5a-a5e8653bec87"],
    "IMFNetSelectStreamsEvent": ["117509a5-4509-40c9-ad4c-f47f18a78f77"],
    "IMFNetSession": ["fe5a22ac-a78c-441f-a5ce-24d31f0d45b4"],
    "IMFNetSessionFactory": ["19be6242-215d-4916-b2ae-3c86a9117348"],
    "IMFNetSessionHandler": ["2196c5fd-0f8c-4c90-b92a-c4029130650c"],
    "IMFNetSetHDCPContextEvent": ["6bb9f6b3-df61-4fff-8fb0-631f35443a9e"],
    "IMFNetSinkConfig": ["9e18a897-0fb9-44bd-b41d-d391a7fb31be"],
    "IMFNetSinkControlConnection": ["20a32133-518c-422a-a95a-691f9772c3ae"],
    "IMFNetUrlTransformEvent": ["b0a495af-a4a3-4b28-b15b-c98dc2f4b092"],
    "IMFNetVRoot": ["9c4c3fcd-a6f3-4b43-8eec-c7ea60c54887"],
    "IMFNetworkCongestionControl": ["d0db51ba-d166-4ee8-b68f-0083304c88d6"],
    "IMFObjectInformation": ["ce6be8e7-d757-435f-9de9-be3ef330b805"],
    "IMFObjectReferenceStream": ["09ef5be3-c8a7-469e-8b70-73bf25bb193f"],
    "IMFOutputPolicy": ["7f00f10a-daed-41af-ab26-5fdfa4dfba3c"],
    "IMFOutputSchema": ["7be0fc5b-abd9-44fb-a5c8-f50136e71599"],
    "IMFOutputTrustAuthority": ["d19f8e94-b126-4446-890c-5dcb7ad71453"],
    "IMFPMPClient": ["6c4e655d-ead8-4421-b6b9-54dcdbbdf820"],
    "IMFPMPClientApp": ["c004f646-be2c-48f3-93a2-a0983eba1108"],
    "IMFPMPHost": ["f70ca1a9-fdc7-4782-b994-adffb1c98606"],
    "IMFPMPHostApp": ["84d2054a-3aa1-4728-a3b0-440a418cf49c"],
    "IMFPMPHostInternal": ["f2b256ec-b3c7-4c9a-b20c-af31bdc375fd"],
    "IMFPMPServer": ["994e23af-1cc2-493c-b9fa-46f1cb040fa4"],
    "IMFPMPServerInternal": ["772ff18d-138b-4257-873c-1b8e0ce1d183"],
    "IMFPMPServerLock": ["994e23b0-1cc2-493c-b9fa-46f1cb040fa4"],
    "IMFPMediaItem": ["90eb3e6b-ecbf-45cc-b1da-c6fe3ea70d57"],
    "IMFPMediaPlayer": ["a714590a-58af-430a-85bf-44f5ec838d85"],
    "IMFPMediaPlayerCallback": ["766c8ffb-5fdb-4fea-a28d-b912996f51bd"],
    "IMFPersistStreamMap": ["5aac5312-a48a-4688-a7a0-b78c43fef031"],
    "IMFPluginControl": ["5c6c44bf-1db6-435b-9249-e8cd10fdec96"],
    "IMFPluginControl2": ["c6982083-3ddc-45cb-af5e-0f7a8ce4de77"],
    "IMFPluginControlInternal": ["e4d88afb-01b8-4965-985f-36122c3fc6fb"],
    "IMFPluginControlTestHook": ["68ff4224-8650-4cbc-8d9e-8cc724000100"],
    "IMFPresentationClock": ["868ce85c-8ea9-4f55-ab82-b009a910a805"],
    "IMFPresentationClockAggregate": ["90ebee9a-6a1e-405d-9a9a-3753ba6d247c"],
    "IMFPresentationClockAggregateClient": ["3bbf4b1c-f423-42eb-9d95-94676ea9e221"],
    "IMFPresentationClockAggregateClientNotify": ["f993f031-75e0-4eac-913a-479bee16e22b"],
    "IMFPresentationDescriptor": ["03cb2711-24d7-4db6-a17f-f3a7a479a536"],
    "IMFPresentationTimeSource": ["7ff12cce-f76f-41c2-863b-1666c8e5e139"],
    "IMFPropertyTranslator": ["d185ef97-da72-4d73-94ec-397645950444"],
    "IMFProtectedEnvironmentAccess": ["ef5dc845-f0d9-4ec9-b00c-cb5183d38434"],
    "IMFProtectedInputCreator": ["f79948fc-9e1f-447d-93b7-c580db2ddd8d"],
    "IMFProtectionSystemHeader": ["f466234a-428e-4cc2-8a15-cca350b914f7"],
    "IMFProtectionSystemHeaderCollection": ["54a8ee28-7a53-4b52-9aa4-ceccd6080023"],
    "IMFPsiFilterConfig": ["f6ea8518-63e9-4f2e-82bf-90057fc680d6"],
    "IMFQualityAdvise": ["ec15e2e9-e36b-4f7c-8758-77d452ef4ce7"],
    "IMFQualityAdvise2": ["f3706f0d-8ea2-4886-8000-7155e9ec2eae"],
    "IMFQualityAdviseInternal": ["3041c46c-9a45-47c7-9e23-9c9e1e4d4d50"],
    "IMFQualityAdviseLimits": ["dfcd8e4d-30b5-4567-acaa-8eb5b7853dc9"],
    "IMFQualityManager": ["8d009d86-5b9f-4115-b1fc-9f80d52ab8ab"],
    "IMFRateControl": ["88ddcd21-03c3-4275-91ed-55ee3929328f"],
    "IMFRateSupport": ["0a9ccdbc-d797-4563-9667-94ec5d79292d"],
    "IMFRatelessTimeSource": ["ab8dbcbe-2eb8-4080-a6d0-cfa3b846efd4"],
    "IMFReadWriteClassFactory": ["e7fe2e12-661c-40da-92f9-4f002ab67627"],
    "IMFRealTimeClient": ["2347d60b-3fb5-480c-8803-8df3adcd3ef0"],
    "IMFRealTimeClientEx": ["03910848-ab16-4611-b100-17b88ae2f248"],
    "IMFRelativePanelReport": ["f25362ea-2c0e-447f-81e2-755914cdc0c3"],
    "IMFRelativePanelWatcher": ["421af7f6-573e-4ad0-8fda-2e57cedb18c6"],
    "IMFRemoteAsyncCallback": ["a27003d0-2354-4f2a-8d6a-ab7cff15437e"],
    "IMFRemoteDesktopPlugin": ["1cde6309-cae0-4940-907e-c1ec9c3d1d4a"],
    "IMFRemoteProxy": ["994e23ad-1cc2-493c-b9fa-46f1cb040fa4"],
    "IMFRequestHandler": ["2196c5fd-0f8c-4c90-b92a-c4029130650c"],
    "IMFRrHandler": ["a9014b8b-0ed4-4a19-a06f-5d42c751d42d"],
    "IMFRtspSinkActivate": ["032b3adc-569b-48aa-ae08-62bcc3c5266b"],
    "IMFSAMIStyle": ["a7e025dd-5303-4a62-89d6-e747e1efac73"],
    "IMFSSLCertificateManager": ["61f7d887-1230-4a8b-aeba-8ad434d1a64d"],
    "IMFSample": ["c40a00f2-b93a-4d80-ae8c-5a1c634f58e4"],
    "IMFSampleAllocatorControl": ["da62b958-3a38-4a97-bd27-149c640c0771"],
    "IMFSampleGrabberSinkCallback": ["8c7b80bf-ee42-4b59-b1df-55668e1bdca8"],
    "IMFSampleGrabberSinkCallback2": ["ca86aa50-c46e-429e-ab27-16d6ac6844cb"],
    "IMFSampleGrabberSinkCallback3": ["28c92d4e-ff6c-4c0b-8c31-7b64a96d65fd"],
    "IMFSampleGrabberSinkCallback4": ["dd6c883b-d4d5-4496-9951-b50a0de24f87"],
    "IMFSampleGrabberSinkInternal": ["647aab17-3579-43a0-a188-45658b223a41"],
    "IMFSampleOutputStream": ["8feed468-6f7e-440d-869a-49bdd283ad0d"],
    "IMFSampleProtection": ["8e36395f-c7b9-43c4-a54d-512b4af63c95"],
    "IMFSaveJob": ["e9931663-80bf-4c6e-98af-5dcf58747d1f"],
    "IMFSchemeHandler": ["6d4c7b74-52a0-4bb7-b0db-55f29f47a668"],
    "IMFSdpTemplate": ["03271c24-dc86-4b41-8c47-76f9c2bf347c"],
    "IMFSeamlessAudioEffect": ["b92ae852-b308-41be-99ee-689a7bed9179"],
    "IMFSecureBuffer": ["c1209904-e584-4752-a2d6-7f21693f8b21"],
    "IMFSecureBufferAllocator": ["2975243e-23eb-419f-8385-84b1f597b0ea"],
    "IMFSecureChannel": ["d0ae555d-3b12-4d97-b060-0990bc5aeb67"],
    "IMFSeekInfo": ["26afea53-d9ed-42b5-ab80-e64f9ee34779"],
    "IMFSendRateHandler": ["6b947dfb-13ff-4a9b-83ef-2f3b49b13513"],
    "IMFSensorActivitiesReport": ["683f7a5e-4a19-43cd-b1a9-dbf4ab3f7777"],
    "IMFSensorActivitiesReportCallback": ["de5072ee-dbe3-46dc-8a87-b6f631194751"],
    "IMFSensorActivitiesReportCallbackInternal": ["40386096-6aa4-4bc6-a705-ad34eeb756a6"],
    "IMFSensorActivitiesReportInternal": ["e7481594-cf55-4101-979d-5bb7c9ad1c3b"],
    "IMFSensorActivityMonitor": ["d0cef145-b3f4-4340-a2e5-7a5080ca05cb"],
    "IMFSensorActivityMonitorInternal": ["ffae9683-35df-488b-aada-3418a53d8bcb"],
    "IMFSensorActivityReport": ["3e8c4be1-a8c2-4528-90de-2851bde5fead"],
    "IMFSensorActivityReportInternal": ["edc45026-2f8c-47b1-b22e-b0d00d8089b5"],
    "IMFSensorDevice": ["fb9f48f2-2a18-4e28-9730-786f30f04dc4"],
    "IMFSensorDeviceIdInternal": ["f2db1e0c-e35f-4819-9efe-b6f9e10ad74a"],
    "IMFSensorDeviceInternal": ["9a928955-c75a-4c2a-b41a-aa48c5834b1c"],
    "IMFSensorGroup": ["4110243a-9757-461f-89f1-f22345bcab4e"],
    "IMFSensorGroupCollection": ["560a0c60-5e50-4429-8c59-c7de0812096c"],
    "IMFSensorGroupId": ["006e0e79-a511-436e-83be-fce6990f258d"],
    "IMFSensorGroupIdInternal": ["1725de0f-cf7a-4075-9365-d8c5d1eea8d7"],
    "IMFSensorGroupIdManager": ["95b1b946-4630-42f8-8bb6-f347b1c5bfe7"],
    "IMFSensorGroupInternal": ["8e3196f0-ce22-4599-a16a-886bb13a7966"],
    "IMFSensorGroupPlugin": ["29fa81ab-e0f7-4abc-b00f-fb2e520b4595"],
    "IMFSensorProcessActivity": ["39dc7f4a-b141-4719-813c-a7f46162a2b8"],
    "IMFSensorProfile": ["22f765d1-8dab-4107-846d-56baf72215e7"],
    "IMFSensorProfileCollection": ["c95ea55b-0187-48be-9353-8d2507662351"],
    "IMFSensorProfileValidationCallback": ["55fb476f-cd01-4763-97b7-174ecdd7cc5a"],
    "IMFSensorStream": ["e9a42171-c56e-498a-8b39-eda5a070b7fc"],
    "IMFSensorStreamInternal": ["30acfa70-af94-4ad4-be36-14e23900c104"],
    "IMFSensorStreamInternal2": ["cfa380d0-f3e1-43ca-a35a-3c7b19d27304"],
    "IMFSensorTransformFactory": ["eed9c2ee-66b4-4f18-a697-ac7d3960215c"],
    "IMFSequencerRemoteStreamCallback": ["994e23ae-19cb-4de1-a64c-acf2edcbe59e"],
    "IMFSequencerSource": ["197cd219-19cb-4de1-a64c-acf2edcbe59e"],
    "IMFSetServiceProvider": ["54fc6d3d-5f42-47db-86c0-4e062d2685e2"],
    "IMFShared2DBuffer": ["a9e12d87-98fa-4e1f-9039-d1767191ad4b"],
    "IMFSharedBufferInternal": ["49c1c9a1-aa28-4209-95fe-c83df82d791e"],
    "IMFSharedMediaBuffer": ["41b8567f-c042-477a-ac5a-e964dc526f4c"],
    "IMFSharingEngineClassFactory": ["2ba61f92-8305-413b-9733-faf15f259384"],
    "IMFShutdown": ["97ec2ea4-0e42-4937-97ac-9d6d328824e1"],
    "IMFSignedLibrary": ["4a724bca-ff6a-4c07-8e0d-7a358421cf06"],
    "IMFSimpleAudioVolume": ["089edf13-cf71-4338-8d13-9e569dbdc319"],
    "IMFSinkClassFactory": ["37aa1c3b-620f-477e-bef9-ac4aa85be95d"],
    "IMFSinkWriter": ["3137f1cd-fe5e-4805-a5d8-fb477448cb3d"],
    "IMFSinkWriterCallback": ["666f76de-33d2-41b9-a458-29ed0a972c58"],
    "IMFSinkWriterCallback2": ["2456bd58-c067-4513-84fe-8d0c88ffdc61"],
    "IMFSinkWriterEncoderConfig": ["17c3779e-3cde-4ede-8c60-3899f5f53ad6"],
    "IMFSinkWriterEx": ["588d72ab-5bc1-496a-8714-b70617141b25"],
    "IMFSource": ["00f5e896-8813-44e3-8789-7e520e0de873"],
    "IMFSourceBuffer": ["e2cd3a4b-af25-4d3d-9110-da0e6f8ee877"],
    "IMFSourceBufferAppendMode": ["19666fb4-babe-4c55-bc03-0a074da37e2a"],
    "IMFSourceBufferList": ["249981f8-8325-41f3-b80c-3b9e3aad0cbe"],
    "IMFSourceBufferNotify": ["87e47623-2ceb-45d6-9b88-d8520c4dcbbc"],
    "IMFSourceDataParserPlugin": ["d7914b2f-a9c9-4b19-b840-dd3b6d0440d4"],
    "IMFSourceExtendedAttributesPlugin": ["f6176336-b5f0-4775-b948-0ad96eb1626f"],
    "IMFSourceFilterConfig": ["7bb552d6-cbd8-42cc-bc1a-7b87a0a3a969"],
    "IMFSourceHeaderParserPlugin": ["030c27d4-7ab9-462a-ade2-eac788549db7"],
    "IMFSourceHeaderParserPlugin2": ["2e1777ad-e9cc-444c-9fd8-90078502ffe9"],
    "IMFSourceIndexParserPlugin": ["3133e934-0981-40cd-9ce8-461bc0e414f0"],
    "IMFSourceOpenMonitor": ["059054b3-027c-494c-a27d-9113291cf87f"],
    "IMFSourceParserControl": ["350ad0d2-d168-4b24-b19d-068c1c4a102e"],
    "IMFSourcePropertyPlugin": ["294ac6b2-4eec-4d5f-a965-046c4e75abe6"],
    "IMFSourceProtectedContentPlugin": ["7b54e044-748b-4900-a63b-8a0ddd50c767"],
    "IMFSourceReader": ["70ae66f2-c809-4e4f-8915-bdcb406b7993"],
    "IMFSourceReaderCallback": ["deec8d99-fa1d-4d82-84c2-2c8969944867"],
    "IMFSourceReaderCallback2": ["cf839fe6-8c2a-4dd2-b6ea-c22d6961af05"],
    "IMFSourceReaderEx": ["7b981cf0-560e-4116-9875-b099895f23d7"],
    "IMFSourceReaderInternal": ["b7dd0143-6276-4459-bc4c-ad9acc9bf815"],
    "IMFSourceResolver": ["fbe5a32d-a497-4b61-bb85-97b1a848a6e3"],
    "IMFSpatialAudioObjectBuffer": ["d396ec8c-605e-4249-978d-72ad1c312872"],
    "IMFSpatialAudioSample": ["abf28a9b-3393-4290-ba79-5ffc46d986b2"],
    "IMFStallableTimeSource": ["3215d3aa-d9bd-4c96-8119-ed089594af2a"],
    "IMFStatistics": ["294eb3fb-94dd-42c2-a12e-374bbf1098f8"],
    "IMFStatisticsCollection": ["294eb3fc-94dd-42c2-a12e-374bbf1098f8"],
    "IMFStatisticsSite": ["294eb3fd-94dd-42c2-a12e-374bbf1098f8"],
    "IMFStreamDescriptor": ["56c03d9c-9dbb-45f5-ab4b-d80f47c05938"],
    "IMFStreamSampleInternal": ["b8db6a81-0228-47de-a17f-7d3c85217efd"],
    "IMFStreamSignalHandler": ["875d3d43-5fee-4f37-b3d8-23454e99a4d2"],
    "IMFStreamSink": ["0a97b3cf-8e7c-4a3d-8f8c-0c843dc247fb"],
    "IMFStreamingSinkConfig": ["9db7aa41-3cc5-40d4-8509-555804ad34cc"],
    "IMFStreamingSinkConfig2": ["fde164d1-1655-4f6e-9ec0-132d31e16e9a"],
    "IMFSystemId": ["fff4af3a-1fc1-4ef9-a29b-d26c49e2f31a"],
    "IMFTMuxSinkClassFactory": ["f49ce537-7fd6-420a-bea5-f286c390d255"],
    "IMFTelemetryComponent": ["0b5e1c7e-bd76-46bc-896c-b2edb40dd803"],
    "IMFTelemetrySession": ["627d2ca6-e1cd-4898-999d-101308f1d431"],
    "IMFTimecodeTranslate": ["ab9d8661-f7e8-4ef4-9861-89f334f94e74"],
    "IMFTimedText": ["1f2a94c9-a3df-430d-9d0f-acd85ddc29af"],
    "IMFTimedTextBinary": ["4ae3a412-0545-43c4-bf6f-6b97a5c6c432"],
    "IMFTimedTextClassFactory": ["02768674-7409-43af-bf7b-af276fda04d2"],
    "IMFTimedTextCue": ["1e560447-9a2b-43e1-a94c-b0aaabfbfbc9"],
    "IMFTimedTextCueBuilder": ["fc7b1bb6-c22e-4b46-8585-ef1429acc18e"],
    "IMFTimedTextCueInternal": ["2c118a1b-9cf4-4181-bcb6-4a986711e88a"],
    "IMFTimedTextCueList": ["ad128745-211b-40a0-9981-fe65f166d0fd"],
    "IMFTimedTextDataSource": ["5a0d8439-09d0-40f3-8dc3-d8b695bb1ecc"],
    "IMFTimedTextDataSourceHost": ["2de804cc-9128-4653-93b2-a511d1fd22e8"],
    "IMFTimedTextDataSourceHostServices": ["6704bce6-20b1-4ca4-8afc-63d3cd6dbd7b"],
    "IMFTimedTextFormattedText": ["e13af3c1-4d47-4354-b1f5-e83ae0ecae60"],
    "IMFTimedTextNotify": ["df6b87b6-ce12-45db-aba7-432fe054e57d"],
    "IMFTimedTextRegion": ["c8d22afc-bc47-4bdf-9b04-787e49ce3f58"],
    "IMFTimedTextRenderer": ["96535dc0-a5d7-4bb6-817d-c052242258ca"],
    "IMFTimedTextStyle": ["09b2455d-b834-4f01-a347-9052e21c450e"],
    "IMFTimedTextTrack": ["8822c32d-654e-4233-bf21-d7f2e67d30d4"],
    "IMFTimedTextTrackInternal": ["a7ddf8ee-a8d9-447a-9e48-791052d93495"],
    "IMFTimedTextTrackList": ["23ff334c-442c-445f-bccc-edc438aa11e2"],
    "IMFTimer": ["e56e4cbd-8f70-49d8-a0f8-edb3d6ab9bf2"],
    "IMFTopoConnector": ["de9a6158-f660-4643-b56a-df9f7998c7cd"],
    "IMFTopoLoader": ["de9a6157-f660-4643-b56a-df9f7998c7cd"],
    "IMFTopology": ["83cf873a-f6da-4bc8-823f-bacfd55dc433"],
    "IMFTopologyNode": ["83cf873a-f6da-4bc8-823f-bacfd55dc430"],
    "IMFTopologyNodeAttributeEditor": ["676aa6dd-238a-410d-bb99-65668d01605a"],
    "IMFTopologyPriv": ["47bae55e-80da-4046-a454-90520b5bc9a4"],
    "IMFTopologyServiceLookup": ["fa993889-4383-415a-a930-dd472a8cf6f7"],
    "IMFTopologyServiceLookupClient": ["fa99388a-4383-415a-a930-dd472a8cf6f7"],
    "IMFTrackedSample": ["245bf8e9-0755-40f7-88a5-ae0f18d55e17"],
    "IMFTrackedSampleInternal": ["6dc5a5a6-e640-4328-9c05-41a2c952d409"],
    "IMFTranscodeEngine": ["e9150228-6355-477f-88b5-a3098c1eaabb"],
    "IMFTranscodeProfile": ["4adfdba3-7ab0-4953-a62b-461e7ff3da1e"],
    "IMFTranscodeSinkInfoProvider": ["8cffcd2e-5a03-4a3a-aff7-edcd107c620e"],
    "IMFTransform": ["bf94c121-5b05-4e6f-8000-ba598961414d"],
    "IMFTransformFieldOfUse": ["6f2b8556-0dbc-41a9-8c10-e7fcaec4dbbe"],
    "IMFTransformProxy": ["654322dd-57f1-4660-b035-645775434005"],
    "IMFTransformRemote": ["212ff881-ffc0-48db-b083-057a109386d8"],
    "IMFTransformRemotePrivate": ["f42cf93e-51a9-4877-85bd-7ee81e39ae83"],
    "IMFTransformViaAppService": ["13bc074b-1b97-4059-ac54-5c710fc846cc"],
    "IMFTransformWrapper": ["506d9f5c-78ea-4055-8274-3073fb140f3f"],
    "IMFTrustedInput": ["542612c4-a1b8-4632-b521-de11ea64a0b0"],
    "IMFTrustedOutput": ["d19f8e95-b126-4446-890c-5dcb7ad71453"],
    "IMFVideoCaptureSampleAllocator": ["725b77c7-ca9f-4fe5-9d72-9946bf9b3c70"],
    "IMFVideoCaptureStatistics": ["0a678416-2c5b-4848-864e-05a698702f5c"],
    "IMFVideoDeviceAsyncExtendedControl": ["5011768d-9445-43f6-b94e-5f16bba99da4"],
    "IMFVideoDeviceBasicControl": ["2cc6bca7-f195-404d-b466-754947710729"],
    "IMFVideoDeviceExtendedControl": ["6b2fe609-cad1-46ec-b2b3-e3ac744a4a52"],
    "IMFVideoDeviceExtendedControlTraceCallback": ["ccc3b1e1-f3de-4dcc-80a7-604b5fe914de"],
    "IMFVideoDeviceFrameSettingControl": ["0a26cfcb-c784-4a14-8b9a-d6e990e5f476"],
    "IMFVideoDeviceID": ["a38d9567-5a9c-4f3c-b293-8eb415b279ba"],
    "IMFVideoDeviceVidCapControl": ["ea4a25c4-e4d5-4f9a-8ba7-80f41bdfd345"],
    "IMFVideoDisplayControl": ["a490b1e4-ab84-4d31-a1b2-181e03b1077a"],
    "IMFVideoMediaType": ["b99f381f-a8f9-47a2-a5af-ca3a225a3890"],
    "IMFVideoMixerBitmap": ["814c7b20-0fdb-4eec-af8f-f957c8f69edc"],
    "IMFVideoMixerControl": ["a5c6c53f-c202-4aa5-9695-175ba8c508a5"],
    "IMFVideoMixerControl2": ["8459616d-966e-4930-b658-54fa7e5a16d3"],
    "IMFVideoPositionMapper": ["1f6a9f17-e70b-4e24-8ae4-0b2c3ba7a4ae"],
    "IMFVideoPresenter": ["29aff080-182a-4a5d-af3b-448f3a6346cb"],
    "IMFVideoProcessor": ["6ab0000c-fece-4d1f-a2ac-a9573530656e"],
    "IMFVideoProcessorControl": ["a3f675d5-6119-4f7f-a100-1d8b280f0efb"],
    "IMFVideoProcessorControl2": ["bde633d3-e1dc-4a7f-a693-bbae399c4a20"],
    "IMFVideoProcessorControl3": ["2424b3f2-eb23-40f1-91aa-74bddeea0883"],
    "IMFVideoProcessorControlInternal": ["44f18199-7981-4f93-abe8-287ff0cccd7a"],
    "IMFVideoRenderer": ["dfdfd197-a9ca-43d8-b341-6af3503792cd"],
    "IMFVideoRendererEffectControl": ["604d33d7-cf23-41d5-8224-5bbbb1a87475"],
    "IMFVideoSampleAllocator": ["86cbc910-e533-4751-8e3b-f19b5b806a03"],
    "IMFVideoSampleAllocatorCallback": ["992388b4-3372-4f67-8b6f-c84c071f4751"],
    "IMFVideoSampleAllocatorCallbackEx": ["fe8d56d8-4f2f-45d8-b420-e5e5776bf51a"],
    "IMFVideoSampleAllocatorEx": ["545b3a48-3283-4f62-866f-a62d8f598f9f"],
    "IMFVideoSampleAllocatorEx2": ["9cbab028-f709-4950-ab0c-02b36a40880e"],
    "IMFVideoSampleAllocatorEx3": ["ef4ce6b9-5094-4f68-a748-9ed30f74f34f"],
    "IMFVideoSampleAllocatorNotify": ["a792cdbe-c374-4e89-8335-278e7b9956a4"],
    "IMFVideoSampleAllocatorNotifyEx": ["3978aa1a-6d5b-4b7f-a340-90899189ae34"],
    "IMFWMDRMITACreator": ["abdf559f-c509-404e-a562-d30ad351e6d1"],
    "IMFWorkQueueServices": ["35fe1bb8-a3a9-40fe-bbec-eb569c9ccca3"],
    "IMFWorkQueueServicesEx": ["96bf961b-40fe-42f1-ba9d-320238b49700"],
    "IMFWrappableTimeSource": ["125dfc8d-ba2c-4bf1-8b18-388c038140c5"],
    "IMILBitmap": ["b1784d3f-8115-4763-13aa-32eddb68294a"],
    "IMILBitmapEffect": ["8a6ff321-c944-4a1b-9944-9954af301258"],
    "IMILBitmapEffectConnections": ["c2b5d861-9b1a-4374-89b0-dec4874d6a81"],
    "IMILBitmapEffectConnectionsInfo": ["476b538a-c765-4237-ba4a-d6a880ff0cfc"],
    "IMILBitmapEffectConnector": ["f59567b3-76c1-4d47-ba1e-79f955e350ef"],
    "IMILBitmapEffectConnectorInfo": ["f66d2e4b-b46b-42fc-859e-3da0ecdb3c43"],
    "IMILBitmapEffectEvents": ["2e880dd8-f8ce-457b-8199-d60bb3d7ef98"],
    "IMILBitmapEffectFactory": ["33a9df34-a403-4ec7-b07e-bc0682370845"],
    "IMILBitmapEffectGroup": ["2f952360-698a-4ac6-81a1-bcfdf08eb8e8"],
    "IMILBitmapEffectGroupImpl": ["78fed518-1cfc-4807-8b85-6b6e51398f62"],
    "IMILBitmapEffectImpl": ["cc2468f2-9936-47be-b4af-06b5df5dbcbb"],
    "IMILBitmapEffectInputConnector": ["a9b4ecaa-7a3c-45e7-8573-f4b81b60dd6c"],
    "IMILBitmapEffectInteriorInputConnector": ["20287e9e-86a2-4e15-953d-eb1438a5b842"],
    "IMILBitmapEffectInteriorOutputConnector": ["00bbb6dc-acc9-4bfc-b344-8bee383dfefa"],
    "IMILBitmapEffectOutputConnector": ["92957aad-841b-4866-82ec-8752468b07fd"],
    "IMILBitmapEffectOutputConnectorImpl": ["21fae777-8b39-4bfa-9f2d-f3941ed36913"],
    "IMILBitmapEffectPrimitive": ["67e31025-3091-4dfc-98d6-dd494551461d"],
    "IMILBitmapEffectPrimitiveImpl": ["ce41e00b-efa6-44e7-b007-dd042e3ae126"],
    "IMILBitmapEffectRenderContext": ["12a2ec7e-2d33-44b2-b334-1abb7846e390"],
    "IMILBitmapEffectRenderContextImpl": ["4d25accb-797d-4fd2-b128-dffeff84fcc3"],
    "IMILBitmapEffects": ["51ac3dce-67c5-448b-9180-ad3eabddd5dd"],
    "IMILBitmapLock": ["a67b2b53-8fa1-4155-8f64-0c247a8f84cd"],
    "IMILBitmapScaler": ["a767b0f0-1c8c-4aef-568f-adf96dcfd5cb"],
    "IMILBitmapSource": ["7543696a-bc8d-46b0-5f81-8d95728972be"],
    "IMILCBitmapLock": ["64cd1766-561c-4379-857a-ff70f36cd82c"],
    "IMILCJpegDecoderFrame": ["21b7f576-9999-41d0-af2c-807cda3863f8"],
    "IMILCMemoryStream": ["43328a0a-f657-4ae4-ad64-f0db70eace67"],
    "IMILCStreamBase": ["c3933843-c24b-45a2-8298-b462f59daaf2"],
    "IMILCSubStream": ["c42d55d5-53be-4aa5-a11b-e250d404289c"],
    "IMILFormatConverter": ["7e2a746f-25c5-4851-b3af-443b79639ec0"],
    "IMILPalette": ["ca8e206f-f22c-4af7-6fba-7bed5eb1c92f"],
    "IMILResourceCache": ["181fa62c-0133-43d4-8d5c-639c3487783f"],
    "IMMDevice": ["d666063f-1587-4e43-81f1-b948e807363f"],
    "IMMDeviceActivator": ["3b0d0ea4-d0a9-4b0e-935b-09516746fac0"],
    "IMMDeviceCollection": ["0bd7a1be-7a1a-44db-8397-cc5392387b5e"],
    "IMMDeviceEnumerator": ["a95664d2-9614-4f35-a746-de8db63617e6"],
    "IMMEndpoint": ["1be09788-6894-4089-8586-9a2a6c265ac5"],
    "IMMNotificationClient": ["7991eec9-7e89-4d85-8390-6c703cec60c0"],
    "IMPEG2Component": ["1493e353-1eb6-473c-802d-8e6b8ec9d2a9"],
    "IMPEG2ComponentType": ["2c073d84-b51c-48c9-aa9f-68971e1f6e38"],
    "IMPEG2PIDMap": ["afb6c2a1-2c41-11d3-8a60-0000f81e0e4a"],
    "IMPEG2StreamIdMap": ["d0e04c47-25b8-4369-925a-362a01d95444"],
    "IMPEG2TuneRequest": ["eb7d987f-8a01-42ad-b8ae-574deee44d1a"],
    "IMPEG2TuneRequestFactory": ["14e11abd-ee37-4893-9ea1-6964de933e39"],
    "IMPEG2TuneRequestSupport": ["1b9d5fc3-5bbc-4b6c-bb18-b9d10e3eeebf"],
    "IMPEG2_TIF_CONTROL": ["f9bac2f9-4149-4916-b2ef-faa202326862"],
    "IMRTResourceBroker": ["59d87252-b4a0-f62b-50ab-4990760e1a45"],
    "IMRU": ["1011fa30-69da-11d2-8599-006097df8c11"],
    "IMSACredentialManager": ["b98f965f-1e46-45a2-b8e6-4454bc0a0ca5"],
    "IMSAdminBase": ["70b51430-b6ca-11d0-b9b9-00a0c922e750"],
    "IMSAdminBase2": ["8298d101-f992-43b7-8eca-5052d885b995"],
    "IMSAdminBase2W": ["8298d101-f992-43b7-8eca-5052d885b995"],
    "IMSAdminBase2_W": ["8298d101-f992-43b7-8eca-5052d885b995"],
    "IMSAdminBase3": ["f612954d-3b0b-4c56-9563-227b7be624b4"],
    "IMSAdminBase3W": ["f612954d-3b0b-4c56-9563-227b7be624b4"],
    "IMSAdminBase3_W": ["f612954d-3b0b-4c56-9563-227b7be624b4"],
    "IMSAdminBaseSink": ["a9e69612-b80d-11d0-b9b9-00a0c922e750"],
    "IMSAdminBaseSinkW": ["a9e69612-b80d-11d0-b9b9-00a0c922e750"],
    "IMSAdminBaseSink_W": ["a9e69612-b80d-11d0-b9b9-00a0c922e750"],
    "IMSAdminBaseW": ["70b51430-b6ca-11d0-b9b9-00a0c922e750"],
    "IMSAdminBase_W": ["70b51430-b6ca-11d0-b9b9-00a0c922e750"],
    "IMSCEPSetup": ["4f7761bb-9f3b-4592-9ee0-9a73259c313e"],
    "IMSEObjectURLWrapper": ["6f955783-4d3d-4007-a10d-bc94698ab8f5"],
    "IMSEventBinder": ["c3a9f406-2222-436d-86d5-ba3229279efb"],
    "IMSFeedsPriv": ["3a2f8555-8498-4dd5-bab9-dba681c5cf4e"],
    "IMSFolderPriv": ["be7101b4-73ff-4acf-a472-b74c4fb5f45d"],
    "IMSImpExpHelp": ["29ff67ff-8050-480f-9f30-cc41635f2f9d"],
    "IMSImpExpHelpW": ["29ff67ff-8050-480f-9f30-cc41635f2f9d"],
    "IMSImpExpHelp_W": ["29ff67ff-8050-480f-9f30-cc41635f2f9d"],
    "IMSMQApplication": ["d7d6e085-dccd-11d0-aa4b-0060970debae"],
    "IMSMQApplication2": ["12a30900-7300-11d2-b0e6-00e02c074f6b"],
    "IMSMQApplication3": ["eba96b1f-2168-11d3-898c-00e02c074f6b"],
    "IMSMQCollection": ["0188ac2f-ecb3-4173-9779-635ca2039c72"],
    "IMSMQCoordinatedTransactionDispenser": ["d7d6e081-dccd-11d0-aa4b-0060970debae"],
    "IMSMQCoordinatedTransactionDispenser2": ["eba96b10-2168-11d3-898c-00e02c074f6b"],
    "IMSMQCoordinatedTransactionDispenser3": ["eba96b14-2168-11d3-898c-00e02c074f6b"],
    "IMSMQDestination": ["eba96b16-2168-11d3-898c-00e02c074f6b"],
    "IMSMQEvent": ["d7d6e077-dccd-11d0-aa4b-0060970debae"],
    "IMSMQEvent2": ["eba96b12-2168-11d3-898c-00e02c074f6b"],
    "IMSMQEvent3": ["eba96b1c-2168-11d3-898c-00e02c074f6b"],
    "IMSMQManagement": ["be5f0241-e489-4957-8cc4-a452fcf3e23e"],
    "IMSMQMessage": ["d7d6e074-dccd-11d0-aa4b-0060970debae"],
    "IMSMQMessage2": ["d9933be0-a567-11d2-b0f3-00e02c074f6b"],
    "IMSMQMessage3": ["eba96b1a-2168-11d3-898c-00e02c074f6b"],
    "IMSMQMessage4": ["eba96b23-2168-11d3-898c-00e02c074f6b"],
    "IMSMQOutgoingQueueManagement": ["64c478fb-f9b0-4695-8a7f-439ac94326d3"],
    "IMSMQPrivateDestination": ["eba96b17-2168-11d3-898c-00e02c074f6b"],
    "IMSMQPrivateEvent": ["d7ab3341-c9d3-11d1-bb47-0080c7c5a2c0"],
    "IMSMQQuery": ["d7d6e072-dccd-11d0-aa4b-0060970debae"],
    "IMSMQQuery2": ["eba96b0e-2168-11d3-898c-00e02c074f6b"],
    "IMSMQQuery3": ["eba96b19-2168-11d3-898c-00e02c074f6b"],
    "IMSMQQuery4": ["eba96b24-2168-11d3-898c-00e02c074f6b"],
    "IMSMQQueue2": ["ef0574e0-06d8-11d3-b100-00e02c074f6b"],
    "IMSMQQueue3": ["eba96b1b-2168-11d3-898c-00e02c074f6b"],
    "IMSMQQueue4": ["eba96b20-2168-11d3-898c-00e02c074f6b"],
    "IMSMQQueueInfo": ["d7d6e07b-dccd-11d0-aa4b-0060970debae"],
    "IMSMQQueueInfo2": ["fd174a80-89cf-11d2-b0f2-00e02c074f6b"],
    "IMSMQQueueInfo3": ["eba96b1d-2168-11d3-898c-00e02c074f6b"],
    "IMSMQQueueInfo4": ["eba96b21-2168-11d3-898c-00e02c074f6b"],
    "IMSMQQueueInfos": ["d7d6e07d-dccd-11d0-aa4b-0060970debae"],
    "IMSMQQueueInfos2": ["eba96b0f-2168-11d3-898c-00e02c074f6b"],
    "IMSMQQueueInfos3": ["eba96b1e-2168-11d3-898c-00e02c074f6b"],
    "IMSMQQueueInfos4": ["eba96b22-2168-11d3-898c-00e02c074f6b"],
    "IMSMQQueueManagement": ["7fbe7759-5760-444d-b8a5-5e7ab9a84cce"],
    "IMSMQTransaction": ["d7d6e07f-dccd-11d0-aa4b-0060970debae"],
    "IMSMQTransaction2": ["2ce0c5b0-6e67-11d2-b0e6-00e02c074f6b"],
    "IMSMQTransaction3": ["eba96b13-2168-11d3-898c-00e02c074f6b"],
    "IMSMQTransactionDispenser": ["d7d6e083-dccd-11d0-aa4b-0060970debae"],
    "IMSMQTransactionDispenser2": ["eba96b11-2168-11d3-898c-00e02c074f6b"],
    "IMSMQTransactionDispenser3": ["eba96b15-2168-11d3-898c-00e02c074f6b"],
    "IMSVidAnalogTuner": ["1c15d47e-911d-11d2-b632-00c04f79498e"],
    "IMSVidAnalogTuner2": ["37647bf7-3dde-4cc8-a4dc-0d534d3d0037"],
    "IMSVidAnalogTunerEvent": ["1c15d486-911d-11d2-b632-00c04f79498e"],
    "IMSVidAudioRenderer": ["37b0353f-a4c8-11d2-b634-00c04f79498e"],
    "IMSVidAudioRendererDevices": ["c5702cd4-9b79-11d3-b654-00c04f79498e"],
    "IMSVidAudioRendererEvent": ["37b03541-a4c8-11d2-b634-00c04f79498e"],
    "IMSVidAudioRendererEvent2": ["e3f55729-353b-4c43-a028-50f79aa9a907"],
    "IMSVidClosedCaptioning": ["99652ea1-c1f7-414f-bb7b-1c967de75983"],
    "IMSVidClosedCaptioning2": ["e00cb864-a029-4310-9987-a873f5887d97"],
    "IMSVidClosedCaptioning3": ["c8638e8a-7625-4c51-9366-2f40a9831fc0"],
    "IMSVidCompositionSegment": ["1c15d483-911d-11d2-b632-00c04f79498e"],
    "IMSVidCtl": ["b0edf162-910a-11d2-b632-00c04f79498e"],
    "IMSVidDataServices": ["334125c1-77e5-11d3-b653-00c04f79498e"],
    "IMSVidDataServicesEvent": ["334125c2-77e5-11d3-b653-00c04f79498e"],
    "IMSVidDevice": ["1c15d47c-911d-11d2-b632-00c04f79498e"],
    "IMSVidDevice2": ["87bd2783-ebc0-478c-b4a0-e8e7f43ab78e"],
    "IMSVidDeviceEvent": ["1c15d480-911d-11d2-b632-00c04f79498e"],
    "IMSVidEVR": ["15e496ae-82a8-4cf9-a6b6-c561dc60398f"],
    "IMSVidEVREvent": ["349abb10-883c-4f22-8714-cecaeee45d62"],
    "IMSVidEncoder": ["c0020fd4-bee7-43d9-a495-9f213117103d"],
    "IMSVidFeature": ["37b03547-a4c8-11d2-b634-00c04f79498e"],
    "IMSVidFeatureEvent": ["3dd2903c-e0aa-11d2-b63a-00c04f79498e"],
    "IMSVidFeatures": ["c5702cd5-9b79-11d3-b654-00c04f79498e"],
    "IMSVidFilePlayback": ["37b03539-a4c8-11d2-b634-00c04f79498e"],
    "IMSVidFilePlayback2": ["2f7e44af-6e52-4660-bc08-d8d542587d72"],
    "IMSVidFilePlaybackEvent": ["37b0353a-a4c8-11d2-b634-00c04f79498e"],
    "IMSVidGenericSink": ["6c29b41d-455b-4c33-963a-0d28e5e555ea"],
    "IMSVidGenericSink2": ["6b5a28f3-47f1-4092-b168-60cabec08f1c"],
    "IMSVidGraphSegment": ["238dec54-adeb-4005-a349-f772b9afebc4"],
    "IMSVidGraphSegmentContainer": ["3dd2903d-e0aa-11d2-b63a-00c04f79498e"],
    "IMSVidGraphSegmentUserInput": ["301c060e-20d9-4587-9b03-f82ed9a9943c"],
    "IMSVidInputDevice": ["37b0353d-a4c8-11d2-b634-00c04f79498e"],
    "IMSVidInputDeviceEvent": ["37b0353e-a4c8-11d2-b634-00c04f79498e"],
    "IMSVidInputDevices": ["c5702cd1-9b79-11d3-b654-00c04f79498e"],
    "IMSVidOutputDevice": ["37b03546-a4c8-11d2-b634-00c04f79498e"],
    "IMSVidOutputDeviceEvent": ["2e6a14e2-571c-11d3-b652-00c04f79498e"],
    "IMSVidOutputDevices": ["c5702cd2-9b79-11d3-b654-00c04f79498e"],
    "IMSVidPlayback": ["37b03538-a4c8-11d2-b634-00c04f79498e"],
    "IMSVidPlaybackEvent": ["37b0353b-a4c8-11d2-b634-00c04f79498e"],
    "IMSVidRect": ["7f5000a6-a440-47ca-8acc-c0e75531a2c2"],
    "IMSVidStreamBufferRecordingControl": ["160621aa-bbbc-4326-a824-c395aebc6e74"],
    "IMSVidStreamBufferSink": ["159dbb45-cd1b-4dab-83ea-5cb1f4f21d07"],
    "IMSVidStreamBufferSink2": ["2ca9fc63-c131-4e5a-955a-544a47c67146"],
    "IMSVidStreamBufferSink3": ["4f8721d7-7d59-4d8b-99f5-a77775586bd5"],
    "IMSVidStreamBufferSinkEvent": ["f798a36b-b05b-4bbe-9703-eaea7d61cd51"],
    "IMSVidStreamBufferSinkEvent2": ["3d7a5166-72d7-484b-a06f-286187b80ca1"],
    "IMSVidStreamBufferSinkEvent3": ["735ad8d5-c259-48e9-81e7-d27953665b23"],
    "IMSVidStreamBufferSinkEvent4": ["1b01dcb0-daf0-412c-a5d1-590c7f62e2b8"],
    "IMSVidStreamBufferSource": ["eb0c8cf9-6950-4772-87b1-47d11cf3a02f"],
    "IMSVidStreamBufferSource2": ["e4ba9059-b1ce-40d8-b9a0-d4ea4a9989d3"],
    "IMSVidStreamBufferSourceEvent": ["50ce8a7d-9c28-4da8-9042-cdfa7116f979"],
    "IMSVidStreamBufferSourceEvent2": ["7aef50ce-8e22-4ba8-bc06-a92a458b4ef2"],
    "IMSVidStreamBufferSourceEvent3": ["ceabd6ab-9b90-4570-adf1-3ce76e00a763"],
    "IMSVidStreamBufferV2SourceEvent": ["49c771f9-41b2-4cf7-9f9a-a313a8f6027e"],
    "IMSVidTuner": ["1c15d47d-911d-11d2-b632-00c04f79498e"],
    "IMSVidTunerEvent": ["1c15d485-911d-11d2-b632-00c04f79498e"],
    "IMSVidVMR9": ["d58b0015-ebef-44bb-bbdd-3f3699d76ea1"],
    "IMSVidVRGraphSegment": ["dd47de3f-9874-4f7b-8b22-7cb2688461e7"],
    "IMSVidVideoInputDevice": ["1c15d47f-911d-11d2-b632-00c04f79498e"],
    "IMSVidVideoRenderer": ["37b03540-a4c8-11d2-b634-00c04f79498e"],
    "IMSVidVideoRenderer2": ["6bdd5c1e-2810-4159-94bc-05511ae8549b"],
    "IMSVidVideoRendererDevices": ["c5702cd3-9b79-11d3-b654-00c04f79498e"],
    "IMSVidVideoRendererEvent": ["37b03545-a4c8-11d2-b634-00c04f79498e"],
    "IMSVidVideoRendererEvent2": ["7145ed66-4730-4fdb-8a53-fde7508d3e5e"],
    "IMSVidWebDVD": ["cf45f88b-ac56-4ee2-a73a-ed04e2885d3c"],
    "IMSVidWebDVD2": ["7027212f-ee9a-4a7c-8b67-f023714cdaff"],
    "IMSVidWebDVDAdm": ["b8be681a-eb2c-47f0-b415-94d5452f0e05"],
    "IMSVidWebDVDEvent": ["b4f7a674-9b83-49cb-a357-c63b871be958"],
    "IMSVidXDS": ["11ebc158-e712-4d1f-8bb3-01ed5274c4ce"],
    "IMSVidXDSEvent": ["6db2317d-3b23-41ec-ba4b-701f407eaf3a"],
    "IMXF": ["c096df9e-fb09-11d1-81b0-0060083316c1", "c096df9e-fb09-11d1-81b0-0060083316c1"],
    "IMXRAttributes": ["6147fa3b-2790-4069-aad8-9502fc4a1416"],
    "IMXRContentHandler": ["bac05b74-cf58-4b65-bd61-0aca1d0bc08e"],
    "IMXXMLFilter": ["c90352f7-643c-4fbc-bb23-e996eb2d51fd"],
    "IMacAlgorithmNamesStatics": ["41412678-fb1e-43a4-895e-a9026e4390a3"],
    "IMacAlgorithmProvider": ["4a3fc5c3-1cbd-41ce-a092-aa0bc5d2d2f5"],
    "IMacAlgorithmProvider2": ["6da32a15-d931-42ed-8e7e-c301caee119c"],
    "IMacAlgorithmProviderStatics": ["c9bdc147-cc77-4df0-9e4e-b921e080644c"],
    "IMagneticStripeReader": ["1a92b015-47c3-468a-9333-0c6517574883"],
    "IMagneticStripeReaderAamvaCardDataReceivedEventArgs": ["0a4bbd51-c316-4910-87f3-7a62ba862d31"],
    "IMagneticStripeReaderBankCardDataReceivedEventArgs": ["2e958823-a31a-4763-882c-23725e39b08e"],
    "IMagneticStripeReaderCapabilities": ["7128809c-c440-44a2-a467-469175d02896"],
    "IMagneticStripeReaderCardTypesStatics": ["528f2c5d-2986-474f-8454-7ccd05928d5f"],
    "IMagneticStripeReaderEncryptionAlgorithmsStatics": ["53b57350-c3db-4754-9c00-41392374a109"],
    "IMagneticStripeReaderErrorOccurredEventArgs": ["1fedf95d-2c84-41ad-b778-f2356a789ab1"],
    "IMagneticStripeReaderReport": ["6a5b6047-99b0-4188-bef1-eddf79f78fe6"],
    "IMagneticStripeReaderStatics": ["c45fab4a-efd7-4760-a5ce-15b0e47e94eb"],
    "IMagneticStripeReaderStatics2": ["8cadc362-d667-48fa-86bc-f5ae1189262b"],
    "IMagneticStripeReaderStatusUpdatedEventArgs": ["09cc6bb0-3262-401d-9e8a-e80d6358906b"],
    "IMagneticStripeReaderTrackData": ["104cf671-4a9d-446e-abc5-20402307ba36"],
    "IMagneticStripeReaderVendorSpecificCardDataReceivedEventArgs": ["af0a5514-59cc-4a60-99e8-99a53dace5aa"],
    "IMagnetometer": ["484f626e-d3c9-4111-b3f6-2cf1faa418d5"],
    "IMagnetometer2": ["b4656c85-26f6-444b-a9e2-a23f966cd368"],
    "IMagnetometer3": ["be93db7c-a625-48ef-acf7-fac104832671"],
    "IMagnetometer4": ["dfb17901-3e0f-508f-b24b-f2bb75015f40"],
    "IMagnetometerDataThreshold": ["d177cb01-9063-5fa5-b596-b445e9dc3401"],
    "IMagnetometerDeviceId": ["58b498c2-7e4b-404c-9fc5-5de8b40ebae3"],
    "IMagnetometerReading": ["0c2cc40d-ebfd-4e5c-bb11-afc29b3cae61"],
    "IMagnetometerReading2": ["d4c95c61-61d9-404b-a328-066f177a1409"],
    "IMagnetometerReadingChangedEventArgs": ["17eae872-2eb9-4ee7-8ad0-3127537d949b"],
    "IMagnetometerStatics": ["853c64cc-0698-4dda-a6df-9cb9cc4ab40a"],
    "IMagnetometerStatics2": ["2c0819f0-ffc6-4f89-a06f-18fa10792933"],
    "IMaintenanceSettings": ["a6024fa8-9652-4adb-a6bf-5cfcd877a7ba"],
    "IMaintenanceTrigger": ["68184c83-fc22-4ce5-841a-7239a9810047"],
    "IMaintenanceTriggerFactory": ["4b3ddb2e-97dd-4629-88b0-b06cf9482ae5"],
    "IManageWritableSharedStream": ["df0ef230-197e-4b83-ac0f-2381219c46ac"],
    "IManagedStream": ["3a55501a-bdcc-4e63-96bc-4ddb6f44ccdd"],
    "IManagedViewerHost": ["5968d43d-d21e-437c-9c71-77c52c3e287a"],
    "IManagerForAlm": ["8f930e5f-019b-461f-aa10-6c3df1d01e5a"],
    "IManeuverWarning": ["c1a36d8a-2630-4378-9e4a-6e44253dceba"],
    "IManipulationCompletedEventArgs": ["b34ab22b-d19b-46ff-9f38-dec7754bb9e7"],
    "IManipulationCompletedEventArgs2": ["f0c0dce7-30a9-5b96-886f-6560a85e4757"],
    "IManipulationCompletedEventHandler": ["38ef4b0f-14f8-42df-9a1e-a4bcc4af77f4"],
    "IManipulationCompletedRoutedEventArgs": ["b5ad9b23-2f41-498e-8319-015ee8a75346"],
    "IManipulationDeltaEventHandler": ["aa1160cb-dfb9-4c56-abdc-711b63c8eb94"],
    "IManipulationDeltaRoutedEventArgs": ["400d5794-4c6f-491d-82d6-3517109399c6"],
    "IManipulationInertiaStartingEventArgs": ["dd37a898-26bf-467a-9ce5-ccf3fb11371e"],
    "IManipulationInertiaStartingEventArgs2": ["c25409b8-f9fa-5a45-bd97-dcbbb2201860"],
    "IManipulationInertiaStartingEventHandler": ["d39d6322-7c9c-481b-827b-c8b2d9bb6fc7"],
    "IManipulationInertiaStartingRoutedEventArgs": ["246a91a9-ca43-4c0b-acef-81e8b8147520"],
    "IManipulationPivot": ["2e3838a5-e6c2-4998-82ac-18748b141666"],
    "IManipulationPivotFactory": ["6d05b039-3702-4396-ad9b-a825efa63a3b"],
    "IManipulationProcessor": ["a22ac519-8300-48a0-bef4-f1be8737dba4"],
    "IManipulationStartedEventArgs": ["ddec873e-cfce-4932-8c1d-3c3d011a34c0"],
    "IManipulationStartedEventArgs2": ["2da3db4e-e583-5055-afaa-16fd986531a6"],
    "IManipulationStartedEventHandler": ["f88345f8-e0a3-4be2-b90c-dc20e6d8beb0"],
    "IManipulationStartedRoutedEventArgs": ["5db1aa05-9f80-48b6-ae6c-4f119de8ff13"],
    "IManipulationStartedRoutedEventArgsFactory": ["84c1daa7-7272-4463-b6c3-a40b9ba151fc"],
    "IManipulationStartingEventHandler": ["10d0b04e-bfe4-42cb-823c-3fecd8770ef8"],
    "IManipulationStartingRoutedEventArgs": ["18d636b7-53a4-4c15-a498-f3a9ca212a42"],
    "IManipulationUpdatedEventArgs": ["cb354ce5-abb8-4f9f-b3ce-8181aa61ad82"],
    "IManipulationUpdatedEventArgs2": ["f3dfb96a-3306-5903-a1c5-ff9757a8689e"],
    "IMapActualCameraChangedEventArgs": ["daa080da-b7f4-422c-a618-bbaa7c1d814c"],
    "IMapActualCameraChangedEventArgs2": ["7ba4c7e5-10dc-455a-9d04-1d72fb6d9b93"],
    "IMapActualCameraChangingEventArgs": ["6b0dbed6-93f7-4682-8de5-a47a1cc7a945"],
    "IMapActualCameraChangingEventArgs2": ["f2867897-40ac-4e8a-a927-510f3846a47e"],
    "IMapAddress": ["cfa7a973-a3b4-4494-b3ff-cba94db69699"],
    "IMapAddress2": ["75cd6df1-e5ad-45a9-bf40-6cf256c1dd13"],
    "IMapBillboard": ["1694259d-0ae2-4f42-a02e-292ca835d39d"],
    "IMapBillboardFactory": ["be45a4c5-8f09-4b86-ae28-783740eb8b31"],
    "IMapBillboardStatics": ["fdf839fe-e1f7-4fb0-8887-7da68c647333"],
    "IMapCamera": ["53a6b623-c0f8-4d8b-ad1e-a59598ea840b"],
    "IMapCameraFactory": ["ea3b0f16-83af-4ace-8e71-10ad9f1e9e7f"],
    "IMapContextRequestedEventArgs": ["fdd1b423-c961-4df2-bb57-82ee0f0bb591"],
    "IMapControl": ["42d0b851-5256-4747-9e6c-0d11e966141e"],
    "IMapControl2": ["e1fd644d-96ec-4065-b0f0-75281da3654d"],
    "IMapControl3": ["586328f8-8cdd-40ae-9338-af2a7be845e5"],
    "IMapControl4": ["068f132a-1817-466d-b7ce-419b3f8e248b"],
    "IMapControl5": ["dd9b0ffd-7823-46a2-82c9-65ddac4f365f"],
    "IMapControl6": ["b0da89a2-1041-4bea-b88a-12ac9a82e0e2"],
    "IMapControl7": ["0d86e453-0c1f-4f7e-ae66-4ad0b4987857"],
    "IMapControl8": ["009e9c46-724d-53ca-9421-7a48fc731523"],
    "IMapControlAutomationPeer": ["425beee4-f2e8-4bcb-9382-5dfdd11fe45f"],
    "IMapControlBusinessLandmarkClickEventArgs": ["5e464922-4a1a-4797-beb7-5cf7754cb867"],
    "IMapControlBusinessLandmarkPointerEnteredEventArgs": ["5e4081a6-ea98-4f95-8caf-5b42696ff504"],
    "IMapControlBusinessLandmarkPointerExitedEventArgs": ["2bb52caf-f24a-46d0-b463-65f719731057"],
    "IMapControlBusinessLandmarkRightTappedEventArgs": ["59ab8ae7-f184-4ab1-b0b0-35c8bf0654b2"],
    "IMapControlDataHelper": ["8bb0f09c-14ab-486c-9de5-5a5def0205a2"],
    "IMapControlDataHelper2": ["59ce429e-562f-4c21-a674-0f11decf0fb3"],
    "IMapControlDataHelperFactory": ["3b70aa8e-02ef-469c-bbaf-dc2158d4289b"],
    "IMapControlDataHelperStatics": ["7a6632d6-e944-4110-83cf-314d0722e2e5"],
    "IMapControlStatics": ["c2c61795-2147-4f0a-942a-5493a85de807"],
    "IMapControlStatics2": ["04852b93-b446-4d31-9752-1ec69a5996ae"],
    "IMapControlStatics4": ["fe785d97-5d13-4fa1-bf1d-84061768c183"],
    "IMapControlStatics5": ["09626f00-b7dd-4189-a7f7-830c412deea3"],
    "IMapControlStatics6": ["3ccfdd7f-24d1-40a2-8351-b3063a8c95a4"],
    "IMapControlStatics7": ["55f1ac4d-72c2-46b2-b7ae-790260be641b"],
    "IMapControlStatics8": ["adb7a7b0-0605-592c-bf9d-d10bdc2be47b"],
    "IMapControlTransitFeatureClickEventArgs": ["76179969-b765-4622-b08a-3072745a4541"],
    "IMapControlTransitFeaturePointerEnteredEventArgs": ["73911a4e-ec4f-479e-94a1-36e081d0d897"],
    "IMapControlTransitFeaturePointerExitedEventArgs": ["6a11258d-448d-44e7-bc69-d13d497154e9"],
    "IMapControlTransitFeatureRightTappedEventArgs": ["aea1cc49-a729-4eae-a59a-3ec9a125a028"],
    "IMapCustomExperience": ["64592866-14a3-4e5f-8883-8e9c500eeede"],
    "IMapCustomExperienceChangedEventArgs": ["b9e6fb9b-8fc1-4042-ac34-a61b38bb7514"],
    "IMapCustomExperienceFactory": ["7a403fb5-a1b1-4e7f-921e-3e6b8d8ebed6"],
    "IMapElement": ["d61fc4df-b245-47f2-9ac2-43c058b1c903"],
    "IMapElement2": ["6619f261-fba6-4964-a7ff-f1af63ab9cb0"],
    "IMapElement3": ["13efbc59-45ed-48b4-93ad-e3f78f8cf218"],
    "IMapElement3D": ["827af8d5-3843-48e2-bd00-0f0644fbe6a5"],
    "IMapElement3DStatics": ["6128011a-450f-442a-b9d9-aa815c71907a"],
    "IMapElement4": ["645883b6-1fc1-4ceb-93bd-dc2c960072e9"],
    "IMapElementClickEventArgs": ["40168a11-d080-4519-99a1-3149fb8999d0"],
    "IMapElementFactory": ["4a30d007-0bd6-47a5-860b-7e7cf5f0c573"],
    "IMapElementPointerEnteredEventArgs": ["ab85dd4e-91d7-4b31-8f0a-d390c7d3a2ef"],
    "IMapElementPointerExitedEventArgs": ["c1a45af9-60c9-4679-9119-20abc75d931f"],
    "IMapElementStatics": ["e8c71cf2-bfef-4b49-8e99-41b5e3789fd2"],
    "IMapElementStatics2": ["9bf72f30-80fe-4f30-bcc1-fa894050f676"],
    "IMapElementStatics3": ["e11ee92f-9742-49aa-aad8-2e466bff3796"],
    "IMapElementStatics4": ["a4296f0b-dff8-467c-9315-6f6db93ee2ba"],
    "IMapElementsLayer": ["de79689a-01ef-46f4-ac60-7c200b552610"],
    "IMapElementsLayerClickEventArgs": ["2ca7cf66-af1b-4c05-8c85-f74ae3d4677f"],
    "IMapElementsLayerContextRequestedEventArgs": ["da45d0b3-7a0e-4758-808b-3a637627eb0d"],
    "IMapElementsLayerPointerEnteredEventArgs": ["757fc032-4694-4404-8c89-348b6b76c5e6"],
    "IMapElementsLayerPointerExitedEventArgs": ["92f3c6ad-03ed-4c39-af20-2a07ee1ccea6"],
    "IMapElementsLayerStatics": ["34005727-f509-4d28-9180-911c03411d74"],
    "IMapFeatureDescriptor": ["530424bd-a257-436d-9e60-c2981f7cc5c4"],
    "IMapIcon": ["d2096872-23d9-4a2b-8be0-69f3a85482ab"],
    "IMapIcon2": ["611254b9-d8aa-4bbd-a316-badf06911d63"],
    "IMapIconStatics": ["dcbc9e56-1190-4b5d-9e56-e5b6724aa328"],
    "IMapIconStatics2": ["ff4c306a-cf76-46ab-a12f-b603b986c696"],
    "IMapInputEventArgs": ["9fc503a0-a8a2-4394-92e9-2247764f2f49"],
    "IMapItemsControl": ["94c2c4d3-b335-42c5-b660-e6a07ec3bddc"],
    "IMapItemsControlStatics": ["33a859c7-789b-425c-8a0a-32385896cb4a"],
    "IMapLayer": ["6d0ff9c1-a14d-4f97-8f57-46715b57683a"],
    "IMapLayerFactory": ["e02a2207-dee3-47c8-9825-bd029c5752f7"],
    "IMapLayerStatics": ["9ca4a26b-5db9-4f0c-bdd5-b1bffdcce946"],
    "IMapLibraryCallback": ["8da15fe7-5eeb-44e2-912f-039c51348136"],
    "IMapLocation": ["3c073f57-0da4-42e8-9ee2-a96fcf2371dc"],
    "IMapLocationFinderResult": ["43f1f179-e8cc-45f6-bed2-54ccbf965d9a"],
    "IMapLocationFinderStatics": ["318adb5d-1c5d-4f35-a2df-aaca94959517"],
    "IMapLocationFinderStatics2": ["959a8b96-6485-4dfd-851a-33ac317e3af6"],
    "IMapManagerStatics": ["37e3e515-82b4-4d54-8fd9-af2624b3011c"],
    "IMapModel3D": ["f8c541a1-ca27-4968-a2bf-9c20f06a0468"],
    "IMapModel3DFactory": ["df7f0bcc-580a-498b-939b-0119a9dadb9e"],
    "IMapModel3DStatics": ["4834a480-8e56-4b0f-872d-7ead103187cd"],
    "IMapPolygon": ["abda2285-4926-4c3a-a5f9-19df7f69db3d"],
    "IMapPolygon2": ["96c8a11e-636b-4018-9c2e-acc9122a01b2"],
    "IMapPolygonStatics": ["37f573be-097b-424c-87cc-2ee042fda6d2"],
    "IMapPolyline": ["fbad24a2-24df-4a86-8ffa-0f8f4d9ec17d"],
    "IMapPolylineStatics": ["61fde44b-1ddf-4303-b809-ec87f58ad065"],
    "IMapRightTappedEventArgs": ["20943171-6fe8-40a6-ad0e-297379b575a7"],
    "IMapRoute": ["fb07b732-584d-4583-9c60-641fea274349"],
    "IMapRoute2": ["d1c5d40c-2213-4ab0-a260-46b38169beac"],
    "IMapRoute3": ["858d1eae-f2ad-429f-bb37-cd21094ffc92"],
    "IMapRoute4": ["366c8ca5-3053-4fa1-80ff-d475f3ed1e6e"],
    "IMapRouteDrivingOptions": ["6815364d-c6dc-4697-a452-b18f8f0b67a1"],
    "IMapRouteDrivingOptions2": ["35dc8670-c298-48d0-b5ad-825460645603"],
    "IMapRouteFinderResult": ["a868a31a-9422-46ac-8ca1-b1614d4bfbe2"],
    "IMapRouteFinderResult2": ["20709c6d-d90c-46c8-91c6-7d4be4efb215"],
    "IMapRouteFinderStatics": ["b8a5c50f-1c64-4c3a-81eb-1f7c152afbbb"],
    "IMapRouteFinderStatics2": ["afcc2c73-7760-49af-b3bd-baf135b703e1"],
    "IMapRouteFinderStatics3": ["f6098134-5913-11e6-8b77-86f30ca893d3"],
    "IMapRouteLeg": ["96f8b2f6-5bba-4d17-9db6-1a263fec7471"],
    "IMapRouteLeg2": ["02e2062d-c9c6-45b8-8e54-1a10b57a17e8"],
    "IMapRouteManeuver": ["ed5c17f0-a6ab-4d65-a086-fa8a7e340df2"],
    "IMapRouteManeuver2": ["5d7bcd9c-7c9b-41df-838b-eae21e4b05a9"],
    "IMapRouteManeuver3": ["a6a138df-0483-4166-85be-b99336c11875"],
    "IMapRouteView": ["740eaec5-bacc-41e1-a67e-dd6513832049"],
    "IMapRouteViewFactory": ["f083addf-0066-4628-82fe-ea78c23cec1e"],
    "IMapScene": ["8bba10a9-50e7-482c-9789-c688b178ac24"],
    "IMapSceneStatics": ["03e4ad6c-86ec-44d9-9597-fb75b7deba0a"],
    "IMapServiceStatics": ["0144ad85-c04c-4cdd-871a-a0726d097cd4"],
    "IMapServiceStatics2": ["f8193eed-9c85-40a9-8896-0fc3fd2b7c2a"],
    "IMapServiceStatics3": ["0a11ce20-63a7-4854-b355-d6dcda223d1b"],
    "IMapServiceStatics4": ["088a2862-6abc-420e-945f-4cfd89c67356"],
    "IMapStyleSheet": ["ae54b2bf-8991-42ed-8d58-20473deede1d"],
    "IMapStyleSheetEntriesStatics": ["c9636345-ef1a-41a4-a757-bd4f43e1e4d1"],
    "IMapStyleSheetEntryStatesStatics": ["23ac5532-866d-4bfa-b481-39bea1de3506"],
    "IMapStyleSheetStatics": ["abbd00ad-0a1c-4335-82f4-61d936aa197d"],
    "IMapTargetCameraChangedEventArgs": ["dbf00472-e953-4fa8-97d0-ea86359057cf"],
    "IMapTargetCameraChangedEventArgs2": ["97c0b332-f2b6-460b-8d91-ac020a2383dd"],
    "IMapTileBitmapRequest": ["46733fbc-d89d-472b-b5f6-d7066b0584f4"],
    "IMapTileBitmapRequestDeferral": ["fe370542-a4ac-4efa-9665-0490b0cafdd2"],
    "IMapTileBitmapRequestedEventArgs": ["337f691d-9b02-4aa2-8b1e-cc4d91719bf3"],
    "IMapTileBitmapRequestedEventArgs2": ["0261d114-246a-5296-bc85-590f53aa39c8"],
    "IMapTileDataSource": ["c03d9f5e-be1f-4c69-9969-79467a513c38"],
    "IMapTileDataSourceFactory": ["a3920fbd-e446-4648-a74d-fd2c5d557c06"],
    "IMapTileSource": ["88a76e4e-2fdf-4567-9255-1100519c8d62"],
    "IMapTileSource2": ["8e65ebbd-4095-5c15-99f1-1260b4e8b0a9"],
    "IMapTileSourceFactory": ["cd7f811f-77fa-482b-9d34-71d31d465c48"],
    "IMapTileSourceStatics": ["93fcc93c-7035-4603-99b1-e659921b6093"],
    "IMapTileSourceStatics2": ["75cdd47e-669c-50fd-ad85-5ea5174cf59b"],
    "IMapTileUriRequest": ["17402335-3127-45b8-87a7-99f87d4e2745"],
    "IMapTileUriRequestDeferral": ["c117ade0-bf3e-4c51-8faa-4b593cf68eb2"],
    "IMapTileUriRequestedEventArgs": ["d2147b43-1bbf-4b98-8dd3-b7834e407e0d"],
    "IMapTileUriRequestedEventArgs2": ["2302185d-33b5-5a55-92f5-74a86a22efa6"],
    "IMapiOutOfProcHandler": ["8da6db1c-8114-40c6-9d97-d2e7e9757d67"],
    "IMapiOutOfProcHandler2": ["38004ea6-ecfd-4da2-a68f-d76ff85da38f"],
    "IMappableObjectRequestContext": ["d8af269b-0b07-461a-8986-19cf28ca0517"],
    "IMappedStream": ["7d747d7f-a49e-11d1-b28e-00c04fb9386d"],
    "IMapping": ["b05651d4-9b10-425e-b616-1fcd828db3b1"],
    "IMappings": ["b05651d3-9b10-425e-b616-1fcd828db3b1"],
    "IMarkupCallback": ["4440306e-d79a-48d0-88e6-a42692279bfb"],
    "IMarkupExtension": ["1ee3416d-562b-486e-9ee5-0f0cbcc8048c"],
    "IMarkupExtensionFactory": ["65329c05-fb5a-4567-9d55-5cdfbada2739"],
    "IMarkupExtensionOverrides": ["393779bf-b9c0-4ffb-a57f-58e7356e425f"],
    "IMarkupServicesPriv": ["3051073d-98b5-11cf-bb82-00aa00bdce0b"],
    "IMarshalEnvoy": ["000001c8-0000-0000-c000-000000000046"],
    "IMarshalOptions": ["4c1e39e1-e3e3-4296-aa86-ec938d896e92"],
    "IMarshalingDirectionAndLocality": ["7d8bce82-7493-4c5d-a54c-8427a03e4972"],
    "IMarshalingStream": ["d8f2f5e6-6102-4863-9f26-389a4676efde"],
    "IMarshallingManager": ["f6ebeb2b-c8de-11d1-b88e-00c04fb9618a"],
    "IMathInputControl": ["eba615aa-fac6-4738-ba5f-ff09e9fe473e"],
    "IMatrix3DHelper": ["e48c10ef-9927-4c9b-8213-07775512ba04"],
    "IMatrix3DHelperStatics": ["9264545e-e158-4e74-8899-689160bd2f8c"],
    "IMatrix3DProjection": ["6f03e149-bfc9-4c01-b578-50338cec97fc"],
    "IMatrix3DProjectionStatics": ["ae9d5895-41ec-4e37-abaa-69f41d2f876b"],
    "IMatrixHelper": ["f3cf4882-06b5-48c8-9eb2-1763e9364038"],
    "IMatrixHelperStatics": ["c18606a6-39f4-4b8a-8403-28e5e5f033b4"],
    "IMatrixTransform": ["edfdd551-5fed-45fc-ae62-92a4b6cf9707"],
    "IMatrixTransformStatics": ["43e02e47-15b8-4758-bb97-7d52420acc5b"],
    "IMbnConnection": ["dcbbbab6-200d-4bbb-aaee-338e368af6fa"],
    "IMbnConnectionContext": ["dcbbbab6-200b-4bbb-aaee-338e368af6fa"],
    "IMbnConnectionContextEvents": ["dcbbbab6-200c-4bbb-aaee-338e368af6fa"],
    "IMbnConnectionEvents": ["dcbbbab6-200e-4bbb-aaee-338e368af6fa"],
    "IMbnConnectionManager": ["dcbbbab6-201d-4bbb-aaee-338e368af6fa"],
    "IMbnConnectionManagerEvents": ["dcbbbab6-201e-4bbb-aaee-338e368af6fa"],
    "IMbnConnectionProfile": ["dcbbbab6-2010-4bbb-aaee-338e368af6fa"],
    "IMbnConnectionProfileEvents": ["dcbbbab6-2011-4bbb-aaee-338e368af6fa"],
    "IMbnConnectionProfileManager": ["dcbbbab6-200f-4bbb-aaee-338e368af6fa"],
    "IMbnConnectionProfileManagerEvents": ["dcbbbab6-201f-4bbb-aaee-338e368af6fa"],
    "IMbnDeviceService": ["b3bb9a71-dc70-4be9-a4da-7886ae8b191b"],
    "IMbnDeviceServiceStateEvents": ["5d3ff196-89ee-49d8-8b60-33ffddffc58d"],
    "IMbnDeviceServicesContext": ["fc5ac347-1592-4068-80bb-6a57580150d8"],
    "IMbnDeviceServicesEvents": ["0a900c19-6824-4e97-b76e-cf239d0ca642"],
    "IMbnDeviceServicesManager": ["20a26258-6811-4478-ac1d-13324e45e41c"],
    "IMbnInterface": ["dcbbbab6-2001-4bbb-aaee-338e368af6fa"],
    "IMbnInterfaceEvents": ["dcbbbab6-2002-4bbb-aaee-338e368af6fa"],
    "IMbnInterfaceManager": ["dcbbbab6-201b-4bbb-aaee-338e368af6fa"],
    "IMbnInterfaceManagerEvents": ["dcbbbab6-201c-4bbb-aaee-338e368af6fa"],
    "IMbnMultiCarrier": ["dcbbbab6-2020-4bbb-aaee-338e368af6fa"],
    "IMbnMultiCarrierEvents": ["dcdddab6-2021-4bbb-aaee-338e368af6fa"],
    "IMbnPin": ["dcbbbab6-2007-4bbb-aaee-338e368af6fa"],
    "IMbnPinEvents": ["dcbbbab6-2008-4bbb-aaee-338e368af6fa"],
    "IMbnPinManager": ["dcbbbab6-2005-4bbb-aaee-338e368af6fa"],
    "IMbnPinManagerEvents": ["dcbbbab6-2006-4bbb-aaee-338e368af6fa"],
    "IMbnRadio": ["dccccab6-201f-4bbb-aaee-338e368af6fa"],
    "IMbnRadioEvents": ["dcdddab6-201f-4bbb-aaee-338e368af6fa"],
    "IMbnRegistration": ["dcbbbab6-2009-4bbb-aaee-338e368af6fa"],
    "IMbnRegistrationEvents": ["dcbbbab6-200a-4bbb-aaee-338e368af6fa"],
    "IMbnServiceActivation": ["dcbbbab6-2017-4bbb-aaee-338e368af6fa"],
    "IMbnServiceActivationEvents": ["dcbbbab6-2018-4bbb-aaee-338e368af6fa"],
    "IMbnSignal": ["dcbbbab6-2003-4bbb-aaee-338e368af6fa"],
    "IMbnSignalEvents": ["dcbbbab6-2004-4bbb-aaee-338e368af6fa"],
    "IMbnSms": ["dcbbbab6-2015-4bbb-aaee-338e368af6fa"],
    "IMbnSmsConfiguration": ["dcbbbab6-2012-4bbb-aaee-338e368af6fa"],
    "IMbnSmsEvents": ["dcbbbab6-2016-4bbb-aaee-338e368af6fa"],
    "IMbnSmsReadMsgPdu": ["dcbbbab6-2013-4bbb-aaee-338e368af6fa"],
    "IMbnSmsReadMsgTextCdma": ["dcbbbab6-2014-4bbb-aaee-338e368af6fa"],
    "IMbnSubscriberInformation": ["459ecc43-bcf5-11dc-a8a8-001321f1405f"],
    "IMbnVendorSpecificEvents": ["dcbbbab6-201a-4bbb-aaee-338e368af6fa"],
    "IMbnVendorSpecificOperation": ["dcbbbab6-2019-4bbb-aaee-338e368af6fa"],
    "IMceBurnerControl": ["5a86b91a-e71e-46c1-88a9-9bb338710552"],
    "IMdmAlert": ["b0fbc327-28c1-4b52-a548-c5807caf70b6"],
    "IMdmAllowPolicyStatics": ["c39709e7-741c-41f2-a4b6-314c31502586"],
    "IMdmPolicyStatics2": ["c99c7526-03d4-49f9-a993-43efccd265c4"],
    "IMdmSession": ["fe89314c-8f64-4797-a9d7-9d88f86ae166"],
    "IMdmSessionManagerStatics": ["cf4ad959-f745-4b79-9b5c-de0bf8efe44b"],
    "IMediaActivityNotifySite": ["8165cfef-179d-46c2-bc71-3fa726dc1f8d"],
    "IMediaBinder": ["2b7e40aa-de07-424f-83f1-f1de46c4fa2e"],
    "IMediaBindingEventArgs": ["b61cb25a-1b6d-4630-a86d-2f0837f712e5"],
    "IMediaBindingEventArgs2": ["0464cceb-bb5a-482f-b8ba-f0284c696567"],
    "IMediaBindingEventArgs3": ["f8eb475e-19be-44fc-a5ed-7aba315037f9"],
    "IMediaBreak": ["714be270-0def-4ebc-a489-6b34930e1558"],
    "IMediaBreakEndedEventArgs": ["32b93276-1c5d-4fee-8732-236dc3a88580"],
    "IMediaBreakFactory": ["4516e002-18e0-4079-8b5f-d33495c15d2e"],
    "IMediaBreakManager": ["a854ddb1-feb4-4d9b-9d97-0fdbe58e5e39"],
    "IMediaBreakSchedule": ["a19a5813-98b6-41d8-83da-f971d22b7bba"],
    "IMediaBreakSeekedOverEventArgs": ["e5aa6746-0606-4492-b9d3-c3c8fde0a4ea"],
    "IMediaBreakSkippedEventArgs": ["6ee94c05-2f54-4a3e-a3ab-24c3b270b4a3"],
    "IMediaBreakStartedEventArgs": ["a87efe71-dfd4-454a-956e-0a4a648395f8"],
    "IMediaBuffer": ["59eff8b9-938c-4a26-82f2-95cb84cdc837"],
    "IMediaCapture": ["c61afbb4-fb10-4a34-ac18-ca80d9c8e7ee"],
    "IMediaCapture2": ["9cc68260-7da1-4043-b652-21b8878daff9"],
    "IMediaCapture3": ["d4136f30-1564-466e-bc0a-af94e02ab016"],
    "IMediaCapture4": ["bacd6fd6-fb08-4947-aea2-ce14eff0ce13"],
    "IMediaCapture5": ["da787c22-3a9b-4720-a71e-97900a316e5a"],
    "IMediaCapture6": ["228948bd-4b20-4bb1-9fd6-a583212a1012"],
    "IMediaCapture7": ["9169f102-8888-541a-95bc-24e4d462542a"],
    "IMediaCaptureDeviceExclusiveControlStatusChangedEventArgs": ["9d2f920d-a588-43c6-89d6-5ad322af006a"],
    "IMediaCaptureFailedEventArgs": ["80fde3f4-54c4-42c0-8d19-cea1a87ca18b"],
    "IMediaCaptureFailedEventHandler": ["2014effb-5cd8-4f08-a314-0d360da59f14"],
    "IMediaCaptureFocusChangedEventArgs": ["81e1bc7f-2277-493e-abee-d3f44ff98c04"],
    "IMediaCaptureInitializationSettings": ["9782ba70-ea65-4900-9356-8ca887726884"],
    "IMediaCaptureInitializationSettings2": ["404e0626-c9dc-43e9-aee4-e6bf1b57b44c"],
    "IMediaCaptureInitializationSettings3": ["4160519d-be48-4730-8104-0cf6e9e97948"],
    "IMediaCaptureInitializationSettings4": ["f502a537-4cb7-4d28-95ed-4f9f012e0518"],
    "IMediaCaptureInitializationSettings5": ["d5a2e3b8-2626-4e94-b7b3-5308a0f64b1a"],
    "IMediaCaptureInitializationSettings6": ["b2e26b47-3db1-4d33-ab63-0ffa09056585"],
    "IMediaCaptureInitializationSettings7": ["41546967-f58a-5d82-9ef4-ed572fb5e34e"],
    "IMediaCapturePauseResult": ["aec47ca3-4477-4b04-a06f-2c1c5182fe9d"],
    "IMediaCaptureRelativePanelWatcher": ["7d896566-04be-5b89-b30e-bd34a9f12db0"],
    "IMediaCaptureSettings": ["1d83aafe-6d45-4477-8dc4-ac5bc01c4091"],
    "IMediaCaptureSettings2": ["6f9e7cfb-fa9f-4b13-9cbe-5ab94f1f3493"],
    "IMediaCaptureSettings3": ["303c67c2-8058-4b1b-b877-8c2ef3528440"],
    "IMediaCaptureStatics": ["acef81ff-99ed-4645-965e-1925cfc63834"],
    "IMediaCaptureStopResult": ["f9db6a2a-a092-4ad1-97d4-f201f9d082db"],
    "IMediaCaptureVideoPreview": ["27727073-549e-447f-a20a-4f03c479d8c0"],
    "IMediaCaptureVideoProfile": ["21a073bf-a3ee-4ecf-9ef6-50b0bc4e1305"],
    "IMediaCaptureVideoProfile2": ["97ddc95f-94ce-468f-9316-fc5bc2638f6b"],
    "IMediaCaptureVideoProfileMediaDescription": ["8012afef-b691-49ff-83f2-c1e76eaaea1b"],
    "IMediaCaptureVideoProfileMediaDescription2": ["c6a6ef13-322d-413a-b85a-68a88e02f4e9"],
    "IMediaClip": ["53f25366-5fba-3ea4-8693-24761811140a"],
    "IMediaClipStatics": ["fa402b68-928f-43c4-bc6e-783a1a359656"],
    "IMediaClipStatics2": ["5b1dd7b3-854e-4d9b-877d-4774a556cd12"],
    "IMediaComposition": ["2e06e605-dc71-41d6-b837-2d2bc14a2947"],
    "IMediaComposition2": ["a59e5372-2366-492c-bec8-e6dfba6d0281"],
    "IMediaCompositionStatics": ["87a08f04-e32a-45ce-8f66-a30df0766224"],
    "IMediaCue": ["c7d15e5d-59dc-431f-a0ee-27744323b36d"],
    "IMediaCueEventArgs": ["d12f47f7-5fa4-4e68-9fe5-32160dcee57e"],
    "IMediaDet": ["65bd0710-24d2-4ff7-9324-ed2e5d3abafa"],
    "IMediaDeviceControl": ["efa8dfa9-6f75-4863-ba0b-583f3036b4de"],
    "IMediaDeviceControlCapabilities": ["23005816-eb85-43e2-b92b-8240d5ee70ec"],
    "IMediaDeviceController": ["f6f8f5ce-209a-48fb-86fc-d44578f317e6"],
    "IMediaDeviceStatics": ["aa2d9a40-909f-4bba-bf8b-0c0d296f14f0"],
    "IMediaElement": ["a38ed2cf-13de-4299-ade2-ae18f74ed353"],
    "IMediaElement2": ["fd53da65-b186-4654-bfdb-180ed26cad07"],
    "IMediaElement3": ["479f6f13-0fdb-4ed8-928a-4d39169c3cd2"],
    "IMediaElementAutomationPeer": ["ba0b9fc2-a6e2-41a5-b17a-d1594613efba"],
    "IMediaElementAutomationPeerFactory": ["b2ad3b28-7575-4173-9bc7-80367a164ed2"],
    "IMediaElementStatics": ["dccd2cb9-7568-4682-a72a-8ddf2a2665ca"],
    "IMediaElementStatics2": ["9ee7f826-f154-4dc6-8014-a6eba987f847"],
    "IMediaEncodingProfile": ["e7dbf5a8-1db9-4783-876b-3dfe12acfdb3"],
    "IMediaEncodingProfile2": ["349b3e0a-4035-488e-9877-85632865ed10"],
    "IMediaEncodingProfile3": ["ba6ebe88-7570-4e69-accf-5611ad015f88"],
    "IMediaEncodingProfileStatics": ["197f352c-2ede-4a45-a896-817a4854f8fe"],
    "IMediaEncodingProfileStatics2": ["ce8de74f-6af4-4288-8fe2-79adf1f79a43"],
    "IMediaEncodingProfileStatics3": ["90dac5aa-cf76-4294-a9ed-1a1420f51f6b"],
    "IMediaEncodingProperties": ["b4002af6-acd4-4e5a-a24b-5d7498a8b8c4"],
    "IMediaEncodingSubtypesStatics": ["37b6580e-a171-4464-ba5a-53189e48c1c8"],
    "IMediaEncodingSubtypesStatics2": ["4b7cd23d-42ff-4d33-8531-0626bee4b52d"],
    "IMediaEncodingSubtypesStatics3": ["ba2414e4-883d-464e-a44f-097da08ef7ff"],
    "IMediaEncodingSubtypesStatics4": ["ddece58a-3949-4644-8a2c-59ef02c642fa"],
    "IMediaEncodingSubtypesStatics5": ["5ad4a007-ffce-4760-9828-5d0c99637e6a"],
    "IMediaEncodingSubtypesStatics6": ["a1252973-a984-5912-93bb-54e7e569e053"],
    "IMediaEngineByteStream": ["8553efe9-667a-4bc6-a59e-448fa2ec1478"],
    "IMediaExtension": ["07915118-45df-442b-8a3f-f7826a6370ab"],
    "IMediaExtensionManager": ["4a25eaf5-242d-4dfb-97f4-69b7c42576ff"],
    "IMediaExtensionManager2": ["5bcebf47-4043-4fed-acaf-54ec29dfb1f7"],
    "IMediaFailedRoutedEventArgs": ["46d1fa8d-5149-4153-ba3c-b03e64ee531e"],
    "IMediaFrame": ["bfb52f8c-5943-47d8-8e10-05308aa5fbd0"],
    "IMediaFrameArrivedEventArgs": ["0b430add-a490-4435-ada1-9affd55239f7"],
    "IMediaFrameFormat": ["71902b4e-b279-4a97-a9db-bd5a2fb78f39"],
    "IMediaFrameFormat2": ["63856340-5e87-4c10-86d1-6df097a6c6a8"],
    "IMediaFrameReader": ["e4c94395-2028-48ed-90b0-d1c1b162e24c"],
    "IMediaFrameReader2": ["871127b3-8531-4050-87cc-a13733cf3e9b"],
    "IMediaFrameReference": ["f6b88641-f0dc-4044-8dc9-961cedd05bad"],
    "IMediaFrameReference2": ["ddbc3ecc-d5b2-49ef-836a-947d989b80c1"],
    "IMediaFrameSource": ["d6782953-90db-46a8-8add-2aa884a8d253"],
    "IMediaFrameSourceController": ["6d076635-316d-4b8f-b7b6-eeb04a8c6525"],
    "IMediaFrameSourceController2": ["efc49fd4-fcf2-4a03-b4e4-ac9628739bee"],
    "IMediaFrameSourceController3": ["1f0cf815-2464-4651-b1e8-4a82dbdb54de"],
    "IMediaFrameSourceGetPropertyResult": ["088616c2-3a64-4bd5-bd2b-e7c898d2f37a"],
    "IMediaFrameSourceGroup": ["7f605b87-4832-4b5f-ae3d-412faab37d34"],
    "IMediaFrameSourceGroupStatics": ["1c48bfc5-436f-4508-94cf-d5d8b7326445"],
    "IMediaFrameSourceInfo": ["87bdc9cd-4601-408f-91cf-038318cd0af3"],
    "IMediaFrameSourceInfo2": ["195a7855-6457-42c6-a769-19b65bd32e6e"],
    "IMediaFrameSourceInfo3": ["ca824ab6-66ea-5885-a2b6-26c0eeec3c7b"],
    "IMediaHolder": ["79eac9ce-baf9-11ce-8c82-00aa004ba90b"],
    "IMediaItemDisplayProperties": ["1e3c1b48-7097-4384-a217-c1291dfa8c16"],
    "IMediaLocator": ["288581e0-66ce-11d2-918f-00c0df10d434"],
    "IMediaMarker": ["1803def8-dca5-4b6f-9c20-e3d3c0643625"],
    "IMediaMarkerTypesStatics": ["bb198040-482f-4743-8832-45853821ece0"],
    "IMediaMarkers": ["afeab189-f8dd-466e-aa10-920b52353fdf"],
    "IMediaObject": ["d8ad0f58-5494-4102-97c5-ec798e59bcf4"],
    "IMediaObjectInPlace": ["651b9ad0-0fc7-4aa9-9538-d89931010741"],
    "IMediaOverlay": ["a902ae5d-7869-4830-8ab1-94dc01c05fa4"],
    "IMediaOverlayFactory": ["b584828a-6188-4f8f-a2e0-aa552d598e18"],
    "IMediaOverlayLayer": ["a6d9ba57-eeda-46c6-bbe5-e398c84168ac"],
    "IMediaOverlayLayerFactory": ["947cb473-a39e-4362-abbf-9f8b5070a062"],
    "IMediaParamInfo": ["6d6cbb60-a223-44aa-842f-a2f06750be6d"],
    "IMediaParams": ["6d6cbb61-a223-44aa-842f-a2f06750be6e"],
    "IMediaPlaybackCommandManager": ["5acee5a6-5cb6-4a5a-8521-cc86b1c1ed37"],
    "IMediaPlaybackCommandManagerAutoRepeatModeReceivedEventArgs": ["3d6f4f23-5230-4411-a0e9-bad94c2a045c"],
    "IMediaPlaybackCommandManagerCommandBehavior": ["786c1e78-ce78-4a10-afd6-843fcbb90c2e"],
    "IMediaPlaybackCommandManagerFastForwardReceivedEventArgs": ["30f064d9-b491-4d0a-bc21-3098bd1332e9"],
    "IMediaPlaybackCommandManagerNextReceivedEventArgs": ["e1504433-a2b0-45d4-b9de-5f42ac14a839"],
    "IMediaPlaybackCommandManagerPauseReceivedEventArgs": ["5ceccd1c-c25c-4221-b16c-c3c98ce012d6"],
    "IMediaPlaybackCommandManagerPlayReceivedEventArgs": ["9af0004e-578b-4c56-a006-16159d888a48"],
    "IMediaPlaybackCommandManagerPositionReceivedEventArgs": ["5591a754-d627-4bdd-a90d-86a015b24902"],
    "IMediaPlaybackCommandManagerPreviousReceivedEventArgs": ["525e3081-4632-4f76-99b1-d771623f6287"],
    "IMediaPlaybackCommandManagerRateReceivedEventArgs": ["18ea3939-4a16-4169-8b05-3eb9f5ff78eb"],
    "IMediaPlaybackCommandManagerRewindReceivedEventArgs": ["9f085947-a3c0-425d-aaef-97ba7898b141"],
    "IMediaPlaybackCommandManagerShuffleReceivedEventArgs": ["50a05cef-63ee-4a96-b7b5-fee08b9ff90c"],
    "IMediaPlaybackDataChangedEventHandler": ["d22f448d-39dc-415f-8325-91eddf0d5264"],
    "IMediaPlaybackDataSource": ["0f4521be-a0b8-4116-b3b1-bfecebaeebe6"],
    "IMediaPlaybackItem": ["047097d2-e4af-48ab-b283-6929e674ece2"],
    "IMediaPlaybackItem2": ["d859d171-d7ef-4b81-ac1f-f40493cbb091"],
    "IMediaPlaybackItem3": ["0d328220-b80a-4d09-9ff8-f87094a1c831"],
    "IMediaPlaybackItemError": ["69fbef2b-dcd6-4df9-a450-dbf4c6f1c2c2"],
    "IMediaPlaybackItemFactory": ["7133fce1-1769-4ff9-a7c1-38d2c4d42360"],
    "IMediaPlaybackItemFactory2": ["d77cdf3a-b947-4972-b35d-adfb931a71e6"],
    "IMediaPlaybackItemFailedEventArgs": ["7703134a-e9a7-47c3-862c-c656d30683d4"],
    "IMediaPlaybackItemOpenedEventArgs": ["cbd9bd82-3037-4fbe-ae8f-39fc39edf4ef"],
    "IMediaPlaybackItemStatics": ["4b1be7f4-4345-403c-8a67-f5de91df4c86"],
    "IMediaPlaybackList": ["7f77ee9c-dc42-4e26-a98d-7850df8ec925"],
    "IMediaPlaybackList2": ["0e09b478-600a-4274-a14b-0b6723d0f48b"],
    "IMediaPlaybackList3": ["dd24bba9-bc47-4463-aa90-c18b7e5ffde1"],
    "IMediaPlaybackSession": ["c32b683d-0407-41ba-8946-8b345a5a5435"],
    "IMediaPlaybackSession2": ["f8ba7c79-1fc8-4097-ad70-c0fa18cc0050"],
    "IMediaPlaybackSession3": ["7ba2b41a-a3e2-405f-b77b-a4812c238b66"],
    "IMediaPlaybackSessionBufferingStartedEventArgs": ["cd6aafed-74e2-43b5-b115-76236c33791a"],
    "IMediaPlaybackSessionOutputDegradationPolicyState": ["558e727d-f633-49f9-965a-abaa1db709be"],
    "IMediaPlaybackSource": ["ef9dc2bc-9317-4696-b051-2bad643177b5"],
    "IMediaPlaybackSphericalVideoProjection": ["d405b37c-6f0e-4661-b8ee-d487ba9752d5"],
    "IMediaPlaybackTimedMetadataTrackList": ["72b41319-bbfb-46a3-9372-9c9c744b9438"],
    "IMediaPlayer": ["381a83cb-6fff-499b-8d64-2885dfc1249e"],
    "IMediaPlayer2": ["3c841218-2123-4fc5-9082-2f883f77bdf5"],
    "IMediaPlayer3": ["ee0660da-031b-4feb-bd9b-92e0a0a8d299"],
    "IMediaPlayer4": ["80035db0-7448-4770-afcf-2a57450914c5"],
    "IMediaPlayer5": ["cfe537fd-f86a-4446-bf4d-c8e792b7b4b3"],
    "IMediaPlayer6": ["e0caa086-ae65-414c-b010-8bc55f00e692"],
    "IMediaPlayer7": ["5d1dc478-4500-4531-b3f4-777a71491f7f"],
    "IMediaPlayerDataReceivedEventArgs": ["c75a9405-c801-412a-835b-83fc0e622a8e"],
    "IMediaPlayerEffects": ["85a1deda-cab6-4cc0-8be3-6035f4de2591"],
    "IMediaPlayerEffects2": ["fa419a79-1bbe-46c5-ae1f-8ee69fb3c2c7"],
    "IMediaPlayerElement": ["3b4ca526-2e25-4598-bc71-d491f8e8de39"],
    "IMediaPlayerElementAutomationPeer": ["02bed209-3f65-4fdd-b5ca-c4750d4e6ea4"],
    "IMediaPlayerElementAutomationPeerFactory": ["08848077-82af-4d19-b170-282a9e0e7f37"],
    "IMediaPlayerElementFactory": ["77e525c3-eb17-4b8d-889d-1ea8abdbd4ef"],
    "IMediaPlayerElementStatics": ["1e7c4020-ac57-42dd-ad1c-3ebc2d7f08ba"],
    "IMediaPlayerFailedEventArgs": ["2744e9b9-a7e3-4f16-bac4-7914ebc08301"],
    "IMediaPlayerPresenter": ["77a92326-0c5b-41fc-bf49-15f6c3524b6b"],
    "IMediaPlayerPresenterFactory": ["e6766fb7-d96f-4b95-b33c-59e81cb1e9ba"],
    "IMediaPlayerPresenterStatics": ["84d774fe-ead4-4957-b42b-223158ca0de7"],
    "IMediaPlayerRateChangedEventArgs": ["40600d58-3b61-4bb2-989f-fc65608b6cab"],
    "IMediaPlayerSource": ["bd4f8897-1423-4c3e-82c5-0fb1af94f715"],
    "IMediaPlayerSource2": ["82449b9f-7322-4c0b-b03b-3e69a48260c5"],
    "IMediaPlayerSurface": ["0ed653bc-b736-49c3-830b-764a3845313a"],
    "IMediaProcessingTrigger": ["9a95be65-8a52-4b30-9011-cf38040ea8b0"],
    "IMediaProcessingTriggerDetails": ["eb8564ac-a351-4f4e-b4f0-9bf2408993db"],
    "IMediaPropertiesChangedEventArgs": ["7d3741cb-adf0-5cef-91ba-cfabcdd77678"],
    "IMediaProtectionManager": ["45694947-c741-434b-a79e-474c12d93d2f"],
    "IMediaProtectionPMPServer": ["0c111226-7b26-4d31-95bb-9c1b08ef7fc0"],
    "IMediaProtectionPMPServerFactory": ["602c8e5e-f7d2-487e-af91-dbc4252b2182"],
    "IMediaProtectionServiceCompletion": ["8b5cca18-cfd5-44ee-a2ed-df76010c14b5"],
    "IMediaProtectionServiceRequest": ["b1de0ea6-2094-478d-87a4-8b95200f85c6"],
    "IMediaQuery": ["30510749-98b5-11cf-bb82-00aa00bdce0b"],
    "IMediaRadioManager": ["6cfdcab5-fc47-42a5-9241-074b58830e73"],
    "IMediaRadioManagerNotifySink": ["89d81f5f-c147-49ed-a11c-77b20c31e7c9"],
    "IMediaRatio": ["d2d0fee5-8929-401d-ac78-7d357e378163"],
    "IMediaRenderer": ["2c012ec3-d975-47fb-96ac-a6418b326d2b"],
    "IMediaRendererActionInformation": ["66fbbfee-5ab0-4a4f-8d15-e5056b26beda"],
    "IMediaRendererBrokerStatics": ["19974cb1-9a1d-45c0-87cf-2c1e835a981c"],
    "IMediaRendererFactory": ["657ab43d-b909-42b2-94d0-e3a0b134e8c9"],
    "IMediaSample2Config": ["68961e68-832b-41ea-bc91-63593f3e70e3"],
    "IMediaSource": ["e7bfb599-a09d-4c21-bcdf-20af4f86b3d9"],
    "IMediaSource2": ["2eb61048-655f-4c37-b813-b4e45dfa0abe"],
    "IMediaSource3": ["b59f0d9b-4b6e-41ed-bbb4-7c7509a994ad"],
    "IMediaSource4": ["bdafad57-8eff-4c63-85a6-84de0ae3e4f2"],
    "IMediaSource5": ["331a22ae-ed2e-4a22-94c8-b743a92b3022"],
    "IMediaSourceAppServiceConnection": ["61e1ea97-1916-4810-b7f4-b642be829596"],
    "IMediaSourceAppServiceConnectionFactory": ["65b912eb-80b9-44f9-9c1e-e120f6d92838"],
    "IMediaSourceAudioInputNode": ["99d8983b-a88a-4041-8e4f-ddbac0c91fd3"],
    "IMediaSourceError": ["5c0a8965-37c5-4e9d-8d21-1cdee90cecc6"],
    "IMediaSourceOpenOperationCompletedEventArgs": ["fc682ceb-e281-477c-a8e0-1acd654114c8"],
    "IMediaSourceStateChangedEventArgs": ["0a30af82-9071-4bac-bc39-ca2a93b717a9"],
    "IMediaSourceStatics": ["f77d6fa4-4652-410e-b1d8-e9a5e245a45c"],
    "IMediaSourceStatics2": ["eee161a4-7f13-4896-b8cb-df0de5bcb9f1"],
    "IMediaSourceStatics3": ["453a30d6-2bea-4122-9f73-eace04526e35"],
    "IMediaSourceStatics4": ["281b3bfc-e50a-4428-a500-9c4ed918d3f0"],
    "IMediaStream": ["b502d1bd-9a57-11d0-8fde-00c04fd9189d"],
    "IMediaStreamDescriptor": ["80f16e6e-92f7-451e-97d2-afd80742da70"],
    "IMediaStreamDescriptor2": ["5073010f-e8b2-4071-b00b-ebf337a76b58"],
    "IMediaStreamFilter": ["bebe595e-9a6f-11d0-8fde-00c04fd9189d"],
    "IMediaStreamSample": ["5c8db627-4b80-4361-9837-6cb7481ad9d6"],
    "IMediaStreamSample2": ["45078691-fce8-4746-a1c8-10c25d3d7cd3"],
    "IMediaStreamSampleProtectionProperties": ["4eb88292-ecdf-493e-841d-dd4add7caca2"],
    "IMediaStreamSampleStatics": ["dfdf218f-a6cf-4579-be41-73dd941ad972"],
    "IMediaStreamSampleStatics2": ["9efe9521-6d46-494c-a2f8-d662922e2dd7"],
    "IMediaStreamSource": ["3712d543-45eb-4138-aa62-c01e26f3843f"],
    "IMediaStreamSource2": ["ec55d0ad-2e6a-4f74-adbb-b562d1533849"],
    "IMediaStreamSource3": ["6a2a2746-3ddd-4ddf-a121-94045ecf9440"],
    "IMediaStreamSource4": ["1d0cfcab-830d-417c-a3a9-2454fd6415c7"],
    "IMediaStreamSourceClosedEventArgs": ["cd8c7eb2-4816-4e24-88f0-491ef7386406"],
    "IMediaStreamSourceClosedRequest": ["907c00e9-18a3-4951-887a-2c1eebd5c69e"],
    "IMediaStreamSourceFactory": ["ef77e0d9-d158-4b7a-863f-203342fbfd41"],
    "IMediaStreamSourceSampleRenderedEventArgs": ["9d697b05-d4f2-4c7a-9dfe-8d6cd0b3ee84"],
    "IMediaStreamSourceSampleRequest": ["4db341a9-3501-4d9b-83f9-8f235c822532"],
    "IMediaStreamSourceSampleRequestDeferral": ["7895cc02-f982-43c8-9d16-c62d999319be"],
    "IMediaStreamSourceSampleRequestedEventArgs": ["10f9bb9e-71c5-492f-847f-0da1f35e81f8"],
    "IMediaStreamSourceStartingEventArgs": ["f41468f2-c274-4940-a5bb-28a572452fa7"],
    "IMediaStreamSourceStartingRequest": ["2a9093e4-35c4-4b1b-a791-0d99db56dd1d"],
    "IMediaStreamSourceStartingRequestDeferral": ["3f1356a5-6340-4dc4-9910-068ed9f598f8"],
    "IMediaStreamSourceSwitchStreamsRequest": ["41b8808e-38a9-4ec3-9ba0-b69b85501e90"],
    "IMediaStreamSourceSwitchStreamsRequestDeferral": ["bee3d835-a505-4f9a-b943-2b8cb1b4bbd9"],
    "IMediaStreamSourceSwitchStreamsRequestedEventArgs": ["42202b72-6ea1-4677-981e-350a0da412aa"],
    "IMediaTimelineController": ["8ed361f3-0b78-4360-bf71-0c841999ea1b"],
    "IMediaTimelineController2": ["ef74ea38-9e72-4df9-8355-6e90c81bbadd"],
    "IMediaTimelineControllerFailedEventArgs": ["8821f81d-3e77-43fb-be26-4fc87a044834"],
    "IMediaTrack": ["03e1fafc-c931-491a-b46b-c10ee8c256b7"],
    "IMediaTranscoder": ["190c99d2-a0aa-4d34-86bc-eed1b12c2f5b", "59007c49-cb25-4bd5-aad9-6943f08f4f9e"],
    "IMediaTranscoder2": ["40531d74-35e0-4f04-8574-ca8bc4e5a082"],
    "IMediaTransportControls": ["d6f69e7d-0825-49a9-9fce-5586d8694f0c"],
    "IMediaTransportControls2": ["2b89efec-1bea-451e-8bcd-cfe2d9423262"],
    "IMediaTransportControls3": ["5086430e-0940-11e7-93ae-92361f002671"],
    "IMediaTransportControls4": ["0fb17c58-9f23-11e7-abc4-cec278b6b50a"],
    "IMediaTransportControlsAutomationPeer": ["a3ad8d93-79f8-4958-a3c8-980defb83d15"],
    "IMediaTransportControlsAutomationPeerFactory": ["f41cb003-e103-4ab0-812a-a08fbdb570ce"],
    "IMediaTransportControlsFactory": ["1da2015a-a8e4-4c1b-88c9-0b183ecc62e3"],
    "IMediaTransportControlsHelper": ["3d41d509-ff44-4420-807e-8f7a2e2c4251"],
    "IMediaTransportControlsHelperStatics": ["5a772047-a9a1-4625-9270-7f49875d4394"],
    "IMediaTransportControlsStatics": ["590ea907-d2ef-4c1a-9429-b4b15d64fd56"],
    "IMediaTransportControlsStatics2": ["1728cfdc-561f-4386-a7f8-090d95f68d96"],
    "IMediaTransportControlsStatics3": ["5fe05542-0940-11e7-93ae-92361f002671"],
    "IMediaTransportControlsStatics4": ["0fb18144-9f23-11e7-abc4-cec278b6b50a"],
    "IMediaTransportControlsThumbnailRequestedEventArgs": ["e4a8b21c-e3c2-485c-ae69-f1537b76755a"],
    "IMemAllocatorCallbackTemp": ["379a0cf0-c1de-11d2-abf5-00a0c905f375"],
    "IMemAllocatorNotifyCallbackTemp": ["92980b30-c1de-11d2-abf5-00a0c905f375"],
    "IMemberOfIESession": ["0e4e1084-4290-4e24-bb44-31f0b9f9f9c4"],
    "IMemoryBuffer": ["fbc4dd2a-245b-11e4-af98-689423260cf8"],
    "IMemoryBufferFactory": ["fbc4dd2b-245b-11e4-af98-689423260cf8"],
    "IMemoryBufferReference": ["fbc4dd29-245b-11e4-af98-689423260cf8"],
    "IMemoryData": ["327fc560-af60-11d0-8212-00c04fc32c45"],
    "IMemoryManagerStatics": ["5c6c279c-d7ca-4779-9188-4057219ce64c"],
    "IMemoryManagerStatics2": ["6eee351f-6d62-423f-9479-b01f9c9f7669"],
    "IMemoryManagerStatics3": ["149b59ce-92ad-4e35-89eb-50dfb4c0d91c"],
    "IMemoryManagerStatics4": ["c5a94828-e84e-4886-8a0d-44b3190e3b72"],
    "IMemoryMappedCache": ["13a1f996-c8d8-4bb9-99f2-6e499e692736"],
    "IMemoryMappedCacheMgr": ["ecf31d61-e474-453c-bee7-de68e441c6d0"],
    "IMemoryMappedHeap": ["8f2b137c-34bb-490d-9cf8-c8c4e8184de6"],
    "IMemoryViewLangServiceInterop": ["e5776e42-0966-11d3-b87f-00c04f79e479"],
    "IMenuBar": ["c8f67b0c-0e76-5af2-bade-785049c80a41"],
    "IMenuBarAutomationPeer": ["4b6adcf1-f274-5592-85a8-7b099e99b320"],
    "IMenuBarAutomationPeerFactory": ["2a094871-4a9b-5a0b-9fda-7bc3ae957c53"],
    "IMenuBarFactory": ["dc619e50-72ba-513f-80aa-ddd093825dde"],
    "IMenuBarItem": ["bf643b4c-8125-5b53-a454-06e896a5acee"],
    "IMenuBarItemAutomationPeer": ["0fce49b4-cff5-5c4b-98ee-e75fdddf799a"],
    "IMenuBarItemAutomationPeerFactory": ["c9c77746-130f-5b19-83a6-61db584613aa"],
    "IMenuBarItemFactory": ["ecf86f62-c394-50e2-a568-17af8cf26874"],
    "IMenuBarItemFlyout": ["ed00d2d8-b686-55fe-8dbb-f04a640e42ef"],
    "IMenuBarItemFlyoutFactory": ["1d24f9bd-bd19-5d95-b573-711f649fcbe9"],
    "IMenuBarItemStatics": ["60a9e3fb-b405-50d0-bb78-d396a34da267"],
    "IMenuBarStatics": ["bed31c25-7db8-51cc-9706-1d79327daf93"],
    "IMenuFlyout": ["ad3210f1-985b-4171-bbba-67bcc729649b"],
    "IMenuFlyout2": ["507c7bad-d9d1-4c05-9d4b-cda8de9ab242"],
    "IMenuFlyoutFactory": ["644533ab-bbb9-499b-9ff3-30d40e2c56d8"],
    "IMenuFlyoutItem": ["160775cf-b598-44af-a488-c3ce2af6d3f0"],
    "IMenuFlyoutItem2": ["0ae266eb-028c-4423-a8e3-989fd9dd7126"],
    "IMenuFlyoutItem3": ["9727b2e3-b2b6-49dc-8c22-e0138b941559"],
    "IMenuFlyoutItemAutomationPeer": ["1fc19462-21df-456e-aa11-8fac6b4b2af6"],
    "IMenuFlyoutItemAutomationPeerFactory": ["d08bfcb8-20d1-45d8-a2c2-2f130df714e0"],
    "IMenuFlyoutItemBase": ["f9b56047-8da6-4730-9208-144125c6b396"],
    "IMenuFlyoutItemBaseFactory": ["83e6dbad-fc67-41d5-8797-60acd1ceb1d9"],
    "IMenuFlyoutItemFactory": ["c5aa39e2-44f3-455e-9c5b-62bb6afce3ad"],
    "IMenuFlyoutItemStatics": ["4950b424-a43a-41f7-aa3a-9ce9619747d5"],
    "IMenuFlyoutItemStatics2": ["aca4f564-1790-4601-916e-5ae1f01f4bd6"],
    "IMenuFlyoutItemStatics3": ["d83fd7c3-0aeb-4ef3-8270-8b9b95f2b298"],
    "IMenuFlyoutItemTemplateSettings": ["56ad1809-3a16-4147-81cb-d0b35c834e0f"],
    "IMenuFlyoutPresenter": ["906e0304-254e-413f-b219-c7b97f003752"],
    "IMenuFlyoutPresenter2": ["895894df-5a9f-4a1f-85ec-6f3c1b6dcb89"],
    "IMenuFlyoutPresenter3": ["6afd4e16-aee0-584a-9849-edaa323a484f"],
    "IMenuFlyoutPresenterAutomationPeer": ["e244a871-fcbb-48fc-8a93-41ea134b53ce"],
    "IMenuFlyoutPresenterAutomationPeerFactory": ["07b5172d-761d-452b-9e6d-fa2a8be0ad26"],
    "IMenuFlyoutPresenterFactory": ["b88b5091-101c-41f8-aac1-1b105c14fb99"],
    "IMenuFlyoutPresenterStatics3": ["3772a818-825a-520c-80ae-4d39a2d59ab5"],
    "IMenuFlyoutPresenterTemplateSettings": ["d68fd00d-629d-4349-ac51-b877c80983b8"],
    "IMenuFlyoutSeparator": ["71fa2b7d-0b51-4950-a1a4-bbc42eac4c12"],
    "IMenuFlyoutSeparatorFactory": ["c159dcc8-b437-44e0-b24b-5720aea1dbac"],
    "IMenuFlyoutStatics": ["3dbefba1-9522-4045-9e58-c99b13aab9b9"],
    "IMenuFlyoutSubItem": ["e5386550-fe2c-43e2-a73f-62168f619973"],
    "IMenuFlyoutSubItem2": ["ac935626-190a-4de2-8d71-7cc4747da580"],
    "IMenuFlyoutSubItemStatics": ["ddb27a36-1874-4aef-837d-6fec9da4e681"],
    "IMenuFlyoutSubItemStatics2": ["ac14d09b-3e93-4785-94ef-fdb23baba965"],
    "IMessageDialog": ["33f59b01-5325-43ab-9ab3-bdae440e4121"],
    "IMessageDialogFactory": ["2d161777-a66f-4ea5-bb87-793ffa4941f2"],
    "IMessageDispatcher": ["f5f84c8f-cfd0-4cd6-b66b-c5d26ff1689d"],
    "IMessageRaw": ["0002038a-0000-0000-c000-000000000046"],
    "IMessageReceivedCallback": ["f5b4c8ff-1d9d-4995-9fea-4d15257c0757"],
    "IMessageReceivedHandler": ["efab0782-f6e2-4675-a045-d8e320c24808"],
    "IMessageTransmittedHandler": ["efaa0b4a-f6e2-4d7d-856c-78fc8efc021e"],
    "IMessageWebSocket": ["33727d08-34d5-4746-ad7b-8dde5bc2ef88"],
    "IMessageWebSocket2": ["bed0cee7-f9c8-440a-9ad5-737281d9742e"],
    "IMessageWebSocket3": ["59d9defb-71af-4349-8487-911fcf681597"],
    "IMessageWebSocketControl": ["8118388a-c629-4f0a-80fb-81fc05538862"],
    "IMessageWebSocketControl2": ["e30fd791-080c-400a-a712-27dfa9e744d8"],
    "IMessageWebSocketMessageReceivedEventArgs": ["478c22ac-4c4b-42ed-9ed7-1ef9f94fa3d5"],
    "IMessageWebSocketMessageReceivedEventArgs2": ["89ce06fd-dd6f-4a07-87f9-f9eb4d89d83d"],
    "IMessages": ["cd000025-8b95-11d1-82db-00c04fb1625d"],
    "IMetaDataInfo": ["7998ea64-7f95-48b8-86fc-17caf48bf5cb"],
    "IMetaDataRegEmit": ["601c95b9-7398-11d2-9771-00a0c9b4d50c"],
    "IMetaDataRegEmitOld": ["f28f419b-62ca-11d2-8f2c-00a0c9a6186d"],
    "IMetaDataRegImport": ["4398b4fd-7399-11d2-9771-00a0c9b4d50c"],
    "IMetaDataRegImportOld": ["f28f419a-62ca-11d2-8f2c-00a0c9a6186d"],
    "IMetaDataWinMDImport": ["969ea0c5-964e-411b-a807-b0f3c2dfcbd4"],
    "IMethodMalloc": ["a0efb28b-6ee2-4d7b-b983-a75ef7beedb8"],
    "IMicrosoftAccountMultiFactorAuthenticationManager": ["0fd340a5-f574-4320-a08e-0a19a82322aa"],
    "IMicrosoftAccountMultiFactorAuthenticatorStatics": ["d964c2e6-f446-4c71-8b79-6ea4024aa9b8"],
    "IMicrosoftAccountMultiFactorGetSessionsResult": ["4e23a9a0-e9fa-497a-95de-6d5747bf974c"],
    "IMicrosoftAccountMultiFactorOneTimeCodedInfo": ["82ba264b-d87c-4668-a976-40cfae547d08"],
    "IMicrosoftAccountMultiFactorSessionInfo": ["5f7eabb4-a278-4635-b765-b494eb260af4"],
    "IMicrosoftAccountMultiFactorUnregisteredAccountsAndSessionInfo": ["aa7ec5fb-da3f-4088-a20d-5618afadb2e5"],
    "IMidiChannelPressureMessage": ["be1fa860-62b4-4d52-a37e-92e54d35b909"],
    "IMidiChannelPressureMessageFactory": ["6218ed2f-2284-412a-94cf-10fb04842c6c"],
    "IMidiControlChangeMessage": ["b7e15f83-780d-405f-b781-3e1598c97f40"],
    "IMidiControlChangeMessageFactory": ["2ab14321-956c-46ad-9752-f87f55052fe3"],
    "IMidiInPort": ["d5c1d9db-971a-4eaf-a23d-ea19fe607ff9"],
    "IMidiInPortStatics": ["44c439dc-67ff-4a6e-8bac-fdb6610cf296"],
    "IMidiMessage": ["79767945-1094-4283-9be0-289fc0ee8334"],
    "IMidiMessageReceivedEventArgs": ["76566e56-f328-4b51-907d-b3a8ce96bf80"],
    "IMidiNoteOffMessage": ["16fd8af4-198e-4d8f-a654-d305a293548f"],
    "IMidiNoteOffMessageFactory": ["a6b240e0-a749-425f-8af4-a4d979cc15b5"],
    "IMidiNoteOnMessage": ["e0224af5-6181-46dd-afa2-410004c057aa"],
    "IMidiNoteOnMessageFactory": ["9b4280a0-59c1-420e-b517-15a10aa9606b"],
    "IMidiOutPort": ["931d6d9f-57a2-4a3a-adb8-4640886f6693"],
    "IMidiOutPortStatics": ["065cc3e9-0f88-448b-9b64-a95826c65b8f"],
    "IMidiPitchBendChangeMessage": ["29df4cb1-2e9f-4faf-8c2b-9cb82a9079ca"],
    "IMidiPitchBendChangeMessageFactory": ["f5eedf55-cfc8-4926-b30e-a3622393306c"],
    "IMidiPolyphonicKeyPressureMessage": ["1f7337fe-ace8-48a0-868e-7cdbf20f04d6"],
    "IMidiPolyphonicKeyPressureMessageFactory": ["e98f483e-c4b3-4dd2-917c-e349815a1b3b"],
    "IMidiProgramChangeMessage": ["9cbb3c78-7a3e-4327-aa98-20b8e4485af8"],
    "IMidiProgramChangeMessageFactory": ["d6b04387-524b-4104-9c99-6572bfd2e261"],
    "IMidiSongPositionPointerMessage": ["4ca50c56-ec5e-4ae4-a115-88dc57cc2b79"],
    "IMidiSongPositionPointerMessageFactory": ["9c00e996-f10b-4fea-b395-f5d6cf80f64e"],
    "IMidiSongSelectMessage": ["49f0f27f-6d83-4741-a5bf-4629f6be974f"],
    "IMidiSongSelectMessageFactory": ["848878e4-8748-4129-a66c-a05493f75daa"],
    "IMidiSynthesizer": ["f0da155e-db90-405f-b8ae-21d2e17f2e45"],
    "IMidiSynthesizerStatics": ["4224eaa8-6629-4d6b-aa8f-d4521a5a31ce"],
    "IMidiSystemExclusiveMessageFactory": ["083de222-3b74-4320-9b42-0ca8545f8a24"],
    "IMidiTimeCodeMessage": ["0bf7087d-fa63-4a1c-8deb-c0e87796a6d7"],
    "IMidiTimeCodeMessageFactory": ["eb3099c5-771c-40de-b961-175a7489a85e"],
    "IMigratedIdentityConnector": ["da13a187-4301-43be-85b4-e385699d3099"],
    "IMiniHwndProxy": ["393f766c-d5ef-4cba-bb23-935166dc30b8"],
    "IMiniport": ["b4c90a24-5791-11d0-86f9-00a0c911b544"],
    "IMiniportAudioEngineNode": ["2ebf536c-ef57-4c64-bedc-25c1a6d668e6"],
    "IMiniportAudioSignalProcessing": ["b532678c-be50-472d-9973-8a6f16594989"],
    "IMiniportDMus": ["c096df9d-fb09-11d1-81b0-0060083316c1", "c096df9d-fb09-11d1-81b0-0060083316c1"],
    "IMiniportMidi": ["b4c90a41-5791-11d0-86f9-00a0c911b544"],
    "IMiniportMidiStream": ["b4c90a42-5791-11d0-86f9-00a0c911b544"],
    "IMiniportPnpNotify": ["6b735365-9487-464c-93e3-fa2c6391d5a4"],
    "IMiniportStreamAudioEngineNode": ["bd6eeb4b-e6e5-40fd-8d5a-5b1dcde20c42"],
    "IMiniportStreamAudioEngineNode2": ["aeb7f86a-6cba-44cf-a2d2-b3fa5b696817"],
    "IMiniportTopology": ["b4c90a31-5791-11d0-86f9-00a0c911b544"],
    "IMiniportWaveCyclic": ["b4c90a27-5791-11d0-86f9-00a0c911b544"],
    "IMiniportWaveCyclicStream": ["b4c90a28-5791-11d0-86f9-00a0c911b544"],
    "IMiniportWavePci": ["b4c90a52-5791-11d0-86f9-00a0c911b544"],
    "IMiniportWavePciStream": ["b4c90a53-5791-11d0-86f9-00a0c911b544"],
    "IMiniportWaveRT": ["0f9fc4d6-6061-4f3c-b1fc-075e35f7960a"],
    "IMiniportWaveRTInputStream": ["cd8e756a-5fc7-4624-984b-2af02925b91f"],
    "IMiniportWaveRTOutputStream": ["831fc7bc-6347-44bc-b47b-c0c657b5bf73"],
    "IMiniportWaveRTStream": ["000ac9ab-faab-4f3d-9455-6ff8306a74a0"],
    "IMiniportWaveRTStreamNotification": ["23759128-96f1-423b-ab4d-81635bcf8ca1"],
    "IMiracastReceiver": ["7a315258-e444-51b4-aff7-b88daa1229e0"],
    "IMiracastReceiverApplySettingsResult": ["d0aa6272-09cd-58e1-a4f2-5d5143d312f9"],
    "IMiracastReceiverConnection": ["704b2f36-d2e5-551f-a854-f822b7917d28"],
    "IMiracastReceiverConnectionCreatedEventArgs": ["7d8dfa39-307a-5c0f-94bd-d0c69d169982"],
    "IMiracastReceiverCursorImageChannel": ["d9ac332d-723a-5a9d-b90a-81153efa2a0f"],
    "IMiracastReceiverCursorImageChannelSettings": ["ccdbedff-bd00-5b9c-8e4c-00cacf86b634"],
    "IMiracastReceiverDisconnectedEventArgs": ["d9a15e5e-5fee-57e6-b4b0-04727db93229"],
    "IMiracastReceiverGameControllerDevice": ["2d7171e8-bed4-5118-a058-e2477eb5888d"],
    "IMiracastReceiverInputDevices": ["da35bb02-28aa-5ee8-96f5-a42901c66f00"],
    "IMiracastReceiverKeyboardDevice": ["beb67272-06c0-54ff-ac96-217464ff2501"],
    "I