# Copyright 2024 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.


COM_CLASSES: dict[str, list[str]] = {
    "ClusAppWiz": ["24F97150-6689-11D1-9AA7-00C04FB93A80"],
    "ClusCfgAddNodesWizard": ["BB8D141E-C00A-469F-BC5C-ECD814F0BD74"],
    "ClusCfgCreateClusterWizard": ["B929818E-F5B0-44DC-8A00-1B5F5F5AA1F0"],
    "ClusCfgResTypeServices": ["6A370489-BB52-4727-B740-08F494163478"],
    "ThumbnailUpdater": ["A3C63918-889D-11D1-83E9-00C04FC2C6D4"],
    "ThumbnailFCNHandler": ["CEFC65D8-66D8-11D1-8D8C-0000F804B057"],
    "GblComponentCategoriesMgr": ["0002E006-0000-0000-C000-000000000046"],
    "StdPicture": ["0BE35204-8F91-11CE-9DE3-00AA004BB851"],
    "StdFont": ["0BE35203-8F91-11CE-9DE3-00AA004BB851"],
    "ConvertVBX": ["FB8F0822-0164-101B-84ED-08002B2EC713"],
    "PersistPropset": ["FB8F0821-0164-101B-84ED-08002B2EC713"],
    "StockPicturePage": ["7EBDAAE2-8120-11CF-899F-00AA00688B10"],
    "StockColorPage": ["7EBDAAE1-8120-11CF-899F-00AA00688B10"],
    "StockFontPage": ["7EBDAAE0-8120-11CF-899F-00AA00688B10"],
    "CPicturePropPage": ["0BE35202-8F91-11CE-9DE3-00AA004BB851"],
    "CColorPropPage": ["0BE35201-8F91-11CE-9DE3-00AA004BB851"],
    "CFontPropPage": ["0BE35200-8F91-11CE-9DE3-00AA004BB851"],
    "AddrControl": ["00000348-0000-0000-C000-000000000046"],
    "CurrentUserClasses": ["00000332-0000-0000-C000-000000000046"],
    "LocalMachineClasses": ["00000331-0000-0000-C000-000000000046"],
    "AllClasses": ["00000330-0000-0000-C000-000000000046"],
    "RemoteUnknownPSFactory": ["00000340-0000-0000-C000-000000000046"],
    "InProcFreeMarshaler": ["0000033A-0000-0000-C000-000000000046", "0000001C-0000-0000-C000-000000000046"],
    "StdAsyncActManager": ["00000329-0000-0000-C000-000000000046"],
    "ComBinding": ["00000328-0000-0000-C000-000000000046"],
    "SynchronizeContainer": ["0000032D-0000-0000-C000-000000000046"],
    "StdEvent": ["0000032B-0000-0000-C000-000000000046"],
    "ManualResetEvent": ["0000032C-0000-0000-C000-000000000046"],
    "StdGlobalInterfaceTable": ["00000323-0000-0000-C000-000000000046"],
    "DCOMAccessControl": ["0000031D-0000-0000-C000-000000000046"],
    "Picture_Dib": ["00000316-0000-0000-C000-000000000046"],
    "Picture_EnhMetafile": ["00000319-0000-0000-C000-000000000046"],
    "Picture_Metafile": ["00000315-0000-0000-C000-000000000046"],
    "PSEnumerators": ["00000313-0000-0000-C000-000000000046"],
    "PSBindCtx": ["00000312-0000-0000-C000-000000000046"],
    "PSDragDrop": ["00000311-0000-0000-C000-000000000046"],
    "PSInPlaceFrame": ["00000310-0000-0000-C000-000000000046"],
    "PSInPlaceActive": ["0000030F-0000-0000-C000-000000000046"],
    "PSClassObject": ["0000030E-0000-0000-C000-000000000046"],
    "PSClientSite": ["0000030D-0000-0000-C000-000000000046"],
    "PSGenObject": ["0000030C-0000-0000-C000-000000000046"],
    "StdMarshal": ["00000017-0000-0000-C000-000000000046"],
    "TrkRestoreParser": ["755939E4-E381-11D0-B1C5-00C04FB9386D"],
    "TrkRestoreNotify": ["D0056F6C-E2A0-11D0-B1C2-00C04FB9386D"],
    "TrkForceOwnership": ["A2531F45-C67D-11D0-8CB1-00C04FD90F85"],
    "TrackFile": ["8790C947-A30B-11D0-8CAB-00C04FD90F85"],
    "CEnroll2": ["127698E4-E730-4E5C-A2B1-21490A70C8A1"],
    "CEnroll": ["43F8F289-7A20-11D0-8F06-00C04FC295E1"],
    "SyncMgr": ["6295DF27-35EE-11D1-8707-00C04FD93327"],
    "SENS": ["D597CAFE-5B9F-11D1-8DD2-00AA004ABD5E"],
    "OLEDB_ROWPOSITIONLIBRARY": ["2048EEE6-7FA2-11D0-9E6A-00A0C9138C29"],
    "OLEDB_CONVERSIONLIBRARY": ["C8B522D1-5CF3-11CE-ADE5-00AA0044773D"],
    "MSDAVTM": ["0C733A8E-2A1C-11CE-ADE5-00AA0044773D"],
    "EXTENDEDERRORINFO": ["C8B522CF-5CF3-11CE-ADE5-00AA0044773D"],
    "OLEDB_ENUMERATOR": ["C8B522D0-5CF3-11CE-ADE5-00AA0044773D"],
    "XMLParser30": ["F5078F31-C551-11D3-89B9-0000F81FE221"],
    "XMLParser26": ["F5078F20-C551-11D3-89B9-0000F81FE221"],
    "XMLParser": ["F5078F19-C551-11D3-89B9-0000F81FE221"],
    "XMLDocument": ["CFC399AF-D876-11D0-9C10-00C04FC99C8E"],
    "XMLDSOControl": ["550DDA30-0541-11D2-9CA9-0060B0EC3D39"],
    "XMLHTTPRequest": ["ED8C108E-4349-11D2-91A4-00C04F7969E8"],
    "DOMFreeThreadedDocument": ["2933BF91-7B36-11D2-B20E-00C04F983E60"],
    "DOMDocument": ["2933BF90-7B36-11D2-B20E-00C04F983E60"],
    "DefaultDebugSessionProvider": ["834128A2-51F4-11D0-8F20-00805F2CD064"],
    "MachineDebugManager": ["0C0A3666-30C9-11D0-8F20-00805F2CD064"],
    "CDebugDocumentHelper": ["83B8BCA6-687C-11D0-A405-00AA0060275C"],
    "DebugHelper": ["0BFCC060-8C1D-11D0-ACCD-00AA0060275C"],
    "ProcessDebugManager": ["78A51822-51F4-11D0-8F20-00805F2CD064"],
    "MailAutoDiscovery": ["008FD5DD-6DBB-48E3-991B-2D3ED658516A"],
    "MailProtocolADEntry": ["61A5D6F3-C131-4C35-BF40-90A50F214122"],
    "AccountDiscovery": ["3DAB30ED-8132-40BF-A8BA-7B5057F0CD10"],
    "AutoDiscoveryProvider": ["C4F3D5BF-4809-44E3-84A4-368B6B33B0B4"],
    "CActiveIMM": ["4955DD33-B159-11D0-8FCF-00AA006BCC59"],
    "DXTICMFilterPP": ["1958FB12-31E6-47E5-AA49-B23D12C853E6"],
    "DXTICMFilter": ["A1BFB370-5A9F-4429-BB72-B13E2FEAEDEF"],
    "DXTMatrixPP": ["C591103A-B3A8-4D47-A3F7-2AEEE4B8013F"],
    "DXTMatrix": ["4ABF5A06-5568-4834-BEE3-327A6D95A685"],
    "DXTMotionBlurPP": ["926433E1-7F8F-4BC6-BEC4-8C126C6B7DC4"],
    "DXTMotionBlur": ["DD13DE77-D3BA-42D4-B5C6-7745FA4E2D4B"],
    "DXTLightPP": ["694AF25F-124D-11D3-91D5-00C04F8EFB69"],
    "DXTWavePP": ["F12456C0-4C9E-11D2-8ADE-00A0C98E6527"],
    "DXTShadowPP": ["EC7E0765-4C76-11D2-8ADE-00A0C98E6527"],
    "DXTGlowPP": ["EC7E0764-4C76-11D2-8ADE-00A0C98E6527"],
    "DXTAlphaPP": ["D687A7E0-4BA4-11D2-8ADE-00A0C98E6527"],
    "DXTLight": ["F9EFBEC2-4302-11D2-952A-00C04FA34F05"],
    "DXTWave": ["ADC6CB88-424C-11D2-952A-00C04FA34F05"],
    "DXTAlpha": ["ADC6CB82-424C-11D2-952A-00C04FA34F05"],
    "DXTShadow": ["E71B4063-3E59-11D2-952A-00C04FA34F05"],
    "DXTGlow": ["9F8E6421-3D9B-11D2-952A-00C04FA34F05"],
    "DXTMetaWormHole": ["0E6AE022-0C83-11D2-8CD4-00104BC75D9A"],
    "DXTMetaThreshold": ["2A54C915-07AA-11D2-8D6D-00C04F8EF8E0"],
    "DXTMetaGriddler2": ["2A54C913-07AA-11D2-8D6D-00C04F8EF8E0"],
    "DXTMetaGriddler": ["2A54C911-07AA-11D2-8D6D-00C04F8EF8E0"],
    "DXTMetaVacuum": ["2A54C90D-07AA-11D2-8D6D-00C04F8EF8E0"],
    "DXTMetaFlowMotion": ["2A54C90B-07AA-11D2-8D6D-00C04F8EF8E0"],
    "DXTMetaColorFade": ["2A54C908-07AA-11D2-8D6D-00C04F8EF8E0"],
    "DXTMetaJaws": ["2A54C904-07AA-11D2-8D6D-00C04F8EF8E0"],
    "DXTMetaBurnFilm": ["107045D1-06E0-11D2-8D6D-00C04F8EF8E0"],
    "DXTMetaTwister": ["107045CF-06E0-11D2-8D6D-00C04F8EF8E0"],
    "DXTMetaWhiteOut": ["107045CC-06E0-11D2-8D6D-00C04F8EF8E0"],
    "DXTMetaRadialScaleWipe": ["107045CA-06E0-11D2-8D6D-00C04F8EF8E0"],
    "DXTMetaLightWipe": ["107045C8-06E0-11D2-8D6D-00C04F8EF8E0"],
    "DXTMetaWater": ["107045C5-06E0-11D2-8D6D-00C04F8EF8E0"],
    "DXTMetaPeelSplit": ["AA0D4D12-06A3-11D2-8F98-00C04FB92EB7"],
    "DXTMetaPeelPiece": ["AA0D4D10-06A3-11D2-8F98-00C04FB92EB7"],
    "DXTMetaPeelSmall": ["AA0D4D0E-06A3-11D2-8F98-00C04FB92EB7"],
    "DXTMetaCenterPeel": ["AA0D4D0C-06A3-11D2-8F98-00C04FB92EB7"],
    "DXTMetaLiquid": ["AA0D4D0A-06A3-11D2-8F98-00C04FB92EB7"],
    "DXTMetaPageTurn": ["AA0D4D08-06A3-11D2-8F98-00C04FB92EB7"],
    "DXTMetaRipple": ["AA0D4D03-06A3-11D2-8F98-00C04FB92EB7"],
    "DXTMetaRoll": ["9C61F46E-0530-11D2-8F98-00C04FB92EB7"],
    "DXTStripsPP": ["FEC0B7EE-7AEC-4067-9EE1-FACFB7CE9AF9"],
    "DXTStrips": ["63A4B1FC-259A-4A5B-8129-A83B8C9E6F4F"],
    "DXTRandomBarsPP": ["E3E6AE11-7FDC-40C4-AFBF-1DCEA82862CC"],
    "DXTRandomBars": ["2E7700B7-27C4-437F-9FBF-1E8BE2817566"],
    "DXTRandomDissolve": ["F7F4A1B6-8E87-452F-A2D7-3077F508DBC0"],
    "DXTAlphaImageLoaderPP": ["8C80CE2D-850D-47DA-8ECD-55023562D167"],
    "DXTAlphaImageLoader": ["0C7EFBDE-0303-4C6F-A4F7-31FA2BE5E397"],
    "DXTRedirect": ["42B07B28-2280-4937-B035-0293FB812781"],
    "DXTMaskFilter": ["3A04D93B-1EDD-4F3F-A375-A03EC19572C4"],
    "DXTRevealTrans": ["E31E87C4-86EA-4940-9B8A-5BD5D179A737"],
    "DXTCheckerBoardPP": ["CBF47525-98D2-45EA-B843-FD213D932B10"],
    "DXTCheckerBoard": ["B3EE7802-8224-4787-A1EA-F0DE16DEABD3"],
    "DXTDropShadowPP": ["EC7E0761-4C76-11D2-8ADE-00A0C98E6527"],
    "DXTDropShadow": ["ADC6CB86-424C-11D2-952A-00C04FA34F05"],
    "DXTChromaPP": ["EC7E0760-4C76-11D2-8ADE-00A0C98E6527"],
    "DXTChroma": ["421516C1-3CF8-11D2-952A-00C04FA34F05"],
    "CrWheelPP": ["FA9F6180-1464-11D2-A484-00C04F8EFB69"],
    "CrWheel": ["5AE1DAE0-1461-11D2-A484-00C04F8EFB69"],
    "CrZigzagPP": ["1559A3C1-102B-11D2-8B82-00A0C93C09B2"],
    "DXTZigzag": ["23E26328-3928-40F2-95E5-93CAD69016EB"],
    "CrZigzag": ["E6E73D20-0C8A-11D2-A484-00C04F8EFB69"],
    "CrSpiralPP": ["C6A4FE81-1022-11D2-8B82-00A0C93C09B2"],
    "DXTSpiral": ["4A03DCB9-6E17-4A39-8845-4EE7DC5331A5"],
    "CrSpiral": ["ACA97E00-0C7D-11D2-A484-00C04F8EFB69"],
    "DXTInset": ["76F363F2-7E9F-4ED7-A6A7-EE30351B6628"],
    "CrInset": ["93073C40-0BA5-11D2-A484-00C04F8EFB69"],
    "CrStretchPP": ["15FB95E0-0F77-11D2-8B82-00A0C93C09B2"],
    "DXTStretch": ["F088DE73-BDD0-4E3C-81F8-6D32F4FE9D28"],
    "CrStretch": ["7658F2A2-0A83-11D2-A484-00C04F8EFB69"],
    "CrBlindPP": ["213052C1-100D-11D2-8B82-00A0C93C09B2"],
    "DXTBlinds": ["9A4A4A51-FB3A-4F4B-9B57-A2912A289769"],
    "CrBlinds": ["00C429C0-0BA9-11D2-A484-00C04F8EFB69"],
    "CrBarnPP": ["FCAD7436-F151-4110-B97E-32BD607FBDB8"],
    "DXTBarn": ["EC9BA17D-60B5-462B-A6D8-14B89057E22A"],
    "CrBarn": ["C3BDF740-0B58-11D2-A484-00C04F8EFB69"],
    "CrRadialWipePP": ["33D932E0-0F48-11D2-8B82-00A0C93C09B2"],
    "DXTRadialWipe": ["164484A9-35D9-4FB7-9FAB-48273B96AA1D"],
    "CrRadialWipe": ["424B71AF-0695-11D2-A484-00C04F8EFB69"],
    "CrSlidePP": ["CC8CEDE1-1003-11D2-8B82-00A0C93C09B2"],
    "DXTSlide": ["D1C5A1E7-CC47-4E32-BDD2-4B3C5FC50AF5"],
    "CrSlide": ["810E402F-056B-11D2-A484-00C04F8EFB69"],
    "CrIrisPP": ["80DE22C4-0F44-11D2-8B82-00A0C93C09B2"],
    "DXTIris": ["049F2CE6-D996-4721-897A-DB15CE9EB73D"],
    "CrIris": ["3F69F351-0379-11D2-A484-00C04F8EFB69"],
    "LUTBuilderPP": ["25B33662-FD83-11D1-8ADE-444553540001"],
    "ConvolvePP": ["25B33661-FD83-11D1-8ADE-444553540001"],
    "CompositePP": ["25B33660-FD83-11D1-8ADE-444553540001"],
    "GradientPP": ["623E2880-FC0E-11D1-9A77-0000F8756A10"],
    "CrBlurPP": ["623E287E-FC0E-11D1-9A77-0000F8756A10"],
    "PixelatePP": ["4CCEA635-FBE0-11D1-906A-00C04FD9189D"],
    "Pixelate": ["4CCEA634-FBE0-11D1-906A-00C04FD9189D"],
    "BasicImageEffectsPP": ["16B280C9-EE70-11D1-9066-00C04FD9189D"],
    "BasicImageEffects": ["16B280C8-EE70-11D1-9066-00C04FD9189D"],
    "FadePP": ["16B280C6-EE70-11D1-9066-00C04FD9189D"],
    "DXFade": ["16B280C5-EE70-11D1-9066-00C04FD9189D"],
    "CrEngrave": ["F515306E-0156-11D2-81EA-0000F87557DB"],
    "CrEmboss": ["F515306D-0156-11D2-81EA-0000F87557DB"],
    "CrBlur": ["7312498D-E87A-11D1-81E0-0000F87557DB"],
    "DXTConvolution": ["2BC0EF29-E6BA-11D1-81DD-0000F87557DB"],
    "DXTWipePP": ["7FFE4D08-FBFD-11D1-9A77-0000F8756A10"],
    "DXTGradientWipe": ["B96F67A2-30C2-47E8-BD85-70A2C948B50F"],
    "DXTWipe": ["AF279B30-86EB-11D1-81BF-0000F87557DB"],
    "DXTGradientD": ["623E2882-FC0E-11D1-9A77-0000F8756A10"],
    "DXLUTBuilder": ["1E54333B-2A00-11D1-8198-0000F87557DB"],
    "DXTComposite": ["9A43A844-0831-11D1-817F-0000F87557DB"],
    "DXTFilter": ["385A91BC-1E8A-4E4A-A7A6-F4FC1E6CA1BD"],
    "DXGradient": ["C6365470-F667-11D1-9067-00C04FD9189D"],
    "DXSurfaceModifier": ["3E669F1D-9C23-11D1-9053-00C04FD9189D"],
    "DXSurface": ["0E890F83-5F79-11D1-9043-00C04FD9189D"],
    "DXTScale": ["555278E2-05DB-11D1-883A-3C8B00C10000"],
    "DXTaskManager": ["4CB26C03-FF93-11D0-817E-0000F87557DB"],
    "DXTransformFactory": ["D1FE6762-FC48-11D0-883A-3C8B00C10000"],
    "DXTFilterCollection": ["A7EE7F34-3BD1-427F-9231-F941E9B7E1FE"],
    "DXTFilterFactory": ["81397204-F51A-4571-8D7B-DC030521AABD"],
    "DXTFilterBehavior": ["649EEC1E-B579-4E8C-BB3B-4997F8426536"],
    "DX2D": ["473AA80B-4577-11D1-81A8-0000F87557DB"],
    "DXRasterizer": ["8652CE55-9E80-11D1-9053-00C04FD9189D"],
    "DXTLabel": ["54702535-2606-11D1-999C-0000F8756A10"],
    "SearchAssistantOC": ["B45FF030-4447-11D2-85DE-00C04FA35C89"],
    "CScriptErrorList": ["EFD01300-160F-11D2-BB2E-00805FF7EFCA"],
    "ShellNameSpace": ["55136805-B2DE-11D1-B9F2-00A0C98BC547"],
    "ShellUIHelper": ["64AB4BB7-111E-11D1-8F79-00C04FC2FBE1"],
    "ShellWindows": ["9BA05972-F6A8-11CF-A442-00A0C90A8F39"],
    "ShellBrowserWindow": ["C08AFD90-F2A1-11D1-8455-00A0C91F3880"],
    "InternetExplorer": ["0002DF01-0000-0000-C000-000000000046"],
    "WebBrowser": ["8856F961-340A-11D0-A96B-00C04FD705A2"],
    "WebBrowser_V1": ["EAB22AC3-30C1-11CF-A7EB-0000C05BAE0B"],
    "CHeaderFooter": ["3050F6CD-98B5-11CF-BB82-00AA00BDCE0B"],
    "CTemplatePrinter": ["3050F6B3-98B5-11CF-BB82-00AA00BDCE0B"],
    "CUtilityButton": ["3050F6B0-98B5-11CF-BB82-00AA00BDCE0B"],
    "CSliderBar": ["3050F68E-98B5-11CF-BB82-00AA00BDCE0B"],
    "CSpinButton": ["3050F68C-98B5-11CF-BB82-00AA00BDCE0B"],
    "CScrollBar": ["3050F68A-98B5-11CF-BB82-00AA00BDCE0B"],
    "CDeviceRect": ["3050F6D4-98B5-11CF-BB82-00AA00BDCE0B"],
    "CLayoutRect": ["3050F664-98B5-11CF-BB82-00AA00BDCE0B"],
    "AnchorClick": ["13D5413C-33B9-11D2-95A7-00C04F8ECB02"],
    "wfolders": ["BAE31F9A-1B81-11D2-A97A-00C04F8ECB02"],
    "CRadioButton": ["3050F69C-98B5-11CF-BB82-00AA00BDCE0B"],
    "CCheckBox": ["3050F686-98B5-11CF-BB82-00AA00BDCE0B"],
    "CCombobox": ["3050F678-98B5-11CF-BB82-00AA00BDCE0B"],
    "CIEOptionElement": ["3050F698-98B5-11CF-BB82-00AA00BDCE0B"],
    "CIESelectElement": ["3050F688-98B5-11CF-BB82-00AA00BDCE0B"],
    "CHtmlArea": ["3050F64F-98B5-11CF-BB82-00AA00BDCE0B"],
    "CDownloadBehavior": ["3050F5BE-98B5-11CF-BB82-00AA00BDCE0B"],
    "CPersistSnapshot": ["3050F4C9-98B5-11CF-BB82-00AA00BDCE0B"],
    "CPersistHistory": ["3050F4C8-98B5-11CF-BB82-00AA00BDCE0B"],
    "CPersistShortcut": ["3050F4C6-98B5-11CF-BB82-00AA00BDCE0B"],
    "CPersistDataPeer": ["3050F487-98B5-11CF-BB82-00AA00BDCE0B"],
    "CPersistUserData": ["3050F48E-98B5-11CF-BB82-00AA00BDCE0B"],
    "HomePage": ["766BF2AE-D650-11D1-9811-00C04FC31D2E"],
    "IntelliForms": ["613AB92E-16BF-11D2-BCA5-00C04FD929DB"],
    "ClientCaps": ["7E8BC44E-AEFF-11D1-89C2-00C04FB6BFC4"],
    "PeerFactory": ["3050F4CF-98B5-11CF-BB82-00AA00BDCE0B"],
    "CoMapMIMEToCLSID": ["30C3B080-30FB-11D0-B724-00AA006C1A01"],
    "CoSniffStream": ["6A01FDA0-30DF-11D0-B724-00AA006C1A01"],
    "CoDitherToRGB8": ["A860CE50-3910-11D0-86FC-00A0C913F750"],
    "HostDialogHelper": ["429AF92C-A51F-11D2-861E-00C04FA35C89"],
    "HTMLInputImage": ["3050F2C4-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLOptionButtonElement": ["3050F2BE-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLInputFileElement": ["3050F2AE-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLInputTextElement": ["3050F2AB-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLInputButtonElement": ["3050F2B4-98B5-11CF-BB82-00AA00BDCE0B"],
    "OldHTMLFormElement": ["0D04D285-6BEC-11CF-8B97-00AA00476DA6"],
    "OldHTMLDocument": ["D48A6EC9-6A4A-11CF-94A7-444553540000"],
    "HTMLAppBehavior": ["3050F5CB-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLPopup": ["3050F667-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLDialog": ["3050F28A-98B5-11CF-BB82-00AA00BDCE0B"],
    "ThreadDialogProcParam": ["3050F5EB-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLNamespaceCollection": ["3050F6B9-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLNamespace": ["3050F6BC-98B5-11CF-BB82-00AA00BDCE0B"],
    "FontNames": ["3050F83A-98B5-11CF-BB82-00AA00BDCE0B"],
    "BlockFormats": ["3050F831-98B5-11CF-BB82-00AA00BDCE0B"],
    "HtmlDlgSafeHelper": ["3050F819-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLStyleFontFace": ["3050F3D4-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLStyleElement": ["3050F37D-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLBGsound": ["3050F370-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLFrameSetSite": ["3050F31A-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLSpanFlow": ["3050F3E6-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLLegendElement": ["3050F3E9-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLFieldSetElement": ["3050F3E8-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLDivPosition": ["3050F249-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLIFrame": ["3050F316-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLFrameElement": ["3050F314-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLFrameBase": ["3050F312-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLParamElement": ["3050F83E-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLObjectElement": ["3050F24E-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLNoShowElement": ["3050F38B-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLScriptElement": ["3050F28C-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLTableCell": ["3050F246-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLTableRow": ["3050F26D-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLTableSection": ["3050F2E9-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLTableCol": ["3050F26C-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLTable": ["3050F26B-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLSpanElement": ["3050F3F5-98B4-11CF-BB82-00AA00BDCE0B"],
    "HTMLPhraseElement": ["3050F26E-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLCommentElement": ["3050F317-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLTableCaption": ["3050F2EC-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLAreaElement": ["3050F283-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLMapElement": ["3050F271-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLAreasCollection": ["3050F4CA-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLEmbed": ["3050F25D-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLDocument": ["25336920-03F9-11CF-8FD0-00AA00686F13"],
    "HTMLWindowProxy": ["3050F391-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLWindow2": ["D48A6EC6-6A4A-11CF-94A7-444553540000"],
    "HTMLScreen": ["3050F35D-98B5-11CF-BB82-00AA00BDCE0B"],
    "FramesCollection": ["3050F7F6-98B5-11CF-BB82-00AA00BDCE0B"],
    "CEventObj": ["3050F48A-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLLocation": ["163BB1E1-6E00-11CF-837A-48DC04C10000"],
    "HTMLNavigator": ["FECEAAA6-8405-11CF-8BA1-00AA00476DA6"],
    "COpsProfile": ["3050F402-98B5-11CF-BB82-00AA00BDCE0B"],
    "CPlugins": ["3050F3FF-98B5-11CF-BB82-00AA00BDCE0B"],
    "CMimeTypes": ["3050F3FE-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLHistory": ["FECEAAA3-8405-11CF-8BA1-00AA00476DA6"],
    "HTMLUnknownElement": ["3050F268-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLBaseFontElement": ["3050F282-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLNextIdElement": ["3050F279-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLIsIndexElement": ["3050F278-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLBaseElement": ["3050F276-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLMetaElement": ["3050F275-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLTitleElement": ["3050F284-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLHeadElement": ["3050F493-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLHtmlElement": ["3050F491-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLMarqueeElement": ["3050F2B9-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLButtonElement": ["3050F2C6-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLRichtextElement": ["3050F2DF-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLTextAreaElement": ["3050F2AC-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLInputElement": ["3050F5D8-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLOptionElementFactory": ["3050F38D-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLOptionElement": ["3050F24D-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLSelectElement": ["3050F245-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLHeaderElement": ["3050F27A-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLElementCollection": ["3050F4CB-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLParaElement": ["3050F26F-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLHRElement": ["3050F252-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLDListElement": ["3050F27D-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLBRElement": ["3050F280-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLDTElement": ["3050F27C-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLDDElement": ["3050F27F-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLDivElement": ["3050F27E-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLBlockElement": ["3050F281-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLLIElement": ["3050F273-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLOListElement": ["3050F270-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLUListElement": ["3050F269-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLListElement": ["3050F272-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLLabelElement": ["3050F32B-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLAnchorElement": ["3050F248-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLFontElement": ["3050F27B-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLBody": ["3050F24A-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLImageElementFactory": ["3050F38F-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLImg": ["3050F241-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLTextElement": ["3050F26A-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLFormElement": ["3050F251-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLLinkElement": ["3050F277-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLStyleSheetsCollection": ["3050F37F-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLStyleSheet": ["3050F2E4-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLStyleSheetPagesCollection": ["3050F7F1-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLStyleSheetPage": ["3050F7EF-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLStyleSheetRulesCollection": ["3050F3CD-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLStyleSheetRule": ["3050F3CE-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLGenericElement": ["3050F4B8-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLUrnCollection": ["3050F580-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTCDescBehavior": ["3050F5DD-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTCAttachBehavior": ["3050F5F5-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTCEventBehavior": ["3050F4FE-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTCMethodBehavior": ["3050F630-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTCPropertyBehavior": ["3050F5DE-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTCDefaultDispatch": ["3050F4FC-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLDefaults": ["3050F6C8-98B5-11CF-BB82-00AA00BDCE0B"],
    "DOMChildrenCollection": ["3050F5AA-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLAttributeCollection": ["3050F4CC-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLDOMImplementation": ["3050F80E-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLDOMTextNode": ["3050F4BA-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLDOMAttribute": ["3050F4B2-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLCurrentStyle": ["3050F3DC-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLRenderStyle": ["3050F6AA-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLRuleStyle": ["3050F3D0-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTMLStyle": ["3050F285-98B5-11CF-BB82-00AA00BDCE0B"],
    "AnimationComposerSiteFactory": ["16911A65-D41D-4431-87F7-E757F4D03BD8"],
    "AnimationComposerFactory": ["332B2A56-F86C-47E7-8602-FC42AC8B9920"],
    "TIMEFilterAnimation": ["C54515D0-F2E5-4BDD-AA86-1E4F23E480E7"],
    "TIMEColorAnimation": ["62F75052-F3EC-4A64-84FB-AB18E0746ED8"],
    "TIMEMotionAnimation": ["0019A09D-1A81-41C5-89EC-D9E737811303"],
    "TIMESetAnimation": ["BA91CE53-BAEB-4F05-861C-0A2A0934F82E"],
    "TIMEAnimation": ["F99D135A-C07C-449E-965C-7DBB7C554A51"],
    "TIME": ["E32EF57B-7FDE-4765-9BC5-A1BA9705C44E"],
    "TIMEFactory": ["17237A20-3ADB-48EC-B182-35291F115790"],
    "SubscriptionMgr": ["ABBE31D0-6DAE-11D0-BECA-00C04FD940BE"],
    "CDLAgent": ["7D559C10-9FE9-11D0-93F7-00AA0059CE02"],
    "PostAgent": ["D8BD2030-6FC9-11D0-864F-00AA006809D9"],
    "WebCheckOfflineSync": ["7FC0B86E-5FA7-11D1-BC7C-00C04FD929DB"],
    "ChannelAgent": ["E3A8BDE6-ABCE-11D0-BC4B-00C04FD929DB"],
    "WebCrawlerAgent": ["08165EA0-E946-11CF-9C87-00AA005127ED"],
    "WebCheck": ["E6FB5E20-DE35-11CF-9C87-00AA005127ED"],
    "SubscriptionThrottler": ["1E9B00E5-9846-11D1-A1EE-00C04FC2FBE1"],
    "HTMLLoadOptions": ["18845040-0FA5-11D1-BA19-00C04FD912D0"],
    "PersistentZoneIdentifier": ["0968E258-16C7-4DBA-AA86-462DD61E31A3"],
    "InternetZoneManager": ["7B8A2D95-0AC9-11D1-896C-00C04FB6BFC4"],
    "InternetSecurityManager": ["7B8A2D94-0AC9-11D1-896C-00C04FB6BFC4"],
    "IActiveXSafetyProvider": ["AAF8C6CE-F972-11D0-97EB-00AA00615333"],
    "SoftDistExt": ["B15B8DC0-C7E1-11D0-8680-00AA00BDCB71"],
    "IntDitherer": ["05F6FE1A-ECEF-11D0-AAE7-00C04FC9B304"],
    "HTMLPluginDocument": ["25336921-03F9-11CF-8FD0-00AA00686F13"],
    "HTMLApplication": ["3050F4D8-98B5-11CF-BB82-00AA00BDCE0B"],
    "HTADocument": ["3050F5C8-98B5-11CF-BB82-00AA00BDCE0B"],
    "MHTMLDocument": ["3050F3D9-98B5-11CF-BB82-00AA00BDCE0B"],
    "IImageDecodeFilter": ["607FD4E8-0A03-11D1-AB1D-00C04FC9B304"],
    "IImgCtx": ["3050F3D6-98B5-11CF-BB82-00AA00BDCE0B"],
    "StdComponentCategoriesMgr": ["0002E005-0000-0000-C000-000000000046"],
    "ClassInstallFilter": ["32B533BB-EDAE-11D0-BD5A-00AA00B92AF1"],
    "CdlProtocol": ["3DD53D40-7B8B-11D0-B013-00AA0059CE02"],
    "DeCompMimeFilter": ["8F6B0360-B80D-11D0-A9B3-006097942311"],
    "StdEncodingFilterFac": ["54C37CD0-D944-11D0-A9F4-006097942311"],
    "NotificaitonTest4": ["C733E504-576E-11D0-B28C-00C04FD7CD22"],
    "NotificaitonTest3": ["C733E503-576E-11D0-B28C-00C04FD7CD22"],
    "NotificaitonTest2": ["C733E502-576E-11D0-B28C-00C04FD7CD22"],
    "NotificaitonTest1": ["C733E501-576E-11D0-B28C-00C04FD7CD22"],
    "THREAD_BROADCAST": ["D34F1812-576E-11D0-B28C-00C04FD7CD22"],
    "PROCESS_BROADCAST": ["D34F1811-576E-11D0-B28C-00C04FD7CD22"],
    "GLOBAL_BROADCAST": ["D34F1810-576E-11D0-B28C-00C04FD7CD22"],
    "WebCheckDefaultProcess": ["C733E4B0-576E-11D0-B28C-00C04FD7CD22"],
    "StdNotificationMgr": ["C733E4AF-576E-11D0-B28C-00C04FD7CD22"],
    "AboutProtocol": ["3050F406-98B5-11CF-BB82-00AA00BDCE0B"],
    "ResProtocol": ["3050F3BC-98B5-11CF-BB82-00AA00BDCE0B"],
    "UrlMkBindCtx": ["79EAC9F2-BAF9-11CE-8C82-00AA004BA90B"],
    "PSUrlMonProxy": ["79EAC9F1-BAF9-11CE-8C82-00AA004BA90B"],
    "MkProtocol": ["79EAC9E6-BAF9-11CE-8C82-00AA004BA90B"],
    "PersistentDataChannel": ["BC9B54AB-7883-4C13-909F-033D03267990"],
    "DataChannel": ["BBB36F15-408D-4056-8C27-920843D40BE5"],
    "PendingProxyConnection": ["D8A68E5E-2B37-426C-A329-C117C14C429E"],
    "EnumAdapterInfo": ["6F9942CA-C1B1-4AB5-93DA-6058991DC8F3"],
    "AdapterInfo": ["6F9942C9-C1B1-4AB5-93DA-6058991DC8F3"],
    "SecondaryControlChannel": ["7B3181A0-C92F-4567-B0FA-CD9A10ECD7D1"],
    "PrimaryControlChannel": ["3CEB5509-C1CD-432F-9D8F-65D1E286AA80"],
    "ApplicationGatewayServices": ["F8ADE1D3-49DF-4B75-9005-EF9508E6A337"],
    "UPnPNAT": ["AE1E00AA-3FD5-403C-8A27-2BBDC30CD0E1"],
    "Request": ["6BC096B1-0CE6-11D1-BAAE-00C04FC2E20D"],
    "McastAddressAllocation": ["DF0DAEF2-A289-11D1-8697-006008B0E5D2"],
    "NetSharingManager": ["5C63C1AD-3956-4FF8-8486-40034758315B"],
    "NetFirewallV6Manager": ["03707315-53E9-4B84-82B2-F09025CAD207"],
    "FlashConfig": ["9F63805A-42A7-4472-BABC-642466C91D59"],
    "NetProvisioning": ["2AA2B5FE-B846-4D07-810C-B21EE45320E3"],
    "Rendezvous": ["F1029E5B-CB5B-11D0-8D59-00C04FD91AC0"],
    "SdoMachine": ["E9218AE7-9E91-11D1-BF60-0080C7846BC0"],
    "SdpConferenceBlob": ["9B2719DD-B696-11D0-A489-00C04FD91AC0"],
    "RequestMakeCall": ["AC48FFE0-F8C4-11D1-A030-00C04FB6809F"],
    "DispatchMapper": ["E9225296-C759-11D1-A02B-00C04FB6809F"],
    "TAPI": ["21D6D48E-A88B-11D0-83DD-00AA003CCABD"],
    "PluggableTerminalRegistration": ["45234E3E-61CC-4311-A3AB-248082554482"],
    "PluggableSuperclassRegistration": ["BB918E32-2A5C-4986-AB40-1686A034390A"],
    "TerminalManager": ["7170F2E0-9BE3-11D0-A009-00AA00B605A4"],
    "RTCClient": ["7A42EA29-A2B7-40C4-B091-F6F024AA89BE"],
    "UPnPDeviceHostSetup": ["B4609411-C81C-4CCE-8C76-C6B50C9402C6"],
    "UPnPDescriptionDocument": ["1D8A9B47-3A28-4CE2-8A4B-BD34E45BCEEB"],
    "UPnPService": ["C624BA95-FBCB-4409-8C03-8CCEEC533EF1"],
    "UPnPServices": ["C0BC4B4A-A406-4EFC-932F-B8546B8100CC"],
    "UPnPDevice": ["A32552C5-BA61-457A-B59A-A2561E125E33"],
    "UPnPDevices": ["B9E84FFD-AD3C-40A4-B835-0882EBCBAAA8"],
    "UPnPDeviceFinder": ["E2085F28-FEB7-404A-B8E7-E659BDEAAA02"],
    "UPnPDeviceHostICSSupport": ["797A9BB1-9E49-4E63-AFE1-1B45B9DC8162"],
    "UPnPRemoteEndpointInfo": ["2E5E84E9-4049-4244-B728-2D24227157C7"],
    "UPnPRegistrar": ["204810B9-73B2-11D4-BF42-00B0D0118B56"],
    "XmlProviderManager": ["61D55F63-98F7-473C-97C7-A08E2F13C955"],
    "SharingConfiguration": ["46C166B1-3108-11D4-9348-00C04F8EEB71"],
    "SharingApplicationDefinition": ["46C166B0-3108-11D4-9348-00C04F8EEB71"],
    "SharingManagerEnumPortMapping": ["46C166AF-3108-11D4-9348-00C04F8EEB71"],
    "SharingManagerEnumApplicationDefinition": ["46C166AE-3108-11D4-9348-00C04F8EEB71"],
    "SharingManagerEnumPrivateConnection": ["46C166AD-3108-11D4-9348-00C04F8EEB71"],
    "SharingManagerEnumPublicConnection": ["46C166AC-3108-11D4-9348-00C04F8EEB71"],
    "HomeNetAutoConfigService": ["9A8EA3B5-572E-4CB3-9EB9-EC689AC575AE"],
    "InternetConnectionBeaconService": ["04DF613A-5610-11D4-9EC8-00B0D022DD1F"],
    "HNetCfgMgr": ["46C166AA-3108-11D4-9348-00C04F8EEB71"],
    "BluetoothConnectionManager": ["B4C8DF59-D16F-4042-80B7-3557A254B7C5"],
    "NetConnectionHNetUtil": ["BA126AE3-2166-11D1-B1D0-00805FC1270E"],
    "EAPOLManager": ["BA126AE4-2166-11D1-B1D0-00805FC1270E"],
    "NetConnectionUiUtilities": ["7007ACD3-3202-11D1-AAD2-00805FC1270E"],
    "LanConnectionManager": ["BA126AD3-2166-11D1-B1D0-00805FC1270E"],
    "ConnectionManager2": ["BA126AE5-2166-11D1-B1D0-00805FC1270E"],
    "ConnectionManager": ["BA126AD1-2166-11D1-B1D0-00805FC1270E"],
    "ConnectionCommonUi": ["7007ACD1-3202-11D1-AAD2-00805FC1270E"],
    "CNetCfg": ["5B035261-40F9-11D1-AAEC-00805FC1270E"],
    "FilePlaybackTerminal": ["0CB9914C-79CD-47DC-ADB0-327F47CEFB20"],
    "FileRecordingTrack": ["BF14A2E4-E88B-4EF5-9740-5AC5D022F8C9"],
    "FileRecordingTerminal": ["521F3D06-C3D0-4511-8617-86B9A783DA77"],
    "FileTerminal": ["AAF578F1-DC70-11D0-8ED3-00C04FB6809F"],
    "SpeakersTerminal": ["AAF578F0-DC70-11D0-8ED3-00C04FB6809F"],
    "BridgeTerminal": ["8EBAE7A3-8943-11D1-96B8-00C04FB6E866"],
    "MediaStreamTerminal": ["E2F7AEF7-4971-11D1-A671-006097C9A2E8"],
    "MicrophoneTerminal": ["AAF578EF-DC70-11D0-8ED3-00C04FB6809F"],
    "SpeakerphoneTerminal": ["AAF578EE-DC70-11D0-8ED3-00C04FB6809F"],
    "HeadsetTerminal": ["AAF578ED-DC70-11D0-8ED3-00C04FB6809F"],
    "HandsetTerminal": ["AAF578EB-DC70-11D0-8ED3-00C04FB6809F"],
    "VideoInputTerminal": ["AAF578EC-DC70-11D0-8ED3-00C04FB6809F"],
    "VideoWindowTerm": ["F7438990-D6EB-11D0-82A6-00AA00B5CA1B"],
    "MtsVbHelper": ["FC4886B3-A40F-11D1-AA88-00AA00BA3258"],
    "EventObjectChange2": ["BB07BACD-CD56-4E63-A8FF-CBF0355FB9F4"],
    "EventObjectChange": ["D0565000-9DF4-11D1-A281-00C04FCA0AA7"],
    "CEventSubscription": ["7542E960-79C7-11D1-88F9-0080C7D771BF"],
    "CEventClass": ["CDBEC9C0-7A68-11D1-88F9-0080C7D771BF"],
    "CEventPublisher": ["AB944620-79C6-11D1-88F9-0080C7D771BF"],
    "CEventSystem": ["4E14FBA2-2E22-11D1-9964-00C04FBBB345"],
    "COMAdminCatalogCollection": ["F618C516-DFB8-11D1-A2CF-00805FC79235"],
    "COMAdminCatalogObject": ["F618C515-DFB8-11D1-A2CF-00805FC79235"],
    "COMAdminCatalog": ["F618C514-DFB8-11D1-A2CF-00805FC79235"],
    "ClrAssemblyLocator": ["458AA3B5-265A-4B75-BC05-9BEA4630CF18"],
    "AppDomainHelper": ["EF24F689-14F8-4D92-B4AF-D7B1F0E70FD4"],
    "SoapMoniker": ["ECABB0C7-7F19-11D2-978E-0000F8757E2A"],
    "PartitionMoniker": ["ECABB0C5-7F19-11D2-978E-0000F8757E2A"],
    "ProcessDump": ["ECABB0C4-7F19-11D2-978E-0000F8757E2A"],
    "TrackerServer": ["ECABAFB9-7F19-11D2-978E-0000F8757E2A"],
    "EventServer": ["ECABAFBC-7F19-11D2-978E-0000F8757E2A"],
    "PoolMgr": ["ECABAFB5-7F19-11D2-978E-0000F8757E2A"],
    "DispenserManager": ["ECABB0C0-7F19-11D2-978E-0000F8757E2A"],
    "MessageMover": ["ECABB0BF-7F19-11D2-978E-0000F8757E2A"],
    "LBEvents": ["ECABB0C1-7F19-11D2-978E-0000F8757E2A"],
    "CRMRecoveryClerk": ["ECABB0BE-7F19-11D2-978E-0000F8757E2A"],
    "CRMClerk": ["ECABB0BD-7F19-11D2-978E-0000F8757E2A"],
    "ComSystemAppEventData": ["ECABB0C6-7F19-11D2-978E-0000F8757E2A"],
    "ComServiceEvents": ["ECABB0C3-7F19-11D2-978E-0000F8757E2A"],
    "MtsGrp": ["4B2E958D-0393-11D1-B1AB-00AA00BA3258"],
    "CoMTSLocator": ["ECABB0AC-7F19-11D2-978E-0000F8757E2A"],
    "COMEvents": ["ECABB0AB-7F19-11D2-978E-0000F8757E2A"],
    "SharedPropertyGroupManager": ["2A005C11-A5DE-11CF-9E66-00AA00A3F464"],
    "SharedPropertyGroup": ["2A005C0B-A5DE-11CF-9E66-00AA00A3F464"],
    "SharedProperty": ["2A005C05-A5DE-11CF-9E66-00AA00A3F464"],
    "ServicePoolConfig": ["ECABB0CA-7F19-11D2-978E-0000F8757E2A"],
    "ServicePool": ["ECABB0C9-7F19-11D2-978E-0000F8757E2A"],
    "CServiceConfig": ["ECABB0C8-7F19-11D2-978E-0000F8757E2A"],
    "ByotServerEx": ["ECABB0AA-7F19-11D2-978E-0000F8757E2A"],
    "TransactionContextEx": ["5CB66670-D3D4-11CF-ACAB-00A024A55AEF"],
    "TransactionContext": ["7999FC25-D3C6-11CF-ACAB-00A024A55AEF"],
    "AppServer": ["71E38F91-7E88-11CF-9EDE-0080C78B7F89"],
    "Dummy30040732": ["ECABB0A9-7F19-11D2-978E-0000F8757E2A"],
    "GetSecurityCallContextAppObject": ["ECABB0A8-7F19-11D2-978E-0000F8757E2A"],
    "SecurityCallContext": ["ECABB0A7-7F19-11D2-978E-0000F8757E2A"],
    "SecurityCallers": ["ECABB0A6-7F19-11D2-978E-0000F8757E2A"],
    "SecurityIdentity": ["ECABB0A5-7F19-11D2-978E-0000F8757E2A"],
    "SecurityCertificate": ["ECABB0A4-7F19-11D2-978E-0000F8757E2A"],
    "ObjectWrapperUnmarshaler": ["ECABAFD3-7F19-11D2-978E-0000F8757E2A"],
    "ComExceptionEvents": ["ECABB0BC-7F19-11D2-978E-0000F8757E2A"],
    "ComCRMEvents": ["ECABB0C2-7F19-11D2-978E-0000F8757E2A"],
    "ComQCEvents": ["ECABB0BB-7F19-11D2-978E-0000F8757E2A"],
    "ComIdentityEvents": ["ECABB0BA-7F19-11D2-978E-0000F8757E2A"],
    "ComActivityEvents": ["ECABB0B9-7F19-11D2-978E-0000F8757E2A"],
    "ComObjectConstructionEvents": ["ECABB0B8-7F19-11D2-978E-0000F8757E2A"],
    "ComObjectPoolEvents2": ["ECABB0B7-7F19-11D2-978E-0000F8757E2A"],
    "ComObjectPoolEvents": ["ECABB0B6-7F19-11D2-978E-0000F8757E2A"],
    "ComSecurityEvents": ["ECABB0B5-7F19-11D2-978E-0000F8757E2A"],
    "ComResourceEvents": ["ECABB0B4-7F19-11D2-978E-0000F8757E2A"],
    "ComObjectEvents": ["ECABB0B3-7F19-11D2-978E-0000F8757E2A"],
    "ComMethodEvents": ["ECABB0B2-7F19-11D2-978E-0000F8757E2A"],
    "ComTransactionEvents": ["ECABB0B1-7F19-11D2-978E-0000F8757E2A"],
    "ComInstanceEvents": ["ECABB0B0-7F19-11D2-978E-0000F8757E2A"],
    "ComAppEvents": ["ECABB0AF-7F19-11D2-978E-0000F8757E2A"],
    "ComUserEvent": ["ECABB0AE-7F19-11D2-978E-0000F8757E2A"],
    "ComThreadEvents": ["ECABB0AD-7F19-11D2-978E-0000F8757E2A"],
    "QCMarshalInterceptor": ["ECABAFCB-7F19-11D2-978E-0000F8757E2A"],
    "DLQListenerStarter": ["ECABAFCA-7F19-11D2-978E-0000F8757E2A"],
    "QCQueueAdmin": ["ECABAFC9-7F19-11D2-978E-0000F8757E2A"],
    "QueueMoniker": ["ECABAFC7-7F19-11D2-978E-0000F8757E2A"],
    "NewMoniker": ["ECABAFC6-7F19-11D2-978E-0000F8757E2A"],
    "Player": ["ECABAFC5-7F19-11D2-978E-0000F8757E2A"],
    "Integrator": ["ECABAFC4-7F19-11D2-978E-0000F8757E2A"],
    "QCListener": ["ECABAFC3-7F19-11D2-978E-0000F8757E2A"],
    "Recorder": ["ECABAFC2-7F19-11D2-978E-0000F8757E2A"],
    "ClerksCollection": ["ECABAFC1-7F19-11D2-978E-0000F8757E2A"],
    "cfw": ["ECABAFC0-7F19-11D2-978E-0000F8757E2A"],
    "ComEventRegistrar": ["ECABAFCF-7F19-11D2-978E-0000F8757E2A"],
    "ComLceEventDispatcher": ["ECABAFBF-7F19-11D2-978E-0000F8757E2A"],
    "NtaHelper": ["ECABAFBE-7F19-11D2-978E-0000F8757E2A"],
    "ClassTracker": ["ECABAFBB-7F19-11D2-978E-0000F8757E2A"],
    "AppTracker": ["ECABAFBA-7F19-11D2-978E-0000F8757E2A"],
    "ObjectConstruct": ["ECABAFB8-7F19-11D2-978E-0000F8757E2A"],
    "CtorAct": ["ECABAFB7-7F19-11D2-978E-0000F8757E2A"],
    "SoapAct": ["ECABAFD0-7F19-11D2-978E-0000F8757E2A"],
    "ObjPoolAct": ["ECABAFB6-7F19-11D2-978E-0000F8757E2A"],
    "AssociationUnmarshal": ["ECABAFB4-7F19-11D2-978E-0000F8757E2A"],
    "UserContextProperty": ["ECABAFB3-7F19-11D2-978E-0000F8757E2A"],
    "vca": ["ECABAFB2-7F19-11D2-978E-0000F8757E2A"],
    "stapa": ["ECABAFB1-7F19-11D2-978E-0000F8757E2A"],
    "obja": ["ECABAFB0-7F19-11D2-978E-0000F8757E2A"],
    "CFAct": ["ECABAFAF-7F19-11D2-978E-0000F8757E2A"],
    "sca": ["ECABAFAE-7F19-11D2-978E-0000F8757E2A"],
    "NonRootTransactionEnvoy": ["ECABAFAD-7F19-11D2-978E-0000F8757E2A"],
    "TransactionUnmarshal": ["ECABAFAC-7F19-11D2-978E-0000F8757E2A"],
    "SecurityEnvoy": ["ECABAFAB-7F19-11D2-978E-0000F8757E2A"],
    "ActivityUnmarshal": ["ECABAFAA-7F19-11D2-978E-0000F8757E2A"],
    "PartitionPropertyUnmarshal": ["ECABAFCC-7F19-11D2-978E-0000F8757E2A"],
    "TrkInfoObjUnmarshal": ["ECABAFCE-7F19-11D2-978E-0000F8757E2A"],
    "TrkInfoCollUnmarshal": ["ECABAFCD-7F19-11D2-978E-0000F8757E2A"],
    "ChannelMgr": ["B3CDAE90-D170-11D0-802B-00C04FD75D13"],
    "ImageList": ["7C476BA2-02B1-48F4-8048-B24619DDC058"],
    "MSEnumDiscRecordersObj": ["8A03567A-63CB-4BA8-BAF6-52119816D1EF"],
    "MSDiscMasterObj": ["520CCA63-51A5-11D3-9144-00104BA11C5E"],
    "MSDiscRecorderObj": ["520CCA61-51A5-11D3-9144-00104BA11C5E"],
    "CMultiLanguage": ["275C23E2-3747-11D0-9FEA-00AA003F8646"],
    "CMLangConvertCharset": ["D66D6F99-CDAA-11D0-B822-00C04FC9B31F"],
    "CMLangString": ["C04D65CF-B70D-11D0-B188-00AA0038C969"],
    "ShellLogonStatusHost": ["60664CAF-AF0D-0007-A300-5C7D25FF22A0"],
    "ShellLocalMachine": ["60664CAF-AF0D-0005-A300-5C7D25FF22A0"],
    "ShellLogonEnumUsers": ["60664CAF-AF0D-0004-A300-5C7D25FF22A0"],
    "ShellLogonUser": ["60664CAF-AF0D-0003-A300-5C7D25FF22A0"],
    "ShellImageDataFactory": ["66E4E4FB-F385-4DD0-8D74-A2EFD1BC6178"],
    "PassportClientServices": ["2D2307C8-7DB4-40D6-9100-D52AF4F97A5B"],
    "FileSearchBand": ["C4EE31F3-4768-11D2-BE5C-00A0C9A83DA1"],
    "SearchCommand": ["B005E690-678D-11D1-B758-00A0C90564FE"],
    "WebViewFolderContents": ["1820FED0-473E-11D0-A96C-00C04FD705A2"],
    "ShellDispatchInproc": ["0A89A860-D7B1-11CE-8350-444553540000"],
    "Shell": ["13709620-C279-11CE-A49E-444553540000"],
    "ShellFolderView": ["62112AA1-EBE4-11CF-A5FB-0020AFE7292D"],
    "ShellLinkObject": ["11219420-1768-11D1-95BE-00609797EA4F"],
    "ShellFolderItem": ["2FE352EA-FD1F-11D2-B1F4-00C04F8EEB3E"],
    "ShellFolderViewOC": ["9BA05971-F6A8-11CF-A442-00A0C90A8F39"],
    "AttachmentServices": ["4125DD96-E03A-4103-8F70-E0597D803B9C"],
    "PassportWizard": ["58F1F272-9240-4F51-B6D4-FD63D1618591"],
    "TrayBandSiteService": ["F60AD0A0-E5E1-45CB-B51A-E15B9F8B2934"],
    "ImageRecompress": ["6E33091C-D2F8-4740-B55E-2E11D1477A2C"],
    "NamespaceWalker": ["72EB61E0-8672-4303-9175-F2E4C68B2E7C"],
    "FolderViewHost": ["20B1CB23-6968-4EB9-B7D4-A66D00D07CEE"],
    "InternetPrintOrdering": ["ADD36AA8-751A-4579-A266-D66F5202CCBB"],
    "PublishingWizard": ["6B33163C-76A5-4B6C-BF21-45DE9CD503A1"],
    "PublishDropTarget": ["CC6EEFFB-43F6-46C5-9619-51D571967F7D"],
    "WebWizardHost": ["C827F149-55C1-4D28-935E-57E47CAED973"],
    "TaskbarList": ["56FDF344-FD6D-11D0-958A-006097C9A090"],
    "CDBurn": ["FBEB8A05-BEEE-4442-804E-409D6C4515E9"],
    "NetCrawler": ["601AC3DC-786A-4EB0-BF40-EE3521E70BFB"],
    "UserEventTimer": ["864A1288-354C-4D19-9D68-C2742BB14997"],
    "UserEventTimerCallback": ["15FFFD13-5140-41B8-B89A-C8D5759CD2B2"],
    "UserNotification": ["0010890E-8789-413C-ADBC-48F5B511B3AF"],
    "PropertiesUI": ["D912F8CF-0396-4915-884E-FB425D32943B"],
    "ImageProperties": ["7AB770C7-0E23-4D7A-8AA2-19BFAD479829"],
    "MergedCategorizer": ["8E827C11-33E7-4BC1-B242-8CD9A1C2B304"],
    "AlphabeticalCategorizer": ["3C2654C6-7372-4F6B-B310-55D6128F49D2"],
    "SizeCategorizer": ["55D7B852-F6D1-42F2-AA75-8728A1B2D264"],
    "TimeCategorizer": ["3BB4118F-DDFD-4D30-A348-9FB5D6BF1AFE"],
    "FreeSpaceCategorizer": ["B5607793-24AC-44C7-82E2-831726AA6CB7"],
    "DriveTypeCategorizer": ["B0A8F3CF-4333-4BAB-8873-1CCB1CADA48B"],
    "DriveSizeCategorizer": ["94357B53-CA29-4B78-83AE-E8FE7409134F"],
    "QueryCancelAutoPlay": ["331F1768-05A9-4DDD-B86E-DAE34DDC998A"],
    "VirusScan": ["E88E5DE0-BD3E-11CF-AAFA-00AA00B6015C"],
    "DsFindFrsMembers": ["94CE4B18-B3D3-11D1-B9B4-00C04FD8D5B0"],
    "DsFindDomainController": ["538C7B7E-D25E-11D0-9742-00A0C906AF45"],
    "DsFindAdvanced": ["83EE3FE3-57D9-11D0-B932-00A024AB2DBB"],
    "DsFindContainer": ["C1B3CBF2-886A-11D0-9140-00AA00C16E65"],
    "DsFindVolume": ["C1B3CBF1-886A-11D0-9140-00AA00C16E65"],
    "DsFindComputer": ["16006700-87AD-11D0-9140-00AA00C16E65"],
    "DsFindPrinter": ["B577F070-7EE2-11D0-913F-00AA00C16E65"],
    "DsFindPeople": ["83EE3FE2-57D9-11D0-B932-00A024AB2DBB"],
    "DsFindObjects": ["83EE3FE1-57D9-11D0-B932-00A024AB2DBB"],
    "DsQuery": ["8A23E65E-31C2-11D0-891C-00A024AB2DBB"],
    "CommonQuery": ["83BC5EC0-6F2A-11D0-A1C4-00AA00C16E65"],
    "DsFolderProperties": ["9E51E0D0-6E0F-11D2-9601-00C04FA31A86"],
    "DsDisplaySpecifier": ["1AB4A8C0-6A0B-11D2-AD49-00C04FA31A86"],
    "DsDomainTreeBrowser": ["1698790A-E2B4-11D0-B0B1-00C04FD8DCA6"],
    "DsPropertyPages": ["0D45D530-764B-11D0-A1CA-00AA00C16E65"],
    "MicrosoftDS": ["FE1290F0-CFBD-11CF-A330-00AA00C16E65"],
    "MenuBandSite": ["E13EF4E4-D2F2-11D0-9816-00C04FD91972"],
    "MenuToolbarBase": ["40B96610-B522-11D1-B3B4-00AA006EFDE7"],
    "ShellFldSetExt": ["6D5313C0-8C62-11D1-B2CD-006097DF8C11"],
    "ISFBand": ["D82BE2B0-5764-11D0-A96E-00C04FD705A2"],
    "QuickLinks": ["0E5CBF21-D15F-11D0-8301-00AA005B4383"],
    "NewMenu": ["D969A300-E7FF-11D0-A93B-00A0C90F2719"],
    "FolderItemsFDF": ["53C74826-AB99-4D33-ACA4-3117F51D3788"],
    "FolderItem": ["FEF10FA2-355E-4E06-9381-9B24D7F7CC88"],
    "CDocBrowsePropertyPage": ["3050F3B4-98B5-11CF-BB82-00AA00BDCE0B"],
    "CImageBrowsePropertyPage": ["3050F3B3-98B5-11CF-BB82-00AA00BDCE0B"],
    "CAnchorBrowsePropertyPage": ["3050F3BB-98B5-11CF-BB82-00AA00BDCE0B"],
    "DragDropHelper": ["4657278A-411B-11D2-839A-00C04FD918D0"],
    "HWShellExecute": ["FFB8655F-81B9-4FCE-B89C-9A6BA76D13E7"],
    "MountedVolume": ["12518493-00B2-11D2-9FA5-9E3420524153"],
    "DocHostUIHandler": ["7057E952-BD1B-11D1-8919-00C04FC2C836"],
    "DarwinAppPublisher": ["CFCCC7A0-A282-11D1-9082-006008059382"],
    "ToolbarExtButtons": ["2CE4B5D8-A28F-11D2-86C5-00C04F8EEA99"],
    "MSOButtons": ["178F34B8-A282-11D2-86C5-00C04F8EEA99"],
    "InternetButtons": ["1E796980-9CC5-11D1-A83F-00C04FC99D61"],
    "FileSysColumnProvider": ["0D2E74C4-3C34-11D2-A27E-00C04FC30871"],
    "LinkColumnProvider": ["24F14F02-7B1C-11D1-838F-0000F80461CF"],
    "DocFileColumnProvider": ["24F14F01-7B1C-11D1-838F-0000F80461CF"],
    "QueryAssociations": ["A07034FD-6CAA-4954-AC3F-97A27216F98A"],
    "ActiveDesktop": ["75048700-EF1F-11D0-9888-006097DEACF9"],
    "FileTypes": ["B091E540-83E3-11CF-A713-0020AFD79762"],
    "ProgressDialog": ["F8383852-FCD3-11D1-A6B9-006097DF5BD4"],
    "ACLCustomMRU": ["6935DB93-21E8-4CCC-BEB9-9FE3C77A297A"],
    "ACLMulti": ["00BB2765-6A77-11D0-A535-00C04FD7D062"],
    "ACLMRU": ["6756A641-DE71-11D0-831B-00AA005B4383"],
    "ACListISF": ["03C036F1-A186-11D0-824A-00AA005B4383"],
    "ACLHistory": ["00BB2764-6A77-11D0-A535-00C04FD7D062"],
    "AutoComplete": ["00BB2763-6A77-11D0-A535-00C04FD7D062"],
    "CURLSearchHook": ["CFBFAE00-17A6-11D0-99CB-00C04FD64497"],
    "CUrlHistory": ["3C374A40-BAE4-11CF-BF7D-00AA006946EE"],
    "InternetShortcut": ["FBF23B40-E3F0-101B-8488-00AA003E56F8"],
    "MenuBand": ["5B4DAE26-B807-11D0-9815-00C04FD91972"],
    "ShellThumbnailDiskCache": ["1EBDCF80-A200-11D0-A3A4-00C04FD706EC"],
    "CFSIconOverlayManager": ["63B51F81-C868-11D0-999C-00C04FD655E1"],
    "StgFolder": ["E773F1AF-3A65-4866-857D-846FC9C4598A"],
    "FolderShortcut": ["0AFACED1-E828-11D1-9187-B532F1E9575D"],
    "ShellTaskScheduler": ["603D3800-BD81-11D0-A3A5-00C04FD706EC"],
    "MyDocuments": ["450D8FBA-AD25-11D0-98A8-0800361B1103"],
    "Printers": ["2227A280-3AEA-1069-A2DE-08002B30309D"],
    "ControlPanel": ["21EC2020-3AEA-1069-A2DD-08002B30309D"],
    "RecycleBin": ["645FF040-5081-101B-9F08-00AA002F954E"],
    "ShellFSFolder": ["F3364BA0-65B9-11CE-A9BA-00AA004AE837"],
    "Internet": ["871C5380-42A0-1069-A2EA-08002B30309D"],
    "MyComputer": ["20D04FE0-3AEA-1069-A2D8-08002B30309D"],
    "NetworkShare": ["54A754C0-4BF0-11D1-83EE-00A0C90DC849"],
    "NetworkServer": ["C0542A90-4BF0-11D1-83EE-00A0C90DC849"],
    "NetworkDomain": ["46E06680-4BF0-11D1-83EE-00A0C90DC849"],
    "NetworkPlaces": ["208D2C60-3AEA-1069-A2D7-08002B30309D"],
    "ShellLink": ["00021401-0000-0000-C000-000000000046"],
    "ShellDesktop": ["00021400-0000-0000-C000-000000000046"],
    "CAccPropServices": ["B5F8350B-0548-48B1-A6EE-88BD00B4A5E7"],
    "SpeechUIServer": ["1443904B-34E4-40F6-B30F-6BEB81267B80"],
    "DxDiagProvider": ["A65B8071-3BFE-4213-9A5B-491DA4461CA7"],
    "DirectMusicAudioPathConfig": ["EE0B9CA0-A81E-11D3-9BD1-0080C7150A74"],
    "DirectSoundWave": ["8A667154-F9CB-11D2-AD8A-0060B0575ABC"],
    "DirectMusicContainer": ["9301E380-1F22-11D3-8226-D2FA76255D47"],
    "DirectMusicScript": ["810B5013-E88D-11D2-8BC1-00600893B1B6"],
    "DirectMusicPatternTrack": ["D2AC2897-B39B-11D1-8704-00600893B1BD"],
    "DirectMusicBand": ["79BA9E00-B6EE-11D1-86BE-00C04FBF8FEF"],
    "DirectMusicLoader": ["D2AC2892-B39B-11D1-8704-00600893B1BD"],
    "DirectMusicComposer": ["D2AC2890-B39B-11D1-8704-00600893B1BD"],
    "DirectMusicChordMap": ["D2AC288F-B39B-11D1-8704-00600893B1BD"],
    "DirectMusicStyle": ["D2AC288A-B39B-11D1-8704-00600893B1BD"],
    "DirectMusicGraph": ["D2AC2884-B39B-11D1-8704-00600893B1BD"],
    "DirectMusicSegmentState": ["D2AC2883-B39B-11D1-8704-00600893B1BD"],
    "DirectMusicSegment": ["D2AC2882-B39B-11D1-8704-00600893B1BD"],
    "DirectMusicPerformance": ["D2AC2881-B39B-11D1-8704-00600893B1BD"],
    "DirectMusicWaveTrack": ["EED36461-9EA5-11D3-9BD1-0080C7150A74"],
    "DirectMusicParamControlTrack": ["4BE0537B-5C19-11D3-8BDC-00600893B1B6"],
    "DirectMusicLyricsTrack": ["995C1CF5-54FF-11D3-8BDA-00600893B1B6"],
    "DirectMusicSegmentTriggerTrack": ["BAE4D665-4EA1-11D3-8BDA-00600893B1B6"],
    "DirectMusicMarkerTrack": ["55A8FD00-4288-11D3-9BD1-8A0D61C88835"],
    "DirectMusicScriptTrack": ["4108FA85-3586-11D3-8BD7-00600893B1B6"],
    "DirectMusicMuteTrack": ["D2AC2898-B39B-11D1-8704-00600893B1BD"],
    "DirectMusicChordMapTrack": ["D2AC2896-B39B-11D1-8704-00600893B1BD"],
    "DirectMusicBandTrack": ["D2AC2894-B39B-11D1-8704-00600893B1BD"],
    "DirectMusicSignPostTrack": ["F17E8672-C3B4-11D1-870B-00600893B1BD"],
    "DirectMusicMotifTrack": ["D2AC288E-B39B-11D1-8704-00600893B1BD"],
    "DirectMusicStyleTrack": ["D2AC288D-B39B-11D1-8704-00600893B1BD"],
    "DirectMusicCommandTrack": ["D2AC288C-B39B-11D1-8704-00600893B1BD"],
    "DirectMusicChordTrack": ["D2AC288B-B39B-11D1-8704-00600893B1BD"],
    "DirectMusicTimeSigTrack": ["D2AC2888-B39B-11D1-8704-00600893B1BD"],
    "DirectMusicSysExTrack": ["D2AC2887-B39B-11D1-8704-00600893B1BD"],
    "DirectMusicSeqTrack": ["D2AC2886-B39B-11D1-8704-00600893B1BD"],
    "DirectMusicTempoTrack": ["D2AC2885-B39B-11D1-8704-00600893B1BD"],
    "DirectMusicSynth": ["58C2B4D0-46E7-11D1-89AC-00A0C9054129"],
    "DirectMusicCollection": ["480FF4B0-28B2-11D1-BEF7-00C04FBF8FEF"],
    "DirectMusic": ["636B9F10-0C7D-11D1-95B2-0020AFDC7421"],
    "DirectPlay8LobbyClient": ["3B2B6775-70B6-45AF-8DEA-A209C69559F3"],
    "DirectPlay8LobbiedApplication": ["667955AD-6B3B-43CA-B949-BC69B5BAFF7F"],
    "DP8SP_BLUETOOTH": ["995513AF-3027-4B9A-956E-C772B3F78006"],
    "DP8SP_TCPIP": ["EBFE7BA0-628D-11D2-AE0F-006097B01411"],
    "DP8SP_SERIAL": ["743B5D60-628D-11D2-AE0F-006097B01411"],
    "DP8SP_MODEM": ["6D4A3650-628D-11D2-AE0F-006097B01411"],
    "DP8SP_IPX": ["53934290-628D-11D2-AE0F-006097B01411"],
    "DirectPlay8NATResolver": ["E4C1D9A2-CBF7-48BD-9A69-34A55E0D8941"],
    "DirectPlay8ThreadPool": ["FC47060E-6153-4B34-B975-8E4121EB7F3C"],
    "DirectPlay8Peer": ["286F484D-375E-4458-A272-B138E2F80A6A"],
    "DirectPlay8Server": ["DA825E1B-6830-43D7-835D-0B5AD82956A2"],
    "DirectPlay8Client": ["743F1DC6-5ABA-429F-8BDF-C54D03253DC2"],
    "DirectPlay8Address": ["934A9523-A3CA-4BC5-ADA0-D6D95D979421"],
    "DirectPlayVoiceTest": ["0F0F094B-B01C-4091-A14D-DD0CD807711A"],
    "DirectPlayVoiceServer": ["D3F5B8E6-9B78-4A4C-94EA-CA2397B663D3"],
    "DirectPlayVoiceClient": ["B9F3EB85-B781-4AC1-8D90-93A05EE37D7D"],
    "DirectSoundFullDuplex": ["FEA4300C-7959-4147-B26A-2377B9E7A91D"],
    "DirectSoundCapture8": ["E4BCAC13-7F99-4908-9A8E-74E3BF24B6E1"],
    "DirectSoundCapture": ["B0210780-89CD-11D0-AF08-00A0C925CD16"],
    "DirectSound8": ["3901CC3F-84B5-4FA4-BA35-AA8172B8A09B"],
    "DirectSound": ["47D4D946-62E8-11CF-93BC-444553540000"],
    "DirectPlayLobby": ["2FE8F810-B2A5-11D0-A787-0000F803ABFC"],
    "DirectPlay": ["D1EB6D20-8923-11D0-9D97-00A0C90A43CB"],
    "DirectInputDevice8": ["25E609E5-B259-11CF-BFC7-444553540000"],
    "DirectInput8": ["25E609E4-B259-11CF-BFC7-444553540000"],
    "DirectInputDevice": ["25E609E1-B259-11CF-BFC7-444553540000"],
    "DirectInput": ["25E609E0-B259-11CF-BFC7-444553540000"],
    "CDirectXFile": ["4516EC43-8F20-11D0-9B6D-0000C0781BC3"],
    "CDirect3DRM": ["4516EC41-8F20-11D0-9B6D-0000C0781BC3"],
    "CDirect3DRMClippedVisual": ["5434E72D-6D66-11D1-BB0B-0000F875865A"],
    "CDirect3DRMProgressiveMesh": ["4516EC40-8F20-11D0-9B6D-0000C0781BC3"],
    "CDirect3DRMTextureInterpolator": ["0DE9EAA8-3B84-11D0-9B6D-0000C0781BC3"],
    "CDirect3DRMMaterialInterpolator": ["0DE9EAA7-3B84-11D0-9B6D-0000C0781BC3"],
    "CDirect3DRMLightInterpolator": ["0DE9EAA6-3B84-11D0-9B6D-0000C0781BC3"],
    "CDirect3DRMMeshInterpolator": ["0DE9EAA3-3B84-11D0-9B6D-0000C0781BC3"],
    "CDirect3DRMFrameInterpolator": ["0DE9EAA2-3B84-11D0-9B6D-0000C0781BC3"],
    "CDirect3DRMViewportInterpolator": ["0DE9EAA1-3B84-11D0-9B6D-0000C0781BC3"],
    "CDirect3DRMShadow": ["4FA3569B-623F-11CF-AC4A-0000C03825A1"],
    "CDirect3DRMUserVisual": ["4FA3569A-623F-11CF-AC4A-0000C03825A1"],
    "CDirect3DRMAnimationSet": ["4FA35699-623F-11CF-AC4A-0000C03825A1"],
    "CDirect3DRMAnimation": ["4FA35698-623F-11CF-AC4A-0000C03825A1"],
    "CDirect3DRMMaterial": ["4FA35697-623F-11CF-AC4A-0000C03825A1"],
    "CDirect3DRMWrap": ["4FA35696-623F-11CF-AC4A-0000C03825A1"],
    "CDirect3DRMTexture": ["4FA35695-623F-11CF-AC4A-0000C03825A1"],
    "CDirect3DRMLight": ["4FA35694-623F-11CF-AC4A-0000C03825A1"],
    "CDirect3DRMFace": ["4FA35693-623F-11CF-AC4A-0000C03825A1"],
    "CDirect3DRMMeshBuilder": ["4FA35692-623F-11CF-AC4A-0000C03825A1"],
    "CDirect3DRMMesh": ["4FA35691-623F-11CF-AC4A-0000C03825A1"],
    "CDirect3DRMFrame": ["4FA35690-623F-11CF-AC4A-0000C03825A1"],
    "CDirect3DRMViewport": ["4FA3568F-623F-11CF-AC4A-0000C03825A1"],
    "CDirect3DRMDevice": ["4FA3568E-623F-11CF-AC4A-0000C03825A1"],
    "XACTDebugEngine": ["0AA000AC-F404-11D9-BD7A-0010DC4F8F81"],
    "XACTAuditionEngine": ["0AA000AB-F404-11D9-BD7A-0010DC4F8F81"],
    "XACTEngine": ["0AA000AA-F404-11D9-BD7A-0010DC4F8F81"],
    "DirectDrawFactory2": ["B9DC4790-4AF1-11D1-8C4C-00C04FD930C5"],
    "DirectDrawClipper": ["593817A0-7DB3-11CF-A2DE-00AA00B93356"],
    "DirectDraw7": ["3C305196-50DB-11D3-9CFE-00C04FD930C5"],
    "DirectDraw": ["D7B70EE0-4340-11CF-B063-0020AFC2CD35"],
    "JavaProxy": ["D2029F40-8AB3-11CF-85FB-00401C608501"],
    "Proxy": ["17CCA71B-ECD7-11D0-B908-00A0C9223196"],
    "NodeManager": ["43136EB5-D36C-11CF-ADBC-00AA00A80033"],
    "StdJavaComModuleManager": ["AC680B41-CDA0-11D1-A936-0080C7C575C0"],
    "CodeStoreDB": ["DF3D9C23-AB4E-11D0-A732-00A0C9082637"],
    "JavaPackageManager": ["D2073C44-AB4F-11D0-A732-00A0C9082637"],
    "BrowserAppletControl": ["08B0E5C0-4FCB-11CF-AAA5-00401C608501"],
    "JavaRuntimeConfiguration": ["004CE610-CCD1-11D0-A9BA-00A0C908DB5E"],
    "JavaExecute": ["3EFB1800-C2A1-11CF-960C-0080C7C2BA87"],
    "OverlayIdentifier_SlowFile": ["7D688A77-C613-11D0-999B-00C04FD655E1"],
    "InfTee": ["F8388A40-D5BB-11D0-BE5A-0080C706568E"],
    "TextRender": ["E30629D3-27E5-11CE-875D-00608CB78066"],
    "CMpegAudioCodec": ["4A2286E0-7BEF-11CE-9BD9-0000E202599C"],
    "CMpegVideoCodec": ["FEB50740-7BEF-11CE-9BD9-0000E202599C"],
    "MPEG1Splitter": ["336475D0-942A-11CE-A870-00AA002FEAB5"],
    "MPEG1PacketPlayer": ["26C25940-4CA9-11CE-A828-00AA002FEAB5"],
    "FileSource": ["701722E0-8AE3-11CE-A85C-00AA002FEAB5"],
    "MPEG1Doc": ["E4BBD160-4269-11CE-838D-00AA0055595A"],
    "FilterGraphNoThread": ["E436EBB8-524F-11CE-9F53-0020AF0BA770"],
    "FilterGraph": ["E436EBB3-524F-11CE-9F53-0020AF0BA770"],
    "FilterMapper": ["E436EBB2-524F-11CE-9F53-0020AF0BA770"],
    "SystemClock": ["E436EBB1-524F-11CE-9F53-0020AF0BA770"],
    "ProtoFilterGraph": ["E436EBB0-524F-11CE-9F53-0020AF0BA770"],
    "AudioFileClip": ["A5EA8D32-253D-11D1-B3F1-00AA003761C5"],
    "VideoFileClip": ["A5EA8D31-253D-11D1-B3F1-00AA003761C5"],
    "SimpleCutList": ["A5EA8D30-253D-11D1-B3F1-00AA003761C5"],
    "CutListGraphBuilder": ["A5EA8D2F-253D-11D1-B3F1-00AA003761C5"],
    "CutListSource": ["A5EA8D20-253D-11D1-B3F1-00AA003761C5"],
    "DVMuxPropertyPage": ["4DB880E0-C10D-11D0-AFB9-00AA00B67A42"],
    "DVEncPropertiesPage": ["4150F050-BB6F-11D0-AFB9-00AA00B67A42"],
    "DVDecPropertiesPage": ["101193C0-0BFE-11D0-AF91-00AA00B67A42"],
    "ModexProperties": ["0618AA30-6BC4-11CF-BF36-00AA0055595A"],
    "VPVBIObject": ["814B9801-1C88-11D1-BAD9-00609744111A"],
    "VPObject": ["CE292861-FC88-11D0-9E69-00C04FD7C15B"],
    "QualityProperties": ["418AFB70-F8B8-11CE-AAC6-0020AF0B99A3"],
    "PerformanceProperties": ["59CE6880-ACF8-11CF-B56E-0080C7C4B68A"],
    "DirectDrawProperties": ["944D4C00-DD52-11CE-BF0E-00AA0055595A"],
    "DVDNavigator": ["9B8C4620-2C1A-11D0-8493-00A02438AD48"],
    "DvdGraphBuilder": ["FCC152B7-F372-11D0-8E00-00C04FD7C08B"],
    "MediaPropertyBag": ["CDBD8D00-C193-11D0-BD4E-00A0C911CE86"],
    "MemoryAllocator": ["1E651CC0-B199-11D0-8212-00C04FC32C45"],
    "FilterMapper2": ["CDA42200-BD88-11D0-BD4E-00A0C911CE86"],
    "DVDHWDecodersCategory": ["2721AE20-7E70-11D0-A5D6-28DB04C10000"],
    "ActiveMovieCategories": ["DA4E3DA0-D07D-11D0-BD50-00A0C911CE86"],
    "CMidiOutClassManager": ["4EFE2452-168A-11D1-BC76-00C04FB9453B"],
    "CWaveOutClassManager": ["E0F158E1-CB04-11D0-BD4E-00A0C911CE86"],
    "CWaveinClassManager": ["33D9A762-90C8-11D0-BD43-00A0C911CE86"],
    "CAcmCoClassManager": ["33D9A761-90C8-11D0-BD43-00A0C911CE86"],
    "CIcmCoClassManager": ["33D9A760-90C8-11D0-BD43-00A0C911CE86"],
    "CQzFilterClassManager": ["083863F1-70DE-11D0-BD40-00A0C911CE86"],
    "CVidCapClassManager": ["860BB310-5D01-11D0-BD3B-00A0C911CE86"],
    "CDeviceMoniker": ["4315D437-5B8C-11D0-BD3B-00A0C911CE86"],
    "SystemDeviceEnum": ["62BE5D10-60EB-11D0-BD3B-00A0C911CE86"],
    "VBISurfaces": ["814B9800-1C88-11D1-BAD9-00609744111A"],
    "OverlayMixer": ["CD8743A1-3736-11D0-9E69-00C04FD7C15B"],
    "Line21Decoder": ["6E8D4A20-310C-11D0-B79A-00AA003767A7"],
    "SeekingPassThru": ["060AF76C-68DD-11D0-8FC1-00C04FD9189D"],
    "DVMux": ["129D7E40-C10D-11D0-AFB9-00AA00B67A42"],
    "DVSplitter": ["4EB31670-9FC6-11CF-AF6E-00AA00B67A42"],
    "DVVideoEnc": ["13AA3650-BB6F-11D0-AFB9-00AA00B67A42"],
    "DVVideoCodec": ["B1B77C00-C3E4-11CF-AF79-00AA00B67A42"],
    "AVIMIDIRender": ["07B65360-C445-11CE-AFDE-00AA006C14F4"],
    "AviMuxProptyPage1": ["0A9AE910-85C0-11D0-BD42-00A0C911CE86"],
    "AviMuxProptyPage": ["C647B5C0-157C-11D0-BD23-00A0C911CE86"],
    "AviDest": ["E2510970-F137-11CE-8B67-00AA00A3F1A6"],
    "FileWriter": ["8596E5F0-0DA5-11D0-BD21-00A0C911CE86"],
    "AVICo": ["D76E2820-1563-11CF-AC98-00AA004C0FA9"],
    "AMovie": ["5F2759C0-7685-11CF-8B23-00805F6CEF60"],
    "PersistMonikerPID": ["E436EBB7-524F-11CE-9F53-0020AF0BA770"],
    "URLReader": ["E436EBB6-524F-11CE-9F53-0020AF0BA770"],
    "AsyncReader": ["E436EBB5-524F-11CE-9F53-0020AF0BA770"],
    "ACMWrapper": ["6A08CF80-0E18-11CF-A24D-0020AFD79767"],
    "AVIDec": ["CF49D4E0-1115-11CE-B03A-0020AF0BA770"],
    "AudioRecord": ["E30629D2-27E5-11CE-875D-00608CB78066"],
    "DSoundRender": ["79376820-07D0-11CF-A24D-0020AFD79767"],
    "AudioProperties": ["05589FAF-C356-11CE-BF01-00AA0055595A"],
    "AudioRender": ["E30629D1-27E5-11CE-875D-00608CB78066"],
    "ModexRenderer": ["07167665-5011-11CF-BF33-00AA0055595A"],
    "Dither": ["1DA08500-9EDC-11CF-BC10-00AA00AC74F6"],
    "Colour": ["1643E180-90F5-11CE-97D5-00AA0055595A"],
    "VideoRenderer": ["70E102B0-5556-11CE-97C0-00AA0055595A"],
    "AVIDocWriter": ["D3588AB1-0781-11CE-B03A-0020AF0BA770"],
    "AVIDoc": ["D3588AB0-0781-11CE-B03A-0020AF0BA770"],
    "MOVReader": ["44584800-F8EE-11CE-B2D4-00DD01101B85"],
    "FGControl": ["E436EBB4-524F-11CE-9F53-0020AF0BA770"],
    "CaptureProperties": ["1B544C22-FD0B-11CE-8C63-00AA0044B51F"],
    "VfwCapture": ["1B544C22-FD0B-11CE-8C63-00AA0044B51E"],
    "AviReader": ["1B544C21-FD0B-11CE-8C63-00AA0044B51E"],
    "AviSplitter": ["1B544C20-FD0B-11CE-8C63-00AA0044B51E"],
    "CutListCacheMemory": ["A5EA8D33-253D-11D1-B3F1-00AA003761C5"],
    "TVTunerFilterPropertyPage": ["266EEE41-6C63-11CF-8A03-00AA006ECB65"],
    "CrossbarFilterPropertyPage": ["71F96461-78F3-11D0-A18C-00A0C9118956"],
    "TVAudioFilterPropertyPage": ["71F96463-78F3-11D0-A18C-00A0C9118956"],
    "VideoProcAmpPropertyPage": ["71F96464-78F3-11D0-A18C-00A0C9118956"],
    "CameraControlPropertyPage": ["71F96465-78F3-11D0-A18C-00A0C9118956"],
    "AnalogVideoDecoderPropertyPage": ["71F96466-78F3-11D0-A18C-00A0C9118956"],
    "VideoStreamConfigPropertyPage": ["71F96467-78F3-11D0-A18C-00A0C9118956"],
    "ADsDSOObject": ["549365D0-EC26-11CF-8310-00AA00B505DB"],
    "ADsSecurityUtility": ["F270C64A-FFB8-4AE4-85FE-3A75E5347966"],
    "UmiLDAPQueryObject": ["CD5D4D76-A818-4F95-B958-7970FD9412CA"],
    "LDAPObject": ["05709878-5195-466C-9E64-487CE3CA20BF"],
    "WinNTObject": ["B8324185-4050-4220-980A-AB14623E063A"],
    "WinNTConnectionObject": ["7992C6EB-D142-4332-831E-3154C50A8316"],
    "LDAPConnectionObject": ["7DA2A9C4-0C46-43BD-B04E-D92B1BE27C45"],
    "Email": ["8F92A857-478E-11D1-A3B4-00C04FB950DC"],
    "FaxNumber": ["A5062215-4681-11D1-A3B4-00C04FB950DC"],
    "CaseIgnoreList": ["15F88A55-4680-11D1-A3B4-00C04FB950DC"],
    "OctetList": ["1241400F-4680-11D1-A3B4-00C04FB950DC"],
    "PostalAddress": ["0A75AFCD-4680-11D1-A3B4-00C04FB950DC"],
    "BackLink": ["FCBF906F-4080-11D1-A3AC-00C04FB950DC"],
    "ReplicaPointer": ["F5D1BADF-4080-11D1-A3AC-00C04FB950DC"],
    "Hold": ["B3AD3E13-4080-11D1-A3AC-00C04FB950DC"],
    "TypedName": ["B33143CB-4080-11D1-A3AC-00C04FB950DC"],
    "Timestamp": ["B2BED2EB-4080-11D1-A3AC-00C04FB950DC"],
    "Path": ["B2538919-4080-11D1-A3AC-00C04FB950DC"],
    "NetAddress": ["B0B71247-4080-11D1-A3AC-00C04FB950DC"],
    "Registrar": ["44EC053A-400F-11D0-9DCD-00A0C90391D3"],
    "CorMetaDataDispenserRuntime": ["1EC2DE53-75CC-11D2-9775-00A0C9B4D50C"],
    "CLR_v1_MetaData": ["005023CA-72B1-11D3-9FC4-00C04F79A0A3"],
    "CLR_v2_MetaData": ["EFEA471A-44FD-4862-9292-0C58D46E1F3A"],
    "Cor": ["BEE00010-EE77-11D0-A015-00C04FBBB884"],
    "CorMetaDataDispenser": ["E5CB7A31-7512-11D2-89CE-0080C792E5D8"],
    "CorMetaDataDispenserReg": ["435755FF-7397-11D2-9771-00A0C9B4D50C"],
    "CorMetaDataReg": ["87F3A1F5-7397-11D2-9771-00A0C9B4D50C"],
    "GPOReportProvider": ["18CBB703-4F47-4DCE-A5DD-3817DDBF8169"],
    "GPMMigrationTable": ["55AF4043-2A06-4F72-ABEF-631B44079C76"],
    "GPMMapEntry": ["8C975253-5431-4471-B35D-0626C928258A"],
    "GPMMapEntryCollection": ["0CF75D5B-A3A1-4C55-B4FE-9E149C41F66D"],
    "GPMResult": ["92101AC0-9287-4206-A3B2-4BDB73D225F6"],
    "GPMConstants": ["3855E880-CD9E-4D0C-9EAF-1579283A1888"],
    "GPMCSECollection": ["CF92B828-2D44-4B61-B10A-B327AFD42DA8"],
    "GPMClientSideExtension": ["C1A2E70E-659C-4B1A-940B-F88B0AF9C8A4"],
    "GPMTrustee": ["C54A700D-19B6-4211-BCB0-E8E2475E471E"],
    "GPMEnum": ["36ED64E5-7266-4545-8E14-1645EEBA2A90"],
    "GPMStatusMessage": ["4B77CC94-D255-409B-BC62-370881715A19"],
    "GPMStatusMsgCollection": ["2824E4BE-4BCC-4CAC-9E60-0E3ED7F12496"],
    "GPMAsyncCancel": ["372796A9-76EC-479D-AD6C-556318ED5F9D"],
    "GPMGPOLinksCollection": ["F6ED581A-49A5-47E2-B771-FD8DC02B6259"],
    "GPMGPOLink": ["C1DF9880-5303-42C6-8A3C-0488E1BF7364"],
    "GPMGPOCollection": ["7A057325-832D-4DE3-A41F-C780436A4E09"],
    "GPMGPO": ["D2CE2994-59B5-4064-B581-4D68486A16C4"],
    "GPMRSOP": ["489B0CAF-9EC2-4EB7-91F5-B6F71D43DA8C"],
    "GPMWMIFilterCollection": ["74DC6D28-E820-47D6-A0B8-F08D93D7FA33"],
    "GPMWMIFilter": ["626745D8-0DEA-4062-BF60-CFC5B1CA1286"],
    "GPMSOMCollection": ["24C1F147-3720-4F5B-A9C3-06B4E4F931D2"],
    "GPMBackupCollection": ["EB8F035B-70DB-4A9F-9676-37C25994E9DC"],
    "GPMBackup": ["ED1A54B8-5EFA-482A-93C0-8AD86F0D68C3"],
    "GPMSecurityInfo": ["547A5E8F-9162-4516-A4DF-9DDB9686D846"],
    "GPMPermission": ["5871A40A-E9C0-46EC-913E-944EF9225A94"],
    "GPMSearchCriteria": ["17AACA26-5CE0-44FA-8CC0-5259E6483566"],
    "GPMSOM": ["32D93FAC-450E-44CF-829C-8B22FF6BDAE1"],
    "GPMBackupDir": ["FCE4A59D-0F21-4AFA-B859-E6D0C62CD10C"],
    "GPMSitesContainer": ["229F5C42-852C-4B30-945F-C522BE9BD386"],
    "GPMDomain": ["710901BE-1050-4CB1-838A-C5CFF259E183"],
    "GPM": ["F5694708-88FE-4B35-BABF-E56162D5FBC8"],
    "KsIBasicAudioInterfaceHandler": ["B9F8AC3E-0F71-11D2-B72C-00C04FB6BD3D"],
    "HHCollectionWrapper": ["06A03425-C9EB-11D2-8CAA-0080C739E3E0"],
    "ComCacheCleanup": ["F7A4F1DA-96C3-4BCF-BEB3-1D9FFDE89EE9"],
    "TaskSymbol": ["44F9A03B-A3EC-4F3B-9364-08E0007F21DF"],
    "MMCDocConfig": ["F1E752C3-FD72-11D0-AEF6-00C04FB6DD2C"],
    "ScopeTree": ["7F1899DA-62A6-11D0-A2C6-00C04FD909DD"],
    "AppEventsDHTMLConnector": ["ADE6444B-C91F-4E37-92A4-5BB430A33340"],
    "Application": ["49B2791A-B1AE-4C90-9B8E-E860BA07F889"],
    "ConsolePower": ["F0285374-DFF1-11D3-B433-00C04F8ECD78"],
    "MMCVersionInfo": ["D6FEDB1D-CF21-4BD9-AF3B-C5468E9C6684"],
    "CTaskScheduler": ["148BD52A-A2AB-11CE-B11F-00AA00530503"],
    "CTask": ["148BD520-A2AB-11CE-B11F-00AA00530503"],
    "DOMDocument2": ["F6D90F11-9C73-11D3-B32E-00C04F990BB4"],
    "MXNamespaceManager40": ["88D969D6-F192-11D4-A65F-0040963251E5"],
    "MXNamespaceManager": ["88D969D5-F192-11D4-A65F-0040963251E5"],
    "SAXAttributes40": ["88D969CA-F192-11D4-A65F-0040963251E5"],
    "SAXAttributes30": ["3E784A01-F3AE-4DC0-9354-9526B9370EBA"],
    "SAXAttributes": ["4DD441AD-526D-4A77-9F1B-9841ED802FB0"],
    "MXHTMLWriter40": ["88D969C9-F192-11D4-A65F-0040963251E5"],
    "MXHTMLWriter30": ["853D1540-C1A7-4AA9-A226-4D3BD301146D"],
    "MXHTMLWriter": ["A4C23EC3-6B70-4466-9127-550077239978"],
    "MXXMLWriter40": ["88D969C8-F192-11D4-A65F-0040963251E5"],
    "MXXMLWriter30": ["3D813DFE-6C91-4A4E-8F41-04346A841D9C"],
    "MXXMLWriter": ["FC220AD8-A72A-4EE8-926E-0B7AD152A020"],
    "SAXXMLReader40": ["7C6E29BC-8B8B-4C3D-859E-AF6CD158BE0F"],
    "SAXXMLReader30": ["3124C396-FB13-4836-A6AD-1317F1713688"],
    "SAXXMLReader": ["079AA557-4A18-424A-8EEE-E39F0A8D41B9"],
    "ServerXMLHTTP40": ["88D969C6-F192-11D4-A65F-0040963251E5"],
    "ServerXMLHTTP30": ["AFB40FFD-B609-40A3-9828-F88BBE11E4E3"],
    "ServerXMLHTTP": ["AFBA6B42-5692-48EA-8141-DC517DCF0EF1"],
    "XMLHTTP40": ["88D969C5-F192-11D4-A65F-0040963251E5"],
    "XMLHTTP30": ["F5078F35-C551-11D3-89B9-0000F81FE221"],
    "XMLHTTP26": ["F5078F1E-C551-11D3-89B9-0000F81FE221"],
    "XMLHTTP": ["F6D90F16-9C73-11D3-B32E-00C04F990BB4"],
    "DSOControl40": ["88D969C4-F192-11D4-A65F-0040963251E5"],
    "DSOControl30": ["F5078F39-C551-11D3-89B9-0000F81FE221"],
    "DSOControl26": ["F5078F1F-C551-11D3-89B9-0000F81FE221"],
    "DSOControl": ["F6D90F14-9C73-11D3-B32E-00C04F990BB4"],
    "XSLTemplate40": ["88D969C3-F192-11D4-A65F-0040963251E5"],
    "XSLTemplate30": ["F5078F36-C551-11D3-89B9-0000F81FE221"],
    "XSLTemplate26": ["F5078F21-C551-11D3-89B9-0000F81FE221"],
    "XSLTemplate": ["2933BF94-7B36-11D2-B20E-00C04F983E60"],
    "XMLSchemaCache40": ["88D969C2-F192-11D4-A65F-0040963251E5"],
    "XMLSchemaCache30": ["F5078F34-C551-11D3-89B9-0000F81FE221"],
    "XMLSchemaCache26": ["F5078F1D-C551-11D3-89B9-0000F81FE221"],
    "XMLSchemaCache": ["373984C9-B845-449B-91E7-45AC83036ADE"],
    "FreeThreadedDOMDocument40": ["88D969C1-F192-11D4-A65F-0040963251E5"],
    "FreeThreadedDOMDocument30": ["F5078F33-C551-11D3-89B9-0000F81FE221"],
    "FreeThreadedDOMDocument26": ["F5078F1C-C551-11D3-89B9-0000F81FE221"],
    "FreeThreadedDOMDocument": ["F6D90F12-9C73-11D3-B32E-00C04F990BB4"],
    "DOMDocument40": ["88D969C0-F192-11D4-A65F-0040963251E5"],
    "DOMDocument30": ["F5078F32-C551-11D3-89B9-0000F81FE221"],
    "DOMDocument26": ["F5078F1B-C551-11D3-89B9-0000F81FE221"],
    "WiaVideo": ["3908C3CD-4478-4536-AF2F-10C25D4EF89A"],
    "SafeWia": ["0DAD5531-BF31-43AC-A513-1F8926BBF5EC"],
    "Wia": ["4EC4272E-2E6F-4EEB-91D0-EBC4D58E8DEE"],
    "Collection": ["6E27C0E7-1D45-4CA7-9BF7-BD6CDDAA1ADC"],
    "DeviceInfo": ["34E1C006-99D2-4335-B0B1-CE7B9FE5396C"],
    "Item": ["E6C45109-442C-4585-BE44-F5D2884E544A"],
    "WiaProtocol": ["13F3EA8B-91D7-4F0A-AD76-D2853AC8BECE"],
    "WiaLog": ["A1E75357-881A-419E-83E2-BB16DB197C68"],
    "WiaDevMgr": ["A1F4E726-8CF1-11D1-BF92-0060081ED811"],
    "StiEventHandler": ["8144B6F5-20A8-444A-B8EE-19DF0BB84BDB"],
    "WiaAutoPlayDropTarget": ["F1ABE2B5-C073-4DBA-B6EB-FD7A5111DD8F"],
    "WiaDefaultUi": ["D1621129-45C4-41AD-A1D1-AF7EAFABEEDC"],
    "Sti": ["B323F8E0-2E68-11D0-90EA-00AA0060F86C"],
    "IdentityUnmarshal": ["0000001B-0000-0000-C000-000000000046"],
    "HTMLFiltersCollection": ["3050F3EF-98B5-11CF-BB82-00AA00BDCE0B"],
    "BackgroundCopyManager": ["4991D34B-80A1-4291-83B6-3328366B9097"],
    "SMTPConnector": ["CD000008-8B95-11D1-82DB-00C04FB1625D"],
    "NNTPPostConnector": ["CD000009-8B95-11D1-82DB-00C04FB1625D"],
    "NNTPFinalConnector": ["CD000010-8B95-11D1-82DB-00C04FB1625D"],
    "NNTPEarlyConnector": ["CD000011-8B95-11D1-82DB-00C04FB1625D"],
    "TIFLoad": ["14EB8748-1753-4393-95AE-4F7E7A87AAD6"],
    "CCertAdmin": ["37EABAF0-7FB6-11D0-8817-00A0C903B83C"],
    "CCertView": ["A12D0F7A-1E84-11D1-9BD6-00C04FB683FA"],
    "CCertGetConfig": ["C6CC49B0-CE17-11D0-8833-00A0C903B83C"],
    "CCertConfig": ["372FCE38-4324-11D0-8810-00A0C903B83C"],
    "CCertRequest": ["98AFF3F0-5524-11D0-8812-00A0C903B83C"],
    "CCertServerPolicy": ["AA000926-FFBE-11CF-8800-00A0C903B83C"],
    "CCertServerExit": ["4C4A5E40-732C-11D0-8816-00A0C903B83C"],
    "CCertEncodeStringArray": ["19A76FE0-7494-11D0-8816-00A0C903B83C"],
    "CCertEncodeLongArray": ["4E0680A0-A0A2-11D0-8821-00A0C903B83C"],
    "CCertEncodeDateArray": ["301F77B0-A470-11D0-8821-00A0C903B83C"],
    "CCertEncodeCRLDistInfo": ["01FA60A0-BBFF-11D0-8825-00A0C903B83C"],
    "CCertEncodeAltName": ["1CFC4CDA-1271-11D1-9BD4-00C04FB683FA"],
    "CCertEncodeBitString": ["6D6B3CD8-1278-11D1-9BD4-00C04FB683FA"],
    "DHtmledDEInsertTableParam": ["47B0DFC7-B7A3-11D1-ADC5-006008A5848C"],
    "DHtmledDEGetBlockFmtNamesParam": ["8D91090E-B955-11D1-ADC5-006008A5848C"],
    "CMLStrAttrWStr": ["C454B4E0-510F-11D1-998C-00AA00601EA8"],
    "CMLStrAttrAStr": ["C454B4E1-510F-11D1-998C-00AA00601EA8"],
    "CMLStrAttrLocale": ["C454B4E2-510F-11D1-998C-00AA00601EA8"],
    "MSAATextMSAAControl": ["08CD963F-7A3E-4F5C-9BD8-D692BB043C5B"],
    "MSAATextAccStore": ["5440837F-4BFF-4AE5-A1B1-7722ECC6332A"],
    "MSAATextAccDictionary": ["6572EE16-5FE5-4331-BB6D-76A49C56E423"],
    "MSAATextAccServerDocMgr": ["6089A37E-EB8A-482D-BD6F-F9F46904D16D"],
    "MSAATextAccClientDocMgr": ["FC48CC30-4F3E-4FA1-803B-AD0E196A83B1"],
    "MSAATextDocWrap": ["BF426F7E-7A5E-44D6-830C-A390EA9462A3"],
    "ClusterReferenceObject": ["F2E60701-2631-11D1-89F1-00A0C90D061E"],
    "MSVideoControlAnalogTVTunerDevice": ["1C15D484-911D-11D2-B632-00C04F79498E"],
    "MSVideoControlBDATunerDevice": ["A2E3074E-6C3D-11D3-B653-00C04F79498E"],
    "MSVideoControlFilePlaybackDevice": ["37B0353C-A4C8-11D2-B634-00C04F79498E"],
    "MSVidWebDVD": ["011B3619-FE63-4814-8A84-15A194CE9CE3"],
    "MSVidWebDVDAdm": ["FA7C375B-66A7-4280-879D-FD459C84BB02"],
    "MSVideoControlVideoRenderer": ["37B03543-A4C8-11D2-B634-00C04F79498E", "24DC3975-09BF-4231-8655-3EE71F43837D"],
    "MSVideoControlAudioRenderer": ["37B03544-A4C8-11D2-B634-00C04F79498E"],
    "MSVideoControlStreamBufferEngineSink": [
        "4A5869CF-929D-4040-AE03-FCAFC5B9CD42",
        "9E77AAC4-35E5-42A1-BDC2-8F3FF399847C",
    ],
    "MSVideoControlStreamBufferEnginePlayback": ["AD8E510D-217F-409B-8076-29C5E73B98E8"],
    "MSVideoControlInputDeviceCollection": ["C5702CCC-9B79-11D3-B654-00C04F79498E"],
    "MSVideoControlOutputDeviceCollection": ["C5702CCD-9B79-11D3-B654-00C04F79498E"],
    "MSVideoControlVideoRendererDeviceCollect": ["C5702CCE-9B79-11D3-B654-00C04F79498E"],
    "MSVideoControlAudioRendererDeviceCollect": ["C5702CCF-9B79-11D3-B654-00C04F79498E"],
    "MSVideoControlFeatureCollection": ["C5702CD0-9B79-11D3-B654-00C04F79498E"],
    "MSVideoControlGenericComposition": ["2764BCE5-CC39-11D2-B639-00C04F79498E"],
    "MSVideoControlStreamBufferSourcetoGeneri": ["991DA7E5-953F-435B-BE5E-B92A05EDFC42"],
    "msvidctlMSEventBinder": ["577FAA18-4518-445E-8F70-1473F8CF4BA4"],
    "AutomationCompliantScalableRectangle": ["CB4276E6-7D5F-4CF1-9727-629C5E6DB6AE"],
    "PassportEncryption": ["41651BFA-A5C8-11D2-95DF-00C04F8E7A70"],
    "PassportFastAuth": ["5602E146-27F6-11D3-94DD-00C04F72DC08"],
    "PassportFactory": ["74EB2514-E239-11D2-95E9-00C04F8E7A70"],
    "AMTimeline": ["78530B75-61F9-11D2-8CAD-00A024580902"],
    "IAMTimelineObj": ["78530B78-61F9-11D2-8CAD-00A024580902"],
    "IAMTimelineSrc": ["78530B7A-61F9-11D2-8CAD-00A024580902"],
    "Xml2Dex": ["18C628EE-962A-11D2-8D08-00A0C9441E20"],
    "MediaLocator": ["CC1101F2-79DC-11D2-8CE6-00A0C9441E20"],
    "MediaDet": ["65BD0711-24D2-4FF7-9324-ED2E5D3ABAFA"],
    "MsGrab": ["C1F400A0-3F08-11D3-9F0B-006008039E37"],
    "NullRenderer": ["C1F400A4-3F08-11D3-9F0B-006008039E37"],
    "DxtCompositor": ["BB44391D-6ABD-422F-9E2E-385C9DFF51FC"],
    "DxtAlphaSetter": ["506D89AE-909A-44F7-9444-ABD575896E35"],
    "DxtKey": ["C5B19592-145E-11D3-9F04-006008039E37"],
    "BackgroundCopyQMgr": ["69AD4AEE-51BE-439B-A92C-86AE490E8B30"],
    "ByteBuffer": ["E126F8FF-A7AF-11D0-B88A-00C04FD424B9"],
    "SCardTypeConv": ["53B6AA67-3F56-11D0-916B-00AA00C18068"],
    "SCardCmd": ["D5778AE7-43DE-11D0-9171-00AA00C18068"],
    "SCardISO7816": ["53B6AA6C-3F56-11D0-916B-00AA00C18068"],
    "SCard": ["1461AAC7-6810-11D0-918F-00AA00C18068"],
    "SCardDatabase": ["1461AACC-6810-11D0-918F-00AA00C18068"],
    "SCardLocate": ["1461AAD1-6810-11D0-918F-00AA00C18068"],
    "trieditTriEditDocument": ["438DA5E0-F171-11D0-984E-0000F80270F8"],
    "SystemTuningSpace": ["D02AAC50-027E-11D3-9D8E-00C04F72D980"],
    "ATSCDigitalBroadcastTuningSpace": ["A2E30750-6C3D-11D3-B653-00C04F79498E"],
    "AnalogRadioTuningSpace": ["8A674B4C-1F63-11D3-B64C-00C04F79498E"],
    "AuxiliaryInputsTuningSpace": ["F9769A06-7ACA-4E39-9CFB-97BB35F0E77E"],
    "AnalogTVTuningSpace": ["8A674B4D-1F63-11D3-B64C-00C04F79498E"],
    "DVBTuningSpace": ["C6B14B32-76AA-4A86-A7AC-5C79AAF58DA7"],
    "DVBSatelliteTuningSpace": ["B64016F3-C9A2-4066-96F0-BD9563314726"],
    "ComponentTypesCollection": ["A1A2B1C4-0E3A-11D3-9D8E-00C04F72D980"],
    "ComponentType": ["823535A0-0318-11D3-9D8E-00C04F72D980"],
    "LanguageComponentType": ["1BE49F30-0E1B-11D3-9D8E-00C04F72D980"],
    "MPEG2ComponentType": ["418008F3-CF67-4668-9628-10DC52BE1D08"],
    "ATSCComponentType": ["A8DCF3D5-0780-4EF4-8A83-2CFFAACB8ACE"],
    "ComponentsCollection": ["809B6661-94C4-49E6-B6EC-3F0F862215AA"],
    "Component": ["59DC47A8-116C-11D3-9D8E-00C04F72D980"],
    "MPEG2Component": ["055CB2D7-2969-45CD-914B-76890722F112"],
    "XDSToRat": ["C5C5C5F0-3ABC-11D6-B25B-00C04FA0C026"],
    "EvalRat": ["C5C5C5F1-3ABC-11D6-B25B-00C04FA0C026"],
    "WbemAdsWMIDSExtension": ["F0975AFE-5C7F-11D2-8B74-00104B2AFB41"],
    "WbemDispDefines": ["4A249B72-FC9A-11D1-8B1E-00600806D9B6"],
    "WbemDispA": ["04B83D62-21AE-11D2-8B33-00600806D9B6"],
    "WbemDispA2": ["D6BDAFB2-9435-491F-BB87-6AA0F0BC31A2"],
    "WPObjWPObj": ["53DEFDE0-9222-11CF-9ED3-00AA004C120C"],
    "AACMFTEncoder": ["93af0c51-2275-45d2-a35b-f2ba21caed00"],
    "AC3ByteStreamPlugin": ["46031ba1-083f-47d9-8369-23c92bdab2ff"],
    "AC3ParserClassFactory": ["9b67e7b7-12ba-4b81-9874-e96d8c7c07f8"],
    "ADTSByteStreamPlugin": ["926f41f7-003e-4382-9e84-9e953be10562"],
    "ADTSParserClassFactory": ["fa869d29-ba80-4d7d-a867-0df126f980a5"],
    "ALawCodecWrapper": ["36cb6e0c-78c1-42b2-9943-846262f31786"],
    "AMAudioData": ["f2468580-af8a-11d0-8212-00c04fc32c45"],
    "AMAudioStream": ["8496e040-af4c-11d0-8212-00c04fc32c45"],
    "AMDirectDrawStream": ["49c47ce4-9ba4-11d0-8212-00c04fc32c45"],
    "AMMediaTypeStream": ["cf0f2f7c-f7bf-11d0-900d-00c04fd9189d"],
    "AMMultiMediaStream": ["49c47ce5-9ba4-11d0-8212-00c04fc32c45"],
    "AMTimelineComp": ["74d2ec80-6233-11d2-8cad-00a024580902"],
    "AMTimelineEffect": ["74d2ec82-6233-11d2-8cad-00a024580902"],
    "AMTimelineGroup": ["f6d371e1-b8a6-11d2-8023-00c0df10d434"],
    "AMTimelineTrack": ["8f6c3c50-897b-11d2-8cfb-00a0c9441e20"],
    "AMTimelineTrans": ["74d2ec81-6233-11d2-8cad-00a024580902"],
    "ASCLOG": ["ff160657-de82-11cf-bc0a-00aa006111e0"],
    "ASCLOGUI": ["31dcab87-bb3e-11d0-9299-00c04fb6678b"],
    "ATHostActivator": ["00000341-0000-0000-c000-000000000046"],
    "ATSCNetworkPropertyPage": ["e3444d16-5ac4-4386-88df-13fd230e1dda"],
    "ATSCNetworkProvider": ["0dad2fdd-5fd7-11d3-8f50-00c04f7971e2"],
    "AVIByteStreamPlugin": ["7afa253e-f823-42f6-a5d9-714bde467412"],
    "AVIDraw": ["a888df60-1e90-11cf-ac98-00aa004c0fa9"],
    "AboutWindowsCommand": ["20e8b2fe-7568-46ae-a0db-76b7f469b92d"],
    "AboveLockAppLaunchCallback": ["7d0e1fd9-e110-45a9-9c24-95e7680d9cb8"],
    "AboveLockViewManager": ["fe2bea70-520d-470e-a69f-f75f245a7581"],
    "AccessibilityDock": ["b11cd547-573e-4d53-8719-d55634e3f458"],
    "AccessibilityDockingService": ["29ce1d46-b481-4aa0-a08a-d3ebc8aca402"],
    "AccessibilitySettingHandler": ["1ce75ee1-e27e-4d22-804f-c76d53192d55"],
    "AccessibilitySettingMonitor": ["b58ed99d-a528-4e1b-a26c-0204d5a43718"],
    "ActionExecutionBroker": ["2b32ecc3-c3bb-4701-82bb-eb7fe370d999"],
    "ActionExecutionBrokerCF": ["f32e8fa6-a99f-4e9b-af78-c929ebb73589"],
    "ActionIdCommand": ["9c07355e-c50a-45d2-b4a3-0a8235f8047f"],
    "ActionIdExecute": ["b9f8535e-bf74-41c2-a6a6-7124442450dc"],
    "ActivationErrorPopupFactory": ["e7de514c-bbbc-41d4-8838-4bb0fe21229a"],
    "ActivationLayoutPreferences": ["0dc1ab8b-a52d-4ba8-bd76-e2819386fb2f"],
    "ActivationProperties": ["00000345-0000-0000-c000-000000000046"],
    "ActivationPropertiesIn": ["00000338-0000-0000-c000-000000000046"],
    "ActivationPropertiesOut": ["00000339-0000-0000-c000-000000000046"],
    "ActivationStore": ["00000351-0000-0000-c000-000000000046"],
    "ActivationStoreHelper": ["62ba9430-9624-46ec-9034-d5ffabb0fca0"],
    "ActiveMonitorNotifier": ["0ad2c288-a3bd-418a-89dc-2483898fdd2e"],
    "ActiveXPlugin": ["06dd38d3-d187-11cf-a80d-00c04fd74ad8"],
    "ActiveXProxy": ["c90250f3-4d7d-4991-9b69-a5c5bc1c2ae6"],
    "ActivityItemEnum": ["1c278ed9-59cb-4179-9549-3c46030636b4"],
    "AdSyncTask": ["2ae64751-b728-4d6b-97a0-b2da2e7d2a3b"],
    "AddMediaServerCommand": ["d7bfd8f3-678c-4827-b84b-0e5fc6d15be3"],
    "AddNewAppFolder": ["15eae92e-f17a-4431-9f28-805e482dafd4"],
    "AddinDesigner": ["ac0714f6-3d04-11d1-ae7d-00a0c90f26f4"],
    "AddinInstance": ["ac0714f7-3d04-11d1-ae7d-00a0c90f26f4"],
    "AddressEditBox": ["a542e116-8088-4146-a352-b0d06e7f6af6"],
    "AdvancedOptionsComWrapper": ["2f2165ff-2c2d-4612-87b2-cc8e5002ef4c"],
    "AdvancedSettingsWriter": ["ffe1df5f-9f06-46d3-af27-f1fc10d63892"],
    "AgHostCoreWindowFactoryProxy": ["4921ded2-3aa5-42bd-999f-69da2dfb9f8d"],
    "AggStdMarshal": ["00000027-0000-0008-c000-000000000046"],
    "AggregateImageList": ["5c7827c4-7381-496f-9463-1a1522eb7f04"],
    "AggregatePropertyProvider": ["37a95411-c7fc-43b7-8694-4e9d7d00337f"],
    "AllocPresenter": ["99d54f63-1a69-41ae-aa4d-c976eb3f0713"],
    "AllocPresenterDDXclMode": ["4444ac9e-242e-471b-a3c7-45dcd46352bc"],
    "AlphaListener": ["8add018c-5c5f-43c5-be1e-07bae85593b7"],
    "AlphaListenerXml": ["01f3e95c-7d8f-46e6-a408-9ba5d1fa5067"],
    "AmiProDocument": ["0003002f-0000-0000-c000-000000000046"],
    "AnimateWindowSize": ["713aacc8-3b71-435c-a3a1-be4e53621ab1"],
    "AntiMoniker": ["00000305-0000-0000-c000-000000000046"],
    "AntiPhishingBrowserSolution": ["e48b2549-d510-4a76-8a5f-fc126a6215f0"],
    "AppBar": ["123cc4e1-b009-4d78-a83e-c073750d829f"],
    "AppContentXMLPropertyStore": ["cfd82661-9b9e-4c87-9dcb-e0fd11681b44"],
    "AppFutureAccessListSettingHandler": ["a005f812-cd2c-48d8-b893-aad2d39589ae"],
    "AppInstanceFolder": ["64693913-1c21-4f30-a98f-4e52906d3b56"],
    "AppMruListSettingHandler": ["18ade8cb-d68c-44d9-a5c5-0e3d8a874583"],
    "AppPoolingActivator": ["68c67565-410e-45e6-8560-4091ae193481"],
    "AppRep": ["3bc4ee9f-1fc1-44db-81fa-ad94dec7af30"],
    "AppRepParm": ["7ded4d39-be20-4ab6-983a-eb4adcd9c93d"],
    "AppResizeOperation": ["44d8c276-eb39-4be0-9a48-b4c998a65b81"],
    "AppShellVerbHandler": ["4ed3a719-cea8-4bd9-910d-e252f997afc2"],
    "AppStartupLink": ["273eb5e7-88b0-4843-bfef-e2c81d43aae5"],
    "AppSuggestedLocationsFolder": ["c57a6066-66a3-4d91-9eb9-41532179f0a5"],
    "AppSuggestedLocationsIconHandler": ["913a6daa-57ee-4551-9ada-64d329d306a5"],
    "AppSwitchOperation": ["265563eb-da85-4a7b-b570-7a7db92edbe7"],
    "AppSyncSettingHandler": ["aa0eb6fc-a8eb-4fd9-a861-0014b374076e"],
    "AppSyncSettingLocalServer": ["8b455e45-7cc8-4253-af5b-b2cd3313e9cc"],
    "AppSyncSettingMonitor": ["a6439333-78d2-4ffd-a20d-53b0edc704ba"],
    "AppTransitionManager": ["aca965c4-d406-4531-b6d9-c099d5d8edea"],
    "AppUpdateFolder": ["d450a8a1-9568-45c7-9c0e-b4f9fb4537bd"],
    "AppUrlDefaults": ["4e29e41b-d022-4d7d-9ade-e42352c23dd6"],
    "AppVisibility": ["7e5fe3d9-985f-4908-91f9-ee19f9fd1514"],
    "AppearPropPage": ["e49741e9-93a8-4ab1-8e96-bf4482282e9c"],
    "AppletOCX": ["08b0e5c0-4fcb-11cf-aaa5-00401c608501"],
    "ApplicationActivationClient": ["79ceeebe-bde0-4c05-9d92-155f78bb7d2b"],
    "ApplicationActivationImpl": ["dc28a608-b55f-46ff-b0db-e2c85b332463"],
    "ApplicationActivationManager": ["45ba127d-10a8-46ea-8ab7-56ea9078943c"],
    "ApplicationActivationManagerSTAShim": ["15ad6165-baa2-492b-b3cc-e7925d2fab97"],
    "ApplicationActivationManagerShim": ["6c3ee638-b588-4d7d-b30a-e7e36759305d"],
    "ApplicationAssociationRegistration": ["591209c7-767b-42b2-9fba-44ee4615f2c7"],
    "ApplicationAssociationRegistrationUI": ["1968106d-f3b5-44cf-890e-116fcb9ecef1"],
    "ApplicationCache": ["30510829-98b5-11cf-bb82-00aa00bdce0b"],
    "ApplicationDataPersistence": ["727af81a-cacf-4e37-9df7-a22ed974f298"],
    "ApplicationDesignModeSettings": ["958a6fb5-dcb2-4faf-aafd-7fb054ad1a3b"],
    "ApplicationDestinations": ["86c14003-4d6b-4ef3-a7b4-0506663b2e68"],
    "ApplicationDocumentLists": ["86bec222-30f2-47e0-9f25-60d11cd75c28"],
    "ApplicationPreLaunch": ["ad7572ad-86a5-4211-bc54-a438e550a740"],
    "ApplicationTargetingTracker": ["c5b454cd-3ca1-4b3a-a1d0-2cb5cd6bd985"],
    "ApplicationTileInformation": ["c578375f-8441-4733-bf71-027683af538b"],
    "ApplicationViewBroker": ["7ed25d63-48e5-4be3-8539-3040b0b8991c"],
    "ApplyPropertiesUndoUnit": ["14795a8f-78f3-47bd-acb6-e767414fe293"],
    "AppxBundleFactory": ["378e0446-5384-43b7-8877-e7dbdd883446"],
    "AppxFactory": ["5842a140-ff9f-4166-8f5c-62f5b7b0c781"],
    "AppxPackageEditor": ["f004f2ca-aebc-4b0d-bf58-e516d5bcc0ab"],
    "AppxPackagingDiagnosticEventSinkManager": ["50ca0a46-1588-4161-8ed2-ef9e469ced5d"],
    "AsfByteStreamPlugin": ["41457294-644c-4298-a28a-bd69f2c0cf3b"],
    "AssemblyLinker": ["f7e02368-a7f4-471f-8c5e-9839ed57cb5e"],
    "AssocApplicationElement": ["0c2bf91b-8746-4fb1-b4d7-7c03f890b168"],
    "AssocClientElement": ["3c81e7fa-1f3b-464a-a350-114a25beb2a2"],
    "AssocClsidElement": ["57aea081-5ee9-4c27-b218-c4b702964c54"],
    "AssocExtensionElement": ["039a5dea-159c-48b8-9dd3-56413a78fde2"],
    "AssocFixedProgIdForFileElement": ["a4917c8e-34de-4728-a6e5-c2eb34ef2025"],
    "AssocFixedProgidElement": ["e88c538a-c610-46d5-aa52-d76bf6adb1fc"],
    "AssocFolderElement": ["7566df7a-42cc-475d-a025-1205ddf4911f"],
    "AssocKindElement": ["cdb9b0ec-fe14-4303-84a4-defdc04a0d6f"],
    "AssocLocationElement": ["f7dcd9cf-dd0b-4691-a7b3-67f017a4761e"],
    "AssocPerceivedElement": ["0dc5fb21-b93d-4e3d-bb2f-ce4e36a70601"],
    "AssocProgidElementIgnoreUnknown": ["503167c9-0060-471d-9dea-c1e3306ec347"],
    "AssocPropertyStore": ["f507f854-308b-401e-a1b7-b55ba6ba679a"],
    "AssocProtocolElement": ["5e9b1783-9d2d-449c-a5b2-123d05228c46"],
    "AssocProtocolElementIgnoreUnknown": ["a94f0ef7-639b-416b-b2b1-10aeee64a514"],
    "AssocShellElement": ["c461837f-ea59-494a-b7c6-cd040e37185e"],
    "AssocStarElement": ["0633b720-6926-404c-b6b3-923b1a501743"],
    "AssocSyncRootShellElement": ["62896085-4e56-4eda-8127-e4a245aff6f7"],
    "AssocSystemElement": ["a6c4baad-4af5-4191-8685-c2c8953a148c"],
    "AssocUnknownProgidElement": ["e337427c-c96d-4183-9c00-b7b8671df7b5"],
    "AudMixer": ["036a9790-c153-11d2-9ef7-006008039e37"],
    "AudioCaptureMFT": ["14dd9a1c-7cff-41be-b1b9-ba1ac6ecb571"],
    "AudioClientBinder": ["41fccc3a-1fa1-4949-953a-6ee61c46a4d1"],
    "AudioCompressorCategory": ["33d9a761-90c8-11d0-bd43-00a0c911ce86"],
    "AudioFlyoutController": ["a1ebdbd0-e4ba-4db3-8df6-c91534061ef4"],
    "AudioInputDeviceCategory": ["33d9a762-90c8-11d0-bd43-00a0c911ce86"],
    "AudioInputMixerProperties": ["2ca8ca52-3c3f-11d2-b73d-00c04fb6bd3d"],
    "AudioPlayerFacade": ["dad220c1-b1a2-43a8-8b11-51c3eff05053"],
    "AudioRendererAdvancedProperties": ["37e92a92-d9aa-11d2-bf84-8ef2b1555aed"],
    "AudioRendererCategory": ["e0f158e1-cb04-11d0-bd4e-00a0c911ce86"],
    "AudioResamplerMediaObject": ["f447b69e-1884-4a7e-8055-346f74d6edb3"],
    "AudioReverb": ["c2633b16-471b-4498-b8c5-4f0959e2ec09"],
    "AudioVolumeMeter": ["4fc3b166-972a-40cf-bc37-7db03db2fba3"],
    "AudioVolumeShellService": ["3bf043ef-a974-49b3-8322-b853cf1e5ec5"],
    "AuthUILegacyShutdownDialog": ["b1325ef5-dd4d-4988-a2b3-c776ad45d0d6"],
    "AuthUISessionControl": ["f9bcb2f0-7df0-4a39-932e-bdef29dfb16b"],
    "AuthUIShutdownChoices": ["14ce31dc-abc2-484c-b061-cf3416aed8ff"],
    "AuthUIShutdownFlyout": ["5affd66e-3c01-4217-be18-414c155f67b1"],
    "AutoPlayDirect": ["bf8841c9-378a-4cad-b4fc-5091366cbc0d"],
    "AutoPlayVerb": ["f26a669a-bcbb-4e37-abf9-7325da15f931"],
    "AutoScrollBehavior": ["26126a51-3c70-4c9a-aec2-948849eeb093"],
    "AutomaticDestinationList": ["f0ae1542-f497-484b-a175-a20db09144ba"],
    "AutomaticUpdates": ["bfe18e9c-6d87-4450-b37c-e02f0b373803"],
    "AutomationCM": ["3f454f0e-42ae-4d7c-8ea3-328250d6e272"],
    "AutoplayContentHandler": ["b33f0d7a-1571-4022-b710-d26e9b87deb8"],
    "AutoplayDeviceEventHandlerInfo": ["68e52c1c-37cb-41d2-afe1-1e77d5f10676"],
    "AutoplayDeviceHandler": ["c68411ea-1396-48f3-af98-b7f657e35c20"],
    "AutoplayHandler": ["7b31547e-ef7e-479b-9494-2216dc179e61"],
    "AutoplayKnownDevices": ["9207d8c7-e7c8-412e-87f8-2e61171bd291"],
    "AvailableNetworksExperienceFlow": ["f2506cd7-82c2-43d9-a1d3-f85f5efe7d09"],
    "AvailableNetworksExperienceFlowCF": ["c55e0038-9b1b-45da-bb96-c8b4a4490a72"],
    "AzAuthorizationStore": ["b2bcff59-a757-4b0b-a1bc-ea69981da69e"],
    "AzBizRuleContext": ["5c2dc96f-8d51-434b-b33c-379bccae77c3"],
    "AzPrincipalLocator": ["483afb5d-70df-4e16-abdc-a1de4d015a3e"],
    "BackOperation": ["bd7ca047-659a-45d5-9706-f734f01d7ceb"],
    "BackgroundTaskCapability": ["53067330-01ce-4027-947f-ff8580e92463"],
    "BackgroundUploadsMonitor": ["9b39403c-8b6d-430d-ae71-9ee1dc6e74c5"],
    "BackupRestoreServices": ["08762ea6-b6ef-45fb-b0a5-2f940a849e12"],
    "BackupSettings": ["49a832d7-c7b3-4556-8716-5bdc745c3c1b"],
    "BackupUploadTaskHandler": ["60a4c78c-e2b8-4e6e-876f-da203b02c05e"],
    "BamThrottleSettings": ["13ee36d8-2efd-44f6-af3b-75ff35e6c691"],
    "BandProxy": ["73cfd649-cd48-4fd8-a272-2070ea56526b"],
    "BandSiteMenu": ["ecd4fc4e-521c-11d0-b792-00a0c90312e1"],
    "BibRef": ["0003002c-0000-0000-c000-000000000046"],
    "BidiRequest": ["b9162a23-45f9-47cc-80f5-fe0fe9b9e1a2"],
    "BidiRequestContainer": ["fc5b8a24-db05-4a01-8388-22edf6c2bbba"],
    "BidiSpl": ["2a614240-a4c5-4c33-bd87-1bc709331639"],
    "BinaryAutoList": ["384ea5ae-ade1-4e8a-8a9b-7bea78fff1e9"],
    "BlobProtocol": ["2f3507bc-862f-44da-8f38-2fd4ab22d02b"],
    "BlockNotificationChannelsCallback": ["e36c2344-af40-4fc0-b24c-4930b809f3e1"],
    "BlockRange": ["b507ca27-2204-11dd-966a-001aa01bbc58"],
    "BlockRangeList": ["b507ca28-2204-11dd-966a-001aa01bbc58"],
    "BooleanCheckMarkControl": ["92ab5af7-a374-417e-b2e2-9b317353a322"],
    "BooleanSetting": ["94971f89-d2eb-44ed-a217-a9bf27b74b65"],
    "BooleanSymbolExpressionEvaluator": ["5dadf1ee-bcbe-46ce-badf-271992c112a3"],
    "BootOptions": ["2c941fce-975b-59be-a960-9a2a262853a5"],
    "BootTraceSession": ["03837538-098b-11d8-9414-505054503030"],
    "BootTraceSessionCollection": ["03837539-098b-11d8-9414-505054503030"],
    "BreadcrumbBar": ["596742a5-1393-4e13-8765-ae1df71acafb"],
    "BroadcastEventService": ["0b3ffb92-0919-4934-9d5b-619c719d0202"],
    "BrowserApplicationState": ["e569bde7-a8dc-47f3-893f-fd2b31b3eefd"],
    "BrowserBand": ["07c45bb1-4a8c-4642-a1f5-237e7215ff66"],
    "BrowserBroker": ["0002df02-0000-0000-c000-000000000046"],
    "BrowserFavoritesSettingHandler": ["f440168e-a06a-4c25-b6eb-01705985e826"],
    "BrowserFrameTestHelper": ["95d744e2-4cea-47a7-8c81-4a6b17903671"],
    "BrowserHistorySettingHandler": ["bf77196e-24ef-4a02-bd52-a626d7ae837e"],
    "BrowserNavigationBar": ["43886cd5-6529-41c4-a707-7b3c92c05e68"],
    "BrowserProgressAggregator": ["104846ab-42b1-4e38-a80d-136f78c3f258"],
    "BrowserSettingHandlerFactory": ["548f0526-b0ec-4915-9c4e-9cee327cf105"],
    "BrowserSettingMonitor": ["fc46b571-5d16-4dce-8f26-f7138c09c768"],
    "BrowserThreadHandshake": ["e69fd98d-7ebe-4c01-bfed-67b4e4616a49"],
    "BrowserThreadState": ["a6b222ab-a5ea-4899-b230-084657eddc7d"],
    "BrowserTypedURLsSettingHandler": ["adbdef00-9a50-4dc6-b945-cb95b4233e3c"],
    "BurnAudioCDExtension": ["f83cbf45-1c37-4ca1-a78a-28bcb91642ec"],
    "BurnExecute": ["b91a4db4-3630-11dc-9eaa-00161718cf63"],
    "ByValueConfirmationInterrupt": ["c2467d33-71c5-4057-977c-e847c2286882"],
    "ByValueConflictInterrupt": ["065377f7-9876-4d5a-9f2a-1b4721255a67"],
    "CAC3DecMediaObject": ["03d7c802-ecfa-47d9-b268-5fb3e310dee4"],
    "CAImmLayer": ["b676db87-64dc-4651-99ec-91070ea48790"],
    "CAccTextRange": ["0f7b08e8-94f0-4103-aa4f-f1aadbe93166"],
    "CActiveIMM12": ["c1ee01f2-b3b6-4a6a-9ddd-e988c088ec82"],
    "CActiveIMM12_Trident": ["50d5107a-d278-4871-8989-f4ceaaf59cfc"],
    "CAsfTocParser": ["9b77c0f2-8735-46c5-b90f-5f0b303ef6ab"],
    "CAttribute": ["3050f6a1-98b5-11cf-bb82-00aa00bdce0b"],
    "CAviTocParser": ["3adce5cc-13c8-4573-b328-ed438eb694f9"],
    "CBackOffController": ["9e175b7f-f52a-11d8-b9a5-505054503030"],
    "CBase": ["3050f49a-98b5-11cf-bb82-00aa00bdce0b"],
    "CCAFilter": ["3d07a539-35ca-447c-9b05-8d85ce924f9e"],
    "CCSSFilterHandler": ["5aaf51b1-b1f0-11d1-b6ab-00a0c90833e9"],
    "CCanvasGradient": ["169f19e5-0317-4962-a72c-273699b2efd0"],
    "CCanvasPattern": ["9acb81fb-ab3b-4250-b7f1-f30a3ee3e55a"],
    "CCaret": ["30510821-98b5-11cf-bb82-00aa00bdce0b"],
    "CClientCaps": ["7e8bc44e-aeff-11d1-89c2-00c04fb6bfc4"],
    "CClusterDetectorDmo": ["36e820c4-165a-4521-863c-619e1160d4d4"],
    "CClusterDetectorEx": ["47354492-827e-4b8a-b318-c80eba1381f0"],
    "CColorControlDmo": ["798059f0-89ca-4160-b325-aeb48efe4f9a"],
    "CColorConvertDMO": ["98230571-0087-4204-b020-3282538e57d3"],
    "CColorLegalizerDmo": ["fdfaa753-e48e-4e33-9c74-98a27fc6726a"],
    "CComputedStyle": ["3050f6c4-98b5-11cf-bb82-00aa00bdce0b"],
    "CCscProtocolHandler": ["a373f500-7a87-11d3-b1c1-00c04f68155c"],
    "CDBurnFolder": ["00eebf57-477d-4084-9921-7ab3c2c9459d"],
    "CDBurnGlobalSettingsDialog": ["66eea0f5-001a-4073-a496-783f86fcf4c0"],
    "CDTVAudDecoderDS": ["8e269032-fe03-4753-9b17-18253c21722e"],
    "CDTVVidDecoderDS": ["64777dc8-4e24-4beb-9d19-60a35be1daaf"],
    "CDVDecoderMediaObject": ["e54709c5-1e17-4c8d-94e7-478940433584"],
    "CDVEncoderMediaObject": ["c82ae729-c327-4cce-914d-8171fefebefb"],
    "CDeColorConvMediaObject": ["49034c05-f43c-400f-84c1-90a683195a3a"],
    "CDeskHtmlProp": ["3fc0b520-68a9-11d0-8d77-00c04fd70822"],
    "CDevProxy": ["8ac3587a-4ae7-42d8-99e0-0a6013eef90f"],
    "CDisplayPointer": ["3050f69f-98b5-11cf-bb82-00aa00bdce0b"],
    "CDocObjectView": ["c2ea74e0-0ed2-11cf-a9bb-00aa004ae837"],
    "CDockingBarPropertyBag": ["4af4a5fc-912a-11d1-b945-00a0c90312e1"],
    "CDocument": ["3050f83b-98b5-11cf-bb82-00aa00bdce0b"],
    "CDraw": ["0003001b-0000-0000-c000-000000000046"],
    "CDwnBindInfo": ["3050f3c2-98b5-11cf-bb82-00aa00bdce0b"],
    "CEGatherNotify": ["9e175b6e-f52a-11d8-b9a5-505054503030"],
    "CEGatherNotifyInline": ["d16b87de-029e-4c85-92c8-ed8bbc5e882c"],
    "CEGatheringManager": ["9e175b69-f52a-11d8-b9a5-505054503030"],
    "CEdgeManagerBroker": ["333d0063-01b8-4216-8a2f-dec7fc227dd0"],
    "CElement": ["3050f233-98b5-11cf-bb82-00aa00bdce0b"],
    "CElementCollection": ["3050f627-98b5-11cf-bb82-00aa00bdce0b"],
    "CEventBindingManager": ["53d01080-af98-11d0-a9eb-00aa00685c74"],
    "CEventComCat": ["ae1ef300-cd8f-11d0-a9f8-00aa00685c74"],
    "CEventLock": ["2e3abb30-af88-11d0-a9eb-00aa00685c74"],
    "CEventManager": ["35172920-a700-11d0-a9ea-00aa00685c74"],
    "CEventMetabaseDatabaseManager": ["8a58cdc0-cbdc-11d0-a9f8-00aa00685c74"],
    "CEventRouter": ["9f82f020-f6fd-11d0-aa14-00aa006bc80b"],
    "CEventSystemTier2": ["1be1f766-5536-11d1-b726-00c04fb926af"],
    "CEventUtil": ["a1e041d0-cd73-11d0-a9f8-00aa00685c74"],
    "CFileChangeTracker": ["69f31c37-09e1-433b-aecb-ebc83e4065d9"],
    "CFileChangeTrackerInternal": ["e48eda45-43c6-48e0-9323-a7b2067d9cd5"],
    "CFileClient": ["bfccd195-1244-4840-ab44-480975c4ffe4"],
    "CFileIo": ["11993195-1244-4840-ab44-480975c4ffe4"],
    "CFindNetPrinters": ["8fadc6a8-183e-4dfc-944a-84a323334b98"],
    "CFrameInterpDMO": ["0a7cfe1b-6ab5-4334-9ed8-3f97cb37daa1"],
    "CFrameRateConvertDmo": ["01f36ce2-0907-4d8b-979d-f151be91c883"],
    "CGatherLanguageResourcePool": ["9e175b70-f52a-11d8-b9a5-505054503030"],
    "CGatherNotify": ["9e175b6d-f52a-11d8-b9a5-505054503030"],
    "CGatherTransaction": ["9e175b6c-f52a-11d8-b9a5-505054503030"],
    "CGatherer": ["9e175b74-f52a-11d8-b9a5-505054503030"],
    "CGathererLogFileProvider": ["9e175ba9-f52a-11d8-b9a5-505054503030"],
    "CGatheringManager": ["9e175b68-f52a-11d8-b9a5-505054503030"],
    "CHCNotificationManager": ["a3b3c46c-05d8-429b-bf66-87068b4ce563"],
    "CHSIME": ["81d4e9c9-1d3b-41bc-9e6c-4b40bf79e35e"],
    "CHS_WUBI": ["6a498709-e00b-4c45-a018-8f9e4081ae40"],
    "CHTIME": ["531fdebf-9b4c-4a43-a2aa-960e8fcdc732"],
    "CHTMLCanvasElement": ["70ea7e81-2945-429e-b912-647d2d81168d"],
    "CHT_BOPOMOFO": ["b115690a-ea02-48d5-a231-e3578d2fdf80"],
    "CHiFiUses": ["5aaf51b3-b1f0-11d1-b6ab-00a0c90833e9"],
    "CHighlightSegment": ["3050f694-98b5-11cf-bb82-00aa00bdce0b"],
    "CHook": ["3050f500-98b5-11cf-bb82-00aa00bdce0b"],
    "CIEContentAdvisorBroker": ["46cb32fa-b5ca-8a3a-62ca-a7023c0496c5"],
    "CIEDataObjectWrapper": ["447edbe5-0080-4036-a0bb-7b84c58c604f"],
    "CIEDropSourceWrapper": ["8e989135-2736-4767-8160-ea3613f69d24"],
    "CIEInetcplRasBroker": ["d63c23c5-53e6-48d5-adda-a385b6bb9c7b"],
    "CIERegistryHKLMBroker": ["4b360c3c-d284-4384-abcc-ef133e1445da"],
    "CIMExecuteCommand": ["17fe9752-0b5a-4665-84cd-569794602f5c"],
    "CISimpleCommandCreator": ["c7b6c04a-cbb5-11d0-bb4c-00c04fc2f410"],
    "CIeAxiInstaller": ["bdb57ff2-79b9-4205-9447-f5fe85f37312"],
    "CIeAxiInstallerService": ["90f18417-f0f1-484e-9d3c-59dceee5dbd8"],
    "CImgElement": ["525c0887-192d-4c4d-accd-56923f7117d9"],
    "CInterlaceMediaObject": ["b5a89c80-4901-407b-9abc-90d9a644bb46"],
    "CLBDTDispenser": ["b890af56-ac8c-11d1-8cb7-00c04fc3261d"],
    "CLRDebugging": ["bacc578d-fbdd-48a4-969f-02d932b74634"],
    "CLRDebuggingLegacy": ["df8395b5-a4ba-450b-a77c-a9a47762c520"],
    "CLRMetaHost": ["9280188d-0e8e-4867-b30c-7fa83884e8de"],
    "CLRMetaHostPolicy": ["2ebcd49a-1b47-4a61-b13a-4a03701e594b"],
    "CLRProfiling": ["bd097ed8-733e-43fe-8ed7-a95ff9a8448c"],
    "CLRRuntimeHost": ["90f1a06e-7712-4762-86b5-7a5eba6bdb02"],
    "CLRStrongName": ["b79b0acd-f5cd-409b-b5a5-a16244610b92"],
    "CMAPI2Handler": ["9e175baf-f52a-11d8-b9a5-505054503030"],
    "CMFNetworkCongestionControl": ["c24b9728-35a2-4c36-b763-2b007cfaf70f"],
    "CMP3DecMediaObject": ["bbeea841-0a63-4f52-a7ab-a9b3a84ed38a"],
    "CMPEG2AudDecoderDS": ["e1f1a0b8-beee-490d-ba7c-066c40b5e2b9"],
    "CMPEG2AudioEncoderMFT": ["46a4dd5c-73f8-4304-94df-308f760974f4"],
    "CMPEG2EncoderAudioDS": ["acd453bc-c58a-44d1-bbf5-bfb325be2d78"],
    "CMPEG2EncoderDS": ["5f5aff4a-2f7f-4279-88c2-cd88eb39d144"],
    "CMPEG2EncoderVideoDS": ["42150cd9-ca9a-4ea5-9939-30ee037f6e74"],
    "CMPEG2VidDecoderDS": ["212690fb-83e5-4526-8fd7-74478b7939cd"],
    "CMPEG2VideoEncoderMFT": ["e6335f02-80b7-4dc4-adfa-dfe7210d20d5"],
    "CMPEGAACDecMediaObject": ["8dde1772-edad-41c3-b4be-1f30fb4ee0d6"],
    "CMSAACDecMFT": ["32d186a7-218f-4c75-8876-dd77273a8999"],
    "CMSAC3Enc": ["c6b400e2-20a7-4e58-a2fe-24619682ce6c"],
    "CMSALACDecMFT": ["c0cd7d12-31fc-4bbc-b363-7322ee3e1879"],
    "CMSALACEncMFT": ["9ab6a28c-748e-4b6a-bfff-cc443b8e8fb4"],
    "CMSDDPlusDecMFT": ["177c0afe-900b-48d4-9e4c-57add250b3d4"],
    "CMSDolbyDigitalEncMFT": ["ac3315c9-f481-45d7-826c-0b406c1f64b8"],
    "CMSFLACDecMFT": ["6b0b3e6b-a2c5-4514-8055-afe8a95242d9"],
    "CMSFLACEncMFT": ["128509e9-c44e-45dc-95e9-c255b8f466a6"],
    "CMSH263EncoderMFT": ["bc47fcfe-98a0-4f27-bb07-698af24f2b38"],
    "CMSH264DecoderMFT": ["62ce7e72-4c71-4d20-b15d-452831a87d9d"],
    "CMSH264EncoderMFT": ["6ca50344-051a-4ded-9779-a43305165e35"],
    "CMSH264RemuxMFT": ["05a47ebb-8bf0-4cbf-ad2f-3b71d75866f5"],
    "CMSH265EncoderMFT": ["f2f84074-8bca-40bd-9159-e880f673dd3b"],
    "CMSMPEGAudDecMFT": ["70707b39-b2ca-4015-abea-f8447d22d88b"],
    "CMSMPEGDecoderMFT": ["2d709e52-123f-49b5-9cbc-9af5cde28fb9"],
    "CMSOpusDecMFT": ["63e17c10-2d43-4c42-8fe3-8d8b63e46a6a"],
    "CMSSCDecMediaObject": ["7bafb3b1-d8f4-4279-9253-27da423108de"],
    "CMSSCEncMediaObject": ["8cb9cc06-d139-4ae6-8bb4-41e612e141d5"],
    "CMSSCEncMediaObject2": ["f7ffe0a0-a4f5-44b5-949e-15ed2bc66f9d"],
    "CMSVPXEncoderMFT": ["aeb6c755-2546-4881-82cc-e15ae5ebff3d"],
    "CMSVideoDSPMFT": ["51571744-7fe4-4ff2-a498-2dc34ff74f1b"],
    "CMarkup": ["3050f4fb-98b5-11cf-bb82-00aa00bdce0b"],
    "CMarkupPointer": ["3050f4a5-98b5-11cf-bb82-00aa00bdce0b"],
    "CMediaQuery": ["3051074a-98b5-11cf-bb82-00aa00bdce0b"],
    "CMpeg2DecMediaObject": ["863d66cd-cdce-4617-b47f-c8929cfc28a6"],
    "CMpeg43DecMediaObject": ["cba9e78b-49a3-49ea-93d4-6bcba8c4de07"],
    "CMpeg4DecMediaObject": ["f371728a-6052-4d47-827c-d039335dfe0a"],
    "CMpeg4EncMediaObject": ["24f258d8-c651-4042-93e4-ca654abb682c"],
    "CMpeg4sDecMFT": ["5686a0d9-fe39-409f-9dff-3fdbc849f9f5"],
    "CMpeg4sDecMediaObject": ["2a11bae2-fe6e-4249-864b-9e9ed6e8dbc2"],
    "CMpeg4sEncMediaObject": ["6ec5a7be-d81e-4f9e-ada3-cd1bf262b6d8"],
    "CNetworkListManager": ["a47979d2-c419-11d9-a5b4-001185ad2b89"],
    "CNode": ["3051046a-98b5-11cf-bb82-00aa00bdce0b"],
    "CNokiaAACCCDecMediaObject": ["eabf7a6f-ccba-4d60-8620-b152cc977263"],
    "CNokiaAACDecMediaObject": ["3cb2bde4-4e29-4c44-a73e-2d7c2c46d6ec"],
    "CNullIFilter": ["9e175b97-f52a-11d8-b9a5-505054503030"],
    "CNullWB": ["9e175ba8-f52a-11d8-b9a5-505054503030"],
    "COMCatalog": ["00000346-0000-0000-c000-000000000046"],
    "COmHistory": ["3ad4f168-301d-4e25-ba39-b25ca7f72b7d"],
    "CPCAFiltersCategory": ["c4c4c4fc-0049-4e2b-98fb-9537f6ce516d"],
    "CPK_DS_AC3Decoder": ["6c9c69d6-0ffc-4481-afdb-cdf1c79c6f3e"],
    "CPK_DS_MPEG2Decoder": ["9910c5cd-95c9-4e06-865a-efa1c8016bf4"],
    "CPLSearchTargetServices": ["8e87e7b8-896b-4e67-bfa2-45c67d60ac3a"],
    "CPeerHandler": ["5aaf51b2-b1f0-11d1-b6ab-00a0c90833e9"],
    "CPrintManagerTemplatePrinter": ["63619f54-9d71-4c23-a08d-50d7f18db2e9"],
    "CProtectedModeAPI": ["ed72f0d2-b701-4c53-adc3-f2fb59946dd8"],
    "CProtectedModeAPINoFrameAffinity": ["8c537469-1ea9-4c85-9947-7e418500cdd4"],
    "CRange": ["3050f234-98b5-11cf-bb82-00aa00bdce0b"],
    "CRecalcEngine": ["3050f499-98b5-11cf-bb82-00aa00bdce0b"],
    "CRegTreeOptions": ["f83dac1c-9bb9-4f2b-b619-09819da81b0e"],
    "CResamplerMediaObject": ["f447b69e-1884-4a7e-8055-346f74d6edb3"],
    "CResizerDMO": ["1ea1ea14-48f4-4054-ad1a-e8aee10ac805"],
    "CResizerMediaObject": ["d3ec8b8b-7728-4fd8-9fe0-7b67d19f73a3"],
    "CSEODictionaryItem": ["2e3a0ec0-89d7-11d0-a9e6-00aa00685c74"],
    "CSEOGenericMoniker": ["7e3bf330-b28e-11d0-8bd8-00c04fd42e37"],
    "CSEOMemDictionary": ["c4df0042-2d33-11d0-a9cf-00aa00685c74"],
    "CSEOMetaDictionary": ["c4df0043-2d33-11d0-a9cf-00aa00685c74"],
    "CSEOMimeDictionary": ["c4df0041-2d33-11d0-a9cf-00aa00685c74"],
    "CSEORegDictionary": ["c4df0040-2d33-11d0-a9cf-00aa00685c74"],
    "CSEORouter": ["83d63730-94fd-11d0-a9e8-00aa00685c74"],
    "CSEOStream": ["ed1343b0-a8a6-11d0-a9ea-00aa00685c74"],
    "CSchedulingAgent": ["148bd52a-a2ab-11ce-b11f-00aa00530503"],
    "CScriptedDiag": ["1f3d8aa5-9ebf-4ee4-85c2-ea40379aede8"],
    "CSdShellExtension": ["877ca5ac-cb41-4842-9c69-9136e42d47e2"],
    "CSearchPSCNHandler": ["35c61cc2-5851-4f2d-89b6-4f9bb4b4193f"],
    "CSecureDispatchProxy": ["30510406-98b5-11cf-bb82-00aa00bdce0b"],
    "CSegment": ["3050f693-98b5-11cf-bb82-00aa00bdce0b"],
    "CSelectionUndoUnit": ["3050f7f8-98b5-11cf-bb82-00aa00bdce0b"],
    "CSettingsBroker": ["c6cc0d21-895d-49cc-98f1-d208cd71e047"],
    "CShdocvwBroker": ["9c7a1728-b694-427a-94a2-a1b2c60f0360"],
    "CShdocvwBrokerNoFrameAffinity": ["20ccef1e-0185-41a5-a933-509c43b54f98"],
    "CShellTreeWalker": ["95ce8412-7027-11d1-b879-006008059382"],
    "CShotDetectorDmo": ["56aefacd-110c-4397-9292-b0a0c61b6750"],
    "CShow": ["00030019-0000-0000-c000-000000000046"],
    "CSimpleMarshal": ["777ba8d2-2498-4875-933a-3067de883070"],
    "CSmpteTransformsDmo": ["bde6388b-da25-485d-ba7f-fabc28b20318"],
    "CStubBindStatusCallback": ["2b4f54b1-3d6d-11d0-8258-00c04fd5ae38"],
    "CStyle": ["3050f499-98b5-11cf-bb82-00aa00bdce0b"],
    "CStyleSheetPage": ["305104a4-98b5-11cf-bb82-00aa00bdce0b"],
    "CSvrOMUses": ["3050f4f0-98b5-11cf-bb82-00aa00bdce0b"],
    "CTVTunerFilter": ["266eee40-6c63-11cf-8a03-00aa006ecb65"],
    "CTVTunerFilterPropertyPage": ["266eee41-6c63-11cf-8a03-00aa006ecb65"],
    "CTaskCondition": ["ee8e4870-a889-4dc4-969f-f38f707f4ac2"],
    "CTaskConditionCombiner": ["427bc7e3-f833-4584-8745-cfab9d7a5761"],
    "CTestQuery": ["49f86845-bbd3-41a9-92d2-d95fc9121646"],
    "CTextClass": ["89bcb7a4-6119-101a-bcb7-00dd010655af"],
    "CTextIFilter": ["c1243ca0-bf96-11cd-b579-08002b30bfeb"],
    "CTextSite": ["3050f35e-98b5-11cf-bb82-00aa00bdce0b"],
    "CTextViewCommandGroup": ["1496a755-94de-11d0-8c3f-00c04fc2aae2"],
    "CThumbnailGeneratorDmo": ["559c6bad-1ea8-4963-a087-8a6810f9218b"],
    "CToc": ["4fe24495-28ce-4920-a4c4-e556e1f0df2a"],
    "CTocCollection": ["5058292d-a244-4840-ab44-480975c4ffe4"],
    "CTocEntry": ["f22f5e05-585c-4def-8523-6555cfbc0cb3"],
    "CTocEntryList": ["3a8cccbc-0efd-43a3-b838-f38a552ba237"],
    "CTocGeneratorDmo": ["4dda1941-77a0-4fb1-a518-e2185041d70c"],
    "CTocParser": ["499eaeea-2737-4849-8bb6-47f107eaf358"],
    "CTreeNode": ["3050f432-98b5-11cf-bb82-00aa00bdce0b"],
    "CUIAutomation": ["ff48dba4-60ef-4201-aa87-54103eef594e"],
    "CUIAutomation8": ["e22ad333-b25f-460c-83d0-0581107395c9"],
    "CUIAutomationBlockingCore": ["8a00041d-ec5c-4194-927d-d00ca43fbf38"],
    "CUIAutomationRegistrar": ["6e29fabf-9977-42d1-8d0e-ca7e61ad87e6"],
    "CUndoManager": ["fabda060-28c7-11d2-b0a7-00c04fa34d84"],
    "CUndoUnitBase": ["19809bd4-0f81-4c6f-a919-49d64e818667"],
    "CVodafoneAACCCDecMediaObject": ["7e76bf7f-c993-4e26-8fab-470a70c0d59c"],
    "CVodafoneAACDecMediaObject": ["7f36f942-dcf3-4d82-9289-5b1820278f7c"],
    "CVsExtProjectReferences": ["89c537a6-ad15-4a0f-aa56-e81754d3f3a4"],
    "CWMADecMediaObject": ["2eeb4adf-4578-4d10-bca7-bb955f56320a"],
    "CWMAEncMediaObject": ["70f598e9-f4ab-495a-99e2-a7c4d3d89abf"],
    "CWMATransMediaObject": ["edcad9cb-3127-40df-b527-0152ccb3f6f5"],
    "CWMAudioAEC": ["745057c7-f353-4f2d-a7ee-58434477730e"],
    "CWMAudioGFXAPO": ["637c490d-eee3-4c0a-973f-371958802da2"],
    "CWMAudioLFXAPO": ["62dc1a93-ae24-464c-a43e-452f824c4250"],
    "CWMAudioSpdTxDMO": ["5210f8e4-b0bb-47c3-a8d9-7b2282cc79ed"],
    "CWMSPDecMediaObject": ["874131cb-4ecc-443b-8948-746b89595d20"],
    "CWMSPEncMediaObject": ["67841b03-c689-4188-ad3f-4c9ebeec710b"],
    "CWMSPEncMediaObject2": ["1f1f4e1a-2252-4063-84bb-eee75f8856d5"],
    "CWMTDecMediaObject": ["f9dbc64e-2dd0-45dd-9b52-66642ef94431"],
    "CWMTEncMediaObject": ["60b67652-e46b-4e44-8609-f74bffdc083c"],
    "CWMV9EncMediaObject": ["d23b90d0-144f-46bd-841d-59e4eb19dc59"],
    "CWMVDecMediaObject": ["82d353df-90bd-4382-8bc2-3f6192b76e34"],
    "CWMVEncMediaObject2": ["96b57cdd-8966-410c-bb1f-c97eea765c04"],
    "CWMVXEncMediaObject": ["7e320092-596a-41b2-bbeb-175d10504eb6"],
    "CWVC1DecMediaObject": ["c9bfbccf-e60e-4588-a3df-5a03b1fd9585"],
    "CWVC1EncMediaObject": ["44653d0d-8cca-41e7-baca-884337b747ac"],
    "CWdiHandler": ["900be39d-6be8-461a-bc4d-b0fa71f5ecb1"],
    "CWebBrowserHandler": ["3cb169b3-17d9-4e47-8b93-2878998f69a2"],
    "CWiFiDirectDeviceAccessCapabilityHandler": ["bb80e1f9-88d9-4f4a-9522-e99b4e796d75"],
    "CWindowsPushNotificationPlatform": ["0c9281f9-6da1-4006-8729-de6e6b61581c"],
    "CWindowsPushNotificationPlatformCF": ["4655840e-ab1a-49d0-a4c4-261fa1c20e86"],
    "CWsPlatform": ["b52d54bb-4818-4eb9-aa80-f9eacd371df8"],
    "CXWizard": ["777ba87c-2498-4875-933a-3067de883070"],
    "CZuneAACCCDecMediaObject": ["a74e98f2-52d6-4b4e-885b-e0a6ca4f187a"],
    "CZuneM4S2DecMediaObject": ["c56fc25c-0fc6-404a-9503-b10bf51a8ab9"],
    "CacheManager": ["0977eec5-10f7-44ae-a7fa-d4824eba5c74"],
    "CachedFileUpdaterMergeHandler": ["a893aa73-054f-4dbc-9e53-f4ee5fe07fd3"],
    "CachedFileUpdaterPlaceholderStreamResolver": ["639bdb5a-7959-48d4-afc3-44f252bf2924"],
    "CalibrationTask": ["b210d694-c8df-490d-9576-9e20cdbc20bd"],
    "CanvasGradient": ["30510715-98b5-11cf-bb82-00aa00bdce0b"],
    "CanvasImageData": ["3051071b-98b5-11cf-bb82-00aa00bdce0b"],
    "CanvasPattern": ["30510717-98b5-11cf-bb82-00aa00bdce0b"],
    "CanvasRenderingContext2D": ["30510700-98b5-11cf-bb82-00aa00bdce0b"],
    "CanvasTextMetrics": ["30510719-98b5-11cf-bb82-00aa00bdce0b"],
    "CaptionsFilter": ["2f7ee4b6-6ff5-4eb4-b24a-2bfc41117171"],
    "CaptureGraphBuilder": ["bf87b6e0-8c27-11d0-b3f0-00aa003761c5"],
    "CaptureGraphBuilder2": ["bf87b6e1-8c27-11d0-b3f0-00aa003761c5"],
    "CatalogServer": ["182c40f0-32e4-11d0-818b-00a0c9231c29"],
    "CategorizerFactory": ["ef1c0450-0b48-4384-94ae-d1cb35641f86"],
    "CategoryEnum": ["5b858418-cfb4-4b32-8501-54d8b0c59f90"],
    "CentennialLifetimeManagerConsoleOperator": ["63766597-1825-407d-8752-098f33846f46"],
    "CharPres_30": ["00030034-0000-0000-c000-000000000046"],
    "Charisma": ["00030032-0000-0000-c000-000000000046"],
    "Charisma_30": ["00030033-0000-0000-c000-000000000046"],
    "CheckCompositionCycles": ["db6efb73-5153-43b7-8078-c6ffc4c0238c"],
    "CheckDiskDialog": ["a4c31131-ff70-4984-afd6-0609ced53ad6"],
    "ChgRemoveAppFolder": ["7b81be6a-ce2b-4676-a29e-eb907a5126c5"],
    "ChooseColumnsCommand": ["1c391f2b-801a-416c-9838-6be810293dfc"],
    "ClTest": ["00030025-0000-0000-c000-000000000046"],
    "ClassMoniker": ["0000031a-0000-0000-c000-000000000046"],
    "CleanRecentDocsCommand": ["2f096b28-c65d-4c05-a37e-7e88735e32fa"],
    "ClientExtractIcon": ["25585dc7-4da0-438d-ad04-e42c8d2d64b9"],
    "ClientNetManager": ["cd12a3ce-9c42-11d2-beed-0060082f2054"],
    "CloseWindowExecute": ["8570b44e-d109-42d3-be32-0f8d446669c5"],
    "CloudChangeWnfMonitor": ["276d4fd3-c41d-465f-8ca9-a82a7762df32"],
    "CloudChangeWnfMonitorClassFactory": ["92a8ccf5-2725-4e95-9264-74fab86fbbca"],
    "ClrObjectFactory": ["ecabafd1-7f19-11d2-978e-0000f8757e2a"],
    "CmdFileIcon": ["57651662-ce3e-11d0-8d77-00c04fc99d61"],
    "CollatorDataSource": ["9e175b8b-f52a-11d8-b9a5-505054503030"],
    "CollectionStagingManager": ["2744bc6a-4039-11e3-abad-8cfb6188709b"],
    "CollectionStagingState": ["e31a5806-8fd2-48ec-a132-7c1e614ac5b1"],
    "ColorSource": ["0cfdd070-581a-11d2-9ee6-006008039e37"],
    "ComActivator": ["0000033c-0000-0000-c000-000000000046"],
    "ComCallUnmarshal": ["3f281000-e95a-11d2-886b-00c04f869f04"],
    "ComCallUnmarshalV4": ["45fb4600-e6e8-4928-b25e-50476ff79425"],
    "ComCatCacheTask": ["8c7461ef-2b13-11d2-be35-3078302c2030"],
    "ComSoapPublisher": ["d8013eef-730b-45e2-ba24-874b7242c425"],
    "CommBand": ["4d5c8c2a-d075-11d0-b416-00c04fb90376"],
    "CommandBarButton": ["55f88891-7708-11d1-aceb-006008961da5"],
    "CommandBarComboBox": ["55f88897-7708-11d1-aceb-006008961da5"],
    "CommandBars": ["55f88893-7708-11d1-aceb-006008961da5"],
    "CommandFolder": ["437ff9c0-a07f-4fa0-af80-84b6c6440a16"],
    "CommandStore": ["f5a8b627-4d46-4d65-92f3-73626ae31971"],
    "CommandStoreShimOverCommandFolder": ["e410f8ae-00a1-4a1b-8247-924705718354"],
    "CommandStoreShimOverCommandFolderWithAllSupportedProtocols": ["67a66362-050e-42ff-b241-82c1f51ea9b9"],
    "CommandStoreShimOverIContextMenuCB": ["edea4743-46d4-4c14-b358-64fd126052ec"],
    "CommonCommandState": ["3756e7f5-e514-4776-a32b-eb24bc1efe7a"],
    "CommonExplorerHost": ["93a56381-e0cd-485a-b60e-67819e12f81b"],
    "CommonLayoutDefinition": ["c206f324-bb45-4765-93ff-3bca7306ff2e"],
    "CommonLayoutModifier": ["08d5bfbf-fbca-4322-9f70-ca9f66f8ed6a"],
    "CommonParentUndoUnit": ["078759d3-423b-48ad-ab6a-5638c2884dbe"],
    "CommonPlacesFolder": ["323ca680-c24d-4099-b94d-446dd2d7249e"],
    "ComponentPackageSupportServer": ["38e441fb-3d16-422f-8750-b2dacec5cefc"],
    "CompositeMoniker": ["00000309-0000-0000-c000-000000000046"],
    "CompositeSettingHandler": ["9311a763-d284-4ce5-b2aa-6a99d9305d60"],
    "ComputerNamePlugin": ["d772327b-027d-48be-ad01-9fd96388255f"],
    "ConditionAttribute": ["18907f3b-9afb-4f87-b764-f9a4e16a21b8"],
    "ConditionHistory": ["c64b9b66-e53d-4c56-b9ae-fede4ee95db1"],
    "ConflictDelegateFolder": ["e413d040-6788-4c22-957e-175d1c513a34"],
    "ConflictFolder": ["289978ac-a101-4341-a817-21eba7fd046d"],
    "ConflictProperties": ["f04cc277-03a2-4277-96a9-77967471bdff"],
    "ConnectedAccountServices": ["61667ee4-8071-46e2-9016-3db2d7be9e28"],
    "ConnectedAccountServicesFactory": ["cdc7b0eb-ee28-4914-9128-64689d3f34f0"],
    "ConnectedAccountStateChange": ["0cd397f8-20a2-46f0-bae8-952deeeda2c5"],
    "ConnectedAccounts": ["8929fd8a-3967-4896-a02d-f126195af6f7"],
    "ConnectedSearchExecuteCommand": ["99325bbe-e0a7-48a1-a23e-716582d09fef"],
    "ConnectedSearchShellService": ["3dbfef35-6f15-4453-bc19-d7ad5cc04756"],
    "ConnectedUserPlugin": ["2af141de-8433-4fe1-a14b-d4af981ab2f5"],
    "Contact": ["61b68808-8eee-4fd1-acb8-3d804c8db056"],
    "ContactAggregationManager": ["96c8ad95-c199-44de-b34e-ac33c442df39"],
    "ContactCardTestHookService": ["4a74fb44-3214-40ea-832a-b8e17bd20bd0"],
    "ContactManager": ["7165c8ab-af88-42bd-86fd-5310b4285a02"],
    "ContentFolder": ["8bb49b4e-039a-4cc8-b6c8-6782b2e386f5"],
    "ContentSnippetBuilder": ["e22b3065-b83a-4ffd-9b08-9e73841a442f"],
    "ContextMarshaler": ["0000033b-0000-0000-c000-000000000046"],
    "ContextMenuPopupFactory": ["4a4d5d1b-869b-4474-806a-4daaa7673e78"],
    "ContextSwitcher": ["0000034e-0000-0000-c000-000000000046"],
    "ControlPanelCategory": ["26ee0668-a00a-44d7-9371-beb064c98683"],
    "ControlPanelRecent": ["5399e694-6ce5-4d6c-8fce-1d8870fdcba0"],
    "ControlPanelTasks": ["ed7ba470-8e54-465e-825c-99712043e01c"],
    "CopyAsPathMenu": ["f3d06e7c-1e45-4a26-847e-f9fcdee59be0"],
    "CopyToChooseFolder": ["af65e2ea-3739-4e57-9c5f-7f43c949ce5e"],
    "CopyToMenu": ["c2fbb630-2971-11d1-a18c-00c04fd75d13"],
    "CopyUndoHandler": ["7abbbcca-e01b-4560-8228-92e1eedbc908"],
    "CorMetaDataRuntime": ["efea471a-44fd-4862-9292-0c58d46e1f3a"],
    "CorRuntimeHost": ["cb2f6723-ab3a-11d2-9c40-00c04fa30a3e"],
    "CoreShellBrokerProvider": ["60359c40-cadf-484f-bfb0-414b521c012e"],
    "CoreShellServiceProvider": ["39dd352b-7231-4897-bfe0-e7374a1c012e"],
    "CoreUICoreWindowFactoryProxy": ["b243a9fd-c57a-4d3e-a7cf-21caed64cb5a"],
    "CorelChart": ["0003001a-0000-0000-c000-000000000046"],
    "CoromandelIntegra": ["00030013-0000-0000-c000-000000000046"],
    "CoromandelObjServer": ["00030014-0000-0000-c000-000000000046"],
    "CortanaExperienceFlow": ["24ac8f2b-4d4a-4c17-9607-6a4b14068f97"],
    "CortanaExperienceFlowCF": ["0dfa72f0-d26c-4987-a128-e3a5641c5568"],
    "CortanaExperienceMgr": ["10493933-661b-4083-9ce0-efe48add0770"],
    "CortanaPlugin": ["e1fd7e9c-fdd3-463d-8717-58df05ccab03"],
    "CounterItem": ["c4d2d8e0-d1dd-11ce-940f-008029004348"],
    "CounterItem2": ["43196c62-c31f-4ce3-a02e-79efe0f6a525"],
    "CounterPropPage": ["cf948561-ede8-11ce-941e-008029004347"],
    "Counters": ["b2b066d2-2aac-11cf-942f-008029004347"],
    "CreateMediaExtensionObject": ["ef65a54d-0788-45b8-8b14-bc0f6a6b5137"],
    "CreateObjectAsSystem": ["135fd325-45b7-4c30-89f8-4386961669f0"],
    "CreateObjectLocalServer": ["7b6ea1d5-03c2-4ae4-b21c-8d0515cc91b7"],
    "CreateObjectTaskServer": ["133eac4f-5891-4d04-bada-d84870380a80"],
    "CscSyncCommand": ["09017262-fdb4-4ff2-9013-26332c926ee7"],
    "CscUpdateHandler": ["750fdf10-2a26-11d1-a3ea-080036587f03"],
    "CscWorkOfflineOnlineCommand": ["196f128d-dce9-4090-b061-3d29c6ca32c2"],
    "CtrlMouseWheelHandler": ["3829dfb4-9eed-434e-88c7-dcbe810b1a6e"],
    "CustRg": ["84d586c4-a423-11d2-b943-00c04f79d22f"],
    "CustomShellManager": ["e4f1b173-acb1-4170-959d-33030db41e92"],
    "D2D12DAffineTransform": ["6aa97485-6354-4cfc-908c-e4a74f62c96c"],
    "D2D13DPerspectiveTransform": ["c2844d0b-3d86-46e7-85ba-526c9240f3fb"],
    "D2D13DTransform": ["e8467b04-ec61-4b8a-b5de-d4d73debea5a"],
    "D2D1AlphaMask": ["c80ecff0-3fd5-4f05-8328-c5d1724b4f0a"],
    "D2D1ArithmeticComposite": ["fc151437-049a-4784-a24a-f1c4daf20987"],
    "D2D1Atlas": ["913e2be4-fdcf-4fe2-a5f0-2454f14ff408"],
    "D2D1BitmapSource": ["5fb6c24d-c6dd-4231-9404-50f4d5c3252d"],
    "D2D1Blend": ["81c5b77b-13f8-4cdd-ad20-c890547ac65d"],
    "D2D1Border": ["2a2d49c0-4acf-43c7-8c6a-7c4a27874d27"],
    "D2D1BorderRect": ["3cc23214-73ad-450b-8436-aa8194927fb8"],
    "D2D1BoundsAdjustment": ["be33b19e-e855-4b59-b513-76f6b082a8d0"],
    "D2D1Brightness": ["8cea8d1e-77b0-4986-b3b9-2f0c0eae7887"],
    "D2D1ChromaKey": ["74c01f5b-2a0d-408c-88e2-c7a3c7197742"],
    "D2D1ColorManagement": ["1a28524c-fdd6-4aa4-ae8f-837eb8267b37"],
    "D2D1ColorMatrix": ["921f03d6-641c-47df-852d-b4bb6153ae11"],
    "D2D1Composite": ["48fc9f51-f6ac-48f1-8b58-3b28ac46f76d"],
    "D2D1Contrast": ["b648a78a-0ed5-4f80-a94a-8e825aca6b77"],
    "D2D1ConvolveMatrix": ["407f8c08-5533-4331-a341-23cc3877843e"],
    "D2D1Crop": ["e23f7110-0e9a-4324-af47-6a2c0c46f35b"],
    "D2D1CrossFade": ["12f575e8-4db1-485f-9a84-03a07dd3829f"],
    "D2D1DirectionalBlur": ["174319a6-58e9-49b2-bb63-caf2c811a3db"],
    "D2D1DiscreteTransfer": ["90866fcd-488e-454b-af06-e5041b66c36c"],
    "D2D1DisplacementMap": ["edc48364-0417-4111-9450-43845fa9f890"],
    "D2D1DistantDiffuse": ["3e7efd62-a32d-46d4-a83c-5278889ac954"],
    "D2D1DistantSpecular": ["428c1ee5-77b8-4450-8ab5-72219c21abda"],
    "D2D1DpiCompensation": ["6c26c5c7-34e0-46fc-9cfd-e5823706e228"],
    "D2D1EdgeDetection": ["eff583ca-cb07-4aa9-ac5d-2cc44c76460f"],
    "D2D1Emboss": ["b1c5eb2b-0348-43f0-8107-4957cacba2ae"],
    "D2D1Exposure": ["b56c8cfa-f634-41ee-bee0-ffa617106004"],
    "D2D1Flood": ["61c23c20-ae69-4d8e-94cf-50078df638f2"],
    "D2D1GammaTransfer": ["409444c4-c419-41a0-b0c1-8cd0c0a18e42"],
    "D2D1GaussianBlur": ["1feb6d69-2fe6-4ac9-8c58-1d7f93e7a6a5"],
    "D2D1Grayscale": ["36dde0eb-3725-42e0-836d-52fb20aee644"],
    "D2D1HdrToneMap": ["7b0b748d-4610-4486-a90c-999d9a2e2b11"],
    "D2D1HighlightsShadows": ["cadc8384-323f-4c7e-a361-2e2b24df6ee4"],
    "D2D1Histogram": ["881db7d0-f7ee-4d4d-a6d2-4697acc66ee8"],
    "D2D1HueRotation": ["0f4458ec-4b32-491b-9e85-bd73f44d3eb6"],
    "D2D1HueToRgb": ["7b78a6bd-0141-4def-8a52-6356ee0cbdd5"],
    "D2D1ImageSource": ["af9d7a84-4b93-45c6-b064-c567fea27582"],
    "D2D1Invert": ["e0c3784d-cb39-4e84-b6fd-6b72f0810263"],
    "D2D1LinearTransfer": ["ad47c8fd-63ef-4acc-9b51-67979c036c06"],
    "D2D1LookupTable3D": ["349e0eda-0088-4a79-9ca3-c7e300202020"],
    "D2D1LuminanceToAlpha": ["41251ab7-0beb-46f8-9da7-59e93fcce5de"],
    "D2D1Morphology": ["eae6c40d-626a-4c2d-bfcb-391001abe202"],
    "D2D1Opacity": ["811d79a4-de28-4454-8094-c64685f8bd4c"],
    "D2D1OpacityMetadata": ["6c53006a-4450-4199-aa5b-ad1656fece5e"],
    "D2D1PointDiffuse": ["b9e303c3-c08c-4f91-8b7b-38656bc48c20"],
    "D2D1PointSpecular": ["09c3ca26-3ae2-4f09-9ebc-ed3865d53f22"],
    "D2D1Posterize": ["2188945e-33a3-4366-b7bc-086bd02d0884"],
    "D2D1Premultiply": ["06eab419-deed-4018-80d2-3e1d471adeb2"],
    "D2D1RgbToHue": ["23f3e5ec-91e8-4d3d-ad0a-afadc1004aa1"],
    "D2D1Saturation": ["5cb2d9cf-327d-459f-a0ce-40c0b2086bf7"],
    "D2D1Scale": ["9daf9369-3846-4d0e-a44e-0c607934a5d7"],
    "D2D1Sepia": ["3a1af410-5f1d-4dbe-84df-915da79b7153"],
    "D2D1Shadow": ["c67ea361-1863-4e69-89db-695d3e9a5b6b"],
    "D2D1Sharpen": ["c9b887cb-c5ff-4dc5-9779-273dcf417c7d"],
    "D2D1SpotDiffuse": ["818a1105-7932-44f4-aa86-08ae7b2f2c93"],
    "D2D1SpotSpecular": ["edae421e-7654-4a37-9db8-71acc1beb3c1"],
    "D2D1Straighten": ["4da47b12-79a3-4fb0-8237-bbc3b2a4de08"],
    "D2D1TableTransfer": ["5bf818c3-5e43-48cb-b631-868396d6a1d4"],
    "D2D1TemperatureTint": ["89176087-8af9-4a08-aeb1-895f38db1766"],
    "D2D1Tile": ["b0784138-3b76-4bc5-b13b-0fa2ad02659f"],
    "D2D1Tint": ["36312b17-f7dd-4014-915d-ffca768cf211"],
    "D2D1Turbulence": ["cf2bb6ae-889a-4ad7-ba29-a2fd732c9fc9"],
    "D2D1UnPremultiply": ["fb9ac489-ad8d-41ed-9999-bb6347d110f7"],
    "D2D1Vignette": ["c00c40be-5e67-4ca3-95b4-f4b02c115135"],
    "D2D1WhiteLevelAdjustment": ["44a1cadb-6cdd-4818-8ff4-26c1cfe95bdb"],
    "D2D1YCbCr": ["99503cc1-66c7-45c9-a875-8ad8a7914401"],
    "D2D1YCbCrInput": ["993b1d0b-68ba-4f56-a170-e7c80f56a860"],
    "DBFolder": ["b2952b16-0e07-4e5a-b993-58c52cb94cae"],
    "DBFolderBoth": ["1bef2128-2f96-4500-ba7c-098dc0049cb2"],
    "DCompManipulationCompositor": ["79dea627-a08a-43ac-8ef5-6900b9299126"],
    "DDOResources": ["d2e86c4f-ea06-4a89-bf00-b49706db46e6"],
    "DGraphCHART": ["00030016-0000-0000-c000-000000000046"],
    "DGraphDATA": ["00030017-0000-0000-c000-000000000046"],
    "DMOFilterCategory": ["bcd5796c-bd52-4d30-ab76-70f975b89199"],
    "DMOWrapperFilter": ["94297043-bd82-4dfd-b0de-8177739c6d20"],
    "DOMBeforeUnloadEvent": ["30510764-98b5-11cf-bb82-00aa00bdce0b"],
    "DOMCloseEvent": ["30510800-98b5-11cf-bb82-00aa00bdce0b"],
    "DOMCompositionEvent": ["305106d9-98b5-11cf-bb82-00aa00bdce0b"],
    "DOMCustomEvent": ["305106df-98b5-11cf-bb82-00aa00bdce0b"],
    "DOMDocumentType": ["30510739-98b5-11cf-bb82-00aa00bdce0b"],
    "DOMDragEvent": ["30510762-98b5-11cf-bb82-00aa00bdce0b"],
    "DOMEvent": ["305104bb-98b5-11cf-bb82-00aa00bdce0b"],
    "DOMException": ["3051072c-98b5-11cf-bb82-00aa00bdce0b"],
    "DOMFocusEvent": ["305106cd-98b5-11cf-bb82-00aa00bdce0b"],
    "DOMKeyboardEvent": ["305106d7-98b5-11cf-bb82-00aa00bdce0b"],
    "DOMMSAnimationEvent": ["305107b8-98b5-11cf-bb82-00aa00bdce0b"],
    "DOMMSManipulationEvent": ["30510817-98b5-11cf-bb82-00aa00bdce0b"],
    "DOMMSTransitionEvent": ["305107b6-98b5-11cf-bb82-00aa00bdce0b"],
    "DOMMessageEvent": ["30510721-98b5-11cf-bb82-00aa00bdce0b"],
    "DOMMouseEvent": ["305106cf-98b5-11cf-bb82-00aa00bdce0b"],
    "DOMMouseWheelEvent": ["305106d1-98b5-11cf-bb82-00aa00bdce0b"],
    "DOMMutationEvent": ["305106db-98b5-11cf-bb82-00aa00bdce0b"],
    "DOMParser": ["30510782-98b5-11cf-bb82-00aa00bdce0b"],
    "DOMParserFactory": ["30510784-98b5-11cf-bb82-00aa00bdce0b"],
    "DOMProcessingInstruction": ["30510743-98b5-11cf-bb82-00aa00bdce0b"],
    "DOMProgressEvent": ["3051071f-98b5-11cf-bb82-00aa00bdce0b"],
    "DOMSiteModeEvent": ["30510766-98b6-11cf-bb82-00aa00bdce0b"],
    "DOMStorageEvent": ["30510723-98b5-11cf-bb82-00aa00bdce0b"],
    "DOMTextEvent": ["305106d5-98b5-11cf-bb82-00aa00bdce0b"],
    "DOMUIEvent": ["305106cb-98b5-11cf-bb82-00aa00bdce0b"],
    "DOMWheelEvent": ["305106d3-98b5-11cf-bb82-00aa00bdce0b"],
    "DSRef": ["e09ee6ac-fef0-41ae-9f77-3c394da49849"],
    "DSRef_R1": ["ab36de40-2bf4-11ce-ab3c-00aa004404fb"],
    "DSRef_R2": ["e9b0e6db-811c-11d0-ad51-00a0c90f5739"],
    "DShowSourceResolver": ["14d7a407-396b-44b3-be85-5199a0f0f80a"],
    "DShowTVEFilter": ["05500280-faa5-4df9-8246-bfc23ac5cea8"],
    "DTFilterEncProperties": ["c4c4c482-0049-4e2b-98fb-9537f6ce516d"],
    "DTFilterTagProperties": ["c4c4c492-0049-4e2b-98fb-9537f6ce516d"],
    "DTSSPDIFMFT": ["d035e24c-c877-42d7-a795-2a8a339b472f"],
    "DUIAccountErrorPage": ["fe62fde5-e0d8-4118-9fa3-45d31a5aea0f"],
    "DUIAuthProxyPage": ["3261bf13-9b3e-4dd5-b6d3-0006f3ffe8bc"],
    "DUIConnectedUserPage": ["32b0c344-a3bb-4f6e-b8d9-e883bc150eea"],
    "DUICortanaPage": ["8d0d175c-1d8e-4099-92ce-84c9b8a5e386"],
    "DUIEndPage": ["c12ec999-9d91-425e-84af-dc15443a6b81"],
    "DUIEnterpriseProvisioningConfigPage": ["c1373050-e8c9-4ae4-a0c5-1dcf07274587"],
    "DUIEnterpriseProvisioningStatusPage": ["3e298c47-0da7-4418-aac7-7a6d1f800a14"],
    "DUIEulaPage": ["24ca8aef-f6d8-4732-8db5-9d83efd8cfbc"],
    "DUIFeatureStagingWizardPage": ["ea7e2f2f-c713-4a10-8708-c9c40587bad7"],
    "DUIHidAccessoryPairingPage": ["19129eac-a717-4bbd-87e0-615e3c939668"],
    "DUIHidKeyboardPairingPage": ["5d429af6-d20f-4363-b378-c4aa2fa685ee"],
    "DUIHidMousePairingPage": ["ee14e412-4988-458c-b863-76e3c1bf71c2"],
    "DUILocalUserPage": ["6208889b-f7a7-44b4-a34e-3c40e83281db"],
    "DUILocalizationPage": ["ee5799d0-070a-49ee-8476-6a02e46e9fdd"],
    "DUIOEMRegistrationPage": ["c8a1fad9-bc51-4031-a3cb-00edb3fd7d63"],
    "DUIPIDPage": ["92192fd8-c1cb-434b-a8e8-b7f3ac424ee4"],
    "DUIProtectPcSettingsPage1": ["7ab7dd72-b9ba-4731-94a0-59042760c18b"],
    "DUIProxyConfigurationPage": ["1ad699a6-31f7-4ef0-93e9-ffd576f35d30"],
    "DUIRecoveryPage": ["cd764a50-d1bd-453e-be7e-8230f6c1f4bb"],
    "DUIRegionModule": ["055e80ca-dd63-4c25-93ab-448bbdb7aa17"],
    "DUIRetailDemoStorePage": ["5ba7489a-4bba-4d18-889a-5f725025f268"],
    "DUIShellViewFrame": ["bde9ee7c-329f-4fcf-ba7a-f8c6e9b4579d"],
    "DUIThrottledAccountPage": ["84918b28-7063-4db3-8246-43e1712e391d"],
    "DUITimezoneModule": ["43c103a6-696f-4d05-af04-9e44a6844b30"],
    "DUIUpgradeAppsPage": ["9068bf36-6f05-477e-b108-a4042237f884"],
    "DUIUpgradePasswordPage": ["24954e9b-d39a-4168-a3b2-e5014c94492f"],
    "DUIWirelessPage": ["b79848c3-4f26-4d9d-bf1d-81fdf2704cf8"],
    "DVBCNetworkProvider": ["dc0c0fe7-0485-4266-b93f-68fbf80ed834"],
    "DVBSNetworkProvider": ["fa4b375a-45b4-4d45-8440-263957b11623"],
    "DVBTNetworkProvider": ["216c62df-6d7f-4e9a-8571-05f14edb766a"],
    "DVDState": ["f963c5cf-a659-4a93-9638-caf3cd277d13"],
    "DataCollectorSet": ["03837521-098b-11d8-9414-505054503030"],
    "DataCollectorSetCollection": ["03837525-098b-11d8-9414-505054503030"],
    "DataConvert": ["c8b522d1-5cf3-11ce-ade5-00aa0044773d"],
    "DataLinks": ["2206cdb2-19c1-11d1-89e0-00c04fd7a829"],
    "DateTimeIntervalGenerator": ["3b1b5147-715e-49e0-ae9f-adf86724bb89"],
    "DefCategoryProvider": ["b2f2e083-84fe-4a7e-80c3-4b50d10d646e"],
    "DefFolderMenu": ["c63382be-7933-48d0-9ac8-85fb46be2fdd"],
    "DefViewPersistHistory": ["7febaf7c-18cf-11d2-993f-00a0c91f3880"],
    "DefaultBrowserSyncSettings": ["3ac83423-3112-4aa6-9b5b-1feb23d0c5f9"],
    "DefaultDeviceFactory": ["3ee8ce0f-2507-42de-a453-8f4d554256e8"],
    "DeferContactService": ["d7b67cf4-84bb-434e-86ae-6592bbc9abd9"],
    "DelayedBackgroundUploadTaskHandler": ["59b9640b-3f70-4d1c-b159-f26eeb8a4c87"],
    "DelayedPropertyStore": ["bd0ad204-aad2-46c9-973a-75481210b9fb"],
    "DeleteAddressBarHistoryCommand": ["935249a5-b5e8-43f6-a991-61435e5954b3"],
    "DemuxRender": ["eb4d075a-65c0-476b-956c-c605eade03f7"],
    "Designer_40": ["00030036-0000-0000-c000-000000000046"],
    "DeskBarApp": ["3ccf8a41-5c85-11d0-9796-00aa00b90adf"],
    "DesktopExplorerHost": ["682159d9-c321-47ca-b3f1-30e36b2ec8b9"],
    "DesktopGadget": ["924ccc1b-6562-4c85-8657-d177925222b6"],
    "DesktopUndoManager": ["3eef301f-b596-4c0b-bd92-013beafce793"],
    "DesktopWallpaper": ["c2cf3110-460e-4fc1-b9d0-8a1c0c9cc4bd"],
    "DestinationList": ["77f10cf0-3db5-4966-b520-b7c54fd35ed6"],
    "DetailCategorizer": ["3e373e22-da99-4cb7-a886-754eae984cb4"],
    "DetectionAndSharing": ["1fda955b-61ff-11da-978c-0008744faab7"],
    "DevProxyMFT": ["8ac3587a-4ae7-42d8-99e0-0a6013eef90f"],
    "DeviceAccessEvents": ["b7259ef0-83a6-4a3b-a2ed-93ee23de7863"],
    "DeviceAccessPolicyCheck": ["d313a859-b510-461a-b4a7-70ff73aef1f1"],
    "DeviceAccessPolicyManager": ["778de47f-7adc-4c4d-974d-771bd1675dc5"],
    "DeviceAssociationBroker": ["806f5b1a-d0db-4a89-94d8-c5712e796f9b"],
    "DeviceBroker": ["acc56a05-e277-4b1e-a43e-7a73e3cd6e6c"],
    "DeviceCenterFolder": ["a8a91a66-3a7d-4424-8d24-04e180695c7a"],
    "DeviceControlCategory": ["cc7bfb46-f175-11d1-a392-00e0291f3959"],
    "DeviceDiscoveryMonitor": ["77d8dda9-6bd7-4659-852e-fb7223e745bc"],
    "DeviceDisplayStatusFactory": ["0ee4845b-96cd-403b-8609-317330581408"],
    "DeviceIoControl": ["12d3e372-874b-457d-9fdf-73977778686c"],
    "DeviceMetadataHelper": ["699583d1-6ba0-4df2-b559-2487ed3a58cb"],
    "DevicesFlow": ["2f93c02d-77f9-46b4-95fb-8cbb81eeb62c"],
    "DevicesFlowCF": ["6f8cf952-b381-44d3-9704-0ed7c3c4e677"],
    "DevicesFlowExperienceFlow": ["046aead9-5a27-4d3c-8a67-f82552e0a91b"],
    "DevicesFlowExperienceFlowCF": ["dd1484d0-5721-4525-99a6-087fc81975f8"],
    "DfMarshal": ["0000030b-0000-0000-c000-000000000046"],
    "DiaSource": ["3bfcea48-620f-4b6b-81f7-b9af75454c7d"],
    "DiaSourceAlt": ["83ab22c8-993a-4d14-a0e0-37bc0aaea793"],
    "DiaStackWalker": ["20cea761-83c2-44f4-a6f7-5cc4577198ca"],
    "DiagHook": ["c7875eef-c7df-4adc-9fd9-056fc10c1491"],
    "DirFavDataItemEnum": ["f45953aa-c9e1-42b6-bd0d-25860a1b1a8d"],
    "DirFavDataProvider": ["9f008f19-b6b1-4e79-8105-0e29f0f28e78"],
    "DirectManipulationManager": ["54e211b6-3650-4f75-8334-fa359598e1c5"],
    "DirectManipulationPrimaryContent": ["caa02661-d59e-41c7-8393-3ba3bacb6b57"],
    "DirectManipulationSharedManager": ["99793286-77cc-4b57-96db-3b354f6f9fb5"],
    "DirectManipulationUpdateManager": ["9fc1bfd5-1835-441a-b3b1-b6cc74b727d0"],
    "DirectManipulationViewport": ["34e211b6-3650-4f75-8334-fa359598e1c5"],
    "DirectMusicSynthSink": ["aec17ce3-a514-11d1-afa6-00aa0024d8b6"],
    "DirectShowPluginControl": ["8670c736-f614-427b-8ada-bbadc587194b"],
    "DirectSoundPrivate": ["11ab3ec0-25ec-11d1-a4d8-00c04fc28aca"],
    "DirtyShutdownReason": ["68ddbb56-9d1d-4fd9-89c5-c0da2a625392"],
    "DiscImageMountVerb": ["9ab3b1c9-3225-4bb4-93b6-bfb3c0d93743"],
    "DiscussionBand": ["bdeade7f-c265-11d0-bced-00a0c90ab50f"],
    "DiskQuotaControl": ["7988b571-ec89-11cf-9c00-00aa00a14f56"],
    "DocHostedMoniker": ["ffd90217-f7c2-4434-9ee1-6f1b530db20f"],
    "DocPropBooleanControl": ["1e8f0d70-7399-41bf-8598-7949a2dec898"],
    "DocPropCalendarControl": ["6a205b57-2567-4a2c-b881-f787fab579a3"],
    "DocPropDrawPercentFullControl": ["ab517586-73cf-489c-8d8c-5ae0ead0613a"],
    "DocPropDrawProgressControl": ["0d81ea0d-13bf-44b2-af1c-fcdf6be7927c"],
    "DocPropDropListComboControl": ["0eea25cc-4362-4a12-850b-86ee61b0d3eb"],
    "DocPropEditBoxControl": ["a9cf0eae-901a-4739-a481-e35b73e47f6d"],
    "DocPropHyperlinkControl": ["15756be1-a4ad-449c-b576-df3df0e068d3"],
    "DocPropIconListControl": ["53a01e9d-61cc-4cb0-83b1-31bc8df63156"],
    "DocPropMLEditBoxControl": ["8ee97210-fd1f-4b19-91da-67914005f020"],
    "DocPropMVPDrawControl": ["8e85d0ce-deaf-4ea1-9410-fd1a2105ceb5"],
    "DocPropMVPEditControl": ["e2183960-9d58-4e9c-878a-4acc06ca564a"],
    "DocPropRatingControl": ["85e94d25-0712-47ed-8cde-b0971177c6a1"],
    "DocPropShellExtension": ["883373c3-bf89-11d1-be35-080036b11a03"],
    "DocPropStaticControl": ["527c9a9b-b9a2-44b0-84f9-f0dc11c2bcfb"],
    "DomainSuggestionDataProvider": ["487493e4-c534-44a7-a3d2-f18891fcba54"],
    "Dot11AdHocManager": ["dd06a84f-83bd-4d01-8ab9-2389fea0869e"],
    "DotNetApplicationXComPlus": ["dc5da001-7cd4-11d2-8ed9-d8c857f98fe3"],
    "DotNetUserControl": ["1e66f26b-79ee-11d2-8710-00c04f79ed0d"],
    "DragDropBroker": ["00000353-0000-0000-c000-000000000046"],
    "DragDropConfigurationBehavior": ["09b01b3e-ba6c-454d-82e8-95e352329f23"],
    "DragDropHandler": ["bd472f60-27fa-11cf-b8b4-444553540000"],
    "DrivesCleanUpCommand": ["9cca66bb-9c78-4e59-a76f-a5e9990b8aa0"],
    "DrivesDefragmentCommand": ["5d75245f-29ae-450d-8924-a7611de279af"],
    "DrmNetNDSchemePlugin": ["2eeeed04-0908-4cdb-af8f-ac5b768a34c9"],
    "DsAdminCreateObj": ["e301a009-f901-11d2-82b9-00c04f68928b"],
    "DsFindWriteableDomainController": ["7cbef079-aa84-444b-bc70-68e41283eabc"],
    "DsObjectPicker": ["17d6ccd8-3b7b-11d2-b9e0-00c04fd8dbf7"],
    "DsmDeviceAppCoordinator": ["53dec7f6-5448-43e2-9573-3f7b91b751dc"],
    "DsmUserTask": ["558e3d9c-f033-4a44-a019-4f3f39ec8e4f"],
    "DtvCcFilter": ["fb056ba0-2502-45b9-8e86-2b40de84ad29"],
    "DxcAssembler": ["d728db68-f903-4f80-94cd-dccf76ec7151"],
    "DxcContainerBuilder": ["94134294-411f-4574-b4d0-8741e25240d2"],
    "DxcContainerReflection": ["b9f54489-55b8-400c-ba3a-1675e4728b91"],
    "DxcLibrary": ["6245d6af-66e0-48fd-80b4-4d271796748c"],
    "DxcLinker": ["ef6a8087-b0ea-4d56-9e45-d07e1a8b7806"],
    "DxcOptimizer": ["ae2cd79f-cc22-453f-9b6b-b124e7a5204c"],
    "DxcValidator": ["8ca3e215-f728-4cf3-8cdd-88af917587a1"],
    "DxtJpeg": ["de75d012-7a65-11d2-8cea-00a0c9441e20"],
    "DynamicStorage": ["f46316e4-fb1b-46eb-aedf-9520bfbb916a"],
    "ECG": ["1496a755-94de-11d0-8c3f-00c04fc2aae2"],
    "EMEStoreActivate": ["2df7b51e-797b-4d06-be71-d14a52cf8421"],
    "ETFilterEncProperties": ["c4c4c481-0049-4e2b-98fb-9537f6ce516d"],
    "ETFilterTagProperties": ["c4c4c491-0049-4e2b-98fb-9537f6ce516d"],
    "EVRPlaybackPipelineOptimizer": ["62079164-233b-41f8-a80f-f01705f514a8"],
    "EVRTearlessWindowPresenter9": ["a0a7a57b-59b2-4919-a694-add0a526c373"],
    "EXTLOG": ["ff160663-de82-11cf-bc0a-00aa006111e0"],
    "EXTLOGUI": ["31dcab88-bb3e-11d0-9299-00c04fb6678b"],
    "EdgeUiDeviceManager": ["e388f56a-d03b-4a08-adc3-e44ca937ad91"],
    "EdgeUiManager": ["0e1487f2-9865-4cd5-b99a-9c5eb063a2bc"],
    "ElevatableDiscImageMount": ["51a1467f-96a2-4b1c-9632-4b4d950fe216"],
    "ElevatableShellLink": ["ff9e6131-a8c1-4188-aa03-82e9f10a05a8"],
    "ElevatedFactoryServerManager": ["e755468c-02f5-4d96-8487-3be68ffe633a"],
    "EmailItemEnum": ["e9f1381f-652f-482d-bc95-d30307760b96"],
    "EmptyRecycleBinExecute": ["48527bb3-e8de-450b-8910-8c4099cb8624"],
    "EmptyRecycleBinState": ["c9298eef-69dd-4cdd-b153-bdbc38486781"],
    "EndPlugin": ["2f7ed5e3-06c9-4b61-97db-067cc8ae0664"],
    "EnhancedStorageACT": ["af076a15-2ece-4ad4-bb21-29f040e176d8"],
    "EnhancedStorageFolder": ["9113a02d-00a3-46b9-bc5f-9c04daddd5d7"],
    "EnhancedStorageSilo": ["cb25220c-76c7-4fee-842b-f3383cd022bc"],
    "EnhancedStorageSiloAction": ["886d29dd-b506-466b-9fbf-b44ff383fb3f"],
    "EnhancedVideoRenderer": ["fa10746c-9b63-4b6c-bc49-fc300ea5f256"],
    "EnterpriseProvisioningPlugin": ["e46c6e1e-8ade-4edd-afaa-446d1999911b"],
    "EnumEnhancedStorageACT": ["fe841493-835c-4fa3-b6cc-b4b2d4719848"],
    "EnumExplorerCommandOnMenu": ["25150040-b8f1-418e-af61-b51071ac1ee2"],
    "EnumFiles": ["e3e478d6-a2f2-4791-89a3-21f5c78dc3ec"],
    "EnumFsiItems": ["2c941fc6-975b-59be-a960-9a2a262853a5"],
    "EnumProgressItems": ["2c941fca-975b-59be-a960-9a2a262853a5"],
    "EnumerableObjectCollection": ["2d3468c1-36a7-43b6-ac24-d3f02fd9607a"],
    "Equation": ["0003000b-0000-0000-c000-000000000046"],
    "ErrorObject": ["0000031b-0000-0000-c000-000000000046"],
    "ErrorOverlayHandler": ["0ca2640d-5b9c-4c59-a5fb-2da61a7437cf"],
    "EulaPlugin": ["56871d63-fe46-4c7e-84bb-5db82d4a99f8"],
    "EvalCom2": ["6e5e1910-8053-4660-b795-6b612e29bc58"],
    "EventException": ["3051073b-98b5-11cf-bb82-00aa00bdce0b"],
    "EventRecordXml": ["aab9c730-3c6c-4faa-a87e-77198d9e2a57"],
    "EverywhereScopeFiller": ["7c61d0a6-af7e-483a-b705-d2c5c2264656"],
    "ExcelChart": ["00030001-0000-0000-c000-000000000046"],
    "ExcelMacrosheet": ["00030002-0000-0000-c000-000000000046"],
    "ExcelWorksheet": ["00030000-0000-0000-c000-000000000046"],
    "ExeDropTarget": ["86c86720-42a0-1069-a2e8-08002b30309d"],
    "ExecuteAssociation": ["1649d1cf-deaf-4a68-abe8-5c9f68572fd1"],
    "ExecuteFolder": ["11dbb47c-a525-400b-9e80-a54615a090c0"],
    "ExecuteOpenSearchDescription": ["cb1dfe3a-edff-4d1f-867d-8adb02926f4b"],
    "ExecuteUnknown": ["e44e9428-bdbc-4987-a099-40dc8fd255e7"],
    "ExpansionExperienceController": ["6e625d11-49b9-4ca6-a697-dd04fd60c41f"],
    "ExplorerAddColumnsCommand": ["385906fb-1482-4f64-8a23-5d74e1ce1815"],
    "ExplorerBrowser": ["71f96385-ddd6-48d3-a0c1-ae06e8b055fb"],
    "ExplorerBrowserResultsFolder": ["418c8b64-5463-461d-88e0-75e2afa3c6fa"],
    "ExplorerCommandEnumerator": ["5b53b2c2-46d6-433e-ab6e-b82efef22b6e"],
    "ExplorerCommandOverCommandStoreVerbList": ["afa470fe-371d-4f98-9592-39e3c7227e5c"],
    "ExplorerCommandOverIContextMenu": ["8de39096-d24e-4df3-b24b-1b7f770bf799"],
    "ExplorerCommandStateOverIContextMenu": ["3b1599f9-e00a-4bbf-ad3e-b3f99fa87779"],
    "ExplorerCopyToCommand": ["3852c2e2-4a16-4b11-8e71-f8904c37ec3d"],
    "ExplorerHideSelectedCommand": ["0947c622-f98a-48a5-9df7-60e5fe202e07"],
    "ExplorerHistoryCommand": ["e2fe048a-318b-4c79-a934-95af2bcadeac"],
    "ExplorerHostCreator": ["ab0b37ec-56f6-4a0e-a8fd-7a8bf7c2da96"],
    "ExplorerIconSizeCommand": ["be382474-a1dd-4dc9-aa9b-2a934d67bd10"],
    "ExplorerLauncher": ["1f849cce-2546-4b9f-b03e-4004781bdc40"],
    "ExplorerMoveToCommand": ["f60c3e02-214a-462b-9b07-56ea38545a13"],
    "ExplorerNewItemCommand": ["91145a83-a6c3-4181-89ff-8365f096f90d"],
    "ExplorerOpenCommand": ["ccec11f2-00c4-4266-9932-b9e49442711e"],
    "ExplorerPermanentDeleteCommand": ["e9571ab2-ad92-4ec6-8924-4e5ad33790f5"],
    "ExplorerRecycleCommand": ["3c4512dc-aefa-4a1e-95cf-edf896092447"],
    "ExplorerSelectionCheckboxesCommand": ["56a91da5-5051-49f5-8d23-1f050a63e966"],
    "ExplorerSettingHandler": ["e1625daf-d7c8-474b-b5c0-1525431d462c"],
    "ExplorerSettingMonitor": ["0e971350-4039-4a03-85fe-4c210917c26d"],
    "ExplorerShowFileExtensionsCommand": ["4ac6c205-2853-4bf5-b47c-919a42a48a16"],
    "ExplorerShowHiddenFilesCommand": ["f7300245-1f4b-41ba-8948-6fd392064494"],
    "ExplorerSizeAllColumnsCommand": ["f4e8bc67-9616-4a28-a332-cf27a5ca6736"],
    "ExtensionItem": ["00d5e447-499e-4dc3-9d51-981564a78b08"],
    "ExtensionManager": ["aa043d17-3a13-42e8-b47a-9118ce4aaa32"],
    "ExtractConstIcon": ["3d154a2d-d911-437e-a30c-5f56a9b7081d"],
    "ExtractToCommand": ["2737ee87-aba3-4f28-89a6-c370484d85f9"],
    "F12ExplorerBar": ["28bccb9a-e66b-463c-82a4-09f320de94d7"],
    "FSCopyHandler": ["d197380a-0a79-4dc8-a033-ed882c2fa14b"],
    "FTItemContainer": ["11d162b6-1cea-4b4a-8037-2518ecd6554b"],
    "FTSqlParserCF": ["9e175b90-f52a-11d8-b9a5-505054503030"],
    "FXEQ": ["f5e01117-d6c4-485a-a3f5-695196f3dbfa"],
    "FXEcho": ["5039d740-f736-449a-84d3-a56202557b87"],
    "FXMasteringLimiter": ["c4137916-2be1-46fd-8599-441536f49856"],
    "FXReverb": ["7d9aca56-cb68-4807-b632-b137352e8596"],
    "FYI": ["0003001e-0000-0000-c000-000000000046"],
    "FYIView": ["0003001f-0000-0000-c000-000000000046"],
    "FadeTask": ["7eb5fbe4-2100-49e6-8593-17e130122f91"],
    "FavDataModelProvider": ["da5a3c3a-7a53-4300-a2fa-1ed6f5d864c5"],
    "FavItemFilter": ["7ee0a24e-a8c6-46ae-a875-8e7c3d18aeaf"],
    "FavShortcutsHandler": ["e6290c32-443a-4529-aec3-320adf0f9622"],
    "FavShortcutsHandlerCallback": ["ae17fc35-f74e-45db-9ccf-35193d4f7622"],
    "FavoritesShellNamespaceMonitorCallback": ["5160f343-7a1f-46c2-9e21-fc7f1daf37f3"],
    "FeatureStagingPlugin": ["5e46f84b-3520-4a35-877a-083a2f0b7f59"],
    "FeedFolderWatcher": ["281001ed-7765-4cb0-84af-e9b387af01ff"],
    "FeedTasks": ["53510d24-57eb-4713-9afb-e6e60530b87e"],
    "FeedViewer": ["528d46b3-3a4b-4b13-bf74-d9cbd7306e07"],
    "FeedWatcher": ["18a6737b-f433-4687-89bc-a1b4dfb9f123"],
    "FeedsArbiterLoRiBroker": ["34e6abfe-e9f4-4ddf-895a-7350e198f26e"],
    "FeedsLoriBroker": ["a7c922a0-a197-4ae4-8fcd-2236bb4cf515"],
    "FeedsManager": ["faeb54c4-f66f-4806-83a0-805299f5e3ad"],
    "FhFolder": ["2f6ce85c-f9ee-43ca-90c7-8a9bd53a2467"],
    "FileByteStream": ["90eab60e-e43a-4188-bcc4-e47fdf04868c"],
    "FileChangeTrackerRegistrar": ["df5196f5-203a-4edf-be7e-d08e5906b1cf"],
    "FileFolderBoth": ["0e5aae11-a475-4c5b-ab00-c66de400274e"],
    "FileMoniker": ["00000303-0000-0000-c000-000000000046"],
    "FileOpenDialog": ["dc1c5a9c-e88a-4dde-a5a1-60f82a20aef7"],
    "FileOpenDialogLegacy": ["725f645b-eaed-4fc5-b1c5-d9ad0accba5e"],
    "FileOperation": ["3ad05575-8857-4850-9277-11b85bdb8e09"],
    "FileOperationUndoUnit": ["72c57034-02c4-4e9f-bf9c-ca711031757e"],
    "FilePlaceholderThumbnailProvider": ["503e9fd4-127c-4d72-84bf-cf3ec3f80d40"],
    "FilePropSheetPageHelper": ["e96767e0-7eaa-45e1-8e7d-64414aff281a"],
    "FileProtocol": ["79eac9e7-baf9-11ce-8c82-00aa004ba90b"],
    "FileSaveDialog": ["c0b4e2f3-ba21-4773-8dba-335ec946eb8b"],
    "FileSaveDialogLegacy": ["af02484c-a0a9-4669-9051-058ab12b9195"],
    "FileSchemePlugin": ["477ec299-1421-4bdd-971f-7ccb933f21ad"],
    "FileSysMonitor": ["4c5ebd71-431c-43a0-b93c-3ebf917b540f"],
    "FileSystemDataItemEnum": ["7dde3545-d2b1-4178-9f83-2dc9a80504d4"],
    "FileSystemDataProvider": ["17e5bf9b-e4fc-4c04-8ea6-527437d6cfd9"],
    "FileSystemImageResult": ["2c941fcc-975b-59be-a960-9a2a262853a5"],
    "FileSystemSettingHandler2": ["c0ab2a0d-f2d2-46e2-9df9-8885a424c29a"],
    "FileTimeBasedSettingUnitResolver": ["2d5d2fab-632b-47c3-a087-93bc89bb5123"],
    "FilgraphManager": ["e436ebb3-524f-11ce-9f53-0020af0ba770"],
    "FilterControl": ["7cd3c903-d2e9-4a4d-8af3-3025445b24bf"],
    "FilterGraphPrivateThread": ["a3ecbc41-581a-4476-b693-a63340462d8b"],
    "FilterWorkerItem": ["82d792e9-8f8c-4f4a-9dbf-06253e4562a8"],
    "FilteredItemFactory": ["36a479ef-8b67-4d01-8dda-753cfcb2dd96"],
    "FindExecute": ["a015411a-f97d-4ef3-8425-8a38d022aebc"],
    "FlightSettingsAPIBroker": ["3185a766-b338-11e4-a71e-12e3f512a338"],
    "FolderCustomize": ["ef43ecfe-2ab9-4632-bf21-58909dd177f0"],
    "FolderInfoTip": ["22c6c651-f6ea-46be-bc83-54e83314c67f"],
    "FolderItemsMultiLevel": ["53c74826-ab99-4d33-aca4-3117f51d3788"],
    "FolderMarshalStub": ["bf50b68e-29b8-4386-ae9c-9734d5117cd5"],
    "FolderNetworkDrive": ["b7373566-8ff2-45d8-af1f-da39f289bcf9"],
    "FolderOptionsCommand": ["83bb272f-7d5e-4b6e-9250-889893f0dac7"],
    "FontPropertyHandler": ["0afccba6-bf90-4a4e-8482-0ac960981f5b"],
    "FormatCancelAutoPlay": ["f1e98303-1060-4509-a49a-c864ffea0f92"],
    "FormatEngine": ["7aa7790d-75d7-484b-98a1-3913d022091d"],
    "FormatForDisplayHelper": ["82c588e7-e54b-408c-9f8c-6af9adf6f1e9"],
    "FrameAuto": ["13a4bbe8-6527-40cb-a996-1602829541ef"],
    "FrameServerNetworkCameraSource": ["7a213aa7-866f-414a-8c1a-275c7283a395"],
    "FrameworkInputPane": ["d5120aa3-46ba-44c5-822d-ca8092c1fc72"],
    "FrequentPlacesFolder": ["3936e9e4-d92c-4eee-a85a-bc16d5ea0819"],
    "FsiDirectoryItem": ["2c941fc8-975b-59be-a960-9a2a262853a5"],
    "FsiFileItem": ["2c941fc7-975b-59be-a960-9a2a262853a5"],
    "FsiNamedStreams": ["c6b6f8ed-6d19-44b4-b539-b159b793a32d"],
    "FsiStream": ["2c941fcd-975b-59be-a960-9a2a262853a5"],
    "FsrmAccessDeniedRemediationClient": ["100b4fc8-74c1-470f-b1b7-dd7b6bae79bd"],
    "FsrmClassificationManager": ["b15c0e47-c391-45b9-95c8-eb596c853f3a"],
    "FsrmExportImport": ["1482dc37-fae9-4787-9025-8ce4e024ab56"],
    "FsrmFileGroupManager": ["8f1363f6-656f-4496-9226-13aecbd7718f"],
    "FsrmFileManagementJobManager": ["eb18f9b2-4c3a-4321-b203-205120cff614"],
    "FsrmFileScreenManager": ["95941183-db53-4c5f-b37b-7d0921cf9dc7"],
    "FsrmFileScreenTemplateManager": ["243111df-e474-46aa-a054-eaa33edc292a"],
    "FsrmPathMapper": ["f3be42bd-8ac2-409e-bbd8-faf9b6b41feb"],
    "FsrmPipelineModuleConnector": ["c7643375-1eb5-44de-a062-623547d933bc"],
    "FsrmQuotaManager": ["90dcab7f-347c-4bfc-b543-540326305fbe"],
    "FsrmQuotaTemplateManager": ["97d3d443-251c-4337-81e7-b32e8f4ee65e"],
    "FsrmReportManager": ["0058ef37-aa66-4c48-bd5b-2fce432ab0c8"],
    "FsrmReportScheduler": ["ea25f1b8-1b8d-4290-8ee8-e17c12c2fe20"],
    "FsrmSetting": ["f556d708-6d4d-4594-9c61-7dbb0dae2a46"],
    "FtpFolder": ["63da6ec0-2e98-11cf-8d82-444553540000"],
    "FtpProtocol": ["79eac9e3-baf9-11ce-8c82-00aa004ba90b"],
    "FunctionDiscovery": ["c72be2ec-8e90-452c-b29a-ab8ff1c071fc"],
    "FunctionInstanceCollection": ["ba818ce5-b55f-443f-ad39-2fe89be6191f"],
    "GCTaskTOID": ["c28eb156-523c-11d2-a561-00a0c92dbfe8"],
    "GIFFilter": ["3b7e1a45-7776-11cf-b751-00aa00bdd7e0"],
    "GPESnapIn": ["8fc0b734-a0e1-11d1-a7d3-0000f87571e3"],
    "GPMBackupDirEx": ["e8c0988a-cf03-4c5b-8be2-2aa9ad32aada"],
    "GPMStarterGPOBackup": ["389e400a-d8ef-455b-a861-5f9ca34a6a02"],
    "GPMStarterGPOBackupCollection": ["e75ea59d-1aeb-4cb5-a78a-281daa582406"],
    "GPMStarterGPOCollection": ["82f8aa8b-49ba-43b2-956e-3397f9b94c3a"],
    "GPMTemplate": ["ecf1d454-71da-4e2f-a8c0-8185465911d9"],
    "GameFolder": ["ed228fdf-9ea8-4870-83b1-96b02cfe0d52"],
    "GangImageList": ["bb8d2c61-6ac0-4850-bc0f-b1c21b4182e3"],
    "GeneralPropPage": ["c3e5d3d2-1a03-11cf-942d-008029004347"],
    "GenericCredentialProvider": ["25cbb996-92ed-457e-b28c-4774084bd562"],
    "GenericTypeLibOLE": ["000204ff-0000-0000-c000-000000000046"],
    "GlobalFolderSettings": ["ef8ad2d1-ae36-11d1-b2d2-006097df8c11"],
    "GlobalOptions": ["0000034b-0000-0000-c000-000000000046"],
    "GlobalRudeWindowManager": ["8e871b70-0f3d-4605-8919-89a7acba199c"],
    "GlobalServiceDS": ["59699770-2bf1-46c6-857c-1d509db7079e"],
    "GopherProtocol": ["79eac9e4-baf9-11ce-8c82-00aa004ba90b"],
    "GraphPropPage": ["c3e5d3d3-1a03-11cf-942d-008029004347"],
    "GrepProvider": ["1685d4ab-a51b-4af1-a4e5-cee87002431d"],
    "GrepWdsResolver": ["1c0f439d-7c29-4bde-8952-4eeb6a49e048"],
    "GroupByColumnCommand": ["827b7a93-2c48-433e-b247-8e3be20aab4a"],
    "GroupPolicyObject": ["ea502722-a23d-11d1-a7d3-0000f87571e3"],
    "HJWIN1_0": ["0003001c-0000-0000-c000-000000000046"],
    "HTMLAudioElement": ["3051070e-98b5-11cf-bb82-00aa00bdce0b"],
    "HTMLAudioElementFactory": ["305107ec-98b5-11cf-bb82-00aa00bdce0b"],
    "HTMLCSSImportRule": ["305106f0-98b5-11cf-bb82-00aa00bdce0b"],
    "HTMLCSSMediaList": ["30510732-98b5-11cf-bb82-00aa00bdce0b"],
    "HTMLCSSMediaRule": ["305106f1-98b5-11cf-bb82-00aa00bdce0b"],
    "HTMLCSSNamespaceRule": ["305106f2-98b5-11cf-bb82-00aa00bdce0b"],
    "HTMLCSSRule": ["305106ef-98b5-11cf-bb82-00aa00bdce0b"],
    "HTMLCSSStyleDeclaration": ["30510741-98b5-11cf-bb82-00aa00bdce0b"],
    "HTMLCanvasElement": ["305106e5-98b5-11cf-bb82-00aa00bdce0b"],
    "HTMLDOMRange": ["305106c3-98b5-11cf-bb82-00aa00bdce0b"],
    "HTMLDOMXmlSerializerFactory": ["30510780-98b5-11cf-bb82-00aa00bdce0b"],
    "HTMLDocumentCompatibleInfo": ["3051041b-98b5-11cf-bb82-00aa00bdce0b"],
    "HTMLDocumentCompatibleInfoCollection": ["30510419-98b5-11cf-bb82-00aa00bdce0b"],
    "HTMLEditor": ["3050f4f5-98b5-11cf-bb82-00aa00bdce0b"],
    "HTMLElemCtxStream": ["30510483-98b5-11cf-bb82-00aa00bdce0b"],
    "HTMLHELP": ["41b23c28-488e-4e5c-ace2-bb0bbabe99e8"],
    "HTMLMSCSSKeyframeRule": ["3051080e-98b5-11cf-bb82-00aa00bdce0b"],
    "HTMLMSCSSKeyframesRule": ["3051080f-98b5-11cf-bb82-00aa00bdce0b"],
    "HTMLMediaElement": ["3051070c-98b5-11cf-bb82-00aa00bdce0b"],
    "HTMLMediaError": ["3051070a-98b5-11cf-bb82-00aa00bdce0b"],
    "HTMLPerformance": ["3051074f-98b5-11cf-bb82-00aa00bdce0b"],
    "HTMLPerformanceNavigation": ["30510751-98b5-11cf-bb82-00aa00bdce0b"],
    "HTMLPerformanceTiming": ["30510753-98b5-11cf-bb82-00aa00bdce0b"],
    "HTMLPopupDoc": ["3050f67d-98b5-11cf-bb82-00aa00bdce0b"],
    "HTMLProgressElement": ["3050f2d5-98b5-11cf-bb82-00aa00bdce0b"],
    "HTMLSemanticElement": ["305107b0-98b5-11cf-bb82-00aa00bdce0b"],
    "HTMLSourceElement": ["3051070d-98b5-11cf-bb82-00aa00bdce0b"],
    "HTMLStorage": ["30510475-98b5-11cf-bb82-00aa00bdce0b"],
    "HTMLStyleMedia": ["3051074c-98b5-11cf-bb82-00aa00bdce0b"],
    "HTMLStyleSheetRulesAppliedCollection": ["eb36f845-2395-4719-b85c-d0d80e184bd9"],
    "HTMLTimeRanges": ["3051070b-98b5-11cf-bb82-00aa00bdce0b"],
    "HTMLVideoElement": ["3051070f-98b5-11cf-bb82-00aa00bdce0b"],
    "HTMLW3CComputedStyle": ["305106c8-98b5-11cf-bb82-00aa00bdce0b"],
    "HTMLWndOptionElement": ["3050f2d0-98b5-11cf-bb82-00aa00bdce0b"],
    "HTMLWndSelectElement": ["3050f2cf-98b5-11cf-bb82-00aa00bdce0b"],
    "HTMLXMLHttpRequest": ["3051040b-98b5-11cf-bb82-00aa00bdce0b"],
    "HTMLXMLHttpRequestFactory": ["3051040d-98b5-11cf-bb82-00aa00bdce0b"],
    "HWDeviceCustomProperties": ["555f3418-d99e-4e51-800a-6e89cfd8b1d7"],
    "HWShellChangeNotification": ["06bfb4de-249d-43be-bacc-379007fd62b6"],
    "HardwareDevices": ["dd522acc-f821-461a-a407-50b198b896dc"],
    "HealthCenterSSO": ["f56f6fdd-aa9d-4618-a949-c1b91af43b1a"],
    "HelpExecute": ["9127081a-04b5-4044-b4c5-c7a9718e8795"],
    "HgAddMembersPage": ["59a23cb9-0a7d-4160-bbc9-d51d24860722"],
    "HgBackupPage": ["fd437830-3eca-4390-884b-f3ea9c681f00"],
    "HgBeginPage": ["abd2ad24-f1ff-47ad-82de-3a1edf38e7a1"],
    "HgChangePasskeyHookPage": ["4582eba9-6aa1-4d79-824e-728929ef455d"],
    "HgChangeSharingHookPage": ["934a7048-1e4a-4d6e-9a9a-cb739f519b07"],
    "HgConfirmPage": ["12fc5e89-5446-4a7c-ba46-207a29e2945d"],
    "HgCplElementProvider": ["24d568c5-f3ae-4f91-9cd9-aa18876da7c2"],
    "HgCplInitializer": ["006e61df-1a43-4f2c-b26f-780baea3a92d"],
    "HgCreateHookPage": ["782fc20a-81cf-43de-a625-072155bcd30c"],
    "HgEmptyHookPage": ["3730bbf8-631a-48fb-9085-e2143c11563b"],
    "HgFinishedPage": ["a86ca2f1-af74-4a74-980b-e185d4ca01b0"],
    "HgJoinHookPage": ["8c1645b0-9864-465e-be75-990b030e4b11"],
    "HgJoinPage": ["2900a727-125c-4f82-ad1e-add2bd6d34a0"],
    "HgLeaveHookPage": ["622a8646-1096-4765-8e07-91a3e661cef9"],
    "HgPasskeyPage": ["879fb53b-cba3-4fc8-b233-d9a93afa7fbc"],
    "HgSharingPage": ["31220067-ee3a-4ed7-b579-103d74930cb5"],
    "HgTask": ["b27b520e-46db-4720-b9c5-5f80acab23a4"],
    "HgUpdateMergeHookPage": ["009f3b45-8a6b-4360-b997-b2a009a16402"],
    "HidPairingPlugin": ["b832674a-f36f-4780-ae4c-1566aae3a4f4"],
    "HideInputPaneAnimationCoordinator": ["384742b1-2a77-4cb3-8cf8-1136f5e17e59"],
    "HierarchyList": ["0003002b-0000-0000-c000-000000000046"],
    "HistFolder": ["ff393560-c2a7-11cf-bff4-444553540000"],
    "HistogramGeneratorMFT": ["7b82d688-3b9e-4090-8ecd-fc84e454c923"],
    "HistoryDataModelProvider": ["e9c6a521-ff96-4032-bb07-192385868bb0"],
    "HistorySearchProtocolHandler": ["ee0bddfa-8373-4cc4-85d8-0618e453187c"],
    "HoloSIInterop": ["0a2ec3b5-6599-42f1-8d7c-afd6f3771cad"],
    "HoloSILoader": ["ba0f250b-ebed-4a99-b386-e0260524fa54"],
    "HolographicCoordinator": ["949cac9a-8ed9-42b5-9bb8-637d43127e5d"],
    "HolographicCortanaExperiencePositioner": ["f8176406-3ab4-46d7-ac48-ed5383c13b7c"],
    "HolographicSessionTracker": ["88a8f216-8669-48d8-b076-0a6319ab4011"],
    "HomeFolder": ["679f85cb-0220-4080-b29b-5540cc05aab6"],
    "HomeFolderCategorizer": ["d88dc591-4172-4a00-a6b1-7b657d2a6643"],
    "HomeGroup": ["de77ba04-3c92-4d11-a1a5-42352a53e0e3"],
    "HomeGroupAutoCreateJoin": ["1f068127-5760-490e-998c-6e35b845f49e"],
    "HomeGroupCPLCommand": ["aa2e2c5b-0b0c-4ecc-b32b-3935269e0588"],
    "HomeGroupCapabilities": ["b37bf7d7-b78e-4465-98de-71732453b03d"],
    "HomeGroupCollection": ["cc6f1005-cae0-4892-b602-65a5fd7ec2d6"],
    "HomeGroupCollectionServer": ["a188db29-2abc-46cb-9a38-40b82cf5d051"],
    "HomeGroupCommandState": ["ccaeaa6d-3a50-488f-a664-5facf424bc46"],
    "HomeGroupComponentList": ["c992c58d-313b-469c-8202-456ff574ff4e"],
    "HomeGroupCtrl": ["c605507b-9613-4756-9c07-e0d74321cb1e"],
    "HomeGroupCtrlServer": ["ea022610-0748-4c24-b229-6c507ebdfdbb"],
    "HomeGroupJoinCommand": ["e4d5b02c-82a9-4363-bd02-8ba595200bcf"],
    "HomeGroupListenerEncryption": ["956faded-2450-4abb-9f8c-4629fafebb92"],
    "HomeGroupListenerNotify": ["6a2a9381-5a92-4296-9397-564673ae1fdd"],
    "HomeGroupNetwork": ["0700f42f-eee3-443a-9899-166f16286796"],
    "HomeGroupPassword": ["7be73787-ce71-4b33-b4c8-00d32b54bea8"],
    "HomeGroupPasswordCommand": ["c98f3822-3658-4d75-8a25-6621665ecd56"],
    "HomeGroupPeerManager": ["5e032150-8c1e-4c9e-bc60-36e9bffcff56"],
    "HomeGroupPrinterMonitor": ["c4050bc4-29e1-4c8f-bf6e-6ebad21e0673"],
    "HomeGroupPrinting": ["147a9c5d-36f4-4e3e-bd47-f5f207425085"],
    "HomeGroupPropertiesXml": ["9d70f871-9edc-42e3-a62d-42aaea519eec"],
    "HomeGroupProvider": ["6f7c8e8f-dc69-4e3f-bc05-439962a05fd5"],
    "HomeGroupRoamedPassword": ["2de92db3-cd3e-4ad6-80f9-089036e1c81e"],
    "HomeGroupSSO": ["ff363bfe-4941-4179-a81c-f3f1ca72d820"],
    "HomeGroupSharingCommand": ["ed8c22ca-7722-464a-a522-7967abf63c35"],
    "HomeGroupState": ["df60686c-2941-4893-80c0-f13173b719d3"],
    "HomeGroupTroubleshooterCommand": ["7b90dae3-4ad0-4f0d-be80-a26b296c3156"],
    "HomeGroupUIStatus": ["6f33340d-8a01-473a-b75f-ded88c8360ce"],
    "HomeGroupUSBPrinterDevice": ["7df8ef76-d449-485f-b4eb-58dc96b31edb"],
    "HomeGroupUserFolder": ["c2022b3a-ee3a-4a8d-9484-0f6d225b1f5b"],
    "HomeGroupUserGroupedFolder": ["544fd8e9-5ec6-4100-991a-b6feccc6b527"],
    "HomeOperationSink": ["d105a4d4-344c-48eb-9866-ee378d90658b"],
    "HomePageSetting": ["374cede0-873a-4c4f-bc86-bcc8cf5116a3"],
    "HorizontalIndicatorContent": ["e7d18cf5-3ec7-44d5-a76b-3770f3cf903d"],
    "HostAuthenticatorApis": ["8b4b437e-4cab-4e83-89f6-7f9f7df414ea"],
    "HostPeerApis": ["8c482dce-2644-4419-aeff-189219f916b9"],
    "HostedApplicationActivationManager": ["513a0312-3345-4d16-94e5-630b0262c2eb"],
    "HostedApplicationBridgeWindow": ["018f2d58-f16d-448a-bd87-225c8c5d5c94"],
    "HostedApplicationExperienceManager": ["d29f1d89-3cd1-4b52-bb5d-7c59b122dbb4"],
    "HostedWindowFactory": ["e084f594-a1de-4038-b8d1-6c3c5fc3617c"],
    "HostedWindowFactoryProxy": ["e57401ab-d6b3-4deb-979e-f082052dd374"],
    "HotPlug": ["1d5532bb-1e08-4002-8445-8ba35e462045"],
    "HtmlDocForParsingSiteUnmarshaller": ["0add8d9b-e3c3-43b5-bbce-1e158e027a64"],
    "HtmlInformation": ["70eb7a10-55d9-11cf-b75b-00aa0051fe20"],
    "HttpProtocol": ["79eac9e2-baf9-11ce-8c82-00aa004ba90b"],
    "HttpSProtocol": ["79eac9e5-baf9-11ce-8c82-00aa004ba90b"],
    "HttpSchemePlugin": ["44cb442b-9da9-49df-b3fd-023777b16e50"],
    "ICMDecompressorDMO": ["d4debcbc-6cd3-44b3-85f1-e8b995ddc61f"],
    "ICodecAPIProxy": ["7ff0997a-1999-4286-a73c-622b8814e7eb"],
    "IE4_PROTOCOLS": ["9d148291-b9c8-11d0-a4cc-0000f80149f6"],
    "IEAddressEditBox": ["8d1a1cad-aa65-4ade-855b-23980fab7217"],
    "IEFadeTask": ["1c1edb47-ce22-4bbb-b608-77b48f83c823"],
    "IENamespaceTreeControl": ["ace52d03-e5cd-4b20-82ff-e71b11beae1d"],
    "IERSSFeedFolderTasks": ["aac2b978-266d-48ae-aa28-60a3ebb872d0"],
    "IERSSFeedsFolder": ["9a096bb5-9dc3-4d1c-8526-c3cbf991ea4e"],
    "IERecoveryStore": ["10bceb99-faac-4080-b2fa-d07cd671eef2"],
    "IETaskScheduler": ["05bdc38e-5493-487a-a7ff-8cf2246abc13"],
    "IEThreadHandshake": ["9fae1230-74ac-4e33-b59c-4051bbeb0803"],
    "IEWebDriverManager": ["90314af2-5250-47b3-89d8-6295fc23bc22"],
    "IEWindows": ["6f5bad87-9d5e-459f-bd03-3957407051ca"],
    "IEXMLDocument": ["30590065-98b5-11cf-bb82-00aa00bdce0b"],
    "IE_ACLCustomMRU": ["fde7673d-2e19-4145-8376-bbd58c4bc7ba"],
    "IE_ACLHistory": ["6038ef75-abfc-4e59-ab6f-12d397f6568d"],
    "IE_ACLMRU": ["98ff6d4b-6387-4b0a-8fbd-c5c4bb17b4f8"],
    "IE_ACLMulti": ["b31c5fae-961f-415b-baf0-e697a5178b94"],
    "IE_ACListISF": ["9d958c62-3954-4b44-8fab-c4670c1db4c2"],
    "IE_AddressBand": ["de011590-0531-4804-9c9c-3fedc7e6e5c8"],
    "IE_AutoComplete": ["3028902f-6374-48b2-8dc6-9725e775b926"],
    "IE_DataModel": ["f4f79392-50e8-4d7f-8e84-ca4173bd0faa"],
    "IE_INIPropertySetStorage": ["942bc614-676c-464e-b384-d3202aaa02da"],
    "IE_ISFBand": ["6cf48ef8-44cd-45d2-8832-a16ea016311b"],
    "IE_MenuBand": ["4b78d326-d922-44f9-af2a-07805c2a3560"],
    "IE_MenuBandSite": ["44c76ecd-f7fa-411c-9929-1b77ba77f524"],
    "IE_PrivateProfile": ["4dfed3f9-b794-4d3c-973b-dda1c28105a9"],
    "IE_QuickLinks": ["f2cf5485-4e02-4f68-819c-b92de9277049"],
    "IE_SearchBand": ["30d02401-6a81-11d0-8274-00c04fd5ae38"],
    "IE_TrackShellMenu": ["6b4ecc4f-16d1-4474-94ab-5a763f2a54ae"],
    "IITCmdInt": ["4662daa2-d393-11d0-9a56-00c04fb68bf7"],
    "IITDatabase": ["66673452-8c23-11d0-a84e-00aa006c7d01"],
    "IITDatabaseLocal": ["4662daa9-d393-11d0-9a56-00c04fb68bf7"],
    "IITGroupUpdate": ["4662daa4-d393-11d0-9a56-00c04fb68bf7"],
    "IITIndexBuild": ["8fa0d5aa-dedf-11d0-9a61-00c04fb68bf7"],
    "IITPropList": ["4662daae-d393-11d0-9a56-00c04fb68bf7"],
    "IITResultSet": ["4662daa7-d393-11d0-9a56-00c04fb68bf7"],
    "IITSvMgr": ["4662daa3-d393-11d0-9a56-00c04fb68bf7"],
    "IITWWFilterBuild": ["8fa0d5ab-dedf-11d0-9a61-00c04fb68bf7"],
    "IITWordWheel": ["d73725c2-8c12-11d0-a84e-00aa006c7d01"],
    "IITWordWheelLocal": ["4662daa8-d393-11d0-9a56-00c04fb68bf7"],
    "IITWordWheelUpdate": ["4662daa5-d393-11d0-9a56-00c04fb68bf7"],
    "IMimeHtmlProtocol": ["05300401-bcbc-11d0-85e3-00c04fd85ab4"],
    "IMimeInternational": ["fd853cd9-7f86-11d0-8252-00c04fd85ab4"],
    "IMimeObjResolver": ["35461e30-c488-11d1-960e-00c04fbd7c09"],
    "INDEX_SERVER_DSO": ["f9ae8980-7e52-11d0-8964-00c04fd611d7"],
    "INIPropertySetStorage": ["6b6f9d2d-6d49-4026-83a6-86dfc1c3c6f0"],
    "ITEngStemmer": ["8fa0d5a8-dedf-11d0-9a61-00c04fb68bf7"],
    "ITStdBreaker": ["4662daaf-d393-11d0-9a56-00c04fb68bf7"],
    "IVideoEncoderCodecAPIProxy": ["b05dabd9-56e5-4fdc-afa4-8a47e91f1c9c"],
    "IVideoEncoderProxy": ["b43c4eec-8c32-4791-9102-508ada5ee8e7"],
    "IisServiceControl": ["e8fb8621-588f-11d2-9d61-00c04f79c5fe"],
    "ImageProcessorForRoaming": ["94e7f5bd-fc4f-446c-93d2-3942e8fe34c9"],
    "ImageSanitizationBroker": ["abca6774-29b5-4aff-a776-c2551ae0ffe6"],
    "ImageSanitizationValidator": ["edb9987a-fff5-4bd2-8b05-2865f3ec621d"],
    "ImePlugInDictDictionaryList_CHS": ["7bf0129b-5bef-4de4-9b0b-5edb66ac2fa6"],
    "ImePlugInDictDictionaryList_JPN": ["4fe2776b-b0f9-4396-b5fc-e9d4cf1ec195"],
    "ImmersiveAppCrusher": ["405ec9ab-0c64-4b9f-b726-3a858a9e2bd6"],
    "ImmersiveAppOpenExecute": ["a9249952-f4c6-4bcd-9b44-6a5ba9b5209e"],
    "ImmersiveApplicationManager": ["50fdbb99-5c92-495e-9e81-e2c2f48cddae"],
    "ImmersiveBackstackManager": ["70a92fa3-7fd8-4808-9a05-6b2fd19aa5b3"],
    "ImmersiveHotkeyNotification": ["00722f5f-cb8f-44d3-ac27-cc37f76cfe92"],
    "ImmersiveLauncher": ["44a50f5f-78e2-4d17-930c-68bb9f69ec9e"],
    "ImmersiveLightDismissProvider": ["600f8139-d614-4700-bf13-b0ccf9818c73"],
    "ImmersiveMonitorManager": ["205447d9-4af1-4f97-a773-e10ff2e44ead"],
    "ImmersiveMonitorNotificationServiceProxy": ["a894ca92-2e31-4af2-bc7e-41079a8e5be9"],
    "ImmersiveOpenWithUI": ["94b23d4d-1040-4c4b-9081-85d8d6fa36c4"],
    "ImmersivePlaybackManager": ["e19ff627-4c38-406d-9b4a-7973e0f539ba"],
    "ImmersiveSessionIdleDetector": ["4bb24bc2-abfd-433d-935f-5950b42a4b3f"],
    "ImmersiveSettingsCache": ["a919ea73-490e-4d5c-9ba7-97cbc73119fe"],
    "ImmersiveShell": ["c2f03a33-21f5-47fa-b4bb-156362a2f239"],
    "ImmersiveShellBroker": ["228826af-02e1-4226-a9e0-99a855e455a6"],
    "ImmersiveShellBrokerComponent": ["4075b76f-fcdc-43b6-b0b9-5a005b38b335"],
    "ImmersiveShellHookService": ["f94cdf40-02d6-4e79-89f7-b5357f3b1a39"],
    "ImmersiveShellNotifier": ["0f7650ee-9afa-47b4-9be7-f74d9d3c41d7"],
    "ImmersiveShellTracingService": ["4c5ef749-a380-44fe-853d-ff928f2cd1ae"],
    "ImmersiveSplashScreen": ["329b80ec-2230-47b8-905d-a2dcf5171c6f"],
    "ImmersiveSplashScreenCF": ["c985df59-a91b-446b-93c3-fb2705d529bc"],
    "ImmersiveWindowMessageService": ["0363215c-3b87-4c3d-8300-ff3fd3e02b91"],
    "ImportServer": ["00030022-0000-0000-c000-000000000046"],
    "InMemoryPropertyStore": ["9a02e012-6303-4e1e-b9a1-630f802592c5"],
    "InMemoryPropertyStoreMarshalByValue": ["d4ca0e2d-6da7-4b75-a97c-5f306f0eaedc"],
    "IncludeInLibraryContextMenu": ["3dad6c5d-2167-4cae-9914-f99e41c12cfa"],
    "IncludeInLibraryExecute": ["f3cc4ca3-22c2-40ec-ac3c-89d8a43373b0"],
    "IndexScopeFiller": ["f60163ce-2b8d-458d-ab2c-40f215767514"],
    "IndexedLocationsComWrapper": ["6d3951eb-0b07-4fb8-b703-7c5cee0db578"],
    "IndexerTasks": ["76be8257-c4c0-4d37-90c0-a23372254d27"],
    "InetLogInformation": ["a1f89741-f619-11cf-bc0f-00aa006111e0"],
    "InfoBarManager": ["819d1334-9d74-4254-9ac8-dc745ebc5386"],
    "InitializeAutoPlayForegroundControl": ["fa61e9f8-580e-4575-ab01-4a62c31fcf43"],
    "InitializeSetNetworkLocationForegroundControl": ["3b64e510-8192-4224-a7ad-67e9a86ec479"],
    "InplaceShareEngine": ["6311429e-2f1a-4777-880f-c7289fd10169"],
    "InprocActpropsUnmarshaller": ["00000344-0000-0000-c000-000000000046"],
    "InputHostLayout": ["4ff787e6-9a86-4ba3-bed9-8019a2b4be1c"],
    "InputModeChangeNotifier": ["674b33c2-6ce9-4c33-838f-ea890d540348"],
    "InputPersonalizationSettingHandler": ["52550de3-15e4-4b53-9670-74fcf2b9ea21"],
    "InputPersonalizationSettingHandlerCallback": ["047fc311-d163-4bf4-8b25-8005623c37da"],
    "InputPersonalizationSettingMonitor": ["e6b1a103-277a-4d64-abd0-90151f9cab82"],
    "InputPersonalizationSettingUnitResolver": ["6d1841aa-4f32-4fe6-8ef2-09f69cb32f14"],
    "InputSequenceCheckerContainer": ["02d887fb-4358-11d2-be22-080009dc0a8d"],
    "InputSwitchControl": ["b9bc2a50-43c3-41aa-a086-5db14e184bae"],
    "InsertDiscDialogCancelAutoPlay": ["4c5ed3b9-d8ef-40bc-bb46-29133669c6f4"],
    "InstallationAgent": ["317e92fc-1679-46fd-a0b5-f08914dd8623"],
    "InternetCacheCleaner": ["9b0efd60-f7b0-11d0-baef-00c04fc308c9"],
    "InternetExplorerManager": ["df4fcc34-067a-4e0a-8352-4a1a5095346e"],
    "InternetExplorerMedium": ["d5e8041d-920f-45e9-b8fb-b1deb82c6e5e"],
    "InternetToolbar": ["5e6ab780-7743-11cf-a12b-00aa004ae837"],
    "InvertSelectionExecute": ["0070746c-9a38-4236-822a-72cc4e5c8087"],
    "InvitationRecordXml": ["6473e7e7-d8d6-4696-9fbb-9f41df134b7b"],
    "InvokeSettingSyncSSO": ["130f6206-b21a-4b21-9d98-526b5aecc0bb"],
    "IsolatedAppLauncher": ["bc812430-e75e-4fd1-9641-1f9f1e2d9a1f"],
    "IsolatedMessageDialogFactory": ["f65817c8-dd85-4136-89f0-b9d12939f2c4"],
    "ItemHandlerCache": ["722b3793-5367-4446-b6bb-db89b05c1f24"],
    "ItemMoniker": ["00000304-0000-0000-c000-000000000046"],
    "ItemSetOperations": ["8509bb76-ffa3-4827-ba5e-2e786010f42f"],
    "ItemStore": ["81b43e73-e814-4dcd-a7c6-e22e7fe6a029"],
    "ItemsView": ["1eeb5b5a-06fb-4732-96b3-975c0194eb39"],
    "JPEGFilter": ["3b7e1a44-7776-11cf-b751-00aa00bdd7e0"],
    "JSProtocol": ["3050f3b2-98b5-11cf-bb82-00aa00bdce0b"],
    "JScript9": ["16d51579-a30b-4c8b-a276-0ff4dc41e755"],
    "JScript9Author": ["34a13fc7-86ab-42e6-a32c-b50666f04ff9"],
    "JScript9DAC": ["197060cb-5efb-4a53-b042-939dbb31627c"],
    "JScript9ThreadService": ["842a1268-6e6a-465c-868f-8bc445b9828f"],
    "KeyChangeProviderMonitor": ["04a7f8a1-f465-4079-a4fd-b8f4700df426"],
    "KeywordDetectorOemAdapter": ["76882aa2-2e80-48f1-a14e-4db1fac1f849"],
    "KindDescriptionFactory": ["1c1800c1-3258-44c2-be80-3deadb6c5e39"],
    "KnownAutoListManager": ["f235ce7d-b143-4d4f-ad93-64e48d53a5fb"],
    "KnownFolderManager": ["4df0c730-df9d-4ae3-9153-aa6b82e9795a"],
    "LPCMByteStreamPlugin": ["3ffb3b8c-eb99-472b-8902-e1c1b05f07cf"],
    "LPCMMFT": ["068a8476-9229-4cc0-9d49-2fc699dcd30a"],
    "LanLWConnectionManager": ["1693a251-983b-4cb6-a4a9-f27585a7d21a"],
    "LangToolsAvailableItemEnum": ["6e7c7940-f68a-4430-82e7-00d289fd75b5"],
    "LangToolsBroker": ["5bbd58bb-993e-4c17-8af6-3af8e908fca8"],
    "LangToolsItemEnum": ["c410fc3a-608c-49f3-b703-baa35d75ca89"],
    "LanguagePlugin": ["c96c4a08-12e9-4f87-8e6c-3dcf98518e11"],
    "LanguageResources": ["9e175b8e-f52a-11d8-b9a5-505054503030"],
    "LanguageSettingConflictResolver": ["017f10e3-89e4-49f0-b545-618de31fd27c"],
    "LanguageSettingHandler": ["e8c40b98-fcf5-4047-86da-11a11590cb98"],
    "LanguageSettingMonitor": ["3807bd87-d141-439a-b711-25a053a020f7"],
    "LateRestoreHelper": ["103874f6-2837-4156-9c6a-dee9d37cf3de"],
    "LauncherOutsideHolographic": ["3f9fc532-5964-48bf-a12d-b9bef2c21638"],
    "LayerComposer": ["31b11d80-9ed7-44f7-b1cd-c95992a738b9"],
    "LayerImageList": ["ea3b2014-508f-4eb0-9d90-2e07ec4105b2"],
    "LayoutFolder": ["328b0346-7eaf-4bbe-a479-7cb88a095f5b"],
    "LayoutManager": ["7e08e268-cd23-4e97-b433-ab31d5bfb6ae"],
    "LegacyAmFilterCategory": ["083863f1-70de-11d0-bd40-00a0c911ce86"],
    "LegacyApplicationActivationManager": ["85df5209-62b7-4e64-9720-53fe40a224fd"],
    "LegacyDataCollectorSet": ["03837526-098b-11d8-9414-505054503030"],
    "LegacyDataCollectorSetCollection": ["03837527-098b-11d8-9414-505054503030"],
    "LegacyExtensionEnumerator": ["89d337c0-6a3c-4966-a058-0f256282471c"],
    "LegacyFindFiles": ["70cba7d2-50a5-4383-8aa5-b378c01c7364"],
    "LegacyPrintUI": ["53445bed-3213-453b-a12a-79aa20a702dc"],
    "LegacyShareFields": ["964a239f-6039-4a44-bb9b-ec0feafe28fc"],
    "LegacyTraceSession": ["03837528-098b-11d8-9414-505054503030"],
    "LegacyTraceSessionCollection": ["03837529-098b-11d8-9414-505054503030"],
    "LibraryChangeIconRibbonCommand": ["6aa17c06-0c75-4006-81a9-57927e77ae87"],
    "LibraryDefaultSaveLocationRibbonCommand": ["17f418ed-5cd0-4067-be51-4c96d386ebc1"],
    "LibraryDescription": ["fe5afcf2-e681-4ada-9703-ef39b8ecb9bf"],
    "LibraryFactory": ["ea8b451c-5a19-49cf-bc5e-98accca49ef3"],
    "LibraryFolder": ["a5a3563a-5755-4a6f-854e-afa3230b199f"],
    "LibraryFolderContextMenu": ["0af96ede-aebf-41ed-a1c8-cf7a685505b6"],
    "LibraryGroupPolicySSO": ["811f592b-cde7-4ca4-a6d4-7bb3f60ad8fb"],
    "LibraryIncludeInLibraryRibbonCommand": ["83472593-4fe6-4f44-a14c-fc8d4b4ff3f5"],
    "LibraryKnownFolderHandler": ["c8c97725-c948-4720-bf0f-e3c2273bfb7d"],
    "LibraryManageLibraryRibbonCommand": ["69a568cf-86d1-4e47-b1fc-a74a110583fb"],
    "LibraryOptimizeLibraryForRibbonCommand": ["9e752621-4573-4308-81c6-9f210db29e85"],
    "LibraryPropHandler": ["66275315-bfa5-451b-88b6-e56ebc8d9b58"],
    "LibraryPropertyStore": ["eea0c191-dda8-4656-8fc4-72bdedba8a78"],
    "LibraryPublicSaveLocationRibbonCommand": ["506229ae-09c7-4ffd-8ec9-6a957f6da601"],
    "LibraryRestoreDefaultsRibbonCommand": ["9a07804e-7050-41d5-a244-badc038df532"],
    "LibraryShareEngine": ["cff9990b-6414-43f1-a526-14ea5eeafbda"],
    "LibraryShowInNavPaneRibbonCommand": ["f8d1da80-9aea-4ca4-ba41-bee6fca037b1"],
    "Line21Decoder2": ["e4206432-01a1-4bee-b3e1-3702c8edc574"],
    "LinguisticAlternativeGenerator": ["9ecf752a-518e-46b1-8691-f5090f5e9a14"],
    "LinguisticService": ["647c959d-3d77-46dc-8f81-2c2cf087c44f"],
    "LinkInfo": ["c82bf597-b831-11d0-b733-00aa00a1ebd2"],
    "ListViewPopup": ["8be9f5ea-e746-4e47-ad57-3fb191ca1eed"],
    "LocDescPropertyStore": ["948b45f7-efb8-46fb-8704-b340d847227a"],
    "LocalCopyHelper": ["021003e9-aac0-4975-979f-14b5d4e717f8"],
    "LocalFileBroker": ["69edb8b6-818a-46c0-a4b8-b6e112c63064"],
    "LocalGroups": ["8f3080a6-af99-4f2e-a806-f3d5702a0444"],
    "LocalMachineNames": ["0000034a-0000-0000-c000-000000000046"],
    "LocalSettingSyncProvider": ["6afe625a-6ed7-4475-bd04-47170b77d584"],
    "LocalThumbnailCache": ["50ef4544-ac9f-4a8e-b21b-8a26180db13f"],
    "LocalUserAccounts": ["4f6bcd94-c2a5-42ce-8dbc-31e794be4630"],
    "LocalUserPlugin": ["68db2410-63d2-4d4a-9449-fbd53fa4e7a3"],
    "LocationDescription": ["7763b7c0-a5fd-4aa9-bd1b-58b17137236b"],
    "LocationFolder": ["267cf8a9-f4e3-41e6-95b1-af881be130ff"],
    "LockScreenAppPositioner": ["27f86e83-f66e-455b-be1f-1ed899c48a2b"],
    "LockScreenApplicationManager": ["1d858a97-49a3-4805-8390-3bd5976e7abb"],
    "LockScreenCallBroker": ["de7d3d65-5454-4ef5-9518-776739dab39f"],
    "LockScreenSettingHandler": ["5eeb65ec-b078-4a5c-9161-6c463590a67b"],
    "LockScreenSettingMonitor": ["75a2b228-8919-4602-ac4a-b01174d18b54"],
    "LockScreenSnapPointsBehavior": ["a54bb483-c715-4d2f-8e0a-e3801f7cba57"],
    "LockScreenStore": ["c185ece5-0720-472c-b407-9bb4e8dd5e72"],
    "LockScreenViewManager": ["76dae2c2-5444-469f-9b1f-a853a5d565e2"],
    "LogFileItem": ["16ec5be8-df93-4237-94e4-9ee918111d71"],
    "LogFiles": ["2735d9fd-f6b9-4f19-a5d9-e2d068584bc5"],
    "LoggedOnAccounts": ["987d8dfa-3e2c-4929-9c51-61ac8e00cbc3"],
    "MAOAdminBroker": ["4356b08e-ecb5-43d1-8e9f-7bef4fc960fe"],
    "MF3GPSinkClassFactory": ["11275a82-5e5a-47fd-a01c-3683c12fb196"],
    "MFAC3PropertyHandler": ["edc3a8b5-2e25-466a-a1ad-21e2f19414ac"],
    "MFAC3SinkClassFactory": ["255a6fda-6f93-4e8a-9611-ded1169eefb4"],
    "MFADTSPropertyHandler": ["80009818-f38f-4af1-87b5-eadab9433e58"],
    "MFADTSSinkClassFactory": ["d7ca55ab-5022-4db3-a599-abafa358e6f3"],
    "MFAMRNBByteStreamHandler": ["efe6208a-0a2c-49fa-8a01-3768b559b6da"],
    "MFAMRNBSinkClassFactory": ["b0271158-70d2-4c5b-9f94-76f549d90fdf"],
    "MFASFPropertyHandler": ["aeb16279-b750-48f1-8586-97956060175a"],
    "MFAVIPropertyHandler": ["e2fb4720-f45f-4a3c-8cb2-2060e12425c3"],
    "MFAVISinkClassFactory": ["af4b1274-b78a-4979-aef5-20e78fee102e"],
    "MFByteStreamProxyClassFactory": ["770e8e77-4916-441c-a9a7-b342d0eebc71"],
    "MFCaptureEngine": ["efce38d3-8914-4674-a7df-ae1b3d654b8a"],
    "MFCaptureEngineClassFactory": ["efce38d3-8914-4674-a7df-ae1b3d654b8a"],
    "MFDShowTransformWrapper": ["ca8eb365-e97f-4cfa-965c-b3e8986abd8f"],
    "MFFLACBytestreamHandler": ["0e41cfb8-0506-40f4-a516-77cc23642d91"],
    "MFFLACSinkClassFactory": ["7d39c56f-6075-47c9-9bae-8cf9e531b5f5"],
    "MFFMPEG4SinkClassFactory": ["60f9f51e-4613-4b35-ae88-332542b567b8"],
    "MFHdcpReceiverControl": ["10794fd1-36a6-4527-8e61-691856d5aa34"],
    "MFImageSharingEngineClassFactory": ["b22c3339-87f3-4059-a0c5-037aa9707eaf"],
    "MFM2TSPropertyHandler": ["1e589e9d-8a8d-46d9-a2f9-e6d4f8161ee9"],
    "MFMP3PropertyHandler": ["c120de80-fde4-49f5-a713-e902ef062b8a"],
    "MFMP3SinkClassFactory": ["e54cdfaf-2381-4cad-ab99-f38517127d5c"],
    "MFMP4PropertyHandler": ["f81b1b56-7613-4ee4-bc05-1fab5de5c07e"],
    "MFMPEG2Demultiplexer": ["f792beee-aeaf-4ebb-ab14-8bc5c8c695a8"],
    "MFMPEG4SinkClassFactory": ["a22c4fc7-6e91-4e1d-89e9-53b2667b72ba"],
    "MFMediaEngineClassFactory": ["b44392da-499b-446b-a4cb-005fead0e6d5"],
    "MFMediaExtensionActivate": ["678da95c-1170-4dc9-a11f-35010586f2e5"],
    "MFMediaSharingEngineClassFactory": ["f8e307fb-6d45-4ad3-9993-66cd5a529659"],
    "MFMediaSourceActivate": ["e79167d7-1b85-4d78-b603-798e0e1a4c67"],
    "MFMediaSourcePackPropertyHandler": ["487ba7b8-4db0-465f-b122-c74a445a095d"],
    "MFMiracastConnectionRegistrar": ["e1790c6b-8727-4598-bad3-6ba88a49c25d"],
    "MFPMP": ["cce1cb19-f9b3-4017-9541-dda1b03f9a43"],
    "MFReadWriteClassFactory": ["48e2ed0f-98c2-4a37-bed5-166312ddd83f"],
    "MFSeamlessAudioEffect": ["c2b94e6d-6ebd-44ee-aac1-eb809c984699"],
    "MFSinkWriter": ["a3bbfb17-8273-4e52-9e0e-9739dc887990"],
    "MFSourceFilter": ["0344ec28-5339-4124-a186-2e8eef168785"],
    "MFSourceReader": ["1777133c-0881-411b-a577-ad545f0714c4"],
    "MFSourceResolver": ["90eab60f-e43a-4188-bcc4-e47fdf04868c"],
    "MFTMuxSinkClassFactory": ["fd215a13-a26a-44ff-ba3a-9109f278e28f"],
    "MFVideoMixer9": ["e474e05a-ab65-4f6a-827c-218b1baaf31f"],
    "MFVideoMixerPassThru": ["5c3dd72f-1ab4-4690-b9d2-6783250aa072"],
    "MFVideoPresenter9": ["98455561-5136-4d28-ab08-4cee40ea2781"],
    "MFVideoPresenterBitBlt": ["d115228d-5e00-4e5f-8886-05d834e3f004"],
    "MFWAVESinkClassFactory": ["36f99745-23c9-4c9c-8dd5-cc31ce964390"],
    "MFWAVPropertyHandler": ["e46787a1-4629-4423-a693-be1f003b2742"],
    "MILBitmapEffectBevel": ["fd361dbe-6c9b-4de0-8290-f6400c2737ed"],
    "MILBitmapEffectBlur": ["a924df87-225d-4373-8f5b-b90ec85ae3de"],
    "MILBitmapEffectDropShadow": ["459a3fbe-d8ac-4692-874b-7a265715aa16"],
    "MILBitmapEffectEmboss": ["cd299846-824f-47ec-a007-12aa767f2816"],
    "MILBitmapEffectGroup": ["ac9c1a9a-7e18-4f64-ac7e-47cf7f051e95"],
    "MJPGEnc": ["b80ab0a0-7416-11d2-9eeb-006008039e37"],
    "MKVByteStreamPlugin": ["1f9a2c18-d89e-463e-b4f4-bb90152acc64"],
    "MLPSPDIFMFT": ["cf5eeedf-0e92-4b3b-a161-bd0ffe545e4b"],
    "MMSPLITTER": ["3ae86b20-7be8-11d1-abe6-00a0c905f375"],
    "MP3ACMCodecWrapper": ["11103421-354c-4cca-a7a3-1aff9a5b6701"],
    "MP3ByteStreamPlugin": ["a82e50ba-8e92-41eb-9df2-433f50ec2993"],
    "MP3DecMediaObject": ["bbeea841-0a63-4f52-a7ab-a9b3a84ed38a"],
    "MP3ParserClassFactory": ["5aa730d8-0f13-4ad6-b6c6-1ea85218c9a0"],
    "MPEG2ByteStreamPlugin": ["40871c59-ab40-471f-8dc3-1f259d862479"],
    "MPEG2DLNASink": ["fa5fe7c5-6a1d-4b11-b41f-f959d6c76500"],
    "MPEG2Demultiplexer": ["afb6c280-2c41-11d3-8a60-0000f81e0e4a"],
    "MPEG2Demultiplexer_NoClock": ["687d3367-3644-467a-adfe-6cd7a85c4a2c"],
    "MPEG2MuxActivate": ["aa1b0e54-7593-40a0-8135-ed0b6cbc0154"],
    "MPEG2MuxMFT": ["ab300f71-01ab-46d2-ab6c-64906cb03258"],
    "MPEG2TSParserClassFactory": ["26a1f020-ddd8-472d-8b7c-2f98b80024f3"],
    "MPEG4ByteStreamPlugin": ["271c3902-6095-4c45-a22f-20091816ee9e"],
    "MPEG4MediaSegmentIndexParser": ["620e38ae-d62c-486b-8339-3df3c04d88c3"],
    "MPEG4ParserClassFactory": ["59899957-02f6-44ac-a369-7704e65a1364"],
    "MPlayer": ["0003000e-0000-0000-c000-000000000046"],
    "MSAACDecMFT": ["32d186a7-218f-4c75-8876-dd77273a8999"],
    "MSAMRNBDecoder": ["265011ae-5481-4f77-a295-abb6ffe8d63e"],
    "MSAMRNBEncoder": ["2fae8afe-04a3-423a-a814-85db454712b0"],
    "MSAdminBase": ["a9e69610-b80d-11d0-b9b9-00a0c922e750"],
    "MSAdminBase_W": ["a9e69610-b80d-11d0-b9b9-00a0c922e750"],
    "MSCContextMenu": ["d6791a63-e7e2-4fee-bf52-5ded8e86e9b8"],
    "MSDAINITIALIZE": ["2206cdb0-19c1-11d1-89e0-00c04fd7a829"],
    "MSDAOSP": ["dfc8bdc0-e378-11d0-9b30-0080c7e9fe95"],
    "MSDDPlusDecMFT": ["177c0afe-900b-48d4-9e4c-57add250b3d4"],
    "MSDraw": ["00030007-0000-0000-c000-000000000046"],
    "MSDtcTransaction": ["39f8d76b-0928-11d1-97df-00c04fb9618a"],
    "MSDtcTransactionManager": ["5b18ab61-091d-11d1-97df-00c04fb9618a"],
    "MSGraph": ["00030006-0000-0000-c000-000000000046"],
    "MSH264DecoderMFT": ["62ce7e72-4c71-4d20-b15d-452831a87d9d"],
    "MSH264EncoderMFT": ["6ca50344-051a-4ded-9779-a43305165e35"],
    "MSH265DecoderMFT": ["420a51a3-d605-430c-b4fc-45274fa6c562"],
    "MSHTMLWebViewElement": ["30c38a01-98b5-11cf-bb82-00aa00bdce0b"],
    "MSIME_JPN": ["03b5835f-f03c-411b-9ce2-aa23e1171e36"],
    "MSIME_KOR": ["a028ae76-01b1-46c2-99c4-acd9858ae02f"],
    "MSLocalStreamProtocol": ["4e495909-3b5b-40a5-8292-516822000537"],
    "MSMPEGAudDecMFT": ["70707b39-b2ca-4015-abea-f8447d22d88b"],
    "MSMPEGDecoderMFT": ["2d709e52-123f-49b5-9cbc-9af5cde28fb9"],
    "MSOpusDecoder": ["63e17c10-2d43-4c42-8fe3-8d8b63e46a6a"],
    "MSPowerPoint": ["00030004-0000-0000-c000-000000000046"],
    "MSPowerPointSho": ["00030005-0000-0000-c000-000000000046"],
    "MSProject": ["00030027-0000-0000-c000-000000000046"],
    "MSStockColor": ["7ebdaae1-8120-11cf-899f-00aa00688b10"],
    "MSStockFont": ["7ebdaae0-8120-11cf-899f-00aa00688b10"],
    "MSStockPicture": ["7ebdaae2-8120-11cf-899f-00aa00688b10"],
    "MSVPxDecoder": ["e3aaf548-c9a4-4c6e-234d-5ada374b0000"],
    "MSWorksChart": ["00030028-0000-0000-c000-000000000046"],
    "MSWorksSpreadsheet": ["00030029-0000-0000-c000-000000000046"],
    "MS_ClipArt_Gallery": ["00030026-0000-0000-c000-000000000046"],
    "MS_PROJ_GRID_CTRL": ["be194b4a-6063-11d1-be5c-00c04fb90759"],
    "MS_SYSTEMINFORMATION": ["273380e8-1438-4b2c-95b0-713284fbc302"],
    "MTHostActivator": ["00000342-0000-0000-c000-000000000046"],
    "MTSPackage": ["51372af3-cae7-11cf-be81-00aa00a2fa25"],
    "MULawCodecWrapper": ["92b66080-5e2d-449e-90c4-c41f268e5514"],
    "MachineDebugManager_DEBUG": ["49769cec-3a55-4bb0-b697-88fede77e8ea"],
    "MachineDebugManager_RETAIL": ["0c0a3666-30c9-11d0-8f20-00805f2cd064"],
    "MacromediaSwFlash": ["d27cdb6e-ae6d-11cf-96b8-444553540000"],
    "MailRecipient": ["9e56be60-c50f-11cf-9a2c-00a0c90a90ce"],
    "MailtoProtocol": ["3050f3da-98b5-11cf-bb82-00aa00bdce0b"],
    "MandatorySingleSnapPointsBehavior": ["12e0a050-adcd-4e5f-9571-692776e5c14d"],
    "MandatorySnapPointsBehavior": ["c6d676c3-e65e-431f-82a8-ec2802f929d6"],
    "ManipulationConfigurationBehavior": ["2803f7dc-5a53-4bcd-a997-3a3043f6cfd7"],
    "MbaeManagerInternal": ["d245983c-67fc-4923-aa19-3f048c495e8b"],
    "MbnConnectionManager": ["bdfee05c-4418-11dd-90ed-001c257ccff1"],
    "MbnConnectionProfileManager": ["bdfee05a-4418-11dd-90ed-001c257ccff1"],
    "MbnDeviceServicesManager": ["2269daa3-2a9f-4165-a501-ce00a6f7a75b"],
    "MbnInterfaceManager": ["bdfee05b-4418-11dd-90ed-001c257ccff1"],
    "MediaEncoderCategory": ["7d22e920-5ca9-4787-8c2b-a6779bd11781"],
    "MediaMultiplexerCategory": ["236c9559-adce-4736-bf72-bab34e392196"],
    "MemPropSetStg": ["c2566514-dd44-4c6c-aaad-fbd2f18d8dee"],
    "MemoryMappedCacheMgr": ["1f486a52-3cb1-48fd-8f50-b8dc300d9f9d"],
    "MenuBarExecute": ["25ab468c-3974-4075-be50-193135461727"],
    "MenuDeskBar": ["205d7a97-f16d-4691-86ef-f3075dcca57d"],
    "MergedFolder": ["26fdc864-be88-46e7-9235-032d8ea5162e"],
    "MetadataPSFactory": ["00000355-0000-0000-c000-000000000046"],
    "MetadataPolicyComponent": ["6f13dd2e-ebee-4dd5-a72e-850b2087f5dd"],
    "MicroThemeSettingHandler": ["4c3624d8-57af-11e1-b779-e5cc4724019b"],
    "MidiRendererCategory": ["4efe2452-168a-11d1-bc76-00c04fb9453b"],
    "MigrationPlugin": ["80ac0a1f-aa9b-4d24-a810-5e7f7687d003"],
    "MimeHandler": ["98af66e4-aa41-4226-b80f-0b1a8f34eeb4"],
    "MinShareFlow": ["7946ede1-839d-49be-9c1d-27c44529e093"],
    "MinSvr": ["0003002a-0000-0000-c000-000000000046"],
    "MinSvrMI": ["0003002d-0000-0000-c000-000000000046"],
    "MiniportDriverDMusUART": ["d3f0ce1c-fffc-11d1-81b0-0060083316c1"],
    "MiniportDriverDMusUARTCapture": ["d3f0ce1d-fffc-11d1-81b0-0060083316c1"],
    "MiniportDriverFmSynth": ["b4c90ae0-5791-11d0-86f9-00a0c911b544"],
    "MiniportDriverFmSynthWithVol": ["e5a3c139-f0f2-11d1-81af-0060083316c1"],
    "MiniportDriverUart": ["b4c90ae1-5791-11d0-86f9-00a0c911b544"],
    "MiracastTestRemoteCommandSender": ["39214908-5362-44b4-97f4-1aa724d3e0da"],
    "MiscPlugin": ["86eb3fd8-e142-4f3d-b3d3-5d8f41097d58"],
    "MiscellaneousFilesProject": ["a2fe74e1-b743-11d0-ae1a-00a0c90fffc3"],
    "MjpegDec": ["301056d0-6dff-11d2-9eeb-006008039e37"],
    "MofCompiler": ["6daf9757-2e37-11d2-aec9-00c04fb68820"],
    "MotionBackgroundThumbnailHandler": ["dea934db-6a19-4bba-aa57-a1b87901a85e"],
    "MountPointRename": ["60173d16-a550-47f0-a14b-c6f9e4da0831"],
    "MouseSettingHandler": ["a1170f2c-c5a4-467f-8eb3-50571d7201ae"],
    "MouseSettingMonitor": ["0f6221db-8ee7-450d-a28a-2898956004f2"],
    "MoveToChooseFolder": ["a0202464-b4b4-4b85-9628-ccd46df16942"],
    "MoveToMenu": ["c2fbb631-2971-11d1-a18c-00c04fd75d13"],
    "Mpeg2TableFilter": ["752845f1-758f-4c83-a043-4270c593308e"],
    "Mpeg2VideoStreamAnalyzer": ["6cfad761-735d-4aa5-8afc-af91a7d61eba"],
    "MrtResourceManager": ["dbce7e40-7345-439d-b12c-114a11819a09"],
    "MruLongList": ["53bd6b4e-3780-4693-afc3-7161c2f3ee9c"],
    "MruPidlList": ["42aedc87-2188-41fd-b9a3-0c966feabec1"],
    "MsAppDataSchemePlugin": ["cfc81939-3886-4acf-9692-da58037ae716"],
    "MsWwaSchemePlugin": ["8db0224b-3d65-4f6f-8e12-beb4b78b8974"],
    "MsftDiscFormat2Data": ["2735412a-7f64-5b0f-8f00-5d77afbe261e"],
    "MsftDiscFormat2Erase": ["2735412b-7f64-5b0f-8f00-5d77afbe261e"],
    "MsftDiscFormat2RawCD": ["27354128-7f64-5b0f-8f00-5d77afbe261e"],
    "MsftDiscFormat2TrackAtOnce": ["27354129-7f64-5b0f-8f00-5d77afbe261e"],
    "MsftDiscMaster2": ["2735412e-7f64-5b0f-8f00-5d77afbe261e"],
    "MsftDiscRecorder2": ["2735412d-7f64-5b0f-8f00-5d77afbe261e"],
    "MsftFileSystemImage": ["2c941fc5-975b-59be-a960-9a2a262853a5"],
    "MsftIsoImageManager": ["ceee3b62-8f56-4056-869b-ef16917e3efc"],
    "MsftMultisessionRandomWrite": ["b507ca24-2204-11dd-966a-001aa01bbc58"],
    "MsftMultisessionSequential": ["27354122-7f64-5b0f-8f00-5d77afbe261e"],
    "MsftRawCDImageCreator": ["25983561-9d65-49ce-b335-40630d901227"],
    "MsftStreamConcatenate": ["27354125-7f64-5b0f-8f00-5d77afbe261e"],
    "MsftStreamInterleave": ["27354124-7f64-5b0f-8f00-5d77afbe261e"],
    "MsftStreamPrng001": ["27354126-7f64-5b0f-8f00-5d77afbe261e"],
    "MsftStreamZero": ["27354127-7f64-5b0f-8f00-5d77afbe261e"],
    "MsftWriteEngine2": ["2735412c-7f64-5b0f-8f00-5d77afbe261e"],
    "MsftWriteSpeedDescriptor": ["27354123-7f64-5b0f-8f00-5d77afbe261e"],
    "MsmMerge": ["0adda830-2c26-11d2-ad65-00a0c9af11a6"],
    "MsmMerge2": ["f94985d5-29f9-4743-9805-99bc3f35b678"],
    "MsoEnvelope": ["0006f01a-0000-0000-c000-000000000046"],
    "Mso_From2000": ["b722bccd-4e68-101b-a2bc-00aa00404770"],
    "MtfPropertyBag": ["26445657-50e1-4c9f-8378-ff028fd26816"],
    "MtfSuggestionClient": ["b2445657-090d-11e4-aeda-b4b52fe06611"],
    "MultiObjectElevationFactory": ["36f0bd14-d84d-468c-b79c-9990f3fa897f"],
    "MultiplexPropertyStore": ["8d14113b-5715-4714-8a20-69fc343626de"],
    "MultiplexingSettingHandler": ["719ff33d-43af-4d4a-a89a-1599e6d88a37"],
    "MyComputerBoth": ["5e5f29ce-e0a8-49d3-af32-7a7bdc173478"],
    "NCSALOG": ["ff16065f-de82-11cf-bc0a-00aa006111e0"],
    "NCSALOGUI": ["31dcab85-bb3e-11d0-9299-00c04fb6678b"],
    "NDFEtw": ["a11db3dc-5ff6-4a0b-aee6-29bcac1e11e0"],
    "NLCommandCreator": ["9e175b8a-f52a-11d8-b9a5-505054503030"],
    "NPCredentialProvider": ["3dd6bec0-8193-4ffe-ae25-e08e39ea4063"],
    "NPSMRegistrar": ["a139e32e-ea10-4b93-a813-a9e44ada2938"],
    "NSCByteStreamPlugin": ["b084785c-dde0-4d30-8ca8-05a373e185be"],
    "NTHostActivator": ["00000343-0000-0000-c000-000000000046"],
    "NamedPropertyStoreXml": ["f582a54c-90d3-45b3-9860-ee3143aa85a0"],
    "NamespaceTreeControl": ["ae054212-3535-4430-83ed-d501aa6680e6"],
    "NavBar": ["056440fd-8568-48e7-a632-72157243b55b"],
    "NavPaneExpandToCurrentFolderCommand": ["2de55398-137e-4c4c-bf72-5cc7f18d9109"],
    "NavPaneShowAllFoldersCommand": ["ddcc6bb8-4cd6-462a-9289-d82d2bee1ffd"],
    "NetFwAuthorizedApplication": ["ec9846b3-2762-4a6b-a214-6acb603462d2"],
    "NetFwMgr": ["304ce942-6e39-40d8-943a-b913c40c9cd4"],
    "NetFwOpenPort": ["0ca545c6-37ad-4a6c-bf92-9f7610067ef5"],
    "NetFwPolicy2": ["e2b3c97f-6ae1-41ac-817a-f6f92166d7dd"],
    "NetFwProduct": ["9d745ed8-c514-4d1d-bf42-751fed2d5ac7"],
    "NetFwProducts": ["cc19079b-8272-4d73-bb70-cdb533527b61"],
    "NetFwRule": ["2c5bc43e-3369-4c33-ab0c-be9469677af4"],
    "NetFwV6Mgr": ["03707315-53e9-4b84-82b2-f09025cad207"],
    "NetGroupPolicies": ["ba126ad8-2166-11d1-b1d0-00805fc1270e"],
    "NetLibraryInfo": ["c82bf596-b831-11d0-b733-00aa00a1ebd2"],
    "NetSchemePlugin": ["e9f4ebab-d97b-463e-a2b1-c54ee3f9414d"],
    "NetworkCategory": ["6173d628-67f9-49b5-b9c1-d7abd9e70d34"],
    "NetworkCategoryHint": ["c53b4598-5c0e-4dfa-bf07-304ad4e04e87"],
    "NetworkConnections": ["7007acc7-3202-11d1-aad2-00805fc1270e"],
    "NetworkExplorerFolder": ["f02c1a0d-be21-4350-88b0-7367fc96ef3c"],
    "NetworkItemFactory": ["41937347-2aba-4d4c-a4ca-6fe4f11f1bac"],
    "NetworkListManager": ["dcb00c01-570f-4a9b-8d69-199fdba5723b"],
    "NetworkProvider": ["b2f3a67c-29da-4c78-8831-091ed509a475"],
    "NetworkRoot": ["953d732d-ab45-11d2-84e0-00c04fa31a86"],
    "NetworkStateChangeTaskHandler": ["a4173a49-f373-4475-9a0f-2d615204dc20"],
    "NetworkStatus": ["35a069a1-a029-46af-b531-454c0f66d61f"],
    "NetworkTraySSO": ["c2796011-81ba-4148-8fca-c6643245113f"],
    "Neutral_WBreaker": ["9e175b98-f52a-11d8-b9a5-505054503030"],
    "NewLibraryHandler": ["c7ca6167-2f46-4c4c-98b2-c92591368971"],
    "NgcPinProvider": ["d6886603-9d2f-4eb2-b667-1971041fa96b"],
    "NodeIterator": ["30510745-98b5-11cf-bb82-00aa00bdce0b"],
    "Note_It": ["00030008-0000-0000-c000-000000000046"],
    "NotificationDataProvider": ["8b47ed52-e8ef-4c45-a864-d1cc8465fede"],
    "NotificationManager": ["1add3454-9cd8-449b-8777-341dac8a3b0a"],
    "NotificationSubscriptionRegistrar": ["a5f60006-199b-11e3-ab72-86006288709b"],
    "NotifyCloudChange": ["98a238a9-d8a2-4e57-84af-6cf88ff719da"],
    "NotifyLocalSettingChange": ["42281387-edea-477c-89db-6f7033d518ab"],
    "NowPlayingSessionManager": ["bcbb9860-c012-4ad7-a938-6e337ae6aba5"],
    "NullPersistentHandler": ["098f2470-bae0-11cd-b579-08002b30bfeb"],
    "ODBCLOG": ["ff16065b-de82-11cf-bc0a-00aa006111e0"],
    "ODBCLOGUI": ["31dcab86-bb3e-11d0-9299-00c04fb6678b"],
    "OEMPTPROVIDER": ["91723892-45d2-48e2-9ec9-562379daf992"],
    "OEMRENDER": ["6d6abf26-9f38-11d1-882a-00c04fb961ec"],
    "OEMRegistrationPlugin": ["08dfcef6-4f00-436f-b621-b1585343c2fb"],
    "OEMUI": ["abce80d7-9f46-11d1-882a-00c04fb961ec"],
    "OEMUIMXDC": ["4e144300-5b43-4288-932a-5e4dd6d82bed"],
    "OLEDragDropHelper": ["0000034f-0000-0000-c000-000000000046"],
    "OOBEDUIWizard": ["dcc42fb9-f88d-43c2-b874-727df0f75586"],
    "OSTaskCompletion": ["07fc2b94-5285-417e-8ac3-c2ce5240b0fa"],
    "ObjMakerOLE": ["0003001d-0000-0000-c000-000000000046"],
    "ObjectContext": ["00000335-0000-0000-c000-000000000046"],
    "ObjrefMoniker": ["00000327-0000-0000-c000-000000000046"],
    "OfficeDocumentPropertyHandler": ["97e467b4-98c6-4f19-9588-161b7773d6f6"],
    "OfflineFilesBackgroundSyncHandler": ["fa3f3dd9-4c1a-456b-a8fa-c76ef3ed83b8"],
    "OfflineFilesCache": ["48c6be7c-3871-43cc-b46f-1449a1bb2ff3"],
    "OfflineFilesContextMenuExt": ["474c98ee-cf3d-41f5-80e3-4aab0ab04301"],
    "OfflineFilesControlPanel": ["a0add4ec-5bd3-4f70-a47b-07797a45c635"],
    "OfflineFilesFolder": ["afdb1f70-2a4c-11d2-9039-00c04f8eeb3e"],
    "OfflineFilesIconOverlayExt": ["4e77131d-3629-431c-9818-c5679dc83e81"],
    "OfflineFilesLaunchSyncCenter": ["815509b5-2940-4287-83dd-13ea06e181dd"],
    "OfflineFilesMakeAvailableOffline": ["0e32d9f9-10fb-4b90-8b24-826b07b084d0"],
    "OfflineFilesManageOfflineFiles": ["59ef44d1-4917-4f05-b10f-48c891e95dcc"],
    "OfflineFilesPropSheetExt": ["7efa68c6-086b-43e1-a2d2-55a113531240"],
    "OfflineFilesService": ["69486dd6-c19f-42e8-b508-a53f9f8e67b8"],
    "OfflineFilesSetting": ["fd3659e9-a920-4123-ad64-7fc76c7aacdf"],
    "OfflineFilesShellSvcObject": ["c51f0a6b-2a63-4cf4-8938-24404eaef422"],
    "OfflineFilesSyncCommand": ["69375d35-b310-40fd-a7dc-9548e1dbc3b5"],
    "OfflineFilesSyncConflictStore": ["68e1df8c-9512-4801-a105-25a44dccb164"],
    "OfflineFilesSyncStatusProvider": ["da3bc7d8-c8f3-4169-aa71-d65c40aa7129"],
    "OfflineFilesSyncStatusProviderInternal": ["d7b197f9-d109-4e8e-97b0-fc3886431a66"],
    "OfflineFilesWmiProvider": ["2dcd1daf-a110-49c0-bfdb-6fdf557b5fdf"],
    "OfflineFilesWorkOfflineOnlineCommand": ["35a5e985-12e6-46ee-b385-e887f3940fb0"],
    "OfflinePagesCacheCleaner": ["8e6e6079-0cb7-11d2-8f10-0000f87abd16"],
    "OldFont": ["46763ee0-cab2-11ce-8c20-00aa0051e5d4"],
    "OleDemo": ["00030012-0000-0000-c000-000000000046"],
    "OlePropertyHandler": ["8d80504a-0826-40c5-97e1-ebc68f953792"],
    "OleUndoManager": ["c964830f-91a0-11d0-b14c-0000f8041356"],
    "OneDriveCloudManagement": ["099eb73c-ff12-45c5-bf64-f0277733a6e2"],
    "OneDriveCloudStorageInfo": ["ddb93701-527b-4250-b619-672efd3c5b21"],
    "OneDriveCloudSyncPolicyManager": ["34212d32-6e9e-11e2-bda0-6b2b6288709b"],
    "OneDriveSettingSyncProvider": ["3fc77a3b-14c6-41b6-acc5-ed80223d81c4"],
    "OnexCredentialProvider": ["07aa0886-cc8d-4e19-a410-1c75af686e62"],
    "OnexPlapSmartcardCredentialProvider": ["33c86cd6-705f-4ba1-9adb-67070b837775"],
    "OnlineIdFilter": ["d4f01ada-979c-491e-bac3-cd3c0e7bcf82"],
    "OpcFactory": ["6b2d6ba0-9f3e-4f27-920b-313cc426a39e"],
    "OpenCmdPromptAsAdminCommand": ["858daca2-78b4-412f-9a4e-315bbb4e1f21"],
    "OpenContainingFolderMenu": ["37ea3a21-7493-4208-a011-7f9ea79ce9f5"],
    "OpenControlPanel": ["06622d85-6856-4460-8de1-a81921b41c4b"],
    "OpenPowershellAsAdmin": ["bf0ac53f-d51c-419f-92e3-2298e125f004"],
    "OpenSearchContextMenu": ["f9a7ab61-c0bc-490e-a7fe-bff26b327a3f"],
    "OpenSearchExtractIcon": ["96b9dae3-cf15-45e9-9719-57285348225e"],
    "OpenSearchLocationCreator": ["c19fbd0e-7663-44ea-8265-74130671a1d6"],
    "OpenSearchProvider": ["48e277f6-4e74-4cd6-ba6f-fa4f42898223"],
    "OpenSearchViewSiteExecute": ["905b55a8-77f0-4d28-80dd-e46b1412343f"],
    "OpenSearchViewSiteState": ["a76de978-f3eb-4a4f-9f99-304ad619e2ab"],
    "OpenServiceActivityManager": ["c5efd803-50f8-43cd-9ab8-aafc1394c9e0"],
    "OpenServiceManager": ["098870b6-39ea-480b-b8b5-dd0167c4db59"],
    "OpenWithExplorerCommand": ["4ce6767d-e09b-45dc-831d-20c8b4ea9a26"],
    "OpenWithMenu": ["09799afb-ad67-11d1-abcd-00c04fc30936"],
    "OperationStatusService": ["515980c3-57fe-4c1e-a561-730dd256ab98"],
    "OplockProvider": ["e2eb4ca4-c96e-4da4-94b1-673c8334a5bb"],
    "OptionalSingleSnapPointsBehavior": ["ff3b0933-2961-477b-8ed2-a0889a194511"],
    "OptionalSnapPointsBehavior": ["da8f26e1-9ac7-4894-8bef-45cf87456e91"],
    "OrderListExport": ["f3368374-cf19-11d0-b93d-00a0c90312e1"],
    "OtherUsersFolder": ["b4fb3f98-c1ea-428d-a78a-d1f5659cba93"],
    "P2PPublicationServices": ["79dba461-677b-448a-8a5e-3006dabaf6f9"],
    "PBDA_AUX_DATA_TYPE": ["fd456373-3323-4090-adca-8ed45f55cf10"],
    "PBDA_Encoder_DATA_TYPE": ["728fd6bc-5546-4716-b103-f899f5a1fa68"],
    "PBDA_FDC_DATA_TYPE": ["e7dbf9a0-22ab-4047-8e67-ef9ad504e729"],
    "PBDA_GDDS_DATA_TYPE": ["c80c0df3-6052-4c16-9f56-c44c21f73c45"],
    "PBrush": ["0003000a-0000-0000-c000-000000000046"],
    "PCSettings": ["5ed4f38c-d3ff-4d61-b506-6820320aebfe"],
    "PDPO": ["ccb4ec60-b9dc-11d1-ac80-00a0c9034873"],
    "PIDPlugin": ["d1e7ee36-6aa6-4dc2-90bb-16a722623b7d"],
    "PINLogonCredentialProvider": ["cb82ea12-9f71-446d-89e1-8d0924e1256e"],
    "PINLogonEnrollmentHandler": ["4f7d48de-1045-48b0-adba-f0b6d93a18f4"],
    "PMNotifications": ["d0df0c7d-33bf-4e04-9b11-b1d7ae572eed"],
    "PPIActivityLauncher": ["0946d37f-ce20-485f-9314-4129b803aa35"],
    "PPILayoutOperation": ["ad255058-e625-4eb1-80bd-0a8e8993a71a"],
    "PRINTSHOP_PHOTO_BTN": ["adb880a6-d8ff-11cf-9377-00aa003b7a11"],
    "PSAutomation": ["00020424-0000-0000-c000-000000000046"],
    "PSDispatch": ["00020420-0000-0000-c000-000000000046"],
    "PSEnumVARIANT": ["00020421-0000-0000-c000-000000000046"],
    "PSFactoryBuffer": ["09290c14-40bf-40f1-a245-85fc671b5fa3"],
    "PSOlePrx32": ["00000320-0000-0000-c000-000000000046"],
    "PSTypeComp": ["00020425-0000-0000-c000-000000000046"],
    "PSTypeInfo": ["00020422-0000-0000-c000-000000000046"],
    "PSTypeLib": ["00020423-0000-0000-c000-000000000046"],
    "PTFilter": ["9cd31617-b303-4f96-8330-2eb173ea4dc6"],
    "PTPROVIDER": ["46ac151b-8490-4531-96cc-55bf2bf19e11"],
    "PackageDebugSettings": ["b1aec16f-2383-4852-b0e9-8f0b1dc66b4d"],
    "PackageInformation": ["5d084dcb-c187-4bdc-95d1-929cc8418bf8"],
    "PackageInstallStateStore": ["8a4d840d-ab27-4c8f-ab9c-765ca85c73b7"],
    "PackageInstallStateStoreEnum": ["2025bcb1-370e-4103-9c34-883770f7f2a0"],
    "PackagerMoniker": ["00000308-0000-0000-c000-000000000046"],
    "ParametricMotionBehavior": ["8a7bd110-3f9d-472d-ba35-ddd2e0ce94a6"],
    "ParametricRestPointBehavior": ["9a05980f-3076-447e-9a16-e334467b5da2"],
    "ParseTracer": ["8a3e2e1e-a40b-4650-9fb4-30072a68e661"],
    "PartitionActivator": ["33de48c4-943f-4b96-8cd8-b117c94576cf"],
    "PasswordCredentialProvider": ["60b78e88-ead8-445c-9cfd-0b87f74ea6cd"],
    "PastSearchesDataProvider": ["689f01c4-32ec-4bb4-a228-2e629bcc2d75"],
    "PathPropertyControl": ["0c0b25f5-e762-4004-96cd-00ffc1ecb5bf"],
    "PeerGroupInvitationXml": ["0c313c67-199b-4e68-884d-d36914e26edd"],
    "PeerGroupWrapper": ["9f36c194-166c-4cbf-b7ea-bf039f950172"],
    "PeerInfoXml": ["d8636558-aaf6-49c1-8171-ffa6668b65a7"],
    "PenWorkspaceDiscoverBroker": ["ad20f6d7-28b9-4a05-86b3-d6a3e149b28d"],
    "PenWorkspaceLayoutPolicyManager": ["9280e842-f931-4d24-b074-739fb4da43f4"],
    "PenWorkspaceScreenCaptureBroker": ["dee0ce93-8376-4db5-a4f0-010596888b49"],
    "PeopleBand": ["668863e6-d688-4115-8f23-bb7f37621a74"],
    "PeoplePaneViewManager": ["3a57cb65-1857-4239-b130-fa0f8f06522a"],
    "PerAppRuntimeBroker": ["2593f8b9-4eaf-457c-b68a-50f6b8ea6b54"],
    "PerMonitorDesktopVisibilityService": ["72422aa4-3536-41fa-965e-d5d9dd130297"],
    "PerceivedTypeCategorizer": ["929783c3-8c9f-495a-821f-2d4856f1e461"],
    "PercentCategorizer": ["5d4d54b3-9fb4-4662-8173-c48568d5e79e"],
    "PersistPeerXml": ["affa1da9-c637-4e6b-a0f3-276889d09f14"],
    "PhotoPaint": ["00030018-0000-0000-c000-000000000046"],
    "PickerControllerInProcServer": ["d41748f8-737c-4edb-bb21-18d8b37c511e"],
    "PickerControllerLocalServer": ["c58ca859-80bc-48df-8f06-ffa94a405bff"],
    "PickerFlyoutFactory": ["51ad6d44-32f8-4aa7-9ee6-24a37fa09354"],
    "PicturePasswordEnrollmentHandler": ["9fb45d27-dfe3-4383-b117-ab631787649a"],
    "PicturePasswordImageSettingHandler": ["879795a1-a911-4fef-984f-1a1ca4e14637"],
    "PinPropertyControl": ["5b389765-edc1-4adf-9812-1c8a83175892"],
    "PinToFrequentExecute": ["b455f46e-e4af-4035-b0a4-cf18d2f6f28e"],
    "PinToHomeCommand": ["70438d09-456a-4a6f-86fe-1c1a3afc699e"],
    "PinToStartService": ["499e58ea-40c6-4601-9730-a046d0451f98"],
    "PinnedPeopleList": ["78317482-5b49-4093-9c34-2758fc63bef0"],
    "PipePSFactory": ["0000032e-0000-0000-c000-000000000046"],
    "PlainTextPersistentHandler": ["5e941d80-bf96-11cd-b579-08002b30bfeb"],
    "PlatformFactory": ["2491432f-3a10-4884-b628-574d57f41e9b"],
    "PlayAll": ["1f872270-d68c-4c28-85d9-70cd5fc47a70"],
    "PlayCommandExecute": ["80c68d96-366b-11dc-9eaa-00161718cf63"],
    "PlayCommandState": ["880ac964-2e34-4425-8cf2-86ada2c3a019"],
    "PlayMusicCommand": ["220898a1-e3f3-46b4-96ea-b0855dc968b6"],
    "PlayToSourceClassFactory": ["da17539a-3dc3-42c1-a749-a183b51f085e"],
    "PlmSuspendControl": ["02844640-e37c-4322-a3b8-4c61a2e58879"],
    "PointerMoniker": ["00000306-0000-0000-c000-000000000046"],
    "PolicyConfig": ["870af99c-171d-4f9e-af0d-e63df40c2bc9"],
    "PolicyConfigVista": ["294935ce-f637-4e7c-a41b-ab255460b862"],
    "PopularSitesDataProvider": ["b1a12acd-7cdf-4664-ab6a-4a476b36bec0"],
    "PopupWindowFactory": ["0dec7d0c-bd63-4759-aa64-adefd70dcf9a"],
    "PortDMus": ["b7902fe9-fb0a-11d1-81b0-0060083316c1"],
    "PortMidi": ["b4c90a43-5791-11d0-86f9-00a0c911b544"],
    "PortTopology": ["b4c90a32-5791-11d0-86f9-00a0c911b544"],
    "PortWaveCyclic": ["b4c90a2a-5791-11d0-86f9-00a0c911b544"],
    "PortWavePci": ["b4c90a54-5791-11d0-86f9-00a0c911b544"],
    "PortWaveRT": ["cc9be57a-eb9e-42b4-94fc-0cad3dbce7fa"],
    "PortableDeviceSyncProvider": ["a38f4597-f640-4189-982f-132ecf8202fa"],
    "PostAppsFirstLogonSync": ["38bfa80b-f989-45b2-aafd-1e0c04e50e56"],
    "PostBootReminder": ["7849596a-48ea-486e-8937-a2a3009f31a9"],
    "PreferredHomeGroupChangedXml": ["9f4f643b-8806-4861-8a79-6699e94dcf66"],
    "PrepareDiscCancelAutoPlay": ["0d40a373-66ad-4bb9-add7-41719fe67c51"],
    "PreviewMime": ["92dbad9f-5025-49b0-9078-2d78f935e341"],
    "PreviewWindowCreator": ["914feed8-267a-4baa-b8aa-21e233792679"],
    "PreviousVersions": ["596ab062-b4d2-4215-9f74-e9109b0a8153"],
    "PrintUIShellExtension": ["77597368-7b15-11d0-a0c2-080036af3f03"],
    "PrinterListener": ["5255efed-103a-4444-b124-f88f99e4ef8d"],
    "PrinterQueueView": ["b021ff57-a928-459c-9d6c-14ded0c9bed2"],
    "PrinterQueueViewJobExtension": ["c20ce506-5da9-4b9c-9662-d88bd30e10a1"],
    "PrinterStatusHTMLViewExtension": ["db49bbeb-c744-49f8-81ac-af97669d4cb0"],
    "PrivateActivator2": ["2e167ea7-85e3-4395-995a-77af9875d79a"],
    "PrivateProfile": ["75847177-f077-4171-bd2c-a6bb2164fbd0"],
    "ProcessLifetimeManager": ["374ee8e8-dea6-4db7-b14a-b43ee3e8948e"],
    "ProfileAccounts": ["99cdc6e0-da00-4dfa-8eb8-831d774f8891"],
    "ProfileNotificationHandler": ["56ea1054-1959-467f-be3b-a2a787c4b6ea"],
    "ProfileNotifyHandler": ["9b359d1b-ad5c-412f-a654-a431424359de"],
    "ProgressItem": ["2c941fcb-975b-59be-a960-9a2a262853a5"],
    "ProgressItems": ["2c941fc9-975b-59be-a960-9a2a262853a5"],
    "ProjectionManager": ["3a66787a-8b15-4321-a09d-6e862d2dd2d4"],
    "ProjectionUI": ["a19141ce-d197-4c8b-82c9-4995f5303497"],
    "PropSysApartmentClassFactory": ["9cfc2df3-6ba3-46ef-a836-e519e81f0ec4"],
    "PropSysBothClassFactory": ["76765b11-3f95-4af2-ac9d-ea55d8994f1a"],
    "PropertyAdapter": ["f803f314-6f09-4c50-b880-e78b858ffc08"],
    "PropertyChangeArray": ["8b6a3ebb-cd13-4704-93c5-bc3413104e4c"],
    "PropertyDescriptionList": ["b8e85518-21ba-4975-a236-e8c512685149"],
    "PropertyKeyStore": ["7ec8c678-db97-4c70-8c09-065ba4ab60e7"],
    "PropertyProvider": ["4a5e5be9-ebf5-4466-bf17-9bf18dc276af"],
    "PropertySetter": ["adf95821-ded7-11d2-acbe-0080c75e246e"],
    "PropertyStore": ["e4796550-df61-448b-9193-13fc1341b163"],
    "PropertyStoreCollection": ["edd36029-d753-4862-aa5b-5bccad2a4d29"],
    "PropertyStoreOverFolderFinal": ["0340f119-a598-4ed9-b0ac-6f6a12d3e755"],
    "PropertyStoreOverPropertySetStorage": ["8727881e-93f9-4671-8c54-1f02b4fab84e"],
    "PropertyStoreXml": ["2f0888f4-2c5b-4353-a395-40cf3b6ba29e"],
    "PropertySystem": ["b8967f85-58ae-4f46-9fb2-5d7904798f4b"],
    "PropertyThumbnailHandler": ["9dbd2c50-62ad-11d0-b806-00c04fd706ec"],
    "ProtectPCPlugin": ["f052299c-6da4-40f0-be0d-8bd02fad080a"],
    "ProviderConfig": ["3722c3b1-82e8-4022-8b27-1f8a68b44ac7"],
    "ProvisioningEngine": ["217700e0-2001-11df-adb9-f4ce462d9137"],
    "ProxyConfigurationPlugin": ["56da6136-b95e-4249-bb50-e4773a2b3b5e"],
    "PseudoSink": ["e002e4f0-e6ea-11d2-9cb3-00105a1f4801"],
    "PsiParserFilter": ["743a6e3b-a5df-43ed-b615-4256add790b8"],
    "Ptype_PSFactory": ["11659a23-5884-4d1b-9cf6-67d6f4f90b36"],
    "PublicationServices": ["c707f6a6-a1f3-45d7-99aa-a2b9491e84ad"],
    "PublicationServicesChangeData": ["0d0e47ed-7220-411f-8f81-1118095da5e7"],
    "PublicationServicesCollection": ["19352205-42b0-4690-9aa4-d7db9ae5f259"],
    "PublicationServicesData": ["3abeafc4-f48f-4517-a9b0-8ad6a94a99a1"],
    "PublicationServicesServer": ["b77c4c36-0154-4c52-ab49-faa03837e47f"],
    "PublishedItemsFolder": ["6785bfac-9d2d-4be5-b7e2-59937e8fb80a"],
    "PublishedItemsSSO": ["003e0278-eca8-4bb8-a256-3689ca1c2600"],
    "QTDec": ["fdfe9681-74a3-11d0-afa7-00aa00b67a42"],
    "QueryResult": ["807e5a10-4856-4f9a-8e3c-a1f7e75648b3"],
    "QuickTimeParser": ["d51bd5a0-7548-11cf-a520-0080c77ef58a"],
    "QuietHoursManager": ["ca80be9f-02db-4b14-9b52-a72d27b5fbf5"],
    "RASProvider": ["5537e283-b1e7-4ef8-9c6e-7ab0afe5056d"],
    "RSOPSnapIn": ["6dc3804b-7212-458d-adb0-9a07e2ae1fa2"],
    "RSSDataModelProvider": ["c2636e9d-058c-4dd9-97a0-8fba5507af02"],
    "RSSFeedFolder": ["1861b137-f5b6-4660-90a3-ea263d0b3bd0"],
    "RTFPreviewHandler": ["a42c2ccb-67d3-46fa-abe6-7d2f3488c7a3"],
    "RadioManagementAPI": ["581333f6-28db-41be-bc7a-ff201f12f3f6"],
    "RangeException": ["3051072e-98b5-11cf-bb82-00aa00bdce0b"],
    "RatingsCategorizer": ["ff99d546-1535-48ad-8d1b-3e185da8ee79"],
    "RawInputProvider": ["43a1bb0e-2ce9-405c-8799-12e7d7550d3f"],
    "ReadingModeExtractedContent": ["f84431a3-a1be-40fc-bafa-84851b344af8"],
    "ReadingModeViewer": ["181d6c15-60a6-4bc7-a8e7-389d5bfe4841"],
    "RebarBandSite": ["ecd4fc4d-521c-11d0-b792-00a0c90312e1"],
    "RebuildSessionTaskTOID": ["8c3e48e3-7ce2-4ecf-8b77-f7a7e52eea35"],
    "RecentDocsContextMenu": ["a8e64375-b645-4314-9efc-c085981786fa"],
    "RecentDocumentsFolder": ["0c39a5cf-1a7a-40c8-ba74-8900e6df5fcd"],
    "RecentFilesFolder": ["3134ef9c-6b18-4996-ad04-ed5912e00eb5"],
    "RecentPlacesFolder": ["22877a6d-37a1-461a-91b0-dbda5aaebc99"],
    "RecordSharingXml": ["fc80316a-0752-400d-aa2e-86de4f6c26ef"],
    "RecordSourceXml": ["fb67f8d9-03a1-42b5-979a-1577f0193611"],
    "RecycleBinCleaner": ["5ef4af3a-f726-11d0-b8a2-00c04fc309a4"],
    "RecycleBinManager": ["4a04656d-52aa-49de-8a09-cb178760e748"],
    "RedoExplorerCommand": ["1cc6b704-d0f5-4dc3-a521-13620d89e8bc"],
    "RegDataDrivenCommand": ["02df6db6-9405-4812-b3f6-500e8615b7af"],
    "RegFolder": ["0997898b-0713-11d2-a4aa-00c04f8eeb3e"],
    "RegProvider": ["681fd532-7ec2-4548-9ece-44aabcfbd254"],
    "RegionPlugin": ["f2fc5c3b-fc71-452c-ab56-47bc0873e46d"],
    "RegisterSuspendNotify": ["00000356-0000-0000-c000-000000000046"],
    "RegistrySettingHandler": ["6d99ef93-c3ab-4539-8f2d-bb1bef21d415"],
    "RegistrySettingMonitor": ["2b4099b4-abed-4014-881e-ab96d7cc4e48"],
    "RemoteHelper": ["e423af7c-fc2d-11d2-b126-00805fc73204"],
    "RemoteProxyFactory32": ["53362c32-a296-4f2d-a2f8-fd984d08340b"],
    "RemoteProxyFactory64": ["53362c64-a296-4f2d-a2f8-fd984d08340b"],
    "RemovableDrivesFolder": ["f5fb2c77-0e2f-4a16-a381-3e560c68bc83"],
    "RemoveFromFrequentPlacesExecute": ["b918dbc4-162c-43e5-85bf-19059a776e9e"],
    "RemoveFromRecentDocumentsExecute": ["c5872cfd-52d1-4494-aa0d-22d42bbb2e30"],
    "RemoveMediaServerCommand": ["ca47b0ae-6f7b-4aeb-8d57-24b3f2aa3d44"],
    "RemovePropertiesDropTarget": ["09a28848-0e97-4cef-b950-cea037161155"],
    "RenameExecute": ["81007291-f070-4c4f-b978-ad1bec84babc"],
    "RenderEngine": ["64d8a8e0-80a2-11d2-8cf3-00a0c9441e20"],
    "ResourceManagerQueue": ["c60f637a-07f3-411d-b577-22e519f8b63b"],
    "Response": ["46e19ba0-25dd-11d0-a55f-00a0c90c2091"],
    "RestoreFavoriteLinksExecute": ["4522c772-9a2b-4920-ad7f-62d3d15eac52"],
    "RestoreLibrariesExecute": ["c51b83e5-9edd-4250-b45a-da672ee3c70e"],
    "RestrictedErrorObject": ["00000352-0000-0000-c000-000000000046"],
    "ResultHandlerFactory": ["b9b61a03-caa7-43bb-b859-acd26d73b3f7"],
    "ResultSetFactory": ["30276b4f-f25c-457c-a4b7-08574f8ea528"],
    "ResultSetManager": ["52ce2fe5-04c3-42fd-8a8b-4251affb8408"],
    "ResultShape": ["ff8a32e3-a9a7-4093-b9c4-5b5b4f30ab63"],
    "ResultsFolder": ["2965e715-eb66-4719-b53f-1672673bbefa"],
    "RetailDemoPlugin": ["94fbc195-cb86-4142-9a6a-8e9ccf0d4f4d"],
    "RibbonDeleteCommand": ["cc89ba65-661c-494a-85c0-5d697dfeb30c"],
    "RibbonPermissionsDialogCommand": ["e2765ac3-564c-40f9-ac12-cd393fbaab0f"],
    "RibbonShareWith": ["bbb9389d-cb46-4855-ada6-4570e7342b3c"],
    "RoamedTabsDataProvider": ["d97a6a3c-8266-4fa6-93ae-80b3bfa81b31"],
    "RoamingOptionsValues": ["4c60517f-c1f8-473a-b1d8-247952876a5a"],
    "Rolling420FrameStitcher": ["becab11e-6629-4237-a9a4-5684579392a2"],
    "RootBinder": ["ff151822-b0bf-11d1-a80d-000000000000"],
    "RotationManager": ["5bd3ea21-163b-4b17-951e-e73eebf0601a"],
    "RpcHelper": ["0000032a-0000-0000-c000-000000000046"],
    "RudeWindowManager": ["b9a160be-0eb0-46a4-9942-30eb90bd792d"],
    "RulesApplied": ["7c803920-7a53-4d26-98ac-fdd23e6b9e01"],
    "RulesAppliedCollection": ["671926ee-c3cf-40af-be8f-1cbaee6486e8"],
    "RunAsNewUser": ["ea72d00e-4960-42fa-ba92-7792a7944c1d"],
    "RunningShareManager": ["7db875bd-1b88-4c5f-9e4c-ed23eaff24e1"],
    "RuntimeBroker": ["d63b10c5-bb46-4990-a94f-e40b9d520160"],
    "SAMIByteStreamPlugin": ["7a56c4cb-d678-4188-85a8-ba2ef68fa10d"],
    "SBE2File": ["93a094d7-51e8-485b-904a-8d6b97dc6b39"],
    "SBE2FileScan": ["3e458037-0ca6-41aa-a594-2aa6c02d709b"],
    "SBE2MediaTypeProfile": ["1f26a602-2b5c-4b63-b8e8-9ea5c1a7dc2e"],
    "SBE2Sink": ["e2448508-95da-4205-9a27-7ec81e723b1a"],
    "SH_AddressBand": ["01e04581-4eee-11d0-bfe9-00aa005b4383"],
    "SH_SearchBand": ["21569614-b795-46b1-85f4-e737a8dc09ad"],
    "STDispenser": ["15b0bb4c-0f7d-11d1-b21f-00c04fb9473f"],
    "SVGAElement": ["305105db-98b5-11cf-bb82-00aa00bdce0b"],
    "SVGAngle": ["30510584-98b5-11cf-bb82-00aa00bdce0b"],
    "SVGAnimatedAngle": ["305105e4-98b5-11cf-bb82-00aa00bdce0b"],
    "SVGAnimatedBoolean": ["3051058b-98b5-11cf-bb82-00aa00bdce0b"],
    "SVGAnimatedEnumeration": ["3051058e-98b5-11cf-bb82-00aa00bdce0b"],
    "SVGAnimatedInteger": ["3051058f-98b5-11cf-bb82-00aa00bdce0b"],
    "SVGAnimatedLength": ["30510581-98b5-11cf-bb82-00aa00bdce0b"],
    "SVGAnimatedLengthList": ["30510582-98b5-11cf-bb82-00aa00bdce0b"],
    "SVGAnimatedNumber": ["30510588-98b5-11cf-bb82-00aa00bdce0b"],
    "SVGAnimatedNumberList": ["3051058a-98b5-11cf-bb82-00aa00bdce0b"],
    "SVGAnimatedPreserveAspectRatio": ["305105ce-98b5-11cf-bb82-00aa00bdce0b"],
    "SVGAnimatedRect": ["30510586-98b5-11cf-bb82-00aa00bdce0b"],
    "SVGAnimatedString": ["3051058c-98b5-11cf-bb82-00aa00bdce0b"],
    "SVGAnimatedTransformList": ["305105b1-98b5-11cf-bb82-00aa00bdce0b"],
    "SVGCircleElement": ["30510578-98b5-11cf-bb82-00aa00bdce0b"],
    "SVGClipPathElement": ["305105e6-98b5-11cf-bb82-00aa00bdce0b"],
    "SVGDefsElement": ["30510570-98b5-11cf-bb82-00aa00bdce0b"],
    "SVGDescElement": ["30510572-98b5-11cf-bb82-00aa00bdce0b"],
    "SVGDocument": ["30590066-98b5-11cf-bb82-00aa00bdce0b"],
    "SVGElement": ["30510564-98b5-11cf-bb82-00aa00bdce0b"],
    "SVGElementInstance": ["30510575-98b5-11cf-bb82-00aa00bdce0b"],
    "SVGElementInstanceList": ["30510576-98b5-11cf-bb82-00aa00bdce0b"],
    "SVGEllipseElement": ["30510579-98b5-11cf-bb82-00aa00bdce0b"],
    "SVGException": ["30510730-98b5-11cf-bb82-00aa00bdce0b"],
    "SVGGElement": ["3051056f-98b5-11cf-bb82-00aa00bdce0b"],
    "SVGGradientElement": ["305105d6-98b5-11cf-bb82-00aa00bdce0b"],
    "SVGImageElement": ["305105cf-98b5-11cf-bb82-00aa00bdce0b"],
    "SVGLength": ["3051057e-98b5-11cf-bb82-00aa00bdce0b"],
    "SVGLengthList": ["30510580-98b5-11cf-bb82-00aa00bdce0b"],
    "SVGLineElement": ["3051057a-98b5-11cf-bb82-00aa00bdce0b"],
    "SVGLinearGradientElement": ["305105d2-98b5-11cf-bb82-00aa00bdce0b"],
    "SVGMarkerElement": ["305105de-98b5-11cf-bb82-00aa00bdce0b"],
    "SVGMaskElement": ["305105e7-98b5-11cf-bb82-00aa00bdce0b"],
    "SVGMatrix": ["305105ae-98b5-11cf-bb82-00aa00bdce0b"],
    "SVGMetadataElement": ["305105d7-98b5-11cf-bb82-00aa00bdce0b"],
    "SVGNumber": ["30510587-98b5-11cf-bb82-00aa00bdce0b"],
    "SVGNumberList": ["30510589-98b5-11cf-bb82-00aa00bdce0b"],
    "SVGPathElement": ["305105b2-98b5-11cf-bb82-00aa00bdce0b"],
    "SVGPathSeg": ["305105b3-98b5-11cf-bb82-00aa00bdce0b"],
    "SVGPathSegArcAbs": ["305105bb-98b5-11cf-bb82-00aa00bdce0b"],
    "SVGPathSegArcRel": ["305105bc-98b5-11cf-bb82-00aa00bdce0b"],
    "SVGPathSegClosePath": ["305105bd-98b5-11cf-bb82-00aa00bdce0b"],
    "SVGPathSegCurvetoCubicAbs": ["305105be-98b5-11cf-bb82-00aa00bdce0b"],
    "SVGPathSegCurvetoCubicRel": ["305105bf-98b5-11cf-bb82-00aa00bdce0b"],
    "SVGPathSegCurvetoCubicSmoothAbs": ["305105c0-98b5-11cf-bb82-00aa00bdce0b"],
    "SVGPathSegCurvetoCubicSmoothRel": ["305105c1-98b5-11cf-bb82-00aa00bdce0b"],
    "SVGPathSegCurvetoQuadraticAbs": ["305105c2-98b5-11cf-bb82-00aa00bdce0b"],
    "SVGPathSegCurvetoQuadraticRel": ["305105c3-98b5-11cf-bb82-00aa00bdce0b"],
    "SVGPathSegCurvetoQuadraticSmoothAbs": ["305105c4-98b5-11cf-bb82-00aa00bdce0b"],
    "SVGPathSegCurvetoQuadraticSmoothRel": ["305105c5-98b5-11cf-bb82-00aa00bdce0b"],
    "SVGPathSegLinetoAbs": ["305105c6-98b5-11cf-bb82-00aa00bdce0b"],
    "SVGPathSegLinetoHorizontalAbs": ["305105c7-98b5-11cf-bb82-00aa00bdce0b"],
    "SVGPathSegLinetoHorizontalRel": ["305105c8-98b5-11cf-bb82-00aa00bdce0b"],
    "SVGPathSegLinetoRel": ["305105c9-98b5-11cf-bb82-00aa00bdce0b"],
    "SVGPathSegLinetoVerticalAbs": ["305105ca-98b5-11cf-bb82-00aa00bdce0b"],
    "SVGPathSegLinetoVerticalRel": ["305105cb-98b5-11cf-bb82-00aa00bdce0b"],
    "SVGPathSegList": ["305105b4-98b5-11cf-bb82-00aa00bdce0b"],
    "SVGPathSegMovetoAbs": ["305105cc-98b5-11cf-bb82-00aa00bdce0b"],
    "SVGPathSegMovetoRel": ["305105cd-98b5-11cf-bb82-00aa00bdce0b"],
    "SVGPatternElement": ["305105d4-98b5-11cf-bb82-00aa00bdce0b"],
    "SVGPoint": ["305105ba-98b5-11cf-bb82-00aa00bdce0b"],
    "SVGPointList": ["305105b9-98b5-11cf-bb82-00aa00bdce0b"],
    "SVGPolygonElement": ["3051057b-98b5-11cf-bb82-00aa00bdce0b"],
    "SVGPolylineElement": ["3051057c-98b5-11cf-bb82-00aa00bdce0b"],
    "SVGPreserveAspectRatio": ["305105d0-98b5-11cf-bb82-00aa00bdce0b"],
    "SVGRadialGradientElement": ["305105d3-98b5-11cf-bb82-00aa00bdce0b"],
    "SVGRect": ["30510583-98b5-11cf-bb82-00aa00bdce0b"],
    "SVGRectElement": ["30510577-98b5-11cf-bb82-00aa00bdce0b"],
    "SVGSVGElement": ["30510574-98b5-11cf-bb82-00aa00bdce0b"],
    "SVGScriptElement": ["305105e1-98b5-11cf-bb82-00aa00bdce0b"],
    "SVGStopElement": ["305105d5-98b5-11cf-bb82-00aa00bdce0b"],
    "SVGStringList": ["3051058d-98b5-11cf-bb82-00aa00bdce0b"],
    "SVGStyleElement": ["305105d1-98b5-11cf-bb82-00aa00bdce0b"],
    "SVGSwitchElement": ["305105d8-98b5-11cf-bb82-00aa00bdce0b"],
    "SVGSymbolElement": ["30510571-98b5-11cf-bb82-00aa00bdce0b"],
    "SVGTSpanElement": ["305105e2-98b5-11cf-bb82-00aa00bdce0b"],
    "SVGTextContentElement": ["305105dd-98b5-11cf-bb82-00aa00bdce0b"],
    "SVGTextElement": ["305105df-98b5-11cf-bb82-00aa00bdce0b"],
    "SVGTextPathElement": ["305105eb-98b5-11cf-bb82-00aa00bdce0b"],
    "SVGTextPositioningElement": ["305105e0-98b5-11cf-bb82-00aa00bdce0b"],
    "SVGTitleElement": ["30510573-98b5-11cf-bb82-00aa00bdce0b"],
    "SVGTransform": ["305105af-98b5-11cf-bb82-00aa00bdce0b"],
    "SVGTransformList": ["305105b0-98b5-11cf-bb82-00aa00bdce0b"],
    "SVGUseElement": ["30510590-98b5-11cf-bb82-00aa00bdce0b"],
    "SVGViewElement": ["305105dc-98b5-11cf-bb82-00aa00bdce0b"],
    "SVGZoomEvent": ["305105d9-98b5-11cf-bb82-00aa00bdce0b"],
    "SVRActivate": ["4d4dedaa-43c5-480d-9ee0-1464f9f4ff4b"],
    "SWbemDateTime": ["47dfbe54-cf76-11d3-b38f-00105a1f473a"],
    "SWbemEventSource": ["04b83d58-21ae-11d2-8b33-00600806d9b6"],
    "SWbemLastError": ["c2feeeac-cfcd-11d1-8b05-00600806d9b6"],
    "SWbemLocator": ["76a64158-cb41-11d1-8b02-00600806d9b6"],
    "SWbemMethod": ["04b83d5b-21ae-11d2-8b33-00600806d9b6"],
    "SWbemMethodSet": ["04b83d5a-21ae-11d2-8b33-00600806d9b6"],
    "SWbemNamedValue": ["04b83d60-21ae-11d2-8b33-00600806d9b6"],
    "SWbemNamedValueSet": ["9aed384e-ce8b-11d1-8b05-00600806d9b6"],
    "SWbemObject": ["04b83d62-21ae-11d2-8b33-00600806d9b6"],
    "SWbemObjectEx": ["d6bdafb2-9435-491f-bb87-6aa0f0bc31a2"],
    "SWbemObjectPath": ["5791bc26-ce9c-11d1-97bf-0000f81e849c"],
    "SWbemObjectSet": ["04b83d61-21ae-11d2-8b33-00600806d9b6"],
    "SWbemPrivilege": ["26ee67bc-5804-11d2-8b4a-00600806d9b6"],
    "SWbemPrivilegeSet": ["26ee67be-5804-11d2-8b4a-00600806d9b6"],
    "SWbemProperty": ["04b83d5d-21ae-11d2-8b33-00600806d9b6"],
    "SWbemPropertySet": ["04b83d5c-21ae-11d2-8b33-00600806d9b6"],
    "SWbemQualifier": ["04b83d5f-21ae-11d2-8b33-00600806d9b6"],
    "SWbemQualifierSet": ["04b83d5e-21ae-11d2-8b33-00600806d9b6"],
    "SWbemRefreshableItem": ["8c6854bc-de4b-11d3-b390-00105a1f473a"],
    "SWbemRefresher": ["d269bf5c-d9c1-11d3-b38f-00105a1f473a"],
    "SWbemSecurity": ["b54d66e9-2287-11d2-8b33-00600806d9b6"],
    "SWbemServices": ["04b83d63-21ae-11d2-8b33-00600806d9b6"],
    "SWbemServicesEx": ["62e522dc-8cf3-40a8-8b2e-37d595651e40"],
    "SWbemSink": ["75718c9a-f029-11d1-a1ac-00c04fb6c223"],
    "SYSTEMLANGBARITEM": ["bebacc94-5cd3-4662-a1e0-f33199493669"],
    "SYSTEMLANGBARITEM2": ["5d997390-8320-400a-88e5-35b0c120f90b"],
    "SampleGrabber": ["c1f400a0-3f08-11d3-9f0b-006008039e37"],
    "SapiLayr": ["dcbd6fa8-032f-11d3-b5b1-00c04fc324a1"],
    "ScfFileExecute": ["6da736c9-dcde-4651-82a8-56e4ef1d8dd7"],
    "ScheduledTasks": ["d6277990-4c6a-11cf-8d87-00aa0060f5bf"],
    "SchemaMigrationPlugin": ["042dc17c-023f-43df-a3ec-982b4dc78a64"],
    "ScopeFactory": ["6746c347-576b-4f73-9012-cdfeea251bc4"],
    "ScopeItem": ["408e13b3-02dc-4db3-9f23-3c3ca354621b"],
    "ScriptingContext": ["d97a6da0-a868-11cf-83ae-11b0c90c2bd8"],
    "Scriptlet": ["ae24fdae-03c6-11d1-8b76-0080c744f389"],
    "SeachEverywhereCommand": ["8973b4ef-7da5-4031-a333-f65609a4dcf4"],
    "SearchBandUnifiedListViewHost": ["160365e1-e73d-4b79-883d-fcaf1abccdaf"],
    "SearchBox": ["64bc32b5-4eec-4de7-972d-bd8bd0324537"],
    "SearchClearMruCommand": ["d509c21a-b88c-4ad1-8fad-d6a7572728e5"],
    "SearchCloseTabCommand": ["cc3fa696-93b8-4745-b935-0599acb97747"],
    "SearchConnectorFolder": ["72b36e70-8700-42d6-a7f7-c9ab3323ee51"],
    "SearchControl": ["fccf70c8-f4d7-4d8b-8c17-cd6715e37fff"],
    "SearchExtensionEnumerator": ["e1485982-2e71-4a6e-b78d-2b2d0ebdf0b3"],
    "SearchFilterDateCommand": ["df46c02a-3568-4765-aad3-88f5e1d42f92"],
    "SearchFilterKindCommand": ["c7f2fb0f-acc2-4ddf-9d8a-5e6e80d61024"],
    "SearchFilterSizeCommand": ["7c127ac8-ec8d-40f2-91d0-b791cfc2397b"],
    "SearchFolder": ["04731b67-d933-450a-90e6-4acd2e9408fe"],
    "SearchFolderItemFactory": ["14010e02-bbbd-41f0-88e3-eda371216584"],
    "SearchHome": ["9343812e-1c37-4a49-a12e-4b2d810d956b"],
    "SearchIDListFactory": ["6e682784-1eca-4cf2-988d-96b6e89e9a4d"],
    "SearchMSExecute": ["90b9bce2-b6db-4fd3-8451-35917ea1081b"],
    "SearchMorePropertiesCommand": ["a38e6420-19ec-490c-b4bf-51673c360213"],
    "SearchMruCommand": ["87ab8051-37bd-4e70-83c0-1e4f9ae1d37d"],
    "SearchOptionCompressedCommand": ["e2f33e30-b587-4f08-bf1a-f28d0f41000a"],
    "SearchOptionContentsCommand": ["576c5669-e07f-4a1b-9a7a-8f85d944283b"],
    "SearchOptionDeepCommand": ["3613f1d2-c9a5-4f41-a070-e5bb823b2e5b"],
    "SearchOptionShallowCommand": ["7b0c11a0-2faf-40d4-9fe5-28fa27c85442"],
    "SearchOptionSystemCommand": ["263a4743-bc0d-40b6-8f7f-1b2135c204d2"],
    "SearchPaneTestHookService": ["cf90e61f-4028-49e7-b304-05b5f54ae183"],
    "SearchProtocolUrl": ["07398dcf-2e0b-4ece-99dd-56b262db948b"],
    "SearchQuery": ["7548a939-2776-46cf-8f62-1d1f488dedf0"],
    "SearchResultsTestHookService": ["2edbfe5e-a3fc-4c62-84a9-ade8b1970aee"],
    "SearchSaveCommand": ["652527c4-4a72-4bd3-bfab-4b06ab172d7c"],
    "SearchSendToCommand": ["10e59d21-3860-4ed8-bd52-883e116a892e"],
    "SearchSendToComputerCommand": ["4c8cc9cb-80ca-4e16-9f60-f5eb55092361"],
    "SearchServices": ["d3ca534d-3342-42b2-900b-1aceaff85e8a"],
    "SearchServicesProvider": ["9440861a-25ca-4bc2-833e-866a6191d110"],
    "SearchSuggestionsDataProvider": ["8ec3bfd6-d1bb-4b3d-83cd-c825080bfc2d"],
    "SearchSuggestionsService": ["8eb9ba6e-ceed-4d06-b7f6-ea6047221299"],
    "SecureHttpSchemePlugin": ["37a61c8b-7f8e-4d08-b12b-248d73e9ab4f"],
    "SecurityEditor": ["4d111e08-cbf7-4f12-a926-2c7920af52fc"],
    "SecurityListener": ["517f6aa6-d6fa-46d0-8094-17ff17e4ccf4"],
    "SecurityListenerXml": ["6dd062c7-b6e6-4702-98b0-6e6ab46c877d"],
    "SecurityZoneChecker": ["57635537-c856-4cc2-ae5c-62c34708070c"],
    "SelectAllExecute": ["aa28fbc7-59f1-4c42-9fd8-ba2be27ea319"],
    "SelectModeExecute": ["9ea81517-a970-461f-8437-9988871198f8"],
    "SelectNoneExecute": ["4705a6b4-e4cb-4ed1-af8d-851c644a0459"],
    "SendTo": ["888dca60-fc0a-11cf-8f0f-00c04fd7d062"],
    "SendToMenu": ["7ba4c740-9e81-11cf-99d3-00aa004ae837"],
    "SeparateSingleProcessExplorerHost": ["ceff45ee-c862-41de-aee2-a022c81eda92"],
    "SeparatorBand": ["a608a731-b6f2-4d08-ac1e-c22a65b64acf"],
    "SequencerSourceRemoteStream": ["90eab610-e43a-4188-bcc4-e47fdf04868c"],
    "ServerDataCollectorSet": ["03837531-098b-11d8-9414-505054503030"],
    "ServerDataCollectorSetCollection": ["03837532-098b-11d8-9414-505054503030"],
    "ServerDemo": ["0003000f-0000-0000-c000-000000000046"],
    "SessionMoniker": ["00000347-0000-0000-c000-000000000046"],
    "SetBackgroundContextMenu": ["ff609cc7-d34d-4049-a1aa-2293517ffcc6"],
    "SetShellForeground": ["9a97f12a-6b73-4dc4-b3c1-e9244c03adac"],
    "SettingMonitorSSO": ["b5cfeb0e-9c01-4942-a5cb-f62eb09d808f"],
    "SettingProfileHandler": ["2c86c843-77ae-4284-9722-27d65366543c"],
    "SettingSyncBackupManager": ["8a0a83a7-7a6d-48d6-8f3d-9029d8a76e06"],
    "SettingSyncDiagnostics": ["deef2a9b-b3b7-46f2-a07f-d53340bf9e0f"],
    "SettingSyncEngine": ["4aa0a5c4-1b9b-4f2e-99d7-99c6aec83474"],
    "SettingSyncGetBackupStatus": ["6e5d1f2a-af9a-419a-9caf-c5a5c32c3cf8"],
    "SettingSyncMetadataStore": ["0d816b02-d487-44fb-8bd3-7eadb66604ca"],
    "SettingSyncParameters": ["08f91d9d-1f00-48c2-b90f-cc75ffafe727"],
    "SettingSyncServices": ["d5b0f757-a97f-4311-b864-78d6094217c6"],
    "SettingSyncSettings": ["ef30258d-9897-45cd-a760-fe5c195cb00e"],
    "SettingSyncStateReporter": ["01c6ca30-792b-404b-a5c2-0a34434b3aa4"],
    "SettingUnitFactory": ["3f66cf3f-68be-485e-8bfe-0a005b2d00f2"],
    "SettingUnitResolver": ["e838b72c-83c9-4a08-8dd1-144cb14616f1"],
    "SettingsCollection": ["a3d93ab0-3079-4662-bf03-1718156e7c32"],
    "SettingsFlow": ["3c4059b0-fb29-4eba-9947-289e0d824e64"],
    "ShapewareVISIO10": ["00030021-0000-0000-c000-000000000046"],
    "ShareCommandState": ["7b4a83b6-f704-4b77-8e3d-c6087e3a21d2"],
    "ShareFlow": ["549e57e9-b362-49d1-b679-b64d510efe4b"],
    "ShareFlowCF": ["bf75430d-51dd-483f-bc3a-4542e6c9dce4"],
    "ShareManager": ["edb5f444-cb8d-445a-a523-ec5ab6ea33c7"],
    "ShareOperationProxy": ["3c5edebe-16c6-4ee4-906b-436aa1f6ef9e"],
    "SharePermissionList": ["59a437ab-74f3-4de2-afe6-54203634c4dd"],
    "SharePlatformCore": ["e317d729-81b0-4257-926b-b8de5f3b0288"],
    "SharePlatformHost": ["586d1936-bc46-4f9c-bf65-77c95ad9d9ad"],
    "SharePointView": ["c577058e-514b-4620-b6f6-6cb8001aa70d"],
    "ShareWith": ["99d353bc-c813-41ec-8f28-eae61e702e57"],
    "ShareWithNobodyCommand": ["c139c040-532d-451b-80ca-44d1f0839d2a"],
    "SharedBitmap": ["4db26476-6787-4046-b836-e8412a9e8a27"],
    "SharingConfigurationManager": ["49f371e1-8c5c-4d9c-9a3b-54a6827f513c"],
    "SharingListener": ["eb6b4457-f013-4e5a-9b05-1d44e4d6faeb"],
    "SharingListenerXml": ["7aae5b4f-488c-419b-95e2-923f2aa70ffd"],
    "ShellAutoplay": ["995c996e-d918-4a8c-a302-45719a6f4ea7"],
    "ShellAutoplayCancelled": ["fb479c02-9ec4-4fed-8599-debe037452cb"],
    "ShellBandProxy": ["f61ffec1-754f-11d0-80ca-00aa005b4383"],
    "ShellBrowserWindowCF": ["5da8fe1f-f485-4516-be06-426b0dddf555"],
    "ShellCopyHook": ["217fc9c0-3aea-1069-a2db-08002b30309d"],
    "ShellDrvDefExt": ["5f5295e0-429f-1069-a2e2-08002b30309d"],
    "ShellFeedbackService": ["4f37e3a9-1d2b-42ab-a5b0-31fc05627def"],
    "ShellFileDefExt": ["21b22460-3aea-1069-a2dc-08002b30309d"],
    "ShellFolderSet": ["ad974ae2-e292-4083-a280-0342d68daf55"],
    "ShellIconGlobalSettings": ["6c955eca-04ce-4f1e-84fe-d8a526ce3137"],
    "ShellIndexerAdminComWrapper": ["1e1714a3-50b9-480b-a94a-636d9a9b56d1"],
    "ShellItem": ["9ac9fbe1-e0a2-4ad6-b4ee-e212013ea917"],
    "ShellItemArray": ["26671179-2ec2-42bf-93d3-64108589cad5"],
    "ShellItemArrayAsCollection": ["cdc82860-468d-4d4e-b7e7-c298ff23ab2c"],
    "ShellItemArrayAsVirtualizedObjectArray": ["f6166dad-d3be-4ebd-8419-9b5ead8d0ec7"],
    "ShellItemArrayWithCommonParent": ["b77b1cbf-e827-44a9-a33a-6ccfeeaa142a"],
    "ShellKnownFolderHandler": ["469afbdf-084f-4dc9-904f-9e824c48bc37"],
    "ShellLibrary": ["d9b3211d-e57f-4426-aaef-30a806add397"],
    "ShellNamespaceMonitor": ["c439a42a-583f-4609-8c30-e3681e2a0e78"],
    "ShellNetDefExt": ["86422020-42a0-1069-a2e5-08002b30309d"],
    "ShellPlaylist": ["d0da2915-3f89-4519-a4ca-5e02528c8ec4"],
    "ShellPublishingXml": ["a05ad39d-c5e6-4723-8802-ab7788548580"],
    "ShellServiceHost": ["6b3b8d23-fa8d-40b9-8dbd-b950333e2c52"],
    "ShellServiceHostBrokerProvider": ["3480a401-bde9-4407-bc02-798a866ac051"],
    "ShellServiceProvider": ["73a45ddd-8abd-4a9c-b6b2-635646254fd0"],
    "ShellSnapComponent": ["19227dc0-fc88-4aaa-8c2d-a0db913aa2ff"],
    "ShellTravelLog": ["d58960ba-2ef3-4910-9e34-c911b1710180"],
    "ShellUrl": ["4bec2015-bfa1-42fa-9c0c-59431bbe880e"],
    "ShellWindowsCF": ["d92bd3b9-99a0-4334-a497-11bcb093e9d2"],
    "Shell_ToolbarExtExec": ["1fba04ee-3024-11d2-8f1f-0000f87abd16"],
    "ShowDWMTreeItem": ["6522cf99-94c7-4958-b18d-4f6159e6926b"],
    "ShowInputPaneAnimationCoordinator": ["1f046abf-3202-4dc1-8cb5-3c67617ce1fa"],
    "SidResolver": ["823b8267-735c-477e-8151-0fa9adc8ab3a"],
    "SimpleConflictPresenter": ["7a0f6ab7-ed84-46b6-b47e-02aa159a152b"],
    "SimpleFileBasedLog": ["e16c0593-128f-11d1-97e4-00c04fb9618a"],
    "SimpleLightDismissProvider": ["83d6f579-4a45-439f-994e-7ec23c46b13e"],
    "SimplePropertyChange": ["c2898807-82f6-4e9e-9320-062f0a31ab83"],
    "SiteModeShortcut": ["182c3813-df97-40fa-9c4e-b7d3e74f00ca"],
    "SlideShowSettingHandler": ["59b7de6c-57af-11e1-b7a4-eacc4724019b"],
    "SlideshowContextMenu": ["0bf754aa-c967-445c-ab3d-d8fda9bae7ef"],
    "SlideshowFeedManager": ["466936a9-e281-45e6-a239-9fe53d07b4a5"],
    "SlideshowHost": ["d034b02a-093b-46b7-8c75-61b9104c71e9"],
    "SlideshowManager": ["a9b005e5-ab63-4c1d-ae9e-aa120a50bb0f"],
    "SlideshowServer": ["536aacfb-5238-4314-b4d4-5b0a2e8b968e"],
    "SmartRenderEngine": ["498b0949-bbe9-4072-98be-6ccaeb79dc6f"],
    "SmartTee": ["cc58e280-8aa1-11d1-b3f1-00aa003761c5"],
    "SmartcardCredentialProvider": ["8fd7e19c-3bf7-489b-a72c-846ab3678c96"],
    "SmartcardPinProvider": ["94596c7e-3744-41ce-893e-bbf09122f76a"],
    "SmartcardReaderSelectionProvider": ["1b283861-754f-4022-ad47-a5eaaa618894"],
    "SmartcardWinRTProvider": ["1ee7337f-85ac-45e2-a23c-37c753209769"],
    "SmbShareEngine": ["77f419aa-771a-45ff-ac66-7567fa3243d3"],
    "SmtpCat": ["b23c35b7-9219-11d2-9e17-00c04fa322ba"],
    "SnapPointsInertiaBehavior": ["7dfec242-fe68-42d2-a073-e4dbf2842067"],
    "SnapRTaskTOID": ["5cbe57cc-268f-4ee1-a3cf-cf963a93b458"],
    "SnapinRegistration": ["b2ddd548-51ba-4cfd-be8b-5db06f40e516"],
    "Snippet": ["6f7ca88d-4247-4b45-91b8-fe2664441aed"],
    "SoftLandingManager": ["4020d514-e884-42e9-91dc-e1f09004d3f0"],
    "SoftkbdIMX": ["f89e9e58-bd2f-4008-9ac2-0f816c09f4ee"],
    "SolutionItemsProject": ["d1dcdb85-c5e8-11d2-bfca-00c04f990235"],
    "SortAscendingCommand": ["5c70bc6a-4ab5-48ee-bce3-e6dd857cbdc6"],
    "SortByColumnCommand": ["e07dfaca-e658-4ce5-89b2-05bbbf75e708"],
    "SortColumnArray": ["7df2cfcd-6c09-415a-ae9d-5263f4964cbb"],
    "SortDescendingCommand": ["e2550429-5df2-48cd-9ea3-26ff682d8a17"],
    "SortGroupsAscendingCommand": ["4fab6371-6d65-47ba-b8f1-ca6273c6c69e"],
    "SortGroupsDescendingCommand": ["b4414d52-69c9-4666-b62a-d82620bed434"],
    "SoundEventSchemePlugin": ["f79a6bf9-7415-4cf3-ae10-4559509abc3c"],
    "SoundRec": ["0003000d-0000-0000-c000-000000000046"],
    "SourcePropPage": ["0cf32aa1-7571-11d0-93c4-00aa00a3ddea"],
    "SparseImageList": ["2ac0b4f3-6d94-4530-b889-497343d6b112"],
    "SparseMultiImageList": ["743c85f6-afe6-47d6-b5fa-f0ca90d74364"],
    "SpeedBumpSnapPointsBehavior": ["97ddd4cb-ef8a-445e-a09f-d4c32f8e34d2"],
    "SpellingDictionaryCallback": ["c19cbbed-8e33-4b9b-8f00-b044415e8764"],
    "SpellingDictionarySettingUnitResolver": ["10a59d3a-e15c-44ec-b6c8-950e713dca7d"],
    "SplashScreenEvents": ["4cbe39a3-bd8a-4d51-9bd3-b7853737fd93"],
    "SqlGenerator": ["9bf8d948-5c56-450e-baf8-d6144c6e81cb"],
    "SrtInv": ["00030011-0000-0000-c000-000000000046"],
    "Srtest": ["00030010-0000-0000-c000-000000000046"],
    "SrvrTest": ["00030023-0000-0000-c000-000000000046"],
    "StackWalker": ["00000349-0000-0000-c000-000000000046"],
    "StagingFolder": ["00da2f99-f2a6-40c2-b770-a920f8e44abc"],
    "StagingHandler": ["312a6884-4abe-4c4e-ae73-c69874c8318b"],
    "StandardCommandSet10": ["5dd0bb59-7076-4c59-88d3-de36931f63f0"],
    "StandardCommandSet11": ["d63db1f0-404e-4b21-9648-ca8d99245ec3"],
    "StandardCommandSet12": ["2a8866dc-7bde-4dc8-a360-a60679534384"],
    "StandardCommandSet14": ["4c7763bf-5faf-4264-a366-b7e1f27ba958"],
    "StandardCommandSet15": ["712c6c80-883b-4aad-b430-bbca5256fa9d"],
    "StandardCommandSet16": ["8f380902-6040-4097-9837-d3f40e66f908"],
    "StandardCommandSet2K": ["1496a755-94de-11d0-8c3f-00c04fc2aae2"],
    "StandardCommandSet97": ["5efc7975-14bc-11cf-9b2b-00aa00573819"],
    "StanfordGraphics": ["00030015-0000-0000-c000-000000000046"],
    "StartMenuCacheAndAppResolver": ["660b90c8-73a9-4b58-8cae-355b7f55341b"],
    "StartMenuCommandingProvider": ["7a54bbed-bb9b-425a-8bd7-1a5410923dcf"],
    "StartMenuCommandingProviderFolder": ["a00ee528-ebd9-48b8-944a-8942113d46ac"],
    "StartMenuGroupPolicyFilter": ["23613363-0028-431d-a49e-a3cd482d3926"],
    "StartMenuLauncherProvider": ["8fe3aa4c-4fff-11e0-9eae-3586dfd72085"],
    "StartMenuLauncherProviderFolder": ["98f275b4-4fff-11e0-89e2-7b86dfd72085"],
    "StartMenuPathCompleteProvider": ["0b2c9183-c9fa-4c53-ae21-c900b0c39965"],
    "StartMenuPathCompleteProviderFolder": ["e345f35f-9397-435c-8f95-4e922c26259e"],
    "StartMenuPathCompleteQueryCache": ["8099904b-0b91-4906-a89d-11de2bd8f737"],
    "StartMenuPin": ["a2a9545d-a0c2-42b4-9708-a0b2badd77c8"],
    "StartMenuProvider": ["25256c24-3b75-49b3-a433-4bb2f8865896"],
    "StartMenuProviderFolder": ["daf95313-e44d-46af-be1b-cbacea2c3065"],
    "StaticDib": ["00000316-0000-0000-c000-000000000046"],
    "StaticFileSettingHandlerHelper": ["ef79ab42-5404-4bca-8bd5-727160ddfae5"],
    "StaticMetafile": ["00000315-0000-0000-c000-000000000046"],
    "StaticNodeList": ["30510467-98b5-11cf-bb82-00aa00bdce0b"],
    "StaticSettingHandlerHelper": ["ecf622a8-028b-4275-b9f6-1c84ee411a3e"],
    "StdHlink": ["79eac9d0-baf9-11ce-8c82-00aa004ba90b"],
    "StdHlinkBrowseContext": ["79eac9d1-baf9-11ce-8c82-00aa004ba90b"],
    "StdOleLink": ["00000300-0000-0000-c000-000000000046"],
    "StdURLMoniker": ["79eac9e0-baf9-11ce-8c82-00aa004ba90b"],
    "StdURLProtocol": ["79eac9e1-baf9-11ce-8c82-00aa004ba90b"],
    "StdWrapper": ["00000336-0000-0000-c000-000000000046"],
    "StdWrapperNoHeader": ["00000350-0000-0000-c000-000000000046"],
    "Stickynote": ["00030020-0000-0000-c000-000000000046"],
    "StorageFolder": ["1703cf31-6ceb-48eb-b026-d35a82a9a65b"],
    "StorageHandler": ["4876dc0e-f963-4227-9a8f-19872b75d231"],
    "StorageProviderBanners": ["7ccdf9f4-e576-455a-8bc7-f6ec68d6f063"],
    "StoreApplicationCapabilityCheck": ["7da2a2ba-8276-4738-94eb-97ffaaa559ca"],
    "StreamBackedFolder": ["edc978d6-4d53-4b2f-a265-5805674be568"],
    "StreamBufferComposeRecording": ["d682c4ba-a90a-42fe-b9e1-03109849c423"],
    "StreamBufferConfig": ["fa8a68b2-c864-4ba2-ad53-d3876a87494b"],
    "StreamBufferPropertyHandler": ["e37a73f8-fb01-43dc-914e-aaee76095ab9"],
    "StreamBufferRecordingAttributes": ["ccaa63ac-1057-4778-ae92-1206ab9acee6"],
    "StreamBufferSink": ["2db47ae5-cf39-43c2-b4d6-0cd8d90946f4"],
    "StreamBufferThumbnailHandler": ["713790ee-5ee1-45ba-8070-a1337d2762fa"],
    "StringCollection": ["72c97d74-7c3b-40ae-b77d-abdb22eba6fb"],
    "StructuredQueryHelper": ["934d4698-6a59-48f8-9f29-9fb30670320e"],
    "SubscribeDialog": ["3e71f26d-136f-4545-813f-35276024b705"],
    "SubtitlesFilter": ["9f22cfea-ce07-41ab-8ba0-c7364af90af9"],
    "SuggestFilterWorker": ["8d1e5d4b-a99c-4408-b0f0-ccab9e5835a1"],
    "SuggestPopup": ["2f2dc38b-34d2-462c-add4-f74cc15510a1"],
    "SuggestionsAggregateDataProvider": ["975e4be9-133c-4fd2-ac2b-6c4efe85d62e"],
    "SurrogateManager": ["0000034c-0000-0000-c000-000000000046"],
    "SuspensionDependencyManager": ["6b273fc5-61fd-4918-95a2-c3b5e9d7f581"],
    "SwitchController": ["9c33c4ab-bc91-4a79-bf47-7c90cebc3aa3"],
    "SwitchThumbnailDeviceManager": ["f0db4512-0e25-4a1f-a88b-8ff40351bfcd"],
    "SxsStore": ["3c6859ce-230b-48a4-be6c-932c0c202048"],
    "SymLink": ["85cfccaf-2d14-42b6-80b6-f40f65d016e7"],
    "SyncCommandGallery": ["4f23c296-f56e-45af-904d-d245bf750759"],
    "SyncCommandState": ["31b231f6-546d-4f9b-ac95-0f963d72559c"],
    "SyncEventProperties": ["4b534112-3af6-4697-a77c-d62ce9b9e7cf"],
    "SyncHandlerFolder": ["0372b488-6515-42da-b37b-440667c1f72a"],
    "SyncHandlerProperties": ["576c9e85-1300-4ef5-bf6b-d00509f4edcd"],
    "SyncIAMEventHandler": ["4e3c6645-b839-4a06-a27b-0190f9e6a0af"],
    "SyncIntegrationManager": ["9aa46009-3ce0-458a-a354-715610a075e6"],
    "SyncItemProperties": ["b32d3949-ed98-4dbb-b347-17a144969bba"],
    "SyncMappingsCommandStateHandler": ["d451359e-d6f4-45bb-8a05-271e8a98c740"],
    "SyncMgrAggregateStatus": ["b8558612-df5e-4f95-bb81-8e910b327fb2"],
    "SyncMgrClient": ["1202db60-1dac-42c5-aed5-1abdd432248e"],
    "SyncMgrControl": ["1a1f4206-0688-4e7f-be03-d82ec69df9a5"],
    "SyncMgrFolder": ["9c73f5e5-7ae7-4e32-a8e8-8d23b85255bf"],
    "SyncMgrIsolationCollection": ["69f9cb25-25e2-4be1-ab8f-07aa7cb535e8"],
    "SyncMgrScheduleWizard": ["8d8b8e30-c451-421b-8553-d2976afa648c"],
    "SyncMgrService": ["3734ff83-6764-44b7-a1b9-55f56183cdb0"],
    "SyncMgrShellServiceObject": ["f20487cc-fc04-4b1e-863f-d9801796130b"],
    "SyncMgrp": ["6295df2d-35ee-11d1-8707-00c04fd93327"],
    "SyncProfileNotificationHandler": ["d63aa156-d534-4bac-9bf1-55359cf5ec30"],
    "SyncProviderObjectCache": ["f6f05056-37fa-4daf-8a51-40a8f14e0f62"],
    "SyncResultsDelegateFolder": ["bc48b32f-5910-47f5-8570-5074a8a5636a"],
    "SyncResultsFolder": ["71d99464-3b6b-475c-b241-e15883207529"],
    "SyncRootManager": ["f324e4f9-8496-40b2-a1ff-9617c1c9affe"],
    "SyncSettingsHandler": ["f0b1e31e-4fe1-49f5-84bc-4ba007655288"],
    "SyncSetupDelegateFolder": ["f1390a9a-a3f4-4e5d-9c5f-98f3bd8d935c"],
    "SyncSetupFolder": ["2e9e59c0-b437-4981-a647-9c34b9b90891"],
    "SyncStatusHandler": ["6bc752f7-9721-49f8-873b-9fecb6215de3"],
    "SyncingOverlayHandler": ["0a30f902-8398-4ee8-86f7-4cfb589f04d1"],
    "SysTray": ["35cec8a3-2be6-11d2-8773-92e220524153"],
    "SystemDataCollectorSet": ["03837546-098b-11d8-9414-505054503030"],
    "SystemDataCollectorSetCollection": ["03837547-098b-11d8-9414-505054503030"],
    "SystemInformation": ["c01b9ba0-bea7-41ba-b604-d0a36f469133"],
    "SystemMonitor": ["c4d2d8e0-d1dd-11ce-940f-008029004347"],
    "SystemMonitor2": ["7f30578c-5f38-4612-acfe-6ed04c7b7af8"],
    "SystemSettingsApplistHandler": ["0413965e-17f3-46b2-b39f-f8aced04194c"],
    "SystemSettingsHandler": ["2f712f0f-ed71-474b-9529-9b9627ed0a6b"],
    "TABLETEXTSERVICE": ["e429b25a-e5d3-4d1f-9be3-0c608477e3a1"],
    "TBAuthProtocol": ["14654ca6-5711-491d-b89a-58e571679951"],
    "TCG": ["1496a755-94de-11d0-8c3f-00c04fc2aae2"],
    "TDC": ["333c7bc4-460f-11d0-bc04-0080c7055a83"],
    "TF_CategoryMgr": ["a4b544a1-438d-4b41-9325-869523e2d6c7"],
    "TF_ClassicLangBar": ["3318360c-1afc-4d09-a86b-9f9cb6dceb9c"],
    "TF_DisplayAttributeMgr": ["3ce74de4-53d3-4d74-8b83-431b3828ba53"],
    "TF_InputProcessorProfiles": ["33c53a50-f456-4884-b049-85fd643ecfed"],
    "TF_LangBarItemMgr": ["b9931692-a2b3-4fab-bf33-9ec6f9fb96ac"],
    "TF_LangBarMgr": ["ebb08c45-6c4a-4fdc-ae53-4eb8c4c7db8e"],
    "TF_ThreadMgr": ["529a9e6b-6587-4f23-ab9e-9c7d683e3c50"],
    "TF_TransitoryExtensionUIEntry": ["ae6be008-07fb-400d-8beb-337a64f7051f"],
    "TPLangMod": ["c6465c2c-7943-452a-9a57-f61db6b452e9"],
    "TVEFilterCCProperties": ["05500282-faa5-4df9-8246-bfc23ac5cea8"],
    "TVEFilterStatsProperties": ["05500283-faa5-4df9-8246-bfc23ac5cea8"],
    "TVEFilterTuneProperties": ["05500281-faa5-4df9-8246-bfc23ac5cea8"],
    "TabletModePositionerOperation": ["0089d119-209b-4240-bafa-89a38268739b"],
    "TaskbandPin": ["90aa3a4e-1cba-4233-b8bb-535773d48449"],
    "TaskbarLayoutPolicyManager": ["4f495385-cab7-4470-9e0d-1bc0ec792e04"],
    "TaskbarSettingHandler": ["d32cd718-970d-4496-b7a7-337be8890145"],
    "TempAppVisualArray": ["f957f191-ed62-46f7-be1b-1155a0564de2"],
    "TerminationActivator": ["e760e244-abb3-4c3c-b925-0781c8ceb46c"],
    "TestIniCache": ["e3281610-0c0e-4f30-800d-6033a3a7e4be"],
    "TestRotationManager": ["21a1bdc5-fd33-415c-b8ba-e156ddddd50c"],
    "TestServ": ["0003002e-0000-0000-c000-000000000046"],
    "TextEditorFactory": ["8b382828-6202-11d1-8870-0000f87579d2"],
    "TextIFilter": ["9e175b96-f52a-11d8-b9a5-505054503030"],
    "ThemeManager": ["2e17c0ef-2851-459b-a3c8-27a41d4bc9f7"],
    "ThemeManager2": ["9324da94-50ec-4a14-a770-e90ca03e7c8f"],
    "ThemeSettingMonitor": ["02665d88-6a3e-4dfc-beff-8ca2118a5061"],
    "ThemesRegTreeItem": ["aabe54d4-6e88-4c46-a6b3-1df790dd6e0d"],
    "ThumbnailStreamCache": ["cbe0fed3-4b91-4e90-8354-8a8c84ec6872"],
    "ThumbnailsOrIconRegTreeItem": ["71e32baa-73ee-40a1-933c-f166f0192b72"],
    "TileElementFactory": ["83e94dbf-7f97-46b0-a6f0-360fe982bf83"],
    "TimeDatePlugin": ["0ac71593-60fc-4a6a-bf85-a0b93bcc3785"],
    "TimeWarpFolder": ["9db7a13c-f208-4981-8353-73cc61ae2783"],
    "TimewarpResultsDelegateFolder": ["a3c3d402-e56c-4033-95f7-4885e80b0111"],
    "TimewarpResultsFolder": ["f8c2ab3b-17bc-41da-9758-339d7dbf2d88"],
    "ToggleRecycleConfirmationCommand": ["2b1ffce5-dd0f-4f1f-b150-a87ae69ce009"],
    "TokenBrokerMonitor": ["32eac0f0-1c2b-4775-942e-0ac11121a0f4"],
    "TopViewRestoreDefaultExecute": ["167c0a56-c490-4623-9225-8ffdc546e56c"],
    "TraceDataProvider": ["03837513-098b-11d8-9414-505054503030"],
    "TraceDataProviderCollection": ["03837511-098b-11d8-9414-505054503030"],
    "TraceRelogger": ["7b40792d-05ff-44c4-9058-f440c71f17d4"],
    "TraceSession": ["0383751c-098b-11d8-9414-505054503030"],
    "TraceSessionCollection": ["03837530-098b-11d8-9414-505054503030"],
    "TrackShellMenu": ["8278f931-2a3e-11d2-838f-00c04fd918d0"],
    "TranscodeSinkActivate": ["5a3b0a4a-56a6-478b-a136-63eb2fe36cd4"],
    "TransferConfirmationUI": ["6b831e4f-a50d-45fc-842f-16ce27595359"],
    "TransmitCategory": ["cc7bfb41-f175-11d1-a392-00e0291f3959"],
    "TravelBand": ["c4ec38bd-4e9e-4b5e-935a-d1bff237d980"],
    "TrayDeskBand": ["e6442437-6c68-4f52-94dd-2cfed267efb9"],
    "TrayForegroundControl": ["95b63696-18b6-4d3e-8ec2-cdb4352318eb"],
    "TreeWalker": ["30510747-98b5-11cf-bb82-00aa00bdce0b"],
    "TridentPrivateDebugAPI": ["305106fc-98b5-11cf-bb82-00aa00bdce0b"],
    "TripoliPi": ["9e175bb7-f52a-11d8-b9a5-505054503030"],
    "TrustedSignalsEnrollmentHandler": ["b8b84b44-8b60-4b1e-837c-343b25093928"],
    "TryHarderFactory": ["ed6ae9cf-ad35-46b7-ac30-3f8b9eb5349f"],
    "TsfServices": ["39aedc00-6b60-46db-8d31-3642be0e4373"],
    "TxtPreviewHandler": ["1531d583-8375-4d3f-b5fb-d23bbd169f22"],
    "TypeAheadFramework": ["41ca099a-b8af-4fc2-a285-03faeaa8b109"],
    "TypeAheadLocalMetadataProvider": ["a0a8c450-92fc-422a-aa04-0a19e8d65ac7"],
    "TypeAheadSearchHistoryProvider": ["4278bb8c-d0fc-4380-a2c4-525b9a396f5b"],
    "TypeAheadSearchHistorySettings": ["46cf315b-2d3a-4765-852a-6500c42d9865"],
    "TypeLibRegistrationReader": ["b1f250c3-b7f8-4da3-9c8d-382602f02424"],
    "TypeListCategorizer": ["58859c43-2c82-454b-86c0-9efb11e54838"],
    "TypeNameFactory": ["b81ff171-20f3-11d2-8dcc-00a0c9b00525"],
    "TypeToSearchIMESettings": ["68cfb337-fd99-43af-a64f-8b84c9ce6a56"],
    "TypedDataThumbnailHandler": ["7c67eb93-8eff-4e48-889f-45ba299bc46f"],
    "TypedUrlDataItemEnum": ["caf7056e-deef-4f15-bd1d-834879973512"],
    "TypedUrlDataProvider": ["f135cee6-7df7-42da-8724-9f0e44c5081b"],
    "UAPSplashScreenEvents": ["3ec569dc-6fb5-45d1-8b46-e122d27962e9"],
    "UIAnimationDiagnostic": ["641aba69-56fd-4029-a445-4d8375d3a699"],
    "UIAnimationManager": ["4c1fc63a-695c-47e8-a339-1a194be3d0b8"],
    "UIAnimationManager2": ["d25d8842-8884-4a4a-b321-091314379bdd"],
    "UIAnimationTimer": ["bfcd4a0c-06b6-4384-b768-0daa792c380e"],
    "UIAnimationTransitionFactory": ["8a9b1cdd-fcd7-419c-8b44-42fd17db1887"],
    "UIAnimationTransitionFactory2": ["84302f97-7f7b-4040-b190-72ac9d18e420"],
    "UIAnimationTransitionLibrary": ["1d6322ad-aa85-4ef5-a828-86d71067d145"],
    "UIAnimationTransitionLibrary2": ["812f944a-c5c8-4cd9-b0a6-b3da802f228d"],
    "UIAutomationCrossBitnessHook32": ["60a90a2f-858d-42af-8929-82be9d99e8a1"],
    "UIAutomationCrossBitnessHook64": ["49f171dd-b51a-40d3-9a6c-52d674cc729d"],
    "UIDiagnostic": ["c608e099-892d-4628-b6a2-97257b014e2e"],
    "UIGlobalNotify": ["f8fb6e07-55e6-4bb9-96bc-2393a039cee7"],
    "UIHost": ["054aae20-4bea-4347-8a35-64a533254a9d"],
    "UIHostNoLaunch": ["4ce576fa-83dc-4f88-951c-9d0782b4e376"],
    "UIRibbonFramework": ["926749fa-2615-4987-8845-c33e65f2b957"],
    "UIRibbonImageFromBitmapFactory": ["0f7434b6-59b6-4250-999e-d168d6ae4293"],
    "UITypeManager": ["32665929-d77e-4ab5-8c08-fbf409b8a233"],
    "UPnPDescriptionDocumentEx": ["33fd0563-d81a-4393-83cc-0195b1da2f91"],
    "UPnPDeviceFinderEx": ["181b54fc-380b-4a75-b3f1-4ac45e9605b0"],
    "URLPropertySetStorage": ["06eee834-461c-42c2-8dcf-1502b527b1f9"],
    "UiaManager": ["4b7a83d5-cf71-40ad-ab0f-bf6830e95330"],
    "UiaWindowNotifier": ["77cbbbb7-6cd0-48ed-a02b-52fbb0e43ecd"],
    "UnPinFromFrequentExecute": ["ee20eeba-df64-4a4e-b7bb-2d1c6b2dfcc1"],
    "UndoExplorerCommand": ["0dbd7044-8ea5-4573-a924-fe8565cce18f"],
    "UnifiedListView": ["cc538cc9-a559-4314-b3c5-4b4582e7a9bb"],
    "UnifiedListViewHost": ["25282340-3fd6-406a-a62b-821efeb3f673"],
    "UnifiedListViewWindow": ["f4f68c2e-761d-4da4-8989-a60cd0835eb7"],
    "UniversalDelegateFolder": ["d84fa0c2-b0b3-4470-9345-75db0ec5a83a"],
    "UniversalSearchBand": ["6d8bb3d3-9d87-4a91-ab56-4f30cffefe9f"],
    "UnsecuredApartment": ["49bd2028-1523-11d1-ad79-00c04fd8fdff"],
    "UpBand": ["87b3efbe-de7f-4e4b-9051-238c66522378"],
    "UpdateCollection": ["13639463-00db-4646-803d-528026140d88"],
    "UpdateDownloader": ["5baf654a-5a07-4264-a255-9ff54c7151e7"],
    "UpdateInstaller": ["d2e0fe7f-d23e-48e1-93c0-6fa8cc346474"],
    "UpdateSearcher": ["b699e5e8-67ff-4177-88b0-3684a3388bfb"],
    "UpdateServiceManager": ["f8d253d9-89a4-4daa-87b6-1168369f0b21"],
    "UpdateSession": ["4cb43d7f-7eee-4906-8698-60da1c38f2fe"],
    "UpgradeAppsPlugin": ["60abc2f2-6305-4e03-8645-5f9ba071954b"],
    "UrlBlockBroker": ["d4a4efe9-516c-4c36-89dd-8666f391d450"],
    "UrlBlockClient": ["ce4b8f65-ce43-4f86-90bf-2897b07e090b"],
    "UrlMonWrapper": ["0000031f-0000-0000-c000-000000000046"],
    "UrlmonSchemePlugin": ["9ec4b4f9-3029-45ad-947b-344de2a249e2"],
    "UserAccounts": ["c3c39131-b182-4801-b437-6d1e65b72f57"],
    "UserEventXml": ["59f927b8-b249-4672-88d5-2d688bafdf24"],
    "UserInfoDialog": ["934b410c-43e4-415e-9935-fbc081ba93a9"],
    "UserInteractionModeHelper": ["2e1271d5-2ff2-4ea4-9647-c67a82a2d85c"],
    "UserNameXml": ["42393e99-8513-42d3-8aea-e0e5fbdc8f64"],
    "UserOOBEPreparationPlugin": ["20425b74-41f5-426f-a145-13bbb45a2f66"],
    "UserTileBroker": ["032c35f6-11e2-497b-9d78-6ad0288fbd48"],
    "UserTileSettingHandler": ["a9224722-48e4-4a66-8068-f90fa13a6d74"],
    "UserTileSettingMonitor": ["4290cad6-a75d-4ac8-a496-56dbbb28eb88"],
    "UserTileStore": ["09c5dd34-009d-40fa-bcb9-0165ad0c15d4"],
    "UserTileValidator": ["027d3767-28e0-4ffa-98d0-df67d0cbbe47"],
    "UsersFilesFolder": ["59031a47-3f72-44a7-89c5-5595fe6b30ee"],
    "UsersLibrariesFolder": ["031e4825-7b94-4dc3-b131-e946b44c8dd5"],
    "V1PasswordCredentialProvider": ["6f45dc1e-5384-457a-bc13-2cd81b0d28ed"],
    "V1SmartcardCredentialProvider": ["8bf9a910-a8ff-457f-999f-a5ca10b4a885"],
    "V1WinBioCredentialProvider": ["ac3ac249-e820-4343-a65b-377ac634dc09"],
    "VERSION_DEPENDENT_MSIME_JAPANESE": ["6a91029e-aa49-471b-aee7-7d332785660d"],
    "VML": ["10072cec-8cc1-11d1-986e-00a0c955b42e"],
    "VS10TextEditorFactory": ["df25faa1-e891-49f6-9823-72634a02a405"],
    "VS10TextEditorFactoryWithEncoding": ["c6be297e-c907-4f43-9120-053c192ef51e"],
    "VSSCoordinator": ["e579ab5f-1cc4-44b4-bed9-de0991ff0623"],
    "VSSRemoteCoordinator": ["95243a62-2f9b-4fdf-b437-40d965f6d17f"],
    "VSSoftwareProvider": ["65ee1dba-8ff4-4a58-ac1c-3470ee2f376a"],
    "VaultProvider": ["503739d0-4c5e-4cfd-b3ba-d881334f0df2"],
    "VdsLoader": ["9c38ed61-d565-4728-aeee-c80952f0ecde"],
    "VdsService": ["7d1933cb-86f6-4a98-8628-01be94c9a575"],
    "VerPropertyHandler": ["66742402-f9b9-11d1-a202-0000f81fedee"],
    "VerbStateTask": ["c99217e2-951d-40b6-b4e4-6af203dadf89"],
    "VerticalIndicatorContent": ["a10b5f17-afe0-4aa2-91e9-3e7001d2e6b4"],
    "VideoCompressorCategory": ["33d9a760-90c8-11d0-bd43-00a0c911ce86"],
    "VideoInputDeviceCategory": ["860bb310-5d01-11d0-bd3b-00a0c911ce86"],
    "VideoMixingRenderer": ["b87beb7b-8d29-423f-ae4d-6582c10175ac"],
    "VideoMixingRenderer9": ["51b4abf3-748f-4e3b-a276-c828330e926a"],
    "VideoPortManager": ["6f26a6cd-967b-47fd-874a-7aed2c9d25a2"],
    "VideoProcessorMFT": ["88753b26-5b24-49bd-b2e7-0c445c78c982"],
    "VideoRendererDefault": ["6bc1cffa-8fc1-4261-ac22-cfb4cc38db50"],
    "VideoTranscoder": ["6d0f3287-6d07-4234-a3bc-ee1cd693372e"],
    "ViewOptionsCommand": ["926b23ab-fd60-43f1-8f63-b24cabdf5316"],
    "ViewOptionsGalleryCommand": ["939d20ac-8036-406f-bd5c-bf672896bd71"],
    "ViewRemotePrintersCommand": ["0a9bbb1e-03ee-4201-9900-abbff56c9c6c"],
    "VirtualDesktopManager": ["aa509086-5ca9-4c25-8f95-589d3c07b48a"],
    "VirtualViewportContent": ["3206a19a-86f0-4cb4-a7f3-16e3b7e2d852"],
    "VisibleIn": ["92038079-b9ef-428f-87f0-0463fcb1272a"],
    "VorbisDecoderMFT": ["1a198ef2-60e5-4ea8-90d8-da1f2832c288"],
    "VsCfgProviderEventsHelper": ["99913f1f-1ee3-11d1-8a6e-00c04f682e21"],
    "VsComReferenceDlg": ["cc05ee57-c6c0-4742-a469-0961e50b0049"],
    "VsCommunityPackage": ["490508dd-32ce-45e8-808c-faebf468b186"],
    "VsDocDataAdapter": ["169f2886-6566-432e-a93d-5588bd583229"],
    "VsDocOutlinePackage": ["21af45b0-ffa5-11d0-b63f-00a0c922e851"],
    "VsEnvironmentPackage": ["da9fb551-c724-11d0-ae1f-00a0c90fffc3"],
    "VsFileShareProvider": ["fce59da7-7bac-40da-8d21-3e7311ba51cd"],
    "VsHiddenTextManagerAdapter": ["85115cfe-3f29-4e52-ae98-6fe62573d11c"],
    "VsProjectCapabilityExpressionMatcher": ["943a3169-d328-4e42-8af6-7200e5e8c2e4"],
    "VsTaskList": ["bc5955d5-aa0d-11d0-a8c5-00a0c921a4d2"],
    "VsTaskListPackage": ["4a9b7e50-aa16-11d0-a8c5-00a0c921a4d2"],
    "VsTextBufferCoordinatorAdapter": ["5fceea4c-d49f-4acd-b816-130a5dcd4c54"],
    "VssEvent": ["faf53cc4-bd73-4e36-83f1-2b23f46e513e"],
    "VssSnapshotMgmt": ["0b5a2c52-3eb9-470a-96e2-6c6d4570e40f"],
    "WAVByteStreamPlugin": ["42c9b9f5-16fc-47ef-af22-da05f7c842e3"],
    "WIC8BIMIPTCDigestMetadataReader": ["02805f1e-d5aa-415b-82c5-61c033a988a6"],
    "WIC8BIMIPTCDigestMetadataWriter": ["2db5e62b-0d67-495f-8f9d-c2f0188647ac"],
    "WIC8BIMIPTCMetadataReader": ["0010668c-0801-4da6-a4a4-826522b6d28f"],
    "WIC8BIMIPTCMetadataWriter": ["00108226-ee41-44a2-9e9c-4be4d5b1d2cd"],
    "WIC8BIMResolutionInfoMetadataReader": ["5805137a-e348-4f7c-b3cc-6db9965a0599"],
    "WIC8BIMResolutionInfoMetadataWriter": ["4ff2fe0e-e74a-4b71-98c4-ab7dc16707ba"],
    "WICAPEMetadataReader": ["1767b93a-b021-44ea-920f-863c11f4f768"],
    "WICAPEMetadataWriter": ["bd6edfca-2890-482f-b233-8d7339a1cf8d"],
    "WICAdngDecoder": ["981d9411-909e-42a7-8f5d-a747ff052edb"],
    "WICApp0MetadataReader": ["43324b33-a78f-480f-9111-9638aaccc832"],
    "WICApp0MetadataWriter": ["f3c633a2-46c8-498e-8fbb-cc6f721bbcde"],
    "WICApp13MetadataReader": ["aa7e3c50-864c-4604-bc04-8b0b76e637f6"],
    "WICApp13MetadataWriter": ["7b19a919-a9d6-49e5-bd45-02c34e4e4cd5"],
    "WICApp1MetadataReader": ["dde33513-774e-4bcd-ae79-02f4adfe62fc"],
    "WICApp1MetadataWriter": ["ee366069-1832-420f-b381-0479ad066f19"],
    "WICBmpDecoder": ["6b462062-7cbf-400d-9fdb-813dd10f2778"],
    "WICBmpEncoder": ["69be8bb4-d66d-47c8-865a-ed1589433782"],
    "WICConvertBgrToYCbCr": ["52bf4ab3-b450-44b9-b0e5-2c9b59c06c67"],
    "WICDdsDecoder": ["9053699f-a341-429d-9e90-ee437cf80c73"],
    "WICDdsEncoder": ["a61dde94-66ce-4ac1-881b-71680588895e"],
    "WICDdsMetadataReader": ["276c88ca-7533-4a86-b676-66b36080d484"],
    "WICDdsMetadataWriter": ["fd688bbd-31ed-4db7-a723-934927d38367"],
    "WICDefaultFormatConverter": ["1a3f11dc-b514-4b17-8c5f-2154513852f1"],
    "WICExifMetadataReader": ["d9403860-297f-4a49-bf9b-77898150a442"],
    "WICExifMetadataWriter": ["c9a14cda-c339-460b-9078-d4debcfabe91"],
    "WICFormatConverterHighColor": ["ac75d454-9f37-48f8-b972-4e19bc856011"],
    "WICFormatConverterNChannel": ["c17cabb2-d4a3-47d7-a557-339b2efbd4f1"],
    "WICFormatConverterWMPhoto": ["9cb5172b-d600-46ba-ab77-77bb7e3a00d9"],
    "WICGCEMetadataReader": ["b92e345d-f52d-41f3-b562-081bc772e3b9"],
    "WICGCEMetadataWriter": ["af95dc76-16b2-47f4-b3ea-3c31796693e7"],
    "WICGifCommentMetadataReader": ["32557d3b-69dc-4f95-836e-f5972b2f6159"],
    "WICGifCommentMetadataWriter": ["a02797fc-c4ae-418c-af95-e637c7ead2a1"],
    "WICGifDecoder": ["381dda3c-9ce9-4834-a23e-1f98f8fc52be"],
    "WICGifEncoder": ["114f5598-0b22-40a0-86a1-c83ea495adbd"],
    "WICGpsMetadataReader": ["3697790b-223b-484e-9925-c4869218f17a"],
    "WICGpsMetadataWriter": ["cb8c13e4-62b5-4c96-a48b-6ba6ace39c76"],
    "WICHeifDecoder": ["e9a4a80a-44fe-4de4-8971-7150b10a5199"],
    "WICHeifEncoder": ["0dbecec1-9eb3-4860-9c6f-ddbe86634575"],
    "WICHeifHDRMetadataReader": ["2438de3d-94d9-4be8-84a8-4de95a575e75"],
    "WICHeifMetadataReader": ["acddfc3f-85ec-41bc-bdef-1bc262e4db05"],
    "WICHeifMetadataWriter": ["3ae45e79-40bc-4401-ace5-dd3cb16e6afe"],
    "WICIMDMetadataReader": ["7447a267-0015-42c8-a8f1-fb3b94c68361"],
    "WICIMDMetadataWriter": ["8c89071f-452e-4e95-9682-9d1024627172"],
    "WICIPTCMetadataReader": ["03012959-f4f6-44d7-9d09-daa087a9db57"],
    "WICIPTCMetadataWriter": ["1249b20c-5dd0-44fe-b0b3-8f92c8e6d080"],
    "WICIRBMetadataReader": ["d4dcd3d7-b4c2-47d9-a6bf-b89ba396a4a3"],
    "WICIRBMetadataWriter": ["5c5c1935-0235-4434-80bc-251bc1ec39c6"],
    "WICIcoDecoder": ["c61bfcdf-2e0f-4aad-a8d7-e06bafebcdfe"],
    "WICIfdMetadataReader": ["8f914656-9d0a-4eb2-9019-0bf96d8a9ee6"],
    "WICIfdMetadataWriter": ["b1ebfc28-c9bd-47a2-8d33-b948769777a7"],
    "WICImagingCategories": ["fae3d380-fea4-4623-8c75-c6b61110b681"],
    "WICImagingFactory": ["317d06e8-5f24-433d-bdf7-79ce68d8abc2", "cacaf262-9370-4615-a13b-9f5539da4c0a"],
    "WICImagingFactory1": ["cacaf262-9370-4615-a13b-9f5539da4c0a"],
    "WICImagingFactory2": ["317d06e8-5f24-433d-bdf7-79ce68d8abc2"],
    "WICInteropMetadataReader": ["b5c8b898-0074-459f-b700-860d4651ea14"],
    "WICInteropMetadataWriter": ["122ec645-cd7e-44d8-b186-2c8c20c3b50f"],
    "WICJpegChrominanceMetadataReader": ["50b1904b-f28f-4574-93f4-0bade82c69e9"],
    "WICJpegChrominanceMetadataWriter": ["3ff566f0-6e6b-49d4-96e6-b78886692c62"],
    "WICJpegCommentMetadataReader": ["9f66347c-60c4-4c4d-ab58-d2358685f607"],
    "WICJpegCommentMetadataWriter": ["e573236f-55b1-4eda-81ea-9f65db0290d3"],
    "WICJpegDecoder": ["9456a480-e88b-43ea-9e73-0b2d9b71b1ca"],
    "WICJpegEncoder": ["1a34f5c1-4a5a-46dc-b644-1f4567e7a676"],
    "WICJpegLuminanceMetadataReader": ["356f2f88-05a6-4728-b9a4-1bfbce04d838"],
    "WICJpegLuminanceMetadataWriter": ["1d583abc-8a0e-4657-9982-a380ca58fb4b"],
    "WICJpegQualcommPhoneEncoder": ["68ed5c62-f534-4979-b2b3-686a12b2b34c"],
    "WICLSDMetadataReader": ["41070793-59e4-479a-a1f7-954adc2ef5fc"],
    "WICLSDMetadataWriter": ["73c037e7-e5d9-4954-876a-6da81d6e5768"],
    "WICMSCameraRawDecoder": ["5fdd51e2-a9d0-44ce-8c8d-162ba0c591a0"],
    "WICPlanarFormatConverter": ["184132b8-32f8-4784-9131-dd7224b23438"],
    "WICPngBkgdMetadataReader": ["0ce7a4a6-03e8-4a60-9d15-282ef32ee7da"],
    "WICPngBkgdMetadataWriter": ["68e3f2fd-31ae-4441-bb6a-fd7047525f90"],
    "WICPngChrmMetadataReader": ["f90b5f36-367b-402a-9dd1-bc0fd59d8f62"],
    "WICPngChrmMetadataWriter": ["e23ce3eb-5608-4e83-bcef-27b1987e51d7"],
    "WICPngDecoder": ["389ea17b-5078-4cde-b6ef-25c15175c751", "e018945b-aa86-4008-9bd4-6777a1e40c11"],
    "WICPngDecoder1": ["389ea17b-5078-4cde-b6ef-25c15175c751"],
    "WICPngDecoder2": ["e018945b-aa86-4008-9bd4-6777a1e40c11"],
    "WICPngEncoder": ["27949969-876a-41d7-9447-568f6a35a4dc"],
    "WICPngGamaMetadataReader": ["3692ca39-e082-4350-9e1f-3704cb083cd5"],
    "WICPngGamaMetadataWriter": ["ff036d13-5d4b-46dd-b10f-106693d9fe4f"],
    "WICPngHistMetadataReader": ["877a0bb7-a313-4491-87b5-2e6d0594f520"],
    "WICPngHistMetadataWriter": ["8a03e749-672e-446e-bf1f-2c11d233b6ff"],
    "WICPngIccpMetadataReader": ["f5d3e63b-cb0f-4628-a478-6d8244be36b1"],
    "WICPngIccpMetadataWriter": ["16671e5f-0ce6-4cc4-9768-e89fe5018ade"],
    "WICPngItxtMetadataReader": ["aabfb2fa-3e1e-4a8f-8977-5556fb94ea23"],
    "WICPngItxtMetadataWriter": ["31879719-e751-4df8-981d-68dff67704ed"],
    "WICPngSrgbMetadataReader": ["fb40360c-547e-4956-a3b9-d4418859ba66"],
    "WICPngSrgbMetadataWriter": ["a6ee35c6-87ec-47df-9f22-1d5aad840c82"],
    "WICPngTextMetadataReader": ["4b59afcc-b8c3-408a-b670-89e5fab6fda7"],
    "WICPngTextMetadataWriter": ["b5ebafb9-253e-4a72-a744-0762d2685683"],
    "WICPngTimeMetadataReader": ["d94edf02-efe5-4f0d-85c8-f5a68b3000b1"],
    "WICPngTimeMetadataWriter": ["1ab78400-b5a3-4d91-8ace-33fcd1499be6"],
    "WICRAWDecoder": ["41945702-8302-44a6-9445-ac98e8afa086"],
    "WICSubIfdMetadataReader": ["50d42f09-ecd1-4b41-b65d-da1fdaa75663"],
    "WICSubIfdMetadataWriter": ["8ade5386-8e9b-4f4c-acf2-f0008706b238"],
    "WICThumbnailMetadataReader": ["fb012959-f4f6-44d7-9d09-daa087a9db57"],
    "WICThumbnailMetadataWriter": ["d049b20c-5dd0-44fe-b0b3-8f92c8e6d080"],
    "WICTiffDecoder": ["b54e85d9-fe23-499f-8b88-6acea713752b"],
    "WICTiffEncoder": ["0131be10-2001-4c5f-a9b0-cc88fab64ce8"],
    "WICUnknownMetadataReader": ["699745c2-5066-4b82-a8e3-d40478dbec8c"],
    "WICUnknownMetadataWriter": ["a09cca86-27ba-4f39-9053-121fa4dc08fc"],
    "WICWebpAnimMetadataReader": ["076f9911-a348-465c-a807-a252f3f2d3de"],
    "WICWebpAnmfMetadataReader": ["85a10b03-c9f6-439f-be5e-c0fbef67807c"],
    "WICWebpDecoder": ["7693e886-51c9-4070-8419-9f70738ec8fa"],
    "WICWmpDecoder": ["a26cec36-234c-4950-ae16-e34aace71d0d"],
    "WICWmpEncoder": ["ac4ce3cb-e1c1-44cd-8215-5a1665509ec2"],
    "WICXMPAltMetadataReader": ["aa94dcc2-b8b0-4898-b835-000aabd74393"],
    "WICXMPAltMetadataWriter": ["076c2a6c-f78f-4c46-a723-3583e70876ea"],
    "WICXMPBagMetadataReader": ["e7e79a30-4f2c-4fab-8d00-394f2d6bbebe"],
    "WICXMPBagMetadataWriter": ["ed822c8c-d6be-4301-a631-0e1416bad28f"],
    "WICXMPMetadataReader": ["72b624df-ae11-4948-a65c-351eb0829419"],
    "WICXMPMetadataWriter": ["1765e14e-1bd4-462e-b6b1-590bf1262ac6"],
    "WICXMPSeqMetadataReader": ["7f12e753-fc71-43d7-a51d-92f35977abb5"],
    "WICXMPSeqMetadataWriter": ["6d68d1de-d432-4b0f-923a-091183a9bda7"],
    "WICXMPStructMetadataReader": ["01b90d9a-8209-47f7-9c52-e1244bf50ced"],
    "WICXMPStructMetadataWriter": ["22c21f93-7ddb-411c-9b17-c5b7bd064abc"],
    "WLANDLG_BALLOON_HANDLER": ["348c9cff-cb90-4024-ae22-f17259a3934b"],
    "WMADecMediaObject": ["2eeb4adf-4578-4d10-bca7-bb955f56320a"],
    "WMAsfReader": ["187463a0-5bb7-11d3-acbe-0080c75e246e"],
    "WMAsfWriter": ["7c23220e-55bb-11d3-8b16-00c04fb6bd3d"],
    "WMBandwidthSharing_Exclusive": ["af6060aa-5197-11d2-b6af-00c04fd908e9"],
    "WMBandwidthSharing_Partial": ["af6060ab-5197-11d2-b6af-00c04fd908e9"],
    "WMDRMContext": ["7f5d25f8-78a5-49a8-a33c-2c0e11831c66"],
    "WMDRMSystemID": ["8948bb22-11bd-4796-93e3-974d1b575678"],
    "WMIExtension": ["f0975afe-5c7f-11d2-8b74-00104b2afb41"],
    "WMMUTEX_Bitrate": ["d6e22a01-35da-11d1-9034-00a0c90349be"],
    "WMMUTEX_Language": ["d6e22a00-35da-11d1-9034-00a0c90349be"],
    "WMMUTEX_Presentation": ["d6e22a02-35da-11d1-9034-00a0c90349be"],
    "WMMUTEX_Unknown": ["d6e22a03-35da-11d1-9034-00a0c90349be"],
    "WMPMediaPluginRegistrar": ["5569e7f5-424b-4b93-89ca-79d17924689a"],
    "WMPSkinManager": ["b2a7fd52-301f-4348-b93a-638c6de49229"],
    "WMVDecoderMFT": ["82d353df-90bd-4382-8bc2-3f6192b76e34"],
    "WPCharts": ["00030031-0000-0000-c000-000000000046"],
    "WPDShServiceObj": ["aaa288ba-9a4c-45b0-95d7-94d524869db5"],
    "WPD_NAMESPACE_EXTENSION": ["35786d3c-b075-49b9-88dd-029876e11c01"],
    "WPGraphics": ["00030030-0000-0000-c000-000000000046"],
    "WSCDefaultProduct": ["2981a36e-f22d-11e5-9ce9-5e5517507c66"],
    "WSCProductList": ["17072f7b-9abe-4a74-a261-1eb76b55107a"],
    "WSChangeNotify": ["e2e760c5-bf0d-4241-bfd6-6d0aab648ac9"],
    "WSDPublicationServices": ["5d48fbd8-e61e-427d-ac65-371322853ec8"],
    "WSDPublisher": ["d7c1aeb5-10f2-48cb-a182-f7ef79c51b19"],
    "WSFavDataProvider": ["6382a5c0-01cb-456e-b4e2-ec48686411d2"],
    "WSHistDataProvider": ["bd08691c-9008-4173-8505-a9c9fad4e477"],
    "WSRSSDataProvider": ["f4d5887b-ba34-4efe-af67-041ca679f4db"],
    "WSShellFolder": ["11016101-e366-4d22-bc06-4ada335c892b"],
    "WSTDecoder": ["70bc06e0-5666-11d3-a184-00105aef9f33"],
    "WTVByteStreamPlugin": ["65964407-a5d8-4060-85b0-1ccd63f768e2"],
    "WamAdmin": ["61738644-f196-11d0-9953-00c04fd919c1"],
    "WaveletFilter": ["ed9a4150-9e00-11cf-b57c-00aa00a71d1a"],
    "WbemAdministrativeLocator": ["cb8555cc-9128-11d1-ad9b-00c04fd8fdff"],
    "WbemAuthenticatedLocator": ["cd184336-9128-11d1-ad9b-00c04fd8fdff"],
    "WbemBackupRestore": ["c49e32c6-bc8b-11d2-85d4-00105a1f8304"],
    "WbemClassObject": ["9a653086-174f-11d2-b5f9-00104b703efd"],
    "WbemContext": ["674b6698-ee92-11d0-ad71-00c04fd8fdff"],
    "WbemDCOMTransport": ["f7ce2e13-8c90-11d1-9e7b-00c04fc324a8"],
    "WbemDecoupledBasicEventProvider": ["f5f75737-2843-4f22-933d-c76a97cda62f"],
    "WbemDecoupledRegistrar": ["4cfc7932-0f9d-4bef-9c32-8ea2a6b56fcb"],
    "WbemDefPath": ["cf4cc405-e2c5-4ddd-b3ce-5e7582d8c9fa"],
    "WbemLevel1Login": ["8bc3f05e-d86b-11d0-a075-00c04fb68820"],
    "WbemLocalAddrRes": ["a1044801-8f7e-11d1-9e7c-00c04fc324a8"],
    "WbemLocator": ["4590f811-1d3a-11d0-891f-00aa004b2e24"],
    "WbemObjectTextSrc": ["8d1c559d-84f0-4bb3-a7d5-56a7435a9ba6"],
    "WbemQuery": ["eac8a024-21e2-4523-ad73-a71a0aa2f56a"],
    "WbemRefresher": ["c71566f2-561e-11d1-ad87-00c04fd8fdff"],
    "WbemStatusCodeText": ["eb87e1bd-3233-11d2-aec9-00c04fb68820"],
    "WbemUnauthenticatedLocator": ["443e7b79-de31-11d2-b340-00104bcc4b4a"],
    "WbemUninitializedClassObject": ["7a0227f6-7108-11d1-ad90-00c04fd8fdff"],
    "WebAppMigration": ["26fa29e5-8a81-45e0-aeeb-0b1d6e5dd977"],
    "WebFilterItemEnum": ["f6317f36-5e21-4f4b-b4d2-3e0806b30e93"],
    "WebFolders": ["bdeadf00-c265-11d0-bced-00a0c90ab50f"],
    "WebGeocoordinates": ["305107c8-98b5-11cf-bb82-00aa00bdce0b"],
    "WebGeolocation": ["305107c6-98b5-11cf-bb82-00aa00bdce0b"],
    "WebGeoposition": ["305107ce-98b5-11cf-bb82-00aa00bdce0b"],
    "WebGeopositionError": ["305107ca-98b5-11cf-bb82-00aa00bdce0b"],
    "WebHijackCheck": ["70d548f5-9393-4d17-92a6-e90b9fa83185"],
    "WebPlatStorageBroker": ["5a1547af-335f-4ee5-b81e-48afc4cc681a"],
    "WebProxy": ["650503cf-9108-4ddc-a2ce-6c2341e1c582"],
    "WeekCategorizer": ["c6f8f7b8-6cb2-4c8b-9470-d66f375c3271"],
    "WiaDefaultSegFilter": ["d4f4d30b-0b29-4508-8922-0c5797d42765"],
    "WinBioCredentialProvider": ["bec09223-b018-416d-a0ac-523971b639f5"],
    "WinHttpRequest": ["2087c2f4-2cef-4953-a8ab-66779b670495"],
    "WinINetShellNamespaceMonitorCallback": ["c6fce351-a02b-466a-9235-d03134892d25"],
    "WinMDELPCMSinkActivate": ["a47286bf-d624-4a30-acdf-2705bd3de0c3"],
    "WinMDENetChannelActivate": ["e4e55606-2ffb-4558-a601-7693efc5481c"],
    "WinMDERtspSinkActivate": ["e0936539-81db-4574-b9f8-34fd0bff6f2e"],
    "WindowArrangementOperation": ["12eaddd9-5da3-40fc-b643-27abd37531c0"],
    "WindowColoriationSettingHandler": ["69c725bb-1a00-496f-a9d6-92f94afb3de8"],
    "WindowManagementEvents": ["0cd069cf-ac9b-41f4-9571-3a95a62c36a1"],
    "WindowPropStore": ["56ad4c5d-b908-4f85-8ff1-7940c29b3bcf"],
    "WindowsSettingHandlerFactory": ["a43c525d-edf0-48d9-b7fb-9babbd6dbd65"],
    "WindowsUpdateAgentInfo": ["c2e88c2f-6f5b-4aaa-894b-55c847ad3a2d"],
    "WininetBroker": ["c39ee728-d419-4bd4-a3ef-eda059dbd935"],
    "WininetHistDataItemEnum": ["693fe0e5-d87e-4920-8775-911f444e4369"],
    "WininetHistDataProvider": ["2e99db7c-1802-441f-9af1-85e94a283419"],
    "WinrtAsyncChannelUnmarshaler": ["00000357-0000-0000-c000-000000000046"],
    "WirelessPlugin": ["8d759bee-4828-47ad-9b19-f873d5e0f945"],
    "WirelessSettingHandler": ["f1759e97-0b98-49da-8b38-372cd47dc97b"],
    "WirelessSettingMonitor": ["5c24b264-3a01-475c-8ee8-ed4b9dc4f86c"],
    "WordArt": ["00030009-0000-0000-c000-000000000046"],
    "WordDocument": ["00030003-0000-0000-c000-000000000046"],
    "WorkFolderLogonTrigger": ["97d47d56-3777-49fb-8e8f-90d7e30e1a1e"],
    "WorkFoldersMaintenanceTask": ["63260bce-a3fb-4a34-aa51-d4d8e877b62b"],
    "WstDecoderPropertyPage": ["04e27f80-91e4-11d3-a184-00105aef9f33"],
    "XDSCodecProperties": ["c4c4c483-0049-4e2b-98fb-9537f6ce516d"],
    "XDSCodecTagProperties": ["c4c4c493-0049-4e2b-98fb-9537f6ce516d"],
    "XDomainRequest": ["30510455-98b5-11cf-bb82-00aa00bdce0b"],
    "XDomainRequestFactory": ["30510457-98b5-11cf-bb82-00aa00bdce0b"],
    "XFeedsManager": ["fe6b11c3-c72e-4061-86c6-9d163121f229"],
    "XHTMLDocument": ["30590067-98b5-11cf-bb82-00aa00bdce0b"],
    "XMLAutoList": ["9ecf51f8-cfb1-458d-9485-f5a231afd22f"],
    "XMLDocument_Private": ["48123bc4-99d9-11d1-a6b3-00c04fd91555"],
    "XMLGraphBuilder": ["1bb05961-5fbf-11d2-a521-44df07c10000"],
    "XMLHttpRequestEventTarget": ["30510831-98b5-11cf-bb82-00aa00bdce0b"],
    "XMLPropertyStore": ["af9f2c0d-6b9f-4e32-a94d-a3e235a31bf7"],
    "XMLSerializer": ["3051077e-98b5-11cf-bb82-00aa00bdce0b"],
    "XamlRuntimeSiteAggregator": ["56f68e55-d114-4c64-996e-6e5f2d5340b2"],
    "XpsOMObjectFactory": ["e974d26d-3d9b-4d47-88cc-3872f2dc3585"],
    "XpsOMThumbnailGenerator": ["7e4a23e2-b969-4761-be35-1a8ced58e323"],
    "XpsSignatureManager": ["b0c43320-2315-44a2-b70a-0943a140a8ee"],
    "ZDPPlugin": ["c22020c6-eeab-455e-bec2-a2cc8fdff976"],
    "ZipContextMenu": ["b8cdcb65-b1bf-4b42-9428-1dfdb7ee92af"],
}
