from ... import *

NB14Type = Generate_New_Bonded_Force_Type("nb14", "1-4", {"kLJ":float, "kee": float}, True)

@Molecule.Set_Save_SPONGE_Input
def write_nb14(self, prefix, dirname):
    bonds = []
    for bond in self.bonded_forces["nb14"]:
        order = list(range(2))
        if bond.kLJ != 0 and  bond.kee != 0:
            if self.atom_index[bond.atoms[order[0]]] > self.atom_index[bond.atoms[order[-1]]]:
                temp_order = order[::-1]
            else:
                temp_order = order
            bonds.append("%d %d %f %f"%(self.atom_index[bond.atoms[temp_order[0]]]
            , self.atom_index[bond.atoms[temp_order[1]]], bond.kLJ, bond.kee))
    
    if (bonds):
        towrite = "%d\n"%len(bonds)
        bonds.sort(key = lambda x: list(map(int, x.split()[:2])))
        towrite += "\n".join(bonds)
        
        f = open(os.path.join(dirname, prefix + "_nb14.txt"),"w")
        f.write(towrite)
        f.close()