import os
from setuptools import find_packages, setup
import platkit

setup(
    name="nextcode-platform-kit",
    version=platkit.__version__,
    license="MIT",
    author="WUXI NextCODE",
    author_email="support@wuxinextcode.com",
    url="https://www.wuxinextcode.com",
    description="Flask setup packages",
    packages=find_packages(exclude=["contrib", "docs", "tests"]),
    include_package_data=True,
    install_requires=[
        "click",
        "cryptography",
        "Flask",
        "Flask-Auth",
        "Flask-HTTPAuth",
        "flask-restx",
        "hjson",
        "logstash-formatter",
        "prometheus-flask-exporter",
        "PyJWT>=2.0.0",
        "python-decouple",
        "requests",
        "pyyaml",
        "sqlalchemy",
        "sentry-sdk[flask]",
        "werkzeug",
    ],
    extras_require={},
    zip_safe=False,
    classifiers=[
        "Development Status :: 4 - Beta",
        "Environment :: Web Environment",
        "Framework :: Flask",
        "Intended Audience :: Developers",
        "License :: OSI Approved :: MIT License",
        "Operating System :: OS Independent",
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3.6",
        "Programming Language :: Python :: 3.7",
        "Programming Language :: Python :: 3.8",
        "Topic :: Internet :: WWW/HTTP",
        "Topic :: Internet :: WWW/HTTP :: Dynamic Content",
        "Topic :: Software Development :: Libraries :: Application Frameworks",
        "Topic :: Software Development :: Libraries :: Python Modules",
    ],
)
