"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApiGatewayV2WebSocketToSqs = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
const defaults = require("@aws-solutions-constructs/core");
const cdk = require("aws-cdk-lib");
const sqs = require("aws-cdk-lib/aws-sqs");
const constructs_1 = require("constructs");
class ApiGatewayV2WebSocketToSqs extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        if (props.existingWebSocketApi && props.webSocketApiProps) {
            throw new Error("Provide either an existing WebSocketApi instance or WebSocketApiProps, not both");
        }
        if (!props.existingWebSocketApi && !props.createDefaultRoute && !props.customRouteName) {
            throw new Error("Either createDefaultRoute or customRouteName must be specified when creating a WebSocketApi");
        }
        const constructMandatedDlqProps = {
            fifo: true,
            deduplicationScope: sqs.DeduplicationScope.MESSAGE_GROUP,
            fifoThroughputLimit: sqs.FifoThroughputLimit.PER_MESSAGE_GROUP_ID,
        };
        const constructMandatedQueueProps = {
            fifo: true,
            deduplicationScope: sqs.DeduplicationScope.MESSAGE_GROUP,
            fifoThroughputLimit: sqs.FifoThroughputLimit.PER_MESSAGE_GROUP_ID,
            redriveAllowPolicy: {
                redrivePermission: sqs.RedrivePermission.DENY_ALL,
            },
            visibilityTimeout: cdk.Duration.minutes(15),
        };
        // Setup the queue
        const buildQueueResponse = defaults.buildQueue(this, "queue", {
            existingQueueObj: props.existingQueueObj,
            queueProps: props.queueProps,
            deployDeadLetterQueue: props.deployDeadLetterQueue,
            deadLetterQueueProps: props.deadLetterQueueProps,
            maxReceiveCount: props.maxReceiveCount,
            enableEncryptionWithCustomerManagedKey: props.enableEncryptionWithCustomerManagedKey,
            encryptionKey: props.encryptionKey,
            encryptionKeyProps: props.encryptionKeyProps,
            constructDeadLetterQueueProps: constructMandatedDlqProps,
            constructQueueProps: constructMandatedQueueProps,
        });
        this.sqsQueue = buildQueueResponse.queue;
        this.deadLetterQueue = buildQueueResponse.dlq;
        const buildWebSocketQueueApiResponse = defaults.buildWebSocketQueueApi(this, id, {
            queue: this.sqsQueue,
            defaultRouteRequestTemplate: props.defaultRouteRequestTemplate,
            createDefaultRoute: props.createDefaultRoute,
            webSocketApiProps: props.webSocketApiProps,
            existingWebSocketApi: props.existingWebSocketApi,
            logGroupProps: props.logGroupProps,
            defaultIamAuthorization: props.defaultIamAuthorization ?? true,
            customRouteName: props.customRouteName,
        });
        this.webSocketApi = buildWebSocketQueueApiResponse.webSocketApi;
        this.webSocketStage = buildWebSocketQueueApiResponse.webSocketStage;
        this.apiGatewayRole = buildWebSocketQueueApiResponse.apiGatewayRole;
        this.apiGatewayLogGroup = buildWebSocketQueueApiResponse.apiGatewayLogGroup;
    }
}
exports.ApiGatewayV2WebSocketToSqs = ApiGatewayV2WebSocketToSqs;
_a = JSII_RTTI_SYMBOL_1;
ApiGatewayV2WebSocketToSqs[_a] = { fqn: "@aws-solutions-constructs/aws-apigatewayv2websocket-sqs.ApiGatewayV2WebSocketToSqs", version: "2.87.0" };
//# sourceMappingURL=data:application/json;base64,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