# This file was generated by mettle.genes.db.GenPy3 [ver 2.1] on Tue Mar 30 15:41:05 2021
#  Target Database = postgresql
#
import asyncio
import copy
import datetime
import uuid
import time
import mettle.lib
import mettle.io
import mettle.db

from bs_audit.db.tables.col import tCol
from bs_audit.db.tables.col_key import tColKey

from .col_insert import dColInsert

class dCol:

    def __init__(self, dbcon: mettle.db.IConnect):
        """
        Constructor.

        :param dbcon: Mettle database connection object.
        """
        self.rec    = tCol()
        self._dbcon = dbcon

    def __enter__(self):
        """
        DAO enter.
        """
        return self

    def __exit__(self, type, value, traceback):
        """
        DAO exit.
        """
        pass

    def insert_deft(self,
                    aud_id: int,
                    name: str,
                    before: str,
                    after: str):
        """
        Insert the record setting all column values.

        :param aud_id: int
        :param name: str
        :param before: str
        :param after: str
        """
        self.rec.aud_id = aud_id
        self.rec.name = name
        self.rec.before = before
        self.rec.after = after

        self.insert()

    def insert(self, irec: tCol = None):
        """
        Insert the record in the database with the record or irec if it is not None.

        :param irec: If not None use this record to insert into the database.
        """
        if irec:
            self.rec._copy_from(irec)

        with dColInsert(self._dbcon) as _qry:
            _qry.exec(self.rec)

        if irec:
            irec._copy_from(self.rec)

