import { MutualTlsCertificate } from './tls-certificate';
import { TlsValidation } from './tls-validation';
/**
 * Represents the properties needed to define client policy.
 *
 * @stability stable
 */
export interface TlsClientPolicy {
    /**
     * Whether the policy is enforced.
     *
     * @default true
     * @stability stable
     */
    readonly enforce?: boolean;
    /**
     * TLS is enforced on the ports specified here.
     *
     * If no ports are specified, TLS will be enforced on all the ports.
     *
     * @default - all ports
     * @stability stable
     */
    readonly ports?: number[];
    /**
     * Represents the object for TLS validation context.
     *
     * @stability stable
     */
    readonly validation: TlsValidation;
    /**
     * Represents a client TLS certificate.
     *
     * The certificate will be sent only if the server requests it, enabling mutual TLS.
     *
     * @default - client TLS certificate is not provided
     * @stability stable
     */
    readonly mutualTlsCertificate?: MutualTlsCertificate;
}
