"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HealthCheck = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("@aws-cdk/core");
const shared_interfaces_1 = require("./shared-interfaces");
/**
 * Contains static factory methods for creating health checks for different protocols.
 *
 * @stability stable
 */
class HealthCheck {
    /**
     * Construct a HTTP health check.
     *
     * @stability stable
     */
    static http(options = {}) {
        jsiiDeprecationWarnings._aws_cdk_aws_appmesh_HttpHealthCheckOptions(options);
        return new HealthCheckImpl(shared_interfaces_1.Protocol.HTTP, options.healthyThreshold, options.unhealthyThreshold, options.interval, options.timeout, options.path);
    }
    /**
     * Construct a HTTP2 health check.
     *
     * @stability stable
     */
    static http2(options = {}) {
        jsiiDeprecationWarnings._aws_cdk_aws_appmesh_HttpHealthCheckOptions(options);
        return new HealthCheckImpl(shared_interfaces_1.Protocol.HTTP2, options.healthyThreshold, options.unhealthyThreshold, options.interval, options.timeout, options.path);
    }
    /**
     * Construct a GRPC health check.
     *
     * @stability stable
     */
    static grpc(options = {}) {
        jsiiDeprecationWarnings._aws_cdk_aws_appmesh_GrpcHealthCheckOptions(options);
        return new HealthCheckImpl(shared_interfaces_1.Protocol.GRPC, options.healthyThreshold, options.unhealthyThreshold, options.interval, options.timeout);
    }
    /**
     * Construct a TCP health check.
     *
     * @stability stable
     */
    static tcp(options = {}) {
        jsiiDeprecationWarnings._aws_cdk_aws_appmesh_TcpHealthCheckOptions(options);
        return new HealthCheckImpl(shared_interfaces_1.Protocol.TCP, options.healthyThreshold, options.unhealthyThreshold, options.interval, options.timeout);
    }
}
exports.HealthCheck = HealthCheck;
_a = JSII_RTTI_SYMBOL_1;
HealthCheck[_a] = { fqn: "@aws-cdk/aws-appmesh.HealthCheck", version: "1.138.1" };
class HealthCheckImpl extends HealthCheck {
    constructor(protocol, healthyThreshold = 2, unhealthyThreshold = 2, interval = cdk.Duration.seconds(5), timeout = cdk.Duration.seconds(2), path) {
        super();
        this.protocol = protocol;
        this.healthyThreshold = healthyThreshold;
        this.unhealthyThreshold = unhealthyThreshold;
        this.interval = interval;
        this.timeout = timeout;
        this.path = path;
        if (healthyThreshold < 2 || healthyThreshold > 10) {
            throw new Error('healthyThreshold must be between 2 and 10');
        }
        if (unhealthyThreshold < 2 || unhealthyThreshold > 10) {
            throw new Error('unhealthyThreshold must be between 2 and 10');
        }
        if (interval.toMilliseconds() < 5000 || interval.toMilliseconds() > 300000) {
            throw new Error('interval must be between 5 seconds and 300 seconds');
        }
        if (timeout.toMilliseconds() < 2000 || timeout.toMilliseconds() > 60000) {
            throw new Error('timeout must be between 2 seconds and 60 seconds');
        }
        // Default to / for HTTP Health Checks
        if (path === undefined && (protocol === shared_interfaces_1.Protocol.HTTP || protocol === shared_interfaces_1.Protocol.HTTP2)) {
            this.path = '/';
        }
    }
    bind(_scope, options) {
        return {
            virtualNodeHealthCheck: {
                protocol: this.protocol,
                healthyThreshold: this.healthyThreshold,
                unhealthyThreshold: this.unhealthyThreshold,
                intervalMillis: this.interval.toMilliseconds(),
                timeoutMillis: this.timeout.toMilliseconds(),
                path: this.path,
                port: options.defaultPort,
            },
            virtualGatewayHealthCheck: {
                protocol: this.protocol,
                healthyThreshold: this.healthyThreshold,
                unhealthyThreshold: this.unhealthyThreshold,
                intervalMillis: this.interval.toMilliseconds(),
                timeoutMillis: this.timeout.toMilliseconds(),
                path: this.path,
                port: options.defaultPort,
            },
        };
    }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaGVhbHRoLWNoZWNrcy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImhlYWx0aC1jaGVja3MudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBQUEscUNBQXFDO0FBRXJDLDJEQUErQzs7Ozs7O0FBb0QvQyxNQUFzQixXQUFXOzs7Ozs7SUFFeEIsTUFBTSxDQUFDLElBQUksQ0FBQyxVQUFrQyxFQUFFOztRQUNyRCxPQUFPLElBQUksZUFBZSxDQUFDLDRCQUFRLENBQUMsSUFBSSxFQUFFLE9BQU8sQ0FBQyxnQkFBZ0IsRUFBRSxPQUFPLENBQUMsa0JBQWtCLEVBQUUsT0FBTyxDQUFDLFFBQVEsRUFBRSxPQUFPLENBQUMsT0FBTyxFQUFFLE9BQU8sQ0FBQyxJQUFJLENBQUMsQ0FBQztLQUNsSjs7Ozs7O0lBR00sTUFBTSxDQUFDLEtBQUssQ0FBQyxVQUFrQyxFQUFFOztRQUN0RCxPQUFPLElBQUksZUFBZSxDQUFDLDRCQUFRLENBQUMsS0FBSyxFQUFFLE9BQU8sQ0FBQyxnQkFBZ0IsRUFBRSxPQUFPLENBQUMsa0JBQWtCLEVBQUUsT0FBTyxDQUFDLFFBQVEsRUFBRSxPQUFPLENBQUMsT0FBTyxFQUFFLE9BQU8sQ0FBQyxJQUFJLENBQUMsQ0FBQztLQUNuSjs7Ozs7O0lBR00sTUFBTSxDQUFDLElBQUksQ0FBQyxVQUFrQyxFQUFFOztRQUNyRCxPQUFPLElBQUksZUFBZSxDQUFDLDRCQUFRLENBQUMsSUFBSSxFQUFFLE9BQU8sQ0FBQyxnQkFBZ0IsRUFBRSxPQUFPLENBQUMsa0JBQWtCLEVBQUUsT0FBTyxDQUFDLFFBQVEsRUFBRSxPQUFPLENBQUMsT0FBTyxDQUFDLENBQUM7S0FDcEk7Ozs7OztJQUdNLE1BQU0sQ0FBQyxHQUFHLENBQUMsVUFBaUMsRUFBRTs7UUFDbkQsT0FBTyxJQUFJLGVBQWUsQ0FBQyw0QkFBUSxDQUFDLEdBQUcsRUFBRSxPQUFPLENBQUMsZ0JBQWdCLEVBQUUsT0FBTyxDQUFDLGtCQUFrQixFQUFFLE9BQU8sQ0FBQyxRQUFRLEVBQUUsT0FBTyxDQUFDLE9BQU8sQ0FBQyxDQUFDO0tBQ25JOztBQW5CSCxrQ0F1QkM7OztBQUVELE1BQU0sZUFBZ0IsU0FBUSxXQUFXO0lBQ3ZDLFlBQ21CLFFBQWtCLEVBQ2xCLG1CQUEyQixDQUFDLEVBQzVCLHFCQUE2QixDQUFDLEVBQzlCLFdBQXlCLEdBQUcsQ0FBQyxRQUFRLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQyxFQUNoRCxVQUF3QixHQUFHLENBQUMsUUFBUSxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUMsRUFDL0MsSUFBYTtRQUM5QixLQUFLLEVBQUUsQ0FBQztRQU5TLGFBQVEsR0FBUixRQUFRLENBQVU7UUFDbEIscUJBQWdCLEdBQWhCLGdCQUFnQixDQUFZO1FBQzVCLHVCQUFrQixHQUFsQixrQkFBa0IsQ0FBWTtRQUM5QixhQUFRLEdBQVIsUUFBUSxDQUF3QztRQUNoRCxZQUFPLEdBQVAsT0FBTyxDQUF3QztRQUMvQyxTQUFJLEdBQUosSUFBSSxDQUFTO1FBRTlCLElBQUksZ0JBQWdCLEdBQUcsQ0FBQyxJQUFJLGdCQUFnQixHQUFHLEVBQUUsRUFBRTtZQUNqRCxNQUFNLElBQUksS0FBSyxDQUFDLDJDQUEyQyxDQUFDLENBQUM7U0FDOUQ7UUFFRCxJQUFJLGtCQUFrQixHQUFHLENBQUMsSUFBSSxrQkFBa0IsR0FBRyxFQUFFLEVBQUU7WUFDckQsTUFBTSxJQUFJLEtBQUssQ0FBQyw2Q0FBNkMsQ0FBQyxDQUFDO1NBQ2hFO1FBRUQsSUFBSSxRQUFRLENBQUMsY0FBYyxFQUFFLEdBQUcsSUFBSSxJQUFJLFFBQVEsQ0FBQyxjQUFjLEVBQUUsR0FBRyxNQUFPLEVBQUU7WUFDM0UsTUFBTSxJQUFJLEtBQUssQ0FBQyxvREFBb0QsQ0FBQyxDQUFDO1NBQ3ZFO1FBRUQsSUFBSSxPQUFPLENBQUMsY0FBYyxFQUFFLEdBQUcsSUFBSSxJQUFJLE9BQU8sQ0FBQyxjQUFjLEVBQUUsR0FBRyxLQUFNLEVBQUU7WUFDeEUsTUFBTSxJQUFJLEtBQUssQ0FBQyxrREFBa0QsQ0FBQyxDQUFDO1NBQ3JFO1FBRUQsc0NBQXNDO1FBQ3RDLElBQUksSUFBSSxLQUFLLFNBQVMsSUFBSSxDQUFDLFFBQVEsS0FBSyw0QkFBUSxDQUFDLElBQUksSUFBSSxRQUFRLEtBQUssNEJBQVEsQ0FBQyxLQUFLLENBQUMsRUFBRTtZQUNyRixJQUFJLENBQUMsSUFBSSxHQUFHLEdBQUcsQ0FBQztTQUNqQjtLQUNGO0lBRU0sSUFBSSxDQUFDLE1BQWlCLEVBQUUsT0FBK0I7UUFDNUQsT0FBTztZQUNMLHNCQUFzQixFQUFFO2dCQUN0QixRQUFRLEVBQUUsSUFBSSxDQUFDLFFBQVE7Z0JBQ3ZCLGdCQUFnQixFQUFFLElBQUksQ0FBQyxnQkFBZ0I7Z0JBQ3ZDLGtCQUFrQixFQUFFLElBQUksQ0FBQyxrQkFBa0I7Z0JBQzNDLGNBQWMsRUFBRSxJQUFJLENBQUMsUUFBUSxDQUFDLGNBQWMsRUFBRTtnQkFDOUMsYUFBYSxFQUFFLElBQUksQ0FBQyxPQUFPLENBQUMsY0FBYyxFQUFFO2dCQUM1QyxJQUFJLEVBQUUsSUFBSSxDQUFDLElBQUk7Z0JBQ2YsSUFBSSxFQUFFLE9BQU8sQ0FBQyxXQUFXO2FBQzFCO1lBQ0QseUJBQXlCLEVBQUU7Z0JBQ3pCLFFBQVEsRUFBRSxJQUFJLENBQUMsUUFBUTtnQkFDdkIsZ0JBQWdCLEVBQUUsSUFBSSxDQUFDLGdCQUFnQjtnQkFDdkMsa0JBQWtCLEVBQUUsSUFBSSxDQUFDLGtCQUFrQjtnQkFDM0MsY0FBYyxFQUFFLElBQUksQ0FBQyxRQUFRLENBQUMsY0FBYyxFQUFFO2dCQUM5QyxhQUFhLEVBQUUsSUFBSSxDQUFDLE9BQU8sQ0FBQyxjQUFjLEVBQUU7Z0JBQzVDLElBQUksRUFBRSxJQUFJLENBQUMsSUFBSTtnQkFDZixJQUFJLEVBQUUsT0FBTyxDQUFDLFdBQVc7YUFDMUI7U0FDRixDQUFDO0tBQ0g7Q0FFRiIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGNkayBmcm9tICdAYXdzLWNkay9jb3JlJztcbmltcG9ydCB7IENmblZpcnR1YWxHYXRld2F5LCBDZm5WaXJ0dWFsTm9kZSB9IGZyb20gJy4vYXBwbWVzaC5nZW5lcmF0ZWQnO1xuaW1wb3J0IHsgUHJvdG9jb2wgfSBmcm9tICcuL3NoYXJlZC1pbnRlcmZhY2VzJztcblxuLy8ga2VlcCB0aGlzIGltcG9ydCBzZXBhcmF0ZSBmcm9tIG90aGVyIGltcG9ydHMgdG8gcmVkdWNlIGNoYW5jZSBmb3IgbWVyZ2UgY29uZmxpY3RzIHdpdGggdjItbWFpblxuLy8gZXNsaW50LWRpc2FibGUtbmV4dC1saW5lIG5vLWR1cGxpY2F0ZS1pbXBvcnRzLCBpbXBvcnQvb3JkZXJcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ0Bhd3MtY2RrL2NvcmUnO1xuXG4vKipcbiAqIFByb3BlcnRpZXMgdXNlZCB0byBkZWZpbmUgaGVhbHRoY2hlY2tzLlxuICovXG5pbnRlcmZhY2UgSGVhbHRoQ2hlY2tDb21tb25PcHRpb25zIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgaGVhbHRoeVRocmVzaG9sZD86IG51bWJlcjtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGludGVydmFsPzogY2RrLkR1cmF0aW9uO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSB0aW1lb3V0PzogY2RrLkR1cmF0aW9uO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgdW5oZWFsdGh5VGhyZXNob2xkPzogbnVtYmVyO1xufVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgaW50ZXJmYWNlIEh0dHBIZWFsdGhDaGVja09wdGlvbnMgZXh0ZW5kcyBIZWFsdGhDaGVja0NvbW1vbk9wdGlvbnMge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBwYXRoPzogc3RyaW5nO1xufVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgaW50ZXJmYWNlIEdycGNIZWFsdGhDaGVja09wdGlvbnMgZXh0ZW5kcyBIZWFsdGhDaGVja0NvbW1vbk9wdGlvbnMgeyB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGludGVyZmFjZSBUY3BIZWFsdGhDaGVja09wdGlvbnMgZXh0ZW5kcyBIZWFsdGhDaGVja0NvbW1vbk9wdGlvbnMgeyB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgaW50ZXJmYWNlIEhlYWx0aENoZWNrQ29uZmlnIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSB2aXJ0dWFsTm9kZUhlYWx0aENoZWNrPzogQ2ZuVmlydHVhbE5vZGUuSGVhbHRoQ2hlY2tQcm9wZXJ0eTtcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IHZpcnR1YWxHYXRld2F5SGVhbHRoQ2hlY2s/OiBDZm5WaXJ0dWFsR2F0ZXdheS5WaXJ0dWFsR2F0ZXdheUhlYWx0aENoZWNrUG9saWN5UHJvcGVydHk7XG59XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGludGVyZmFjZSBIZWFsdGhDaGVja0JpbmRPcHRpb25zIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgZGVmYXVsdFBvcnQ/OiBudW1iZXI7XG59XG5cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgYWJzdHJhY3QgY2xhc3MgSGVhbHRoQ2hlY2sge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgc3RhdGljIGh0dHAob3B0aW9uczogSHR0cEhlYWx0aENoZWNrT3B0aW9ucyA9IHt9KTogSGVhbHRoQ2hlY2sge1xuICAgIHJldHVybiBuZXcgSGVhbHRoQ2hlY2tJbXBsKFByb3RvY29sLkhUVFAsIG9wdGlvbnMuaGVhbHRoeVRocmVzaG9sZCwgb3B0aW9ucy51bmhlYWx0aHlUaHJlc2hvbGQsIG9wdGlvbnMuaW50ZXJ2YWwsIG9wdGlvbnMudGltZW91dCwgb3B0aW9ucy5wYXRoKTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgc3RhdGljIGh0dHAyKG9wdGlvbnM6IEh0dHBIZWFsdGhDaGVja09wdGlvbnMgPSB7fSk6IEhlYWx0aENoZWNrIHtcbiAgICByZXR1cm4gbmV3IEhlYWx0aENoZWNrSW1wbChQcm90b2NvbC5IVFRQMiwgb3B0aW9ucy5oZWFsdGh5VGhyZXNob2xkLCBvcHRpb25zLnVuaGVhbHRoeVRocmVzaG9sZCwgb3B0aW9ucy5pbnRlcnZhbCwgb3B0aW9ucy50aW1lb3V0LCBvcHRpb25zLnBhdGgpO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHN0YXRpYyBncnBjKG9wdGlvbnM6IEdycGNIZWFsdGhDaGVja09wdGlvbnMgPSB7fSk6IEhlYWx0aENoZWNrIHtcbiAgICByZXR1cm4gbmV3IEhlYWx0aENoZWNrSW1wbChQcm90b2NvbC5HUlBDLCBvcHRpb25zLmhlYWx0aHlUaHJlc2hvbGQsIG9wdGlvbnMudW5oZWFsdGh5VGhyZXNob2xkLCBvcHRpb25zLmludGVydmFsLCBvcHRpb25zLnRpbWVvdXQpO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgc3RhdGljIHRjcChvcHRpb25zOiBUY3BIZWFsdGhDaGVja09wdGlvbnMgPSB7fSk6IEhlYWx0aENoZWNrIHtcbiAgICByZXR1cm4gbmV3IEhlYWx0aENoZWNrSW1wbChQcm90b2NvbC5UQ1AsIG9wdGlvbnMuaGVhbHRoeVRocmVzaG9sZCwgb3B0aW9ucy51bmhlYWx0aHlUaHJlc2hvbGQsIG9wdGlvbnMuaW50ZXJ2YWwsIG9wdGlvbnMudGltZW91dCk7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgYWJzdHJhY3QgYmluZChzY29wZTogQ29uc3RydWN0LCBvcHRpb25zOiBIZWFsdGhDaGVja0JpbmRPcHRpb25zKTogSGVhbHRoQ2hlY2tDb25maWc7XG59XG5cbmNsYXNzIEhlYWx0aENoZWNrSW1wbCBleHRlbmRzIEhlYWx0aENoZWNrIHtcbiAgY29uc3RydWN0b3IoXG4gICAgcHJpdmF0ZSByZWFkb25seSBwcm90b2NvbDogUHJvdG9jb2wsXG4gICAgcHJpdmF0ZSByZWFkb25seSBoZWFsdGh5VGhyZXNob2xkOiBudW1iZXIgPSAyLFxuICAgIHByaXZhdGUgcmVhZG9ubHkgdW5oZWFsdGh5VGhyZXNob2xkOiBudW1iZXIgPSAyLFxuICAgIHByaXZhdGUgcmVhZG9ubHkgaW50ZXJ2YWw6IGNkay5EdXJhdGlvbiA9IGNkay5EdXJhdGlvbi5zZWNvbmRzKDUpLFxuICAgIHByaXZhdGUgcmVhZG9ubHkgdGltZW91dDogY2RrLkR1cmF0aW9uID0gY2RrLkR1cmF0aW9uLnNlY29uZHMoMiksXG4gICAgcHJpdmF0ZSByZWFkb25seSBwYXRoPzogc3RyaW5nKSB7XG4gICAgc3VwZXIoKTtcbiAgICBpZiAoaGVhbHRoeVRocmVzaG9sZCA8IDIgfHwgaGVhbHRoeVRocmVzaG9sZCA+IDEwKSB7XG4gICAgICB0aHJvdyBuZXcgRXJyb3IoJ2hlYWx0aHlUaHJlc2hvbGQgbXVzdCBiZSBiZXR3ZWVuIDIgYW5kIDEwJyk7XG4gICAgfVxuXG4gICAgaWYgKHVuaGVhbHRoeVRocmVzaG9sZCA8IDIgfHwgdW5oZWFsdGh5VGhyZXNob2xkID4gMTApIHtcbiAgICAgIHRocm93IG5ldyBFcnJvcigndW5oZWFsdGh5VGhyZXNob2xkIG11c3QgYmUgYmV0d2VlbiAyIGFuZCAxMCcpO1xuICAgIH1cblxuICAgIGlmIChpbnRlcnZhbC50b01pbGxpc2Vjb25kcygpIDwgNTAwMCB8fCBpbnRlcnZhbC50b01pbGxpc2Vjb25kcygpID4gMzAwXzAwMCkge1xuICAgICAgdGhyb3cgbmV3IEVycm9yKCdpbnRlcnZhbCBtdXN0IGJlIGJldHdlZW4gNSBzZWNvbmRzIGFuZCAzMDAgc2Vjb25kcycpO1xuICAgIH1cblxuICAgIGlmICh0aW1lb3V0LnRvTWlsbGlzZWNvbmRzKCkgPCAyMDAwIHx8IHRpbWVvdXQudG9NaWxsaXNlY29uZHMoKSA+IDYwXzAwMCkge1xuICAgICAgdGhyb3cgbmV3IEVycm9yKCd0aW1lb3V0IG11c3QgYmUgYmV0d2VlbiAyIHNlY29uZHMgYW5kIDYwIHNlY29uZHMnKTtcbiAgICB9XG5cbiAgICAvLyBEZWZhdWx0IHRvIC8gZm9yIEhUVFAgSGVhbHRoIENoZWNrc1xuICAgIGlmIChwYXRoID09PSB1bmRlZmluZWQgJiYgKHByb3RvY29sID09PSBQcm90b2NvbC5IVFRQIHx8IHByb3RvY29sID09PSBQcm90b2NvbC5IVFRQMikpIHtcbiAgICAgIHRoaXMucGF0aCA9ICcvJztcbiAgICB9XG4gIH1cblxuICBwdWJsaWMgYmluZChfc2NvcGU6IENvbnN0cnVjdCwgb3B0aW9uczogSGVhbHRoQ2hlY2tCaW5kT3B0aW9ucyk6IEhlYWx0aENoZWNrQ29uZmlnIHtcbiAgICByZXR1cm4ge1xuICAgICAgdmlydHVhbE5vZGVIZWFsdGhDaGVjazoge1xuICAgICAgICBwcm90b2NvbDogdGhpcy5wcm90b2NvbCxcbiAgICAgICAgaGVhbHRoeVRocmVzaG9sZDogdGhpcy5oZWFsdGh5VGhyZXNob2xkLFxuICAgICAgICB1bmhlYWx0aHlUaHJlc2hvbGQ6IHRoaXMudW5oZWFsdGh5VGhyZXNob2xkLFxuICAgICAgICBpbnRlcnZhbE1pbGxpczogdGhpcy5pbnRlcnZhbC50b01pbGxpc2Vjb25kcygpLFxuICAgICAgICB0aW1lb3V0TWlsbGlzOiB0aGlzLnRpbWVvdXQudG9NaWxsaXNlY29uZHMoKSxcbiAgICAgICAgcGF0aDogdGhpcy5wYXRoLFxuICAgICAgICBwb3J0OiBvcHRpb25zLmRlZmF1bHRQb3J0LFxuICAgICAgfSxcbiAgICAgIHZpcnR1YWxHYXRld2F5SGVhbHRoQ2hlY2s6IHtcbiAgICAgICAgcHJvdG9jb2w6IHRoaXMucHJvdG9jb2wsXG4gICAgICAgIGhlYWx0aHlUaHJlc2hvbGQ6IHRoaXMuaGVhbHRoeVRocmVzaG9sZCxcbiAgICAgICAgdW5oZWFsdGh5VGhyZXNob2xkOiB0aGlzLnVuaGVhbHRoeVRocmVzaG9sZCxcbiAgICAgICAgaW50ZXJ2YWxNaWxsaXM6IHRoaXMuaW50ZXJ2YWwudG9NaWxsaXNlY29uZHMoKSxcbiAgICAgICAgdGltZW91dE1pbGxpczogdGhpcy50aW1lb3V0LnRvTWlsbGlzZWNvbmRzKCksXG4gICAgICAgIHBhdGg6IHRoaXMucGF0aCxcbiAgICAgICAgcG9ydDogb3B0aW9ucy5kZWZhdWx0UG9ydCxcbiAgICAgIH0sXG4gICAgfTtcbiAgfVxuXG59XG4iXX0=