# keynote-parser

<a href="https://travis-ci.org/psobot/keynote-parser"><img src="https://travis-ci.com/psobot/keynote-parser.svg?branch=master" alt="build:" /></a>

`keynote-parser` is a Python module for unpacking and re-packing
[Apple Keynote](https://www.apple.com/keynote/) `.key` files. It supports Keynote
files generated by Keynote version 12.1 (current as of September 2022).

Keynote uses a proprietary, compressed binary format to store its presentations.
This format is comprised of a zip file containing images and videos, as well as
[Snappy](https://github.com/google/snappy)-compressed
[Protobuf](https://github.com/protocolbuffers/protobuf) `.iwa` files containing
metadata, text, and all other definitions used in the presentation.

`keynote-parser` unpacks these component files into `.yaml` files in a directory,
making them editable by text editors and/or scripts, then allows re-packing of these
files into a working Keynote archive.

What could you use this for? Well, I use it to allow versioning of Keynote files in Git,
which makes diffs more understandable (rather than binary), as well as modifying text
in Keynote files in response to external scripts.
(e.g.: figures that update from databases before giving a presentation)

## Installation

```bash
pip3 install keynote-parser
```

## Usage

```bash
# Unpack MyPresentation.key into ./MyPresentation/
keynote-parser unpack MyPresentation.key

# Re-pack ./MyPresentation/ into MyPresentation.out.key
keynote-parser pack ./MyPresentation/

# List the files within a Keynote archive
keynote-parser ls MyPresentation.key

# Dump a particular .iwa file into its yaml representation on stdout
keynote-parser cat MyPresentation.key /Index/Slide-00001.iwa

# Replace text within a Keynote file in-place
keynote-parser replace MyPresentation.key --find "hello world" --replace "hello dolly"
```

### Formats

`keynote-parser` supports reading a list of replacements from a JSON file passed in
as `--replacements`. This file must have the form:

```json
{
  "replacements": [
    {
      "find": "regexp to search for",
      "replace": "string to replace with"
    },
    ...
  ]
}
```

This argument can be passed to `keynote-parser replace` to replace text in a Keynote
file in-place. It can also be passed to `keynote-parser pack` to pack a directory
into a Keynote file, replacing text along the way.

#### Replacing Images

The `replacements` json format can also be used to replace images in a Keynote file.
To do so:

* Use the `keynote-parser ls` command to determine the name of the image to replace.
* Set the `find` pattern to the image's name, with the `-\d\d\d` suffix removed.
* Set the `replace` field to the local path to the replacement image.

`keynote-parser` will automatically rescale the replacement image to fit all of the
sizes of the target image.

### Compatibility

Note that between Keynote 10.2 and Keynote 11.2, a number of Protobuf definitions
used by Keynote have changed names. `keynote-parser` does not yet support
backwards compatibility: it can only read `.key` files as the
currently-supported Keynote version would, and will write `.yaml` output with
keys that match the current names of the keys. This means that **`.yaml` files
generated with older versions of `keynote-parser` may not be readable by with
v1.11.2.1 or higher of `keynote-parser`**.

Until this issue is fixed (_if_ it's ever fixed) - to properly read `.yaml` files
created by older versions of `keynote-parser`:
 - use an older version of `keynote-parser` to read the file
 - write a `.key` (or `.iwa`) file with that older version
 - upgrade `keynote-parser`
 - read that resulting `.iwa` file in the newer version of `keynote-parser`

## Updates

As `keynote-parser` includes Protobuf definitions extracted from a copy of Keynote,
new versions of Keynote will inevitably create `.key` files that cannot be read by `keynote-parser`.
As new versions of Keynote are released, updates to `keynote-parser` can be made automatically
by running the following on a macOS machine with Keynote installed:

```shell
# protobuf>=3.20.0rc1 must be installed, with the C++ runtime
# on Intel, this can be done with "pip install 'protobuf>=3.20.0rc1'"
# on Apple Silicon, this may require a manual build from source
cd dumper
make clean
make
```

## Troubleshooting

### Unable to complete installation due to snappy-c.h not found.

```bash
snappy/snappymodule.cc:31:10: fatal error: 'snappy-c.h' file not found
```

This means you're missing the Snappy libraries. Install Snappy via whatever method your OS supports. e.g. `brew install snappy`, `sudo apt-get install libsnappy-dev`, etc.

## Credits

`keynote-parser` was built by [Peter Sobot](https://petersobot.com) but heavily based on [prior
work](https://github.com/obriensp/iWorkFileFormat/blob/master/Docs/index.md) by [Sean Patrick O'Brien](http://www.obriensp.com).
A copy of O'Brien's format documentation is included in the `docs` folder for posterity.

## License

All code in this repository is licensed under the MIT License.

```
Copyright 2019-2022 Peter Sobot

Permission is hereby granted, free of charge, to any person obtaining a copy of this software
and associated documentation files (the "Software"), to deal in the Software without restriction,
including without limitation the rights to use, copy, modify, merge, publish, distribute,
sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or
substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
```
