/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.pgsnapshot.v0_6.impl;

import java.util.ArrayList;
import java.util.logging.Logger;
import org.openstreetmap.osmosis.core.container.v0_6.BoundContainerIterator;
import org.openstreetmap.osmosis.core.container.v0_6.DatasetContext;
import org.openstreetmap.osmosis.core.container.v0_6.EntityContainer;
import org.openstreetmap.osmosis.core.container.v0_6.EntityManager;
import org.openstreetmap.osmosis.core.container.v0_6.NodeContainerIterator;
import org.openstreetmap.osmosis.core.container.v0_6.RelationContainerIterator;
import org.openstreetmap.osmosis.core.container.v0_6.WayContainerIterator;
import org.openstreetmap.osmosis.core.database.DatabaseLoginCredentials;
import org.openstreetmap.osmosis.core.database.DatabasePreferences;
import org.openstreetmap.osmosis.core.domain.v0_6.Bound;
import org.openstreetmap.osmosis.core.domain.v0_6.Node;
import org.openstreetmap.osmosis.core.domain.v0_6.Relation;
import org.openstreetmap.osmosis.core.domain.v0_6.Way;
import org.openstreetmap.osmosis.core.lifecycle.ReleasableIterator;
import org.openstreetmap.osmosis.core.store.MultipleSourceIterator;
import org.openstreetmap.osmosis.core.store.ReleasableAdaptorForIterator;
import org.openstreetmap.osmosis.core.store.UpcastIterator;
import org.openstreetmap.osmosis.pgsnapshot.common.DatabaseContext;
import org.openstreetmap.osmosis.pgsnapshot.common.PolygonBuilder;
import org.openstreetmap.osmosis.pgsnapshot.common.SchemaVersionValidator;
import org.openstreetmap.osmosis.pgsnapshot.v0_6.impl.ActionDao;
import org.openstreetmap.osmosis.pgsnapshot.v0_6.impl.DatabaseCapabilityChecker;
import org.openstreetmap.osmosis.pgsnapshot.v0_6.impl.NodeDao;
import org.openstreetmap.osmosis.pgsnapshot.v0_6.impl.PostgreSqlEntityManager;
import org.openstreetmap.osmosis.pgsnapshot.v0_6.impl.RelationDao;
import org.openstreetmap.osmosis.pgsnapshot.v0_6.impl.UserDao;
import org.openstreetmap.osmosis.pgsnapshot.v0_6.impl.WayDao;
import org.postgis.Geometry;
import org.postgis.PGgeometry;
import org.postgis.Point;
import org.postgis.Polygon;
import org.springframework.jdbc.core.JdbcTemplate;

public class PostgreSqlDatasetContext
implements DatasetContext {
    private static final Logger LOG = Logger.getLogger(PostgreSqlDatasetContext.class.getName());
    private DatabaseLoginCredentials loginCredentials;
    private DatabasePreferences preferences;
    private DatabaseCapabilityChecker capabilityChecker;
    private boolean initialized;
    private DatabaseContext dbCtx;
    private JdbcTemplate jdbcTemplate;
    private UserDao userDao;
    private NodeDao nodeDao;
    private WayDao wayDao;
    private RelationDao relationDao;
    private PostgreSqlEntityManager<Node> nodeManager;
    private PostgreSqlEntityManager<Way> wayManager;
    private PostgreSqlEntityManager<Relation> relationManager;
    private PolygonBuilder polygonBuilder;
    private boolean logging;

    public PostgreSqlDatasetContext(DatabaseLoginCredentials loginCredentials, DatabasePreferences preferences, boolean logging) {
        this.loginCredentials = loginCredentials;
        this.preferences = preferences;
        this.polygonBuilder = new PolygonBuilder();
        this.initialized = false;
        this.logging = logging;
    }

    private void initialize() {
        if (this.dbCtx == null) {
            this.dbCtx = new DatabaseContext(this.loginCredentials);
            this.jdbcTemplate = this.dbCtx.getJdbcTemplate();
            this.dbCtx.beginTransaction();
            new SchemaVersionValidator(this.jdbcTemplate, this.preferences).validateVersion(6);
            this.capabilityChecker = new DatabaseCapabilityChecker(this.dbCtx);
            ActionDao actionDao = new ActionDao(this.dbCtx);
            this.userDao = new UserDao(this.dbCtx, actionDao);
            this.nodeDao = new NodeDao(this.dbCtx, actionDao, this.logging);
            this.wayDao = new WayDao(this.dbCtx, actionDao, this.logging);
            this.relationDao = new RelationDao(this.dbCtx, actionDao, this.logging);
            this.nodeManager = new PostgreSqlEntityManager<Node>(this.nodeDao, this.userDao);
            this.wayManager = new PostgreSqlEntityManager<Way>(this.wayDao, this.userDao);
            this.relationManager = new PostgreSqlEntityManager<Relation>(this.relationDao, this.userDao);
        }
        this.initialized = true;
    }

    @Deprecated
    public Node getNode(long id) {
        return (Node)this.getNodeManager().getEntity(id);
    }

    @Deprecated
    public Way getWay(long id) {
        return (Way)this.getWayManager().getEntity(id);
    }

    @Deprecated
    public Relation getRelation(long id) {
        return (Relation)this.getRelationManager().getEntity(id);
    }

    public EntityManager<Node> getNodeManager() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.nodeManager;
    }

    public EntityManager<Way> getWayManager() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.wayManager;
    }

    public EntityManager<Relation> getRelationManager() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.relationManager;
    }

    public ReleasableIterator<EntityContainer> iterate() {
        if (!this.initialized) {
            this.initialize();
        }
        ArrayList<Bound> bounds = new ArrayList<Bound>();
        bounds.add(new Bound("Osmosis 0.48.3"));
        ArrayList<UpcastIterator> sources = new ArrayList<UpcastIterator>();
        sources.add(new UpcastIterator((ReleasableIterator)new BoundContainerIterator((ReleasableIterator)new ReleasableAdaptorForIterator(bounds.iterator()))));
        sources.add(new UpcastIterator((ReleasableIterator)new NodeContainerIterator(this.nodeDao.iterate())));
        sources.add(new UpcastIterator((ReleasableIterator)new WayContainerIterator(this.wayDao.iterate())));
        sources.add(new UpcastIterator((ReleasableIterator)new RelationContainerIterator(this.relationDao.iterate())));
        return new MultipleSourceIterator(sources);
    }

    public ReleasableIterator<EntityContainer> iterateBoundingBox(double left, double right, double top, double bottom, boolean completeWays) {
        if (!this.initialized) {
            this.initialize();
        }
        ArrayList<Bound> bounds = new ArrayList<Bound>();
        bounds.add(new Bound(right, left, top, bottom, "Osmosis 0.48.3"));
        this.jdbcTemplate.update("SET enable_seqscan = false");
        this.jdbcTemplate.update("SET enable_mergejoin = false");
        this.jdbcTemplate.update("SET enable_hashjoin = false");
        Point[] bboxPoints = new Point[]{new Point(left, bottom), new Point(left, top), new Point(right, top), new Point(right, bottom), new Point(left, bottom)};
        Polygon bboxPolygon = this.polygonBuilder.createPolygon(bboxPoints);
        LOG.finer("Selecting all nodes inside bounding box.");
        int rowCount = this.jdbcTemplate.update("CREATE TEMPORARY TABLE bbox_nodes ON COMMIT DROP AS SELECT * FROM nodes WHERE (geom && ?)", new Object[]{new PGgeometry((Geometry)bboxPolygon)});
        LOG.finer("Adding a primary key to the temporary nodes table.");
        this.jdbcTemplate.update("ALTER TABLE ONLY bbox_nodes ADD CONSTRAINT pk_bbox_nodes PRIMARY KEY (id)");
        LOG.finer("Updating query analyzer statistics on the temporary nodes table.");
        this.jdbcTemplate.update("ANALYZE bbox_nodes");
        if (this.capabilityChecker.isWayLinestringSupported()) {
            LOG.finer("Selecting all ways inside bounding box using way linestring geometry.");
            rowCount = this.jdbcTemplate.update("CREATE TEMPORARY TABLE bbox_ways ON COMMIT DROP AS SELECT * FROM ways WHERE (linestring && ?)", new Object[]{new PGgeometry((Geometry)bboxPolygon)});
        } else if (this.capabilityChecker.isWayBboxSupported()) {
            LOG.finer("Selecting all ways inside bounding box using dynamically built way linestring with way bbox indexing.");
            rowCount = this.jdbcTemplate.update("CREATE TEMPORARY TABLE bbox_ways ON COMMIT DROP AS SELECT w.* FROM (SELECT c.id AS id, First(c.version) AS version, First(c.user_id) AS user_id, First(c.tstamp) AS tstamp, First(c.changeset_id) AS changeset_id, First(c.tags) AS tags, First(c.nodes) AS nodes, ST_MakeLine(c.geom) AS way_line FROM (SELECT w.*, n.geom AS geom FROM nodes n INNER JOIN way_nodes wn ON n.id = wn.node_id INNER JOIN ways w ON wn.way_id = w.id WHERE (w.bbox && ?) ORDER BY wn.way_id, wn.sequence_id) c GROUP BY c.id) w WHERE (w.way_line && ?)", new Object[]{new PGgeometry((Geometry)bboxPolygon), new PGgeometry((Geometry)bboxPolygon)});
        } else {
            LOG.finer("Selecting all way ids inside bounding box using already selected nodes.");
            rowCount = this.jdbcTemplate.update("CREATE TEMPORARY TABLE bbox_ways ON COMMIT DROP AS SELECT w.* FROM ways w INNER JOIN ( SELECT wn.way_id FROM way_nodes wn INNER JOIN bbox_nodes n ON wn.node_id = n.id GROUP BY wn.way_id) wids ON w.id = wids.way_id");
        }
        LOG.finer(rowCount + " rows affected.");
        LOG.finer("Adding a primary key to the temporary ways table.");
        this.jdbcTemplate.update("ALTER TABLE ONLY bbox_ways ADD CONSTRAINT pk_bbox_ways PRIMARY KEY (id)");
        LOG.finer("Updating query analyzer statistics on the temporary ways table.");
        this.jdbcTemplate.update("ANALYZE bbox_ways");
        LOG.finer("Selecting all relation ids containing selected nodes or ways.");
        rowCount = this.jdbcTemplate.update("CREATE TEMPORARY TABLE bbox_relations ON COMMIT DROP AS SELECT r.* FROM relations r INNER JOIN (    SELECT relation_id FROM (        SELECT rm.relation_id AS relation_id FROM relation_members rm        INNER JOIN bbox_nodes n ON rm.member_id = n.id WHERE rm.member_type = 'N'         UNION         SELECT rm.relation_id AS relation_id FROM relation_members rm        INNER JOIN bbox_ways w ON rm.member_id = w.id WHERE rm.member_type = 'W'     ) rids GROUP BY relation_id) rids ON r.id = rids.relation_id");
        LOG.finer(rowCount + " rows affected.");
        LOG.finer("Adding a primary key to the temporary relations table.");
        this.jdbcTemplate.update("ALTER TABLE ONLY bbox_relations ADD CONSTRAINT pk_bbox_relations PRIMARY KEY (id)");
        LOG.finer("Updating query analyzer statistics on the temporary relations table.");
        this.jdbcTemplate.update("ANALYZE bbox_relations");
        do {
            LOG.finer("Selecting parent relations of selected relations.");
            rowCount = this.jdbcTemplate.update("INSERT INTO bbox_relations SELECT r.* FROM relations r INNER JOIN (    SELECT rm.relation_id FROM relation_members rm    INNER JOIN bbox_relations br ON rm.member_id = br.id    WHERE rm.member_type = 'R' AND NOT EXISTS (        SELECT * FROM bbox_relations br2 WHERE rm.relation_id = br2.id    ) GROUP BY rm.relation_id) rids ON r.id = rids.relation_id");
            LOG.finer(rowCount + " rows affected.");
        } while (rowCount > 0);
        LOG.finer("Updating query analyzer statistics on the temporary relations table.");
        this.jdbcTemplate.update("ANALYZE bbox_relations");
        if (completeWays) {
            LOG.finer("Selecting all nodes for selected ways.");
            this.jdbcTemplate.update("CREATE TEMPORARY TABLE bbox_way_nodes (id bigint) ON COMMIT DROP");
            this.jdbcTemplate.queryForList("SELECT unnest_bbox_way_nodes()");
            this.jdbcTemplate.update("CREATE TEMPORARY TABLE bbox_missing_way_nodes ON COMMIT DROP AS SELECT buwn.id FROM (SELECT DISTINCT bwn.id FROM bbox_way_nodes bwn) buwn WHERE NOT EXISTS (    SELECT * FROM bbox_nodes WHERE id = buwn.id);");
            this.jdbcTemplate.update("ALTER TABLE ONLY bbox_missing_way_nodes ADD CONSTRAINT pk_bbox_missing_way_nodes PRIMARY KEY (id)");
            this.jdbcTemplate.update("ANALYZE bbox_missing_way_nodes");
            rowCount = this.jdbcTemplate.update("INSERT INTO bbox_nodes SELECT n.* FROM nodes n INNER JOIN bbox_missing_way_nodes bwn ON n.id = bwn.id;");
            LOG.finer(rowCount + " rows affected.");
        }
        LOG.finer("Updating query analyzer statistics on the temporary nodes table.");
        this.jdbcTemplate.update("ANALYZE bbox_nodes");
        LOG.finer("Iterating over results.");
        ArrayList<UpcastIterator> resultSets = new ArrayList<UpcastIterator>();
        resultSets.add(new UpcastIterator((ReleasableIterator)new BoundContainerIterator((ReleasableIterator)new ReleasableAdaptorForIterator(bounds.iterator()))));
        resultSets.add(new UpcastIterator((ReleasableIterator)new NodeContainerIterator(this.nodeDao.iterate("bbox_"))));
        resultSets.add(new UpcastIterator((ReleasableIterator)new WayContainerIterator(this.wayDao.iterate("bbox_"))));
        resultSets.add(new UpcastIterator((ReleasableIterator)new RelationContainerIterator(this.relationDao.iterate("bbox_"))));
        return new MultipleSourceIterator(resultSets);
    }

    public void complete() {
        this.dbCtx.commitTransaction();
    }

    public void close() {
        if (this.dbCtx != null) {
            this.dbCtx.close();
            this.dbCtx = null;
        }
    }
}

