/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin.registry.xml;

import java.net.URL;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.java.plugin.PathResolver;
import org.java.plugin.registry.Extension;
import org.java.plugin.registry.ExtensionPoint;
import org.java.plugin.registry.Identity;
import org.java.plugin.registry.IntegrityCheckReport;
import org.java.plugin.registry.Library;
import org.java.plugin.registry.PluginDescriptor;
import org.java.plugin.registry.PluginPrerequisite;
import org.java.plugin.registry.xml.ExtensionImpl;
import org.java.plugin.registry.xml.ExtensionPointImpl;
import org.java.plugin.registry.xml.LibraryImpl;
import org.java.plugin.registry.xml.PluginDescriptorImpl;
import org.java.plugin.registry.xml.PluginPrerequisiteImpl;
import org.java.plugin.registry.xml.PluginRegistryImpl;
import org.java.plugin.util.IoUtil;
import org.java.plugin.util.ResourceManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class IntegrityChecker
implements IntegrityCheckReport {
    private static Log log = LogFactory.getLog(IntegrityChecker.class);
    private final PluginRegistryImpl registry;
    private List<IntegrityCheckReport.ReportItem> items = new LinkedList<IntegrityCheckReport.ReportItem>();
    private int errorsCount;
    private int warningsCount;

    IntegrityChecker(PluginRegistryImpl aRegistry, Collection<IntegrityCheckReport.ReportItem> anItems) {
        this.registry = aRegistry;
        for (IntegrityCheckReport.ReportItem item : anItems) {
            switch (item.getSeverity()) {
                case ERROR: {
                    break;
                }
                case WARNING: {
                    ++this.warningsCount;
                    break;
                }
            }
            this.items.add(item);
        }
    }

    void doCheck(PathResolver pathResolver) {
        int count = 0;
        this.items.add(new ReportItemImpl(IntegrityCheckReport.Severity.INFO, null, IntegrityCheckReport.Error.NO_ERROR, "pluginsCheckStart", null));
        try {
            for (PluginDescriptor descriptor : this.registry.getPluginDescriptors()) {
                PluginDescriptorImpl descr = (PluginDescriptorImpl)descriptor;
                ++count;
                this.items.add(new ReportItemImpl(IntegrityCheckReport.Severity.INFO, descr, IntegrityCheckReport.Error.NO_ERROR, "pluginCheckStart", descr.getUniqueId()));
                this.checkPlugin(descr, pathResolver);
                this.items.add(new ReportItemImpl(IntegrityCheckReport.Severity.INFO, descr, IntegrityCheckReport.Error.NO_ERROR, "pluginCheckFinish", descr.getUniqueId()));
            }
        }
        catch (Exception e) {
            log.error("integrity check failed for registry " + this.registry, e);
            ++this.errorsCount;
            this.items.add(new ReportItemImpl(IntegrityCheckReport.Severity.ERROR, null, IntegrityCheckReport.Error.CHECKER_FAULT, "pluginsCheckError", e));
        }
        this.items.add(new ReportItemImpl(IntegrityCheckReport.Severity.INFO, null, IntegrityCheckReport.Error.NO_ERROR, "pluginsCheckFinish", count));
    }

    private void checkPlugin(PluginDescriptorImpl descr, PathResolver pathResolver) {
        int count = 0;
        this.items.add(new ReportItemImpl(IntegrityCheckReport.Severity.INFO, descr, IntegrityCheckReport.Error.NO_ERROR, "prerequisitesCheckStart", descr.getUniqueId()));
        for (PluginPrerequisite prerequisite : descr.getPrerequisites()) {
            PluginPrerequisiteImpl pre = (PluginPrerequisiteImpl)prerequisite;
            ++count;
            if (pre.isOptional() || pre.matches()) continue;
            ++this.errorsCount;
            this.items.add(new ReportItemImpl(IntegrityCheckReport.Severity.ERROR, descr, IntegrityCheckReport.Error.UNSATISFIED_PREREQUISITE, "unsatisfiedPrerequisite", new Object[]{pre.getPluginId(), descr.getUniqueId()}));
        }
        this.items.add(new ReportItemImpl(IntegrityCheckReport.Severity.INFO, descr, IntegrityCheckReport.Error.NO_ERROR, "prerequisitesCheckFinish", new Object[]{count, descr.getUniqueId()}));
        if (pathResolver != null) {
            count = 0;
            this.items.add(new ReportItemImpl(IntegrityCheckReport.Severity.INFO, descr, IntegrityCheckReport.Error.NO_ERROR, "librariesCheckStart", descr.getUniqueId()));
            for (Library library : descr.getLibraries()) {
                LibraryImpl lib = (LibraryImpl)library;
                ++count;
                URL url = pathResolver.resolvePath(lib, lib.getPath());
                if (IoUtil.isResourceExists(url)) continue;
                ++this.errorsCount;
                this.items.add(new ReportItemImpl(IntegrityCheckReport.Severity.ERROR, lib, IntegrityCheckReport.Error.BAD_LIBRARY, "accesToResourceFailed", new Object[]{lib.getUniqueId(), descr.getUniqueId(), url}));
            }
            this.items.add(new ReportItemImpl(IntegrityCheckReport.Severity.INFO, descr, IntegrityCheckReport.Error.NO_ERROR, "librariesCheckFinish", new Object[]{count, descr.getUniqueId()}));
        } else {
            this.items.add(new ReportItemImpl(IntegrityCheckReport.Severity.INFO, descr, IntegrityCheckReport.Error.NO_ERROR, "librariesCheckSkip", descr.getUniqueId()));
        }
        count = 0;
        this.items.add(new ReportItemImpl(IntegrityCheckReport.Severity.INFO, descr, IntegrityCheckReport.Error.NO_ERROR, "extPointsCheckStart", null));
        for (ExtensionPoint extensionPoint : descr.getExtensionPoints()) {
            ++count;
            ExtensionPointImpl extPoint = (ExtensionPointImpl)extensionPoint;
            this.items.add(new ReportItemImpl(IntegrityCheckReport.Severity.INFO, extPoint, IntegrityCheckReport.Error.NO_ERROR, "extPointCheckStart", extPoint.getUniqueId()));
            Collection<IntegrityCheckReport.ReportItem> extPointItems = extPoint.validate();
            for (IntegrityCheckReport.ReportItem item : extPointItems) {
                switch (item.getSeverity()) {
                    case ERROR: {
                        ++this.errorsCount;
                        break;
                    }
                    case WARNING: {
                        ++this.warningsCount;
                        break;
                    }
                }
                this.items.add(item);
            }
            this.items.add(new ReportItemImpl(IntegrityCheckReport.Severity.INFO, extPoint, IntegrityCheckReport.Error.NO_ERROR, "extPointCheckFinish", extPoint.getUniqueId()));
        }
        this.items.add(new ReportItemImpl(IntegrityCheckReport.Severity.INFO, descr, IntegrityCheckReport.Error.NO_ERROR, "extPointsCheckFinish", new Object[]{count, descr.getUniqueId()}));
        count = 0;
        this.items.add(new ReportItemImpl(IntegrityCheckReport.Severity.INFO, descr, IntegrityCheckReport.Error.NO_ERROR, "extsCheckStart", null));
        for (Extension extension : descr.getExtensions()) {
            ++count;
            ExtensionImpl ext = (ExtensionImpl)extension;
            this.items.add(new ReportItemImpl(IntegrityCheckReport.Severity.INFO, ext, IntegrityCheckReport.Error.NO_ERROR, "extCheckStart", ext.getUniqueId()));
            Collection<IntegrityCheckReport.ReportItem> extItems = ext.validate();
            for (IntegrityCheckReport.ReportItem item : extItems) {
                switch (item.getSeverity()) {
                    case ERROR: {
                        ++this.errorsCount;
                        break;
                    }
                    case WARNING: {
                        ++this.warningsCount;
                        break;
                    }
                }
                this.items.add(item);
            }
            this.items.add(new ReportItemImpl(IntegrityCheckReport.Severity.INFO, ext, IntegrityCheckReport.Error.NO_ERROR, "extCheckFinish", ext.getUniqueId()));
        }
        this.items.add(new ReportItemImpl(IntegrityCheckReport.Severity.INFO, descr, IntegrityCheckReport.Error.NO_ERROR, "extsCheckFinish", new Object[]{count, descr.getUniqueId()}));
    }

    @Override
    public int countErrors() {
        return this.errorsCount;
    }

    @Override
    public int countWarnings() {
        return this.warningsCount;
    }

    @Override
    public Collection<IntegrityCheckReport.ReportItem> getItems() {
        return this.items;
    }

    static class ReportItemImpl
    implements IntegrityCheckReport.ReportItem {
        private final IntegrityCheckReport.Severity severity;
        private final Identity source;
        private final IntegrityCheckReport.Error code;
        private final String msg;
        private final Object data;

        ReportItemImpl(IntegrityCheckReport.Severity aSeverity, Identity aSource, IntegrityCheckReport.Error aCode, String aMsg, Object aData) {
            this.severity = aSeverity;
            this.source = aSource;
            this.code = aCode;
            this.msg = aMsg;
            this.data = aData;
        }

        public IntegrityCheckReport.Error getCode() {
            return this.code;
        }

        public String getMessage() {
            return ResourceManager.getMessage("org.java.plugin.registry.xml", this.msg, this.data);
        }

        public String getMessage(Locale locale) {
            return ResourceManager.getMessage("org.java.plugin.registry.xml", this.msg, locale, this.data);
        }

        public IntegrityCheckReport.Severity getSeverity() {
            return this.severity;
        }

        public Identity getSource() {
            return this.source;
        }
    }
}

