/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.tagtransform.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;
import org.openstreetmap.osmosis.tagtransform.Match;
import org.openstreetmap.osmosis.tagtransform.Matcher;
import org.openstreetmap.osmosis.tagtransform.TTEntityType;
import org.openstreetmap.osmosis.tagtransform.impl.MatchResultMatch;

public class TagMatcher
implements Matcher {
    private String matchID;
    private Pattern keyPattern;
    private Pattern valuePattern;
    private long matchHits = 0L;

    public TagMatcher(String matchID, String keyPattern, String valuePattern) {
        this.matchID = matchID;
        this.keyPattern = Pattern.compile(keyPattern);
        this.valuePattern = Pattern.compile(valuePattern);
    }

    @Override
    public Collection<Match> match(Map<String, String> tags, TTEntityType type, String uname, int uid) {
        ArrayList<Match> matches = new ArrayList<Match>();
        for (Map.Entry<String, String> tag : tags.entrySet()) {
            java.util.regex.Matcher keyMatch = this.keyPattern.matcher(tag.getKey());
            java.util.regex.Matcher valueMatch = this.valuePattern.matcher(tag.getValue());
            if (!keyMatch.matches() || !valueMatch.matches()) continue;
            MatchResult keyRes = keyMatch.toMatchResult();
            MatchResult valueRes = valueMatch.toMatchResult();
            matches.add(new MatchResultMatch(this.matchID, keyRes, valueRes));
        }
        this.matchHits += (long)matches.size();
        return matches;
    }

    @Override
    public void outputStats(StringBuilder output, String indent) {
        output.append(indent);
        output.append("Tag[");
        if (this.matchID != null) {
            output.append(this.matchID);
            output.append(",");
        }
        output.append(this.keyPattern.pattern());
        output.append(",");
        output.append(this.valuePattern.pattern());
        output.append("]: ");
        output.append(this.matchHits);
        output.append('\n');
    }
}

