/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.tagtransform.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.csv.QuoteMode;
import org.openstreetmap.osmosis.tagtransform.DataSource;
import org.w3c.dom.NamedNodeMap;

public class DataSourceCSV
implements DataSource {
    private Map<String, String[]> data = Collections.emptyMap();
    private String[] fallback;

    public DataSourceCSV(File parentDirectory, NamedNodeMap attributes) {
        String file = attributes.getNamedItem("file").getTextContent();
        String csvFormat = attributes.getNamedItem("csvFormat").getTextContent();
        List lookupIndices = Stream.of(attributes.getNamedItem("lookup").getTextContent().split(",")).map(idx -> Integer.parseInt(idx)).collect(Collectors.toList());
        List returnIndices = Stream.of(attributes.getNamedItem("return").getTextContent().split(",")).map(idx -> Integer.parseInt(idx)).collect(Collectors.toList());
        try (InputStreamReader fis = new InputStreamReader(new FileInputStream(new File(parentDirectory, file)));){
            CSVRecord fallbackRecord = (CSVRecord)CSVParser.parse((String)attributes.getNamedItem("fallback").getTextContent(), (CSVFormat)CSVFormat.newFormat((char)',').withDelimiter(',').withQuote('\"').withQuoteMode(QuoteMode.MINIMAL)).iterator().next();
            this.fallback = new String[fallbackRecord.size()];
            for (int i = 0; i < this.fallback.length; ++i) {
                this.fallback[i] = fallbackRecord.get(i);
            }
            CSVParser parser = CSVParser.parse((Reader)fis, (CSVFormat)CSVFormat.valueOf((String)csvFormat));
            this.data = parser.getRecords().stream().collect(Collectors.toMap(r -> lookupIndices.stream().map(i -> r.get(i.intValue())).collect(Collectors.joining("\u0000")), r -> (String[])returnIndices.stream().map(i -> r.get(i.intValue())).toArray(String[]::new)));
        }
        catch (IOException ex) {
            Logger.getLogger(DataSourceCSV.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public String[] transform(String[] matches) {
        return this.data.getOrDefault(String.join((CharSequence)"\u0000", matches), this.fallback);
    }
}

