/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.writer.util;

import java.util.Comparator;
import java.util.PriorityQueue;
import java.util.logging.Logger;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateFilter;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public class PolyLabel {
    private static final Logger LOGGER = Logger.getLogger(PolyLabel.class.getName());
    private static final double PRECISION = 1.1920928955078125E-7;
    private static final double SQRT2 = Math.sqrt(2.0);

    public static Point get(Geometry geometry) {
        Polygon polygon;
        if (geometry instanceof LineString) {
            polygon = geometry.getFactory().createPolygon(geometry.getCoordinates());
        } else if (geometry instanceof MultiPolygon) {
            Geometry widestGeometry = geometry.getGeometryN(0);
            for (int i = 1; i < geometry.getNumGeometries(); ++i) {
                if (!(geometry.getGeometryN(i).getEnvelopeInternal().getWidth() > widestGeometry.getEnvelopeInternal().getWidth())) continue;
                widestGeometry = geometry.getGeometryN(i);
            }
            polygon = (Polygon)widestGeometry;
        } else if (geometry instanceof Polygon) {
            polygon = (Polygon)geometry;
        } else {
            LOGGER.warning("Failed to get label for geometry: " + geometry);
            return geometry.getCentroid();
        }
        polygon = (Polygon)polygon.clone();
        polygon.apply(new CoordinateFilter(){

            @Override
            public void filter(Coordinate c) {
                c.x = PolyLabel.longitudeToX(c.x);
                c.y = PolyLabel.latitudeToY(c.y);
            }
        });
        polygon.geometryChanged();
        Envelope envelope = polygon.getEnvelopeInternal();
        double width = envelope.getWidth();
        double height = envelope.getHeight();
        double cellSize = Math.min(width, height);
        double h2 = cellSize / 2.0;
        PriorityQueue<Cell> cellQueue = new PriorityQueue<Cell>(1, new MaxComparator());
        for (double x = envelope.getMinX(); x < envelope.getMaxX(); x += cellSize) {
            for (double y = envelope.getMinY(); y < envelope.getMaxY(); y += cellSize) {
                cellQueue.add(new Cell(x + h2, y + h2, h2, polygon));
            }
        }
        Cell bestCell = PolyLabel.getCentroidCell(polygon);
        Cell bboxCell = new Cell(envelope.centre().x, envelope.centre().y, 0.0, polygon);
        if (bboxCell.d > bestCell.d) {
            bestCell = bboxCell;
        }
        while (!cellQueue.isEmpty()) {
            Cell cell = (Cell)cellQueue.remove();
            if (cell.d > bestCell.d) {
                bestCell = cell;
            }
            if (cell.max - bestCell.d <= 1.1920928955078125E-7) continue;
            h2 = cell.h / 2.0;
            cellQueue.add(new Cell(cell.x - h2, cell.y - h2, h2, polygon));
            cellQueue.add(new Cell(cell.x + h2, cell.y - h2, h2, polygon));
            cellQueue.add(new Cell(cell.x - h2, cell.y + h2, h2, polygon));
            cellQueue.add(new Cell(cell.x + h2, cell.y + h2, h2, polygon));
        }
        return geometry.getFactory().createPoint(new Coordinate(PolyLabel.toLongitude(bestCell.x), PolyLabel.toLatitude(bestCell.y)));
    }

    private static float pointToPolygonDist(double x, double y, Polygon polygon) {
        boolean inside = false;
        double minDistSq = Double.POSITIVE_INFINITY;
        LineString exterior = polygon.getExteriorRing();
        int i = 0;
        int n = exterior.getNumPoints() - 1;
        int j = n - 1;
        while (i < n) {
            Coordinate a = exterior.getCoordinateN(i);
            Coordinate b = exterior.getCoordinateN(j);
            if (a.y > y ^ b.y > y && x < (b.x - a.x) * (y - a.y) / (b.y - a.y) + a.x) {
                inside = !inside;
            }
            double seqDistSq = PolyLabel.getSegDistSq(x, y, a, b);
            minDistSq = Math.min(minDistSq, seqDistSq);
            j = i++;
        }
        for (int k = 0; k < polygon.getNumInteriorRing(); ++k) {
            LineString interior = polygon.getInteriorRingN(k);
            int i2 = 0;
            int n2 = interior.getNumPoints() - 1;
            int j2 = n2 - 1;
            while (i2 < n2) {
                Coordinate a = interior.getCoordinateN(i2);
                Coordinate b = interior.getCoordinateN(j2);
                if (a.y > y ^ b.y > y && x < (b.x - a.x) * (y - a.y) / (b.y - a.y) + a.x) {
                    inside = !inside;
                }
                minDistSq = Math.min(minDistSq, PolyLabel.getSegDistSq(x, y, a, b));
                j2 = i2++;
            }
        }
        return (float)((double)(inside ? 1 : -1) * Math.sqrt(minDistSq));
    }

    private static Cell getCentroidCell(Polygon polygon) {
        double area = 0.0;
        double x = 0.0;
        double y = 0.0;
        LineString exterior = polygon.getExteriorRing();
        int i = 0;
        int n = exterior.getNumPoints() - 1;
        int j = n - 1;
        while (i < n) {
            Coordinate a = exterior.getCoordinateN(i);
            Coordinate b = exterior.getCoordinateN(j);
            double f = a.x * b.y - b.x * a.y;
            x += (a.x + b.x) * f;
            y += (a.y + b.y) * f;
            area += f * 3.0;
            j = i++;
        }
        return new Cell(x / area, y / area, 0.0, polygon);
    }

    private static double getSegDistSq(double px, double py, Coordinate a, Coordinate b) {
        double x = a.x;
        double y = a.y;
        double dx = b.x - x;
        double dy = b.y - y;
        if (dx != 0.0 || dy != 0.0) {
            double t = ((px - x) * dx + (py - y) * dy) / (dx * dx + dy * dy);
            if (t > 1.0) {
                x = b.x;
                y = b.y;
            } else if (t > 0.0) {
                x += dx * t;
                y += dy * t;
            }
        }
        dx = px - x;
        dy = py - y;
        return dx * dx + dy * dy;
    }

    private static double latitudeToY(double latitude) {
        double sinLatitude = Math.sin(latitude * (Math.PI / 180));
        return 0.5 - Math.log((1.0 + sinLatitude) / (1.0 - sinLatitude)) / (Math.PI * 4);
    }

    private static double longitudeToX(double longitude) {
        return (longitude + 180.0) / 360.0;
    }

    private static double toLatitude(double y) {
        return 90.0 - 360.0 * Math.atan(Math.exp((y - 0.5) * (Math.PI * 2))) / Math.PI;
    }

    private static double toLongitude(double x) {
        return 360.0 * (x - 0.5);
    }

    private static class Cell {
        final double x;
        final double y;
        final double h;
        final double d;
        final double max;

        Cell(double x, double y, double h2, Polygon polygon) {
            this.x = x;
            this.y = y;
            this.h = h2;
            this.d = PolyLabel.pointToPolygonDist(x, y, polygon);
            this.max = this.d + this.h * SQRT2;
        }
    }

    private static class MaxComparator
    implements Comparator<Cell> {
        private MaxComparator() {
        }

        @Override
        public int compare(Cell a, Cell b) {
            return Double.compare(b.max, a.max);
        }
    }
}

