/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.writer.util;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mapsforge.map.writer.OSMTagMapping;
import org.mapsforge.map.writer.model.OSMTag;
import org.mapsforge.map.writer.model.SpecialTagExtractionResult;
import org.mapsforge.map.writer.util.ColorsCSS;
import org.openstreetmap.osmosis.core.domain.v0_6.Entity;
import org.openstreetmap.osmosis.core.domain.v0_6.Tag;
import org.openstreetmap.osmosis.core.domain.v0_6.Way;

public final class OSMUtils {
    private static final Logger LOGGER = Logger.getLogger(OSMUtils.class.getName());
    private static final int MAX_ELEVATION = 9000;
    private static final Pattern COLOR_PATTERN = Pattern.compile("#([A-Fa-f0-9]{6})");
    private static final Pattern DIGIT_PATTERN = Pattern.compile("-?\\d+(\\.\\d+)?");
    private static final Pattern NAME_LANGUAGE_PATTERN = Pattern.compile("(name)(:)([a-zA-Z]{1,3}(?:[-_][a-zA-Z0-9]{1,8})*)");
    private static int nBytes;
    private static int nFloats;
    private static int nIntegers;
    private static int nShorts;
    private static int nStrings;

    public static Map<Short, Object> extractKnownPOITags(Entity entity) {
        HashMap<Short, Object> tagMap = new HashMap<Short, Object>();
        OSMTagMapping mapping = OSMTagMapping.getInstance();
        if (entity.getTags() != null) {
            for (Tag tag : entity.getTags()) {
                OSMTag poiTag = mapping.getPoiTag(tag.getKey(), tag.getValue());
                if (poiTag == null) continue;
                String wildcard = poiTag.getValue();
                tagMap.put(poiTag.getId(), OSMUtils.getObjectFromWildcardAndValue(wildcard, tag.getValue()));
            }
        }
        return tagMap;
    }

    public static Map<Short, Object> extractKnownWayTags(Entity entity) {
        HashMap<Short, Object> tagMap = new HashMap<Short, Object>();
        OSMTagMapping mapping = OSMTagMapping.getInstance();
        if (entity.getTags() != null) {
            for (Tag tag : entity.getTags()) {
                OSMTag wayTag = mapping.getWayTag(tag.getKey(), tag.getValue());
                if (wayTag == null) continue;
                String wildcard = wayTag.getValue();
                tagMap.put(wayTag.getId(), OSMUtils.getObjectFromWildcardAndValue(wildcard, tag.getValue()));
            }
        }
        return tagMap;
    }

    public static SpecialTagExtractionResult extractSpecialFields(Entity entity, List<String> preferredLanguages) {
        Object name = null;
        String ref = null;
        String housenumber = null;
        byte layer = 5;
        short elevation = 0;
        String relationType = null;
        if (entity.getTags() != null) {
            if (preferredLanguages != null && preferredLanguages.size() > 1) {
                ArrayList tags = new ArrayList(entity.getTags());
                Collections.sort(tags);
                Object defaultName = null;
                ArrayList<String> restPreferredLanguages = new ArrayList<String>(preferredLanguages);
                for (Object tag : tags) {
                    String language;
                    String key = tag.getKey().toLowerCase(Locale.ENGLISH);
                    if ("name".equals(key)) {
                        name = defaultName = tag.getValue();
                        continue;
                    }
                    Matcher matcher = NAME_LANGUAGE_PATTERN.matcher(key);
                    if (!matcher.matches() || tag.getValue().equals(defaultName) || !preferredLanguages.contains(language = matcher.group(3).toLowerCase(Locale.ENGLISH).replace('_', '-'))) continue;
                    restPreferredLanguages.remove(language);
                    name = (name != null ? (String)name + '\r' : "") + language + '\b' + tag.getValue();
                }
                if (!restPreferredLanguages.isEmpty()) {
                    HashMap<String, String> fallbacks = new HashMap<String, String>();
                    for (String preferredLanguage : restPreferredLanguages) {
                        for (Tag tag : tags) {
                            String language;
                            String key = tag.getKey().toLowerCase(Locale.ENGLISH);
                            Matcher matcher = NAME_LANGUAGE_PATTERN.matcher(key);
                            if (!matcher.matches() || tag.getValue().equals(defaultName) || fallbacks.containsKey(language = matcher.group(3).toLowerCase(Locale.ENGLISH).replace('_', '-')) || language.contains("-") || !preferredLanguage.contains("-") && !preferredLanguage.contains("_") || !preferredLanguage.toLowerCase(Locale.ENGLISH).startsWith(language)) continue;
                            fallbacks.put(language, tag.getValue());
                        }
                    }
                    for (String language : fallbacks.keySet()) {
                        name = (name != null ? (String)name + '\r' : "") + language + '\b' + (String)fallbacks.get(language);
                    }
                }
            } else {
                boolean foundPreferredLanguageName = false;
                for (Tag tag : entity.getTags()) {
                    Matcher matcher;
                    String language;
                    String key = tag.getKey().toLowerCase(Locale.ENGLISH);
                    if ("name".equals(key) && !foundPreferredLanguageName) {
                        name = tag.getValue();
                        continue;
                    }
                    if (preferredLanguages == null || foundPreferredLanguageName || !(matcher = NAME_LANGUAGE_PATTERN.matcher(key)).matches() || !(language = matcher.group(3)).equalsIgnoreCase(preferredLanguages.get(0))) continue;
                    name = tag.getValue();
                    foundPreferredLanguageName = true;
                }
            }
            for (Tag tag : entity.getTags()) {
                String key = tag.getKey().toLowerCase(Locale.ENGLISH);
                if ("piste:name".equals(key) && name == null) {
                    name = tag.getValue();
                    continue;
                }
                if ("addr:housenumber".equals(key)) {
                    housenumber = tag.getValue();
                    continue;
                }
                if ("ref".equals(key)) {
                    ref = tag.getValue();
                    continue;
                }
                if ("layer".equals(key)) {
                    String l = tag.getValue();
                    try {
                        byte testLayer = Byte.parseByte(l);
                        if (testLayer >= -5 && testLayer <= 5) {
                            testLayer = (byte)(testLayer + 5);
                        }
                        layer = testLayer;
                    }
                    catch (NumberFormatException e) {
                        LOGGER.finest("could not parse layer information to byte type: " + tag.getValue() + "\t entity-id: " + entity.getId() + "\tentity-type: " + entity.getType().name());
                    }
                    continue;
                }
                if ("ele".equals(key)) {
                    Double floatElevation = OSMUtils.parseDoubleUnit(tag.getValue());
                    if (floatElevation != null) {
                        if (!(floatElevation < 9000.0)) continue;
                        elevation = floatElevation.shortValue();
                        continue;
                    }
                    LOGGER.finest("could not parse elevation information to double type: " + tag.getValue() + "\t entity-id: " + entity.getId() + "\tentity-type: " + entity.getType().name());
                    continue;
                }
                if (!"type".equals(key)) continue;
                relationType = tag.getValue();
            }
        }
        return new SpecialTagExtractionResult((String)name, ref, housenumber, layer, elevation, relationType);
    }

    public static Byte getByteValue(String value) {
        ++nBytes;
        return OSMUtils.parseDoubleUnit(value).byteValue();
    }

    public static Float getFloatValue(String value) {
        ++nFloats;
        return Float.valueOf(OSMUtils.parseDoubleUnit(value).floatValue());
    }

    public static Integer getIntegerValue(String value) {
        Integer integer;
        ++nIntegers;
        if (Character.isLetter(value.charAt(0)) && (integer = ColorsCSS.get(value)) != null) {
            LOGGER.finest("ColorNam: #" + Integer.toHexString(integer));
            return integer;
        }
        Matcher matcher = COLOR_PATTERN.matcher(value);
        if (matcher.matches()) {
            try {
                integer = Color.decode(value).getRGB();
                LOGGER.finest("ColorHex: #" + Integer.toHexString(integer));
            }
            catch (NumberFormatException e) {
                integer = 0;
                LOGGER.warning("Color conversion failed: " + value + "\n" + e.getMessage());
            }
        } else {
            integer = OSMUtils.parseDoubleUnit(value).intValue();
        }
        return integer;
    }

    public static Object getObjectFromWildcardAndValue(String wildcard, String value) {
        if (wildcard.length() == 2 && wildcard.charAt(0) == '%') {
            Character format = Character.valueOf(wildcard.charAt(1));
            if (format.charValue() == 'b') {
                return OSMUtils.getByteValue(value);
            }
            if (format.charValue() == 'i') {
                return OSMUtils.getIntegerValue(value);
            }
            if (format.charValue() == 'f') {
                return OSMUtils.getFloatValue(value);
            }
            if (format.charValue() == 'h') {
                return OSMUtils.getShortValue(value);
            }
            if (format.charValue() == 's') {
                return OSMUtils.getStringValue(value);
            }
        }
        return null;
    }

    public static Short getShortValue(String value) {
        ++nShorts;
        return OSMUtils.parseDoubleUnit(value).shortValue();
    }

    public static String getStringValue(String value) {
        ++nStrings;
        return value;
    }

    public static String getValueType(String key, String value) {
        Matcher matcher;
        Double f = OSMUtils.parseDoubleUnit(value);
        if (f != null) {
            if ((double)Math.round(f) == f) {
                if ((double)f.byteValue() == f) {
                    return "%b";
                }
                if ((double)f.shortValue() == f) {
                    return "%h";
                }
                return "%i";
            }
            return "%f";
        }
        if (key.contains("colour") && ((matcher = COLOR_PATTERN.matcher(value)).matches() || ColorsCSS.get(value) != null)) {
            return "%i";
        }
        return "%s";
    }

    public static boolean isArea(Way way) {
        boolean result = true;
        if (way.getTags() != null) {
            for (Tag tag : way.getTags()) {
                String key = tag.getKey().toLowerCase(Locale.ENGLISH);
                String value = tag.getValue().toLowerCase(Locale.ENGLISH);
                if ("area".equals(key)) {
                    if ("yes".equals(value) || "y".equals(value) || "true".equals(value)) {
                        return true;
                    }
                    if ("no".equals(value) || "n".equals(value) || "false".equals(value)) {
                        return false;
                    }
                }
                if ("aeroway".equals(key) || "building".equals(key) || "landuse".equals(key) || "leisure".equals(key) || "natural".equals(key) || "amenity".equals(key)) {
                    return true;
                }
                if ("highway".equals(key) || "barrier".equals(key)) {
                    result = false;
                }
                if (!"railway".equals(key) || !"rail".equals(value) && !"tram".equals(value) && !"subway".equals(value) && !"monorail".equals(value) && !"narrow_gauge".equals(value) && !"preserved".equals(value) && !"light_rail".equals(value) && !"construction".equals(value)) continue;
                result = false;
            }
        }
        return result;
    }

    public static String logValueTypeCount() {
        return "Bytes:\t" + nBytes + "\nShorts:\t" + nShorts + "\nIntegers:\t" + nIntegers + "\nFloats:\t" + nFloats + "\nStrings:\t" + nStrings;
    }

    public static Double parseDoubleUnit(String value) {
        value = value.replaceAll("m", "").replaceAll(",", ".");
        Matcher matcher = DIGIT_PATTERN.matcher(value);
        Double res = null;
        if (matcher.matches()) {
            try {
                res = Double.parseDouble(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return res;
    }

    public static String tagsToString(Map<Short, Object> tagMap, boolean isWay) {
        OSMTagMapping mapping = OSMTagMapping.getInstance();
        StringBuilder sb = new StringBuilder("<id,k=v,v>[");
        for (Map.Entry<Short, Object> tag : tagMap.entrySet()) {
            sb.append("[");
            sb.append(tag.getKey());
            sb.append(", ");
            sb.append(isWay ? mapping.getWayTag(tag.getKey()).tagKey() : mapping.getPoiTag(tag.getKey()).tagKey());
            sb.append(", ");
            sb.append(tag.getValue());
            sb.append("],");
        }
        sb.append("]");
        return sb.toString();
    }

    private OSMUtils() {
    }

    static {
        nStrings = 0;
    }
}

