/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.writer.osmosis;

import org.mapsforge.map.writer.model.MapWriterConfiguration;
import org.mapsforge.map.writer.osmosis.MapFileWriterTask;
import org.openstreetmap.osmosis.core.pipeline.common.TaskConfiguration;
import org.openstreetmap.osmosis.core.pipeline.common.TaskManager;
import org.openstreetmap.osmosis.core.pipeline.common.TaskManagerFactory;
import org.openstreetmap.osmosis.core.pipeline.v0_6.SinkManager;
import org.openstreetmap.osmosis.core.task.v0_6.Sink;

class MapFileWriterFactory
extends TaskManagerFactory {
    private static final String PARAM_BBOX = "bbox";
    private static final String PARAM_BBOX_ENLARGEMENT = "bbox-enlargement";
    private static final String PARAM_COMMENT = "comment";
    private static final String PARAM_DEBUG_INFO = "debug-file";
    private static final String PARAM_ENCODING = "encoding";
    private static final String PARAM_LABEL_POSITION = "label-position";
    private static final String PARAM_MAP_START_POSITION = "map-start-position";
    private static final String PARAM_MAP_START_ZOOM = "map-start-zoom";
    private static final String PARAM_OUTFILE = "file";
    private static final String PARAM_POLYGON_CLIPPING = "polygon-clipping";
    private static final String PARAM_POLYLABEL = "polylabel";
    private static final String PARAM_PREFERRED_LANGUAGES = "preferred-languages";
    private static final String PARAM_PROGRESS_LOGS = "progress-logs";
    private static final String PARAM_SIMPLIFICATION_FACTOR = "simplification-factor";
    private static final String PARAM_SIMPLIFICATION_MAX_ZOOM = "simplification-max-zoom";
    private static final String PARAM_SKIP_INVALID_RELATIONS = "skip-invalid-relations";
    private static final String PARAM_TAG_MAPPING_FILE = "tag-conf-file";
    private static final String PARAM_TAG_VALUES = "tag-values";
    private static final String PARAM_THREADS = "threads";
    private static final String PARAM_TYPE = "type";
    private static final String PARAM_WAY_CLIPPING = "way-clipping";
    private static final String PARAM_ZOOMINTERVAL_CONFIG = "zoom-interval-conf";

    MapFileWriterFactory() {
    }

    protected TaskManager createTaskManagerImpl(TaskConfiguration taskConfig) {
        MapWriterConfiguration configuration = new MapWriterConfiguration();
        configuration.addOutputFile(this.getStringArgument(taskConfig, PARAM_OUTFILE, "mapsforge.map"));
        configuration.setTagValues(this.getBooleanArgument(taskConfig, PARAM_TAG_VALUES, false));
        configuration.loadTagMappingFile(this.getStringArgument(taskConfig, PARAM_TAG_MAPPING_FILE, null));
        configuration.addMapStartPosition(this.getStringArgument(taskConfig, PARAM_MAP_START_POSITION, null));
        configuration.addMapStartZoom(this.getStringArgument(taskConfig, PARAM_MAP_START_ZOOM, null));
        configuration.addBboxConfiguration(this.getStringArgument(taskConfig, PARAM_BBOX, null));
        configuration.addZoomIntervalConfiguration(this.getStringArgument(taskConfig, PARAM_ZOOMINTERVAL_CONFIG, null));
        configuration.setComment(this.getStringArgument(taskConfig, PARAM_COMMENT, null));
        configuration.setDebugStrings(this.getBooleanArgument(taskConfig, PARAM_DEBUG_INFO, false));
        configuration.setPolygonClipping(this.getBooleanArgument(taskConfig, PARAM_POLYGON_CLIPPING, true));
        configuration.setPolylabel(this.getBooleanArgument(taskConfig, PARAM_POLYLABEL, false));
        configuration.setProgressLogs(this.getBooleanArgument(taskConfig, PARAM_PROGRESS_LOGS, true));
        configuration.setWayClipping(this.getBooleanArgument(taskConfig, PARAM_WAY_CLIPPING, true));
        configuration.setLabelPosition(this.getBooleanArgument(taskConfig, PARAM_LABEL_POSITION, false));
        configuration.setSimplification(this.getDoubleArgument(taskConfig, PARAM_SIMPLIFICATION_FACTOR, 2.5));
        configuration.setSimplificationMaxZoom((byte)this.getIntegerArgument(taskConfig, PARAM_SIMPLIFICATION_MAX_ZOOM, 12));
        configuration.setSkipInvalidRelations(this.getBooleanArgument(taskConfig, PARAM_SKIP_INVALID_RELATIONS, false));
        configuration.setDataProcessorType(this.getStringArgument(taskConfig, PARAM_TYPE, "ram"));
        configuration.setBboxEnlargement(this.getIntegerArgument(taskConfig, PARAM_BBOX_ENLARGEMENT, 20));
        configuration.addPreferredLanguages(this.getStringArgument(taskConfig, PARAM_PREFERRED_LANGUAGES, null));
        configuration.addEncodingChoice(this.getStringArgument(taskConfig, PARAM_ENCODING, "auto"));
        configuration.setThreads(this.getIntegerArgument(taskConfig, PARAM_THREADS, 1));
        configuration.validate();
        MapFileWriterTask task = new MapFileWriterTask(configuration);
        return new SinkManager(taskConfig.getId(), (Sink)task, taskConfig.getPipeArgs());
    }
}

