/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.writer.model;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.BitSet;
import java.util.List;
import java.util.logging.Logger;
import org.mapsforge.map.writer.model.TileCoordinate;

public final class TileInfo {
    public static final byte TILE_INFO_ZOOMLEVEL = 12;
    private static final byte BITMASK = 3;
    private static final Logger LOGGER = Logger.getLogger(TileInfo.class.getName());
    private static final int N_BITS = 0x1000000;
    private static final int N_BYTES = 0x400000;
    private static final String OCEAN_TILES_FILE = "oceantiles_12.dat";
    private static final byte SEA = 2;
    private final BitSet seaTileInfo = new BitSet(0x1000000);

    public static TileInfo getInstance() {
        return new TileInfo(OCEAN_TILES_FILE);
    }

    private TileInfo(String strInputFile) {
        try {
            DataInputStream dis = new DataInputStream(TileInfo.class.getClassLoader().getResourceAsStream(strInputFile));
            long start = System.currentTimeMillis();
            for (int i = 0; i < 0x400000; ++i) {
                byte currentByte = dis.readByte();
                if ((currentByte >> 6 & 3) == 2) {
                    this.seaTileInfo.set(i * 4);
                }
                if ((currentByte >> 4 & 3) == 2) {
                    this.seaTileInfo.set(i * 4 + 1);
                }
                if ((currentByte >> 2 & 3) == 2) {
                    this.seaTileInfo.set(i * 4 + 2);
                }
                if ((currentByte & 3) != 2) continue;
                this.seaTileInfo.set(i * 4 + 3);
            }
            LOGGER.fine("loading of tile info data took " + (System.currentTimeMillis() - start) + " ms");
        }
        catch (IOException e) {
            LOGGER.severe("error loading tile info from file " + strInputFile);
        }
    }

    public boolean isWaterTile(TileCoordinate tc) {
        List<TileCoordinate> tiles = tc.translateToZoomLevel((byte)12);
        for (TileCoordinate tile : tiles) {
            if (this.seaTileInfo.get(tile.getY() * 4096 + tile.getX())) continue;
            return false;
        }
        return true;
    }
}

