/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.writer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mapsforge.map.writer.model.TDNode;
import org.mapsforge.map.writer.model.TDWay;
import org.mapsforge.map.writer.model.TileData;

public class RAMTileData
extends TileData {
    private final Set<TDNode> pois = new HashSet<TDNode>();
    private final Set<TDWay> ways = new HashSet<TDWay>();

    RAMTileData() {
    }

    @Override
    public final void addPOI(TDNode poi) {
        this.pois.add(poi);
    }

    @Override
    public final void addWay(TDWay way) {
        this.ways.add(way);
    }

    @Override
    public final Map<Byte, List<TDNode>> poisByZoomlevel(byte minValidZoomlevel, byte maxValidZoomlevel) {
        HashMap<Byte, List<TDNode>> poisByZoomlevel = new HashMap<Byte, List<TDNode>>();
        for (TDNode poi : this.pois) {
            List<TDNode> group;
            byte zoomlevel = poi.getZoomAppear();
            if (zoomlevel > maxValidZoomlevel) continue;
            if (zoomlevel < minValidZoomlevel) {
                zoomlevel = minValidZoomlevel;
            }
            if ((group = poisByZoomlevel.get(zoomlevel)) == null) {
                group = new ArrayList<TDNode>();
            }
            group.add(poi);
            poisByZoomlevel.put(zoomlevel, group);
        }
        return poisByZoomlevel;
    }

    @Override
    public final Map<Byte, List<TDWay>> waysByZoomlevel(byte minValidZoomlevel, byte maxValidZoomlevel) {
        HashMap<Byte, List<TDWay>> waysByZoomlevel = new HashMap<Byte, List<TDWay>>();
        for (TDWay way : this.ways) {
            List<TDWay> group;
            byte zoomlevel = way.getMinimumZoomLevel();
            if (zoomlevel > maxValidZoomlevel) continue;
            if (zoomlevel < minValidZoomlevel) {
                zoomlevel = minValidZoomlevel;
            }
            if ((group = waysByZoomlevel.get(zoomlevel)) == null) {
                group = new ArrayList<TDWay>();
            }
            group.add(way);
            waysByZoomlevel.put(zoomlevel, group);
        }
        return waysByZoomlevel;
    }
}

