/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.replication.v0_6;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.merge.common.ConflictResolutionMethod;
import org.openstreetmap.osmosis.core.pipeline.common.TaskRunner;
import org.openstreetmap.osmosis.core.task.v0_6.ChangeSink;
import org.openstreetmap.osmosis.core.task.v0_6.RunnableChangeSource;
import org.openstreetmap.osmosis.core.time.DateParser;
import org.openstreetmap.osmosis.core.util.FileBasedLock;
import org.openstreetmap.osmosis.replication.common.TimestampTracker;
import org.openstreetmap.osmosis.replication.v0_6.impl.ChangesetFileNameFormatter;
import org.openstreetmap.osmosis.replication.v0_6.impl.IntervalDownloaderConfiguration;
import org.openstreetmap.osmosis.set.v0_6.ChangeMerger;
import org.openstreetmap.osmosis.xml.common.CompressionMethod;
import org.openstreetmap.osmosis.xml.v0_6.XmlChangeReader;

public class IntervalDownloader
implements RunnableChangeSource {
    private static final Logger LOG = Logger.getLogger(IntervalDownloader.class.getName());
    private static final String LOCK_FILE = "download.lock";
    private static final String CONFIG_FILE = "configuration.txt";
    private static final String TSTAMP_FILE = "timestamp.txt";
    private static final String TSTAMP_NEW_FILE = "timestamp-new.txt";
    private static final String SERVER_TSTAMP_FILE = "timestamp.txt";
    private ChangeSink changeSink;
    private String taskId;
    private File workingDirectory;
    private DateParser dateParser;

    public IntervalDownloader(String taskId, File workingDirectory) {
        this.taskId = taskId;
        this.workingDirectory = workingDirectory;
        this.dateParser = new DateParser();
    }

    public void setChangeSink(ChangeSink changeSink) {
        this.changeSink = changeSink;
    }

    private Date getServerTimestamp(URL baseUrl) {
        URL timestampUrl;
        try {
            timestampUrl = new URL(baseUrl, "timestamp.txt");
        }
        catch (MalformedURLException e) {
            throw new OsmosisRuntimeException("The server timestamp URL could not be created.", (Throwable)e);
        }
        try {
            Date result;
            URLConnection connection = timestampUrl.openConnection();
            connection.setReadTimeout(900000);
            connection.setConnectTimeout(900000);
            connection.setRequestProperty("User-Agent", "Osmosis/0.48.3");
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
                result = this.dateParser.parse(reader.readLine());
            }
            return result;
        }
        catch (IOException e) {
            throw new OsmosisRuntimeException("Unable to read the timestamp from the server.", (Throwable)e);
        }
    }

    private File downloadChangesetFile(String fileName, URL baseUrl) {
        URL changesetUrl;
        try {
            changesetUrl = new URL(baseUrl, fileName);
        }
        catch (MalformedURLException e) {
            throw new OsmosisRuntimeException("The server file URL could not be created.", (Throwable)e);
        }
        try {
            File outputFile;
            URLConnection connection = changesetUrl.openConnection();
            connection.setReadTimeout(900000);
            connection.setConnectTimeout(900000);
            try (BufferedInputStream source = new BufferedInputStream(connection.getInputStream(), 65536);){
                outputFile = File.createTempFile("change", null);
                try (BufferedOutputStream sink = new BufferedOutputStream(new FileOutputStream(outputFile), 65536);){
                    byte[] buffer = new byte[65536];
                    int bytesRead = source.read(buffer);
                    while (bytesRead > 0) {
                        sink.write(buffer, 0, bytesRead);
                        bytesRead = source.read(buffer);
                    }
                }
            }
            return outputFile;
        }
        catch (IOException e) {
            throw new OsmosisRuntimeException("Unable to read the changeset file " + fileName + " from the server.", (Throwable)e);
        }
    }

    private void download() {
        boolean tasksSuccessful;
        URL baseUrl;
        IntervalDownloaderConfiguration configuration = new IntervalDownloaderConfiguration(new File(this.workingDirectory, CONFIG_FILE));
        TimestampTracker timestampTracker = new TimestampTracker(new File(this.workingDirectory, "timestamp.txt"), new File(this.workingDirectory, TSTAMP_NEW_FILE));
        ChangesetFileNameFormatter fileNameFormatter = new ChangesetFileNameFormatter(configuration.getChangeFileBeginFormat(), configuration.getChangeFileEndFormat());
        try {
            baseUrl = new URL(configuration.getBaseUrl());
        }
        catch (MalformedURLException e) {
            throw new OsmosisRuntimeException("Unable to convert URL string (" + configuration.getBaseUrl() + ") into a URL.", (Throwable)e);
        }
        ArrayList<File> tmpFileList = new ArrayList<File>();
        Object currentTime = timestampTracker.getTime();
        Date maximumTime = this.getServerTimestamp(baseUrl);
        int maxDownloadCount = configuration.getMaxDownloadCount();
        for (int downloadCount = 0; (maxDownloadCount == 0 || downloadCount < maxDownloadCount) && ((Date)currentTime).before(maximumTime); ++downloadCount) {
            Date nextTime = new Date(((Date)currentTime).getTime() + (long)configuration.getIntervalLength());
            String downloadFileName = fileNameFormatter.generateFileName((Date)currentTime, nextTime);
            tmpFileList.add(this.downloadChangesetFile(downloadFileName, baseUrl));
            currentTime = nextTime;
        }
        ArrayList<Object> tasks = new ArrayList<Object>();
        for (File tmpFile : tmpFileList) {
            XmlChangeReader changeReader = new XmlChangeReader(tmpFile, true, CompressionMethod.GZip);
            if (tasks.size() > 0) {
                ChangeMerger changeMerger = new ChangeMerger(ConflictResolutionMethod.LatestSource, 10);
                ((RunnableChangeSource)tasks.get(tasks.size() - 1)).setChangeSink(changeMerger.getChangeSink(0));
                changeReader.setChangeSink(changeMerger.getChangeSink(1));
                tasks.add(changeReader);
                tasks.add(changeMerger);
                continue;
            }
            tasks.add(changeReader);
        }
        if (tasks.size() > 0) {
            TaskRunner taskRunner;
            int i;
            ((RunnableChangeSource)tasks.get(tasks.size() - 1)).setChangeSink(this.changeSink);
            ArrayList<TaskRunner> taskRunners = new ArrayList<TaskRunner>(tasks.size());
            for (i = 0; i < tasks.size(); ++i) {
                taskRunners.add(new TaskRunner((Runnable)tasks.get(i), "Thread-" + this.taskId + "-worker" + i));
            }
            for (i = 0; i < taskRunners.size(); ++i) {
                taskRunner = (TaskRunner)taskRunners.get(i);
                LOG.fine("Launching changeset worker + " + i + " in a new thread.");
                taskRunner.start();
            }
            tasksSuccessful = true;
            for (i = 0; i < taskRunners.size(); ++i) {
                taskRunner = (TaskRunner)taskRunners.get(i);
                LOG.fine("Waiting for changeset worker " + i + " to complete.");
                try {
                    taskRunner.join();
                }
                catch (InterruptedException e) {
                    LOG.log(Level.WARNING, "The wait for task completion was interrupted.", e);
                }
                if (taskRunner.isSuccessful()) continue;
                LOG.log(Level.SEVERE, "Changeset worker " + i + " failed", taskRunner.getException());
                tasksSuccessful = false;
            }
        } else {
            this.changeSink.complete();
            tasksSuccessful = true;
        }
        for (File tmpFile : tmpFileList) {
            if (tmpFile.delete()) continue;
            LOG.warning("Unable to delete file " + tmpFile.getName());
        }
        if (!tasksSuccessful) {
            throw new OsmosisRuntimeException("One or more changeset workers failed.");
        }
        timestampTracker.setTime((Date)currentTime);
    }

    public void run() {
        FileBasedLock fileLock = new FileBasedLock(new File(this.workingDirectory, LOCK_FILE));
        try {
            this.changeSink.initialize(Collections.emptyMap());
            fileLock.lock();
            this.download();
            fileLock.unlock();
        }
        finally {
            this.changeSink.close();
            fileLock.close();
        }
    }
}

