/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.dataset.v0_6;

import org.openstreetmap.osmosis.core.pipeline.common.TaskConfiguration;
import org.openstreetmap.osmosis.core.pipeline.common.TaskManager;
import org.openstreetmap.osmosis.core.pipeline.common.TaskManagerFactory;
import org.openstreetmap.osmosis.core.pipeline.v0_6.DatasetSinkSourceManager;
import org.openstreetmap.osmosis.core.task.v0_6.DatasetSinkSource;
import org.openstreetmap.osmosis.dataset.v0_6.DatasetBoundingBoxFilter;

public class DatasetBoundingBoxFilterFactory
extends TaskManagerFactory {
    private static final String ARG_LEFT = "left";
    private static final String ARG_RIGHT = "right";
    private static final String ARG_TOP = "top";
    private static final String ARG_BOTTOM = "bottom";
    private static final double DEFAULT_LEFT = -180.0;
    private static final double DEFAULT_RIGHT = 180.0;
    private static final double DEFAULT_TOP = 90.0;
    private static final double DEFAULT_BOTTOM = -90.0;
    private static final String ARG_COMPLETE_WAYS = "completeWays";
    private static final boolean DEFAULT_COMPLETE_WAYS = false;

    protected TaskManager createTaskManagerImpl(TaskConfiguration taskConfig) {
        double left = this.getDoubleArgument(taskConfig, ARG_LEFT, -180.0);
        double right = this.getDoubleArgument(taskConfig, ARG_RIGHT, 180.0);
        double top = this.getDoubleArgument(taskConfig, ARG_TOP, 90.0);
        double bottom = this.getDoubleArgument(taskConfig, ARG_BOTTOM, -90.0);
        boolean completeWays = this.getBooleanArgument(taskConfig, ARG_COMPLETE_WAYS, false);
        return new DatasetSinkSourceManager(taskConfig.getId(), (DatasetSinkSource)new DatasetBoundingBoxFilter(left, right, top, bottom, completeWays), taskConfig.getPipeArgs());
    }
}

