/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.apidb.v0_6.impl;

import java.util.List;
import java.util.NoSuchElementException;
import org.openstreetmap.osmosis.apidb.v0_6.impl.EntityHistoryListReader;
import org.openstreetmap.osmosis.core.container.v0_6.ChangeContainer;
import org.openstreetmap.osmosis.core.lifecycle.ReleasableIterator;
import org.openstreetmap.osmosis.core.store.PeekableIterator;
import org.openstreetmap.osmosis.core.task.common.ChangeAction;

public class DeltaToDiffReader
implements ReleasableIterator<ChangeContainer> {
    private PeekableIterator<List<ChangeContainer>> sourceIterator;
    private ChangeContainer nextValue;
    private boolean nextValueLoaded;

    public DeltaToDiffReader(ReleasableIterator<ChangeContainer> sourceIterator) {
        this.sourceIterator = new PeekableIterator((ReleasableIterator)new EntityHistoryListReader(sourceIterator));
        this.nextValueLoaded = false;
    }

    public boolean hasNext() {
        while (!this.nextValueLoaded && this.sourceIterator.hasNext()) {
            List changeList = (List)this.sourceIterator.next();
            boolean createdPreviously = ((ChangeContainer)changeList.get(0)).getEntityContainer().getEntity().getVersion() > 1;
            ChangeContainer changeContainer = (ChangeContainer)changeList.get(changeList.size() - 1);
            if (!ChangeAction.Delete.equals((Object)changeContainer.getAction()) && createdPreviously) {
                this.nextValue = new ChangeContainer(changeContainer.getEntityContainer(), ChangeAction.Modify);
                this.nextValueLoaded = true;
                continue;
            }
            if (!ChangeAction.Delete.equals((Object)changeContainer.getAction()) && !createdPreviously) {
                this.nextValue = new ChangeContainer(changeContainer.getEntityContainer(), ChangeAction.Create);
                this.nextValueLoaded = true;
                continue;
            }
            if (!ChangeAction.Delete.equals((Object)changeContainer.getAction()) || !createdPreviously) continue;
            this.nextValue = new ChangeContainer(changeContainer.getEntityContainer(), ChangeAction.Delete);
            this.nextValueLoaded = true;
        }
        return this.nextValueLoaded;
    }

    public ChangeContainer next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.nextValueLoaded = false;
        return this.nextValue;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void close() {
        this.sourceIterator.close();
    }
}

